// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'dart:ffi' as ffi;

/// C Bindings to the TreeSitter library
class TreeSitter {
  /// Holds the symbol lookup function.
  final ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
      _lookup;

  /// The symbols are looked up in [dynamicLibrary].
  TreeSitter(ffi.DynamicLibrary dynamicLibrary)
      : _lookup = dynamicLibrary.lookup;

  /// The symbols are looked up with [lookup].
  TreeSitter.fromLookup(
      ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
          lookup)
      : _lookup = lookup;

  /// Create a new parser.
  ffi.Pointer<TSParser> ts_parser_new() {
    return _ts_parser_new();
  }

  late final _ts_parser_newPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<TSParser> Function()>>(
          'ts_parser_new');
  late final _ts_parser_new =
      _ts_parser_newPtr.asFunction<ffi.Pointer<TSParser> Function()>();

  /// Delete the parser, freeing all of the memory that it used.
  void ts_parser_delete(
    ffi.Pointer<TSParser> parser,
  ) {
    return _ts_parser_delete(
      parser,
    );
  }

  late final _ts_parser_deletePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSParser>)>>(
          'ts_parser_delete');
  late final _ts_parser_delete =
      _ts_parser_deletePtr.asFunction<void Function(ffi.Pointer<TSParser>)>();

  /// Set the language that the parser should use for parsing.
  ///
  /// Returns a boolean indicating whether or not the language was successfully
  /// assigned. True means assignment succeeded. False means there was a version
  /// mismatch: the language was generated with an incompatible version of the
  /// Tree-sitter CLI. Check the language's version using `ts_language_version`
  /// and compare it to this library's `TREE_SITTER_LANGUAGE_VERSION` and
  /// `TREE_SITTER_MIN_COMPATIBLE_LANGUAGE_VERSION` constants.
  bool ts_parser_set_language(
    ffi.Pointer<TSParser> self,
    ffi.Pointer<TSLanguage> language,
  ) {
    return _ts_parser_set_language(
      self,
      language,
    );
  }

  late final _ts_parser_set_languagePtr = _lookup<
      ffi.NativeFunction<
          ffi.Bool Function(ffi.Pointer<TSParser>,
              ffi.Pointer<TSLanguage>)>>('ts_parser_set_language');
  late final _ts_parser_set_language = _ts_parser_set_languagePtr.asFunction<
      bool Function(ffi.Pointer<TSParser>, ffi.Pointer<TSLanguage>)>();

  /// Get the parser's current language.
  ffi.Pointer<TSLanguage> ts_parser_language(
    ffi.Pointer<TSParser> self,
  ) {
    return _ts_parser_language(
      self,
    );
  }

  late final _ts_parser_languagePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<TSLanguage> Function(
              ffi.Pointer<TSParser>)>>('ts_parser_language');
  late final _ts_parser_language = _ts_parser_languagePtr
      .asFunction<ffi.Pointer<TSLanguage> Function(ffi.Pointer<TSParser>)>();

  /// Set the ranges of text that the parser should include when parsing.
  ///
  /// By default, the parser will always include entire documents. This function
  /// allows you to parse only a *portion* of a document but still return a syntax
  /// tree whose ranges match up with the document as a whole. You can also pass
  /// multiple disjoint ranges.
  ///
  /// The second and third parameters specify the location and length of an array
  /// of ranges. The parser does *not* take ownership of these ranges; it copies
  /// the data, so it doesn't matter how these ranges are allocated.
  ///
  /// If `length` is zero, then the entire document will be parsed. Otherwise,
  /// the given ranges must be ordered from earliest to latest in the document,
  /// and they must not overlap. That is, the following must hold for all
  /// `i` < `length - 1`: ranges[i].end_byte <= ranges[i + 1].start_byte
  ///
  /// If this requirement is not satisfied, the operation will fail, the ranges
  /// will not be assigned, and this function will return `false`. On success,
  /// this function returns `true`
  bool ts_parser_set_included_ranges(
    ffi.Pointer<TSParser> self,
    ffi.Pointer<TSRange> ranges,
    int length,
  ) {
    return _ts_parser_set_included_ranges(
      self,
      ranges,
      length,
    );
  }

  late final _ts_parser_set_included_rangesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Bool Function(ffi.Pointer<TSParser>, ffi.Pointer<TSRange>,
              ffi.Uint32)>>('ts_parser_set_included_ranges');
  late final _ts_parser_set_included_ranges =
      _ts_parser_set_included_rangesPtr.asFunction<
          bool Function(ffi.Pointer<TSParser>, ffi.Pointer<TSRange>, int)>();

  /// Get the ranges of text that the parser will include when parsing.
  ///
  /// The returned pointer is owned by the parser. The caller should not free it
  /// or write to it. The length of the array will be written to the given
  /// `length` pointer.
  ffi.Pointer<TSRange> ts_parser_included_ranges(
    ffi.Pointer<TSParser> self,
    ffi.Pointer<ffi.Uint32> length,
  ) {
    return _ts_parser_included_ranges(
      self,
      length,
    );
  }

  late final _ts_parser_included_rangesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<TSRange> Function(ffi.Pointer<TSParser>,
              ffi.Pointer<ffi.Uint32>)>>('ts_parser_included_ranges');
  late final _ts_parser_included_ranges =
      _ts_parser_included_rangesPtr.asFunction<
          ffi.Pointer<TSRange> Function(
              ffi.Pointer<TSParser>, ffi.Pointer<ffi.Uint32>)>();

  /// Use the parser to parse some source code and create a syntax tree.
  ///
  /// If you are parsing this document for the first time, pass `NULL` for the
  /// `old_tree` parameter. Otherwise, if you have already parsed an earlier
  /// version of this document and the document has since been edited, pass the
  /// previous syntax tree so that the unchanged parts of it can be reused.
  /// This will save time and memory. For this to work correctly, you must have
  /// already edited the old syntax tree using the `ts_tree_edit` function in a
  /// way that exactly matches the source code changes.
  ///
  /// The `TSInput` parameter lets you specify how to read the text. It has the
  /// following three fields:
  /// 1. `read`: A function to retrieve a chunk of text at a given byte offset
  /// and (row, column) position. The function should return a pointer to the
  /// text and write its length to the `bytes_read` pointer. The parser does
  /// not take ownership of this buffer; it just borrows it until it has
  /// finished reading it. The function should write a zero value to the
  /// `bytes_read` pointer to indicate the end of the document.
  /// 2. `payload`: An arbitrary pointer that will be passed to each invocation
  /// of the `read` function.
  /// 3. `encoding`: An indication of how the text is encoded. Either
  /// `TSInputEncodingUTF8` or `TSInputEncodingUTF16`.
  ///
  /// This function returns a syntax tree on success, and `NULL` on failure. There
  /// are three possible reasons for failure:
  /// 1. The parser does not have a language assigned. Check for this using the
  /// `ts_parser_language` function.
  /// 2. Parsing was cancelled due to a timeout that was set by an earlier call to
  /// the `ts_parser_set_timeout_micros` function. You can resume parsing from
  /// where the parser left out by calling `ts_parser_parse` again with the
  /// same arguments. Or you can start parsing from scratch by first calling
  /// `ts_parser_reset`.
  /// 3. Parsing was cancelled using a cancellation flag that was set by an
  /// earlier call to `ts_parser_set_cancellation_flag`. You can resume parsing
  /// from where the parser left out by calling `ts_parser_parse` again with
  /// the same arguments.
  ffi.Pointer<TSTree> ts_parser_parse(
    ffi.Pointer<TSParser> self,
    ffi.Pointer<TSTree> old_tree,
    TSInput input,
  ) {
    return _ts_parser_parse(
      self,
      old_tree,
      input,
    );
  }

  late final _ts_parser_parsePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<TSTree> Function(ffi.Pointer<TSParser>,
              ffi.Pointer<TSTree>, TSInput)>>('ts_parser_parse');
  late final _ts_parser_parse = _ts_parser_parsePtr.asFunction<
      ffi.Pointer<TSTree> Function(
          ffi.Pointer<TSParser>, ffi.Pointer<TSTree>, TSInput)>();

  /// Use the parser to parse some source code stored in one contiguous buffer.
  /// The first two parameters are the same as in the `ts_parser_parse` function
  /// above. The second two parameters indicate the location of the buffer and its
  /// length in bytes.
  ffi.Pointer<TSTree> ts_parser_parse_string(
    ffi.Pointer<TSParser> self,
    ffi.Pointer<TSTree> old_tree,
    ffi.Pointer<ffi.Char> string,
    int length,
  ) {
    return _ts_parser_parse_string(
      self,
      old_tree,
      string,
      length,
    );
  }

  late final _ts_parser_parse_stringPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<TSTree> Function(
              ffi.Pointer<TSParser>,
              ffi.Pointer<TSTree>,
              ffi.Pointer<ffi.Char>,
              ffi.Uint32)>>('ts_parser_parse_string');
  late final _ts_parser_parse_string = _ts_parser_parse_stringPtr.asFunction<
      ffi.Pointer<TSTree> Function(ffi.Pointer<TSParser>, ffi.Pointer<TSTree>,
          ffi.Pointer<ffi.Char>, int)>();

  /// Use the parser to parse some source code stored in one contiguous buffer with
  /// a given encoding. The first four parameters work the same as in the
  /// `ts_parser_parse_string` method above. The final parameter indicates whether
  /// the text is encoded as UTF8 or UTF16.
  ffi.Pointer<TSTree> ts_parser_parse_string_encoding(
    ffi.Pointer<TSParser> self,
    ffi.Pointer<TSTree> old_tree,
    ffi.Pointer<ffi.Char> string,
    int length,
    int encoding,
  ) {
    return _ts_parser_parse_string_encoding(
      self,
      old_tree,
      string,
      length,
      encoding,
    );
  }

  late final _ts_parser_parse_string_encodingPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<TSTree> Function(
              ffi.Pointer<TSParser>,
              ffi.Pointer<TSTree>,
              ffi.Pointer<ffi.Char>,
              ffi.Uint32,
              ffi.Int32)>>('ts_parser_parse_string_encoding');
  late final _ts_parser_parse_string_encoding =
      _ts_parser_parse_string_encodingPtr.asFunction<
          ffi.Pointer<TSTree> Function(ffi.Pointer<TSParser>,
              ffi.Pointer<TSTree>, ffi.Pointer<ffi.Char>, int, int)>();

  /// Instruct the parser to start the next parse from the beginning.
  ///
  /// If the parser previously failed because of a timeout or a cancellation, then
  /// by default, it will resume where it left off on the next call to
  /// `ts_parser_parse` or other parsing functions. If you don't want to resume,
  /// and instead intend to use this parser to parse some other document, you must
  /// call `ts_parser_reset` first.
  void ts_parser_reset(
    ffi.Pointer<TSParser> self,
  ) {
    return _ts_parser_reset(
      self,
    );
  }

  late final _ts_parser_resetPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSParser>)>>(
          'ts_parser_reset');
  late final _ts_parser_reset =
      _ts_parser_resetPtr.asFunction<void Function(ffi.Pointer<TSParser>)>();

  /// Set the maximum duration in microseconds that parsing should be allowed to
  /// take before halting.
  ///
  /// If parsing takes longer than this, it will halt early, returning NULL.
  /// See `ts_parser_parse` for more information.
  void ts_parser_set_timeout_micros(
    ffi.Pointer<TSParser> self,
    int timeout,
  ) {
    return _ts_parser_set_timeout_micros(
      self,
      timeout,
    );
  }

  late final _ts_parser_set_timeout_microsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<TSParser>,
              ffi.Uint64)>>('ts_parser_set_timeout_micros');
  late final _ts_parser_set_timeout_micros = _ts_parser_set_timeout_microsPtr
      .asFunction<void Function(ffi.Pointer<TSParser>, int)>();

  /// Get the duration in microseconds that parsing is allowed to take.
  int ts_parser_timeout_micros(
    ffi.Pointer<TSParser> self,
  ) {
    return _ts_parser_timeout_micros(
      self,
    );
  }

  late final _ts_parser_timeout_microsPtr =
      _lookup<ffi.NativeFunction<ffi.Uint64 Function(ffi.Pointer<TSParser>)>>(
          'ts_parser_timeout_micros');
  late final _ts_parser_timeout_micros = _ts_parser_timeout_microsPtr
      .asFunction<int Function(ffi.Pointer<TSParser>)>();

  /// Set the parser's current cancellation flag pointer.
  ///
  /// If a non-null pointer is assigned, then the parser will periodically read
  /// from this pointer during parsing. If it reads a non-zero value, it will
  /// halt early, returning NULL. See `ts_parser_parse` for more information.
  void ts_parser_set_cancellation_flag(
    ffi.Pointer<TSParser> self,
    ffi.Pointer<ffi.Size> flag,
  ) {
    return _ts_parser_set_cancellation_flag(
      self,
      flag,
    );
  }

  late final _ts_parser_set_cancellation_flagPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<TSParser>,
              ffi.Pointer<ffi.Size>)>>('ts_parser_set_cancellation_flag');
  late final _ts_parser_set_cancellation_flag =
      _ts_parser_set_cancellation_flagPtr.asFunction<
          void Function(ffi.Pointer<TSParser>, ffi.Pointer<ffi.Size>)>();

  /// Get the parser's current cancellation flag pointer.
  ffi.Pointer<ffi.Size> ts_parser_cancellation_flag(
    ffi.Pointer<TSParser> self,
  ) {
    return _ts_parser_cancellation_flag(
      self,
    );
  }

  late final _ts_parser_cancellation_flagPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Size> Function(
              ffi.Pointer<TSParser>)>>('ts_parser_cancellation_flag');
  late final _ts_parser_cancellation_flag = _ts_parser_cancellation_flagPtr
      .asFunction<ffi.Pointer<ffi.Size> Function(ffi.Pointer<TSParser>)>();

  /// Set the logger that a parser should use during parsing.
  ///
  /// The parser does not take ownership over the logger payload. If a logger was
  /// previously assigned, the caller is responsible for releasing any memory
  /// owned by the previous logger.
  void ts_parser_set_logger(
    ffi.Pointer<TSParser> self,
    TSLogger logger,
  ) {
    return _ts_parser_set_logger(
      self,
      logger,
    );
  }

  late final _ts_parser_set_loggerPtr = _lookup<
          ffi
          .NativeFunction<ffi.Void Function(ffi.Pointer<TSParser>, TSLogger)>>(
      'ts_parser_set_logger');
  late final _ts_parser_set_logger = _ts_parser_set_loggerPtr
      .asFunction<void Function(ffi.Pointer<TSParser>, TSLogger)>();

  /// Get the parser's current logger.
  TSLogger ts_parser_logger(
    ffi.Pointer<TSParser> self,
  ) {
    return _ts_parser_logger(
      self,
    );
  }

  late final _ts_parser_loggerPtr =
      _lookup<ffi.NativeFunction<TSLogger Function(ffi.Pointer<TSParser>)>>(
          'ts_parser_logger');
  late final _ts_parser_logger = _ts_parser_loggerPtr
      .asFunction<TSLogger Function(ffi.Pointer<TSParser>)>();

  /// Set the file descriptor to which the parser should write debugging graphs
  /// during parsing. The graphs are formatted in the DOT language. You may want
  /// to pipe these graphs directly to a `dot(1)` process in order to generate
  /// SVG output. You can turn off this logging by passing a negative number.
  void ts_parser_print_dot_graphs(
    ffi.Pointer<TSParser> self,
    int file,
  ) {
    return _ts_parser_print_dot_graphs(
      self,
      file,
    );
  }

  late final _ts_parser_print_dot_graphsPtr = _lookup<
          ffi
          .NativeFunction<ffi.Void Function(ffi.Pointer<TSParser>, ffi.Int)>>(
      'ts_parser_print_dot_graphs');
  late final _ts_parser_print_dot_graphs = _ts_parser_print_dot_graphsPtr
      .asFunction<void Function(ffi.Pointer<TSParser>, int)>();

  /// Create a shallow copy of the syntax tree. This is very fast.
  ///
  /// You need to copy a syntax tree in order to use it on more than one thread at
  /// a time, as syntax trees are not thread safe.
  ffi.Pointer<TSTree> ts_tree_copy(
    ffi.Pointer<TSTree> self,
  ) {
    return _ts_tree_copy(
      self,
    );
  }

  late final _ts_tree_copyPtr = _lookup<
          ffi
          .NativeFunction<ffi.Pointer<TSTree> Function(ffi.Pointer<TSTree>)>>(
      'ts_tree_copy');
  late final _ts_tree_copy = _ts_tree_copyPtr
      .asFunction<ffi.Pointer<TSTree> Function(ffi.Pointer<TSTree>)>();

  /// Delete the syntax tree, freeing all of the memory that it used.
  void ts_tree_delete(
    ffi.Pointer<TSTree> self,
  ) {
    return _ts_tree_delete(
      self,
    );
  }

  late final _ts_tree_deletePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSTree>)>>(
          'ts_tree_delete');
  late final _ts_tree_delete =
      _ts_tree_deletePtr.asFunction<void Function(ffi.Pointer<TSTree>)>();

  /// Get the root node of the syntax tree.
  TSNode ts_tree_root_node(
    ffi.Pointer<TSTree> self,
  ) {
    return _ts_tree_root_node(
      self,
    );
  }

  late final _ts_tree_root_nodePtr =
      _lookup<ffi.NativeFunction<TSNode Function(ffi.Pointer<TSTree>)>>(
          'ts_tree_root_node');
  late final _ts_tree_root_node =
      _ts_tree_root_nodePtr.asFunction<TSNode Function(ffi.Pointer<TSTree>)>();

  /// Get the root node of the syntax tree, but with its position
  /// shifted forward by the given offset.
  TSNode ts_tree_root_node_with_offset(
    ffi.Pointer<TSTree> self,
    int offset_bytes,
    TSPoint offset_point,
  ) {
    return _ts_tree_root_node_with_offset(
      self,
      offset_bytes,
      offset_point,
    );
  }

  late final _ts_tree_root_node_with_offsetPtr = _lookup<
      ffi.NativeFunction<
          TSNode Function(ffi.Pointer<TSTree>, ffi.Uint32,
              TSPoint)>>('ts_tree_root_node_with_offset');
  late final _ts_tree_root_node_with_offset = _ts_tree_root_node_with_offsetPtr
      .asFunction<TSNode Function(ffi.Pointer<TSTree>, int, TSPoint)>();

  /// Get the language that was used to parse the syntax tree.
  ffi.Pointer<TSLanguage> ts_tree_language(
    ffi.Pointer<TSTree> arg0,
  ) {
    return _ts_tree_language(
      arg0,
    );
  }

  late final _ts_tree_languagePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<TSLanguage> Function(
              ffi.Pointer<TSTree>)>>('ts_tree_language');
  late final _ts_tree_language = _ts_tree_languagePtr
      .asFunction<ffi.Pointer<TSLanguage> Function(ffi.Pointer<TSTree>)>();

  /// Get the array of included ranges that was used to parse the syntax tree.
  ///
  /// The returned pointer must be freed by the caller.
  ffi.Pointer<TSRange> ts_tree_included_ranges(
    ffi.Pointer<TSTree> arg0,
    ffi.Pointer<ffi.Uint32> length,
  ) {
    return _ts_tree_included_ranges(
      arg0,
      length,
    );
  }

  late final _ts_tree_included_rangesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<TSRange> Function(ffi.Pointer<TSTree>,
              ffi.Pointer<ffi.Uint32>)>>('ts_tree_included_ranges');
  late final _ts_tree_included_ranges = _ts_tree_included_rangesPtr.asFunction<
      ffi.Pointer<TSRange> Function(
          ffi.Pointer<TSTree>, ffi.Pointer<ffi.Uint32>)>();

  /// Edit the syntax tree to keep it in sync with source code that has been
  /// edited.
  ///
  /// You must describe the edit both in terms of byte offsets and in terms of
  /// (row, column) coordinates.
  void ts_tree_edit(
    ffi.Pointer<TSTree> self,
    ffi.Pointer<TSInputEdit> edit,
  ) {
    return _ts_tree_edit(
      self,
      edit,
    );
  }

  late final _ts_tree_editPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<TSTree>, ffi.Pointer<TSInputEdit>)>>('ts_tree_edit');
  late final _ts_tree_edit = _ts_tree_editPtr.asFunction<
      void Function(ffi.Pointer<TSTree>, ffi.Pointer<TSInputEdit>)>();

  /// Compare an old edited syntax tree to a new syntax tree representing the same
  /// document, returning an array of ranges whose syntactic structure has changed.
  ///
  /// For this to work correctly, the old syntax tree must have been edited such
  /// that its ranges match up to the new tree. Generally, you'll want to call
  /// this function right after calling one of the `ts_parser_parse` functions.
  /// You need to pass the old tree that was passed to parse, as well as the new
  /// tree that was returned from that function.
  ///
  /// The returned array is allocated using `malloc` and the caller is responsible
  /// for freeing it using `free`. The length of the array will be written to the
  /// given `length` pointer.
  ffi.Pointer<TSRange> ts_tree_get_changed_ranges(
    ffi.Pointer<TSTree> old_tree,
    ffi.Pointer<TSTree> new_tree,
    ffi.Pointer<ffi.Uint32> length,
  ) {
    return _ts_tree_get_changed_ranges(
      old_tree,
      new_tree,
      length,
    );
  }

  late final _ts_tree_get_changed_rangesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<TSRange> Function(
              ffi.Pointer<TSTree>,
              ffi.Pointer<TSTree>,
              ffi.Pointer<ffi.Uint32>)>>('ts_tree_get_changed_ranges');
  late final _ts_tree_get_changed_ranges =
      _ts_tree_get_changed_rangesPtr.asFunction<
          ffi.Pointer<TSRange> Function(ffi.Pointer<TSTree>,
              ffi.Pointer<TSTree>, ffi.Pointer<ffi.Uint32>)>();

  /// Write a DOT graph describing the syntax tree to the given file.
  void ts_tree_print_dot_graph(
    ffi.Pointer<TSTree> arg0,
    int file_descriptor,
  ) {
    return _ts_tree_print_dot_graph(
      arg0,
      file_descriptor,
    );
  }

  late final _ts_tree_print_dot_graphPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSTree>, ffi.Int)>>(
      'ts_tree_print_dot_graph');
  late final _ts_tree_print_dot_graph = _ts_tree_print_dot_graphPtr
      .asFunction<void Function(ffi.Pointer<TSTree>, int)>();

  /// Get the node's type as a null-terminated string.
  ffi.Pointer<ffi.Char> ts_node_type(
    TSNode arg0,
  ) {
    return _ts_node_type(
      arg0,
    );
  }

  late final _ts_node_typePtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(TSNode)>>(
          'ts_node_type');
  late final _ts_node_type =
      _ts_node_typePtr.asFunction<ffi.Pointer<ffi.Char> Function(TSNode)>();

  /// Get the node's type as a numerical id.
  int ts_node_symbol(
    TSNode arg0,
  ) {
    return _ts_node_symbol(
      arg0,
    );
  }

  late final _ts_node_symbolPtr =
      _lookup<ffi.NativeFunction<TSSymbol Function(TSNode)>>('ts_node_symbol');
  late final _ts_node_symbol =
      _ts_node_symbolPtr.asFunction<int Function(TSNode)>();

  /// Get the node's start byte.
  int ts_node_start_byte(
    TSNode arg0,
  ) {
    return _ts_node_start_byte(
      arg0,
    );
  }

  late final _ts_node_start_bytePtr =
      _lookup<ffi.NativeFunction<ffi.Uint32 Function(TSNode)>>(
          'ts_node_start_byte');
  late final _ts_node_start_byte =
      _ts_node_start_bytePtr.asFunction<int Function(TSNode)>();

  /// Get the node's start position in terms of rows and columns.
  TSPoint ts_node_start_point(
    TSNode arg0,
  ) {
    return _ts_node_start_point(
      arg0,
    );
  }

  late final _ts_node_start_pointPtr =
      _lookup<ffi.NativeFunction<TSPoint Function(TSNode)>>(
          'ts_node_start_point');
  late final _ts_node_start_point =
      _ts_node_start_pointPtr.asFunction<TSPoint Function(TSNode)>();

  /// Get the node's end byte.
  int ts_node_end_byte(
    TSNode arg0,
  ) {
    return _ts_node_end_byte(
      arg0,
    );
  }

  late final _ts_node_end_bytePtr =
      _lookup<ffi.NativeFunction<ffi.Uint32 Function(TSNode)>>(
          'ts_node_end_byte');
  late final _ts_node_end_byte =
      _ts_node_end_bytePtr.asFunction<int Function(TSNode)>();

  /// Get the node's end position in terms of rows and columns.
  TSPoint ts_node_end_point(
    TSNode arg0,
  ) {
    return _ts_node_end_point(
      arg0,
    );
  }

  late final _ts_node_end_pointPtr =
      _lookup<ffi.NativeFunction<TSPoint Function(TSNode)>>(
          'ts_node_end_point');
  late final _ts_node_end_point =
      _ts_node_end_pointPtr.asFunction<TSPoint Function(TSNode)>();

  /// Get an S-expression representing the node as a string.
  ///
  /// This string is allocated with `malloc` and the caller is responsible for
  /// freeing it using `free`.
  ffi.Pointer<ffi.Char> ts_node_string(
    TSNode arg0,
  ) {
    return _ts_node_string(
      arg0,
    );
  }

  late final _ts_node_stringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(TSNode)>>(
          'ts_node_string');
  late final _ts_node_string =
      _ts_node_stringPtr.asFunction<ffi.Pointer<ffi.Char> Function(TSNode)>();

  /// Check if the node is null. Functions like `ts_node_child` and
  /// `ts_node_next_sibling` will return a null node to indicate that no such node
  /// was found.
  bool ts_node_is_null(
    TSNode arg0,
  ) {
    return _ts_node_is_null(
      arg0,
    );
  }

  late final _ts_node_is_nullPtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function(TSNode)>>('ts_node_is_null');
  late final _ts_node_is_null =
      _ts_node_is_nullPtr.asFunction<bool Function(TSNode)>();

  /// Check if the node is *named*. Named nodes correspond to named rules in the
  /// grammar, whereas *anonymous* nodes correspond to string literals in the
  /// grammar.
  bool ts_node_is_named(
    TSNode arg0,
  ) {
    return _ts_node_is_named(
      arg0,
    );
  }

  late final _ts_node_is_namedPtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function(TSNode)>>(
          'ts_node_is_named');
  late final _ts_node_is_named =
      _ts_node_is_namedPtr.asFunction<bool Function(TSNode)>();

  /// Check if the node is *missing*. Missing nodes are inserted by the parser in
  /// order to recover from certain kinds of syntax errors.
  bool ts_node_is_missing(
    TSNode arg0,
  ) {
    return _ts_node_is_missing(
      arg0,
    );
  }

  late final _ts_node_is_missingPtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function(TSNode)>>(
          'ts_node_is_missing');
  late final _ts_node_is_missing =
      _ts_node_is_missingPtr.asFunction<bool Function(TSNode)>();

  /// Check if the node is *extra*. Extra nodes represent things like comments,
  /// which are not required the grammar, but can appear anywhere.
  bool ts_node_is_extra(
    TSNode arg0,
  ) {
    return _ts_node_is_extra(
      arg0,
    );
  }

  late final _ts_node_is_extraPtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function(TSNode)>>(
          'ts_node_is_extra');
  late final _ts_node_is_extra =
      _ts_node_is_extraPtr.asFunction<bool Function(TSNode)>();

  /// Check if a syntax node has been edited.
  bool ts_node_has_changes(
    TSNode arg0,
  ) {
    return _ts_node_has_changes(
      arg0,
    );
  }

  late final _ts_node_has_changesPtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function(TSNode)>>(
          'ts_node_has_changes');
  late final _ts_node_has_changes =
      _ts_node_has_changesPtr.asFunction<bool Function(TSNode)>();

  /// Check if the node is a syntax error or contains any syntax errors.
  bool ts_node_has_error(
    TSNode arg0,
  ) {
    return _ts_node_has_error(
      arg0,
    );
  }

  late final _ts_node_has_errorPtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function(TSNode)>>(
          'ts_node_has_error');
  late final _ts_node_has_error =
      _ts_node_has_errorPtr.asFunction<bool Function(TSNode)>();

  /// Get the node's immediate parent.
  TSNode ts_node_parent(
    TSNode arg0,
  ) {
    return _ts_node_parent(
      arg0,
    );
  }

  late final _ts_node_parentPtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode)>>('ts_node_parent');
  late final _ts_node_parent =
      _ts_node_parentPtr.asFunction<TSNode Function(TSNode)>();

  /// Get the node's child at the given index, where zero represents the first
  /// child.
  TSNode ts_node_child(
    TSNode arg0,
    int arg1,
  ) {
    return _ts_node_child(
      arg0,
      arg1,
    );
  }

  late final _ts_node_childPtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode, ffi.Uint32)>>(
          'ts_node_child');
  late final _ts_node_child =
      _ts_node_childPtr.asFunction<TSNode Function(TSNode, int)>();

  /// Get the field name for node's child at the given index, where zero represents
  /// the first child. Returns NULL, if no field is found.
  ffi.Pointer<ffi.Char> ts_node_field_name_for_child(
    TSNode arg0,
    int arg1,
  ) {
    return _ts_node_field_name_for_child(
      arg0,
      arg1,
    );
  }

  late final _ts_node_field_name_for_childPtr = _lookup<
          ffi
          .NativeFunction<ffi.Pointer<ffi.Char> Function(TSNode, ffi.Uint32)>>(
      'ts_node_field_name_for_child');
  late final _ts_node_field_name_for_child = _ts_node_field_name_for_childPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(TSNode, int)>();

  /// Get the node's number of children.
  int ts_node_child_count(
    TSNode arg0,
  ) {
    return _ts_node_child_count(
      arg0,
    );
  }

  late final _ts_node_child_countPtr =
      _lookup<ffi.NativeFunction<ffi.Uint32 Function(TSNode)>>(
          'ts_node_child_count');
  late final _ts_node_child_count =
      _ts_node_child_countPtr.asFunction<int Function(TSNode)>();

  /// Get the node's *named* child at the given index.
  ///
  /// See also `ts_node_is_named`.
  TSNode ts_node_named_child(
    TSNode arg0,
    int arg1,
  ) {
    return _ts_node_named_child(
      arg0,
      arg1,
    );
  }

  late final _ts_node_named_childPtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode, ffi.Uint32)>>(
          'ts_node_named_child');
  late final _ts_node_named_child =
      _ts_node_named_childPtr.asFunction<TSNode Function(TSNode, int)>();

  /// Get the node's number of *named* children.
  ///
  /// See also `ts_node_is_named`.
  int ts_node_named_child_count(
    TSNode arg0,
  ) {
    return _ts_node_named_child_count(
      arg0,
    );
  }

  late final _ts_node_named_child_countPtr =
      _lookup<ffi.NativeFunction<ffi.Uint32 Function(TSNode)>>(
          'ts_node_named_child_count');
  late final _ts_node_named_child_count =
      _ts_node_named_child_countPtr.asFunction<int Function(TSNode)>();

  /// Get the node's child with the given field name.
  TSNode ts_node_child_by_field_name(
    TSNode self,
    ffi.Pointer<ffi.Char> field_name,
    int field_name_length,
  ) {
    return _ts_node_child_by_field_name(
      self,
      field_name,
      field_name_length,
    );
  }

  late final _ts_node_child_by_field_namePtr = _lookup<
      ffi.NativeFunction<
          TSNode Function(TSNode, ffi.Pointer<ffi.Char>,
              ffi.Uint32)>>('ts_node_child_by_field_name');
  late final _ts_node_child_by_field_name = _ts_node_child_by_field_namePtr
      .asFunction<TSNode Function(TSNode, ffi.Pointer<ffi.Char>, int)>();

  /// Get the node's child with the given numerical field id.
  ///
  /// You can convert a field name to an id using the
  /// `ts_language_field_id_for_name` function.
  TSNode ts_node_child_by_field_id(
    TSNode arg0,
    int arg1,
  ) {
    return _ts_node_child_by_field_id(
      arg0,
      arg1,
    );
  }

  late final _ts_node_child_by_field_idPtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode, TSFieldId)>>(
          'ts_node_child_by_field_id');
  late final _ts_node_child_by_field_id =
      _ts_node_child_by_field_idPtr.asFunction<TSNode Function(TSNode, int)>();

  /// Get the node's next / previous sibling.
  TSNode ts_node_next_sibling(
    TSNode arg0,
  ) {
    return _ts_node_next_sibling(
      arg0,
    );
  }

  late final _ts_node_next_siblingPtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode)>>(
          'ts_node_next_sibling');
  late final _ts_node_next_sibling =
      _ts_node_next_siblingPtr.asFunction<TSNode Function(TSNode)>();

  TSNode ts_node_prev_sibling(
    TSNode arg0,
  ) {
    return _ts_node_prev_sibling(
      arg0,
    );
  }

  late final _ts_node_prev_siblingPtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode)>>(
          'ts_node_prev_sibling');
  late final _ts_node_prev_sibling =
      _ts_node_prev_siblingPtr.asFunction<TSNode Function(TSNode)>();

  /// Get the node's next / previous *named* sibling.
  TSNode ts_node_next_named_sibling(
    TSNode arg0,
  ) {
    return _ts_node_next_named_sibling(
      arg0,
    );
  }

  late final _ts_node_next_named_siblingPtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode)>>(
          'ts_node_next_named_sibling');
  late final _ts_node_next_named_sibling =
      _ts_node_next_named_siblingPtr.asFunction<TSNode Function(TSNode)>();

  TSNode ts_node_prev_named_sibling(
    TSNode arg0,
  ) {
    return _ts_node_prev_named_sibling(
      arg0,
    );
  }

  late final _ts_node_prev_named_siblingPtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode)>>(
          'ts_node_prev_named_sibling');
  late final _ts_node_prev_named_sibling =
      _ts_node_prev_named_siblingPtr.asFunction<TSNode Function(TSNode)>();

  /// Get the node's first child that extends beyond the given byte offset.
  TSNode ts_node_first_child_for_byte(
    TSNode arg0,
    int arg1,
  ) {
    return _ts_node_first_child_for_byte(
      arg0,
      arg1,
    );
  }

  late final _ts_node_first_child_for_bytePtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode, ffi.Uint32)>>(
          'ts_node_first_child_for_byte');
  late final _ts_node_first_child_for_byte = _ts_node_first_child_for_bytePtr
      .asFunction<TSNode Function(TSNode, int)>();

  /// Get the node's first named child that extends beyond the given byte offset.
  TSNode ts_node_first_named_child_for_byte(
    TSNode arg0,
    int arg1,
  ) {
    return _ts_node_first_named_child_for_byte(
      arg0,
      arg1,
    );
  }

  late final _ts_node_first_named_child_for_bytePtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode, ffi.Uint32)>>(
          'ts_node_first_named_child_for_byte');
  late final _ts_node_first_named_child_for_byte =
      _ts_node_first_named_child_for_bytePtr
          .asFunction<TSNode Function(TSNode, int)>();

  /// Get the smallest node within this node that spans the given range of bytes
  /// or (row, column) positions.
  TSNode ts_node_descendant_for_byte_range(
    TSNode arg0,
    int arg1,
    int arg2,
  ) {
    return _ts_node_descendant_for_byte_range(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _ts_node_descendant_for_byte_rangePtr = _lookup<
          ffi.NativeFunction<TSNode Function(TSNode, ffi.Uint32, ffi.Uint32)>>(
      'ts_node_descendant_for_byte_range');
  late final _ts_node_descendant_for_byte_range =
      _ts_node_descendant_for_byte_rangePtr
          .asFunction<TSNode Function(TSNode, int, int)>();

  TSNode ts_node_descendant_for_point_range(
    TSNode arg0,
    TSPoint arg1,
    TSPoint arg2,
  ) {
    return _ts_node_descendant_for_point_range(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _ts_node_descendant_for_point_rangePtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode, TSPoint, TSPoint)>>(
          'ts_node_descendant_for_point_range');
  late final _ts_node_descendant_for_point_range =
      _ts_node_descendant_for_point_rangePtr
          .asFunction<TSNode Function(TSNode, TSPoint, TSPoint)>();

  /// Get the smallest named node within this node that spans the given range of
  /// bytes or (row, column) positions.
  TSNode ts_node_named_descendant_for_byte_range(
    TSNode arg0,
    int arg1,
    int arg2,
  ) {
    return _ts_node_named_descendant_for_byte_range(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _ts_node_named_descendant_for_byte_rangePtr = _lookup<
          ffi.NativeFunction<TSNode Function(TSNode, ffi.Uint32, ffi.Uint32)>>(
      'ts_node_named_descendant_for_byte_range');
  late final _ts_node_named_descendant_for_byte_range =
      _ts_node_named_descendant_for_byte_rangePtr
          .asFunction<TSNode Function(TSNode, int, int)>();

  TSNode ts_node_named_descendant_for_point_range(
    TSNode arg0,
    TSPoint arg1,
    TSPoint arg2,
  ) {
    return _ts_node_named_descendant_for_point_range(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _ts_node_named_descendant_for_point_rangePtr =
      _lookup<ffi.NativeFunction<TSNode Function(TSNode, TSPoint, TSPoint)>>(
          'ts_node_named_descendant_for_point_range');
  late final _ts_node_named_descendant_for_point_range =
      _ts_node_named_descendant_for_point_rangePtr
          .asFunction<TSNode Function(TSNode, TSPoint, TSPoint)>();

  /// Edit the node to keep it in-sync with source code that has been edited.
  ///
  /// This function is only rarely needed. When you edit a syntax tree with the
  /// `ts_tree_edit` function, all of the nodes that you retrieve from the tree
  /// afterward will already reflect the edit. You only need to use `ts_node_edit`
  /// when you have a `TSNode` instance that you want to keep and continue to use
  /// after an edit.
  void ts_node_edit(
    ffi.Pointer<TSNode> arg0,
    ffi.Pointer<TSInputEdit> arg1,
  ) {
    return _ts_node_edit(
      arg0,
      arg1,
    );
  }

  late final _ts_node_editPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<TSNode>, ffi.Pointer<TSInputEdit>)>>('ts_node_edit');
  late final _ts_node_edit = _ts_node_editPtr.asFunction<
      void Function(ffi.Pointer<TSNode>, ffi.Pointer<TSInputEdit>)>();

  /// Check if two nodes are identical.
  bool ts_node_eq(
    TSNode arg0,
    TSNode arg1,
  ) {
    return _ts_node_eq(
      arg0,
      arg1,
    );
  }

  late final _ts_node_eqPtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function(TSNode, TSNode)>>(
          'ts_node_eq');
  late final _ts_node_eq =
      _ts_node_eqPtr.asFunction<bool Function(TSNode, TSNode)>();

  /// Create a new tree cursor starting from the given node.
  ///
  /// A tree cursor allows you to walk a syntax tree more efficiently than is
  /// possible using the `TSNode` functions. It is a mutable object that is always
  /// on a certain syntax node, and can be moved imperatively to different nodes.
  TSTreeCursor ts_tree_cursor_new(
    TSNode arg0,
  ) {
    return _ts_tree_cursor_new(
      arg0,
    );
  }

  late final _ts_tree_cursor_newPtr =
      _lookup<ffi.NativeFunction<TSTreeCursor Function(TSNode)>>(
          'ts_tree_cursor_new');
  late final _ts_tree_cursor_new =
      _ts_tree_cursor_newPtr.asFunction<TSTreeCursor Function(TSNode)>();

  /// Delete a tree cursor, freeing all of the memory that it used.
  void ts_tree_cursor_delete(
    ffi.Pointer<TSTreeCursor> arg0,
  ) {
    return _ts_tree_cursor_delete(
      arg0,
    );
  }

  late final _ts_tree_cursor_deletePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSTreeCursor>)>>(
          'ts_tree_cursor_delete');
  late final _ts_tree_cursor_delete = _ts_tree_cursor_deletePtr
      .asFunction<void Function(ffi.Pointer<TSTreeCursor>)>();

  /// Re-initialize a tree cursor to start at a different node.
  void ts_tree_cursor_reset(
    ffi.Pointer<TSTreeCursor> arg0,
    TSNode arg1,
  ) {
    return _ts_tree_cursor_reset(
      arg0,
      arg1,
    );
  }

  late final _ts_tree_cursor_resetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<TSTreeCursor>, TSNode)>>('ts_tree_cursor_reset');
  late final _ts_tree_cursor_reset = _ts_tree_cursor_resetPtr
      .asFunction<void Function(ffi.Pointer<TSTreeCursor>, TSNode)>();

  /// Get the tree cursor's current node.
  TSNode ts_tree_cursor_current_node(
    ffi.Pointer<TSTreeCursor> arg0,
  ) {
    return _ts_tree_cursor_current_node(
      arg0,
    );
  }

  late final _ts_tree_cursor_current_nodePtr =
      _lookup<ffi.NativeFunction<TSNode Function(ffi.Pointer<TSTreeCursor>)>>(
          'ts_tree_cursor_current_node');
  late final _ts_tree_cursor_current_node = _ts_tree_cursor_current_nodePtr
      .asFunction<TSNode Function(ffi.Pointer<TSTreeCursor>)>();

  /// Get the field name of the tree cursor's current node.
  ///
  /// This returns `NULL` if the current node doesn't have a field.
  /// See also `ts_node_child_by_field_name`.
  ffi.Pointer<ffi.Char> ts_tree_cursor_current_field_name(
    ffi.Pointer<TSTreeCursor> arg0,
  ) {
    return _ts_tree_cursor_current_field_name(
      arg0,
    );
  }

  late final _ts_tree_cursor_current_field_namePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<TSTreeCursor>)>>('ts_tree_cursor_current_field_name');
  late final _ts_tree_cursor_current_field_name =
      _ts_tree_cursor_current_field_namePtr.asFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<TSTreeCursor>)>();

  /// Get the field id of the tree cursor's current node.
  ///
  /// This returns zero if the current node doesn't have a field.
  /// See also `ts_node_child_by_field_id`, `ts_language_field_id_for_name`.
  int ts_tree_cursor_current_field_id(
    ffi.Pointer<TSTreeCursor> arg0,
  ) {
    return _ts_tree_cursor_current_field_id(
      arg0,
    );
  }

  late final _ts_tree_cursor_current_field_idPtr = _lookup<
          ffi.NativeFunction<TSFieldId Function(ffi.Pointer<TSTreeCursor>)>>(
      'ts_tree_cursor_current_field_id');
  late final _ts_tree_cursor_current_field_id =
      _ts_tree_cursor_current_field_idPtr
          .asFunction<int Function(ffi.Pointer<TSTreeCursor>)>();

  /// Move the cursor to the parent of its current node.
  ///
  /// This returns `true` if the cursor successfully moved, and returns `false`
  /// if there was no parent node (the cursor was already on the root node).
  bool ts_tree_cursor_goto_parent(
    ffi.Pointer<TSTreeCursor> arg0,
  ) {
    return _ts_tree_cursor_goto_parent(
      arg0,
    );
  }

  late final _ts_tree_cursor_goto_parentPtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function(ffi.Pointer<TSTreeCursor>)>>(
          'ts_tree_cursor_goto_parent');
  late final _ts_tree_cursor_goto_parent = _ts_tree_cursor_goto_parentPtr
      .asFunction<bool Function(ffi.Pointer<TSTreeCursor>)>();

  /// Move the cursor to the next sibling of its current node.
  ///
  /// This returns `true` if the cursor successfully moved, and returns `false`
  /// if there was no next sibling node.
  bool ts_tree_cursor_goto_next_sibling(
    ffi.Pointer<TSTreeCursor> arg0,
  ) {
    return _ts_tree_cursor_goto_next_sibling(
      arg0,
    );
  }

  late final _ts_tree_cursor_goto_next_siblingPtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function(ffi.Pointer<TSTreeCursor>)>>(
          'ts_tree_cursor_goto_next_sibling');
  late final _ts_tree_cursor_goto_next_sibling =
      _ts_tree_cursor_goto_next_siblingPtr
          .asFunction<bool Function(ffi.Pointer<TSTreeCursor>)>();

  /// Move the cursor to the first child of its current node.
  ///
  /// This returns `true` if the cursor successfully moved, and returns `false`
  /// if there were no children.
  bool ts_tree_cursor_goto_first_child(
    ffi.Pointer<TSTreeCursor> arg0,
  ) {
    return _ts_tree_cursor_goto_first_child(
      arg0,
    );
  }

  late final _ts_tree_cursor_goto_first_childPtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function(ffi.Pointer<TSTreeCursor>)>>(
          'ts_tree_cursor_goto_first_child');
  late final _ts_tree_cursor_goto_first_child =
      _ts_tree_cursor_goto_first_childPtr
          .asFunction<bool Function(ffi.Pointer<TSTreeCursor>)>();

  /// Move the cursor to the first child of its current node that extends beyond
  /// the given byte offset or point.
  ///
  /// This returns the index of the child node if one was found, and returns -1
  /// if no such child was found.
  int ts_tree_cursor_goto_first_child_for_byte(
    ffi.Pointer<TSTreeCursor> arg0,
    int arg1,
  ) {
    return _ts_tree_cursor_goto_first_child_for_byte(
      arg0,
      arg1,
    );
  }

  late final _ts_tree_cursor_goto_first_child_for_bytePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int64 Function(ffi.Pointer<TSTreeCursor>,
              ffi.Uint32)>>('ts_tree_cursor_goto_first_child_for_byte');
  late final _ts_tree_cursor_goto_first_child_for_byte =
      _ts_tree_cursor_goto_first_child_for_bytePtr
          .asFunction<int Function(ffi.Pointer<TSTreeCursor>, int)>();

  int ts_tree_cursor_goto_first_child_for_point(
    ffi.Pointer<TSTreeCursor> arg0,
    TSPoint arg1,
  ) {
    return _ts_tree_cursor_goto_first_child_for_point(
      arg0,
      arg1,
    );
  }

  late final _ts_tree_cursor_goto_first_child_for_pointPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int64 Function(ffi.Pointer<TSTreeCursor>,
              TSPoint)>>('ts_tree_cursor_goto_first_child_for_point');
  late final _ts_tree_cursor_goto_first_child_for_point =
      _ts_tree_cursor_goto_first_child_for_pointPtr
          .asFunction<int Function(ffi.Pointer<TSTreeCursor>, TSPoint)>();

  TSTreeCursor ts_tree_cursor_copy(
    ffi.Pointer<TSTreeCursor> arg0,
  ) {
    return _ts_tree_cursor_copy(
      arg0,
    );
  }

  late final _ts_tree_cursor_copyPtr = _lookup<
          ffi.NativeFunction<TSTreeCursor Function(ffi.Pointer<TSTreeCursor>)>>(
      'ts_tree_cursor_copy');
  late final _ts_tree_cursor_copy = _ts_tree_cursor_copyPtr
      .asFunction<TSTreeCursor Function(ffi.Pointer<TSTreeCursor>)>();

  /// Create a new query from a string containing one or more S-expression
  /// patterns. The query is associated with a particular language, and can
  /// only be run on syntax nodes parsed with that language.
  ///
  /// If all of the given patterns are valid, this returns a `TSQuery`.
  /// If a pattern is invalid, this returns `NULL`, and provides two pieces
  /// of information about the problem:
  /// 1. The byte offset of the error is written to the `error_offset` parameter.
  /// 2. The type of error is written to the `error_type` parameter.
  ffi.Pointer<TSQuery> ts_query_new(
    ffi.Pointer<TSLanguage> language,
    ffi.Pointer<ffi.Char> source,
    int source_len,
    ffi.Pointer<ffi.Uint32> error_offset,
    ffi.Pointer<ffi.Int32> error_type,
  ) {
    return _ts_query_new(
      language,
      source,
      source_len,
      error_offset,
      error_type,
    );
  }

  late final _ts_query_newPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<TSQuery> Function(
              ffi.Pointer<TSLanguage>,
              ffi.Pointer<ffi.Char>,
              ffi.Uint32,
              ffi.Pointer<ffi.Uint32>,
              ffi.Pointer<ffi.Int32>)>>('ts_query_new');
  late final _ts_query_new = _ts_query_newPtr.asFunction<
      ffi.Pointer<TSQuery> Function(
          ffi.Pointer<TSLanguage>,
          ffi.Pointer<ffi.Char>,
          int,
          ffi.Pointer<ffi.Uint32>,
          ffi.Pointer<ffi.Int32>)>();

  /// Delete a query, freeing all of the memory that it used.
  void ts_query_delete(
    ffi.Pointer<TSQuery> arg0,
  ) {
    return _ts_query_delete(
      arg0,
    );
  }

  late final _ts_query_deletePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSQuery>)>>(
          'ts_query_delete');
  late final _ts_query_delete =
      _ts_query_deletePtr.asFunction<void Function(ffi.Pointer<TSQuery>)>();

  /// Get the number of patterns, captures, or string literals in the query.
  int ts_query_pattern_count(
    ffi.Pointer<TSQuery> arg0,
  ) {
    return _ts_query_pattern_count(
      arg0,
    );
  }

  late final _ts_query_pattern_countPtr =
      _lookup<ffi.NativeFunction<ffi.Uint32 Function(ffi.Pointer<TSQuery>)>>(
          'ts_query_pattern_count');
  late final _ts_query_pattern_count = _ts_query_pattern_countPtr
      .asFunction<int Function(ffi.Pointer<TSQuery>)>();

  int ts_query_capture_count(
    ffi.Pointer<TSQuery> arg0,
  ) {
    return _ts_query_capture_count(
      arg0,
    );
  }

  late final _ts_query_capture_countPtr =
      _lookup<ffi.NativeFunction<ffi.Uint32 Function(ffi.Pointer<TSQuery>)>>(
          'ts_query_capture_count');
  late final _ts_query_capture_count = _ts_query_capture_countPtr
      .asFunction<int Function(ffi.Pointer<TSQuery>)>();

  int ts_query_string_count(
    ffi.Pointer<TSQuery> arg0,
  ) {
    return _ts_query_string_count(
      arg0,
    );
  }

  late final _ts_query_string_countPtr =
      _lookup<ffi.NativeFunction<ffi.Uint32 Function(ffi.Pointer<TSQuery>)>>(
          'ts_query_string_count');
  late final _ts_query_string_count = _ts_query_string_countPtr
      .asFunction<int Function(ffi.Pointer<TSQuery>)>();

  /// Get the byte offset where the given pattern starts in the query's source.
  ///
  /// This can be useful when combining queries by concatenating their source
  /// code strings.
  int ts_query_start_byte_for_pattern(
    ffi.Pointer<TSQuery> arg0,
    int arg1,
  ) {
    return _ts_query_start_byte_for_pattern(
      arg0,
      arg1,
    );
  }

  late final _ts_query_start_byte_for_patternPtr = _lookup<
      ffi.NativeFunction<
          ffi.Uint32 Function(ffi.Pointer<TSQuery>,
              ffi.Uint32)>>('ts_query_start_byte_for_pattern');
  late final _ts_query_start_byte_for_pattern =
      _ts_query_start_byte_for_patternPtr
          .asFunction<int Function(ffi.Pointer<TSQuery>, int)>();

  /// Get all of the predicates for the given pattern in the query.
  ///
  /// The predicates are represented as a single array of steps. There are three
  /// types of steps in this array, which correspond to the three legal values for
  /// the `type` field:
  /// - `TSQueryPredicateStepTypeCapture` - Steps with this type represent names
  /// of captures. Their `value_id` can be used with the
  /// `ts_query_capture_name_for_id` function to obtain the name of the capture.
  /// - `TSQueryPredicateStepTypeString` - Steps with this type represent literal
  /// strings. Their `value_id` can be used with the
  /// `ts_query_string_value_for_id` function to obtain their string value.
  /// - `TSQueryPredicateStepTypeDone` - Steps with this type are *sentinels*
  /// that represent the end of an individual predicate. If a pattern has two
  /// predicates, then there will be two steps with this `type` in the array.
  ffi.Pointer<TSQueryPredicateStep> ts_query_predicates_for_pattern(
    ffi.Pointer<TSQuery> self,
    int pattern_index,
    ffi.Pointer<ffi.Uint32> length,
  ) {
    return _ts_query_predicates_for_pattern(
      self,
      pattern_index,
      length,
    );
  }

  late final _ts_query_predicates_for_patternPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<TSQueryPredicateStep> Function(
              ffi.Pointer<TSQuery>,
              ffi.Uint32,
              ffi.Pointer<ffi.Uint32>)>>('ts_query_predicates_for_pattern');
  late final _ts_query_predicates_for_pattern =
      _ts_query_predicates_for_patternPtr.asFunction<
          ffi.Pointer<TSQueryPredicateStep> Function(
              ffi.Pointer<TSQuery>, int, ffi.Pointer<ffi.Uint32>)>();

  bool ts_query_is_pattern_rooted(
    ffi.Pointer<TSQuery> self,
    int pattern_index,
  ) {
    return _ts_query_is_pattern_rooted(
      self,
      pattern_index,
    );
  }

  late final _ts_query_is_pattern_rootedPtr = _lookup<
          ffi
          .NativeFunction<ffi.Bool Function(ffi.Pointer<TSQuery>, ffi.Uint32)>>(
      'ts_query_is_pattern_rooted');
  late final _ts_query_is_pattern_rooted = _ts_query_is_pattern_rootedPtr
      .asFunction<bool Function(ffi.Pointer<TSQuery>, int)>();

  bool ts_query_is_pattern_non_local(
    ffi.Pointer<TSQuery> self,
    int pattern_index,
  ) {
    return _ts_query_is_pattern_non_local(
      self,
      pattern_index,
    );
  }

  late final _ts_query_is_pattern_non_localPtr = _lookup<
          ffi
          .NativeFunction<ffi.Bool Function(ffi.Pointer<TSQuery>, ffi.Uint32)>>(
      'ts_query_is_pattern_non_local');
  late final _ts_query_is_pattern_non_local = _ts_query_is_pattern_non_localPtr
      .asFunction<bool Function(ffi.Pointer<TSQuery>, int)>();

  bool ts_query_is_pattern_guaranteed_at_step(
    ffi.Pointer<TSQuery> self,
    int byte_offset,
  ) {
    return _ts_query_is_pattern_guaranteed_at_step(
      self,
      byte_offset,
    );
  }

  late final _ts_query_is_pattern_guaranteed_at_stepPtr = _lookup<
          ffi
          .NativeFunction<ffi.Bool Function(ffi.Pointer<TSQuery>, ffi.Uint32)>>(
      'ts_query_is_pattern_guaranteed_at_step');
  late final _ts_query_is_pattern_guaranteed_at_step =
      _ts_query_is_pattern_guaranteed_at_stepPtr
          .asFunction<bool Function(ffi.Pointer<TSQuery>, int)>();

  /// Get the name and length of one of the query's captures, or one of the
  /// query's string literals. Each capture and string is associated with a
  /// numeric id based on the order that it appeared in the query's source.
  ffi.Pointer<ffi.Char> ts_query_capture_name_for_id(
    ffi.Pointer<TSQuery> arg0,
    int id,
    ffi.Pointer<ffi.Uint32> length,
  ) {
    return _ts_query_capture_name_for_id(
      arg0,
      id,
      length,
    );
  }

  late final _ts_query_capture_name_for_idPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<TSQuery>, ffi.Uint32,
              ffi.Pointer<ffi.Uint32>)>>('ts_query_capture_name_for_id');
  late final _ts_query_capture_name_for_id =
      _ts_query_capture_name_for_idPtr.asFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<TSQuery>, int, ffi.Pointer<ffi.Uint32>)>();

  /// Get the quantifier of the query's captures. Each capture is * associated
  /// with a numeric id based on the order that it appeared in the query's source.
  int ts_query_capture_quantifier_for_id(
    ffi.Pointer<TSQuery> arg0,
    int pattern_id,
    int capture_id,
  ) {
    return _ts_query_capture_quantifier_for_id(
      arg0,
      pattern_id,
      capture_id,
    );
  }

  late final _ts_query_capture_quantifier_for_idPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.Pointer<TSQuery>, ffi.Uint32,
              ffi.Uint32)>>('ts_query_capture_quantifier_for_id');
  late final _ts_query_capture_quantifier_for_id =
      _ts_query_capture_quantifier_for_idPtr
          .asFunction<int Function(ffi.Pointer<TSQuery>, int, int)>();

  ffi.Pointer<ffi.Char> ts_query_string_value_for_id(
    ffi.Pointer<TSQuery> arg0,
    int id,
    ffi.Pointer<ffi.Uint32> length,
  ) {
    return _ts_query_string_value_for_id(
      arg0,
      id,
      length,
    );
  }

  late final _ts_query_string_value_for_idPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<TSQuery>, ffi.Uint32,
              ffi.Pointer<ffi.Uint32>)>>('ts_query_string_value_for_id');
  late final _ts_query_string_value_for_id =
      _ts_query_string_value_for_idPtr.asFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<TSQuery>, int, ffi.Pointer<ffi.Uint32>)>();

  /// Disable a certain capture within a query.
  ///
  /// This prevents the capture from being returned in matches, and also avoids
  /// any resource usage associated with recording the capture. Currently, there
  /// is no way to undo this.
  void ts_query_disable_capture(
    ffi.Pointer<TSQuery> arg0,
    ffi.Pointer<ffi.Char> arg1,
    int arg2,
  ) {
    return _ts_query_disable_capture(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _ts_query_disable_capturePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<TSQuery>, ffi.Pointer<ffi.Char>,
              ffi.Uint32)>>('ts_query_disable_capture');
  late final _ts_query_disable_capture =
      _ts_query_disable_capturePtr.asFunction<
          void Function(ffi.Pointer<TSQuery>, ffi.Pointer<ffi.Char>, int)>();

  /// Disable a certain pattern within a query.
  ///
  /// This prevents the pattern from matching and removes most of the overhead
  /// associated with the pattern. Currently, there is no way to undo this.
  void ts_query_disable_pattern(
    ffi.Pointer<TSQuery> arg0,
    int arg1,
  ) {
    return _ts_query_disable_pattern(
      arg0,
      arg1,
    );
  }

  late final _ts_query_disable_patternPtr = _lookup<
          ffi
          .NativeFunction<ffi.Void Function(ffi.Pointer<TSQuery>, ffi.Uint32)>>(
      'ts_query_disable_pattern');
  late final _ts_query_disable_pattern = _ts_query_disable_patternPtr
      .asFunction<void Function(ffi.Pointer<TSQuery>, int)>();

  /// Create a new cursor for executing a given query.
  ///
  /// The cursor stores the state that is needed to iteratively search
  /// for matches. To use the query cursor, first call `ts_query_cursor_exec`
  /// to start running a given query on a given syntax node. Then, there are
  /// two options for consuming the results of the query:
  /// 1. Repeatedly call `ts_query_cursor_next_match` to iterate over all of the
  /// *matches* in the order that they were found. Each match contains the
  /// index of the pattern that matched, and an array of captures. Because
  /// multiple patterns can match the same set of nodes, one match may contain
  /// captures that appear *before* some of the captures from a previous match.
  /// 2. Repeatedly call `ts_query_cursor_next_capture` to iterate over all of the
  /// individual *captures* in the order that they appear. This is useful if
  /// don't care about which pattern matched, and just want a single ordered
  /// sequence of captures.
  ///
  /// If you don't care about consuming all of the results, you can stop calling
  /// `ts_query_cursor_next_match` or `ts_query_cursor_next_capture` at any point.
  /// You can then start executing another query on another node by calling
  /// `ts_query_cursor_exec` again.
  ffi.Pointer<TSQueryCursor> ts_query_cursor_new() {
    return _ts_query_cursor_new();
  }

  late final _ts_query_cursor_newPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<TSQueryCursor> Function()>>(
          'ts_query_cursor_new');
  late final _ts_query_cursor_new = _ts_query_cursor_newPtr
      .asFunction<ffi.Pointer<TSQueryCursor> Function()>();

  /// Delete a query cursor, freeing all of the memory that it used.
  void ts_query_cursor_delete(
    ffi.Pointer<TSQueryCursor> arg0,
  ) {
    return _ts_query_cursor_delete(
      arg0,
    );
  }

  late final _ts_query_cursor_deletePtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSQueryCursor>)>>(
      'ts_query_cursor_delete');
  late final _ts_query_cursor_delete = _ts_query_cursor_deletePtr
      .asFunction<void Function(ffi.Pointer<TSQueryCursor>)>();

  /// Start running a given query on a given node.
  void ts_query_cursor_exec(
    ffi.Pointer<TSQueryCursor> arg0,
    ffi.Pointer<TSQuery> arg1,
    TSNode arg2,
  ) {
    return _ts_query_cursor_exec(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _ts_query_cursor_execPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<TSQueryCursor>, ffi.Pointer<TSQuery>,
              TSNode)>>('ts_query_cursor_exec');
  late final _ts_query_cursor_exec = _ts_query_cursor_execPtr.asFunction<
      void Function(
          ffi.Pointer<TSQueryCursor>, ffi.Pointer<TSQuery>, TSNode)>();

  /// Manage the maximum number of in-progress matches allowed by this query
  /// cursor.
  ///
  /// Query cursors have an optional maximum capacity for storing lists of
  /// in-progress captures. If this capacity is exceeded, then the
  /// earliest-starting match will silently be dropped to make room for further
  /// matches. This maximum capacity is optional — by default, query cursors allow
  /// any number of pending matches, dynamically allocating new space for them as
  /// needed as the query is executed.
  bool ts_query_cursor_did_exceed_match_limit(
    ffi.Pointer<TSQueryCursor> arg0,
  ) {
    return _ts_query_cursor_did_exceed_match_limit(
      arg0,
    );
  }

  late final _ts_query_cursor_did_exceed_match_limitPtr = _lookup<
          ffi.NativeFunction<ffi.Bool Function(ffi.Pointer<TSQueryCursor>)>>(
      'ts_query_cursor_did_exceed_match_limit');
  late final _ts_query_cursor_did_exceed_match_limit =
      _ts_query_cursor_did_exceed_match_limitPtr
          .asFunction<bool Function(ffi.Pointer<TSQueryCursor>)>();

  int ts_query_cursor_match_limit(
    ffi.Pointer<TSQueryCursor> arg0,
  ) {
    return _ts_query_cursor_match_limit(
      arg0,
    );
  }

  late final _ts_query_cursor_match_limitPtr = _lookup<
          ffi.NativeFunction<ffi.Uint32 Function(ffi.Pointer<TSQueryCursor>)>>(
      'ts_query_cursor_match_limit');
  late final _ts_query_cursor_match_limit = _ts_query_cursor_match_limitPtr
      .asFunction<int Function(ffi.Pointer<TSQueryCursor>)>();

  void ts_query_cursor_set_match_limit(
    ffi.Pointer<TSQueryCursor> arg0,
    int arg1,
  ) {
    return _ts_query_cursor_set_match_limit(
      arg0,
      arg1,
    );
  }

  late final _ts_query_cursor_set_match_limitPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<TSQueryCursor>,
              ffi.Uint32)>>('ts_query_cursor_set_match_limit');
  late final _ts_query_cursor_set_match_limit =
      _ts_query_cursor_set_match_limitPtr
          .asFunction<void Function(ffi.Pointer<TSQueryCursor>, int)>();

  /// Set the range of bytes or (row, column) positions in which the query
  /// will be executed.
  void ts_query_cursor_set_byte_range(
    ffi.Pointer<TSQueryCursor> arg0,
    int arg1,
    int arg2,
  ) {
    return _ts_query_cursor_set_byte_range(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _ts_query_cursor_set_byte_rangePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<TSQueryCursor>, ffi.Uint32,
              ffi.Uint32)>>('ts_query_cursor_set_byte_range');
  late final _ts_query_cursor_set_byte_range =
      _ts_query_cursor_set_byte_rangePtr
          .asFunction<void Function(ffi.Pointer<TSQueryCursor>, int, int)>();

  void ts_query_cursor_set_point_range(
    ffi.Pointer<TSQueryCursor> arg0,
    TSPoint arg1,
    TSPoint arg2,
  ) {
    return _ts_query_cursor_set_point_range(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _ts_query_cursor_set_point_rangePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<TSQueryCursor>, TSPoint,
              TSPoint)>>('ts_query_cursor_set_point_range');
  late final _ts_query_cursor_set_point_range =
      _ts_query_cursor_set_point_rangePtr.asFunction<
          void Function(ffi.Pointer<TSQueryCursor>, TSPoint, TSPoint)>();

  /// Advance to the next match of the currently running query.
  ///
  /// If there is a match, write it to `*match` and return `true`.
  /// Otherwise, return `false`.
  bool ts_query_cursor_next_match(
    ffi.Pointer<TSQueryCursor> arg0,
    ffi.Pointer<TSQueryMatch> match,
  ) {
    return _ts_query_cursor_next_match(
      arg0,
      match,
    );
  }

  late final _ts_query_cursor_next_matchPtr = _lookup<
      ffi.NativeFunction<
          ffi.Bool Function(ffi.Pointer<TSQueryCursor>,
              ffi.Pointer<TSQueryMatch>)>>('ts_query_cursor_next_match');
  late final _ts_query_cursor_next_match =
      _ts_query_cursor_next_matchPtr.asFunction<
          bool Function(
              ffi.Pointer<TSQueryCursor>, ffi.Pointer<TSQueryMatch>)>();

  void ts_query_cursor_remove_match(
    ffi.Pointer<TSQueryCursor> arg0,
    int id,
  ) {
    return _ts_query_cursor_remove_match(
      arg0,
      id,
    );
  }

  late final _ts_query_cursor_remove_matchPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<TSQueryCursor>,
              ffi.Uint32)>>('ts_query_cursor_remove_match');
  late final _ts_query_cursor_remove_match = _ts_query_cursor_remove_matchPtr
      .asFunction<void Function(ffi.Pointer<TSQueryCursor>, int)>();

  /// Advance to the next capture of the currently running query.
  ///
  /// If there is a capture, write its match to `*match` and its index within
  /// the matche's capture list to `*capture_index`. Otherwise, return `false`.
  bool ts_query_cursor_next_capture(
    ffi.Pointer<TSQueryCursor> arg0,
    ffi.Pointer<TSQueryMatch> match,
    ffi.Pointer<ffi.Uint32> capture_index,
  ) {
    return _ts_query_cursor_next_capture(
      arg0,
      match,
      capture_index,
    );
  }

  late final _ts_query_cursor_next_capturePtr = _lookup<
      ffi.NativeFunction<
          ffi.Bool Function(
              ffi.Pointer<TSQueryCursor>,
              ffi.Pointer<TSQueryMatch>,
              ffi.Pointer<ffi.Uint32>)>>('ts_query_cursor_next_capture');
  late final _ts_query_cursor_next_capture =
      _ts_query_cursor_next_capturePtr.asFunction<
          bool Function(ffi.Pointer<TSQueryCursor>, ffi.Pointer<TSQueryMatch>,
              ffi.Pointer<ffi.Uint32>)>();

  /// Set the maximum start depth for a cursor.
  ///
  /// This prevents cursors from exploring children nodes at a certain depth.
  /// Note if a pattern includes many children, then they will still be checked.
  ///
  /// Set to `0` to remove the maximum start depth.
  void ts_query_cursor_set_max_start_depth(
    ffi.Pointer<TSQueryCursor> arg0,
    int arg1,
  ) {
    return _ts_query_cursor_set_max_start_depth(
      arg0,
      arg1,
    );
  }

  late final _ts_query_cursor_set_max_start_depthPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<TSQueryCursor>,
              ffi.Uint32)>>('ts_query_cursor_set_max_start_depth');
  late final _ts_query_cursor_set_max_start_depth =
      _ts_query_cursor_set_max_start_depthPtr
          .asFunction<void Function(ffi.Pointer<TSQueryCursor>, int)>();

  /// Get the number of distinct node types in the language.
  int ts_language_symbol_count(
    ffi.Pointer<TSLanguage> arg0,
  ) {
    return _ts_language_symbol_count(
      arg0,
    );
  }

  late final _ts_language_symbol_countPtr =
      _lookup<ffi.NativeFunction<ffi.Uint32 Function(ffi.Pointer<TSLanguage>)>>(
          'ts_language_symbol_count');
  late final _ts_language_symbol_count = _ts_language_symbol_countPtr
      .asFunction<int Function(ffi.Pointer<TSLanguage>)>();

  /// Get a node type string for the given numerical id.
  ffi.Pointer<ffi.Char> ts_language_symbol_name(
    ffi.Pointer<TSLanguage> arg0,
    int arg1,
  ) {
    return _ts_language_symbol_name(
      arg0,
      arg1,
    );
  }

  late final _ts_language_symbol_namePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<TSLanguage>, TSSymbol)>>('ts_language_symbol_name');
  late final _ts_language_symbol_name = _ts_language_symbol_namePtr.asFunction<
      ffi.Pointer<ffi.Char> Function(ffi.Pointer<TSLanguage>, int)>();

  /// Get the numerical id for the given node type string.
  int ts_language_symbol_for_name(
    ffi.Pointer<TSLanguage> self,
    ffi.Pointer<ffi.Char> string,
    int length,
    bool is_named,
  ) {
    return _ts_language_symbol_for_name(
      self,
      string,
      length,
      is_named,
    );
  }

  late final _ts_language_symbol_for_namePtr = _lookup<
      ffi.NativeFunction<
          TSSymbol Function(ffi.Pointer<TSLanguage>, ffi.Pointer<ffi.Char>,
              ffi.Uint32, ffi.Bool)>>('ts_language_symbol_for_name');
  late final _ts_language_symbol_for_name =
      _ts_language_symbol_for_namePtr.asFunction<
          int Function(
              ffi.Pointer<TSLanguage>, ffi.Pointer<ffi.Char>, int, bool)>();

  /// Get the number of distinct field names in the language.
  int ts_language_field_count(
    ffi.Pointer<TSLanguage> arg0,
  ) {
    return _ts_language_field_count(
      arg0,
    );
  }

  late final _ts_language_field_countPtr =
      _lookup<ffi.NativeFunction<ffi.Uint32 Function(ffi.Pointer<TSLanguage>)>>(
          'ts_language_field_count');
  late final _ts_language_field_count = _ts_language_field_countPtr
      .asFunction<int Function(ffi.Pointer<TSLanguage>)>();

  /// Get the field name string for the given numerical id.
  ffi.Pointer<ffi.Char> ts_language_field_name_for_id(
    ffi.Pointer<TSLanguage> arg0,
    int arg1,
  ) {
    return _ts_language_field_name_for_id(
      arg0,
      arg1,
    );
  }

  late final _ts_language_field_name_for_idPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<TSLanguage>,
              TSFieldId)>>('ts_language_field_name_for_id');
  late final _ts_language_field_name_for_id =
      _ts_language_field_name_for_idPtr.asFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<TSLanguage>, int)>();

  /// Get the numerical id for the given field name string.
  int ts_language_field_id_for_name(
    ffi.Pointer<TSLanguage> arg0,
    ffi.Pointer<ffi.Char> arg1,
    int arg2,
  ) {
    return _ts_language_field_id_for_name(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _ts_language_field_id_for_namePtr = _lookup<
      ffi.NativeFunction<
          TSFieldId Function(ffi.Pointer<TSLanguage>, ffi.Pointer<ffi.Char>,
              ffi.Uint32)>>('ts_language_field_id_for_name');
  late final _ts_language_field_id_for_name =
      _ts_language_field_id_for_namePtr.asFunction<
          int Function(ffi.Pointer<TSLanguage>, ffi.Pointer<ffi.Char>, int)>();

  /// Check whether the given node type id belongs to named nodes, anonymous nodes,
  /// or a hidden nodes.
  ///
  /// See also `ts_node_is_named`. Hidden nodes are never returned from the API.
  int ts_language_symbol_type(
    ffi.Pointer<TSLanguage> arg0,
    int arg1,
  ) {
    return _ts_language_symbol_type(
      arg0,
      arg1,
    );
  }

  late final _ts_language_symbol_typePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(
              ffi.Pointer<TSLanguage>, TSSymbol)>>('ts_language_symbol_type');
  late final _ts_language_symbol_type = _ts_language_symbol_typePtr
      .asFunction<int Function(ffi.Pointer<TSLanguage>, int)>();

  /// Get the ABI version number for this language. This version number is used
  /// to ensure that languages were generated by a compatible version of
  /// Tree-sitter.
  ///
  /// See also `ts_parser_set_language`.
  int ts_language_version(
    ffi.Pointer<TSLanguage> arg0,
  ) {
    return _ts_language_version(
      arg0,
    );
  }

  late final _ts_language_versionPtr =
      _lookup<ffi.NativeFunction<ffi.Uint32 Function(ffi.Pointer<TSLanguage>)>>(
          'ts_language_version');
  late final _ts_language_version = _ts_language_versionPtr
      .asFunction<int Function(ffi.Pointer<TSLanguage>)>();

  /// Set the allocation functions used by the library.
  ///
  /// By default, Tree-sitter uses the standard libc allocation functions,
  /// but aborts the process when an allocation fails. This function lets
  /// you supply alternative allocation functions at runtime.
  ///
  /// If you pass `NULL` for any parameter, Tree-sitter will switch back to
  /// its default implementation of that function.
  ///
  /// If you call this function after the library has already been used, then
  /// you must ensure that either:
  /// 1. All the existing objects have been freed.
  /// 2. The new allocator shares its state with the old one, so it is capable
  /// of freeing memory that was allocated by the old allocator.
  void ts_set_allocator(
    ffi.Pointer<ffi.NativeFunction<ffi.Pointer<ffi.Void> Function(ffi.Size)>>
        new_malloc,
    ffi.Pointer<
            ffi
            .NativeFunction<ffi.Pointer<ffi.Void> Function(ffi.Size, ffi.Size)>>
        new_calloc,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Pointer<ffi.Void> Function(
                    ffi.Pointer<ffi.Void>, ffi.Size)>>
        new_realloc,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        new_free,
  ) {
    return _ts_set_allocator(
      new_malloc,
      new_calloc,
      new_realloc,
      new_free,
    );
  }

  late final _ts_set_allocatorPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<
                  ffi.NativeFunction<ffi.Pointer<ffi.Void> Function(ffi.Size)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Pointer<ffi.Void> Function(ffi.Size, ffi.Size)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Pointer<ffi.Void> Function(
                          ffi.Pointer<ffi.Void>, ffi.Size)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('ts_set_allocator');
  late final _ts_set_allocator = _ts_set_allocatorPtr.asFunction<
      void Function(
          ffi.Pointer<
              ffi.NativeFunction<ffi.Pointer<ffi.Void> Function(ffi.Size)>>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Pointer<ffi.Void> Function(ffi.Size, ffi.Size)>>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Pointer<ffi.Void> Function(
                      ffi.Pointer<ffi.Void>, ffi.Size)>>,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  late final addresses = _SymbolAddresses(this);
}

class _SymbolAddresses {
  final TreeSitter _library;
  _SymbolAddresses(this._library);
  ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSParser>)>>
      get ts_parser_delete => _library._ts_parser_deletePtr;
  ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSTree>)>>
      get ts_tree_delete => _library._ts_tree_deletePtr;
  ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSTreeCursor>)>>
      get ts_tree_cursor_delete => _library._ts_tree_cursor_deletePtr;
  ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSQuery>)>>
      get ts_query_delete => _library._ts_query_deletePtr;
  ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<TSQueryCursor>)>>
      get ts_query_cursor_delete => _library._ts_query_cursor_deletePtr;
}

final class TSLanguage extends ffi.Opaque {}

final class TSParser extends ffi.Opaque {}

final class TSTree extends ffi.Opaque {}

final class TSQuery extends ffi.Opaque {}

final class TSQueryCursor extends ffi.Opaque {}

abstract class TSInputEncoding {
  static const int TSInputEncodingUTF8 = 0;
  static const int TSInputEncodingUTF16 = 1;
}

abstract class TSSymbolType {
  static const int TSSymbolTypeRegular = 0;
  static const int TSSymbolTypeAnonymous = 1;
  static const int TSSymbolTypeAuxiliary = 2;
}

final class TSPoint extends ffi.Struct {
  @ffi.Uint32()
  external int row;

  @ffi.Uint32()
  external int column;
}

final class TSRange extends ffi.Struct {
  external TSPoint start_point;

  external TSPoint end_point;

  @ffi.Uint32()
  external int start_byte;

  @ffi.Uint32()
  external int end_byte;
}

final class TSInput extends ffi.Struct {
  external ffi.Pointer<ffi.Void> payload;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<ffi.Void> payload,
              ffi.Uint32 byte_index,
              TSPoint position,
              ffi.Pointer<ffi.Uint32> bytes_read)>> read;

  @ffi.Int32()
  external int encoding;
}

abstract class TSLogType {
  static const int TSLogTypeParse = 0;
  static const int TSLogTypeLex = 1;
}

final class TSLogger extends ffi.Struct {
  external ffi.Pointer<ffi.Void> payload;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<ffi.Void>, ffi.Int32, ffi.Pointer<ffi.Char>)>> log;
}

final class TSInputEdit extends ffi.Struct {
  @ffi.Uint32()
  external int start_byte;

  @ffi.Uint32()
  external int old_end_byte;

  @ffi.Uint32()
  external int new_end_byte;

  external TSPoint start_point;

  external TSPoint old_end_point;

  external TSPoint new_end_point;
}

final class TSNode extends ffi.Struct {
  @ffi.Array.multi([4])
  external ffi.Array<ffi.Uint32> context;

  external ffi.Pointer<ffi.Void> id;

  external ffi.Pointer<TSTree> tree;
}

final class TSTreeCursor extends ffi.Struct {
  external ffi.Pointer<ffi.Void> tree;

  external ffi.Pointer<ffi.Void> id;

  @ffi.Array.multi([2])
  external ffi.Array<ffi.Uint32> context;
}

final class TSQueryCapture extends ffi.Struct {
  external TSNode node;

  @ffi.Uint32()
  external int index;
}

abstract class TSQuantifier {
  static const int TSQuantifierZero = 0;
  static const int TSQuantifierZeroOrOne = 1;
  static const int TSQuantifierZeroOrMore = 2;
  static const int TSQuantifierOne = 3;
  static const int TSQuantifierOneOrMore = 4;
}

final class TSQueryMatch extends ffi.Struct {
  @ffi.Uint32()
  external int id;

  @ffi.Uint16()
  external int pattern_index;

  @ffi.Uint16()
  external int capture_count;

  external ffi.Pointer<TSQueryCapture> captures;
}

abstract class TSQueryPredicateStepType {
  static const int TSQueryPredicateStepTypeDone = 0;
  static const int TSQueryPredicateStepTypeCapture = 1;
  static const int TSQueryPredicateStepTypeString = 2;
}

final class TSQueryPredicateStep extends ffi.Struct {
  @ffi.Int32()
  external int type;

  @ffi.Uint32()
  external int value_id;
}

abstract class TSQueryError {
  static const int TSQueryErrorNone = 0;
  static const int TSQueryErrorSyntax = 1;
  static const int TSQueryErrorNodeType = 2;
  static const int TSQueryErrorField = 3;
  static const int TSQueryErrorCapture = 4;
  static const int TSQueryErrorStructure = 5;
  static const int TSQueryErrorLanguage = 6;
}

/// /
typedef TSSymbol = ffi.Uint16;
typedef TSFieldId = ffi.Uint16;

const int TREE_SITTER_LANGUAGE_VERSION = 14;

const int TREE_SITTER_MIN_COMPATIBLE_LANGUAGE_VERSION = 13;
