#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 722
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 89
#define ALIAS_COUNT 0
#define TOKEN_COUNT 40
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 1

enum {
  sym__escape_identity = 1,
  anon_sym_BSLASHt = 2,
  anon_sym_BSLASHr = 3,
  anon_sym_BSLASHn = 4,
  sym__escape_semicolon = 5,
  aux_sym_variable_token1 = 6,
  anon_sym_DOLLAR = 7,
  anon_sym_LBRACE = 8,
  anon_sym_RBRACE = 9,
  anon_sym_ENV = 10,
  anon_sym_CACHE = 11,
  anon_sym_LT = 12,
  anon_sym_GT = 13,
  anon_sym_COLON = 14,
  aux_sym__gen_exp_arguments_token1 = 15,
  aux_sym__untrimmed_argument_token1 = 16,
  anon_sym_LPAREN = 17,
  anon_sym_RPAREN = 18,
  anon_sym_DQUOTE = 19,
  aux_sym__quoted_text_token1 = 20,
  aux_sym__unquoted_text_token1 = 21,
  aux_sym_if_command_token1 = 22,
  aux_sym_endwhile_command_token1 = 23,
  sym_if = 24,
  sym_elseif = 25,
  sym_else = 26,
  sym_endif = 27,
  sym_foreach = 28,
  sym_endforeach = 29,
  sym_while = 30,
  sym_endwhile = 31,
  sym_function = 32,
  sym_endfunction = 33,
  sym_macro = 34,
  sym_endmacro = 35,
  sym_identifier = 36,
  sym_bracket_argument = 37,
  sym_bracket_comment = 38,
  sym_line_comment = 39,
  sym_source_file = 40,
  sym_escape_sequence = 41,
  sym__escape_encoded = 42,
  sym_variable = 43,
  sym_variable_ref = 44,
  sym_normal_var = 45,
  sym_env_var = 46,
  sym_cache_var = 47,
  sym_gen_exp = 48,
  sym__gen_exp_content = 49,
  sym__gen_exp_arguments = 50,
  sym_argument = 51,
  sym__untrimmed_argument = 52,
  sym__paren_argument = 53,
  sym_quoted_argument = 54,
  sym_quoted_element = 55,
  sym__quoted_text = 56,
  sym_unquoted_argument = 57,
  sym__unquoted_text = 58,
  sym_if_command = 59,
  sym_elseif_command = 60,
  sym_else_command = 61,
  sym_endif_command = 62,
  sym_if_condition = 63,
  sym_foreach_command = 64,
  sym_endforeach_command = 65,
  sym_foreach_loop = 66,
  sym_while_command = 67,
  sym_endwhile_command = 68,
  sym_while_loop = 69,
  sym_function_command = 70,
  sym_endfunction_command = 71,
  sym_function_def = 72,
  sym_macro_command = 73,
  sym_endmacro_command = 74,
  sym_macro_def = 75,
  sym_normal_command = 76,
  sym__command_invocation = 77,
  sym__untrimmed_command_invocation = 78,
  aux_sym_source_file_repeat1 = 79,
  aux_sym_variable_repeat1 = 80,
  aux_sym__gen_exp_arguments_repeat1 = 81,
  aux_sym__paren_argument_repeat1 = 82,
  aux_sym_quoted_element_repeat1 = 83,
  aux_sym__quoted_text_repeat1 = 84,
  aux_sym_unquoted_argument_repeat1 = 85,
  aux_sym__unquoted_text_repeat1 = 86,
  aux_sym_if_command_repeat1 = 87,
  aux_sym_if_condition_repeat1 = 88,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__escape_identity] = "_escape_identity",
  [anon_sym_BSLASHt] = "\\t",
  [anon_sym_BSLASHr] = "\\r",
  [anon_sym_BSLASHn] = "\\n",
  [sym__escape_semicolon] = "_escape_semicolon",
  [aux_sym_variable_token1] = "variable_token1",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_ENV] = "ENV",
  [anon_sym_CACHE] = "CACHE",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_COLON] = ":",
  [aux_sym__gen_exp_arguments_token1] = "_gen_exp_arguments_token1",
  [aux_sym__untrimmed_argument_token1] = "_untrimmed_argument_token1",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__quoted_text_token1] = "_quoted_text_token1",
  [aux_sym__unquoted_text_token1] = "_unquoted_text_token1",
  [aux_sym_if_command_token1] = "if_command_token1",
  [aux_sym_endwhile_command_token1] = "endwhile_command_token1",
  [sym_if] = "if",
  [sym_elseif] = "elseif",
  [sym_else] = "else",
  [sym_endif] = "endif",
  [sym_foreach] = "foreach",
  [sym_endforeach] = "endforeach",
  [sym_while] = "while",
  [sym_endwhile] = "endwhile",
  [sym_function] = "function",
  [sym_endfunction] = "endfunction",
  [sym_macro] = "macro",
  [sym_endmacro] = "endmacro",
  [sym_identifier] = "identifier",
  [sym_bracket_argument] = "bracket_argument",
  [sym_bracket_comment] = "bracket_comment",
  [sym_line_comment] = "line_comment",
  [sym_source_file] = "source_file",
  [sym_escape_sequence] = "escape_sequence",
  [sym__escape_encoded] = "_escape_encoded",
  [sym_variable] = "variable",
  [sym_variable_ref] = "variable_ref",
  [sym_normal_var] = "normal_var",
  [sym_env_var] = "env_var",
  [sym_cache_var] = "cache_var",
  [sym_gen_exp] = "gen_exp",
  [sym__gen_exp_content] = "_gen_exp_content",
  [sym__gen_exp_arguments] = "_gen_exp_arguments",
  [sym_argument] = "argument",
  [sym__untrimmed_argument] = "_untrimmed_argument",
  [sym__paren_argument] = "_paren_argument",
  [sym_quoted_argument] = "quoted_argument",
  [sym_quoted_element] = "quoted_element",
  [sym__quoted_text] = "_quoted_text",
  [sym_unquoted_argument] = "unquoted_argument",
  [sym__unquoted_text] = "_unquoted_text",
  [sym_if_command] = "if_command",
  [sym_elseif_command] = "elseif_command",
  [sym_else_command] = "else_command",
  [sym_endif_command] = "endif_command",
  [sym_if_condition] = "if_condition",
  [sym_foreach_command] = "foreach_command",
  [sym_endforeach_command] = "endforeach_command",
  [sym_foreach_loop] = "foreach_loop",
  [sym_while_command] = "while_command",
  [sym_endwhile_command] = "endwhile_command",
  [sym_while_loop] = "while_loop",
  [sym_function_command] = "function_command",
  [sym_endfunction_command] = "endfunction_command",
  [sym_function_def] = "function_def",
  [sym_macro_command] = "macro_command",
  [sym_endmacro_command] = "endmacro_command",
  [sym_macro_def] = "macro_def",
  [sym_normal_command] = "normal_command",
  [sym__command_invocation] = "_command_invocation",
  [sym__untrimmed_command_invocation] = "_untrimmed_command_invocation",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_variable_repeat1] = "variable_repeat1",
  [aux_sym__gen_exp_arguments_repeat1] = "_gen_exp_arguments_repeat1",
  [aux_sym__paren_argument_repeat1] = "_paren_argument_repeat1",
  [aux_sym_quoted_element_repeat1] = "quoted_element_repeat1",
  [aux_sym__quoted_text_repeat1] = "_quoted_text_repeat1",
  [aux_sym_unquoted_argument_repeat1] = "unquoted_argument_repeat1",
  [aux_sym__unquoted_text_repeat1] = "_unquoted_text_repeat1",
  [aux_sym_if_command_repeat1] = "if_command_repeat1",
  [aux_sym_if_condition_repeat1] = "if_condition_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__escape_identity] = sym__escape_identity,
  [anon_sym_BSLASHt] = anon_sym_BSLASHt,
  [anon_sym_BSLASHr] = anon_sym_BSLASHr,
  [anon_sym_BSLASHn] = anon_sym_BSLASHn,
  [sym__escape_semicolon] = sym__escape_semicolon,
  [aux_sym_variable_token1] = aux_sym_variable_token1,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_ENV] = anon_sym_ENV,
  [anon_sym_CACHE] = anon_sym_CACHE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [aux_sym__gen_exp_arguments_token1] = aux_sym__gen_exp_arguments_token1,
  [aux_sym__untrimmed_argument_token1] = aux_sym__untrimmed_argument_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__quoted_text_token1] = aux_sym__quoted_text_token1,
  [aux_sym__unquoted_text_token1] = aux_sym__unquoted_text_token1,
  [aux_sym_if_command_token1] = aux_sym_if_command_token1,
  [aux_sym_endwhile_command_token1] = aux_sym_endwhile_command_token1,
  [sym_if] = sym_if,
  [sym_elseif] = sym_elseif,
  [sym_else] = sym_else,
  [sym_endif] = sym_endif,
  [sym_foreach] = sym_foreach,
  [sym_endforeach] = sym_endforeach,
  [sym_while] = sym_while,
  [sym_endwhile] = sym_endwhile,
  [sym_function] = sym_function,
  [sym_endfunction] = sym_endfunction,
  [sym_macro] = sym_macro,
  [sym_endmacro] = sym_endmacro,
  [sym_identifier] = sym_identifier,
  [sym_bracket_argument] = sym_bracket_argument,
  [sym_bracket_comment] = sym_bracket_comment,
  [sym_line_comment] = sym_line_comment,
  [sym_source_file] = sym_source_file,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__escape_encoded] = sym__escape_encoded,
  [sym_variable] = sym_variable,
  [sym_variable_ref] = sym_variable_ref,
  [sym_normal_var] = sym_normal_var,
  [sym_env_var] = sym_env_var,
  [sym_cache_var] = sym_cache_var,
  [sym_gen_exp] = sym_gen_exp,
  [sym__gen_exp_content] = sym__gen_exp_content,
  [sym__gen_exp_arguments] = sym__gen_exp_arguments,
  [sym_argument] = sym_argument,
  [sym__untrimmed_argument] = sym__untrimmed_argument,
  [sym__paren_argument] = sym__paren_argument,
  [sym_quoted_argument] = sym_quoted_argument,
  [sym_quoted_element] = sym_quoted_element,
  [sym__quoted_text] = sym__quoted_text,
  [sym_unquoted_argument] = sym_unquoted_argument,
  [sym__unquoted_text] = sym__unquoted_text,
  [sym_if_command] = sym_if_command,
  [sym_elseif_command] = sym_elseif_command,
  [sym_else_command] = sym_else_command,
  [sym_endif_command] = sym_endif_command,
  [sym_if_condition] = sym_if_condition,
  [sym_foreach_command] = sym_foreach_command,
  [sym_endforeach_command] = sym_endforeach_command,
  [sym_foreach_loop] = sym_foreach_loop,
  [sym_while_command] = sym_while_command,
  [sym_endwhile_command] = sym_endwhile_command,
  [sym_while_loop] = sym_while_loop,
  [sym_function_command] = sym_function_command,
  [sym_endfunction_command] = sym_endfunction_command,
  [sym_function_def] = sym_function_def,
  [sym_macro_command] = sym_macro_command,
  [sym_endmacro_command] = sym_endmacro_command,
  [sym_macro_def] = sym_macro_def,
  [sym_normal_command] = sym_normal_command,
  [sym__command_invocation] = sym__command_invocation,
  [sym__untrimmed_command_invocation] = sym__untrimmed_command_invocation,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_variable_repeat1] = aux_sym_variable_repeat1,
  [aux_sym__gen_exp_arguments_repeat1] = aux_sym__gen_exp_arguments_repeat1,
  [aux_sym__paren_argument_repeat1] = aux_sym__paren_argument_repeat1,
  [aux_sym_quoted_element_repeat1] = aux_sym_quoted_element_repeat1,
  [aux_sym__quoted_text_repeat1] = aux_sym__quoted_text_repeat1,
  [aux_sym_unquoted_argument_repeat1] = aux_sym_unquoted_argument_repeat1,
  [aux_sym__unquoted_text_repeat1] = aux_sym__unquoted_text_repeat1,
  [aux_sym_if_command_repeat1] = aux_sym_if_command_repeat1,
  [aux_sym_if_condition_repeat1] = aux_sym_if_condition_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__escape_identity] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BSLASHt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHn] = {
    .visible = true,
    .named = false,
  },
  [sym__escape_semicolon] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_variable_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENV] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CACHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__gen_exp_arguments_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__untrimmed_argument_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__quoted_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unquoted_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_endwhile_command_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_endif] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_endwhile] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction] = {
    .visible = true,
    .named = true,
  },
  [sym_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_endmacro] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_encoded] = {
    .visible = false,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_var] = {
    .visible = true,
    .named = true,
  },
  [sym_env_var] = {
    .visible = true,
    .named = true,
  },
  [sym_cache_var] = {
    .visible = true,
    .named = true,
  },
  [sym_gen_exp] = {
    .visible = true,
    .named = true,
  },
  [sym__gen_exp_content] = {
    .visible = false,
    .named = true,
  },
  [sym__gen_exp_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__untrimmed_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__paren_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_element] = {
    .visible = true,
    .named = true,
  },
  [sym__quoted_text] = {
    .visible = false,
    .named = true,
  },
  [sym_unquoted_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__unquoted_text] = {
    .visible = false,
    .named = true,
  },
  [sym_if_command] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_command] = {
    .visible = true,
    .named = true,
  },
  [sym_else_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endif_command] = {
    .visible = true,
    .named = true,
  },
  [sym_if_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_while_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endwhile_command] = {
    .visible = true,
    .named = true,
  },
  [sym_while_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_function_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction_command] = {
    .visible = true,
    .named = true,
  },
  [sym_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endmacro_command] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_def] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_command] = {
    .visible = true,
    .named = true,
  },
  [sym__command_invocation] = {
    .visible = false,
    .named = true,
  },
  [sym__untrimmed_command_invocation] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__gen_exp_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paren_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_quoted_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__quoted_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unquoted_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unquoted_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_condition_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(24);
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == '(') ADVANCE(41);
      if (lookahead == ')') ADVANCE(42);
      if (lookahead == ',') ADVANCE(39);
      if (lookahead == ':') ADVANCE(38);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == 'C') ADVANCE(48);
      if (lookahead == 'E') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '{') ADVANCE(32);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'') ADVANCE(47);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == '(') ADVANCE(41);
      if (lookahead == ')') ADVANCE(42);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == 'C') ADVANCE(48);
      if (lookahead == 'E') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '{') ADVANCE(32);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'') ADVANCE(47);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == '(') ADVANCE(41);
      if (lookahead == ')') ADVANCE(42);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'') ADVANCE(47);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ')') ADVANCE(42);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'' &&
          lookahead != '(') ADVANCE(47);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ',') ADVANCE(39);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == 'C') ADVANCE(48);
      if (lookahead == 'E') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '{') ADVANCE(32);
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(47);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ',') ADVANCE(39);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(47);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == 'C') ADVANCE(45);
      if (lookahead == 'E') ADVANCE(46);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '{') ADVANCE(32);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(47);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == '(') ADVANCE(41);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '}') ADVANCE(33);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(51);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(30);
      END_STATE();
    case 10:
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ')') ADVANCE(42);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == 'C') ADVANCE(48);
      if (lookahead == 'E') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '{') ADVANCE(32);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\'' &&
          lookahead != '(') ADVANCE(47);
      END_STATE();
    case 11:
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ':') ADVANCE(38);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == 'C') ADVANCE(48);
      if (lookahead == 'E') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '{') ADVANCE(32);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(47);
      END_STATE();
    case 12:
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ':') ADVANCE(38);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(47);
      END_STATE();
    case 13:
      if (lookahead == 'C') ADVANCE(15);
      END_STATE();
    case 14:
      if (lookahead == 'E') ADVANCE(35);
      END_STATE();
    case 15:
      if (lookahead == 'H') ADVANCE(14);
      END_STATE();
    case 16:
      if (lookahead == 'V') ADVANCE(34);
      END_STATE();
    case 17:
      if (lookahead == 'n') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(27);
      if (lookahead == 't') ADVANCE(26);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ';' &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(25);
      END_STATE();
    case 18:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(102);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(114);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(68);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 19:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(109);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(114);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(68);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 20:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(110);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(114);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(68);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 21:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(111);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(114);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(68);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 22:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(114);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(68);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 23:
      if (eof) ADVANCE(24);
      if (lookahead == '}') ADVANCE(33);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(114);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(68);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym__escape_identity);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_BSLASHt);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_BSLASHr);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_BSLASHn);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(sym__escape_semicolon);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_ENV);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_CACHE);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(aux_sym__gen_exp_arguments_token1);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(aux_sym__untrimmed_argument_token1);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      if (lookahead == 'A') ADVANCE(13);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      if (lookahead == 'N') ADVANCE(16);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == 'A') ADVANCE(13);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == 'N') ADVANCE(16);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(55);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(aux_sym_if_command_token1);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == 'C') ADVANCE(48);
      if (lookahead == 'E') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '{') ADVANCE(32);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(50);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(47);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(50);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(47);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == ')') ADVANCE(42);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(55);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_elseif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_else);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_endif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_foreach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_endforeach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_endwhile);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_function);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_endfunction);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_macro);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_endmacro);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(124);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(120);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(108);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(106);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(116);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(113);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 23, .external_lex_state = 2},
  [2] = {.lex_state = 2, .external_lex_state = 1},
  [3] = {.lex_state = 2, .external_lex_state = 1},
  [4] = {.lex_state = 2, .external_lex_state = 1},
  [5] = {.lex_state = 2, .external_lex_state = 1},
  [6] = {.lex_state = 2, .external_lex_state = 1},
  [7] = {.lex_state = 2, .external_lex_state = 1},
  [8] = {.lex_state = 2, .external_lex_state = 1},
  [9] = {.lex_state = 2, .external_lex_state = 1},
  [10] = {.lex_state = 2, .external_lex_state = 1},
  [11] = {.lex_state = 2, .external_lex_state = 1},
  [12] = {.lex_state = 2, .external_lex_state = 1},
  [13] = {.lex_state = 2, .external_lex_state = 1},
  [14] = {.lex_state = 2, .external_lex_state = 1},
  [15] = {.lex_state = 2, .external_lex_state = 1},
  [16] = {.lex_state = 2, .external_lex_state = 1},
  [17] = {.lex_state = 2, .external_lex_state = 1},
  [18] = {.lex_state = 2, .external_lex_state = 1},
  [19] = {.lex_state = 2, .external_lex_state = 1},
  [20] = {.lex_state = 2, .external_lex_state = 1},
  [21] = {.lex_state = 2, .external_lex_state = 1},
  [22] = {.lex_state = 2, .external_lex_state = 1},
  [23] = {.lex_state = 2, .external_lex_state = 1},
  [24] = {.lex_state = 2, .external_lex_state = 1},
  [25] = {.lex_state = 2, .external_lex_state = 1},
  [26] = {.lex_state = 2, .external_lex_state = 1},
  [27] = {.lex_state = 2, .external_lex_state = 1},
  [28] = {.lex_state = 2, .external_lex_state = 1},
  [29] = {.lex_state = 2, .external_lex_state = 1},
  [30] = {.lex_state = 2, .external_lex_state = 1},
  [31] = {.lex_state = 2, .external_lex_state = 1},
  [32] = {.lex_state = 2, .external_lex_state = 1},
  [33] = {.lex_state = 2, .external_lex_state = 1},
  [34] = {.lex_state = 2, .external_lex_state = 1},
  [35] = {.lex_state = 2, .external_lex_state = 1},
  [36] = {.lex_state = 2, .external_lex_state = 1},
  [37] = {.lex_state = 2, .external_lex_state = 1},
  [38] = {.lex_state = 2, .external_lex_state = 1},
  [39] = {.lex_state = 2, .external_lex_state = 1},
  [40] = {.lex_state = 2, .external_lex_state = 1},
  [41] = {.lex_state = 2, .external_lex_state = 1},
  [42] = {.lex_state = 2, .external_lex_state = 1},
  [43] = {.lex_state = 2, .external_lex_state = 1},
  [44] = {.lex_state = 2, .external_lex_state = 1},
  [45] = {.lex_state = 2, .external_lex_state = 1},
  [46] = {.lex_state = 2, .external_lex_state = 1},
  [47] = {.lex_state = 2, .external_lex_state = 1},
  [48] = {.lex_state = 2, .external_lex_state = 1},
  [49] = {.lex_state = 2, .external_lex_state = 1},
  [50] = {.lex_state = 2, .external_lex_state = 1},
  [51] = {.lex_state = 2, .external_lex_state = 1},
  [52] = {.lex_state = 2, .external_lex_state = 1},
  [53] = {.lex_state = 2, .external_lex_state = 1},
  [54] = {.lex_state = 2, .external_lex_state = 1},
  [55] = {.lex_state = 2, .external_lex_state = 1},
  [56] = {.lex_state = 2, .external_lex_state = 1},
  [57] = {.lex_state = 2, .external_lex_state = 1},
  [58] = {.lex_state = 2, .external_lex_state = 1},
  [59] = {.lex_state = 2, .external_lex_state = 1},
  [60] = {.lex_state = 2, .external_lex_state = 1},
  [61] = {.lex_state = 2, .external_lex_state = 1},
  [62] = {.lex_state = 2, .external_lex_state = 1},
  [63] = {.lex_state = 2, .external_lex_state = 1},
  [64] = {.lex_state = 2, .external_lex_state = 1},
  [65] = {.lex_state = 2, .external_lex_state = 1},
  [66] = {.lex_state = 2, .external_lex_state = 1},
  [67] = {.lex_state = 2, .external_lex_state = 1},
  [68] = {.lex_state = 2, .external_lex_state = 1},
  [69] = {.lex_state = 2, .external_lex_state = 1},
  [70] = {.lex_state = 2, .external_lex_state = 1},
  [71] = {.lex_state = 2, .external_lex_state = 1},
  [72] = {.lex_state = 2, .external_lex_state = 1},
  [73] = {.lex_state = 2, .external_lex_state = 1},
  [74] = {.lex_state = 2, .external_lex_state = 1},
  [75] = {.lex_state = 2, .external_lex_state = 1},
  [76] = {.lex_state = 2, .external_lex_state = 1},
  [77] = {.lex_state = 2, .external_lex_state = 1},
  [78] = {.lex_state = 2, .external_lex_state = 1},
  [79] = {.lex_state = 2, .external_lex_state = 1},
  [80] = {.lex_state = 2, .external_lex_state = 1},
  [81] = {.lex_state = 2, .external_lex_state = 1},
  [82] = {.lex_state = 2, .external_lex_state = 1},
  [83] = {.lex_state = 2, .external_lex_state = 1},
  [84] = {.lex_state = 2, .external_lex_state = 1},
  [85] = {.lex_state = 2, .external_lex_state = 1},
  [86] = {.lex_state = 2, .external_lex_state = 1},
  [87] = {.lex_state = 2, .external_lex_state = 1},
  [88] = {.lex_state = 2, .external_lex_state = 1},
  [89] = {.lex_state = 2, .external_lex_state = 1},
  [90] = {.lex_state = 2, .external_lex_state = 1},
  [91] = {.lex_state = 2, .external_lex_state = 1},
  [92] = {.lex_state = 2, .external_lex_state = 1},
  [93] = {.lex_state = 2, .external_lex_state = 1},
  [94] = {.lex_state = 2, .external_lex_state = 1},
  [95] = {.lex_state = 2, .external_lex_state = 1},
  [96] = {.lex_state = 2, .external_lex_state = 1},
  [97] = {.lex_state = 2, .external_lex_state = 1},
  [98] = {.lex_state = 2, .external_lex_state = 1},
  [99] = {.lex_state = 2, .external_lex_state = 1},
  [100] = {.lex_state = 2, .external_lex_state = 1},
  [101] = {.lex_state = 2, .external_lex_state = 1},
  [102] = {.lex_state = 2, .external_lex_state = 1},
  [103] = {.lex_state = 2, .external_lex_state = 1},
  [104] = {.lex_state = 2, .external_lex_state = 1},
  [105] = {.lex_state = 2, .external_lex_state = 1},
  [106] = {.lex_state = 2, .external_lex_state = 1},
  [107] = {.lex_state = 2, .external_lex_state = 1},
  [108] = {.lex_state = 2, .external_lex_state = 1},
  [109] = {.lex_state = 2, .external_lex_state = 1},
  [110] = {.lex_state = 2, .external_lex_state = 1},
  [111] = {.lex_state = 2, .external_lex_state = 1},
  [112] = {.lex_state = 2, .external_lex_state = 1},
  [113] = {.lex_state = 2, .external_lex_state = 1},
  [114] = {.lex_state = 2, .external_lex_state = 1},
  [115] = {.lex_state = 2, .external_lex_state = 1},
  [116] = {.lex_state = 2, .external_lex_state = 1},
  [117] = {.lex_state = 2, .external_lex_state = 1},
  [118] = {.lex_state = 2, .external_lex_state = 1},
  [119] = {.lex_state = 2, .external_lex_state = 1},
  [120] = {.lex_state = 2, .external_lex_state = 1},
  [121] = {.lex_state = 2, .external_lex_state = 1},
  [122] = {.lex_state = 2, .external_lex_state = 1},
  [123] = {.lex_state = 2, .external_lex_state = 1},
  [124] = {.lex_state = 2, .external_lex_state = 1},
  [125] = {.lex_state = 2, .external_lex_state = 1},
  [126] = {.lex_state = 2, .external_lex_state = 1},
  [127] = {.lex_state = 2, .external_lex_state = 1},
  [128] = {.lex_state = 2, .external_lex_state = 1},
  [129] = {.lex_state = 18, .external_lex_state = 2},
  [130] = {.lex_state = 18, .external_lex_state = 2},
  [131] = {.lex_state = 18, .external_lex_state = 2},
  [132] = {.lex_state = 18, .external_lex_state = 2},
  [133] = {.lex_state = 18, .external_lex_state = 2},
  [134] = {.lex_state = 18, .external_lex_state = 2},
  [135] = {.lex_state = 18, .external_lex_state = 2},
  [136] = {.lex_state = 18, .external_lex_state = 2},
  [137] = {.lex_state = 18, .external_lex_state = 2},
  [138] = {.lex_state = 18, .external_lex_state = 2},
  [139] = {.lex_state = 18, .external_lex_state = 2},
  [140] = {.lex_state = 18, .external_lex_state = 2},
  [141] = {.lex_state = 18, .external_lex_state = 2},
  [142] = {.lex_state = 19, .external_lex_state = 2},
  [143] = {.lex_state = 20, .external_lex_state = 2},
  [144] = {.lex_state = 19, .external_lex_state = 2},
  [145] = {.lex_state = 20, .external_lex_state = 2},
  [146] = {.lex_state = 21, .external_lex_state = 2},
  [147] = {.lex_state = 20, .external_lex_state = 2},
  [148] = {.lex_state = 22, .external_lex_state = 2},
  [149] = {.lex_state = 19, .external_lex_state = 2},
  [150] = {.lex_state = 22, .external_lex_state = 2},
  [151] = {.lex_state = 21, .external_lex_state = 2},
  [152] = {.lex_state = 19, .external_lex_state = 2},
  [153] = {.lex_state = 19, .external_lex_state = 2},
  [154] = {.lex_state = 20, .external_lex_state = 2},
  [155] = {.lex_state = 22, .external_lex_state = 2},
  [156] = {.lex_state = 21, .external_lex_state = 2},
  [157] = {.lex_state = 21, .external_lex_state = 2},
  [158] = {.lex_state = 22, .external_lex_state = 2},
  [159] = {.lex_state = 19, .external_lex_state = 2},
  [160] = {.lex_state = 20, .external_lex_state = 2},
  [161] = {.lex_state = 19, .external_lex_state = 2},
  [162] = {.lex_state = 20, .external_lex_state = 2},
  [163] = {.lex_state = 22, .external_lex_state = 2},
  [164] = {.lex_state = 21, .external_lex_state = 2},
  [165] = {.lex_state = 19, .external_lex_state = 2},
  [166] = {.lex_state = 22, .external_lex_state = 2},
  [167] = {.lex_state = 19, .external_lex_state = 2},
  [168] = {.lex_state = 22, .external_lex_state = 2},
  [169] = {.lex_state = 21, .external_lex_state = 2},
  [170] = {.lex_state = 20, .external_lex_state = 2},
  [171] = {.lex_state = 21, .external_lex_state = 2},
  [172] = {.lex_state = 22, .external_lex_state = 2},
  [173] = {.lex_state = 21, .external_lex_state = 2},
  [174] = {.lex_state = 22, .external_lex_state = 2},
  [175] = {.lex_state = 19, .external_lex_state = 2},
  [176] = {.lex_state = 22, .external_lex_state = 2},
  [177] = {.lex_state = 19, .external_lex_state = 2},
  [178] = {.lex_state = 21, .external_lex_state = 2},
  [179] = {.lex_state = 20, .external_lex_state = 2},
  [180] = {.lex_state = 21, .external_lex_state = 2},
  [181] = {.lex_state = 20, .external_lex_state = 2},
  [182] = {.lex_state = 19, .external_lex_state = 2},
  [183] = {.lex_state = 22, .external_lex_state = 2},
  [184] = {.lex_state = 21, .external_lex_state = 2},
  [185] = {.lex_state = 21, .external_lex_state = 2},
  [186] = {.lex_state = 22, .external_lex_state = 2},
  [187] = {.lex_state = 20, .external_lex_state = 2},
  [188] = {.lex_state = 20, .external_lex_state = 2},
  [189] = {.lex_state = 20, .external_lex_state = 2},
  [190] = {.lex_state = 7, .external_lex_state = 3},
  [191] = {.lex_state = 7, .external_lex_state = 3},
  [192] = {.lex_state = 7, .external_lex_state = 3},
  [193] = {.lex_state = 7, .external_lex_state = 3},
  [194] = {.lex_state = 7, .external_lex_state = 3},
  [195] = {.lex_state = 7, .external_lex_state = 3},
  [196] = {.lex_state = 22, .external_lex_state = 2},
  [197] = {.lex_state = 23, .external_lex_state = 2},
  [198] = {.lex_state = 7, .external_lex_state = 3},
  [199] = {.lex_state = 20, .external_lex_state = 2},
  [200] = {.lex_state = 2, .external_lex_state = 1},
  [201] = {.lex_state = 7, .external_lex_state = 3},
  [202] = {.lex_state = 21, .external_lex_state = 2},
  [203] = {.lex_state = 19, .external_lex_state = 2},
  [204] = {.lex_state = 23, .external_lex_state = 2},
  [205] = {.lex_state = 2, .external_lex_state = 1},
  [206] = {.lex_state = 7, .external_lex_state = 3},
  [207] = {.lex_state = 3, .external_lex_state = 3},
  [208] = {.lex_state = 3, .external_lex_state = 3},
  [209] = {.lex_state = 3, .external_lex_state = 3},
  [210] = {.lex_state = 3, .external_lex_state = 3},
  [211] = {.lex_state = 3, .external_lex_state = 3},
  [212] = {.lex_state = 3, .external_lex_state = 3},
  [213] = {.lex_state = 3, .external_lex_state = 3},
  [214] = {.lex_state = 3, .external_lex_state = 3},
  [215] = {.lex_state = 3, .external_lex_state = 3},
  [216] = {.lex_state = 3, .external_lex_state = 3},
  [217] = {.lex_state = 3, .external_lex_state = 3},
  [218] = {.lex_state = 3, .external_lex_state = 3},
  [219] = {.lex_state = 3, .external_lex_state = 3},
  [220] = {.lex_state = 3, .external_lex_state = 3},
  [221] = {.lex_state = 3, .external_lex_state = 3},
  [222] = {.lex_state = 3, .external_lex_state = 3},
  [223] = {.lex_state = 3, .external_lex_state = 3},
  [224] = {.lex_state = 3, .external_lex_state = 3},
  [225] = {.lex_state = 3, .external_lex_state = 3},
  [226] = {.lex_state = 3, .external_lex_state = 3},
  [227] = {.lex_state = 3, .external_lex_state = 3},
  [228] = {.lex_state = 3, .external_lex_state = 3},
  [229] = {.lex_state = 3, .external_lex_state = 3},
  [230] = {.lex_state = 3, .external_lex_state = 3},
  [231] = {.lex_state = 5, .external_lex_state = 3},
  [232] = {.lex_state = 5, .external_lex_state = 3},
  [233] = {.lex_state = 8},
  [234] = {.lex_state = 8},
  [235] = {.lex_state = 12},
  [236] = {.lex_state = 8},
  [237] = {.lex_state = 8},
  [238] = {.lex_state = 12},
  [239] = {.lex_state = 53},
  [240] = {.lex_state = 1, .external_lex_state = 1},
  [241] = {.lex_state = 3},
  [242] = {.lex_state = 8},
  [243] = {.lex_state = 53},
  [244] = {.lex_state = 8},
  [245] = {.lex_state = 3},
  [246] = {.lex_state = 9},
  [247] = {.lex_state = 9},
  [248] = {.lex_state = 4, .external_lex_state = 3},
  [249] = {.lex_state = 9},
  [250] = {.lex_state = 9},
  [251] = {.lex_state = 9},
  [252] = {.lex_state = 9},
  [253] = {.lex_state = 9},
  [254] = {.lex_state = 9},
  [255] = {.lex_state = 9},
  [256] = {.lex_state = 9},
  [257] = {.lex_state = 9},
  [258] = {.lex_state = 9},
  [259] = {.lex_state = 9},
  [260] = {.lex_state = 9},
  [261] = {.lex_state = 9},
  [262] = {.lex_state = 9},
  [263] = {.lex_state = 9},
  [264] = {.lex_state = 9},
  [265] = {.lex_state = 9},
  [266] = {.lex_state = 9},
  [267] = {.lex_state = 2, .external_lex_state = 1},
  [268] = {.lex_state = 9},
  [269] = {.lex_state = 9},
  [270] = {.lex_state = 9},
  [271] = {.lex_state = 2, .external_lex_state = 1},
  [272] = {.lex_state = 2, .external_lex_state = 1},
  [273] = {.lex_state = 2, .external_lex_state = 1},
  [274] = {.lex_state = 2, .external_lex_state = 1},
  [275] = {.lex_state = 2, .external_lex_state = 1},
  [276] = {.lex_state = 2, .external_lex_state = 1},
  [277] = {.lex_state = 2, .external_lex_state = 1},
  [278] = {.lex_state = 2, .external_lex_state = 1},
  [279] = {.lex_state = 2, .external_lex_state = 1},
  [280] = {.lex_state = 2, .external_lex_state = 1},
  [281] = {.lex_state = 2, .external_lex_state = 1},
  [282] = {.lex_state = 2, .external_lex_state = 1},
  [283] = {.lex_state = 11},
  [284] = {.lex_state = 6},
  [285] = {.lex_state = 18, .external_lex_state = 2},
  [286] = {.lex_state = 18, .external_lex_state = 2},
  [287] = {.lex_state = 18, .external_lex_state = 2},
  [288] = {.lex_state = 18, .external_lex_state = 2},
  [289] = {.lex_state = 18, .external_lex_state = 2},
  [290] = {.lex_state = 52},
  [291] = {.lex_state = 18, .external_lex_state = 2},
  [292] = {.lex_state = 18, .external_lex_state = 2},
  [293] = {.lex_state = 18, .external_lex_state = 2},
  [294] = {.lex_state = 18, .external_lex_state = 2},
  [295] = {.lex_state = 18, .external_lex_state = 2},
  [296] = {.lex_state = 18, .external_lex_state = 2},
  [297] = {.lex_state = 18, .external_lex_state = 2},
  [298] = {.lex_state = 18, .external_lex_state = 2},
  [299] = {.lex_state = 18, .external_lex_state = 2},
  [300] = {.lex_state = 18, .external_lex_state = 2},
  [301] = {.lex_state = 18, .external_lex_state = 2},
  [302] = {.lex_state = 18, .external_lex_state = 2},
  [303] = {.lex_state = 18, .external_lex_state = 2},
  [304] = {.lex_state = 18, .external_lex_state = 2},
  [305] = {.lex_state = 18, .external_lex_state = 2},
  [306] = {.lex_state = 18, .external_lex_state = 2},
  [307] = {.lex_state = 18, .external_lex_state = 2},
  [308] = {.lex_state = 18, .external_lex_state = 2},
  [309] = {.lex_state = 10},
  [310] = {.lex_state = 18, .external_lex_state = 2},
  [311] = {.lex_state = 18, .external_lex_state = 2},
  [312] = {.lex_state = 18, .external_lex_state = 2},
  [313] = {.lex_state = 18, .external_lex_state = 2},
  [314] = {.lex_state = 18, .external_lex_state = 2},
  [315] = {.lex_state = 18, .external_lex_state = 2},
  [316] = {.lex_state = 18, .external_lex_state = 2},
  [317] = {.lex_state = 5, .external_lex_state = 3},
  [318] = {.lex_state = 18, .external_lex_state = 2},
  [319] = {.lex_state = 18, .external_lex_state = 2},
  [320] = {.lex_state = 18, .external_lex_state = 2},
  [321] = {.lex_state = 18, .external_lex_state = 2},
  [322] = {.lex_state = 18, .external_lex_state = 2},
  [323] = {.lex_state = 18, .external_lex_state = 2},
  [324] = {.lex_state = 18, .external_lex_state = 2},
  [325] = {.lex_state = 18, .external_lex_state = 2},
  [326] = {.lex_state = 5, .external_lex_state = 3},
  [327] = {.lex_state = 5, .external_lex_state = 3},
  [328] = {.lex_state = 5, .external_lex_state = 3},
  [329] = {.lex_state = 5, .external_lex_state = 3},
  [330] = {.lex_state = 5, .external_lex_state = 3},
  [331] = {.lex_state = 5, .external_lex_state = 3},
  [332] = {.lex_state = 5, .external_lex_state = 3},
  [333] = {.lex_state = 5, .external_lex_state = 3},
  [334] = {.lex_state = 5, .external_lex_state = 3},
  [335] = {.lex_state = 5, .external_lex_state = 3},
  [336] = {.lex_state = 5, .external_lex_state = 3},
  [337] = {.lex_state = 23, .external_lex_state = 2},
  [338] = {.lex_state = 20, .external_lex_state = 2},
  [339] = {.lex_state = 22, .external_lex_state = 2},
  [340] = {.lex_state = 22, .external_lex_state = 2},
  [341] = {.lex_state = 22, .external_lex_state = 2},
  [342] = {.lex_state = 22, .external_lex_state = 2},
  [343] = {.lex_state = 22, .external_lex_state = 2},
  [344] = {.lex_state = 22, .external_lex_state = 2},
  [345] = {.lex_state = 22, .external_lex_state = 2},
  [346] = {.lex_state = 22, .external_lex_state = 2},
  [347] = {.lex_state = 22, .external_lex_state = 2},
  [348] = {.lex_state = 22, .external_lex_state = 2},
  [349] = {.lex_state = 22, .external_lex_state = 2},
  [350] = {.lex_state = 23, .external_lex_state = 2},
  [351] = {.lex_state = 22, .external_lex_state = 2},
  [352] = {.lex_state = 22, .external_lex_state = 2},
  [353] = {.lex_state = 22, .external_lex_state = 2},
  [354] = {.lex_state = 22, .external_lex_state = 2},
  [355] = {.lex_state = 22, .external_lex_state = 2},
  [356] = {.lex_state = 22, .external_lex_state = 2},
  [357] = {.lex_state = 23, .external_lex_state = 2},
  [358] = {.lex_state = 23, .external_lex_state = 2},
  [359] = {.lex_state = 22, .external_lex_state = 2},
  [360] = {.lex_state = 22, .external_lex_state = 2},
  [361] = {.lex_state = 22, .external_lex_state = 2},
  [362] = {.lex_state = 22, .external_lex_state = 2},
  [363] = {.lex_state = 23, .external_lex_state = 2},
  [364] = {.lex_state = 23, .external_lex_state = 2},
  [365] = {.lex_state = 22, .external_lex_state = 2},
  [366] = {.lex_state = 22, .external_lex_state = 2},
  [367] = {.lex_state = 19, .external_lex_state = 2},
  [368] = {.lex_state = 19, .external_lex_state = 2},
  [369] = {.lex_state = 19, .external_lex_state = 2},
  [370] = {.lex_state = 19, .external_lex_state = 2},
  [371] = {.lex_state = 19, .external_lex_state = 2},
  [372] = {.lex_state = 22, .external_lex_state = 2},
  [373] = {.lex_state = 21, .external_lex_state = 2},
  [374] = {.lex_state = 19, .external_lex_state = 2},
  [375] = {.lex_state = 19, .external_lex_state = 2},
  [376] = {.lex_state = 19, .external_lex_state = 2},
  [377] = {.lex_state = 19, .external_lex_state = 2},
  [378] = {.lex_state = 19, .external_lex_state = 2},
  [379] = {.lex_state = 19, .external_lex_state = 2},
  [380] = {.lex_state = 19, .external_lex_state = 2},
  [381] = {.lex_state = 19, .external_lex_state = 2},
  [382] = {.lex_state = 19, .external_lex_state = 2},
  [383] = {.lex_state = 19, .external_lex_state = 2},
  [384] = {.lex_state = 19, .external_lex_state = 2},
  [385] = {.lex_state = 19, .external_lex_state = 2},
  [386] = {.lex_state = 20, .external_lex_state = 2},
  [387] = {.lex_state = 19, .external_lex_state = 2},
  [388] = {.lex_state = 19, .external_lex_state = 2},
  [389] = {.lex_state = 19, .external_lex_state = 2},
  [390] = {.lex_state = 19, .external_lex_state = 2},
  [391] = {.lex_state = 19, .external_lex_state = 2},
  [392] = {.lex_state = 19, .external_lex_state = 2},
  [393] = {.lex_state = 22, .external_lex_state = 2},
  [394] = {.lex_state = 19, .external_lex_state = 2},
  [395] = {.lex_state = 19, .external_lex_state = 2},
  [396] = {.lex_state = 19, .external_lex_state = 2},
  [397] = {.lex_state = 19, .external_lex_state = 2},
  [398] = {.lex_state = 19, .external_lex_state = 2},
  [399] = {.lex_state = 23, .external_lex_state = 2},
  [400] = {.lex_state = 23, .external_lex_state = 2},
  [401] = {.lex_state = 19, .external_lex_state = 2},
  [402] = {.lex_state = 19, .external_lex_state = 2},
  [403] = {.lex_state = 23, .external_lex_state = 2},
  [404] = {.lex_state = 22, .external_lex_state = 2},
  [405] = {.lex_state = 22, .external_lex_state = 2},
  [406] = {.lex_state = 22, .external_lex_state = 2},
  [407] = {.lex_state = 22, .external_lex_state = 2},
  [408] = {.lex_state = 22, .external_lex_state = 2},
  [409] = {.lex_state = 21, .external_lex_state = 2},
  [410] = {.lex_state = 21, .external_lex_state = 2},
  [411] = {.lex_state = 23, .external_lex_state = 2},
  [412] = {.lex_state = 23, .external_lex_state = 2},
  [413] = {.lex_state = 21, .external_lex_state = 2},
  [414] = {.lex_state = 21, .external_lex_state = 2},
  [415] = {.lex_state = 21, .external_lex_state = 2},
  [416] = {.lex_state = 21, .external_lex_state = 2},
  [417] = {.lex_state = 20, .external_lex_state = 2},
  [418] = {.lex_state = 21, .external_lex_state = 2},
  [419] = {.lex_state = 21, .external_lex_state = 2},
  [420] = {.lex_state = 21, .external_lex_state = 2},
  [421] = {.lex_state = 21, .external_lex_state = 2},
  [422] = {.lex_state = 21, .external_lex_state = 2},
  [423] = {.lex_state = 21, .external_lex_state = 2},
  [424] = {.lex_state = 22, .external_lex_state = 2},
  [425] = {.lex_state = 21, .external_lex_state = 2},
  [426] = {.lex_state = 19, .external_lex_state = 2},
  [427] = {.lex_state = 21, .external_lex_state = 2},
  [428] = {.lex_state = 23, .external_lex_state = 2},
  [429] = {.lex_state = 21, .external_lex_state = 2},
  [430] = {.lex_state = 21, .external_lex_state = 2},
  [431] = {.lex_state = 21, .external_lex_state = 2},
  [432] = {.lex_state = 23, .external_lex_state = 2},
  [433] = {.lex_state = 21, .external_lex_state = 2},
  [434] = {.lex_state = 23, .external_lex_state = 2},
  [435] = {.lex_state = 21, .external_lex_state = 2},
  [436] = {.lex_state = 23, .external_lex_state = 2},
  [437] = {.lex_state = 21, .external_lex_state = 2},
  [438] = {.lex_state = 21, .external_lex_state = 2},
  [439] = {.lex_state = 23, .external_lex_state = 2},
  [440] = {.lex_state = 23, .external_lex_state = 2},
  [441] = {.lex_state = 21, .external_lex_state = 2},
  [442] = {.lex_state = 23, .external_lex_state = 2},
  [443] = {.lex_state = 21, .external_lex_state = 2},
  [444] = {.lex_state = 21, .external_lex_state = 2},
  [445] = {.lex_state = 20, .external_lex_state = 2},
  [446] = {.lex_state = 21, .external_lex_state = 2},
  [447] = {.lex_state = 22, .external_lex_state = 2},
  [448] = {.lex_state = 19, .external_lex_state = 2},
  [449] = {.lex_state = 21, .external_lex_state = 2},
  [450] = {.lex_state = 23, .external_lex_state = 2},
  [451] = {.lex_state = 23, .external_lex_state = 2},
  [452] = {.lex_state = 21, .external_lex_state = 2},
  [453] = {.lex_state = 21, .external_lex_state = 2},
  [454] = {.lex_state = 21, .external_lex_state = 2},
  [455] = {.lex_state = 21, .external_lex_state = 2},
  [456] = {.lex_state = 21, .external_lex_state = 2},
  [457] = {.lex_state = 20, .external_lex_state = 2},
  [458] = {.lex_state = 20, .external_lex_state = 2},
  [459] = {.lex_state = 23, .external_lex_state = 2},
  [460] = {.lex_state = 23, .external_lex_state = 2},
  [461] = {.lex_state = 20, .external_lex_state = 2},
  [462] = {.lex_state = 20, .external_lex_state = 2},
  [463] = {.lex_state = 20, .external_lex_state = 2},
  [464] = {.lex_state = 20, .external_lex_state = 2},
  [465] = {.lex_state = 23, .external_lex_state = 2},
  [466] = {.lex_state = 23, .external_lex_state = 2},
  [467] = {.lex_state = 23, .external_lex_state = 2},
  [468] = {.lex_state = 20, .external_lex_state = 2},
  [469] = {.lex_state = 23, .external_lex_state = 2},
  [470] = {.lex_state = 20, .external_lex_state = 2},
  [471] = {.lex_state = 20, .external_lex_state = 2},
  [472] = {.lex_state = 20, .external_lex_state = 2},
  [473] = {.lex_state = 23, .external_lex_state = 2},
  [474] = {.lex_state = 20, .external_lex_state = 2},
  [475] = {.lex_state = 23, .external_lex_state = 2},
  [476] = {.lex_state = 20, .external_lex_state = 2},
  [477] = {.lex_state = 7, .external_lex_state = 3},
  [478] = {.lex_state = 23, .external_lex_state = 2},
  [479] = {.lex_state = 20, .external_lex_state = 2},
  [480] = {.lex_state = 20, .external_lex_state = 2},
  [481] = {.lex_state = 20, .external_lex_state = 2},
  [482] = {.lex_state = 20, .external_lex_state = 2},
  [483] = {.lex_state = 20, .external_lex_state = 2},
  [484] = {.lex_state = 20, .external_lex_state = 2},
  [485] = {.lex_state = 20, .external_lex_state = 2},
  [486] = {.lex_state = 20, .external_lex_state = 2},
  [487] = {.lex_state = 20, .external_lex_state = 2},
  [488] = {.lex_state = 20, .external_lex_state = 2},
  [489] = {.lex_state = 20, .external_lex_state = 2},
  [490] = {.lex_state = 20, .external_lex_state = 2},
  [491] = {.lex_state = 20, .external_lex_state = 2},
  [492] = {.lex_state = 12},
  [493] = {.lex_state = 20, .external_lex_state = 2},
  [494] = {.lex_state = 20, .external_lex_state = 2},
  [495] = {.lex_state = 20, .external_lex_state = 2},
  [496] = {.lex_state = 12},
  [497] = {.lex_state = 12},
  [498] = {.lex_state = 12},
  [499] = {.lex_state = 3},
  [500] = {.lex_state = 53},
  [501] = {.lex_state = 12},
  [502] = {.lex_state = 12},
  [503] = {.lex_state = 12},
  [504] = {.lex_state = 8},
  [505] = {.lex_state = 12},
  [506] = {.lex_state = 9},
  [507] = {.lex_state = 53},
  [508] = {.lex_state = 9},
  [509] = {.lex_state = 9},
  [510] = {.lex_state = 8},
  [511] = {.lex_state = 8},
  [512] = {.lex_state = 8},
  [513] = {.lex_state = 8},
  [514] = {.lex_state = 53},
  [515] = {.lex_state = 53},
  [516] = {.lex_state = 3},
  [517] = {.lex_state = 8},
  [518] = {.lex_state = 3},
  [519] = {.lex_state = 53},
  [520] = {.lex_state = 8},
  [521] = {.lex_state = 53},
  [522] = {.lex_state = 3},
  [523] = {.lex_state = 8},
  [524] = {.lex_state = 3},
  [525] = {.lex_state = 9},
  [526] = {.lex_state = 3},
  [527] = {.lex_state = 3},
  [528] = {.lex_state = 53},
  [529] = {.lex_state = 9},
  [530] = {.lex_state = 3},
  [531] = {.lex_state = 53},
  [532] = {.lex_state = 9},
  [533] = {.lex_state = 9},
  [534] = {.lex_state = 9},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 9},
  [537] = {.lex_state = 9},
  [538] = {.lex_state = 9},
  [539] = {.lex_state = 9},
  [540] = {.lex_state = 9},
  [541] = {.lex_state = 9},
  [542] = {.lex_state = 9},
  [543] = {.lex_state = 9},
  [544] = {.lex_state = 9},
  [545] = {.lex_state = 9},
  [546] = {.lex_state = 9},
  [547] = {.lex_state = 9},
  [548] = {.lex_state = 9},
  [549] = {.lex_state = 9},
  [550] = {.lex_state = 9},
  [551] = {.lex_state = 9},
  [552] = {.lex_state = 9},
  [553] = {.lex_state = 9},
  [554] = {.lex_state = 9},
  [555] = {.lex_state = 9},
  [556] = {.lex_state = 9},
  [557] = {.lex_state = 9},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 9},
  [560] = {.lex_state = 9},
  [561] = {.lex_state = 9},
  [562] = {.lex_state = 9},
  [563] = {.lex_state = 9},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 9},
  [566] = {.lex_state = 9},
  [567] = {.lex_state = 9},
  [568] = {.lex_state = 9},
  [569] = {.lex_state = 9},
  [570] = {.lex_state = 9},
  [571] = {.lex_state = 9},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 9},
  [574] = {.lex_state = 9},
  [575] = {.lex_state = 9},
  [576] = {.lex_state = 9},
  [577] = {.lex_state = 9},
  [578] = {.lex_state = 9},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 9},
  [581] = {.lex_state = 9},
  [582] = {.lex_state = 9},
  [583] = {.lex_state = 9},
  [584] = {.lex_state = 9},
  [585] = {.lex_state = 9},
  [586] = {.lex_state = 9},
  [587] = {.lex_state = 9},
  [588] = {.lex_state = 9},
  [589] = {.lex_state = 9},
  [590] = {.lex_state = 9},
  [591] = {.lex_state = 9},
  [592] = {.lex_state = 9},
  [593] = {.lex_state = 9},
  [594] = {.lex_state = 9},
  [595] = {.lex_state = 9},
  [596] = {.lex_state = 9},
  [597] = {.lex_state = 9},
  [598] = {.lex_state = 9},
  [599] = {.lex_state = 9},
  [600] = {.lex_state = 9},
  [601] = {.lex_state = 9},
  [602] = {.lex_state = 9},
  [603] = {.lex_state = 9},
  [604] = {.lex_state = 9},
  [605] = {.lex_state = 9},
  [606] = {.lex_state = 9},
  [607] = {.lex_state = 9},
  [608] = {.lex_state = 9},
  [609] = {.lex_state = 9},
  [610] = {.lex_state = 9},
  [611] = {.lex_state = 9},
  [612] = {.lex_state = 9},
  [613] = {.lex_state = 9},
  [614] = {.lex_state = 9},
  [615] = {.lex_state = 9},
  [616] = {.lex_state = 9},
  [617] = {.lex_state = 9},
  [618] = {.lex_state = 9},
  [619] = {.lex_state = 9},
  [620] = {.lex_state = 9},
  [621] = {.lex_state = 9},
  [622] = {.lex_state = 9},
  [623] = {.lex_state = 9},
  [624] = {.lex_state = 54},
  [625] = {.lex_state = 54},
  [626] = {.lex_state = 54},
  [627] = {.lex_state = 54},
  [628] = {.lex_state = 54},
  [629] = {.lex_state = 54},
  [630] = {.lex_state = 54},
  [631] = {.lex_state = 54},
  [632] = {.lex_state = 54},
  [633] = {.lex_state = 54},
  [634] = {.lex_state = 54},
  [635] = {.lex_state = 54},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 55},
  [638] = {.lex_state = 55},
  [639] = {.lex_state = 23},
  [640] = {.lex_state = 23},
  [641] = {.lex_state = 23},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 55},
  [645] = {.lex_state = 55},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 23},
  [648] = {.lex_state = 23},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 23},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 23},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 55},
  [662] = {.lex_state = 55},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 23},
  [666] = {.lex_state = 23},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 23},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 23},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 23},
  [674] = {.lex_state = 23},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 55},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 55},
  [679] = {.lex_state = 55},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 55},
  [682] = {.lex_state = 23},
  [683] = {.lex_state = 23},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 55},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 55},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 23},
  [694] = {.lex_state = 23},
  [695] = {.lex_state = 55},
  [696] = {.lex_state = 55},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 23},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 23},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 23},
  [715] = {.lex_state = 23},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 55},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
};

enum {
  ts_external_token_bracket_argument = 0,
  ts_external_token_bracket_comment = 1,
  ts_external_token_line_comment = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_bracket_argument] = sym_bracket_argument,
  [ts_external_token_bracket_comment] = sym_bracket_comment,
  [ts_external_token_line_comment] = sym_line_comment,
};

static const bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_bracket_argument] = true,
    [ts_external_token_bracket_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [2] = {
    [ts_external_token_bracket_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [3] = {
    [ts_external_token_bracket_argument] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__escape_identity] = ACTIONS(1),
    [anon_sym_BSLASHt] = ACTIONS(1),
    [anon_sym_BSLASHr] = ACTIONS(1),
    [anon_sym_BSLASHn] = ACTIONS(1),
    [sym__escape_semicolon] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_ENV] = ACTIONS(1),
    [anon_sym_CACHE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [aux_sym__gen_exp_arguments_token1] = ACTIONS(1),
    [aux_sym__untrimmed_argument_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [aux_sym__unquoted_text_token1] = ACTIONS(1),
    [aux_sym_if_command_token1] = ACTIONS(1),
    [sym_bracket_argument] = ACTIONS(1),
    [sym_bracket_comment] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(710),
    [sym_if_command] = STATE(129),
    [sym_if_condition] = STATE(197),
    [sym_foreach_command] = STATE(154),
    [sym_foreach_loop] = STATE(197),
    [sym_while_command] = STATE(156),
    [sym_while_loop] = STATE(197),
    [sym_function_command] = STATE(158),
    [sym_function_def] = STATE(197),
    [sym_macro_command] = STATE(159),
    [sym_macro_def] = STATE(197),
    [sym_normal_command] = STATE(197),
    [sym__command_invocation] = STATE(197),
    [sym__untrimmed_command_invocation] = STATE(197),
    [aux_sym_source_file_repeat1] = STATE(197),
    [ts_builtin_sym_end] = ACTIONS(3),
    [aux_sym__untrimmed_argument_token1] = ACTIONS(5),
    [sym_if] = ACTIONS(7),
    [sym_foreach] = ACTIONS(9),
    [sym_while] = ACTIONS(11),
    [sym_function] = ACTIONS(13),
    [sym_macro] = ACTIONS(15),
    [sym_identifier] = ACTIONS(17),
    [sym_bracket_comment] = ACTIONS(5),
    [sym_line_comment] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_RPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [57] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(37), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(35), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(9), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [114] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(41), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(39), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(5), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [171] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(37), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [228] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(45), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(43), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(10), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [285] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(49), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(12), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [342] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(53), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(51), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(14), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [399] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(55), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [456] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(57), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [513] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(57), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(59), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(18), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [570] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(61), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [627] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(61), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(63), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(20), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [684] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [741] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(69), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(67), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(52), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [798] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(71), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(22), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [855] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(73), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(57), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [912] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [969] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(60), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1026] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1083] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(87), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(85), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(63), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1140] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(89), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1197] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(93), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(91), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(66), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1254] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(97), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(95), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(26), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1311] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(101), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(99), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(69), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1368] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1425] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(105), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(31), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1482] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(107), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(32), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1539] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(111), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(34), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1596] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(117), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(115), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(36), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1653] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1710] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(121), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1767] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(121), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(123), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(38), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1824] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(125), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1881] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(125), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(127), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(39), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1938] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(129), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1995] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(129), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(131), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(40), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2052] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2109] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2166] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2223] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(139), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(42), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2280] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(143), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2337] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(143), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(145), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(47), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2394] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(149), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(147), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(49), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2451] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(153), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(151), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(51), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2508] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(155), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(55), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2565] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2622] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(161), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(96), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2679] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(165), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2736] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(165), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(167), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(59), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2793] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(169), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2850] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(171), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2907] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(169), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(173), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(78), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2964] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(171), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(175), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(105), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3021] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(177), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3078] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(177), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(179), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(79), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3135] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3192] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(183), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(107), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3249] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(185), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3306] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(187), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3363] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(187), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(189), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(109), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3420] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(191), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3477] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(193), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3534] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(193), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(195), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(111), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3591] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(197), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3648] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(199), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3705] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(199), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(201), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(113), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3762] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(203), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3819] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(205), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3876] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(205), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(207), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3933] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(211), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(209), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(117), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3990] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(215), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(213), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(62), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4047] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(219), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(217), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(120), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4104] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(215), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4161] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(223), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(221), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(123), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4218] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(227), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(225), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(65), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4275] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(227), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4332] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4389] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4446] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(235), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(233), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(89), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4503] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(239), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(237), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(68), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4560] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(239), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4617] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(241), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4674] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(245), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(243), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(74), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4731] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(249), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(247), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(127), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4788] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(251), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4845] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(255), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(253), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(77), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4902] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(259), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(257), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(122), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4959] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(261), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5016] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(265), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(263), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(82), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5073] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(261), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(267), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(101), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5130] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(271), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(269), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(83), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5187] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(271), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5244] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(275), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(273), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(103), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5301] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(279), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(277), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(106), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5358] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(281), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5415] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(283), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5472] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(287), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(285), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(110), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5529] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(289), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5586] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(291), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5643] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(293), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5700] = 13,
    ACTIONS(298), 1,
      anon_sym_DOLLAR,
    ACTIONS(304), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    ACTIONS(309), 1,
      anon_sym_DQUOTE,
    ACTIONS(312), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(315), 1,
      sym_bracket_argument,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(301), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(295), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5757] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(318), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5814] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(318), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(320), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(116), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5871] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(322), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5928] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(324), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5985] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(326), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6042] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(324), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(328), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(125), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6099] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(330), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6156] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(332), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6213] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(334), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6270] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(332), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(336), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(128), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6327] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(338), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6384] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(342), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(340), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(93), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6441] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(344), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6498] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(346), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6555] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(348), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6612] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(348), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(350), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(100), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6669] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(354), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(352), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(2), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6726] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(356), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6783] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(356), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(358), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6840] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(354), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6897] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(360), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6954] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(360), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(362), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(97), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7011] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(364), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7068] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(368), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(366), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(86), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7125] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(368), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7182] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(370), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(277), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7239] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(378), 1,
      sym_endif,
    ACTIONS(380), 1,
      sym_identifier,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(350), 1,
      sym_endif_command,
    ACTIONS(372), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(135), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7303] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(384), 1,
      sym_endif,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(319), 1,
      sym_endif_command,
    ACTIONS(382), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(139), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7367] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(388), 1,
      sym_endif,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(375), 1,
      sym_endif_command,
    ACTIONS(386), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7431] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(392), 1,
      sym_endif,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(456), 1,
      sym_endif_command,
    ACTIONS(390), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(133), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7495] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(392), 1,
      sym_endif,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(444), 1,
      sym_endif_command,
    ACTIONS(386), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7559] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(396), 1,
      sym_endif,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(408), 1,
      sym_endif_command,
    ACTIONS(394), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(136), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7623] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(378), 1,
      sym_endif,
    ACTIONS(380), 1,
      sym_identifier,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(400), 1,
      sym_endif_command,
    ACTIONS(386), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7687] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(396), 1,
      sym_endif,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(339), 1,
      sym_endif_command,
    ACTIONS(386), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7751] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(398), 1,
      sym_endif,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(489), 1,
      sym_endif_command,
    ACTIONS(386), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7815] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(388), 1,
      sym_endif,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(367), 1,
      sym_endif_command,
    ACTIONS(400), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(131), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7879] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(384), 1,
      sym_endif,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(305), 1,
      sym_endif_command,
    ACTIONS(386), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7943] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(398), 1,
      sym_endif,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    STATE(480), 1,
      sym_endif_command,
    ACTIONS(402), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(137), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [8007] = 16,
    ACTIONS(407), 1,
      sym_if,
    ACTIONS(410), 1,
      sym_elseif,
    ACTIONS(413), 1,
      sym_else,
    ACTIONS(416), 1,
      sym_endif,
    ACTIONS(418), 1,
      sym_foreach,
    ACTIONS(421), 1,
      sym_while,
    ACTIONS(424), 1,
      sym_function,
    ACTIONS(427), 1,
      sym_macro,
    ACTIONS(430), 1,
      sym_identifier,
    STATE(130), 1,
      sym_if_command,
    STATE(144), 1,
      sym_macro_command,
    STATE(176), 1,
      sym_function_command,
    STATE(180), 1,
      sym_while_command,
    STATE(188), 1,
      sym_foreach_command,
    ACTIONS(404), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [8068] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(435), 1,
      sym_endmacro,
    ACTIONS(437), 1,
      sym_identifier,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(343), 1,
      sym_endmacro_command,
    ACTIONS(433), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(203), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8124] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(441), 1,
      sym_endforeach,
    ACTIONS(443), 1,
      sym_identifier,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(340), 1,
      sym_endforeach_command,
    ACTIONS(439), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(199), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8180] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(437), 1,
      sym_identifier,
    ACTIONS(447), 1,
      sym_endmacro,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(324), 1,
      sym_endmacro_command,
    ACTIONS(445), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(149), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8236] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(449), 1,
      sym_endforeach,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(376), 1,
      sym_endforeach_command,
    ACTIONS(439), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(199), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8292] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(453), 1,
      sym_endwhile,
    ACTIONS(455), 1,
      sym_identifier,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(377), 1,
      sym_endwhile_command,
    ACTIONS(451), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(202), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8348] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(457), 1,
      sym_endforeach,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(297), 1,
      sym_endforeach_command,
    ACTIONS(439), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(199), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8404] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(461), 1,
      sym_endfunction,
    ACTIONS(463), 1,
      sym_identifier,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(299), 1,
      sym_endfunction_command,
    ACTIONS(459), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(196), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8460] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(437), 1,
      sym_identifier,
    ACTIONS(447), 1,
      sym_endmacro,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(320), 1,
      sym_endmacro_command,
    ACTIONS(433), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(203), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8516] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(463), 1,
      sym_identifier,
    ACTIONS(465), 1,
      sym_endfunction,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(378), 1,
      sym_endfunction_command,
    ACTIONS(459), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(196), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8572] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(453), 1,
      sym_endwhile,
    ACTIONS(455), 1,
      sym_identifier,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(369), 1,
      sym_endwhile_command,
    ACTIONS(467), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(146), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8628] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(437), 1,
      sym_identifier,
    ACTIONS(469), 1,
      sym_endmacro,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(412), 1,
      sym_endmacro_command,
    ACTIONS(433), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(203), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8684] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(437), 1,
      sym_identifier,
    ACTIONS(471), 1,
      sym_endmacro,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(437), 1,
      sym_endmacro_command,
    ACTIONS(433), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(203), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8740] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(475), 1,
      sym_endforeach,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(357), 1,
      sym_endforeach_command,
    ACTIONS(473), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(181), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8796] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(463), 1,
      sym_identifier,
    ACTIONS(477), 1,
      sym_endfunction,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(438), 1,
      sym_endfunction_command,
    ACTIONS(459), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(196), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8852] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(455), 1,
      sym_identifier,
    ACTIONS(481), 1,
      sym_endwhile,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(358), 1,
      sym_endwhile_command,
    ACTIONS(479), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(185), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8908] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(455), 1,
      sym_identifier,
    ACTIONS(483), 1,
      sym_endwhile,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(441), 1,
      sym_endwhile_command,
    ACTIONS(451), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(202), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8964] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(463), 1,
      sym_identifier,
    ACTIONS(487), 1,
      sym_endfunction,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(363), 1,
      sym_endfunction_command,
    ACTIONS(485), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(186), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9020] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(437), 1,
      sym_identifier,
    ACTIONS(469), 1,
      sym_endmacro,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(364), 1,
      sym_endmacro_command,
    ACTIONS(489), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(152), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9076] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(491), 1,
      sym_endforeach,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(443), 1,
      sym_endforeach_command,
    ACTIONS(439), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(199), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9132] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(437), 1,
      sym_identifier,
    ACTIONS(493), 1,
      sym_endmacro,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(379), 1,
      sym_endmacro_command,
    ACTIONS(433), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(203), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9188] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(497), 1,
      sym_endforeach,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(481), 1,
      sym_endforeach_command,
    ACTIONS(495), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(170), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9244] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(463), 1,
      sym_identifier,
    ACTIONS(465), 1,
      sym_endfunction,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(370), 1,
      sym_endfunction_command,
    ACTIONS(499), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(150), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9300] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(455), 1,
      sym_identifier,
    ACTIONS(503), 1,
      sym_endwhile,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(483), 1,
      sym_endwhile_command,
    ACTIONS(501), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(171), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9356] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(437), 1,
      sym_identifier,
    ACTIONS(471), 1,
      sym_endmacro,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(452), 1,
      sym_endmacro_command,
    ACTIONS(505), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(153), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9412] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(463), 1,
      sym_identifier,
    ACTIONS(509), 1,
      sym_endfunction,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(486), 1,
      sym_endfunction_command,
    ACTIONS(507), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(174), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9468] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(437), 1,
      sym_identifier,
    ACTIONS(513), 1,
      sym_endmacro,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(487), 1,
      sym_endmacro_command,
    ACTIONS(511), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(177), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9524] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(463), 1,
      sym_identifier,
    ACTIONS(477), 1,
      sym_endfunction,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(453), 1,
      sym_endfunction_command,
    ACTIONS(515), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(155), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9580] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(455), 1,
      sym_identifier,
    ACTIONS(517), 1,
      sym_endwhile,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(289), 1,
      sym_endwhile_command,
    ACTIONS(451), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(202), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9636] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(497), 1,
      sym_endforeach,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(491), 1,
      sym_endforeach_command,
    ACTIONS(439), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(199), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9692] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(455), 1,
      sym_identifier,
    ACTIONS(503), 1,
      sym_endwhile,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(493), 1,
      sym_endwhile_command,
    ACTIONS(451), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(202), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9748] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(463), 1,
      sym_identifier,
    ACTIONS(519), 1,
      sym_endfunction,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(342), 1,
      sym_endfunction_command,
    ACTIONS(459), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(196), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9804] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(455), 1,
      sym_identifier,
    ACTIONS(521), 1,
      sym_endwhile,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(341), 1,
      sym_endwhile_command,
    ACTIONS(451), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(202), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9860] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(463), 1,
      sym_identifier,
    ACTIONS(509), 1,
      sym_endfunction,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(495), 1,
      sym_endfunction_command,
    ACTIONS(459), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(196), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9916] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(437), 1,
      sym_identifier,
    ACTIONS(493), 1,
      sym_endmacro,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(371), 1,
      sym_endmacro_command,
    ACTIONS(523), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(161), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9972] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(461), 1,
      sym_endfunction,
    ACTIONS(463), 1,
      sym_identifier,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(323), 1,
      sym_endfunction_command,
    ACTIONS(525), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(148), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10028] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(437), 1,
      sym_identifier,
    ACTIONS(513), 1,
      sym_endmacro,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(494), 1,
      sym_endmacro_command,
    ACTIONS(433), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(203), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10084] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(455), 1,
      sym_identifier,
    ACTIONS(483), 1,
      sym_endwhile,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(454), 1,
      sym_endwhile_command,
    ACTIONS(527), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(157), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10140] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(449), 1,
      sym_endforeach,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(368), 1,
      sym_endforeach_command,
    ACTIONS(529), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(145), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10196] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(455), 1,
      sym_identifier,
    ACTIONS(517), 1,
      sym_endwhile,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(322), 1,
      sym_endwhile_command,
    ACTIONS(531), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(169), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10252] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(475), 1,
      sym_endforeach,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(439), 1,
      sym_endforeach_command,
    ACTIONS(439), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(199), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10308] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(435), 1,
      sym_endmacro,
    ACTIONS(437), 1,
      sym_identifier,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    STATE(404), 1,
      sym_endmacro_command,
    ACTIONS(533), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(142), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10364] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(463), 1,
      sym_identifier,
    ACTIONS(519), 1,
      sym_endfunction,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(405), 1,
      sym_endfunction_command,
    ACTIONS(535), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(172), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10420] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(455), 1,
      sym_identifier,
    ACTIONS(521), 1,
      sym_endwhile,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(406), 1,
      sym_endwhile_command,
    ACTIONS(537), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(173), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10476] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(455), 1,
      sym_identifier,
    ACTIONS(481), 1,
      sym_endwhile,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    STATE(403), 1,
      sym_endwhile_command,
    ACTIONS(451), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(202), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10532] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(463), 1,
      sym_identifier,
    ACTIONS(487), 1,
      sym_endfunction,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    STATE(411), 1,
      sym_endfunction_command,
    ACTIONS(459), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(196), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10588] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(491), 1,
      sym_endforeach,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(455), 1,
      sym_endforeach_command,
    ACTIONS(539), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(160), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10644] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(443), 1,
      sym_identifier,
    ACTIONS(457), 1,
      sym_endforeach,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(321), 1,
      sym_endforeach_command,
    ACTIONS(541), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(147), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10700] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(441), 1,
      sym_endforeach,
    ACTIONS(443), 1,
      sym_identifier,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    STATE(407), 1,
      sym_endforeach_command,
    ACTIONS(543), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(143), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10756] = 12,
    ACTIONS(547), 1,
      anon_sym_DOLLAR,
    ACTIONS(549), 1,
      anon_sym_GT,
    ACTIONS(551), 1,
      anon_sym_DQUOTE,
    ACTIONS(553), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(555), 1,
      sym_bracket_argument,
    STATE(192), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(330), 1,
      sym__escape_encoded,
    STATE(331), 1,
      sym_argument,
    STATE(336), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(329), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(545), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(232), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10805] = 12,
    ACTIONS(559), 1,
      anon_sym_DOLLAR,
    ACTIONS(561), 1,
      anon_sym_GT,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(565), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(567), 1,
      sym_bracket_argument,
    STATE(496), 1,
      sym__escape_encoded,
    STATE(558), 1,
      sym_argument,
    STATE(707), 1,
      sym__gen_exp_content,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(503), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(557), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(235), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10854] = 12,
    ACTIONS(572), 1,
      anon_sym_DOLLAR,
    ACTIONS(575), 1,
      anon_sym_GT,
    ACTIONS(577), 1,
      anon_sym_DQUOTE,
    ACTIONS(580), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(583), 1,
      sym_bracket_argument,
    STATE(192), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(330), 1,
      sym__escape_encoded,
    STATE(331), 1,
      sym_argument,
    STATE(336), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(329), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(232), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10903] = 12,
    ACTIONS(547), 1,
      anon_sym_DOLLAR,
    ACTIONS(551), 1,
      anon_sym_DQUOTE,
    ACTIONS(553), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(555), 1,
      sym_bracket_argument,
    ACTIONS(586), 1,
      anon_sym_GT,
    STATE(190), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(330), 1,
      sym__escape_encoded,
    STATE(331), 1,
      sym_argument,
    STATE(336), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(329), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(545), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(232), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10952] = 12,
    ACTIONS(559), 1,
      anon_sym_DOLLAR,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(565), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(588), 1,
      anon_sym_GT,
    STATE(496), 1,
      sym__escape_encoded,
    STATE(558), 1,
      sym_argument,
    STATE(650), 1,
      sym__gen_exp_content,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(503), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(557), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(235), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11001] = 12,
    ACTIONS(559), 1,
      anon_sym_DOLLAR,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(565), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(590), 1,
      anon_sym_GT,
    STATE(496), 1,
      sym__escape_encoded,
    STATE(558), 1,
      sym_argument,
    STATE(672), 1,
      sym__gen_exp_content,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(503), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(557), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(235), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11050] = 14,
    ACTIONS(595), 1,
      sym_if,
    ACTIONS(598), 1,
      sym_foreach,
    ACTIONS(601), 1,
      sym_while,
    ACTIONS(604), 1,
      sym_function,
    ACTIONS(607), 1,
      sym_endfunction,
    ACTIONS(609), 1,
      sym_macro,
    ACTIONS(612), 1,
      sym_identifier,
    STATE(134), 1,
      sym_if_command,
    STATE(182), 1,
      sym_macro_command,
    STATE(183), 1,
      sym_function_command,
    STATE(184), 1,
      sym_while_command,
    STATE(189), 1,
      sym_foreach_command,
    ACTIONS(592), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(196), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11103] = 14,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_identifier,
    ACTIONS(615), 1,
      ts_builtin_sym_end,
    STATE(129), 1,
      sym_if_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(156), 1,
      sym_while_command,
    STATE(158), 1,
      sym_function_command,
    STATE(159), 1,
      sym_macro_command,
    ACTIONS(617), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(204), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11156] = 12,
    ACTIONS(559), 1,
      anon_sym_DOLLAR,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(565), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(619), 1,
      anon_sym_GT,
    STATE(496), 1,
      sym__escape_encoded,
    STATE(558), 1,
      sym_argument,
    STATE(670), 1,
      sym__gen_exp_content,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(503), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(557), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(235), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11205] = 14,
    ACTIONS(595), 1,
      sym_if,
    ACTIONS(598), 1,
      sym_foreach,
    ACTIONS(601), 1,
      sym_while,
    ACTIONS(604), 1,
      sym_function,
    ACTIONS(607), 1,
      sym_endforeach,
    ACTIONS(609), 1,
      sym_macro,
    ACTIONS(624), 1,
      sym_identifier,
    STATE(140), 1,
      sym_if_command,
    STATE(162), 1,
      sym_foreach_command,
    STATE(164), 1,
      sym_while_command,
    STATE(166), 1,
      sym_function_command,
    STATE(167), 1,
      sym_macro_command,
    ACTIONS(621), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(199), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11258] = 7,
    ACTIONS(630), 1,
      anon_sym_DOLLAR,
    ACTIONS(635), 1,
      aux_sym__unquoted_text_token1,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(627), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(200), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(633), 7,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11297] = 12,
    ACTIONS(559), 1,
      anon_sym_DOLLAR,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(565), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(638), 1,
      anon_sym_GT,
    STATE(496), 1,
      sym__escape_encoded,
    STATE(558), 1,
      sym_argument,
    STATE(660), 1,
      sym__gen_exp_content,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(503), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(557), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(235), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11346] = 14,
    ACTIONS(595), 1,
      sym_if,
    ACTIONS(598), 1,
      sym_foreach,
    ACTIONS(601), 1,
      sym_while,
    ACTIONS(604), 1,
      sym_function,
    ACTIONS(607), 1,
      sym_endwhile,
    ACTIONS(609), 1,
      sym_macro,
    ACTIONS(643), 1,
      sym_identifier,
    STATE(132), 1,
      sym_if_command,
    STATE(165), 1,
      sym_macro_command,
    STATE(168), 1,
      sym_function_command,
    STATE(178), 1,
      sym_while_command,
    STATE(187), 1,
      sym_foreach_command,
    ACTIONS(640), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(202), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11399] = 14,
    ACTIONS(595), 1,
      sym_if,
    ACTIONS(598), 1,
      sym_foreach,
    ACTIONS(601), 1,
      sym_while,
    ACTIONS(604), 1,
      sym_function,
    ACTIONS(607), 1,
      sym_endmacro,
    ACTIONS(609), 1,
      sym_macro,
    ACTIONS(649), 1,
      sym_identifier,
    STATE(138), 1,
      sym_if_command,
    STATE(151), 1,
      sym_while_command,
    STATE(163), 1,
      sym_function_command,
    STATE(175), 1,
      sym_macro_command,
    STATE(179), 1,
      sym_foreach_command,
    ACTIONS(646), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(203), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11452] = 14,
    ACTIONS(595), 1,
      sym_if,
    ACTIONS(598), 1,
      sym_foreach,
    ACTIONS(601), 1,
      sym_while,
    ACTIONS(604), 1,
      sym_function,
    ACTIONS(609), 1,
      sym_macro,
    ACTIONS(652), 1,
      ts_builtin_sym_end,
    ACTIONS(657), 1,
      sym_identifier,
    STATE(129), 1,
      sym_if_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(156), 1,
      sym_while_command,
    STATE(158), 1,
      sym_function_command,
    STATE(159), 1,
      sym_macro_command,
    ACTIONS(654), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(204), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11505] = 7,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(662), 1,
      aux_sym__unquoted_text_token1,
    STATE(274), 1,
      sym__escape_encoded,
    STATE(276), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(19), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(200), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(660), 7,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11544] = 12,
    ACTIONS(559), 1,
      anon_sym_DOLLAR,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(565), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(664), 1,
      anon_sym_GT,
    STATE(496), 1,
      sym__escape_encoded,
    STATE(558), 1,
      sym_argument,
    STATE(698), 1,
      sym__gen_exp_content,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(503), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(557), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(235), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11593] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(670), 1,
      anon_sym_RPAREN,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(649), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11639] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(674), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(667), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11685] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(676), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(711), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11731] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(678), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(702), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11777] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(680), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(688), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11823] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(682), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(652), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11869] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(684), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(680), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11915] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(686), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(675), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11961] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(688), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(658), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12007] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(690), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(668), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12053] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(692), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(657), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12099] = 11,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    ACTIONS(567), 1,
      sym_bracket_argument,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(694), 1,
      anon_sym_RPAREN,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(697), 1,
      sym_argument,
    STATE(535), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(245), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12145] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(644), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12188] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(681), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12231] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(661), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12274] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(645), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12317] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(696), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12360] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(679), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12403] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(662), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12446] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(695), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12489] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(638), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12532] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(637), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12575] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(686), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12618] = 10,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(704), 1,
      sym_bracket_argument,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(678), 1,
      sym_argument,
    STATE(718), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12661] = 8,
    ACTIONS(709), 1,
      anon_sym_DOLLAR,
    ACTIONS(712), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(714), 1,
      aux_sym__unquoted_text_token1,
    STATE(330), 1,
      sym__escape_encoded,
    ACTIONS(633), 3,
      sym_bracket_argument,
      anon_sym_GT,
      anon_sym_DQUOTE,
    STATE(329), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(706), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(231), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12699] = 8,
    ACTIONS(547), 1,
      anon_sym_DOLLAR,
    ACTIONS(717), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(719), 1,
      aux_sym__unquoted_text_token1,
    STATE(330), 1,
      sym__escape_encoded,
    ACTIONS(660), 3,
      sym_bracket_argument,
      anon_sym_GT,
      anon_sym_DQUOTE,
    STATE(329), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(545), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(231), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12737] = 8,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(725), 1,
      anon_sym_DQUOTE,
    ACTIONS(727), 1,
      aux_sym__quoted_text_token1,
    STATE(523), 1,
      sym__escape_encoded,
    STATE(656), 1,
      sym_quoted_element,
    STATE(520), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(721), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(244), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [12773] = 8,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(727), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(729), 1,
      anon_sym_DQUOTE,
    STATE(523), 1,
      sym__escape_encoded,
    STATE(687), 1,
      sym_quoted_element,
    STATE(520), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(721), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(244), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [12809] = 7,
    ACTIONS(559), 1,
      anon_sym_DOLLAR,
    ACTIONS(731), 1,
      aux_sym__unquoted_text_token1,
    STATE(496), 1,
      sym__escape_encoded,
    ACTIONS(660), 2,
      anon_sym_GT,
      anon_sym_COLON,
    STATE(503), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(557), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(238), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12843] = 8,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(727), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    STATE(523), 1,
      sym__escape_encoded,
    STATE(655), 1,
      sym_quoted_element,
    STATE(520), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(721), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(244), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [12879] = 8,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(727), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(735), 1,
      anon_sym_DQUOTE,
    STATE(523), 1,
      sym__escape_encoded,
    STATE(703), 1,
      sym_quoted_element,
    STATE(520), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(721), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(244), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [12915] = 7,
    ACTIONS(740), 1,
      anon_sym_DOLLAR,
    ACTIONS(743), 1,
      aux_sym__unquoted_text_token1,
    STATE(496), 1,
      sym__escape_encoded,
    ACTIONS(633), 2,
      anon_sym_GT,
      anon_sym_COLON,
    STATE(503), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(737), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(238), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12949] = 7,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(717), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(746), 1,
      aux_sym__unquoted_text_token1,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(696), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(243), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12982] = 6,
    ACTIONS(750), 1,
      anon_sym_LBRACE,
    ACTIONS(752), 1,
      anon_sym_ENV,
    ACTIONS(754), 1,
      anon_sym_CACHE,
    ACTIONS(756), 1,
      anon_sym_LT,
    ACTIONS(758), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(748), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [13013] = 7,
    ACTIONS(633), 1,
      anon_sym_RPAREN,
    ACTIONS(763), 1,
      anon_sym_DOLLAR,
    ACTIONS(766), 1,
      aux_sym__unquoted_text_token1,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(760), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(241), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13046] = 7,
    ACTIONS(772), 1,
      anon_sym_DOLLAR,
    ACTIONS(775), 1,
      anon_sym_DQUOTE,
    ACTIONS(777), 1,
      aux_sym__quoted_text_token1,
    STATE(523), 1,
      sym__escape_encoded,
    STATE(520), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(769), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(242), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [13079] = 7,
    ACTIONS(712), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(783), 1,
      anon_sym_DOLLAR,
    ACTIONS(786), 1,
      aux_sym__unquoted_text_token1,
    STATE(514), 1,
      sym__escape_encoded,
    STATE(531), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(780), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(243), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13112] = 7,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(789), 1,
      anon_sym_DQUOTE,
    ACTIONS(791), 1,
      aux_sym__quoted_text_token1,
    STATE(523), 1,
      sym__escape_encoded,
    STATE(520), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(721), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(242), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [13145] = 7,
    ACTIONS(660), 1,
      anon_sym_RPAREN,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(793), 1,
      aux_sym__unquoted_text_token1,
    STATE(516), 1,
      sym__escape_encoded,
    STATE(518), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(666), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
    STATE(241), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13178] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(665), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13208] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(648), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13238] = 6,
    ACTIONS(801), 1,
      anon_sym_LBRACE,
    ACTIONS(803), 1,
      anon_sym_ENV,
    ACTIONS(805), 1,
      anon_sym_CACHE,
    ACTIONS(807), 1,
      anon_sym_LT,
    ACTIONS(758), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(748), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13266] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(706), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13296] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(674), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13326] = 7,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    ACTIONS(809), 1,
      aux_sym_variable_token1,
    ACTIONS(811), 1,
      anon_sym_RBRACE,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(259), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13356] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(640), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13386] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(673), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13416] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(659), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13446] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(682), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13476] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(683), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13506] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(714), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13536] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(693), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13566] = 7,
    ACTIONS(816), 1,
      aux_sym_variable_token1,
    ACTIONS(819), 1,
      anon_sym_DOLLAR,
    ACTIONS(822), 1,
      anon_sym_RBRACE,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(259), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(813), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13596] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(669), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13626] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(639), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13656] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(647), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13686] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(715), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13716] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(699), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13746] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(641), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13776] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(694), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13806] = 4,
    ACTIONS(826), 1,
      anon_sym_DOLLAR,
    ACTIONS(829), 1,
      aux_sym__unquoted_text_token1,
    STATE(267), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(824), 12,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [13830] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(651), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13860] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(671), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13890] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(525), 1,
      sym__escape_encoded,
    STATE(666), 1,
      sym_variable,
    STATE(251), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(529), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [13920] = 2,
    ACTIONS(834), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(832), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [13939] = 2,
    ACTIONS(838), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(836), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [13958] = 2,
    ACTIONS(842), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(840), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [13977] = 2,
    ACTIONS(846), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(844), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [13996] = 2,
    ACTIONS(850), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(848), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14015] = 2,
    ACTIONS(854), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(852), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14034] = 2,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(856), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14053] = 2,
    ACTIONS(862), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(860), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14072] = 2,
    ACTIONS(866), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(864), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14091] = 2,
    ACTIONS(870), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(868), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14110] = 2,
    ACTIONS(874), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(872), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14129] = 2,
    ACTIONS(878), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(876), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14148] = 6,
    ACTIONS(758), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_ENV,
    ACTIONS(884), 1,
      anon_sym_CACHE,
    ACTIONS(886), 1,
      anon_sym_LT,
    ACTIONS(748), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [14174] = 6,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_ENV,
    ACTIONS(894), 1,
      anon_sym_CACHE,
    ACTIONS(896), 1,
      anon_sym_LT,
    ACTIONS(898), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(888), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [14199] = 2,
    ACTIONS(900), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(902), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14216] = 2,
    ACTIONS(904), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(906), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14233] = 2,
    ACTIONS(908), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(910), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14250] = 2,
    ACTIONS(912), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(914), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14267] = 2,
    ACTIONS(916), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(918), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14284] = 6,
    ACTIONS(920), 1,
      anon_sym_LBRACE,
    ACTIONS(922), 1,
      anon_sym_ENV,
    ACTIONS(924), 1,
      anon_sym_CACHE,
    ACTIONS(926), 1,
      anon_sym_LT,
    ACTIONS(758), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(748), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
  [14309] = 2,
    ACTIONS(928), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14326] = 2,
    ACTIONS(932), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14343] = 2,
    ACTIONS(936), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(938), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14360] = 2,
    ACTIONS(940), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14377] = 2,
    ACTIONS(944), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(946), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14394] = 2,
    ACTIONS(948), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(950), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14411] = 2,
    ACTIONS(952), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14428] = 2,
    ACTIONS(956), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(958), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14445] = 2,
    ACTIONS(960), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14462] = 2,
    ACTIONS(964), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14479] = 2,
    ACTIONS(968), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14496] = 2,
    ACTIONS(972), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14513] = 2,
    ACTIONS(976), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(978), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14530] = 2,
    ACTIONS(980), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(982), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14547] = 2,
    ACTIONS(984), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(986), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14564] = 2,
    ACTIONS(988), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(990), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14581] = 2,
    ACTIONS(992), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(994), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14598] = 2,
    ACTIONS(996), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(998), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14615] = 6,
    ACTIONS(758), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1000), 1,
      anon_sym_LBRACE,
    ACTIONS(1002), 1,
      anon_sym_ENV,
    ACTIONS(1004), 1,
      anon_sym_CACHE,
    ACTIONS(1006), 1,
      anon_sym_LT,
    ACTIONS(748), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [14640] = 2,
    ACTIONS(1008), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1010), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14657] = 2,
    ACTIONS(1012), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1014), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14674] = 2,
    ACTIONS(1016), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1018), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14691] = 2,
    ACTIONS(1020), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1022), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14708] = 2,
    ACTIONS(1024), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1026), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14725] = 2,
    ACTIONS(1028), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1030), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14742] = 2,
    ACTIONS(1032), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1034), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14759] = 5,
    ACTIONS(1036), 1,
      anon_sym_DOLLAR,
    ACTIONS(1039), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(1041), 1,
      aux_sym__unquoted_text_token1,
    STATE(317), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(824), 8,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14782] = 2,
    ACTIONS(1044), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1046), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14799] = 2,
    ACTIONS(1048), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1050), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14816] = 2,
    ACTIONS(1052), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1054), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14833] = 2,
    ACTIONS(1056), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1058), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14850] = 2,
    ACTIONS(1060), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1062), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14867] = 2,
    ACTIONS(1064), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1066), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14884] = 2,
    ACTIONS(1068), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1070), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14901] = 2,
    ACTIONS(1072), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1074), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14918] = 2,
    ACTIONS(842), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(840), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14934] = 2,
    ACTIONS(838), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(836), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14950] = 2,
    ACTIONS(850), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(848), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14966] = 2,
    ACTIONS(854), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(852), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14982] = 2,
    ACTIONS(846), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(844), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14998] = 3,
    ACTIONS(1078), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(1080), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1076), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15016] = 2,
    ACTIONS(870), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(868), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15032] = 2,
    ACTIONS(866), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(864), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15048] = 2,
    ACTIONS(878), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(876), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15064] = 2,
    ACTIONS(834), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(832), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15080] = 2,
    ACTIONS(858), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(856), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15096] = 2,
    ACTIONS(932), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15111] = 2,
    ACTIONS(1082), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1084), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15126] = 2,
    ACTIONS(984), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(986), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15141] = 2,
    ACTIONS(952), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15156] = 2,
    ACTIONS(916), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(918), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15171] = 2,
    ACTIONS(960), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15186] = 2,
    ACTIONS(1052), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1054), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15201] = 2,
    ACTIONS(1024), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1026), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15216] = 2,
    ACTIONS(1020), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1022), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15231] = 2,
    ACTIONS(900), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(902), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15246] = 2,
    ACTIONS(1008), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1010), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15261] = 2,
    ACTIONS(996), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(998), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15276] = 2,
    ACTIONS(992), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(994), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15291] = 2,
    ACTIONS(1048), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1050), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15306] = 2,
    ACTIONS(988), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(990), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15321] = 2,
    ACTIONS(972), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15336] = 2,
    ACTIONS(968), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15351] = 2,
    ACTIONS(964), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15366] = 2,
    ACTIONS(912), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(914), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15381] = 2,
    ACTIONS(948), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(950), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15396] = 2,
    ACTIONS(1056), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1058), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15411] = 2,
    ACTIONS(1060), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1062), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15426] = 2,
    ACTIONS(940), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15441] = 2,
    ACTIONS(932), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15456] = 2,
    ACTIONS(1016), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1018), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15471] = 2,
    ACTIONS(1044), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1046), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15486] = 2,
    ACTIONS(1064), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1066), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15501] = 2,
    ACTIONS(1068), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1070), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15516] = 2,
    ACTIONS(908), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(910), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15531] = 2,
    ACTIONS(936), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(938), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15546] = 2,
    ACTIONS(1048), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1050), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15561] = 2,
    ACTIONS(1056), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1058), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15576] = 2,
    ACTIONS(1060), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1062), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15591] = 2,
    ACTIONS(1064), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1066), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15606] = 2,
    ACTIONS(1068), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1070), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15621] = 2,
    ACTIONS(928), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15636] = 2,
    ACTIONS(1086), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1088), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [15651] = 2,
    ACTIONS(928), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15666] = 2,
    ACTIONS(984), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(986), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15681] = 2,
    ACTIONS(952), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15696] = 2,
    ACTIONS(916), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(918), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15711] = 2,
    ACTIONS(960), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15726] = 2,
    ACTIONS(1052), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1054), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15741] = 2,
    ACTIONS(1024), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1026), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15756] = 2,
    ACTIONS(1020), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1022), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15771] = 2,
    ACTIONS(900), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(902), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15786] = 2,
    ACTIONS(1008), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1010), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15801] = 2,
    ACTIONS(996), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(998), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15816] = 2,
    ACTIONS(992), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(994), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15831] = 2,
    ACTIONS(940), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15846] = 2,
    ACTIONS(988), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(990), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15861] = 2,
    ACTIONS(972), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15876] = 2,
    ACTIONS(968), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15891] = 2,
    ACTIONS(964), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15906] = 2,
    ACTIONS(912), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(914), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15921] = 2,
    ACTIONS(948), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(950), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15936] = 2,
    ACTIONS(1090), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1092), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15951] = 2,
    ACTIONS(1094), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1096), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15966] = 2,
    ACTIONS(940), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15981] = 2,
    ACTIONS(932), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15996] = 2,
    ACTIONS(1016), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1018), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16011] = 2,
    ACTIONS(1044), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1046), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16026] = 2,
    ACTIONS(928), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16041] = 2,
    ACTIONS(984), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(986), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16056] = 2,
    ACTIONS(908), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(910), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16071] = 2,
    ACTIONS(936), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(938), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16086] = 2,
    ACTIONS(916), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(918), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16101] = 2,
    ACTIONS(1068), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1070), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16116] = 2,
    ACTIONS(1064), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1066), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16131] = 2,
    ACTIONS(1060), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1062), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16146] = 2,
    ACTIONS(1056), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1058), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16161] = 2,
    ACTIONS(1048), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1050), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16176] = 2,
    ACTIONS(936), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(938), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16191] = 2,
    ACTIONS(908), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(910), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16206] = 2,
    ACTIONS(960), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16221] = 2,
    ACTIONS(1052), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1054), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16236] = 2,
    ACTIONS(1044), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1046), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16251] = 2,
    ACTIONS(1016), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1018), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16266] = 2,
    ACTIONS(932), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16281] = 2,
    ACTIONS(940), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16296] = 2,
    ACTIONS(1098), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1100), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16311] = 2,
    ACTIONS(1102), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1104), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16326] = 2,
    ACTIONS(948), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(950), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16341] = 2,
    ACTIONS(912), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(914), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16356] = 2,
    ACTIONS(964), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16371] = 2,
    ACTIONS(968), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16386] = 2,
    ACTIONS(972), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16401] = 2,
    ACTIONS(1106), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1108), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16416] = 2,
    ACTIONS(988), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(990), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16431] = 2,
    ACTIONS(1110), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1112), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16446] = 2,
    ACTIONS(992), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(994), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16461] = 2,
    ACTIONS(1024), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1026), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16476] = 2,
    ACTIONS(996), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(998), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16491] = 2,
    ACTIONS(1008), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1010), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16506] = 2,
    ACTIONS(900), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(902), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16521] = 2,
    ACTIONS(1020), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1022), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16536] = 2,
    ACTIONS(1020), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1022), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16551] = 2,
    ACTIONS(900), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(902), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16566] = 2,
    ACTIONS(1024), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1026), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16581] = 2,
    ACTIONS(1008), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1010), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16596] = 2,
    ACTIONS(1052), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1054), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16611] = 2,
    ACTIONS(960), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16626] = 2,
    ACTIONS(952), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16641] = 2,
    ACTIONS(996), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(998), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16656] = 2,
    ACTIONS(916), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(918), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16671] = 2,
    ACTIONS(992), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(994), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16686] = 2,
    ACTIONS(952), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16701] = 2,
    ACTIONS(984), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(986), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16716] = 2,
    ACTIONS(1114), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1116), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16731] = 2,
    ACTIONS(1118), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1120), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16746] = 2,
    ACTIONS(1122), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1124), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16761] = 2,
    ACTIONS(1126), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1128), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16776] = 2,
    ACTIONS(928), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16791] = 2,
    ACTIONS(988), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(990), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16806] = 2,
    ACTIONS(972), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16821] = 2,
    ACTIONS(1068), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1070), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16836] = 2,
    ACTIONS(1064), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1066), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16851] = 2,
    ACTIONS(1060), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1062), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16866] = 2,
    ACTIONS(1056), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1058), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16881] = 2,
    ACTIONS(1048), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1050), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16896] = 2,
    ACTIONS(936), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(938), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16911] = 2,
    ACTIONS(908), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(910), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16926] = 2,
    ACTIONS(968), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16941] = 2,
    ACTIONS(964), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16956] = 2,
    ACTIONS(1044), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1046), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16971] = 2,
    ACTIONS(1016), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1018), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16986] = 2,
    ACTIONS(932), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17001] = 2,
    ACTIONS(1024), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1026), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17016] = 2,
    ACTIONS(912), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(914), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17031] = 2,
    ACTIONS(948), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(950), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17046] = 2,
    ACTIONS(940), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17061] = 2,
    ACTIONS(948), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(950), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17076] = 2,
    ACTIONS(1016), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1018), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17091] = 2,
    ACTIONS(912), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(914), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17106] = 2,
    ACTIONS(964), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17121] = 2,
    ACTIONS(968), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17136] = 2,
    ACTIONS(1044), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1046), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17151] = 2,
    ACTIONS(972), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17166] = 2,
    ACTIONS(908), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(910), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17181] = 2,
    ACTIONS(988), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(990), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17196] = 2,
    ACTIONS(1130), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(575), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [17211] = 2,
    ACTIONS(936), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(938), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17226] = 2,
    ACTIONS(992), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(994), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17241] = 2,
    ACTIONS(1048), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1050), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17256] = 2,
    ACTIONS(1056), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1058), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17271] = 2,
    ACTIONS(996), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(998), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17286] = 2,
    ACTIONS(1060), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1062), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17301] = 2,
    ACTIONS(1008), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1010), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17316] = 2,
    ACTIONS(900), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(902), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17331] = 2,
    ACTIONS(1064), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1066), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17346] = 2,
    ACTIONS(1068), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1070), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17361] = 2,
    ACTIONS(928), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17376] = 2,
    ACTIONS(984), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(986), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17391] = 2,
    ACTIONS(1020), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1022), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17406] = 2,
    ACTIONS(952), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17421] = 4,
    ACTIONS(1132), 1,
      anon_sym_DOLLAR,
    ACTIONS(1135), 1,
      aux_sym__unquoted_text_token1,
    STATE(492), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(824), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_GT,
      anon_sym_COLON,
  [17440] = 2,
    ACTIONS(916), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(918), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17455] = 2,
    ACTIONS(1052), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1054), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17470] = 2,
    ACTIONS(960), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17485] = 2,
    ACTIONS(846), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(844), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17499] = 2,
    ACTIONS(850), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(848), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17513] = 2,
    ACTIONS(838), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(836), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17527] = 4,
    ACTIONS(1138), 1,
      anon_sym_DOLLAR,
    ACTIONS(1141), 1,
      aux_sym__unquoted_text_token1,
    STATE(499), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(824), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_RPAREN,
  [17545] = 5,
    ACTIONS(1039), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(1144), 1,
      anon_sym_DOLLAR,
    ACTIONS(1147), 1,
      aux_sym__unquoted_text_token1,
    STATE(500), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(824), 5,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
  [17565] = 2,
    ACTIONS(878), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(876), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17579] = 2,
    ACTIONS(842), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(840), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17593] = 2,
    ACTIONS(854), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(852), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17607] = 4,
    ACTIONS(1152), 1,
      anon_sym_DOLLAR,
    ACTIONS(1155), 1,
      aux_sym__quoted_text_token1,
    STATE(504), 1,
      aux_sym__quoted_text_repeat1,
    ACTIONS(1150), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DQUOTE,
  [17625] = 2,
    ACTIONS(870), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(868), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17639] = 1,
    ACTIONS(848), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [17650] = 2,
    ACTIONS(850), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(848), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
  [17663] = 1,
    ACTIONS(840), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [17674] = 1,
    ACTIONS(836), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [17685] = 2,
    ACTIONS(842), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(840), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17698] = 2,
    ACTIONS(838), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(836), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17711] = 2,
    ACTIONS(870), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(868), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17724] = 2,
    ACTIONS(850), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(848), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17737] = 2,
    ACTIONS(846), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(844), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
  [17750] = 2,
    ACTIONS(838), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(836), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
  [17763] = 2,
    ACTIONS(846), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(844), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17776] = 2,
    ACTIONS(878), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(876), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17789] = 2,
    ACTIONS(854), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(852), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17802] = 2,
    ACTIONS(842), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(840), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
  [17815] = 2,
    ACTIONS(854), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(852), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17828] = 2,
    ACTIONS(870), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(868), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
  [17841] = 2,
    ACTIONS(842), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(840), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17854] = 2,
    ACTIONS(846), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(844), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17867] = 2,
    ACTIONS(870), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(868), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17880] = 1,
    ACTIONS(844), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [17891] = 2,
    ACTIONS(878), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(876), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17904] = 2,
    ACTIONS(838), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(836), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17917] = 2,
    ACTIONS(878), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(876), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
  [17930] = 1,
    ACTIONS(852), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [17941] = 2,
    ACTIONS(850), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(848), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17954] = 2,
    ACTIONS(854), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      sym__escape_semicolon,
      anon_sym_DOLLAR,
  [17967] = 3,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1160), 1,
      aux_sym_if_command_token1,
    STATE(560), 1,
      aux_sym_if_command_repeat1,
  [17977] = 3,
    ACTIONS(1162), 1,
      anon_sym_LPAREN,
    ACTIONS(1164), 1,
      aux_sym_if_command_token1,
    STATE(573), 1,
      aux_sym_if_command_repeat1,
  [17987] = 3,
    ACTIONS(1166), 1,
      anon_sym_LPAREN,
    ACTIONS(1168), 1,
      aux_sym_if_command_token1,
    STATE(598), 1,
      aux_sym_if_command_repeat1,
  [17997] = 1,
    ACTIONS(856), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [18003] = 3,
    ACTIONS(1170), 1,
      anon_sym_LPAREN,
    ACTIONS(1172), 1,
      aux_sym_if_command_token1,
    STATE(597), 1,
      aux_sym_if_command_repeat1,
  [18013] = 3,
    ACTIONS(1174), 1,
      anon_sym_LPAREN,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18023] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1178), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18033] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1180), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18043] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1182), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18053] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1184), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18063] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1186), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18073] = 3,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1190), 1,
      aux_sym_if_command_token1,
    STATE(537), 1,
      aux_sym_if_command_repeat1,
  [18083] = 3,
    ACTIONS(1192), 1,
      anon_sym_LPAREN,
    ACTIONS(1194), 1,
      aux_sym_if_command_token1,
    STATE(538), 1,
      aux_sym_if_command_repeat1,
  [18093] = 3,
    ACTIONS(1196), 1,
      anon_sym_LPAREN,
    ACTIONS(1198), 1,
      aux_sym_if_command_token1,
    STATE(539), 1,
      aux_sym_if_command_repeat1,
  [18103] = 3,
    ACTIONS(1200), 1,
      anon_sym_LPAREN,
    ACTIONS(1202), 1,
      aux_sym_if_command_token1,
    STATE(540), 1,
      aux_sym_if_command_repeat1,
  [18113] = 3,
    ACTIONS(1204), 1,
      anon_sym_LPAREN,
    ACTIONS(1206), 1,
      aux_sym_if_command_token1,
    STATE(542), 1,
      aux_sym_if_command_repeat1,
  [18123] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1208), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18133] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1210), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18143] = 3,
    ACTIONS(1212), 1,
      anon_sym_LPAREN,
    ACTIONS(1214), 1,
      aux_sym_if_command_token1,
    STATE(548), 1,
      aux_sym_if_command_repeat1,
  [18153] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1216), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18163] = 3,
    ACTIONS(1218), 1,
      anon_sym_LPAREN,
    ACTIONS(1220), 1,
      aux_sym_if_command_token1,
    STATE(595), 1,
      aux_sym_if_command_repeat1,
  [18173] = 3,
    ACTIONS(1222), 1,
      anon_sym_LPAREN,
    ACTIONS(1224), 1,
      aux_sym_if_command_token1,
    STATE(590), 1,
      aux_sym_if_command_repeat1,
  [18183] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1226), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18193] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1228), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18203] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1230), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18213] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1232), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18223] = 3,
    ACTIONS(1234), 1,
      anon_sym_GT,
    ACTIONS(1236), 1,
      anon_sym_COLON,
    STATE(684), 1,
      sym__gen_exp_arguments,
  [18233] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1238), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18243] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18253] = 3,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    ACTIONS(1244), 1,
      aux_sym_if_command_token1,
    STATE(554), 1,
      aux_sym_if_command_repeat1,
  [18263] = 3,
    ACTIONS(1246), 1,
      anon_sym_LPAREN,
    ACTIONS(1248), 1,
      aux_sym_if_command_token1,
    STATE(555), 1,
      aux_sym_if_command_repeat1,
  [18273] = 3,
    ACTIONS(1250), 1,
      anon_sym_LPAREN,
    ACTIONS(1252), 1,
      aux_sym_if_command_token1,
    STATE(557), 1,
      aux_sym_if_command_repeat1,
  [18283] = 3,
    ACTIONS(1254), 1,
      anon_sym_LBRACE,
    ACTIONS(1256), 1,
      anon_sym_ENV,
    ACTIONS(1258), 1,
      anon_sym_CACHE,
  [18293] = 3,
    ACTIONS(1260), 1,
      anon_sym_LPAREN,
    ACTIONS(1262), 1,
      aux_sym_if_command_token1,
    STATE(559), 1,
      aux_sym_if_command_repeat1,
  [18303] = 3,
    ACTIONS(1264), 1,
      anon_sym_LPAREN,
    ACTIONS(1266), 1,
      aux_sym_if_command_token1,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18313] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1269), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18323] = 3,
    ACTIONS(1271), 1,
      anon_sym_LPAREN,
    ACTIONS(1273), 1,
      aux_sym_if_command_token1,
    STATE(567), 1,
      aux_sym_if_command_repeat1,
  [18333] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1275), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18343] = 3,
    ACTIONS(1277), 1,
      anon_sym_LPAREN,
    ACTIONS(1279), 1,
      aux_sym_if_command_token1,
    STATE(588), 1,
      aux_sym_if_command_repeat1,
  [18353] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1281), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18363] = 1,
    ACTIONS(832), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [18369] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18379] = 3,
    ACTIONS(1285), 1,
      anon_sym_LPAREN,
    ACTIONS(1287), 1,
      aux_sym_if_command_token1,
    STATE(541), 1,
      aux_sym_if_command_repeat1,
  [18389] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1289), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18399] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18409] = 3,
    ACTIONS(1293), 1,
      anon_sym_LPAREN,
    ACTIONS(1295), 1,
      aux_sym_if_command_token1,
    STATE(549), 1,
      aux_sym_if_command_repeat1,
  [18419] = 3,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1299), 1,
      aux_sym_if_command_token1,
    STATE(551), 1,
      aux_sym_if_command_repeat1,
  [18429] = 1,
    ACTIONS(864), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [18435] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1301), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18445] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1303), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18455] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1305), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18465] = 3,
    ACTIONS(1307), 1,
      anon_sym_LPAREN,
    ACTIONS(1309), 1,
      aux_sym_if_command_token1,
    STATE(601), 1,
      aux_sym_if_command_repeat1,
  [18475] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1311), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18485] = 3,
    ACTIONS(1313), 1,
      anon_sym_LPAREN,
    ACTIONS(1315), 1,
      aux_sym_if_command_token1,
    STATE(556), 1,
      aux_sym_if_command_repeat1,
  [18495] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1317), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18505] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1319), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18515] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18525] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1323), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18535] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1325), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18545] = 3,
    ACTIONS(1327), 1,
      anon_sym_LPAREN,
    ACTIONS(1329), 1,
      aux_sym_if_command_token1,
    STATE(569), 1,
      aux_sym_if_command_repeat1,
  [18555] = 3,
    ACTIONS(1331), 1,
      anon_sym_LPAREN,
    ACTIONS(1333), 1,
      aux_sym_if_command_token1,
    STATE(575), 1,
      aux_sym_if_command_repeat1,
  [18565] = 3,
    ACTIONS(1335), 1,
      anon_sym_LPAREN,
    ACTIONS(1337), 1,
      aux_sym_if_command_token1,
    STATE(603), 1,
      aux_sym_if_command_repeat1,
  [18575] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1339), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18585] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1341), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18595] = 3,
    ACTIONS(1343), 1,
      anon_sym_LPAREN,
    ACTIONS(1345), 1,
      aux_sym_if_command_token1,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18605] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1347), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18615] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18625] = 3,
    ACTIONS(1351), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      aux_sym_if_command_token1,
    STATE(576), 1,
      aux_sym_if_command_repeat1,
  [18635] = 3,
    ACTIONS(1355), 1,
      anon_sym_LPAREN,
    ACTIONS(1357), 1,
      aux_sym_if_command_token1,
    STATE(581), 1,
      aux_sym_if_command_repeat1,
  [18645] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1359), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18655] = 3,
    ACTIONS(1361), 1,
      anon_sym_LPAREN,
    ACTIONS(1363), 1,
      aux_sym_if_command_token1,
    STATE(582), 1,
      aux_sym_if_command_repeat1,
  [18665] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1365), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18675] = 3,
    ACTIONS(1367), 1,
      anon_sym_LPAREN,
    ACTIONS(1369), 1,
      aux_sym_if_command_token1,
    STATE(571), 1,
      aux_sym_if_command_repeat1,
  [18685] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1371), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18695] = 3,
    ACTIONS(1373), 1,
      anon_sym_LPAREN,
    ACTIONS(1375), 1,
      aux_sym_if_command_token1,
    STATE(605), 1,
      aux_sym_if_command_repeat1,
  [18705] = 3,
    ACTIONS(1377), 1,
      anon_sym_LPAREN,
    ACTIONS(1379), 1,
      aux_sym_if_command_token1,
    STATE(586), 1,
      aux_sym_if_command_repeat1,
  [18715] = 3,
    ACTIONS(1381), 1,
      anon_sym_LPAREN,
    ACTIONS(1383), 1,
      aux_sym_if_command_token1,
    STATE(580), 1,
      aux_sym_if_command_repeat1,
  [18725] = 3,
    ACTIONS(1385), 1,
      anon_sym_LPAREN,
    ACTIONS(1387), 1,
      aux_sym_if_command_token1,
    STATE(610), 1,
      aux_sym_if_command_repeat1,
  [18735] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1389), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18745] = 3,
    ACTIONS(1391), 1,
      anon_sym_LPAREN,
    ACTIONS(1393), 1,
      aux_sym_if_command_token1,
    STATE(616), 1,
      aux_sym_if_command_repeat1,
  [18755] = 3,
    ACTIONS(1395), 1,
      anon_sym_LPAREN,
    ACTIONS(1397), 1,
      aux_sym_if_command_token1,
    STATE(617), 1,
      aux_sym_if_command_repeat1,
  [18765] = 3,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1401), 1,
      aux_sym_if_command_token1,
    STATE(618), 1,
      aux_sym_if_command_repeat1,
  [18775] = 3,
    ACTIONS(1403), 1,
      anon_sym_LPAREN,
    ACTIONS(1405), 1,
      aux_sym_if_command_token1,
    STATE(619), 1,
      aux_sym_if_command_repeat1,
  [18785] = 3,
    ACTIONS(1407), 1,
      anon_sym_LPAREN,
    ACTIONS(1409), 1,
      aux_sym_if_command_token1,
    STATE(620), 1,
      aux_sym_if_command_repeat1,
  [18795] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1411), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18805] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1413), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18815] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1415), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18825] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1417), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18835] = 3,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    ACTIONS(1419), 1,
      anon_sym_LPAREN,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18845] = 3,
    ACTIONS(1421), 1,
      anon_sym_LPAREN,
    ACTIONS(1423), 1,
      aux_sym_if_command_token1,
    STATE(584), 1,
      aux_sym_if_command_repeat1,
  [18855] = 3,
    ACTIONS(1425), 1,
      anon_sym_LPAREN,
    ACTIONS(1427), 1,
      aux_sym_if_command_token1,
    STATE(587), 1,
      aux_sym_if_command_repeat1,
  [18865] = 3,
    ACTIONS(1429), 1,
      anon_sym_LPAREN,
    ACTIONS(1431), 1,
      aux_sym_if_command_token1,
    STATE(589), 1,
      aux_sym_if_command_repeat1,
  [18875] = 2,
    ACTIONS(1433), 1,
      anon_sym_RPAREN,
    ACTIONS(1435), 1,
      aux_sym_endwhile_command_token1,
  [18882] = 2,
    ACTIONS(1437), 1,
      anon_sym_RPAREN,
    ACTIONS(1439), 1,
      aux_sym_endwhile_command_token1,
  [18889] = 2,
    ACTIONS(1441), 1,
      anon_sym_RPAREN,
    ACTIONS(1443), 1,
      aux_sym_endwhile_command_token1,
  [18896] = 2,
    ACTIONS(1445), 1,
      anon_sym_RPAREN,
    ACTIONS(1447), 1,
      aux_sym_endwhile_command_token1,
  [18903] = 2,
    ACTIONS(1449), 1,
      anon_sym_RPAREN,
    ACTIONS(1451), 1,
      aux_sym_endwhile_command_token1,
  [18910] = 2,
    ACTIONS(1453), 1,
      anon_sym_RPAREN,
    ACTIONS(1455), 1,
      aux_sym_endwhile_command_token1,
  [18917] = 2,
    ACTIONS(1457), 1,
      anon_sym_RPAREN,
    ACTIONS(1459), 1,
      aux_sym_endwhile_command_token1,
  [18924] = 2,
    ACTIONS(1461), 1,
      anon_sym_RPAREN,
    ACTIONS(1463), 1,
      aux_sym_endwhile_command_token1,
  [18931] = 2,
    ACTIONS(1465), 1,
      anon_sym_RPAREN,
    ACTIONS(1467), 1,
      aux_sym_endwhile_command_token1,
  [18938] = 2,
    ACTIONS(1469), 1,
      anon_sym_RPAREN,
    ACTIONS(1471), 1,
      aux_sym_endwhile_command_token1,
  [18945] = 2,
    ACTIONS(1473), 1,
      anon_sym_RPAREN,
    ACTIONS(1475), 1,
      aux_sym_endwhile_command_token1,
  [18952] = 2,
    ACTIONS(1477), 1,
      anon_sym_RPAREN,
    ACTIONS(1479), 1,
      aux_sym_endwhile_command_token1,
  [18959] = 1,
    ACTIONS(1481), 1,
      anon_sym_RPAREN,
  [18963] = 1,
    ACTIONS(1483), 1,
      aux_sym_endwhile_command_token1,
  [18967] = 1,
    ACTIONS(1485), 1,
      aux_sym_endwhile_command_token1,
  [18971] = 1,
    ACTIONS(1487), 1,
      anon_sym_RBRACE,
  [18975] = 1,
    ACTIONS(1489), 1,
      anon_sym_RBRACE,
  [18979] = 1,
    ACTIONS(1491), 1,
      anon_sym_RBRACE,
  [18983] = 1,
    ACTIONS(1493), 1,
      anon_sym_RPAREN,
  [18987] = 1,
    ACTIONS(1495), 1,
      anon_sym_RPAREN,
  [18991] = 1,
    ACTIONS(1497), 1,
      aux_sym_endwhile_command_token1,
  [18995] = 1,
    ACTIONS(1499), 1,
      aux_sym_endwhile_command_token1,
  [18999] = 1,
    ACTIONS(1501), 1,
      anon_sym_RPAREN,
  [19003] = 1,
    ACTIONS(1503), 1,
      anon_sym_RBRACE,
  [19007] = 1,
    ACTIONS(1505), 1,
      anon_sym_RBRACE,
  [19011] = 1,
    ACTIONS(1507), 1,
      anon_sym_RPAREN,
  [19015] = 1,
    ACTIONS(1509), 1,
      anon_sym_GT,
  [19019] = 1,
    ACTIONS(1511), 1,
      anon_sym_RBRACE,
  [19023] = 1,
    ACTIONS(670), 1,
      anon_sym_RPAREN,
  [19027] = 1,
    ACTIONS(1513), 1,
      anon_sym_LBRACE,
  [19031] = 1,
    ACTIONS(1515), 1,
      anon_sym_LBRACE,
  [19035] = 1,
    ACTIONS(1517), 1,
      anon_sym_DQUOTE,
  [19039] = 1,
    ACTIONS(1519), 1,
      anon_sym_DQUOTE,
  [19043] = 1,
    ACTIONS(674), 1,
      anon_sym_RPAREN,
  [19047] = 1,
    ACTIONS(684), 1,
      anon_sym_RPAREN,
  [19051] = 1,
    ACTIONS(1521), 1,
      anon_sym_RBRACE,
  [19055] = 1,
    ACTIONS(1523), 1,
      anon_sym_GT,
  [19059] = 1,
    ACTIONS(1525), 1,
      aux_sym_endwhile_command_token1,
  [19063] = 1,
    ACTIONS(1527), 1,
      aux_sym_endwhile_command_token1,
  [19067] = 1,
    ACTIONS(1529), 1,
      anon_sym_RPAREN,
  [19071] = 1,
    ACTIONS(1531), 1,
      anon_sym_RPAREN,
  [19075] = 1,
    ACTIONS(1533), 1,
      anon_sym_RBRACE,
  [19079] = 1,
    ACTIONS(1535), 1,
      anon_sym_RBRACE,
  [19083] = 1,
    ACTIONS(1537), 1,
      anon_sym_RPAREN,
  [19087] = 1,
    ACTIONS(1539), 1,
      anon_sym_RPAREN,
  [19091] = 1,
    ACTIONS(1541), 1,
      anon_sym_RBRACE,
  [19095] = 1,
    ACTIONS(1543), 1,
      anon_sym_GT,
  [19099] = 1,
    ACTIONS(1545), 1,
      anon_sym_RBRACE,
  [19103] = 1,
    ACTIONS(1547), 1,
      anon_sym_GT,
  [19107] = 1,
    ACTIONS(1549), 1,
      anon_sym_RBRACE,
  [19111] = 1,
    ACTIONS(1551), 1,
      anon_sym_RBRACE,
  [19115] = 1,
    ACTIONS(690), 1,
      anon_sym_RPAREN,
  [19119] = 1,
    ACTIONS(832), 1,
      aux_sym_endwhile_command_token1,
  [19123] = 1,
    ACTIONS(1553), 1,
      anon_sym_RPAREN,
  [19127] = 1,
    ACTIONS(1555), 1,
      aux_sym_endwhile_command_token1,
  [19131] = 1,
    ACTIONS(1557), 1,
      aux_sym_endwhile_command_token1,
  [19135] = 1,
    ACTIONS(1559), 1,
      anon_sym_RPAREN,
  [19139] = 1,
    ACTIONS(1561), 1,
      aux_sym_endwhile_command_token1,
  [19143] = 1,
    ACTIONS(1563), 1,
      anon_sym_RBRACE,
  [19147] = 1,
    ACTIONS(1565), 1,
      anon_sym_RBRACE,
  [19151] = 1,
    ACTIONS(1567), 1,
      anon_sym_GT,
  [19155] = 1,
    ACTIONS(1569), 1,
      anon_sym_RPAREN,
  [19159] = 1,
    ACTIONS(1571), 1,
      aux_sym_endwhile_command_token1,
  [19163] = 1,
    ACTIONS(1573), 1,
      anon_sym_DQUOTE,
  [19167] = 1,
    ACTIONS(676), 1,
      anon_sym_RPAREN,
  [19171] = 1,
    ACTIONS(1575), 1,
      anon_sym_RPAREN,
  [19175] = 1,
    ACTIONS(864), 1,
      aux_sym_endwhile_command_token1,
  [19179] = 1,
    ACTIONS(1577), 1,
      anon_sym_RPAREN,
  [19183] = 1,
    ACTIONS(1579), 1,
      anon_sym_RPAREN,
  [19187] = 1,
    ACTIONS(1581), 1,
      anon_sym_RBRACE,
  [19191] = 1,
    ACTIONS(1583), 1,
      anon_sym_RBRACE,
  [19195] = 1,
    ACTIONS(1585), 1,
      aux_sym_endwhile_command_token1,
  [19199] = 1,
    ACTIONS(1587), 1,
      aux_sym_endwhile_command_token1,
  [19203] = 1,
    ACTIONS(1589), 1,
      anon_sym_RPAREN,
  [19207] = 1,
    ACTIONS(1591), 1,
      anon_sym_GT,
  [19211] = 1,
    ACTIONS(1593), 1,
      anon_sym_RBRACE,
  [19215] = 1,
    ACTIONS(1595), 1,
      anon_sym_LBRACE,
  [19219] = 1,
    ACTIONS(1597), 1,
      anon_sym_LBRACE,
  [19223] = 1,
    ACTIONS(694), 1,
      anon_sym_RPAREN,
  [19227] = 1,
    ACTIONS(1599), 1,
      anon_sym_DQUOTE,
  [19231] = 1,
    ACTIONS(1601), 1,
      anon_sym_LBRACE,
  [19235] = 1,
    ACTIONS(1603), 1,
      anon_sym_LBRACE,
  [19239] = 1,
    ACTIONS(1605), 1,
      anon_sym_RBRACE,
  [19243] = 1,
    ACTIONS(1607), 1,
      anon_sym_GT,
  [19247] = 1,
    ACTIONS(1609), 1,
      anon_sym_LBRACE,
  [19251] = 1,
    ACTIONS(1611), 1,
      anon_sym_LBRACE,
  [19255] = 1,
    ACTIONS(1613), 1,
      ts_builtin_sym_end,
  [19259] = 1,
    ACTIONS(1615), 1,
      anon_sym_RPAREN,
  [19263] = 1,
    ACTIONS(1617), 1,
      anon_sym_LBRACE,
  [19267] = 1,
    ACTIONS(1619), 1,
      anon_sym_LBRACE,
  [19271] = 1,
    ACTIONS(1621), 1,
      anon_sym_RBRACE,
  [19275] = 1,
    ACTIONS(1623), 1,
      anon_sym_RBRACE,
  [19279] = 1,
    ACTIONS(1625), 1,
      anon_sym_LBRACE,
  [19283] = 1,
    ACTIONS(1627), 1,
      anon_sym_LBRACE,
  [19287] = 1,
    ACTIONS(856), 1,
      aux_sym_endwhile_command_token1,
  [19291] = 1,
    ACTIONS(1629), 1,
      anon_sym_RPAREN,
  [19295] = 1,
    ACTIONS(1631), 1,
      anon_sym_LBRACE,
  [19299] = 1,
    ACTIONS(1633), 1,
      anon_sym_LBRACE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 57,
  [SMALL_STATE(4)] = 114,
  [SMALL_STATE(5)] = 171,
  [SMALL_STATE(6)] = 228,
  [SMALL_STATE(7)] = 285,
  [SMALL_STATE(8)] = 342,
  [SMALL_STATE(9)] = 399,
  [SMALL_STATE(10)] = 456,
  [SMALL_STATE(11)] = 513,
  [SMALL_STATE(12)] = 570,
  [SMALL_STATE(13)] = 627,
  [SMALL_STATE(14)] = 684,
  [SMALL_STATE(15)] = 741,
  [SMALL_STATE(16)] = 798,
  [SMALL_STATE(17)] = 855,
  [SMALL_STATE(18)] = 912,
  [SMALL_STATE(19)] = 969,
  [SMALL_STATE(20)] = 1026,
  [SMALL_STATE(21)] = 1083,
  [SMALL_STATE(22)] = 1140,
  [SMALL_STATE(23)] = 1197,
  [SMALL_STATE(24)] = 1254,
  [SMALL_STATE(25)] = 1311,
  [SMALL_STATE(26)] = 1368,
  [SMALL_STATE(27)] = 1425,
  [SMALL_STATE(28)] = 1482,
  [SMALL_STATE(29)] = 1539,
  [SMALL_STATE(30)] = 1596,
  [SMALL_STATE(31)] = 1653,
  [SMALL_STATE(32)] = 1710,
  [SMALL_STATE(33)] = 1767,
  [SMALL_STATE(34)] = 1824,
  [SMALL_STATE(35)] = 1881,
  [SMALL_STATE(36)] = 1938,
  [SMALL_STATE(37)] = 1995,
  [SMALL_STATE(38)] = 2052,
  [SMALL_STATE(39)] = 2109,
  [SMALL_STATE(40)] = 2166,
  [SMALL_STATE(41)] = 2223,
  [SMALL_STATE(42)] = 2280,
  [SMALL_STATE(43)] = 2337,
  [SMALL_STATE(44)] = 2394,
  [SMALL_STATE(45)] = 2451,
  [SMALL_STATE(46)] = 2508,
  [SMALL_STATE(47)] = 2565,
  [SMALL_STATE(48)] = 2622,
  [SMALL_STATE(49)] = 2679,
  [SMALL_STATE(50)] = 2736,
  [SMALL_STATE(51)] = 2793,
  [SMALL_STATE(52)] = 2850,
  [SMALL_STATE(53)] = 2907,
  [SMALL_STATE(54)] = 2964,
  [SMALL_STATE(55)] = 3021,
  [SMALL_STATE(56)] = 3078,
  [SMALL_STATE(57)] = 3135,
  [SMALL_STATE(58)] = 3192,
  [SMALL_STATE(59)] = 3249,
  [SMALL_STATE(60)] = 3306,
  [SMALL_STATE(61)] = 3363,
  [SMALL_STATE(62)] = 3420,
  [SMALL_STATE(63)] = 3477,
  [SMALL_STATE(64)] = 3534,
  [SMALL_STATE(65)] = 3591,
  [SMALL_STATE(66)] = 3648,
  [SMALL_STATE(67)] = 3705,
  [SMALL_STATE(68)] = 3762,
  [SMALL_STATE(69)] = 3819,
  [SMALL_STATE(70)] = 3876,
  [SMALL_STATE(71)] = 3933,
  [SMALL_STATE(72)] = 3990,
  [SMALL_STATE(73)] = 4047,
  [SMALL_STATE(74)] = 4104,
  [SMALL_STATE(75)] = 4161,
  [SMALL_STATE(76)] = 4218,
  [SMALL_STATE(77)] = 4275,
  [SMALL_STATE(78)] = 4332,
  [SMALL_STATE(79)] = 4389,
  [SMALL_STATE(80)] = 4446,
  [SMALL_STATE(81)] = 4503,
  [SMALL_STATE(82)] = 4560,
  [SMALL_STATE(83)] = 4617,
  [SMALL_STATE(84)] = 4674,
  [SMALL_STATE(85)] = 4731,
  [SMALL_STATE(86)] = 4788,
  [SMALL_STATE(87)] = 4845,
  [SMALL_STATE(88)] = 4902,
  [SMALL_STATE(89)] = 4959,
  [SMALL_STATE(90)] = 5016,
  [SMALL_STATE(91)] = 5073,
  [SMALL_STATE(92)] = 5130,
  [SMALL_STATE(93)] = 5187,
  [SMALL_STATE(94)] = 5244,
  [SMALL_STATE(95)] = 5301,
  [SMALL_STATE(96)] = 5358,
  [SMALL_STATE(97)] = 5415,
  [SMALL_STATE(98)] = 5472,
  [SMALL_STATE(99)] = 5529,
  [SMALL_STATE(100)] = 5586,
  [SMALL_STATE(101)] = 5643,
  [SMALL_STATE(102)] = 5700,
  [SMALL_STATE(103)] = 5757,
  [SMALL_STATE(104)] = 5814,
  [SMALL_STATE(105)] = 5871,
  [SMALL_STATE(106)] = 5928,
  [SMALL_STATE(107)] = 5985,
  [SMALL_STATE(108)] = 6042,
  [SMALL_STATE(109)] = 6099,
  [SMALL_STATE(110)] = 6156,
  [SMALL_STATE(111)] = 6213,
  [SMALL_STATE(112)] = 6270,
  [SMALL_STATE(113)] = 6327,
  [SMALL_STATE(114)] = 6384,
  [SMALL_STATE(115)] = 6441,
  [SMALL_STATE(116)] = 6498,
  [SMALL_STATE(117)] = 6555,
  [SMALL_STATE(118)] = 6612,
  [SMALL_STATE(119)] = 6669,
  [SMALL_STATE(120)] = 6726,
  [SMALL_STATE(121)] = 6783,
  [SMALL_STATE(122)] = 6840,
  [SMALL_STATE(123)] = 6897,
  [SMALL_STATE(124)] = 6954,
  [SMALL_STATE(125)] = 7011,
  [SMALL_STATE(126)] = 7068,
  [SMALL_STATE(127)] = 7125,
  [SMALL_STATE(128)] = 7182,
  [SMALL_STATE(129)] = 7239,
  [SMALL_STATE(130)] = 7303,
  [SMALL_STATE(131)] = 7367,
  [SMALL_STATE(132)] = 7431,
  [SMALL_STATE(133)] = 7495,
  [SMALL_STATE(134)] = 7559,
  [SMALL_STATE(135)] = 7623,
  [SMALL_STATE(136)] = 7687,
  [SMALL_STATE(137)] = 7751,
  [SMALL_STATE(138)] = 7815,
  [SMALL_STATE(139)] = 7879,
  [SMALL_STATE(140)] = 7943,
  [SMALL_STATE(141)] = 8007,
  [SMALL_STATE(142)] = 8068,
  [SMALL_STATE(143)] = 8124,
  [SMALL_STATE(144)] = 8180,
  [SMALL_STATE(145)] = 8236,
  [SMALL_STATE(146)] = 8292,
  [SMALL_STATE(147)] = 8348,
  [SMALL_STATE(148)] = 8404,
  [SMALL_STATE(149)] = 8460,
  [SMALL_STATE(150)] = 8516,
  [SMALL_STATE(151)] = 8572,
  [SMALL_STATE(152)] = 8628,
  [SMALL_STATE(153)] = 8684,
  [SMALL_STATE(154)] = 8740,
  [SMALL_STATE(155)] = 8796,
  [SMALL_STATE(156)] = 8852,
  [SMALL_STATE(157)] = 8908,
  [SMALL_STATE(158)] = 8964,
  [SMALL_STATE(159)] = 9020,
  [SMALL_STATE(160)] = 9076,
  [SMALL_STATE(161)] = 9132,
  [SMALL_STATE(162)] = 9188,
  [SMALL_STATE(163)] = 9244,
  [SMALL_STATE(164)] = 9300,
  [SMALL_STATE(165)] = 9356,
  [SMALL_STATE(166)] = 9412,
  [SMALL_STATE(167)] = 9468,
  [SMALL_STATE(168)] = 9524,
  [SMALL_STATE(169)] = 9580,
  [SMALL_STATE(170)] = 9636,
  [SMALL_STATE(171)] = 9692,
  [SMALL_STATE(172)] = 9748,
  [SMALL_STATE(173)] = 9804,
  [SMALL_STATE(174)] = 9860,
  [SMALL_STATE(175)] = 9916,
  [SMALL_STATE(176)] = 9972,
  [SMALL_STATE(177)] = 10028,
  [SMALL_STATE(178)] = 10084,
  [SMALL_STATE(179)] = 10140,
  [SMALL_STATE(180)] = 10196,
  [SMALL_STATE(181)] = 10252,
  [SMALL_STATE(182)] = 10308,
  [SMALL_STATE(183)] = 10364,
  [SMALL_STATE(184)] = 10420,
  [SMALL_STATE(185)] = 10476,
  [SMALL_STATE(186)] = 10532,
  [SMALL_STATE(187)] = 10588,
  [SMALL_STATE(188)] = 10644,
  [SMALL_STATE(189)] = 10700,
  [SMALL_STATE(190)] = 10756,
  [SMALL_STATE(191)] = 10805,
  [SMALL_STATE(192)] = 10854,
  [SMALL_STATE(193)] = 10903,
  [SMALL_STATE(194)] = 10952,
  [SMALL_STATE(195)] = 11001,
  [SMALL_STATE(196)] = 11050,
  [SMALL_STATE(197)] = 11103,
  [SMALL_STATE(198)] = 11156,
  [SMALL_STATE(199)] = 11205,
  [SMALL_STATE(200)] = 11258,
  [SMALL_STATE(201)] = 11297,
  [SMALL_STATE(202)] = 11346,
  [SMALL_STATE(203)] = 11399,
  [SMALL_STATE(204)] = 11452,
  [SMALL_STATE(205)] = 11505,
  [SMALL_STATE(206)] = 11544,
  [SMALL_STATE(207)] = 11593,
  [SMALL_STATE(208)] = 11639,
  [SMALL_STATE(209)] = 11685,
  [SMALL_STATE(210)] = 11731,
  [SMALL_STATE(211)] = 11777,
  [SMALL_STATE(212)] = 11823,
  [SMALL_STATE(213)] = 11869,
  [SMALL_STATE(214)] = 11915,
  [SMALL_STATE(215)] = 11961,
  [SMALL_STATE(216)] = 12007,
  [SMALL_STATE(217)] = 12053,
  [SMALL_STATE(218)] = 12099,
  [SMALL_STATE(219)] = 12145,
  [SMALL_STATE(220)] = 12188,
  [SMALL_STATE(221)] = 12231,
  [SMALL_STATE(222)] = 12274,
  [SMALL_STATE(223)] = 12317,
  [SMALL_STATE(224)] = 12360,
  [SMALL_STATE(225)] = 12403,
  [SMALL_STATE(226)] = 12446,
  [SMALL_STATE(227)] = 12489,
  [SMALL_STATE(228)] = 12532,
  [SMALL_STATE(229)] = 12575,
  [SMALL_STATE(230)] = 12618,
  [SMALL_STATE(231)] = 12661,
  [SMALL_STATE(232)] = 12699,
  [SMALL_STATE(233)] = 12737,
  [SMALL_STATE(234)] = 12773,
  [SMALL_STATE(235)] = 12809,
  [SMALL_STATE(236)] = 12843,
  [SMALL_STATE(237)] = 12879,
  [SMALL_STATE(238)] = 12915,
  [SMALL_STATE(239)] = 12949,
  [SMALL_STATE(240)] = 12982,
  [SMALL_STATE(241)] = 13013,
  [SMALL_STATE(242)] = 13046,
  [SMALL_STATE(243)] = 13079,
  [SMALL_STATE(244)] = 13112,
  [SMALL_STATE(245)] = 13145,
  [SMALL_STATE(246)] = 13178,
  [SMALL_STATE(247)] = 13208,
  [SMALL_STATE(248)] = 13238,
  [SMALL_STATE(249)] = 13266,
  [SMALL_STATE(250)] = 13296,
  [SMALL_STATE(251)] = 13326,
  [SMALL_STATE(252)] = 13356,
  [SMALL_STATE(253)] = 13386,
  [SMALL_STATE(254)] = 13416,
  [SMALL_STATE(255)] = 13446,
  [SMALL_STATE(256)] = 13476,
  [SMALL_STATE(257)] = 13506,
  [SMALL_STATE(258)] = 13536,
  [SMALL_STATE(259)] = 13566,
  [SMALL_STATE(260)] = 13596,
  [SMALL_STATE(261)] = 13626,
  [SMALL_STATE(262)] = 13656,
  [SMALL_STATE(263)] = 13686,
  [SMALL_STATE(264)] = 13716,
  [SMALL_STATE(265)] = 13746,
  [SMALL_STATE(266)] = 13776,
  [SMALL_STATE(267)] = 13806,
  [SMALL_STATE(268)] = 13830,
  [SMALL_STATE(269)] = 13860,
  [SMALL_STATE(270)] = 13890,
  [SMALL_STATE(271)] = 13920,
  [SMALL_STATE(272)] = 13939,
  [SMALL_STATE(273)] = 13958,
  [SMALL_STATE(274)] = 13977,
  [SMALL_STATE(275)] = 13996,
  [SMALL_STATE(276)] = 14015,
  [SMALL_STATE(277)] = 14034,
  [SMALL_STATE(278)] = 14053,
  [SMALL_STATE(279)] = 14072,
  [SMALL_STATE(280)] = 14091,
  [SMALL_STATE(281)] = 14110,
  [SMALL_STATE(282)] = 14129,
  [SMALL_STATE(283)] = 14148,
  [SMALL_STATE(284)] = 14174,
  [SMALL_STATE(285)] = 14199,
  [SMALL_STATE(286)] = 14216,
  [SMALL_STATE(287)] = 14233,
  [SMALL_STATE(288)] = 14250,
  [SMALL_STATE(289)] = 14267,
  [SMALL_STATE(290)] = 14284,
  [SMALL_STATE(291)] = 14309,
  [SMALL_STATE(292)] = 14326,
  [SMALL_STATE(293)] = 14343,
  [SMALL_STATE(294)] = 14360,
  [SMALL_STATE(295)] = 14377,
  [SMALL_STATE(296)] = 14394,
  [SMALL_STATE(297)] = 14411,
  [SMALL_STATE(298)] = 14428,
  [SMALL_STATE(299)] = 14445,
  [SMALL_STATE(300)] = 14462,
  [SMALL_STATE(301)] = 14479,
  [SMALL_STATE(302)] = 14496,
  [SMALL_STATE(303)] = 14513,
  [SMALL_STATE(304)] = 14530,
  [SMALL_STATE(305)] = 14547,
  [SMALL_STATE(306)] = 14564,
  [SMALL_STATE(307)] = 14581,
  [SMALL_STATE(308)] = 14598,
  [SMALL_STATE(309)] = 14615,
  [SMALL_STATE(310)] = 14640,
  [SMALL_STATE(311)] = 14657,
  [SMALL_STATE(312)] = 14674,
  [SMALL_STATE(313)] = 14691,
  [SMALL_STATE(314)] = 14708,
  [SMALL_STATE(315)] = 14725,
  [SMALL_STATE(316)] = 14742,
  [SMALL_STATE(317)] = 14759,
  [SMALL_STATE(318)] = 14782,
  [SMALL_STATE(319)] = 14799,
  [SMALL_STATE(320)] = 14816,
  [SMALL_STATE(321)] = 14833,
  [SMALL_STATE(322)] = 14850,
  [SMALL_STATE(323)] = 14867,
  [SMALL_STATE(324)] = 14884,
  [SMALL_STATE(325)] = 14901,
  [SMALL_STATE(326)] = 14918,
  [SMALL_STATE(327)] = 14934,
  [SMALL_STATE(328)] = 14950,
  [SMALL_STATE(329)] = 14966,
  [SMALL_STATE(330)] = 14982,
  [SMALL_STATE(331)] = 14998,
  [SMALL_STATE(332)] = 15016,
  [SMALL_STATE(333)] = 15032,
  [SMALL_STATE(334)] = 15048,
  [SMALL_STATE(335)] = 15064,
  [SMALL_STATE(336)] = 15080,
  [SMALL_STATE(337)] = 15096,
  [SMALL_STATE(338)] = 15111,
  [SMALL_STATE(339)] = 15126,
  [SMALL_STATE(340)] = 15141,
  [SMALL_STATE(341)] = 15156,
  [SMALL_STATE(342)] = 15171,
  [SMALL_STATE(343)] = 15186,
  [SMALL_STATE(344)] = 15201,
  [SMALL_STATE(345)] = 15216,
  [SMALL_STATE(346)] = 15231,
  [SMALL_STATE(347)] = 15246,
  [SMALL_STATE(348)] = 15261,
  [SMALL_STATE(349)] = 15276,
  [SMALL_STATE(350)] = 15291,
  [SMALL_STATE(351)] = 15306,
  [SMALL_STATE(352)] = 15321,
  [SMALL_STATE(353)] = 15336,
  [SMALL_STATE(354)] = 15351,
  [SMALL_STATE(355)] = 15366,
  [SMALL_STATE(356)] = 15381,
  [SMALL_STATE(357)] = 15396,
  [SMALL_STATE(358)] = 15411,
  [SMALL_STATE(359)] = 15426,
  [SMALL_STATE(360)] = 15441,
  [SMALL_STATE(361)] = 15456,
  [SMALL_STATE(362)] = 15471,
  [SMALL_STATE(363)] = 15486,
  [SMALL_STATE(364)] = 15501,
  [SMALL_STATE(365)] = 15516,
  [SMALL_STATE(366)] = 15531,
  [SMALL_STATE(367)] = 15546,
  [SMALL_STATE(368)] = 15561,
  [SMALL_STATE(369)] = 15576,
  [SMALL_STATE(370)] = 15591,
  [SMALL_STATE(371)] = 15606,
  [SMALL_STATE(372)] = 15621,
  [SMALL_STATE(373)] = 15636,
  [SMALL_STATE(374)] = 15651,
  [SMALL_STATE(375)] = 15666,
  [SMALL_STATE(376)] = 15681,
  [SMALL_STATE(377)] = 15696,
  [SMALL_STATE(378)] = 15711,
  [SMALL_STATE(379)] = 15726,
  [SMALL_STATE(380)] = 15741,
  [SMALL_STATE(381)] = 15756,
  [SMALL_STATE(382)] = 15771,
  [SMALL_STATE(383)] = 15786,
  [SMALL_STATE(384)] = 15801,
  [SMALL_STATE(385)] = 15816,
  [SMALL_STATE(386)] = 15831,
  [SMALL_STATE(387)] = 15846,
  [SMALL_STATE(388)] = 15861,
  [SMALL_STATE(389)] = 15876,
  [SMALL_STATE(390)] = 15891,
  [SMALL_STATE(391)] = 15906,
  [SMALL_STATE(392)] = 15921,
  [SMALL_STATE(393)] = 15936,
  [SMALL_STATE(394)] = 15951,
  [SMALL_STATE(395)] = 15966,
  [SMALL_STATE(396)] = 15981,
  [SMALL_STATE(397)] = 15996,
  [SMALL_STATE(398)] = 16011,
  [SMALL_STATE(399)] = 16026,
  [SMALL_STATE(400)] = 16041,
  [SMALL_STATE(401)] = 16056,
  [SMALL_STATE(402)] = 16071,
  [SMALL_STATE(403)] = 16086,
  [SMALL_STATE(404)] = 16101,
  [SMALL_STATE(405)] = 16116,
  [SMALL_STATE(406)] = 16131,
  [SMALL_STATE(407)] = 16146,
  [SMALL_STATE(408)] = 16161,
  [SMALL_STATE(409)] = 16176,
  [SMALL_STATE(410)] = 16191,
  [SMALL_STATE(411)] = 16206,
  [SMALL_STATE(412)] = 16221,
  [SMALL_STATE(413)] = 16236,
  [SMALL_STATE(414)] = 16251,
  [SMALL_STATE(415)] = 16266,
  [SMALL_STATE(416)] = 16281,
  [SMALL_STATE(417)] = 16296,
  [SMALL_STATE(418)] = 16311,
  [SMALL_STATE(419)] = 16326,
  [SMALL_STATE(420)] = 16341,
  [SMALL_STATE(421)] = 16356,
  [SMALL_STATE(422)] = 16371,
  [SMALL_STATE(423)] = 16386,
  [SMALL_STATE(424)] = 16401,
  [SMALL_STATE(425)] = 16416,
  [SMALL_STATE(426)] = 16431,
  [SMALL_STATE(427)] = 16446,
  [SMALL_STATE(428)] = 16461,
  [SMALL_STATE(429)] = 16476,
  [SMALL_STATE(430)] = 16491,
  [SMALL_STATE(431)] = 16506,
  [SMALL_STATE(432)] = 16521,
  [SMALL_STATE(433)] = 16536,
  [SMALL_STATE(434)] = 16551,
  [SMALL_STATE(435)] = 16566,
  [SMALL_STATE(436)] = 16581,
  [SMALL_STATE(437)] = 16596,
  [SMALL_STATE(438)] = 16611,
  [SMALL_STATE(439)] = 16626,
  [SMALL_STATE(440)] = 16641,
  [SMALL_STATE(441)] = 16656,
  [SMALL_STATE(442)] = 16671,
  [SMALL_STATE(443)] = 16686,
  [SMALL_STATE(444)] = 16701,
  [SMALL_STATE(445)] = 16716,
  [SMALL_STATE(446)] = 16731,
  [SMALL_STATE(447)] = 16746,
  [SMALL_STATE(448)] = 16761,
  [SMALL_STATE(449)] = 16776,
  [SMALL_STATE(450)] = 16791,
  [SMALL_STATE(451)] = 16806,
  [SMALL_STATE(452)] = 16821,
  [SMALL_STATE(453)] = 16836,
  [SMALL_STATE(454)] = 16851,
  [SMALL_STATE(455)] = 16866,
  [SMALL_STATE(456)] = 16881,
  [SMALL_STATE(457)] = 16896,
  [SMALL_STATE(458)] = 16911,
  [SMALL_STATE(459)] = 16926,
  [SMALL_STATE(460)] = 16941,
  [SMALL_STATE(461)] = 16956,
  [SMALL_STATE(462)] = 16971,
  [SMALL_STATE(463)] = 16986,
  [SMALL_STATE(464)] = 17001,
  [SMALL_STATE(465)] = 17016,
  [SMALL_STATE(466)] = 17031,
  [SMALL_STATE(467)] = 17046,
  [SMALL_STATE(468)] = 17061,
  [SMALL_STATE(469)] = 17076,
  [SMALL_STATE(470)] = 17091,
  [SMALL_STATE(471)] = 17106,
  [SMALL_STATE(472)] = 17121,
  [SMALL_STATE(473)] = 17136,
  [SMALL_STATE(474)] = 17151,
  [SMALL_STATE(475)] = 17166,
  [SMALL_STATE(476)] = 17181,
  [SMALL_STATE(477)] = 17196,
  [SMALL_STATE(478)] = 17211,
  [SMALL_STATE(479)] = 17226,
  [SMALL_STATE(480)] = 17241,
  [SMALL_STATE(481)] = 17256,
  [SMALL_STATE(482)] = 17271,
  [SMALL_STATE(483)] = 17286,
  [SMALL_STATE(484)] = 17301,
  [SMALL_STATE(485)] = 17316,
  [SMALL_STATE(486)] = 17331,
  [SMALL_STATE(487)] = 17346,
  [SMALL_STATE(488)] = 17361,
  [SMALL_STATE(489)] = 17376,
  [SMALL_STATE(490)] = 17391,
  [SMALL_STATE(491)] = 17406,
  [SMALL_STATE(492)] = 17421,
  [SMALL_STATE(493)] = 17440,
  [SMALL_STATE(494)] = 17455,
  [SMALL_STATE(495)] = 17470,
  [SMALL_STATE(496)] = 17485,
  [SMALL_STATE(497)] = 17499,
  [SMALL_STATE(498)] = 17513,
  [SMALL_STATE(499)] = 17527,
  [SMALL_STATE(500)] = 17545,
  [SMALL_STATE(501)] = 17565,
  [SMALL_STATE(502)] = 17579,
  [SMALL_STATE(503)] = 17593,
  [SMALL_STATE(504)] = 17607,
  [SMALL_STATE(505)] = 17625,
  [SMALL_STATE(506)] = 17639,
  [SMALL_STATE(507)] = 17650,
  [SMALL_STATE(508)] = 17663,
  [SMALL_STATE(509)] = 17674,
  [SMALL_STATE(510)] = 17685,
  [SMALL_STATE(511)] = 17698,
  [SMALL_STATE(512)] = 17711,
  [SMALL_STATE(513)] = 17724,
  [SMALL_STATE(514)] = 17737,
  [SMALL_STATE(515)] = 17750,
  [SMALL_STATE(516)] = 17763,
  [SMALL_STATE(517)] = 17776,
  [SMALL_STATE(518)] = 17789,
  [SMALL_STATE(519)] = 17802,
  [SMALL_STATE(520)] = 17815,
  [SMALL_STATE(521)] = 17828,
  [SMALL_STATE(522)] = 17841,
  [SMALL_STATE(523)] = 17854,
  [SMALL_STATE(524)] = 17867,
  [SMALL_STATE(525)] = 17880,
  [SMALL_STATE(526)] = 17891,
  [SMALL_STATE(527)] = 17904,
  [SMALL_STATE(528)] = 17917,
  [SMALL_STATE(529)] = 17930,
  [SMALL_STATE(530)] = 17941,
  [SMALL_STATE(531)] = 17954,
  [SMALL_STATE(532)] = 17967,
  [SMALL_STATE(533)] = 17977,
  [SMALL_STATE(534)] = 17987,
  [SMALL_STATE(535)] = 17997,
  [SMALL_STATE(536)] = 18003,
  [SMALL_STATE(537)] = 18013,
  [SMALL_STATE(538)] = 18023,
  [SMALL_STATE(539)] = 18033,
  [SMALL_STATE(540)] = 18043,
  [SMALL_STATE(541)] = 18053,
  [SMALL_STATE(542)] = 18063,
  [SMALL_STATE(543)] = 18073,
  [SMALL_STATE(544)] = 18083,
  [SMALL_STATE(545)] = 18093,
  [SMALL_STATE(546)] = 18103,
  [SMALL_STATE(547)] = 18113,
  [SMALL_STATE(548)] = 18123,
  [SMALL_STATE(549)] = 18133,
  [SMALL_STATE(550)] = 18143,
  [SMALL_STATE(551)] = 18153,
  [SMALL_STATE(552)] = 18163,
  [SMALL_STATE(553)] = 18173,
  [SMALL_STATE(554)] = 18183,
  [SMALL_STATE(555)] = 18193,
  [SMALL_STATE(556)] = 18203,
  [SMALL_STATE(557)] = 18213,
  [SMALL_STATE(558)] = 18223,
  [SMALL_STATE(559)] = 18233,
  [SMALL_STATE(560)] = 18243,
  [SMALL_STATE(561)] = 18253,
  [SMALL_STATE(562)] = 18263,
  [SMALL_STATE(563)] = 18273,
  [SMALL_STATE(564)] = 18283,
  [SMALL_STATE(565)] = 18293,
  [SMALL_STATE(566)] = 18303,
  [SMALL_STATE(567)] = 18313,
  [SMALL_STATE(568)] = 18323,
  [SMALL_STATE(569)] = 18333,
  [SMALL_STATE(570)] = 18343,
  [SMALL_STATE(571)] = 18353,
  [SMALL_STATE(572)] = 18363,
  [SMALL_STATE(573)] = 18369,
  [SMALL_STATE(574)] = 18379,
  [SMALL_STATE(575)] = 18389,
  [SMALL_STATE(576)] = 18399,
  [SMALL_STATE(577)] = 18409,
  [SMALL_STATE(578)] = 18419,
  [SMALL_STATE(579)] = 18429,
  [SMALL_STATE(580)] = 18435,
  [SMALL_STATE(581)] = 18445,
  [SMALL_STATE(582)] = 18455,
  [SMALL_STATE(583)] = 18465,
  [SMALL_STATE(584)] = 18475,
  [SMALL_STATE(585)] = 18485,
  [SMALL_STATE(586)] = 18495,
  [SMALL_STATE(587)] = 18505,
  [SMALL_STATE(588)] = 18515,
  [SMALL_STATE(589)] = 18525,
  [SMALL_STATE(590)] = 18535,
  [SMALL_STATE(591)] = 18545,
  [SMALL_STATE(592)] = 18555,
  [SMALL_STATE(593)] = 18565,
  [SMALL_STATE(594)] = 18575,
  [SMALL_STATE(595)] = 18585,
  [SMALL_STATE(596)] = 18595,
  [SMALL_STATE(597)] = 18605,
  [SMALL_STATE(598)] = 18615,
  [SMALL_STATE(599)] = 18625,
  [SMALL_STATE(600)] = 18635,
  [SMALL_STATE(601)] = 18645,
  [SMALL_STATE(602)] = 18655,
  [SMALL_STATE(603)] = 18665,
  [SMALL_STATE(604)] = 18675,
  [SMALL_STATE(605)] = 18685,
  [SMALL_STATE(606)] = 18695,
  [SMALL_STATE(607)] = 18705,
  [SMALL_STATE(608)] = 18715,
  [SMALL_STATE(609)] = 18725,
  [SMALL_STATE(610)] = 18735,
  [SMALL_STATE(611)] = 18745,
  [SMALL_STATE(612)] = 18755,
  [SMALL_STATE(613)] = 18765,
  [SMALL_STATE(614)] = 18775,
  [SMALL_STATE(615)] = 18785,
  [SMALL_STATE(616)] = 18795,
  [SMALL_STATE(617)] = 18805,
  [SMALL_STATE(618)] = 18815,
  [SMALL_STATE(619)] = 18825,
  [SMALL_STATE(620)] = 18835,
  [SMALL_STATE(621)] = 18845,
  [SMALL_STATE(622)] = 18855,
  [SMALL_STATE(623)] = 18865,
  [SMALL_STATE(624)] = 18875,
  [SMALL_STATE(625)] = 18882,
  [SMALL_STATE(626)] = 18889,
  [SMALL_STATE(627)] = 18896,
  [SMALL_STATE(628)] = 18903,
  [SMALL_STATE(629)] = 18910,
  [SMALL_STATE(630)] = 18917,
  [SMALL_STATE(631)] = 18924,
  [SMALL_STATE(632)] = 18931,
  [SMALL_STATE(633)] = 18938,
  [SMALL_STATE(634)] = 18945,
  [SMALL_STATE(635)] = 18952,
  [SMALL_STATE(636)] = 18959,
  [SMALL_STATE(637)] = 18963,
  [SMALL_STATE(638)] = 18967,
  [SMALL_STATE(639)] = 18971,
  [SMALL_STATE(640)] = 18975,
  [SMALL_STATE(641)] = 18979,
  [SMALL_STATE(642)] = 18983,
  [SMALL_STATE(643)] = 18987,
  [SMALL_STATE(644)] = 18991,
  [SMALL_STATE(645)] = 18995,
  [SMALL_STATE(646)] = 18999,
  [SMALL_STATE(647)] = 19003,
  [SMALL_STATE(648)] = 19007,
  [SMALL_STATE(649)] = 19011,
  [SMALL_STATE(650)] = 19015,
  [SMALL_STATE(651)] = 19019,
  [SMALL_STATE(652)] = 19023,
  [SMALL_STATE(653)] = 19027,
  [SMALL_STATE(654)] = 19031,
  [SMALL_STATE(655)] = 19035,
  [SMALL_STATE(656)] = 19039,
  [SMALL_STATE(657)] = 19043,
  [SMALL_STATE(658)] = 19047,
  [SMALL_STATE(659)] = 19051,
  [SMALL_STATE(660)] = 19055,
  [SMALL_STATE(661)] = 19059,
  [SMALL_STATE(662)] = 19063,
  [SMALL_STATE(663)] = 19067,
  [SMALL_STATE(664)] = 19071,
  [SMALL_STATE(665)] = 19075,
  [SMALL_STATE(666)] = 19079,
  [SMALL_STATE(667)] = 19083,
  [SMALL_STATE(668)] = 19087,
  [SMALL_STATE(669)] = 19091,
  [SMALL_STATE(670)] = 19095,
  [SMALL_STATE(671)] = 19099,
  [SMALL_STATE(672)] = 19103,
  [SMALL_STATE(673)] = 19107,
  [SMALL_STATE(674)] = 19111,
  [SMALL_STATE(675)] = 19115,
  [SMALL_STATE(676)] = 19119,
  [SMALL_STATE(677)] = 19123,
  [SMALL_STATE(678)] = 19127,
  [SMALL_STATE(679)] = 19131,
  [SMALL_STATE(680)] = 19135,
  [SMALL_STATE(681)] = 19139,
  [SMALL_STATE(682)] = 19143,
  [SMALL_STATE(683)] = 19147,
  [SMALL_STATE(684)] = 19151,
  [SMALL_STATE(685)] = 19155,
  [SMALL_STATE(686)] = 19159,
  [SMALL_STATE(687)] = 19163,
  [SMALL_STATE(688)] = 19167,
  [SMALL_STATE(689)] = 19171,
  [SMALL_STATE(690)] = 19175,
  [SMALL_STATE(691)] = 19179,
  [SMALL_STATE(692)] = 19183,
  [SMALL_STATE(693)] = 19187,
  [SMALL_STATE(694)] = 19191,
  [SMALL_STATE(695)] = 19195,
  [SMALL_STATE(696)] = 19199,
  [SMALL_STATE(697)] = 19203,
  [SMALL_STATE(698)] = 19207,
  [SMALL_STATE(699)] = 19211,
  [SMALL_STATE(700)] = 19215,
  [SMALL_STATE(701)] = 19219,
  [SMALL_STATE(702)] = 19223,
  [SMALL_STATE(703)] = 19227,
  [SMALL_STATE(704)] = 19231,
  [SMALL_STATE(705)] = 19235,
  [SMALL_STATE(706)] = 19239,
  [SMALL_STATE(707)] = 19243,
  [SMALL_STATE(708)] = 19247,
  [SMALL_STATE(709)] = 19251,
  [SMALL_STATE(710)] = 19255,
  [SMALL_STATE(711)] = 19259,
  [SMALL_STATE(712)] = 19263,
  [SMALL_STATE(713)] = 19267,
  [SMALL_STATE(714)] = 19271,
  [SMALL_STATE(715)] = 19275,
  [SMALL_STATE(716)] = 19279,
  [SMALL_STATE(717)] = 19283,
  [SMALL_STATE(718)] = 19287,
  [SMALL_STATE(719)] = 19291,
  [SMALL_STATE(720)] = 19295,
  [SMALL_STATE(721)] = 19299,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(593),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(623),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(622),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(621),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(608),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(604),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [295] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(274),
  [298] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(240),
  [301] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(102),
  [304] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(48),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2),
  [309] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(236),
  [312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(205),
  [315] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(277),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [374] = {.entry = {.count = 1, .reusable = false}}, SHIFT(583),
  [376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(534),
  [378] = {.entry = {.count = 1, .reusable = false}}, SHIFT(536),
  [380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(609),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(611),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(547),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(602),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(532),
  [398] = {.entry = {.count = 1, .reusable = false}}, SHIFT(591),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [404] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(141),
  [407] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(593),
  [410] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(583),
  [413] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(534),
  [416] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2),
  [418] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(623),
  [421] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(622),
  [424] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(621),
  [427] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(608),
  [430] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(609),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(561),
  [437] = {.entry = {.count = 1, .reusable = false}}, SHIFT(550),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [441] = {.entry = {.count = 1, .reusable = false}}, SHIFT(565),
  [443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(596),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(615),
  [449] = {.entry = {.count = 1, .reusable = false}}, SHIFT(546),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(545),
  [455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(606),
  [457] = {.entry = {.count = 1, .reusable = false}}, SHIFT(612),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [461] = {.entry = {.count = 1, .reusable = false}}, SHIFT(614),
  [463] = {.entry = {.count = 1, .reusable = false}}, SHIFT(568),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(544),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [469] = {.entry = {.count = 1, .reusable = false}}, SHIFT(607),
  [471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(533),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [475] = {.entry = {.count = 1, .reusable = false}}, SHIFT(552),
  [477] = {.entry = {.count = 1, .reusable = false}}, SHIFT(592),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [481] = {.entry = {.count = 1, .reusable = false}}, SHIFT(553),
  [483] = {.entry = {.count = 1, .reusable = false}}, SHIFT(599),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [487] = {.entry = {.count = 1, .reusable = false}}, SHIFT(570),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [491] = {.entry = {.count = 1, .reusable = false}}, SHIFT(600),
  [493] = {.entry = {.count = 1, .reusable = false}}, SHIFT(543),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [497] = {.entry = {.count = 1, .reusable = false}}, SHIFT(585),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [503] = {.entry = {.count = 1, .reusable = false}}, SHIFT(578),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(577),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [513] = {.entry = {.count = 1, .reusable = false}}, SHIFT(574),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [517] = {.entry = {.count = 1, .reusable = false}}, SHIFT(613),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(562),
  [521] = {.entry = {.count = 1, .reusable = false}}, SHIFT(563),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [549] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_arguments, 2),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [565] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [569] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(330),
  [572] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(248),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2),
  [577] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(237),
  [580] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(232),
  [583] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(336),
  [586] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_arguments, 1),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [592] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(196),
  [595] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(593),
  [598] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(623),
  [601] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(622),
  [604] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(621),
  [607] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [609] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(608),
  [612] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(568),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [621] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(199),
  [624] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(596),
  [627] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(274),
  [630] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(240),
  [633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2),
  [635] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(200),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [640] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(202),
  [643] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(606),
  [646] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(203),
  [649] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(550),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [654] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(204),
  [657] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(604),
  [660] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoted_argument, 1),
  [662] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [672] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [702] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(718),
  [706] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(330),
  [709] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(248),
  [712] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2),
  [714] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(231),
  [717] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoted_argument, 1),
  [719] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [727] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(676),
  [731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(238),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [737] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(496),
  [740] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(283),
  [743] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(238),
  [746] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 1),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(653),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [758] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 1),
  [760] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(516),
  [763] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(309),
  [766] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(241),
  [769] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(523),
  [772] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(284),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2),
  [777] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(242),
  [780] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(514),
  [783] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(290),
  [786] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(243),
  [789] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_element, 1),
  [791] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [793] = {.entry = {.count = 1, .reusable = false}}, SHIFT(241),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(720),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(721),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1),
  [813] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(525),
  [816] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(259),
  [819] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(564),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2),
  [824] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2),
  [826] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(267),
  [829] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(267),
  [832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_argument, 2),
  [834] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_argument, 2),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_env_var, 5),
  [838] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_env_var, 5),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cache_var, 5),
  [842] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cache_var, 5),
  [844] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_escape_sequence, 1),
  [846] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_escape_sequence, 1),
  [848] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_var, 4),
  [850] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_var, 4),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_ref, 1),
  [854] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_ref, 1),
  [856] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1),
  [858] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument, 1),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren_argument, 2),
  [862] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren_argument, 2),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_argument, 3),
  [866] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_argument, 3),
  [868] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gen_exp, 4),
  [870] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_gen_exp, 4),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren_argument, 3),
  [874] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren_argument, 3),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gen_exp, 3),
  [878] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_gen_exp, 3),
  [880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(712),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(713),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [888] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 1),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(700),
  [894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(701),
  [896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [898] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__quoted_text_repeat1, 1),
  [900] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 3),
  [902] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 3),
  [904] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 5),
  [906] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 5),
  [908] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 6),
  [910] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 6),
  [912] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 4),
  [914] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 4),
  [916] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_loop, 3),
  [918] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_loop, 3),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(716),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(717),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [928] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 3),
  [930] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 3),
  [932] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 5),
  [934] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 5),
  [936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 7),
  [938] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 7),
  [940] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 5),
  [942] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 5),
  [944] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 3),
  [946] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 3),
  [948] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 4),
  [950] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 4),
  [952] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_loop, 3),
  [954] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_loop, 3),
  [956] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 4),
  [958] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 4),
  [960] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 3),
  [962] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_def, 3),
  [964] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 4),
  [966] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 4),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 4),
  [970] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 4),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 4),
  [974] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 4),
  [976] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 4),
  [978] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 4),
  [980] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 4),
  [982] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 4),
  [984] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_condition, 3),
  [986] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_condition, 3),
  [988] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 5),
  [990] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 5),
  [992] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 3),
  [994] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 3),
  [996] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 3),
  [998] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 3),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(704),
  [1004] = {.entry = {.count = 1, .reusable = true}}, SHIFT(705),
  [1006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1008] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 3),
  [1010] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 3),
  [1012] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 5),
  [1014] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 5),
  [1016] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 5),
  [1018] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 5),
  [1020] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 3),
  [1022] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 3),
  [1024] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 4),
  [1026] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 4),
  [1028] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 5),
  [1030] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 5),
  [1032] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 3),
  [1034] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 3),
  [1036] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(317),
  [1039] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2),
  [1041] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(317),
  [1044] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 5),
  [1046] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 5),
  [1048] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_condition, 2),
  [1050] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_condition, 2),
  [1052] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_def, 3),
  [1054] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_def, 3),
  [1056] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_loop, 2),
  [1058] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_loop, 2),
  [1060] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_loop, 2),
  [1062] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_loop, 2),
  [1064] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 2),
  [1066] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_def, 2),
  [1068] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_def, 2),
  [1070] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_def, 2),
  [1072] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 3),
  [1074] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 3),
  [1076] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 1),
  [1078] = {.entry = {.count = 1, .reusable = false}}, SHIFT(477),
  [1080] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 1),
  [1082] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 3),
  [1084] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 3),
  [1086] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 3),
  [1088] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 3),
  [1090] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 3),
  [1092] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 3),
  [1094] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 3),
  [1096] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 3),
  [1098] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 4),
  [1100] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 4),
  [1102] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 4),
  [1104] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 4),
  [1106] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 4),
  [1108] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 4),
  [1110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 4),
  [1112] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 4),
  [1114] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 5),
  [1116] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 5),
  [1118] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 5),
  [1120] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 5),
  [1122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 5),
  [1124] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 5),
  [1126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 5),
  [1128] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 5),
  [1130] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2),
  [1132] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(492),
  [1135] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(492),
  [1138] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(499),
  [1141] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(499),
  [1144] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(500),
  [1147] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(500),
  [1150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 2),
  [1152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 2), SHIFT_REPEAT(504),
  [1155] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__quoted_text_repeat1, 2), SHIFT_REPEAT(504),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [1166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [1234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_content, 1),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(708),
  [1258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(709),
  [1260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_command_repeat1, 2),
  [1266] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_command_repeat1, 2), SHIFT_REPEAT(566),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(629),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(634),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [1339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(624),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(616),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(628),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [1407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [1411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [1425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [1433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1451] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [1455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [1461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1463] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1467] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1475] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(636),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(677),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(719),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(642),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(692),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(691),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(664),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(663),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(685),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_content, 2),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(689),
  [1573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(690),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [1587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(643),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [1595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1613] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_cmake_external_scanner_create(void);
void tree_sitter_cmake_external_scanner_destroy(void *);
bool tree_sitter_cmake_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_cmake_external_scanner_serialize(void *, char *);
void tree_sitter_cmake_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_cmake(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_cmake_external_scanner_create,
      tree_sitter_cmake_external_scanner_destroy,
      tree_sitter_cmake_external_scanner_scan,
      tree_sitter_cmake_external_scanner_serialize,
      tree_sitter_cmake_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
