#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 902
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 96
#define ALIAS_COUNT 0
#define TOKEN_COUNT 43
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 1

enum {
  sym__escape_identity = 1,
  anon_sym_BSLASHt = 2,
  anon_sym_BSLASHr = 3,
  anon_sym_BSLASHn = 4,
  anon_sym_SEMI = 5,
  anon_sym_BSLASH_SEMI = 6,
  aux_sym_variable_token1 = 7,
  anon_sym_DOLLAR = 8,
  anon_sym_LBRACE = 9,
  anon_sym_RBRACE = 10,
  anon_sym_ENV = 11,
  anon_sym_CACHE = 12,
  anon_sym_LT = 13,
  anon_sym_GT = 14,
  anon_sym_COLON = 15,
  aux_sym__gen_exp_arguments_token1 = 16,
  aux_sym__untrimmed_argument_token1 = 17,
  anon_sym_LPAREN = 18,
  anon_sym_RPAREN = 19,
  anon_sym_DQUOTE = 20,
  aux_sym__quoted_text_token1 = 21,
  aux_sym__unquoted_text_token1 = 22,
  aux_sym_if_command_token1 = 23,
  aux_sym_endwhile_command_token1 = 24,
  sym_if = 25,
  sym_elseif = 26,
  sym_else = 27,
  sym_endif = 28,
  sym_foreach = 29,
  sym_endforeach = 30,
  sym_while = 31,
  sym_endwhile = 32,
  sym_function = 33,
  sym_endfunction = 34,
  sym_macro = 35,
  sym_endmacro = 36,
  sym_block = 37,
  sym_endblock = 38,
  sym_identifier = 39,
  sym_bracket_argument = 40,
  sym_bracket_comment = 41,
  sym_line_comment = 42,
  sym_source_file = 43,
  sym_escape_sequence = 44,
  sym__escape_encoded = 45,
  sym__escape_semicolon = 46,
  sym_variable = 47,
  sym_variable_ref = 48,
  sym_normal_var = 49,
  sym_env_var = 50,
  sym_cache_var = 51,
  sym_gen_exp = 52,
  sym__gen_exp_content = 53,
  sym__gen_exp_arguments = 54,
  sym_argument = 55,
  sym__untrimmed_argument = 56,
  sym__paren_argument = 57,
  sym_quoted_argument = 58,
  sym_quoted_element = 59,
  sym__quoted_text = 60,
  sym_unquoted_argument = 61,
  sym__unquoted_text = 62,
  sym_if_command = 63,
  sym_elseif_command = 64,
  sym_else_command = 65,
  sym_endif_command = 66,
  sym_if_condition = 67,
  sym_foreach_command = 68,
  sym_endforeach_command = 69,
  sym_foreach_loop = 70,
  sym_while_command = 71,
  sym_endwhile_command = 72,
  sym_while_loop = 73,
  sym_function_command = 74,
  sym_endfunction_command = 75,
  sym_function_def = 76,
  sym_macro_command = 77,
  sym_endmacro_command = 78,
  sym_macro_def = 79,
  sym_block_command = 80,
  sym_endblock_command = 81,
  sym_block_def = 82,
  sym_normal_command = 83,
  sym__command_invocation = 84,
  sym__untrimmed_command_invocation = 85,
  aux_sym_source_file_repeat1 = 86,
  aux_sym_variable_repeat1 = 87,
  aux_sym__gen_exp_arguments_repeat1 = 88,
  aux_sym__paren_argument_repeat1 = 89,
  aux_sym_quoted_element_repeat1 = 90,
  aux_sym__quoted_text_repeat1 = 91,
  aux_sym_unquoted_argument_repeat1 = 92,
  aux_sym__unquoted_text_repeat1 = 93,
  aux_sym_if_command_repeat1 = 94,
  aux_sym_if_condition_repeat1 = 95,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__escape_identity] = "_escape_identity",
  [anon_sym_BSLASHt] = "\\t",
  [anon_sym_BSLASHr] = "\\r",
  [anon_sym_BSLASHn] = "\\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_BSLASH_SEMI] = "\\;",
  [aux_sym_variable_token1] = "variable_token1",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_ENV] = "ENV",
  [anon_sym_CACHE] = "CACHE",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_COLON] = ":",
  [aux_sym__gen_exp_arguments_token1] = "_gen_exp_arguments_token1",
  [aux_sym__untrimmed_argument_token1] = "_untrimmed_argument_token1",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__quoted_text_token1] = "_quoted_text_token1",
  [aux_sym__unquoted_text_token1] = "_unquoted_text_token1",
  [aux_sym_if_command_token1] = "if_command_token1",
  [aux_sym_endwhile_command_token1] = "endwhile_command_token1",
  [sym_if] = "if",
  [sym_elseif] = "elseif",
  [sym_else] = "else",
  [sym_endif] = "endif",
  [sym_foreach] = "foreach",
  [sym_endforeach] = "endforeach",
  [sym_while] = "while",
  [sym_endwhile] = "endwhile",
  [sym_function] = "function",
  [sym_endfunction] = "endfunction",
  [sym_macro] = "macro",
  [sym_endmacro] = "endmacro",
  [sym_block] = "block",
  [sym_endblock] = "endblock",
  [sym_identifier] = "identifier",
  [sym_bracket_argument] = "bracket_argument",
  [sym_bracket_comment] = "bracket_comment",
  [sym_line_comment] = "line_comment",
  [sym_source_file] = "source_file",
  [sym_escape_sequence] = "escape_sequence",
  [sym__escape_encoded] = "_escape_encoded",
  [sym__escape_semicolon] = "_escape_semicolon",
  [sym_variable] = "variable",
  [sym_variable_ref] = "variable_ref",
  [sym_normal_var] = "normal_var",
  [sym_env_var] = "env_var",
  [sym_cache_var] = "cache_var",
  [sym_gen_exp] = "gen_exp",
  [sym__gen_exp_content] = "_gen_exp_content",
  [sym__gen_exp_arguments] = "_gen_exp_arguments",
  [sym_argument] = "argument",
  [sym__untrimmed_argument] = "_untrimmed_argument",
  [sym__paren_argument] = "_paren_argument",
  [sym_quoted_argument] = "quoted_argument",
  [sym_quoted_element] = "quoted_element",
  [sym__quoted_text] = "_quoted_text",
  [sym_unquoted_argument] = "unquoted_argument",
  [sym__unquoted_text] = "_unquoted_text",
  [sym_if_command] = "if_command",
  [sym_elseif_command] = "elseif_command",
  [sym_else_command] = "else_command",
  [sym_endif_command] = "endif_command",
  [sym_if_condition] = "if_condition",
  [sym_foreach_command] = "foreach_command",
  [sym_endforeach_command] = "endforeach_command",
  [sym_foreach_loop] = "foreach_loop",
  [sym_while_command] = "while_command",
  [sym_endwhile_command] = "endwhile_command",
  [sym_while_loop] = "while_loop",
  [sym_function_command] = "function_command",
  [sym_endfunction_command] = "endfunction_command",
  [sym_function_def] = "function_def",
  [sym_macro_command] = "macro_command",
  [sym_endmacro_command] = "endmacro_command",
  [sym_macro_def] = "macro_def",
  [sym_block_command] = "block_command",
  [sym_endblock_command] = "endblock_command",
  [sym_block_def] = "block_def",
  [sym_normal_command] = "normal_command",
  [sym__command_invocation] = "_command_invocation",
  [sym__untrimmed_command_invocation] = "_untrimmed_command_invocation",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_variable_repeat1] = "variable_repeat1",
  [aux_sym__gen_exp_arguments_repeat1] = "_gen_exp_arguments_repeat1",
  [aux_sym__paren_argument_repeat1] = "_paren_argument_repeat1",
  [aux_sym_quoted_element_repeat1] = "quoted_element_repeat1",
  [aux_sym__quoted_text_repeat1] = "_quoted_text_repeat1",
  [aux_sym_unquoted_argument_repeat1] = "unquoted_argument_repeat1",
  [aux_sym__unquoted_text_repeat1] = "_unquoted_text_repeat1",
  [aux_sym_if_command_repeat1] = "if_command_repeat1",
  [aux_sym_if_condition_repeat1] = "if_condition_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__escape_identity] = sym__escape_identity,
  [anon_sym_BSLASHt] = anon_sym_BSLASHt,
  [anon_sym_BSLASHr] = anon_sym_BSLASHr,
  [anon_sym_BSLASHn] = anon_sym_BSLASHn,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_BSLASH_SEMI] = anon_sym_BSLASH_SEMI,
  [aux_sym_variable_token1] = aux_sym_variable_token1,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_ENV] = anon_sym_ENV,
  [anon_sym_CACHE] = anon_sym_CACHE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [aux_sym__gen_exp_arguments_token1] = aux_sym__gen_exp_arguments_token1,
  [aux_sym__untrimmed_argument_token1] = aux_sym__untrimmed_argument_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__quoted_text_token1] = aux_sym__quoted_text_token1,
  [aux_sym__unquoted_text_token1] = aux_sym__unquoted_text_token1,
  [aux_sym_if_command_token1] = aux_sym_if_command_token1,
  [aux_sym_endwhile_command_token1] = aux_sym_endwhile_command_token1,
  [sym_if] = sym_if,
  [sym_elseif] = sym_elseif,
  [sym_else] = sym_else,
  [sym_endif] = sym_endif,
  [sym_foreach] = sym_foreach,
  [sym_endforeach] = sym_endforeach,
  [sym_while] = sym_while,
  [sym_endwhile] = sym_endwhile,
  [sym_function] = sym_function,
  [sym_endfunction] = sym_endfunction,
  [sym_macro] = sym_macro,
  [sym_endmacro] = sym_endmacro,
  [sym_block] = sym_block,
  [sym_endblock] = sym_endblock,
  [sym_identifier] = sym_identifier,
  [sym_bracket_argument] = sym_bracket_argument,
  [sym_bracket_comment] = sym_bracket_comment,
  [sym_line_comment] = sym_line_comment,
  [sym_source_file] = sym_source_file,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__escape_encoded] = sym__escape_encoded,
  [sym__escape_semicolon] = sym__escape_semicolon,
  [sym_variable] = sym_variable,
  [sym_variable_ref] = sym_variable_ref,
  [sym_normal_var] = sym_normal_var,
  [sym_env_var] = sym_env_var,
  [sym_cache_var] = sym_cache_var,
  [sym_gen_exp] = sym_gen_exp,
  [sym__gen_exp_content] = sym__gen_exp_content,
  [sym__gen_exp_arguments] = sym__gen_exp_arguments,
  [sym_argument] = sym_argument,
  [sym__untrimmed_argument] = sym__untrimmed_argument,
  [sym__paren_argument] = sym__paren_argument,
  [sym_quoted_argument] = sym_quoted_argument,
  [sym_quoted_element] = sym_quoted_element,
  [sym__quoted_text] = sym__quoted_text,
  [sym_unquoted_argument] = sym_unquoted_argument,
  [sym__unquoted_text] = sym__unquoted_text,
  [sym_if_command] = sym_if_command,
  [sym_elseif_command] = sym_elseif_command,
  [sym_else_command] = sym_else_command,
  [sym_endif_command] = sym_endif_command,
  [sym_if_condition] = sym_if_condition,
  [sym_foreach_command] = sym_foreach_command,
  [sym_endforeach_command] = sym_endforeach_command,
  [sym_foreach_loop] = sym_foreach_loop,
  [sym_while_command] = sym_while_command,
  [sym_endwhile_command] = sym_endwhile_command,
  [sym_while_loop] = sym_while_loop,
  [sym_function_command] = sym_function_command,
  [sym_endfunction_command] = sym_endfunction_command,
  [sym_function_def] = sym_function_def,
  [sym_macro_command] = sym_macro_command,
  [sym_endmacro_command] = sym_endmacro_command,
  [sym_macro_def] = sym_macro_def,
  [sym_block_command] = sym_block_command,
  [sym_endblock_command] = sym_endblock_command,
  [sym_block_def] = sym_block_def,
  [sym_normal_command] = sym_normal_command,
  [sym__command_invocation] = sym__command_invocation,
  [sym__untrimmed_command_invocation] = sym__untrimmed_command_invocation,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_variable_repeat1] = aux_sym_variable_repeat1,
  [aux_sym__gen_exp_arguments_repeat1] = aux_sym__gen_exp_arguments_repeat1,
  [aux_sym__paren_argument_repeat1] = aux_sym__paren_argument_repeat1,
  [aux_sym_quoted_element_repeat1] = aux_sym_quoted_element_repeat1,
  [aux_sym__quoted_text_repeat1] = aux_sym__quoted_text_repeat1,
  [aux_sym_unquoted_argument_repeat1] = aux_sym_unquoted_argument_repeat1,
  [aux_sym__unquoted_text_repeat1] = aux_sym__unquoted_text_repeat1,
  [aux_sym_if_command_repeat1] = aux_sym_if_command_repeat1,
  [aux_sym_if_condition_repeat1] = aux_sym_if_condition_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__escape_identity] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BSLASHt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_variable_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENV] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CACHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__gen_exp_arguments_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__untrimmed_argument_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__quoted_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unquoted_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_endwhile_command_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_endif] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_endwhile] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction] = {
    .visible = true,
    .named = true,
  },
  [sym_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_endmacro] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_endblock] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_encoded] = {
    .visible = false,
    .named = true,
  },
  [sym__escape_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_var] = {
    .visible = true,
    .named = true,
  },
  [sym_env_var] = {
    .visible = true,
    .named = true,
  },
  [sym_cache_var] = {
    .visible = true,
    .named = true,
  },
  [sym_gen_exp] = {
    .visible = true,
    .named = true,
  },
  [sym__gen_exp_content] = {
    .visible = false,
    .named = true,
  },
  [sym__gen_exp_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__untrimmed_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__paren_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_element] = {
    .visible = true,
    .named = true,
  },
  [sym__quoted_text] = {
    .visible = false,
    .named = true,
  },
  [sym_unquoted_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__unquoted_text] = {
    .visible = false,
    .named = true,
  },
  [sym_if_command] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_command] = {
    .visible = true,
    .named = true,
  },
  [sym_else_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endif_command] = {
    .visible = true,
    .named = true,
  },
  [sym_if_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_while_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endwhile_command] = {
    .visible = true,
    .named = true,
  },
  [sym_while_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_function_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction_command] = {
    .visible = true,
    .named = true,
  },
  [sym_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endmacro_command] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_def] = {
    .visible = true,
    .named = true,
  },
  [sym_block_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endblock_command] = {
    .visible = true,
    .named = true,
  },
  [sym_block_def] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_command] = {
    .visible = true,
    .named = true,
  },
  [sym__command_invocation] = {
    .visible = false,
    .named = true,
  },
  [sym__untrimmed_command_invocation] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__gen_exp_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paren_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_quoted_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__quoted_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unquoted_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unquoted_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_condition_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 3,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 2,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 5,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 10,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 26,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 10,
  [35] = 35,
  [36] = 29,
  [37] = 35,
  [38] = 33,
  [39] = 32,
  [40] = 31,
  [41] = 28,
  [42] = 35,
  [43] = 29,
  [44] = 28,
  [45] = 26,
  [46] = 5,
  [47] = 29,
  [48] = 18,
  [49] = 16,
  [50] = 15,
  [51] = 31,
  [52] = 35,
  [53] = 10,
  [54] = 32,
  [55] = 55,
  [56] = 18,
  [57] = 4,
  [58] = 16,
  [59] = 59,
  [60] = 7,
  [61] = 61,
  [62] = 15,
  [63] = 22,
  [64] = 64,
  [65] = 65,
  [66] = 2,
  [67] = 67,
  [68] = 68,
  [69] = 13,
  [70] = 70,
  [71] = 71,
  [72] = 12,
  [73] = 73,
  [74] = 74,
  [75] = 9,
  [76] = 76,
  [77] = 77,
  [78] = 4,
  [79] = 33,
  [80] = 32,
  [81] = 81,
  [82] = 7,
  [83] = 83,
  [84] = 3,
  [85] = 31,
  [86] = 11,
  [87] = 6,
  [88] = 6,
  [89] = 11,
  [90] = 12,
  [91] = 7,
  [92] = 4,
  [93] = 12,
  [94] = 3,
  [95] = 28,
  [96] = 22,
  [97] = 6,
  [98] = 26,
  [99] = 2,
  [100] = 15,
  [101] = 5,
  [102] = 13,
  [103] = 16,
  [104] = 18,
  [105] = 9,
  [106] = 3,
  [107] = 33,
  [108] = 11,
  [109] = 109,
  [110] = 9,
  [111] = 5,
  [112] = 11,
  [113] = 26,
  [114] = 28,
  [115] = 115,
  [116] = 13,
  [117] = 3,
  [118] = 118,
  [119] = 22,
  [120] = 120,
  [121] = 31,
  [122] = 122,
  [123] = 32,
  [124] = 124,
  [125] = 33,
  [126] = 126,
  [127] = 35,
  [128] = 128,
  [129] = 10,
  [130] = 18,
  [131] = 33,
  [132] = 132,
  [133] = 133,
  [134] = 29,
  [135] = 135,
  [136] = 136,
  [137] = 35,
  [138] = 16,
  [139] = 15,
  [140] = 32,
  [141] = 6,
  [142] = 33,
  [143] = 35,
  [144] = 32,
  [145] = 12,
  [146] = 29,
  [147] = 4,
  [148] = 7,
  [149] = 31,
  [150] = 12,
  [151] = 6,
  [152] = 29,
  [153] = 11,
  [154] = 28,
  [155] = 7,
  [156] = 4,
  [157] = 26,
  [158] = 7,
  [159] = 31,
  [160] = 26,
  [161] = 5,
  [162] = 15,
  [163] = 9,
  [164] = 13,
  [165] = 2,
  [166] = 22,
  [167] = 22,
  [168] = 2,
  [169] = 13,
  [170] = 10,
  [171] = 9,
  [172] = 18,
  [173] = 28,
  [174] = 3,
  [175] = 175,
  [176] = 11,
  [177] = 177,
  [178] = 6,
  [179] = 9,
  [180] = 12,
  [181] = 16,
  [182] = 18,
  [183] = 16,
  [184] = 10,
  [185] = 4,
  [186] = 13,
  [187] = 5,
  [188] = 2,
  [189] = 15,
  [190] = 22,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 192,
  [195] = 195,
  [196] = 195,
  [197] = 195,
  [198] = 192,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 199,
  [203] = 203,
  [204] = 200,
  [205] = 192,
  [206] = 201,
  [207] = 192,
  [208] = 199,
  [209] = 195,
  [210] = 210,
  [211] = 201,
  [212] = 210,
  [213] = 199,
  [214] = 214,
  [215] = 203,
  [216] = 214,
  [217] = 193,
  [218] = 218,
  [219] = 210,
  [220] = 218,
  [221] = 201,
  [222] = 200,
  [223] = 214,
  [224] = 210,
  [225] = 199,
  [226] = 203,
  [227] = 201,
  [228] = 200,
  [229] = 195,
  [230] = 192,
  [231] = 200,
  [232] = 218,
  [233] = 210,
  [234] = 218,
  [235] = 214,
  [236] = 193,
  [237] = 193,
  [238] = 214,
  [239] = 203,
  [240] = 214,
  [241] = 195,
  [242] = 203,
  [243] = 210,
  [244] = 200,
  [245] = 193,
  [246] = 218,
  [247] = 201,
  [248] = 218,
  [249] = 210,
  [250] = 218,
  [251] = 193,
  [252] = 199,
  [253] = 193,
  [254] = 203,
  [255] = 192,
  [256] = 201,
  [257] = 203,
  [258] = 195,
  [259] = 200,
  [260] = 199,
  [261] = 214,
  [262] = 262,
  [263] = 262,
  [264] = 262,
  [265] = 262,
  [266] = 266,
  [267] = 262,
  [268] = 262,
  [269] = 269,
  [270] = 270,
  [271] = 270,
  [272] = 272,
  [273] = 273,
  [274] = 270,
  [275] = 270,
  [276] = 270,
  [277] = 270,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 280,
  [283] = 281,
  [284] = 280,
  [285] = 281,
  [286] = 281,
  [287] = 281,
  [288] = 281,
  [289] = 281,
  [290] = 280,
  [291] = 280,
  [292] = 280,
  [293] = 280,
  [294] = 294,
  [295] = 295,
  [296] = 295,
  [297] = 294,
  [298] = 294,
  [299] = 295,
  [300] = 295,
  [301] = 295,
  [302] = 294,
  [303] = 295,
  [304] = 295,
  [305] = 294,
  [306] = 294,
  [307] = 294,
  [308] = 279,
  [309] = 273,
  [310] = 310,
  [311] = 279,
  [312] = 310,
  [313] = 310,
  [314] = 310,
  [315] = 273,
  [316] = 273,
  [317] = 317,
  [318] = 318,
  [319] = 279,
  [320] = 273,
  [321] = 279,
  [322] = 322,
  [323] = 323,
  [324] = 323,
  [325] = 325,
  [326] = 326,
  [327] = 325,
  [328] = 323,
  [329] = 325,
  [330] = 323,
  [331] = 325,
  [332] = 326,
  [333] = 325,
  [334] = 326,
  [335] = 326,
  [336] = 325,
  [337] = 337,
  [338] = 323,
  [339] = 323,
  [340] = 340,
  [341] = 325,
  [342] = 323,
  [343] = 326,
  [344] = 326,
  [345] = 326,
  [346] = 346,
  [347] = 322,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 322,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 322,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 322,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 346,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 354,
  [409] = 353,
  [410] = 348,
  [411] = 411,
  [412] = 358,
  [413] = 351,
  [414] = 350,
  [415] = 352,
  [416] = 355,
  [417] = 359,
  [418] = 356,
  [419] = 406,
  [420] = 395,
  [421] = 382,
  [422] = 384,
  [423] = 385,
  [424] = 386,
  [425] = 387,
  [426] = 388,
  [427] = 390,
  [428] = 362,
  [429] = 392,
  [430] = 393,
  [431] = 394,
  [432] = 395,
  [433] = 396,
  [434] = 397,
  [435] = 398,
  [436] = 399,
  [437] = 364,
  [438] = 401,
  [439] = 402,
  [440] = 403,
  [441] = 399,
  [442] = 404,
  [443] = 405,
  [444] = 406,
  [445] = 407,
  [446] = 400,
  [447] = 398,
  [448] = 397,
  [449] = 389,
  [450] = 380,
  [451] = 372,
  [452] = 373,
  [453] = 375,
  [454] = 376,
  [455] = 377,
  [456] = 378,
  [457] = 405,
  [458] = 364,
  [459] = 381,
  [460] = 382,
  [461] = 384,
  [462] = 385,
  [463] = 386,
  [464] = 387,
  [465] = 388,
  [466] = 390,
  [467] = 362,
  [468] = 392,
  [469] = 393,
  [470] = 394,
  [471] = 395,
  [472] = 396,
  [473] = 397,
  [474] = 398,
  [475] = 399,
  [476] = 364,
  [477] = 401,
  [478] = 402,
  [479] = 403,
  [480] = 401,
  [481] = 404,
  [482] = 405,
  [483] = 403,
  [484] = 407,
  [485] = 400,
  [486] = 402,
  [487] = 378,
  [488] = 389,
  [489] = 380,
  [490] = 396,
  [491] = 395,
  [492] = 394,
  [493] = 393,
  [494] = 392,
  [495] = 362,
  [496] = 390,
  [497] = 346,
  [498] = 388,
  [499] = 377,
  [500] = 386,
  [501] = 385,
  [502] = 384,
  [503] = 382,
  [504] = 381,
  [505] = 376,
  [506] = 378,
  [507] = 377,
  [508] = 376,
  [509] = 375,
  [510] = 373,
  [511] = 372,
  [512] = 375,
  [513] = 373,
  [514] = 372,
  [515] = 380,
  [516] = 389,
  [517] = 405,
  [518] = 406,
  [519] = 400,
  [520] = 407,
  [521] = 406,
  [522] = 404,
  [523] = 404,
  [524] = 387,
  [525] = 407,
  [526] = 403,
  [527] = 402,
  [528] = 401,
  [529] = 364,
  [530] = 399,
  [531] = 398,
  [532] = 397,
  [533] = 400,
  [534] = 396,
  [535] = 381,
  [536] = 394,
  [537] = 393,
  [538] = 392,
  [539] = 362,
  [540] = 390,
  [541] = 388,
  [542] = 387,
  [543] = 386,
  [544] = 385,
  [545] = 384,
  [546] = 382,
  [547] = 381,
  [548] = 389,
  [549] = 372,
  [550] = 380,
  [551] = 551,
  [552] = 389,
  [553] = 378,
  [554] = 377,
  [555] = 376,
  [556] = 400,
  [557] = 407,
  [558] = 406,
  [559] = 405,
  [560] = 404,
  [561] = 375,
  [562] = 373,
  [563] = 372,
  [564] = 380,
  [565] = 389,
  [566] = 403,
  [567] = 402,
  [568] = 401,
  [569] = 364,
  [570] = 399,
  [571] = 398,
  [572] = 400,
  [573] = 407,
  [574] = 397,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 406,
  [581] = 380,
  [582] = 405,
  [583] = 404,
  [584] = 373,
  [585] = 403,
  [586] = 402,
  [587] = 401,
  [588] = 364,
  [589] = 396,
  [590] = 395,
  [591] = 394,
  [592] = 393,
  [593] = 392,
  [594] = 362,
  [595] = 399,
  [596] = 398,
  [597] = 390,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 397,
  [604] = 372,
  [605] = 396,
  [606] = 395,
  [607] = 394,
  [608] = 393,
  [609] = 392,
  [610] = 388,
  [611] = 387,
  [612] = 386,
  [613] = 385,
  [614] = 362,
  [615] = 390,
  [616] = 384,
  [617] = 375,
  [618] = 382,
  [619] = 388,
  [620] = 387,
  [621] = 386,
  [622] = 381,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 385,
  [629] = 384,
  [630] = 382,
  [631] = 381,
  [632] = 378,
  [633] = 377,
  [634] = 378,
  [635] = 376,
  [636] = 377,
  [637] = 375,
  [638] = 376,
  [639] = 373,
  [640] = 346,
  [641] = 356,
  [642] = 354,
  [643] = 643,
  [644] = 359,
  [645] = 355,
  [646] = 346,
  [647] = 352,
  [648] = 350,
  [649] = 351,
  [650] = 359,
  [651] = 356,
  [652] = 355,
  [653] = 356,
  [654] = 352,
  [655] = 354,
  [656] = 351,
  [657] = 359,
  [658] = 355,
  [659] = 356,
  [660] = 352,
  [661] = 354,
  [662] = 350,
  [663] = 351,
  [664] = 359,
  [665] = 355,
  [666] = 352,
  [667] = 350,
  [668] = 351,
  [669] = 350,
  [670] = 354,
  [671] = 359,
  [672] = 355,
  [673] = 352,
  [674] = 350,
  [675] = 351,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 676,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 677,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 690,
  [705] = 683,
  [706] = 706,
  [707] = 703,
  [708] = 702,
  [709] = 692,
  [710] = 693,
  [711] = 676,
  [712] = 695,
  [713] = 696,
  [714] = 697,
  [715] = 698,
  [716] = 677,
  [717] = 701,
  [718] = 702,
  [719] = 703,
  [720] = 690,
  [721] = 698,
  [722] = 683,
  [723] = 701,
  [724] = 700,
  [725] = 677,
  [726] = 692,
  [727] = 693,
  [728] = 676,
  [729] = 695,
  [730] = 696,
  [731] = 358,
  [732] = 697,
  [733] = 348,
  [734] = 698,
  [735] = 353,
  [736] = 677,
  [737] = 700,
  [738] = 701,
  [739] = 702,
  [740] = 703,
  [741] = 690,
  [742] = 683,
  [743] = 698,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 692,
  [748] = 693,
  [749] = 676,
  [750] = 750,
  [751] = 695,
  [752] = 676,
  [753] = 696,
  [754] = 697,
  [755] = 698,
  [756] = 677,
  [757] = 700,
  [758] = 692,
  [759] = 693,
  [760] = 701,
  [761] = 702,
  [762] = 703,
  [763] = 690,
  [764] = 683,
  [765] = 690,
  [766] = 703,
  [767] = 702,
  [768] = 701,
  [769] = 700,
  [770] = 677,
  [771] = 698,
  [772] = 697,
  [773] = 696,
  [774] = 695,
  [775] = 683,
  [776] = 693,
  [777] = 692,
  [778] = 778,
  [779] = 695,
  [780] = 780,
  [781] = 697,
  [782] = 696,
  [783] = 683,
  [784] = 690,
  [785] = 703,
  [786] = 702,
  [787] = 701,
  [788] = 696,
  [789] = 700,
  [790] = 692,
  [791] = 697,
  [792] = 700,
  [793] = 695,
  [794] = 676,
  [795] = 693,
  [796] = 796,
  [797] = 797,
  [798] = 797,
  [799] = 796,
  [800] = 796,
  [801] = 797,
  [802] = 796,
  [803] = 796,
  [804] = 796,
  [805] = 797,
  [806] = 796,
  [807] = 797,
  [808] = 797,
  [809] = 797,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 814,
  [817] = 817,
  [818] = 818,
  [819] = 812,
  [820] = 820,
  [821] = 820,
  [822] = 811,
  [823] = 823,
  [824] = 810,
  [825] = 825,
  [826] = 826,
  [827] = 811,
  [828] = 828,
  [829] = 828,
  [830] = 826,
  [831] = 810,
  [832] = 818,
  [833] = 818,
  [834] = 823,
  [835] = 353,
  [836] = 812,
  [837] = 348,
  [838] = 820,
  [839] = 811,
  [840] = 817,
  [841] = 828,
  [842] = 826,
  [843] = 810,
  [844] = 823,
  [845] = 823,
  [846] = 814,
  [847] = 815,
  [848] = 358,
  [849] = 826,
  [850] = 815,
  [851] = 817,
  [852] = 814,
  [853] = 814,
  [854] = 817,
  [855] = 855,
  [856] = 812,
  [857] = 820,
  [858] = 811,
  [859] = 828,
  [860] = 826,
  [861] = 823,
  [862] = 810,
  [863] = 818,
  [864] = 823,
  [865] = 810,
  [866] = 826,
  [867] = 828,
  [868] = 818,
  [869] = 818,
  [870] = 815,
  [871] = 812,
  [872] = 828,
  [873] = 814,
  [874] = 817,
  [875] = 812,
  [876] = 820,
  [877] = 811,
  [878] = 855,
  [879] = 813,
  [880] = 823,
  [881] = 810,
  [882] = 855,
  [883] = 813,
  [884] = 826,
  [885] = 828,
  [886] = 855,
  [887] = 813,
  [888] = 811,
  [889] = 889,
  [890] = 855,
  [891] = 813,
  [892] = 820,
  [893] = 818,
  [894] = 855,
  [895] = 813,
  [896] = 820,
  [897] = 814,
  [898] = 855,
  [899] = 813,
  [900] = 817,
  [901] = 812,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(25);
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == ',') ADVANCE(41);
      if (lookahead == ':') ADVANCE(40);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(42);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'') ADVANCE(49);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'') ADVANCE(49);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'') ADVANCE(49);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'' &&
          lookahead != '(') ADVANCE(49);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ',') ADVANCE(41);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(49);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ',') ADVANCE(41);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(49);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(47);
      if (lookahead == 'E') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead != 0) ADVANCE(46);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(49);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0) ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '}') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(53);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      END_STATE();
    case 10:
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\'' &&
          lookahead != '(') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ':') ADVANCE(40);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(49);
      END_STATE();
    case 12:
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ':') ADVANCE(40);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(49);
      END_STATE();
    case 13:
      if (lookahead == ';') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(29);
      if (lookahead == 'r') ADVANCE(28);
      if (lookahead == 't') ADVANCE(27);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(26);
      END_STATE();
    case 14:
      if (lookahead == 'C') ADVANCE(16);
      END_STATE();
    case 15:
      if (lookahead == 'E') ADVANCE(37);
      END_STATE();
    case 16:
      if (lookahead == 'H') ADVANCE(15);
      END_STATE();
    case 17:
      if (lookahead == 'V') ADVANCE(36);
      END_STATE();
    case 18:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(113);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 19:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(120);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 20:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(122);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 21:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(123);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 22:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(124);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 23:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(125);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 24:
      if (eof) ADVANCE(25);
      if (lookahead == '}') ADVANCE(35);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(sym__escape_identity);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_BSLASHt);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_BSLASHr);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_BSLASHn);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_BSLASH_SEMI);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_ENV);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_CACHE);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym__gen_exp_arguments_token1);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(aux_sym__untrimmed_argument_token1);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      if (lookahead == 'A') ADVANCE(14);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      if (lookahead == 'N') ADVANCE(17);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == 'A') ADVANCE(14);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == 'N') ADVANCE(17);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(57);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(aux_sym_if_command_token1);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(52);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(49);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(52);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(49);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(57);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_elseif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_else);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_endif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_foreach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_endforeach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_endwhile);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_function);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_endfunction);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_macro);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_endmacro);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_block);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_endblock);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(116);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(106);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(135);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(108);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 24, .external_lex_state = 2},
  [2] = {.lex_state = 2, .external_lex_state = 1},
  [3] = {.lex_state = 2, .external_lex_state = 1},
  [4] = {.lex_state = 2, .external_lex_state = 1},
  [5] = {.lex_state = 2, .external_lex_state = 1},
  [6] = {.lex_state = 2, .external_lex_state = 1},
  [7] = {.lex_state = 2, .external_lex_state = 1},
  [8] = {.lex_state = 2, .external_lex_state = 1},
  [9] = {.lex_state = 2, .external_lex_state = 1},
  [10] = {.lex_state = 18, .external_lex_state = 2},
  [11] = {.lex_state = 2, .external_lex_state = 1},
  [12] = {.lex_state = 2, .external_lex_state = 1},
  [13] = {.lex_state = 2, .external_lex_state = 1},
  [14] = {.lex_state = 2, .external_lex_state = 1},
  [15] = {.lex_state = 2, .external_lex_state = 1},
  [16] = {.lex_state = 2, .external_lex_state = 1},
  [17] = {.lex_state = 2, .external_lex_state = 1},
  [18] = {.lex_state = 2, .external_lex_state = 1},
  [19] = {.lex_state = 2, .external_lex_state = 1},
  [20] = {.lex_state = 2, .external_lex_state = 1},
  [21] = {.lex_state = 2, .external_lex_state = 1},
  [22] = {.lex_state = 2, .external_lex_state = 1},
  [23] = {.lex_state = 2, .external_lex_state = 1},
  [24] = {.lex_state = 18, .external_lex_state = 2},
  [25] = {.lex_state = 2, .external_lex_state = 1},
  [26] = {.lex_state = 2, .external_lex_state = 1},
  [27] = {.lex_state = 2, .external_lex_state = 1},
  [28] = {.lex_state = 2, .external_lex_state = 1},
  [29] = {.lex_state = 2, .external_lex_state = 1},
  [30] = {.lex_state = 2, .external_lex_state = 1},
  [31] = {.lex_state = 2, .external_lex_state = 1},
  [32] = {.lex_state = 2, .external_lex_state = 1},
  [33] = {.lex_state = 2, .external_lex_state = 1},
  [34] = {.lex_state = 18, .external_lex_state = 2},
  [35] = {.lex_state = 18, .external_lex_state = 2},
  [36] = {.lex_state = 2, .external_lex_state = 1},
  [37] = {.lex_state = 18, .external_lex_state = 2},
  [38] = {.lex_state = 2, .external_lex_state = 1},
  [39] = {.lex_state = 2, .external_lex_state = 1},
  [40] = {.lex_state = 2, .external_lex_state = 1},
  [41] = {.lex_state = 2, .external_lex_state = 1},
  [42] = {.lex_state = 18, .external_lex_state = 2},
  [43] = {.lex_state = 2, .external_lex_state = 1},
  [44] = {.lex_state = 2, .external_lex_state = 1},
  [45] = {.lex_state = 2, .external_lex_state = 1},
  [46] = {.lex_state = 2, .external_lex_state = 1},
  [47] = {.lex_state = 2, .external_lex_state = 1},
  [48] = {.lex_state = 2, .external_lex_state = 1},
  [49] = {.lex_state = 2, .external_lex_state = 1},
  [50] = {.lex_state = 2, .external_lex_state = 1},
  [51] = {.lex_state = 2, .external_lex_state = 1},
  [52] = {.lex_state = 18, .external_lex_state = 2},
  [53] = {.lex_state = 18, .external_lex_state = 2},
  [54] = {.lex_state = 2, .external_lex_state = 1},
  [55] = {.lex_state = 2, .external_lex_state = 1},
  [56] = {.lex_state = 2, .external_lex_state = 1},
  [57] = {.lex_state = 2, .external_lex_state = 1},
  [58] = {.lex_state = 2, .external_lex_state = 1},
  [59] = {.lex_state = 2, .external_lex_state = 1},
  [60] = {.lex_state = 2, .external_lex_state = 1},
  [61] = {.lex_state = 2, .external_lex_state = 1},
  [62] = {.lex_state = 2, .external_lex_state = 1},
  [63] = {.lex_state = 2, .external_lex_state = 1},
  [64] = {.lex_state = 2, .external_lex_state = 1},
  [65] = {.lex_state = 2, .external_lex_state = 1},
  [66] = {.lex_state = 2, .external_lex_state = 1},
  [67] = {.lex_state = 2, .external_lex_state = 1},
  [68] = {.lex_state = 2, .external_lex_state = 1},
  [69] = {.lex_state = 2, .external_lex_state = 1},
  [70] = {.lex_state = 2, .external_lex_state = 1},
  [71] = {.lex_state = 2, .external_lex_state = 1},
  [72] = {.lex_state = 2, .external_lex_state = 1},
  [73] = {.lex_state = 2, .external_lex_state = 1},
  [74] = {.lex_state = 2, .external_lex_state = 1},
  [75] = {.lex_state = 2, .external_lex_state = 1},
  [76] = {.lex_state = 2, .external_lex_state = 1},
  [77] = {.lex_state = 2, .external_lex_state = 1},
  [78] = {.lex_state = 2, .external_lex_state = 1},
  [79] = {.lex_state = 2, .external_lex_state = 1},
  [80] = {.lex_state = 2, .external_lex_state = 1},
  [81] = {.lex_state = 2, .external_lex_state = 1},
  [82] = {.lex_state = 2, .external_lex_state = 1},
  [83] = {.lex_state = 2, .external_lex_state = 1},
  [84] = {.lex_state = 2, .external_lex_state = 1},
  [85] = {.lex_state = 2, .external_lex_state = 1},
  [86] = {.lex_state = 2, .external_lex_state = 1},
  [87] = {.lex_state = 2, .external_lex_state = 1},
  [88] = {.lex_state = 2, .external_lex_state = 1},
  [89] = {.lex_state = 2, .external_lex_state = 1},
  [90] = {.lex_state = 2, .external_lex_state = 1},
  [91] = {.lex_state = 2, .external_lex_state = 1},
  [92] = {.lex_state = 2, .external_lex_state = 1},
  [93] = {.lex_state = 2, .external_lex_state = 1},
  [94] = {.lex_state = 2, .external_lex_state = 1},
  [95] = {.lex_state = 2, .external_lex_state = 1},
  [96] = {.lex_state = 2, .external_lex_state = 1},
  [97] = {.lex_state = 2, .external_lex_state = 1},
  [98] = {.lex_state = 2, .external_lex_state = 1},
  [99] = {.lex_state = 2, .external_lex_state = 1},
  [100] = {.lex_state = 2, .external_lex_state = 1},
  [101] = {.lex_state = 2, .external_lex_state = 1},
  [102] = {.lex_state = 2, .external_lex_state = 1},
  [103] = {.lex_state = 2, .external_lex_state = 1},
  [104] = {.lex_state = 2, .external_lex_state = 1},
  [105] = {.lex_state = 2, .external_lex_state = 1},
  [106] = {.lex_state = 2, .external_lex_state = 1},
  [107] = {.lex_state = 2, .external_lex_state = 1},
  [108] = {.lex_state = 2, .external_lex_state = 1},
  [109] = {.lex_state = 2, .external_lex_state = 1},
  [110] = {.lex_state = 2, .external_lex_state = 1},
  [111] = {.lex_state = 2, .external_lex_state = 1},
  [112] = {.lex_state = 2, .external_lex_state = 1},
  [113] = {.lex_state = 2, .external_lex_state = 1},
  [114] = {.lex_state = 2, .external_lex_state = 1},
  [115] = {.lex_state = 2, .external_lex_state = 1},
  [116] = {.lex_state = 2, .external_lex_state = 1},
  [117] = {.lex_state = 2, .external_lex_state = 1},
  [118] = {.lex_state = 2, .external_lex_state = 1},
  [119] = {.lex_state = 2, .external_lex_state = 1},
  [120] = {.lex_state = 2, .external_lex_state = 1},
  [121] = {.lex_state = 2, .external_lex_state = 1},
  [122] = {.lex_state = 2, .external_lex_state = 1},
  [123] = {.lex_state = 2, .external_lex_state = 1},
  [124] = {.lex_state = 2, .external_lex_state = 1},
  [125] = {.lex_state = 2, .external_lex_state = 1},
  [126] = {.lex_state = 2, .external_lex_state = 1},
  [127] = {.lex_state = 18, .external_lex_state = 2},
  [128] = {.lex_state = 2, .external_lex_state = 1},
  [129] = {.lex_state = 18, .external_lex_state = 2},
  [130] = {.lex_state = 2, .external_lex_state = 1},
  [131] = {.lex_state = 2, .external_lex_state = 1},
  [132] = {.lex_state = 2, .external_lex_state = 1},
  [133] = {.lex_state = 2, .external_lex_state = 1},
  [134] = {.lex_state = 2, .external_lex_state = 1},
  [135] = {.lex_state = 2, .external_lex_state = 1},
  [136] = {.lex_state = 2, .external_lex_state = 1},
  [137] = {.lex_state = 18, .external_lex_state = 2},
  [138] = {.lex_state = 2, .external_lex_state = 1},
  [139] = {.lex_state = 2, .external_lex_state = 1},
  [140] = {.lex_state = 2, .external_lex_state = 1},
  [141] = {.lex_state = 2, .external_lex_state = 1},
  [142] = {.lex_state = 2, .external_lex_state = 1},
  [143] = {.lex_state = 18, .external_lex_state = 2},
  [144] = {.lex_state = 2, .external_lex_state = 1},
  [145] = {.lex_state = 2, .external_lex_state = 1},
  [146] = {.lex_state = 2, .external_lex_state = 1},
  [147] = {.lex_state = 2, .external_lex_state = 1},
  [148] = {.lex_state = 2, .external_lex_state = 1},
  [149] = {.lex_state = 2, .external_lex_state = 1},
  [150] = {.lex_state = 2, .external_lex_state = 1},
  [151] = {.lex_state = 2, .external_lex_state = 1},
  [152] = {.lex_state = 2, .external_lex_state = 1},
  [153] = {.lex_state = 2, .external_lex_state = 1},
  [154] = {.lex_state = 2, .external_lex_state = 1},
  [155] = {.lex_state = 2, .external_lex_state = 1},
  [156] = {.lex_state = 2, .external_lex_state = 1},
  [157] = {.lex_state = 2, .external_lex_state = 1},
  [158] = {.lex_state = 2, .external_lex_state = 1},
  [159] = {.lex_state = 2, .external_lex_state = 1},
  [160] = {.lex_state = 2, .external_lex_state = 1},
  [161] = {.lex_state = 2, .external_lex_state = 1},
  [162] = {.lex_state = 2, .external_lex_state = 1},
  [163] = {.lex_state = 2, .external_lex_state = 1},
  [164] = {.lex_state = 2, .external_lex_state = 1},
  [165] = {.lex_state = 2, .external_lex_state = 1},
  [166] = {.lex_state = 2, .external_lex_state = 1},
  [167] = {.lex_state = 2, .external_lex_state = 1},
  [168] = {.lex_state = 2, .external_lex_state = 1},
  [169] = {.lex_state = 2, .external_lex_state = 1},
  [170] = {.lex_state = 18, .external_lex_state = 2},
  [171] = {.lex_state = 2, .external_lex_state = 1},
  [172] = {.lex_state = 2, .external_lex_state = 1},
  [173] = {.lex_state = 2, .external_lex_state = 1},
  [174] = {.lex_state = 2, .external_lex_state = 1},
  [175] = {.lex_state = 2, .external_lex_state = 1},
  [176] = {.lex_state = 2, .external_lex_state = 1},
  [177] = {.lex_state = 2, .external_lex_state = 1},
  [178] = {.lex_state = 2, .external_lex_state = 1},
  [179] = {.lex_state = 2, .external_lex_state = 1},
  [180] = {.lex_state = 2, .external_lex_state = 1},
  [181] = {.lex_state = 2, .external_lex_state = 1},
  [182] = {.lex_state = 2, .external_lex_state = 1},
  [183] = {.lex_state = 2, .external_lex_state = 1},
  [184] = {.lex_state = 18, .external_lex_state = 2},
  [185] = {.lex_state = 2, .external_lex_state = 1},
  [186] = {.lex_state = 2, .external_lex_state = 1},
  [187] = {.lex_state = 2, .external_lex_state = 1},
  [188] = {.lex_state = 2, .external_lex_state = 1},
  [189] = {.lex_state = 2, .external_lex_state = 1},
  [190] = {.lex_state = 2, .external_lex_state = 1},
  [191] = {.lex_state = 18, .external_lex_state = 2},
  [192] = {.lex_state = 19, .external_lex_state = 2},
  [193] = {.lex_state = 23, .external_lex_state = 2},
  [194] = {.lex_state = 19, .external_lex_state = 2},
  [195] = {.lex_state = 20, .external_lex_state = 2},
  [196] = {.lex_state = 20, .external_lex_state = 2},
  [197] = {.lex_state = 20, .external_lex_state = 2},
  [198] = {.lex_state = 19, .external_lex_state = 2},
  [199] = {.lex_state = 21, .external_lex_state = 2},
  [200] = {.lex_state = 23, .external_lex_state = 2},
  [201] = {.lex_state = 22, .external_lex_state = 2},
  [202] = {.lex_state = 21, .external_lex_state = 2},
  [203] = {.lex_state = 21, .external_lex_state = 2},
  [204] = {.lex_state = 23, .external_lex_state = 2},
  [205] = {.lex_state = 19, .external_lex_state = 2},
  [206] = {.lex_state = 22, .external_lex_state = 2},
  [207] = {.lex_state = 19, .external_lex_state = 2},
  [208] = {.lex_state = 21, .external_lex_state = 2},
  [209] = {.lex_state = 20, .external_lex_state = 2},
  [210] = {.lex_state = 19, .external_lex_state = 2},
  [211] = {.lex_state = 22, .external_lex_state = 2},
  [212] = {.lex_state = 19, .external_lex_state = 2},
  [213] = {.lex_state = 21, .external_lex_state = 2},
  [214] = {.lex_state = 22, .external_lex_state = 2},
  [215] = {.lex_state = 21, .external_lex_state = 2},
  [216] = {.lex_state = 22, .external_lex_state = 2},
  [217] = {.lex_state = 23, .external_lex_state = 2},
  [218] = {.lex_state = 20, .external_lex_state = 2},
  [219] = {.lex_state = 19, .external_lex_state = 2},
  [220] = {.lex_state = 20, .external_lex_state = 2},
  [221] = {.lex_state = 22, .external_lex_state = 2},
  [222] = {.lex_state = 23, .external_lex_state = 2},
  [223] = {.lex_state = 22, .external_lex_state = 2},
  [224] = {.lex_state = 19, .external_lex_state = 2},
  [225] = {.lex_state = 21, .external_lex_state = 2},
  [226] = {.lex_state = 21, .external_lex_state = 2},
  [227] = {.lex_state = 22, .external_lex_state = 2},
  [228] = {.lex_state = 23, .external_lex_state = 2},
  [229] = {.lex_state = 20, .external_lex_state = 2},
  [230] = {.lex_state = 19, .external_lex_state = 2},
  [231] = {.lex_state = 23, .external_lex_state = 2},
  [232] = {.lex_state = 20, .external_lex_state = 2},
  [233] = {.lex_state = 19, .external_lex_state = 2},
  [234] = {.lex_state = 20, .external_lex_state = 2},
  [235] = {.lex_state = 22, .external_lex_state = 2},
  [236] = {.lex_state = 23, .external_lex_state = 2},
  [237] = {.lex_state = 23, .external_lex_state = 2},
  [238] = {.lex_state = 22, .external_lex_state = 2},
  [239] = {.lex_state = 21, .external_lex_state = 2},
  [240] = {.lex_state = 22, .external_lex_state = 2},
  [241] = {.lex_state = 20, .external_lex_state = 2},
  [242] = {.lex_state = 21, .external_lex_state = 2},
  [243] = {.lex_state = 19, .external_lex_state = 2},
  [244] = {.lex_state = 23, .external_lex_state = 2},
  [245] = {.lex_state = 23, .external_lex_state = 2},
  [246] = {.lex_state = 20, .external_lex_state = 2},
  [247] = {.lex_state = 22, .external_lex_state = 2},
  [248] = {.lex_state = 20, .external_lex_state = 2},
  [249] = {.lex_state = 19, .external_lex_state = 2},
  [250] = {.lex_state = 20, .external_lex_state = 2},
  [251] = {.lex_state = 23, .external_lex_state = 2},
  [252] = {.lex_state = 21, .external_lex_state = 2},
  [253] = {.lex_state = 23, .external_lex_state = 2},
  [254] = {.lex_state = 21, .external_lex_state = 2},
  [255] = {.lex_state = 19, .external_lex_state = 2},
  [256] = {.lex_state = 22, .external_lex_state = 2},
  [257] = {.lex_state = 21, .external_lex_state = 2},
  [258] = {.lex_state = 20, .external_lex_state = 2},
  [259] = {.lex_state = 23, .external_lex_state = 2},
  [260] = {.lex_state = 21, .external_lex_state = 2},
  [261] = {.lex_state = 22, .external_lex_state = 2},
  [262] = {.lex_state = 24, .external_lex_state = 2},
  [263] = {.lex_state = 23, .external_lex_state = 2},
  [264] = {.lex_state = 21, .external_lex_state = 2},
  [265] = {.lex_state = 20, .external_lex_state = 2},
  [266] = {.lex_state = 24, .external_lex_state = 2},
  [267] = {.lex_state = 19, .external_lex_state = 2},
  [268] = {.lex_state = 22, .external_lex_state = 2},
  [269] = {.lex_state = 7, .external_lex_state = 3},
  [270] = {.lex_state = 7, .external_lex_state = 3},
  [271] = {.lex_state = 7, .external_lex_state = 3},
  [272] = {.lex_state = 7, .external_lex_state = 3},
  [273] = {.lex_state = 2, .external_lex_state = 1},
  [274] = {.lex_state = 7, .external_lex_state = 3},
  [275] = {.lex_state = 7, .external_lex_state = 3},
  [276] = {.lex_state = 7, .external_lex_state = 3},
  [277] = {.lex_state = 7, .external_lex_state = 3},
  [278] = {.lex_state = 7, .external_lex_state = 3},
  [279] = {.lex_state = 2, .external_lex_state = 1},
  [280] = {.lex_state = 3, .external_lex_state = 3},
  [281] = {.lex_state = 3, .external_lex_state = 3},
  [282] = {.lex_state = 3, .external_lex_state = 3},
  [283] = {.lex_state = 3, .external_lex_state = 3},
  [284] = {.lex_state = 3, .external_lex_state = 3},
  [285] = {.lex_state = 3, .external_lex_state = 3},
  [286] = {.lex_state = 3, .external_lex_state = 3},
  [287] = {.lex_state = 3, .external_lex_state = 3},
  [288] = {.lex_state = 3, .external_lex_state = 3},
  [289] = {.lex_state = 3, .external_lex_state = 3},
  [290] = {.lex_state = 3, .external_lex_state = 3},
  [291] = {.lex_state = 3, .external_lex_state = 3},
  [292] = {.lex_state = 3, .external_lex_state = 3},
  [293] = {.lex_state = 3, .external_lex_state = 3},
  [294] = {.lex_state = 3, .external_lex_state = 3},
  [295] = {.lex_state = 3, .external_lex_state = 3},
  [296] = {.lex_state = 3, .external_lex_state = 3},
  [297] = {.lex_state = 3, .external_lex_state = 3},
  [298] = {.lex_state = 3, .external_lex_state = 3},
  [299] = {.lex_state = 3, .external_lex_state = 3},
  [300] = {.lex_state = 3, .external_lex_state = 3},
  [301] = {.lex_state = 3, .external_lex_state = 3},
  [302] = {.lex_state = 3, .external_lex_state = 3},
  [303] = {.lex_state = 3, .external_lex_state = 3},
  [304] = {.lex_state = 3, .external_lex_state = 3},
  [305] = {.lex_state = 3, .external_lex_state = 3},
  [306] = {.lex_state = 3, .external_lex_state = 3},
  [307] = {.lex_state = 3, .external_lex_state = 3},
  [308] = {.lex_state = 5, .external_lex_state = 3},
  [309] = {.lex_state = 5, .external_lex_state = 3},
  [310] = {.lex_state = 8},
  [311] = {.lex_state = 12},
  [312] = {.lex_state = 8},
  [313] = {.lex_state = 8},
  [314] = {.lex_state = 8},
  [315] = {.lex_state = 12},
  [316] = {.lex_state = 55},
  [317] = {.lex_state = 8},
  [318] = {.lex_state = 8},
  [319] = {.lex_state = 55},
  [320] = {.lex_state = 3},
  [321] = {.lex_state = 3},
  [322] = {.lex_state = 1, .external_lex_state = 1},
  [323] = {.lex_state = 9},
  [324] = {.lex_state = 9},
  [325] = {.lex_state = 9},
  [326] = {.lex_state = 9},
  [327] = {.lex_state = 9},
  [328] = {.lex_state = 9},
  [329] = {.lex_state = 9},
  [330] = {.lex_state = 9},
  [331] = {.lex_state = 9},
  [332] = {.lex_state = 9},
  [333] = {.lex_state = 9},
  [334] = {.lex_state = 9},
  [335] = {.lex_state = 9},
  [336] = {.lex_state = 9},
  [337] = {.lex_state = 9},
  [338] = {.lex_state = 9},
  [339] = {.lex_state = 9},
  [340] = {.lex_state = 9},
  [341] = {.lex_state = 9},
  [342] = {.lex_state = 9},
  [343] = {.lex_state = 9},
  [344] = {.lex_state = 9},
  [345] = {.lex_state = 9},
  [346] = {.lex_state = 2, .external_lex_state = 1},
  [347] = {.lex_state = 4, .external_lex_state = 3},
  [348] = {.lex_state = 2, .external_lex_state = 1},
  [349] = {.lex_state = 2, .external_lex_state = 1},
  [350] = {.lex_state = 2, .external_lex_state = 1},
  [351] = {.lex_state = 2, .external_lex_state = 1},
  [352] = {.lex_state = 2, .external_lex_state = 1},
  [353] = {.lex_state = 2, .external_lex_state = 1},
  [354] = {.lex_state = 2, .external_lex_state = 1},
  [355] = {.lex_state = 2, .external_lex_state = 1},
  [356] = {.lex_state = 2, .external_lex_state = 1},
  [357] = {.lex_state = 2, .external_lex_state = 1},
  [358] = {.lex_state = 2, .external_lex_state = 1},
  [359] = {.lex_state = 2, .external_lex_state = 1},
  [360] = {.lex_state = 11},
  [361] = {.lex_state = 18, .external_lex_state = 2},
  [362] = {.lex_state = 18, .external_lex_state = 2},
  [363] = {.lex_state = 18, .external_lex_state = 2},
  [364] = {.lex_state = 18, .external_lex_state = 2},
  [365] = {.lex_state = 18, .external_lex_state = 2},
  [366] = {.lex_state = 18, .external_lex_state = 2},
  [367] = {.lex_state = 18, .external_lex_state = 2},
  [368] = {.lex_state = 18, .external_lex_state = 2},
  [369] = {.lex_state = 18, .external_lex_state = 2},
  [370] = {.lex_state = 18, .external_lex_state = 2},
  [371] = {.lex_state = 18, .external_lex_state = 2},
  [372] = {.lex_state = 18, .external_lex_state = 2},
  [373] = {.lex_state = 18, .external_lex_state = 2},
  [374] = {.lex_state = 54},
  [375] = {.lex_state = 18, .external_lex_state = 2},
  [376] = {.lex_state = 18, .external_lex_state = 2},
  [377] = {.lex_state = 18, .external_lex_state = 2},
  [378] = {.lex_state = 18, .external_lex_state = 2},
  [379] = {.lex_state = 10},
  [380] = {.lex_state = 18, .external_lex_state = 2},
  [381] = {.lex_state = 18, .external_lex_state = 2},
  [382] = {.lex_state = 18, .external_lex_state = 2},
  [383] = {.lex_state = 5, .external_lex_state = 3},
  [384] = {.lex_state = 18, .external_lex_state = 2},
  [385] = {.lex_state = 18, .external_lex_state = 2},
  [386] = {.lex_state = 18, .external_lex_state = 2},
  [387] = {.lex_state = 18, .external_lex_state = 2},
  [388] = {.lex_state = 18, .external_lex_state = 2},
  [389] = {.lex_state = 18, .external_lex_state = 2},
  [390] = {.lex_state = 18, .external_lex_state = 2},
  [391] = {.lex_state = 6},
  [392] = {.lex_state = 18, .external_lex_state = 2},
  [393] = {.lex_state = 18, .external_lex_state = 2},
  [394] = {.lex_state = 18, .external_lex_state = 2},
  [395] = {.lex_state = 18, .external_lex_state = 2},
  [396] = {.lex_state = 18, .external_lex_state = 2},
  [397] = {.lex_state = 18, .external_lex_state = 2},
  [398] = {.lex_state = 18, .external_lex_state = 2},
  [399] = {.lex_state = 18, .external_lex_state = 2},
  [400] = {.lex_state = 18, .external_lex_state = 2},
  [401] = {.lex_state = 18, .external_lex_state = 2},
  [402] = {.lex_state = 18, .external_lex_state = 2},
  [403] = {.lex_state = 18, .external_lex_state = 2},
  [404] = {.lex_state = 18, .external_lex_state = 2},
  [405] = {.lex_state = 18, .external_lex_state = 2},
  [406] = {.lex_state = 18, .external_lex_state = 2},
  [407] = {.lex_state = 18, .external_lex_state = 2},
  [408] = {.lex_state = 5, .external_lex_state = 3},
  [409] = {.lex_state = 5, .external_lex_state = 3},
  [410] = {.lex_state = 5, .external_lex_state = 3},
  [411] = {.lex_state = 5, .external_lex_state = 3},
  [412] = {.lex_state = 5, .external_lex_state = 3},
  [413] = {.lex_state = 5, .external_lex_state = 3},
  [414] = {.lex_state = 5, .external_lex_state = 3},
  [415] = {.lex_state = 5, .external_lex_state = 3},
  [416] = {.lex_state = 5, .external_lex_state = 3},
  [417] = {.lex_state = 5, .external_lex_state = 3},
  [418] = {.lex_state = 5, .external_lex_state = 3},
  [419] = {.lex_state = 21, .external_lex_state = 2},
  [420] = {.lex_state = 23, .external_lex_state = 2},
  [421] = {.lex_state = 22, .external_lex_state = 2},
  [422] = {.lex_state = 22, .external_lex_state = 2},
  [423] = {.lex_state = 22, .external_lex_state = 2},
  [424] = {.lex_state = 22, .external_lex_state = 2},
  [425] = {.lex_state = 22, .external_lex_state = 2},
  [426] = {.lex_state = 22, .external_lex_state = 2},
  [427] = {.lex_state = 22, .external_lex_state = 2},
  [428] = {.lex_state = 22, .external_lex_state = 2},
  [429] = {.lex_state = 22, .external_lex_state = 2},
  [430] = {.lex_state = 22, .external_lex_state = 2},
  [431] = {.lex_state = 22, .external_lex_state = 2},
  [432] = {.lex_state = 22, .external_lex_state = 2},
  [433] = {.lex_state = 22, .external_lex_state = 2},
  [434] = {.lex_state = 22, .external_lex_state = 2},
  [435] = {.lex_state = 22, .external_lex_state = 2},
  [436] = {.lex_state = 22, .external_lex_state = 2},
  [437] = {.lex_state = 22, .external_lex_state = 2},
  [438] = {.lex_state = 22, .external_lex_state = 2},
  [439] = {.lex_state = 22, .external_lex_state = 2},
  [440] = {.lex_state = 22, .external_lex_state = 2},
  [441] = {.lex_state = 19, .external_lex_state = 2},
  [442] = {.lex_state = 22, .external_lex_state = 2},
  [443] = {.lex_state = 22, .external_lex_state = 2},
  [444] = {.lex_state = 22, .external_lex_state = 2},
  [445] = {.lex_state = 22, .external_lex_state = 2},
  [446] = {.lex_state = 22, .external_lex_state = 2},
  [447] = {.lex_state = 19, .external_lex_state = 2},
  [448] = {.lex_state = 19, .external_lex_state = 2},
  [449] = {.lex_state = 22, .external_lex_state = 2},
  [450] = {.lex_state = 22, .external_lex_state = 2},
  [451] = {.lex_state = 21, .external_lex_state = 2},
  [452] = {.lex_state = 21, .external_lex_state = 2},
  [453] = {.lex_state = 21, .external_lex_state = 2},
  [454] = {.lex_state = 21, .external_lex_state = 2},
  [455] = {.lex_state = 21, .external_lex_state = 2},
  [456] = {.lex_state = 21, .external_lex_state = 2},
  [457] = {.lex_state = 23, .external_lex_state = 2},
  [458] = {.lex_state = 19, .external_lex_state = 2},
  [459] = {.lex_state = 21, .external_lex_state = 2},
  [460] = {.lex_state = 21, .external_lex_state = 2},
  [461] = {.lex_state = 21, .external_lex_state = 2},
  [462] = {.lex_state = 21, .external_lex_state = 2},
  [463] = {.lex_state = 21, .external_lex_state = 2},
  [464] = {.lex_state = 21, .external_lex_state = 2},
  [465] = {.lex_state = 21, .external_lex_state = 2},
  [466] = {.lex_state = 21, .external_lex_state = 2},
  [467] = {.lex_state = 21, .external_lex_state = 2},
  [468] = {.lex_state = 21, .external_lex_state = 2},
  [469] = {.lex_state = 21, .external_lex_state = 2},
  [470] = {.lex_state = 21, .external_lex_state = 2},
  [471] = {.lex_state = 21, .external_lex_state = 2},
  [472] = {.lex_state = 21, .external_lex_state = 2},
  [473] = {.lex_state = 21, .external_lex_state = 2},
  [474] = {.lex_state = 21, .external_lex_state = 2},
  [475] = {.lex_state = 21, .external_lex_state = 2},
  [476] = {.lex_state = 21, .external_lex_state = 2},
  [477] = {.lex_state = 21, .external_lex_state = 2},
  [478] = {.lex_state = 21, .external_lex_state = 2},
  [479] = {.lex_state = 21, .external_lex_state = 2},
  [480] = {.lex_state = 19, .external_lex_state = 2},
  [481] = {.lex_state = 21, .external_lex_state = 2},
  [482] = {.lex_state = 21, .external_lex_state = 2},
  [483] = {.lex_state = 19, .external_lex_state = 2},
  [484] = {.lex_state = 21, .external_lex_state = 2},
  [485] = {.lex_state = 21, .external_lex_state = 2},
  [486] = {.lex_state = 19, .external_lex_state = 2},
  [487] = {.lex_state = 22, .external_lex_state = 2},
  [488] = {.lex_state = 21, .external_lex_state = 2},
  [489] = {.lex_state = 21, .external_lex_state = 2},
  [490] = {.lex_state = 19, .external_lex_state = 2},
  [491] = {.lex_state = 19, .external_lex_state = 2},
  [492] = {.lex_state = 19, .external_lex_state = 2},
  [493] = {.lex_state = 19, .external_lex_state = 2},
  [494] = {.lex_state = 19, .external_lex_state = 2},
  [495] = {.lex_state = 19, .external_lex_state = 2},
  [496] = {.lex_state = 19, .external_lex_state = 2},
  [497] = {.lex_state = 12},
  [498] = {.lex_state = 19, .external_lex_state = 2},
  [499] = {.lex_state = 22, .external_lex_state = 2},
  [500] = {.lex_state = 19, .external_lex_state = 2},
  [501] = {.lex_state = 19, .external_lex_state = 2},
  [502] = {.lex_state = 19, .external_lex_state = 2},
  [503] = {.lex_state = 19, .external_lex_state = 2},
  [504] = {.lex_state = 19, .external_lex_state = 2},
  [505] = {.lex_state = 22, .external_lex_state = 2},
  [506] = {.lex_state = 19, .external_lex_state = 2},
  [507] = {.lex_state = 19, .external_lex_state = 2},
  [508] = {.lex_state = 19, .external_lex_state = 2},
  [509] = {.lex_state = 19, .external_lex_state = 2},
  [510] = {.lex_state = 19, .external_lex_state = 2},
  [511] = {.lex_state = 19, .external_lex_state = 2},
  [512] = {.lex_state = 22, .external_lex_state = 2},
  [513] = {.lex_state = 22, .external_lex_state = 2},
  [514] = {.lex_state = 22, .external_lex_state = 2},
  [515] = {.lex_state = 23, .external_lex_state = 2},
  [516] = {.lex_state = 23, .external_lex_state = 2},
  [517] = {.lex_state = 19, .external_lex_state = 2},
  [518] = {.lex_state = 19, .external_lex_state = 2},
  [519] = {.lex_state = 23, .external_lex_state = 2},
  [520] = {.lex_state = 23, .external_lex_state = 2},
  [521] = {.lex_state = 23, .external_lex_state = 2},
  [522] = {.lex_state = 19, .external_lex_state = 2},
  [523] = {.lex_state = 23, .external_lex_state = 2},
  [524] = {.lex_state = 19, .external_lex_state = 2},
  [525] = {.lex_state = 19, .external_lex_state = 2},
  [526] = {.lex_state = 23, .external_lex_state = 2},
  [527] = {.lex_state = 23, .external_lex_state = 2},
  [528] = {.lex_state = 23, .external_lex_state = 2},
  [529] = {.lex_state = 23, .external_lex_state = 2},
  [530] = {.lex_state = 23, .external_lex_state = 2},
  [531] = {.lex_state = 23, .external_lex_state = 2},
  [532] = {.lex_state = 23, .external_lex_state = 2},
  [533] = {.lex_state = 19, .external_lex_state = 2},
  [534] = {.lex_state = 23, .external_lex_state = 2},
  [535] = {.lex_state = 22, .external_lex_state = 2},
  [536] = {.lex_state = 23, .external_lex_state = 2},
  [537] = {.lex_state = 23, .external_lex_state = 2},
  [538] = {.lex_state = 23, .external_lex_state = 2},
  [539] = {.lex_state = 23, .external_lex_state = 2},
  [540] = {.lex_state = 23, .external_lex_state = 2},
  [541] = {.lex_state = 23, .external_lex_state = 2},
  [542] = {.lex_state = 23, .external_lex_state = 2},
  [543] = {.lex_state = 23, .external_lex_state = 2},
  [544] = {.lex_state = 23, .external_lex_state = 2},
  [545] = {.lex_state = 23, .external_lex_state = 2},
  [546] = {.lex_state = 23, .external_lex_state = 2},
  [547] = {.lex_state = 23, .external_lex_state = 2},
  [548] = {.lex_state = 19, .external_lex_state = 2},
  [549] = {.lex_state = 24, .external_lex_state = 2},
  [550] = {.lex_state = 24, .external_lex_state = 2},
  [551] = {.lex_state = 7, .external_lex_state = 3},
  [552] = {.lex_state = 24, .external_lex_state = 2},
  [553] = {.lex_state = 23, .external_lex_state = 2},
  [554] = {.lex_state = 23, .external_lex_state = 2},
  [555] = {.lex_state = 23, .external_lex_state = 2},
  [556] = {.lex_state = 24, .external_lex_state = 2},
  [557] = {.lex_state = 24, .external_lex_state = 2},
  [558] = {.lex_state = 24, .external_lex_state = 2},
  [559] = {.lex_state = 24, .external_lex_state = 2},
  [560] = {.lex_state = 24, .external_lex_state = 2},
  [561] = {.lex_state = 23, .external_lex_state = 2},
  [562] = {.lex_state = 23, .external_lex_state = 2},
  [563] = {.lex_state = 23, .external_lex_state = 2},
  [564] = {.lex_state = 20, .external_lex_state = 2},
  [565] = {.lex_state = 20, .external_lex_state = 2},
  [566] = {.lex_state = 24, .external_lex_state = 2},
  [567] = {.lex_state = 24, .external_lex_state = 2},
  [568] = {.lex_state = 24, .external_lex_state = 2},
  [569] = {.lex_state = 24, .external_lex_state = 2},
  [570] = {.lex_state = 24, .external_lex_state = 2},
  [571] = {.lex_state = 24, .external_lex_state = 2},
  [572] = {.lex_state = 20, .external_lex_state = 2},
  [573] = {.lex_state = 20, .external_lex_state = 2},
  [574] = {.lex_state = 24, .external_lex_state = 2},
  [575] = {.lex_state = 21, .external_lex_state = 2},
  [576] = {.lex_state = 22, .external_lex_state = 2},
  [577] = {.lex_state = 23, .external_lex_state = 2},
  [578] = {.lex_state = 20, .external_lex_state = 2},
  [579] = {.lex_state = 19, .external_lex_state = 2},
  [580] = {.lex_state = 20, .external_lex_state = 2},
  [581] = {.lex_state = 19, .external_lex_state = 2},
  [582] = {.lex_state = 20, .external_lex_state = 2},
  [583] = {.lex_state = 20, .external_lex_state = 2},
  [584] = {.lex_state = 24, .external_lex_state = 2},
  [585] = {.lex_state = 20, .external_lex_state = 2},
  [586] = {.lex_state = 20, .external_lex_state = 2},
  [587] = {.lex_state = 20, .external_lex_state = 2},
  [588] = {.lex_state = 20, .external_lex_state = 2},
  [589] = {.lex_state = 24, .external_lex_state = 2},
  [590] = {.lex_state = 24, .external_lex_state = 2},
  [591] = {.lex_state = 24, .external_lex_state = 2},
  [592] = {.lex_state = 24, .external_lex_state = 2},
  [593] = {.lex_state = 24, .external_lex_state = 2},
  [594] = {.lex_state = 24, .external_lex_state = 2},
  [595] = {.lex_state = 20, .external_lex_state = 2},
  [596] = {.lex_state = 20, .external_lex_state = 2},
  [597] = {.lex_state = 24, .external_lex_state = 2},
  [598] = {.lex_state = 21, .external_lex_state = 2},
  [599] = {.lex_state = 22, .external_lex_state = 2},
  [600] = {.lex_state = 23, .external_lex_state = 2},
  [601] = {.lex_state = 20, .external_lex_state = 2},
  [602] = {.lex_state = 19, .external_lex_state = 2},
  [603] = {.lex_state = 20, .external_lex_state = 2},
  [604] = {.lex_state = 20, .external_lex_state = 2},
  [605] = {.lex_state = 20, .external_lex_state = 2},
  [606] = {.lex_state = 20, .external_lex_state = 2},
  [607] = {.lex_state = 20, .external_lex_state = 2},
  [608] = {.lex_state = 20, .external_lex_state = 2},
  [609] = {.lex_state = 20, .external_lex_state = 2},
  [610] = {.lex_state = 24, .external_lex_state = 2},
  [611] = {.lex_state = 24, .external_lex_state = 2},
  [612] = {.lex_state = 24, .external_lex_state = 2},
  [613] = {.lex_state = 24, .external_lex_state = 2},
  [614] = {.lex_state = 20, .external_lex_state = 2},
  [615] = {.lex_state = 20, .external_lex_state = 2},
  [616] = {.lex_state = 24, .external_lex_state = 2},
  [617] = {.lex_state = 24, .external_lex_state = 2},
  [618] = {.lex_state = 24, .external_lex_state = 2},
  [619] = {.lex_state = 20, .external_lex_state = 2},
  [620] = {.lex_state = 20, .external_lex_state = 2},
  [621] = {.lex_state = 20, .external_lex_state = 2},
  [622] = {.lex_state = 24, .external_lex_state = 2},
  [623] = {.lex_state = 21, .external_lex_state = 2},
  [624] = {.lex_state = 22, .external_lex_state = 2},
  [625] = {.lex_state = 23, .external_lex_state = 2},
  [626] = {.lex_state = 20, .external_lex_state = 2},
  [627] = {.lex_state = 19, .external_lex_state = 2},
  [628] = {.lex_state = 20, .external_lex_state = 2},
  [629] = {.lex_state = 20, .external_lex_state = 2},
  [630] = {.lex_state = 20, .external_lex_state = 2},
  [631] = {.lex_state = 20, .external_lex_state = 2},
  [632] = {.lex_state = 20, .external_lex_state = 2},
  [633] = {.lex_state = 20, .external_lex_state = 2},
  [634] = {.lex_state = 24, .external_lex_state = 2},
  [635] = {.lex_state = 20, .external_lex_state = 2},
  [636] = {.lex_state = 24, .external_lex_state = 2},
  [637] = {.lex_state = 20, .external_lex_state = 2},
  [638] = {.lex_state = 24, .external_lex_state = 2},
  [639] = {.lex_state = 20, .external_lex_state = 2},
  [640] = {.lex_state = 55},
  [641] = {.lex_state = 12},
  [642] = {.lex_state = 12},
  [643] = {.lex_state = 8},
  [644] = {.lex_state = 12},
  [645] = {.lex_state = 12},
  [646] = {.lex_state = 3},
  [647] = {.lex_state = 12},
  [648] = {.lex_state = 12},
  [649] = {.lex_state = 12},
  [650] = {.lex_state = 8},
  [651] = {.lex_state = 55},
  [652] = {.lex_state = 8},
  [653] = {.lex_state = 8},
  [654] = {.lex_state = 8},
  [655] = {.lex_state = 8},
  [656] = {.lex_state = 8},
  [657] = {.lex_state = 3},
  [658] = {.lex_state = 3},
  [659] = {.lex_state = 3},
  [660] = {.lex_state = 3},
  [661] = {.lex_state = 3},
  [662] = {.lex_state = 3},
  [663] = {.lex_state = 3},
  [664] = {.lex_state = 9},
  [665] = {.lex_state = 9},
  [666] = {.lex_state = 9},
  [667] = {.lex_state = 9},
  [668] = {.lex_state = 9},
  [669] = {.lex_state = 8},
  [670] = {.lex_state = 55},
  [671] = {.lex_state = 55},
  [672] = {.lex_state = 55},
  [673] = {.lex_state = 55},
  [674] = {.lex_state = 55},
  [675] = {.lex_state = 55},
  [676] = {.lex_state = 9},
  [677] = {.lex_state = 9},
  [678] = {.lex_state = 9},
  [679] = {.lex_state = 9},
  [680] = {.lex_state = 9},
  [681] = {.lex_state = 9},
  [682] = {.lex_state = 9},
  [683] = {.lex_state = 9},
  [684] = {.lex_state = 9},
  [685] = {.lex_state = 9},
  [686] = {.lex_state = 9},
  [687] = {.lex_state = 9},
  [688] = {.lex_state = 9},
  [689] = {.lex_state = 9},
  [690] = {.lex_state = 9},
  [691] = {.lex_state = 9},
  [692] = {.lex_state = 9},
  [693] = {.lex_state = 9},
  [694] = {.lex_state = 9},
  [695] = {.lex_state = 9},
  [696] = {.lex_state = 9},
  [697] = {.lex_state = 9},
  [698] = {.lex_state = 9},
  [699] = {.lex_state = 9},
  [700] = {.lex_state = 9},
  [701] = {.lex_state = 9},
  [702] = {.lex_state = 9},
  [703] = {.lex_state = 9},
  [704] = {.lex_state = 9},
  [705] = {.lex_state = 9},
  [706] = {.lex_state = 9},
  [707] = {.lex_state = 9},
  [708] = {.lex_state = 9},
  [709] = {.lex_state = 9},
  [710] = {.lex_state = 9},
  [711] = {.lex_state = 9},
  [712] = {.lex_state = 9},
  [713] = {.lex_state = 9},
  [714] = {.lex_state = 9},
  [715] = {.lex_state = 9},
  [716] = {.lex_state = 9},
  [717] = {.lex_state = 9},
  [718] = {.lex_state = 9},
  [719] = {.lex_state = 9},
  [720] = {.lex_state = 9},
  [721] = {.lex_state = 9},
  [722] = {.lex_state = 9},
  [723] = {.lex_state = 9},
  [724] = {.lex_state = 9},
  [725] = {.lex_state = 9},
  [726] = {.lex_state = 9},
  [727] = {.lex_state = 9},
  [728] = {.lex_state = 9},
  [729] = {.lex_state = 9},
  [730] = {.lex_state = 9},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 9},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 9},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 9},
  [737] = {.lex_state = 9},
  [738] = {.lex_state = 9},
  [739] = {.lex_state = 9},
  [740] = {.lex_state = 9},
  [741] = {.lex_state = 9},
  [742] = {.lex_state = 9},
  [743] = {.lex_state = 9},
  [744] = {.lex_state = 9},
  [745] = {.lex_state = 9},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 9},
  [748] = {.lex_state = 9},
  [749] = {.lex_state = 9},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 9},
  [752] = {.lex_state = 9},
  [753] = {.lex_state = 9},
  [754] = {.lex_state = 9},
  [755] = {.lex_state = 9},
  [756] = {.lex_state = 9},
  [757] = {.lex_state = 9},
  [758] = {.lex_state = 9},
  [759] = {.lex_state = 9},
  [760] = {.lex_state = 9},
  [761] = {.lex_state = 9},
  [762] = {.lex_state = 9},
  [763] = {.lex_state = 9},
  [764] = {.lex_state = 9},
  [765] = {.lex_state = 9},
  [766] = {.lex_state = 9},
  [767] = {.lex_state = 9},
  [768] = {.lex_state = 9},
  [769] = {.lex_state = 9},
  [770] = {.lex_state = 9},
  [771] = {.lex_state = 9},
  [772] = {.lex_state = 9},
  [773] = {.lex_state = 9},
  [774] = {.lex_state = 9},
  [775] = {.lex_state = 9},
  [776] = {.lex_state = 9},
  [777] = {.lex_state = 9},
  [778] = {.lex_state = 9},
  [779] = {.lex_state = 9},
  [780] = {.lex_state = 9},
  [781] = {.lex_state = 9},
  [782] = {.lex_state = 9},
  [783] = {.lex_state = 9},
  [784] = {.lex_state = 9},
  [785] = {.lex_state = 9},
  [786] = {.lex_state = 9},
  [787] = {.lex_state = 9},
  [788] = {.lex_state = 9},
  [789] = {.lex_state = 9},
  [790] = {.lex_state = 9},
  [791] = {.lex_state = 9},
  [792] = {.lex_state = 9},
  [793] = {.lex_state = 9},
  [794] = {.lex_state = 9},
  [795] = {.lex_state = 9},
  [796] = {.lex_state = 56},
  [797] = {.lex_state = 56},
  [798] = {.lex_state = 56},
  [799] = {.lex_state = 56},
  [800] = {.lex_state = 56},
  [801] = {.lex_state = 56},
  [802] = {.lex_state = 56},
  [803] = {.lex_state = 56},
  [804] = {.lex_state = 56},
  [805] = {.lex_state = 56},
  [806] = {.lex_state = 56},
  [807] = {.lex_state = 56},
  [808] = {.lex_state = 56},
  [809] = {.lex_state = 56},
  [810] = {.lex_state = 24},
  [811] = {.lex_state = 57},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 24},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 24},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 57},
  [821] = {.lex_state = 57},
  [822] = {.lex_state = 57},
  [823] = {.lex_state = 24},
  [824] = {.lex_state = 24},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 57},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 24},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 24},
  [835] = {.lex_state = 57},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 57},
  [838] = {.lex_state = 57},
  [839] = {.lex_state = 57},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 24},
  [844] = {.lex_state = 24},
  [845] = {.lex_state = 24},
  [846] = {.lex_state = 24},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 57},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 24},
  [853] = {.lex_state = 24},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 57},
  [858] = {.lex_state = 57},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 24},
  [862] = {.lex_state = 24},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 24},
  [865] = {.lex_state = 24},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 24},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 57},
  [877] = {.lex_state = 57},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 24},
  [881] = {.lex_state = 24},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 57},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 57},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 57},
  [897] = {.lex_state = 24},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
};

enum {
  ts_external_token_bracket_argument = 0,
  ts_external_token_bracket_comment = 1,
  ts_external_token_line_comment = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_bracket_argument] = sym_bracket_argument,
  [ts_external_token_bracket_comment] = sym_bracket_comment,
  [ts_external_token_line_comment] = sym_line_comment,
};

static const bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_bracket_argument] = true,
    [ts_external_token_bracket_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [2] = {
    [ts_external_token_bracket_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [3] = {
    [ts_external_token_bracket_argument] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__escape_identity] = ACTIONS(1),
    [anon_sym_BSLASHt] = ACTIONS(1),
    [anon_sym_BSLASHr] = ACTIONS(1),
    [anon_sym_BSLASHn] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_BSLASH_SEMI] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_ENV] = ACTIONS(1),
    [anon_sym_CACHE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [aux_sym__gen_exp_arguments_token1] = ACTIONS(1),
    [aux_sym__untrimmed_argument_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [aux_sym__unquoted_text_token1] = ACTIONS(1),
    [aux_sym_if_command_token1] = ACTIONS(1),
    [sym_bracket_argument] = ACTIONS(1),
    [sym_bracket_comment] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(889),
    [sym_if_command] = STATE(10),
    [sym_if_condition] = STATE(266),
    [sym_foreach_command] = STATE(194),
    [sym_foreach_loop] = STATE(266),
    [sym_while_command] = STATE(196),
    [sym_while_loop] = STATE(266),
    [sym_function_command] = STATE(200),
    [sym_function_def] = STATE(266),
    [sym_macro_command] = STATE(201),
    [sym_macro_def] = STATE(266),
    [sym_block_command] = STATE(202),
    [sym_block_def] = STATE(266),
    [sym_normal_command] = STATE(266),
    [sym__command_invocation] = STATE(266),
    [sym__untrimmed_command_invocation] = STATE(266),
    [aux_sym_source_file_repeat1] = STATE(266),
    [ts_builtin_sym_end] = ACTIONS(3),
    [aux_sym__untrimmed_argument_token1] = ACTIONS(5),
    [sym_if] = ACTIONS(7),
    [sym_foreach] = ACTIONS(9),
    [sym_while] = ACTIONS(11),
    [sym_function] = ACTIONS(13),
    [sym_macro] = ACTIONS(15),
    [sym_block] = ACTIONS(17),
    [sym_identifier] = ACTIONS(19),
    [sym_bracket_comment] = ACTIONS(5),
    [sym_line_comment] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_RPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [59] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(39), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(37), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(190), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [118] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(41), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [177] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(45), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(43), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(108), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [236] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(49), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(14), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [295] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(41), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(51), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(13), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [354] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(55), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(53), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(22), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [413] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(57), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [472] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(65), 1,
      sym_endif,
    ACTIONS(67), 1,
      sym_identifier,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(549), 1,
      sym_endif_command,
    ACTIONS(59), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(35), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [543] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(55), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [602] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(49), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [661] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(69), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [720] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [779] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(73), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(9), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [838] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [897] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(79), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(77), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(59), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [956] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1015] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(85), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(83), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(64), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1074] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(89), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(87), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(11), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1133] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(93), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(91), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(67), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1192] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(95), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1251] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(99), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(97), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(70), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1310] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(103), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(451), 1,
      sym_endif_command,
    ACTIONS(101), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(52), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [1381] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(107), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(105), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(73), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1440] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(111), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(109), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(93), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1499] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(115), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(113), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(76), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1558] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(117), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(78), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1617] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(123), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(121), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(79), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1676] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(127), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(125), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(12), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1735] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(131), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(129), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(58), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1794] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(133), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(56), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1853] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1912] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(139), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(372), 1,
      sym_endif_command,
    ACTIONS(137), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(37), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [1983] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(65), 1,
      sym_endif,
    ACTIONS(67), 1,
      sym_identifier,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(618), 1,
      sym_endif_command,
    ACTIONS(141), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(191), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [2054] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(145), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(143), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(38), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2113] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(139), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(382), 1,
      sym_endif_command,
    ACTIONS(141), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(191), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [2184] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(147), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2243] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(147), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(149), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(48), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2302] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(153), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(151), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(49), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2361] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(155), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(4), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2420] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(159), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(546), 1,
      sym_endif_command,
    ACTIONS(141), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(191), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [2491] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(161), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(33), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2550] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(167), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(165), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(57), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2609] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(171), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(169), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(72), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2668] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(175), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(173), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(89), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2727] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(179), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(177), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(131), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2786] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2845] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(183), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2904] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(183), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(185), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(110), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2963] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(189), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(187), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(16), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3022] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(103), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(460), 1,
      sym_endif_command,
    ACTIONS(141), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(191), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [3093] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(159), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(563), 1,
      sym_endif_command,
    ACTIONS(191), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(42), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [3164] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(195), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(193), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(18), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3223] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(199), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(197), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(109), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3282] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(201), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3341] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(203), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3400] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(205), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3459] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(207), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3518] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(203), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(209), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(116), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3577] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(207), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(211), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(118), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3636] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(205), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(213), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(163), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3695] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(215), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3754] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(217), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3813] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(217), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(219), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(120), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3872] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(221), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3931] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(223), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3990] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(223), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(225), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(122), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4049] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(227), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4108] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4167] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(231), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(124), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4226] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(233), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4285] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(235), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4344] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(235), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(237), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(126), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4403] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(239), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4462] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(241), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4521] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(241), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(243), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(128), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4580] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(245), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4639] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(247), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4698] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(247), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(249), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(130), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4757] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(253), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(251), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(132), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4816] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(245), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(255), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(164), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4875] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(259), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(257), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(135), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4934] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(263), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(261), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(63), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4993] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(267), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(265), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(138), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5052] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(263), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5111] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(271), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(269), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(66), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5170] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(233), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(273), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(2), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5229] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(275), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5288] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(271), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5347] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(279), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(277), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(69), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5406] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(279), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5465] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(281), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5524] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(275), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(283), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(119), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5583] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(287), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(285), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(147), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5642] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(289), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5701] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(281), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(291), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(165), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5760] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(295), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(293), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(150), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5819] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(297), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5878] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(301), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(299), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(75), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5937] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(305), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(303), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(153), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5996] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6055] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(301), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6114] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(309), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6173] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(311), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6232] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(315), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(313), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(96), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6291] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(195), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6350] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(317), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6409] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(319), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6468] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(321), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6527] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(325), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(323), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(86), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6586] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(315), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6645] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(329), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(327), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(90), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6704] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(333), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(331), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(92), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6763] = 13,
    ACTIONS(338), 1,
      anon_sym_DOLLAR,
    ACTIONS(344), 1,
      anon_sym_LPAREN,
    ACTIONS(347), 1,
      anon_sym_RPAREN,
    ACTIONS(349), 1,
      anon_sym_DQUOTE,
    ACTIONS(352), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(355), 1,
      sym_bracket_argument,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(341), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(335), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6822] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(358), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6881] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(317), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(360), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(166), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6940] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(362), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6999] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(364), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7058] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(366), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7117] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(370), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(368), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(103), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7176] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(372), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7235] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(376), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(374), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(104), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7294] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(378), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7353] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(376), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7412] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(380), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7471] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(421), 1,
      sym_endif_command,
    ACTIONS(141), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(191), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7542] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(384), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7601] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(388), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(511), 1,
      sym_endif_command,
    ACTIONS(386), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(137), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7672] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(390), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7731] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(392), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7790] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(394), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7849] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(394), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(396), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(175), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7908] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(400), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(398), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(142), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7967] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(402), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8026] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(402), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(404), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(177), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8085] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(388), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(503), 1,
      sym_endif_command,
    ACTIONS(141), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(191), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [8156] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(406), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8215] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(406), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(408), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(179), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8274] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(392), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(410), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(182), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8333] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(414), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(412), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8392] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(416), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8451] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(418), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(630), 1,
      sym_endif_command,
    ACTIONS(141), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(191), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [8522] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(416), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(420), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(172), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8581] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(414), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8640] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(424), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(422), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(125), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8699] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(426), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8758] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(426), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(428), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(186), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8817] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(432), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(430), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(183), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8876] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(434), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8935] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(434), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(436), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(188), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8994] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(440), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(438), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(107), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9053] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(39), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9112] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(444), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(442), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(185), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9171] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(448), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(446), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9230] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(448), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9289] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(452), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(450), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(180), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9348] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(456), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(454), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(169), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9407] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(460), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(458), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(181), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9466] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(464), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(462), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(145), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9525] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(468), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(466), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(176), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9584] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(472), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(470), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(105), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9643] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(474), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9702] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(476), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9761] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(478), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9820] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(480), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9879] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(482), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9938] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(484), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9997] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(486), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10056] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(514), 1,
      sym_endif_command,
    ACTIONS(488), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(127), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [10127] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(490), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10186] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(492), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10245] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(496), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(494), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(156), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10304] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(500), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(498), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(167), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10363] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(502), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10422] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(500), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10481] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(504), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10540] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(508), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(506), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(168), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10599] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(510), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10658] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(508), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10717] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(472), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10776] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(512), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10835] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(514), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10894] = 19,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(61), 1,
      sym_elseif,
    ACTIONS(63), 1,
      sym_else,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(418), 1,
      sym_endif,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    STATE(604), 1,
      sym_endif_command,
    ACTIONS(516), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(143), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [10965] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(456), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11024] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(518), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11083] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(522), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(520), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(112), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11142] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(524), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11201] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(514), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(526), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(171), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11260] = 13,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(35), 1,
      sym_bracket_argument,
    ACTIONS(528), 1,
      anon_sym_RPAREN,
    STATE(353), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(25), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(273), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11319] = 18,
    ACTIONS(533), 1,
      sym_if,
    ACTIONS(536), 1,
      sym_elseif,
    ACTIONS(539), 1,
      sym_else,
    ACTIONS(542), 1,
      sym_endif,
    ACTIONS(544), 1,
      sym_foreach,
    ACTIONS(547), 1,
      sym_while,
    ACTIONS(550), 1,
      sym_function,
    ACTIONS(553), 1,
      sym_macro,
    ACTIONS(556), 1,
      sym_block,
    ACTIONS(559), 1,
      sym_identifier,
    STATE(34), 1,
      sym_if_command,
    STATE(207), 1,
      sym_foreach_command,
    STATE(209), 1,
      sym_while_command,
    STATE(211), 1,
      sym_macro_command,
    STATE(213), 1,
      sym_block_command,
    STATE(231), 1,
      sym_function_command,
    ACTIONS(530), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(191), 12,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [11387] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(564), 1,
      sym_endforeach,
    ACTIONS(566), 1,
      sym_identifier,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(452), 1,
      sym_endforeach_command,
    ACTIONS(562), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(210), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11450] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(570), 1,
      sym_endfunction,
    ACTIONS(572), 1,
      sym_identifier,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(543), 1,
      sym_endfunction_command,
    ACTIONS(568), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(263), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11513] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(584), 1,
      sym_endforeach_command,
    ACTIONS(574), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(243), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11576] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(580), 1,
      sym_endwhile,
    ACTIONS(582), 1,
      sym_identifier,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(637), 1,
      sym_endwhile_command,
    ACTIONS(578), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(220), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11639] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(586), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(617), 1,
      sym_endwhile_command,
    ACTIONS(584), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(250), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11702] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(590), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(512), 1,
      sym_endwhile_command,
    ACTIONS(588), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(234), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11765] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(594), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(513), 1,
      sym_endforeach_command,
    ACTIONS(592), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(233), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11828] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(598), 1,
      sym_endblock,
    ACTIONS(600), 1,
      sym_identifier,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(487), 1,
      sym_endblock_command,
    ACTIONS(596), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(242), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11891] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(604), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(638), 1,
      sym_endfunction_command,
    ACTIONS(602), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(251), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11954] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(608), 1,
      sym_endmacro,
    ACTIONS(610), 1,
      sym_identifier,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(636), 1,
      sym_endmacro_command,
    ACTIONS(606), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(261), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12017] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(614), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(634), 1,
      sym_endblock_command,
    ACTIONS(612), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(257), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12080] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(618), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(541), 1,
      sym_endblock_command,
    ACTIONS(616), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(264), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12143] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(622), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(635), 1,
      sym_endfunction_command,
    ACTIONS(620), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(253), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12206] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(626), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(639), 1,
      sym_endforeach_command,
    ACTIONS(624), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(212), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12269] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(630), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(633), 1,
      sym_endmacro_command,
    ACTIONS(628), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(223), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12332] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(634), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(373), 1,
      sym_endforeach_command,
    ACTIONS(632), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(224), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12395] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(638), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(632), 1,
      sym_endblock_command,
    ACTIONS(636), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(254), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12458] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(642), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(375), 1,
      sym_endwhile_command,
    ACTIONS(640), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(232), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12521] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(564), 1,
      sym_endforeach,
    ACTIONS(566), 1,
      sym_identifier,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(461), 1,
      sym_endforeach_command,
    ACTIONS(644), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(267), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12584] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(648), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(377), 1,
      sym_endmacro_command,
    ACTIONS(646), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(238), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12647] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(626), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(629), 1,
      sym_endforeach_command,
    ACTIONS(644), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(267), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12710] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(652), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(378), 1,
      sym_endblock_command,
    ACTIONS(650), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(239), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12773] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(656), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(542), 1,
      sym_endmacro_command,
    ACTIONS(654), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(268), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12836] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(658), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(498), 1,
      sym_endblock_command,
    ACTIONS(616), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(264), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12899] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(660), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(524), 1,
      sym_endmacro_command,
    ACTIONS(654), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(268), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12962] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(662), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(500), 1,
      sym_endfunction_command,
    ACTIONS(568), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(263), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13025] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(666), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(501), 1,
      sym_endwhile_command,
    ACTIONS(664), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(265), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13088] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(668), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(502), 1,
      sym_endforeach_command,
    ACTIONS(644), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(267), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13151] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(580), 1,
      sym_endwhile,
    ACTIONS(582), 1,
      sym_identifier,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(628), 1,
      sym_endwhile_command,
    ACTIONS(664), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(265), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13214] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(672), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(499), 1,
      sym_endmacro_command,
    ACTIONS(670), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(240), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13277] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(676), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(505), 1,
      sym_endfunction_command,
    ACTIONS(674), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(236), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13340] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(630), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(620), 1,
      sym_endmacro_command,
    ACTIONS(654), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(268), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13403] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(634), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(384), 1,
      sym_endforeach_command,
    ACTIONS(644), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(267), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13466] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(658), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(506), 1,
      sym_endblock_command,
    ACTIONS(678), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13529] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(680), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(465), 1,
      sym_endblock_command,
    ACTIONS(616), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(264), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13592] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(660), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(507), 1,
      sym_endmacro_command,
    ACTIONS(682), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(216), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13655] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(662), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(508), 1,
      sym_endfunction_command,
    ACTIONS(684), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(217), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13718] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(666), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(509), 1,
      sym_endwhile_command,
    ACTIONS(686), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(218), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13781] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(668), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(510), 1,
      sym_endforeach_command,
    ACTIONS(688), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(219), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13844] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(692), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(376), 1,
      sym_endfunction_command,
    ACTIONS(690), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(237), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13907] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(642), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(385), 1,
      sym_endwhile_command,
    ACTIONS(664), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(265), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [13970] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(594), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(422), 1,
      sym_endforeach_command,
    ACTIONS(644), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(267), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14033] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(590), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(423), 1,
      sym_endwhile_command,
    ACTIONS(664), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(265), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14096] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(694), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(464), 1,
      sym_endmacro_command,
    ACTIONS(654), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(268), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14159] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(676), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(424), 1,
      sym_endfunction_command,
    ACTIONS(568), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(263), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14222] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(692), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(386), 1,
      sym_endfunction_command,
    ACTIONS(568), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(263), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14285] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(648), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(387), 1,
      sym_endmacro_command,
    ACTIONS(654), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(268), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14348] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(652), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(388), 1,
      sym_endblock_command,
    ACTIONS(616), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(264), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14411] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(672), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(425), 1,
      sym_endmacro_command,
    ACTIONS(654), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(268), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14474] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(698), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(453), 1,
      sym_endwhile_command,
    ACTIONS(696), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14537] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(598), 1,
      sym_endblock,
    ACTIONS(600), 1,
      sym_identifier,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(426), 1,
      sym_endblock_command,
    ACTIONS(616), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(264), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14600] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(616), 1,
      sym_endforeach_command,
    ACTIONS(644), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(267), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14663] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(702), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(454), 1,
      sym_endfunction_command,
    ACTIONS(700), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(245), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14726] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(702), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(463), 1,
      sym_endfunction_command,
    ACTIONS(568), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(263), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14789] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(698), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(462), 1,
      sym_endwhile_command,
    ACTIONS(664), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(265), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14852] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(694), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(455), 1,
      sym_endmacro_command,
    ACTIONS(704), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(235), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14915] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(706), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(544), 1,
      sym_endwhile_command,
    ACTIONS(664), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(265), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [14978] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(708), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(545), 1,
      sym_endforeach_command,
    ACTIONS(644), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(267), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15041] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(586), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(613), 1,
      sym_endwhile_command,
    ACTIONS(664), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(265), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15104] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(604), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(612), 1,
      sym_endfunction_command,
    ACTIONS(568), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(263), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15167] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(618), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(553), 1,
      sym_endblock_command,
    ACTIONS(710), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(203), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15230] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(572), 1,
      sym_identifier,
    ACTIONS(622), 1,
      sym_endfunction,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(621), 1,
      sym_endfunction_command,
    ACTIONS(568), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(263), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15293] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(638), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(619), 1,
      sym_endblock_command,
    ACTIONS(616), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(264), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15356] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(708), 1,
      sym_endforeach,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    STATE(562), 1,
      sym_endforeach_command,
    ACTIONS(712), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(249), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15419] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(610), 1,
      sym_identifier,
    ACTIONS(656), 1,
      sym_endmacro,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(554), 1,
      sym_endmacro_command,
    ACTIONS(714), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(214), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15482] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(614), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(610), 1,
      sym_endblock_command,
    ACTIONS(616), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(264), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15545] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(582), 1,
      sym_identifier,
    ACTIONS(706), 1,
      sym_endwhile,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    STATE(561), 1,
      sym_endwhile_command,
    ACTIONS(716), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(248), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15608] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(570), 1,
      sym_endfunction,
    ACTIONS(572), 1,
      sym_identifier,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    STATE(555), 1,
      sym_endfunction_command,
    ACTIONS(718), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(193), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15671] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(600), 1,
      sym_identifier,
    ACTIONS(680), 1,
      sym_endblock,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    STATE(456), 1,
      sym_endblock_command,
    ACTIONS(720), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(226), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15734] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(608), 1,
      sym_endmacro,
    ACTIONS(610), 1,
      sym_identifier,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    STATE(611), 1,
      sym_endmacro_command,
    ACTIONS(654), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(268), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15797] = 16,
    ACTIONS(722), 1,
      ts_builtin_sym_end,
    ACTIONS(727), 1,
      sym_if,
    ACTIONS(730), 1,
      sym_foreach,
    ACTIONS(733), 1,
      sym_while,
    ACTIONS(736), 1,
      sym_function,
    ACTIONS(739), 1,
      sym_macro,
    ACTIONS(742), 1,
      sym_block,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(10), 1,
      sym_if_command,
    STATE(194), 1,
      sym_foreach_command,
    STATE(196), 1,
      sym_while_command,
    STATE(200), 1,
      sym_function_command,
    STATE(201), 1,
      sym_macro_command,
    STATE(202), 1,
      sym_block_command,
    ACTIONS(724), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(262), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15857] = 16,
    ACTIONS(727), 1,
      sym_if,
    ACTIONS(730), 1,
      sym_foreach,
    ACTIONS(733), 1,
      sym_while,
    ACTIONS(736), 1,
      sym_function,
    ACTIONS(739), 1,
      sym_macro,
    ACTIONS(742), 1,
      sym_block,
    ACTIONS(751), 1,
      sym_endfunction,
    ACTIONS(753), 1,
      sym_identifier,
    STATE(53), 1,
      sym_if_command,
    STATE(252), 1,
      sym_block_command,
    STATE(255), 1,
      sym_foreach_command,
    STATE(256), 1,
      sym_macro_command,
    STATE(258), 1,
      sym_while_command,
    STATE(259), 1,
      sym_function_command,
    ACTIONS(748), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(263), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15917] = 16,
    ACTIONS(727), 1,
      sym_if,
    ACTIONS(730), 1,
      sym_foreach,
    ACTIONS(733), 1,
      sym_while,
    ACTIONS(736), 1,
      sym_function,
    ACTIONS(739), 1,
      sym_macro,
    ACTIONS(742), 1,
      sym_block,
    ACTIONS(751), 1,
      sym_endblock,
    ACTIONS(759), 1,
      sym_identifier,
    STATE(24), 1,
      sym_if_command,
    STATE(192), 1,
      sym_foreach_command,
    STATE(241), 1,
      sym_while_command,
    STATE(244), 1,
      sym_function_command,
    STATE(247), 1,
      sym_macro_command,
    STATE(260), 1,
      sym_block_command,
    ACTIONS(756), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(264), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [15977] = 16,
    ACTIONS(727), 1,
      sym_if,
    ACTIONS(730), 1,
      sym_foreach,
    ACTIONS(733), 1,
      sym_while,
    ACTIONS(736), 1,
      sym_function,
    ACTIONS(739), 1,
      sym_macro,
    ACTIONS(742), 1,
      sym_block,
    ACTIONS(751), 1,
      sym_endwhile,
    ACTIONS(765), 1,
      sym_identifier,
    STATE(184), 1,
      sym_if_command,
    STATE(195), 1,
      sym_while_command,
    STATE(204), 1,
      sym_function_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(208), 1,
      sym_block_command,
    ACTIONS(762), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(265), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [16037] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(19), 1,
      sym_identifier,
    ACTIONS(768), 1,
      ts_builtin_sym_end,
    STATE(10), 1,
      sym_if_command,
    STATE(194), 1,
      sym_foreach_command,
    STATE(196), 1,
      sym_while_command,
    STATE(200), 1,
      sym_function_command,
    STATE(201), 1,
      sym_macro_command,
    STATE(202), 1,
      sym_block_command,
    ACTIONS(770), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(262), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [16097] = 16,
    ACTIONS(727), 1,
      sym_if,
    ACTIONS(730), 1,
      sym_foreach,
    ACTIONS(733), 1,
      sym_while,
    ACTIONS(736), 1,
      sym_function,
    ACTIONS(739), 1,
      sym_macro,
    ACTIONS(742), 1,
      sym_block,
    ACTIONS(751), 1,
      sym_endforeach,
    ACTIONS(775), 1,
      sym_identifier,
    STATE(129), 1,
      sym_if_command,
    STATE(225), 1,
      sym_block_command,
    STATE(227), 1,
      sym_macro_command,
    STATE(228), 1,
      sym_function_command,
    STATE(229), 1,
      sym_while_command,
    STATE(230), 1,
      sym_foreach_command,
    ACTIONS(772), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(267), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [16157] = 16,
    ACTIONS(727), 1,
      sym_if,
    ACTIONS(730), 1,
      sym_foreach,
    ACTIONS(733), 1,
      sym_while,
    ACTIONS(736), 1,
      sym_function,
    ACTIONS(739), 1,
      sym_macro,
    ACTIONS(742), 1,
      sym_block,
    ACTIONS(751), 1,
      sym_endmacro,
    ACTIONS(781), 1,
      sym_identifier,
    STATE(170), 1,
      sym_if_command,
    STATE(197), 1,
      sym_while_command,
    STATE(198), 1,
      sym_foreach_command,
    STATE(199), 1,
      sym_block_command,
    STATE(221), 1,
      sym_macro_command,
    STATE(222), 1,
      sym_function_command,
    ACTIONS(778), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(268), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [16217] = 12,
    ACTIONS(787), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_GT,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(795), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(798), 1,
      sym_bracket_argument,
    STATE(269), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(411), 1,
      sym_argument,
    STATE(409), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(417), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(416), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(784), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(309), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16268] = 12,
    ACTIONS(803), 1,
      anon_sym_DOLLAR,
    ACTIONS(805), 1,
      anon_sym_GT,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(809), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(811), 1,
      sym_bracket_argument,
    STATE(746), 1,
      sym_argument,
    STATE(874), 1,
      sym__gen_exp_content,
    STATE(644), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(645), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(801), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(315), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16319] = 12,
    ACTIONS(803), 1,
      anon_sym_DOLLAR,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(809), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(813), 1,
      anon_sym_GT,
    STATE(746), 1,
      sym_argument,
    STATE(854), 1,
      sym__gen_exp_content,
    STATE(644), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(645), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(801), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(315), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16370] = 12,
    ACTIONS(817), 1,
      anon_sym_DOLLAR,
    ACTIONS(819), 1,
      anon_sym_GT,
    ACTIONS(821), 1,
      anon_sym_DQUOTE,
    ACTIONS(823), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(825), 1,
      sym_bracket_argument,
    STATE(278), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(411), 1,
      sym_argument,
    STATE(409), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(417), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(416), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(815), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(309), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16421] = 7,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(829), 1,
      aux_sym__unquoted_text_token1,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(21), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(279), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(827), 7,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [16462] = 12,
    ACTIONS(803), 1,
      anon_sym_DOLLAR,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(809), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(831), 1,
      anon_sym_GT,
    STATE(746), 1,
      sym_argument,
    STATE(900), 1,
      sym__gen_exp_content,
    STATE(644), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(645), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(801), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(315), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16513] = 12,
    ACTIONS(803), 1,
      anon_sym_DOLLAR,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(809), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(833), 1,
      anon_sym_GT,
    STATE(746), 1,
      sym_argument,
    STATE(851), 1,
      sym__gen_exp_content,
    STATE(644), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(645), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(801), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(315), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16564] = 12,
    ACTIONS(803), 1,
      anon_sym_DOLLAR,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(809), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(835), 1,
      anon_sym_GT,
    STATE(746), 1,
      sym_argument,
    STATE(817), 1,
      sym__gen_exp_content,
    STATE(644), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(645), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(801), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(315), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16615] = 12,
    ACTIONS(803), 1,
      anon_sym_DOLLAR,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(809), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(837), 1,
      anon_sym_GT,
    STATE(746), 1,
      sym_argument,
    STATE(840), 1,
      sym__gen_exp_content,
    STATE(644), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(645), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(801), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(315), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16666] = 12,
    ACTIONS(817), 1,
      anon_sym_DOLLAR,
    ACTIONS(821), 1,
      anon_sym_DQUOTE,
    ACTIONS(823), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(825), 1,
      sym_bracket_argument,
    ACTIONS(839), 1,
      anon_sym_GT,
    STATE(269), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(411), 1,
      sym_argument,
    STATE(409), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(417), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(416), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(815), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(309), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16717] = 7,
    ACTIONS(844), 1,
      anon_sym_DOLLAR,
    ACTIONS(849), 1,
      aux_sym__unquoted_text_token1,
    STATE(359), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(355), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(841), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(279), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(847), 7,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [16758] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(856), 1,
      anon_sym_RPAREN,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    STATE(818), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16806] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(860), 1,
      anon_sym_RPAREN,
    STATE(836), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16854] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(862), 1,
      anon_sym_RPAREN,
    STATE(869), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16902] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(864), 1,
      anon_sym_RPAREN,
    STATE(875), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16950] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(866), 1,
      anon_sym_RPAREN,
    STATE(868), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [16998] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(868), 1,
      anon_sym_RPAREN,
    STATE(856), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17046] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(870), 1,
      anon_sym_RPAREN,
    STATE(819), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17094] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(872), 1,
      anon_sym_RPAREN,
    STATE(871), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17142] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(874), 1,
      anon_sym_RPAREN,
    STATE(901), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17190] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(876), 1,
      anon_sym_RPAREN,
    STATE(812), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17238] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(878), 1,
      anon_sym_RPAREN,
    STATE(863), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17286] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(880), 1,
      anon_sym_RPAREN,
    STATE(893), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17334] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(882), 1,
      anon_sym_RPAREN,
    STATE(833), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17382] = 11,
    ACTIONS(807), 1,
      anon_sym_DQUOTE,
    ACTIONS(811), 1,
      sym_bracket_argument,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(884), 1,
      anon_sym_RPAREN,
    STATE(832), 1,
      sym_argument,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(735), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(320), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17430] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(839), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17475] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(821), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17520] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(892), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17565] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(858), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17610] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(888), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17655] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(857), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17700] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(896), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17745] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(876), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17790] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(877), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17835] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(820), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17880] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(838), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17925] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(822), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [17970] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(811), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [18015] = 10,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_DQUOTE,
    ACTIONS(892), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(894), 1,
      sym_bracket_argument,
    STATE(827), 1,
      sym_argument,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(835), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(316), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [18060] = 8,
    ACTIONS(899), 1,
      anon_sym_DOLLAR,
    ACTIONS(902), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(904), 1,
      aux_sym__unquoted_text_token1,
    STATE(417), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(847), 3,
      sym_bracket_argument,
      anon_sym_GT,
      anon_sym_DQUOTE,
    STATE(416), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(896), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(308), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [18100] = 8,
    ACTIONS(817), 1,
      anon_sym_DOLLAR,
    ACTIONS(907), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(909), 1,
      aux_sym__unquoted_text_token1,
    STATE(417), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(827), 3,
      sym_bracket_argument,
      anon_sym_GT,
      anon_sym_DQUOTE,
    STATE(416), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(815), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(308), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [18140] = 8,
    ACTIONS(913), 1,
      anon_sym_DOLLAR,
    ACTIONS(915), 1,
      anon_sym_DQUOTE,
    ACTIONS(917), 1,
      aux_sym__quoted_text_token1,
    STATE(847), 1,
      sym_quoted_element,
    STATE(650), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(652), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(911), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(318), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [18178] = 7,
    ACTIONS(922), 1,
      anon_sym_DOLLAR,
    ACTIONS(925), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(847), 2,
      anon_sym_GT,
      anon_sym_COLON,
    STATE(644), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(645), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(919), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(311), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [18214] = 8,
    ACTIONS(913), 1,
      anon_sym_DOLLAR,
    ACTIONS(917), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(928), 1,
      anon_sym_DQUOTE,
    STATE(815), 1,
      sym_quoted_element,
    STATE(650), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(652), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(911), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(318), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [18252] = 8,
    ACTIONS(913), 1,
      anon_sym_DOLLAR,
    ACTIONS(917), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(930), 1,
      anon_sym_DQUOTE,
    STATE(870), 1,
      sym_quoted_element,
    STATE(650), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(652), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(911), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(318), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [18290] = 8,
    ACTIONS(913), 1,
      anon_sym_DOLLAR,
    ACTIONS(917), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(932), 1,
      anon_sym_DQUOTE,
    STATE(850), 1,
      sym_quoted_element,
    STATE(650), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(652), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(911), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(318), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [18328] = 7,
    ACTIONS(803), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(827), 2,
      anon_sym_GT,
      anon_sym_COLON,
    STATE(644), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(645), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(801), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(311), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [18364] = 7,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(907), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(936), 1,
      aux_sym__unquoted_text_token1,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(886), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(319), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [18399] = 7,
    ACTIONS(941), 1,
      anon_sym_DOLLAR,
    ACTIONS(944), 1,
      anon_sym_DQUOTE,
    ACTIONS(946), 1,
      aux_sym__quoted_text_token1,
    STATE(650), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(652), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(938), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(317), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [18434] = 7,
    ACTIONS(913), 1,
      anon_sym_DOLLAR,
    ACTIONS(949), 1,
      anon_sym_DQUOTE,
    ACTIONS(951), 1,
      aux_sym__quoted_text_token1,
    STATE(650), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(652), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(911), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(317), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [18469] = 7,
    ACTIONS(902), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(956), 1,
      anon_sym_DOLLAR,
    ACTIONS(959), 1,
      aux_sym__unquoted_text_token1,
    STATE(671), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(672), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(953), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(319), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [18504] = 7,
    ACTIONS(827), 1,
      anon_sym_RPAREN,
    ACTIONS(854), 1,
      anon_sym_DOLLAR,
    ACTIONS(962), 1,
      aux_sym__unquoted_text_token1,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(852), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(321), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [18539] = 7,
    ACTIONS(847), 1,
      anon_sym_RPAREN,
    ACTIONS(967), 1,
      anon_sym_DOLLAR,
    ACTIONS(970), 1,
      aux_sym__unquoted_text_token1,
    STATE(657), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(658), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(964), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(321), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [18574] = 6,
    ACTIONS(975), 1,
      anon_sym_LBRACE,
    ACTIONS(977), 1,
      anon_sym_ENV,
    ACTIONS(979), 1,
      anon_sym_CACHE,
    ACTIONS(981), 1,
      anon_sym_LT,
    ACTIONS(983), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(973), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [18606] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(864), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18638] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(845), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18670] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(865), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18702] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(853), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18734] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(831), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18766] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(834), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18798] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(824), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18830] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(823), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18862] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(810), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18894] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(846), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18926] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(862), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18958] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(852), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [18990] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(897), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19022] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(881), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19054] = 7,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    ACTIONS(991), 1,
      aux_sym_variable_token1,
    ACTIONS(993), 1,
      anon_sym_RBRACE,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(340), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19086] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(861), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19118] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(844), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19150] = 7,
    ACTIONS(998), 1,
      aux_sym_variable_token1,
    ACTIONS(1001), 1,
      anon_sym_DOLLAR,
    ACTIONS(1004), 1,
      anon_sym_RBRACE,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(340), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(995), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19182] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(843), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19214] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(880), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19246] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(873), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19278] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(816), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19310] = 7,
    ACTIONS(987), 1,
      aux_sym_variable_token1,
    ACTIONS(989), 1,
      anon_sym_DOLLAR,
    STATE(814), 1,
      sym_variable,
    STATE(664), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(337), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(665), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(985), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [19342] = 4,
    ACTIONS(1008), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      aux_sym__unquoted_text_token1,
    STATE(346), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(1006), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19367] = 6,
    ACTIONS(1014), 1,
      anon_sym_LBRACE,
    ACTIONS(1016), 1,
      anon_sym_ENV,
    ACTIONS(1018), 1,
      anon_sym_CACHE,
    ACTIONS(1020), 1,
      anon_sym_LT,
    ACTIONS(983), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(973), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [19396] = 2,
    ACTIONS(1024), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1022), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19416] = 2,
    ACTIONS(1028), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1026), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19436] = 2,
    ACTIONS(1032), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1030), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19456] = 2,
    ACTIONS(1036), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1034), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19476] = 2,
    ACTIONS(1040), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1038), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19496] = 2,
    ACTIONS(1044), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1042), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19516] = 2,
    ACTIONS(1048), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1046), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19536] = 2,
    ACTIONS(1052), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1050), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19556] = 2,
    ACTIONS(1056), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1054), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19576] = 2,
    ACTIONS(1060), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1058), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19596] = 2,
    ACTIONS(1064), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1062), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19616] = 2,
    ACTIONS(1068), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1066), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [19636] = 6,
    ACTIONS(983), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1070), 1,
      anon_sym_LBRACE,
    ACTIONS(1072), 1,
      anon_sym_ENV,
    ACTIONS(1074), 1,
      anon_sym_CACHE,
    ACTIONS(1076), 1,
      anon_sym_LT,
    ACTIONS(973), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [19663] = 2,
    ACTIONS(1078), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1080), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19681] = 2,
    ACTIONS(1082), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1084), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19699] = 2,
    ACTIONS(1086), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1088), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19717] = 2,
    ACTIONS(1090), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1092), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19735] = 2,
    ACTIONS(1094), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1096), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19753] = 2,
    ACTIONS(1098), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1100), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19771] = 2,
    ACTIONS(1102), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1104), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19789] = 2,
    ACTIONS(1106), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1108), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19807] = 2,
    ACTIONS(1110), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1112), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19825] = 2,
    ACTIONS(1114), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1116), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19843] = 2,
    ACTIONS(1118), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1120), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19861] = 2,
    ACTIONS(1122), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1124), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19879] = 2,
    ACTIONS(1126), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1128), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19897] = 6,
    ACTIONS(1130), 1,
      anon_sym_LBRACE,
    ACTIONS(1132), 1,
      anon_sym_ENV,
    ACTIONS(1134), 1,
      anon_sym_CACHE,
    ACTIONS(1136), 1,
      anon_sym_LT,
    ACTIONS(983), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(973), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [19923] = 2,
    ACTIONS(1138), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1140), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19941] = 2,
    ACTIONS(1142), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1144), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19959] = 2,
    ACTIONS(1146), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1148), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19977] = 2,
    ACTIONS(1150), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1152), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [19995] = 6,
    ACTIONS(983), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1154), 1,
      anon_sym_LBRACE,
    ACTIONS(1156), 1,
      anon_sym_ENV,
    ACTIONS(1158), 1,
      anon_sym_CACHE,
    ACTIONS(1160), 1,
      anon_sym_LT,
    ACTIONS(973), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [20021] = 2,
    ACTIONS(1162), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1164), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20039] = 2,
    ACTIONS(1166), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1168), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20057] = 2,
    ACTIONS(1170), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1172), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20075] = 5,
    ACTIONS(1174), 1,
      anon_sym_DOLLAR,
    ACTIONS(1177), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(1179), 1,
      aux_sym__unquoted_text_token1,
    STATE(383), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(1006), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20099] = 2,
    ACTIONS(1182), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1184), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20117] = 2,
    ACTIONS(1186), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1188), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20135] = 2,
    ACTIONS(1190), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1192), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20153] = 2,
    ACTIONS(1194), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1196), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20171] = 2,
    ACTIONS(1198), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1200), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20189] = 2,
    ACTIONS(1202), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1204), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20207] = 2,
    ACTIONS(1206), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1208), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20225] = 6,
    ACTIONS(1212), 1,
      anon_sym_LBRACE,
    ACTIONS(1214), 1,
      anon_sym_ENV,
    ACTIONS(1216), 1,
      anon_sym_CACHE,
    ACTIONS(1218), 1,
      anon_sym_LT,
    ACTIONS(1220), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(1210), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [20251] = 2,
    ACTIONS(1222), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1224), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20269] = 2,
    ACTIONS(1226), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1228), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20287] = 2,
    ACTIONS(1230), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1232), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20305] = 2,
    ACTIONS(1234), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1236), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20323] = 2,
    ACTIONS(1238), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1240), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20341] = 2,
    ACTIONS(1242), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1244), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20359] = 2,
    ACTIONS(1246), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1248), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20377] = 2,
    ACTIONS(1250), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1252), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20395] = 2,
    ACTIONS(1254), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1256), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20413] = 2,
    ACTIONS(1258), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1260), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20431] = 2,
    ACTIONS(1262), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1264), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20449] = 2,
    ACTIONS(1266), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1268), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20467] = 2,
    ACTIONS(1270), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1272), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20485] = 2,
    ACTIONS(1274), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1276), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20503] = 2,
    ACTIONS(1278), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1280), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20521] = 2,
    ACTIONS(1282), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1284), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [20539] = 2,
    ACTIONS(1048), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1046), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20556] = 2,
    ACTIONS(1044), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1042), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20573] = 2,
    ACTIONS(1024), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1022), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20590] = 3,
    ACTIONS(1288), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(1290), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1286), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20609] = 2,
    ACTIONS(1064), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1062), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20626] = 2,
    ACTIONS(1036), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1034), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20643] = 2,
    ACTIONS(1032), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1030), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20660] = 2,
    ACTIONS(1040), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1038), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20677] = 2,
    ACTIONS(1052), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1050), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20694] = 2,
    ACTIONS(1068), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1066), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20711] = 2,
    ACTIONS(1056), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1054), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [20728] = 2,
    ACTIONS(1278), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1280), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [20744] = 2,
    ACTIONS(1234), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1236), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [20760] = 2,
    ACTIONS(1170), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1172), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20776] = 2,
    ACTIONS(1182), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1184), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20792] = 2,
    ACTIONS(1186), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1188), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20808] = 2,
    ACTIONS(1190), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1192), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20824] = 2,
    ACTIONS(1194), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1196), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20840] = 2,
    ACTIONS(1198), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1200), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20856] = 2,
    ACTIONS(1206), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1208), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20872] = 2,
    ACTIONS(1082), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1084), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20888] = 2,
    ACTIONS(1222), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1224), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20904] = 2,
    ACTIONS(1226), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1228), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20920] = 2,
    ACTIONS(1230), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1232), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20936] = 2,
    ACTIONS(1234), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1236), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20952] = 2,
    ACTIONS(1238), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1240), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20968] = 2,
    ACTIONS(1242), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1244), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [20984] = 2,
    ACTIONS(1246), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1248), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21000] = 2,
    ACTIONS(1250), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1252), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21016] = 2,
    ACTIONS(1090), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1092), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21032] = 2,
    ACTIONS(1258), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1260), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21048] = 2,
    ACTIONS(1262), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1264), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21064] = 2,
    ACTIONS(1266), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1268), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21080] = 2,
    ACTIONS(1250), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1252), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21096] = 2,
    ACTIONS(1270), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1272), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21112] = 2,
    ACTIONS(1274), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1276), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21128] = 2,
    ACTIONS(1278), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1280), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21144] = 2,
    ACTIONS(1282), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1284), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21160] = 2,
    ACTIONS(1254), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1256), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21176] = 2,
    ACTIONS(1246), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1248), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21192] = 2,
    ACTIONS(1242), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1244), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21208] = 2,
    ACTIONS(1202), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1204), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21224] = 2,
    ACTIONS(1162), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1164), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21240] = 2,
    ACTIONS(1122), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1124), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21256] = 2,
    ACTIONS(1126), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1128), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21272] = 2,
    ACTIONS(1138), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1140), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21288] = 2,
    ACTIONS(1142), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1144), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21304] = 2,
    ACTIONS(1146), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1148), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21320] = 2,
    ACTIONS(1150), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1152), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21336] = 2,
    ACTIONS(1274), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1276), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [21352] = 2,
    ACTIONS(1090), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1092), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21368] = 2,
    ACTIONS(1166), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1168), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21384] = 2,
    ACTIONS(1170), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1172), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21400] = 2,
    ACTIONS(1182), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1184), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21416] = 2,
    ACTIONS(1186), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1188), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21432] = 2,
    ACTIONS(1190), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1192), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21448] = 2,
    ACTIONS(1194), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1196), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21464] = 2,
    ACTIONS(1198), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1200), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21480] = 2,
    ACTIONS(1206), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1208), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21496] = 2,
    ACTIONS(1082), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1084), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21512] = 2,
    ACTIONS(1222), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1224), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21528] = 2,
    ACTIONS(1226), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1228), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21544] = 2,
    ACTIONS(1230), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1232), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21560] = 2,
    ACTIONS(1234), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1236), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21576] = 2,
    ACTIONS(1238), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1240), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21592] = 2,
    ACTIONS(1242), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1244), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21608] = 2,
    ACTIONS(1246), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1248), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21624] = 2,
    ACTIONS(1250), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1252), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21640] = 2,
    ACTIONS(1090), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1092), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21656] = 2,
    ACTIONS(1258), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1260), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21672] = 2,
    ACTIONS(1262), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1264), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21688] = 2,
    ACTIONS(1266), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1268), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21704] = 2,
    ACTIONS(1258), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1260), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21720] = 2,
    ACTIONS(1270), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1272), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21736] = 2,
    ACTIONS(1274), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1276), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21752] = 2,
    ACTIONS(1266), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1268), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21768] = 2,
    ACTIONS(1282), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1284), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21784] = 2,
    ACTIONS(1254), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1256), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21800] = 2,
    ACTIONS(1262), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1264), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21816] = 2,
    ACTIONS(1150), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1152), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [21832] = 2,
    ACTIONS(1202), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1204), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21848] = 2,
    ACTIONS(1162), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1164), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [21864] = 2,
    ACTIONS(1238), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1240), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21880] = 2,
    ACTIONS(1234), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1236), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21896] = 2,
    ACTIONS(1230), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1232), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21912] = 2,
    ACTIONS(1226), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1228), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21928] = 2,
    ACTIONS(1222), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1224), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21944] = 2,
    ACTIONS(1082), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1084), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21960] = 2,
    ACTIONS(1206), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1208), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [21976] = 4,
    ACTIONS(1292), 1,
      anon_sym_DOLLAR,
    ACTIONS(1295), 1,
      aux_sym__unquoted_text_token1,
    STATE(497), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(1006), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_GT,
      anon_sym_COLON,
  [21996] = 2,
    ACTIONS(1198), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1200), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22012] = 2,
    ACTIONS(1146), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1148), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [22028] = 2,
    ACTIONS(1190), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1192), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22044] = 2,
    ACTIONS(1186), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1188), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22060] = 2,
    ACTIONS(1182), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1184), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22076] = 2,
    ACTIONS(1170), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1172), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22092] = 2,
    ACTIONS(1166), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1168), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22108] = 2,
    ACTIONS(1142), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1144), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [22124] = 2,
    ACTIONS(1150), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1152), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22140] = 2,
    ACTIONS(1146), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1148), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22156] = 2,
    ACTIONS(1142), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1144), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22172] = 2,
    ACTIONS(1138), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1140), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22188] = 2,
    ACTIONS(1126), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1128), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22204] = 2,
    ACTIONS(1122), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1124), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22220] = 2,
    ACTIONS(1138), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1140), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [22236] = 2,
    ACTIONS(1126), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1128), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [22252] = 2,
    ACTIONS(1122), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1124), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [22268] = 2,
    ACTIONS(1162), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1164), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22284] = 2,
    ACTIONS(1202), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1204), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22300] = 2,
    ACTIONS(1274), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1276), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22316] = 2,
    ACTIONS(1278), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1280), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22332] = 2,
    ACTIONS(1254), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1256), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22348] = 2,
    ACTIONS(1282), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1284), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22364] = 2,
    ACTIONS(1278), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1280), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22380] = 2,
    ACTIONS(1270), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1272), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22396] = 2,
    ACTIONS(1270), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1272), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22412] = 2,
    ACTIONS(1194), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1196), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22428] = 2,
    ACTIONS(1282), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1284), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22444] = 2,
    ACTIONS(1266), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1268), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22460] = 2,
    ACTIONS(1262), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1264), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22476] = 2,
    ACTIONS(1258), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1260), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22492] = 2,
    ACTIONS(1090), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1092), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22508] = 2,
    ACTIONS(1250), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1252), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22524] = 2,
    ACTIONS(1246), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1248), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22540] = 2,
    ACTIONS(1242), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1244), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22556] = 2,
    ACTIONS(1254), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1256), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22572] = 2,
    ACTIONS(1238), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1240), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22588] = 2,
    ACTIONS(1166), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1168), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [22604] = 2,
    ACTIONS(1230), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1232), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22620] = 2,
    ACTIONS(1226), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1228), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22636] = 2,
    ACTIONS(1222), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1224), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22652] = 2,
    ACTIONS(1082), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1084), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22668] = 2,
    ACTIONS(1206), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1208), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22684] = 2,
    ACTIONS(1198), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1200), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22700] = 2,
    ACTIONS(1194), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1196), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22716] = 2,
    ACTIONS(1190), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1192), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22732] = 2,
    ACTIONS(1186), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1188), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22748] = 2,
    ACTIONS(1182), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1184), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22764] = 2,
    ACTIONS(1170), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1172), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22780] = 2,
    ACTIONS(1166), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1168), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22796] = 2,
    ACTIONS(1202), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1204), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22812] = 2,
    ACTIONS(1122), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1124), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22828] = 2,
    ACTIONS(1162), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1164), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22844] = 2,
    ACTIONS(1298), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(790), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [22860] = 2,
    ACTIONS(1202), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1204), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22876] = 2,
    ACTIONS(1150), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1152), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22892] = 2,
    ACTIONS(1146), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1148), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22908] = 2,
    ACTIONS(1142), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1144), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [22924] = 2,
    ACTIONS(1254), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1256), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22940] = 2,
    ACTIONS(1282), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1284), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22956] = 2,
    ACTIONS(1278), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1280), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22972] = 2,
    ACTIONS(1274), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1276), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [22988] = 2,
    ACTIONS(1270), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1272), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23004] = 2,
    ACTIONS(1138), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1140), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [23020] = 2,
    ACTIONS(1126), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1128), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [23036] = 2,
    ACTIONS(1122), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1124), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [23052] = 2,
    ACTIONS(1162), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1164), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23068] = 2,
    ACTIONS(1202), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1204), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23084] = 2,
    ACTIONS(1266), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1268), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23100] = 2,
    ACTIONS(1262), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1264), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23116] = 2,
    ACTIONS(1258), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1260), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23132] = 2,
    ACTIONS(1090), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1092), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23148] = 2,
    ACTIONS(1250), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1252), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23164] = 2,
    ACTIONS(1246), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1248), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23180] = 2,
    ACTIONS(1254), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1256), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23196] = 2,
    ACTIONS(1282), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1284), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23212] = 2,
    ACTIONS(1242), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1244), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23228] = 2,
    ACTIONS(1300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1302), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [23244] = 2,
    ACTIONS(1304), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1306), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [23260] = 2,
    ACTIONS(1308), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1310), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [23276] = 2,
    ACTIONS(1312), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1314), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23292] = 2,
    ACTIONS(1316), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1318), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23308] = 2,
    ACTIONS(1278), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1280), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23324] = 2,
    ACTIONS(1162), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1164), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23340] = 2,
    ACTIONS(1274), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1276), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23356] = 2,
    ACTIONS(1270), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1272), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23372] = 2,
    ACTIONS(1126), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1128), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23388] = 2,
    ACTIONS(1266), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1268), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23404] = 2,
    ACTIONS(1262), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1264), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23420] = 2,
    ACTIONS(1258), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1260), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23436] = 2,
    ACTIONS(1090), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1092), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23452] = 2,
    ACTIONS(1238), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1240), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23468] = 2,
    ACTIONS(1234), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1236), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23484] = 2,
    ACTIONS(1230), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1232), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23500] = 2,
    ACTIONS(1226), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1228), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23516] = 2,
    ACTIONS(1222), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1224), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23532] = 2,
    ACTIONS(1082), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1084), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23548] = 2,
    ACTIONS(1250), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1252), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23564] = 2,
    ACTIONS(1246), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1248), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23580] = 2,
    ACTIONS(1206), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1208), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23596] = 2,
    ACTIONS(1320), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1322), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [23612] = 2,
    ACTIONS(1324), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1326), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [23628] = 2,
    ACTIONS(1328), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1330), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [23644] = 2,
    ACTIONS(1332), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1334), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23660] = 2,
    ACTIONS(1336), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1338), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23676] = 2,
    ACTIONS(1242), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1244), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23692] = 2,
    ACTIONS(1122), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1124), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23708] = 2,
    ACTIONS(1238), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1240), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23724] = 2,
    ACTIONS(1234), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1236), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23740] = 2,
    ACTIONS(1230), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1232), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23756] = 2,
    ACTIONS(1226), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1228), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23772] = 2,
    ACTIONS(1222), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1224), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23788] = 2,
    ACTIONS(1198), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1200), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23804] = 2,
    ACTIONS(1194), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1196), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23820] = 2,
    ACTIONS(1190), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1192), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23836] = 2,
    ACTIONS(1186), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1188), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23852] = 2,
    ACTIONS(1082), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1084), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23868] = 2,
    ACTIONS(1206), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1208), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23884] = 2,
    ACTIONS(1182), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1184), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23900] = 2,
    ACTIONS(1138), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1140), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23916] = 2,
    ACTIONS(1170), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1172), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23932] = 2,
    ACTIONS(1198), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1200), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23948] = 2,
    ACTIONS(1194), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1196), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23964] = 2,
    ACTIONS(1190), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1192), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23980] = 2,
    ACTIONS(1166), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1168), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [23996] = 2,
    ACTIONS(1340), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1342), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [24012] = 2,
    ACTIONS(1344), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1346), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [24028] = 2,
    ACTIONS(1348), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1350), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [24044] = 2,
    ACTIONS(1352), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1354), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24060] = 2,
    ACTIONS(1356), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1358), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24076] = 2,
    ACTIONS(1186), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1188), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24092] = 2,
    ACTIONS(1182), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1184), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24108] = 2,
    ACTIONS(1170), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1172), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24124] = 2,
    ACTIONS(1166), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1168), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24140] = 2,
    ACTIONS(1150), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1152), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24156] = 2,
    ACTIONS(1146), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1148), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24172] = 2,
    ACTIONS(1150), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1152), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24188] = 2,
    ACTIONS(1142), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1144), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24204] = 2,
    ACTIONS(1146), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1148), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24220] = 2,
    ACTIONS(1138), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1140), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24236] = 2,
    ACTIONS(1142), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1144), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24252] = 2,
    ACTIONS(1126), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1128), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [24268] = 5,
    ACTIONS(1177), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(1360), 1,
      anon_sym_DOLLAR,
    ACTIONS(1363), 1,
      aux_sym__unquoted_text_token1,
    STATE(640), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(1006), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [24289] = 2,
    ACTIONS(1056), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1054), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [24304] = 2,
    ACTIONS(1048), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1046), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [24319] = 4,
    ACTIONS(1368), 1,
      anon_sym_DOLLAR,
    ACTIONS(1371), 1,
      aux_sym__quoted_text_token1,
    STATE(643), 1,
      aux_sym__quoted_text_repeat1,
    ACTIONS(1366), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DQUOTE,
  [24338] = 2,
    ACTIONS(1068), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1066), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [24353] = 2,
    ACTIONS(1052), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1050), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [24368] = 4,
    ACTIONS(1374), 1,
      anon_sym_DOLLAR,
    ACTIONS(1377), 1,
      aux_sym__unquoted_text_token1,
    STATE(646), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(1006), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_RPAREN,
  [24387] = 2,
    ACTIONS(1040), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1038), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [24402] = 2,
    ACTIONS(1032), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1030), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [24417] = 2,
    ACTIONS(1036), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1034), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [24432] = 2,
    ACTIONS(1068), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(1066), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [24446] = 2,
    ACTIONS(1056), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(1054), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [24460] = 2,
    ACTIONS(1052), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(1050), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [24474] = 2,
    ACTIONS(1056), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(1054), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [24488] = 2,
    ACTIONS(1040), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(1038), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [24502] = 2,
    ACTIONS(1048), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(1046), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [24516] = 2,
    ACTIONS(1036), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(1034), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [24530] = 2,
    ACTIONS(1068), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1066), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [24544] = 2,
    ACTIONS(1052), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1050), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [24558] = 2,
    ACTIONS(1056), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1054), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [24572] = 2,
    ACTIONS(1040), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1038), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [24586] = 2,
    ACTIONS(1048), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1046), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [24600] = 2,
    ACTIONS(1032), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1030), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [24614] = 2,
    ACTIONS(1036), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(1034), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [24628] = 1,
    ACTIONS(1066), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [24640] = 1,
    ACTIONS(1050), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [24652] = 1,
    ACTIONS(1038), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [24664] = 1,
    ACTIONS(1030), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [24676] = 1,
    ACTIONS(1034), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [24688] = 2,
    ACTIONS(1032), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(1030), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [24702] = 2,
    ACTIONS(1048), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(1046), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [24716] = 2,
    ACTIONS(1068), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(1066), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [24730] = 2,
    ACTIONS(1052), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(1050), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [24744] = 2,
    ACTIONS(1040), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(1038), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [24758] = 2,
    ACTIONS(1032), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(1030), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [24772] = 2,
    ACTIONS(1036), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(1034), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [24786] = 3,
    ACTIONS(1380), 1,
      anon_sym_LPAREN,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24796] = 3,
    ACTIONS(1384), 1,
      anon_sym_LPAREN,
    ACTIONS(1386), 1,
      aux_sym_if_command_token1,
    STATE(795), 1,
      aux_sym_if_command_repeat1,
  [24806] = 3,
    ACTIONS(1388), 1,
      anon_sym_LPAREN,
    ACTIONS(1390), 1,
      aux_sym_if_command_token1,
    STATE(685), 1,
      aux_sym_if_command_repeat1,
  [24816] = 3,
    ACTIONS(1392), 1,
      anon_sym_LPAREN,
    ACTIONS(1394), 1,
      aux_sym_if_command_token1,
    STATE(686), 1,
      aux_sym_if_command_repeat1,
  [24826] = 3,
    ACTIONS(1396), 1,
      anon_sym_LPAREN,
    ACTIONS(1398), 1,
      aux_sym_if_command_token1,
    STATE(687), 1,
      aux_sym_if_command_repeat1,
  [24836] = 3,
    ACTIONS(1400), 1,
      anon_sym_LPAREN,
    ACTIONS(1402), 1,
      aux_sym_if_command_token1,
    STATE(688), 1,
      aux_sym_if_command_repeat1,
  [24846] = 3,
    ACTIONS(1404), 1,
      anon_sym_LPAREN,
    ACTIONS(1406), 1,
      aux_sym_if_command_token1,
    STATE(689), 1,
      aux_sym_if_command_repeat1,
  [24856] = 3,
    ACTIONS(1408), 1,
      anon_sym_LPAREN,
    ACTIONS(1410), 1,
      aux_sym_if_command_token1,
    STATE(690), 1,
      aux_sym_if_command_repeat1,
  [24866] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1412), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24876] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1414), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24886] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1416), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24896] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1418), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24906] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1420), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24916] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1422), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24926] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1424), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24936] = 3,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    ACTIONS(1428), 1,
      aux_sym_if_command_token1,
    STATE(745), 1,
      aux_sym_if_command_repeat1,
  [24946] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1430), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24956] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1432), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24966] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1434), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24976] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1436), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24986] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1438), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [24996] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1440), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25006] = 3,
    ACTIONS(1442), 1,
      anon_sym_LPAREN,
    ACTIONS(1444), 1,
      aux_sym_if_command_token1,
    STATE(692), 1,
      aux_sym_if_command_repeat1,
  [25016] = 3,
    ACTIONS(1446), 1,
      anon_sym_LPAREN,
    ACTIONS(1448), 1,
      aux_sym_if_command_token1,
    STATE(693), 1,
      aux_sym_if_command_repeat1,
  [25026] = 3,
    ACTIONS(1450), 1,
      anon_sym_LPAREN,
    ACTIONS(1452), 1,
      aux_sym_if_command_token1,
    STATE(694), 1,
      aux_sym_if_command_repeat1,
  [25036] = 3,
    ACTIONS(1454), 1,
      anon_sym_LPAREN,
    ACTIONS(1456), 1,
      aux_sym_if_command_token1,
    STATE(695), 1,
      aux_sym_if_command_repeat1,
  [25046] = 3,
    ACTIONS(1458), 1,
      anon_sym_LPAREN,
    ACTIONS(1460), 1,
      aux_sym_if_command_token1,
    STATE(696), 1,
      aux_sym_if_command_repeat1,
  [25056] = 3,
    ACTIONS(1462), 1,
      anon_sym_LPAREN,
    ACTIONS(1464), 1,
      aux_sym_if_command_token1,
    STATE(697), 1,
      aux_sym_if_command_repeat1,
  [25066] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1466), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25076] = 3,
    ACTIONS(1468), 1,
      anon_sym_LPAREN,
    ACTIONS(1470), 1,
      aux_sym_if_command_token1,
    STATE(704), 1,
      aux_sym_if_command_repeat1,
  [25086] = 3,
    ACTIONS(1472), 1,
      anon_sym_LPAREN,
    ACTIONS(1474), 1,
      aux_sym_if_command_token1,
    STATE(780), 1,
      aux_sym_if_command_repeat1,
  [25096] = 3,
    ACTIONS(1476), 1,
      anon_sym_LPAREN,
    ACTIONS(1478), 1,
      aux_sym_if_command_token1,
    STATE(781), 1,
      aux_sym_if_command_repeat1,
  [25106] = 3,
    ACTIONS(1480), 1,
      anon_sym_LPAREN,
    ACTIONS(1482), 1,
      aux_sym_if_command_token1,
    STATE(782), 1,
      aux_sym_if_command_repeat1,
  [25116] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1484), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25126] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1486), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25136] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1488), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25146] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1490), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25156] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1492), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25166] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1494), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25176] = 3,
    ACTIONS(1496), 1,
      anon_sym_LPAREN,
    ACTIONS(1498), 1,
      aux_sym_if_command_token1,
    STATE(709), 1,
      aux_sym_if_command_repeat1,
  [25186] = 3,
    ACTIONS(1500), 1,
      anon_sym_LPAREN,
    ACTIONS(1502), 1,
      aux_sym_if_command_token1,
    STATE(710), 1,
      aux_sym_if_command_repeat1,
  [25196] = 3,
    ACTIONS(1504), 1,
      anon_sym_LPAREN,
    ACTIONS(1506), 1,
      aux_sym_if_command_token1,
    STATE(712), 1,
      aux_sym_if_command_repeat1,
  [25206] = 3,
    ACTIONS(1508), 1,
      anon_sym_LPAREN,
    ACTIONS(1510), 1,
      aux_sym_if_command_token1,
    STATE(713), 1,
      aux_sym_if_command_repeat1,
  [25216] = 3,
    ACTIONS(1512), 1,
      anon_sym_LPAREN,
    ACTIONS(1514), 1,
      aux_sym_if_command_token1,
    STATE(714), 1,
      aux_sym_if_command_repeat1,
  [25226] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1516), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25236] = 3,
    ACTIONS(1518), 1,
      anon_sym_LPAREN,
    ACTIONS(1520), 1,
      aux_sym_if_command_token1,
    STATE(790), 1,
      aux_sym_if_command_repeat1,
  [25246] = 3,
    ACTIONS(1522), 1,
      anon_sym_LPAREN,
    ACTIONS(1524), 1,
      aux_sym_if_command_token1,
    STATE(720), 1,
      aux_sym_if_command_repeat1,
  [25256] = 3,
    ACTIONS(1526), 1,
      anon_sym_LPAREN,
    ACTIONS(1528), 1,
      aux_sym_if_command_token1,
    STATE(779), 1,
      aux_sym_if_command_repeat1,
  [25266] = 3,
    ACTIONS(1530), 1,
      anon_sym_LPAREN,
    ACTIONS(1532), 1,
      aux_sym_if_command_token1,
    STATE(752), 1,
      aux_sym_if_command_repeat1,
  [25276] = 3,
    ACTIONS(1534), 1,
      anon_sym_LPAREN,
    ACTIONS(1536), 1,
      aux_sym_if_command_token1,
    STATE(759), 1,
      aux_sym_if_command_repeat1,
  [25286] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25296] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1540), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25306] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1542), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25316] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1544), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25326] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1546), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25336] = 1,
    ACTIONS(1062), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [25342] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1548), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25352] = 1,
    ACTIONS(1022), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [25358] = 3,
    ACTIONS(1550), 1,
      anon_sym_LPAREN,
    ACTIONS(1552), 1,
      aux_sym_if_command_token1,
    STATE(726), 1,
      aux_sym_if_command_repeat1,
  [25368] = 1,
    ACTIONS(1042), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [25374] = 3,
    ACTIONS(1554), 1,
      anon_sym_LPAREN,
    ACTIONS(1556), 1,
      aux_sym_if_command_token1,
    STATE(727), 1,
      aux_sym_if_command_repeat1,
  [25384] = 3,
    ACTIONS(1558), 1,
      anon_sym_LPAREN,
    ACTIONS(1560), 1,
      aux_sym_if_command_token1,
    STATE(728), 1,
      aux_sym_if_command_repeat1,
  [25394] = 3,
    ACTIONS(1562), 1,
      anon_sym_LPAREN,
    ACTIONS(1564), 1,
      aux_sym_if_command_token1,
    STATE(729), 1,
      aux_sym_if_command_repeat1,
  [25404] = 3,
    ACTIONS(1566), 1,
      anon_sym_LPAREN,
    ACTIONS(1568), 1,
      aux_sym_if_command_token1,
    STATE(730), 1,
      aux_sym_if_command_repeat1,
  [25414] = 3,
    ACTIONS(1570), 1,
      anon_sym_LPAREN,
    ACTIONS(1572), 1,
      aux_sym_if_command_token1,
    STATE(732), 1,
      aux_sym_if_command_repeat1,
  [25424] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1574), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25434] = 3,
    ACTIONS(1576), 1,
      anon_sym_LPAREN,
    ACTIONS(1578), 1,
      aux_sym_if_command_token1,
    STATE(741), 1,
      aux_sym_if_command_repeat1,
  [25444] = 3,
    ACTIONS(1580), 1,
      anon_sym_LPAREN,
    ACTIONS(1582), 1,
      aux_sym_if_command_token1,
    STATE(758), 1,
      aux_sym_if_command_repeat1,
  [25454] = 3,
    ACTIONS(1584), 1,
      anon_sym_LPAREN,
    ACTIONS(1586), 1,
      aux_sym_if_command_token1,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25464] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1589), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25474] = 3,
    ACTIONS(1591), 1,
      anon_sym_GT,
    ACTIONS(1593), 1,
      anon_sym_COLON,
    STATE(825), 1,
      sym__gen_exp_arguments,
  [25484] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1595), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25494] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1597), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25504] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1599), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25514] = 3,
    ACTIONS(1601), 1,
      anon_sym_LBRACE,
    ACTIONS(1603), 1,
      anon_sym_ENV,
    ACTIONS(1605), 1,
      anon_sym_CACHE,
  [25524] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1607), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25534] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1609), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25544] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1611), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25554] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1613), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25564] = 3,
    ACTIONS(1615), 1,
      anon_sym_LPAREN,
    ACTIONS(1617), 1,
      aux_sym_if_command_token1,
    STATE(747), 1,
      aux_sym_if_command_repeat1,
  [25574] = 3,
    ACTIONS(1619), 1,
      anon_sym_LPAREN,
    ACTIONS(1621), 1,
      aux_sym_if_command_token1,
    STATE(748), 1,
      aux_sym_if_command_repeat1,
  [25584] = 3,
    ACTIONS(1623), 1,
      anon_sym_LPAREN,
    ACTIONS(1625), 1,
      aux_sym_if_command_token1,
    STATE(749), 1,
      aux_sym_if_command_repeat1,
  [25594] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1627), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25604] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1629), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25614] = 3,
    ACTIONS(1631), 1,
      anon_sym_LPAREN,
    ACTIONS(1633), 1,
      aux_sym_if_command_token1,
    STATE(751), 1,
      aux_sym_if_command_repeat1,
  [25624] = 3,
    ACTIONS(1635), 1,
      anon_sym_LPAREN,
    ACTIONS(1637), 1,
      aux_sym_if_command_token1,
    STATE(753), 1,
      aux_sym_if_command_repeat1,
  [25634] = 3,
    ACTIONS(1639), 1,
      anon_sym_LPAREN,
    ACTIONS(1641), 1,
      aux_sym_if_command_token1,
    STATE(754), 1,
      aux_sym_if_command_repeat1,
  [25644] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1643), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25654] = 3,
    ACTIONS(1645), 1,
      anon_sym_LPAREN,
    ACTIONS(1647), 1,
      aux_sym_if_command_token1,
    STATE(765), 1,
      aux_sym_if_command_repeat1,
  [25664] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1649), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25674] = 3,
    ACTIONS(1651), 1,
      anon_sym_LPAREN,
    ACTIONS(1653), 1,
      aux_sym_if_command_token1,
    STATE(772), 1,
      aux_sym_if_command_repeat1,
  [25684] = 3,
    ACTIONS(1655), 1,
      anon_sym_LPAREN,
    ACTIONS(1657), 1,
      aux_sym_if_command_token1,
    STATE(773), 1,
      aux_sym_if_command_repeat1,
  [25694] = 3,
    ACTIONS(1659), 1,
      anon_sym_LPAREN,
    ACTIONS(1661), 1,
      aux_sym_if_command_token1,
    STATE(774), 1,
      aux_sym_if_command_repeat1,
  [25704] = 3,
    ACTIONS(1663), 1,
      anon_sym_LPAREN,
    ACTIONS(1665), 1,
      aux_sym_if_command_token1,
    STATE(676), 1,
      aux_sym_if_command_repeat1,
  [25714] = 3,
    ACTIONS(1667), 1,
      anon_sym_LPAREN,
    ACTIONS(1669), 1,
      aux_sym_if_command_token1,
    STATE(776), 1,
      aux_sym_if_command_repeat1,
  [25724] = 3,
    ACTIONS(1671), 1,
      anon_sym_LPAREN,
    ACTIONS(1673), 1,
      aux_sym_if_command_token1,
    STATE(777), 1,
      aux_sym_if_command_repeat1,
  [25734] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1675), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25744] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1677), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25754] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1679), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25764] = 3,
    ACTIONS(1681), 1,
      anon_sym_LPAREN,
    ACTIONS(1683), 1,
      aux_sym_if_command_token1,
    STATE(763), 1,
      aux_sym_if_command_repeat1,
  [25774] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1685), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25784] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1687), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25794] = 3,
    ACTIONS(1689), 1,
      anon_sym_LPAREN,
    ACTIONS(1691), 1,
      aux_sym_if_command_token1,
    STATE(684), 1,
      aux_sym_if_command_repeat1,
  [25804] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1693), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25814] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1695), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25824] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1697), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25834] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1699), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25844] = 3,
    ACTIONS(1701), 1,
      anon_sym_LPAREN,
    ACTIONS(1703), 1,
      aux_sym_if_command_token1,
    STATE(784), 1,
      aux_sym_if_command_repeat1,
  [25854] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1705), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25864] = 3,
    ACTIONS(1707), 1,
      anon_sym_LPAREN,
    ACTIONS(1709), 1,
      aux_sym_if_command_token1,
    STATE(791), 1,
      aux_sym_if_command_repeat1,
  [25874] = 3,
    ACTIONS(1711), 1,
      anon_sym_LPAREN,
    ACTIONS(1713), 1,
      aux_sym_if_command_token1,
    STATE(788), 1,
      aux_sym_if_command_repeat1,
  [25884] = 3,
    ACTIONS(1715), 1,
      anon_sym_LPAREN,
    ACTIONS(1717), 1,
      aux_sym_if_command_token1,
    STATE(793), 1,
      aux_sym_if_command_repeat1,
  [25894] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1719), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25904] = 3,
    ACTIONS(1721), 1,
      anon_sym_LPAREN,
    ACTIONS(1723), 1,
      aux_sym_if_command_token1,
    STATE(711), 1,
      aux_sym_if_command_repeat1,
  [25914] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1725), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25924] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1727), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25934] = 3,
    ACTIONS(1729), 1,
      anon_sym_LPAREN,
    ACTIONS(1731), 1,
      aux_sym_if_command_token1,
    STATE(794), 1,
      aux_sym_if_command_repeat1,
  [25944] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1733), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25954] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1735), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25964] = 3,
    ACTIONS(1382), 1,
      aux_sym_if_command_token1,
    ACTIONS(1737), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      aux_sym_if_command_repeat1,
  [25974] = 2,
    ACTIONS(1739), 1,
      anon_sym_RPAREN,
    ACTIONS(1741), 1,
      aux_sym_endwhile_command_token1,
  [25981] = 2,
    ACTIONS(1743), 1,
      anon_sym_RPAREN,
    ACTIONS(1745), 1,
      aux_sym_endwhile_command_token1,
  [25988] = 2,
    ACTIONS(1747), 1,
      anon_sym_RPAREN,
    ACTIONS(1749), 1,
      aux_sym_endwhile_command_token1,
  [25995] = 2,
    ACTIONS(1751), 1,
      anon_sym_RPAREN,
    ACTIONS(1753), 1,
      aux_sym_endwhile_command_token1,
  [26002] = 2,
    ACTIONS(1755), 1,
      anon_sym_RPAREN,
    ACTIONS(1757), 1,
      aux_sym_endwhile_command_token1,
  [26009] = 2,
    ACTIONS(1759), 1,
      anon_sym_RPAREN,
    ACTIONS(1761), 1,
      aux_sym_endwhile_command_token1,
  [26016] = 2,
    ACTIONS(1763), 1,
      anon_sym_RPAREN,
    ACTIONS(1765), 1,
      aux_sym_endwhile_command_token1,
  [26023] = 2,
    ACTIONS(1767), 1,
      anon_sym_RPAREN,
    ACTIONS(1769), 1,
      aux_sym_endwhile_command_token1,
  [26030] = 2,
    ACTIONS(1771), 1,
      anon_sym_RPAREN,
    ACTIONS(1773), 1,
      aux_sym_endwhile_command_token1,
  [26037] = 2,
    ACTIONS(1775), 1,
      anon_sym_RPAREN,
    ACTIONS(1777), 1,
      aux_sym_endwhile_command_token1,
  [26044] = 2,
    ACTIONS(1779), 1,
      anon_sym_RPAREN,
    ACTIONS(1781), 1,
      aux_sym_endwhile_command_token1,
  [26051] = 2,
    ACTIONS(1783), 1,
      anon_sym_RPAREN,
    ACTIONS(1785), 1,
      aux_sym_endwhile_command_token1,
  [26058] = 2,
    ACTIONS(1787), 1,
      anon_sym_RPAREN,
    ACTIONS(1789), 1,
      aux_sym_endwhile_command_token1,
  [26065] = 2,
    ACTIONS(1791), 1,
      anon_sym_RPAREN,
    ACTIONS(1793), 1,
      aux_sym_endwhile_command_token1,
  [26072] = 1,
    ACTIONS(1795), 1,
      anon_sym_RBRACE,
  [26076] = 1,
    ACTIONS(1797), 1,
      aux_sym_endwhile_command_token1,
  [26080] = 1,
    ACTIONS(1799), 1,
      anon_sym_RPAREN,
  [26084] = 1,
    ACTIONS(1801), 1,
      anon_sym_LBRACE,
  [26088] = 1,
    ACTIONS(1803), 1,
      anon_sym_RBRACE,
  [26092] = 1,
    ACTIONS(1805), 1,
      anon_sym_DQUOTE,
  [26096] = 1,
    ACTIONS(1807), 1,
      anon_sym_RBRACE,
  [26100] = 1,
    ACTIONS(1809), 1,
      anon_sym_GT,
  [26104] = 1,
    ACTIONS(876), 1,
      anon_sym_RPAREN,
  [26108] = 1,
    ACTIONS(1811), 1,
      anon_sym_RPAREN,
  [26112] = 1,
    ACTIONS(1813), 1,
      aux_sym_endwhile_command_token1,
  [26116] = 1,
    ACTIONS(1815), 1,
      aux_sym_endwhile_command_token1,
  [26120] = 1,
    ACTIONS(1817), 1,
      aux_sym_endwhile_command_token1,
  [26124] = 1,
    ACTIONS(1819), 1,
      anon_sym_RBRACE,
  [26128] = 1,
    ACTIONS(1821), 1,
      anon_sym_RBRACE,
  [26132] = 1,
    ACTIONS(1823), 1,
      anon_sym_GT,
  [26136] = 1,
    ACTIONS(1825), 1,
      anon_sym_RPAREN,
  [26140] = 1,
    ACTIONS(1827), 1,
      aux_sym_endwhile_command_token1,
  [26144] = 1,
    ACTIONS(1829), 1,
      anon_sym_RPAREN,
  [26148] = 1,
    ACTIONS(1831), 1,
      anon_sym_RPAREN,
  [26152] = 1,
    ACTIONS(1833), 1,
      anon_sym_RPAREN,
  [26156] = 1,
    ACTIONS(1835), 1,
      anon_sym_RBRACE,
  [26160] = 1,
    ACTIONS(868), 1,
      anon_sym_RPAREN,
  [26164] = 1,
    ACTIONS(870), 1,
      anon_sym_RPAREN,
  [26168] = 1,
    ACTIONS(1837), 1,
      anon_sym_RBRACE,
  [26172] = 1,
    ACTIONS(1042), 1,
      aux_sym_endwhile_command_token1,
  [26176] = 1,
    ACTIONS(1839), 1,
      anon_sym_RPAREN,
  [26180] = 1,
    ACTIONS(1022), 1,
      aux_sym_endwhile_command_token1,
  [26184] = 1,
    ACTIONS(1841), 1,
      aux_sym_endwhile_command_token1,
  [26188] = 1,
    ACTIONS(1843), 1,
      aux_sym_endwhile_command_token1,
  [26192] = 1,
    ACTIONS(1845), 1,
      anon_sym_GT,
  [26196] = 1,
    ACTIONS(1847), 1,
      anon_sym_RPAREN,
  [26200] = 1,
    ACTIONS(1849), 1,
      anon_sym_RPAREN,
  [26204] = 1,
    ACTIONS(1851), 1,
      anon_sym_RBRACE,
  [26208] = 1,
    ACTIONS(1853), 1,
      anon_sym_RBRACE,
  [26212] = 1,
    ACTIONS(1855), 1,
      anon_sym_RBRACE,
  [26216] = 1,
    ACTIONS(1857), 1,
      anon_sym_RBRACE,
  [26220] = 1,
    ACTIONS(1859), 1,
      anon_sym_DQUOTE,
  [26224] = 1,
    ACTIONS(1062), 1,
      aux_sym_endwhile_command_token1,
  [26228] = 1,
    ACTIONS(1861), 1,
      anon_sym_RPAREN,
  [26232] = 1,
    ACTIONS(1863), 1,
      anon_sym_DQUOTE,
  [26236] = 1,
    ACTIONS(1865), 1,
      anon_sym_GT,
  [26240] = 1,
    ACTIONS(1867), 1,
      anon_sym_RBRACE,
  [26244] = 1,
    ACTIONS(1869), 1,
      anon_sym_RBRACE,
  [26248] = 1,
    ACTIONS(1871), 1,
      anon_sym_GT,
  [26252] = 1,
    ACTIONS(1873), 1,
      anon_sym_LBRACE,
  [26256] = 1,
    ACTIONS(1875), 1,
      anon_sym_RPAREN,
  [26260] = 1,
    ACTIONS(1877), 1,
      aux_sym_endwhile_command_token1,
  [26264] = 1,
    ACTIONS(1879), 1,
      aux_sym_endwhile_command_token1,
  [26268] = 1,
    ACTIONS(1881), 1,
      anon_sym_RPAREN,
  [26272] = 1,
    ACTIONS(1883), 1,
      anon_sym_RPAREN,
  [26276] = 1,
    ACTIONS(1885), 1,
      anon_sym_RBRACE,
  [26280] = 1,
    ACTIONS(1887), 1,
      anon_sym_RBRACE,
  [26284] = 1,
    ACTIONS(872), 1,
      anon_sym_RPAREN,
  [26288] = 1,
    ACTIONS(1889), 1,
      anon_sym_RBRACE,
  [26292] = 1,
    ACTIONS(1891), 1,
      anon_sym_RBRACE,
  [26296] = 1,
    ACTIONS(1893), 1,
      anon_sym_RPAREN,
  [26300] = 1,
    ACTIONS(1895), 1,
      anon_sym_RPAREN,
  [26304] = 1,
    ACTIONS(864), 1,
      anon_sym_RPAREN,
  [26308] = 1,
    ACTIONS(860), 1,
      anon_sym_RPAREN,
  [26312] = 1,
    ACTIONS(1897), 1,
      anon_sym_DQUOTE,
  [26316] = 1,
    ACTIONS(1899), 1,
      anon_sym_RPAREN,
  [26320] = 1,
    ACTIONS(1901), 1,
      anon_sym_RPAREN,
  [26324] = 1,
    ACTIONS(1903), 1,
      anon_sym_RBRACE,
  [26328] = 1,
    ACTIONS(1905), 1,
      anon_sym_GT,
  [26332] = 1,
    ACTIONS(1907), 1,
      anon_sym_RPAREN,
  [26336] = 1,
    ACTIONS(1909), 1,
      aux_sym_endwhile_command_token1,
  [26340] = 1,
    ACTIONS(1911), 1,
      aux_sym_endwhile_command_token1,
  [26344] = 1,
    ACTIONS(1913), 1,
      anon_sym_LBRACE,
  [26348] = 1,
    ACTIONS(1915), 1,
      anon_sym_LBRACE,
  [26352] = 1,
    ACTIONS(1917), 1,
      anon_sym_RBRACE,
  [26356] = 1,
    ACTIONS(1919), 1,
      anon_sym_RBRACE,
  [26360] = 1,
    ACTIONS(1921), 1,
      anon_sym_LBRACE,
  [26364] = 1,
    ACTIONS(1923), 1,
      anon_sym_LBRACE,
  [26368] = 1,
    ACTIONS(1925), 1,
      anon_sym_RPAREN,
  [26372] = 1,
    ACTIONS(1927), 1,
      anon_sym_RPAREN,
  [26376] = 1,
    ACTIONS(1929), 1,
      anon_sym_LBRACE,
  [26380] = 1,
    ACTIONS(1931), 1,
      anon_sym_LBRACE,
  [26384] = 1,
    ACTIONS(1933), 1,
      aux_sym_endwhile_command_token1,
  [26388] = 1,
    ACTIONS(1935), 1,
      ts_builtin_sym_end,
  [26392] = 1,
    ACTIONS(1937), 1,
      anon_sym_LBRACE,
  [26396] = 1,
    ACTIONS(1939), 1,
      anon_sym_LBRACE,
  [26400] = 1,
    ACTIONS(1941), 1,
      aux_sym_endwhile_command_token1,
  [26404] = 1,
    ACTIONS(874), 1,
      anon_sym_RPAREN,
  [26408] = 1,
    ACTIONS(1943), 1,
      anon_sym_LBRACE,
  [26412] = 1,
    ACTIONS(1945), 1,
      anon_sym_LBRACE,
  [26416] = 1,
    ACTIONS(1947), 1,
      aux_sym_endwhile_command_token1,
  [26420] = 1,
    ACTIONS(1949), 1,
      anon_sym_RBRACE,
  [26424] = 1,
    ACTIONS(1951), 1,
      anon_sym_LBRACE,
  [26428] = 1,
    ACTIONS(1953), 1,
      anon_sym_LBRACE,
  [26432] = 1,
    ACTIONS(1955), 1,
      anon_sym_GT,
  [26436] = 1,
    ACTIONS(1957), 1,
      anon_sym_RPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 59,
  [SMALL_STATE(4)] = 118,
  [SMALL_STATE(5)] = 177,
  [SMALL_STATE(6)] = 236,
  [SMALL_STATE(7)] = 295,
  [SMALL_STATE(8)] = 354,
  [SMALL_STATE(9)] = 413,
  [SMALL_STATE(10)] = 472,
  [SMALL_STATE(11)] = 543,
  [SMALL_STATE(12)] = 602,
  [SMALL_STATE(13)] = 661,
  [SMALL_STATE(14)] = 720,
  [SMALL_STATE(15)] = 779,
  [SMALL_STATE(16)] = 838,
  [SMALL_STATE(17)] = 897,
  [SMALL_STATE(18)] = 956,
  [SMALL_STATE(19)] = 1015,
  [SMALL_STATE(20)] = 1074,
  [SMALL_STATE(21)] = 1133,
  [SMALL_STATE(22)] = 1192,
  [SMALL_STATE(23)] = 1251,
  [SMALL_STATE(24)] = 1310,
  [SMALL_STATE(25)] = 1381,
  [SMALL_STATE(26)] = 1440,
  [SMALL_STATE(27)] = 1499,
  [SMALL_STATE(28)] = 1558,
  [SMALL_STATE(29)] = 1617,
  [SMALL_STATE(30)] = 1676,
  [SMALL_STATE(31)] = 1735,
  [SMALL_STATE(32)] = 1794,
  [SMALL_STATE(33)] = 1853,
  [SMALL_STATE(34)] = 1912,
  [SMALL_STATE(35)] = 1983,
  [SMALL_STATE(36)] = 2054,
  [SMALL_STATE(37)] = 2113,
  [SMALL_STATE(38)] = 2184,
  [SMALL_STATE(39)] = 2243,
  [SMALL_STATE(40)] = 2302,
  [SMALL_STATE(41)] = 2361,
  [SMALL_STATE(42)] = 2420,
  [SMALL_STATE(43)] = 2491,
  [SMALL_STATE(44)] = 2550,
  [SMALL_STATE(45)] = 2609,
  [SMALL_STATE(46)] = 2668,
  [SMALL_STATE(47)] = 2727,
  [SMALL_STATE(48)] = 2786,
  [SMALL_STATE(49)] = 2845,
  [SMALL_STATE(50)] = 2904,
  [SMALL_STATE(51)] = 2963,
  [SMALL_STATE(52)] = 3022,
  [SMALL_STATE(53)] = 3093,
  [SMALL_STATE(54)] = 3164,
  [SMALL_STATE(55)] = 3223,
  [SMALL_STATE(56)] = 3282,
  [SMALL_STATE(57)] = 3341,
  [SMALL_STATE(58)] = 3400,
  [SMALL_STATE(59)] = 3459,
  [SMALL_STATE(60)] = 3518,
  [SMALL_STATE(61)] = 3577,
  [SMALL_STATE(62)] = 3636,
  [SMALL_STATE(63)] = 3695,
  [SMALL_STATE(64)] = 3754,
  [SMALL_STATE(65)] = 3813,
  [SMALL_STATE(66)] = 3872,
  [SMALL_STATE(67)] = 3931,
  [SMALL_STATE(68)] = 3990,
  [SMALL_STATE(69)] = 4049,
  [SMALL_STATE(70)] = 4108,
  [SMALL_STATE(71)] = 4167,
  [SMALL_STATE(72)] = 4226,
  [SMALL_STATE(73)] = 4285,
  [SMALL_STATE(74)] = 4344,
  [SMALL_STATE(75)] = 4403,
  [SMALL_STATE(76)] = 4462,
  [SMALL_STATE(77)] = 4521,
  [SMALL_STATE(78)] = 4580,
  [SMALL_STATE(79)] = 4639,
  [SMALL_STATE(80)] = 4698,
  [SMALL_STATE(81)] = 4757,
  [SMALL_STATE(82)] = 4816,
  [SMALL_STATE(83)] = 4875,
  [SMALL_STATE(84)] = 4934,
  [SMALL_STATE(85)] = 4993,
  [SMALL_STATE(86)] = 5052,
  [SMALL_STATE(87)] = 5111,
  [SMALL_STATE(88)] = 5170,
  [SMALL_STATE(89)] = 5229,
  [SMALL_STATE(90)] = 5288,
  [SMALL_STATE(91)] = 5347,
  [SMALL_STATE(92)] = 5406,
  [SMALL_STATE(93)] = 5465,
  [SMALL_STATE(94)] = 5524,
  [SMALL_STATE(95)] = 5583,
  [SMALL_STATE(96)] = 5642,
  [SMALL_STATE(97)] = 5701,
  [SMALL_STATE(98)] = 5760,
  [SMALL_STATE(99)] = 5819,
  [SMALL_STATE(100)] = 5878,
  [SMALL_STATE(101)] = 5937,
  [SMALL_STATE(102)] = 5996,
  [SMALL_STATE(103)] = 6055,
  [SMALL_STATE(104)] = 6114,
  [SMALL_STATE(105)] = 6173,
  [SMALL_STATE(106)] = 6232,
  [SMALL_STATE(107)] = 6291,
  [SMALL_STATE(108)] = 6350,
  [SMALL_STATE(109)] = 6409,
  [SMALL_STATE(110)] = 6468,
  [SMALL_STATE(111)] = 6527,
  [SMALL_STATE(112)] = 6586,
  [SMALL_STATE(113)] = 6645,
  [SMALL_STATE(114)] = 6704,
  [SMALL_STATE(115)] = 6763,
  [SMALL_STATE(116)] = 6822,
  [SMALL_STATE(117)] = 6881,
  [SMALL_STATE(118)] = 6940,
  [SMALL_STATE(119)] = 6999,
  [SMALL_STATE(120)] = 7058,
  [SMALL_STATE(121)] = 7117,
  [SMALL_STATE(122)] = 7176,
  [SMALL_STATE(123)] = 7235,
  [SMALL_STATE(124)] = 7294,
  [SMALL_STATE(125)] = 7353,
  [SMALL_STATE(126)] = 7412,
  [SMALL_STATE(127)] = 7471,
  [SMALL_STATE(128)] = 7542,
  [SMALL_STATE(129)] = 7601,
  [SMALL_STATE(130)] = 7672,
  [SMALL_STATE(131)] = 7731,
  [SMALL_STATE(132)] = 7790,
  [SMALL_STATE(133)] = 7849,
  [SMALL_STATE(134)] = 7908,
  [SMALL_STATE(135)] = 7967,
  [SMALL_STATE(136)] = 8026,
  [SMALL_STATE(137)] = 8085,
  [SMALL_STATE(138)] = 8156,
  [SMALL_STATE(139)] = 8215,
  [SMALL_STATE(140)] = 8274,
  [SMALL_STATE(141)] = 8333,
  [SMALL_STATE(142)] = 8392,
  [SMALL_STATE(143)] = 8451,
  [SMALL_STATE(144)] = 8522,
  [SMALL_STATE(145)] = 8581,
  [SMALL_STATE(146)] = 8640,
  [SMALL_STATE(147)] = 8699,
  [SMALL_STATE(148)] = 8758,
  [SMALL_STATE(149)] = 8817,
  [SMALL_STATE(150)] = 8876,
  [SMALL_STATE(151)] = 8935,
  [SMALL_STATE(152)] = 8994,
  [SMALL_STATE(153)] = 9053,
  [SMALL_STATE(154)] = 9112,
  [SMALL_STATE(155)] = 9171,
  [SMALL_STATE(156)] = 9230,
  [SMALL_STATE(157)] = 9289,
  [SMALL_STATE(158)] = 9348,
  [SMALL_STATE(159)] = 9407,
  [SMALL_STATE(160)] = 9466,
  [SMALL_STATE(161)] = 9525,
  [SMALL_STATE(162)] = 9584,
  [SMALL_STATE(163)] = 9643,
  [SMALL_STATE(164)] = 9702,
  [SMALL_STATE(165)] = 9761,
  [SMALL_STATE(166)] = 9820,
  [SMALL_STATE(167)] = 9879,
  [SMALL_STATE(168)] = 9938,
  [SMALL_STATE(169)] = 9997,
  [SMALL_STATE(170)] = 10056,
  [SMALL_STATE(171)] = 10127,
  [SMALL_STATE(172)] = 10186,
  [SMALL_STATE(173)] = 10245,
  [SMALL_STATE(174)] = 10304,
  [SMALL_STATE(175)] = 10363,
  [SMALL_STATE(176)] = 10422,
  [SMALL_STATE(177)] = 10481,
  [SMALL_STATE(178)] = 10540,
  [SMALL_STATE(179)] = 10599,
  [SMALL_STATE(180)] = 10658,
  [SMALL_STATE(181)] = 10717,
  [SMALL_STATE(182)] = 10776,
  [SMALL_STATE(183)] = 10835,
  [SMALL_STATE(184)] = 10894,
  [SMALL_STATE(185)] = 10965,
  [SMALL_STATE(186)] = 11024,
  [SMALL_STATE(187)] = 11083,
  [SMALL_STATE(188)] = 11142,
  [SMALL_STATE(189)] = 11201,
  [SMALL_STATE(190)] = 11260,
  [SMALL_STATE(191)] = 11319,
  [SMALL_STATE(192)] = 11387,
  [SMALL_STATE(193)] = 11450,
  [SMALL_STATE(194)] = 11513,
  [SMALL_STATE(195)] = 11576,
  [SMALL_STATE(196)] = 11639,
  [SMALL_STATE(197)] = 11702,
  [SMALL_STATE(198)] = 11765,
  [SMALL_STATE(199)] = 11828,
  [SMALL_STATE(200)] = 11891,
  [SMALL_STATE(201)] = 11954,
  [SMALL_STATE(202)] = 12017,
  [SMALL_STATE(203)] = 12080,
  [SMALL_STATE(204)] = 12143,
  [SMALL_STATE(205)] = 12206,
  [SMALL_STATE(206)] = 12269,
  [SMALL_STATE(207)] = 12332,
  [SMALL_STATE(208)] = 12395,
  [SMALL_STATE(209)] = 12458,
  [SMALL_STATE(210)] = 12521,
  [SMALL_STATE(211)] = 12584,
  [SMALL_STATE(212)] = 12647,
  [SMALL_STATE(213)] = 12710,
  [SMALL_STATE(214)] = 12773,
  [SMALL_STATE(215)] = 12836,
  [SMALL_STATE(216)] = 12899,
  [SMALL_STATE(217)] = 12962,
  [SMALL_STATE(218)] = 13025,
  [SMALL_STATE(219)] = 13088,
  [SMALL_STATE(220)] = 13151,
  [SMALL_STATE(221)] = 13214,
  [SMALL_STATE(222)] = 13277,
  [SMALL_STATE(223)] = 13340,
  [SMALL_STATE(224)] = 13403,
  [SMALL_STATE(225)] = 13466,
  [SMALL_STATE(226)] = 13529,
  [SMALL_STATE(227)] = 13592,
  [SMALL_STATE(228)] = 13655,
  [SMALL_STATE(229)] = 13718,
  [SMALL_STATE(230)] = 13781,
  [SMALL_STATE(231)] = 13844,
  [SMALL_STATE(232)] = 13907,
  [SMALL_STATE(233)] = 13970,
  [SMALL_STATE(234)] = 14033,
  [SMALL_STATE(235)] = 14096,
  [SMALL_STATE(236)] = 14159,
  [SMALL_STATE(237)] = 14222,
  [SMALL_STATE(238)] = 14285,
  [SMALL_STATE(239)] = 14348,
  [SMALL_STATE(240)] = 14411,
  [SMALL_STATE(241)] = 14474,
  [SMALL_STATE(242)] = 14537,
  [SMALL_STATE(243)] = 14600,
  [SMALL_STATE(244)] = 14663,
  [SMALL_STATE(245)] = 14726,
  [SMALL_STATE(246)] = 14789,
  [SMALL_STATE(247)] = 14852,
  [SMALL_STATE(248)] = 14915,
  [SMALL_STATE(249)] = 14978,
  [SMALL_STATE(250)] = 15041,
  [SMALL_STATE(251)] = 15104,
  [SMALL_STATE(252)] = 15167,
  [SMALL_STATE(253)] = 15230,
  [SMALL_STATE(254)] = 15293,
  [SMALL_STATE(255)] = 15356,
  [SMALL_STATE(256)] = 15419,
  [SMALL_STATE(257)] = 15482,
  [SMALL_STATE(258)] = 15545,
  [SMALL_STATE(259)] = 15608,
  [SMALL_STATE(260)] = 15671,
  [SMALL_STATE(261)] = 15734,
  [SMALL_STATE(262)] = 15797,
  [SMALL_STATE(263)] = 15857,
  [SMALL_STATE(264)] = 15917,
  [SMALL_STATE(265)] = 15977,
  [SMALL_STATE(266)] = 16037,
  [SMALL_STATE(267)] = 16097,
  [SMALL_STATE(268)] = 16157,
  [SMALL_STATE(269)] = 16217,
  [SMALL_STATE(270)] = 16268,
  [SMALL_STATE(271)] = 16319,
  [SMALL_STATE(272)] = 16370,
  [SMALL_STATE(273)] = 16421,
  [SMALL_STATE(274)] = 16462,
  [SMALL_STATE(275)] = 16513,
  [SMALL_STATE(276)] = 16564,
  [SMALL_STATE(277)] = 16615,
  [SMALL_STATE(278)] = 16666,
  [SMALL_STATE(279)] = 16717,
  [SMALL_STATE(280)] = 16758,
  [SMALL_STATE(281)] = 16806,
  [SMALL_STATE(282)] = 16854,
  [SMALL_STATE(283)] = 16902,
  [SMALL_STATE(284)] = 16950,
  [SMALL_STATE(285)] = 16998,
  [SMALL_STATE(286)] = 17046,
  [SMALL_STATE(287)] = 17094,
  [SMALL_STATE(288)] = 17142,
  [SMALL_STATE(289)] = 17190,
  [SMALL_STATE(290)] = 17238,
  [SMALL_STATE(291)] = 17286,
  [SMALL_STATE(292)] = 17334,
  [SMALL_STATE(293)] = 17382,
  [SMALL_STATE(294)] = 17430,
  [SMALL_STATE(295)] = 17475,
  [SMALL_STATE(296)] = 17520,
  [SMALL_STATE(297)] = 17565,
  [SMALL_STATE(298)] = 17610,
  [SMALL_STATE(299)] = 17655,
  [SMALL_STATE(300)] = 17700,
  [SMALL_STATE(301)] = 17745,
  [SMALL_STATE(302)] = 17790,
  [SMALL_STATE(303)] = 17835,
  [SMALL_STATE(304)] = 17880,
  [SMALL_STATE(305)] = 17925,
  [SMALL_STATE(306)] = 17970,
  [SMALL_STATE(307)] = 18015,
  [SMALL_STATE(308)] = 18060,
  [SMALL_STATE(309)] = 18100,
  [SMALL_STATE(310)] = 18140,
  [SMALL_STATE(311)] = 18178,
  [SMALL_STATE(312)] = 18214,
  [SMALL_STATE(313)] = 18252,
  [SMALL_STATE(314)] = 18290,
  [SMALL_STATE(315)] = 18328,
  [SMALL_STATE(316)] = 18364,
  [SMALL_STATE(317)] = 18399,
  [SMALL_STATE(318)] = 18434,
  [SMALL_STATE(319)] = 18469,
  [SMALL_STATE(320)] = 18504,
  [SMALL_STATE(321)] = 18539,
  [SMALL_STATE(322)] = 18574,
  [SMALL_STATE(323)] = 18606,
  [SMALL_STATE(324)] = 18638,
  [SMALL_STATE(325)] = 18670,
  [SMALL_STATE(326)] = 18702,
  [SMALL_STATE(327)] = 18734,
  [SMALL_STATE(328)] = 18766,
  [SMALL_STATE(329)] = 18798,
  [SMALL_STATE(330)] = 18830,
  [SMALL_STATE(331)] = 18862,
  [SMALL_STATE(332)] = 18894,
  [SMALL_STATE(333)] = 18926,
  [SMALL_STATE(334)] = 18958,
  [SMALL_STATE(335)] = 18990,
  [SMALL_STATE(336)] = 19022,
  [SMALL_STATE(337)] = 19054,
  [SMALL_STATE(338)] = 19086,
  [SMALL_STATE(339)] = 19118,
  [SMALL_STATE(340)] = 19150,
  [SMALL_STATE(341)] = 19182,
  [SMALL_STATE(342)] = 19214,
  [SMALL_STATE(343)] = 19246,
  [SMALL_STATE(344)] = 19278,
  [SMALL_STATE(345)] = 19310,
  [SMALL_STATE(346)] = 19342,
  [SMALL_STATE(347)] = 19367,
  [SMALL_STATE(348)] = 19396,
  [SMALL_STATE(349)] = 19416,
  [SMALL_STATE(350)] = 19436,
  [SMALL_STATE(351)] = 19456,
  [SMALL_STATE(352)] = 19476,
  [SMALL_STATE(353)] = 19496,
  [SMALL_STATE(354)] = 19516,
  [SMALL_STATE(355)] = 19536,
  [SMALL_STATE(356)] = 19556,
  [SMALL_STATE(357)] = 19576,
  [SMALL_STATE(358)] = 19596,
  [SMALL_STATE(359)] = 19616,
  [SMALL_STATE(360)] = 19636,
  [SMALL_STATE(361)] = 19663,
  [SMALL_STATE(362)] = 19681,
  [SMALL_STATE(363)] = 19699,
  [SMALL_STATE(364)] = 19717,
  [SMALL_STATE(365)] = 19735,
  [SMALL_STATE(366)] = 19753,
  [SMALL_STATE(367)] = 19771,
  [SMALL_STATE(368)] = 19789,
  [SMALL_STATE(369)] = 19807,
  [SMALL_STATE(370)] = 19825,
  [SMALL_STATE(371)] = 19843,
  [SMALL_STATE(372)] = 19861,
  [SMALL_STATE(373)] = 19879,
  [SMALL_STATE(374)] = 19897,
  [SMALL_STATE(375)] = 19923,
  [SMALL_STATE(376)] = 19941,
  [SMALL_STATE(377)] = 19959,
  [SMALL_STATE(378)] = 19977,
  [SMALL_STATE(379)] = 19995,
  [SMALL_STATE(380)] = 20021,
  [SMALL_STATE(381)] = 20039,
  [SMALL_STATE(382)] = 20057,
  [SMALL_STATE(383)] = 20075,
  [SMALL_STATE(384)] = 20099,
  [SMALL_STATE(385)] = 20117,
  [SMALL_STATE(386)] = 20135,
  [SMALL_STATE(387)] = 20153,
  [SMALL_STATE(388)] = 20171,
  [SMALL_STATE(389)] = 20189,
  [SMALL_STATE(390)] = 20207,
  [SMALL_STATE(391)] = 20225,
  [SMALL_STATE(392)] = 20251,
  [SMALL_STATE(393)] = 20269,
  [SMALL_STATE(394)] = 20287,
  [SMALL_STATE(395)] = 20305,
  [SMALL_STATE(396)] = 20323,
  [SMALL_STATE(397)] = 20341,
  [SMALL_STATE(398)] = 20359,
  [SMALL_STATE(399)] = 20377,
  [SMALL_STATE(400)] = 20395,
  [SMALL_STATE(401)] = 20413,
  [SMALL_STATE(402)] = 20431,
  [SMALL_STATE(403)] = 20449,
  [SMALL_STATE(404)] = 20467,
  [SMALL_STATE(405)] = 20485,
  [SMALL_STATE(406)] = 20503,
  [SMALL_STATE(407)] = 20521,
  [SMALL_STATE(408)] = 20539,
  [SMALL_STATE(409)] = 20556,
  [SMALL_STATE(410)] = 20573,
  [SMALL_STATE(411)] = 20590,
  [SMALL_STATE(412)] = 20609,
  [SMALL_STATE(413)] = 20626,
  [SMALL_STATE(414)] = 20643,
  [SMALL_STATE(415)] = 20660,
  [SMALL_STATE(416)] = 20677,
  [SMALL_STATE(417)] = 20694,
  [SMALL_STATE(418)] = 20711,
  [SMALL_STATE(419)] = 20728,
  [SMALL_STATE(420)] = 20744,
  [SMALL_STATE(421)] = 20760,
  [SMALL_STATE(422)] = 20776,
  [SMALL_STATE(423)] = 20792,
  [SMALL_STATE(424)] = 20808,
  [SMALL_STATE(425)] = 20824,
  [SMALL_STATE(426)] = 20840,
  [SMALL_STATE(427)] = 20856,
  [SMALL_STATE(428)] = 20872,
  [SMALL_STATE(429)] = 20888,
  [SMALL_STATE(430)] = 20904,
  [SMALL_STATE(431)] = 20920,
  [SMALL_STATE(432)] = 20936,
  [SMALL_STATE(433)] = 20952,
  [SMALL_STATE(434)] = 20968,
  [SMALL_STATE(435)] = 20984,
  [SMALL_STATE(436)] = 21000,
  [SMALL_STATE(437)] = 21016,
  [SMALL_STATE(438)] = 21032,
  [SMALL_STATE(439)] = 21048,
  [SMALL_STATE(440)] = 21064,
  [SMALL_STATE(441)] = 21080,
  [SMALL_STATE(442)] = 21096,
  [SMALL_STATE(443)] = 21112,
  [SMALL_STATE(444)] = 21128,
  [SMALL_STATE(445)] = 21144,
  [SMALL_STATE(446)] = 21160,
  [SMALL_STATE(447)] = 21176,
  [SMALL_STATE(448)] = 21192,
  [SMALL_STATE(449)] = 21208,
  [SMALL_STATE(450)] = 21224,
  [SMALL_STATE(451)] = 21240,
  [SMALL_STATE(452)] = 21256,
  [SMALL_STATE(453)] = 21272,
  [SMALL_STATE(454)] = 21288,
  [SMALL_STATE(455)] = 21304,
  [SMALL_STATE(456)] = 21320,
  [SMALL_STATE(457)] = 21336,
  [SMALL_STATE(458)] = 21352,
  [SMALL_STATE(459)] = 21368,
  [SMALL_STATE(460)] = 21384,
  [SMALL_STATE(461)] = 21400,
  [SMALL_STATE(462)] = 21416,
  [SMALL_STATE(463)] = 21432,
  [SMALL_STATE(464)] = 21448,
  [SMALL_STATE(465)] = 21464,
  [SMALL_STATE(466)] = 21480,
  [SMALL_STATE(467)] = 21496,
  [SMALL_STATE(468)] = 21512,
  [SMALL_STATE(469)] = 21528,
  [SMALL_STATE(470)] = 21544,
  [SMALL_STATE(471)] = 21560,
  [SMALL_STATE(472)] = 21576,
  [SMALL_STATE(473)] = 21592,
  [SMALL_STATE(474)] = 21608,
  [SMALL_STATE(475)] = 21624,
  [SMALL_STATE(476)] = 21640,
  [SMALL_STATE(477)] = 21656,
  [SMALL_STATE(478)] = 21672,
  [SMALL_STATE(479)] = 21688,
  [SMALL_STATE(480)] = 21704,
  [SMALL_STATE(481)] = 21720,
  [SMALL_STATE(482)] = 21736,
  [SMALL_STATE(483)] = 21752,
  [SMALL_STATE(484)] = 21768,
  [SMALL_STATE(485)] = 21784,
  [SMALL_STATE(486)] = 21800,
  [SMALL_STATE(487)] = 21816,
  [SMALL_STATE(488)] = 21832,
  [SMALL_STATE(489)] = 21848,
  [SMALL_STATE(490)] = 21864,
  [SMALL_STATE(491)] = 21880,
  [SMALL_STATE(492)] = 21896,
  [SMALL_STATE(493)] = 21912,
  [SMALL_STATE(494)] = 21928,
  [SMALL_STATE(495)] = 21944,
  [SMALL_STATE(496)] = 21960,
  [SMALL_STATE(497)] = 21976,
  [SMALL_STATE(498)] = 21996,
  [SMALL_STATE(499)] = 22012,
  [SMALL_STATE(500)] = 22028,
  [SMALL_STATE(501)] = 22044,
  [SMALL_STATE(502)] = 22060,
  [SMALL_STATE(503)] = 22076,
  [SMALL_STATE(504)] = 22092,
  [SMALL_STATE(505)] = 22108,
  [SMALL_STATE(506)] = 22124,
  [SMALL_STATE(507)] = 22140,
  [SMALL_STATE(508)] = 22156,
  [SMALL_STATE(509)] = 22172,
  [SMALL_STATE(510)] = 22188,
  [SMALL_STATE(511)] = 22204,
  [SMALL_STATE(512)] = 22220,
  [SMALL_STATE(513)] = 22236,
  [SMALL_STATE(514)] = 22252,
  [SMALL_STATE(515)] = 22268,
  [SMALL_STATE(516)] = 22284,
  [SMALL_STATE(517)] = 22300,
  [SMALL_STATE(518)] = 22316,
  [SMALL_STATE(519)] = 22332,
  [SMALL_STATE(520)] = 22348,
  [SMALL_STATE(521)] = 22364,
  [SMALL_STATE(522)] = 22380,
  [SMALL_STATE(523)] = 22396,
  [SMALL_STATE(524)] = 22412,
  [SMALL_STATE(525)] = 22428,
  [SMALL_STATE(526)] = 22444,
  [SMALL_STATE(527)] = 22460,
  [SMALL_STATE(528)] = 22476,
  [SMALL_STATE(529)] = 22492,
  [SMALL_STATE(530)] = 22508,
  [SMALL_STATE(531)] = 22524,
  [SMALL_STATE(532)] = 22540,
  [SMALL_STATE(533)] = 22556,
  [SMALL_STATE(534)] = 22572,
  [SMALL_STATE(535)] = 22588,
  [SMALL_STATE(536)] = 22604,
  [SMALL_STATE(537)] = 22620,
  [SMALL_STATE(538)] = 22636,
  [SMALL_STATE(539)] = 22652,
  [SMALL_STATE(540)] = 22668,
  [SMALL_STATE(541)] = 22684,
  [SMALL_STATE(542)] = 22700,
  [SMALL_STATE(543)] = 22716,
  [SMALL_STATE(544)] = 22732,
  [SMALL_STATE(545)] = 22748,
  [SMALL_STATE(546)] = 22764,
  [SMALL_STATE(547)] = 22780,
  [SMALL_STATE(548)] = 22796,
  [SMALL_STATE(549)] = 22812,
  [SMALL_STATE(550)] = 22828,
  [SMALL_STATE(551)] = 22844,
  [SMALL_STATE(552)] = 22860,
  [SMALL_STATE(553)] = 22876,
  [SMALL_STATE(554)] = 22892,
  [SMALL_STATE(555)] = 22908,
  [SMALL_STATE(556)] = 22924,
  [SMALL_STATE(557)] = 22940,
  [SMALL_STATE(558)] = 22956,
  [SMALL_STATE(559)] = 22972,
  [SMALL_STATE(560)] = 22988,
  [SMALL_STATE(561)] = 23004,
  [SMALL_STATE(562)] = 23020,
  [SMALL_STATE(563)] = 23036,
  [SMALL_STATE(564)] = 23052,
  [SMALL_STATE(565)] = 23068,
  [SMALL_STATE(566)] = 23084,
  [SMALL_STATE(567)] = 23100,
  [SMALL_STATE(568)] = 23116,
  [SMALL_STATE(569)] = 23132,
  [SMALL_STATE(570)] = 23148,
  [SMALL_STATE(571)] = 23164,
  [SMALL_STATE(572)] = 23180,
  [SMALL_STATE(573)] = 23196,
  [SMALL_STATE(574)] = 23212,
  [SMALL_STATE(575)] = 23228,
  [SMALL_STATE(576)] = 23244,
  [SMALL_STATE(577)] = 23260,
  [SMALL_STATE(578)] = 23276,
  [SMALL_STATE(579)] = 23292,
  [SMALL_STATE(580)] = 23308,
  [SMALL_STATE(581)] = 23324,
  [SMALL_STATE(582)] = 23340,
  [SMALL_STATE(583)] = 23356,
  [SMALL_STATE(584)] = 23372,
  [SMALL_STATE(585)] = 23388,
  [SMALL_STATE(586)] = 23404,
  [SMALL_STATE(587)] = 23420,
  [SMALL_STATE(588)] = 23436,
  [SMALL_STATE(589)] = 23452,
  [SMALL_STATE(590)] = 23468,
  [SMALL_STATE(591)] = 23484,
  [SMALL_STATE(592)] = 23500,
  [SMALL_STATE(593)] = 23516,
  [SMALL_STATE(594)] = 23532,
  [SMALL_STATE(595)] = 23548,
  [SMALL_STATE(596)] = 23564,
  [SMALL_STATE(597)] = 23580,
  [SMALL_STATE(598)] = 23596,
  [SMALL_STATE(599)] = 23612,
  [SMALL_STATE(600)] = 23628,
  [SMALL_STATE(601)] = 23644,
  [SMALL_STATE(602)] = 23660,
  [SMALL_STATE(603)] = 23676,
  [SMALL_STATE(604)] = 23692,
  [SMALL_STATE(605)] = 23708,
  [SMALL_STATE(606)] = 23724,
  [SMALL_STATE(607)] = 23740,
  [SMALL_STATE(608)] = 23756,
  [SMALL_STATE(609)] = 23772,
  [SMALL_STATE(610)] = 23788,
  [SMALL_STATE(611)] = 23804,
  [SMALL_STATE(612)] = 23820,
  [SMALL_STATE(613)] = 23836,
  [SMALL_STATE(614)] = 23852,
  [SMALL_STATE(615)] = 23868,
  [SMALL_STATE(616)] = 23884,
  [SMALL_STATE(617)] = 23900,
  [SMALL_STATE(618)] = 23916,
  [SMALL_STATE(619)] = 23932,
  [SMALL_STATE(620)] = 23948,
  [SMALL_STATE(621)] = 23964,
  [SMALL_STATE(622)] = 23980,
  [SMALL_STATE(623)] = 23996,
  [SMALL_STATE(624)] = 24012,
  [SMALL_STATE(625)] = 24028,
  [SMALL_STATE(626)] = 24044,
  [SMALL_STATE(627)] = 24060,
  [SMALL_STATE(628)] = 24076,
  [SMALL_STATE(629)] = 24092,
  [SMALL_STATE(630)] = 24108,
  [SMALL_STATE(631)] = 24124,
  [SMALL_STATE(632)] = 24140,
  [SMALL_STATE(633)] = 24156,
  [SMALL_STATE(634)] = 24172,
  [SMALL_STATE(635)] = 24188,
  [SMALL_STATE(636)] = 24204,
  [SMALL_STATE(637)] = 24220,
  [SMALL_STATE(638)] = 24236,
  [SMALL_STATE(639)] = 24252,
  [SMALL_STATE(640)] = 24268,
  [SMALL_STATE(641)] = 24289,
  [SMALL_STATE(642)] = 24304,
  [SMALL_STATE(643)] = 24319,
  [SMALL_STATE(644)] = 24338,
  [SMALL_STATE(645)] = 24353,
  [SMALL_STATE(646)] = 24368,
  [SMALL_STATE(647)] = 24387,
  [SMALL_STATE(648)] = 24402,
  [SMALL_STATE(649)] = 24417,
  [SMALL_STATE(650)] = 24432,
  [SMALL_STATE(651)] = 24446,
  [SMALL_STATE(652)] = 24460,
  [SMALL_STATE(653)] = 24474,
  [SMALL_STATE(654)] = 24488,
  [SMALL_STATE(655)] = 24502,
  [SMALL_STATE(656)] = 24516,
  [SMALL_STATE(657)] = 24530,
  [SMALL_STATE(658)] = 24544,
  [SMALL_STATE(659)] = 24558,
  [SMALL_STATE(660)] = 24572,
  [SMALL_STATE(661)] = 24586,
  [SMALL_STATE(662)] = 24600,
  [SMALL_STATE(663)] = 24614,
  [SMALL_STATE(664)] = 24628,
  [SMALL_STATE(665)] = 24640,
  [SMALL_STATE(666)] = 24652,
  [SMALL_STATE(667)] = 24664,
  [SMALL_STATE(668)] = 24676,
  [SMALL_STATE(669)] = 24688,
  [SMALL_STATE(670)] = 24702,
  [SMALL_STATE(671)] = 24716,
  [SMALL_STATE(672)] = 24730,
  [SMALL_STATE(673)] = 24744,
  [SMALL_STATE(674)] = 24758,
  [SMALL_STATE(675)] = 24772,
  [SMALL_STATE(676)] = 24786,
  [SMALL_STATE(677)] = 24796,
  [SMALL_STATE(678)] = 24806,
  [SMALL_STATE(679)] = 24816,
  [SMALL_STATE(680)] = 24826,
  [SMALL_STATE(681)] = 24836,
  [SMALL_STATE(682)] = 24846,
  [SMALL_STATE(683)] = 24856,
  [SMALL_STATE(684)] = 24866,
  [SMALL_STATE(685)] = 24876,
  [SMALL_STATE(686)] = 24886,
  [SMALL_STATE(687)] = 24896,
  [SMALL_STATE(688)] = 24906,
  [SMALL_STATE(689)] = 24916,
  [SMALL_STATE(690)] = 24926,
  [SMALL_STATE(691)] = 24936,
  [SMALL_STATE(692)] = 24946,
  [SMALL_STATE(693)] = 24956,
  [SMALL_STATE(694)] = 24966,
  [SMALL_STATE(695)] = 24976,
  [SMALL_STATE(696)] = 24986,
  [SMALL_STATE(697)] = 24996,
  [SMALL_STATE(698)] = 25006,
  [SMALL_STATE(699)] = 25016,
  [SMALL_STATE(700)] = 25026,
  [SMALL_STATE(701)] = 25036,
  [SMALL_STATE(702)] = 25046,
  [SMALL_STATE(703)] = 25056,
  [SMALL_STATE(704)] = 25066,
  [SMALL_STATE(705)] = 25076,
  [SMALL_STATE(706)] = 25086,
  [SMALL_STATE(707)] = 25096,
  [SMALL_STATE(708)] = 25106,
  [SMALL_STATE(709)] = 25116,
  [SMALL_STATE(710)] = 25126,
  [SMALL_STATE(711)] = 25136,
  [SMALL_STATE(712)] = 25146,
  [SMALL_STATE(713)] = 25156,
  [SMALL_STATE(714)] = 25166,
  [SMALL_STATE(715)] = 25176,
  [SMALL_STATE(716)] = 25186,
  [SMALL_STATE(717)] = 25196,
  [SMALL_STATE(718)] = 25206,
  [SMALL_STATE(719)] = 25216,
  [SMALL_STATE(720)] = 25226,
  [SMALL_STATE(721)] = 25236,
  [SMALL_STATE(722)] = 25246,
  [SMALL_STATE(723)] = 25256,
  [SMALL_STATE(724)] = 25266,
  [SMALL_STATE(725)] = 25276,
  [SMALL_STATE(726)] = 25286,
  [SMALL_STATE(727)] = 25296,
  [SMALL_STATE(728)] = 25306,
  [SMALL_STATE(729)] = 25316,
  [SMALL_STATE(730)] = 25326,
  [SMALL_STATE(731)] = 25336,
  [SMALL_STATE(732)] = 25342,
  [SMALL_STATE(733)] = 25352,
  [SMALL_STATE(734)] = 25358,
  [SMALL_STATE(735)] = 25368,
  [SMALL_STATE(736)] = 25374,
  [SMALL_STATE(737)] = 25384,
  [SMALL_STATE(738)] = 25394,
  [SMALL_STATE(739)] = 25404,
  [SMALL_STATE(740)] = 25414,
  [SMALL_STATE(741)] = 25424,
  [SMALL_STATE(742)] = 25434,
  [SMALL_STATE(743)] = 25444,
  [SMALL_STATE(744)] = 25454,
  [SMALL_STATE(745)] = 25464,
  [SMALL_STATE(746)] = 25474,
  [SMALL_STATE(747)] = 25484,
  [SMALL_STATE(748)] = 25494,
  [SMALL_STATE(749)] = 25504,
  [SMALL_STATE(750)] = 25514,
  [SMALL_STATE(751)] = 25524,
  [SMALL_STATE(752)] = 25534,
  [SMALL_STATE(753)] = 25544,
  [SMALL_STATE(754)] = 25554,
  [SMALL_STATE(755)] = 25564,
  [SMALL_STATE(756)] = 25574,
  [SMALL_STATE(757)] = 25584,
  [SMALL_STATE(758)] = 25594,
  [SMALL_STATE(759)] = 25604,
  [SMALL_STATE(760)] = 25614,
  [SMALL_STATE(761)] = 25624,
  [SMALL_STATE(762)] = 25634,
  [SMALL_STATE(763)] = 25644,
  [SMALL_STATE(764)] = 25654,
  [SMALL_STATE(765)] = 25664,
  [SMALL_STATE(766)] = 25674,
  [SMALL_STATE(767)] = 25684,
  [SMALL_STATE(768)] = 25694,
  [SMALL_STATE(769)] = 25704,
  [SMALL_STATE(770)] = 25714,
  [SMALL_STATE(771)] = 25724,
  [SMALL_STATE(772)] = 25734,
  [SMALL_STATE(773)] = 25744,
  [SMALL_STATE(774)] = 25754,
  [SMALL_STATE(775)] = 25764,
  [SMALL_STATE(776)] = 25774,
  [SMALL_STATE(777)] = 25784,
  [SMALL_STATE(778)] = 25794,
  [SMALL_STATE(779)] = 25804,
  [SMALL_STATE(780)] = 25814,
  [SMALL_STATE(781)] = 25824,
  [SMALL_STATE(782)] = 25834,
  [SMALL_STATE(783)] = 25844,
  [SMALL_STATE(784)] = 25854,
  [SMALL_STATE(785)] = 25864,
  [SMALL_STATE(786)] = 25874,
  [SMALL_STATE(787)] = 25884,
  [SMALL_STATE(788)] = 25894,
  [SMALL_STATE(789)] = 25904,
  [SMALL_STATE(790)] = 25914,
  [SMALL_STATE(791)] = 25924,
  [SMALL_STATE(792)] = 25934,
  [SMALL_STATE(793)] = 25944,
  [SMALL_STATE(794)] = 25954,
  [SMALL_STATE(795)] = 25964,
  [SMALL_STATE(796)] = 25974,
  [SMALL_STATE(797)] = 25981,
  [SMALL_STATE(798)] = 25988,
  [SMALL_STATE(799)] = 25995,
  [SMALL_STATE(800)] = 26002,
  [SMALL_STATE(801)] = 26009,
  [SMALL_STATE(802)] = 26016,
  [SMALL_STATE(803)] = 26023,
  [SMALL_STATE(804)] = 26030,
  [SMALL_STATE(805)] = 26037,
  [SMALL_STATE(806)] = 26044,
  [SMALL_STATE(807)] = 26051,
  [SMALL_STATE(808)] = 26058,
  [SMALL_STATE(809)] = 26065,
  [SMALL_STATE(810)] = 26072,
  [SMALL_STATE(811)] = 26076,
  [SMALL_STATE(812)] = 26080,
  [SMALL_STATE(813)] = 26084,
  [SMALL_STATE(814)] = 26088,
  [SMALL_STATE(815)] = 26092,
  [SMALL_STATE(816)] = 26096,
  [SMALL_STATE(817)] = 26100,
  [SMALL_STATE(818)] = 26104,
  [SMALL_STATE(819)] = 26108,
  [SMALL_STATE(820)] = 26112,
  [SMALL_STATE(821)] = 26116,
  [SMALL_STATE(822)] = 26120,
  [SMALL_STATE(823)] = 26124,
  [SMALL_STATE(824)] = 26128,
  [SMALL_STATE(825)] = 26132,
  [SMALL_STATE(826)] = 26136,
  [SMALL_STATE(827)] = 26140,
  [SMALL_STATE(828)] = 26144,
  [SMALL_STATE(829)] = 26148,
  [SMALL_STATE(830)] = 26152,
  [SMALL_STATE(831)] = 26156,
  [SMALL_STATE(832)] = 26160,
  [SMALL_STATE(833)] = 26164,
  [SMALL_STATE(834)] = 26168,
  [SMALL_STATE(835)] = 26172,
  [SMALL_STATE(836)] = 26176,
  [SMALL_STATE(837)] = 26180,
  [SMALL_STATE(838)] = 26184,
  [SMALL_STATE(839)] = 26188,
  [SMALL_STATE(840)] = 26192,
  [SMALL_STATE(841)] = 26196,
  [SMALL_STATE(842)] = 26200,
  [SMALL_STATE(843)] = 26204,
  [SMALL_STATE(844)] = 26208,
  [SMALL_STATE(845)] = 26212,
  [SMALL_STATE(846)] = 26216,
  [SMALL_STATE(847)] = 26220,
  [SMALL_STATE(848)] = 26224,
  [SMALL_STATE(849)] = 26228,
  [SMALL_STATE(850)] = 26232,
  [SMALL_STATE(851)] = 26236,
  [SMALL_STATE(852)] = 26240,
  [SMALL_STATE(853)] = 26244,
  [SMALL_STATE(854)] = 26248,
  [SMALL_STATE(855)] = 26252,
  [SMALL_STATE(856)] = 26256,
  [SMALL_STATE(857)] = 26260,
  [SMALL_STATE(858)] = 26264,
  [SMALL_STATE(859)] = 26268,
  [SMALL_STATE(860)] = 26272,
  [SMALL_STATE(861)] = 26276,
  [SMALL_STATE(862)] = 26280,
  [SMALL_STATE(863)] = 26284,
  [SMALL_STATE(864)] = 26288,
  [SMALL_STATE(865)] = 26292,
  [SMALL_STATE(866)] = 26296,
  [SMALL_STATE(867)] = 26300,
  [SMALL_STATE(868)] = 26304,
  [SMALL_STATE(869)] = 26308,
  [SMALL_STATE(870)] = 26312,
  [SMALL_STATE(871)] = 26316,
  [SMALL_STATE(872)] = 26320,
  [SMALL_STATE(873)] = 26324,
  [SMALL_STATE(874)] = 26328,
  [SMALL_STATE(875)] = 26332,
  [SMALL_STATE(876)] = 26336,
  [SMALL_STATE(877)] = 26340,
  [SMALL_STATE(878)] = 26344,
  [SMALL_STATE(879)] = 26348,
  [SMALL_STATE(880)] = 26352,
  [SMALL_STATE(881)] = 26356,
  [SMALL_STATE(882)] = 26360,
  [SMALL_STATE(883)] = 26364,
  [SMALL_STATE(884)] = 26368,
  [SMALL_STATE(885)] = 26372,
  [SMALL_STATE(886)] = 26376,
  [SMALL_STATE(887)] = 26380,
  [SMALL_STATE(888)] = 26384,
  [SMALL_STATE(889)] = 26388,
  [SMALL_STATE(890)] = 26392,
  [SMALL_STATE(891)] = 26396,
  [SMALL_STATE(892)] = 26400,
  [SMALL_STATE(893)] = 26404,
  [SMALL_STATE(894)] = 26408,
  [SMALL_STATE(895)] = 26412,
  [SMALL_STATE(896)] = 26416,
  [SMALL_STATE(897)] = 26420,
  [SMALL_STATE(898)] = 26424,
  [SMALL_STATE(899)] = 26428,
  [SMALL_STATE(900)] = 26432,
  [SMALL_STATE(901)] = 26436,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(778),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(678),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(679),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(680),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(681),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(682),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(683),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(691),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(706),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(707),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(764),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(703),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(624),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(623),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [139] = {.entry = {.count = 1, .reusable = false}}, SHIFT(766),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(740),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [335] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(359),
  [338] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(322),
  [341] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(115),
  [344] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(55),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2),
  [349] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(312),
  [352] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(273),
  [355] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(353),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(615),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(719),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(785),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(762),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [530] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(191),
  [533] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(778),
  [536] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(691),
  [539] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(706),
  [542] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2),
  [544] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(678),
  [547] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(679),
  [550] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(680),
  [553] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(681),
  [556] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(682),
  [559] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(764),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [564] = {.entry = {.count = 1, .reusable = false}}, SHIFT(702),
  [566] = {.entry = {.count = 1, .reusable = false}}, SHIFT(783),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [570] = {.entry = {.count = 1, .reusable = false}}, SHIFT(737),
  [572] = {.entry = {.count = 1, .reusable = false}}, SHIFT(742),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [576] = {.entry = {.count = 1, .reusable = false}}, SHIFT(708),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [580] = {.entry = {.count = 1, .reusable = false}}, SHIFT(760),
  [582] = {.entry = {.count = 1, .reusable = false}}, SHIFT(775),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(723),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [590] = {.entry = {.count = 1, .reusable = false}}, SHIFT(717),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [594] = {.entry = {.count = 1, .reusable = false}}, SHIFT(718),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [598] = {.entry = {.count = 1, .reusable = false}}, SHIFT(715),
  [600] = {.entry = {.count = 1, .reusable = false}}, SHIFT(705),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [604] = {.entry = {.count = 1, .reusable = false}}, SHIFT(724),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [608] = {.entry = {.count = 1, .reusable = false}}, SHIFT(725),
  [610] = {.entry = {.count = 1, .reusable = false}}, SHIFT(722),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [614] = {.entry = {.count = 1, .reusable = false}}, SHIFT(743),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [618] = {.entry = {.count = 1, .reusable = false}}, SHIFT(734),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [622] = {.entry = {.count = 1, .reusable = false}}, SHIFT(757),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [626] = {.entry = {.count = 1, .reusable = false}}, SHIFT(761),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [630] = {.entry = {.count = 1, .reusable = false}}, SHIFT(756),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [634] = {.entry = {.count = 1, .reusable = false}}, SHIFT(767),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [638] = {.entry = {.count = 1, .reusable = false}}, SHIFT(755),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [642] = {.entry = {.count = 1, .reusable = false}}, SHIFT(768),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [648] = {.entry = {.count = 1, .reusable = false}}, SHIFT(770),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [652] = {.entry = {.count = 1, .reusable = false}}, SHIFT(771),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [656] = {.entry = {.count = 1, .reusable = false}}, SHIFT(736),
  [658] = {.entry = {.count = 1, .reusable = false}}, SHIFT(721),
  [660] = {.entry = {.count = 1, .reusable = false}}, SHIFT(677),
  [662] = {.entry = {.count = 1, .reusable = false}}, SHIFT(792),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [666] = {.entry = {.count = 1, .reusable = false}}, SHIFT(787),
  [668] = {.entry = {.count = 1, .reusable = false}}, SHIFT(786),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [672] = {.entry = {.count = 1, .reusable = false}}, SHIFT(716),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [676] = {.entry = {.count = 1, .reusable = false}}, SHIFT(789),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [680] = {.entry = {.count = 1, .reusable = false}}, SHIFT(698),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [692] = {.entry = {.count = 1, .reusable = false}}, SHIFT(769),
  [694] = {.entry = {.count = 1, .reusable = false}}, SHIFT(699),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [698] = {.entry = {.count = 1, .reusable = false}}, SHIFT(701),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [702] = {.entry = {.count = 1, .reusable = false}}, SHIFT(700),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [706] = {.entry = {.count = 1, .reusable = false}}, SHIFT(738),
  [708] = {.entry = {.count = 1, .reusable = false}}, SHIFT(739),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [724] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(262),
  [727] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(778),
  [730] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(678),
  [733] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(679),
  [736] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(680),
  [739] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(681),
  [742] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(682),
  [745] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(683),
  [748] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(263),
  [751] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [753] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(742),
  [756] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(264),
  [759] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(705),
  [762] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(265),
  [765] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(775),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [772] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(267),
  [775] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(783),
  [778] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(268),
  [781] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(722),
  [784] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(417),
  [787] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(347),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2),
  [792] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(314),
  [795] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(309),
  [798] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(409),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(644),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(653),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [809] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(735),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(651),
  [815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_arguments, 1),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [823] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoted_argument, 1),
  [829] = {.entry = {.count = 1, .reusable = false}}, SHIFT(279),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(659),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(641),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_arguments, 2),
  [841] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(359),
  [844] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(322),
  [847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2),
  [849] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(279),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [858] = {.entry = {.count = 1, .reusable = false}}, SHIFT(320),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(671),
  [888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [892] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(835),
  [896] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(417),
  [899] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(347),
  [902] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2),
  [904] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(308),
  [907] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoted_argument, 1),
  [909] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(650),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(837),
  [917] = {.entry = {.count = 1, .reusable = false}}, SHIFT(318),
  [919] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(644),
  [922] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(360),
  [925] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(311),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(733),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [934] = {.entry = {.count = 1, .reusable = false}}, SHIFT(311),
  [936] = {.entry = {.count = 1, .reusable = false}}, SHIFT(319),
  [938] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(650),
  [941] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(391),
  [944] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2),
  [946] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(317),
  [949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_element, 1),
  [951] = {.entry = {.count = 1, .reusable = false}}, SHIFT(317),
  [953] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(671),
  [956] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(374),
  [959] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(319),
  [962] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [964] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(657),
  [967] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(379),
  [970] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(321),
  [973] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 1),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(855),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(813),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [983] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 1),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(664),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(750),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [993] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1),
  [995] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(664),
  [998] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(340),
  [1001] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(750),
  [1004] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2),
  [1008] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(346),
  [1011] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(346),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(898),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(899),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1022] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_argument, 2),
  [1024] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_argument, 2),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren_argument, 2),
  [1028] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren_argument, 2),
  [1030] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_env_var, 5),
  [1032] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_env_var, 5),
  [1034] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cache_var, 5),
  [1036] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cache_var, 5),
  [1038] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_var, 4),
  [1040] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_var, 4),
  [1042] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1),
  [1044] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument, 1),
  [1046] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gen_exp, 4),
  [1048] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_gen_exp, 4),
  [1050] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_ref, 1),
  [1052] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_ref, 1),
  [1054] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gen_exp, 3),
  [1056] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_gen_exp, 3),
  [1058] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren_argument, 3),
  [1060] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren_argument, 3),
  [1062] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_argument, 3),
  [1064] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_argument, 3),
  [1066] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_escape_sequence, 1),
  [1068] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_escape_sequence, 1),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(890),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(891),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1078] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 5),
  [1080] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 5),
  [1082] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 3),
  [1084] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 3),
  [1086] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 4),
  [1088] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 4),
  [1090] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 4),
  [1092] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 4),
  [1094] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 3),
  [1096] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 3),
  [1098] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 3),
  [1100] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 3),
  [1102] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 5),
  [1104] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 5),
  [1106] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 4),
  [1108] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 4),
  [1110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 4),
  [1112] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 4),
  [1114] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 5),
  [1116] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 5),
  [1118] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 3),
  [1120] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 3),
  [1122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_condition, 2),
  [1124] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_condition, 2),
  [1126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_loop, 2),
  [1128] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_loop, 2),
  [1130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [1132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(894),
  [1134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(895),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_loop, 2),
  [1140] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_loop, 2),
  [1142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 2),
  [1144] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_def, 2),
  [1146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_def, 2),
  [1148] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_def, 2),
  [1150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_def, 2),
  [1152] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_def, 2),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(882),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(883),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 7),
  [1164] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 7),
  [1166] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 3),
  [1168] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 3),
  [1170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_condition, 3),
  [1172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_condition, 3),
  [1174] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(383),
  [1177] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2),
  [1179] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(383),
  [1182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_loop, 3),
  [1184] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_loop, 3),
  [1186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_loop, 3),
  [1188] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_loop, 3),
  [1190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 3),
  [1192] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_def, 3),
  [1194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_def, 3),
  [1196] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_def, 3),
  [1198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_def, 3),
  [1200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_def, 3),
  [1202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 6),
  [1204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 6),
  [1206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 4),
  [1208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 4),
  [1210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 1),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(878),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(879),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1220] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__quoted_text_repeat1, 1),
  [1222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 3),
  [1224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 3),
  [1226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 3),
  [1228] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 3),
  [1230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 3),
  [1232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 3),
  [1234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 3),
  [1236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 3),
  [1238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endblock_command, 3),
  [1240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endblock_command, 3),
  [1242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 5),
  [1244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 5),
  [1246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 4),
  [1248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 4),
  [1250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 4),
  [1252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 4),
  [1254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endblock_command, 5),
  [1256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endblock_command, 5),
  [1258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 4),
  [1260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 4),
  [1262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 4),
  [1264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 4),
  [1266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endblock_command, 4),
  [1268] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endblock_command, 4),
  [1270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 5),
  [1272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 5),
  [1274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 5),
  [1276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 5),
  [1278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 5),
  [1280] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 5),
  [1282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 5),
  [1284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 5),
  [1286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 1),
  [1288] = {.entry = {.count = 1, .reusable = false}}, SHIFT(551),
  [1290] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 1),
  [1292] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(497),
  [1295] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(497),
  [1298] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2),
  [1300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_command, 5),
  [1302] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_command, 5),
  [1304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 5),
  [1306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 5),
  [1308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 5),
  [1310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 5),
  [1312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 5),
  [1314] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 5),
  [1316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 5),
  [1318] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 5),
  [1320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_command, 4),
  [1322] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_command, 4),
  [1324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 4),
  [1326] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 4),
  [1328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 4),
  [1330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 4),
  [1332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 4),
  [1334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 4),
  [1336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 4),
  [1338] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 4),
  [1340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_command, 3),
  [1342] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_command, 3),
  [1344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 3),
  [1346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 3),
  [1348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 3),
  [1350] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 3),
  [1352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 3),
  [1354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 3),
  [1356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 3),
  [1358] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 3),
  [1360] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(640),
  [1363] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(640),
  [1366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 2),
  [1368] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 2), SHIFT_REPEAT(643),
  [1371] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__quoted_text_repeat1, 2), SHIFT_REPEAT(643),
  [1374] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(646),
  [1377] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(646),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(744),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(795),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(685),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(686),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(687),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(688),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(689),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(690),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(745),
  [1430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [1432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(807),
  [1438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(692),
  [1446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(693),
  [1450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(694),
  [1454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(796),
  [1456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(695),
  [1458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(696),
  [1462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(697),
  [1466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(704),
  [1472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(780),
  [1476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(781),
  [1480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(782),
  [1484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(805),
  [1492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(709),
  [1500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(710),
  [1504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(803),
  [1506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(712),
  [1508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(713),
  [1512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(714),
  [1516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(790),
  [1522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(720),
  [1526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(799),
  [1528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(779),
  [1530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(752),
  [1534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(759),
  [1538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(809),
  [1546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [1552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(726),
  [1554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(727),
  [1558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(728),
  [1562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(802),
  [1564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(729),
  [1566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(730),
  [1570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [1572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(732),
  [1574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(741),
  [1580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(758),
  [1584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_command_repeat1, 2),
  [1586] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_command_repeat1, 2), SHIFT_REPEAT(744),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_content, 1),
  [1593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(886),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(887),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(798),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [1613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(747),
  [1619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(748),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(749),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(806),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(751),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(753),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(754),
  [1643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(765),
  [1649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(772),
  [1655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(773),
  [1659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(804),
  [1661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(774),
  [1663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(676),
  [1667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(776),
  [1671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(777),
  [1675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(801),
  [1681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(763),
  [1685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(684),
  [1693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(808),
  [1695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [1701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [1703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(784),
  [1705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(791),
  [1711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(788),
  [1715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(800),
  [1717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(793),
  [1719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(711),
  [1725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(794),
  [1733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(797),
  [1735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1741] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [1743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1745] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [1747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1749] = {.entry = {.count = 1, .reusable = false}}, SHIFT(305),
  [1751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [1753] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [1755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1757] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [1759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1761] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [1763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1765] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [1767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1769] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [1771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1773] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [1775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1777] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [1779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [1781] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [1783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1785] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [1787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1789] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [1791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [1793] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [1795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(885),
  [1799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [1801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [1803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(826),
  [1815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(830),
  [1817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(829),
  [1819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_content, 2),
  [1825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(828),
  [1829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [1831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [1837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [1839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(866),
  [1843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(867),
  [1845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(642),
  [1847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(675),
  [1853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(674),
  [1855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(662),
  [1857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(666),
  [1859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(848),
  [1861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [1869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(647),
  [1871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(670),
  [1873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [1875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(842),
  [1879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(841),
  [1881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(663),
  [1889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [1891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(649),
  [1893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(731),
  [1899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [1905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(655),
  [1907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(849),
  [1911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(872),
  [1913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(669),
  [1919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [1921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [1923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [1925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(859),
  [1935] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [1941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(860),
  [1943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(884),
  [1949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(660),
  [1951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [1953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [1957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_cmake_external_scanner_create(void);
void tree_sitter_cmake_external_scanner_destroy(void *);
bool tree_sitter_cmake_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_cmake_external_scanner_serialize(void *, char *);
void tree_sitter_cmake_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_cmake(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_cmake_external_scanner_create,
      tree_sitter_cmake_external_scanner_destroy,
      tree_sitter_cmake_external_scanner_scan,
      tree_sitter_cmake_external_scanner_serialize,
      tree_sitter_cmake_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
