#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 534
#define LARGE_STATE_COUNT 225
#define SYMBOL_COUNT 73
#define ALIAS_COUNT 0
#define TOKEN_COUNT 35
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 11
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 43

enum {
  sym__ws = 1,
  sym_comment = 2,
  anon_sym_POUND_ = 3,
  sym_num_lit = 4,
  anon_sym_SLASH = 5,
  aux_sym__kwd_leading_slash_token1 = 6,
  aux_sym__kwd_qualified_token1 = 7,
  anon_sym_COLON = 8,
  anon_sym_COLON_COLON = 9,
  aux_sym_str_lit_token1 = 10,
  sym_char_lit = 11,
  sym_nil_lit = 12,
  sym_bool_lit = 13,
  aux_sym__sym_qualified_token1 = 14,
  aux_sym__sym_qualified_token2 = 15,
  anon_sym_CARET = 16,
  anon_sym_POUND_CARET = 17,
  anon_sym_LPAREN = 18,
  anon_sym_RPAREN = 19,
  anon_sym_LBRACE = 20,
  anon_sym_RBRACE = 21,
  anon_sym_LBRACK = 22,
  anon_sym_RBRACK = 23,
  anon_sym_POUND = 24,
  anon_sym_POUND_QMARK = 25,
  anon_sym_POUND_QMARK_AT = 26,
  anon_sym_POUND_SQUOTE = 27,
  anon_sym_POUND_POUND = 28,
  anon_sym_POUND_EQ = 29,
  anon_sym_AT = 30,
  anon_sym_SQUOTE = 31,
  anon_sym_BQUOTE = 32,
  anon_sym_TILDE_AT = 33,
  anon_sym_TILDE = 34,
  sym_source = 35,
  sym__gap = 36,
  sym_dis_expr = 37,
  sym__form = 38,
  sym_kwd_lit = 39,
  sym_str_lit = 40,
  sym_sym_lit = 41,
  sym__metadata_lit = 42,
  sym_meta_lit = 43,
  sym_old_meta_lit = 44,
  sym_list_lit = 45,
  sym__bare_list_lit = 46,
  sym_map_lit = 47,
  sym__bare_map_lit = 48,
  sym_vec_lit = 49,
  sym__bare_vec_lit = 50,
  sym_set_lit = 51,
  sym__bare_set_lit = 52,
  sym_anon_fn_lit = 53,
  sym_regex_lit = 54,
  sym_read_cond_lit = 55,
  sym_splicing_read_cond_lit = 56,
  sym_auto_res_mark = 57,
  sym_ns_map_lit = 58,
  sym_var_quoting_lit = 59,
  sym_sym_val_lit = 60,
  sym_evaling_lit = 61,
  sym_tagged_or_ctor_lit = 62,
  sym_derefing_lit = 63,
  sym_quoting_lit = 64,
  sym_syn_quoting_lit = 65,
  sym_unquote_splicing_lit = 66,
  sym_unquoting_lit = 67,
  aux_sym_source_repeat1 = 68,
  aux_sym_dis_expr_repeat1 = 69,
  aux_sym_sym_lit_repeat1 = 70,
  aux_sym__bare_list_lit_repeat1 = 71,
  aux_sym_read_cond_lit_repeat1 = 72,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__ws] = "_ws",
  [sym_comment] = "comment",
  [anon_sym_POUND_] = "#_",
  [sym_num_lit] = "num_lit",
  [anon_sym_SLASH] = "/",
  [aux_sym__kwd_leading_slash_token1] = "kwd_name",
  [aux_sym__kwd_qualified_token1] = "kwd_ns",
  [anon_sym_COLON] = ":",
  [anon_sym_COLON_COLON] = "::",
  [aux_sym_str_lit_token1] = "str_lit_token1",
  [sym_char_lit] = "char_lit",
  [sym_nil_lit] = "nil_lit",
  [sym_bool_lit] = "bool_lit",
  [aux_sym__sym_qualified_token1] = "sym_ns",
  [aux_sym__sym_qualified_token2] = "sym_name",
  [anon_sym_CARET] = "^",
  [anon_sym_POUND_CARET] = "#^",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_POUND] = "#",
  [anon_sym_POUND_QMARK] = "#\?",
  [anon_sym_POUND_QMARK_AT] = "#\?@",
  [anon_sym_POUND_SQUOTE] = "#'",
  [anon_sym_POUND_POUND] = "##",
  [anon_sym_POUND_EQ] = "#=",
  [anon_sym_AT] = "@",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_TILDE_AT] = "~@",
  [anon_sym_TILDE] = "~",
  [sym_source] = "source",
  [sym__gap] = "_gap",
  [sym_dis_expr] = "dis_expr",
  [sym__form] = "_form",
  [sym_kwd_lit] = "kwd_lit",
  [sym_str_lit] = "str_lit",
  [sym_sym_lit] = "sym_lit",
  [sym__metadata_lit] = "_metadata_lit",
  [sym_meta_lit] = "meta_lit",
  [sym_old_meta_lit] = "old_meta_lit",
  [sym_list_lit] = "list_lit",
  [sym__bare_list_lit] = "_bare_list_lit",
  [sym_map_lit] = "map_lit",
  [sym__bare_map_lit] = "_bare_map_lit",
  [sym_vec_lit] = "vec_lit",
  [sym__bare_vec_lit] = "_bare_vec_lit",
  [sym_set_lit] = "set_lit",
  [sym__bare_set_lit] = "_bare_set_lit",
  [sym_anon_fn_lit] = "anon_fn_lit",
  [sym_regex_lit] = "regex_lit",
  [sym_read_cond_lit] = "read_cond_lit",
  [sym_splicing_read_cond_lit] = "splicing_read_cond_lit",
  [sym_auto_res_mark] = "auto_res_mark",
  [sym_ns_map_lit] = "ns_map_lit",
  [sym_var_quoting_lit] = "var_quoting_lit",
  [sym_sym_val_lit] = "sym_val_lit",
  [sym_evaling_lit] = "evaling_lit",
  [sym_tagged_or_ctor_lit] = "tagged_or_ctor_lit",
  [sym_derefing_lit] = "derefing_lit",
  [sym_quoting_lit] = "quoting_lit",
  [sym_syn_quoting_lit] = "syn_quoting_lit",
  [sym_unquote_splicing_lit] = "unquote_splicing_lit",
  [sym_unquoting_lit] = "unquoting_lit",
  [aux_sym_source_repeat1] = "source_repeat1",
  [aux_sym_dis_expr_repeat1] = "dis_expr_repeat1",
  [aux_sym_sym_lit_repeat1] = "sym_lit_repeat1",
  [aux_sym__bare_list_lit_repeat1] = "_bare_list_lit_repeat1",
  [aux_sym_read_cond_lit_repeat1] = "read_cond_lit_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__ws] = sym__ws,
  [sym_comment] = sym_comment,
  [anon_sym_POUND_] = anon_sym_POUND_,
  [sym_num_lit] = sym_num_lit,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [aux_sym__kwd_leading_slash_token1] = aux_sym__kwd_leading_slash_token1,
  [aux_sym__kwd_qualified_token1] = aux_sym__kwd_qualified_token1,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [aux_sym_str_lit_token1] = aux_sym_str_lit_token1,
  [sym_char_lit] = sym_char_lit,
  [sym_nil_lit] = sym_nil_lit,
  [sym_bool_lit] = sym_bool_lit,
  [aux_sym__sym_qualified_token1] = aux_sym__sym_qualified_token1,
  [aux_sym__sym_qualified_token2] = aux_sym__sym_qualified_token2,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_POUND_CARET] = anon_sym_POUND_CARET,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_POUND_QMARK] = anon_sym_POUND_QMARK,
  [anon_sym_POUND_QMARK_AT] = anon_sym_POUND_QMARK_AT,
  [anon_sym_POUND_SQUOTE] = anon_sym_POUND_SQUOTE,
  [anon_sym_POUND_POUND] = anon_sym_POUND_POUND,
  [anon_sym_POUND_EQ] = anon_sym_POUND_EQ,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_TILDE_AT] = anon_sym_TILDE_AT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [sym_source] = sym_source,
  [sym__gap] = sym__gap,
  [sym_dis_expr] = sym_dis_expr,
  [sym__form] = sym__form,
  [sym_kwd_lit] = sym_kwd_lit,
  [sym_str_lit] = sym_str_lit,
  [sym_sym_lit] = sym_sym_lit,
  [sym__metadata_lit] = sym__metadata_lit,
  [sym_meta_lit] = sym_meta_lit,
  [sym_old_meta_lit] = sym_old_meta_lit,
  [sym_list_lit] = sym_list_lit,
  [sym__bare_list_lit] = sym__bare_list_lit,
  [sym_map_lit] = sym_map_lit,
  [sym__bare_map_lit] = sym__bare_map_lit,
  [sym_vec_lit] = sym_vec_lit,
  [sym__bare_vec_lit] = sym__bare_vec_lit,
  [sym_set_lit] = sym_set_lit,
  [sym__bare_set_lit] = sym__bare_set_lit,
  [sym_anon_fn_lit] = sym_anon_fn_lit,
  [sym_regex_lit] = sym_regex_lit,
  [sym_read_cond_lit] = sym_read_cond_lit,
  [sym_splicing_read_cond_lit] = sym_splicing_read_cond_lit,
  [sym_auto_res_mark] = sym_auto_res_mark,
  [sym_ns_map_lit] = sym_ns_map_lit,
  [sym_var_quoting_lit] = sym_var_quoting_lit,
  [sym_sym_val_lit] = sym_sym_val_lit,
  [sym_evaling_lit] = sym_evaling_lit,
  [sym_tagged_or_ctor_lit] = sym_tagged_or_ctor_lit,
  [sym_derefing_lit] = sym_derefing_lit,
  [sym_quoting_lit] = sym_quoting_lit,
  [sym_syn_quoting_lit] = sym_syn_quoting_lit,
  [sym_unquote_splicing_lit] = sym_unquote_splicing_lit,
  [sym_unquoting_lit] = sym_unquoting_lit,
  [aux_sym_source_repeat1] = aux_sym_source_repeat1,
  [aux_sym_dis_expr_repeat1] = aux_sym_dis_expr_repeat1,
  [aux_sym_sym_lit_repeat1] = aux_sym_sym_lit_repeat1,
  [aux_sym__bare_list_lit_repeat1] = aux_sym__bare_list_lit_repeat1,
  [aux_sym_read_cond_lit_repeat1] = aux_sym_read_cond_lit_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__ws] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND_] = {
    .visible = true,
    .named = false,
  },
  [sym_num_lit] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__kwd_leading_slash_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__kwd_qualified_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_str_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_char_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_nil_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_lit] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__sym_qualified_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__sym_qualified_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_QMARK_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [sym_source] = {
    .visible = true,
    .named = true,
  },
  [sym__gap] = {
    .visible = false,
    .named = true,
  },
  [sym_dis_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__form] = {
    .visible = false,
    .named = true,
  },
  [sym_kwd_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_str_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_sym_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__metadata_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_meta_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_old_meta_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_list_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_list_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_map_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_map_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_vec_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_vec_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_set_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_set_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_anon_fn_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_read_cond_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_splicing_read_cond_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_auto_res_mark] = {
    .visible = true,
    .named = true,
  },
  [sym_ns_map_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_var_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_sym_val_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_evaling_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_tagged_or_ctor_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_derefing_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_syn_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_unquote_splicing_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_unquoting_lit] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dis_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sym_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bare_list_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_read_cond_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_close = 1,
  field_delimiter = 2,
  field_marker = 3,
  field_meta = 4,
  field_name = 5,
  field_namespace = 6,
  field_old_meta = 7,
  field_open = 8,
  field_prefix = 9,
  field_tag = 10,
  field_value = 11,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_close] = "close",
  [field_delimiter] = "delimiter",
  [field_marker] = "marker",
  [field_meta] = "meta",
  [field_name] = "name",
  [field_namespace] = "namespace",
  [field_old_meta] = "old_meta",
  [field_open] = "open",
  [field_prefix] = "prefix",
  [field_tag] = "tag",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 3},
  [6] = {.index = 8, .length = 4},
  [7] = {.index = 12, .length = 2},
  [8] = {.index = 14, .length = 2},
  [9] = {.index = 16, .length = 2},
  [10] = {.index = 18, .length = 1},
  [11] = {.index = 19, .length = 1},
  [12] = {.index = 20, .length = 4},
  [13] = {.index = 24, .length = 3},
  [14] = {.index = 27, .length = 5},
  [15] = {.index = 32, .length = 6},
  [16] = {.index = 38, .length = 4},
  [17] = {.index = 42, .length = 2},
  [18] = {.index = 44, .length = 3},
  [19] = {.index = 47, .length = 3},
  [20] = {.index = 50, .length = 3},
  [21] = {.index = 53, .length = 2},
  [22] = {.index = 55, .length = 3},
  [23] = {.index = 58, .length = 5},
  [24] = {.index = 63, .length = 3},
  [25] = {.index = 66, .length = 4},
  [26] = {.index = 70, .length = 6},
  [27] = {.index = 76, .length = 4},
  [28] = {.index = 80, .length = 4},
  [29] = {.index = 84, .length = 4},
  [30] = {.index = 88, .length = 5},
  [31] = {.index = 93, .length = 3},
  [32] = {.index = 96, .length = 3},
  [33] = {.index = 99, .length = 5},
  [34] = {.index = 104, .length = 7},
  [35] = {.index = 111, .length = 5},
  [36] = {.index = 116, .length = 6},
  [37] = {.index = 122, .length = 4},
  [38] = {.index = 126, .length = 3},
  [39] = {.index = 129, .length = 7},
  [40] = {.index = 136, .length = 5},
  [41] = {.index = 141, .length = 5},
  [42] = {.index = 146, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
  [3] =
    {field_meta, 0},
  [4] =
    {field_old_meta, 0},
  [5] =
    {field_close, 0, .inherited = true},
    {field_open, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [8] =
    {field_close, 0, .inherited = true},
    {field_marker, 0, .inherited = true},
    {field_open, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [12] =
    {field_marker, 0},
    {field_value, 1},
  [14] =
    {field_marker, 0},
    {field_name, 1},
  [16] =
    {field_close, 1},
    {field_open, 0},
  [18] =
    {field_value, 0},
  [19] =
    {field_marker, 0},
  [20] =
    {field_close, 1, .inherited = true},
    {field_marker, 0},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [24] =
    {field_meta, 0, .inherited = true},
    {field_name, 1},
    {field_old_meta, 0, .inherited = true},
  [27] =
    {field_close, 1, .inherited = true},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [32] =
    {field_close, 1, .inherited = true},
    {field_marker, 1, .inherited = true},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [38] =
    {field_meta, 0, .inherited = true},
    {field_meta, 1, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_old_meta, 1, .inherited = true},
  [42] =
    {field_marker, 0},
    {field_value, 2},
  [44] =
    {field_delimiter, 1},
    {field_marker, 0},
    {field_name, 2},
  [47] =
    {field_delimiter, 1},
    {field_name, 2},
    {field_namespace, 0},
  [50] =
    {field_close, 2},
    {field_open, 0},
    {field_value, 1, .inherited = true},
  [53] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [55] =
    {field_close, 2},
    {field_marker, 0},
    {field_open, 1},
  [58] =
    {field_close, 2, .inherited = true},
    {field_marker, 0},
    {field_open, 2, .inherited = true},
    {field_prefix, 1},
    {field_value, 2, .inherited = true},
  [63] =
    {field_marker, 0},
    {field_tag, 1},
    {field_value, 2},
  [66] =
    {field_close, 2, .inherited = true},
    {field_marker, 0},
    {field_open, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [70] =
    {field_close, 2, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [76] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_value, 2},
  [80] =
    {field_delimiter, 2},
    {field_marker, 0},
    {field_name, 3},
    {field_namespace, 1},
  [84] =
    {field_close, 3},
    {field_marker, 0},
    {field_open, 1},
    {field_value, 2, .inherited = true},
  [88] =
    {field_close, 3, .inherited = true},
    {field_marker, 0},
    {field_open, 3, .inherited = true},
    {field_prefix, 1},
    {field_value, 3, .inherited = true},
  [93] =
    {field_marker, 0},
    {field_tag, 1},
    {field_value, 3},
  [96] =
    {field_marker, 0},
    {field_tag, 2},
    {field_value, 3},
  [99] =
    {field_delimiter, 2},
    {field_meta, 0, .inherited = true},
    {field_name, 3},
    {field_namespace, 1},
    {field_old_meta, 0, .inherited = true},
  [104] =
    {field_close, 3, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_prefix, 2},
    {field_value, 3, .inherited = true},
  [111] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 2},
    {field_value, 3},
  [116] =
    {field_close, 3, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [122] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_value, 3},
  [126] =
    {field_marker, 0},
    {field_tag, 2},
    {field_value, 4},
  [129] =
    {field_close, 4, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_prefix, 2},
    {field_value, 4, .inherited = true},
  [136] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 2},
    {field_value, 4},
  [141] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 3},
    {field_value, 4},
  [146] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 3},
    {field_value, 5},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = aux_sym__sym_qualified_token2,
  },
  [8] = {
    [1] = aux_sym__kwd_leading_slash_token1,
  },
  [13] = {
    [1] = aux_sym__sym_qualified_token2,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym__ws_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ','
      ? (c < 28
        ? (c >= '\t' && c <= '\r')
        : c <= ' ')
      : (c <= ',' || c == 5760))
    : (c <= 8198 || (c < 8287
      ? (c < 8232
        ? (c >= 8200 && c <= 8202)
        : c <= 8233)
      : (c <= 8287 || c == 12288))));
}

static inline bool sym_comment_character_set_1(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '/'
          ? c == ','
          : c <= '/')
        : (c <= ';' || c == '@'))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == '`'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < '@'
        ? (c < ';'
          ? c == ','
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? c == '{'
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_3(int32_t c) {
  return (c < '{'
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= '"' || (c >= '(' && c <= ')')))
      : (c <= ',' || (c < '@'
        ? c == ';'
        : (c <= '@' || (c >= '[' && c <= '`')))))
    : (c <= '{' || (c < 8200
      ? (c < 5760
        ? (c >= '}' && c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_4(int32_t c) {
  return (c < '@'
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < '/'
        ? c == ','
        : (c <= '9' || c == ';'))))
    : (c <= '^' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? (c >= '`' && c <= '{')
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_6(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '/'
          ? c == ','
          : c <= '9')
        : (c <= ';' || (c >= '@' && c <= 'F')))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? (c >= '`' && c <= 'f')
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_10(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '/'
          ? c == ','
          : c <= '9')
        : (c <= ';' || c == '@'))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == '`'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_11(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '0'
          ? c == ','
          : c <= '9')
        : (c <= ';' || c == '@'))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == '`'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_14(int32_t c) {
  return (c < '`'
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || (c < '('
          ? c == '"'
          : c <= ')')))
      : (c <= ',' || (c < '@'
        ? (c < ';'
          ? c == '/'
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == 'l'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_qualified_token1_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < '@'
        ? (c < ':'
          ? c == ','
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? c == '{'
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(46);
      if (lookahead == '"') ADVANCE(3);
      if (lookahead == '#') ADVANCE(147);
      if (lookahead == '\'') ADVANCE(162);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == ')') ADVANCE(140);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '0') ADVANCE(56);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(51);
      if (lookahead == '@') ADVANCE(160);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == '\\') ADVANCE(43);
      if (lookahead == ']') ADVANCE(144);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '`') ADVANCE(163);
      if (lookahead == 'f') ADVANCE(98);
      if (lookahead == 'n') ADVANCE(92);
      if (lookahead == 't') ADVANCE(95);
      if (lookahead == '{') ADVANCE(141);
      if (lookahead == '}') ADVANCE(142);
      if (lookahead == '~') ADVANCE(165);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(87);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(58);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(47);
      if (lookahead != 0) ADVANCE(99);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(3);
      if (lookahead == '#') ADVANCE(146);
      if (lookahead == '\'') ADVANCE(161);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(51);
      if (lookahead == '@') ADVANCE(160);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '`') ADVANCE(163);
      if (lookahead == '{') ADVANCE(141);
      if (lookahead == '~') ADVANCE(165);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(47);
      if (lookahead != 0 &&
          lookahead != ')' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '\\' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(135);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(3);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(100);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(51);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '{') ADVANCE(141);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(47);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '@' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(99);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead != 0) ADVANCE(3);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '\'') ADVANCE(161);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == '@') ADVANCE(160);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '`') ADVANCE(163);
      if (lookahead == '{') ADVANCE(141);
      if (lookahead == '~') ADVANCE(165);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != ')' &&
          lookahead != ',' &&
          (lookahead < '0' || ';' < lookahead) &&
          lookahead != '\\' &&
          lookahead != ']' &&
          lookahead != '}' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(135);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(148);
      if (lookahead == '\'') ADVANCE(162);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '/') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= ':')) ADVANCE(100);
      if (lookahead == ';') ADVANCE(51);
      if (lookahead == '@') ADVANCE(160);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '`') ADVANCE(163);
      if (lookahead == '{') ADVANCE(141);
      if (lookahead == '~') ADVANCE(165);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(47);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != ')' &&
          lookahead != '\\' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(99);
      END_STATE();
    case 6:
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= ':')) ADVANCE(100);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ';') ADVANCE(51);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '{') ADVANCE(141);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(47);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != ')' &&
          lookahead != '@' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(99);
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(79);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= ':')) ADVANCE(100);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ';') ADVANCE(51);
      if (lookahead == '^') ADVANCE(137);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(47);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '@' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(99);
      END_STATE();
    case 8:
      if (lookahead == '#') ADVANCE(101);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == ';') ADVANCE(51);
      if (lookahead == '{') ADVANCE(141);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(47);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ':' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(102);
      END_STATE();
    case 9:
      if (lookahead == '#') ADVANCE(80);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      if (lookahead == ';') ADVANCE(51);
      if (lookahead == '{') ADVANCE(141);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(47);
      END_STATE();
    case 10:
      if (lookahead == '/') ADVANCE(76);
      if (!aux_sym__kwd_qualified_token1_character_set_1(lookahead)) ADVANCE(102);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(14);
      END_STATE();
    case 12:
      if (lookahead == 'b') ADVANCE(108);
      END_STATE();
    case 13:
      if (lookahead == 'c') ADVANCE(21);
      END_STATE();
    case 14:
      if (lookahead == 'c') ADVANCE(16);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(108);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(15);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == 'f') ADVANCE(18);
      END_STATE();
    case 20:
      if (lookahead == 'i') ADVANCE(25);
      END_STATE();
    case 21:
      if (lookahead == 'k') ADVANCE(29);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(20);
      END_STATE();
    case 23:
      if (lookahead == 'm') ADVANCE(19);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(108);
      END_STATE();
    case 25:
      if (lookahead == 'n') ADVANCE(16);
      END_STATE();
    case 26:
      if (lookahead == 'p') ADVANCE(11);
      END_STATE();
    case 27:
      if (lookahead == 'r') ADVANCE(23);
      END_STATE();
    case 28:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(26);
      END_STATE();
    case 30:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(28);
      END_STATE();
    case 32:
      if (lookahead == 'w') ADVANCE(22);
      END_STATE();
    case 33:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(108);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 41:
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 42:
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(136);
      END_STATE();
    case 43:
      if (lookahead != 0 &&
          lookahead != 'b' &&
          lookahead != 'f' &&
          lookahead != 'n' &&
          lookahead != 'o' &&
          (lookahead < 'r' || 'u' < lookahead)) ADVANCE(108);
      if (lookahead == 'b') ADVANCE(109);
      if (lookahead == 'f') ADVANCE(113);
      if (lookahead == 'n') ADVANCE(111);
      if (lookahead == 'o') ADVANCE(117);
      if (lookahead == 'r') ADVANCE(112);
      if (lookahead == 's') ADVANCE(114);
      if (lookahead == 't') ADVANCE(110);
      if (lookahead == 'u') ADVANCE(118);
      END_STATE();
    case 44:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(3);
      END_STATE();
    case 45:
      if (eof) ADVANCE(46);
      if (lookahead == '"') ADVANCE(3);
      if (lookahead == '#') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(161);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == ')') ADVANCE(140);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == '0') ADVANCE(62);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(51);
      if (lookahead == '@') ADVANCE(160);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == '\\') ADVANCE(43);
      if (lookahead == ']') ADVANCE(144);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '`') ADVANCE(163);
      if (lookahead == 'f') ADVANCE(123);
      if (lookahead == 'n') ADVANCE(125);
      if (lookahead == 't') ADVANCE(128);
      if (lookahead == '{') ADVANCE(141);
      if (lookahead == '}') ADVANCE(142);
      if (lookahead == '~') ADVANCE(165);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(122);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(47);
      if (lookahead != 0) ADVANCE(135);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym__ws);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(48);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(49);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (28 <= lookahead && lookahead <= ' ') ||
          lookahead == '"' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ',' ||
          lookahead == '/' ||
          lookahead == ';' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= '^') ||
          lookahead == '`' ||
          lookahead == '{' ||
          lookahead == '}' ||
          lookahead == '~' ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8198) ||
          (8200 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(51);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(48);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(50);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (28 <= lookahead && lookahead <= ' ') ||
          lookahead == '"' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ',' ||
          lookahead == ';' ||
          lookahead == '@' ||
          ('[' <= lookahead && lookahead <= '^') ||
          lookahead == '`' ||
          lookahead == '{' ||
          lookahead == '}' ||
          lookahead == '~' ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8198) ||
          (8200 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(51);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead != 0) ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_POUND_);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_POUND_);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(102);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_POUND_);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_num_lit);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(68);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(86);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(82);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(84);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(57);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(68);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(86);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(82);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(68);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(86);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(69);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(85);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(81);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(83);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(60);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(69);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(85);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(81);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(69);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(85);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(70);
      if (lookahead == '/') ADVANCE(34);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(33);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(40);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(37);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(63);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(70);
      if (lookahead == '/') ADVANCE(34);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(33);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(40);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(70);
      if (lookahead == '/') ADVANCE(34);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(33);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(71);
      if (lookahead == '/') ADVANCE(34);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(131);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(132);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(133);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(66);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(71);
      if (lookahead == '/') ADVANCE(34);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(131);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(132);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(71);
      if (lookahead == '/') ADVANCE(34);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(131);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'N') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_num_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_num_lit);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || '"' < lookahead) &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '?' &&
          lookahead != '@' &&
          (lookahead < '[' || '`' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(100);
      if (lookahead == '?') ADVANCE(151);
      if (lookahead == '^') ADVANCE(138);
      if (lookahead == '_') ADVANCE(54);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead == '!') ADVANCE(50);
      if (!aux_sym__kwd_leading_slash_token1_character_set_3(lookahead)) ADVANCE(100);
      if (lookahead == '^') ADVANCE(138);
      if (lookahead == '_') ADVANCE(54);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead == '!') ADVANCE(50);
      if (!aux_sym__kwd_leading_slash_token1_character_set_3(lookahead)) ADVANCE(100);
      if (lookahead == '_') ADVANCE(54);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_4(lookahead)) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ';' &&
          (lookahead < '@' || '^' < lookahead) &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_6(lookahead)) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ';' &&
          (lookahead < '@' || 'F' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '`' || 'f' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          (lookahead < '+' || '-' < lookahead) &&
          (lookahead < '/' || '9' < lookahead) &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          (lookahead < '+' || '-' < lookahead) &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(100);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_10(lookahead)) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == '0') ADVANCE(59);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(61);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_10(lookahead)) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_11(lookahead)) ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_11(lookahead)) ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != '/' &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != 'e' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != '/' &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != 'i' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_14(lookahead)) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == 'l') ADVANCE(96);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_14(lookahead)) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == 'l') ADVANCE(119);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != '/' &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != 'r' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != '/' &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != 's' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == 's') ADVANCE(91);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != '/' &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != 'u' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == 'u') ADVANCE(91);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != '/' &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != 'a' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == 'a') ADVANCE(93);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym__kwd_qualified_token1);
      if (lookahead == '!') ADVANCE(49);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || '"' < lookahead) &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != '/' &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '`' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(102);
      if (lookahead == '_') ADVANCE(53);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym__kwd_qualified_token1);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(102);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(105);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (!aux_sym__kwd_qualified_token1_character_set_1(lookahead)) ADVANCE(100);
      if (lookahead == ':') ADVANCE(106);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym_str_lit_token1);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_char_lit);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'a') ADVANCE(13);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'a') ADVANCE(12);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'p') ADVANCE(11);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(108);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(116);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_nil_lit);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(99);
      if (lookahead == '/') ADVANCE(100);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_nil_lit);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_bool_lit);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == '0') ADVANCE(65);
      if (!aux_sym__kwd_leading_slash_token1_character_set_10(lookahead)) ADVANCE(135);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'a') ADVANCE(126);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'e') ADVANCE(121);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'i') ADVANCE(127);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'l') ADVANCE(129);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'l') ADVANCE(120);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'r') ADVANCE(130);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 's') ADVANCE(124);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'u') ADVANCE(124);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(134);
      if (!aux_sym__kwd_leading_slash_token1_character_set_10(lookahead)) ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_4(lookahead)) ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_6(lookahead)) ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_10(lookahead)) ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token2);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_POUND_CARET);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(51);
      if (lookahead == '#') ADVANCE(156);
      if (lookahead == '\'') ADVANCE(154);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '?') ADVANCE(150);
      if (lookahead == '^') ADVANCE(138);
      if (lookahead == '_') ADVANCE(52);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(51);
      if (lookahead == '\'') ADVANCE(154);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '?') ADVANCE(150);
      if (lookahead == '^') ADVANCE(138);
      if (lookahead == '_') ADVANCE(52);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '#') ADVANCE(157);
      if (lookahead == '\'') ADVANCE(155);
      if (lookahead == '=') ADVANCE(159);
      if (lookahead == '?') ADVANCE(152);
      if (lookahead == '^') ADVANCE(138);
      if (lookahead == '_') ADVANCE(54);
      if (!aux_sym__kwd_leading_slash_token1_character_set_3(lookahead)) ADVANCE(100);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '\'') ADVANCE(155);
      if (lookahead == '=') ADVANCE(159);
      if (lookahead == '?') ADVANCE(152);
      if (lookahead == '^') ADVANCE(138);
      if (lookahead == '_') ADVANCE(54);
      if (!aux_sym__kwd_leading_slash_token1_character_set_3(lookahead)) ADVANCE(100);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '\'') ADVANCE(154);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '?') ADVANCE(150);
      if (lookahead == '^') ADVANCE(138);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK);
      if (lookahead == '@') ADVANCE(153);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      if (lookahead == '@') ADVANCE(153);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK_AT);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_POUND_SQUOTE);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_POUND_SQUOTE);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_POUND_POUND);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_POUND_POUND);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_POUND_EQ);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_POUND_EQ);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_TILDE_AT);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '@') ADVANCE(164);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 45},
  [2] = {.lex_state = 45},
  [3] = {.lex_state = 45},
  [4] = {.lex_state = 45},
  [5] = {.lex_state = 45},
  [6] = {.lex_state = 45},
  [7] = {.lex_state = 45},
  [8] = {.lex_state = 45},
  [9] = {.lex_state = 45},
  [10] = {.lex_state = 45},
  [11] = {.lex_state = 45},
  [12] = {.lex_state = 45},
  [13] = {.lex_state = 45},
  [14] = {.lex_state = 45},
  [15] = {.lex_state = 45},
  [16] = {.lex_state = 45},
  [17] = {.lex_state = 45},
  [18] = {.lex_state = 45},
  [19] = {.lex_state = 45},
  [20] = {.lex_state = 45},
  [21] = {.lex_state = 45},
  [22] = {.lex_state = 45},
  [23] = {.lex_state = 45},
  [24] = {.lex_state = 45},
  [25] = {.lex_state = 45},
  [26] = {.lex_state = 45},
  [27] = {.lex_state = 45},
  [28] = {.lex_state = 45},
  [29] = {.lex_state = 45},
  [30] = {.lex_state = 45},
  [31] = {.lex_state = 45},
  [32] = {.lex_state = 45},
  [33] = {.lex_state = 45},
  [34] = {.lex_state = 45},
  [35] = {.lex_state = 45},
  [36] = {.lex_state = 45},
  [37] = {.lex_state = 45},
  [38] = {.lex_state = 45},
  [39] = {.lex_state = 45},
  [40] = {.lex_state = 45},
  [41] = {.lex_state = 45},
  [42] = {.lex_state = 45},
  [43] = {.lex_state = 45},
  [44] = {.lex_state = 45},
  [45] = {.lex_state = 45},
  [46] = {.lex_state = 45},
  [47] = {.lex_state = 45},
  [48] = {.lex_state = 45},
  [49] = {.lex_state = 45},
  [50] = {.lex_state = 45},
  [51] = {.lex_state = 45},
  [52] = {.lex_state = 45},
  [53] = {.lex_state = 45},
  [54] = {.lex_state = 45},
  [55] = {.lex_state = 45},
  [56] = {.lex_state = 45},
  [57] = {.lex_state = 45},
  [58] = {.lex_state = 45},
  [59] = {.lex_state = 45},
  [60] = {.lex_state = 45},
  [61] = {.lex_state = 45},
  [62] = {.lex_state = 45},
  [63] = {.lex_state = 45},
  [64] = {.lex_state = 45},
  [65] = {.lex_state = 45},
  [66] = {.lex_state = 45},
  [67] = {.lex_state = 45},
  [68] = {.lex_state = 45},
  [69] = {.lex_state = 45},
  [70] = {.lex_state = 45},
  [71] = {.lex_state = 45},
  [72] = {.lex_state = 45},
  [73] = {.lex_state = 45},
  [74] = {.lex_state = 45},
  [75] = {.lex_state = 45},
  [76] = {.lex_state = 45},
  [77] = {.lex_state = 45},
  [78] = {.lex_state = 45},
  [79] = {.lex_state = 45},
  [80] = {.lex_state = 45},
  [81] = {.lex_state = 45},
  [82] = {.lex_state = 45},
  [83] = {.lex_state = 45},
  [84] = {.lex_state = 45},
  [85] = {.lex_state = 45},
  [86] = {.lex_state = 45},
  [87] = {.lex_state = 45},
  [88] = {.lex_state = 45},
  [89] = {.lex_state = 45},
  [90] = {.lex_state = 45},
  [91] = {.lex_state = 45},
  [92] = {.lex_state = 45},
  [93] = {.lex_state = 45},
  [94] = {.lex_state = 45},
  [95] = {.lex_state = 45},
  [96] = {.lex_state = 45},
  [97] = {.lex_state = 45},
  [98] = {.lex_state = 45},
  [99] = {.lex_state = 45},
  [100] = {.lex_state = 45},
  [101] = {.lex_state = 45},
  [102] = {.lex_state = 45},
  [103] = {.lex_state = 45},
  [104] = {.lex_state = 45},
  [105] = {.lex_state = 45},
  [106] = {.lex_state = 45},
  [107] = {.lex_state = 45},
  [108] = {.lex_state = 45},
  [109] = {.lex_state = 45},
  [110] = {.lex_state = 45},
  [111] = {.lex_state = 45},
  [112] = {.lex_state = 45},
  [113] = {.lex_state = 45},
  [114] = {.lex_state = 45},
  [115] = {.lex_state = 45},
  [116] = {.lex_state = 45},
  [117] = {.lex_state = 45},
  [118] = {.lex_state = 45},
  [119] = {.lex_state = 45},
  [120] = {.lex_state = 45},
  [121] = {.lex_state = 45},
  [122] = {.lex_state = 45},
  [123] = {.lex_state = 45},
  [124] = {.lex_state = 45},
  [125] = {.lex_state = 45},
  [126] = {.lex_state = 45},
  [127] = {.lex_state = 45},
  [128] = {.lex_state = 45},
  [129] = {.lex_state = 45},
  [130] = {.lex_state = 45},
  [131] = {.lex_state = 45},
  [132] = {.lex_state = 45},
  [133] = {.lex_state = 45},
  [134] = {.lex_state = 45},
  [135] = {.lex_state = 45},
  [136] = {.lex_state = 45},
  [137] = {.lex_state = 45},
  [138] = {.lex_state = 45},
  [139] = {.lex_state = 45},
  [140] = {.lex_state = 45},
  [141] = {.lex_state = 45},
  [142] = {.lex_state = 45},
  [143] = {.lex_state = 45},
  [144] = {.lex_state = 45},
  [145] = {.lex_state = 45},
  [146] = {.lex_state = 45},
  [147] = {.lex_state = 45},
  [148] = {.lex_state = 45},
  [149] = {.lex_state = 45},
  [150] = {.lex_state = 45},
  [151] = {.lex_state = 45},
  [152] = {.lex_state = 45},
  [153] = {.lex_state = 45},
  [154] = {.lex_state = 45},
  [155] = {.lex_state = 45},
  [156] = {.lex_state = 45},
  [157] = {.lex_state = 45},
  [158] = {.lex_state = 45},
  [159] = {.lex_state = 45},
  [160] = {.lex_state = 45},
  [161] = {.lex_state = 45},
  [162] = {.lex_state = 45},
  [163] = {.lex_state = 45},
  [164] = {.lex_state = 45},
  [165] = {.lex_state = 45},
  [166] = {.lex_state = 45},
  [167] = {.lex_state = 45},
  [168] = {.lex_state = 45},
  [169] = {.lex_state = 45},
  [170] = {.lex_state = 45},
  [171] = {.lex_state = 45},
  [172] = {.lex_state = 45},
  [173] = {.lex_state = 45},
  [174] = {.lex_state = 45},
  [175] = {.lex_state = 45},
  [176] = {.lex_state = 45},
  [177] = {.lex_state = 45},
  [178] = {.lex_state = 45},
  [179] = {.lex_state = 45},
  [180] = {.lex_state = 45},
  [181] = {.lex_state = 45},
  [182] = {.lex_state = 45},
  [183] = {.lex_state = 45},
  [184] = {.lex_state = 45},
  [185] = {.lex_state = 45},
  [186] = {.lex_state = 45},
  [187] = {.lex_state = 45},
  [188] = {.lex_state = 45},
  [189] = {.lex_state = 45},
  [190] = {.lex_state = 45},
  [191] = {.lex_state = 45},
  [192] = {.lex_state = 45},
  [193] = {.lex_state = 45},
  [194] = {.lex_state = 45},
  [195] = {.lex_state = 45},
  [196] = {.lex_state = 45},
  [197] = {.lex_state = 45},
  [198] = {.lex_state = 45},
  [199] = {.lex_state = 45},
  [200] = {.lex_state = 45},
  [201] = {.lex_state = 45},
  [202] = {.lex_state = 45},
  [203] = {.lex_state = 45},
  [204] = {.lex_state = 45},
  [205] = {.lex_state = 45},
  [206] = {.lex_state = 45},
  [207] = {.lex_state = 45},
  [208] = {.lex_state = 45},
  [209] = {.lex_state = 45},
  [210] = {.lex_state = 45},
  [211] = {.lex_state = 45},
  [212] = {.lex_state = 45},
  [213] = {.lex_state = 45},
  [214] = {.lex_state = 45},
  [215] = {.lex_state = 45},
  [216] = {.lex_state = 45},
  [217] = {.lex_state = 45},
  [218] = {.lex_state = 45},
  [219] = {.lex_state = 45},
  [220] = {.lex_state = 45},
  [221] = {.lex_state = 45},
  [222] = {.lex_state = 45},
  [223] = {.lex_state = 45},
  [224] = {.lex_state = 45},
  [225] = {.lex_state = 0},
  [226] = {.lex_state = 45},
  [227] = {.lex_state = 45},
  [228] = {.lex_state = 45},
  [229] = {.lex_state = 45},
  [230] = {.lex_state = 45},
  [231] = {.lex_state = 45},
  [232] = {.lex_state = 45},
  [233] = {.lex_state = 45},
  [234] = {.lex_state = 45},
  [235] = {.lex_state = 45},
  [236] = {.lex_state = 45},
  [237] = {.lex_state = 45},
  [238] = {.lex_state = 45},
  [239] = {.lex_state = 45},
  [240] = {.lex_state = 45},
  [241] = {.lex_state = 45},
  [242] = {.lex_state = 45},
  [243] = {.lex_state = 45},
  [244] = {.lex_state = 45},
  [245] = {.lex_state = 45},
  [246] = {.lex_state = 45},
  [247] = {.lex_state = 45},
  [248] = {.lex_state = 45},
  [249] = {.lex_state = 45},
  [250] = {.lex_state = 45},
  [251] = {.lex_state = 45},
  [252] = {.lex_state = 45},
  [253] = {.lex_state = 45},
  [254] = {.lex_state = 45},
  [255] = {.lex_state = 45},
  [256] = {.lex_state = 45},
  [257] = {.lex_state = 45},
  [258] = {.lex_state = 45},
  [259] = {.lex_state = 45},
  [260] = {.lex_state = 45},
  [261] = {.lex_state = 45},
  [262] = {.lex_state = 45},
  [263] = {.lex_state = 45},
  [264] = {.lex_state = 45},
  [265] = {.lex_state = 45},
  [266] = {.lex_state = 45},
  [267] = {.lex_state = 45},
  [268] = {.lex_state = 45},
  [269] = {.lex_state = 45},
  [270] = {.lex_state = 45},
  [271] = {.lex_state = 45},
  [272] = {.lex_state = 45},
  [273] = {.lex_state = 45},
  [274] = {.lex_state = 45},
  [275] = {.lex_state = 45},
  [276] = {.lex_state = 45},
  [277] = {.lex_state = 45},
  [278] = {.lex_state = 45},
  [279] = {.lex_state = 45},
  [280] = {.lex_state = 45},
  [281] = {.lex_state = 45},
  [282] = {.lex_state = 45},
  [283] = {.lex_state = 45},
  [284] = {.lex_state = 45},
  [285] = {.lex_state = 45},
  [286] = {.lex_state = 45},
  [287] = {.lex_state = 45},
  [288] = {.lex_state = 45},
  [289] = {.lex_state = 45},
  [290] = {.lex_state = 45},
  [291] = {.lex_state = 45},
  [292] = {.lex_state = 45},
  [293] = {.lex_state = 45},
  [294] = {.lex_state = 45},
  [295] = {.lex_state = 45},
  [296] = {.lex_state = 45},
  [297] = {.lex_state = 45},
  [298] = {.lex_state = 45},
  [299] = {.lex_state = 45},
  [300] = {.lex_state = 45},
  [301] = {.lex_state = 45},
  [302] = {.lex_state = 45},
  [303] = {.lex_state = 45},
  [304] = {.lex_state = 45},
  [305] = {.lex_state = 45},
  [306] = {.lex_state = 45},
  [307] = {.lex_state = 45},
  [308] = {.lex_state = 45},
  [309] = {.lex_state = 45},
  [310] = {.lex_state = 45},
  [311] = {.lex_state = 45},
  [312] = {.lex_state = 45},
  [313] = {.lex_state = 45},
  [314] = {.lex_state = 45},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 4},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 1},
  [319] = {.lex_state = 4},
  [320] = {.lex_state = 1},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 1},
  [323] = {.lex_state = 1},
  [324] = {.lex_state = 4},
  [325] = {.lex_state = 4},
  [326] = {.lex_state = 1},
  [327] = {.lex_state = 1},
  [328] = {.lex_state = 1},
  [329] = {.lex_state = 4},
  [330] = {.lex_state = 1},
  [331] = {.lex_state = 1},
  [332] = {.lex_state = 4},
  [333] = {.lex_state = 1},
  [334] = {.lex_state = 1},
  [335] = {.lex_state = 1},
  [336] = {.lex_state = 1},
  [337] = {.lex_state = 1},
  [338] = {.lex_state = 1},
  [339] = {.lex_state = 1},
  [340] = {.lex_state = 1},
  [341] = {.lex_state = 1},
  [342] = {.lex_state = 1},
  [343] = {.lex_state = 1},
  [344] = {.lex_state = 1},
  [345] = {.lex_state = 1},
  [346] = {.lex_state = 1},
  [347] = {.lex_state = 1},
  [348] = {.lex_state = 1},
  [349] = {.lex_state = 1},
  [350] = {.lex_state = 1},
  [351] = {.lex_state = 1},
  [352] = {.lex_state = 1},
  [353] = {.lex_state = 1},
  [354] = {.lex_state = 1},
  [355] = {.lex_state = 1},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 1},
  [358] = {.lex_state = 1},
  [359] = {.lex_state = 1},
  [360] = {.lex_state = 1},
  [361] = {.lex_state = 1},
  [362] = {.lex_state = 1},
  [363] = {.lex_state = 1},
  [364] = {.lex_state = 1},
  [365] = {.lex_state = 1},
  [366] = {.lex_state = 1},
  [367] = {.lex_state = 1},
  [368] = {.lex_state = 1},
  [369] = {.lex_state = 1},
  [370] = {.lex_state = 1},
  [371] = {.lex_state = 1},
  [372] = {.lex_state = 1},
  [373] = {.lex_state = 1},
  [374] = {.lex_state = 1},
  [375] = {.lex_state = 1},
  [376] = {.lex_state = 1},
  [377] = {.lex_state = 1},
  [378] = {.lex_state = 1},
  [379] = {.lex_state = 1},
  [380] = {.lex_state = 1},
  [381] = {.lex_state = 1},
  [382] = {.lex_state = 1},
  [383] = {.lex_state = 1},
  [384] = {.lex_state = 1},
  [385] = {.lex_state = 1},
  [386] = {.lex_state = 1},
  [387] = {.lex_state = 1},
  [388] = {.lex_state = 1},
  [389] = {.lex_state = 1},
  [390] = {.lex_state = 1},
  [391] = {.lex_state = 1},
  [392] = {.lex_state = 1},
  [393] = {.lex_state = 1},
  [394] = {.lex_state = 1},
  [395] = {.lex_state = 1},
  [396] = {.lex_state = 1},
  [397] = {.lex_state = 1},
  [398] = {.lex_state = 1},
  [399] = {.lex_state = 1},
  [400] = {.lex_state = 1},
  [401] = {.lex_state = 1},
  [402] = {.lex_state = 1},
  [403] = {.lex_state = 1},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 1},
  [406] = {.lex_state = 1},
  [407] = {.lex_state = 1},
  [408] = {.lex_state = 1},
  [409] = {.lex_state = 1},
  [410] = {.lex_state = 1},
  [411] = {.lex_state = 1},
  [412] = {.lex_state = 1},
  [413] = {.lex_state = 1},
  [414] = {.lex_state = 1},
  [415] = {.lex_state = 1},
  [416] = {.lex_state = 1},
  [417] = {.lex_state = 1},
  [418] = {.lex_state = 1},
  [419] = {.lex_state = 1},
  [420] = {.lex_state = 1},
  [421] = {.lex_state = 1},
  [422] = {.lex_state = 1},
  [423] = {.lex_state = 1},
  [424] = {.lex_state = 1},
  [425] = {.lex_state = 1},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 1},
  [428] = {.lex_state = 1},
  [429] = {.lex_state = 1},
  [430] = {.lex_state = 1},
  [431] = {.lex_state = 1},
  [432] = {.lex_state = 1},
  [433] = {.lex_state = 1},
  [434] = {.lex_state = 1},
  [435] = {.lex_state = 1},
  [436] = {.lex_state = 1},
  [437] = {.lex_state = 5},
  [438] = {.lex_state = 4},
  [439] = {.lex_state = 1},
  [440] = {.lex_state = 1},
  [441] = {.lex_state = 1},
  [442] = {.lex_state = 1},
  [443] = {.lex_state = 1},
  [444] = {.lex_state = 1},
  [445] = {.lex_state = 1},
  [446] = {.lex_state = 1},
  [447] = {.lex_state = 1},
  [448] = {.lex_state = 1},
  [449] = {.lex_state = 1},
  [450] = {.lex_state = 1},
  [451] = {.lex_state = 4},
  [452] = {.lex_state = 1},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 1},
  [455] = {.lex_state = 1},
  [456] = {.lex_state = 1},
  [457] = {.lex_state = 1},
  [458] = {.lex_state = 1},
  [459] = {.lex_state = 1},
  [460] = {.lex_state = 1},
  [461] = {.lex_state = 1},
  [462] = {.lex_state = 1},
  [463] = {.lex_state = 1},
  [464] = {.lex_state = 1},
  [465] = {.lex_state = 1},
  [466] = {.lex_state = 1},
  [467] = {.lex_state = 1},
  [468] = {.lex_state = 1},
  [469] = {.lex_state = 1},
  [470] = {.lex_state = 1},
  [471] = {.lex_state = 1},
  [472] = {.lex_state = 1},
  [473] = {.lex_state = 2},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 1},
  [476] = {.lex_state = 1},
  [477] = {.lex_state = 1},
  [478] = {.lex_state = 1},
  [479] = {.lex_state = 6},
  [480] = {.lex_state = 1},
  [481] = {.lex_state = 1},
  [482] = {.lex_state = 1},
  [483] = {.lex_state = 1},
  [484] = {.lex_state = 1},
  [485] = {.lex_state = 1},
  [486] = {.lex_state = 45},
  [487] = {.lex_state = 45},
  [488] = {.lex_state = 45},
  [489] = {.lex_state = 45},
  [490] = {.lex_state = 7},
  [491] = {.lex_state = 45},
  [492] = {.lex_state = 45},
  [493] = {.lex_state = 45},
  [494] = {.lex_state = 45},
  [495] = {.lex_state = 45},
  [496] = {.lex_state = 1},
  [497] = {.lex_state = 45},
  [498] = {.lex_state = 45},
  [499] = {.lex_state = 45},
  [500] = {.lex_state = 1},
  [501] = {.lex_state = 45},
  [502] = {.lex_state = 8},
  [503] = {.lex_state = 9},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 10},
  [522] = {.lex_state = 10},
  [523] = {.lex_state = 10},
  [524] = {.lex_state = 10},
  [525] = {.lex_state = 10},
  [526] = {.lex_state = 10},
  [527] = {.lex_state = 42},
  [528] = {.lex_state = 42},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 41},
  [531] = {.lex_state = 42},
  [532] = {.lex_state = 41},
  [533] = {.lex_state = 42},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__ws] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
    [anon_sym_POUND_] = ACTIONS(1),
    [sym_num_lit] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [aux_sym__kwd_leading_slash_token1] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [aux_sym_str_lit_token1] = ACTIONS(1),
    [sym_char_lit] = ACTIONS(1),
    [sym_nil_lit] = ACTIONS(1),
    [sym_bool_lit] = ACTIONS(1),
    [aux_sym__sym_qualified_token1] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_POUND_CARET] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_POUND_QMARK] = ACTIONS(1),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1),
    [anon_sym_POUND_POUND] = ACTIONS(1),
    [anon_sym_POUND_EQ] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_TILDE_AT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
  },
  [1] = {
    [sym_source] = STATE(529),
    [sym__gap] = STATE(19),
    [sym_dis_expr] = STATE(19),
    [sym__form] = STATE(19),
    [sym_kwd_lit] = STATE(19),
    [sym_str_lit] = STATE(19),
    [sym_sym_lit] = STATE(19),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(19),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(19),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(19),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(19),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(19),
    [sym_regex_lit] = STATE(19),
    [sym_read_cond_lit] = STATE(19),
    [sym_splicing_read_cond_lit] = STATE(19),
    [sym_ns_map_lit] = STATE(19),
    [sym_var_quoting_lit] = STATE(19),
    [sym_sym_val_lit] = STATE(19),
    [sym_evaling_lit] = STATE(19),
    [sym_tagged_or_ctor_lit] = STATE(19),
    [sym_derefing_lit] = STATE(19),
    [sym_quoting_lit] = STATE(19),
    [sym_syn_quoting_lit] = STATE(19),
    [sym_unquote_splicing_lit] = STATE(19),
    [sym_unquoting_lit] = STATE(19),
    [aux_sym_source_repeat1] = STATE(19),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [ts_builtin_sym_end] = ACTIONS(3),
    [sym__ws] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(5),
    [sym_nil_lit] = ACTIONS(17),
    [sym_bool_lit] = ACTIONS(17),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [2] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(53),
    [sym_comment] = ACTIONS(53),
    [anon_sym_POUND_] = ACTIONS(56),
    [sym_num_lit] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(62),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_COLON_COLON] = ACTIONS(68),
    [aux_sym_str_lit_token1] = ACTIONS(71),
    [sym_char_lit] = ACTIONS(59),
    [sym_nil_lit] = ACTIONS(74),
    [sym_bool_lit] = ACTIONS(74),
    [aux_sym__sym_qualified_token1] = ACTIONS(77),
    [anon_sym_CARET] = ACTIONS(80),
    [anon_sym_POUND_CARET] = ACTIONS(83),
    [anon_sym_LPAREN] = ACTIONS(86),
    [anon_sym_RPAREN] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_RBRACE] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(94),
    [anon_sym_RBRACK] = ACTIONS(89),
    [anon_sym_POUND] = ACTIONS(97),
    [anon_sym_POUND_QMARK] = ACTIONS(100),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(103),
    [anon_sym_POUND_SQUOTE] = ACTIONS(106),
    [anon_sym_POUND_POUND] = ACTIONS(109),
    [anon_sym_POUND_EQ] = ACTIONS(112),
    [anon_sym_AT] = ACTIONS(115),
    [anon_sym_SQUOTE] = ACTIONS(118),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_TILDE_AT] = ACTIONS(124),
    [anon_sym_TILDE] = ACTIONS(127),
  },
  [3] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(136),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [4] = {
    [sym__gap] = STATE(7),
    [sym_dis_expr] = STATE(7),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(7),
    [sym__ws] = ACTIONS(138),
    [sym_comment] = ACTIONS(138),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_RBRACK] = ACTIONS(140),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [5] = {
    [sym__gap] = STATE(5),
    [sym_dis_expr] = STATE(5),
    [sym__form] = STATE(5),
    [sym_kwd_lit] = STATE(5),
    [sym_str_lit] = STATE(5),
    [sym_sym_lit] = STATE(5),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(5),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(5),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(5),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(5),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(5),
    [sym_regex_lit] = STATE(5),
    [sym_read_cond_lit] = STATE(5),
    [sym_splicing_read_cond_lit] = STATE(5),
    [sym_ns_map_lit] = STATE(5),
    [sym_var_quoting_lit] = STATE(5),
    [sym_sym_val_lit] = STATE(5),
    [sym_evaling_lit] = STATE(5),
    [sym_tagged_or_ctor_lit] = STATE(5),
    [sym_derefing_lit] = STATE(5),
    [sym_quoting_lit] = STATE(5),
    [sym_syn_quoting_lit] = STATE(5),
    [sym_unquote_splicing_lit] = STATE(5),
    [sym_unquoting_lit] = STATE(5),
    [aux_sym_source_repeat1] = STATE(5),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [ts_builtin_sym_end] = ACTIONS(142),
    [sym__ws] = ACTIONS(144),
    [sym_comment] = ACTIONS(144),
    [anon_sym_POUND_] = ACTIONS(147),
    [sym_num_lit] = ACTIONS(144),
    [anon_sym_SLASH] = ACTIONS(150),
    [anon_sym_COLON] = ACTIONS(153),
    [anon_sym_COLON_COLON] = ACTIONS(156),
    [aux_sym_str_lit_token1] = ACTIONS(159),
    [sym_char_lit] = ACTIONS(144),
    [sym_nil_lit] = ACTIONS(162),
    [sym_bool_lit] = ACTIONS(162),
    [aux_sym__sym_qualified_token1] = ACTIONS(165),
    [anon_sym_CARET] = ACTIONS(168),
    [anon_sym_POUND_CARET] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_LBRACK] = ACTIONS(180),
    [anon_sym_POUND] = ACTIONS(183),
    [anon_sym_POUND_QMARK] = ACTIONS(186),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(189),
    [anon_sym_POUND_SQUOTE] = ACTIONS(192),
    [anon_sym_POUND_POUND] = ACTIONS(195),
    [anon_sym_POUND_EQ] = ACTIONS(198),
    [anon_sym_AT] = ACTIONS(201),
    [anon_sym_SQUOTE] = ACTIONS(204),
    [anon_sym_BQUOTE] = ACTIONS(207),
    [anon_sym_TILDE_AT] = ACTIONS(210),
    [anon_sym_TILDE] = ACTIONS(213),
  },
  [6] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(216),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [7] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_RBRACK] = ACTIONS(218),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [8] = {
    [sym__gap] = STATE(12),
    [sym_dis_expr] = STATE(12),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(12),
    [sym__ws] = ACTIONS(220),
    [sym_comment] = ACTIONS(220),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [9] = {
    [sym__gap] = STATE(17),
    [sym_dis_expr] = STATE(17),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(17),
    [sym__ws] = ACTIONS(224),
    [sym_comment] = ACTIONS(224),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(226),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [10] = {
    [sym__gap] = STATE(20),
    [sym_dis_expr] = STATE(20),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(20),
    [sym__ws] = ACTIONS(228),
    [sym_comment] = ACTIONS(228),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(230),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [11] = {
    [sym__gap] = STATE(16),
    [sym_dis_expr] = STATE(16),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(16),
    [sym__ws] = ACTIONS(232),
    [sym_comment] = ACTIONS(232),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_RBRACK] = ACTIONS(234),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [12] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(236),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [13] = {
    [sym__gap] = STATE(3),
    [sym_dis_expr] = STATE(3),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(3),
    [sym__ws] = ACTIONS(238),
    [sym_comment] = ACTIONS(238),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(240),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [14] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(242),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [15] = {
    [sym__gap] = STATE(6),
    [sym_dis_expr] = STATE(6),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(6),
    [sym__ws] = ACTIONS(244),
    [sym_comment] = ACTIONS(244),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(246),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [16] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_RBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [17] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(250),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [18] = {
    [sym__gap] = STATE(14),
    [sym_dis_expr] = STATE(14),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(14),
    [sym__ws] = ACTIONS(252),
    [sym_comment] = ACTIONS(252),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(254),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [19] = {
    [sym__gap] = STATE(5),
    [sym_dis_expr] = STATE(5),
    [sym__form] = STATE(5),
    [sym_kwd_lit] = STATE(5),
    [sym_str_lit] = STATE(5),
    [sym_sym_lit] = STATE(5),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(5),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(5),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(5),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(5),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(5),
    [sym_regex_lit] = STATE(5),
    [sym_read_cond_lit] = STATE(5),
    [sym_splicing_read_cond_lit] = STATE(5),
    [sym_ns_map_lit] = STATE(5),
    [sym_var_quoting_lit] = STATE(5),
    [sym_sym_val_lit] = STATE(5),
    [sym_evaling_lit] = STATE(5),
    [sym_tagged_or_ctor_lit] = STATE(5),
    [sym_derefing_lit] = STATE(5),
    [sym_quoting_lit] = STATE(5),
    [sym_syn_quoting_lit] = STATE(5),
    [sym_unquote_splicing_lit] = STATE(5),
    [sym_unquoting_lit] = STATE(5),
    [aux_sym_source_repeat1] = STATE(5),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [ts_builtin_sym_end] = ACTIONS(256),
    [sym__ws] = ACTIONS(258),
    [sym_comment] = ACTIONS(258),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(258),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(258),
    [sym_nil_lit] = ACTIONS(260),
    [sym_bool_lit] = ACTIONS(260),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [20] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(313),
    [sym_kwd_lit] = STATE(313),
    [sym_str_lit] = STATE(313),
    [sym_sym_lit] = STATE(313),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(313),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(313),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(313),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(313),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(313),
    [sym_regex_lit] = STATE(313),
    [sym_read_cond_lit] = STATE(313),
    [sym_splicing_read_cond_lit] = STATE(313),
    [sym_ns_map_lit] = STATE(313),
    [sym_var_quoting_lit] = STATE(313),
    [sym_sym_val_lit] = STATE(313),
    [sym_evaling_lit] = STATE(313),
    [sym_tagged_or_ctor_lit] = STATE(313),
    [sym_derefing_lit] = STATE(313),
    [sym_quoting_lit] = STATE(313),
    [sym_syn_quoting_lit] = STATE(313),
    [sym_unquote_splicing_lit] = STATE(313),
    [sym_unquoting_lit] = STATE(313),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(262),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [21] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(398),
    [sym_kwd_lit] = STATE(398),
    [sym_str_lit] = STATE(398),
    [sym_sym_lit] = STATE(398),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(398),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(398),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(398),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(398),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(398),
    [sym_regex_lit] = STATE(398),
    [sym_read_cond_lit] = STATE(398),
    [sym_splicing_read_cond_lit] = STATE(398),
    [sym_ns_map_lit] = STATE(398),
    [sym_var_quoting_lit] = STATE(398),
    [sym_sym_val_lit] = STATE(398),
    [sym_evaling_lit] = STATE(398),
    [sym_tagged_or_ctor_lit] = STATE(398),
    [sym_derefing_lit] = STATE(398),
    [sym_quoting_lit] = STATE(398),
    [sym_syn_quoting_lit] = STATE(398),
    [sym_unquote_splicing_lit] = STATE(398),
    [sym_unquoting_lit] = STATE(398),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(266),
    [sym_nil_lit] = ACTIONS(276),
    [sym_bool_lit] = ACTIONS(276),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [22] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(389),
    [sym_kwd_lit] = STATE(389),
    [sym_str_lit] = STATE(389),
    [sym_sym_lit] = STATE(389),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(389),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(389),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(389),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(389),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(389),
    [sym_regex_lit] = STATE(389),
    [sym_read_cond_lit] = STATE(389),
    [sym_splicing_read_cond_lit] = STATE(389),
    [sym_ns_map_lit] = STATE(389),
    [sym_var_quoting_lit] = STATE(389),
    [sym_sym_val_lit] = STATE(389),
    [sym_evaling_lit] = STATE(389),
    [sym_tagged_or_ctor_lit] = STATE(389),
    [sym_derefing_lit] = STATE(389),
    [sym_quoting_lit] = STATE(389),
    [sym_syn_quoting_lit] = STATE(389),
    [sym_unquote_splicing_lit] = STATE(389),
    [sym_unquoting_lit] = STATE(389),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(308),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(308),
    [sym_nil_lit] = ACTIONS(314),
    [sym_bool_lit] = ACTIONS(314),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [23] = {
    [sym__gap] = STATE(70),
    [sym_dis_expr] = STATE(70),
    [sym__form] = STATE(348),
    [sym_kwd_lit] = STATE(348),
    [sym_str_lit] = STATE(348),
    [sym_sym_lit] = STATE(348),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(348),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(348),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(348),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(348),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(348),
    [sym_regex_lit] = STATE(348),
    [sym_read_cond_lit] = STATE(348),
    [sym_splicing_read_cond_lit] = STATE(348),
    [sym_ns_map_lit] = STATE(348),
    [sym_var_quoting_lit] = STATE(348),
    [sym_sym_val_lit] = STATE(348),
    [sym_evaling_lit] = STATE(348),
    [sym_tagged_or_ctor_lit] = STATE(348),
    [sym_derefing_lit] = STATE(348),
    [sym_quoting_lit] = STATE(348),
    [sym_syn_quoting_lit] = STATE(348),
    [sym_unquote_splicing_lit] = STATE(348),
    [sym_unquoting_lit] = STATE(348),
    [aux_sym_dis_expr_repeat1] = STATE(70),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(330),
    [sym_comment] = ACTIONS(330),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(332),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(332),
    [sym_nil_lit] = ACTIONS(334),
    [sym_bool_lit] = ACTIONS(334),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [24] = {
    [sym__gap] = STATE(71),
    [sym_dis_expr] = STATE(71),
    [sym__form] = STATE(246),
    [sym_kwd_lit] = STATE(246),
    [sym_str_lit] = STATE(246),
    [sym_sym_lit] = STATE(246),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(246),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(246),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(246),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(246),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(246),
    [sym_regex_lit] = STATE(246),
    [sym_read_cond_lit] = STATE(246),
    [sym_splicing_read_cond_lit] = STATE(246),
    [sym_ns_map_lit] = STATE(246),
    [sym_var_quoting_lit] = STATE(246),
    [sym_sym_val_lit] = STATE(246),
    [sym_evaling_lit] = STATE(246),
    [sym_tagged_or_ctor_lit] = STATE(246),
    [sym_derefing_lit] = STATE(246),
    [sym_quoting_lit] = STATE(246),
    [sym_syn_quoting_lit] = STATE(246),
    [sym_unquote_splicing_lit] = STATE(246),
    [sym_unquoting_lit] = STATE(246),
    [aux_sym_dis_expr_repeat1] = STATE(71),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(336),
    [sym_comment] = ACTIONS(336),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(338),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(338),
    [sym_nil_lit] = ACTIONS(340),
    [sym_bool_lit] = ACTIONS(340),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [25] = {
    [sym__gap] = STATE(73),
    [sym_dis_expr] = STATE(73),
    [sym__form] = STATE(247),
    [sym_kwd_lit] = STATE(247),
    [sym_str_lit] = STATE(247),
    [sym_sym_lit] = STATE(247),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(247),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(247),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(247),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(247),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(247),
    [sym_regex_lit] = STATE(247),
    [sym_read_cond_lit] = STATE(247),
    [sym_splicing_read_cond_lit] = STATE(247),
    [sym_ns_map_lit] = STATE(247),
    [sym_var_quoting_lit] = STATE(247),
    [sym_sym_val_lit] = STATE(247),
    [sym_evaling_lit] = STATE(247),
    [sym_tagged_or_ctor_lit] = STATE(247),
    [sym_derefing_lit] = STATE(247),
    [sym_quoting_lit] = STATE(247),
    [sym_syn_quoting_lit] = STATE(247),
    [sym_unquote_splicing_lit] = STATE(247),
    [sym_unquoting_lit] = STATE(247),
    [aux_sym_dis_expr_repeat1] = STATE(73),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(342),
    [sym_comment] = ACTIONS(342),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(344),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(344),
    [sym_nil_lit] = ACTIONS(346),
    [sym_bool_lit] = ACTIONS(346),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [26] = {
    [sym__gap] = STATE(75),
    [sym_dis_expr] = STATE(75),
    [sym__form] = STATE(248),
    [sym_kwd_lit] = STATE(248),
    [sym_str_lit] = STATE(248),
    [sym_sym_lit] = STATE(248),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(248),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(248),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(248),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(248),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(248),
    [sym_regex_lit] = STATE(248),
    [sym_read_cond_lit] = STATE(248),
    [sym_splicing_read_cond_lit] = STATE(248),
    [sym_ns_map_lit] = STATE(248),
    [sym_var_quoting_lit] = STATE(248),
    [sym_sym_val_lit] = STATE(248),
    [sym_evaling_lit] = STATE(248),
    [sym_tagged_or_ctor_lit] = STATE(248),
    [sym_derefing_lit] = STATE(248),
    [sym_quoting_lit] = STATE(248),
    [sym_syn_quoting_lit] = STATE(248),
    [sym_unquote_splicing_lit] = STATE(248),
    [sym_unquoting_lit] = STATE(248),
    [aux_sym_dis_expr_repeat1] = STATE(75),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(348),
    [sym_comment] = ACTIONS(348),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(350),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(350),
    [sym_nil_lit] = ACTIONS(352),
    [sym_bool_lit] = ACTIONS(352),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [27] = {
    [sym__gap] = STATE(77),
    [sym_dis_expr] = STATE(77),
    [sym__form] = STATE(249),
    [sym_kwd_lit] = STATE(249),
    [sym_str_lit] = STATE(249),
    [sym_sym_lit] = STATE(249),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(249),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(249),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(249),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(249),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(249),
    [sym_regex_lit] = STATE(249),
    [sym_read_cond_lit] = STATE(249),
    [sym_splicing_read_cond_lit] = STATE(249),
    [sym_ns_map_lit] = STATE(249),
    [sym_var_quoting_lit] = STATE(249),
    [sym_sym_val_lit] = STATE(249),
    [sym_evaling_lit] = STATE(249),
    [sym_tagged_or_ctor_lit] = STATE(249),
    [sym_derefing_lit] = STATE(249),
    [sym_quoting_lit] = STATE(249),
    [sym_syn_quoting_lit] = STATE(249),
    [sym_unquote_splicing_lit] = STATE(249),
    [sym_unquoting_lit] = STATE(249),
    [aux_sym_dis_expr_repeat1] = STATE(77),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(354),
    [sym_comment] = ACTIONS(354),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(356),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(356),
    [sym_nil_lit] = ACTIONS(358),
    [sym_bool_lit] = ACTIONS(358),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [28] = {
    [sym__gap] = STATE(79),
    [sym_dis_expr] = STATE(79),
    [sym__form] = STATE(250),
    [sym_kwd_lit] = STATE(250),
    [sym_str_lit] = STATE(250),
    [sym_sym_lit] = STATE(250),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(250),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(250),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(250),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(250),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(250),
    [sym_regex_lit] = STATE(250),
    [sym_read_cond_lit] = STATE(250),
    [sym_splicing_read_cond_lit] = STATE(250),
    [sym_ns_map_lit] = STATE(250),
    [sym_var_quoting_lit] = STATE(250),
    [sym_sym_val_lit] = STATE(250),
    [sym_evaling_lit] = STATE(250),
    [sym_tagged_or_ctor_lit] = STATE(250),
    [sym_derefing_lit] = STATE(250),
    [sym_quoting_lit] = STATE(250),
    [sym_syn_quoting_lit] = STATE(250),
    [sym_unquote_splicing_lit] = STATE(250),
    [sym_unquoting_lit] = STATE(250),
    [aux_sym_dis_expr_repeat1] = STATE(79),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(360),
    [sym_comment] = ACTIONS(360),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(362),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(362),
    [sym_nil_lit] = ACTIONS(364),
    [sym_bool_lit] = ACTIONS(364),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [29] = {
    [sym__gap] = STATE(191),
    [sym_dis_expr] = STATE(191),
    [sym__form] = STATE(348),
    [sym_kwd_lit] = STATE(348),
    [sym_str_lit] = STATE(348),
    [sym_sym_lit] = STATE(348),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(348),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(348),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(348),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(348),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(348),
    [sym_regex_lit] = STATE(348),
    [sym_read_cond_lit] = STATE(348),
    [sym_splicing_read_cond_lit] = STATE(348),
    [sym_ns_map_lit] = STATE(348),
    [sym_var_quoting_lit] = STATE(348),
    [sym_sym_val_lit] = STATE(348),
    [sym_evaling_lit] = STATE(348),
    [sym_tagged_or_ctor_lit] = STATE(348),
    [sym_derefing_lit] = STATE(348),
    [sym_quoting_lit] = STATE(348),
    [sym_syn_quoting_lit] = STATE(348),
    [sym_unquote_splicing_lit] = STATE(348),
    [sym_unquoting_lit] = STATE(348),
    [aux_sym_dis_expr_repeat1] = STATE(191),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(366),
    [sym_comment] = ACTIONS(366),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(332),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(332),
    [sym_nil_lit] = ACTIONS(334),
    [sym_bool_lit] = ACTIONS(334),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [30] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(393),
    [sym_kwd_lit] = STATE(393),
    [sym_str_lit] = STATE(393),
    [sym_sym_lit] = STATE(393),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(393),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(393),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(393),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(393),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(393),
    [sym_regex_lit] = STATE(393),
    [sym_read_cond_lit] = STATE(393),
    [sym_splicing_read_cond_lit] = STATE(393),
    [sym_ns_map_lit] = STATE(393),
    [sym_var_quoting_lit] = STATE(393),
    [sym_sym_val_lit] = STATE(393),
    [sym_evaling_lit] = STATE(393),
    [sym_tagged_or_ctor_lit] = STATE(393),
    [sym_derefing_lit] = STATE(393),
    [sym_quoting_lit] = STATE(393),
    [sym_syn_quoting_lit] = STATE(393),
    [sym_unquote_splicing_lit] = STATE(393),
    [sym_unquoting_lit] = STATE(393),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(368),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(368),
    [sym_nil_lit] = ACTIONS(370),
    [sym_bool_lit] = ACTIONS(370),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [31] = {
    [sym__gap] = STATE(30),
    [sym_dis_expr] = STATE(30),
    [sym__form] = STATE(421),
    [sym_kwd_lit] = STATE(421),
    [sym_str_lit] = STATE(421),
    [sym_sym_lit] = STATE(421),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(421),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(421),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(421),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(421),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(421),
    [sym_regex_lit] = STATE(421),
    [sym_read_cond_lit] = STATE(421),
    [sym_splicing_read_cond_lit] = STATE(421),
    [sym_ns_map_lit] = STATE(421),
    [sym_var_quoting_lit] = STATE(421),
    [sym_sym_val_lit] = STATE(421),
    [sym_evaling_lit] = STATE(421),
    [sym_tagged_or_ctor_lit] = STATE(421),
    [sym_derefing_lit] = STATE(421),
    [sym_quoting_lit] = STATE(421),
    [sym_syn_quoting_lit] = STATE(421),
    [sym_unquote_splicing_lit] = STATE(421),
    [sym_unquoting_lit] = STATE(421),
    [aux_sym_dis_expr_repeat1] = STATE(30),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(372),
    [sym_comment] = ACTIONS(372),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(374),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(374),
    [sym_nil_lit] = ACTIONS(376),
    [sym_bool_lit] = ACTIONS(376),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [32] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(427),
    [sym_kwd_lit] = STATE(427),
    [sym_str_lit] = STATE(427),
    [sym_sym_lit] = STATE(427),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(427),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(427),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(427),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(427),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(427),
    [sym_regex_lit] = STATE(427),
    [sym_read_cond_lit] = STATE(427),
    [sym_splicing_read_cond_lit] = STATE(427),
    [sym_ns_map_lit] = STATE(427),
    [sym_var_quoting_lit] = STATE(427),
    [sym_sym_val_lit] = STATE(427),
    [sym_evaling_lit] = STATE(427),
    [sym_tagged_or_ctor_lit] = STATE(427),
    [sym_derefing_lit] = STATE(427),
    [sym_quoting_lit] = STATE(427),
    [sym_syn_quoting_lit] = STATE(427),
    [sym_unquote_splicing_lit] = STATE(427),
    [sym_unquoting_lit] = STATE(427),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(378),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(378),
    [sym_nil_lit] = ACTIONS(380),
    [sym_bool_lit] = ACTIONS(380),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [33] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(399),
    [sym_kwd_lit] = STATE(399),
    [sym_str_lit] = STATE(399),
    [sym_sym_lit] = STATE(399),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(399),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(399),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(399),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(399),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(399),
    [sym_regex_lit] = STATE(399),
    [sym_read_cond_lit] = STATE(399),
    [sym_splicing_read_cond_lit] = STATE(399),
    [sym_ns_map_lit] = STATE(399),
    [sym_var_quoting_lit] = STATE(399),
    [sym_sym_val_lit] = STATE(399),
    [sym_evaling_lit] = STATE(399),
    [sym_tagged_or_ctor_lit] = STATE(399),
    [sym_derefing_lit] = STATE(399),
    [sym_quoting_lit] = STATE(399),
    [sym_syn_quoting_lit] = STATE(399),
    [sym_unquote_splicing_lit] = STATE(399),
    [sym_unquoting_lit] = STATE(399),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(382),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(382),
    [sym_nil_lit] = ACTIONS(384),
    [sym_bool_lit] = ACTIONS(384),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [34] = {
    [sym__gap] = STATE(103),
    [sym_dis_expr] = STATE(103),
    [sym__form] = STATE(295),
    [sym_kwd_lit] = STATE(295),
    [sym_str_lit] = STATE(295),
    [sym_sym_lit] = STATE(295),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(295),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(295),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(295),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(295),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(295),
    [sym_regex_lit] = STATE(295),
    [sym_read_cond_lit] = STATE(295),
    [sym_splicing_read_cond_lit] = STATE(295),
    [sym_ns_map_lit] = STATE(295),
    [sym_var_quoting_lit] = STATE(295),
    [sym_sym_val_lit] = STATE(295),
    [sym_evaling_lit] = STATE(295),
    [sym_tagged_or_ctor_lit] = STATE(295),
    [sym_derefing_lit] = STATE(295),
    [sym_quoting_lit] = STATE(295),
    [sym_syn_quoting_lit] = STATE(295),
    [sym_unquote_splicing_lit] = STATE(295),
    [sym_unquoting_lit] = STATE(295),
    [aux_sym_dis_expr_repeat1] = STATE(103),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(386),
    [sym_comment] = ACTIONS(386),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(388),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(388),
    [sym_nil_lit] = ACTIONS(394),
    [sym_bool_lit] = ACTIONS(394),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [35] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(397),
    [sym_kwd_lit] = STATE(397),
    [sym_str_lit] = STATE(397),
    [sym_sym_lit] = STATE(397),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(397),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(397),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(397),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(397),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(397),
    [sym_regex_lit] = STATE(397),
    [sym_read_cond_lit] = STATE(397),
    [sym_splicing_read_cond_lit] = STATE(397),
    [sym_ns_map_lit] = STATE(397),
    [sym_var_quoting_lit] = STATE(397),
    [sym_sym_val_lit] = STATE(397),
    [sym_evaling_lit] = STATE(397),
    [sym_tagged_or_ctor_lit] = STATE(397),
    [sym_derefing_lit] = STATE(397),
    [sym_quoting_lit] = STATE(397),
    [sym_syn_quoting_lit] = STATE(397),
    [sym_unquote_splicing_lit] = STATE(397),
    [sym_unquoting_lit] = STATE(397),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(410),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(410),
    [sym_nil_lit] = ACTIONS(412),
    [sym_bool_lit] = ACTIONS(412),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [36] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(386),
    [sym_kwd_lit] = STATE(386),
    [sym_str_lit] = STATE(386),
    [sym_sym_lit] = STATE(386),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(386),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(386),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(386),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(386),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(386),
    [sym_regex_lit] = STATE(386),
    [sym_read_cond_lit] = STATE(386),
    [sym_splicing_read_cond_lit] = STATE(386),
    [sym_ns_map_lit] = STATE(386),
    [sym_var_quoting_lit] = STATE(386),
    [sym_sym_val_lit] = STATE(386),
    [sym_evaling_lit] = STATE(386),
    [sym_tagged_or_ctor_lit] = STATE(386),
    [sym_derefing_lit] = STATE(386),
    [sym_quoting_lit] = STATE(386),
    [sym_syn_quoting_lit] = STATE(386),
    [sym_unquote_splicing_lit] = STATE(386),
    [sym_unquoting_lit] = STATE(386),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(414),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(414),
    [sym_nil_lit] = ACTIONS(420),
    [sym_bool_lit] = ACTIONS(420),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [37] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(380),
    [sym_kwd_lit] = STATE(380),
    [sym_str_lit] = STATE(380),
    [sym_sym_lit] = STATE(380),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(380),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(380),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(380),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(380),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(380),
    [sym_regex_lit] = STATE(380),
    [sym_read_cond_lit] = STATE(380),
    [sym_splicing_read_cond_lit] = STATE(380),
    [sym_ns_map_lit] = STATE(380),
    [sym_var_quoting_lit] = STATE(380),
    [sym_sym_val_lit] = STATE(380),
    [sym_evaling_lit] = STATE(380),
    [sym_tagged_or_ctor_lit] = STATE(380),
    [sym_derefing_lit] = STATE(380),
    [sym_quoting_lit] = STATE(380),
    [sym_syn_quoting_lit] = STATE(380),
    [sym_unquote_splicing_lit] = STATE(380),
    [sym_unquoting_lit] = STATE(380),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(436),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(436),
    [sym_nil_lit] = ACTIONS(438),
    [sym_bool_lit] = ACTIONS(438),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [38] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(357),
    [sym_kwd_lit] = STATE(357),
    [sym_str_lit] = STATE(357),
    [sym_sym_lit] = STATE(357),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(357),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(357),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(357),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(357),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(357),
    [sym_regex_lit] = STATE(357),
    [sym_read_cond_lit] = STATE(357),
    [sym_splicing_read_cond_lit] = STATE(357),
    [sym_ns_map_lit] = STATE(357),
    [sym_var_quoting_lit] = STATE(357),
    [sym_sym_val_lit] = STATE(357),
    [sym_evaling_lit] = STATE(357),
    [sym_tagged_or_ctor_lit] = STATE(357),
    [sym_derefing_lit] = STATE(357),
    [sym_quoting_lit] = STATE(357),
    [sym_syn_quoting_lit] = STATE(357),
    [sym_unquote_splicing_lit] = STATE(357),
    [sym_unquoting_lit] = STATE(357),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(440),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(440),
    [sym_nil_lit] = ACTIONS(442),
    [sym_bool_lit] = ACTIONS(442),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [39] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(257),
    [sym_kwd_lit] = STATE(257),
    [sym_str_lit] = STATE(257),
    [sym_sym_lit] = STATE(257),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(257),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(257),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(257),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(257),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(257),
    [sym_regex_lit] = STATE(257),
    [sym_read_cond_lit] = STATE(257),
    [sym_splicing_read_cond_lit] = STATE(257),
    [sym_ns_map_lit] = STATE(257),
    [sym_var_quoting_lit] = STATE(257),
    [sym_sym_val_lit] = STATE(257),
    [sym_evaling_lit] = STATE(257),
    [sym_tagged_or_ctor_lit] = STATE(257),
    [sym_derefing_lit] = STATE(257),
    [sym_quoting_lit] = STATE(257),
    [sym_syn_quoting_lit] = STATE(257),
    [sym_unquote_splicing_lit] = STATE(257),
    [sym_unquoting_lit] = STATE(257),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(444),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(444),
    [sym_nil_lit] = ACTIONS(446),
    [sym_bool_lit] = ACTIONS(446),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [40] = {
    [sym__gap] = STATE(204),
    [sym_dis_expr] = STATE(204),
    [sym__form] = STATE(363),
    [sym_kwd_lit] = STATE(363),
    [sym_str_lit] = STATE(363),
    [sym_sym_lit] = STATE(363),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(363),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(363),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(363),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(363),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(363),
    [sym_regex_lit] = STATE(363),
    [sym_read_cond_lit] = STATE(363),
    [sym_splicing_read_cond_lit] = STATE(363),
    [sym_ns_map_lit] = STATE(363),
    [sym_var_quoting_lit] = STATE(363),
    [sym_sym_val_lit] = STATE(363),
    [sym_evaling_lit] = STATE(363),
    [sym_tagged_or_ctor_lit] = STATE(363),
    [sym_derefing_lit] = STATE(363),
    [sym_quoting_lit] = STATE(363),
    [sym_syn_quoting_lit] = STATE(363),
    [sym_unquote_splicing_lit] = STATE(363),
    [sym_unquoting_lit] = STATE(363),
    [aux_sym_dis_expr_repeat1] = STATE(204),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(448),
    [sym_comment] = ACTIONS(448),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(450),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(450),
    [sym_nil_lit] = ACTIONS(456),
    [sym_bool_lit] = ACTIONS(456),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [41] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(343),
    [sym_kwd_lit] = STATE(343),
    [sym_str_lit] = STATE(343),
    [sym_sym_lit] = STATE(343),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(343),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(343),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(343),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(343),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(343),
    [sym_regex_lit] = STATE(343),
    [sym_read_cond_lit] = STATE(343),
    [sym_splicing_read_cond_lit] = STATE(343),
    [sym_ns_map_lit] = STATE(343),
    [sym_var_quoting_lit] = STATE(343),
    [sym_sym_val_lit] = STATE(343),
    [sym_evaling_lit] = STATE(343),
    [sym_tagged_or_ctor_lit] = STATE(343),
    [sym_derefing_lit] = STATE(343),
    [sym_quoting_lit] = STATE(343),
    [sym_syn_quoting_lit] = STATE(343),
    [sym_unquote_splicing_lit] = STATE(343),
    [sym_unquoting_lit] = STATE(343),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(472),
    [sym_nil_lit] = ACTIONS(474),
    [sym_bool_lit] = ACTIONS(474),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [42] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(393),
    [sym_kwd_lit] = STATE(393),
    [sym_str_lit] = STATE(393),
    [sym_sym_lit] = STATE(393),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(393),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(393),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(393),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(393),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(393),
    [sym_regex_lit] = STATE(393),
    [sym_read_cond_lit] = STATE(393),
    [sym_splicing_read_cond_lit] = STATE(393),
    [sym_ns_map_lit] = STATE(393),
    [sym_var_quoting_lit] = STATE(393),
    [sym_sym_val_lit] = STATE(393),
    [sym_evaling_lit] = STATE(393),
    [sym_tagged_or_ctor_lit] = STATE(393),
    [sym_derefing_lit] = STATE(393),
    [sym_quoting_lit] = STATE(393),
    [sym_syn_quoting_lit] = STATE(393),
    [sym_unquote_splicing_lit] = STATE(393),
    [sym_unquoting_lit] = STATE(393),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(368),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(368),
    [sym_nil_lit] = ACTIONS(370),
    [sym_bool_lit] = ACTIONS(370),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [43] = {
    [sym__gap] = STATE(32),
    [sym_dis_expr] = STATE(32),
    [sym__form] = STATE(349),
    [sym_kwd_lit] = STATE(349),
    [sym_str_lit] = STATE(349),
    [sym_sym_lit] = STATE(349),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(349),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(349),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(349),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(349),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(349),
    [sym_regex_lit] = STATE(349),
    [sym_read_cond_lit] = STATE(349),
    [sym_splicing_read_cond_lit] = STATE(349),
    [sym_ns_map_lit] = STATE(349),
    [sym_var_quoting_lit] = STATE(349),
    [sym_sym_val_lit] = STATE(349),
    [sym_evaling_lit] = STATE(349),
    [sym_tagged_or_ctor_lit] = STATE(349),
    [sym_derefing_lit] = STATE(349),
    [sym_quoting_lit] = STATE(349),
    [sym_syn_quoting_lit] = STATE(349),
    [sym_unquote_splicing_lit] = STATE(349),
    [sym_unquoting_lit] = STATE(349),
    [aux_sym_dis_expr_repeat1] = STATE(32),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(476),
    [sym_comment] = ACTIONS(476),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(478),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(478),
    [sym_nil_lit] = ACTIONS(480),
    [sym_bool_lit] = ACTIONS(480),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [44] = {
    [sym__gap] = STATE(33),
    [sym_dis_expr] = STATE(33),
    [sym__form] = STATE(354),
    [sym_kwd_lit] = STATE(354),
    [sym_str_lit] = STATE(354),
    [sym_sym_lit] = STATE(354),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(354),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(354),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(354),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(354),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(354),
    [sym_regex_lit] = STATE(354),
    [sym_read_cond_lit] = STATE(354),
    [sym_splicing_read_cond_lit] = STATE(354),
    [sym_ns_map_lit] = STATE(354),
    [sym_var_quoting_lit] = STATE(354),
    [sym_sym_val_lit] = STATE(354),
    [sym_evaling_lit] = STATE(354),
    [sym_tagged_or_ctor_lit] = STATE(354),
    [sym_derefing_lit] = STATE(354),
    [sym_quoting_lit] = STATE(354),
    [sym_syn_quoting_lit] = STATE(354),
    [sym_unquote_splicing_lit] = STATE(354),
    [sym_unquoting_lit] = STATE(354),
    [aux_sym_dis_expr_repeat1] = STATE(33),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(482),
    [sym_comment] = ACTIONS(482),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(484),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(484),
    [sym_nil_lit] = ACTIONS(486),
    [sym_bool_lit] = ACTIONS(486),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [45] = {
    [sym__gap] = STATE(42),
    [sym_dis_expr] = STATE(42),
    [sym__form] = STATE(421),
    [sym_kwd_lit] = STATE(421),
    [sym_str_lit] = STATE(421),
    [sym_sym_lit] = STATE(421),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(421),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(421),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(421),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(421),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(421),
    [sym_regex_lit] = STATE(421),
    [sym_read_cond_lit] = STATE(421),
    [sym_splicing_read_cond_lit] = STATE(421),
    [sym_ns_map_lit] = STATE(421),
    [sym_var_quoting_lit] = STATE(421),
    [sym_sym_val_lit] = STATE(421),
    [sym_evaling_lit] = STATE(421),
    [sym_tagged_or_ctor_lit] = STATE(421),
    [sym_derefing_lit] = STATE(421),
    [sym_quoting_lit] = STATE(421),
    [sym_syn_quoting_lit] = STATE(421),
    [sym_unquote_splicing_lit] = STATE(421),
    [sym_unquoting_lit] = STATE(421),
    [aux_sym_dis_expr_repeat1] = STATE(42),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(488),
    [sym_comment] = ACTIONS(488),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(374),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(374),
    [sym_nil_lit] = ACTIONS(376),
    [sym_bool_lit] = ACTIONS(376),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [46] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(355),
    [sym_kwd_lit] = STATE(355),
    [sym_str_lit] = STATE(355),
    [sym_sym_lit] = STATE(355),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(355),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(355),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(355),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(355),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(355),
    [sym_regex_lit] = STATE(355),
    [sym_read_cond_lit] = STATE(355),
    [sym_splicing_read_cond_lit] = STATE(355),
    [sym_ns_map_lit] = STATE(355),
    [sym_var_quoting_lit] = STATE(355),
    [sym_sym_val_lit] = STATE(355),
    [sym_evaling_lit] = STATE(355),
    [sym_tagged_or_ctor_lit] = STATE(355),
    [sym_derefing_lit] = STATE(355),
    [sym_quoting_lit] = STATE(355),
    [sym_syn_quoting_lit] = STATE(355),
    [sym_unquote_splicing_lit] = STATE(355),
    [sym_unquoting_lit] = STATE(355),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(490),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(490),
    [sym_nil_lit] = ACTIONS(492),
    [sym_bool_lit] = ACTIONS(492),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [47] = {
    [sym__gap] = STATE(123),
    [sym_dis_expr] = STATE(123),
    [sym__form] = STATE(361),
    [sym_kwd_lit] = STATE(361),
    [sym_str_lit] = STATE(361),
    [sym_sym_lit] = STATE(361),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(361),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(361),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(361),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(361),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(361),
    [sym_regex_lit] = STATE(361),
    [sym_read_cond_lit] = STATE(361),
    [sym_splicing_read_cond_lit] = STATE(361),
    [sym_ns_map_lit] = STATE(361),
    [sym_var_quoting_lit] = STATE(361),
    [sym_sym_val_lit] = STATE(361),
    [sym_evaling_lit] = STATE(361),
    [sym_tagged_or_ctor_lit] = STATE(361),
    [sym_derefing_lit] = STATE(361),
    [sym_quoting_lit] = STATE(361),
    [sym_syn_quoting_lit] = STATE(361),
    [sym_unquote_splicing_lit] = STATE(361),
    [sym_unquoting_lit] = STATE(361),
    [aux_sym_dis_expr_repeat1] = STATE(123),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(494),
    [sym_comment] = ACTIONS(494),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(496),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(496),
    [sym_nil_lit] = ACTIONS(498),
    [sym_bool_lit] = ACTIONS(498),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [48] = {
    [sym__gap] = STATE(35),
    [sym_dis_expr] = STATE(35),
    [sym__form] = STATE(363),
    [sym_kwd_lit] = STATE(363),
    [sym_str_lit] = STATE(363),
    [sym_sym_lit] = STATE(363),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(363),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(363),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(363),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(363),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(363),
    [sym_regex_lit] = STATE(363),
    [sym_read_cond_lit] = STATE(363),
    [sym_splicing_read_cond_lit] = STATE(363),
    [sym_ns_map_lit] = STATE(363),
    [sym_var_quoting_lit] = STATE(363),
    [sym_sym_val_lit] = STATE(363),
    [sym_evaling_lit] = STATE(363),
    [sym_tagged_or_ctor_lit] = STATE(363),
    [sym_derefing_lit] = STATE(363),
    [sym_quoting_lit] = STATE(363),
    [sym_syn_quoting_lit] = STATE(363),
    [sym_unquote_splicing_lit] = STATE(363),
    [sym_unquoting_lit] = STATE(363),
    [aux_sym_dis_expr_repeat1] = STATE(35),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(500),
    [sym_comment] = ACTIONS(500),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(450),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(450),
    [sym_nil_lit] = ACTIONS(456),
    [sym_bool_lit] = ACTIONS(456),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [49] = {
    [sym__gap] = STATE(125),
    [sym_dis_expr] = STATE(125),
    [sym__form] = STATE(365),
    [sym_kwd_lit] = STATE(365),
    [sym_str_lit] = STATE(365),
    [sym_sym_lit] = STATE(365),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(365),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(365),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(365),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(365),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(365),
    [sym_regex_lit] = STATE(365),
    [sym_read_cond_lit] = STATE(365),
    [sym_splicing_read_cond_lit] = STATE(365),
    [sym_ns_map_lit] = STATE(365),
    [sym_var_quoting_lit] = STATE(365),
    [sym_sym_val_lit] = STATE(365),
    [sym_evaling_lit] = STATE(365),
    [sym_tagged_or_ctor_lit] = STATE(365),
    [sym_derefing_lit] = STATE(365),
    [sym_quoting_lit] = STATE(365),
    [sym_syn_quoting_lit] = STATE(365),
    [sym_unquote_splicing_lit] = STATE(365),
    [sym_unquoting_lit] = STATE(365),
    [aux_sym_dis_expr_repeat1] = STATE(125),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(502),
    [sym_comment] = ACTIONS(502),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(504),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(504),
    [sym_nil_lit] = ACTIONS(506),
    [sym_bool_lit] = ACTIONS(506),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [50] = {
    [sym__gap] = STATE(37),
    [sym_dis_expr] = STATE(37),
    [sym__form] = STATE(367),
    [sym_kwd_lit] = STATE(367),
    [sym_str_lit] = STATE(367),
    [sym_sym_lit] = STATE(367),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(367),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(367),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(367),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(367),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(367),
    [sym_regex_lit] = STATE(367),
    [sym_read_cond_lit] = STATE(367),
    [sym_splicing_read_cond_lit] = STATE(367),
    [sym_ns_map_lit] = STATE(367),
    [sym_var_quoting_lit] = STATE(367),
    [sym_sym_val_lit] = STATE(367),
    [sym_evaling_lit] = STATE(367),
    [sym_tagged_or_ctor_lit] = STATE(367),
    [sym_derefing_lit] = STATE(367),
    [sym_quoting_lit] = STATE(367),
    [sym_syn_quoting_lit] = STATE(367),
    [sym_unquote_splicing_lit] = STATE(367),
    [sym_unquoting_lit] = STATE(367),
    [aux_sym_dis_expr_repeat1] = STATE(37),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(508),
    [sym_comment] = ACTIONS(508),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(510),
    [sym_nil_lit] = ACTIONS(512),
    [sym_bool_lit] = ACTIONS(512),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [51] = {
    [sym__gap] = STATE(38),
    [sym_dis_expr] = STATE(38),
    [sym__form] = STATE(369),
    [sym_kwd_lit] = STATE(369),
    [sym_str_lit] = STATE(369),
    [sym_sym_lit] = STATE(369),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(369),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(369),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(369),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(369),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(369),
    [sym_regex_lit] = STATE(369),
    [sym_read_cond_lit] = STATE(369),
    [sym_splicing_read_cond_lit] = STATE(369),
    [sym_ns_map_lit] = STATE(369),
    [sym_var_quoting_lit] = STATE(369),
    [sym_sym_val_lit] = STATE(369),
    [sym_evaling_lit] = STATE(369),
    [sym_tagged_or_ctor_lit] = STATE(369),
    [sym_derefing_lit] = STATE(369),
    [sym_quoting_lit] = STATE(369),
    [sym_syn_quoting_lit] = STATE(369),
    [sym_unquote_splicing_lit] = STATE(369),
    [sym_unquoting_lit] = STATE(369),
    [aux_sym_dis_expr_repeat1] = STATE(38),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(514),
    [sym_comment] = ACTIONS(514),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(516),
    [sym_nil_lit] = ACTIONS(518),
    [sym_bool_lit] = ACTIONS(518),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [52] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(427),
    [sym_kwd_lit] = STATE(427),
    [sym_str_lit] = STATE(427),
    [sym_sym_lit] = STATE(427),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(427),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(427),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(427),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(427),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(427),
    [sym_regex_lit] = STATE(427),
    [sym_read_cond_lit] = STATE(427),
    [sym_splicing_read_cond_lit] = STATE(427),
    [sym_ns_map_lit] = STATE(427),
    [sym_var_quoting_lit] = STATE(427),
    [sym_sym_val_lit] = STATE(427),
    [sym_evaling_lit] = STATE(427),
    [sym_tagged_or_ctor_lit] = STATE(427),
    [sym_derefing_lit] = STATE(427),
    [sym_quoting_lit] = STATE(427),
    [sym_syn_quoting_lit] = STATE(427),
    [sym_unquote_splicing_lit] = STATE(427),
    [sym_unquoting_lit] = STATE(427),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(378),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(378),
    [sym_nil_lit] = ACTIONS(380),
    [sym_bool_lit] = ACTIONS(380),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [53] = {
    [sym__gap] = STATE(41),
    [sym_dis_expr] = STATE(41),
    [sym__form] = STATE(375),
    [sym_kwd_lit] = STATE(375),
    [sym_str_lit] = STATE(375),
    [sym_sym_lit] = STATE(375),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(375),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(375),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(375),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(375),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(375),
    [sym_regex_lit] = STATE(375),
    [sym_read_cond_lit] = STATE(375),
    [sym_splicing_read_cond_lit] = STATE(375),
    [sym_ns_map_lit] = STATE(375),
    [sym_var_quoting_lit] = STATE(375),
    [sym_sym_val_lit] = STATE(375),
    [sym_evaling_lit] = STATE(375),
    [sym_tagged_or_ctor_lit] = STATE(375),
    [sym_derefing_lit] = STATE(375),
    [sym_quoting_lit] = STATE(375),
    [sym_syn_quoting_lit] = STATE(375),
    [sym_unquote_splicing_lit] = STATE(375),
    [sym_unquoting_lit] = STATE(375),
    [aux_sym_dis_expr_repeat1] = STATE(41),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(520),
    [sym_comment] = ACTIONS(520),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(522),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(522),
    [sym_nil_lit] = ACTIONS(524),
    [sym_bool_lit] = ACTIONS(524),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [54] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(399),
    [sym_kwd_lit] = STATE(399),
    [sym_str_lit] = STATE(399),
    [sym_sym_lit] = STATE(399),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(399),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(399),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(399),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(399),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(399),
    [sym_regex_lit] = STATE(399),
    [sym_read_cond_lit] = STATE(399),
    [sym_splicing_read_cond_lit] = STATE(399),
    [sym_ns_map_lit] = STATE(399),
    [sym_var_quoting_lit] = STATE(399),
    [sym_sym_val_lit] = STATE(399),
    [sym_evaling_lit] = STATE(399),
    [sym_tagged_or_ctor_lit] = STATE(399),
    [sym_derefing_lit] = STATE(399),
    [sym_quoting_lit] = STATE(399),
    [sym_syn_quoting_lit] = STATE(399),
    [sym_unquote_splicing_lit] = STATE(399),
    [sym_unquoting_lit] = STATE(399),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(382),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(382),
    [sym_nil_lit] = ACTIONS(384),
    [sym_bool_lit] = ACTIONS(384),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [55] = {
    [sym__gap] = STATE(115),
    [sym_dis_expr] = STATE(115),
    [sym__form] = STATE(265),
    [sym_kwd_lit] = STATE(265),
    [sym_str_lit] = STATE(265),
    [sym_sym_lit] = STATE(265),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(265),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(265),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(265),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(265),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(265),
    [sym_regex_lit] = STATE(265),
    [sym_read_cond_lit] = STATE(265),
    [sym_splicing_read_cond_lit] = STATE(265),
    [sym_ns_map_lit] = STATE(265),
    [sym_var_quoting_lit] = STATE(265),
    [sym_sym_val_lit] = STATE(265),
    [sym_evaling_lit] = STATE(265),
    [sym_tagged_or_ctor_lit] = STATE(265),
    [sym_derefing_lit] = STATE(265),
    [sym_quoting_lit] = STATE(265),
    [sym_syn_quoting_lit] = STATE(265),
    [sym_unquote_splicing_lit] = STATE(265),
    [sym_unquoting_lit] = STATE(265),
    [aux_sym_dis_expr_repeat1] = STATE(115),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(526),
    [sym_comment] = ACTIONS(526),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(528),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(528),
    [sym_nil_lit] = ACTIONS(530),
    [sym_bool_lit] = ACTIONS(530),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [56] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(379),
    [sym_kwd_lit] = STATE(379),
    [sym_str_lit] = STATE(379),
    [sym_sym_lit] = STATE(379),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(379),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(379),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(379),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(379),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(379),
    [sym_regex_lit] = STATE(379),
    [sym_read_cond_lit] = STATE(379),
    [sym_splicing_read_cond_lit] = STATE(379),
    [sym_ns_map_lit] = STATE(379),
    [sym_var_quoting_lit] = STATE(379),
    [sym_sym_val_lit] = STATE(379),
    [sym_evaling_lit] = STATE(379),
    [sym_tagged_or_ctor_lit] = STATE(379),
    [sym_derefing_lit] = STATE(379),
    [sym_quoting_lit] = STATE(379),
    [sym_syn_quoting_lit] = STATE(379),
    [sym_unquote_splicing_lit] = STATE(379),
    [sym_unquoting_lit] = STATE(379),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(532),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(532),
    [sym_nil_lit] = ACTIONS(534),
    [sym_bool_lit] = ACTIONS(534),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [57] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(382),
    [sym_kwd_lit] = STATE(382),
    [sym_str_lit] = STATE(382),
    [sym_sym_lit] = STATE(382),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(382),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(382),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(382),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(382),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(382),
    [sym_regex_lit] = STATE(382),
    [sym_read_cond_lit] = STATE(382),
    [sym_splicing_read_cond_lit] = STATE(382),
    [sym_ns_map_lit] = STATE(382),
    [sym_var_quoting_lit] = STATE(382),
    [sym_sym_val_lit] = STATE(382),
    [sym_evaling_lit] = STATE(382),
    [sym_tagged_or_ctor_lit] = STATE(382),
    [sym_derefing_lit] = STATE(382),
    [sym_quoting_lit] = STATE(382),
    [sym_syn_quoting_lit] = STATE(382),
    [sym_unquote_splicing_lit] = STATE(382),
    [sym_unquoting_lit] = STATE(382),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(536),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(536),
    [sym_nil_lit] = ACTIONS(538),
    [sym_bool_lit] = ACTIONS(538),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [58] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(397),
    [sym_kwd_lit] = STATE(397),
    [sym_str_lit] = STATE(397),
    [sym_sym_lit] = STATE(397),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(397),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(397),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(397),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(397),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(397),
    [sym_regex_lit] = STATE(397),
    [sym_read_cond_lit] = STATE(397),
    [sym_splicing_read_cond_lit] = STATE(397),
    [sym_ns_map_lit] = STATE(397),
    [sym_var_quoting_lit] = STATE(397),
    [sym_sym_val_lit] = STATE(397),
    [sym_evaling_lit] = STATE(397),
    [sym_tagged_or_ctor_lit] = STATE(397),
    [sym_derefing_lit] = STATE(397),
    [sym_quoting_lit] = STATE(397),
    [sym_syn_quoting_lit] = STATE(397),
    [sym_unquote_splicing_lit] = STATE(397),
    [sym_unquoting_lit] = STATE(397),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(410),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(410),
    [sym_nil_lit] = ACTIONS(412),
    [sym_bool_lit] = ACTIONS(412),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [59] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(382),
    [sym_kwd_lit] = STATE(382),
    [sym_str_lit] = STATE(382),
    [sym_sym_lit] = STATE(382),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(382),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(382),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(382),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(382),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(382),
    [sym_regex_lit] = STATE(382),
    [sym_read_cond_lit] = STATE(382),
    [sym_splicing_read_cond_lit] = STATE(382),
    [sym_ns_map_lit] = STATE(382),
    [sym_var_quoting_lit] = STATE(382),
    [sym_sym_val_lit] = STATE(382),
    [sym_evaling_lit] = STATE(382),
    [sym_tagged_or_ctor_lit] = STATE(382),
    [sym_derefing_lit] = STATE(382),
    [sym_quoting_lit] = STATE(382),
    [sym_syn_quoting_lit] = STATE(382),
    [sym_unquote_splicing_lit] = STATE(382),
    [sym_unquoting_lit] = STATE(382),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(536),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(536),
    [sym_nil_lit] = ACTIONS(538),
    [sym_bool_lit] = ACTIONS(538),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [60] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(386),
    [sym_kwd_lit] = STATE(386),
    [sym_str_lit] = STATE(386),
    [sym_sym_lit] = STATE(386),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(386),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(386),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(386),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(386),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(386),
    [sym_regex_lit] = STATE(386),
    [sym_read_cond_lit] = STATE(386),
    [sym_splicing_read_cond_lit] = STATE(386),
    [sym_ns_map_lit] = STATE(386),
    [sym_var_quoting_lit] = STATE(386),
    [sym_sym_val_lit] = STATE(386),
    [sym_evaling_lit] = STATE(386),
    [sym_tagged_or_ctor_lit] = STATE(386),
    [sym_derefing_lit] = STATE(386),
    [sym_quoting_lit] = STATE(386),
    [sym_syn_quoting_lit] = STATE(386),
    [sym_unquote_splicing_lit] = STATE(386),
    [sym_unquoting_lit] = STATE(386),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(414),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(414),
    [sym_nil_lit] = ACTIONS(420),
    [sym_bool_lit] = ACTIONS(420),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [61] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(383),
    [sym_kwd_lit] = STATE(383),
    [sym_str_lit] = STATE(383),
    [sym_sym_lit] = STATE(383),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(383),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(383),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(383),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(383),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(383),
    [sym_regex_lit] = STATE(383),
    [sym_read_cond_lit] = STATE(383),
    [sym_splicing_read_cond_lit] = STATE(383),
    [sym_ns_map_lit] = STATE(383),
    [sym_var_quoting_lit] = STATE(383),
    [sym_sym_val_lit] = STATE(383),
    [sym_evaling_lit] = STATE(383),
    [sym_tagged_or_ctor_lit] = STATE(383),
    [sym_derefing_lit] = STATE(383),
    [sym_quoting_lit] = STATE(383),
    [sym_syn_quoting_lit] = STATE(383),
    [sym_unquote_splicing_lit] = STATE(383),
    [sym_unquoting_lit] = STATE(383),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(540),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(540),
    [sym_nil_lit] = ACTIONS(542),
    [sym_bool_lit] = ACTIONS(542),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [62] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(380),
    [sym_kwd_lit] = STATE(380),
    [sym_str_lit] = STATE(380),
    [sym_sym_lit] = STATE(380),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(380),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(380),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(380),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(380),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(380),
    [sym_regex_lit] = STATE(380),
    [sym_read_cond_lit] = STATE(380),
    [sym_splicing_read_cond_lit] = STATE(380),
    [sym_ns_map_lit] = STATE(380),
    [sym_var_quoting_lit] = STATE(380),
    [sym_sym_val_lit] = STATE(380),
    [sym_evaling_lit] = STATE(380),
    [sym_tagged_or_ctor_lit] = STATE(380),
    [sym_derefing_lit] = STATE(380),
    [sym_quoting_lit] = STATE(380),
    [sym_syn_quoting_lit] = STATE(380),
    [sym_unquote_splicing_lit] = STATE(380),
    [sym_unquoting_lit] = STATE(380),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(436),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(436),
    [sym_nil_lit] = ACTIONS(438),
    [sym_bool_lit] = ACTIONS(438),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [63] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(333),
    [sym_kwd_lit] = STATE(333),
    [sym_str_lit] = STATE(333),
    [sym_sym_lit] = STATE(333),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(333),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(333),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(333),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(333),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(333),
    [sym_regex_lit] = STATE(333),
    [sym_read_cond_lit] = STATE(333),
    [sym_splicing_read_cond_lit] = STATE(333),
    [sym_ns_map_lit] = STATE(333),
    [sym_var_quoting_lit] = STATE(333),
    [sym_sym_val_lit] = STATE(333),
    [sym_evaling_lit] = STATE(333),
    [sym_tagged_or_ctor_lit] = STATE(333),
    [sym_derefing_lit] = STATE(333),
    [sym_quoting_lit] = STATE(333),
    [sym_syn_quoting_lit] = STATE(333),
    [sym_unquote_splicing_lit] = STATE(333),
    [sym_unquoting_lit] = STATE(333),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(544),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(544),
    [sym_nil_lit] = ACTIONS(546),
    [sym_bool_lit] = ACTIONS(546),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [64] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(268),
    [sym_kwd_lit] = STATE(268),
    [sym_str_lit] = STATE(268),
    [sym_sym_lit] = STATE(268),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(268),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(268),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(268),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(268),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(268),
    [sym_regex_lit] = STATE(268),
    [sym_read_cond_lit] = STATE(268),
    [sym_splicing_read_cond_lit] = STATE(268),
    [sym_ns_map_lit] = STATE(268),
    [sym_var_quoting_lit] = STATE(268),
    [sym_sym_val_lit] = STATE(268),
    [sym_evaling_lit] = STATE(268),
    [sym_tagged_or_ctor_lit] = STATE(268),
    [sym_derefing_lit] = STATE(268),
    [sym_quoting_lit] = STATE(268),
    [sym_syn_quoting_lit] = STATE(268),
    [sym_unquote_splicing_lit] = STATE(268),
    [sym_unquoting_lit] = STATE(268),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(548),
    [sym_nil_lit] = ACTIONS(550),
    [sym_bool_lit] = ACTIONS(550),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [65] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(385),
    [sym_kwd_lit] = STATE(385),
    [sym_str_lit] = STATE(385),
    [sym_sym_lit] = STATE(385),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(385),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(385),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(385),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(385),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(385),
    [sym_regex_lit] = STATE(385),
    [sym_read_cond_lit] = STATE(385),
    [sym_splicing_read_cond_lit] = STATE(385),
    [sym_ns_map_lit] = STATE(385),
    [sym_var_quoting_lit] = STATE(385),
    [sym_sym_val_lit] = STATE(385),
    [sym_evaling_lit] = STATE(385),
    [sym_tagged_or_ctor_lit] = STATE(385),
    [sym_derefing_lit] = STATE(385),
    [sym_quoting_lit] = STATE(385),
    [sym_syn_quoting_lit] = STATE(385),
    [sym_unquote_splicing_lit] = STATE(385),
    [sym_unquoting_lit] = STATE(385),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(552),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(552),
    [sym_nil_lit] = ACTIONS(554),
    [sym_bool_lit] = ACTIONS(554),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [66] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(357),
    [sym_kwd_lit] = STATE(357),
    [sym_str_lit] = STATE(357),
    [sym_sym_lit] = STATE(357),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(357),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(357),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(357),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(357),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(357),
    [sym_regex_lit] = STATE(357),
    [sym_read_cond_lit] = STATE(357),
    [sym_splicing_read_cond_lit] = STATE(357),
    [sym_ns_map_lit] = STATE(357),
    [sym_var_quoting_lit] = STATE(357),
    [sym_sym_val_lit] = STATE(357),
    [sym_evaling_lit] = STATE(357),
    [sym_tagged_or_ctor_lit] = STATE(357),
    [sym_derefing_lit] = STATE(357),
    [sym_quoting_lit] = STATE(357),
    [sym_syn_quoting_lit] = STATE(357),
    [sym_unquote_splicing_lit] = STATE(357),
    [sym_unquoting_lit] = STATE(357),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(440),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(440),
    [sym_nil_lit] = ACTIONS(442),
    [sym_bool_lit] = ACTIONS(442),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [67] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(380),
    [sym_kwd_lit] = STATE(380),
    [sym_str_lit] = STATE(380),
    [sym_sym_lit] = STATE(380),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(380),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(380),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(380),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(380),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(380),
    [sym_regex_lit] = STATE(380),
    [sym_read_cond_lit] = STATE(380),
    [sym_splicing_read_cond_lit] = STATE(380),
    [sym_ns_map_lit] = STATE(380),
    [sym_var_quoting_lit] = STATE(380),
    [sym_sym_val_lit] = STATE(380),
    [sym_evaling_lit] = STATE(380),
    [sym_tagged_or_ctor_lit] = STATE(380),
    [sym_derefing_lit] = STATE(380),
    [sym_quoting_lit] = STATE(380),
    [sym_syn_quoting_lit] = STATE(380),
    [sym_unquote_splicing_lit] = STATE(380),
    [sym_unquoting_lit] = STATE(380),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(436),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(436),
    [sym_nil_lit] = ACTIONS(438),
    [sym_bool_lit] = ACTIONS(438),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [68] = {
    [sym__gap] = STATE(46),
    [sym_dis_expr] = STATE(46),
    [sym__form] = STATE(401),
    [sym_kwd_lit] = STATE(401),
    [sym_str_lit] = STATE(401),
    [sym_sym_lit] = STATE(401),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(401),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(401),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(401),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(401),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(401),
    [sym_regex_lit] = STATE(401),
    [sym_read_cond_lit] = STATE(401),
    [sym_splicing_read_cond_lit] = STATE(401),
    [sym_ns_map_lit] = STATE(401),
    [sym_var_quoting_lit] = STATE(401),
    [sym_sym_val_lit] = STATE(401),
    [sym_evaling_lit] = STATE(401),
    [sym_tagged_or_ctor_lit] = STATE(401),
    [sym_derefing_lit] = STATE(401),
    [sym_quoting_lit] = STATE(401),
    [sym_syn_quoting_lit] = STATE(401),
    [sym_unquote_splicing_lit] = STATE(401),
    [sym_unquoting_lit] = STATE(401),
    [aux_sym_dis_expr_repeat1] = STATE(46),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(556),
    [sym_comment] = ACTIONS(556),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(558),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(558),
    [sym_nil_lit] = ACTIONS(560),
    [sym_bool_lit] = ACTIONS(560),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [69] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(343),
    [sym_kwd_lit] = STATE(343),
    [sym_str_lit] = STATE(343),
    [sym_sym_lit] = STATE(343),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(343),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(343),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(343),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(343),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(343),
    [sym_regex_lit] = STATE(343),
    [sym_read_cond_lit] = STATE(343),
    [sym_splicing_read_cond_lit] = STATE(343),
    [sym_ns_map_lit] = STATE(343),
    [sym_var_quoting_lit] = STATE(343),
    [sym_sym_val_lit] = STATE(343),
    [sym_evaling_lit] = STATE(343),
    [sym_tagged_or_ctor_lit] = STATE(343),
    [sym_derefing_lit] = STATE(343),
    [sym_quoting_lit] = STATE(343),
    [sym_syn_quoting_lit] = STATE(343),
    [sym_unquote_splicing_lit] = STATE(343),
    [sym_unquoting_lit] = STATE(343),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(472),
    [sym_nil_lit] = ACTIONS(474),
    [sym_bool_lit] = ACTIONS(474),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [70] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(412),
    [sym_kwd_lit] = STATE(412),
    [sym_str_lit] = STATE(412),
    [sym_sym_lit] = STATE(412),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(412),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(412),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(412),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(412),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(412),
    [sym_regex_lit] = STATE(412),
    [sym_read_cond_lit] = STATE(412),
    [sym_splicing_read_cond_lit] = STATE(412),
    [sym_ns_map_lit] = STATE(412),
    [sym_var_quoting_lit] = STATE(412),
    [sym_sym_val_lit] = STATE(412),
    [sym_evaling_lit] = STATE(412),
    [sym_tagged_or_ctor_lit] = STATE(412),
    [sym_derefing_lit] = STATE(412),
    [sym_quoting_lit] = STATE(412),
    [sym_syn_quoting_lit] = STATE(412),
    [sym_unquote_splicing_lit] = STATE(412),
    [sym_unquoting_lit] = STATE(412),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(562),
    [sym_nil_lit] = ACTIONS(564),
    [sym_bool_lit] = ACTIONS(564),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [71] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(271),
    [sym_kwd_lit] = STATE(271),
    [sym_str_lit] = STATE(271),
    [sym_sym_lit] = STATE(271),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(271),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(271),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(271),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(271),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(271),
    [sym_regex_lit] = STATE(271),
    [sym_read_cond_lit] = STATE(271),
    [sym_splicing_read_cond_lit] = STATE(271),
    [sym_ns_map_lit] = STATE(271),
    [sym_var_quoting_lit] = STATE(271),
    [sym_sym_val_lit] = STATE(271),
    [sym_evaling_lit] = STATE(271),
    [sym_tagged_or_ctor_lit] = STATE(271),
    [sym_derefing_lit] = STATE(271),
    [sym_quoting_lit] = STATE(271),
    [sym_syn_quoting_lit] = STATE(271),
    [sym_unquote_splicing_lit] = STATE(271),
    [sym_unquoting_lit] = STATE(271),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(566),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(566),
    [sym_nil_lit] = ACTIONS(568),
    [sym_bool_lit] = ACTIONS(568),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [72] = {
    [sym__gap] = STATE(56),
    [sym_dis_expr] = STATE(56),
    [sym__form] = STATE(420),
    [sym_kwd_lit] = STATE(420),
    [sym_str_lit] = STATE(420),
    [sym_sym_lit] = STATE(420),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(420),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(420),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(420),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(420),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(420),
    [sym_regex_lit] = STATE(420),
    [sym_read_cond_lit] = STATE(420),
    [sym_splicing_read_cond_lit] = STATE(420),
    [sym_ns_map_lit] = STATE(420),
    [sym_var_quoting_lit] = STATE(420),
    [sym_sym_val_lit] = STATE(420),
    [sym_evaling_lit] = STATE(420),
    [sym_tagged_or_ctor_lit] = STATE(420),
    [sym_derefing_lit] = STATE(420),
    [sym_quoting_lit] = STATE(420),
    [sym_syn_quoting_lit] = STATE(420),
    [sym_unquote_splicing_lit] = STATE(420),
    [sym_unquoting_lit] = STATE(420),
    [aux_sym_dis_expr_repeat1] = STATE(56),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(570),
    [sym_comment] = ACTIONS(570),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(572),
    [sym_nil_lit] = ACTIONS(574),
    [sym_bool_lit] = ACTIONS(574),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [73] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(272),
    [sym_kwd_lit] = STATE(272),
    [sym_str_lit] = STATE(272),
    [sym_sym_lit] = STATE(272),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(272),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(272),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(272),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(272),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(272),
    [sym_regex_lit] = STATE(272),
    [sym_read_cond_lit] = STATE(272),
    [sym_splicing_read_cond_lit] = STATE(272),
    [sym_ns_map_lit] = STATE(272),
    [sym_var_quoting_lit] = STATE(272),
    [sym_sym_val_lit] = STATE(272),
    [sym_evaling_lit] = STATE(272),
    [sym_tagged_or_ctor_lit] = STATE(272),
    [sym_derefing_lit] = STATE(272),
    [sym_quoting_lit] = STATE(272),
    [sym_syn_quoting_lit] = STATE(272),
    [sym_unquote_splicing_lit] = STATE(272),
    [sym_unquoting_lit] = STATE(272),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(576),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(576),
    [sym_nil_lit] = ACTIONS(578),
    [sym_bool_lit] = ACTIONS(578),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [74] = {
    [sym__gap] = STATE(59),
    [sym_dis_expr] = STATE(59),
    [sym__form] = STATE(425),
    [sym_kwd_lit] = STATE(425),
    [sym_str_lit] = STATE(425),
    [sym_sym_lit] = STATE(425),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(425),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(425),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(425),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(425),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(425),
    [sym_regex_lit] = STATE(425),
    [sym_read_cond_lit] = STATE(425),
    [sym_splicing_read_cond_lit] = STATE(425),
    [sym_ns_map_lit] = STATE(425),
    [sym_var_quoting_lit] = STATE(425),
    [sym_sym_val_lit] = STATE(425),
    [sym_evaling_lit] = STATE(425),
    [sym_tagged_or_ctor_lit] = STATE(425),
    [sym_derefing_lit] = STATE(425),
    [sym_quoting_lit] = STATE(425),
    [sym_syn_quoting_lit] = STATE(425),
    [sym_unquote_splicing_lit] = STATE(425),
    [sym_unquoting_lit] = STATE(425),
    [aux_sym_dis_expr_repeat1] = STATE(59),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(580),
    [sym_comment] = ACTIONS(580),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(582),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(582),
    [sym_nil_lit] = ACTIONS(584),
    [sym_bool_lit] = ACTIONS(584),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [75] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(273),
    [sym_kwd_lit] = STATE(273),
    [sym_str_lit] = STATE(273),
    [sym_sym_lit] = STATE(273),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(273),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(273),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(273),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(273),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(273),
    [sym_regex_lit] = STATE(273),
    [sym_read_cond_lit] = STATE(273),
    [sym_splicing_read_cond_lit] = STATE(273),
    [sym_ns_map_lit] = STATE(273),
    [sym_var_quoting_lit] = STATE(273),
    [sym_sym_val_lit] = STATE(273),
    [sym_evaling_lit] = STATE(273),
    [sym_tagged_or_ctor_lit] = STATE(273),
    [sym_derefing_lit] = STATE(273),
    [sym_quoting_lit] = STATE(273),
    [sym_syn_quoting_lit] = STATE(273),
    [sym_unquote_splicing_lit] = STATE(273),
    [sym_unquoting_lit] = STATE(273),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(586),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(586),
    [sym_nil_lit] = ACTIONS(588),
    [sym_bool_lit] = ACTIONS(588),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [76] = {
    [sym__gap] = STATE(61),
    [sym_dis_expr] = STATE(61),
    [sym__form] = STATE(426),
    [sym_kwd_lit] = STATE(426),
    [sym_str_lit] = STATE(426),
    [sym_sym_lit] = STATE(426),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(426),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(426),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(426),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(426),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(426),
    [sym_regex_lit] = STATE(426),
    [sym_read_cond_lit] = STATE(426),
    [sym_splicing_read_cond_lit] = STATE(426),
    [sym_ns_map_lit] = STATE(426),
    [sym_var_quoting_lit] = STATE(426),
    [sym_sym_val_lit] = STATE(426),
    [sym_evaling_lit] = STATE(426),
    [sym_tagged_or_ctor_lit] = STATE(426),
    [sym_derefing_lit] = STATE(426),
    [sym_quoting_lit] = STATE(426),
    [sym_syn_quoting_lit] = STATE(426),
    [sym_unquote_splicing_lit] = STATE(426),
    [sym_unquoting_lit] = STATE(426),
    [aux_sym_dis_expr_repeat1] = STATE(61),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(590),
    [sym_comment] = ACTIONS(590),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(592),
    [sym_nil_lit] = ACTIONS(594),
    [sym_bool_lit] = ACTIONS(594),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [77] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(274),
    [sym_kwd_lit] = STATE(274),
    [sym_str_lit] = STATE(274),
    [sym_sym_lit] = STATE(274),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(274),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(274),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(274),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(274),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(274),
    [sym_regex_lit] = STATE(274),
    [sym_read_cond_lit] = STATE(274),
    [sym_splicing_read_cond_lit] = STATE(274),
    [sym_ns_map_lit] = STATE(274),
    [sym_var_quoting_lit] = STATE(274),
    [sym_sym_val_lit] = STATE(274),
    [sym_evaling_lit] = STATE(274),
    [sym_tagged_or_ctor_lit] = STATE(274),
    [sym_derefing_lit] = STATE(274),
    [sym_quoting_lit] = STATE(274),
    [sym_syn_quoting_lit] = STATE(274),
    [sym_unquote_splicing_lit] = STATE(274),
    [sym_unquoting_lit] = STATE(274),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(596),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(596),
    [sym_nil_lit] = ACTIONS(598),
    [sym_bool_lit] = ACTIONS(598),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [78] = {
    [sym__gap] = STATE(63),
    [sym_dis_expr] = STATE(63),
    [sym__form] = STATE(428),
    [sym_kwd_lit] = STATE(428),
    [sym_str_lit] = STATE(428),
    [sym_sym_lit] = STATE(428),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(428),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(428),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(428),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(428),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(428),
    [sym_regex_lit] = STATE(428),
    [sym_read_cond_lit] = STATE(428),
    [sym_splicing_read_cond_lit] = STATE(428),
    [sym_ns_map_lit] = STATE(428),
    [sym_var_quoting_lit] = STATE(428),
    [sym_sym_val_lit] = STATE(428),
    [sym_evaling_lit] = STATE(428),
    [sym_tagged_or_ctor_lit] = STATE(428),
    [sym_derefing_lit] = STATE(428),
    [sym_quoting_lit] = STATE(428),
    [sym_syn_quoting_lit] = STATE(428),
    [sym_unquote_splicing_lit] = STATE(428),
    [sym_unquoting_lit] = STATE(428),
    [aux_sym_dis_expr_repeat1] = STATE(63),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(600),
    [sym_comment] = ACTIONS(600),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(602),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(602),
    [sym_nil_lit] = ACTIONS(604),
    [sym_bool_lit] = ACTIONS(604),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [79] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(275),
    [sym_kwd_lit] = STATE(275),
    [sym_str_lit] = STATE(275),
    [sym_sym_lit] = STATE(275),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(275),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(275),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(275),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(275),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(275),
    [sym_regex_lit] = STATE(275),
    [sym_read_cond_lit] = STATE(275),
    [sym_splicing_read_cond_lit] = STATE(275),
    [sym_ns_map_lit] = STATE(275),
    [sym_var_quoting_lit] = STATE(275),
    [sym_sym_val_lit] = STATE(275),
    [sym_evaling_lit] = STATE(275),
    [sym_tagged_or_ctor_lit] = STATE(275),
    [sym_derefing_lit] = STATE(275),
    [sym_quoting_lit] = STATE(275),
    [sym_syn_quoting_lit] = STATE(275),
    [sym_unquote_splicing_lit] = STATE(275),
    [sym_unquoting_lit] = STATE(275),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(606),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(606),
    [sym_nil_lit] = ACTIONS(608),
    [sym_bool_lit] = ACTIONS(608),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [80] = {
    [sym__gap] = STATE(65),
    [sym_dis_expr] = STATE(65),
    [sym__form] = STATE(429),
    [sym_kwd_lit] = STATE(429),
    [sym_str_lit] = STATE(429),
    [sym_sym_lit] = STATE(429),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(429),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(429),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(429),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(429),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(429),
    [sym_regex_lit] = STATE(429),
    [sym_read_cond_lit] = STATE(429),
    [sym_splicing_read_cond_lit] = STATE(429),
    [sym_ns_map_lit] = STATE(429),
    [sym_var_quoting_lit] = STATE(429),
    [sym_sym_val_lit] = STATE(429),
    [sym_evaling_lit] = STATE(429),
    [sym_tagged_or_ctor_lit] = STATE(429),
    [sym_derefing_lit] = STATE(429),
    [sym_quoting_lit] = STATE(429),
    [sym_syn_quoting_lit] = STATE(429),
    [sym_unquote_splicing_lit] = STATE(429),
    [sym_unquoting_lit] = STATE(429),
    [aux_sym_dis_expr_repeat1] = STATE(65),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(610),
    [sym_comment] = ACTIONS(610),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(612),
    [sym_nil_lit] = ACTIONS(614),
    [sym_bool_lit] = ACTIONS(614),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [81] = {
    [sym__gap] = STATE(22),
    [sym_dis_expr] = STATE(22),
    [sym__form] = STATE(340),
    [sym_kwd_lit] = STATE(340),
    [sym_str_lit] = STATE(340),
    [sym_sym_lit] = STATE(340),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(340),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(340),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(340),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(340),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(340),
    [sym_regex_lit] = STATE(340),
    [sym_read_cond_lit] = STATE(340),
    [sym_splicing_read_cond_lit] = STATE(340),
    [sym_ns_map_lit] = STATE(340),
    [sym_var_quoting_lit] = STATE(340),
    [sym_sym_val_lit] = STATE(340),
    [sym_evaling_lit] = STATE(340),
    [sym_tagged_or_ctor_lit] = STATE(340),
    [sym_derefing_lit] = STATE(340),
    [sym_quoting_lit] = STATE(340),
    [sym_syn_quoting_lit] = STATE(340),
    [sym_unquote_splicing_lit] = STATE(340),
    [sym_unquoting_lit] = STATE(340),
    [aux_sym_dis_expr_repeat1] = STATE(22),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(616),
    [sym_comment] = ACTIONS(616),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(618),
    [sym_nil_lit] = ACTIONS(620),
    [sym_bool_lit] = ACTIONS(620),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [82] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(383),
    [sym_kwd_lit] = STATE(383),
    [sym_str_lit] = STATE(383),
    [sym_sym_lit] = STATE(383),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(383),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(383),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(383),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(383),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(383),
    [sym_regex_lit] = STATE(383),
    [sym_read_cond_lit] = STATE(383),
    [sym_splicing_read_cond_lit] = STATE(383),
    [sym_ns_map_lit] = STATE(383),
    [sym_var_quoting_lit] = STATE(383),
    [sym_sym_val_lit] = STATE(383),
    [sym_evaling_lit] = STATE(383),
    [sym_tagged_or_ctor_lit] = STATE(383),
    [sym_derefing_lit] = STATE(383),
    [sym_quoting_lit] = STATE(383),
    [sym_syn_quoting_lit] = STATE(383),
    [sym_unquote_splicing_lit] = STATE(383),
    [sym_unquoting_lit] = STATE(383),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(540),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(540),
    [sym_nil_lit] = ACTIONS(542),
    [sym_bool_lit] = ACTIONS(542),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [83] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(382),
    [sym_kwd_lit] = STATE(382),
    [sym_str_lit] = STATE(382),
    [sym_sym_lit] = STATE(382),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(382),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(382),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(382),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(382),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(382),
    [sym_regex_lit] = STATE(382),
    [sym_read_cond_lit] = STATE(382),
    [sym_splicing_read_cond_lit] = STATE(382),
    [sym_ns_map_lit] = STATE(382),
    [sym_var_quoting_lit] = STATE(382),
    [sym_sym_val_lit] = STATE(382),
    [sym_evaling_lit] = STATE(382),
    [sym_tagged_or_ctor_lit] = STATE(382),
    [sym_derefing_lit] = STATE(382),
    [sym_quoting_lit] = STATE(382),
    [sym_syn_quoting_lit] = STATE(382),
    [sym_unquote_splicing_lit] = STATE(382),
    [sym_unquoting_lit] = STATE(382),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(536),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(536),
    [sym_nil_lit] = ACTIONS(538),
    [sym_bool_lit] = ACTIONS(538),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [84] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(379),
    [sym_kwd_lit] = STATE(379),
    [sym_str_lit] = STATE(379),
    [sym_sym_lit] = STATE(379),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(379),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(379),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(379),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(379),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(379),
    [sym_regex_lit] = STATE(379),
    [sym_read_cond_lit] = STATE(379),
    [sym_splicing_read_cond_lit] = STATE(379),
    [sym_ns_map_lit] = STATE(379),
    [sym_var_quoting_lit] = STATE(379),
    [sym_sym_val_lit] = STATE(379),
    [sym_evaling_lit] = STATE(379),
    [sym_tagged_or_ctor_lit] = STATE(379),
    [sym_derefing_lit] = STATE(379),
    [sym_quoting_lit] = STATE(379),
    [sym_syn_quoting_lit] = STATE(379),
    [sym_unquote_splicing_lit] = STATE(379),
    [sym_unquoting_lit] = STATE(379),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(532),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(532),
    [sym_nil_lit] = ACTIONS(534),
    [sym_bool_lit] = ACTIONS(534),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [85] = {
    [sym__gap] = STATE(52),
    [sym_dis_expr] = STATE(52),
    [sym__form] = STATE(349),
    [sym_kwd_lit] = STATE(349),
    [sym_str_lit] = STATE(349),
    [sym_sym_lit] = STATE(349),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(349),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(349),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(349),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(349),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(349),
    [sym_regex_lit] = STATE(349),
    [sym_read_cond_lit] = STATE(349),
    [sym_splicing_read_cond_lit] = STATE(349),
    [sym_ns_map_lit] = STATE(349),
    [sym_var_quoting_lit] = STATE(349),
    [sym_sym_val_lit] = STATE(349),
    [sym_evaling_lit] = STATE(349),
    [sym_tagged_or_ctor_lit] = STATE(349),
    [sym_derefing_lit] = STATE(349),
    [sym_quoting_lit] = STATE(349),
    [sym_syn_quoting_lit] = STATE(349),
    [sym_unquote_splicing_lit] = STATE(349),
    [sym_unquoting_lit] = STATE(349),
    [aux_sym_dis_expr_repeat1] = STATE(52),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(622),
    [sym_comment] = ACTIONS(622),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(478),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(478),
    [sym_nil_lit] = ACTIONS(480),
    [sym_bool_lit] = ACTIONS(480),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [86] = {
    [sym__gap] = STATE(54),
    [sym_dis_expr] = STATE(54),
    [sym__form] = STATE(354),
    [sym_kwd_lit] = STATE(354),
    [sym_str_lit] = STATE(354),
    [sym_sym_lit] = STATE(354),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(354),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(354),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(354),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(354),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(354),
    [sym_regex_lit] = STATE(354),
    [sym_read_cond_lit] = STATE(354),
    [sym_splicing_read_cond_lit] = STATE(354),
    [sym_ns_map_lit] = STATE(354),
    [sym_var_quoting_lit] = STATE(354),
    [sym_sym_val_lit] = STATE(354),
    [sym_evaling_lit] = STATE(354),
    [sym_tagged_or_ctor_lit] = STATE(354),
    [sym_derefing_lit] = STATE(354),
    [sym_quoting_lit] = STATE(354),
    [sym_syn_quoting_lit] = STATE(354),
    [sym_unquote_splicing_lit] = STATE(354),
    [sym_unquoting_lit] = STATE(354),
    [aux_sym_dis_expr_repeat1] = STATE(54),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(624),
    [sym_comment] = ACTIONS(624),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(484),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(484),
    [sym_nil_lit] = ACTIONS(486),
    [sym_bool_lit] = ACTIONS(486),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [87] = {
    [sym__gap] = STATE(139),
    [sym_dis_expr] = STATE(139),
    [sym__form] = STATE(279),
    [sym_kwd_lit] = STATE(279),
    [sym_str_lit] = STATE(279),
    [sym_sym_lit] = STATE(279),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(279),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(279),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(279),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(279),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(279),
    [sym_regex_lit] = STATE(279),
    [sym_read_cond_lit] = STATE(279),
    [sym_splicing_read_cond_lit] = STATE(279),
    [sym_ns_map_lit] = STATE(279),
    [sym_var_quoting_lit] = STATE(279),
    [sym_sym_val_lit] = STATE(279),
    [sym_evaling_lit] = STATE(279),
    [sym_tagged_or_ctor_lit] = STATE(279),
    [sym_derefing_lit] = STATE(279),
    [sym_quoting_lit] = STATE(279),
    [sym_syn_quoting_lit] = STATE(279),
    [sym_unquote_splicing_lit] = STATE(279),
    [sym_unquoting_lit] = STATE(279),
    [aux_sym_dis_expr_repeat1] = STATE(139),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(626),
    [sym_comment] = ACTIONS(626),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(628),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(628),
    [sym_nil_lit] = ACTIONS(630),
    [sym_bool_lit] = ACTIONS(630),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [88] = {
    [sym__gap] = STATE(121),
    [sym_dis_expr] = STATE(121),
    [sym__form] = STATE(375),
    [sym_kwd_lit] = STATE(375),
    [sym_str_lit] = STATE(375),
    [sym_sym_lit] = STATE(375),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(375),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(375),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(375),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(375),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(375),
    [sym_regex_lit] = STATE(375),
    [sym_read_cond_lit] = STATE(375),
    [sym_splicing_read_cond_lit] = STATE(375),
    [sym_ns_map_lit] = STATE(375),
    [sym_var_quoting_lit] = STATE(375),
    [sym_sym_val_lit] = STATE(375),
    [sym_evaling_lit] = STATE(375),
    [sym_tagged_or_ctor_lit] = STATE(375),
    [sym_derefing_lit] = STATE(375),
    [sym_quoting_lit] = STATE(375),
    [sym_syn_quoting_lit] = STATE(375),
    [sym_unquote_splicing_lit] = STATE(375),
    [sym_unquoting_lit] = STATE(375),
    [aux_sym_dis_expr_repeat1] = STATE(121),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(632),
    [sym_comment] = ACTIONS(632),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(522),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(522),
    [sym_nil_lit] = ACTIONS(524),
    [sym_bool_lit] = ACTIONS(524),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [89] = {
    [sym__gap] = STATE(145),
    [sym_dis_expr] = STATE(145),
    [sym__form] = STATE(283),
    [sym_kwd_lit] = STATE(283),
    [sym_str_lit] = STATE(283),
    [sym_sym_lit] = STATE(283),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(283),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(283),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(283),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(283),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(283),
    [sym_regex_lit] = STATE(283),
    [sym_read_cond_lit] = STATE(283),
    [sym_splicing_read_cond_lit] = STATE(283),
    [sym_ns_map_lit] = STATE(283),
    [sym_var_quoting_lit] = STATE(283),
    [sym_sym_val_lit] = STATE(283),
    [sym_evaling_lit] = STATE(283),
    [sym_tagged_or_ctor_lit] = STATE(283),
    [sym_derefing_lit] = STATE(283),
    [sym_quoting_lit] = STATE(283),
    [sym_syn_quoting_lit] = STATE(283),
    [sym_unquote_splicing_lit] = STATE(283),
    [sym_unquoting_lit] = STATE(283),
    [aux_sym_dis_expr_repeat1] = STATE(145),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(634),
    [sym_comment] = ACTIONS(634),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(636),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(636),
    [sym_nil_lit] = ACTIONS(638),
    [sym_bool_lit] = ACTIONS(638),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [90] = {
    [sym__gap] = STATE(147),
    [sym_dis_expr] = STATE(147),
    [sym__form] = STATE(284),
    [sym_kwd_lit] = STATE(284),
    [sym_str_lit] = STATE(284),
    [sym_sym_lit] = STATE(284),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(284),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(284),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(284),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(284),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(284),
    [sym_regex_lit] = STATE(284),
    [sym_read_cond_lit] = STATE(284),
    [sym_splicing_read_cond_lit] = STATE(284),
    [sym_ns_map_lit] = STATE(284),
    [sym_var_quoting_lit] = STATE(284),
    [sym_sym_val_lit] = STATE(284),
    [sym_evaling_lit] = STATE(284),
    [sym_tagged_or_ctor_lit] = STATE(284),
    [sym_derefing_lit] = STATE(284),
    [sym_quoting_lit] = STATE(284),
    [sym_syn_quoting_lit] = STATE(284),
    [sym_unquote_splicing_lit] = STATE(284),
    [sym_unquoting_lit] = STATE(284),
    [aux_sym_dis_expr_repeat1] = STATE(147),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(640),
    [sym_comment] = ACTIONS(640),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(642),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(642),
    [sym_nil_lit] = ACTIONS(644),
    [sym_bool_lit] = ACTIONS(644),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [91] = {
    [sym__gap] = STATE(149),
    [sym_dis_expr] = STATE(149),
    [sym__form] = STATE(285),
    [sym_kwd_lit] = STATE(285),
    [sym_str_lit] = STATE(285),
    [sym_sym_lit] = STATE(285),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(285),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(285),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(285),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(285),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(285),
    [sym_regex_lit] = STATE(285),
    [sym_read_cond_lit] = STATE(285),
    [sym_splicing_read_cond_lit] = STATE(285),
    [sym_ns_map_lit] = STATE(285),
    [sym_var_quoting_lit] = STATE(285),
    [sym_sym_val_lit] = STATE(285),
    [sym_evaling_lit] = STATE(285),
    [sym_tagged_or_ctor_lit] = STATE(285),
    [sym_derefing_lit] = STATE(285),
    [sym_quoting_lit] = STATE(285),
    [sym_syn_quoting_lit] = STATE(285),
    [sym_unquote_splicing_lit] = STATE(285),
    [sym_unquoting_lit] = STATE(285),
    [aux_sym_dis_expr_repeat1] = STATE(149),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(646),
    [sym_comment] = ACTIONS(646),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(648),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(648),
    [sym_nil_lit] = ACTIONS(650),
    [sym_bool_lit] = ACTIONS(650),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [92] = {
    [sym__gap] = STATE(151),
    [sym_dis_expr] = STATE(151),
    [sym__form] = STATE(286),
    [sym_kwd_lit] = STATE(286),
    [sym_str_lit] = STATE(286),
    [sym_sym_lit] = STATE(286),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(286),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(286),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(286),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(286),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(286),
    [sym_regex_lit] = STATE(286),
    [sym_read_cond_lit] = STATE(286),
    [sym_splicing_read_cond_lit] = STATE(286),
    [sym_ns_map_lit] = STATE(286),
    [sym_var_quoting_lit] = STATE(286),
    [sym_sym_val_lit] = STATE(286),
    [sym_evaling_lit] = STATE(286),
    [sym_tagged_or_ctor_lit] = STATE(286),
    [sym_derefing_lit] = STATE(286),
    [sym_quoting_lit] = STATE(286),
    [sym_syn_quoting_lit] = STATE(286),
    [sym_unquote_splicing_lit] = STATE(286),
    [sym_unquoting_lit] = STATE(286),
    [aux_sym_dis_expr_repeat1] = STATE(151),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(652),
    [sym_comment] = ACTIONS(652),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(654),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(654),
    [sym_nil_lit] = ACTIONS(656),
    [sym_bool_lit] = ACTIONS(656),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [93] = {
    [sym__gap] = STATE(153),
    [sym_dis_expr] = STATE(153),
    [sym__form] = STATE(287),
    [sym_kwd_lit] = STATE(287),
    [sym_str_lit] = STATE(287),
    [sym_sym_lit] = STATE(287),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(287),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(287),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(287),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(287),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(287),
    [sym_regex_lit] = STATE(287),
    [sym_read_cond_lit] = STATE(287),
    [sym_splicing_read_cond_lit] = STATE(287),
    [sym_ns_map_lit] = STATE(287),
    [sym_var_quoting_lit] = STATE(287),
    [sym_sym_val_lit] = STATE(287),
    [sym_evaling_lit] = STATE(287),
    [sym_tagged_or_ctor_lit] = STATE(287),
    [sym_derefing_lit] = STATE(287),
    [sym_quoting_lit] = STATE(287),
    [sym_syn_quoting_lit] = STATE(287),
    [sym_unquote_splicing_lit] = STATE(287),
    [sym_unquoting_lit] = STATE(287),
    [aux_sym_dis_expr_repeat1] = STATE(153),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(658),
    [sym_comment] = ACTIONS(658),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(660),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(660),
    [sym_nil_lit] = ACTIONS(662),
    [sym_bool_lit] = ACTIONS(662),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [94] = {
    [sym__gap] = STATE(172),
    [sym_dis_expr] = STATE(172),
    [sym__form] = STATE(234),
    [sym_kwd_lit] = STATE(234),
    [sym_str_lit] = STATE(234),
    [sym_sym_lit] = STATE(234),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(234),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(234),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(234),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(234),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(234),
    [sym_regex_lit] = STATE(234),
    [sym_read_cond_lit] = STATE(234),
    [sym_splicing_read_cond_lit] = STATE(234),
    [sym_ns_map_lit] = STATE(234),
    [sym_var_quoting_lit] = STATE(234),
    [sym_sym_val_lit] = STATE(234),
    [sym_evaling_lit] = STATE(234),
    [sym_tagged_or_ctor_lit] = STATE(234),
    [sym_derefing_lit] = STATE(234),
    [sym_quoting_lit] = STATE(234),
    [sym_syn_quoting_lit] = STATE(234),
    [sym_unquote_splicing_lit] = STATE(234),
    [sym_unquoting_lit] = STATE(234),
    [aux_sym_dis_expr_repeat1] = STATE(172),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(664),
    [sym_comment] = ACTIONS(664),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(666),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(666),
    [sym_nil_lit] = ACTIONS(668),
    [sym_bool_lit] = ACTIONS(668),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [95] = {
    [sym__gap] = STATE(122),
    [sym_dis_expr] = STATE(122),
    [sym__form] = STATE(369),
    [sym_kwd_lit] = STATE(369),
    [sym_str_lit] = STATE(369),
    [sym_sym_lit] = STATE(369),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(369),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(369),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(369),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(369),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(369),
    [sym_regex_lit] = STATE(369),
    [sym_read_cond_lit] = STATE(369),
    [sym_splicing_read_cond_lit] = STATE(369),
    [sym_ns_map_lit] = STATE(369),
    [sym_var_quoting_lit] = STATE(369),
    [sym_sym_val_lit] = STATE(369),
    [sym_evaling_lit] = STATE(369),
    [sym_tagged_or_ctor_lit] = STATE(369),
    [sym_derefing_lit] = STATE(369),
    [sym_quoting_lit] = STATE(369),
    [sym_syn_quoting_lit] = STATE(369),
    [sym_unquote_splicing_lit] = STATE(369),
    [sym_unquoting_lit] = STATE(369),
    [aux_sym_dis_expr_repeat1] = STATE(122),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(670),
    [sym_comment] = ACTIONS(670),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(516),
    [sym_nil_lit] = ACTIONS(518),
    [sym_bool_lit] = ACTIONS(518),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [96] = {
    [sym__gap] = STATE(67),
    [sym_dis_expr] = STATE(67),
    [sym__form] = STATE(367),
    [sym_kwd_lit] = STATE(367),
    [sym_str_lit] = STATE(367),
    [sym_sym_lit] = STATE(367),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(367),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(367),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(367),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(367),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(367),
    [sym_regex_lit] = STATE(367),
    [sym_read_cond_lit] = STATE(367),
    [sym_splicing_read_cond_lit] = STATE(367),
    [sym_ns_map_lit] = STATE(367),
    [sym_var_quoting_lit] = STATE(367),
    [sym_sym_val_lit] = STATE(367),
    [sym_evaling_lit] = STATE(367),
    [sym_tagged_or_ctor_lit] = STATE(367),
    [sym_derefing_lit] = STATE(367),
    [sym_quoting_lit] = STATE(367),
    [sym_syn_quoting_lit] = STATE(367),
    [sym_unquote_splicing_lit] = STATE(367),
    [sym_unquoting_lit] = STATE(367),
    [aux_sym_dis_expr_repeat1] = STATE(67),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(672),
    [sym_comment] = ACTIONS(672),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(510),
    [sym_nil_lit] = ACTIONS(512),
    [sym_bool_lit] = ACTIONS(512),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [97] = {
    [sym__gap] = STATE(36),
    [sym_dis_expr] = STATE(36),
    [sym__form] = STATE(365),
    [sym_kwd_lit] = STATE(365),
    [sym_str_lit] = STATE(365),
    [sym_sym_lit] = STATE(365),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(365),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(365),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(365),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(365),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(365),
    [sym_regex_lit] = STATE(365),
    [sym_read_cond_lit] = STATE(365),
    [sym_splicing_read_cond_lit] = STATE(365),
    [sym_ns_map_lit] = STATE(365),
    [sym_var_quoting_lit] = STATE(365),
    [sym_sym_val_lit] = STATE(365),
    [sym_evaling_lit] = STATE(365),
    [sym_tagged_or_ctor_lit] = STATE(365),
    [sym_derefing_lit] = STATE(365),
    [sym_quoting_lit] = STATE(365),
    [sym_syn_quoting_lit] = STATE(365),
    [sym_unquote_splicing_lit] = STATE(365),
    [sym_unquoting_lit] = STATE(365),
    [aux_sym_dis_expr_repeat1] = STATE(36),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(674),
    [sym_comment] = ACTIONS(674),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(504),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(504),
    [sym_nil_lit] = ACTIONS(506),
    [sym_bool_lit] = ACTIONS(506),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [98] = {
    [sym__gap] = STATE(131),
    [sym_dis_expr] = STATE(131),
    [sym__form] = STATE(363),
    [sym_kwd_lit] = STATE(363),
    [sym_str_lit] = STATE(363),
    [sym_sym_lit] = STATE(363),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(363),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(363),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(363),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(363),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(363),
    [sym_regex_lit] = STATE(363),
    [sym_read_cond_lit] = STATE(363),
    [sym_splicing_read_cond_lit] = STATE(363),
    [sym_ns_map_lit] = STATE(363),
    [sym_var_quoting_lit] = STATE(363),
    [sym_sym_val_lit] = STATE(363),
    [sym_evaling_lit] = STATE(363),
    [sym_tagged_or_ctor_lit] = STATE(363),
    [sym_derefing_lit] = STATE(363),
    [sym_quoting_lit] = STATE(363),
    [sym_syn_quoting_lit] = STATE(363),
    [sym_unquote_splicing_lit] = STATE(363),
    [sym_unquoting_lit] = STATE(363),
    [aux_sym_dis_expr_repeat1] = STATE(131),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(676),
    [sym_comment] = ACTIONS(676),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(450),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(450),
    [sym_nil_lit] = ACTIONS(456),
    [sym_bool_lit] = ACTIONS(456),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [99] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(301),
    [sym_kwd_lit] = STATE(301),
    [sym_str_lit] = STATE(301),
    [sym_sym_lit] = STATE(301),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(301),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(301),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(301),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(301),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(301),
    [sym_regex_lit] = STATE(301),
    [sym_read_cond_lit] = STATE(301),
    [sym_splicing_read_cond_lit] = STATE(301),
    [sym_ns_map_lit] = STATE(301),
    [sym_var_quoting_lit] = STATE(301),
    [sym_sym_val_lit] = STATE(301),
    [sym_evaling_lit] = STATE(301),
    [sym_tagged_or_ctor_lit] = STATE(301),
    [sym_derefing_lit] = STATE(301),
    [sym_quoting_lit] = STATE(301),
    [sym_syn_quoting_lit] = STATE(301),
    [sym_unquote_splicing_lit] = STATE(301),
    [sym_unquoting_lit] = STATE(301),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(678),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(678),
    [sym_nil_lit] = ACTIONS(680),
    [sym_bool_lit] = ACTIONS(680),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [100] = {
    [sym__gap] = STATE(99),
    [sym_dis_expr] = STATE(99),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_dis_expr_repeat1] = STATE(99),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(682),
    [sym_comment] = ACTIONS(682),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(684),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(684),
    [sym_nil_lit] = ACTIONS(686),
    [sym_bool_lit] = ACTIONS(686),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [101] = {
    [sym__gap] = STATE(136),
    [sym_dis_expr] = STATE(136),
    [sym__form] = STATE(361),
    [sym_kwd_lit] = STATE(361),
    [sym_str_lit] = STATE(361),
    [sym_sym_lit] = STATE(361),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(361),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(361),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(361),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(361),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(361),
    [sym_regex_lit] = STATE(361),
    [sym_read_cond_lit] = STATE(361),
    [sym_splicing_read_cond_lit] = STATE(361),
    [sym_ns_map_lit] = STATE(361),
    [sym_var_quoting_lit] = STATE(361),
    [sym_sym_val_lit] = STATE(361),
    [sym_evaling_lit] = STATE(361),
    [sym_tagged_or_ctor_lit] = STATE(361),
    [sym_derefing_lit] = STATE(361),
    [sym_quoting_lit] = STATE(361),
    [sym_syn_quoting_lit] = STATE(361),
    [sym_unquote_splicing_lit] = STATE(361),
    [sym_unquoting_lit] = STATE(361),
    [aux_sym_dis_expr_repeat1] = STATE(136),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(688),
    [sym_comment] = ACTIONS(688),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(496),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(496),
    [sym_nil_lit] = ACTIONS(498),
    [sym_bool_lit] = ACTIONS(498),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [102] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(355),
    [sym_kwd_lit] = STATE(355),
    [sym_str_lit] = STATE(355),
    [sym_sym_lit] = STATE(355),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(355),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(355),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(355),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(355),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(355),
    [sym_regex_lit] = STATE(355),
    [sym_read_cond_lit] = STATE(355),
    [sym_splicing_read_cond_lit] = STATE(355),
    [sym_ns_map_lit] = STATE(355),
    [sym_var_quoting_lit] = STATE(355),
    [sym_sym_val_lit] = STATE(355),
    [sym_evaling_lit] = STATE(355),
    [sym_tagged_or_ctor_lit] = STATE(355),
    [sym_derefing_lit] = STATE(355),
    [sym_quoting_lit] = STATE(355),
    [sym_syn_quoting_lit] = STATE(355),
    [sym_unquote_splicing_lit] = STATE(355),
    [sym_unquoting_lit] = STATE(355),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(490),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(490),
    [sym_nil_lit] = ACTIONS(492),
    [sym_bool_lit] = ACTIONS(492),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [103] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(262),
    [sym_kwd_lit] = STATE(262),
    [sym_str_lit] = STATE(262),
    [sym_sym_lit] = STATE(262),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(262),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(262),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(262),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(262),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(262),
    [sym_regex_lit] = STATE(262),
    [sym_read_cond_lit] = STATE(262),
    [sym_splicing_read_cond_lit] = STATE(262),
    [sym_ns_map_lit] = STATE(262),
    [sym_var_quoting_lit] = STATE(262),
    [sym_sym_val_lit] = STATE(262),
    [sym_evaling_lit] = STATE(262),
    [sym_tagged_or_ctor_lit] = STATE(262),
    [sym_derefing_lit] = STATE(262),
    [sym_quoting_lit] = STATE(262),
    [sym_syn_quoting_lit] = STATE(262),
    [sym_unquote_splicing_lit] = STATE(262),
    [sym_unquoting_lit] = STATE(262),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(690),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(690),
    [sym_nil_lit] = ACTIONS(692),
    [sym_bool_lit] = ACTIONS(692),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [104] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(355),
    [sym_kwd_lit] = STATE(355),
    [sym_str_lit] = STATE(355),
    [sym_sym_lit] = STATE(355),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(355),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(355),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(355),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(355),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(355),
    [sym_regex_lit] = STATE(355),
    [sym_read_cond_lit] = STATE(355),
    [sym_splicing_read_cond_lit] = STATE(355),
    [sym_ns_map_lit] = STATE(355),
    [sym_var_quoting_lit] = STATE(355),
    [sym_sym_val_lit] = STATE(355),
    [sym_evaling_lit] = STATE(355),
    [sym_tagged_or_ctor_lit] = STATE(355),
    [sym_derefing_lit] = STATE(355),
    [sym_quoting_lit] = STATE(355),
    [sym_syn_quoting_lit] = STATE(355),
    [sym_unquote_splicing_lit] = STATE(355),
    [sym_unquoting_lit] = STATE(355),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(490),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(490),
    [sym_nil_lit] = ACTIONS(492),
    [sym_bool_lit] = ACTIONS(492),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [105] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(307),
    [sym_kwd_lit] = STATE(307),
    [sym_str_lit] = STATE(307),
    [sym_sym_lit] = STATE(307),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(307),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(307),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(307),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(307),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(307),
    [sym_regex_lit] = STATE(307),
    [sym_read_cond_lit] = STATE(307),
    [sym_splicing_read_cond_lit] = STATE(307),
    [sym_ns_map_lit] = STATE(307),
    [sym_var_quoting_lit] = STATE(307),
    [sym_sym_val_lit] = STATE(307),
    [sym_evaling_lit] = STATE(307),
    [sym_tagged_or_ctor_lit] = STATE(307),
    [sym_derefing_lit] = STATE(307),
    [sym_quoting_lit] = STATE(307),
    [sym_syn_quoting_lit] = STATE(307),
    [sym_unquote_splicing_lit] = STATE(307),
    [sym_unquoting_lit] = STATE(307),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(694),
    [sym_nil_lit] = ACTIONS(696),
    [sym_bool_lit] = ACTIONS(696),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [106] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(308),
    [sym_kwd_lit] = STATE(308),
    [sym_str_lit] = STATE(308),
    [sym_sym_lit] = STATE(308),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(308),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(308),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(308),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(308),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(308),
    [sym_regex_lit] = STATE(308),
    [sym_read_cond_lit] = STATE(308),
    [sym_splicing_read_cond_lit] = STATE(308),
    [sym_ns_map_lit] = STATE(308),
    [sym_var_quoting_lit] = STATE(308),
    [sym_sym_val_lit] = STATE(308),
    [sym_evaling_lit] = STATE(308),
    [sym_tagged_or_ctor_lit] = STATE(308),
    [sym_derefing_lit] = STATE(308),
    [sym_quoting_lit] = STATE(308),
    [sym_syn_quoting_lit] = STATE(308),
    [sym_unquote_splicing_lit] = STATE(308),
    [sym_unquoting_lit] = STATE(308),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(698),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(698),
    [sym_nil_lit] = ACTIONS(700),
    [sym_bool_lit] = ACTIONS(700),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [107] = {
    [sym__gap] = STATE(39),
    [sym_dis_expr] = STATE(39),
    [sym__form] = STATE(234),
    [sym_kwd_lit] = STATE(234),
    [sym_str_lit] = STATE(234),
    [sym_sym_lit] = STATE(234),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(234),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(234),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(234),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(234),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(234),
    [sym_regex_lit] = STATE(234),
    [sym_read_cond_lit] = STATE(234),
    [sym_splicing_read_cond_lit] = STATE(234),
    [sym_ns_map_lit] = STATE(234),
    [sym_var_quoting_lit] = STATE(234),
    [sym_sym_val_lit] = STATE(234),
    [sym_evaling_lit] = STATE(234),
    [sym_tagged_or_ctor_lit] = STATE(234),
    [sym_derefing_lit] = STATE(234),
    [sym_quoting_lit] = STATE(234),
    [sym_syn_quoting_lit] = STATE(234),
    [sym_unquote_splicing_lit] = STATE(234),
    [sym_unquoting_lit] = STATE(234),
    [aux_sym_dis_expr_repeat1] = STATE(39),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(702),
    [sym_comment] = ACTIONS(702),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(666),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(666),
    [sym_nil_lit] = ACTIONS(668),
    [sym_bool_lit] = ACTIONS(668),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [108] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(309),
    [sym_kwd_lit] = STATE(309),
    [sym_str_lit] = STATE(309),
    [sym_sym_lit] = STATE(309),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(309),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(309),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(309),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(309),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(309),
    [sym_regex_lit] = STATE(309),
    [sym_read_cond_lit] = STATE(309),
    [sym_splicing_read_cond_lit] = STATE(309),
    [sym_ns_map_lit] = STATE(309),
    [sym_var_quoting_lit] = STATE(309),
    [sym_sym_val_lit] = STATE(309),
    [sym_evaling_lit] = STATE(309),
    [sym_tagged_or_ctor_lit] = STATE(309),
    [sym_derefing_lit] = STATE(309),
    [sym_quoting_lit] = STATE(309),
    [sym_syn_quoting_lit] = STATE(309),
    [sym_unquote_splicing_lit] = STATE(309),
    [sym_unquoting_lit] = STATE(309),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(704),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(704),
    [sym_nil_lit] = ACTIONS(706),
    [sym_bool_lit] = ACTIONS(706),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [109] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(310),
    [sym_kwd_lit] = STATE(310),
    [sym_str_lit] = STATE(310),
    [sym_sym_lit] = STATE(310),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(310),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(310),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(310),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(310),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(310),
    [sym_regex_lit] = STATE(310),
    [sym_read_cond_lit] = STATE(310),
    [sym_splicing_read_cond_lit] = STATE(310),
    [sym_ns_map_lit] = STATE(310),
    [sym_var_quoting_lit] = STATE(310),
    [sym_sym_val_lit] = STATE(310),
    [sym_evaling_lit] = STATE(310),
    [sym_tagged_or_ctor_lit] = STATE(310),
    [sym_derefing_lit] = STATE(310),
    [sym_quoting_lit] = STATE(310),
    [sym_syn_quoting_lit] = STATE(310),
    [sym_unquote_splicing_lit] = STATE(310),
    [sym_unquoting_lit] = STATE(310),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(708),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(708),
    [sym_nil_lit] = ACTIONS(710),
    [sym_bool_lit] = ACTIONS(710),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [110] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(311),
    [sym_kwd_lit] = STATE(311),
    [sym_str_lit] = STATE(311),
    [sym_sym_lit] = STATE(311),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(311),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(311),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(311),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(311),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(311),
    [sym_regex_lit] = STATE(311),
    [sym_read_cond_lit] = STATE(311),
    [sym_splicing_read_cond_lit] = STATE(311),
    [sym_ns_map_lit] = STATE(311),
    [sym_var_quoting_lit] = STATE(311),
    [sym_sym_val_lit] = STATE(311),
    [sym_evaling_lit] = STATE(311),
    [sym_tagged_or_ctor_lit] = STATE(311),
    [sym_derefing_lit] = STATE(311),
    [sym_quoting_lit] = STATE(311),
    [sym_syn_quoting_lit] = STATE(311),
    [sym_unquote_splicing_lit] = STATE(311),
    [sym_unquoting_lit] = STATE(311),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(712),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(712),
    [sym_nil_lit] = ACTIONS(714),
    [sym_bool_lit] = ACTIONS(714),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [111] = {
    [sym__gap] = STATE(64),
    [sym_dis_expr] = STATE(64),
    [sym__form] = STATE(243),
    [sym_kwd_lit] = STATE(243),
    [sym_str_lit] = STATE(243),
    [sym_sym_lit] = STATE(243),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(243),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(243),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(243),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(243),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(243),
    [sym_regex_lit] = STATE(243),
    [sym_read_cond_lit] = STATE(243),
    [sym_splicing_read_cond_lit] = STATE(243),
    [sym_ns_map_lit] = STATE(243),
    [sym_var_quoting_lit] = STATE(243),
    [sym_sym_val_lit] = STATE(243),
    [sym_evaling_lit] = STATE(243),
    [sym_tagged_or_ctor_lit] = STATE(243),
    [sym_derefing_lit] = STATE(243),
    [sym_quoting_lit] = STATE(243),
    [sym_syn_quoting_lit] = STATE(243),
    [sym_unquote_splicing_lit] = STATE(243),
    [sym_unquoting_lit] = STATE(243),
    [aux_sym_dis_expr_repeat1] = STATE(64),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(716),
    [sym_comment] = ACTIONS(716),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(718),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(718),
    [sym_nil_lit] = ACTIONS(720),
    [sym_bool_lit] = ACTIONS(720),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [112] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(333),
    [sym_kwd_lit] = STATE(333),
    [sym_str_lit] = STATE(333),
    [sym_sym_lit] = STATE(333),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(333),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(333),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(333),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(333),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(333),
    [sym_regex_lit] = STATE(333),
    [sym_read_cond_lit] = STATE(333),
    [sym_splicing_read_cond_lit] = STATE(333),
    [sym_ns_map_lit] = STATE(333),
    [sym_var_quoting_lit] = STATE(333),
    [sym_sym_val_lit] = STATE(333),
    [sym_evaling_lit] = STATE(333),
    [sym_tagged_or_ctor_lit] = STATE(333),
    [sym_derefing_lit] = STATE(333),
    [sym_quoting_lit] = STATE(333),
    [sym_syn_quoting_lit] = STATE(333),
    [sym_unquote_splicing_lit] = STATE(333),
    [sym_unquoting_lit] = STATE(333),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(544),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(544),
    [sym_nil_lit] = ACTIONS(546),
    [sym_bool_lit] = ACTIONS(546),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [113] = {
    [sym__gap] = STATE(21),
    [sym_dis_expr] = STATE(21),
    [sym__form] = STATE(361),
    [sym_kwd_lit] = STATE(361),
    [sym_str_lit] = STATE(361),
    [sym_sym_lit] = STATE(361),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(361),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(361),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(361),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(361),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(361),
    [sym_regex_lit] = STATE(361),
    [sym_read_cond_lit] = STATE(361),
    [sym_splicing_read_cond_lit] = STATE(361),
    [sym_ns_map_lit] = STATE(361),
    [sym_var_quoting_lit] = STATE(361),
    [sym_sym_val_lit] = STATE(361),
    [sym_evaling_lit] = STATE(361),
    [sym_tagged_or_ctor_lit] = STATE(361),
    [sym_derefing_lit] = STATE(361),
    [sym_quoting_lit] = STATE(361),
    [sym_syn_quoting_lit] = STATE(361),
    [sym_unquote_splicing_lit] = STATE(361),
    [sym_unquoting_lit] = STATE(361),
    [aux_sym_dis_expr_repeat1] = STATE(21),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(722),
    [sym_comment] = ACTIONS(722),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(496),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(496),
    [sym_nil_lit] = ACTIONS(498),
    [sym_bool_lit] = ACTIONS(498),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [114] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(312),
    [sym_kwd_lit] = STATE(312),
    [sym_str_lit] = STATE(312),
    [sym_sym_lit] = STATE(312),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(312),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(312),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(312),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(312),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(312),
    [sym_regex_lit] = STATE(312),
    [sym_read_cond_lit] = STATE(312),
    [sym_splicing_read_cond_lit] = STATE(312),
    [sym_ns_map_lit] = STATE(312),
    [sym_var_quoting_lit] = STATE(312),
    [sym_sym_val_lit] = STATE(312),
    [sym_evaling_lit] = STATE(312),
    [sym_tagged_or_ctor_lit] = STATE(312),
    [sym_derefing_lit] = STATE(312),
    [sym_quoting_lit] = STATE(312),
    [sym_syn_quoting_lit] = STATE(312),
    [sym_unquote_splicing_lit] = STATE(312),
    [sym_unquoting_lit] = STATE(312),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(724),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(724),
    [sym_nil_lit] = ACTIONS(726),
    [sym_bool_lit] = ACTIONS(726),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [115] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(291),
    [sym_kwd_lit] = STATE(291),
    [sym_str_lit] = STATE(291),
    [sym_sym_lit] = STATE(291),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(291),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(291),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(291),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(291),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(291),
    [sym_regex_lit] = STATE(291),
    [sym_read_cond_lit] = STATE(291),
    [sym_splicing_read_cond_lit] = STATE(291),
    [sym_ns_map_lit] = STATE(291),
    [sym_var_quoting_lit] = STATE(291),
    [sym_sym_val_lit] = STATE(291),
    [sym_evaling_lit] = STATE(291),
    [sym_tagged_or_ctor_lit] = STATE(291),
    [sym_derefing_lit] = STATE(291),
    [sym_quoting_lit] = STATE(291),
    [sym_syn_quoting_lit] = STATE(291),
    [sym_unquote_splicing_lit] = STATE(291),
    [sym_unquoting_lit] = STATE(291),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(728),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(728),
    [sym_nil_lit] = ACTIONS(730),
    [sym_bool_lit] = ACTIONS(730),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [116] = {
    [sym__gap] = STATE(159),
    [sym_dis_expr] = STATE(159),
    [sym__form] = STATE(292),
    [sym_kwd_lit] = STATE(292),
    [sym_str_lit] = STATE(292),
    [sym_sym_lit] = STATE(292),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(292),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(292),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(292),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(292),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(292),
    [sym_regex_lit] = STATE(292),
    [sym_read_cond_lit] = STATE(292),
    [sym_splicing_read_cond_lit] = STATE(292),
    [sym_ns_map_lit] = STATE(292),
    [sym_var_quoting_lit] = STATE(292),
    [sym_sym_val_lit] = STATE(292),
    [sym_evaling_lit] = STATE(292),
    [sym_tagged_or_ctor_lit] = STATE(292),
    [sym_derefing_lit] = STATE(292),
    [sym_quoting_lit] = STATE(292),
    [sym_syn_quoting_lit] = STATE(292),
    [sym_unquote_splicing_lit] = STATE(292),
    [sym_unquoting_lit] = STATE(292),
    [aux_sym_dis_expr_repeat1] = STATE(159),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(732),
    [sym_comment] = ACTIONS(732),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(734),
    [sym_nil_lit] = ACTIONS(736),
    [sym_bool_lit] = ACTIONS(736),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [117] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(300),
    [sym_kwd_lit] = STATE(300),
    [sym_str_lit] = STATE(300),
    [sym_sym_lit] = STATE(300),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(300),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(300),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(300),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(300),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(300),
    [sym_regex_lit] = STATE(300),
    [sym_read_cond_lit] = STATE(300),
    [sym_splicing_read_cond_lit] = STATE(300),
    [sym_ns_map_lit] = STATE(300),
    [sym_var_quoting_lit] = STATE(300),
    [sym_sym_val_lit] = STATE(300),
    [sym_evaling_lit] = STATE(300),
    [sym_tagged_or_ctor_lit] = STATE(300),
    [sym_derefing_lit] = STATE(300),
    [sym_quoting_lit] = STATE(300),
    [sym_syn_quoting_lit] = STATE(300),
    [sym_unquote_splicing_lit] = STATE(300),
    [sym_unquoting_lit] = STATE(300),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(738),
    [sym_nil_lit] = ACTIONS(740),
    [sym_bool_lit] = ACTIONS(740),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [118] = {
    [sym__gap] = STATE(58),
    [sym_dis_expr] = STATE(58),
    [sym__form] = STATE(363),
    [sym_kwd_lit] = STATE(363),
    [sym_str_lit] = STATE(363),
    [sym_sym_lit] = STATE(363),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(363),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(363),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(363),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(363),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(363),
    [sym_regex_lit] = STATE(363),
    [sym_read_cond_lit] = STATE(363),
    [sym_splicing_read_cond_lit] = STATE(363),
    [sym_ns_map_lit] = STATE(363),
    [sym_var_quoting_lit] = STATE(363),
    [sym_sym_val_lit] = STATE(363),
    [sym_evaling_lit] = STATE(363),
    [sym_tagged_or_ctor_lit] = STATE(363),
    [sym_derefing_lit] = STATE(363),
    [sym_quoting_lit] = STATE(363),
    [sym_syn_quoting_lit] = STATE(363),
    [sym_unquote_splicing_lit] = STATE(363),
    [sym_unquoting_lit] = STATE(363),
    [aux_sym_dis_expr_repeat1] = STATE(58),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(742),
    [sym_comment] = ACTIONS(742),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(450),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(450),
    [sym_nil_lit] = ACTIONS(456),
    [sym_bool_lit] = ACTIONS(456),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [119] = {
    [sym__gap] = STATE(146),
    [sym_dis_expr] = STATE(146),
    [sym__form] = STATE(354),
    [sym_kwd_lit] = STATE(354),
    [sym_str_lit] = STATE(354),
    [sym_sym_lit] = STATE(354),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(354),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(354),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(354),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(354),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(354),
    [sym_regex_lit] = STATE(354),
    [sym_read_cond_lit] = STATE(354),
    [sym_splicing_read_cond_lit] = STATE(354),
    [sym_ns_map_lit] = STATE(354),
    [sym_var_quoting_lit] = STATE(354),
    [sym_sym_val_lit] = STATE(354),
    [sym_evaling_lit] = STATE(354),
    [sym_tagged_or_ctor_lit] = STATE(354),
    [sym_derefing_lit] = STATE(354),
    [sym_quoting_lit] = STATE(354),
    [sym_syn_quoting_lit] = STATE(354),
    [sym_unquote_splicing_lit] = STATE(354),
    [sym_unquoting_lit] = STATE(354),
    [aux_sym_dis_expr_repeat1] = STATE(146),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(744),
    [sym_comment] = ACTIONS(744),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(484),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(484),
    [sym_nil_lit] = ACTIONS(486),
    [sym_bool_lit] = ACTIONS(486),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [120] = {
    [sym__gap] = STATE(148),
    [sym_dis_expr] = STATE(148),
    [sym__form] = STATE(349),
    [sym_kwd_lit] = STATE(349),
    [sym_str_lit] = STATE(349),
    [sym_sym_lit] = STATE(349),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(349),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(349),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(349),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(349),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(349),
    [sym_regex_lit] = STATE(349),
    [sym_read_cond_lit] = STATE(349),
    [sym_splicing_read_cond_lit] = STATE(349),
    [sym_ns_map_lit] = STATE(349),
    [sym_var_quoting_lit] = STATE(349),
    [sym_sym_val_lit] = STATE(349),
    [sym_evaling_lit] = STATE(349),
    [sym_tagged_or_ctor_lit] = STATE(349),
    [sym_derefing_lit] = STATE(349),
    [sym_quoting_lit] = STATE(349),
    [sym_syn_quoting_lit] = STATE(349),
    [sym_unquote_splicing_lit] = STATE(349),
    [sym_unquoting_lit] = STATE(349),
    [aux_sym_dis_expr_repeat1] = STATE(148),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(746),
    [sym_comment] = ACTIONS(746),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(478),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(478),
    [sym_nil_lit] = ACTIONS(480),
    [sym_bool_lit] = ACTIONS(480),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [121] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(343),
    [sym_kwd_lit] = STATE(343),
    [sym_str_lit] = STATE(343),
    [sym_sym_lit] = STATE(343),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(343),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(343),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(343),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(343),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(343),
    [sym_regex_lit] = STATE(343),
    [sym_read_cond_lit] = STATE(343),
    [sym_splicing_read_cond_lit] = STATE(343),
    [sym_ns_map_lit] = STATE(343),
    [sym_var_quoting_lit] = STATE(343),
    [sym_sym_val_lit] = STATE(343),
    [sym_evaling_lit] = STATE(343),
    [sym_tagged_or_ctor_lit] = STATE(343),
    [sym_derefing_lit] = STATE(343),
    [sym_quoting_lit] = STATE(343),
    [sym_syn_quoting_lit] = STATE(343),
    [sym_unquote_splicing_lit] = STATE(343),
    [sym_unquoting_lit] = STATE(343),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(472),
    [sym_nil_lit] = ACTIONS(474),
    [sym_bool_lit] = ACTIONS(474),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [122] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(357),
    [sym_kwd_lit] = STATE(357),
    [sym_str_lit] = STATE(357),
    [sym_sym_lit] = STATE(357),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(357),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(357),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(357),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(357),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(357),
    [sym_regex_lit] = STATE(357),
    [sym_read_cond_lit] = STATE(357),
    [sym_splicing_read_cond_lit] = STATE(357),
    [sym_ns_map_lit] = STATE(357),
    [sym_var_quoting_lit] = STATE(357),
    [sym_sym_val_lit] = STATE(357),
    [sym_evaling_lit] = STATE(357),
    [sym_tagged_or_ctor_lit] = STATE(357),
    [sym_derefing_lit] = STATE(357),
    [sym_quoting_lit] = STATE(357),
    [sym_syn_quoting_lit] = STATE(357),
    [sym_unquote_splicing_lit] = STATE(357),
    [sym_unquoting_lit] = STATE(357),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(440),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(440),
    [sym_nil_lit] = ACTIONS(442),
    [sym_bool_lit] = ACTIONS(442),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [123] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(398),
    [sym_kwd_lit] = STATE(398),
    [sym_str_lit] = STATE(398),
    [sym_sym_lit] = STATE(398),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(398),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(398),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(398),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(398),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(398),
    [sym_regex_lit] = STATE(398),
    [sym_read_cond_lit] = STATE(398),
    [sym_splicing_read_cond_lit] = STATE(398),
    [sym_ns_map_lit] = STATE(398),
    [sym_var_quoting_lit] = STATE(398),
    [sym_sym_val_lit] = STATE(398),
    [sym_evaling_lit] = STATE(398),
    [sym_tagged_or_ctor_lit] = STATE(398),
    [sym_derefing_lit] = STATE(398),
    [sym_quoting_lit] = STATE(398),
    [sym_syn_quoting_lit] = STATE(398),
    [sym_unquote_splicing_lit] = STATE(398),
    [sym_unquoting_lit] = STATE(398),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(266),
    [sym_nil_lit] = ACTIONS(276),
    [sym_bool_lit] = ACTIONS(276),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [124] = {
    [sym__gap] = STATE(182),
    [sym_dis_expr] = STATE(182),
    [sym__form] = STATE(340),
    [sym_kwd_lit] = STATE(340),
    [sym_str_lit] = STATE(340),
    [sym_sym_lit] = STATE(340),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(340),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(340),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(340),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(340),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(340),
    [sym_regex_lit] = STATE(340),
    [sym_read_cond_lit] = STATE(340),
    [sym_splicing_read_cond_lit] = STATE(340),
    [sym_ns_map_lit] = STATE(340),
    [sym_var_quoting_lit] = STATE(340),
    [sym_sym_val_lit] = STATE(340),
    [sym_evaling_lit] = STATE(340),
    [sym_tagged_or_ctor_lit] = STATE(340),
    [sym_derefing_lit] = STATE(340),
    [sym_quoting_lit] = STATE(340),
    [sym_syn_quoting_lit] = STATE(340),
    [sym_unquote_splicing_lit] = STATE(340),
    [sym_unquoting_lit] = STATE(340),
    [aux_sym_dis_expr_repeat1] = STATE(182),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(748),
    [sym_comment] = ACTIONS(748),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(618),
    [sym_nil_lit] = ACTIONS(620),
    [sym_bool_lit] = ACTIONS(620),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [125] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(386),
    [sym_kwd_lit] = STATE(386),
    [sym_str_lit] = STATE(386),
    [sym_sym_lit] = STATE(386),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(386),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(386),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(386),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(386),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(386),
    [sym_regex_lit] = STATE(386),
    [sym_read_cond_lit] = STATE(386),
    [sym_splicing_read_cond_lit] = STATE(386),
    [sym_ns_map_lit] = STATE(386),
    [sym_var_quoting_lit] = STATE(386),
    [sym_sym_val_lit] = STATE(386),
    [sym_evaling_lit] = STATE(386),
    [sym_tagged_or_ctor_lit] = STATE(386),
    [sym_derefing_lit] = STATE(386),
    [sym_quoting_lit] = STATE(386),
    [sym_syn_quoting_lit] = STATE(386),
    [sym_unquote_splicing_lit] = STATE(386),
    [sym_unquoting_lit] = STATE(386),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(324),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(414),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(414),
    [sym_nil_lit] = ACTIONS(420),
    [sym_bool_lit] = ACTIONS(420),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(318),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [anon_sym_TILDE_AT] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(328),
  },
  [126] = {
    [sym__gap] = STATE(105),
    [sym_dis_expr] = STATE(105),
    [sym__form] = STATE(292),
    [sym_kwd_lit] = STATE(292),
    [sym_str_lit] = STATE(292),
    [sym_sym_lit] = STATE(292),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(292),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(292),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(292),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(292),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(292),
    [sym_regex_lit] = STATE(292),
    [sym_read_cond_lit] = STATE(292),
    [sym_splicing_read_cond_lit] = STATE(292),
    [sym_ns_map_lit] = STATE(292),
    [sym_var_quoting_lit] = STATE(292),
    [sym_sym_val_lit] = STATE(292),
    [sym_evaling_lit] = STATE(292),
    [sym_tagged_or_ctor_lit] = STATE(292),
    [sym_derefing_lit] = STATE(292),
    [sym_quoting_lit] = STATE(292),
    [sym_syn_quoting_lit] = STATE(292),
    [sym_unquote_splicing_lit] = STATE(292),
    [sym_unquoting_lit] = STATE(292),
    [aux_sym_dis_expr_repeat1] = STATE(105),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(750),
    [sym_comment] = ACTIONS(750),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(734),
    [sym_nil_lit] = ACTIONS(736),
    [sym_bool_lit] = ACTIONS(736),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [127] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(291),
    [sym_kwd_lit] = STATE(291),
    [sym_str_lit] = STATE(291),
    [sym_sym_lit] = STATE(291),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(291),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(291),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(291),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(291),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(291),
    [sym_regex_lit] = STATE(291),
    [sym_read_cond_lit] = STATE(291),
    [sym_splicing_read_cond_lit] = STATE(291),
    [sym_ns_map_lit] = STATE(291),
    [sym_var_quoting_lit] = STATE(291),
    [sym_sym_val_lit] = STATE(291),
    [sym_evaling_lit] = STATE(291),
    [sym_tagged_or_ctor_lit] = STATE(291),
    [sym_derefing_lit] = STATE(291),
    [sym_quoting_lit] = STATE(291),
    [sym_syn_quoting_lit] = STATE(291),
    [sym_unquote_splicing_lit] = STATE(291),
    [sym_unquoting_lit] = STATE(291),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(728),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(728),
    [sym_nil_lit] = ACTIONS(730),
    [sym_bool_lit] = ACTIONS(730),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [128] = {
    [sym__gap] = STATE(60),
    [sym_dis_expr] = STATE(60),
    [sym__form] = STATE(365),
    [sym_kwd_lit] = STATE(365),
    [sym_str_lit] = STATE(365),
    [sym_sym_lit] = STATE(365),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(365),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(365),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(365),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(365),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(365),
    [sym_regex_lit] = STATE(365),
    [sym_read_cond_lit] = STATE(365),
    [sym_splicing_read_cond_lit] = STATE(365),
    [sym_ns_map_lit] = STATE(365),
    [sym_var_quoting_lit] = STATE(365),
    [sym_sym_val_lit] = STATE(365),
    [sym_evaling_lit] = STATE(365),
    [sym_tagged_or_ctor_lit] = STATE(365),
    [sym_derefing_lit] = STATE(365),
    [sym_quoting_lit] = STATE(365),
    [sym_syn_quoting_lit] = STATE(365),
    [sym_unquote_splicing_lit] = STATE(365),
    [sym_unquoting_lit] = STATE(365),
    [aux_sym_dis_expr_repeat1] = STATE(60),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(752),
    [sym_comment] = ACTIONS(752),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(504),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(504),
    [sym_nil_lit] = ACTIONS(506),
    [sym_bool_lit] = ACTIONS(506),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [129] = {
    [sym__gap] = STATE(62),
    [sym_dis_expr] = STATE(62),
    [sym__form] = STATE(367),
    [sym_kwd_lit] = STATE(367),
    [sym_str_lit] = STATE(367),
    [sym_sym_lit] = STATE(367),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(367),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(367),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(367),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(367),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(367),
    [sym_regex_lit] = STATE(367),
    [sym_read_cond_lit] = STATE(367),
    [sym_splicing_read_cond_lit] = STATE(367),
    [sym_ns_map_lit] = STATE(367),
    [sym_var_quoting_lit] = STATE(367),
    [sym_sym_val_lit] = STATE(367),
    [sym_evaling_lit] = STATE(367),
    [sym_tagged_or_ctor_lit] = STATE(367),
    [sym_derefing_lit] = STATE(367),
    [sym_quoting_lit] = STATE(367),
    [sym_syn_quoting_lit] = STATE(367),
    [sym_unquote_splicing_lit] = STATE(367),
    [sym_unquoting_lit] = STATE(367),
    [aux_sym_dis_expr_repeat1] = STATE(62),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(754),
    [sym_comment] = ACTIONS(754),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(510),
    [sym_nil_lit] = ACTIONS(512),
    [sym_bool_lit] = ACTIONS(512),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [130] = {
    [sym__gap] = STATE(164),
    [sym_dis_expr] = STATE(164),
    [sym__form] = STATE(295),
    [sym_kwd_lit] = STATE(295),
    [sym_str_lit] = STATE(295),
    [sym_sym_lit] = STATE(295),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(295),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(295),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(295),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(295),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(295),
    [sym_regex_lit] = STATE(295),
    [sym_read_cond_lit] = STATE(295),
    [sym_splicing_read_cond_lit] = STATE(295),
    [sym_ns_map_lit] = STATE(295),
    [sym_var_quoting_lit] = STATE(295),
    [sym_sym_val_lit] = STATE(295),
    [sym_evaling_lit] = STATE(295),
    [sym_tagged_or_ctor_lit] = STATE(295),
    [sym_derefing_lit] = STATE(295),
    [sym_quoting_lit] = STATE(295),
    [sym_syn_quoting_lit] = STATE(295),
    [sym_unquote_splicing_lit] = STATE(295),
    [sym_unquoting_lit] = STATE(295),
    [aux_sym_dis_expr_repeat1] = STATE(164),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(756),
    [sym_comment] = ACTIONS(756),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(388),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(388),
    [sym_nil_lit] = ACTIONS(394),
    [sym_bool_lit] = ACTIONS(394),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [131] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(397),
    [sym_kwd_lit] = STATE(397),
    [sym_str_lit] = STATE(397),
    [sym_sym_lit] = STATE(397),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(397),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(397),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(397),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(397),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(397),
    [sym_regex_lit] = STATE(397),
    [sym_read_cond_lit] = STATE(397),
    [sym_splicing_read_cond_lit] = STATE(397),
    [sym_ns_map_lit] = STATE(397),
    [sym_var_quoting_lit] = STATE(397),
    [sym_sym_val_lit] = STATE(397),
    [sym_evaling_lit] = STATE(397),
    [sym_tagged_or_ctor_lit] = STATE(397),
    [sym_derefing_lit] = STATE(397),
    [sym_quoting_lit] = STATE(397),
    [sym_syn_quoting_lit] = STATE(397),
    [sym_unquote_splicing_lit] = STATE(397),
    [sym_unquoting_lit] = STATE(397),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(410),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(410),
    [sym_nil_lit] = ACTIONS(412),
    [sym_bool_lit] = ACTIONS(412),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [132] = {
    [sym__gap] = STATE(66),
    [sym_dis_expr] = STATE(66),
    [sym__form] = STATE(369),
    [sym_kwd_lit] = STATE(369),
    [sym_str_lit] = STATE(369),
    [sym_sym_lit] = STATE(369),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(369),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(369),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(369),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(369),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(369),
    [sym_regex_lit] = STATE(369),
    [sym_read_cond_lit] = STATE(369),
    [sym_splicing_read_cond_lit] = STATE(369),
    [sym_ns_map_lit] = STATE(369),
    [sym_var_quoting_lit] = STATE(369),
    [sym_sym_val_lit] = STATE(369),
    [sym_evaling_lit] = STATE(369),
    [sym_tagged_or_ctor_lit] = STATE(369),
    [sym_derefing_lit] = STATE(369),
    [sym_quoting_lit] = STATE(369),
    [sym_syn_quoting_lit] = STATE(369),
    [sym_unquote_splicing_lit] = STATE(369),
    [sym_unquoting_lit] = STATE(369),
    [aux_sym_dis_expr_repeat1] = STATE(66),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(758),
    [sym_comment] = ACTIONS(758),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(516),
    [sym_nil_lit] = ACTIONS(518),
    [sym_bool_lit] = ACTIONS(518),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [133] = {
    [sym__gap] = STATE(183),
    [sym_dis_expr] = STATE(183),
    [sym__form] = STATE(429),
    [sym_kwd_lit] = STATE(429),
    [sym_str_lit] = STATE(429),
    [sym_sym_lit] = STATE(429),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(429),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(429),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(429),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(429),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(429),
    [sym_regex_lit] = STATE(429),
    [sym_read_cond_lit] = STATE(429),
    [sym_splicing_read_cond_lit] = STATE(429),
    [sym_ns_map_lit] = STATE(429),
    [sym_var_quoting_lit] = STATE(429),
    [sym_sym_val_lit] = STATE(429),
    [sym_evaling_lit] = STATE(429),
    [sym_tagged_or_ctor_lit] = STATE(429),
    [sym_derefing_lit] = STATE(429),
    [sym_quoting_lit] = STATE(429),
    [sym_syn_quoting_lit] = STATE(429),
    [sym_unquote_splicing_lit] = STATE(429),
    [sym_unquoting_lit] = STATE(429),
    [aux_sym_dis_expr_repeat1] = STATE(183),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(760),
    [sym_comment] = ACTIONS(760),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(612),
    [sym_nil_lit] = ACTIONS(614),
    [sym_bool_lit] = ACTIONS(614),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [134] = {
    [sym__gap] = STATE(112),
    [sym_dis_expr] = STATE(112),
    [sym__form] = STATE(428),
    [sym_kwd_lit] = STATE(428),
    [sym_str_lit] = STATE(428),
    [sym_sym_lit] = STATE(428),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(428),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(428),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(428),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(428),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(428),
    [sym_regex_lit] = STATE(428),
    [sym_read_cond_lit] = STATE(428),
    [sym_splicing_read_cond_lit] = STATE(428),
    [sym_ns_map_lit] = STATE(428),
    [sym_var_quoting_lit] = STATE(428),
    [sym_sym_val_lit] = STATE(428),
    [sym_evaling_lit] = STATE(428),
    [sym_tagged_or_ctor_lit] = STATE(428),
    [sym_derefing_lit] = STATE(428),
    [sym_quoting_lit] = STATE(428),
    [sym_syn_quoting_lit] = STATE(428),
    [sym_unquote_splicing_lit] = STATE(428),
    [sym_unquoting_lit] = STATE(428),
    [aux_sym_dis_expr_repeat1] = STATE(112),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(762),
    [sym_comment] = ACTIONS(762),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(602),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(602),
    [sym_nil_lit] = ACTIONS(604),
    [sym_bool_lit] = ACTIONS(604),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [135] = {
    [sym__gap] = STATE(69),
    [sym_dis_expr] = STATE(69),
    [sym__form] = STATE(375),
    [sym_kwd_lit] = STATE(375),
    [sym_str_lit] = STATE(375),
    [sym_sym_lit] = STATE(375),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(375),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(375),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(375),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(375),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(375),
    [sym_regex_lit] = STATE(375),
    [sym_read_cond_lit] = STATE(375),
    [sym_splicing_read_cond_lit] = STATE(375),
    [sym_ns_map_lit] = STATE(375),
    [sym_var_quoting_lit] = STATE(375),
    [sym_sym_val_lit] = STATE(375),
    [sym_evaling_lit] = STATE(375),
    [sym_tagged_or_ctor_lit] = STATE(375),
    [sym_derefing_lit] = STATE(375),
    [sym_quoting_lit] = STATE(375),
    [sym_syn_quoting_lit] = STATE(375),
    [sym_unquote_splicing_lit] = STATE(375),
    [sym_unquoting_lit] = STATE(375),
    [aux_sym_dis_expr_repeat1] = STATE(69),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(764),
    [sym_comment] = ACTIONS(764),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(522),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(522),
    [sym_nil_lit] = ACTIONS(524),
    [sym_bool_lit] = ACTIONS(524),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [136] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(398),
    [sym_kwd_lit] = STATE(398),
    [sym_str_lit] = STATE(398),
    [sym_sym_lit] = STATE(398),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(398),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(398),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(398),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(398),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(398),
    [sym_regex_lit] = STATE(398),
    [sym_read_cond_lit] = STATE(398),
    [sym_splicing_read_cond_lit] = STATE(398),
    [sym_ns_map_lit] = STATE(398),
    [sym_var_quoting_lit] = STATE(398),
    [sym_sym_val_lit] = STATE(398),
    [sym_evaling_lit] = STATE(398),
    [sym_tagged_or_ctor_lit] = STATE(398),
    [sym_derefing_lit] = STATE(398),
    [sym_quoting_lit] = STATE(398),
    [sym_syn_quoting_lit] = STATE(398),
    [sym_unquote_splicing_lit] = STATE(398),
    [sym_unquoting_lit] = STATE(398),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(266),
    [sym_nil_lit] = ACTIONS(276),
    [sym_bool_lit] = ACTIONS(276),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [137] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(379),
    [sym_kwd_lit] = STATE(379),
    [sym_str_lit] = STATE(379),
    [sym_sym_lit] = STATE(379),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(379),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(379),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(379),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(379),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(379),
    [sym_regex_lit] = STATE(379),
    [sym_read_cond_lit] = STATE(379),
    [sym_splicing_read_cond_lit] = STATE(379),
    [sym_ns_map_lit] = STATE(379),
    [sym_var_quoting_lit] = STATE(379),
    [sym_sym_val_lit] = STATE(379),
    [sym_evaling_lit] = STATE(379),
    [sym_tagged_or_ctor_lit] = STATE(379),
    [sym_derefing_lit] = STATE(379),
    [sym_quoting_lit] = STATE(379),
    [sym_syn_quoting_lit] = STATE(379),
    [sym_unquote_splicing_lit] = STATE(379),
    [sym_unquoting_lit] = STATE(379),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(532),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(532),
    [sym_nil_lit] = ACTIONS(534),
    [sym_bool_lit] = ACTIONS(534),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [138] = {
    [sym__gap] = STATE(106),
    [sym_dis_expr] = STATE(106),
    [sym__form] = STATE(287),
    [sym_kwd_lit] = STATE(287),
    [sym_str_lit] = STATE(287),
    [sym_sym_lit] = STATE(287),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(287),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(287),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(287),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(287),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(287),
    [sym_regex_lit] = STATE(287),
    [sym_read_cond_lit] = STATE(287),
    [sym_splicing_read_cond_lit] = STATE(287),
    [sym_ns_map_lit] = STATE(287),
    [sym_var_quoting_lit] = STATE(287),
    [sym_sym_val_lit] = STATE(287),
    [sym_evaling_lit] = STATE(287),
    [sym_tagged_or_ctor_lit] = STATE(287),
    [sym_derefing_lit] = STATE(287),
    [sym_quoting_lit] = STATE(287),
    [sym_syn_quoting_lit] = STATE(287),
    [sym_unquote_splicing_lit] = STATE(287),
    [sym_unquoting_lit] = STATE(287),
    [aux_sym_dis_expr_repeat1] = STATE(106),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(766),
    [sym_comment] = ACTIONS(766),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(660),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(660),
    [sym_nil_lit] = ACTIONS(662),
    [sym_bool_lit] = ACTIONS(662),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [139] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(300),
    [sym_kwd_lit] = STATE(300),
    [sym_str_lit] = STATE(300),
    [sym_sym_lit] = STATE(300),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(300),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(300),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(300),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(300),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(300),
    [sym_regex_lit] = STATE(300),
    [sym_read_cond_lit] = STATE(300),
    [sym_splicing_read_cond_lit] = STATE(300),
    [sym_ns_map_lit] = STATE(300),
    [sym_var_quoting_lit] = STATE(300),
    [sym_sym_val_lit] = STATE(300),
    [sym_evaling_lit] = STATE(300),
    [sym_tagged_or_ctor_lit] = STATE(300),
    [sym_derefing_lit] = STATE(300),
    [sym_quoting_lit] = STATE(300),
    [sym_syn_quoting_lit] = STATE(300),
    [sym_unquote_splicing_lit] = STATE(300),
    [sym_unquoting_lit] = STATE(300),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(738),
    [sym_nil_lit] = ACTIONS(740),
    [sym_bool_lit] = ACTIONS(740),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [140] = {
    [sym__gap] = STATE(108),
    [sym_dis_expr] = STATE(108),
    [sym__form] = STATE(286),
    [sym_kwd_lit] = STATE(286),
    [sym_str_lit] = STATE(286),
    [sym_sym_lit] = STATE(286),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(286),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(286),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(286),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(286),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(286),
    [sym_regex_lit] = STATE(286),
    [sym_read_cond_lit] = STATE(286),
    [sym_splicing_read_cond_lit] = STATE(286),
    [sym_ns_map_lit] = STATE(286),
    [sym_var_quoting_lit] = STATE(286),
    [sym_sym_val_lit] = STATE(286),
    [sym_evaling_lit] = STATE(286),
    [sym_tagged_or_ctor_lit] = STATE(286),
    [sym_derefing_lit] = STATE(286),
    [sym_quoting_lit] = STATE(286),
    [sym_syn_quoting_lit] = STATE(286),
    [sym_unquote_splicing_lit] = STATE(286),
    [sym_unquoting_lit] = STATE(286),
    [aux_sym_dis_expr_repeat1] = STATE(108),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(768),
    [sym_comment] = ACTIONS(768),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(654),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(654),
    [sym_nil_lit] = ACTIONS(656),
    [sym_bool_lit] = ACTIONS(656),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [141] = {
    [sym__gap] = STATE(109),
    [sym_dis_expr] = STATE(109),
    [sym__form] = STATE(285),
    [sym_kwd_lit] = STATE(285),
    [sym_str_lit] = STATE(285),
    [sym_sym_lit] = STATE(285),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(285),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(285),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(285),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(285),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(285),
    [sym_regex_lit] = STATE(285),
    [sym_read_cond_lit] = STATE(285),
    [sym_splicing_read_cond_lit] = STATE(285),
    [sym_ns_map_lit] = STATE(285),
    [sym_var_quoting_lit] = STATE(285),
    [sym_sym_val_lit] = STATE(285),
    [sym_evaling_lit] = STATE(285),
    [sym_tagged_or_ctor_lit] = STATE(285),
    [sym_derefing_lit] = STATE(285),
    [sym_quoting_lit] = STATE(285),
    [sym_syn_quoting_lit] = STATE(285),
    [sym_unquote_splicing_lit] = STATE(285),
    [sym_unquoting_lit] = STATE(285),
    [aux_sym_dis_expr_repeat1] = STATE(109),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(770),
    [sym_comment] = ACTIONS(770),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(648),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(648),
    [sym_nil_lit] = ACTIONS(650),
    [sym_bool_lit] = ACTIONS(650),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [142] = {
    [sym__gap] = STATE(110),
    [sym_dis_expr] = STATE(110),
    [sym__form] = STATE(284),
    [sym_kwd_lit] = STATE(284),
    [sym_str_lit] = STATE(284),
    [sym_sym_lit] = STATE(284),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(284),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(284),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(284),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(284),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(284),
    [sym_regex_lit] = STATE(284),
    [sym_read_cond_lit] = STATE(284),
    [sym_splicing_read_cond_lit] = STATE(284),
    [sym_ns_map_lit] = STATE(284),
    [sym_var_quoting_lit] = STATE(284),
    [sym_sym_val_lit] = STATE(284),
    [sym_evaling_lit] = STATE(284),
    [sym_tagged_or_ctor_lit] = STATE(284),
    [sym_derefing_lit] = STATE(284),
    [sym_quoting_lit] = STATE(284),
    [sym_syn_quoting_lit] = STATE(284),
    [sym_unquote_splicing_lit] = STATE(284),
    [sym_unquoting_lit] = STATE(284),
    [aux_sym_dis_expr_repeat1] = STATE(110),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(772),
    [sym_comment] = ACTIONS(772),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(642),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(642),
    [sym_nil_lit] = ACTIONS(644),
    [sym_bool_lit] = ACTIONS(644),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [143] = {
    [sym__gap] = STATE(114),
    [sym_dis_expr] = STATE(114),
    [sym__form] = STATE(283),
    [sym_kwd_lit] = STATE(283),
    [sym_str_lit] = STATE(283),
    [sym_sym_lit] = STATE(283),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(283),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(283),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(283),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(283),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(283),
    [sym_regex_lit] = STATE(283),
    [sym_read_cond_lit] = STATE(283),
    [sym_splicing_read_cond_lit] = STATE(283),
    [sym_ns_map_lit] = STATE(283),
    [sym_var_quoting_lit] = STATE(283),
    [sym_sym_val_lit] = STATE(283),
    [sym_evaling_lit] = STATE(283),
    [sym_tagged_or_ctor_lit] = STATE(283),
    [sym_derefing_lit] = STATE(283),
    [sym_quoting_lit] = STATE(283),
    [sym_syn_quoting_lit] = STATE(283),
    [sym_unquote_splicing_lit] = STATE(283),
    [sym_unquoting_lit] = STATE(283),
    [aux_sym_dis_expr_repeat1] = STATE(114),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(774),
    [sym_comment] = ACTIONS(774),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(636),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(636),
    [sym_nil_lit] = ACTIONS(638),
    [sym_bool_lit] = ACTIONS(638),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [144] = {
    [sym__gap] = STATE(117),
    [sym_dis_expr] = STATE(117),
    [sym__form] = STATE(279),
    [sym_kwd_lit] = STATE(279),
    [sym_str_lit] = STATE(279),
    [sym_sym_lit] = STATE(279),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(279),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(279),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(279),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(279),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(279),
    [sym_regex_lit] = STATE(279),
    [sym_read_cond_lit] = STATE(279),
    [sym_splicing_read_cond_lit] = STATE(279),
    [sym_ns_map_lit] = STATE(279),
    [sym_var_quoting_lit] = STATE(279),
    [sym_sym_val_lit] = STATE(279),
    [sym_evaling_lit] = STATE(279),
    [sym_tagged_or_ctor_lit] = STATE(279),
    [sym_derefing_lit] = STATE(279),
    [sym_quoting_lit] = STATE(279),
    [sym_syn_quoting_lit] = STATE(279),
    [sym_unquote_splicing_lit] = STATE(279),
    [sym_unquoting_lit] = STATE(279),
    [aux_sym_dis_expr_repeat1] = STATE(117),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(776),
    [sym_comment] = ACTIONS(776),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(628),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(628),
    [sym_nil_lit] = ACTIONS(630),
    [sym_bool_lit] = ACTIONS(630),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [145] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(312),
    [sym_kwd_lit] = STATE(312),
    [sym_str_lit] = STATE(312),
    [sym_sym_lit] = STATE(312),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(312),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(312),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(312),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(312),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(312),
    [sym_regex_lit] = STATE(312),
    [sym_read_cond_lit] = STATE(312),
    [sym_splicing_read_cond_lit] = STATE(312),
    [sym_ns_map_lit] = STATE(312),
    [sym_var_quoting_lit] = STATE(312),
    [sym_sym_val_lit] = STATE(312),
    [sym_evaling_lit] = STATE(312),
    [sym_tagged_or_ctor_lit] = STATE(312),
    [sym_derefing_lit] = STATE(312),
    [sym_quoting_lit] = STATE(312),
    [sym_syn_quoting_lit] = STATE(312),
    [sym_unquote_splicing_lit] = STATE(312),
    [sym_unquoting_lit] = STATE(312),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(724),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(724),
    [sym_nil_lit] = ACTIONS(726),
    [sym_bool_lit] = ACTIONS(726),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [146] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(399),
    [sym_kwd_lit] = STATE(399),
    [sym_str_lit] = STATE(399),
    [sym_sym_lit] = STATE(399),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(399),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(399),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(399),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(399),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(399),
    [sym_regex_lit] = STATE(399),
    [sym_read_cond_lit] = STATE(399),
    [sym_splicing_read_cond_lit] = STATE(399),
    [sym_ns_map_lit] = STATE(399),
    [sym_var_quoting_lit] = STATE(399),
    [sym_sym_val_lit] = STATE(399),
    [sym_evaling_lit] = STATE(399),
    [sym_tagged_or_ctor_lit] = STATE(399),
    [sym_derefing_lit] = STATE(399),
    [sym_quoting_lit] = STATE(399),
    [sym_syn_quoting_lit] = STATE(399),
    [sym_unquote_splicing_lit] = STATE(399),
    [sym_unquoting_lit] = STATE(399),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(382),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(382),
    [sym_nil_lit] = ACTIONS(384),
    [sym_bool_lit] = ACTIONS(384),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [147] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(311),
    [sym_kwd_lit] = STATE(311),
    [sym_str_lit] = STATE(311),
    [sym_sym_lit] = STATE(311),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(311),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(311),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(311),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(311),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(311),
    [sym_regex_lit] = STATE(311),
    [sym_read_cond_lit] = STATE(311),
    [sym_splicing_read_cond_lit] = STATE(311),
    [sym_ns_map_lit] = STATE(311),
    [sym_var_quoting_lit] = STATE(311),
    [sym_sym_val_lit] = STATE(311),
    [sym_evaling_lit] = STATE(311),
    [sym_tagged_or_ctor_lit] = STATE(311),
    [sym_derefing_lit] = STATE(311),
    [sym_quoting_lit] = STATE(311),
    [sym_syn_quoting_lit] = STATE(311),
    [sym_unquote_splicing_lit] = STATE(311),
    [sym_unquoting_lit] = STATE(311),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(712),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(712),
    [sym_nil_lit] = ACTIONS(714),
    [sym_bool_lit] = ACTIONS(714),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [148] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(427),
    [sym_kwd_lit] = STATE(427),
    [sym_str_lit] = STATE(427),
    [sym_sym_lit] = STATE(427),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(427),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(427),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(427),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(427),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(427),
    [sym_regex_lit] = STATE(427),
    [sym_read_cond_lit] = STATE(427),
    [sym_splicing_read_cond_lit] = STATE(427),
    [sym_ns_map_lit] = STATE(427),
    [sym_var_quoting_lit] = STATE(427),
    [sym_sym_val_lit] = STATE(427),
    [sym_evaling_lit] = STATE(427),
    [sym_tagged_or_ctor_lit] = STATE(427),
    [sym_derefing_lit] = STATE(427),
    [sym_quoting_lit] = STATE(427),
    [sym_syn_quoting_lit] = STATE(427),
    [sym_unquote_splicing_lit] = STATE(427),
    [sym_unquoting_lit] = STATE(427),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(378),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(378),
    [sym_nil_lit] = ACTIONS(380),
    [sym_bool_lit] = ACTIONS(380),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [149] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(310),
    [sym_kwd_lit] = STATE(310),
    [sym_str_lit] = STATE(310),
    [sym_sym_lit] = STATE(310),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(310),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(310),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(310),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(310),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(310),
    [sym_regex_lit] = STATE(310),
    [sym_read_cond_lit] = STATE(310),
    [sym_splicing_read_cond_lit] = STATE(310),
    [sym_ns_map_lit] = STATE(310),
    [sym_var_quoting_lit] = STATE(310),
    [sym_sym_val_lit] = STATE(310),
    [sym_evaling_lit] = STATE(310),
    [sym_tagged_or_ctor_lit] = STATE(310),
    [sym_derefing_lit] = STATE(310),
    [sym_quoting_lit] = STATE(310),
    [sym_syn_quoting_lit] = STATE(310),
    [sym_unquote_splicing_lit] = STATE(310),
    [sym_unquoting_lit] = STATE(310),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(708),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(708),
    [sym_nil_lit] = ACTIONS(710),
    [sym_bool_lit] = ACTIONS(710),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [150] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(275),
    [sym_kwd_lit] = STATE(275),
    [sym_str_lit] = STATE(275),
    [sym_sym_lit] = STATE(275),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(275),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(275),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(275),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(275),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(275),
    [sym_regex_lit] = STATE(275),
    [sym_read_cond_lit] = STATE(275),
    [sym_splicing_read_cond_lit] = STATE(275),
    [sym_ns_map_lit] = STATE(275),
    [sym_var_quoting_lit] = STATE(275),
    [sym_sym_val_lit] = STATE(275),
    [sym_evaling_lit] = STATE(275),
    [sym_tagged_or_ctor_lit] = STATE(275),
    [sym_derefing_lit] = STATE(275),
    [sym_quoting_lit] = STATE(275),
    [sym_syn_quoting_lit] = STATE(275),
    [sym_unquote_splicing_lit] = STATE(275),
    [sym_unquoting_lit] = STATE(275),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(606),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(606),
    [sym_nil_lit] = ACTIONS(608),
    [sym_bool_lit] = ACTIONS(608),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [151] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(309),
    [sym_kwd_lit] = STATE(309),
    [sym_str_lit] = STATE(309),
    [sym_sym_lit] = STATE(309),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(309),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(309),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(309),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(309),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(309),
    [sym_regex_lit] = STATE(309),
    [sym_read_cond_lit] = STATE(309),
    [sym_splicing_read_cond_lit] = STATE(309),
    [sym_ns_map_lit] = STATE(309),
    [sym_var_quoting_lit] = STATE(309),
    [sym_sym_val_lit] = STATE(309),
    [sym_evaling_lit] = STATE(309),
    [sym_tagged_or_ctor_lit] = STATE(309),
    [sym_derefing_lit] = STATE(309),
    [sym_quoting_lit] = STATE(309),
    [sym_syn_quoting_lit] = STATE(309),
    [sym_unquote_splicing_lit] = STATE(309),
    [sym_unquoting_lit] = STATE(309),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(704),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(704),
    [sym_nil_lit] = ACTIONS(706),
    [sym_bool_lit] = ACTIONS(706),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [152] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(274),
    [sym_kwd_lit] = STATE(274),
    [sym_str_lit] = STATE(274),
    [sym_sym_lit] = STATE(274),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(274),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(274),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(274),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(274),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(274),
    [sym_regex_lit] = STATE(274),
    [sym_read_cond_lit] = STATE(274),
    [sym_splicing_read_cond_lit] = STATE(274),
    [sym_ns_map_lit] = STATE(274),
    [sym_var_quoting_lit] = STATE(274),
    [sym_sym_val_lit] = STATE(274),
    [sym_evaling_lit] = STATE(274),
    [sym_tagged_or_ctor_lit] = STATE(274),
    [sym_derefing_lit] = STATE(274),
    [sym_quoting_lit] = STATE(274),
    [sym_syn_quoting_lit] = STATE(274),
    [sym_unquote_splicing_lit] = STATE(274),
    [sym_unquoting_lit] = STATE(274),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(596),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(596),
    [sym_nil_lit] = ACTIONS(598),
    [sym_bool_lit] = ACTIONS(598),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [153] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(308),
    [sym_kwd_lit] = STATE(308),
    [sym_str_lit] = STATE(308),
    [sym_sym_lit] = STATE(308),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(308),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(308),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(308),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(308),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(308),
    [sym_regex_lit] = STATE(308),
    [sym_read_cond_lit] = STATE(308),
    [sym_splicing_read_cond_lit] = STATE(308),
    [sym_ns_map_lit] = STATE(308),
    [sym_var_quoting_lit] = STATE(308),
    [sym_sym_val_lit] = STATE(308),
    [sym_evaling_lit] = STATE(308),
    [sym_tagged_or_ctor_lit] = STATE(308),
    [sym_derefing_lit] = STATE(308),
    [sym_quoting_lit] = STATE(308),
    [sym_syn_quoting_lit] = STATE(308),
    [sym_unquote_splicing_lit] = STATE(308),
    [sym_unquoting_lit] = STATE(308),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(698),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(698),
    [sym_nil_lit] = ACTIONS(700),
    [sym_bool_lit] = ACTIONS(700),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [154] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(273),
    [sym_kwd_lit] = STATE(273),
    [sym_str_lit] = STATE(273),
    [sym_sym_lit] = STATE(273),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(273),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(273),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(273),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(273),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(273),
    [sym_regex_lit] = STATE(273),
    [sym_read_cond_lit] = STATE(273),
    [sym_splicing_read_cond_lit] = STATE(273),
    [sym_ns_map_lit] = STATE(273),
    [sym_var_quoting_lit] = STATE(273),
    [sym_sym_val_lit] = STATE(273),
    [sym_evaling_lit] = STATE(273),
    [sym_tagged_or_ctor_lit] = STATE(273),
    [sym_derefing_lit] = STATE(273),
    [sym_quoting_lit] = STATE(273),
    [sym_syn_quoting_lit] = STATE(273),
    [sym_unquote_splicing_lit] = STATE(273),
    [sym_unquoting_lit] = STATE(273),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(586),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(586),
    [sym_nil_lit] = ACTIONS(588),
    [sym_bool_lit] = ACTIONS(588),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [155] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(272),
    [sym_kwd_lit] = STATE(272),
    [sym_str_lit] = STATE(272),
    [sym_sym_lit] = STATE(272),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(272),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(272),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(272),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(272),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(272),
    [sym_regex_lit] = STATE(272),
    [sym_read_cond_lit] = STATE(272),
    [sym_splicing_read_cond_lit] = STATE(272),
    [sym_ns_map_lit] = STATE(272),
    [sym_var_quoting_lit] = STATE(272),
    [sym_sym_val_lit] = STATE(272),
    [sym_evaling_lit] = STATE(272),
    [sym_tagged_or_ctor_lit] = STATE(272),
    [sym_derefing_lit] = STATE(272),
    [sym_quoting_lit] = STATE(272),
    [sym_syn_quoting_lit] = STATE(272),
    [sym_unquote_splicing_lit] = STATE(272),
    [sym_unquoting_lit] = STATE(272),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(576),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(576),
    [sym_nil_lit] = ACTIONS(578),
    [sym_bool_lit] = ACTIONS(578),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [156] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(271),
    [sym_kwd_lit] = STATE(271),
    [sym_str_lit] = STATE(271),
    [sym_sym_lit] = STATE(271),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(271),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(271),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(271),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(271),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(271),
    [sym_regex_lit] = STATE(271),
    [sym_read_cond_lit] = STATE(271),
    [sym_splicing_read_cond_lit] = STATE(271),
    [sym_ns_map_lit] = STATE(271),
    [sym_var_quoting_lit] = STATE(271),
    [sym_sym_val_lit] = STATE(271),
    [sym_evaling_lit] = STATE(271),
    [sym_tagged_or_ctor_lit] = STATE(271),
    [sym_derefing_lit] = STATE(271),
    [sym_quoting_lit] = STATE(271),
    [sym_syn_quoting_lit] = STATE(271),
    [sym_unquote_splicing_lit] = STATE(271),
    [sym_unquoting_lit] = STATE(271),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(566),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(566),
    [sym_nil_lit] = ACTIONS(568),
    [sym_bool_lit] = ACTIONS(568),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [157] = {
    [sym__gap] = STATE(160),
    [sym_dis_expr] = STATE(160),
    [sym__form] = STATE(421),
    [sym_kwd_lit] = STATE(421),
    [sym_str_lit] = STATE(421),
    [sym_sym_lit] = STATE(421),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(421),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(421),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(421),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(421),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(421),
    [sym_regex_lit] = STATE(421),
    [sym_read_cond_lit] = STATE(421),
    [sym_splicing_read_cond_lit] = STATE(421),
    [sym_ns_map_lit] = STATE(421),
    [sym_var_quoting_lit] = STATE(421),
    [sym_sym_val_lit] = STATE(421),
    [sym_evaling_lit] = STATE(421),
    [sym_tagged_or_ctor_lit] = STATE(421),
    [sym_derefing_lit] = STATE(421),
    [sym_quoting_lit] = STATE(421),
    [sym_syn_quoting_lit] = STATE(421),
    [sym_unquote_splicing_lit] = STATE(421),
    [sym_unquoting_lit] = STATE(421),
    [aux_sym_dis_expr_repeat1] = STATE(160),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(778),
    [sym_comment] = ACTIONS(778),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(374),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(374),
    [sym_nil_lit] = ACTIONS(376),
    [sym_bool_lit] = ACTIONS(376),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [158] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(268),
    [sym_kwd_lit] = STATE(268),
    [sym_str_lit] = STATE(268),
    [sym_sym_lit] = STATE(268),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(268),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(268),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(268),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(268),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(268),
    [sym_regex_lit] = STATE(268),
    [sym_read_cond_lit] = STATE(268),
    [sym_splicing_read_cond_lit] = STATE(268),
    [sym_ns_map_lit] = STATE(268),
    [sym_var_quoting_lit] = STATE(268),
    [sym_sym_val_lit] = STATE(268),
    [sym_evaling_lit] = STATE(268),
    [sym_tagged_or_ctor_lit] = STATE(268),
    [sym_derefing_lit] = STATE(268),
    [sym_quoting_lit] = STATE(268),
    [sym_syn_quoting_lit] = STATE(268),
    [sym_unquote_splicing_lit] = STATE(268),
    [sym_unquoting_lit] = STATE(268),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(548),
    [sym_nil_lit] = ACTIONS(550),
    [sym_bool_lit] = ACTIONS(550),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [159] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(307),
    [sym_kwd_lit] = STATE(307),
    [sym_str_lit] = STATE(307),
    [sym_sym_lit] = STATE(307),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(307),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(307),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(307),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(307),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(307),
    [sym_regex_lit] = STATE(307),
    [sym_read_cond_lit] = STATE(307),
    [sym_splicing_read_cond_lit] = STATE(307),
    [sym_ns_map_lit] = STATE(307),
    [sym_var_quoting_lit] = STATE(307),
    [sym_sym_val_lit] = STATE(307),
    [sym_evaling_lit] = STATE(307),
    [sym_tagged_or_ctor_lit] = STATE(307),
    [sym_derefing_lit] = STATE(307),
    [sym_quoting_lit] = STATE(307),
    [sym_syn_quoting_lit] = STATE(307),
    [sym_unquote_splicing_lit] = STATE(307),
    [sym_unquoting_lit] = STATE(307),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(694),
    [sym_nil_lit] = ACTIONS(696),
    [sym_bool_lit] = ACTIONS(696),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [160] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(393),
    [sym_kwd_lit] = STATE(393),
    [sym_str_lit] = STATE(393),
    [sym_sym_lit] = STATE(393),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(393),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(393),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(393),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(393),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(393),
    [sym_regex_lit] = STATE(393),
    [sym_read_cond_lit] = STATE(393),
    [sym_splicing_read_cond_lit] = STATE(393),
    [sym_ns_map_lit] = STATE(393),
    [sym_var_quoting_lit] = STATE(393),
    [sym_sym_val_lit] = STATE(393),
    [sym_evaling_lit] = STATE(393),
    [sym_tagged_or_ctor_lit] = STATE(393),
    [sym_derefing_lit] = STATE(393),
    [sym_quoting_lit] = STATE(393),
    [sym_syn_quoting_lit] = STATE(393),
    [sym_unquote_splicing_lit] = STATE(393),
    [sym_unquoting_lit] = STATE(393),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(368),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(368),
    [sym_nil_lit] = ACTIONS(370),
    [sym_bool_lit] = ACTIONS(370),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [161] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(348),
    [sym_kwd_lit] = STATE(348),
    [sym_str_lit] = STATE(348),
    [sym_sym_lit] = STATE(348),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(348),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(348),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(348),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(348),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(348),
    [sym_regex_lit] = STATE(348),
    [sym_read_cond_lit] = STATE(348),
    [sym_splicing_read_cond_lit] = STATE(348),
    [sym_ns_map_lit] = STATE(348),
    [sym_var_quoting_lit] = STATE(348),
    [sym_sym_val_lit] = STATE(348),
    [sym_evaling_lit] = STATE(348),
    [sym_tagged_or_ctor_lit] = STATE(348),
    [sym_derefing_lit] = STATE(348),
    [sym_quoting_lit] = STATE(348),
    [sym_syn_quoting_lit] = STATE(348),
    [sym_unquote_splicing_lit] = STATE(348),
    [sym_unquoting_lit] = STATE(348),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(780),
    [sym_comment] = ACTIONS(780),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(332),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(332),
    [sym_nil_lit] = ACTIONS(334),
    [sym_bool_lit] = ACTIONS(334),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [162] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(382),
    [sym_kwd_lit] = STATE(382),
    [sym_str_lit] = STATE(382),
    [sym_sym_lit] = STATE(382),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(382),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(382),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(382),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(382),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(382),
    [sym_regex_lit] = STATE(382),
    [sym_read_cond_lit] = STATE(382),
    [sym_splicing_read_cond_lit] = STATE(382),
    [sym_ns_map_lit] = STATE(382),
    [sym_var_quoting_lit] = STATE(382),
    [sym_sym_val_lit] = STATE(382),
    [sym_evaling_lit] = STATE(382),
    [sym_tagged_or_ctor_lit] = STATE(382),
    [sym_derefing_lit] = STATE(382),
    [sym_quoting_lit] = STATE(382),
    [sym_syn_quoting_lit] = STATE(382),
    [sym_unquote_splicing_lit] = STATE(382),
    [sym_unquoting_lit] = STATE(382),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(536),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(536),
    [sym_nil_lit] = ACTIONS(538),
    [sym_bool_lit] = ACTIONS(538),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [163] = {
    [sym__gap] = STATE(127),
    [sym_dis_expr] = STATE(127),
    [sym__form] = STATE(265),
    [sym_kwd_lit] = STATE(265),
    [sym_str_lit] = STATE(265),
    [sym_sym_lit] = STATE(265),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(265),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(265),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(265),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(265),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(265),
    [sym_regex_lit] = STATE(265),
    [sym_read_cond_lit] = STATE(265),
    [sym_splicing_read_cond_lit] = STATE(265),
    [sym_ns_map_lit] = STATE(265),
    [sym_var_quoting_lit] = STATE(265),
    [sym_sym_val_lit] = STATE(265),
    [sym_evaling_lit] = STATE(265),
    [sym_tagged_or_ctor_lit] = STATE(265),
    [sym_derefing_lit] = STATE(265),
    [sym_quoting_lit] = STATE(265),
    [sym_syn_quoting_lit] = STATE(265),
    [sym_unquote_splicing_lit] = STATE(265),
    [sym_unquoting_lit] = STATE(265),
    [aux_sym_dis_expr_repeat1] = STATE(127),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(782),
    [sym_comment] = ACTIONS(782),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(528),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(528),
    [sym_nil_lit] = ACTIONS(530),
    [sym_bool_lit] = ACTIONS(530),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [164] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(262),
    [sym_kwd_lit] = STATE(262),
    [sym_str_lit] = STATE(262),
    [sym_sym_lit] = STATE(262),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(262),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(262),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(262),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(262),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(262),
    [sym_regex_lit] = STATE(262),
    [sym_read_cond_lit] = STATE(262),
    [sym_splicing_read_cond_lit] = STATE(262),
    [sym_ns_map_lit] = STATE(262),
    [sym_var_quoting_lit] = STATE(262),
    [sym_sym_val_lit] = STATE(262),
    [sym_evaling_lit] = STATE(262),
    [sym_tagged_or_ctor_lit] = STATE(262),
    [sym_derefing_lit] = STATE(262),
    [sym_quoting_lit] = STATE(262),
    [sym_syn_quoting_lit] = STATE(262),
    [sym_unquote_splicing_lit] = STATE(262),
    [sym_unquoting_lit] = STATE(262),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(690),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(690),
    [sym_nil_lit] = ACTIONS(692),
    [sym_bool_lit] = ACTIONS(692),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [165] = {
    [sym__gap] = STATE(82),
    [sym_dis_expr] = STATE(82),
    [sym__form] = STATE(426),
    [sym_kwd_lit] = STATE(426),
    [sym_str_lit] = STATE(426),
    [sym_sym_lit] = STATE(426),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(426),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(426),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(426),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(426),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(426),
    [sym_regex_lit] = STATE(426),
    [sym_read_cond_lit] = STATE(426),
    [sym_splicing_read_cond_lit] = STATE(426),
    [sym_ns_map_lit] = STATE(426),
    [sym_var_quoting_lit] = STATE(426),
    [sym_sym_val_lit] = STATE(426),
    [sym_evaling_lit] = STATE(426),
    [sym_tagged_or_ctor_lit] = STATE(426),
    [sym_derefing_lit] = STATE(426),
    [sym_quoting_lit] = STATE(426),
    [sym_syn_quoting_lit] = STATE(426),
    [sym_unquote_splicing_lit] = STATE(426),
    [sym_unquoting_lit] = STATE(426),
    [aux_sym_dis_expr_repeat1] = STATE(82),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(784),
    [sym_comment] = ACTIONS(784),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(592),
    [sym_nil_lit] = ACTIONS(594),
    [sym_bool_lit] = ACTIONS(594),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [166] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(383),
    [sym_kwd_lit] = STATE(383),
    [sym_str_lit] = STATE(383),
    [sym_sym_lit] = STATE(383),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(383),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(383),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(383),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(383),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(383),
    [sym_regex_lit] = STATE(383),
    [sym_read_cond_lit] = STATE(383),
    [sym_splicing_read_cond_lit] = STATE(383),
    [sym_ns_map_lit] = STATE(383),
    [sym_var_quoting_lit] = STATE(383),
    [sym_sym_val_lit] = STATE(383),
    [sym_evaling_lit] = STATE(383),
    [sym_tagged_or_ctor_lit] = STATE(383),
    [sym_derefing_lit] = STATE(383),
    [sym_quoting_lit] = STATE(383),
    [sym_syn_quoting_lit] = STATE(383),
    [sym_unquote_splicing_lit] = STATE(383),
    [sym_unquoting_lit] = STATE(383),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(540),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(540),
    [sym_nil_lit] = ACTIONS(542),
    [sym_bool_lit] = ACTIONS(542),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [167] = {
    [sym__gap] = STATE(184),
    [sym_dis_expr] = STATE(184),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_dis_expr_repeat1] = STATE(184),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(786),
    [sym_comment] = ACTIONS(786),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(684),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(684),
    [sym_nil_lit] = ACTIONS(686),
    [sym_bool_lit] = ACTIONS(686),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [168] = {
    [sym__gap] = STATE(83),
    [sym_dis_expr] = STATE(83),
    [sym__form] = STATE(425),
    [sym_kwd_lit] = STATE(425),
    [sym_str_lit] = STATE(425),
    [sym_sym_lit] = STATE(425),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(425),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(425),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(425),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(425),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(425),
    [sym_regex_lit] = STATE(425),
    [sym_read_cond_lit] = STATE(425),
    [sym_splicing_read_cond_lit] = STATE(425),
    [sym_ns_map_lit] = STATE(425),
    [sym_var_quoting_lit] = STATE(425),
    [sym_sym_val_lit] = STATE(425),
    [sym_evaling_lit] = STATE(425),
    [sym_tagged_or_ctor_lit] = STATE(425),
    [sym_derefing_lit] = STATE(425),
    [sym_quoting_lit] = STATE(425),
    [sym_syn_quoting_lit] = STATE(425),
    [sym_unquote_splicing_lit] = STATE(425),
    [sym_unquoting_lit] = STATE(425),
    [aux_sym_dis_expr_repeat1] = STATE(83),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(788),
    [sym_comment] = ACTIONS(788),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(582),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(582),
    [sym_nil_lit] = ACTIONS(584),
    [sym_bool_lit] = ACTIONS(584),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [169] = {
    [sym__gap] = STATE(84),
    [sym_dis_expr] = STATE(84),
    [sym__form] = STATE(420),
    [sym_kwd_lit] = STATE(420),
    [sym_str_lit] = STATE(420),
    [sym_sym_lit] = STATE(420),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(420),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(420),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(420),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(420),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(420),
    [sym_regex_lit] = STATE(420),
    [sym_read_cond_lit] = STATE(420),
    [sym_splicing_read_cond_lit] = STATE(420),
    [sym_ns_map_lit] = STATE(420),
    [sym_var_quoting_lit] = STATE(420),
    [sym_sym_val_lit] = STATE(420),
    [sym_evaling_lit] = STATE(420),
    [sym_tagged_or_ctor_lit] = STATE(420),
    [sym_derefing_lit] = STATE(420),
    [sym_quoting_lit] = STATE(420),
    [sym_syn_quoting_lit] = STATE(420),
    [sym_unquote_splicing_lit] = STATE(420),
    [sym_unquoting_lit] = STATE(420),
    [aux_sym_dis_expr_repeat1] = STATE(84),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(790),
    [sym_comment] = ACTIONS(790),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(572),
    [sym_nil_lit] = ACTIONS(574),
    [sym_bool_lit] = ACTIONS(574),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [170] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(412),
    [sym_kwd_lit] = STATE(412),
    [sym_str_lit] = STATE(412),
    [sym_sym_lit] = STATE(412),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(412),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(412),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(412),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(412),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(412),
    [sym_regex_lit] = STATE(412),
    [sym_read_cond_lit] = STATE(412),
    [sym_splicing_read_cond_lit] = STATE(412),
    [sym_ns_map_lit] = STATE(412),
    [sym_var_quoting_lit] = STATE(412),
    [sym_sym_val_lit] = STATE(412),
    [sym_evaling_lit] = STATE(412),
    [sym_tagged_or_ctor_lit] = STATE(412),
    [sym_derefing_lit] = STATE(412),
    [sym_quoting_lit] = STATE(412),
    [sym_syn_quoting_lit] = STATE(412),
    [sym_unquote_splicing_lit] = STATE(412),
    [sym_unquoting_lit] = STATE(412),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(562),
    [sym_nil_lit] = ACTIONS(564),
    [sym_bool_lit] = ACTIONS(564),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [171] = {
    [sym__gap] = STATE(218),
    [sym_dis_expr] = STATE(218),
    [sym__form] = STATE(340),
    [sym_kwd_lit] = STATE(340),
    [sym_str_lit] = STATE(340),
    [sym_sym_lit] = STATE(340),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(340),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(340),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(340),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(340),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(340),
    [sym_regex_lit] = STATE(340),
    [sym_read_cond_lit] = STATE(340),
    [sym_splicing_read_cond_lit] = STATE(340),
    [sym_ns_map_lit] = STATE(340),
    [sym_var_quoting_lit] = STATE(340),
    [sym_sym_val_lit] = STATE(340),
    [sym_evaling_lit] = STATE(340),
    [sym_tagged_or_ctor_lit] = STATE(340),
    [sym_derefing_lit] = STATE(340),
    [sym_quoting_lit] = STATE(340),
    [sym_syn_quoting_lit] = STATE(340),
    [sym_unquote_splicing_lit] = STATE(340),
    [sym_unquoting_lit] = STATE(340),
    [aux_sym_dis_expr_repeat1] = STATE(218),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(792),
    [sym_comment] = ACTIONS(792),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(618),
    [sym_nil_lit] = ACTIONS(620),
    [sym_bool_lit] = ACTIONS(620),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [172] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(257),
    [sym_kwd_lit] = STATE(257),
    [sym_str_lit] = STATE(257),
    [sym_sym_lit] = STATE(257),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(257),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(257),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(257),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(257),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(257),
    [sym_regex_lit] = STATE(257),
    [sym_read_cond_lit] = STATE(257),
    [sym_splicing_read_cond_lit] = STATE(257),
    [sym_ns_map_lit] = STATE(257),
    [sym_var_quoting_lit] = STATE(257),
    [sym_sym_val_lit] = STATE(257),
    [sym_evaling_lit] = STATE(257),
    [sym_tagged_or_ctor_lit] = STATE(257),
    [sym_derefing_lit] = STATE(257),
    [sym_quoting_lit] = STATE(257),
    [sym_syn_quoting_lit] = STATE(257),
    [sym_unquote_splicing_lit] = STATE(257),
    [sym_unquoting_lit] = STATE(257),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(444),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(444),
    [sym_nil_lit] = ACTIONS(446),
    [sym_bool_lit] = ACTIONS(446),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [173] = {
    [sym__gap] = STATE(150),
    [sym_dis_expr] = STATE(150),
    [sym__form] = STATE(250),
    [sym_kwd_lit] = STATE(250),
    [sym_str_lit] = STATE(250),
    [sym_sym_lit] = STATE(250),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(250),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(250),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(250),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(250),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(250),
    [sym_regex_lit] = STATE(250),
    [sym_read_cond_lit] = STATE(250),
    [sym_splicing_read_cond_lit] = STATE(250),
    [sym_ns_map_lit] = STATE(250),
    [sym_var_quoting_lit] = STATE(250),
    [sym_sym_val_lit] = STATE(250),
    [sym_evaling_lit] = STATE(250),
    [sym_tagged_or_ctor_lit] = STATE(250),
    [sym_derefing_lit] = STATE(250),
    [sym_quoting_lit] = STATE(250),
    [sym_syn_quoting_lit] = STATE(250),
    [sym_unquote_splicing_lit] = STATE(250),
    [sym_unquoting_lit] = STATE(250),
    [aux_sym_dis_expr_repeat1] = STATE(150),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(794),
    [sym_comment] = ACTIONS(794),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(362),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(362),
    [sym_nil_lit] = ACTIONS(364),
    [sym_bool_lit] = ACTIONS(364),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [174] = {
    [sym__gap] = STATE(152),
    [sym_dis_expr] = STATE(152),
    [sym__form] = STATE(249),
    [sym_kwd_lit] = STATE(249),
    [sym_str_lit] = STATE(249),
    [sym_sym_lit] = STATE(249),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(249),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(249),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(249),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(249),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(249),
    [sym_regex_lit] = STATE(249),
    [sym_read_cond_lit] = STATE(249),
    [sym_splicing_read_cond_lit] = STATE(249),
    [sym_ns_map_lit] = STATE(249),
    [sym_var_quoting_lit] = STATE(249),
    [sym_sym_val_lit] = STATE(249),
    [sym_evaling_lit] = STATE(249),
    [sym_tagged_or_ctor_lit] = STATE(249),
    [sym_derefing_lit] = STATE(249),
    [sym_quoting_lit] = STATE(249),
    [sym_syn_quoting_lit] = STATE(249),
    [sym_unquote_splicing_lit] = STATE(249),
    [sym_unquoting_lit] = STATE(249),
    [aux_sym_dis_expr_repeat1] = STATE(152),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(796),
    [sym_comment] = ACTIONS(796),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(356),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(356),
    [sym_nil_lit] = ACTIONS(358),
    [sym_bool_lit] = ACTIONS(358),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [175] = {
    [sym__gap] = STATE(154),
    [sym_dis_expr] = STATE(154),
    [sym__form] = STATE(248),
    [sym_kwd_lit] = STATE(248),
    [sym_str_lit] = STATE(248),
    [sym_sym_lit] = STATE(248),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(248),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(248),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(248),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(248),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(248),
    [sym_regex_lit] = STATE(248),
    [sym_read_cond_lit] = STATE(248),
    [sym_splicing_read_cond_lit] = STATE(248),
    [sym_ns_map_lit] = STATE(248),
    [sym_var_quoting_lit] = STATE(248),
    [sym_sym_val_lit] = STATE(248),
    [sym_evaling_lit] = STATE(248),
    [sym_tagged_or_ctor_lit] = STATE(248),
    [sym_derefing_lit] = STATE(248),
    [sym_quoting_lit] = STATE(248),
    [sym_syn_quoting_lit] = STATE(248),
    [sym_unquote_splicing_lit] = STATE(248),
    [sym_unquoting_lit] = STATE(248),
    [aux_sym_dis_expr_repeat1] = STATE(154),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(798),
    [sym_comment] = ACTIONS(798),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(350),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(350),
    [sym_nil_lit] = ACTIONS(352),
    [sym_bool_lit] = ACTIONS(352),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [176] = {
    [sym__gap] = STATE(155),
    [sym_dis_expr] = STATE(155),
    [sym__form] = STATE(247),
    [sym_kwd_lit] = STATE(247),
    [sym_str_lit] = STATE(247),
    [sym_sym_lit] = STATE(247),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(247),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(247),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(247),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(247),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(247),
    [sym_regex_lit] = STATE(247),
    [sym_read_cond_lit] = STATE(247),
    [sym_splicing_read_cond_lit] = STATE(247),
    [sym_ns_map_lit] = STATE(247),
    [sym_var_quoting_lit] = STATE(247),
    [sym_sym_val_lit] = STATE(247),
    [sym_evaling_lit] = STATE(247),
    [sym_tagged_or_ctor_lit] = STATE(247),
    [sym_derefing_lit] = STATE(247),
    [sym_quoting_lit] = STATE(247),
    [sym_syn_quoting_lit] = STATE(247),
    [sym_unquote_splicing_lit] = STATE(247),
    [sym_unquoting_lit] = STATE(247),
    [aux_sym_dis_expr_repeat1] = STATE(155),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(800),
    [sym_comment] = ACTIONS(800),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(344),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(344),
    [sym_nil_lit] = ACTIONS(346),
    [sym_bool_lit] = ACTIONS(346),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [177] = {
    [sym__gap] = STATE(156),
    [sym_dis_expr] = STATE(156),
    [sym__form] = STATE(246),
    [sym_kwd_lit] = STATE(246),
    [sym_str_lit] = STATE(246),
    [sym_sym_lit] = STATE(246),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(246),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(246),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(246),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(246),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(246),
    [sym_regex_lit] = STATE(246),
    [sym_read_cond_lit] = STATE(246),
    [sym_splicing_read_cond_lit] = STATE(246),
    [sym_ns_map_lit] = STATE(246),
    [sym_var_quoting_lit] = STATE(246),
    [sym_sym_val_lit] = STATE(246),
    [sym_evaling_lit] = STATE(246),
    [sym_tagged_or_ctor_lit] = STATE(246),
    [sym_derefing_lit] = STATE(246),
    [sym_quoting_lit] = STATE(246),
    [sym_syn_quoting_lit] = STATE(246),
    [sym_unquote_splicing_lit] = STATE(246),
    [sym_unquoting_lit] = STATE(246),
    [aux_sym_dis_expr_repeat1] = STATE(156),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(802),
    [sym_comment] = ACTIONS(802),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(338),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(338),
    [sym_nil_lit] = ACTIONS(340),
    [sym_bool_lit] = ACTIONS(340),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [178] = {
    [sym__gap] = STATE(158),
    [sym_dis_expr] = STATE(158),
    [sym__form] = STATE(243),
    [sym_kwd_lit] = STATE(243),
    [sym_str_lit] = STATE(243),
    [sym_sym_lit] = STATE(243),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(243),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(243),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(243),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(243),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(243),
    [sym_regex_lit] = STATE(243),
    [sym_read_cond_lit] = STATE(243),
    [sym_splicing_read_cond_lit] = STATE(243),
    [sym_ns_map_lit] = STATE(243),
    [sym_var_quoting_lit] = STATE(243),
    [sym_sym_val_lit] = STATE(243),
    [sym_evaling_lit] = STATE(243),
    [sym_tagged_or_ctor_lit] = STATE(243),
    [sym_derefing_lit] = STATE(243),
    [sym_quoting_lit] = STATE(243),
    [sym_syn_quoting_lit] = STATE(243),
    [sym_unquote_splicing_lit] = STATE(243),
    [sym_unquoting_lit] = STATE(243),
    [aux_sym_dis_expr_repeat1] = STATE(158),
    [aux_sym_sym_lit_repeat1] = STATE(329),
    [sym__ws] = ACTIONS(804),
    [sym_comment] = ACTIONS(804),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(718),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(718),
    [sym_nil_lit] = ACTIONS(720),
    [sym_bool_lit] = ACTIONS(720),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(396),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(398),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [anon_sym_TILDE_AT] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(408),
  },
  [179] = {
    [sym__gap] = STATE(216),
    [sym_dis_expr] = STATE(216),
    [sym__form] = STATE(429),
    [sym_kwd_lit] = STATE(429),
    [sym_str_lit] = STATE(429),
    [sym_sym_lit] = STATE(429),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(429),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(429),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(429),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(429),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(429),
    [sym_regex_lit] = STATE(429),
    [sym_read_cond_lit] = STATE(429),
    [sym_splicing_read_cond_lit] = STATE(429),
    [sym_ns_map_lit] = STATE(429),
    [sym_var_quoting_lit] = STATE(429),
    [sym_sym_val_lit] = STATE(429),
    [sym_evaling_lit] = STATE(429),
    [sym_tagged_or_ctor_lit] = STATE(429),
    [sym_derefing_lit] = STATE(429),
    [sym_quoting_lit] = STATE(429),
    [sym_syn_quoting_lit] = STATE(429),
    [sym_unquote_splicing_lit] = STATE(429),
    [sym_unquoting_lit] = STATE(429),
    [aux_sym_dis_expr_repeat1] = STATE(216),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(806),
    [sym_comment] = ACTIONS(806),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(612),
    [sym_nil_lit] = ACTIONS(614),
    [sym_bool_lit] = ACTIONS(614),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [180] = {
    [sym__gap] = STATE(190),
    [sym_dis_expr] = STATE(190),
    [sym__form] = STATE(428),
    [sym_kwd_lit] = STATE(428),
    [sym_str_lit] = STATE(428),
    [sym_sym_lit] = STATE(428),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(428),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(428),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(428),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(428),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(428),
    [sym_regex_lit] = STATE(428),
    [sym_read_cond_lit] = STATE(428),
    [sym_splicing_read_cond_lit] = STATE(428),
    [sym_ns_map_lit] = STATE(428),
    [sym_var_quoting_lit] = STATE(428),
    [sym_sym_val_lit] = STATE(428),
    [sym_evaling_lit] = STATE(428),
    [sym_tagged_or_ctor_lit] = STATE(428),
    [sym_derefing_lit] = STATE(428),
    [sym_quoting_lit] = STATE(428),
    [sym_syn_quoting_lit] = STATE(428),
    [sym_unquote_splicing_lit] = STATE(428),
    [sym_unquoting_lit] = STATE(428),
    [aux_sym_dis_expr_repeat1] = STATE(190),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(808),
    [sym_comment] = ACTIONS(808),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(602),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(602),
    [sym_nil_lit] = ACTIONS(604),
    [sym_bool_lit] = ACTIONS(604),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [181] = {
    [sym__gap] = STATE(104),
    [sym_dis_expr] = STATE(104),
    [sym__form] = STATE(401),
    [sym_kwd_lit] = STATE(401),
    [sym_str_lit] = STATE(401),
    [sym_sym_lit] = STATE(401),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(401),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(401),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(401),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(401),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(401),
    [sym_regex_lit] = STATE(401),
    [sym_read_cond_lit] = STATE(401),
    [sym_splicing_read_cond_lit] = STATE(401),
    [sym_ns_map_lit] = STATE(401),
    [sym_var_quoting_lit] = STATE(401),
    [sym_sym_val_lit] = STATE(401),
    [sym_evaling_lit] = STATE(401),
    [sym_tagged_or_ctor_lit] = STATE(401),
    [sym_derefing_lit] = STATE(401),
    [sym_quoting_lit] = STATE(401),
    [sym_syn_quoting_lit] = STATE(401),
    [sym_unquote_splicing_lit] = STATE(401),
    [sym_unquoting_lit] = STATE(401),
    [aux_sym_dis_expr_repeat1] = STATE(104),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(810),
    [sym_comment] = ACTIONS(810),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(558),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(558),
    [sym_nil_lit] = ACTIONS(560),
    [sym_bool_lit] = ACTIONS(560),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [182] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(389),
    [sym_kwd_lit] = STATE(389),
    [sym_str_lit] = STATE(389),
    [sym_sym_lit] = STATE(389),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(389),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(389),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(389),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(389),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(389),
    [sym_regex_lit] = STATE(389),
    [sym_read_cond_lit] = STATE(389),
    [sym_splicing_read_cond_lit] = STATE(389),
    [sym_ns_map_lit] = STATE(389),
    [sym_var_quoting_lit] = STATE(389),
    [sym_sym_val_lit] = STATE(389),
    [sym_evaling_lit] = STATE(389),
    [sym_tagged_or_ctor_lit] = STATE(389),
    [sym_derefing_lit] = STATE(389),
    [sym_quoting_lit] = STATE(389),
    [sym_syn_quoting_lit] = STATE(389),
    [sym_unquote_splicing_lit] = STATE(389),
    [sym_unquoting_lit] = STATE(389),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(308),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(308),
    [sym_nil_lit] = ACTIONS(314),
    [sym_bool_lit] = ACTIONS(314),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [183] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(385),
    [sym_kwd_lit] = STATE(385),
    [sym_str_lit] = STATE(385),
    [sym_sym_lit] = STATE(385),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(385),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(385),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(385),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(385),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(385),
    [sym_regex_lit] = STATE(385),
    [sym_read_cond_lit] = STATE(385),
    [sym_splicing_read_cond_lit] = STATE(385),
    [sym_ns_map_lit] = STATE(385),
    [sym_var_quoting_lit] = STATE(385),
    [sym_sym_val_lit] = STATE(385),
    [sym_evaling_lit] = STATE(385),
    [sym_tagged_or_ctor_lit] = STATE(385),
    [sym_derefing_lit] = STATE(385),
    [sym_quoting_lit] = STATE(385),
    [sym_syn_quoting_lit] = STATE(385),
    [sym_unquote_splicing_lit] = STATE(385),
    [sym_unquoting_lit] = STATE(385),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(316),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(552),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(418),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(552),
    [sym_nil_lit] = ACTIONS(554),
    [sym_bool_lit] = ACTIONS(554),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(422),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(424),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(430),
    [anon_sym_TILDE_AT] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(434),
  },
  [184] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(301),
    [sym_kwd_lit] = STATE(301),
    [sym_str_lit] = STATE(301),
    [sym_sym_lit] = STATE(301),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(301),
    [sym__bare_list_lit] = STATE(230),
    [sym_map_lit] = STATE(301),
    [sym__bare_map_lit] = STATE(231),
    [sym_vec_lit] = STATE(301),
    [sym__bare_vec_lit] = STATE(232),
    [sym_set_lit] = STATE(301),
    [sym__bare_set_lit] = STATE(233),
    [sym_anon_fn_lit] = STATE(301),
    [sym_regex_lit] = STATE(301),
    [sym_read_cond_lit] = STATE(301),
    [sym_splicing_read_cond_lit] = STATE(301),
    [sym_ns_map_lit] = STATE(301),
    [sym_var_quoting_lit] = STATE(301),
    [sym_sym_val_lit] = STATE(301),
    [sym_evaling_lit] = STATE(301),
    [sym_tagged_or_ctor_lit] = STATE(301),
    [sym_derefing_lit] = STATE(301),
    [sym_quoting_lit] = STATE(301),
    [sym_syn_quoting_lit] = STATE(301),
    [sym_unquote_splicing_lit] = STATE(301),
    [sym_unquoting_lit] = STATE(301),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(325),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(678),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(678),
    [sym_nil_lit] = ACTIONS(680),
    [sym_bool_lit] = ACTIONS(680),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [185] = {
    [sym__gap] = STATE(166),
    [sym_dis_expr] = STATE(166),
    [sym__form] = STATE(426),
    [sym_kwd_lit] = STATE(426),
    [sym_str_lit] = STATE(426),
    [sym_sym_lit] = STATE(426),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(426),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(426),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(426),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(426),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(426),
    [sym_regex_lit] = STATE(426),
    [sym_read_cond_lit] = STATE(426),
    [sym_splicing_read_cond_lit] = STATE(426),
    [sym_ns_map_lit] = STATE(426),
    [sym_var_quoting_lit] = STATE(426),
    [sym_sym_val_lit] = STATE(426),
    [sym_evaling_lit] = STATE(426),
    [sym_tagged_or_ctor_lit] = STATE(426),
    [sym_derefing_lit] = STATE(426),
    [sym_quoting_lit] = STATE(426),
    [sym_syn_quoting_lit] = STATE(426),
    [sym_unquote_splicing_lit] = STATE(426),
    [sym_unquoting_lit] = STATE(426),
    [aux_sym_dis_expr_repeat1] = STATE(166),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(812),
    [sym_comment] = ACTIONS(812),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(592),
    [sym_nil_lit] = ACTIONS(594),
    [sym_bool_lit] = ACTIONS(594),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [186] = {
    [sym__gap] = STATE(202),
    [sym_dis_expr] = STATE(202),
    [sym__form] = STATE(348),
    [sym_kwd_lit] = STATE(348),
    [sym_str_lit] = STATE(348),
    [sym_sym_lit] = STATE(348),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(348),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(348),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(348),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(348),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(348),
    [sym_regex_lit] = STATE(348),
    [sym_read_cond_lit] = STATE(348),
    [sym_splicing_read_cond_lit] = STATE(348),
    [sym_ns_map_lit] = STATE(348),
    [sym_var_quoting_lit] = STATE(348),
    [sym_sym_val_lit] = STATE(348),
    [sym_evaling_lit] = STATE(348),
    [sym_tagged_or_ctor_lit] = STATE(348),
    [sym_derefing_lit] = STATE(348),
    [sym_quoting_lit] = STATE(348),
    [sym_syn_quoting_lit] = STATE(348),
    [sym_unquote_splicing_lit] = STATE(348),
    [sym_unquoting_lit] = STATE(348),
    [aux_sym_dis_expr_repeat1] = STATE(202),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(814),
    [sym_comment] = ACTIONS(814),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(332),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(332),
    [sym_nil_lit] = ACTIONS(334),
    [sym_bool_lit] = ACTIONS(334),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [187] = {
    [sym__gap] = STATE(162),
    [sym_dis_expr] = STATE(162),
    [sym__form] = STATE(425),
    [sym_kwd_lit] = STATE(425),
    [sym_str_lit] = STATE(425),
    [sym_sym_lit] = STATE(425),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(425),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(425),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(425),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(425),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(425),
    [sym_regex_lit] = STATE(425),
    [sym_read_cond_lit] = STATE(425),
    [sym_splicing_read_cond_lit] = STATE(425),
    [sym_ns_map_lit] = STATE(425),
    [sym_var_quoting_lit] = STATE(425),
    [sym_sym_val_lit] = STATE(425),
    [sym_evaling_lit] = STATE(425),
    [sym_tagged_or_ctor_lit] = STATE(425),
    [sym_derefing_lit] = STATE(425),
    [sym_quoting_lit] = STATE(425),
    [sym_syn_quoting_lit] = STATE(425),
    [sym_unquote_splicing_lit] = STATE(425),
    [sym_unquoting_lit] = STATE(425),
    [aux_sym_dis_expr_repeat1] = STATE(162),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(816),
    [sym_comment] = ACTIONS(816),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(582),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(582),
    [sym_nil_lit] = ACTIONS(584),
    [sym_bool_lit] = ACTIONS(584),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [188] = {
    [sym__gap] = STATE(137),
    [sym_dis_expr] = STATE(137),
    [sym__form] = STATE(420),
    [sym_kwd_lit] = STATE(420),
    [sym_str_lit] = STATE(420),
    [sym_sym_lit] = STATE(420),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(420),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(420),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(420),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(420),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(420),
    [sym_regex_lit] = STATE(420),
    [sym_read_cond_lit] = STATE(420),
    [sym_splicing_read_cond_lit] = STATE(420),
    [sym_ns_map_lit] = STATE(420),
    [sym_var_quoting_lit] = STATE(420),
    [sym_sym_val_lit] = STATE(420),
    [sym_evaling_lit] = STATE(420),
    [sym_tagged_or_ctor_lit] = STATE(420),
    [sym_derefing_lit] = STATE(420),
    [sym_quoting_lit] = STATE(420),
    [sym_syn_quoting_lit] = STATE(420),
    [sym_unquote_splicing_lit] = STATE(420),
    [sym_unquoting_lit] = STATE(420),
    [aux_sym_dis_expr_repeat1] = STATE(137),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(818),
    [sym_comment] = ACTIONS(818),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(572),
    [sym_nil_lit] = ACTIONS(574),
    [sym_bool_lit] = ACTIONS(574),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [189] = {
    [sym__gap] = STATE(214),
    [sym_dis_expr] = STATE(214),
    [sym__form] = STATE(340),
    [sym_kwd_lit] = STATE(340),
    [sym_str_lit] = STATE(340),
    [sym_sym_lit] = STATE(340),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(340),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(340),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(340),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(340),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(340),
    [sym_regex_lit] = STATE(340),
    [sym_read_cond_lit] = STATE(340),
    [sym_splicing_read_cond_lit] = STATE(340),
    [sym_ns_map_lit] = STATE(340),
    [sym_var_quoting_lit] = STATE(340),
    [sym_sym_val_lit] = STATE(340),
    [sym_evaling_lit] = STATE(340),
    [sym_tagged_or_ctor_lit] = STATE(340),
    [sym_derefing_lit] = STATE(340),
    [sym_quoting_lit] = STATE(340),
    [sym_syn_quoting_lit] = STATE(340),
    [sym_unquote_splicing_lit] = STATE(340),
    [sym_unquoting_lit] = STATE(340),
    [aux_sym_dis_expr_repeat1] = STATE(214),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(820),
    [sym_comment] = ACTIONS(820),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(618),
    [sym_nil_lit] = ACTIONS(620),
    [sym_bool_lit] = ACTIONS(620),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [190] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(333),
    [sym_kwd_lit] = STATE(333),
    [sym_str_lit] = STATE(333),
    [sym_sym_lit] = STATE(333),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(333),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(333),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(333),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(333),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(333),
    [sym_regex_lit] = STATE(333),
    [sym_read_cond_lit] = STATE(333),
    [sym_splicing_read_cond_lit] = STATE(333),
    [sym_ns_map_lit] = STATE(333),
    [sym_var_quoting_lit] = STATE(333),
    [sym_sym_val_lit] = STATE(333),
    [sym_evaling_lit] = STATE(333),
    [sym_tagged_or_ctor_lit] = STATE(333),
    [sym_derefing_lit] = STATE(333),
    [sym_quoting_lit] = STATE(333),
    [sym_syn_quoting_lit] = STATE(333),
    [sym_unquote_splicing_lit] = STATE(333),
    [sym_unquoting_lit] = STATE(333),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(544),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(544),
    [sym_nil_lit] = ACTIONS(546),
    [sym_bool_lit] = ACTIONS(546),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [191] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(412),
    [sym_kwd_lit] = STATE(412),
    [sym_str_lit] = STATE(412),
    [sym_sym_lit] = STATE(412),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(412),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(412),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(412),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(412),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(412),
    [sym_regex_lit] = STATE(412),
    [sym_read_cond_lit] = STATE(412),
    [sym_splicing_read_cond_lit] = STATE(412),
    [sym_ns_map_lit] = STATE(412),
    [sym_var_quoting_lit] = STATE(412),
    [sym_sym_val_lit] = STATE(412),
    [sym_evaling_lit] = STATE(412),
    [sym_tagged_or_ctor_lit] = STATE(412),
    [sym_derefing_lit] = STATE(412),
    [sym_quoting_lit] = STATE(412),
    [sym_syn_quoting_lit] = STATE(412),
    [sym_unquote_splicing_lit] = STATE(412),
    [sym_unquoting_lit] = STATE(412),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(562),
    [sym_nil_lit] = ACTIONS(564),
    [sym_bool_lit] = ACTIONS(564),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [192] = {
    [sym__gap] = STATE(220),
    [sym_dis_expr] = STATE(220),
    [sym__form] = STATE(429),
    [sym_kwd_lit] = STATE(429),
    [sym_str_lit] = STATE(429),
    [sym_sym_lit] = STATE(429),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(429),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(429),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(429),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(429),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(429),
    [sym_regex_lit] = STATE(429),
    [sym_read_cond_lit] = STATE(429),
    [sym_splicing_read_cond_lit] = STATE(429),
    [sym_ns_map_lit] = STATE(429),
    [sym_var_quoting_lit] = STATE(429),
    [sym_sym_val_lit] = STATE(429),
    [sym_evaling_lit] = STATE(429),
    [sym_tagged_or_ctor_lit] = STATE(429),
    [sym_derefing_lit] = STATE(429),
    [sym_quoting_lit] = STATE(429),
    [sym_syn_quoting_lit] = STATE(429),
    [sym_unquote_splicing_lit] = STATE(429),
    [sym_unquoting_lit] = STATE(429),
    [aux_sym_dis_expr_repeat1] = STATE(220),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(822),
    [sym_comment] = ACTIONS(822),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(612),
    [sym_nil_lit] = ACTIONS(614),
    [sym_bool_lit] = ACTIONS(614),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [193] = {
    [sym__gap] = STATE(222),
    [sym_dis_expr] = STATE(222),
    [sym__form] = STATE(428),
    [sym_kwd_lit] = STATE(428),
    [sym_str_lit] = STATE(428),
    [sym_sym_lit] = STATE(428),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(428),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(428),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(428),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(428),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(428),
    [sym_regex_lit] = STATE(428),
    [sym_read_cond_lit] = STATE(428),
    [sym_splicing_read_cond_lit] = STATE(428),
    [sym_ns_map_lit] = STATE(428),
    [sym_var_quoting_lit] = STATE(428),
    [sym_sym_val_lit] = STATE(428),
    [sym_evaling_lit] = STATE(428),
    [sym_tagged_or_ctor_lit] = STATE(428),
    [sym_derefing_lit] = STATE(428),
    [sym_quoting_lit] = STATE(428),
    [sym_syn_quoting_lit] = STATE(428),
    [sym_unquote_splicing_lit] = STATE(428),
    [sym_unquoting_lit] = STATE(428),
    [aux_sym_dis_expr_repeat1] = STATE(222),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(824),
    [sym_comment] = ACTIONS(824),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(602),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(602),
    [sym_nil_lit] = ACTIONS(604),
    [sym_bool_lit] = ACTIONS(604),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [194] = {
    [sym__gap] = STATE(224),
    [sym_dis_expr] = STATE(224),
    [sym__form] = STATE(426),
    [sym_kwd_lit] = STATE(426),
    [sym_str_lit] = STATE(426),
    [sym_sym_lit] = STATE(426),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(426),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(426),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(426),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(426),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(426),
    [sym_regex_lit] = STATE(426),
    [sym_read_cond_lit] = STATE(426),
    [sym_splicing_read_cond_lit] = STATE(426),
    [sym_ns_map_lit] = STATE(426),
    [sym_var_quoting_lit] = STATE(426),
    [sym_sym_val_lit] = STATE(426),
    [sym_evaling_lit] = STATE(426),
    [sym_tagged_or_ctor_lit] = STATE(426),
    [sym_derefing_lit] = STATE(426),
    [sym_quoting_lit] = STATE(426),
    [sym_syn_quoting_lit] = STATE(426),
    [sym_unquote_splicing_lit] = STATE(426),
    [sym_unquoting_lit] = STATE(426),
    [aux_sym_dis_expr_repeat1] = STATE(224),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(826),
    [sym_comment] = ACTIONS(826),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(592),
    [sym_nil_lit] = ACTIONS(594),
    [sym_bool_lit] = ACTIONS(594),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [195] = {
    [sym__gap] = STATE(57),
    [sym_dis_expr] = STATE(57),
    [sym__form] = STATE(425),
    [sym_kwd_lit] = STATE(425),
    [sym_str_lit] = STATE(425),
    [sym_sym_lit] = STATE(425),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(425),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(425),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(425),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(425),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(425),
    [sym_regex_lit] = STATE(425),
    [sym_read_cond_lit] = STATE(425),
    [sym_splicing_read_cond_lit] = STATE(425),
    [sym_ns_map_lit] = STATE(425),
    [sym_var_quoting_lit] = STATE(425),
    [sym_sym_val_lit] = STATE(425),
    [sym_evaling_lit] = STATE(425),
    [sym_tagged_or_ctor_lit] = STATE(425),
    [sym_derefing_lit] = STATE(425),
    [sym_quoting_lit] = STATE(425),
    [sym_syn_quoting_lit] = STATE(425),
    [sym_unquote_splicing_lit] = STATE(425),
    [sym_unquoting_lit] = STATE(425),
    [aux_sym_dis_expr_repeat1] = STATE(57),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(828),
    [sym_comment] = ACTIONS(828),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(582),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(582),
    [sym_nil_lit] = ACTIONS(584),
    [sym_bool_lit] = ACTIONS(584),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [196] = {
    [sym__gap] = STATE(212),
    [sym_dis_expr] = STATE(212),
    [sym__form] = STATE(420),
    [sym_kwd_lit] = STATE(420),
    [sym_str_lit] = STATE(420),
    [sym_sym_lit] = STATE(420),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(420),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(420),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(420),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(420),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(420),
    [sym_regex_lit] = STATE(420),
    [sym_read_cond_lit] = STATE(420),
    [sym_splicing_read_cond_lit] = STATE(420),
    [sym_ns_map_lit] = STATE(420),
    [sym_var_quoting_lit] = STATE(420),
    [sym_sym_val_lit] = STATE(420),
    [sym_evaling_lit] = STATE(420),
    [sym_tagged_or_ctor_lit] = STATE(420),
    [sym_derefing_lit] = STATE(420),
    [sym_quoting_lit] = STATE(420),
    [sym_syn_quoting_lit] = STATE(420),
    [sym_unquote_splicing_lit] = STATE(420),
    [sym_unquoting_lit] = STATE(420),
    [aux_sym_dis_expr_repeat1] = STATE(212),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(830),
    [sym_comment] = ACTIONS(830),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(572),
    [sym_nil_lit] = ACTIONS(574),
    [sym_bool_lit] = ACTIONS(574),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [197] = {
    [sym__gap] = STATE(102),
    [sym_dis_expr] = STATE(102),
    [sym__form] = STATE(401),
    [sym_kwd_lit] = STATE(401),
    [sym_str_lit] = STATE(401),
    [sym_sym_lit] = STATE(401),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(401),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(401),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(401),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(401),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(401),
    [sym_regex_lit] = STATE(401),
    [sym_read_cond_lit] = STATE(401),
    [sym_splicing_read_cond_lit] = STATE(401),
    [sym_ns_map_lit] = STATE(401),
    [sym_var_quoting_lit] = STATE(401),
    [sym_sym_val_lit] = STATE(401),
    [sym_evaling_lit] = STATE(401),
    [sym_tagged_or_ctor_lit] = STATE(401),
    [sym_derefing_lit] = STATE(401),
    [sym_quoting_lit] = STATE(401),
    [sym_syn_quoting_lit] = STATE(401),
    [sym_unquote_splicing_lit] = STATE(401),
    [sym_unquoting_lit] = STATE(401),
    [aux_sym_dis_expr_repeat1] = STATE(102),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(832),
    [sym_comment] = ACTIONS(832),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(558),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(558),
    [sym_nil_lit] = ACTIONS(560),
    [sym_bool_lit] = ACTIONS(560),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [198] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(393),
    [sym_kwd_lit] = STATE(393),
    [sym_str_lit] = STATE(393),
    [sym_sym_lit] = STATE(393),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(393),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(393),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(393),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(393),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(393),
    [sym_regex_lit] = STATE(393),
    [sym_read_cond_lit] = STATE(393),
    [sym_splicing_read_cond_lit] = STATE(393),
    [sym_ns_map_lit] = STATE(393),
    [sym_var_quoting_lit] = STATE(393),
    [sym_sym_val_lit] = STATE(393),
    [sym_evaling_lit] = STATE(393),
    [sym_tagged_or_ctor_lit] = STATE(393),
    [sym_derefing_lit] = STATE(393),
    [sym_quoting_lit] = STATE(393),
    [sym_syn_quoting_lit] = STATE(393),
    [sym_unquote_splicing_lit] = STATE(393),
    [sym_unquoting_lit] = STATE(393),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(368),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(368),
    [sym_nil_lit] = ACTIONS(370),
    [sym_bool_lit] = ACTIONS(370),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [199] = {
    [sym__gap] = STATE(198),
    [sym_dis_expr] = STATE(198),
    [sym__form] = STATE(421),
    [sym_kwd_lit] = STATE(421),
    [sym_str_lit] = STATE(421),
    [sym_sym_lit] = STATE(421),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(421),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(421),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(421),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(421),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(421),
    [sym_regex_lit] = STATE(421),
    [sym_read_cond_lit] = STATE(421),
    [sym_splicing_read_cond_lit] = STATE(421),
    [sym_ns_map_lit] = STATE(421),
    [sym_var_quoting_lit] = STATE(421),
    [sym_sym_val_lit] = STATE(421),
    [sym_evaling_lit] = STATE(421),
    [sym_tagged_or_ctor_lit] = STATE(421),
    [sym_derefing_lit] = STATE(421),
    [sym_quoting_lit] = STATE(421),
    [sym_syn_quoting_lit] = STATE(421),
    [sym_unquote_splicing_lit] = STATE(421),
    [sym_unquoting_lit] = STATE(421),
    [aux_sym_dis_expr_repeat1] = STATE(198),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(834),
    [sym_comment] = ACTIONS(834),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(374),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(374),
    [sym_nil_lit] = ACTIONS(376),
    [sym_bool_lit] = ACTIONS(376),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [200] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(427),
    [sym_kwd_lit] = STATE(427),
    [sym_str_lit] = STATE(427),
    [sym_sym_lit] = STATE(427),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(427),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(427),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(427),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(427),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(427),
    [sym_regex_lit] = STATE(427),
    [sym_read_cond_lit] = STATE(427),
    [sym_splicing_read_cond_lit] = STATE(427),
    [sym_ns_map_lit] = STATE(427),
    [sym_var_quoting_lit] = STATE(427),
    [sym_sym_val_lit] = STATE(427),
    [sym_evaling_lit] = STATE(427),
    [sym_tagged_or_ctor_lit] = STATE(427),
    [sym_derefing_lit] = STATE(427),
    [sym_quoting_lit] = STATE(427),
    [sym_syn_quoting_lit] = STATE(427),
    [sym_unquote_splicing_lit] = STATE(427),
    [sym_unquoting_lit] = STATE(427),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(378),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(378),
    [sym_nil_lit] = ACTIONS(380),
    [sym_bool_lit] = ACTIONS(380),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [201] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(399),
    [sym_kwd_lit] = STATE(399),
    [sym_str_lit] = STATE(399),
    [sym_sym_lit] = STATE(399),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(399),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(399),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(399),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(399),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(399),
    [sym_regex_lit] = STATE(399),
    [sym_read_cond_lit] = STATE(399),
    [sym_splicing_read_cond_lit] = STATE(399),
    [sym_ns_map_lit] = STATE(399),
    [sym_var_quoting_lit] = STATE(399),
    [sym_sym_val_lit] = STATE(399),
    [sym_evaling_lit] = STATE(399),
    [sym_tagged_or_ctor_lit] = STATE(399),
    [sym_derefing_lit] = STATE(399),
    [sym_quoting_lit] = STATE(399),
    [sym_syn_quoting_lit] = STATE(399),
    [sym_unquote_splicing_lit] = STATE(399),
    [sym_unquoting_lit] = STATE(399),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(382),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(382),
    [sym_nil_lit] = ACTIONS(384),
    [sym_bool_lit] = ACTIONS(384),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [202] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(412),
    [sym_kwd_lit] = STATE(412),
    [sym_str_lit] = STATE(412),
    [sym_sym_lit] = STATE(412),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(412),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(412),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(412),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(412),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(412),
    [sym_regex_lit] = STATE(412),
    [sym_read_cond_lit] = STATE(412),
    [sym_splicing_read_cond_lit] = STATE(412),
    [sym_ns_map_lit] = STATE(412),
    [sym_var_quoting_lit] = STATE(412),
    [sym_sym_val_lit] = STATE(412),
    [sym_evaling_lit] = STATE(412),
    [sym_tagged_or_ctor_lit] = STATE(412),
    [sym_derefing_lit] = STATE(412),
    [sym_quoting_lit] = STATE(412),
    [sym_syn_quoting_lit] = STATE(412),
    [sym_unquote_splicing_lit] = STATE(412),
    [sym_unquoting_lit] = STATE(412),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(562),
    [sym_nil_lit] = ACTIONS(564),
    [sym_bool_lit] = ACTIONS(564),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [203] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(398),
    [sym_kwd_lit] = STATE(398),
    [sym_str_lit] = STATE(398),
    [sym_sym_lit] = STATE(398),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(398),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(398),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(398),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(398),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(398),
    [sym_regex_lit] = STATE(398),
    [sym_read_cond_lit] = STATE(398),
    [sym_splicing_read_cond_lit] = STATE(398),
    [sym_ns_map_lit] = STATE(398),
    [sym_var_quoting_lit] = STATE(398),
    [sym_sym_val_lit] = STATE(398),
    [sym_evaling_lit] = STATE(398),
    [sym_tagged_or_ctor_lit] = STATE(398),
    [sym_derefing_lit] = STATE(398),
    [sym_quoting_lit] = STATE(398),
    [sym_syn_quoting_lit] = STATE(398),
    [sym_unquote_splicing_lit] = STATE(398),
    [sym_unquoting_lit] = STATE(398),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(266),
    [sym_nil_lit] = ACTIONS(276),
    [sym_bool_lit] = ACTIONS(276),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [204] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(397),
    [sym_kwd_lit] = STATE(397),
    [sym_str_lit] = STATE(397),
    [sym_sym_lit] = STATE(397),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(397),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(397),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(397),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(397),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(397),
    [sym_regex_lit] = STATE(397),
    [sym_read_cond_lit] = STATE(397),
    [sym_splicing_read_cond_lit] = STATE(397),
    [sym_ns_map_lit] = STATE(397),
    [sym_var_quoting_lit] = STATE(397),
    [sym_sym_val_lit] = STATE(397),
    [sym_evaling_lit] = STATE(397),
    [sym_tagged_or_ctor_lit] = STATE(397),
    [sym_derefing_lit] = STATE(397),
    [sym_quoting_lit] = STATE(397),
    [sym_syn_quoting_lit] = STATE(397),
    [sym_unquote_splicing_lit] = STATE(397),
    [sym_unquoting_lit] = STATE(397),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(410),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(410),
    [sym_nil_lit] = ACTIONS(412),
    [sym_bool_lit] = ACTIONS(412),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [205] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(386),
    [sym_kwd_lit] = STATE(386),
    [sym_str_lit] = STATE(386),
    [sym_sym_lit] = STATE(386),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(386),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(386),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(386),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(386),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(386),
    [sym_regex_lit] = STATE(386),
    [sym_read_cond_lit] = STATE(386),
    [sym_splicing_read_cond_lit] = STATE(386),
    [sym_ns_map_lit] = STATE(386),
    [sym_var_quoting_lit] = STATE(386),
    [sym_sym_val_lit] = STATE(386),
    [sym_evaling_lit] = STATE(386),
    [sym_tagged_or_ctor_lit] = STATE(386),
    [sym_derefing_lit] = STATE(386),
    [sym_quoting_lit] = STATE(386),
    [sym_syn_quoting_lit] = STATE(386),
    [sym_unquote_splicing_lit] = STATE(386),
    [sym_unquoting_lit] = STATE(386),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(414),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(414),
    [sym_nil_lit] = ACTIONS(420),
    [sym_bool_lit] = ACTIONS(420),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [206] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(380),
    [sym_kwd_lit] = STATE(380),
    [sym_str_lit] = STATE(380),
    [sym_sym_lit] = STATE(380),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(380),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(380),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(380),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(380),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(380),
    [sym_regex_lit] = STATE(380),
    [sym_read_cond_lit] = STATE(380),
    [sym_splicing_read_cond_lit] = STATE(380),
    [sym_ns_map_lit] = STATE(380),
    [sym_var_quoting_lit] = STATE(380),
    [sym_sym_val_lit] = STATE(380),
    [sym_evaling_lit] = STATE(380),
    [sym_tagged_or_ctor_lit] = STATE(380),
    [sym_derefing_lit] = STATE(380),
    [sym_quoting_lit] = STATE(380),
    [sym_syn_quoting_lit] = STATE(380),
    [sym_unquote_splicing_lit] = STATE(380),
    [sym_unquoting_lit] = STATE(380),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(436),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(436),
    [sym_nil_lit] = ACTIONS(438),
    [sym_bool_lit] = ACTIONS(438),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [207] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(357),
    [sym_kwd_lit] = STATE(357),
    [sym_str_lit] = STATE(357),
    [sym_sym_lit] = STATE(357),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(357),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(357),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(357),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(357),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(357),
    [sym_regex_lit] = STATE(357),
    [sym_read_cond_lit] = STATE(357),
    [sym_splicing_read_cond_lit] = STATE(357),
    [sym_ns_map_lit] = STATE(357),
    [sym_var_quoting_lit] = STATE(357),
    [sym_sym_val_lit] = STATE(357),
    [sym_evaling_lit] = STATE(357),
    [sym_tagged_or_ctor_lit] = STATE(357),
    [sym_derefing_lit] = STATE(357),
    [sym_quoting_lit] = STATE(357),
    [sym_syn_quoting_lit] = STATE(357),
    [sym_unquote_splicing_lit] = STATE(357),
    [sym_unquoting_lit] = STATE(357),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(440),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(440),
    [sym_nil_lit] = ACTIONS(442),
    [sym_bool_lit] = ACTIONS(442),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [208] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(343),
    [sym_kwd_lit] = STATE(343),
    [sym_str_lit] = STATE(343),
    [sym_sym_lit] = STATE(343),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(343),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(343),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(343),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(343),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(343),
    [sym_regex_lit] = STATE(343),
    [sym_read_cond_lit] = STATE(343),
    [sym_splicing_read_cond_lit] = STATE(343),
    [sym_ns_map_lit] = STATE(343),
    [sym_var_quoting_lit] = STATE(343),
    [sym_sym_val_lit] = STATE(343),
    [sym_evaling_lit] = STATE(343),
    [sym_tagged_or_ctor_lit] = STATE(343),
    [sym_derefing_lit] = STATE(343),
    [sym_quoting_lit] = STATE(343),
    [sym_syn_quoting_lit] = STATE(343),
    [sym_unquote_splicing_lit] = STATE(343),
    [sym_unquoting_lit] = STATE(343),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(472),
    [sym_nil_lit] = ACTIONS(474),
    [sym_bool_lit] = ACTIONS(474),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [209] = {
    [sym__gap] = STATE(213),
    [sym_dis_expr] = STATE(213),
    [sym__form] = STATE(401),
    [sym_kwd_lit] = STATE(401),
    [sym_str_lit] = STATE(401),
    [sym_sym_lit] = STATE(401),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(401),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(401),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(401),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(401),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(401),
    [sym_regex_lit] = STATE(401),
    [sym_read_cond_lit] = STATE(401),
    [sym_splicing_read_cond_lit] = STATE(401),
    [sym_ns_map_lit] = STATE(401),
    [sym_var_quoting_lit] = STATE(401),
    [sym_sym_val_lit] = STATE(401),
    [sym_evaling_lit] = STATE(401),
    [sym_tagged_or_ctor_lit] = STATE(401),
    [sym_derefing_lit] = STATE(401),
    [sym_quoting_lit] = STATE(401),
    [sym_syn_quoting_lit] = STATE(401),
    [sym_unquote_splicing_lit] = STATE(401),
    [sym_unquoting_lit] = STATE(401),
    [aux_sym_dis_expr_repeat1] = STATE(213),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(836),
    [sym_comment] = ACTIONS(836),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(558),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(558),
    [sym_nil_lit] = ACTIONS(560),
    [sym_bool_lit] = ACTIONS(560),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [210] = {
    [sym__gap] = STATE(200),
    [sym_dis_expr] = STATE(200),
    [sym__form] = STATE(349),
    [sym_kwd_lit] = STATE(349),
    [sym_str_lit] = STATE(349),
    [sym_sym_lit] = STATE(349),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(349),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(349),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(349),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(349),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(349),
    [sym_regex_lit] = STATE(349),
    [sym_read_cond_lit] = STATE(349),
    [sym_splicing_read_cond_lit] = STATE(349),
    [sym_ns_map_lit] = STATE(349),
    [sym_var_quoting_lit] = STATE(349),
    [sym_sym_val_lit] = STATE(349),
    [sym_evaling_lit] = STATE(349),
    [sym_tagged_or_ctor_lit] = STATE(349),
    [sym_derefing_lit] = STATE(349),
    [sym_quoting_lit] = STATE(349),
    [sym_syn_quoting_lit] = STATE(349),
    [sym_unquote_splicing_lit] = STATE(349),
    [sym_unquoting_lit] = STATE(349),
    [aux_sym_dis_expr_repeat1] = STATE(200),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(838),
    [sym_comment] = ACTIONS(838),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(478),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(478),
    [sym_nil_lit] = ACTIONS(480),
    [sym_bool_lit] = ACTIONS(480),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [211] = {
    [sym__gap] = STATE(203),
    [sym_dis_expr] = STATE(203),
    [sym__form] = STATE(361),
    [sym_kwd_lit] = STATE(361),
    [sym_str_lit] = STATE(361),
    [sym_sym_lit] = STATE(361),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(361),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(361),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(361),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(361),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(361),
    [sym_regex_lit] = STATE(361),
    [sym_read_cond_lit] = STATE(361),
    [sym_splicing_read_cond_lit] = STATE(361),
    [sym_ns_map_lit] = STATE(361),
    [sym_var_quoting_lit] = STATE(361),
    [sym_sym_val_lit] = STATE(361),
    [sym_evaling_lit] = STATE(361),
    [sym_tagged_or_ctor_lit] = STATE(361),
    [sym_derefing_lit] = STATE(361),
    [sym_quoting_lit] = STATE(361),
    [sym_syn_quoting_lit] = STATE(361),
    [sym_unquote_splicing_lit] = STATE(361),
    [sym_unquoting_lit] = STATE(361),
    [aux_sym_dis_expr_repeat1] = STATE(203),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(840),
    [sym_comment] = ACTIONS(840),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(496),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(496),
    [sym_nil_lit] = ACTIONS(498),
    [sym_bool_lit] = ACTIONS(498),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [212] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(379),
    [sym_kwd_lit] = STATE(379),
    [sym_str_lit] = STATE(379),
    [sym_sym_lit] = STATE(379),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(379),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(379),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(379),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(379),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(379),
    [sym_regex_lit] = STATE(379),
    [sym_read_cond_lit] = STATE(379),
    [sym_splicing_read_cond_lit] = STATE(379),
    [sym_ns_map_lit] = STATE(379),
    [sym_var_quoting_lit] = STATE(379),
    [sym_sym_val_lit] = STATE(379),
    [sym_evaling_lit] = STATE(379),
    [sym_tagged_or_ctor_lit] = STATE(379),
    [sym_derefing_lit] = STATE(379),
    [sym_quoting_lit] = STATE(379),
    [sym_syn_quoting_lit] = STATE(379),
    [sym_unquote_splicing_lit] = STATE(379),
    [sym_unquoting_lit] = STATE(379),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(532),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(532),
    [sym_nil_lit] = ACTIONS(534),
    [sym_bool_lit] = ACTIONS(534),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [213] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(355),
    [sym_kwd_lit] = STATE(355),
    [sym_str_lit] = STATE(355),
    [sym_sym_lit] = STATE(355),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(355),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(355),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(355),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(355),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(355),
    [sym_regex_lit] = STATE(355),
    [sym_read_cond_lit] = STATE(355),
    [sym_splicing_read_cond_lit] = STATE(355),
    [sym_ns_map_lit] = STATE(355),
    [sym_var_quoting_lit] = STATE(355),
    [sym_sym_val_lit] = STATE(355),
    [sym_evaling_lit] = STATE(355),
    [sym_tagged_or_ctor_lit] = STATE(355),
    [sym_derefing_lit] = STATE(355),
    [sym_quoting_lit] = STATE(355),
    [sym_syn_quoting_lit] = STATE(355),
    [sym_unquote_splicing_lit] = STATE(355),
    [sym_unquoting_lit] = STATE(355),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(490),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(490),
    [sym_nil_lit] = ACTIONS(492),
    [sym_bool_lit] = ACTIONS(492),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [214] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(389),
    [sym_kwd_lit] = STATE(389),
    [sym_str_lit] = STATE(389),
    [sym_sym_lit] = STATE(389),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(389),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(389),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(389),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(389),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(389),
    [sym_regex_lit] = STATE(389),
    [sym_read_cond_lit] = STATE(389),
    [sym_splicing_read_cond_lit] = STATE(389),
    [sym_ns_map_lit] = STATE(389),
    [sym_var_quoting_lit] = STATE(389),
    [sym_sym_val_lit] = STATE(389),
    [sym_evaling_lit] = STATE(389),
    [sym_tagged_or_ctor_lit] = STATE(389),
    [sym_derefing_lit] = STATE(389),
    [sym_quoting_lit] = STATE(389),
    [sym_syn_quoting_lit] = STATE(389),
    [sym_unquote_splicing_lit] = STATE(389),
    [sym_unquoting_lit] = STATE(389),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(308),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(308),
    [sym_nil_lit] = ACTIONS(314),
    [sym_bool_lit] = ACTIONS(314),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [215] = {
    [sym__gap] = STATE(201),
    [sym_dis_expr] = STATE(201),
    [sym__form] = STATE(354),
    [sym_kwd_lit] = STATE(354),
    [sym_str_lit] = STATE(354),
    [sym_sym_lit] = STATE(354),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(354),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(354),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(354),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(354),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(354),
    [sym_regex_lit] = STATE(354),
    [sym_read_cond_lit] = STATE(354),
    [sym_splicing_read_cond_lit] = STATE(354),
    [sym_ns_map_lit] = STATE(354),
    [sym_var_quoting_lit] = STATE(354),
    [sym_sym_val_lit] = STATE(354),
    [sym_evaling_lit] = STATE(354),
    [sym_tagged_or_ctor_lit] = STATE(354),
    [sym_derefing_lit] = STATE(354),
    [sym_quoting_lit] = STATE(354),
    [sym_syn_quoting_lit] = STATE(354),
    [sym_unquote_splicing_lit] = STATE(354),
    [sym_unquoting_lit] = STATE(354),
    [aux_sym_dis_expr_repeat1] = STATE(201),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(842),
    [sym_comment] = ACTIONS(842),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(484),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(484),
    [sym_nil_lit] = ACTIONS(486),
    [sym_bool_lit] = ACTIONS(486),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [216] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(385),
    [sym_kwd_lit] = STATE(385),
    [sym_str_lit] = STATE(385),
    [sym_sym_lit] = STATE(385),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(385),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(385),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(385),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(385),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(385),
    [sym_regex_lit] = STATE(385),
    [sym_read_cond_lit] = STATE(385),
    [sym_splicing_read_cond_lit] = STATE(385),
    [sym_ns_map_lit] = STATE(385),
    [sym_var_quoting_lit] = STATE(385),
    [sym_sym_val_lit] = STATE(385),
    [sym_evaling_lit] = STATE(385),
    [sym_tagged_or_ctor_lit] = STATE(385),
    [sym_derefing_lit] = STATE(385),
    [sym_quoting_lit] = STATE(385),
    [sym_syn_quoting_lit] = STATE(385),
    [sym_unquote_splicing_lit] = STATE(385),
    [sym_unquoting_lit] = STATE(385),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(552),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(552),
    [sym_nil_lit] = ACTIONS(554),
    [sym_bool_lit] = ACTIONS(554),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [217] = {
    [sym__gap] = STATE(208),
    [sym_dis_expr] = STATE(208),
    [sym__form] = STATE(375),
    [sym_kwd_lit] = STATE(375),
    [sym_str_lit] = STATE(375),
    [sym_sym_lit] = STATE(375),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(375),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(375),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(375),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(375),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(375),
    [sym_regex_lit] = STATE(375),
    [sym_read_cond_lit] = STATE(375),
    [sym_splicing_read_cond_lit] = STATE(375),
    [sym_ns_map_lit] = STATE(375),
    [sym_var_quoting_lit] = STATE(375),
    [sym_sym_val_lit] = STATE(375),
    [sym_evaling_lit] = STATE(375),
    [sym_tagged_or_ctor_lit] = STATE(375),
    [sym_derefing_lit] = STATE(375),
    [sym_quoting_lit] = STATE(375),
    [sym_syn_quoting_lit] = STATE(375),
    [sym_unquote_splicing_lit] = STATE(375),
    [sym_unquoting_lit] = STATE(375),
    [aux_sym_dis_expr_repeat1] = STATE(208),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(844),
    [sym_comment] = ACTIONS(844),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(522),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(522),
    [sym_nil_lit] = ACTIONS(524),
    [sym_bool_lit] = ACTIONS(524),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [218] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(389),
    [sym_kwd_lit] = STATE(389),
    [sym_str_lit] = STATE(389),
    [sym_sym_lit] = STATE(389),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(389),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(389),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(389),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(389),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(389),
    [sym_regex_lit] = STATE(389),
    [sym_read_cond_lit] = STATE(389),
    [sym_splicing_read_cond_lit] = STATE(389),
    [sym_ns_map_lit] = STATE(389),
    [sym_var_quoting_lit] = STATE(389),
    [sym_sym_val_lit] = STATE(389),
    [sym_evaling_lit] = STATE(389),
    [sym_tagged_or_ctor_lit] = STATE(389),
    [sym_derefing_lit] = STATE(389),
    [sym_quoting_lit] = STATE(389),
    [sym_syn_quoting_lit] = STATE(389),
    [sym_unquote_splicing_lit] = STATE(389),
    [sym_unquoting_lit] = STATE(389),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(319),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(308),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(308),
    [sym_nil_lit] = ACTIONS(314),
    [sym_bool_lit] = ACTIONS(314),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [219] = {
    [sym__gap] = STATE(207),
    [sym_dis_expr] = STATE(207),
    [sym__form] = STATE(369),
    [sym_kwd_lit] = STATE(369),
    [sym_str_lit] = STATE(369),
    [sym_sym_lit] = STATE(369),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(369),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(369),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(369),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(369),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(369),
    [sym_regex_lit] = STATE(369),
    [sym_read_cond_lit] = STATE(369),
    [sym_splicing_read_cond_lit] = STATE(369),
    [sym_ns_map_lit] = STATE(369),
    [sym_var_quoting_lit] = STATE(369),
    [sym_sym_val_lit] = STATE(369),
    [sym_evaling_lit] = STATE(369),
    [sym_tagged_or_ctor_lit] = STATE(369),
    [sym_derefing_lit] = STATE(369),
    [sym_quoting_lit] = STATE(369),
    [sym_syn_quoting_lit] = STATE(369),
    [sym_unquote_splicing_lit] = STATE(369),
    [sym_unquoting_lit] = STATE(369),
    [aux_sym_dis_expr_repeat1] = STATE(207),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(846),
    [sym_comment] = ACTIONS(846),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(516),
    [sym_nil_lit] = ACTIONS(518),
    [sym_bool_lit] = ACTIONS(518),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [220] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(385),
    [sym_kwd_lit] = STATE(385),
    [sym_str_lit] = STATE(385),
    [sym_sym_lit] = STATE(385),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(385),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(385),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(385),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(385),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(385),
    [sym_regex_lit] = STATE(385),
    [sym_read_cond_lit] = STATE(385),
    [sym_splicing_read_cond_lit] = STATE(385),
    [sym_ns_map_lit] = STATE(385),
    [sym_var_quoting_lit] = STATE(385),
    [sym_sym_val_lit] = STATE(385),
    [sym_evaling_lit] = STATE(385),
    [sym_tagged_or_ctor_lit] = STATE(385),
    [sym_derefing_lit] = STATE(385),
    [sym_quoting_lit] = STATE(385),
    [sym_syn_quoting_lit] = STATE(385),
    [sym_unquote_splicing_lit] = STATE(385),
    [sym_unquoting_lit] = STATE(385),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(552),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(552),
    [sym_nil_lit] = ACTIONS(554),
    [sym_bool_lit] = ACTIONS(554),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [221] = {
    [sym__gap] = STATE(206),
    [sym_dis_expr] = STATE(206),
    [sym__form] = STATE(367),
    [sym_kwd_lit] = STATE(367),
    [sym_str_lit] = STATE(367),
    [sym_sym_lit] = STATE(367),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(367),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(367),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(367),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(367),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(367),
    [sym_regex_lit] = STATE(367),
    [sym_read_cond_lit] = STATE(367),
    [sym_splicing_read_cond_lit] = STATE(367),
    [sym_ns_map_lit] = STATE(367),
    [sym_var_quoting_lit] = STATE(367),
    [sym_sym_val_lit] = STATE(367),
    [sym_evaling_lit] = STATE(367),
    [sym_tagged_or_ctor_lit] = STATE(367),
    [sym_derefing_lit] = STATE(367),
    [sym_quoting_lit] = STATE(367),
    [sym_syn_quoting_lit] = STATE(367),
    [sym_unquote_splicing_lit] = STATE(367),
    [sym_unquoting_lit] = STATE(367),
    [aux_sym_dis_expr_repeat1] = STATE(206),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(848),
    [sym_comment] = ACTIONS(848),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(510),
    [sym_nil_lit] = ACTIONS(512),
    [sym_bool_lit] = ACTIONS(512),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [222] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(333),
    [sym_kwd_lit] = STATE(333),
    [sym_str_lit] = STATE(333),
    [sym_sym_lit] = STATE(333),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(333),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(333),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(333),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(333),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(333),
    [sym_regex_lit] = STATE(333),
    [sym_read_cond_lit] = STATE(333),
    [sym_splicing_read_cond_lit] = STATE(333),
    [sym_ns_map_lit] = STATE(333),
    [sym_var_quoting_lit] = STATE(333),
    [sym_sym_val_lit] = STATE(333),
    [sym_evaling_lit] = STATE(333),
    [sym_tagged_or_ctor_lit] = STATE(333),
    [sym_derefing_lit] = STATE(333),
    [sym_quoting_lit] = STATE(333),
    [sym_syn_quoting_lit] = STATE(333),
    [sym_unquote_splicing_lit] = STATE(333),
    [sym_unquoting_lit] = STATE(333),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(544),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(544),
    [sym_nil_lit] = ACTIONS(546),
    [sym_bool_lit] = ACTIONS(546),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [223] = {
    [sym__gap] = STATE(205),
    [sym_dis_expr] = STATE(205),
    [sym__form] = STATE(365),
    [sym_kwd_lit] = STATE(365),
    [sym_str_lit] = STATE(365),
    [sym_sym_lit] = STATE(365),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(365),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(365),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(365),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(365),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(365),
    [sym_regex_lit] = STATE(365),
    [sym_read_cond_lit] = STATE(365),
    [sym_splicing_read_cond_lit] = STATE(365),
    [sym_ns_map_lit] = STATE(365),
    [sym_var_quoting_lit] = STATE(365),
    [sym_sym_val_lit] = STATE(365),
    [sym_evaling_lit] = STATE(365),
    [sym_tagged_or_ctor_lit] = STATE(365),
    [sym_derefing_lit] = STATE(365),
    [sym_quoting_lit] = STATE(365),
    [sym_syn_quoting_lit] = STATE(365),
    [sym_unquote_splicing_lit] = STATE(365),
    [sym_unquoting_lit] = STATE(365),
    [aux_sym_dis_expr_repeat1] = STATE(205),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(850),
    [sym_comment] = ACTIONS(850),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(504),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(504),
    [sym_nil_lit] = ACTIONS(506),
    [sym_bool_lit] = ACTIONS(506),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
  [224] = {
    [sym__gap] = STATE(314),
    [sym_dis_expr] = STATE(314),
    [sym__form] = STATE(383),
    [sym_kwd_lit] = STATE(383),
    [sym_str_lit] = STATE(383),
    [sym_sym_lit] = STATE(383),
    [sym__metadata_lit] = STATE(451),
    [sym_meta_lit] = STATE(422),
    [sym_old_meta_lit] = STATE(424),
    [sym_list_lit] = STATE(383),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(383),
    [sym__bare_map_lit] = STATE(391),
    [sym_vec_lit] = STATE(383),
    [sym__bare_vec_lit] = STATE(395),
    [sym_set_lit] = STATE(383),
    [sym__bare_set_lit] = STATE(346),
    [sym_anon_fn_lit] = STATE(383),
    [sym_regex_lit] = STATE(383),
    [sym_read_cond_lit] = STATE(383),
    [sym_splicing_read_cond_lit] = STATE(383),
    [sym_ns_map_lit] = STATE(383),
    [sym_var_quoting_lit] = STATE(383),
    [sym_sym_val_lit] = STATE(383),
    [sym_evaling_lit] = STATE(383),
    [sym_tagged_or_ctor_lit] = STATE(383),
    [sym_derefing_lit] = STATE(383),
    [sym_quoting_lit] = STATE(383),
    [sym_syn_quoting_lit] = STATE(383),
    [sym_unquote_splicing_lit] = STATE(383),
    [sym_unquoting_lit] = STATE(383),
    [aux_sym_dis_expr_repeat1] = STATE(314),
    [aux_sym_sym_lit_repeat1] = STATE(332),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(540),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(454),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(540),
    [sym_nil_lit] = ACTIONS(542),
    [sym_bool_lit] = ACTIONS(542),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(460),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [anon_sym_BQUOTE] = ACTIONS(466),
    [anon_sym_TILDE_AT] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(470),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(856), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(854), 14,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_SQUOTE,
      anon_sym_TILDE,
    ACTIONS(852), 18,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      sym_num_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_AT,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [40] = 2,
    ACTIONS(860), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(858), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [77] = 2,
    ACTIONS(864), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(862), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [114] = 2,
    ACTIONS(868), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(866), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [151] = 3,
    ACTIONS(872), 1,
      anon_sym_SLASH,
    ACTIONS(874), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(870), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [190] = 2,
    ACTIONS(878), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(876), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [227] = 2,
    ACTIONS(882), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(880), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [264] = 2,
    ACTIONS(886), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(884), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [301] = 2,
    ACTIONS(890), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(888), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [338] = 2,
    ACTIONS(894), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(892), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [375] = 3,
    ACTIONS(896), 1,
      anon_sym_SLASH,
    ACTIONS(854), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(852), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [414] = 2,
    ACTIONS(900), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(898), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [451] = 2,
    ACTIONS(904), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(902), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [488] = 2,
    ACTIONS(908), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(906), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [525] = 2,
    ACTIONS(912), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(910), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [562] = 2,
    ACTIONS(916), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(914), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [599] = 2,
    ACTIONS(920), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(918), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [636] = 2,
    ACTIONS(924), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(922), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [673] = 2,
    ACTIONS(928), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(926), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [710] = 2,
    ACTIONS(932), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(930), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [747] = 2,
    ACTIONS(936), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(934), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [784] = 2,
    ACTIONS(940), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(938), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [821] = 2,
    ACTIONS(944), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(942), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [858] = 2,
    ACTIONS(948), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(946), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [895] = 2,
    ACTIONS(952), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(950), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [932] = 2,
    ACTIONS(956), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(954), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [969] = 2,
    ACTIONS(960), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(958), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1006] = 3,
    ACTIONS(962), 1,
      anon_sym_SLASH,
    ACTIONS(960), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(958), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1045] = 2,
    ACTIONS(966), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(964), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1082] = 2,
    ACTIONS(970), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(968), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1119] = 2,
    ACTIONS(974), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(972), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1156] = 2,
    ACTIONS(978), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(976), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1193] = 2,
    ACTIONS(982), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(980), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1230] = 2,
    ACTIONS(986), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(984), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1267] = 2,
    ACTIONS(990), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(988), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1304] = 2,
    ACTIONS(994), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(992), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1341] = 2,
    ACTIONS(998), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(996), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1378] = 2,
    ACTIONS(1002), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1000), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1415] = 2,
    ACTIONS(1006), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1004), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1452] = 2,
    ACTIONS(1010), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1008), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1489] = 2,
    ACTIONS(1014), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1012), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1526] = 2,
    ACTIONS(1018), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1016), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1563] = 2,
    ACTIONS(1022), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1020), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1600] = 2,
    ACTIONS(1026), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1024), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1637] = 2,
    ACTIONS(1030), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1028), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1674] = 2,
    ACTIONS(1034), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1032), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1711] = 2,
    ACTIONS(1038), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1036), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1748] = 2,
    ACTIONS(1042), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1040), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1785] = 2,
    ACTIONS(1046), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1044), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1822] = 2,
    ACTIONS(1050), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1048), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1859] = 2,
    ACTIONS(1054), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1052), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1896] = 2,
    ACTIONS(874), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(870), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1933] = 2,
    ACTIONS(1058), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1056), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1970] = 2,
    ACTIONS(1062), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1060), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2007] = 2,
    ACTIONS(1066), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1064), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2044] = 2,
    ACTIONS(1070), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1068), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2081] = 2,
    ACTIONS(1070), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1068), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2118] = 2,
    ACTIONS(1070), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1068), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2155] = 2,
    ACTIONS(1074), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1072), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2192] = 2,
    ACTIONS(1078), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1076), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2229] = 2,
    ACTIONS(1082), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1080), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2266] = 2,
    ACTIONS(1086), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1084), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2303] = 2,
    ACTIONS(1090), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1088), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2340] = 2,
    ACTIONS(1094), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1092), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2377] = 2,
    ACTIONS(1098), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1096), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2414] = 2,
    ACTIONS(1102), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1100), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2451] = 2,
    ACTIONS(1106), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1104), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2488] = 2,
    ACTIONS(1110), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1108), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2525] = 2,
    ACTIONS(1114), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1112), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2562] = 2,
    ACTIONS(1118), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1116), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2599] = 2,
    ACTIONS(1122), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1120), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2636] = 2,
    ACTIONS(1118), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1116), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2673] = 2,
    ACTIONS(1126), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1124), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2710] = 2,
    ACTIONS(1126), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1124), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2747] = 2,
    ACTIONS(1126), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1124), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2784] = 2,
    ACTIONS(1130), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1128), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2821] = 2,
    ACTIONS(1134), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1132), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2858] = 2,
    ACTIONS(1138), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1136), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2895] = 2,
    ACTIONS(1142), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1140), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2932] = 2,
    ACTIONS(1146), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1144), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2969] = 2,
    ACTIONS(1150), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1148), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3006] = 2,
    ACTIONS(1142), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1140), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3043] = 2,
    ACTIONS(1154), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1152), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3080] = 2,
    ACTIONS(1158), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1156), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3117] = 2,
    ACTIONS(1162), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1160), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3154] = 2,
    ACTIONS(1166), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1164), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3191] = 2,
    ACTIONS(1170), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1168), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3228] = 2,
    ACTIONS(1174), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1172), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3265] = 2,
    ACTIONS(1178), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1176), 24,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3301] = 5,
    ACTIONS(1183), 1,
      anon_sym_POUND_,
    ACTIONS(1180), 2,
      sym__ws,
      sym_comment,
    STATE(314), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1188), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1186), 18,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3343] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(416), 1,
      anon_sym_COLON,
    ACTIONS(418), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1190), 2,
      sym__ws,
      sym_comment,
    STATE(462), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(443), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3405] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_LBRACK,
    ACTIONS(1202), 1,
      anon_sym_SLASH,
    ACTIONS(1204), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1206), 1,
      anon_sym_POUND,
    ACTIONS(1208), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1210), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1212), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1214), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1216), 1,
      anon_sym_AT,
    ACTIONS(1218), 1,
      anon_sym_SQUOTE,
    ACTIONS(1220), 1,
      anon_sym_BQUOTE,
    ACTIONS(1222), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1224), 1,
      anon_sym_TILDE,
    STATE(413), 1,
      sym__bare_set_lit,
    STATE(414), 1,
      sym__bare_vec_lit,
    STATE(415), 1,
      sym__bare_map_lit,
    STATE(416), 1,
      sym__bare_list_lit,
    STATE(422), 1,
      sym_meta_lit,
    STATE(424), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      aux_sym_sym_lit_repeat1,
    STATE(451), 1,
      sym__metadata_lit,
  [3481] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(270), 1,
      anon_sym_COLON,
    ACTIONS(272), 1,
      anon_sym_COLON_COLON,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1226), 2,
      sym__ws,
      sym_comment,
    STATE(326), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(441), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3543] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(270), 1,
      anon_sym_COLON,
    ACTIONS(272), 1,
      anon_sym_COLON_COLON,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1228), 2,
      sym__ws,
      sym_comment,
    STATE(327), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(449), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3605] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_LBRACK,
    ACTIONS(1202), 1,
      anon_sym_SLASH,
    ACTIONS(1204), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1208), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1210), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1214), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1230), 1,
      anon_sym_POUND,
    ACTIONS(1232), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1234), 1,
      anon_sym_AT,
    ACTIONS(1236), 1,
      anon_sym_SQUOTE,
    ACTIONS(1238), 1,
      anon_sym_BQUOTE,
    ACTIONS(1240), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1242), 1,
      anon_sym_TILDE,
    STATE(413), 1,
      sym__bare_set_lit,
    STATE(414), 1,
      sym__bare_vec_lit,
    STATE(415), 1,
      sym__bare_map_lit,
    STATE(416), 1,
      sym__bare_list_lit,
    STATE(422), 1,
      sym_meta_lit,
    STATE(424), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      aux_sym_sym_lit_repeat1,
    STATE(451), 1,
      sym__metadata_lit,
  [3681] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(310), 1,
      anon_sym_COLON,
    ACTIONS(312), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1190), 2,
      sym__ws,
      sym_comment,
    STATE(462), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(444), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3743] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(310), 1,
      anon_sym_COLON,
    ACTIONS(312), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1190), 2,
      sym__ws,
      sym_comment,
    STATE(462), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(443), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3805] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(310), 1,
      anon_sym_COLON,
    ACTIONS(312), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1244), 2,
      sym__ws,
      sym_comment,
    STATE(320), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(449), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3867] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(310), 1,
      anon_sym_COLON,
    ACTIONS(312), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1246), 2,
      sym__ws,
      sym_comment,
    STATE(321), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(441), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3929] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_LBRACK,
    ACTIONS(1202), 1,
      anon_sym_SLASH,
    ACTIONS(1204), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1208), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1210), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1214), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1248), 1,
      anon_sym_POUND,
    ACTIONS(1250), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1252), 1,
      anon_sym_AT,
    ACTIONS(1254), 1,
      anon_sym_SQUOTE,
    ACTIONS(1256), 1,
      anon_sym_BQUOTE,
    ACTIONS(1258), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1260), 1,
      anon_sym_TILDE,
    STATE(413), 1,
      sym__bare_set_lit,
    STATE(414), 1,
      sym__bare_vec_lit,
    STATE(415), 1,
      sym__bare_map_lit,
    STATE(416), 1,
      sym__bare_list_lit,
    STATE(422), 1,
      sym_meta_lit,
    STATE(424), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      aux_sym_sym_lit_repeat1,
    STATE(451), 1,
      sym__metadata_lit,
  [4005] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_LBRACK,
    ACTIONS(1262), 1,
      anon_sym_SLASH,
    ACTIONS(1264), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1266), 1,
      anon_sym_POUND,
    ACTIONS(1268), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1270), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1272), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1274), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1276), 1,
      anon_sym_AT,
    ACTIONS(1278), 1,
      anon_sym_SQUOTE,
    ACTIONS(1280), 1,
      anon_sym_BQUOTE,
    ACTIONS(1282), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1284), 1,
      anon_sym_TILDE,
    STATE(253), 1,
      sym__bare_list_lit,
    STATE(254), 1,
      sym__bare_map_lit,
    STATE(255), 1,
      sym__bare_vec_lit,
    STATE(256), 1,
      sym__bare_set_lit,
    STATE(422), 1,
      sym_meta_lit,
    STATE(424), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      aux_sym_sym_lit_repeat1,
    STATE(451), 1,
      sym__metadata_lit,
  [4081] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(270), 1,
      anon_sym_COLON,
    ACTIONS(272), 1,
      anon_sym_COLON_COLON,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1190), 2,
      sym__ws,
      sym_comment,
    STATE(462), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(443), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [4143] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(270), 1,
      anon_sym_COLON,
    ACTIONS(272), 1,
      anon_sym_COLON_COLON,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1190), 2,
      sym__ws,
      sym_comment,
    STATE(462), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(444), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [4205] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(416), 1,
      anon_sym_COLON,
    ACTIONS(418), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1190), 2,
      sym__ws,
      sym_comment,
    STATE(462), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(444), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [4267] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_LBRACK,
    ACTIONS(1262), 1,
      anon_sym_SLASH,
    ACTIONS(1264), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1268), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1270), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1274), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1286), 1,
      anon_sym_POUND,
    ACTIONS(1288), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1290), 1,
      anon_sym_AT,
    ACTIONS(1292), 1,
      anon_sym_SQUOTE,
    ACTIONS(1294), 1,
      anon_sym_BQUOTE,
    ACTIONS(1296), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1298), 1,
      anon_sym_TILDE,
    STATE(253), 1,
      sym__bare_list_lit,
    STATE(254), 1,
      sym__bare_map_lit,
    STATE(255), 1,
      sym__bare_vec_lit,
    STATE(256), 1,
      sym__bare_set_lit,
    STATE(422), 1,
      sym_meta_lit,
    STATE(424), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      aux_sym_sym_lit_repeat1,
    STATE(451), 1,
      sym__metadata_lit,
  [4343] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(416), 1,
      anon_sym_COLON,
    ACTIONS(418), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1300), 2,
      sym__ws,
      sym_comment,
    STATE(328), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(449), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [4405] = 18,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(274), 1,
      aux_sym_str_lit_token1,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(416), 1,
      anon_sym_COLON,
    ACTIONS(418), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1192), 1,
      anon_sym_POUND_,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    STATE(391), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(477), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1302), 2,
      sym__ws,
      sym_comment,
    STATE(315), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(441), 5,
      sym_kwd_lit,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [4467] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_LBRACK,
    ACTIONS(1202), 1,
      anon_sym_SLASH,
    ACTIONS(1204), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1208), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1210), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1214), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1304), 1,
      anon_sym_POUND,
    ACTIONS(1306), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1308), 1,
      anon_sym_AT,
    ACTIONS(1310), 1,
      anon_sym_SQUOTE,
    ACTIONS(1312), 1,
      anon_sym_BQUOTE,
    ACTIONS(1314), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1316), 1,
      anon_sym_TILDE,
    STATE(413), 1,
      sym__bare_set_lit,
    STATE(414), 1,
      sym__bare_vec_lit,
    STATE(415), 1,
      sym__bare_map_lit,
    STATE(416), 1,
      sym__bare_list_lit,
    STATE(422), 1,
      sym_meta_lit,
    STATE(424), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      aux_sym_sym_lit_repeat1,
    STATE(451), 1,
      sym__metadata_lit,
  [4543] = 2,
    ACTIONS(1042), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1040), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4571] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1324), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1332), 1,
      anon_sym_LBRACE,
    STATE(163), 1,
      sym_sym_lit,
    STATE(240), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1318), 2,
      sym__ws,
      sym_comment,
    STATE(499), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(460), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [4633] = 5,
    ACTIONS(1337), 1,
      anon_sym_POUND_,
    ACTIONS(1334), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1188), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(335), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1186), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4667] = 3,
    ACTIONS(1340), 1,
      anon_sym_SLASH,
    ACTIONS(874), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(870), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4697] = 2,
    ACTIONS(868), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(866), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4725] = 2,
    ACTIONS(874), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(870), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4753] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1344), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1346), 1,
      anon_sym_LBRACE,
    STATE(209), 1,
      sym_sym_lit,
    STATE(374), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1342), 2,
      sym__ws,
      sym_comment,
    STATE(487), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(459), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [4815] = 2,
    ACTIONS(928), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(926), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4843] = 2,
    ACTIONS(924), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(922), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4871] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1344), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1346), 1,
      anon_sym_LBRACE,
    STATE(181), 1,
      sym_sym_lit,
    STATE(374), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1348), 2,
      sym__ws,
      sym_comment,
    STATE(487), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(461), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [4933] = 2,
    ACTIONS(1130), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1128), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4961] = 2,
    ACTIONS(1146), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1144), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4989] = 2,
    ACTIONS(864), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(862), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5017] = 2,
    ACTIONS(890), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(888), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5045] = 2,
    ACTIONS(1118), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1116), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5073] = 2,
    ACTIONS(894), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(892), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5101] = 2,
    ACTIONS(1122), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1120), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5129] = 2,
    ACTIONS(1118), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1116), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5157] = 2,
    ACTIONS(1114), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1112), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5185] = 2,
    ACTIONS(932), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(930), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5213] = 2,
    ACTIONS(1126), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1124), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5241] = 2,
    ACTIONS(1110), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1108), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5269] = 2,
    ACTIONS(1106), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1104), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5297] = 2,
    ACTIONS(1102), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1100), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5325] = 2,
    ACTIONS(1174), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1172), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5353] = 2,
    ACTIONS(1098), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1096), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5381] = 2,
    ACTIONS(1094), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1092), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5409] = 3,
    ACTIONS(1350), 1,
      anon_sym_SLASH,
    ACTIONS(854), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(852), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5439] = 2,
    ACTIONS(1090), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1088), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5467] = 2,
    ACTIONS(900), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(898), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5495] = 2,
    ACTIONS(1086), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1084), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5523] = 2,
    ACTIONS(904), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(902), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5551] = 2,
    ACTIONS(1082), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1080), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5579] = 2,
    ACTIONS(908), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(906), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5607] = 2,
    ACTIONS(1078), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1076), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5635] = 2,
    ACTIONS(912), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(910), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5663] = 2,
    ACTIONS(1074), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1072), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5691] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1324), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1332), 1,
      anon_sym_LBRACE,
    STATE(55), 1,
      sym_sym_lit,
    STATE(240), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1352), 2,
      sym__ws,
      sym_comment,
    STATE(499), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(463), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5753] = 2,
    ACTIONS(1070), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1068), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5781] = 2,
    ACTIONS(1070), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1068), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5809] = 2,
    ACTIONS(1070), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1068), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5837] = 2,
    ACTIONS(916), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(914), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5865] = 2,
    ACTIONS(1066), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1064), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5893] = 2,
    ACTIONS(1062), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1060), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5921] = 2,
    ACTIONS(1058), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1056), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5949] = 2,
    ACTIONS(1150), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1148), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5977] = 2,
    ACTIONS(1054), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1052), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6005] = 2,
    ACTIONS(1170), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1168), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6033] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1344), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1346), 1,
      anon_sym_LBRACE,
    STATE(197), 1,
      sym_sym_lit,
    STATE(374), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1354), 2,
      sym__ws,
      sym_comment,
    STATE(487), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(466), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6095] = 2,
    ACTIONS(1050), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1048), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6123] = 2,
    ACTIONS(1046), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1044), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6151] = 2,
    ACTIONS(1126), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1124), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6179] = 2,
    ACTIONS(1038), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1036), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6207] = 2,
    ACTIONS(1166), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1164), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6235] = 2,
    ACTIONS(1034), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1032), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6263] = 2,
    ACTIONS(1030), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1028), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6291] = 2,
    ACTIONS(1026), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1024), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6319] = 2,
    ACTIONS(1126), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1124), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6347] = 2,
    ACTIONS(882), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(880), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6375] = 2,
    ACTIONS(878), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(876), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6403] = 2,
    ACTIONS(1134), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1132), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6431] = 2,
    ACTIONS(920), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(918), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6459] = 2,
    ACTIONS(886), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(884), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6487] = 2,
    ACTIONS(1022), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1020), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6515] = 2,
    ACTIONS(1162), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1160), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6543] = 2,
    ACTIONS(1158), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1156), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6571] = 2,
    ACTIONS(1154), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1152), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6599] = 2,
    ACTIONS(1018), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1016), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6627] = 2,
    ACTIONS(1014), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1012), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6655] = 5,
    ACTIONS(1358), 1,
      anon_sym_POUND_,
    ACTIONS(1356), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1362), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(335), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1360), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6689] = 5,
    ACTIONS(1358), 1,
      anon_sym_POUND_,
    ACTIONS(1356), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1366), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(335), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1364), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6723] = 2,
    ACTIONS(860), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(858), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6751] = 2,
    ACTIONS(1010), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1008), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6779] = 2,
    ACTIONS(1006), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1004), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6807] = 2,
    ACTIONS(998), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(996), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6835] = 2,
    ACTIONS(994), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(992), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6863] = 2,
    ACTIONS(1142), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1140), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6891] = 2,
    ACTIONS(990), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(988), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6919] = 2,
    ACTIONS(986), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(984), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6947] = 2,
    ACTIONS(982), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(980), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6975] = 2,
    ACTIONS(978), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(976), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7003] = 2,
    ACTIONS(974), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(972), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7031] = 2,
    ACTIONS(970), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(968), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7059] = 2,
    ACTIONS(966), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(964), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7087] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1344), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1346), 1,
      anon_sym_LBRACE,
    STATE(68), 1,
      sym_sym_lit,
    STATE(374), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1368), 2,
      sym__ws,
      sym_comment,
    STATE(487), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(454), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7149] = 3,
    ACTIONS(1370), 1,
      anon_sym_SLASH,
    ACTIONS(960), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(958), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7179] = 2,
    ACTIONS(960), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(958), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7207] = 2,
    ACTIONS(956), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(954), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7235] = 2,
    ACTIONS(1138), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1136), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7263] = 5,
    ACTIONS(1358), 1,
      anon_sym_POUND_,
    ACTIONS(1372), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1376), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(403), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1374), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7297] = 2,
    ACTIONS(1142), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1140), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7325] = 5,
    ACTIONS(1358), 1,
      anon_sym_POUND_,
    ACTIONS(1378), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1382), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(402), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1380), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7359] = 2,
    ACTIONS(952), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(950), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7387] = 2,
    ACTIONS(948), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(946), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7415] = 2,
    ACTIONS(1002), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1000), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7443] = 2,
    ACTIONS(944), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(942), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7471] = 2,
    ACTIONS(940), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(938), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7499] = 2,
    ACTIONS(936), 4,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(934), 19,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7527] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1332), 1,
      anon_sym_LBRACE,
    STATE(34), 1,
      sym_sym_lit,
    STATE(305), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    STATE(491), 1,
      sym_auto_res_mark,
    STATE(498), 1,
      sym_kwd_lit,
    ACTIONS(1384), 2,
      sym__ws,
      sym_comment,
    STATE(457), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7588] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1346), 1,
      anon_sym_LBRACE,
    STATE(120), 1,
      sym_sym_lit,
    STATE(378), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    STATE(492), 1,
      sym_auto_res_mark,
    STATE(493), 1,
      sym_kwd_lit,
    ACTIONS(1386), 2,
      sym__ws,
      sym_comment,
    STATE(458), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7649] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1346), 1,
      anon_sym_LBRACE,
    STATE(210), 1,
      sym_sym_lit,
    STATE(378), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    STATE(492), 1,
      sym_auto_res_mark,
    STATE(493), 1,
      sym_kwd_lit,
    ACTIONS(1388), 2,
      sym__ws,
      sym_comment,
    STATE(468), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7710] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1346), 1,
      anon_sym_LBRACE,
    STATE(85), 1,
      sym_sym_lit,
    STATE(378), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    STATE(492), 1,
      sym_auto_res_mark,
    STATE(493), 1,
      sym_kwd_lit,
    ACTIONS(1390), 2,
      sym__ws,
      sym_comment,
    STATE(467), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7771] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1346), 1,
      anon_sym_LBRACE,
    STATE(43), 1,
      sym_sym_lit,
    STATE(378), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    STATE(492), 1,
      sym_auto_res_mark,
    STATE(493), 1,
      sym_kwd_lit,
    ACTIONS(1392), 2,
      sym__ws,
      sym_comment,
    STATE(455), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7832] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(390), 1,
      anon_sym_COLON,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1322), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1332), 1,
      anon_sym_LBRACE,
    STATE(130), 1,
      sym_sym_lit,
    STATE(305), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    STATE(491), 1,
      sym_auto_res_mark,
    STATE(498), 1,
      sym_kwd_lit,
    ACTIONS(1394), 2,
      sym__ws,
      sym_comment,
    STATE(452), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7893] = 3,
    ACTIONS(1396), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(854), 9,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_SQUOTE,
      anon_sym_TILDE,
    ACTIONS(852), 11,
      sym__ws,
      sym_comment,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_AT,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7921] = 8,
    ACTIONS(1400), 1,
      anon_sym_CARET,
    ACTIONS(1403), 1,
      anon_sym_POUND_CARET,
    STATE(422), 1,
      sym_meta_lit,
    STATE(424), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      aux_sym_sym_lit_repeat1,
    STATE(451), 1,
      sym__metadata_lit,
    ACTIONS(1406), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1398), 12,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7959] = 15,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    ACTIONS(1412), 1,
      anon_sym_POUND_QMARK,
    STATE(230), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(476), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1408), 2,
      sym__ws,
      sym_comment,
    STATE(270), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(474), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8010] = 17,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    ACTIONS(1412), 1,
      anon_sym_POUND_QMARK,
    STATE(230), 1,
      sym__bare_list_lit,
    STATE(280), 1,
      sym_sym_lit,
    STATE(281), 1,
      sym_list_lit,
    STATE(282), 1,
      sym_read_cond_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(476), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1414), 2,
      sym__ws,
      sym_comment,
    STATE(447), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8065] = 2,
    ACTIONS(1418), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1416), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [8090] = 15,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    ACTIONS(1412), 1,
      anon_sym_POUND_QMARK,
    STATE(230), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(476), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1420), 2,
      sym__ws,
      sym_comment,
    STATE(245), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(439), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8141] = 2,
    ACTIONS(1424), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1422), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [8166] = 2,
    ACTIONS(1428), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1426), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [8191] = 15,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    STATE(392), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(475), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1408), 2,
      sym__ws,
      sym_comment,
    STATE(387), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(474), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8242] = 17,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    STATE(353), 1,
      sym_read_cond_lit,
    STATE(384), 1,
      sym_sym_lit,
    STATE(390), 1,
      sym_list_lit,
    STATE(392), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(475), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1408), 2,
      sym__ws,
      sym_comment,
    STATE(474), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8297] = 17,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    ACTIONS(1412), 1,
      anon_sym_POUND_QMARK,
    STATE(230), 1,
      sym__bare_list_lit,
    STATE(297), 1,
      sym_read_cond_lit,
    STATE(298), 1,
      sym_list_lit,
    STATE(299), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(476), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1408), 2,
      sym__ws,
      sym_comment,
    STATE(474), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8352] = 17,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    STATE(371), 1,
      sym_read_cond_lit,
    STATE(372), 1,
      sym_list_lit,
    STATE(373), 1,
      sym_sym_lit,
    STATE(392), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(475), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1430), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8407] = 2,
    ACTIONS(1434), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1432), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [8432] = 15,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1200), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    STATE(392), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(475), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1436), 2,
      sym__ws,
      sym_comment,
    STATE(430), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(445), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8483] = 2,
    ACTIONS(1440), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1438), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [8505] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(167), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8545] = 12,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(388), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(496), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8585] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(44), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8625] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(31), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8665] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(269), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8705] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(100), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8745] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(157), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8785] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(215), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8825] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(126), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8865] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(119), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8905] = 5,
    ACTIONS(1188), 1,
      anon_sym_COLON,
    ACTIONS(1447), 1,
      anon_sym_POUND_,
    ACTIONS(1444), 2,
      sym__ws,
      sym_comment,
    STATE(462), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1186), 8,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LBRACE,
      anon_sym_POUND_QMARK,
  [8931] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(116), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8971] = 12,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(1194), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(352), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(496), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1450), 2,
      sym__ws,
      sym_comment,
    STATE(453), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9011] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(244), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1452), 2,
      sym__ws,
      sym_comment,
    STATE(456), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9051] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(86), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9091] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(45), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9131] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1326), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(199), 1,
      sym_sym_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(485), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9171] = 4,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    ACTIONS(1454), 2,
      sym__ws,
      sym_comment,
    STATE(471), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1374), 7,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_POUND_QMARK,
  [9193] = 4,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    ACTIONS(1456), 2,
      sym__ws,
      sym_comment,
    STATE(472), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1380), 7,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_POUND_QMARK,
  [9215] = 4,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    ACTIONS(1408), 2,
      sym__ws,
      sym_comment,
    STATE(474), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1364), 7,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_POUND_QMARK,
  [9237] = 4,
    ACTIONS(1410), 1,
      anon_sym_POUND_,
    ACTIONS(1408), 2,
      sym__ws,
      sym_comment,
    STATE(474), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1360), 7,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_POUND_QMARK,
  [9259] = 3,
    ACTIONS(1396), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(852), 6,
      sym__ws,
      sym_comment,
      aux_sym_str_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LBRACE,
    ACTIONS(854), 6,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND_QMARK,
  [9279] = 4,
    ACTIONS(1461), 1,
      anon_sym_POUND_,
    ACTIONS(1458), 2,
      sym__ws,
      sym_comment,
    STATE(474), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1186), 7,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_POUND_QMARK,
  [9301] = 11,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1202), 1,
      anon_sym_SLASH,
    ACTIONS(1204), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1464), 1,
      anon_sym_POUND_QMARK,
    STATE(416), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(478), 1,
      aux_sym_sym_lit_repeat1,
  [9335] = 11,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1262), 1,
      anon_sym_SLASH,
    ACTIONS(1264), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1466), 1,
      anon_sym_POUND_QMARK,
    STATE(253), 1,
      sym__bare_list_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(478), 1,
      aux_sym_sym_lit_repeat1,
  [9369] = 11,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1196), 1,
      anon_sym_CARET,
    ACTIONS(1198), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1202), 1,
      anon_sym_SLASH,
    ACTIONS(1204), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1464), 1,
      anon_sym_POUND_QMARK,
    STATE(415), 1,
      sym__bare_map_lit,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(478), 1,
      aux_sym_sym_lit_repeat1,
  [9403] = 7,
    ACTIONS(1468), 1,
      anon_sym_CARET,
    ACTIONS(1471), 1,
      anon_sym_POUND_CARET,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(469), 1,
      sym_meta_lit,
    STATE(470), 1,
      sym_old_meta_lit,
    STATE(478), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1398), 5,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_POUND_QMARK,
  [9429] = 3,
    ACTIONS(1396), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(854), 4,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND_QMARK,
    ACTIONS(852), 6,
      sym__ws,
      sym_comment,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
  [9447] = 4,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1360), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [9466] = 4,
    ACTIONS(1477), 1,
      anon_sym_POUND_,
    ACTIONS(1474), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1186), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [9485] = 4,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1480), 2,
      sym__ws,
      sym_comment,
    STATE(484), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1374), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [9504] = 4,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1482), 2,
      sym__ws,
      sym_comment,
    STATE(480), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1380), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [9523] = 4,
    ACTIONS(1320), 1,
      anon_sym_POUND_,
    ACTIONS(1442), 2,
      sym__ws,
      sym_comment,
    STATE(481), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1364), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [9542] = 8,
    ACTIONS(1262), 1,
      anon_sym_SLASH,
    ACTIONS(1264), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(500), 1,
      aux_sym_sym_lit_repeat1,
  [9567] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(290), 1,
      sym__bare_map_lit,
    ACTIONS(1484), 2,
      sym__ws,
      sym_comment,
    STATE(501), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9586] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(404), 1,
      sym__bare_map_lit,
    ACTIONS(1488), 2,
      sym__ws,
      sym_comment,
    STATE(497), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9605] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(423), 1,
      sym__bare_map_lit,
    ACTIONS(1484), 2,
      sym__ws,
      sym_comment,
    STATE(501), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9624] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(409), 1,
      sym__bare_map_lit,
    ACTIONS(1484), 2,
      sym__ws,
      sym_comment,
    STATE(501), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9643] = 3,
    ACTIONS(1396), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(854), 3,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
    ACTIONS(852), 4,
      sym__ws,
      sym_comment,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [9658] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(296), 1,
      sym__bare_map_lit,
    ACTIONS(1490), 2,
      sym__ws,
      sym_comment,
    STATE(494), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9677] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(347), 1,
      sym__bare_map_lit,
    ACTIONS(1492), 2,
      sym__ws,
      sym_comment,
    STATE(488), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9696] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(350), 1,
      sym__bare_map_lit,
    ACTIONS(1494), 2,
      sym__ws,
      sym_comment,
    STATE(489), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9715] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(303), 1,
      sym__bare_map_lit,
    ACTIONS(1484), 2,
      sym__ws,
      sym_comment,
    STATE(501), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9734] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(306), 1,
      sym__bare_map_lit,
    ACTIONS(1484), 2,
      sym__ws,
      sym_comment,
    STATE(501), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9753] = 8,
    ACTIONS(1202), 1,
      anon_sym_SLASH,
    ACTIONS(1204), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1328), 1,
      anon_sym_CARET,
    ACTIONS(1330), 1,
      anon_sym_POUND_CARET,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(500), 1,
      aux_sym_sym_lit_repeat1,
  [9778] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(356), 1,
      sym__bare_map_lit,
    ACTIONS(1484), 2,
      sym__ws,
      sym_comment,
    STATE(501), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9797] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(294), 1,
      sym__bare_map_lit,
    ACTIONS(1496), 2,
      sym__ws,
      sym_comment,
    STATE(495), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9816] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_POUND_,
    STATE(226), 1,
      sym__bare_map_lit,
    ACTIONS(1498), 2,
      sym__ws,
      sym_comment,
    STATE(486), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9835] = 7,
    ACTIONS(1500), 1,
      anon_sym_CARET,
    ACTIONS(1503), 1,
      anon_sym_POUND_CARET,
    STATE(451), 1,
      sym__metadata_lit,
    STATE(482), 1,
      sym_meta_lit,
    STATE(483), 1,
      sym_old_meta_lit,
    STATE(500), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1398), 2,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
  [9858] = 4,
    ACTIONS(1186), 1,
      anon_sym_LBRACE,
    ACTIONS(1509), 1,
      anon_sym_POUND_,
    ACTIONS(1506), 2,
      sym__ws,
      sym_comment,
    STATE(501), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [9874] = 4,
    ACTIONS(1514), 1,
      anon_sym_POUND_,
    ACTIONS(1516), 1,
      anon_sym_SLASH,
    ACTIONS(1518), 1,
      aux_sym__kwd_qualified_token1,
    ACTIONS(1512), 3,
      sym__ws,
      sym_comment,
      anon_sym_LBRACE,
  [9889] = 3,
    ACTIONS(854), 1,
      anon_sym_POUND_,
    ACTIONS(856), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(852), 3,
      sym__ws,
      sym_comment,
      anon_sym_LBRACE,
  [9901] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1520), 1,
      sym__ws,
    STATE(304), 1,
      sym__bare_list_lit,
    STATE(520), 1,
      aux_sym_read_cond_lit_repeat1,
  [9914] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1522), 1,
      sym__ws,
    STATE(242), 1,
      sym__bare_list_lit,
    STATE(510), 1,
      aux_sym_read_cond_lit_repeat1,
  [9927] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1524), 1,
      sym__ws,
    STATE(278), 1,
      sym__bare_list_lit,
    STATE(504), 1,
      aux_sym_read_cond_lit_repeat1,
  [9940] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1526), 1,
      sym__ws,
    STATE(277), 1,
      sym__bare_list_lit,
    STATE(519), 1,
      aux_sym_read_cond_lit_repeat1,
  [9953] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1520), 1,
      sym__ws,
    STATE(396), 1,
      sym__bare_list_lit,
    STATE(520), 1,
      aux_sym_read_cond_lit_repeat1,
  [9966] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1528), 1,
      sym__ws,
    STATE(377), 1,
      sym__bare_list_lit,
    STATE(517), 1,
      aux_sym_read_cond_lit_repeat1,
  [9979] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1520), 1,
      sym__ws,
    STATE(267), 1,
      sym__bare_list_lit,
    STATE(520), 1,
      aux_sym_read_cond_lit_repeat1,
  [9992] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1520), 1,
      sym__ws,
    STATE(266), 1,
      sym__bare_list_lit,
    STATE(520), 1,
      aux_sym_read_cond_lit_repeat1,
  [10005] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1530), 1,
      sym__ws,
    STATE(241), 1,
      sym__bare_list_lit,
    STATE(511), 1,
      aux_sym_read_cond_lit_repeat1,
  [10018] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1532), 1,
      sym__ws,
    STATE(376), 1,
      sym__bare_list_lit,
    STATE(516), 1,
      aux_sym_read_cond_lit_repeat1,
  [10031] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1534), 1,
      sym__ws,
    STATE(341), 1,
      sym__bare_list_lit,
    STATE(508), 1,
      aux_sym_read_cond_lit_repeat1,
  [10044] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1536), 1,
      sym__ws,
    STATE(394), 1,
      sym__bare_list_lit,
    STATE(518), 1,
      aux_sym_read_cond_lit_repeat1,
  [10057] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1520), 1,
      sym__ws,
    STATE(344), 1,
      sym__bare_list_lit,
    STATE(520), 1,
      aux_sym_read_cond_lit_repeat1,
  [10070] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1520), 1,
      sym__ws,
    STATE(345), 1,
      sym__bare_list_lit,
    STATE(520), 1,
      aux_sym_read_cond_lit_repeat1,
  [10083] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1520), 1,
      sym__ws,
    STATE(400), 1,
      sym__bare_list_lit,
    STATE(520), 1,
      aux_sym_read_cond_lit_repeat1,
  [10096] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1520), 1,
      sym__ws,
    STATE(227), 1,
      sym__bare_list_lit,
    STATE(520), 1,
      aux_sym_read_cond_lit_repeat1,
  [10109] = 3,
    ACTIONS(1538), 1,
      sym__ws,
    ACTIONS(1541), 1,
      anon_sym_LPAREN,
    STATE(520), 1,
      aux_sym_read_cond_lit_repeat1,
  [10119] = 2,
    ACTIONS(1543), 1,
      anon_sym_SLASH,
    ACTIONS(1545), 1,
      aux_sym__kwd_qualified_token1,
  [10126] = 2,
    ACTIONS(1547), 1,
      anon_sym_SLASH,
    ACTIONS(1549), 1,
      aux_sym__kwd_qualified_token1,
  [10133] = 2,
    ACTIONS(1545), 1,
      aux_sym__kwd_qualified_token1,
    ACTIONS(1551), 1,
      anon_sym_SLASH,
  [10140] = 2,
    ACTIONS(1516), 1,
      anon_sym_SLASH,
    ACTIONS(1549), 1,
      aux_sym__kwd_qualified_token1,
  [10147] = 2,
    ACTIONS(1545), 1,
      aux_sym__kwd_qualified_token1,
    ACTIONS(1553), 1,
      anon_sym_SLASH,
  [10154] = 2,
    ACTIONS(1545), 1,
      aux_sym__kwd_qualified_token1,
    ACTIONS(1555), 1,
      anon_sym_SLASH,
  [10161] = 1,
    ACTIONS(1557), 1,
      aux_sym__sym_qualified_token2,
  [10165] = 1,
    ACTIONS(1559), 1,
      aux_sym__sym_qualified_token2,
  [10169] = 1,
    ACTIONS(1561), 1,
      ts_builtin_sym_end,
  [10173] = 1,
    ACTIONS(1563), 1,
      aux_sym__kwd_leading_slash_token1,
  [10177] = 1,
    ACTIONS(1565), 1,
      aux_sym__sym_qualified_token2,
  [10181] = 1,
    ACTIONS(1567), 1,
      aux_sym__kwd_leading_slash_token1,
  [10185] = 1,
    ACTIONS(1569), 1,
      aux_sym__sym_qualified_token2,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(225)] = 0,
  [SMALL_STATE(226)] = 40,
  [SMALL_STATE(227)] = 77,
  [SMALL_STATE(228)] = 114,
  [SMALL_STATE(229)] = 151,
  [SMALL_STATE(230)] = 190,
  [SMALL_STATE(231)] = 227,
  [SMALL_STATE(232)] = 264,
  [SMALL_STATE(233)] = 301,
  [SMALL_STATE(234)] = 338,
  [SMALL_STATE(235)] = 375,
  [SMALL_STATE(236)] = 414,
  [SMALL_STATE(237)] = 451,
  [SMALL_STATE(238)] = 488,
  [SMALL_STATE(239)] = 525,
  [SMALL_STATE(240)] = 562,
  [SMALL_STATE(241)] = 599,
  [SMALL_STATE(242)] = 636,
  [SMALL_STATE(243)] = 673,
  [SMALL_STATE(244)] = 710,
  [SMALL_STATE(245)] = 747,
  [SMALL_STATE(246)] = 784,
  [SMALL_STATE(247)] = 821,
  [SMALL_STATE(248)] = 858,
  [SMALL_STATE(249)] = 895,
  [SMALL_STATE(250)] = 932,
  [SMALL_STATE(251)] = 969,
  [SMALL_STATE(252)] = 1006,
  [SMALL_STATE(253)] = 1045,
  [SMALL_STATE(254)] = 1082,
  [SMALL_STATE(255)] = 1119,
  [SMALL_STATE(256)] = 1156,
  [SMALL_STATE(257)] = 1193,
  [SMALL_STATE(258)] = 1230,
  [SMALL_STATE(259)] = 1267,
  [SMALL_STATE(260)] = 1304,
  [SMALL_STATE(261)] = 1341,
  [SMALL_STATE(262)] = 1378,
  [SMALL_STATE(263)] = 1415,
  [SMALL_STATE(264)] = 1452,
  [SMALL_STATE(265)] = 1489,
  [SMALL_STATE(266)] = 1526,
  [SMALL_STATE(267)] = 1563,
  [SMALL_STATE(268)] = 1600,
  [SMALL_STATE(269)] = 1637,
  [SMALL_STATE(270)] = 1674,
  [SMALL_STATE(271)] = 1711,
  [SMALL_STATE(272)] = 1748,
  [SMALL_STATE(273)] = 1785,
  [SMALL_STATE(274)] = 1822,
  [SMALL_STATE(275)] = 1859,
  [SMALL_STATE(276)] = 1896,
  [SMALL_STATE(277)] = 1933,
  [SMALL_STATE(278)] = 1970,
  [SMALL_STATE(279)] = 2007,
  [SMALL_STATE(280)] = 2044,
  [SMALL_STATE(281)] = 2081,
  [SMALL_STATE(282)] = 2118,
  [SMALL_STATE(283)] = 2155,
  [SMALL_STATE(284)] = 2192,
  [SMALL_STATE(285)] = 2229,
  [SMALL_STATE(286)] = 2266,
  [SMALL_STATE(287)] = 2303,
  [SMALL_STATE(288)] = 2340,
  [SMALL_STATE(289)] = 2377,
  [SMALL_STATE(290)] = 2414,
  [SMALL_STATE(291)] = 2451,
  [SMALL_STATE(292)] = 2488,
  [SMALL_STATE(293)] = 2525,
  [SMALL_STATE(294)] = 2562,
  [SMALL_STATE(295)] = 2599,
  [SMALL_STATE(296)] = 2636,
  [SMALL_STATE(297)] = 2673,
  [SMALL_STATE(298)] = 2710,
  [SMALL_STATE(299)] = 2747,
  [SMALL_STATE(300)] = 2784,
  [SMALL_STATE(301)] = 2821,
  [SMALL_STATE(302)] = 2858,
  [SMALL_STATE(303)] = 2895,
  [SMALL_STATE(304)] = 2932,
  [SMALL_STATE(305)] = 2969,
  [SMALL_STATE(306)] = 3006,
  [SMALL_STATE(307)] = 3043,
  [SMALL_STATE(308)] = 3080,
  [SMALL_STATE(309)] = 3117,
  [SMALL_STATE(310)] = 3154,
  [SMALL_STATE(311)] = 3191,
  [SMALL_STATE(312)] = 3228,
  [SMALL_STATE(313)] = 3265,
  [SMALL_STATE(314)] = 3301,
  [SMALL_STATE(315)] = 3343,
  [SMALL_STATE(316)] = 3405,
  [SMALL_STATE(317)] = 3481,
  [SMALL_STATE(318)] = 3543,
  [SMALL_STATE(319)] = 3605,
  [SMALL_STATE(320)] = 3681,
  [SMALL_STATE(321)] = 3743,
  [SMALL_STATE(322)] = 3805,
  [SMALL_STATE(323)] = 3867,
  [SMALL_STATE(324)] = 3929,
  [SMALL_STATE(325)] = 4005,
  [SMALL_STATE(326)] = 4081,
  [SMALL_STATE(327)] = 4143,
  [SMALL_STATE(328)] = 4205,
  [SMALL_STATE(329)] = 4267,
  [SMALL_STATE(330)] = 4343,
  [SMALL_STATE(331)] = 4405,
  [SMALL_STATE(332)] = 4467,
  [SMALL_STATE(333)] = 4543,
  [SMALL_STATE(334)] = 4571,
  [SMALL_STATE(335)] = 4633,
  [SMALL_STATE(336)] = 4667,
  [SMALL_STATE(337)] = 4697,
  [SMALL_STATE(338)] = 4725,
  [SMALL_STATE(339)] = 4753,
  [SMALL_STATE(340)] = 4815,
  [SMALL_STATE(341)] = 4843,
  [SMALL_STATE(342)] = 4871,
  [SMALL_STATE(343)] = 4933,
  [SMALL_STATE(344)] = 4961,
  [SMALL_STATE(345)] = 4989,
  [SMALL_STATE(346)] = 5017,
  [SMALL_STATE(347)] = 5045,
  [SMALL_STATE(348)] = 5073,
  [SMALL_STATE(349)] = 5101,
  [SMALL_STATE(350)] = 5129,
  [SMALL_STATE(351)] = 5157,
  [SMALL_STATE(352)] = 5185,
  [SMALL_STATE(353)] = 5213,
  [SMALL_STATE(354)] = 5241,
  [SMALL_STATE(355)] = 5269,
  [SMALL_STATE(356)] = 5297,
  [SMALL_STATE(357)] = 5325,
  [SMALL_STATE(358)] = 5353,
  [SMALL_STATE(359)] = 5381,
  [SMALL_STATE(360)] = 5409,
  [SMALL_STATE(361)] = 5439,
  [SMALL_STATE(362)] = 5467,
  [SMALL_STATE(363)] = 5495,
  [SMALL_STATE(364)] = 5523,
  [SMALL_STATE(365)] = 5551,
  [SMALL_STATE(366)] = 5579,
  [SMALL_STATE(367)] = 5607,
  [SMALL_STATE(368)] = 5635,
  [SMALL_STATE(369)] = 5663,
  [SMALL_STATE(370)] = 5691,
  [SMALL_STATE(371)] = 5753,
  [SMALL_STATE(372)] = 5781,
  [SMALL_STATE(373)] = 5809,
  [SMALL_STATE(374)] = 5837,
  [SMALL_STATE(375)] = 5865,
  [SMALL_STATE(376)] = 5893,
  [SMALL_STATE(377)] = 5921,
  [SMALL_STATE(378)] = 5949,
  [SMALL_STATE(379)] = 5977,
  [SMALL_STATE(380)] = 6005,
  [SMALL_STATE(381)] = 6033,
  [SMALL_STATE(382)] = 6095,
  [SMALL_STATE(383)] = 6123,
  [SMALL_STATE(384)] = 6151,
  [SMALL_STATE(385)] = 6179,
  [SMALL_STATE(386)] = 6207,
  [SMALL_STATE(387)] = 6235,
  [SMALL_STATE(388)] = 6263,
  [SMALL_STATE(389)] = 6291,
  [SMALL_STATE(390)] = 6319,
  [SMALL_STATE(391)] = 6347,
  [SMALL_STATE(392)] = 6375,
  [SMALL_STATE(393)] = 6403,
  [SMALL_STATE(394)] = 6431,
  [SMALL_STATE(395)] = 6459,
  [SMALL_STATE(396)] = 6487,
  [SMALL_STATE(397)] = 6515,
  [SMALL_STATE(398)] = 6543,
  [SMALL_STATE(399)] = 6571,
  [SMALL_STATE(400)] = 6599,
  [SMALL_STATE(401)] = 6627,
  [SMALL_STATE(402)] = 6655,
  [SMALL_STATE(403)] = 6689,
  [SMALL_STATE(404)] = 6723,
  [SMALL_STATE(405)] = 6751,
  [SMALL_STATE(406)] = 6779,
  [SMALL_STATE(407)] = 6807,
  [SMALL_STATE(408)] = 6835,
  [SMALL_STATE(409)] = 6863,
  [SMALL_STATE(410)] = 6891,
  [SMALL_STATE(411)] = 6919,
  [SMALL_STATE(412)] = 6947,
  [SMALL_STATE(413)] = 6975,
  [SMALL_STATE(414)] = 7003,
  [SMALL_STATE(415)] = 7031,
  [SMALL_STATE(416)] = 7059,
  [SMALL_STATE(417)] = 7087,
  [SMALL_STATE(418)] = 7149,
  [SMALL_STATE(419)] = 7179,
  [SMALL_STATE(420)] = 7207,
  [SMALL_STATE(421)] = 7235,
  [SMALL_STATE(422)] = 7263,
  [SMALL_STATE(423)] = 7297,
  [SMALL_STATE(424)] = 7325,
  [SMALL_STATE(425)] = 7359,
  [SMALL_STATE(426)] = 7387,
  [SMALL_STATE(427)] = 7415,
  [SMALL_STATE(428)] = 7443,
  [SMALL_STATE(429)] = 7471,
  [SMALL_STATE(430)] = 7499,
  [SMALL_STATE(431)] = 7527,
  [SMALL_STATE(432)] = 7588,
  [SMALL_STATE(433)] = 7649,
  [SMALL_STATE(434)] = 7710,
  [SMALL_STATE(435)] = 7771,
  [SMALL_STATE(436)] = 7832,
  [SMALL_STATE(437)] = 7893,
  [SMALL_STATE(438)] = 7921,
  [SMALL_STATE(439)] = 7959,
  [SMALL_STATE(440)] = 8010,
  [SMALL_STATE(441)] = 8065,
  [SMALL_STATE(442)] = 8090,
  [SMALL_STATE(443)] = 8141,
  [SMALL_STATE(444)] = 8166,
  [SMALL_STATE(445)] = 8191,
  [SMALL_STATE(446)] = 8242,
  [SMALL_STATE(447)] = 8297,
  [SMALL_STATE(448)] = 8352,
  [SMALL_STATE(449)] = 8407,
  [SMALL_STATE(450)] = 8432,
  [SMALL_STATE(451)] = 8483,
  [SMALL_STATE(452)] = 8505,
  [SMALL_STATE(453)] = 8545,
  [SMALL_STATE(454)] = 8585,
  [SMALL_STATE(455)] = 8625,
  [SMALL_STATE(456)] = 8665,
  [SMALL_STATE(457)] = 8705,
  [SMALL_STATE(458)] = 8745,
  [SMALL_STATE(459)] = 8785,
  [SMALL_STATE(460)] = 8825,
  [SMALL_STATE(461)] = 8865,
  [SMALL_STATE(462)] = 8905,
  [SMALL_STATE(463)] = 8931,
  [SMALL_STATE(464)] = 8971,
  [SMALL_STATE(465)] = 9011,
  [SMALL_STATE(466)] = 9051,
  [SMALL_STATE(467)] = 9091,
  [SMALL_STATE(468)] = 9131,
  [SMALL_STATE(469)] = 9171,
  [SMALL_STATE(470)] = 9193,
  [SMALL_STATE(471)] = 9215,
  [SMALL_STATE(472)] = 9237,
  [SMALL_STATE(473)] = 9259,
  [SMALL_STATE(474)] = 9279,
  [SMALL_STATE(475)] = 9301,
  [SMALL_STATE(476)] = 9335,
  [SMALL_STATE(477)] = 9369,
  [SMALL_STATE(478)] = 9403,
  [SMALL_STATE(479)] = 9429,
  [SMALL_STATE(480)] = 9447,
  [SMALL_STATE(481)] = 9466,
  [SMALL_STATE(482)] = 9485,
  [SMALL_STATE(483)] = 9504,
  [SMALL_STATE(484)] = 9523,
  [SMALL_STATE(485)] = 9542,
  [SMALL_STATE(486)] = 9567,
  [SMALL_STATE(487)] = 9586,
  [SMALL_STATE(488)] = 9605,
  [SMALL_STATE(489)] = 9624,
  [SMALL_STATE(490)] = 9643,
  [SMALL_STATE(491)] = 9658,
  [SMALL_STATE(492)] = 9677,
  [SMALL_STATE(493)] = 9696,
  [SMALL_STATE(494)] = 9715,
  [SMALL_STATE(495)] = 9734,
  [SMALL_STATE(496)] = 9753,
  [SMALL_STATE(497)] = 9778,
  [SMALL_STATE(498)] = 9797,
  [SMALL_STATE(499)] = 9816,
  [SMALL_STATE(500)] = 9835,
  [SMALL_STATE(501)] = 9858,
  [SMALL_STATE(502)] = 9874,
  [SMALL_STATE(503)] = 9889,
  [SMALL_STATE(504)] = 9901,
  [SMALL_STATE(505)] = 9914,
  [SMALL_STATE(506)] = 9927,
  [SMALL_STATE(507)] = 9940,
  [SMALL_STATE(508)] = 9953,
  [SMALL_STATE(509)] = 9966,
  [SMALL_STATE(510)] = 9979,
  [SMALL_STATE(511)] = 9992,
  [SMALL_STATE(512)] = 10005,
  [SMALL_STATE(513)] = 10018,
  [SMALL_STATE(514)] = 10031,
  [SMALL_STATE(515)] = 10044,
  [SMALL_STATE(516)] = 10057,
  [SMALL_STATE(517)] = 10070,
  [SMALL_STATE(518)] = 10083,
  [SMALL_STATE(519)] = 10096,
  [SMALL_STATE(520)] = 10109,
  [SMALL_STATE(521)] = 10119,
  [SMALL_STATE(522)] = 10126,
  [SMALL_STATE(523)] = 10133,
  [SMALL_STATE(524)] = 10140,
  [SMALL_STATE(525)] = 10147,
  [SMALL_STATE(526)] = 10154,
  [SMALL_STATE(527)] = 10161,
  [SMALL_STATE(528)] = 10165,
  [SMALL_STATE(529)] = 10169,
  [SMALL_STATE(530)] = 10173,
  [SMALL_STATE(531)] = 10177,
  [SMALL_STATE(532)] = 10181,
  [SMALL_STATE(533)] = 10185,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(522),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(370),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(512),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [53] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(2),
  [56] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(107),
  [59] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(313),
  [62] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(276),
  [65] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(522),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(522),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(228),
  [74] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(313),
  [77] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(229),
  [80] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(317),
  [83] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(318),
  [86] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(9),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21),
  [91] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(10),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(11),
  [97] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(370),
  [100] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(512),
  [103] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(505),
  [106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(111),
  [109] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(465),
  [112] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(442),
  [115] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(24),
  [118] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(25),
  [121] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(26),
  [124] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(27),
  [127] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(28),
  [130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [134] = {.entry = {.count = 1, .reusable = false}}, SHIFT(313),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2),
  [144] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(5),
  [147] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(107),
  [150] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(276),
  [153] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(522),
  [156] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(522),
  [159] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(228),
  [162] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(5),
  [165] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(229),
  [168] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(317),
  [171] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(318),
  [174] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(9),
  [177] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(10),
  [180] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(11),
  [183] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(370),
  [186] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(512),
  [189] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(505),
  [192] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(111),
  [195] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(465),
  [198] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(442),
  [201] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(24),
  [204] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(25),
  [207] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(26),
  [210] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(27),
  [213] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(28),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source, 1),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [270] = {.entry = {.count = 1, .reusable = false}}, SHIFT(523),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [276] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [286] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [288] = {.entry = {.count = 1, .reusable = false}}, SHIFT(515),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [306] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [310] = {.entry = {.count = 1, .reusable = false}}, SHIFT(521),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [314] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [316] = {.entry = {.count = 1, .reusable = false}}, SHIFT(417),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [328] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [334] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [340] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [346] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [364] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [370] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(421),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(427),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(524),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(334),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [412] = {.entry = {.count = 1, .reusable = false}}, SHIFT(397),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [416] = {.entry = {.count = 1, .reusable = false}}, SHIFT(526),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [420] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [438] = {.entry = {.count = 1, .reusable = false}}, SHIFT(380),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [442] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [446] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [452] = {.entry = {.count = 1, .reusable = false}}, SHIFT(525),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [456] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [458] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [474] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [486] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [492] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [506] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [512] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [518] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [524] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [530] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [534] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(382),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [542] = {.entry = {.count = 1, .reusable = false}}, SHIFT(383),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [546] = {.entry = {.count = 1, .reusable = false}}, SHIFT(333),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [550] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [554] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [560] = {.entry = {.count = 1, .reusable = false}}, SHIFT(401),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [564] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [568] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(420),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [578] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(425),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [594] = {.entry = {.count = 1, .reusable = false}}, SHIFT(426),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [598] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [604] = {.entry = {.count = 1, .reusable = false}}, SHIFT(428),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [608] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [614] = {.entry = {.count = 1, .reusable = false}}, SHIFT(429),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [620] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [630] = {.entry = {.count = 1, .reusable = false}}, SHIFT(279),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [638] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [644] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [650] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [656] = {.entry = {.count = 1, .reusable = false}}, SHIFT(286),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [662] = {.entry = {.count = 1, .reusable = false}}, SHIFT(287),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [668] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [680] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [686] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [692] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [696] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [700] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [706] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [710] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [714] = {.entry = {.count = 1, .reusable = false}}, SHIFT(311),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [720] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [726] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [730] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [736] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [740] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_kwd_lit, 2, .production_id = 8),
  [854] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_kwd_lit, 2, .production_id = 8),
  [856] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [858] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 3, .production_id = 23),
  [860] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 3, .production_id = 23),
  [862] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 4, .production_id = 36),
  [864] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 4, .production_id = 36),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_str_lit, 1),
  [868] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_str_lit, 1),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_lit, 1, .production_id = 1),
  [872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [874] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_lit, 1, .production_id = 1),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_lit, 1, .production_id = 5),
  [878] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_lit, 1, .production_id = 5),
  [880] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_lit, 1, .production_id = 5),
  [882] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map_lit, 1, .production_id = 5),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_lit, 1, .production_id = 5),
  [886] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_lit, 1, .production_id = 5),
  [888] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_lit, 1, .production_id = 6),
  [890] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set_lit, 1, .production_id = 6),
  [892] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dis_expr, 2, .production_id = 7),
  [894] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dis_expr, 2, .production_id = 7),
  [896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [898] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_list_lit, 2, .production_id = 9),
  [900] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_list_lit, 2, .production_id = 9),
  [902] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_map_lit, 2, .production_id = 9),
  [904] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_map_lit, 2, .production_id = 9),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_vec_lit, 2, .production_id = 9),
  [908] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_vec_lit, 2, .production_id = 9),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_lit, 2, .production_id = 11),
  [912] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_lit, 2, .production_id = 11),
  [914] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_fn_lit, 2, .production_id = 12),
  [916] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_fn_lit, 2, .production_id = 12),
  [918] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 2, .production_id = 12),
  [920] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 2, .production_id = 12),
  [922] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 2, .production_id = 12),
  [924] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 2, .production_id = 12),
  [926] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 2, .production_id = 7),
  [928] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 2, .production_id = 7),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_val_lit, 2, .production_id = 7),
  [932] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_val_lit, 2, .production_id = 7),
  [934] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 2, .production_id = 7),
  [936] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 2, .production_id = 7),
  [938] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 2, .production_id = 7),
  [940] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 2, .production_id = 7),
  [942] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 2, .production_id = 7),
  [944] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 2, .production_id = 7),
  [946] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 2, .production_id = 7),
  [948] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 2, .production_id = 7),
  [950] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 2, .production_id = 7),
  [952] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 2, .production_id = 7),
  [954] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 2, .production_id = 7),
  [956] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 2, .production_id = 7),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_lit, 2, .production_id = 13),
  [960] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_lit, 2, .production_id = 13),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [964] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_lit, 2, .production_id = 14),
  [966] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_lit, 2, .production_id = 14),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_lit, 2, .production_id = 14),
  [970] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map_lit, 2, .production_id = 14),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_lit, 2, .production_id = 14),
  [974] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_lit, 2, .production_id = 14),
  [976] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_lit, 2, .production_id = 15),
  [978] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set_lit, 2, .production_id = 15),
  [980] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dis_expr, 3, .production_id = 17),
  [982] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dis_expr, 3, .production_id = 17),
  [984] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_kwd_lit, 3, .production_id = 18),
  [986] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_kwd_lit, 3, .production_id = 18),
  [988] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_lit, 3, .production_id = 19),
  [990] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_lit, 3, .production_id = 19),
  [992] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_list_lit, 3, .production_id = 20),
  [994] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_list_lit, 3, .production_id = 20),
  [996] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_map_lit, 3, .production_id = 20),
  [998] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_map_lit, 3, .production_id = 20),
  [1000] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 40),
  [1002] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 40),
  [1004] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_vec_lit, 3, .production_id = 20),
  [1006] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_vec_lit, 3, .production_id = 20),
  [1008] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_set_lit, 3, .production_id = 22),
  [1010] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_set_lit, 3, .production_id = 22),
  [1012] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 3, .production_id = 24),
  [1014] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 3, .production_id = 24),
  [1016] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 3, .production_id = 25),
  [1018] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 3, .production_id = 25),
  [1020] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 25),
  [1022] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 25),
  [1024] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 17),
  [1026] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 17),
  [1028] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_val_lit, 3, .production_id = 17),
  [1030] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_val_lit, 3, .production_id = 17),
  [1032] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 3, .production_id = 17),
  [1034] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 3, .production_id = 17),
  [1036] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 3, .production_id = 17),
  [1038] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 3, .production_id = 17),
  [1040] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 3, .production_id = 17),
  [1042] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 3, .production_id = 17),
  [1044] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 17),
  [1046] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 17),
  [1048] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 17),
  [1050] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 17),
  [1052] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 3, .production_id = 17),
  [1054] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 3, .production_id = 17),
  [1056] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 3, .production_id = 26),
  [1058] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 3, .production_id = 26),
  [1060] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 26),
  [1062] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 26),
  [1064] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 27),
  [1066] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 27),
  [1068] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 3, .production_id = 27),
  [1070] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 3, .production_id = 27),
  [1072] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 3, .production_id = 27),
  [1074] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 3, .production_id = 27),
  [1076] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 3, .production_id = 27),
  [1078] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 3, .production_id = 27),
  [1080] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 27),
  [1082] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 27),
  [1084] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 27),
  [1086] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 27),
  [1088] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 3, .production_id = 27),
  [1090] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 3, .production_id = 27),
  [1092] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_kwd_lit, 4, .production_id = 28),
  [1094] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_kwd_lit, 4, .production_id = 28),
  [1096] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_set_lit, 4, .production_id = 29),
  [1098] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_set_lit, 4, .production_id = 29),
  [1100] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 4, .production_id = 30),
  [1102] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 4, .production_id = 30),
  [1104] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 31),
  [1106] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 31),
  [1108] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 32),
  [1110] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 32),
  [1112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_lit, 4, .production_id = 33),
  [1114] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_lit, 4, .production_id = 33),
  [1116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 4, .production_id = 34),
  [1118] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 4, .production_id = 34),
  [1120] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 35),
  [1122] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 35),
  [1124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 4, .production_id = 37),
  [1126] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 4, .production_id = 37),
  [1128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 4, .production_id = 37),
  [1130] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 4, .production_id = 37),
  [1132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 6, .production_id = 42),
  [1134] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 6, .production_id = 42),
  [1136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 41),
  [1138] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 41),
  [1140] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 5, .production_id = 39),
  [1142] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 5, .production_id = 39),
  [1144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 4, .production_id = 36),
  [1146] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 4, .production_id = 36),
  [1148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_fn_lit, 3, .production_id = 26),
  [1150] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_fn_lit, 3, .production_id = 26),
  [1152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 38),
  [1154] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 38),
  [1156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 4, .production_id = 37),
  [1158] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 4, .production_id = 37),
  [1160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 4, .production_id = 37),
  [1162] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 4, .production_id = 37),
  [1164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 4, .production_id = 37),
  [1166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 4, .production_id = 37),
  [1168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 4, .production_id = 37),
  [1170] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 4, .production_id = 37),
  [1172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 4, .production_id = 37),
  [1174] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 4, .production_id = 37),
  [1176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 1, .production_id = 10),
  [1178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 1, .production_id = 10),
  [1180] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(314),
  [1183] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(107),
  [1186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2),
  [1188] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_dis_expr_repeat1, 2),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(432),
  [1208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(509),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1224] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1230] = {.entry = {.count = 1, .reusable = false}}, SHIFT(434),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1242] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [1248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(435),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1266] = {.entry = {.count = 1, .reusable = false}}, SHIFT(436),
  [1268] = {.entry = {.count = 1, .reusable = false}}, SHIFT(507),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [1276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1284] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [1286] = {.entry = {.count = 1, .reusable = false}}, SHIFT(431),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1298] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1304] = {.entry = {.count = 1, .reusable = false}}, SHIFT(433),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1316] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1334] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(335),
  [1337] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(29),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 2, .production_id = 4),
  [1362] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 2, .production_id = 4),
  [1364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 2, .production_id = 3),
  [1366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 2, .production_id = 3),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [1374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 1, .production_id = 3),
  [1376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 1, .production_id = 3),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 1, .production_id = 4),
  [1382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 1, .production_id = 4),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(411),
  [1398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16),
  [1400] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(317),
  [1403] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(318),
  [1406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_meta_lit, 2, .production_id = 7),
  [1418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_meta_lit, 2, .production_id = 7),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1422] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_meta_lit, 3, .production_id = 17),
  [1424] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_meta_lit, 3, .production_id = 17),
  [1426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_old_meta_lit, 3, .production_id = 17),
  [1428] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_old_meta_lit, 3, .production_id = 17),
  [1430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_old_meta_lit, 2, .production_id = 7),
  [1434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_old_meta_lit, 2, .production_id = 7),
  [1436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1438] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 1, .production_id = 2),
  [1440] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sym_lit_repeat1, 1, .production_id = 2),
  [1442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1444] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(462),
  [1447] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(186),
  [1450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1458] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(474),
  [1461] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(161),
  [1464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [1468] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(331),
  [1471] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(330),
  [1474] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(481),
  [1477] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(23),
  [1480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [1484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [1486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [1492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1500] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(323),
  [1503] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(322),
  [1506] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(501),
  [1509] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(94),
  [1512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_auto_res_mark, 1),
  [1514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_auto_res_mark, 1),
  [1516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [1518] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [1520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [1536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1538] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_read_cond_lit_repeat1, 2), SHIFT_REPEAT(520),
  [1541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_read_cond_lit_repeat1, 2),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1561] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_clojure(void) {
  static TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = (const uint16_t *)ts_parse_table,
    .small_parse_table = (const uint16_t *)ts_small_parse_table,
    .small_parse_table_map = (const uint32_t *)ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = (const TSFieldMapSlice *)ts_field_map_slices,
    .field_map_entries = (const TSFieldMapEntry *)ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = (const TSSymbol *)ts_alias_sequences,
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
