#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 910
#define LARGE_STATE_COUNT 99
#define SYMBOL_COUNT 110
#define ALIAS_COUNT 4
#define TOKEN_COUNT 65
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 12

enum {
  sym_shebang = 1,
  anon_sym_return = 2,
  anon_sym_COMMA = 3,
  anon_sym_EQ = 4,
  anon_sym_local = 5,
  anon_sym_LBRACK = 6,
  anon_sym_RBRACK = 7,
  anon_sym_DOT = 8,
  anon_sym_do = 9,
  anon_sym_end = 10,
  anon_sym_if = 11,
  anon_sym_then = 12,
  anon_sym_elseif = 13,
  anon_sym_else = 14,
  anon_sym_while = 15,
  anon_sym_repeat = 16,
  anon_sym_until = 17,
  anon_sym_for = 18,
  anon_sym_in = 19,
  anon_sym_goto = 20,
  sym_break_statement = 21,
  anon_sym_COLON_COLON = 22,
  anon_sym_SEMI = 23,
  anon_sym_function = 24,
  anon_sym_COLON = 25,
  anon_sym_LPAREN = 26,
  anon_sym_RPAREN = 27,
  sym_spread = 28,
  sym_self = 29,
  sym_next = 30,
  anon_sym__G = 31,
  anon_sym__VERSION = 32,
  anon_sym_LBRACE = 33,
  anon_sym_RBRACE = 34,
  anon_sym_or = 35,
  anon_sym_and = 36,
  anon_sym_LT = 37,
  anon_sym_LT_EQ = 38,
  anon_sym_EQ_EQ = 39,
  anon_sym_TILDE_EQ = 40,
  anon_sym_GT_EQ = 41,
  anon_sym_GT = 42,
  anon_sym_PIPE = 43,
  anon_sym_TILDE = 44,
  anon_sym_AMP = 45,
  anon_sym_LT_LT = 46,
  anon_sym_GT_GT = 47,
  anon_sym_PLUS = 48,
  anon_sym_DASH = 49,
  anon_sym_STAR = 50,
  anon_sym_SLASH = 51,
  anon_sym_SLASH_SLASH = 52,
  anon_sym_PERCENT = 53,
  anon_sym_DOT_DOT = 54,
  anon_sym_CARET = 55,
  anon_sym_not = 56,
  anon_sym_POUND = 57,
  sym_number = 58,
  sym_nil = 59,
  sym_true = 60,
  sym_false = 61,
  sym_identifier = 62,
  sym_comment = 63,
  sym_string = 64,
  sym_program = 65,
  sym_return_statement = 66,
  sym_variable_declaration = 67,
  sym_local_variable_declaration = 68,
  sym__variable_declarator = 69,
  sym_field_expression = 70,
  sym__local_variable_declarator = 71,
  sym_do_statement = 72,
  sym_if_statement = 73,
  sym_elseif = 74,
  sym_else = 75,
  sym_while_statement = 76,
  sym_repeat_statement = 77,
  sym_for_statement = 78,
  sym_for_in_statement = 79,
  sym__loop_expression = 80,
  sym__in_loop_expression = 81,
  sym_goto_statement = 82,
  sym_label_statement = 83,
  sym__empty_statement = 84,
  sym_function_statement = 85,
  sym_local_function_statement = 86,
  sym_function_call_statement = 87,
  sym_arguments = 88,
  sym_function_name = 89,
  sym_function_name_field = 90,
  sym_parameters = 91,
  sym__function_body = 92,
  sym__expression = 93,
  sym_global_variable = 94,
  sym__prefix = 95,
  sym_function_definition = 96,
  sym_table = 97,
  sym_field = 98,
  sym__field_sequence = 99,
  sym__field_sep = 100,
  sym_binary_operation = 101,
  sym_unary_operation = 102,
  aux_sym_program_repeat1 = 103,
  aux_sym_return_statement_repeat1 = 104,
  aux_sym_variable_declaration_repeat1 = 105,
  aux_sym__local_variable_declarator_repeat1 = 106,
  aux_sym_if_statement_repeat1 = 107,
  aux_sym_function_name_field_repeat1 = 108,
  aux_sym__field_sequence_repeat1 = 109,
  alias_sym_condition_expression = 110,
  alias_sym_expression = 111,
  alias_sym_method = 112,
  alias_sym_property_identifier = 113,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_shebang] = "shebang",
  [anon_sym_return] = "return",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_local] = "local",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_do] = "do",
  [anon_sym_end] = "end",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_until] = "until",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_goto] = "goto",
  [sym_break_statement] = "break_statement",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_SEMI] = ";",
  [anon_sym_function] = "function",
  [anon_sym_COLON] = ":",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym_spread] = "spread",
  [sym_self] = "self",
  [sym_next] = "next",
  [anon_sym__G] = "_G",
  [anon_sym__VERSION] = "_VERSION",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_PIPE] = "|",
  [anon_sym_TILDE] = "~",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_CARET] = "^",
  [anon_sym_not] = "not",
  [anon_sym_POUND] = "#",
  [sym_number] = "number",
  [sym_nil] = "nil",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [sym_string] = "string",
  [sym_program] = "program",
  [sym_return_statement] = "return_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym__variable_declarator] = "_variable_declarator",
  [sym_field_expression] = "field_expression",
  [sym__local_variable_declarator] = "variable_declarator",
  [sym_do_statement] = "do_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif] = "elseif",
  [sym_else] = "else",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__loop_expression] = "loop_expression",
  [sym__in_loop_expression] = "loop_expression",
  [sym_goto_statement] = "goto_statement",
  [sym_label_statement] = "label_statement",
  [sym__empty_statement] = "_empty_statement",
  [sym_function_statement] = "function",
  [sym_local_function_statement] = "local_function",
  [sym_function_call_statement] = "function_call",
  [sym_arguments] = "arguments",
  [sym_function_name] = "function_name",
  [sym_function_name_field] = "function_name_field",
  [sym_parameters] = "parameters",
  [sym__function_body] = "_function_body",
  [sym__expression] = "_expression",
  [sym_global_variable] = "global_variable",
  [sym__prefix] = "_prefix",
  [sym_function_definition] = "function_definition",
  [sym_table] = "table",
  [sym_field] = "field",
  [sym__field_sequence] = "_field_sequence",
  [sym__field_sep] = "_field_sep",
  [sym_binary_operation] = "binary_operation",
  [sym_unary_operation] = "unary_operation",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_return_statement_repeat1] = "return_statement_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym__local_variable_declarator_repeat1] = "_local_variable_declarator_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_function_name_field_repeat1] = "function_name_field_repeat1",
  [aux_sym__field_sequence_repeat1] = "_field_sequence_repeat1",
  [alias_sym_condition_expression] = "condition_expression",
  [alias_sym_expression] = "expression",
  [alias_sym_method] = "method",
  [alias_sym_property_identifier] = "property_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_shebang] = sym_shebang,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_goto] = anon_sym_goto,
  [sym_break_statement] = sym_break_statement,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_spread] = sym_spread,
  [sym_self] = sym_self,
  [sym_next] = sym_next,
  [anon_sym__G] = anon_sym__G,
  [anon_sym__VERSION] = anon_sym__VERSION,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_POUND] = anon_sym_POUND,
  [sym_number] = sym_number,
  [sym_nil] = sym_nil,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [sym_string] = sym_string,
  [sym_program] = sym_program,
  [sym_return_statement] = sym_return_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym__variable_declarator] = sym__variable_declarator,
  [sym_field_expression] = sym_field_expression,
  [sym__local_variable_declarator] = sym__local_variable_declarator,
  [sym_do_statement] = sym_do_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif] = sym_elseif,
  [sym_else] = sym_else,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__loop_expression] = sym__loop_expression,
  [sym__in_loop_expression] = sym__loop_expression,
  [sym_goto_statement] = sym_goto_statement,
  [sym_label_statement] = sym_label_statement,
  [sym__empty_statement] = sym__empty_statement,
  [sym_function_statement] = sym_function_statement,
  [sym_local_function_statement] = sym_local_function_statement,
  [sym_function_call_statement] = sym_function_call_statement,
  [sym_arguments] = sym_arguments,
  [sym_function_name] = sym_function_name,
  [sym_function_name_field] = sym_function_name_field,
  [sym_parameters] = sym_parameters,
  [sym__function_body] = sym__function_body,
  [sym__expression] = sym__expression,
  [sym_global_variable] = sym_global_variable,
  [sym__prefix] = sym__prefix,
  [sym_function_definition] = sym_function_definition,
  [sym_table] = sym_table,
  [sym_field] = sym_field,
  [sym__field_sequence] = sym__field_sequence,
  [sym__field_sep] = sym__field_sep,
  [sym_binary_operation] = sym_binary_operation,
  [sym_unary_operation] = sym_unary_operation,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_return_statement_repeat1] = aux_sym_return_statement_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym__local_variable_declarator_repeat1] = aux_sym__local_variable_declarator_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_function_name_field_repeat1] = aux_sym_function_name_field_repeat1,
  [aux_sym__field_sequence_repeat1] = aux_sym__field_sequence_repeat1,
  [alias_sym_condition_expression] = alias_sym_condition_expression,
  [alias_sym_expression] = alias_sym_expression,
  [alias_sym_method] = alias_sym_method,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_shebang] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_spread] = {
    .visible = true,
    .named = true,
  },
  [sym_self] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__G] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__VERSION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__local_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__loop_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__in_loop_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_label_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_function_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_local_function_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_function_name] = {
    .visible = true,
    .named = true,
  },
  [sym_function_name_field] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__function_body] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_global_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__prefix] = {
    .visible = false,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_table] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym__field_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym__field_sep] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operation] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_return_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__local_variable_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_name_field_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_condition_expression] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_expression] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_method] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_object = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_object] = "object",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_object, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_expression,
  },
  [3] = {
    [2] = alias_sym_condition_expression,
  },
  [4] = {
    [1] = sym__local_variable_declarator,
  },
  [5] = {
    [0] = sym__local_variable_declarator,
  },
  [6] = {
    [2] = alias_sym_property_identifier,
  },
  [7] = {
    [1] = alias_sym_condition_expression,
  },
  [8] = {
    [3] = alias_sym_condition_expression,
  },
  [9] = {
    [1] = alias_sym_property_identifier,
  },
  [10] = {
    [2] = alias_sym_method,
  },
  [11] = {
    [4] = alias_sym_condition_expression,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__variable_declarator, 2,
    sym__variable_declarator,
    sym__local_variable_declarator,
  sym__expression, 3,
    sym__expression,
    alias_sym_condition_expression,
    alias_sym_expression,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(96);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '%') ADVANCE(173);
      if (lookahead == '&') ADVANCE(165);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == ')') ADVANCE(140);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '+') ADVANCE(168);
      if (lookahead == ',') ADVANCE(100);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(107);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(138);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(161);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '_') ADVANCE(19);
      if (lookahead == 'a') ADVANCE(61);
      if (lookahead == 'b') ADVANCE(75);
      if (lookahead == 'd') ADVANCE(67);
      if (lookahead == 'e') ADVANCE(54);
      if (lookahead == 'f') ADVANCE(25);
      if (lookahead == 'g') ADVANCE(68);
      if (lookahead == 'i') ADVANCE(43);
      if (lookahead == 'l') ADVANCE(69);
      if (lookahead == 'n') ADVANCE(33);
      if (lookahead == 'o') ADVANCE(73);
      if (lookahead == 'r') ADVANCE(34);
      if (lookahead == 's') ADVANCE(40);
      if (lookahead == 't') ADVANCE(49);
      if (lookahead == 'u') ADVANCE(66);
      if (lookahead == 'w') ADVANCE(47);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(162);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(97);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '%') ADVANCE(173);
      if (lookahead == '&') ADVANCE(165);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '+') ADVANCE(168);
      if (lookahead == ',') ADVANCE(100);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(107);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(138);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(161);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'a') ADVANCE(237);
      if (lookahead == 'b') ADVANCE(249);
      if (lookahead == 'd') ADVANCE(239);
      if (lookahead == 'e') ADVANCE(232);
      if (lookahead == 'f') ADVANCE(200);
      if (lookahead == 'g') ADVANCE(240);
      if (lookahead == 'i') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(241);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 'o') ADVANCE(247);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'w') ADVANCE(221);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(162);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '%') ADVANCE(173);
      if (lookahead == '&') ADVANCE(165);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '+') ADVANCE(168);
      if (lookahead == ',') ADVANCE(100);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(107);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(138);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(161);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'a') ADVANCE(237);
      if (lookahead == 'b') ADVANCE(249);
      if (lookahead == 'd') ADVANCE(239);
      if (lookahead == 'e') ADVANCE(235);
      if (lookahead == 'f') ADVANCE(200);
      if (lookahead == 'g') ADVANCE(240);
      if (lookahead == 'i') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(241);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 'o') ADVANCE(247);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'w') ADVANCE(221);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(162);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '%') ADVANCE(173);
      if (lookahead == '&') ADVANCE(165);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '+') ADVANCE(168);
      if (lookahead == ',') ADVANCE(100);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(107);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(138);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(161);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'a') ADVANCE(237);
      if (lookahead == 'b') ADVANCE(249);
      if (lookahead == 'd') ADVANCE(239);
      if (lookahead == 'f') ADVANCE(200);
      if (lookahead == 'g') ADVANCE(240);
      if (lookahead == 'i') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(241);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 'o') ADVANCE(247);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'u') ADVANCE(238);
      if (lookahead == 'w') ADVANCE(221);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(162);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == ',') ADVANCE(100);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(17);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(249);
      if (lookahead == 'd') ADVANCE(239);
      if (lookahead == 'e') ADVANCE(232);
      if (lookahead == 'f') ADVANCE(200);
      if (lookahead == 'g') ADVANCE(240);
      if (lookahead == 'i') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(241);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'w') ADVANCE(221);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '~') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 6:
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == ',') ADVANCE(100);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(17);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(249);
      if (lookahead == 'd') ADVANCE(239);
      if (lookahead == 'e') ADVANCE(235);
      if (lookahead == 'f') ADVANCE(200);
      if (lookahead == 'g') ADVANCE(240);
      if (lookahead == 'i') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(241);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'w') ADVANCE(221);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '~') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == ',') ADVANCE(100);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(17);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(249);
      if (lookahead == 'd') ADVANCE(239);
      if (lookahead == 'f') ADVANCE(200);
      if (lookahead == 'g') ADVANCE(240);
      if (lookahead == 'i') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(241);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'u') ADVANCE(238);
      if (lookahead == 'w') ADVANCE(221);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '~') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 8:
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'e') ADVANCE(232);
      if (lookahead == 'f') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '~') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 9:
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'e') ADVANCE(235);
      if (lookahead == 'f') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '~') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 10:
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'f') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'u') ADVANCE(238);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '~') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 11:
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 12:
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 13:
      if (lookahead == ')') ADVANCE(140);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(141);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(14);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 17:
      if (lookahead == ':') ADVANCE(133);
      END_STATE();
    case 18:
      if (lookahead == 'E') ADVANCE(23);
      END_STATE();
    case 19:
      if (lookahead == 'G') ADVANCE(146);
      if (lookahead == 'V') ADVANCE(18);
      END_STATE();
    case 20:
      if (lookahead == 'I') ADVANCE(22);
      END_STATE();
    case 21:
      if (lookahead == 'N') ADVANCE(148);
      END_STATE();
    case 22:
      if (lookahead == 'O') ADVANCE(21);
      END_STATE();
    case 23:
      if (lookahead == 'R') ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == 'S') ADVANCE(20);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(60);
      if (lookahead == 'o') ADVANCE(74);
      if (lookahead == 'u') ADVANCE(65);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(53);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(81);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(27);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(82);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(154);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(111);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(87);
      if (lookahead == 'i') ADVANCE(55);
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(26);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(113);
      if (lookahead == 'n') ADVANCE(128);
      END_STATE();
    case 44:
      if (lookahead == 'f') ADVANCE(142);
      END_STATE();
    case 45:
      if (lookahead == 'f') ADVANCE(116);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(46)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 47:
      if (lookahead == 'h') ADVANCE(50);
      END_STATE();
    case 48:
      if (lookahead == 'h') ADVANCE(42);
      END_STATE();
    case 49:
      if (lookahead == 'h') ADVANCE(42);
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(59);
      END_STATE();
    case 51:
      if (lookahead == 'i') ADVANCE(71);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 53:
      if (lookahead == 'k') ADVANCE(131);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(77);
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(187);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(103);
      END_STATE();
    case 58:
      if (lookahead == 'l') ADVANCE(124);
      END_STATE();
    case 59:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 60:
      if (lookahead == 'l') ADVANCE(78);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 64:
      if (lookahead == 'n') ADVANCE(135);
      END_STATE();
    case 65:
      if (lookahead == 'n') ADVANCE(30);
      END_STATE();
    case 66:
      if (lookahead == 'n') ADVANCE(84);
      END_STATE();
    case 67:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(83);
      END_STATE();
    case 69:
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 70:
      if (lookahead == 'o') ADVANCE(129);
      END_STATE();
    case 71:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 72:
      if (lookahead == 'p') ADVANCE(41);
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 75:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 76:
      if (lookahead == 'r') ADVANCE(63);
      END_STATE();
    case 77:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 78:
      if (lookahead == 's') ADVANCE(38);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 80:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 84:
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 85:
      if (lookahead == 'u') ADVANCE(76);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(37);
      END_STATE();
    case 87:
      if (lookahead == 'x') ADVANCE(80);
      END_STATE();
    case 88:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 89:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 90:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(183);
      END_STATE();
    case 91:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      END_STATE();
    case 92:
      if (eof) ADVANCE(96);
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == ',') ADVANCE(100);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(17);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(249);
      if (lookahead == 'd') ADVANCE(239);
      if (lookahead == 'f') ADVANCE(200);
      if (lookahead == 'g') ADVANCE(240);
      if (lookahead == 'i') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(241);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'w') ADVANCE(221);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '~') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 93:
      if (eof) ADVANCE(96);
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '%') ADVANCE(173);
      if (lookahead == '&') ADVANCE(165);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '+') ADVANCE(168);
      if (lookahead == ',') ADVANCE(100);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(107);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(138);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(161);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'a') ADVANCE(237);
      if (lookahead == 'b') ADVANCE(249);
      if (lookahead == 'd') ADVANCE(239);
      if (lookahead == 'f') ADVANCE(200);
      if (lookahead == 'g') ADVANCE(240);
      if (lookahead == 'i') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(241);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 'o') ADVANCE(247);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'w') ADVANCE(221);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(162);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(93)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 94:
      if (eof) ADVANCE(96);
      if (lookahead == '#') ADVANCE(179);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == ')') ADVANCE(140);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == '_') ADVANCE(194);
      if (lookahead == 'f') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '~') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(94)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 95:
      if (eof) ADVANCE(96);
      if (lookahead == '%') ADVANCE(173);
      if (lookahead == '&') ADVANCE(165);
      if (lookahead == '(') ADVANCE(139);
      if (lookahead == ')') ADVANCE(140);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '+') ADVANCE(168);
      if (lookahead == ',') ADVANCE(100);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == ';') ADVANCE(134);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(161);
      if (lookahead == '[') ADVANCE(105);
      if (lookahead == ']') ADVANCE(106);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'a') ADVANCE(61);
      if (lookahead == 'd') ADVANCE(67);
      if (lookahead == 'e') ADVANCE(54);
      if (lookahead == 'o') ADVANCE(73);
      if (lookahead == 't') ADVANCE(48);
      if (lookahead == 'u') ADVANCE(66);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(162);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(95)
      END_STATE();
    case 96:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_shebang);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_return);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(158);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_local);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(174);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_do);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_end);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_elseif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(45);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_repeat);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_until);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_goto);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_break_statement);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_function);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(133);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_spread);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_self);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_self);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_next);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_next);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym__G);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym__G);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym__VERSION);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym__VERSION);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(166);
      if (lookahead == '=') ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(167);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(159);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(172);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(141);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_not);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(1);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(88);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(90);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_nil);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'G') ADVANCE(147);
      if (lookahead == 'V') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(226);
      if (lookahead == 'o') ADVANCE(246);
      if (lookahead == 'u') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(226);
      if (lookahead == 'u') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(261);
      if (lookahead == 'i') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(230);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'k') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(251);
      if (lookahead == 'n') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(256);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(217);
      if (lookahead == 't') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(260);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 92, .external_lex_state = 1},
  [2] = {.lex_state = 5, .external_lex_state = 1},
  [3] = {.lex_state = 5, .external_lex_state = 1},
  [4] = {.lex_state = 5, .external_lex_state = 1},
  [5] = {.lex_state = 5, .external_lex_state = 1},
  [6] = {.lex_state = 5, .external_lex_state = 1},
  [7] = {.lex_state = 5, .external_lex_state = 1},
  [8] = {.lex_state = 5, .external_lex_state = 1},
  [9] = {.lex_state = 5, .external_lex_state = 1},
  [10] = {.lex_state = 5, .external_lex_state = 1},
  [11] = {.lex_state = 2, .external_lex_state = 1},
  [12] = {.lex_state = 2, .external_lex_state = 1},
  [13] = {.lex_state = 5, .external_lex_state = 1},
  [14] = {.lex_state = 2, .external_lex_state = 1},
  [15] = {.lex_state = 2, .external_lex_state = 1},
  [16] = {.lex_state = 5, .external_lex_state = 1},
  [17] = {.lex_state = 2, .external_lex_state = 1},
  [18] = {.lex_state = 2, .external_lex_state = 1},
  [19] = {.lex_state = 6, .external_lex_state = 1},
  [20] = {.lex_state = 6, .external_lex_state = 1},
  [21] = {.lex_state = 2, .external_lex_state = 1},
  [22] = {.lex_state = 6, .external_lex_state = 1},
  [23] = {.lex_state = 92, .external_lex_state = 1},
  [24] = {.lex_state = 6, .external_lex_state = 1},
  [25] = {.lex_state = 3, .external_lex_state = 1},
  [26] = {.lex_state = 93, .external_lex_state = 1},
  [27] = {.lex_state = 6, .external_lex_state = 1},
  [28] = {.lex_state = 7, .external_lex_state = 1},
  [29] = {.lex_state = 2, .external_lex_state = 1},
  [30] = {.lex_state = 93, .external_lex_state = 1},
  [31] = {.lex_state = 92, .external_lex_state = 1},
  [32] = {.lex_state = 6, .external_lex_state = 1},
  [33] = {.lex_state = 92, .external_lex_state = 1},
  [34] = {.lex_state = 2, .external_lex_state = 1},
  [35] = {.lex_state = 6, .external_lex_state = 1},
  [36] = {.lex_state = 6, .external_lex_state = 1},
  [37] = {.lex_state = 2, .external_lex_state = 1},
  [38] = {.lex_state = 2, .external_lex_state = 1},
  [39] = {.lex_state = 6, .external_lex_state = 1},
  [40] = {.lex_state = 6, .external_lex_state = 1},
  [41] = {.lex_state = 6, .external_lex_state = 1},
  [42] = {.lex_state = 6, .external_lex_state = 1},
  [43] = {.lex_state = 6, .external_lex_state = 1},
  [44] = {.lex_state = 7, .external_lex_state = 1},
  [45] = {.lex_state = 6, .external_lex_state = 1},
  [46] = {.lex_state = 4, .external_lex_state = 1},
  [47] = {.lex_state = 4, .external_lex_state = 1},
  [48] = {.lex_state = 6, .external_lex_state = 1},
  [49] = {.lex_state = 7, .external_lex_state = 1},
  [50] = {.lex_state = 6, .external_lex_state = 1},
  [51] = {.lex_state = 6, .external_lex_state = 1},
  [52] = {.lex_state = 7, .external_lex_state = 1},
  [53] = {.lex_state = 6, .external_lex_state = 1},
  [54] = {.lex_state = 3, .external_lex_state = 1},
  [55] = {.lex_state = 6, .external_lex_state = 1},
  [56] = {.lex_state = 6, .external_lex_state = 1},
  [57] = {.lex_state = 2, .external_lex_state = 1},
  [58] = {.lex_state = 6, .external_lex_state = 1},
  [59] = {.lex_state = 6, .external_lex_state = 1},
  [60] = {.lex_state = 2, .external_lex_state = 1},
  [61] = {.lex_state = 2, .external_lex_state = 1},
  [62] = {.lex_state = 6, .external_lex_state = 1},
  [63] = {.lex_state = 6, .external_lex_state = 1},
  [64] = {.lex_state = 6, .external_lex_state = 1},
  [65] = {.lex_state = 6, .external_lex_state = 1},
  [66] = {.lex_state = 6, .external_lex_state = 1},
  [67] = {.lex_state = 6, .external_lex_state = 1},
  [68] = {.lex_state = 6, .external_lex_state = 1},
  [69] = {.lex_state = 7, .external_lex_state = 1},
  [70] = {.lex_state = 6, .external_lex_state = 1},
  [71] = {.lex_state = 6, .external_lex_state = 1},
  [72] = {.lex_state = 7, .external_lex_state = 1},
  [73] = {.lex_state = 6, .external_lex_state = 1},
  [74] = {.lex_state = 2, .external_lex_state = 1},
  [75] = {.lex_state = 2, .external_lex_state = 1},
  [76] = {.lex_state = 6, .external_lex_state = 1},
  [77] = {.lex_state = 6, .external_lex_state = 1},
  [78] = {.lex_state = 6, .external_lex_state = 1},
  [79] = {.lex_state = 6, .external_lex_state = 1},
  [80] = {.lex_state = 6, .external_lex_state = 1},
  [81] = {.lex_state = 6, .external_lex_state = 1},
  [82] = {.lex_state = 6, .external_lex_state = 1},
  [83] = {.lex_state = 6, .external_lex_state = 1},
  [84] = {.lex_state = 7, .external_lex_state = 1},
  [85] = {.lex_state = 6, .external_lex_state = 1},
  [86] = {.lex_state = 6, .external_lex_state = 1},
  [87] = {.lex_state = 6, .external_lex_state = 1},
  [88] = {.lex_state = 6, .external_lex_state = 1},
  [89] = {.lex_state = 2, .external_lex_state = 1},
  [90] = {.lex_state = 6, .external_lex_state = 1},
  [91] = {.lex_state = 6, .external_lex_state = 1},
  [92] = {.lex_state = 6, .external_lex_state = 1},
  [93] = {.lex_state = 6, .external_lex_state = 1},
  [94] = {.lex_state = 6, .external_lex_state = 1},
  [95] = {.lex_state = 6, .external_lex_state = 1},
  [96] = {.lex_state = 7, .external_lex_state = 1},
  [97] = {.lex_state = 6, .external_lex_state = 1},
  [98] = {.lex_state = 6, .external_lex_state = 1},
  [99] = {.lex_state = 7, .external_lex_state = 1},
  [100] = {.lex_state = 92, .external_lex_state = 1},
  [101] = {.lex_state = 93, .external_lex_state = 1},
  [102] = {.lex_state = 4, .external_lex_state = 1},
  [103] = {.lex_state = 3, .external_lex_state = 1},
  [104] = {.lex_state = 3, .external_lex_state = 1},
  [105] = {.lex_state = 4, .external_lex_state = 1},
  [106] = {.lex_state = 6, .external_lex_state = 1},
  [107] = {.lex_state = 93, .external_lex_state = 1},
  [108] = {.lex_state = 2, .external_lex_state = 1},
  [109] = {.lex_state = 4, .external_lex_state = 1},
  [110] = {.lex_state = 3, .external_lex_state = 1},
  [111] = {.lex_state = 93, .external_lex_state = 1},
  [112] = {.lex_state = 4, .external_lex_state = 1},
  [113] = {.lex_state = 93, .external_lex_state = 1},
  [114] = {.lex_state = 3, .external_lex_state = 1},
  [115] = {.lex_state = 93, .external_lex_state = 1},
  [116] = {.lex_state = 2, .external_lex_state = 1},
  [117] = {.lex_state = 4, .external_lex_state = 1},
  [118] = {.lex_state = 4, .external_lex_state = 1},
  [119] = {.lex_state = 93, .external_lex_state = 1},
  [120] = {.lex_state = 3, .external_lex_state = 1},
  [121] = {.lex_state = 93, .external_lex_state = 1},
  [122] = {.lex_state = 93, .external_lex_state = 1},
  [123] = {.lex_state = 4, .external_lex_state = 1},
  [124] = {.lex_state = 93, .external_lex_state = 1},
  [125] = {.lex_state = 4, .external_lex_state = 1},
  [126] = {.lex_state = 4, .external_lex_state = 1},
  [127] = {.lex_state = 3, .external_lex_state = 1},
  [128] = {.lex_state = 3, .external_lex_state = 1},
  [129] = {.lex_state = 3, .external_lex_state = 1},
  [130] = {.lex_state = 4, .external_lex_state = 1},
  [131] = {.lex_state = 2, .external_lex_state = 1},
  [132] = {.lex_state = 93, .external_lex_state = 1},
  [133] = {.lex_state = 4, .external_lex_state = 1},
  [134] = {.lex_state = 3, .external_lex_state = 1},
  [135] = {.lex_state = 3, .external_lex_state = 1},
  [136] = {.lex_state = 3, .external_lex_state = 1},
  [137] = {.lex_state = 4, .external_lex_state = 1},
  [138] = {.lex_state = 93, .external_lex_state = 1},
  [139] = {.lex_state = 93, .external_lex_state = 1},
  [140] = {.lex_state = 3, .external_lex_state = 1},
  [141] = {.lex_state = 4, .external_lex_state = 1},
  [142] = {.lex_state = 4, .external_lex_state = 1},
  [143] = {.lex_state = 93, .external_lex_state = 1},
  [144] = {.lex_state = 93, .external_lex_state = 1},
  [145] = {.lex_state = 3, .external_lex_state = 1},
  [146] = {.lex_state = 4, .external_lex_state = 1},
  [147] = {.lex_state = 3, .external_lex_state = 1},
  [148] = {.lex_state = 2, .external_lex_state = 1},
  [149] = {.lex_state = 93, .external_lex_state = 1},
  [150] = {.lex_state = 3, .external_lex_state = 1},
  [151] = {.lex_state = 2, .external_lex_state = 1},
  [152] = {.lex_state = 2, .external_lex_state = 1},
  [153] = {.lex_state = 2, .external_lex_state = 1},
  [154] = {.lex_state = 2, .external_lex_state = 1},
  [155] = {.lex_state = 4, .external_lex_state = 1},
  [156] = {.lex_state = 2, .external_lex_state = 1},
  [157] = {.lex_state = 2, .external_lex_state = 1},
  [158] = {.lex_state = 2, .external_lex_state = 1},
  [159] = {.lex_state = 2, .external_lex_state = 1},
  [160] = {.lex_state = 93, .external_lex_state = 1},
  [161] = {.lex_state = 2, .external_lex_state = 1},
  [162] = {.lex_state = 3, .external_lex_state = 1},
  [163] = {.lex_state = 2, .external_lex_state = 1},
  [164] = {.lex_state = 2, .external_lex_state = 1},
  [165] = {.lex_state = 2, .external_lex_state = 1},
  [166] = {.lex_state = 2, .external_lex_state = 1},
  [167] = {.lex_state = 2, .external_lex_state = 1},
  [168] = {.lex_state = 2, .external_lex_state = 1},
  [169] = {.lex_state = 2, .external_lex_state = 1},
  [170] = {.lex_state = 2, .external_lex_state = 1},
  [171] = {.lex_state = 2, .external_lex_state = 1},
  [172] = {.lex_state = 2, .external_lex_state = 1},
  [173] = {.lex_state = 2, .external_lex_state = 1},
  [174] = {.lex_state = 4, .external_lex_state = 1},
  [175] = {.lex_state = 4, .external_lex_state = 1},
  [176] = {.lex_state = 2, .external_lex_state = 1},
  [177] = {.lex_state = 2, .external_lex_state = 1},
  [178] = {.lex_state = 3, .external_lex_state = 1},
  [179] = {.lex_state = 4, .external_lex_state = 1},
  [180] = {.lex_state = 93, .external_lex_state = 1},
  [181] = {.lex_state = 2, .external_lex_state = 1},
  [182] = {.lex_state = 2, .external_lex_state = 1},
  [183] = {.lex_state = 2, .external_lex_state = 1},
  [184] = {.lex_state = 93, .external_lex_state = 1},
  [185] = {.lex_state = 3, .external_lex_state = 1},
  [186] = {.lex_state = 93, .external_lex_state = 1},
  [187] = {.lex_state = 2, .external_lex_state = 1},
  [188] = {.lex_state = 3, .external_lex_state = 1},
  [189] = {.lex_state = 2, .external_lex_state = 1},
  [190] = {.lex_state = 2, .external_lex_state = 1},
  [191] = {.lex_state = 2, .external_lex_state = 1},
  [192] = {.lex_state = 2, .external_lex_state = 1},
  [193] = {.lex_state = 2, .external_lex_state = 1},
  [194] = {.lex_state = 2, .external_lex_state = 1},
  [195] = {.lex_state = 2, .external_lex_state = 1},
  [196] = {.lex_state = 2, .external_lex_state = 1},
  [197] = {.lex_state = 3, .external_lex_state = 1},
  [198] = {.lex_state = 93, .external_lex_state = 1},
  [199] = {.lex_state = 4, .external_lex_state = 1},
  [200] = {.lex_state = 3, .external_lex_state = 1},
  [201] = {.lex_state = 4, .external_lex_state = 1},
  [202] = {.lex_state = 4, .external_lex_state = 1},
  [203] = {.lex_state = 4, .external_lex_state = 1},
  [204] = {.lex_state = 93, .external_lex_state = 1},
  [205] = {.lex_state = 93, .external_lex_state = 1},
  [206] = {.lex_state = 3, .external_lex_state = 1},
  [207] = {.lex_state = 3, .external_lex_state = 1},
  [208] = {.lex_state = 3, .external_lex_state = 1},
  [209] = {.lex_state = 4, .external_lex_state = 1},
  [210] = {.lex_state = 93, .external_lex_state = 1},
  [211] = {.lex_state = 4, .external_lex_state = 1},
  [212] = {.lex_state = 4, .external_lex_state = 1},
  [213] = {.lex_state = 3, .external_lex_state = 1},
  [214] = {.lex_state = 4, .external_lex_state = 1},
  [215] = {.lex_state = 93, .external_lex_state = 1},
  [216] = {.lex_state = 3, .external_lex_state = 1},
  [217] = {.lex_state = 4, .external_lex_state = 1},
  [218] = {.lex_state = 3, .external_lex_state = 1},
  [219] = {.lex_state = 3, .external_lex_state = 1},
  [220] = {.lex_state = 93, .external_lex_state = 1},
  [221] = {.lex_state = 3, .external_lex_state = 1},
  [222] = {.lex_state = 3, .external_lex_state = 1},
  [223] = {.lex_state = 4, .external_lex_state = 1},
  [224] = {.lex_state = 4, .external_lex_state = 1},
  [225] = {.lex_state = 93, .external_lex_state = 1},
  [226] = {.lex_state = 3, .external_lex_state = 1},
  [227] = {.lex_state = 3, .external_lex_state = 1},
  [228] = {.lex_state = 3, .external_lex_state = 1},
  [229] = {.lex_state = 4, .external_lex_state = 1},
  [230] = {.lex_state = 93, .external_lex_state = 1},
  [231] = {.lex_state = 93, .external_lex_state = 1},
  [232] = {.lex_state = 3, .external_lex_state = 1},
  [233] = {.lex_state = 93, .external_lex_state = 1},
  [234] = {.lex_state = 93, .external_lex_state = 1},
  [235] = {.lex_state = 4, .external_lex_state = 1},
  [236] = {.lex_state = 4, .external_lex_state = 1},
  [237] = {.lex_state = 93, .external_lex_state = 1},
  [238] = {.lex_state = 93, .external_lex_state = 1},
  [239] = {.lex_state = 93, .external_lex_state = 1},
  [240] = {.lex_state = 4, .external_lex_state = 1},
  [241] = {.lex_state = 93, .external_lex_state = 1},
  [242] = {.lex_state = 3, .external_lex_state = 1},
  [243] = {.lex_state = 93, .external_lex_state = 1},
  [244] = {.lex_state = 4, .external_lex_state = 1},
  [245] = {.lex_state = 93, .external_lex_state = 1},
  [246] = {.lex_state = 3, .external_lex_state = 1},
  [247] = {.lex_state = 4, .external_lex_state = 1},
  [248] = {.lex_state = 93, .external_lex_state = 1},
  [249] = {.lex_state = 3, .external_lex_state = 1},
  [250] = {.lex_state = 4, .external_lex_state = 1},
  [251] = {.lex_state = 3, .external_lex_state = 1},
  [252] = {.lex_state = 3, .external_lex_state = 1},
  [253] = {.lex_state = 3, .external_lex_state = 1},
  [254] = {.lex_state = 93, .external_lex_state = 1},
  [255] = {.lex_state = 4, .external_lex_state = 1},
  [256] = {.lex_state = 4, .external_lex_state = 1},
  [257] = {.lex_state = 4, .external_lex_state = 1},
  [258] = {.lex_state = 3, .external_lex_state = 1},
  [259] = {.lex_state = 93, .external_lex_state = 1},
  [260] = {.lex_state = 4, .external_lex_state = 1},
  [261] = {.lex_state = 4, .external_lex_state = 1},
  [262] = {.lex_state = 4, .external_lex_state = 1},
  [263] = {.lex_state = 4, .external_lex_state = 1},
  [264] = {.lex_state = 3, .external_lex_state = 1},
  [265] = {.lex_state = 4, .external_lex_state = 1},
  [266] = {.lex_state = 93, .external_lex_state = 1},
  [267] = {.lex_state = 3, .external_lex_state = 1},
  [268] = {.lex_state = 3, .external_lex_state = 1},
  [269] = {.lex_state = 3, .external_lex_state = 1},
  [270] = {.lex_state = 4, .external_lex_state = 1},
  [271] = {.lex_state = 4, .external_lex_state = 1},
  [272] = {.lex_state = 3, .external_lex_state = 1},
  [273] = {.lex_state = 4, .external_lex_state = 1},
  [274] = {.lex_state = 3, .external_lex_state = 1},
  [275] = {.lex_state = 4, .external_lex_state = 1},
  [276] = {.lex_state = 4, .external_lex_state = 1},
  [277] = {.lex_state = 93, .external_lex_state = 1},
  [278] = {.lex_state = 3, .external_lex_state = 1},
  [279] = {.lex_state = 93, .external_lex_state = 1},
  [280] = {.lex_state = 93, .external_lex_state = 1},
  [281] = {.lex_state = 3, .external_lex_state = 1},
  [282] = {.lex_state = 4, .external_lex_state = 1},
  [283] = {.lex_state = 3, .external_lex_state = 1},
  [284] = {.lex_state = 93, .external_lex_state = 1},
  [285] = {.lex_state = 93, .external_lex_state = 1},
  [286] = {.lex_state = 93, .external_lex_state = 1},
  [287] = {.lex_state = 93, .external_lex_state = 1},
  [288] = {.lex_state = 93, .external_lex_state = 1},
  [289] = {.lex_state = 4, .external_lex_state = 1},
  [290] = {.lex_state = 93, .external_lex_state = 1},
  [291] = {.lex_state = 93, .external_lex_state = 1},
  [292] = {.lex_state = 93, .external_lex_state = 1},
  [293] = {.lex_state = 93, .external_lex_state = 1},
  [294] = {.lex_state = 3, .external_lex_state = 1},
  [295] = {.lex_state = 4, .external_lex_state = 1},
  [296] = {.lex_state = 3, .external_lex_state = 1},
  [297] = {.lex_state = 93, .external_lex_state = 1},
  [298] = {.lex_state = 3, .external_lex_state = 1},
  [299] = {.lex_state = 95, .external_lex_state = 1},
  [300] = {.lex_state = 95, .external_lex_state = 1},
  [301] = {.lex_state = 95, .external_lex_state = 1},
  [302] = {.lex_state = 95, .external_lex_state = 1},
  [303] = {.lex_state = 95, .external_lex_state = 1},
  [304] = {.lex_state = 95, .external_lex_state = 1},
  [305] = {.lex_state = 95, .external_lex_state = 1},
  [306] = {.lex_state = 95, .external_lex_state = 1},
  [307] = {.lex_state = 95, .external_lex_state = 1},
  [308] = {.lex_state = 95, .external_lex_state = 1},
  [309] = {.lex_state = 95, .external_lex_state = 1},
  [310] = {.lex_state = 95, .external_lex_state = 1},
  [311] = {.lex_state = 95, .external_lex_state = 1},
  [312] = {.lex_state = 95, .external_lex_state = 1},
  [313] = {.lex_state = 95, .external_lex_state = 1},
  [314] = {.lex_state = 5, .external_lex_state = 1},
  [315] = {.lex_state = 5, .external_lex_state = 1},
  [316] = {.lex_state = 5, .external_lex_state = 1},
  [317] = {.lex_state = 5, .external_lex_state = 1},
  [318] = {.lex_state = 5, .external_lex_state = 1},
  [319] = {.lex_state = 5, .external_lex_state = 1},
  [320] = {.lex_state = 5, .external_lex_state = 1},
  [321] = {.lex_state = 5, .external_lex_state = 1},
  [322] = {.lex_state = 5, .external_lex_state = 1},
  [323] = {.lex_state = 6, .external_lex_state = 1},
  [324] = {.lex_state = 95, .external_lex_state = 2},
  [325] = {.lex_state = 95, .external_lex_state = 2},
  [326] = {.lex_state = 95, .external_lex_state = 2},
  [327] = {.lex_state = 95, .external_lex_state = 2},
  [328] = {.lex_state = 95, .external_lex_state = 2},
  [329] = {.lex_state = 95, .external_lex_state = 2},
  [330] = {.lex_state = 95, .external_lex_state = 2},
  [331] = {.lex_state = 95, .external_lex_state = 2},
  [332] = {.lex_state = 95, .external_lex_state = 2},
  [333] = {.lex_state = 95, .external_lex_state = 2},
  [334] = {.lex_state = 95, .external_lex_state = 2},
  [335] = {.lex_state = 8, .external_lex_state = 1},
  [336] = {.lex_state = 95, .external_lex_state = 2},
  [337] = {.lex_state = 95, .external_lex_state = 2},
  [338] = {.lex_state = 6, .external_lex_state = 1},
  [339] = {.lex_state = 95, .external_lex_state = 2},
  [340] = {.lex_state = 92, .external_lex_state = 1},
  [341] = {.lex_state = 95, .external_lex_state = 2},
  [342] = {.lex_state = 95, .external_lex_state = 2},
  [343] = {.lex_state = 7, .external_lex_state = 1},
  [344] = {.lex_state = 92, .external_lex_state = 1},
  [345] = {.lex_state = 92, .external_lex_state = 1},
  [346] = {.lex_state = 95, .external_lex_state = 2},
  [347] = {.lex_state = 7, .external_lex_state = 1},
  [348] = {.lex_state = 7, .external_lex_state = 1},
  [349] = {.lex_state = 95, .external_lex_state = 2},
  [350] = {.lex_state = 6, .external_lex_state = 1},
  [351] = {.lex_state = 95, .external_lex_state = 2},
  [352] = {.lex_state = 5, .external_lex_state = 1},
  [353] = {.lex_state = 5, .external_lex_state = 1},
  [354] = {.lex_state = 5, .external_lex_state = 1},
  [355] = {.lex_state = 6, .external_lex_state = 1},
  [356] = {.lex_state = 5, .external_lex_state = 1},
  [357] = {.lex_state = 7, .external_lex_state = 1},
  [358] = {.lex_state = 94, .external_lex_state = 1},
  [359] = {.lex_state = 92, .external_lex_state = 1},
  [360] = {.lex_state = 92, .external_lex_state = 1},
  [361] = {.lex_state = 7, .external_lex_state = 1},
  [362] = {.lex_state = 94, .external_lex_state = 1},
  [363] = {.lex_state = 5, .external_lex_state = 1},
  [364] = {.lex_state = 5, .external_lex_state = 1},
  [365] = {.lex_state = 6, .external_lex_state = 1},
  [366] = {.lex_state = 94, .external_lex_state = 1},
  [367] = {.lex_state = 94, .external_lex_state = 1},
  [368] = {.lex_state = 7, .external_lex_state = 1},
  [369] = {.lex_state = 5, .external_lex_state = 1},
  [370] = {.lex_state = 5, .external_lex_state = 1},
  [371] = {.lex_state = 5, .external_lex_state = 1},
  [372] = {.lex_state = 7, .external_lex_state = 1},
  [373] = {.lex_state = 5, .external_lex_state = 1},
  [374] = {.lex_state = 5, .external_lex_state = 1},
  [375] = {.lex_state = 5, .external_lex_state = 1},
  [376] = {.lex_state = 5, .external_lex_state = 1},
  [377] = {.lex_state = 5, .external_lex_state = 1},
  [378] = {.lex_state = 92, .external_lex_state = 1},
  [379] = {.lex_state = 6, .external_lex_state = 1},
  [380] = {.lex_state = 5, .external_lex_state = 1},
  [381] = {.lex_state = 7, .external_lex_state = 1},
  [382] = {.lex_state = 92, .external_lex_state = 1},
  [383] = {.lex_state = 94, .external_lex_state = 1},
  [384] = {.lex_state = 5, .external_lex_state = 1},
  [385] = {.lex_state = 5, .external_lex_state = 1},
  [386] = {.lex_state = 6, .external_lex_state = 1},
  [387] = {.lex_state = 5, .external_lex_state = 1},
  [388] = {.lex_state = 6, .external_lex_state = 1},
  [389] = {.lex_state = 5, .external_lex_state = 1},
  [390] = {.lex_state = 92, .external_lex_state = 1},
  [391] = {.lex_state = 94, .external_lex_state = 1},
  [392] = {.lex_state = 5, .external_lex_state = 1},
  [393] = {.lex_state = 5, .external_lex_state = 1},
  [394] = {.lex_state = 5, .external_lex_state = 1},
  [395] = {.lex_state = 5, .external_lex_state = 1},
  [396] = {.lex_state = 5, .external_lex_state = 1},
  [397] = {.lex_state = 94, .external_lex_state = 1},
  [398] = {.lex_state = 10, .external_lex_state = 1},
  [399] = {.lex_state = 94, .external_lex_state = 1},
  [400] = {.lex_state = 7, .external_lex_state = 1},
  [401] = {.lex_state = 92, .external_lex_state = 1},
  [402] = {.lex_state = 95, .external_lex_state = 1},
  [403] = {.lex_state = 94, .external_lex_state = 1},
  [404] = {.lex_state = 9, .external_lex_state = 1},
  [405] = {.lex_state = 6, .external_lex_state = 1},
  [406] = {.lex_state = 92, .external_lex_state = 1},
  [407] = {.lex_state = 7, .external_lex_state = 1},
  [408] = {.lex_state = 7, .external_lex_state = 1},
  [409] = {.lex_state = 92, .external_lex_state = 1},
  [410] = {.lex_state = 7, .external_lex_state = 1},
  [411] = {.lex_state = 7, .external_lex_state = 1},
  [412] = {.lex_state = 7, .external_lex_state = 1},
  [413] = {.lex_state = 7, .external_lex_state = 1},
  [414] = {.lex_state = 7, .external_lex_state = 1},
  [415] = {.lex_state = 7, .external_lex_state = 1},
  [416] = {.lex_state = 7, .external_lex_state = 1},
  [417] = {.lex_state = 7, .external_lex_state = 1},
  [418] = {.lex_state = 6, .external_lex_state = 1},
  [419] = {.lex_state = 7, .external_lex_state = 1},
  [420] = {.lex_state = 7, .external_lex_state = 1},
  [421] = {.lex_state = 6, .external_lex_state = 1},
  [422] = {.lex_state = 7, .external_lex_state = 1},
  [423] = {.lex_state = 7, .external_lex_state = 1},
  [424] = {.lex_state = 7, .external_lex_state = 1},
  [425] = {.lex_state = 92, .external_lex_state = 1},
  [426] = {.lex_state = 7, .external_lex_state = 1},
  [427] = {.lex_state = 95, .external_lex_state = 2},
  [428] = {.lex_state = 92, .external_lex_state = 1},
  [429] = {.lex_state = 6, .external_lex_state = 1},
  [430] = {.lex_state = 6, .external_lex_state = 1},
  [431] = {.lex_state = 92, .external_lex_state = 1},
  [432] = {.lex_state = 6, .external_lex_state = 1},
  [433] = {.lex_state = 92, .external_lex_state = 1},
  [434] = {.lex_state = 6, .external_lex_state = 1},
  [435] = {.lex_state = 92, .external_lex_state = 1},
  [436] = {.lex_state = 6, .external_lex_state = 1},
  [437] = {.lex_state = 6, .external_lex_state = 1},
  [438] = {.lex_state = 6, .external_lex_state = 1},
  [439] = {.lex_state = 92, .external_lex_state = 1},
  [440] = {.lex_state = 6, .external_lex_state = 1},
  [441] = {.lex_state = 92, .external_lex_state = 1},
  [442] = {.lex_state = 6, .external_lex_state = 1},
  [443] = {.lex_state = 6, .external_lex_state = 1},
  [444] = {.lex_state = 92, .external_lex_state = 1},
  [445] = {.lex_state = 92, .external_lex_state = 1},
  [446] = {.lex_state = 92, .external_lex_state = 1},
  [447] = {.lex_state = 6, .external_lex_state = 1},
  [448] = {.lex_state = 7, .external_lex_state = 1},
  [449] = {.lex_state = 7, .external_lex_state = 1},
  [450] = {.lex_state = 7, .external_lex_state = 1},
  [451] = {.lex_state = 6, .external_lex_state = 1},
  [452] = {.lex_state = 6, .external_lex_state = 1},
  [453] = {.lex_state = 92, .external_lex_state = 1},
  [454] = {.lex_state = 6, .external_lex_state = 1},
  [455] = {.lex_state = 7, .external_lex_state = 1},
  [456] = {.lex_state = 7, .external_lex_state = 1},
  [457] = {.lex_state = 92, .external_lex_state = 1},
  [458] = {.lex_state = 6, .external_lex_state = 1},
  [459] = {.lex_state = 6, .external_lex_state = 1},
  [460] = {.lex_state = 92, .external_lex_state = 1},
  [461] = {.lex_state = 6, .external_lex_state = 1},
  [462] = {.lex_state = 92, .external_lex_state = 1},
  [463] = {.lex_state = 92, .external_lex_state = 1},
  [464] = {.lex_state = 92, .external_lex_state = 1},
  [465] = {.lex_state = 7, .external_lex_state = 1},
  [466] = {.lex_state = 6, .external_lex_state = 1},
  [467] = {.lex_state = 92, .external_lex_state = 1},
  [468] = {.lex_state = 92, .external_lex_state = 1},
  [469] = {.lex_state = 6, .external_lex_state = 1},
  [470] = {.lex_state = 7, .external_lex_state = 1},
  [471] = {.lex_state = 92, .external_lex_state = 1},
  [472] = {.lex_state = 7, .external_lex_state = 1},
  [473] = {.lex_state = 92, .external_lex_state = 1},
  [474] = {.lex_state = 6, .external_lex_state = 1},
  [475] = {.lex_state = 92, .external_lex_state = 1},
  [476] = {.lex_state = 6, .external_lex_state = 1},
  [477] = {.lex_state = 94, .external_lex_state = 1},
  [478] = {.lex_state = 92, .external_lex_state = 1},
  [479] = {.lex_state = 6, .external_lex_state = 1},
  [480] = {.lex_state = 6, .external_lex_state = 1},
  [481] = {.lex_state = 95, .external_lex_state = 2},
  [482] = {.lex_state = 6, .external_lex_state = 1},
  [483] = {.lex_state = 6, .external_lex_state = 1},
  [484] = {.lex_state = 6, .external_lex_state = 1},
  [485] = {.lex_state = 6, .external_lex_state = 1},
  [486] = {.lex_state = 94, .external_lex_state = 1},
  [487] = {.lex_state = 94, .external_lex_state = 1},
  [488] = {.lex_state = 94, .external_lex_state = 1},
  [489] = {.lex_state = 94, .external_lex_state = 1},
  [490] = {.lex_state = 94, .external_lex_state = 1},
  [491] = {.lex_state = 94, .external_lex_state = 1},
  [492] = {.lex_state = 94, .external_lex_state = 1},
  [493] = {.lex_state = 94, .external_lex_state = 1},
  [494] = {.lex_state = 94, .external_lex_state = 1},
  [495] = {.lex_state = 94, .external_lex_state = 1},
  [496] = {.lex_state = 94, .external_lex_state = 1},
  [497] = {.lex_state = 94, .external_lex_state = 1},
  [498] = {.lex_state = 94, .external_lex_state = 1},
  [499] = {.lex_state = 94, .external_lex_state = 1},
  [500] = {.lex_state = 94, .external_lex_state = 1},
  [501] = {.lex_state = 94, .external_lex_state = 1},
  [502] = {.lex_state = 94, .external_lex_state = 1},
  [503] = {.lex_state = 94, .external_lex_state = 1},
  [504] = {.lex_state = 94, .external_lex_state = 1},
  [505] = {.lex_state = 94, .external_lex_state = 1},
  [506] = {.lex_state = 94, .external_lex_state = 1},
  [507] = {.lex_state = 94, .external_lex_state = 1},
  [508] = {.lex_state = 94, .external_lex_state = 1},
  [509] = {.lex_state = 94, .external_lex_state = 1},
  [510] = {.lex_state = 94, .external_lex_state = 1},
  [511] = {.lex_state = 94, .external_lex_state = 1},
  [512] = {.lex_state = 94, .external_lex_state = 1},
  [513] = {.lex_state = 94, .external_lex_state = 1},
  [514] = {.lex_state = 94, .external_lex_state = 1},
  [515] = {.lex_state = 94, .external_lex_state = 1},
  [516] = {.lex_state = 94, .external_lex_state = 1},
  [517] = {.lex_state = 94, .external_lex_state = 1},
  [518] = {.lex_state = 94, .external_lex_state = 1},
  [519] = {.lex_state = 94, .external_lex_state = 1},
  [520] = {.lex_state = 94, .external_lex_state = 1},
  [521] = {.lex_state = 94, .external_lex_state = 1},
  [522] = {.lex_state = 94, .external_lex_state = 1},
  [523] = {.lex_state = 94, .external_lex_state = 1},
  [524] = {.lex_state = 94, .external_lex_state = 1},
  [525] = {.lex_state = 94, .external_lex_state = 1},
  [526] = {.lex_state = 94, .external_lex_state = 1},
  [527] = {.lex_state = 94, .external_lex_state = 1},
  [528] = {.lex_state = 94, .external_lex_state = 1},
  [529] = {.lex_state = 94, .external_lex_state = 1},
  [530] = {.lex_state = 94, .external_lex_state = 1},
  [531] = {.lex_state = 94, .external_lex_state = 1},
  [532] = {.lex_state = 94, .external_lex_state = 1},
  [533] = {.lex_state = 94, .external_lex_state = 1},
  [534] = {.lex_state = 94, .external_lex_state = 1},
  [535] = {.lex_state = 94, .external_lex_state = 1},
  [536] = {.lex_state = 94, .external_lex_state = 1},
  [537] = {.lex_state = 94, .external_lex_state = 1},
  [538] = {.lex_state = 94, .external_lex_state = 1},
  [539] = {.lex_state = 94, .external_lex_state = 1},
  [540] = {.lex_state = 94, .external_lex_state = 1},
  [541] = {.lex_state = 94, .external_lex_state = 1},
  [542] = {.lex_state = 94, .external_lex_state = 1},
  [543] = {.lex_state = 94, .external_lex_state = 1},
  [544] = {.lex_state = 94, .external_lex_state = 1},
  [545] = {.lex_state = 94, .external_lex_state = 1},
  [546] = {.lex_state = 94, .external_lex_state = 1},
  [547] = {.lex_state = 94, .external_lex_state = 1},
  [548] = {.lex_state = 94, .external_lex_state = 1},
  [549] = {.lex_state = 94, .external_lex_state = 1},
  [550] = {.lex_state = 94, .external_lex_state = 1},
  [551] = {.lex_state = 94, .external_lex_state = 1},
  [552] = {.lex_state = 94, .external_lex_state = 1},
  [553] = {.lex_state = 94, .external_lex_state = 1},
  [554] = {.lex_state = 94, .external_lex_state = 1},
  [555] = {.lex_state = 94, .external_lex_state = 1},
  [556] = {.lex_state = 94, .external_lex_state = 1},
  [557] = {.lex_state = 94, .external_lex_state = 1},
  [558] = {.lex_state = 94, .external_lex_state = 1},
  [559] = {.lex_state = 94, .external_lex_state = 1},
  [560] = {.lex_state = 94, .external_lex_state = 1},
  [561] = {.lex_state = 94, .external_lex_state = 1},
  [562] = {.lex_state = 94, .external_lex_state = 1},
  [563] = {.lex_state = 94, .external_lex_state = 1},
  [564] = {.lex_state = 94, .external_lex_state = 1},
  [565] = {.lex_state = 94, .external_lex_state = 1},
  [566] = {.lex_state = 94, .external_lex_state = 1},
  [567] = {.lex_state = 94, .external_lex_state = 1},
  [568] = {.lex_state = 94, .external_lex_state = 1},
  [569] = {.lex_state = 94, .external_lex_state = 1},
  [570] = {.lex_state = 94, .external_lex_state = 1},
  [571] = {.lex_state = 94, .external_lex_state = 1},
  [572] = {.lex_state = 94, .external_lex_state = 1},
  [573] = {.lex_state = 94, .external_lex_state = 1},
  [574] = {.lex_state = 94, .external_lex_state = 1},
  [575] = {.lex_state = 94, .external_lex_state = 1},
  [576] = {.lex_state = 94, .external_lex_state = 1},
  [577] = {.lex_state = 94, .external_lex_state = 1},
  [578] = {.lex_state = 94, .external_lex_state = 1},
  [579] = {.lex_state = 94, .external_lex_state = 1},
  [580] = {.lex_state = 94, .external_lex_state = 1},
  [581] = {.lex_state = 94, .external_lex_state = 1},
  [582] = {.lex_state = 94, .external_lex_state = 1},
  [583] = {.lex_state = 94, .external_lex_state = 1},
  [584] = {.lex_state = 94, .external_lex_state = 1},
  [585] = {.lex_state = 94, .external_lex_state = 1},
  [586] = {.lex_state = 94, .external_lex_state = 1},
  [587] = {.lex_state = 94, .external_lex_state = 1},
  [588] = {.lex_state = 94, .external_lex_state = 1},
  [589] = {.lex_state = 94, .external_lex_state = 1},
  [590] = {.lex_state = 94, .external_lex_state = 1},
  [591] = {.lex_state = 94, .external_lex_state = 1},
  [592] = {.lex_state = 94, .external_lex_state = 1},
  [593] = {.lex_state = 94, .external_lex_state = 1},
  [594] = {.lex_state = 94, .external_lex_state = 1},
  [595] = {.lex_state = 94, .external_lex_state = 1},
  [596] = {.lex_state = 94, .external_lex_state = 1},
  [597] = {.lex_state = 94, .external_lex_state = 1},
  [598] = {.lex_state = 94, .external_lex_state = 1},
  [599] = {.lex_state = 94, .external_lex_state = 1},
  [600] = {.lex_state = 94, .external_lex_state = 1},
  [601] = {.lex_state = 94, .external_lex_state = 1},
  [602] = {.lex_state = 94, .external_lex_state = 1},
  [603] = {.lex_state = 94, .external_lex_state = 1},
  [604] = {.lex_state = 94, .external_lex_state = 1},
  [605] = {.lex_state = 94, .external_lex_state = 1},
  [606] = {.lex_state = 94, .external_lex_state = 1},
  [607] = {.lex_state = 94, .external_lex_state = 1},
  [608] = {.lex_state = 94, .external_lex_state = 1},
  [609] = {.lex_state = 94, .external_lex_state = 1},
  [610] = {.lex_state = 94, .external_lex_state = 1},
  [611] = {.lex_state = 94, .external_lex_state = 1},
  [612] = {.lex_state = 94, .external_lex_state = 1},
  [613] = {.lex_state = 94, .external_lex_state = 1},
  [614] = {.lex_state = 94, .external_lex_state = 1},
  [615] = {.lex_state = 94, .external_lex_state = 1},
  [616] = {.lex_state = 94, .external_lex_state = 1},
  [617] = {.lex_state = 94, .external_lex_state = 1},
  [618] = {.lex_state = 94, .external_lex_state = 1},
  [619] = {.lex_state = 94, .external_lex_state = 1},
  [620] = {.lex_state = 94, .external_lex_state = 1},
  [621] = {.lex_state = 94, .external_lex_state = 1},
  [622] = {.lex_state = 94, .external_lex_state = 1},
  [623] = {.lex_state = 94, .external_lex_state = 1},
  [624] = {.lex_state = 94, .external_lex_state = 1},
  [625] = {.lex_state = 94, .external_lex_state = 1},
  [626] = {.lex_state = 94, .external_lex_state = 1},
  [627] = {.lex_state = 94, .external_lex_state = 1},
  [628] = {.lex_state = 94, .external_lex_state = 1},
  [629] = {.lex_state = 94, .external_lex_state = 1},
  [630] = {.lex_state = 94, .external_lex_state = 1},
  [631] = {.lex_state = 94, .external_lex_state = 1},
  [632] = {.lex_state = 94, .external_lex_state = 1},
  [633] = {.lex_state = 94, .external_lex_state = 1},
  [634] = {.lex_state = 94, .external_lex_state = 1},
  [635] = {.lex_state = 94, .external_lex_state = 1},
  [636] = {.lex_state = 94, .external_lex_state = 1},
  [637] = {.lex_state = 94, .external_lex_state = 1},
  [638] = {.lex_state = 94, .external_lex_state = 1},
  [639] = {.lex_state = 94, .external_lex_state = 1},
  [640] = {.lex_state = 94, .external_lex_state = 1},
  [641] = {.lex_state = 94, .external_lex_state = 1},
  [642] = {.lex_state = 94, .external_lex_state = 1},
  [643] = {.lex_state = 94, .external_lex_state = 1},
  [644] = {.lex_state = 94, .external_lex_state = 1},
  [645] = {.lex_state = 94, .external_lex_state = 1},
  [646] = {.lex_state = 94, .external_lex_state = 1},
  [647] = {.lex_state = 94, .external_lex_state = 1},
  [648] = {.lex_state = 94, .external_lex_state = 1},
  [649] = {.lex_state = 94, .external_lex_state = 1},
  [650] = {.lex_state = 94, .external_lex_state = 1},
  [651] = {.lex_state = 94, .external_lex_state = 1},
  [652] = {.lex_state = 94, .external_lex_state = 1},
  [653] = {.lex_state = 94, .external_lex_state = 1},
  [654] = {.lex_state = 94, .external_lex_state = 1},
  [655] = {.lex_state = 95, .external_lex_state = 2},
  [656] = {.lex_state = 95, .external_lex_state = 2},
  [657] = {.lex_state = 95, .external_lex_state = 2},
  [658] = {.lex_state = 95, .external_lex_state = 2},
  [659] = {.lex_state = 95, .external_lex_state = 2},
  [660] = {.lex_state = 95, .external_lex_state = 2},
  [661] = {.lex_state = 95, .external_lex_state = 2},
  [662] = {.lex_state = 95, .external_lex_state = 2},
  [663] = {.lex_state = 95, .external_lex_state = 2},
  [664] = {.lex_state = 95, .external_lex_state = 2},
  [665] = {.lex_state = 95, .external_lex_state = 2},
  [666] = {.lex_state = 95, .external_lex_state = 2},
  [667] = {.lex_state = 95, .external_lex_state = 2},
  [668] = {.lex_state = 95, .external_lex_state = 2},
  [669] = {.lex_state = 95, .external_lex_state = 2},
  [670] = {.lex_state = 95, .external_lex_state = 2},
  [671] = {.lex_state = 95, .external_lex_state = 2},
  [672] = {.lex_state = 95, .external_lex_state = 2},
  [673] = {.lex_state = 95, .external_lex_state = 2},
  [674] = {.lex_state = 95, .external_lex_state = 2},
  [675] = {.lex_state = 95, .external_lex_state = 2},
  [676] = {.lex_state = 95, .external_lex_state = 2},
  [677] = {.lex_state = 95, .external_lex_state = 2},
  [678] = {.lex_state = 95, .external_lex_state = 2},
  [679] = {.lex_state = 95, .external_lex_state = 2},
  [680] = {.lex_state = 95, .external_lex_state = 2},
  [681] = {.lex_state = 95, .external_lex_state = 2},
  [682] = {.lex_state = 95, .external_lex_state = 2},
  [683] = {.lex_state = 95, .external_lex_state = 2},
  [684] = {.lex_state = 95, .external_lex_state = 2},
  [685] = {.lex_state = 95, .external_lex_state = 2},
  [686] = {.lex_state = 95, .external_lex_state = 2},
  [687] = {.lex_state = 95, .external_lex_state = 2},
  [688] = {.lex_state = 0, .external_lex_state = 2},
  [689] = {.lex_state = 12, .external_lex_state = 2},
  [690] = {.lex_state = 0, .external_lex_state = 2},
  [691] = {.lex_state = 0, .external_lex_state = 1},
  [692] = {.lex_state = 0, .external_lex_state = 1},
  [693] = {.lex_state = 0, .external_lex_state = 2},
  [694] = {.lex_state = 0, .external_lex_state = 2},
  [695] = {.lex_state = 0, .external_lex_state = 2},
  [696] = {.lex_state = 0, .external_lex_state = 2},
  [697] = {.lex_state = 0, .external_lex_state = 2},
  [698] = {.lex_state = 0, .external_lex_state = 2},
  [699] = {.lex_state = 0, .external_lex_state = 2},
  [700] = {.lex_state = 0, .external_lex_state = 2},
  [701] = {.lex_state = 11, .external_lex_state = 2},
  [702] = {.lex_state = 0, .external_lex_state = 2},
  [703] = {.lex_state = 0, .external_lex_state = 2},
  [704] = {.lex_state = 0, .external_lex_state = 2},
  [705] = {.lex_state = 11, .external_lex_state = 2},
  [706] = {.lex_state = 0, .external_lex_state = 2},
  [707] = {.lex_state = 0, .external_lex_state = 2},
  [708] = {.lex_state = 0, .external_lex_state = 2},
  [709] = {.lex_state = 0, .external_lex_state = 2},
  [710] = {.lex_state = 0, .external_lex_state = 2},
  [711] = {.lex_state = 0, .external_lex_state = 2},
  [712] = {.lex_state = 0, .external_lex_state = 2},
  [713] = {.lex_state = 11, .external_lex_state = 2},
  [714] = {.lex_state = 0, .external_lex_state = 2},
  [715] = {.lex_state = 11, .external_lex_state = 2},
  [716] = {.lex_state = 0, .external_lex_state = 2},
  [717] = {.lex_state = 0, .external_lex_state = 2},
  [718] = {.lex_state = 0, .external_lex_state = 1},
  [719] = {.lex_state = 0, .external_lex_state = 2},
  [720] = {.lex_state = 0, .external_lex_state = 1},
  [721] = {.lex_state = 0, .external_lex_state = 1},
  [722] = {.lex_state = 0, .external_lex_state = 2},
  [723] = {.lex_state = 0, .external_lex_state = 1},
  [724] = {.lex_state = 0, .external_lex_state = 2},
  [725] = {.lex_state = 0, .external_lex_state = 2},
  [726] = {.lex_state = 0, .external_lex_state = 1},
  [727] = {.lex_state = 0, .external_lex_state = 2},
  [728] = {.lex_state = 0, .external_lex_state = 2},
  [729] = {.lex_state = 13, .external_lex_state = 2},
  [730] = {.lex_state = 0, .external_lex_state = 2},
  [731] = {.lex_state = 0, .external_lex_state = 2},
  [732] = {.lex_state = 0, .external_lex_state = 2},
  [733] = {.lex_state = 0, .external_lex_state = 2},
  [734] = {.lex_state = 0, .external_lex_state = 2},
  [735] = {.lex_state = 0, .external_lex_state = 2},
  [736] = {.lex_state = 0, .external_lex_state = 2},
  [737] = {.lex_state = 0, .external_lex_state = 2},
  [738] = {.lex_state = 0, .external_lex_state = 2},
  [739] = {.lex_state = 0, .external_lex_state = 2},
  [740] = {.lex_state = 0, .external_lex_state = 2},
  [741] = {.lex_state = 11, .external_lex_state = 2},
  [742] = {.lex_state = 0, .external_lex_state = 2},
  [743] = {.lex_state = 0, .external_lex_state = 2},
  [744] = {.lex_state = 0, .external_lex_state = 2},
  [745] = {.lex_state = 0, .external_lex_state = 2},
  [746] = {.lex_state = 0, .external_lex_state = 2},
  [747] = {.lex_state = 46, .external_lex_state = 2},
  [748] = {.lex_state = 0, .external_lex_state = 2},
  [749] = {.lex_state = 0, .external_lex_state = 2},
  [750] = {.lex_state = 0, .external_lex_state = 2},
  [751] = {.lex_state = 0, .external_lex_state = 2},
  [752] = {.lex_state = 11, .external_lex_state = 2},
  [753] = {.lex_state = 0, .external_lex_state = 2},
  [754] = {.lex_state = 0, .external_lex_state = 2},
  [755] = {.lex_state = 0, .external_lex_state = 2},
  [756] = {.lex_state = 46, .external_lex_state = 2},
  [757] = {.lex_state = 0, .external_lex_state = 2},
  [758] = {.lex_state = 0, .external_lex_state = 2},
  [759] = {.lex_state = 0, .external_lex_state = 2},
  [760] = {.lex_state = 11, .external_lex_state = 2},
  [761] = {.lex_state = 0, .external_lex_state = 2},
  [762] = {.lex_state = 0, .external_lex_state = 2},
  [763] = {.lex_state = 0, .external_lex_state = 2},
  [764] = {.lex_state = 0, .external_lex_state = 2},
  [765] = {.lex_state = 0, .external_lex_state = 2},
  [766] = {.lex_state = 0, .external_lex_state = 2},
  [767] = {.lex_state = 46, .external_lex_state = 2},
  [768] = {.lex_state = 0, .external_lex_state = 2},
  [769] = {.lex_state = 0, .external_lex_state = 2},
  [770] = {.lex_state = 0, .external_lex_state = 2},
  [771] = {.lex_state = 11, .external_lex_state = 2},
  [772] = {.lex_state = 0, .external_lex_state = 2},
  [773] = {.lex_state = 0, .external_lex_state = 2},
  [774] = {.lex_state = 46, .external_lex_state = 2},
  [775] = {.lex_state = 0, .external_lex_state = 2},
  [776] = {.lex_state = 11, .external_lex_state = 2},
  [777] = {.lex_state = 0, .external_lex_state = 2},
  [778] = {.lex_state = 11, .external_lex_state = 2},
  [779] = {.lex_state = 0, .external_lex_state = 2},
  [780] = {.lex_state = 0, .external_lex_state = 2},
  [781] = {.lex_state = 0, .external_lex_state = 2},
  [782] = {.lex_state = 0, .external_lex_state = 2},
  [783] = {.lex_state = 0, .external_lex_state = 2},
  [784] = {.lex_state = 0, .external_lex_state = 2},
  [785] = {.lex_state = 0, .external_lex_state = 2},
  [786] = {.lex_state = 0, .external_lex_state = 2},
  [787] = {.lex_state = 0, .external_lex_state = 2},
  [788] = {.lex_state = 0, .external_lex_state = 2},
  [789] = {.lex_state = 0, .external_lex_state = 2},
  [790] = {.lex_state = 0, .external_lex_state = 2},
  [791] = {.lex_state = 11, .external_lex_state = 2},
  [792] = {.lex_state = 0, .external_lex_state = 2},
  [793] = {.lex_state = 0, .external_lex_state = 2},
  [794] = {.lex_state = 0, .external_lex_state = 2},
  [795] = {.lex_state = 0, .external_lex_state = 2},
  [796] = {.lex_state = 0, .external_lex_state = 2},
  [797] = {.lex_state = 0, .external_lex_state = 2},
  [798] = {.lex_state = 0, .external_lex_state = 2},
  [799] = {.lex_state = 0, .external_lex_state = 2},
  [800] = {.lex_state = 11, .external_lex_state = 2},
  [801] = {.lex_state = 11, .external_lex_state = 2},
  [802] = {.lex_state = 11, .external_lex_state = 2},
  [803] = {.lex_state = 0, .external_lex_state = 2},
  [804] = {.lex_state = 0, .external_lex_state = 2},
  [805] = {.lex_state = 11, .external_lex_state = 2},
  [806] = {.lex_state = 11, .external_lex_state = 2},
  [807] = {.lex_state = 0, .external_lex_state = 2},
  [808] = {.lex_state = 0, .external_lex_state = 2},
  [809] = {.lex_state = 0, .external_lex_state = 2},
  [810] = {.lex_state = 11, .external_lex_state = 2},
  [811] = {.lex_state = 0, .external_lex_state = 2},
  [812] = {.lex_state = 0, .external_lex_state = 2},
  [813] = {.lex_state = 0, .external_lex_state = 2},
  [814] = {.lex_state = 0, .external_lex_state = 2},
  [815] = {.lex_state = 0, .external_lex_state = 2},
  [816] = {.lex_state = 0, .external_lex_state = 2},
  [817] = {.lex_state = 0, .external_lex_state = 2},
  [818] = {.lex_state = 11, .external_lex_state = 2},
  [819] = {.lex_state = 11, .external_lex_state = 2},
  [820] = {.lex_state = 0, .external_lex_state = 2},
  [821] = {.lex_state = 0, .external_lex_state = 2},
  [822] = {.lex_state = 0, .external_lex_state = 2},
  [823] = {.lex_state = 0, .external_lex_state = 2},
  [824] = {.lex_state = 0, .external_lex_state = 2},
  [825] = {.lex_state = 0, .external_lex_state = 2},
  [826] = {.lex_state = 0, .external_lex_state = 2},
  [827] = {.lex_state = 0, .external_lex_state = 2},
  [828] = {.lex_state = 0, .external_lex_state = 2},
  [829] = {.lex_state = 0, .external_lex_state = 2},
  [830] = {.lex_state = 11, .external_lex_state = 2},
  [831] = {.lex_state = 0, .external_lex_state = 2},
  [832] = {.lex_state = 0, .external_lex_state = 2},
  [833] = {.lex_state = 0, .external_lex_state = 2},
  [834] = {.lex_state = 0, .external_lex_state = 2},
  [835] = {.lex_state = 11, .external_lex_state = 2},
  [836] = {.lex_state = 0, .external_lex_state = 2},
  [837] = {.lex_state = 0, .external_lex_state = 2},
  [838] = {.lex_state = 0, .external_lex_state = 2},
  [839] = {.lex_state = 0, .external_lex_state = 2},
  [840] = {.lex_state = 0, .external_lex_state = 2},
  [841] = {.lex_state = 0, .external_lex_state = 2},
  [842] = {.lex_state = 0, .external_lex_state = 2},
  [843] = {.lex_state = 0, .external_lex_state = 2},
  [844] = {.lex_state = 0, .external_lex_state = 2},
  [845] = {.lex_state = 0, .external_lex_state = 2},
  [846] = {.lex_state = 0, .external_lex_state = 2},
  [847] = {.lex_state = 11, .external_lex_state = 2},
  [848] = {.lex_state = 11, .external_lex_state = 2},
  [849] = {.lex_state = 0, .external_lex_state = 2},
  [850] = {.lex_state = 11, .external_lex_state = 2},
  [851] = {.lex_state = 0, .external_lex_state = 2},
  [852] = {.lex_state = 0, .external_lex_state = 2},
  [853] = {.lex_state = 11, .external_lex_state = 2},
  [854] = {.lex_state = 0, .external_lex_state = 2},
  [855] = {.lex_state = 0, .external_lex_state = 2},
  [856] = {.lex_state = 0, .external_lex_state = 2},
  [857] = {.lex_state = 0, .external_lex_state = 2},
  [858] = {.lex_state = 0, .external_lex_state = 2},
  [859] = {.lex_state = 0, .external_lex_state = 2},
  [860] = {.lex_state = 0, .external_lex_state = 2},
  [861] = {.lex_state = 11, .external_lex_state = 2},
  [862] = {.lex_state = 0, .external_lex_state = 2},
  [863] = {.lex_state = 0, .external_lex_state = 2},
  [864] = {.lex_state = 0, .external_lex_state = 2},
  [865] = {.lex_state = 11, .external_lex_state = 2},
  [866] = {.lex_state = 0, .external_lex_state = 2},
  [867] = {.lex_state = 11, .external_lex_state = 2},
  [868] = {.lex_state = 0, .external_lex_state = 2},
  [869] = {.lex_state = 11, .external_lex_state = 2},
  [870] = {.lex_state = 0, .external_lex_state = 2},
  [871] = {.lex_state = 11, .external_lex_state = 2},
  [872] = {.lex_state = 0, .external_lex_state = 2},
  [873] = {.lex_state = 0, .external_lex_state = 2},
  [874] = {.lex_state = 0, .external_lex_state = 2},
  [875] = {.lex_state = 11, .external_lex_state = 2},
  [876] = {.lex_state = 0, .external_lex_state = 2},
  [877] = {.lex_state = 11, .external_lex_state = 2},
  [878] = {.lex_state = 0, .external_lex_state = 2},
  [879] = {.lex_state = 0, .external_lex_state = 2},
  [880] = {.lex_state = 0, .external_lex_state = 2},
  [881] = {.lex_state = 0, .external_lex_state = 2},
  [882] = {.lex_state = 11, .external_lex_state = 2},
  [883] = {.lex_state = 11, .external_lex_state = 2},
  [884] = {.lex_state = 11, .external_lex_state = 2},
  [885] = {.lex_state = 11, .external_lex_state = 2},
  [886] = {.lex_state = 11, .external_lex_state = 2},
  [887] = {.lex_state = 0, .external_lex_state = 2},
  [888] = {.lex_state = 0, .external_lex_state = 2},
  [889] = {.lex_state = 0, .external_lex_state = 2},
  [890] = {.lex_state = 0, .external_lex_state = 2},
  [891] = {.lex_state = 11, .external_lex_state = 2},
  [892] = {.lex_state = 0, .external_lex_state = 2},
  [893] = {.lex_state = 11, .external_lex_state = 2},
  [894] = {.lex_state = 0, .external_lex_state = 2},
  [895] = {.lex_state = 0, .external_lex_state = 2},
  [896] = {.lex_state = 0, .external_lex_state = 2},
  [897] = {.lex_state = 0, .external_lex_state = 2},
  [898] = {.lex_state = 0, .external_lex_state = 2},
  [899] = {.lex_state = 0, .external_lex_state = 2},
  [900] = {.lex_state = 0, .external_lex_state = 2},
  [901] = {.lex_state = 0, .external_lex_state = 2},
  [902] = {.lex_state = 0, .external_lex_state = 2},
  [903] = {.lex_state = 0, .external_lex_state = 2},
  [904] = {.lex_state = 0, .external_lex_state = 2},
  [905] = {.lex_state = 0, .external_lex_state = 2},
  [906] = {.lex_state = 0, .external_lex_state = 2},
  [907] = {.lex_state = 0, .external_lex_state = 2},
  [908] = {.lex_state = 0, .external_lex_state = 2},
  [909] = {.lex_state = 0, .external_lex_state = 2},
};

enum {
  ts_external_token_comment = 0,
  ts_external_token_string = 1,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_comment] = sym_comment,
  [ts_external_token_string] = sym_string,
};

static const bool ts_external_scanner_states[3][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_comment] = true,
    [ts_external_token_string] = true,
  },
  [2] = {
    [ts_external_token_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_shebang] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym_spread] = ACTIONS(1),
    [sym_self] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [anon_sym__G] = ACTIONS(1),
    [anon_sym__VERSION] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(857),
    [sym_return_statement] = STATE(852),
    [sym_variable_declaration] = STATE(31),
    [sym_local_variable_declaration] = STATE(31),
    [sym__variable_declarator] = STATE(26),
    [sym_field_expression] = STATE(107),
    [sym_do_statement] = STATE(31),
    [sym_if_statement] = STATE(31),
    [sym_while_statement] = STATE(31),
    [sym_repeat_statement] = STATE(31),
    [sym_for_statement] = STATE(31),
    [sym_for_in_statement] = STATE(31),
    [sym_goto_statement] = STATE(31),
    [sym_label_statement] = STATE(31),
    [sym__empty_statement] = STATE(31),
    [sym_function_statement] = STATE(31),
    [sym_local_function_statement] = STATE(31),
    [sym_function_call_statement] = STATE(160),
    [sym__expression] = STATE(254),
    [sym_global_variable] = STATE(30),
    [sym__prefix] = STATE(30),
    [sym_function_definition] = STATE(248),
    [sym_table] = STATE(248),
    [sym_binary_operation] = STATE(248),
    [sym_unary_operation] = STATE(248),
    [aux_sym_program_repeat1] = STATE(31),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_shebang] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(11),
    [anon_sym_do] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_goto] = ACTIONS(23),
    [sym_break_statement] = ACTIONS(25),
    [anon_sym_COLON_COLON] = ACTIONS(27),
    [anon_sym_SEMI] = ACTIONS(29),
    [anon_sym_function] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [sym_spread] = ACTIONS(35),
    [sym_self] = ACTIONS(37),
    [sym_next] = ACTIONS(39),
    [anon_sym__G] = ACTIONS(41),
    [anon_sym__VERSION] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(45),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_POUND] = ACTIONS(47),
    [sym_number] = ACTIONS(35),
    [sym_nil] = ACTIONS(39),
    [sym_true] = ACTIONS(39),
    [sym_false] = ACTIONS(39),
    [sym_identifier] = ACTIONS(49),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(35),
  },
  [2] = {
    [sym_return_statement] = STATE(699),
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_elseif] = STATE(700),
    [sym_else] = STATE(902),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_if_statement_repeat1] = STATE(700),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_local] = ACTIONS(53),
    [anon_sym_do] = ACTIONS(55),
    [anon_sym_end] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_elseif] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_goto] = ACTIONS(71),
    [sym_break_statement] = ACTIONS(73),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [sym_spread] = ACTIONS(83),
    [sym_self] = ACTIONS(85),
    [sym_next] = ACTIONS(87),
    [anon_sym__G] = ACTIONS(89),
    [anon_sym__VERSION] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(95),
    [anon_sym_POUND] = ACTIONS(93),
    [sym_number] = ACTIONS(83),
    [sym_nil] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_identifier] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(83),
  },
  [3] = {
    [sym_return_statement] = STATE(716),
    [sym_variable_declaration] = STATE(2),
    [sym_local_variable_declaration] = STATE(2),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(2),
    [sym_if_statement] = STATE(2),
    [sym_elseif] = STATE(714),
    [sym_else] = STATE(890),
    [sym_while_statement] = STATE(2),
    [sym_repeat_statement] = STATE(2),
    [sym_for_statement] = STATE(2),
    [sym_for_in_statement] = STATE(2),
    [sym_goto_statement] = STATE(2),
    [sym_label_statement] = STATE(2),
    [sym__empty_statement] = STATE(2),
    [sym_function_statement] = STATE(2),
    [sym_local_function_statement] = STATE(2),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(2),
    [aux_sym_if_statement_repeat1] = STATE(714),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_local] = ACTIONS(53),
    [anon_sym_do] = ACTIONS(55),
    [anon_sym_end] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_elseif] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_goto] = ACTIONS(71),
    [sym_break_statement] = ACTIONS(101),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(103),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [sym_spread] = ACTIONS(83),
    [sym_self] = ACTIONS(85),
    [sym_next] = ACTIONS(87),
    [anon_sym__G] = ACTIONS(89),
    [anon_sym__VERSION] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(95),
    [anon_sym_POUND] = ACTIONS(93),
    [sym_number] = ACTIONS(83),
    [sym_nil] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_identifier] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(83),
  },
  [4] = {
    [sym_return_statement] = STATE(696),
    [sym_variable_declaration] = STATE(5),
    [sym_local_variable_declaration] = STATE(5),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_elseif] = STATE(698),
    [sym_else] = STATE(782),
    [sym_while_statement] = STATE(5),
    [sym_repeat_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_for_in_statement] = STATE(5),
    [sym_goto_statement] = STATE(5),
    [sym_label_statement] = STATE(5),
    [sym__empty_statement] = STATE(5),
    [sym_function_statement] = STATE(5),
    [sym_local_function_statement] = STATE(5),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(5),
    [aux_sym_if_statement_repeat1] = STATE(698),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_local] = ACTIONS(53),
    [anon_sym_do] = ACTIONS(55),
    [anon_sym_end] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_elseif] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_goto] = ACTIONS(71),
    [sym_break_statement] = ACTIONS(107),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(109),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [sym_spread] = ACTIONS(83),
    [sym_self] = ACTIONS(85),
    [sym_next] = ACTIONS(87),
    [anon_sym__G] = ACTIONS(89),
    [anon_sym__VERSION] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(95),
    [anon_sym_POUND] = ACTIONS(93),
    [sym_number] = ACTIONS(83),
    [sym_nil] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_identifier] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(83),
  },
  [5] = {
    [sym_return_statement] = STATE(709),
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_elseif] = STATE(708),
    [sym_else] = STATE(832),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_if_statement_repeat1] = STATE(708),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_local] = ACTIONS(53),
    [anon_sym_do] = ACTIONS(55),
    [anon_sym_end] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_elseif] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_goto] = ACTIONS(71),
    [sym_break_statement] = ACTIONS(73),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [sym_spread] = ACTIONS(83),
    [sym_self] = ACTIONS(85),
    [sym_next] = ACTIONS(87),
    [anon_sym__G] = ACTIONS(89),
    [anon_sym__VERSION] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(95),
    [anon_sym_POUND] = ACTIONS(93),
    [sym_number] = ACTIONS(83),
    [sym_nil] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_identifier] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(83),
  },
  [6] = {
    [sym_return_statement] = STATE(706),
    [sym_variable_declaration] = STATE(7),
    [sym_local_variable_declaration] = STATE(7),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_elseif] = STATE(695),
    [sym_else] = STATE(793),
    [sym_while_statement] = STATE(7),
    [sym_repeat_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_goto_statement] = STATE(7),
    [sym_label_statement] = STATE(7),
    [sym__empty_statement] = STATE(7),
    [sym_function_statement] = STATE(7),
    [sym_local_function_statement] = STATE(7),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_if_statement_repeat1] = STATE(695),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_local] = ACTIONS(53),
    [anon_sym_do] = ACTIONS(55),
    [anon_sym_end] = ACTIONS(113),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_elseif] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_goto] = ACTIONS(71),
    [sym_break_statement] = ACTIONS(115),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(117),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [sym_spread] = ACTIONS(83),
    [sym_self] = ACTIONS(85),
    [sym_next] = ACTIONS(87),
    [anon_sym__G] = ACTIONS(89),
    [anon_sym__VERSION] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(95),
    [anon_sym_POUND] = ACTIONS(93),
    [sym_number] = ACTIONS(83),
    [sym_nil] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_identifier] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(83),
  },
  [7] = {
    [sym_return_statement] = STATE(697),
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_elseif] = STATE(707),
    [sym_else] = STATE(786),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_if_statement_repeat1] = STATE(707),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_local] = ACTIONS(53),
    [anon_sym_do] = ACTIONS(55),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_elseif] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_goto] = ACTIONS(71),
    [sym_break_statement] = ACTIONS(73),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [sym_spread] = ACTIONS(83),
    [sym_self] = ACTIONS(85),
    [sym_next] = ACTIONS(87),
    [anon_sym__G] = ACTIONS(89),
    [anon_sym__VERSION] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(95),
    [anon_sym_POUND] = ACTIONS(93),
    [sym_number] = ACTIONS(83),
    [sym_nil] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_identifier] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(83),
  },
  [8] = {
    [sym_return_statement] = STATE(703),
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_elseif] = STATE(704),
    [sym_else] = STATE(833),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_if_statement_repeat1] = STATE(704),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_local] = ACTIONS(53),
    [anon_sym_do] = ACTIONS(55),
    [anon_sym_end] = ACTIONS(121),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_elseif] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_goto] = ACTIONS(71),
    [sym_break_statement] = ACTIONS(73),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [sym_spread] = ACTIONS(83),
    [sym_self] = ACTIONS(85),
    [sym_next] = ACTIONS(87),
    [anon_sym__G] = ACTIONS(89),
    [anon_sym__VERSION] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(95),
    [anon_sym_POUND] = ACTIONS(93),
    [sym_number] = ACTIONS(83),
    [sym_nil] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_identifier] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(83),
  },
  [9] = {
    [sym_return_statement] = STATE(712),
    [sym_variable_declaration] = STATE(8),
    [sym_local_variable_declaration] = STATE(8),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(8),
    [sym_if_statement] = STATE(8),
    [sym_elseif] = STATE(710),
    [sym_else] = STATE(822),
    [sym_while_statement] = STATE(8),
    [sym_repeat_statement] = STATE(8),
    [sym_for_statement] = STATE(8),
    [sym_for_in_statement] = STATE(8),
    [sym_goto_statement] = STATE(8),
    [sym_label_statement] = STATE(8),
    [sym__empty_statement] = STATE(8),
    [sym_function_statement] = STATE(8),
    [sym_local_function_statement] = STATE(8),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(8),
    [aux_sym_if_statement_repeat1] = STATE(710),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_local] = ACTIONS(53),
    [anon_sym_do] = ACTIONS(55),
    [anon_sym_end] = ACTIONS(123),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_elseif] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_goto] = ACTIONS(71),
    [sym_break_statement] = ACTIONS(125),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(127),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [sym_spread] = ACTIONS(83),
    [sym_self] = ACTIONS(85),
    [sym_next] = ACTIONS(87),
    [anon_sym__G] = ACTIONS(89),
    [anon_sym__VERSION] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(95),
    [anon_sym_POUND] = ACTIONS(93),
    [sym_number] = ACTIONS(83),
    [sym_nil] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_identifier] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(83),
  },
  [10] = {
    [sym_return_statement] = STATE(758),
    [sym_variable_declaration] = STATE(13),
    [sym_local_variable_declaration] = STATE(13),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_repeat_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_for_in_statement] = STATE(13),
    [sym_goto_statement] = STATE(13),
    [sym_label_statement] = STATE(13),
    [sym__empty_statement] = STATE(13),
    [sym_function_statement] = STATE(13),
    [sym_local_function_statement] = STATE(13),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(13),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_local] = ACTIONS(53),
    [anon_sym_do] = ACTIONS(55),
    [anon_sym_end] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_elseif] = ACTIONS(129),
    [anon_sym_else] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_goto] = ACTIONS(71),
    [sym_break_statement] = ACTIONS(131),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(133),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [sym_spread] = ACTIONS(83),
    [sym_self] = ACTIONS(85),
    [sym_next] = ACTIONS(87),
    [anon_sym__G] = ACTIONS(89),
    [anon_sym__VERSION] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(95),
    [anon_sym_POUND] = ACTIONS(93),
    [sym_number] = ACTIONS(83),
    [sym_nil] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_identifier] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(83),
  },
  [11] = {
    [aux_sym_variable_declaration_repeat1] = STATE(739),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_COMMA] = ACTIONS(137),
    [anon_sym_EQ] = ACTIONS(139),
    [anon_sym_local] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_do] = ACTIONS(135),
    [anon_sym_end] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_elseif] = ACTIONS(135),
    [anon_sym_else] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(135),
    [anon_sym_for] = ACTIONS(135),
    [anon_sym_goto] = ACTIONS(135),
    [sym_break_statement] = ACTIONS(135),
    [anon_sym_COLON_COLON] = ACTIONS(141),
    [anon_sym_SEMI] = ACTIONS(141),
    [anon_sym_function] = ACTIONS(135),
    [anon_sym_COLON] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(141),
    [sym_spread] = ACTIONS(141),
    [sym_self] = ACTIONS(135),
    [sym_next] = ACTIONS(135),
    [anon_sym__G] = ACTIONS(135),
    [anon_sym__VERSION] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(141),
    [anon_sym_or] = ACTIONS(135),
    [anon_sym_and] = ACTIONS(135),
    [anon_sym_LT] = ACTIONS(135),
    [anon_sym_LT_EQ] = ACTIONS(141),
    [anon_sym_EQ_EQ] = ACTIONS(141),
    [anon_sym_TILDE_EQ] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(141),
    [anon_sym_GT] = ACTIONS(135),
    [anon_sym_PIPE] = ACTIONS(141),
    [anon_sym_TILDE] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(141),
    [anon_sym_LT_LT] = ACTIONS(141),
    [anon_sym_GT_GT] = ACTIONS(141),
    [anon_sym_PLUS] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(141),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_SLASH] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(141),
    [anon_sym_PERCENT] = ACTIONS(141),
    [anon_sym_DOT_DOT] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(141),
    [anon_sym_not] = ACTIONS(135),
    [anon_sym_POUND] = ACTIONS(141),
    [sym_number] = ACTIONS(141),
    [sym_nil] = ACTIONS(135),
    [sym_true] = ACTIONS(135),
    [sym_false] = ACTIONS(135),
    [sym_identifier] = ACTIONS(135),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(141),
  },
  [12] = {
    [sym_arguments] = STATE(61),
    [sym_table] = STATE(74),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(145),
    [anon_sym_local] = ACTIONS(143),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_DOT] = ACTIONS(149),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_end] = ACTIONS(143),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_elseif] = ACTIONS(143),
    [anon_sym_else] = ACTIONS(143),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_repeat] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_goto] = ACTIONS(143),
    [sym_break_statement] = ACTIONS(143),
    [anon_sym_COLON_COLON] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_COLON] = ACTIONS(151),
    [anon_sym_LPAREN] = ACTIONS(153),
    [sym_spread] = ACTIONS(145),
    [sym_self] = ACTIONS(143),
    [sym_next] = ACTIONS(143),
    [anon_sym__G] = ACTIONS(143),
    [anon_sym__VERSION] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(156),
    [anon_sym_or] = ACTIONS(143),
    [anon_sym_and] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(143),
    [anon_sym_LT_EQ] = ACTIONS(145),
    [anon_sym_EQ_EQ] = ACTIONS(145),
    [anon_sym_TILDE_EQ] = ACTIONS(145),
    [anon_sym_GT_EQ] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(143),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(143),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LT_LT] = ACTIONS(145),
    [anon_sym_GT_GT] = ACTIONS(145),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_STAR] = ACTIONS(145),
    [anon_sym_SLASH] = ACTIONS(143),
    [anon_sym_SLASH_SLASH] = ACTIONS(145),
    [anon_sym_PERCENT] = ACTIONS(145),
    [anon_sym_DOT_DOT] = ACTIONS(143),
    [anon_sym_CARET] = ACTIONS(145),
    [anon_sym_not] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [sym_number] = ACTIONS(145),
    [sym_nil] = ACTIONS(143),
    [sym_true] = ACTIONS(143),
    [sym_false] = ACTIONS(143),
    [sym_identifier] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(159),
  },
  [13] = {
    [sym_return_statement] = STATE(766),
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_local] = ACTIONS(53),
    [anon_sym_do] = ACTIONS(55),
    [anon_sym_end] = ACTIONS(162),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_elseif] = ACTIONS(162),
    [anon_sym_else] = ACTIONS(162),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [anon_sym_goto] = ACTIONS(71),
    [sym_break_statement] = ACTIONS(73),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [sym_spread] = ACTIONS(83),
    [sym_self] = ACTIONS(85),
    [sym_next] = ACTIONS(87),
    [anon_sym__G] = ACTIONS(89),
    [anon_sym__VERSION] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_TILDE] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(95),
    [anon_sym_POUND] = ACTIONS(93),
    [sym_number] = ACTIONS(83),
    [sym_nil] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_identifier] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(83),
  },
  [14] = {
    [anon_sym_return] = ACTIONS(164),
    [anon_sym_COMMA] = ACTIONS(166),
    [anon_sym_EQ] = ACTIONS(164),
    [anon_sym_local] = ACTIONS(164),
    [anon_sym_LBRACK] = ACTIONS(166),
    [anon_sym_DOT] = ACTIONS(164),
    [anon_sym_do] = ACTIONS(164),
    [anon_sym_end] = ACTIONS(164),
    [anon_sym_if] = ACTIONS(164),
    [anon_sym_elseif] = ACTIONS(164),
    [anon_sym_else] = ACTIONS(164),
    [anon_sym_while] = ACTIONS(164),
    [anon_sym_repeat] = ACTIONS(164),
    [anon_sym_for] = ACTIONS(164),
    [anon_sym_goto] = ACTIONS(164),
    [sym_break_statement] = ACTIONS(164),
    [anon_sym_COLON_COLON] = ACTIONS(166),
    [anon_sym_SEMI] = ACTIONS(166),
    [anon_sym_function] = ACTIONS(164),
    [anon_sym_COLON] = ACTIONS(164),
    [anon_sym_LPAREN] = ACTIONS(166),
    [sym_spread] = ACTIONS(166),
    [sym_self] = ACTIONS(164),
    [sym_next] = ACTIONS(164),
    [anon_sym__G] = ACTIONS(164),
    [anon_sym__VERSION] = ACTIONS(164),
    [anon_sym_LBRACE] = ACTIONS(166),
    [anon_sym_or] = ACTIONS(164),
    [anon_sym_and] = ACTIONS(164),
    [anon_sym_LT] = ACTIONS(164),
    [anon_sym_LT_EQ] = ACTIONS(166),
    [anon_sym_EQ_EQ] = ACTIONS(166),
    [anon_sym_TILDE_EQ] = ACTIONS(166),
    [anon_sym_GT_EQ] = ACTIONS(166),
    [anon_sym_GT] = ACTIONS(164),
    [anon_sym_PIPE] = ACTIONS(166),
    [anon_sym_TILDE] = ACTIONS(164),
    [anon_sym_AMP] = ACTIONS(166),
    [anon_sym_LT_LT] = ACTIONS(166),
    [anon_sym_GT_GT] = ACTIONS(166),
    [anon_sym_PLUS] = ACTIONS(166),
    [anon_sym_DASH] = ACTIONS(166),
    [anon_sym_STAR] = ACTIONS(166),
    [anon_sym_SLASH] = ACTIONS(164),
    [anon_sym_SLASH_SLASH] = ACTIONS(166),
    [anon_sym_PERCENT] = ACTIONS(166),
    [anon_sym_DOT_DOT] = ACTIONS(164),
    [anon_sym_CARET] = ACTIONS(166),
    [anon_sym_not] = ACTIONS(164),
    [anon_sym_POUND] = ACTIONS(166),
    [sym_number] = ACTIONS(166),
    [sym_nil] = ACTIONS(164),
    [sym_true] = ACTIONS(164),
    [sym_false] = ACTIONS(164),
    [sym_identifier] = ACTIONS(164),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(166),
  },
  [15] = {
    [anon_sym_return] = ACTIONS(168),
    [anon_sym_COMMA] = ACTIONS(170),
    [anon_sym_EQ] = ACTIONS(168),
    [anon_sym_local] = ACTIONS(168),
    [anon_sym_LBRACK] = ACTIONS(170),
    [anon_sym_DOT] = ACTIONS(168),
    [anon_sym_do] = ACTIONS(168),
    [anon_sym_end] = ACTIONS(168),
    [anon_sym_if] = ACTIONS(168),
    [anon_sym_elseif] = ACTIONS(168),
    [anon_sym_else] = ACTIONS(168),
    [anon_sym_while] = ACTIONS(168),
    [anon_sym_repeat] = ACTIONS(168),
    [anon_sym_for] = ACTIONS(168),
    [anon_sym_goto] = ACTIONS(168),
    [sym_break_statement] = ACTIONS(168),
    [anon_sym_COLON_COLON] = ACTIONS(170),
    [anon_sym_SEMI] = ACTIONS(170),
    [anon_sym_function] = ACTIONS(168),
    [anon_sym_COLON] = ACTIONS(168),
    [anon_sym_LPAREN] = ACTIONS(170),
    [sym_spread] = ACTIONS(170),
    [sym_self] = ACTIONS(168),
    [sym_next] = ACTIONS(168),
    [anon_sym__G] = ACTIONS(168),
    [anon_sym__VERSION] = ACTIONS(168),
    [anon_sym_LBRACE] = ACTIONS(170),
    [anon_sym_or] = ACTIONS(168),
    [anon_sym_and] = ACTIONS(168),
    [anon_sym_LT] = ACTIONS(168),
    [anon_sym_LT_EQ] = ACTIONS(170),
    [anon_sym_EQ_EQ] = ACTIONS(170),
    [anon_sym_TILDE_EQ] = ACTIONS(170),
    [anon_sym_GT_EQ] = ACTIONS(170),
    [anon_sym_GT] = ACTIONS(168),
    [anon_sym_PIPE] = ACTIONS(170),
    [anon_sym_TILDE] = ACTIONS(168),
    [anon_sym_AMP] = ACTIONS(170),
    [anon_sym_LT_LT] = ACTIONS(170),
    [anon_sym_GT_GT] = ACTIONS(170),
    [anon_sym_PLUS] = ACTIONS(170),
    [anon_sym_DASH] = ACTIONS(170),
    [anon_sym_STAR] = ACTIONS(170),
    [anon_sym_SLASH] = ACTIONS(168),
    [anon_sym_SLASH_SLASH] = ACTIONS(170),
    [anon_sym_PERCENT] = ACTIONS(170),
    [anon_sym_DOT_DOT] = ACTIONS(168),
    [anon_sym_CARET] = ACTIONS(170),
    [anon_sym_not] = ACTIONS(168),
    [anon_sym_POUND] = ACTIONS(170),
    [sym_number] = ACTIONS(170),
    [sym_nil] = ACTIONS(168),
    [sym_true] = ACTIONS(168),
    [sym_false] = ACTIONS(168),
    [sym_identifier] = ACTIONS(168),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(170),
  },
  [16] = {
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(11),
    [sym_field_expression] = STATE(15),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(108),
    [sym__expression] = STATE(191),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [anon_sym_return] = ACTIONS(172),
    [anon_sym_local] = ACTIONS(174),
    [anon_sym_do] = ACTIONS(177),
    [anon_sym_end] = ACTIONS(172),
    [anon_sym_if] = ACTIONS(180),
    [anon_sym_elseif] = ACTIONS(172),
    [anon_sym_else] = ACTIONS(172),
    [anon_sym_while] = ACTIONS(183),
    [anon_sym_repeat] = ACTIONS(186),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_goto] = ACTIONS(192),
    [sym_break_statement] = ACTIONS(195),
    [anon_sym_COLON_COLON] = ACTIONS(198),
    [anon_sym_SEMI] = ACTIONS(201),
    [anon_sym_function] = ACTIONS(204),
    [anon_sym_LPAREN] = ACTIONS(207),
    [sym_spread] = ACTIONS(210),
    [sym_self] = ACTIONS(213),
    [sym_next] = ACTIONS(216),
    [anon_sym__G] = ACTIONS(219),
    [anon_sym__VERSION] = ACTIONS(219),
    [anon_sym_LBRACE] = ACTIONS(222),
    [anon_sym_TILDE] = ACTIONS(225),
    [anon_sym_DASH] = ACTIONS(225),
    [anon_sym_not] = ACTIONS(228),
    [anon_sym_POUND] = ACTIONS(225),
    [sym_number] = ACTIONS(210),
    [sym_nil] = ACTIONS(216),
    [sym_true] = ACTIONS(216),
    [sym_false] = ACTIONS(216),
    [sym_identifier] = ACTIONS(231),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(210),
  },
  [17] = {
    [anon_sym_return] = ACTIONS(234),
    [anon_sym_COMMA] = ACTIONS(236),
    [anon_sym_EQ] = ACTIONS(234),
    [anon_sym_local] = ACTIONS(234),
    [anon_sym_LBRACK] = ACTIONS(236),
    [anon_sym_DOT] = ACTIONS(234),
    [anon_sym_do] = ACTIONS(234),
    [anon_sym_end] = ACTIONS(234),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_elseif] = ACTIONS(234),
    [anon_sym_else] = ACTIONS(234),
    [anon_sym_while] = ACTIONS(234),
    [anon_sym_repeat] = ACTIONS(234),
    [anon_sym_for] = ACTIONS(234),
    [anon_sym_goto] = ACTIONS(234),
    [sym_break_statement] = ACTIONS(234),
    [anon_sym_COLON_COLON] = ACTIONS(236),
    [anon_sym_SEMI] = ACTIONS(236),
    [anon_sym_function] = ACTIONS(234),
    [anon_sym_COLON] = ACTIONS(234),
    [anon_sym_LPAREN] = ACTIONS(236),
    [sym_spread] = ACTIONS(236),
    [sym_self] = ACTIONS(234),
    [sym_next] = ACTIONS(234),
    [anon_sym__G] = ACTIONS(234),
    [anon_sym__VERSION] = ACTIONS(234),
    [anon_sym_LBRACE] = ACTIONS(236),
    [anon_sym_or] = ACTIONS(234),
    [anon_sym_and] = ACTIONS(234),
    [anon_sym_LT] = ACTIONS(234),
    [anon_sym_LT_EQ] = ACTIONS(236),
    [anon_sym_EQ_EQ] = ACTIONS(236),
    [anon_sym_TILDE_EQ] = ACTIONS(236),
    [anon_sym_GT_EQ] = ACTIONS(236),
    [anon_sym_GT] = ACTIONS(234),
    [anon_sym_PIPE] = ACTIONS(236),
    [anon_sym_TILDE] = ACTIONS(234),
    [anon_sym_AMP] = ACTIONS(236),
    [anon_sym_LT_LT] = ACTIONS(236),
    [anon_sym_GT_GT] = ACTIONS(236),
    [anon_sym_PLUS] = ACTIONS(236),
    [anon_sym_DASH] = ACTIONS(236),
    [anon_sym_STAR] = ACTIONS(236),
    [anon_sym_SLASH] = ACTIONS(234),
    [anon_sym_SLASH_SLASH] = ACTIONS(236),
    [anon_sym_PERCENT] = ACTIONS(236),
    [anon_sym_DOT_DOT] = ACTIONS(234),
    [anon_sym_CARET] = ACTIONS(236),
    [anon_sym_not] = ACTIONS(234),
    [anon_sym_POUND] = ACTIONS(236),
    [sym_number] = ACTIONS(236),
    [sym_nil] = ACTIONS(234),
    [sym_true] = ACTIONS(234),
    [sym_false] = ACTIONS(234),
    [sym_identifier] = ACTIONS(234),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(236),
  },
  [18] = {
    [anon_sym_return] = ACTIONS(238),
    [anon_sym_COMMA] = ACTIONS(170),
    [anon_sym_EQ] = ACTIONS(168),
    [anon_sym_local] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(170),
    [anon_sym_DOT] = ACTIONS(168),
    [anon_sym_do] = ACTIONS(238),
    [anon_sym_end] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_elseif] = ACTIONS(238),
    [anon_sym_else] = ACTIONS(238),
    [anon_sym_while] = ACTIONS(238),
    [anon_sym_repeat] = ACTIONS(238),
    [anon_sym_for] = ACTIONS(238),
    [anon_sym_goto] = ACTIONS(238),
    [sym_break_statement] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(241),
    [anon_sym_SEMI] = ACTIONS(241),
    [anon_sym_function] = ACTIONS(238),
    [anon_sym_COLON] = ACTIONS(168),
    [anon_sym_LPAREN] = ACTIONS(241),
    [sym_spread] = ACTIONS(241),
    [sym_self] = ACTIONS(238),
    [sym_next] = ACTIONS(238),
    [anon_sym__G] = ACTIONS(238),
    [anon_sym__VERSION] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(241),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(241),
    [anon_sym_EQ_EQ] = ACTIONS(241),
    [anon_sym_TILDE_EQ] = ACTIONS(241),
    [anon_sym_GT_EQ] = ACTIONS(241),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(241),
    [anon_sym_TILDE] = ACTIONS(238),
    [anon_sym_AMP] = ACTIONS(241),
    [anon_sym_LT_LT] = ACTIONS(241),
    [anon_sym_GT_GT] = ACTIONS(241),
    [anon_sym_PLUS] = ACTIONS(241),
    [anon_sym_DASH] = ACTIONS(241),
    [anon_sym_STAR] = ACTIONS(241),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_SLASH_SLASH] = ACTIONS(241),
    [anon_sym_PERCENT] = ACTIONS(241),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_CARET] = ACTIONS(241),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(241),
    [sym_number] = ACTIONS(241),
    [sym_nil] = ACTIONS(238),
    [sym_true] = ACTIONS(238),
    [sym_false] = ACTIONS(238),
    [sym_identifier] = ACTIONS(238),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(241),
  },
  [19] = {
    [sym_return_statement] = STATE(783),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [20] = {
    [sym_return_statement] = STATE(862),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(288),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [21] = {
    [anon_sym_return] = ACTIONS(290),
    [anon_sym_COMMA] = ACTIONS(292),
    [anon_sym_local] = ACTIONS(290),
    [anon_sym_LBRACK] = ACTIONS(292),
    [anon_sym_DOT] = ACTIONS(290),
    [anon_sym_do] = ACTIONS(290),
    [anon_sym_end] = ACTIONS(290),
    [anon_sym_if] = ACTIONS(290),
    [anon_sym_elseif] = ACTIONS(290),
    [anon_sym_else] = ACTIONS(290),
    [anon_sym_while] = ACTIONS(290),
    [anon_sym_repeat] = ACTIONS(290),
    [anon_sym_for] = ACTIONS(290),
    [anon_sym_goto] = ACTIONS(290),
    [sym_break_statement] = ACTIONS(290),
    [anon_sym_COLON_COLON] = ACTIONS(292),
    [anon_sym_SEMI] = ACTIONS(292),
    [anon_sym_function] = ACTIONS(290),
    [anon_sym_COLON] = ACTIONS(290),
    [anon_sym_LPAREN] = ACTIONS(292),
    [sym_spread] = ACTIONS(292),
    [sym_self] = ACTIONS(290),
    [sym_next] = ACTIONS(290),
    [anon_sym__G] = ACTIONS(290),
    [anon_sym__VERSION] = ACTIONS(290),
    [anon_sym_LBRACE] = ACTIONS(292),
    [anon_sym_or] = ACTIONS(290),
    [anon_sym_and] = ACTIONS(290),
    [anon_sym_LT] = ACTIONS(290),
    [anon_sym_LT_EQ] = ACTIONS(292),
    [anon_sym_EQ_EQ] = ACTIONS(292),
    [anon_sym_TILDE_EQ] = ACTIONS(292),
    [anon_sym_GT_EQ] = ACTIONS(292),
    [anon_sym_GT] = ACTIONS(290),
    [anon_sym_PIPE] = ACTIONS(292),
    [anon_sym_TILDE] = ACTIONS(290),
    [anon_sym_AMP] = ACTIONS(292),
    [anon_sym_LT_LT] = ACTIONS(292),
    [anon_sym_GT_GT] = ACTIONS(292),
    [anon_sym_PLUS] = ACTIONS(292),
    [anon_sym_DASH] = ACTIONS(292),
    [anon_sym_STAR] = ACTIONS(292),
    [anon_sym_SLASH] = ACTIONS(290),
    [anon_sym_SLASH_SLASH] = ACTIONS(292),
    [anon_sym_PERCENT] = ACTIONS(292),
    [anon_sym_DOT_DOT] = ACTIONS(290),
    [anon_sym_CARET] = ACTIONS(292),
    [anon_sym_not] = ACTIONS(290),
    [anon_sym_POUND] = ACTIONS(292),
    [sym_number] = ACTIONS(292),
    [sym_nil] = ACTIONS(290),
    [sym_true] = ACTIONS(290),
    [sym_false] = ACTIONS(290),
    [sym_identifier] = ACTIONS(290),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(292),
  },
  [22] = {
    [sym_return_statement] = STATE(899),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(294),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [23] = {
    [sym_return_statement] = STATE(849),
    [sym_variable_declaration] = STATE(33),
    [sym_local_variable_declaration] = STATE(33),
    [sym__variable_declarator] = STATE(26),
    [sym_field_expression] = STATE(107),
    [sym_do_statement] = STATE(33),
    [sym_if_statement] = STATE(33),
    [sym_while_statement] = STATE(33),
    [sym_repeat_statement] = STATE(33),
    [sym_for_statement] = STATE(33),
    [sym_for_in_statement] = STATE(33),
    [sym_goto_statement] = STATE(33),
    [sym_label_statement] = STATE(33),
    [sym__empty_statement] = STATE(33),
    [sym_function_statement] = STATE(33),
    [sym_local_function_statement] = STATE(33),
    [sym_function_call_statement] = STATE(160),
    [sym__expression] = STATE(254),
    [sym_global_variable] = STATE(30),
    [sym__prefix] = STATE(30),
    [sym_function_definition] = STATE(248),
    [sym_table] = STATE(248),
    [sym_binary_operation] = STATE(248),
    [sym_unary_operation] = STATE(248),
    [aux_sym_program_repeat1] = STATE(33),
    [ts_builtin_sym_end] = ACTIONS(296),
    [anon_sym_return] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(11),
    [anon_sym_do] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_goto] = ACTIONS(23),
    [sym_break_statement] = ACTIONS(298),
    [anon_sym_COLON_COLON] = ACTIONS(27),
    [anon_sym_SEMI] = ACTIONS(300),
    [anon_sym_function] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [sym_spread] = ACTIONS(35),
    [sym_self] = ACTIONS(37),
    [sym_next] = ACTIONS(39),
    [anon_sym__G] = ACTIONS(41),
    [anon_sym__VERSION] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(45),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_POUND] = ACTIONS(45),
    [sym_number] = ACTIONS(35),
    [sym_nil] = ACTIONS(39),
    [sym_true] = ACTIONS(39),
    [sym_false] = ACTIONS(39),
    [sym_identifier] = ACTIONS(49),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(35),
  },
  [24] = {
    [sym_return_statement] = STATE(855),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(302),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [25] = {
    [aux_sym_variable_declaration_repeat1] = STATE(773),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_COMMA] = ACTIONS(137),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_local] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_do] = ACTIONS(135),
    [anon_sym_end] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(135),
    [anon_sym_for] = ACTIONS(135),
    [anon_sym_goto] = ACTIONS(135),
    [sym_break_statement] = ACTIONS(135),
    [anon_sym_COLON_COLON] = ACTIONS(141),
    [anon_sym_SEMI] = ACTIONS(141),
    [anon_sym_function] = ACTIONS(135),
    [anon_sym_COLON] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(141),
    [sym_spread] = ACTIONS(141),
    [sym_self] = ACTIONS(135),
    [sym_next] = ACTIONS(135),
    [anon_sym__G] = ACTIONS(135),
    [anon_sym__VERSION] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(141),
    [anon_sym_or] = ACTIONS(135),
    [anon_sym_and] = ACTIONS(135),
    [anon_sym_LT] = ACTIONS(135),
    [anon_sym_LT_EQ] = ACTIONS(141),
    [anon_sym_EQ_EQ] = ACTIONS(141),
    [anon_sym_TILDE_EQ] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(141),
    [anon_sym_GT] = ACTIONS(135),
    [anon_sym_PIPE] = ACTIONS(141),
    [anon_sym_TILDE] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(141),
    [anon_sym_LT_LT] = ACTIONS(141),
    [anon_sym_GT_GT] = ACTIONS(141),
    [anon_sym_PLUS] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(141),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_SLASH] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(141),
    [anon_sym_PERCENT] = ACTIONS(141),
    [anon_sym_DOT_DOT] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(141),
    [anon_sym_not] = ACTIONS(135),
    [anon_sym_POUND] = ACTIONS(141),
    [sym_number] = ACTIONS(141),
    [sym_nil] = ACTIONS(135),
    [sym_true] = ACTIONS(135),
    [sym_false] = ACTIONS(135),
    [sym_identifier] = ACTIONS(135),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(141),
  },
  [26] = {
    [aux_sym_variable_declaration_repeat1] = STATE(736),
    [ts_builtin_sym_end] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_COMMA] = ACTIONS(137),
    [anon_sym_EQ] = ACTIONS(306),
    [anon_sym_local] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_do] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(135),
    [anon_sym_for] = ACTIONS(135),
    [anon_sym_goto] = ACTIONS(135),
    [sym_break_statement] = ACTIONS(135),
    [anon_sym_COLON_COLON] = ACTIONS(141),
    [anon_sym_SEMI] = ACTIONS(141),
    [anon_sym_function] = ACTIONS(135),
    [anon_sym_COLON] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(141),
    [sym_spread] = ACTIONS(141),
    [sym_self] = ACTIONS(135),
    [sym_next] = ACTIONS(135),
    [anon_sym__G] = ACTIONS(135),
    [anon_sym__VERSION] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(141),
    [anon_sym_or] = ACTIONS(135),
    [anon_sym_and] = ACTIONS(135),
    [anon_sym_LT] = ACTIONS(135),
    [anon_sym_LT_EQ] = ACTIONS(141),
    [anon_sym_EQ_EQ] = ACTIONS(141),
    [anon_sym_TILDE_EQ] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(141),
    [anon_sym_GT] = ACTIONS(135),
    [anon_sym_PIPE] = ACTIONS(141),
    [anon_sym_TILDE] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(141),
    [anon_sym_LT_LT] = ACTIONS(141),
    [anon_sym_GT_GT] = ACTIONS(141),
    [anon_sym_PLUS] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(141),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_SLASH] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(141),
    [anon_sym_PERCENT] = ACTIONS(141),
    [anon_sym_DOT_DOT] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(141),
    [anon_sym_not] = ACTIONS(135),
    [anon_sym_POUND] = ACTIONS(141),
    [sym_number] = ACTIONS(141),
    [sym_nil] = ACTIONS(135),
    [sym_true] = ACTIONS(135),
    [sym_false] = ACTIONS(135),
    [sym_identifier] = ACTIONS(135),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(141),
  },
  [27] = {
    [sym_return_statement] = STATE(879),
    [sym_variable_declaration] = STATE(82),
    [sym_local_variable_declaration] = STATE(82),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(82),
    [sym_if_statement] = STATE(82),
    [sym_while_statement] = STATE(82),
    [sym_repeat_statement] = STATE(82),
    [sym_for_statement] = STATE(82),
    [sym_for_in_statement] = STATE(82),
    [sym_goto_statement] = STATE(82),
    [sym_label_statement] = STATE(82),
    [sym__empty_statement] = STATE(82),
    [sym_function_statement] = STATE(82),
    [sym_local_function_statement] = STATE(82),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(82),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(308),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(310),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(312),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [28] = {
    [sym_return_statement] = STATE(878),
    [sym_variable_declaration] = STATE(96),
    [sym_local_variable_declaration] = STATE(96),
    [sym__variable_declarator] = STATE(47),
    [sym_field_expression] = STATE(109),
    [sym_do_statement] = STATE(96),
    [sym_if_statement] = STATE(96),
    [sym_while_statement] = STATE(96),
    [sym_repeat_statement] = STATE(96),
    [sym_for_statement] = STATE(96),
    [sym_for_in_statement] = STATE(96),
    [sym_goto_statement] = STATE(96),
    [sym_label_statement] = STATE(96),
    [sym__empty_statement] = STATE(96),
    [sym_function_statement] = STATE(96),
    [sym_local_function_statement] = STATE(96),
    [sym_function_call_statement] = STATE(155),
    [sym__expression] = STATE(255),
    [sym_global_variable] = STATE(46),
    [sym__prefix] = STATE(46),
    [sym_function_definition] = STATE(250),
    [sym_table] = STATE(250),
    [sym_binary_operation] = STATE(250),
    [sym_unary_operation] = STATE(250),
    [aux_sym_program_repeat1] = STATE(96),
    [anon_sym_return] = ACTIONS(314),
    [anon_sym_local] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(318),
    [anon_sym_if] = ACTIONS(320),
    [anon_sym_while] = ACTIONS(322),
    [anon_sym_repeat] = ACTIONS(324),
    [anon_sym_until] = ACTIONS(326),
    [anon_sym_for] = ACTIONS(328),
    [anon_sym_goto] = ACTIONS(330),
    [sym_break_statement] = ACTIONS(332),
    [anon_sym_COLON_COLON] = ACTIONS(334),
    [anon_sym_SEMI] = ACTIONS(336),
    [anon_sym_function] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [sym_spread] = ACTIONS(342),
    [sym_self] = ACTIONS(344),
    [sym_next] = ACTIONS(346),
    [anon_sym__G] = ACTIONS(348),
    [anon_sym__VERSION] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(352),
    [anon_sym_DASH] = ACTIONS(352),
    [anon_sym_not] = ACTIONS(354),
    [anon_sym_POUND] = ACTIONS(352),
    [sym_number] = ACTIONS(342),
    [sym_nil] = ACTIONS(346),
    [sym_true] = ACTIONS(346),
    [sym_false] = ACTIONS(346),
    [sym_identifier] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(342),
  },
  [29] = {
    [anon_sym_return] = ACTIONS(358),
    [anon_sym_COMMA] = ACTIONS(360),
    [anon_sym_local] = ACTIONS(358),
    [anon_sym_LBRACK] = ACTIONS(360),
    [anon_sym_DOT] = ACTIONS(358),
    [anon_sym_do] = ACTIONS(358),
    [anon_sym_end] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(358),
    [anon_sym_elseif] = ACTIONS(358),
    [anon_sym_else] = ACTIONS(358),
    [anon_sym_while] = ACTIONS(358),
    [anon_sym_repeat] = ACTIONS(358),
    [anon_sym_for] = ACTIONS(358),
    [anon_sym_goto] = ACTIONS(358),
    [sym_break_statement] = ACTIONS(358),
    [anon_sym_COLON_COLON] = ACTIONS(360),
    [anon_sym_SEMI] = ACTIONS(360),
    [anon_sym_function] = ACTIONS(358),
    [anon_sym_COLON] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(360),
    [sym_spread] = ACTIONS(360),
    [sym_self] = ACTIONS(358),
    [sym_next] = ACTIONS(358),
    [anon_sym__G] = ACTIONS(358),
    [anon_sym__VERSION] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(360),
    [anon_sym_or] = ACTIONS(358),
    [anon_sym_and] = ACTIONS(358),
    [anon_sym_LT] = ACTIONS(358),
    [anon_sym_LT_EQ] = ACTIONS(360),
    [anon_sym_EQ_EQ] = ACTIONS(360),
    [anon_sym_TILDE_EQ] = ACTIONS(360),
    [anon_sym_GT_EQ] = ACTIONS(360),
    [anon_sym_GT] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(360),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_AMP] = ACTIONS(360),
    [anon_sym_LT_LT] = ACTIONS(360),
    [anon_sym_GT_GT] = ACTIONS(360),
    [anon_sym_PLUS] = ACTIONS(360),
    [anon_sym_DASH] = ACTIONS(360),
    [anon_sym_STAR] = ACTIONS(360),
    [anon_sym_SLASH] = ACTIONS(358),
    [anon_sym_SLASH_SLASH] = ACTIONS(360),
    [anon_sym_PERCENT] = ACTIONS(360),
    [anon_sym_DOT_DOT] = ACTIONS(358),
    [anon_sym_CARET] = ACTIONS(360),
    [anon_sym_not] = ACTIONS(358),
    [anon_sym_POUND] = ACTIONS(360),
    [sym_number] = ACTIONS(360),
    [sym_nil] = ACTIONS(358),
    [sym_true] = ACTIONS(358),
    [sym_false] = ACTIONS(358),
    [sym_identifier] = ACTIONS(358),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(360),
  },
  [30] = {
    [sym_arguments] = STATE(124),
    [sym_table] = STATE(132),
    [ts_builtin_sym_end] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(145),
    [anon_sym_local] = ACTIONS(143),
    [anon_sym_LBRACK] = ACTIONS(362),
    [anon_sym_DOT] = ACTIONS(364),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_repeat] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_goto] = ACTIONS(143),
    [sym_break_statement] = ACTIONS(143),
    [anon_sym_COLON_COLON] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_COLON] = ACTIONS(366),
    [anon_sym_LPAREN] = ACTIONS(368),
    [sym_spread] = ACTIONS(145),
    [sym_self] = ACTIONS(143),
    [sym_next] = ACTIONS(143),
    [anon_sym__G] = ACTIONS(143),
    [anon_sym__VERSION] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_or] = ACTIONS(143),
    [anon_sym_and] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(143),
    [anon_sym_LT_EQ] = ACTIONS(145),
    [anon_sym_EQ_EQ] = ACTIONS(145),
    [anon_sym_TILDE_EQ] = ACTIONS(145),
    [anon_sym_GT_EQ] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(143),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(143),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LT_LT] = ACTIONS(145),
    [anon_sym_GT_GT] = ACTIONS(145),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_STAR] = ACTIONS(145),
    [anon_sym_SLASH] = ACTIONS(143),
    [anon_sym_SLASH_SLASH] = ACTIONS(145),
    [anon_sym_PERCENT] = ACTIONS(145),
    [anon_sym_DOT_DOT] = ACTIONS(143),
    [anon_sym_CARET] = ACTIONS(145),
    [anon_sym_not] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [sym_number] = ACTIONS(145),
    [sym_nil] = ACTIONS(143),
    [sym_true] = ACTIONS(143),
    [sym_false] = ACTIONS(143),
    [sym_identifier] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(374),
  },
  [31] = {
    [sym_return_statement] = STATE(849),
    [sym_variable_declaration] = STATE(100),
    [sym_local_variable_declaration] = STATE(100),
    [sym__variable_declarator] = STATE(26),
    [sym_field_expression] = STATE(107),
    [sym_do_statement] = STATE(100),
    [sym_if_statement] = STATE(100),
    [sym_while_statement] = STATE(100),
    [sym_repeat_statement] = STATE(100),
    [sym_for_statement] = STATE(100),
    [sym_for_in_statement] = STATE(100),
    [sym_goto_statement] = STATE(100),
    [sym_label_statement] = STATE(100),
    [sym__empty_statement] = STATE(100),
    [sym_function_statement] = STATE(100),
    [sym_local_function_statement] = STATE(100),
    [sym_function_call_statement] = STATE(160),
    [sym__expression] = STATE(254),
    [sym_global_variable] = STATE(30),
    [sym__prefix] = STATE(30),
    [sym_function_definition] = STATE(248),
    [sym_table] = STATE(248),
    [sym_binary_operation] = STATE(248),
    [sym_unary_operation] = STATE(248),
    [aux_sym_program_repeat1] = STATE(100),
    [ts_builtin_sym_end] = ACTIONS(296),
    [anon_sym_return] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(11),
    [anon_sym_do] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_goto] = ACTIONS(23),
    [sym_break_statement] = ACTIONS(377),
    [anon_sym_COLON_COLON] = ACTIONS(27),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [sym_spread] = ACTIONS(35),
    [sym_self] = ACTIONS(37),
    [sym_next] = ACTIONS(39),
    [anon_sym__G] = ACTIONS(41),
    [anon_sym__VERSION] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(45),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_POUND] = ACTIONS(45),
    [sym_number] = ACTIONS(35),
    [sym_nil] = ACTIONS(39),
    [sym_true] = ACTIONS(39),
    [sym_false] = ACTIONS(39),
    [sym_identifier] = ACTIONS(49),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(35),
  },
  [32] = {
    [sym_return_statement] = STATE(851),
    [sym_variable_declaration] = STATE(24),
    [sym_local_variable_declaration] = STATE(24),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_repeat_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_goto_statement] = STATE(24),
    [sym_label_statement] = STATE(24),
    [sym__empty_statement] = STATE(24),
    [sym_function_statement] = STATE(24),
    [sym_local_function_statement] = STATE(24),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(24),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(383),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [33] = {
    [sym_return_statement] = STATE(842),
    [sym_variable_declaration] = STATE(100),
    [sym_local_variable_declaration] = STATE(100),
    [sym__variable_declarator] = STATE(26),
    [sym_field_expression] = STATE(107),
    [sym_do_statement] = STATE(100),
    [sym_if_statement] = STATE(100),
    [sym_while_statement] = STATE(100),
    [sym_repeat_statement] = STATE(100),
    [sym_for_statement] = STATE(100),
    [sym_for_in_statement] = STATE(100),
    [sym_goto_statement] = STATE(100),
    [sym_label_statement] = STATE(100),
    [sym__empty_statement] = STATE(100),
    [sym_function_statement] = STATE(100),
    [sym_local_function_statement] = STATE(100),
    [sym_function_call_statement] = STATE(160),
    [sym__expression] = STATE(254),
    [sym_global_variable] = STATE(30),
    [sym__prefix] = STATE(30),
    [sym_function_definition] = STATE(248),
    [sym_table] = STATE(248),
    [sym_binary_operation] = STATE(248),
    [sym_unary_operation] = STATE(248),
    [aux_sym_program_repeat1] = STATE(100),
    [ts_builtin_sym_end] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(11),
    [anon_sym_do] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_goto] = ACTIONS(23),
    [sym_break_statement] = ACTIONS(377),
    [anon_sym_COLON_COLON] = ACTIONS(27),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [sym_spread] = ACTIONS(35),
    [sym_self] = ACTIONS(37),
    [sym_next] = ACTIONS(39),
    [anon_sym__G] = ACTIONS(41),
    [anon_sym__VERSION] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(45),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_POUND] = ACTIONS(45),
    [sym_number] = ACTIONS(35),
    [sym_nil] = ACTIONS(39),
    [sym_true] = ACTIONS(39),
    [sym_false] = ACTIONS(39),
    [sym_identifier] = ACTIONS(49),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(35),
  },
  [34] = {
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_COMMA] = ACTIONS(391),
    [anon_sym_local] = ACTIONS(389),
    [anon_sym_LBRACK] = ACTIONS(391),
    [anon_sym_DOT] = ACTIONS(389),
    [anon_sym_do] = ACTIONS(389),
    [anon_sym_end] = ACTIONS(389),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_elseif] = ACTIONS(389),
    [anon_sym_else] = ACTIONS(389),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(389),
    [anon_sym_for] = ACTIONS(389),
    [anon_sym_goto] = ACTIONS(389),
    [sym_break_statement] = ACTIONS(389),
    [anon_sym_COLON_COLON] = ACTIONS(391),
    [anon_sym_SEMI] = ACTIONS(391),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_COLON] = ACTIONS(389),
    [anon_sym_LPAREN] = ACTIONS(391),
    [sym_spread] = ACTIONS(391),
    [sym_self] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [anon_sym__G] = ACTIONS(389),
    [anon_sym__VERSION] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_or] = ACTIONS(389),
    [anon_sym_and] = ACTIONS(389),
    [anon_sym_LT] = ACTIONS(389),
    [anon_sym_LT_EQ] = ACTIONS(391),
    [anon_sym_EQ_EQ] = ACTIONS(391),
    [anon_sym_TILDE_EQ] = ACTIONS(391),
    [anon_sym_GT_EQ] = ACTIONS(391),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_PIPE] = ACTIONS(391),
    [anon_sym_TILDE] = ACTIONS(389),
    [anon_sym_AMP] = ACTIONS(391),
    [anon_sym_LT_LT] = ACTIONS(391),
    [anon_sym_GT_GT] = ACTIONS(391),
    [anon_sym_PLUS] = ACTIONS(391),
    [anon_sym_DASH] = ACTIONS(391),
    [anon_sym_STAR] = ACTIONS(391),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_SLASH_SLASH] = ACTIONS(391),
    [anon_sym_PERCENT] = ACTIONS(391),
    [anon_sym_DOT_DOT] = ACTIONS(389),
    [anon_sym_CARET] = ACTIONS(391),
    [anon_sym_not] = ACTIONS(389),
    [anon_sym_POUND] = ACTIONS(391),
    [sym_number] = ACTIONS(391),
    [sym_nil] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_identifier] = ACTIONS(389),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(391),
  },
  [35] = {
    [sym_return_statement] = STATE(838),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(393),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [36] = {
    [sym_return_statement] = STATE(837),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [37] = {
    [anon_sym_return] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(399),
    [anon_sym_local] = ACTIONS(397),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_DOT] = ACTIONS(397),
    [anon_sym_do] = ACTIONS(397),
    [anon_sym_end] = ACTIONS(397),
    [anon_sym_if] = ACTIONS(397),
    [anon_sym_elseif] = ACTIONS(397),
    [anon_sym_else] = ACTIONS(397),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(397),
    [anon_sym_goto] = ACTIONS(397),
    [sym_break_statement] = ACTIONS(397),
    [anon_sym_COLON_COLON] = ACTIONS(399),
    [anon_sym_SEMI] = ACTIONS(399),
    [anon_sym_function] = ACTIONS(397),
    [anon_sym_COLON] = ACTIONS(397),
    [anon_sym_LPAREN] = ACTIONS(399),
    [sym_spread] = ACTIONS(399),
    [sym_self] = ACTIONS(397),
    [sym_next] = ACTIONS(397),
    [anon_sym__G] = ACTIONS(397),
    [anon_sym__VERSION] = ACTIONS(397),
    [anon_sym_LBRACE] = ACTIONS(399),
    [anon_sym_or] = ACTIONS(397),
    [anon_sym_and] = ACTIONS(397),
    [anon_sym_LT] = ACTIONS(397),
    [anon_sym_LT_EQ] = ACTIONS(399),
    [anon_sym_EQ_EQ] = ACTIONS(399),
    [anon_sym_TILDE_EQ] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(399),
    [anon_sym_GT] = ACTIONS(397),
    [anon_sym_PIPE] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(397),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_LT_LT] = ACTIONS(399),
    [anon_sym_GT_GT] = ACTIONS(399),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_STAR] = ACTIONS(399),
    [anon_sym_SLASH] = ACTIONS(397),
    [anon_sym_SLASH_SLASH] = ACTIONS(399),
    [anon_sym_PERCENT] = ACTIONS(399),
    [anon_sym_DOT_DOT] = ACTIONS(397),
    [anon_sym_CARET] = ACTIONS(399),
    [anon_sym_not] = ACTIONS(397),
    [anon_sym_POUND] = ACTIONS(399),
    [sym_number] = ACTIONS(399),
    [sym_nil] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_identifier] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(399),
  },
  [38] = {
    [anon_sym_return] = ACTIONS(238),
    [anon_sym_COMMA] = ACTIONS(241),
    [anon_sym_local] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(170),
    [anon_sym_DOT] = ACTIONS(168),
    [anon_sym_do] = ACTIONS(238),
    [anon_sym_end] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_elseif] = ACTIONS(238),
    [anon_sym_else] = ACTIONS(238),
    [anon_sym_while] = ACTIONS(238),
    [anon_sym_repeat] = ACTIONS(238),
    [anon_sym_for] = ACTIONS(238),
    [anon_sym_goto] = ACTIONS(238),
    [sym_break_statement] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(241),
    [anon_sym_SEMI] = ACTIONS(241),
    [anon_sym_function] = ACTIONS(238),
    [anon_sym_COLON] = ACTIONS(168),
    [anon_sym_LPAREN] = ACTIONS(241),
    [sym_spread] = ACTIONS(241),
    [sym_self] = ACTIONS(238),
    [sym_next] = ACTIONS(238),
    [anon_sym__G] = ACTIONS(238),
    [anon_sym__VERSION] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(241),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(241),
    [anon_sym_EQ_EQ] = ACTIONS(241),
    [anon_sym_TILDE_EQ] = ACTIONS(241),
    [anon_sym_GT_EQ] = ACTIONS(241),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(241),
    [anon_sym_TILDE] = ACTIONS(238),
    [anon_sym_AMP] = ACTIONS(241),
    [anon_sym_LT_LT] = ACTIONS(241),
    [anon_sym_GT_GT] = ACTIONS(241),
    [anon_sym_PLUS] = ACTIONS(241),
    [anon_sym_DASH] = ACTIONS(241),
    [anon_sym_STAR] = ACTIONS(241),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_SLASH_SLASH] = ACTIONS(241),
    [anon_sym_PERCENT] = ACTIONS(241),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_CARET] = ACTIONS(241),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(241),
    [sym_number] = ACTIONS(241),
    [sym_nil] = ACTIONS(238),
    [sym_true] = ACTIONS(238),
    [sym_false] = ACTIONS(238),
    [sym_identifier] = ACTIONS(238),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(241),
  },
  [39] = {
    [sym_return_statement] = STATE(836),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(401),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [40] = {
    [sym_return_statement] = STATE(856),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(403),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [41] = {
    [sym_return_statement] = STATE(831),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(405),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [42] = {
    [sym_return_statement] = STATE(829),
    [sym_variable_declaration] = STATE(35),
    [sym_local_variable_declaration] = STATE(35),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(35),
    [sym_if_statement] = STATE(35),
    [sym_while_statement] = STATE(35),
    [sym_repeat_statement] = STATE(35),
    [sym_for_statement] = STATE(35),
    [sym_for_in_statement] = STATE(35),
    [sym_goto_statement] = STATE(35),
    [sym_label_statement] = STATE(35),
    [sym__empty_statement] = STATE(35),
    [sym_function_statement] = STATE(35),
    [sym_local_function_statement] = STATE(35),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(35),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(407),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(409),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(411),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [43] = {
    [sym_return_statement] = STATE(827),
    [sym_variable_declaration] = STATE(36),
    [sym_local_variable_declaration] = STATE(36),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(36),
    [sym_if_statement] = STATE(36),
    [sym_while_statement] = STATE(36),
    [sym_repeat_statement] = STATE(36),
    [sym_for_statement] = STATE(36),
    [sym_for_in_statement] = STATE(36),
    [sym_goto_statement] = STATE(36),
    [sym_label_statement] = STATE(36),
    [sym__empty_statement] = STATE(36),
    [sym_function_statement] = STATE(36),
    [sym_local_function_statement] = STATE(36),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(36),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(413),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(415),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(417),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [44] = {
    [sym_return_statement] = STATE(863),
    [sym_variable_declaration] = STATE(99),
    [sym_local_variable_declaration] = STATE(99),
    [sym__variable_declarator] = STATE(47),
    [sym_field_expression] = STATE(109),
    [sym_do_statement] = STATE(99),
    [sym_if_statement] = STATE(99),
    [sym_while_statement] = STATE(99),
    [sym_repeat_statement] = STATE(99),
    [sym_for_statement] = STATE(99),
    [sym_for_in_statement] = STATE(99),
    [sym_goto_statement] = STATE(99),
    [sym_label_statement] = STATE(99),
    [sym__empty_statement] = STATE(99),
    [sym_function_statement] = STATE(99),
    [sym_local_function_statement] = STATE(99),
    [sym_function_call_statement] = STATE(155),
    [sym__expression] = STATE(255),
    [sym_global_variable] = STATE(46),
    [sym__prefix] = STATE(46),
    [sym_function_definition] = STATE(250),
    [sym_table] = STATE(250),
    [sym_binary_operation] = STATE(250),
    [sym_unary_operation] = STATE(250),
    [aux_sym_program_repeat1] = STATE(99),
    [anon_sym_return] = ACTIONS(314),
    [anon_sym_local] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(318),
    [anon_sym_if] = ACTIONS(320),
    [anon_sym_while] = ACTIONS(322),
    [anon_sym_repeat] = ACTIONS(324),
    [anon_sym_until] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(328),
    [anon_sym_goto] = ACTIONS(330),
    [sym_break_statement] = ACTIONS(421),
    [anon_sym_COLON_COLON] = ACTIONS(334),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_function] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [sym_spread] = ACTIONS(342),
    [sym_self] = ACTIONS(344),
    [sym_next] = ACTIONS(346),
    [anon_sym__G] = ACTIONS(348),
    [anon_sym__VERSION] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(352),
    [anon_sym_DASH] = ACTIONS(352),
    [anon_sym_not] = ACTIONS(354),
    [anon_sym_POUND] = ACTIONS(352),
    [sym_number] = ACTIONS(342),
    [sym_nil] = ACTIONS(346),
    [sym_true] = ACTIONS(346),
    [sym_false] = ACTIONS(346),
    [sym_identifier] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(342),
  },
  [45] = {
    [sym_return_statement] = STATE(825),
    [sym_variable_declaration] = STATE(39),
    [sym_local_variable_declaration] = STATE(39),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_repeat_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_for_in_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_label_statement] = STATE(39),
    [sym__empty_statement] = STATE(39),
    [sym_function_statement] = STATE(39),
    [sym_local_function_statement] = STATE(39),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(39),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(425),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(427),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [46] = {
    [sym_arguments] = STATE(133),
    [sym_table] = STATE(123),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(145),
    [anon_sym_local] = ACTIONS(143),
    [anon_sym_LBRACK] = ACTIONS(431),
    [anon_sym_DOT] = ACTIONS(433),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_repeat] = ACTIONS(143),
    [anon_sym_until] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_goto] = ACTIONS(143),
    [sym_break_statement] = ACTIONS(143),
    [anon_sym_COLON_COLON] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_COLON] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(437),
    [sym_spread] = ACTIONS(145),
    [sym_self] = ACTIONS(143),
    [sym_next] = ACTIONS(143),
    [anon_sym__G] = ACTIONS(143),
    [anon_sym__VERSION] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(440),
    [anon_sym_or] = ACTIONS(143),
    [anon_sym_and] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(143),
    [anon_sym_LT_EQ] = ACTIONS(145),
    [anon_sym_EQ_EQ] = ACTIONS(145),
    [anon_sym_TILDE_EQ] = ACTIONS(145),
    [anon_sym_GT_EQ] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(143),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(143),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LT_LT] = ACTIONS(145),
    [anon_sym_GT_GT] = ACTIONS(145),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_STAR] = ACTIONS(145),
    [anon_sym_SLASH] = ACTIONS(143),
    [anon_sym_SLASH_SLASH] = ACTIONS(145),
    [anon_sym_PERCENT] = ACTIONS(145),
    [anon_sym_DOT_DOT] = ACTIONS(143),
    [anon_sym_CARET] = ACTIONS(145),
    [anon_sym_not] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [sym_number] = ACTIONS(145),
    [sym_nil] = ACTIONS(143),
    [sym_true] = ACTIONS(143),
    [sym_false] = ACTIONS(143),
    [sym_identifier] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(443),
  },
  [47] = {
    [aux_sym_variable_declaration_repeat1] = STATE(744),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_COMMA] = ACTIONS(137),
    [anon_sym_EQ] = ACTIONS(446),
    [anon_sym_local] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DOT] = ACTIONS(135),
    [anon_sym_do] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(135),
    [anon_sym_until] = ACTIONS(135),
    [anon_sym_for] = ACTIONS(135),
    [anon_sym_goto] = ACTIONS(135),
    [sym_break_statement] = ACTIONS(135),
    [anon_sym_COLON_COLON] = ACTIONS(141),
    [anon_sym_SEMI] = ACTIONS(141),
    [anon_sym_function] = ACTIONS(135),
    [anon_sym_COLON] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(141),
    [sym_spread] = ACTIONS(141),
    [sym_self] = ACTIONS(135),
    [sym_next] = ACTIONS(135),
    [anon_sym__G] = ACTIONS(135),
    [anon_sym__VERSION] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(141),
    [anon_sym_or] = ACTIONS(135),
    [anon_sym_and] = ACTIONS(135),
    [anon_sym_LT] = ACTIONS(135),
    [anon_sym_LT_EQ] = ACTIONS(141),
    [anon_sym_EQ_EQ] = ACTIONS(141),
    [anon_sym_TILDE_EQ] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(141),
    [anon_sym_GT] = ACTIONS(135),
    [anon_sym_PIPE] = ACTIONS(141),
    [anon_sym_TILDE] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(141),
    [anon_sym_LT_LT] = ACTIONS(141),
    [anon_sym_GT_GT] = ACTIONS(141),
    [anon_sym_PLUS] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(141),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_SLASH] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(141),
    [anon_sym_PERCENT] = ACTIONS(141),
    [anon_sym_DOT_DOT] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(141),
    [anon_sym_not] = ACTIONS(135),
    [anon_sym_POUND] = ACTIONS(141),
    [sym_number] = ACTIONS(141),
    [sym_nil] = ACTIONS(135),
    [sym_true] = ACTIONS(135),
    [sym_false] = ACTIONS(135),
    [sym_identifier] = ACTIONS(135),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(141),
  },
  [48] = {
    [sym_return_statement] = STATE(817),
    [sym_variable_declaration] = STATE(41),
    [sym_local_variable_declaration] = STATE(41),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(41),
    [sym_if_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_repeat_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_for_in_statement] = STATE(41),
    [sym_goto_statement] = STATE(41),
    [sym_label_statement] = STATE(41),
    [sym__empty_statement] = STATE(41),
    [sym_function_statement] = STATE(41),
    [sym_local_function_statement] = STATE(41),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(41),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(448),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(450),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(452),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [49] = {
    [sym_return_statement] = STATE(814),
    [sym_variable_declaration] = STATE(99),
    [sym_local_variable_declaration] = STATE(99),
    [sym__variable_declarator] = STATE(47),
    [sym_field_expression] = STATE(109),
    [sym_do_statement] = STATE(99),
    [sym_if_statement] = STATE(99),
    [sym_while_statement] = STATE(99),
    [sym_repeat_statement] = STATE(99),
    [sym_for_statement] = STATE(99),
    [sym_for_in_statement] = STATE(99),
    [sym_goto_statement] = STATE(99),
    [sym_label_statement] = STATE(99),
    [sym__empty_statement] = STATE(99),
    [sym_function_statement] = STATE(99),
    [sym_local_function_statement] = STATE(99),
    [sym_function_call_statement] = STATE(155),
    [sym__expression] = STATE(255),
    [sym_global_variable] = STATE(46),
    [sym__prefix] = STATE(46),
    [sym_function_definition] = STATE(250),
    [sym_table] = STATE(250),
    [sym_binary_operation] = STATE(250),
    [sym_unary_operation] = STATE(250),
    [aux_sym_program_repeat1] = STATE(99),
    [anon_sym_return] = ACTIONS(314),
    [anon_sym_local] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(318),
    [anon_sym_if] = ACTIONS(320),
    [anon_sym_while] = ACTIONS(322),
    [anon_sym_repeat] = ACTIONS(324),
    [anon_sym_until] = ACTIONS(454),
    [anon_sym_for] = ACTIONS(328),
    [anon_sym_goto] = ACTIONS(330),
    [sym_break_statement] = ACTIONS(421),
    [anon_sym_COLON_COLON] = ACTIONS(334),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_function] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [sym_spread] = ACTIONS(342),
    [sym_self] = ACTIONS(344),
    [sym_next] = ACTIONS(346),
    [anon_sym__G] = ACTIONS(348),
    [anon_sym__VERSION] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(352),
    [anon_sym_DASH] = ACTIONS(352),
    [anon_sym_not] = ACTIONS(354),
    [anon_sym_POUND] = ACTIONS(352),
    [sym_number] = ACTIONS(342),
    [sym_nil] = ACTIONS(346),
    [sym_true] = ACTIONS(346),
    [sym_false] = ACTIONS(346),
    [sym_identifier] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(342),
  },
  [50] = {
    [sym_return_statement] = STATE(811),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(456),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [51] = {
    [sym_return_statement] = STATE(901),
    [sym_variable_declaration] = STATE(71),
    [sym_local_variable_declaration] = STATE(71),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(71),
    [sym_if_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_repeat_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_for_in_statement] = STATE(71),
    [sym_goto_statement] = STATE(71),
    [sym_label_statement] = STATE(71),
    [sym__empty_statement] = STATE(71),
    [sym_function_statement] = STATE(71),
    [sym_local_function_statement] = STATE(71),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(71),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(458),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(460),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(462),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [52] = {
    [sym_return_statement] = STATE(797),
    [sym_variable_declaration] = STATE(49),
    [sym_local_variable_declaration] = STATE(49),
    [sym__variable_declarator] = STATE(47),
    [sym_field_expression] = STATE(109),
    [sym_do_statement] = STATE(49),
    [sym_if_statement] = STATE(49),
    [sym_while_statement] = STATE(49),
    [sym_repeat_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_for_in_statement] = STATE(49),
    [sym_goto_statement] = STATE(49),
    [sym_label_statement] = STATE(49),
    [sym__empty_statement] = STATE(49),
    [sym_function_statement] = STATE(49),
    [sym_local_function_statement] = STATE(49),
    [sym_function_call_statement] = STATE(155),
    [sym__expression] = STATE(255),
    [sym_global_variable] = STATE(46),
    [sym__prefix] = STATE(46),
    [sym_function_definition] = STATE(250),
    [sym_table] = STATE(250),
    [sym_binary_operation] = STATE(250),
    [sym_unary_operation] = STATE(250),
    [aux_sym_program_repeat1] = STATE(49),
    [anon_sym_return] = ACTIONS(314),
    [anon_sym_local] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(318),
    [anon_sym_if] = ACTIONS(320),
    [anon_sym_while] = ACTIONS(322),
    [anon_sym_repeat] = ACTIONS(324),
    [anon_sym_until] = ACTIONS(464),
    [anon_sym_for] = ACTIONS(328),
    [anon_sym_goto] = ACTIONS(330),
    [sym_break_statement] = ACTIONS(466),
    [anon_sym_COLON_COLON] = ACTIONS(334),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [sym_spread] = ACTIONS(342),
    [sym_self] = ACTIONS(344),
    [sym_next] = ACTIONS(346),
    [anon_sym__G] = ACTIONS(348),
    [anon_sym__VERSION] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(352),
    [anon_sym_DASH] = ACTIONS(352),
    [anon_sym_not] = ACTIONS(354),
    [anon_sym_POUND] = ACTIONS(352),
    [sym_number] = ACTIONS(342),
    [sym_nil] = ACTIONS(346),
    [sym_true] = ACTIONS(346),
    [sym_false] = ACTIONS(346),
    [sym_identifier] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(342),
  },
  [53] = {
    [sym_return_statement] = STATE(887),
    [sym_variable_declaration] = STATE(22),
    [sym_local_variable_declaration] = STATE(22),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_repeat_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym_label_statement] = STATE(22),
    [sym__empty_statement] = STATE(22),
    [sym_function_statement] = STATE(22),
    [sym_local_function_statement] = STATE(22),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(22),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(470),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(472),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(474),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [54] = {
    [sym_arguments] = STATE(136),
    [sym_table] = STATE(127),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(145),
    [anon_sym_local] = ACTIONS(143),
    [anon_sym_LBRACK] = ACTIONS(476),
    [anon_sym_DOT] = ACTIONS(478),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_end] = ACTIONS(143),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_repeat] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_goto] = ACTIONS(143),
    [sym_break_statement] = ACTIONS(143),
    [anon_sym_COLON_COLON] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_COLON] = ACTIONS(480),
    [anon_sym_LPAREN] = ACTIONS(482),
    [sym_spread] = ACTIONS(145),
    [sym_self] = ACTIONS(143),
    [sym_next] = ACTIONS(143),
    [anon_sym__G] = ACTIONS(143),
    [anon_sym__VERSION] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_or] = ACTIONS(143),
    [anon_sym_and] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(143),
    [anon_sym_LT_EQ] = ACTIONS(145),
    [anon_sym_EQ_EQ] = ACTIONS(145),
    [anon_sym_TILDE_EQ] = ACTIONS(145),
    [anon_sym_GT_EQ] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(143),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(143),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LT_LT] = ACTIONS(145),
    [anon_sym_GT_GT] = ACTIONS(145),
    [anon_sym_PLUS] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_STAR] = ACTIONS(145),
    [anon_sym_SLASH] = ACTIONS(143),
    [anon_sym_SLASH_SLASH] = ACTIONS(145),
    [anon_sym_PERCENT] = ACTIONS(145),
    [anon_sym_DOT_DOT] = ACTIONS(143),
    [anon_sym_CARET] = ACTIONS(145),
    [anon_sym_not] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [sym_number] = ACTIONS(145),
    [sym_nil] = ACTIONS(143),
    [sym_true] = ACTIONS(143),
    [sym_false] = ACTIONS(143),
    [sym_identifier] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(488),
  },
  [55] = {
    [sym_return_statement] = STATE(795),
    [sym_variable_declaration] = STATE(50),
    [sym_local_variable_declaration] = STATE(50),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(50),
    [sym_if_statement] = STATE(50),
    [sym_while_statement] = STATE(50),
    [sym_repeat_statement] = STATE(50),
    [sym_for_statement] = STATE(50),
    [sym_for_in_statement] = STATE(50),
    [sym_goto_statement] = STATE(50),
    [sym_label_statement] = STATE(50),
    [sym__empty_statement] = STATE(50),
    [sym_function_statement] = STATE(50),
    [sym_local_function_statement] = STATE(50),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(50),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(491),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(493),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [56] = {
    [sym_return_statement] = STATE(895),
    [sym_variable_declaration] = STATE(81),
    [sym_local_variable_declaration] = STATE(81),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(81),
    [sym_if_statement] = STATE(81),
    [sym_while_statement] = STATE(81),
    [sym_repeat_statement] = STATE(81),
    [sym_for_statement] = STATE(81),
    [sym_for_in_statement] = STATE(81),
    [sym_goto_statement] = STATE(81),
    [sym_label_statement] = STATE(81),
    [sym__empty_statement] = STATE(81),
    [sym_function_statement] = STATE(81),
    [sym_local_function_statement] = STATE(81),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(81),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(499),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(501),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [57] = {
    [anon_sym_return] = ACTIONS(503),
    [anon_sym_COMMA] = ACTIONS(505),
    [anon_sym_local] = ACTIONS(503),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_DOT] = ACTIONS(503),
    [anon_sym_do] = ACTIONS(503),
    [anon_sym_end] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_elseif] = ACTIONS(503),
    [anon_sym_else] = ACTIONS(503),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(503),
    [anon_sym_for] = ACTIONS(503),
    [anon_sym_goto] = ACTIONS(503),
    [sym_break_statement] = ACTIONS(503),
    [anon_sym_COLON_COLON] = ACTIONS(505),
    [anon_sym_SEMI] = ACTIONS(505),
    [anon_sym_function] = ACTIONS(503),
    [anon_sym_COLON] = ACTIONS(503),
    [anon_sym_LPAREN] = ACTIONS(505),
    [sym_spread] = ACTIONS(505),
    [sym_self] = ACTIONS(503),
    [sym_next] = ACTIONS(503),
    [anon_sym__G] = ACTIONS(503),
    [anon_sym__VERSION] = ACTIONS(503),
    [anon_sym_LBRACE] = ACTIONS(505),
    [anon_sym_or] = ACTIONS(503),
    [anon_sym_and] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(503),
    [anon_sym_LT_EQ] = ACTIONS(505),
    [anon_sym_EQ_EQ] = ACTIONS(505),
    [anon_sym_TILDE_EQ] = ACTIONS(505),
    [anon_sym_GT_EQ] = ACTIONS(505),
    [anon_sym_GT] = ACTIONS(503),
    [anon_sym_PIPE] = ACTIONS(505),
    [anon_sym_TILDE] = ACTIONS(503),
    [anon_sym_AMP] = ACTIONS(505),
    [anon_sym_LT_LT] = ACTIONS(505),
    [anon_sym_GT_GT] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(505),
    [anon_sym_DASH] = ACTIONS(505),
    [anon_sym_STAR] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(503),
    [anon_sym_SLASH_SLASH] = ACTIONS(505),
    [anon_sym_PERCENT] = ACTIONS(505),
    [anon_sym_DOT_DOT] = ACTIONS(503),
    [anon_sym_CARET] = ACTIONS(505),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_POUND] = ACTIONS(505),
    [sym_number] = ACTIONS(505),
    [sym_nil] = ACTIONS(503),
    [sym_true] = ACTIONS(503),
    [sym_false] = ACTIONS(503),
    [sym_identifier] = ACTIONS(503),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(505),
  },
  [58] = {
    [sym_return_statement] = STATE(784),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [59] = {
    [sym_return_statement] = STATE(785),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(509),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [60] = {
    [anon_sym_return] = ACTIONS(511),
    [anon_sym_COMMA] = ACTIONS(513),
    [anon_sym_local] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(513),
    [anon_sym_DOT] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(511),
    [anon_sym_end] = ACTIONS(511),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_elseif] = ACTIONS(511),
    [anon_sym_else] = ACTIONS(511),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_repeat] = ACTIONS(511),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_goto] = ACTIONS(511),
    [sym_break_statement] = ACTIONS(511),
    [anon_sym_COLON_COLON] = ACTIONS(513),
    [anon_sym_SEMI] = ACTIONS(513),
    [anon_sym_function] = ACTIONS(511),
    [anon_sym_COLON] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(513),
    [sym_spread] = ACTIONS(513),
    [sym_self] = ACTIONS(511),
    [sym_next] = ACTIONS(511),
    [anon_sym__G] = ACTIONS(511),
    [anon_sym__VERSION] = ACTIONS(511),
    [anon_sym_LBRACE] = ACTIONS(513),
    [anon_sym_or] = ACTIONS(511),
    [anon_sym_and] = ACTIONS(511),
    [anon_sym_LT] = ACTIONS(511),
    [anon_sym_LT_EQ] = ACTIONS(513),
    [anon_sym_EQ_EQ] = ACTIONS(513),
    [anon_sym_TILDE_EQ] = ACTIONS(513),
    [anon_sym_GT_EQ] = ACTIONS(513),
    [anon_sym_GT] = ACTIONS(511),
    [anon_sym_PIPE] = ACTIONS(513),
    [anon_sym_TILDE] = ACTIONS(511),
    [anon_sym_AMP] = ACTIONS(513),
    [anon_sym_LT_LT] = ACTIONS(513),
    [anon_sym_GT_GT] = ACTIONS(513),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [anon_sym_STAR] = ACTIONS(513),
    [anon_sym_SLASH] = ACTIONS(511),
    [anon_sym_SLASH_SLASH] = ACTIONS(513),
    [anon_sym_PERCENT] = ACTIONS(513),
    [anon_sym_DOT_DOT] = ACTIONS(511),
    [anon_sym_CARET] = ACTIONS(513),
    [anon_sym_not] = ACTIONS(511),
    [anon_sym_POUND] = ACTIONS(513),
    [sym_number] = ACTIONS(513),
    [sym_nil] = ACTIONS(511),
    [sym_true] = ACTIONS(511),
    [sym_false] = ACTIONS(511),
    [sym_identifier] = ACTIONS(511),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(513),
  },
  [61] = {
    [anon_sym_return] = ACTIONS(515),
    [anon_sym_COMMA] = ACTIONS(517),
    [anon_sym_local] = ACTIONS(515),
    [anon_sym_LBRACK] = ACTIONS(517),
    [anon_sym_DOT] = ACTIONS(515),
    [anon_sym_do] = ACTIONS(515),
    [anon_sym_end] = ACTIONS(515),
    [anon_sym_if] = ACTIONS(515),
    [anon_sym_elseif] = ACTIONS(515),
    [anon_sym_else] = ACTIONS(515),
    [anon_sym_while] = ACTIONS(515),
    [anon_sym_repeat] = ACTIONS(515),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_goto] = ACTIONS(515),
    [sym_break_statement] = ACTIONS(515),
    [anon_sym_COLON_COLON] = ACTIONS(517),
    [anon_sym_SEMI] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(515),
    [anon_sym_COLON] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [sym_spread] = ACTIONS(517),
    [sym_self] = ACTIONS(515),
    [sym_next] = ACTIONS(515),
    [anon_sym__G] = ACTIONS(515),
    [anon_sym__VERSION] = ACTIONS(515),
    [anon_sym_LBRACE] = ACTIONS(517),
    [anon_sym_or] = ACTIONS(515),
    [anon_sym_and] = ACTIONS(515),
    [anon_sym_LT] = ACTIONS(515),
    [anon_sym_LT_EQ] = ACTIONS(517),
    [anon_sym_EQ_EQ] = ACTIONS(517),
    [anon_sym_TILDE_EQ] = ACTIONS(517),
    [anon_sym_GT_EQ] = ACTIONS(517),
    [anon_sym_GT] = ACTIONS(515),
    [anon_sym_PIPE] = ACTIONS(517),
    [anon_sym_TILDE] = ACTIONS(515),
    [anon_sym_AMP] = ACTIONS(517),
    [anon_sym_LT_LT] = ACTIONS(517),
    [anon_sym_GT_GT] = ACTIONS(517),
    [anon_sym_PLUS] = ACTIONS(517),
    [anon_sym_DASH] = ACTIONS(517),
    [anon_sym_STAR] = ACTIONS(517),
    [anon_sym_SLASH] = ACTIONS(515),
    [anon_sym_SLASH_SLASH] = ACTIONS(517),
    [anon_sym_PERCENT] = ACTIONS(517),
    [anon_sym_DOT_DOT] = ACTIONS(515),
    [anon_sym_CARET] = ACTIONS(517),
    [anon_sym_not] = ACTIONS(515),
    [anon_sym_POUND] = ACTIONS(517),
    [sym_number] = ACTIONS(517),
    [sym_nil] = ACTIONS(515),
    [sym_true] = ACTIONS(515),
    [sym_false] = ACTIONS(515),
    [sym_identifier] = ACTIONS(515),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(517),
  },
  [62] = {
    [sym_return_statement] = STATE(787),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(519),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [63] = {
    [sym_return_statement] = STATE(788),
    [sym_variable_declaration] = STATE(19),
    [sym_local_variable_declaration] = STATE(19),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_repeat_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_goto_statement] = STATE(19),
    [sym_label_statement] = STATE(19),
    [sym__empty_statement] = STATE(19),
    [sym_function_statement] = STATE(19),
    [sym_local_function_statement] = STATE(19),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(19),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(521),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(523),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(525),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [64] = {
    [sym_return_statement] = STATE(789),
    [sym_variable_declaration] = STATE(58),
    [sym_local_variable_declaration] = STATE(58),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_repeat_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_for_in_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym_label_statement] = STATE(58),
    [sym__empty_statement] = STATE(58),
    [sym_function_statement] = STATE(58),
    [sym_local_function_statement] = STATE(58),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(58),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(527),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(529),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(531),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [65] = {
    [sym_return_statement] = STATE(792),
    [sym_variable_declaration] = STATE(59),
    [sym_local_variable_declaration] = STATE(59),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(59),
    [sym_if_statement] = STATE(59),
    [sym_while_statement] = STATE(59),
    [sym_repeat_statement] = STATE(59),
    [sym_for_statement] = STATE(59),
    [sym_for_in_statement] = STATE(59),
    [sym_goto_statement] = STATE(59),
    [sym_label_statement] = STATE(59),
    [sym__empty_statement] = STATE(59),
    [sym_function_statement] = STATE(59),
    [sym_local_function_statement] = STATE(59),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(59),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(533),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(535),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(537),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [66] = {
    [sym_return_statement] = STATE(860),
    [sym_variable_declaration] = STATE(20),
    [sym_local_variable_declaration] = STATE(20),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_repeat_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_goto_statement] = STATE(20),
    [sym_label_statement] = STATE(20),
    [sym__empty_statement] = STATE(20),
    [sym_function_statement] = STATE(20),
    [sym_local_function_statement] = STATE(20),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(20),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(539),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(541),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(543),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [67] = {
    [sym_return_statement] = STATE(864),
    [sym_variable_declaration] = STATE(77),
    [sym_local_variable_declaration] = STATE(77),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(77),
    [sym_if_statement] = STATE(77),
    [sym_while_statement] = STATE(77),
    [sym_repeat_statement] = STATE(77),
    [sym_for_statement] = STATE(77),
    [sym_for_in_statement] = STATE(77),
    [sym_goto_statement] = STATE(77),
    [sym_label_statement] = STATE(77),
    [sym__empty_statement] = STATE(77),
    [sym_function_statement] = STATE(77),
    [sym_local_function_statement] = STATE(77),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(77),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(545),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(547),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(549),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [68] = {
    [sym_return_statement] = STATE(794),
    [sym_variable_declaration] = STATE(62),
    [sym_local_variable_declaration] = STATE(62),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(62),
    [sym_if_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_repeat_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_for_in_statement] = STATE(62),
    [sym_goto_statement] = STATE(62),
    [sym_label_statement] = STATE(62),
    [sym__empty_statement] = STATE(62),
    [sym_function_statement] = STATE(62),
    [sym_local_function_statement] = STATE(62),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(62),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(551),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(553),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(555),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [69] = {
    [sym_return_statement] = STATE(796),
    [sym_variable_declaration] = STATE(99),
    [sym_local_variable_declaration] = STATE(99),
    [sym__variable_declarator] = STATE(47),
    [sym_field_expression] = STATE(109),
    [sym_do_statement] = STATE(99),
    [sym_if_statement] = STATE(99),
    [sym_while_statement] = STATE(99),
    [sym_repeat_statement] = STATE(99),
    [sym_for_statement] = STATE(99),
    [sym_for_in_statement] = STATE(99),
    [sym_goto_statement] = STATE(99),
    [sym_label_statement] = STATE(99),
    [sym__empty_statement] = STATE(99),
    [sym_function_statement] = STATE(99),
    [sym_local_function_statement] = STATE(99),
    [sym_function_call_statement] = STATE(155),
    [sym__expression] = STATE(255),
    [sym_global_variable] = STATE(46),
    [sym__prefix] = STATE(46),
    [sym_function_definition] = STATE(250),
    [sym_table] = STATE(250),
    [sym_binary_operation] = STATE(250),
    [sym_unary_operation] = STATE(250),
    [aux_sym_program_repeat1] = STATE(99),
    [anon_sym_return] = ACTIONS(314),
    [anon_sym_local] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(318),
    [anon_sym_if] = ACTIONS(320),
    [anon_sym_while] = ACTIONS(322),
    [anon_sym_repeat] = ACTIONS(324),
    [anon_sym_until] = ACTIONS(557),
    [anon_sym_for] = ACTIONS(328),
    [anon_sym_goto] = ACTIONS(330),
    [sym_break_statement] = ACTIONS(421),
    [anon_sym_COLON_COLON] = ACTIONS(334),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_function] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [sym_spread] = ACTIONS(342),
    [sym_self] = ACTIONS(344),
    [sym_next] = ACTIONS(346),
    [anon_sym__G] = ACTIONS(348),
    [anon_sym__VERSION] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(352),
    [anon_sym_DASH] = ACTIONS(352),
    [anon_sym_not] = ACTIONS(354),
    [anon_sym_POUND] = ACTIONS(352),
    [sym_number] = ACTIONS(342),
    [sym_nil] = ACTIONS(346),
    [sym_true] = ACTIONS(346),
    [sym_false] = ACTIONS(346),
    [sym_identifier] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(342),
  },
  [70] = {
    [sym_return_statement] = STATE(798),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(559),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [71] = {
    [sym_return_statement] = STATE(907),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(561),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [72] = {
    [sym_return_statement] = STATE(809),
    [sym_variable_declaration] = STATE(69),
    [sym_local_variable_declaration] = STATE(69),
    [sym__variable_declarator] = STATE(47),
    [sym_field_expression] = STATE(109),
    [sym_do_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_repeat_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_for_in_statement] = STATE(69),
    [sym_goto_statement] = STATE(69),
    [sym_label_statement] = STATE(69),
    [sym__empty_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_local_function_statement] = STATE(69),
    [sym_function_call_statement] = STATE(155),
    [sym__expression] = STATE(255),
    [sym_global_variable] = STATE(46),
    [sym__prefix] = STATE(46),
    [sym_function_definition] = STATE(250),
    [sym_table] = STATE(250),
    [sym_binary_operation] = STATE(250),
    [sym_unary_operation] = STATE(250),
    [aux_sym_program_repeat1] = STATE(69),
    [anon_sym_return] = ACTIONS(314),
    [anon_sym_local] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(318),
    [anon_sym_if] = ACTIONS(320),
    [anon_sym_while] = ACTIONS(322),
    [anon_sym_repeat] = ACTIONS(324),
    [anon_sym_until] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(328),
    [anon_sym_goto] = ACTIONS(330),
    [sym_break_statement] = ACTIONS(565),
    [anon_sym_COLON_COLON] = ACTIONS(334),
    [anon_sym_SEMI] = ACTIONS(567),
    [anon_sym_function] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [sym_spread] = ACTIONS(342),
    [sym_self] = ACTIONS(344),
    [sym_next] = ACTIONS(346),
    [anon_sym__G] = ACTIONS(348),
    [anon_sym__VERSION] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(352),
    [anon_sym_DASH] = ACTIONS(352),
    [anon_sym_not] = ACTIONS(354),
    [anon_sym_POUND] = ACTIONS(352),
    [sym_number] = ACTIONS(342),
    [sym_nil] = ACTIONS(346),
    [sym_true] = ACTIONS(346),
    [sym_false] = ACTIONS(346),
    [sym_identifier] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(342),
  },
  [73] = {
    [sym_return_statement] = STATE(815),
    [sym_variable_declaration] = STATE(70),
    [sym_local_variable_declaration] = STATE(70),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(70),
    [sym_if_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_repeat_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_for_in_statement] = STATE(70),
    [sym_goto_statement] = STATE(70),
    [sym_label_statement] = STATE(70),
    [sym__empty_statement] = STATE(70),
    [sym_function_statement] = STATE(70),
    [sym_local_function_statement] = STATE(70),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(70),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(569),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(571),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(573),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [74] = {
    [anon_sym_return] = ACTIONS(575),
    [anon_sym_COMMA] = ACTIONS(577),
    [anon_sym_local] = ACTIONS(575),
    [anon_sym_LBRACK] = ACTIONS(577),
    [anon_sym_DOT] = ACTIONS(575),
    [anon_sym_do] = ACTIONS(575),
    [anon_sym_end] = ACTIONS(575),
    [anon_sym_if] = ACTIONS(575),
    [anon_sym_elseif] = ACTIONS(575),
    [anon_sym_else] = ACTIONS(575),
    [anon_sym_while] = ACTIONS(575),
    [anon_sym_repeat] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(575),
    [anon_sym_goto] = ACTIONS(575),
    [sym_break_statement] = ACTIONS(575),
    [anon_sym_COLON_COLON] = ACTIONS(577),
    [anon_sym_SEMI] = ACTIONS(577),
    [anon_sym_function] = ACTIONS(575),
    [anon_sym_COLON] = ACTIONS(575),
    [anon_sym_LPAREN] = ACTIONS(577),
    [sym_spread] = ACTIONS(577),
    [sym_self] = ACTIONS(575),
    [sym_next] = ACTIONS(575),
    [anon_sym__G] = ACTIONS(575),
    [anon_sym__VERSION] = ACTIONS(575),
    [anon_sym_LBRACE] = ACTIONS(577),
    [anon_sym_or] = ACTIONS(575),
    [anon_sym_and] = ACTIONS(575),
    [anon_sym_LT] = ACTIONS(575),
    [anon_sym_LT_EQ] = ACTIONS(577),
    [anon_sym_EQ_EQ] = ACTIONS(577),
    [anon_sym_TILDE_EQ] = ACTIONS(577),
    [anon_sym_GT_EQ] = ACTIONS(577),
    [anon_sym_GT] = ACTIONS(575),
    [anon_sym_PIPE] = ACTIONS(577),
    [anon_sym_TILDE] = ACTIONS(575),
    [anon_sym_AMP] = ACTIONS(577),
    [anon_sym_LT_LT] = ACTIONS(577),
    [anon_sym_GT_GT] = ACTIONS(577),
    [anon_sym_PLUS] = ACTIONS(577),
    [anon_sym_DASH] = ACTIONS(577),
    [anon_sym_STAR] = ACTIONS(577),
    [anon_sym_SLASH] = ACTIONS(575),
    [anon_sym_SLASH_SLASH] = ACTIONS(577),
    [anon_sym_PERCENT] = ACTIONS(577),
    [anon_sym_DOT_DOT] = ACTIONS(575),
    [anon_sym_CARET] = ACTIONS(577),
    [anon_sym_not] = ACTIONS(575),
    [anon_sym_POUND] = ACTIONS(577),
    [sym_number] = ACTIONS(577),
    [sym_nil] = ACTIONS(575),
    [sym_true] = ACTIONS(575),
    [sym_false] = ACTIONS(575),
    [sym_identifier] = ACTIONS(575),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(577),
  },
  [75] = {
    [anon_sym_return] = ACTIONS(579),
    [anon_sym_COMMA] = ACTIONS(581),
    [anon_sym_local] = ACTIONS(579),
    [anon_sym_LBRACK] = ACTIONS(581),
    [anon_sym_DOT] = ACTIONS(579),
    [anon_sym_do] = ACTIONS(579),
    [anon_sym_end] = ACTIONS(579),
    [anon_sym_if] = ACTIONS(579),
    [anon_sym_elseif] = ACTIONS(579),
    [anon_sym_else] = ACTIONS(579),
    [anon_sym_while] = ACTIONS(579),
    [anon_sym_repeat] = ACTIONS(579),
    [anon_sym_for] = ACTIONS(579),
    [anon_sym_goto] = ACTIONS(579),
    [sym_break_statement] = ACTIONS(579),
    [anon_sym_COLON_COLON] = ACTIONS(581),
    [anon_sym_SEMI] = ACTIONS(581),
    [anon_sym_function] = ACTIONS(579),
    [anon_sym_COLON] = ACTIONS(579),
    [anon_sym_LPAREN] = ACTIONS(581),
    [sym_spread] = ACTIONS(581),
    [sym_self] = ACTIONS(579),
    [sym_next] = ACTIONS(579),
    [anon_sym__G] = ACTIONS(579),
    [anon_sym__VERSION] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(581),
    [anon_sym_or] = ACTIONS(579),
    [anon_sym_and] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(579),
    [anon_sym_LT_EQ] = ACTIONS(581),
    [anon_sym_EQ_EQ] = ACTIONS(581),
    [anon_sym_TILDE_EQ] = ACTIONS(581),
    [anon_sym_GT_EQ] = ACTIONS(581),
    [anon_sym_GT] = ACTIONS(579),
    [anon_sym_PIPE] = ACTIONS(581),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_AMP] = ACTIONS(581),
    [anon_sym_LT_LT] = ACTIONS(581),
    [anon_sym_GT_GT] = ACTIONS(581),
    [anon_sym_PLUS] = ACTIONS(581),
    [anon_sym_DASH] = ACTIONS(581),
    [anon_sym_STAR] = ACTIONS(581),
    [anon_sym_SLASH] = ACTIONS(579),
    [anon_sym_SLASH_SLASH] = ACTIONS(581),
    [anon_sym_PERCENT] = ACTIONS(581),
    [anon_sym_DOT_DOT] = ACTIONS(579),
    [anon_sym_CARET] = ACTIONS(581),
    [anon_sym_not] = ACTIONS(579),
    [anon_sym_POUND] = ACTIONS(581),
    [sym_number] = ACTIONS(581),
    [sym_nil] = ACTIONS(579),
    [sym_true] = ACTIONS(579),
    [sym_false] = ACTIONS(579),
    [sym_identifier] = ACTIONS(579),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(581),
  },
  [76] = {
    [sym_return_statement] = STATE(894),
    [sym_variable_declaration] = STATE(91),
    [sym_local_variable_declaration] = STATE(91),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(91),
    [sym_if_statement] = STATE(91),
    [sym_while_statement] = STATE(91),
    [sym_repeat_statement] = STATE(91),
    [sym_for_statement] = STATE(91),
    [sym_for_in_statement] = STATE(91),
    [sym_goto_statement] = STATE(91),
    [sym_label_statement] = STATE(91),
    [sym__empty_statement] = STATE(91),
    [sym_function_statement] = STATE(91),
    [sym_local_function_statement] = STATE(91),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(91),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(583),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(585),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [77] = {
    [sym_return_statement] = STATE(866),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(589),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [78] = {
    [sym_return_statement] = STATE(823),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(591),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [79] = {
    [sym_return_statement] = STATE(824),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(593),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [80] = {
    [sym_return_statement] = STATE(868),
    [sym_variable_declaration] = STATE(90),
    [sym_local_variable_declaration] = STATE(90),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(90),
    [sym_if_statement] = STATE(90),
    [sym_while_statement] = STATE(90),
    [sym_repeat_statement] = STATE(90),
    [sym_for_statement] = STATE(90),
    [sym_for_in_statement] = STATE(90),
    [sym_goto_statement] = STATE(90),
    [sym_label_statement] = STATE(90),
    [sym__empty_statement] = STATE(90),
    [sym_function_statement] = STATE(90),
    [sym_local_function_statement] = STATE(90),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(90),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(595),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(597),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(599),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [81] = {
    [sym_return_statement] = STATE(905),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(601),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [82] = {
    [sym_return_statement] = STATE(858),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(603),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [83] = {
    [sym_return_statement] = STATE(826),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(605),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [84] = {
    [sym_return_statement] = STATE(816),
    [sym_variable_declaration] = STATE(44),
    [sym_local_variable_declaration] = STATE(44),
    [sym__variable_declarator] = STATE(47),
    [sym_field_expression] = STATE(109),
    [sym_do_statement] = STATE(44),
    [sym_if_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_repeat_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_for_in_statement] = STATE(44),
    [sym_goto_statement] = STATE(44),
    [sym_label_statement] = STATE(44),
    [sym__empty_statement] = STATE(44),
    [sym_function_statement] = STATE(44),
    [sym_local_function_statement] = STATE(44),
    [sym_function_call_statement] = STATE(155),
    [sym__expression] = STATE(255),
    [sym_global_variable] = STATE(46),
    [sym__prefix] = STATE(46),
    [sym_function_definition] = STATE(250),
    [sym_table] = STATE(250),
    [sym_binary_operation] = STATE(250),
    [sym_unary_operation] = STATE(250),
    [aux_sym_program_repeat1] = STATE(44),
    [anon_sym_return] = ACTIONS(314),
    [anon_sym_local] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(318),
    [anon_sym_if] = ACTIONS(320),
    [anon_sym_while] = ACTIONS(322),
    [anon_sym_repeat] = ACTIONS(324),
    [anon_sym_until] = ACTIONS(607),
    [anon_sym_for] = ACTIONS(328),
    [anon_sym_goto] = ACTIONS(330),
    [sym_break_statement] = ACTIONS(609),
    [anon_sym_COLON_COLON] = ACTIONS(334),
    [anon_sym_SEMI] = ACTIONS(611),
    [anon_sym_function] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [sym_spread] = ACTIONS(342),
    [sym_self] = ACTIONS(344),
    [sym_next] = ACTIONS(346),
    [anon_sym__G] = ACTIONS(348),
    [anon_sym__VERSION] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(352),
    [anon_sym_DASH] = ACTIONS(352),
    [anon_sym_not] = ACTIONS(354),
    [anon_sym_POUND] = ACTIONS(352),
    [sym_number] = ACTIONS(342),
    [sym_nil] = ACTIONS(346),
    [sym_true] = ACTIONS(346),
    [sym_false] = ACTIONS(346),
    [sym_identifier] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(342),
  },
  [85] = {
    [sym_return_statement] = STATE(834),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(613),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [86] = {
    [sym_return_statement] = STATE(840),
    [sym_variable_declaration] = STATE(78),
    [sym_local_variable_declaration] = STATE(78),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(78),
    [sym_if_statement] = STATE(78),
    [sym_while_statement] = STATE(78),
    [sym_repeat_statement] = STATE(78),
    [sym_for_statement] = STATE(78),
    [sym_for_in_statement] = STATE(78),
    [sym_goto_statement] = STATE(78),
    [sym_label_statement] = STATE(78),
    [sym__empty_statement] = STATE(78),
    [sym_function_statement] = STATE(78),
    [sym_local_function_statement] = STATE(78),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(78),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(615),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(617),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(619),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [87] = {
    [sym_return_statement] = STATE(843),
    [sym_variable_declaration] = STATE(79),
    [sym_local_variable_declaration] = STATE(79),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(79),
    [sym_if_statement] = STATE(79),
    [sym_while_statement] = STATE(79),
    [sym_repeat_statement] = STATE(79),
    [sym_for_statement] = STATE(79),
    [sym_for_in_statement] = STATE(79),
    [sym_goto_statement] = STATE(79),
    [sym_label_statement] = STATE(79),
    [sym__empty_statement] = STATE(79),
    [sym_function_statement] = STATE(79),
    [sym_local_function_statement] = STATE(79),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(623),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [88] = {
    [sym_return_statement] = STATE(779),
    [sym_variable_declaration] = STATE(83),
    [sym_local_variable_declaration] = STATE(83),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(83),
    [sym_if_statement] = STATE(83),
    [sym_while_statement] = STATE(83),
    [sym_repeat_statement] = STATE(83),
    [sym_for_statement] = STATE(83),
    [sym_for_in_statement] = STATE(83),
    [sym_goto_statement] = STATE(83),
    [sym_label_statement] = STATE(83),
    [sym__empty_statement] = STATE(83),
    [sym_function_statement] = STATE(83),
    [sym_local_function_statement] = STATE(83),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(83),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(627),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(629),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(631),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [89] = {
    [anon_sym_return] = ACTIONS(633),
    [anon_sym_COMMA] = ACTIONS(635),
    [anon_sym_local] = ACTIONS(633),
    [anon_sym_LBRACK] = ACTIONS(635),
    [anon_sym_DOT] = ACTIONS(633),
    [anon_sym_do] = ACTIONS(633),
    [anon_sym_end] = ACTIONS(633),
    [anon_sym_if] = ACTIONS(633),
    [anon_sym_elseif] = ACTIONS(633),
    [anon_sym_else] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(633),
    [anon_sym_repeat] = ACTIONS(633),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_goto] = ACTIONS(633),
    [sym_break_statement] = ACTIONS(633),
    [anon_sym_COLON_COLON] = ACTIONS(635),
    [anon_sym_SEMI] = ACTIONS(635),
    [anon_sym_function] = ACTIONS(633),
    [anon_sym_COLON] = ACTIONS(633),
    [anon_sym_LPAREN] = ACTIONS(635),
    [sym_spread] = ACTIONS(635),
    [sym_self] = ACTIONS(633),
    [sym_next] = ACTIONS(633),
    [anon_sym__G] = ACTIONS(633),
    [anon_sym__VERSION] = ACTIONS(633),
    [anon_sym_LBRACE] = ACTIONS(635),
    [anon_sym_or] = ACTIONS(633),
    [anon_sym_and] = ACTIONS(633),
    [anon_sym_LT] = ACTIONS(633),
    [anon_sym_LT_EQ] = ACTIONS(635),
    [anon_sym_EQ_EQ] = ACTIONS(635),
    [anon_sym_TILDE_EQ] = ACTIONS(635),
    [anon_sym_GT_EQ] = ACTIONS(635),
    [anon_sym_GT] = ACTIONS(633),
    [anon_sym_PIPE] = ACTIONS(635),
    [anon_sym_TILDE] = ACTIONS(633),
    [anon_sym_AMP] = ACTIONS(635),
    [anon_sym_LT_LT] = ACTIONS(635),
    [anon_sym_GT_GT] = ACTIONS(635),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_DASH] = ACTIONS(635),
    [anon_sym_STAR] = ACTIONS(635),
    [anon_sym_SLASH] = ACTIONS(633),
    [anon_sym_SLASH_SLASH] = ACTIONS(635),
    [anon_sym_PERCENT] = ACTIONS(635),
    [anon_sym_DOT_DOT] = ACTIONS(633),
    [anon_sym_CARET] = ACTIONS(635),
    [anon_sym_not] = ACTIONS(633),
    [anon_sym_POUND] = ACTIONS(635),
    [sym_number] = ACTIONS(635),
    [sym_nil] = ACTIONS(633),
    [sym_true] = ACTIONS(633),
    [sym_false] = ACTIONS(633),
    [sym_identifier] = ACTIONS(633),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(635),
  },
  [90] = {
    [sym_return_statement] = STATE(870),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(637),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [91] = {
    [sym_return_statement] = STATE(904),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(639),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [92] = {
    [sym_return_statement] = STATE(872),
    [sym_variable_declaration] = STATE(97),
    [sym_local_variable_declaration] = STATE(97),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(97),
    [sym_if_statement] = STATE(97),
    [sym_while_statement] = STATE(97),
    [sym_repeat_statement] = STATE(97),
    [sym_for_statement] = STATE(97),
    [sym_for_in_statement] = STATE(97),
    [sym_goto_statement] = STATE(97),
    [sym_label_statement] = STATE(97),
    [sym__empty_statement] = STATE(97),
    [sym_function_statement] = STATE(97),
    [sym_local_function_statement] = STATE(97),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(97),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(641),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(643),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(645),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [93] = {
    [sym_return_statement] = STATE(828),
    [sym_variable_declaration] = STATE(40),
    [sym_local_variable_declaration] = STATE(40),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(40),
    [sym_if_statement] = STATE(40),
    [sym_while_statement] = STATE(40),
    [sym_repeat_statement] = STATE(40),
    [sym_for_statement] = STATE(40),
    [sym_for_in_statement] = STATE(40),
    [sym_goto_statement] = STATE(40),
    [sym_label_statement] = STATE(40),
    [sym__empty_statement] = STATE(40),
    [sym_function_statement] = STATE(40),
    [sym_local_function_statement] = STATE(40),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(40),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(647),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(649),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [94] = {
    [sym_return_statement] = STATE(892),
    [sym_variable_declaration] = STATE(95),
    [sym_local_variable_declaration] = STATE(95),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(95),
    [sym_if_statement] = STATE(95),
    [sym_while_statement] = STATE(95),
    [sym_repeat_statement] = STATE(95),
    [sym_for_statement] = STATE(95),
    [sym_for_in_statement] = STATE(95),
    [sym_goto_statement] = STATE(95),
    [sym_label_statement] = STATE(95),
    [sym__empty_statement] = STATE(95),
    [sym_function_statement] = STATE(95),
    [sym_local_function_statement] = STATE(95),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(95),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(653),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(655),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [95] = {
    [sym_return_statement] = STATE(903),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [96] = {
    [sym_return_statement] = STATE(854),
    [sym_variable_declaration] = STATE(99),
    [sym_local_variable_declaration] = STATE(99),
    [sym__variable_declarator] = STATE(47),
    [sym_field_expression] = STATE(109),
    [sym_do_statement] = STATE(99),
    [sym_if_statement] = STATE(99),
    [sym_while_statement] = STATE(99),
    [sym_repeat_statement] = STATE(99),
    [sym_for_statement] = STATE(99),
    [sym_for_in_statement] = STATE(99),
    [sym_goto_statement] = STATE(99),
    [sym_label_statement] = STATE(99),
    [sym__empty_statement] = STATE(99),
    [sym_function_statement] = STATE(99),
    [sym_local_function_statement] = STATE(99),
    [sym_function_call_statement] = STATE(155),
    [sym__expression] = STATE(255),
    [sym_global_variable] = STATE(46),
    [sym__prefix] = STATE(46),
    [sym_function_definition] = STATE(250),
    [sym_table] = STATE(250),
    [sym_binary_operation] = STATE(250),
    [sym_unary_operation] = STATE(250),
    [aux_sym_program_repeat1] = STATE(99),
    [anon_sym_return] = ACTIONS(314),
    [anon_sym_local] = ACTIONS(316),
    [anon_sym_do] = ACTIONS(318),
    [anon_sym_if] = ACTIONS(320),
    [anon_sym_while] = ACTIONS(322),
    [anon_sym_repeat] = ACTIONS(324),
    [anon_sym_until] = ACTIONS(661),
    [anon_sym_for] = ACTIONS(328),
    [anon_sym_goto] = ACTIONS(330),
    [sym_break_statement] = ACTIONS(421),
    [anon_sym_COLON_COLON] = ACTIONS(334),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_function] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(340),
    [sym_spread] = ACTIONS(342),
    [sym_self] = ACTIONS(344),
    [sym_next] = ACTIONS(346),
    [anon_sym__G] = ACTIONS(348),
    [anon_sym__VERSION] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(352),
    [anon_sym_DASH] = ACTIONS(352),
    [anon_sym_not] = ACTIONS(354),
    [anon_sym_POUND] = ACTIONS(352),
    [sym_number] = ACTIONS(342),
    [sym_nil] = ACTIONS(346),
    [sym_true] = ACTIONS(346),
    [sym_false] = ACTIONS(346),
    [sym_identifier] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(342),
  },
  [97] = {
    [sym_return_statement] = STATE(874),
    [sym_variable_declaration] = STATE(106),
    [sym_local_variable_declaration] = STATE(106),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(106),
    [sym_if_statement] = STATE(106),
    [sym_while_statement] = STATE(106),
    [sym_repeat_statement] = STATE(106),
    [sym_for_statement] = STATE(106),
    [sym_for_in_statement] = STATE(106),
    [sym_goto_statement] = STATE(106),
    [sym_label_statement] = STATE(106),
    [sym__empty_statement] = STATE(106),
    [sym_function_statement] = STATE(106),
    [sym_local_function_statement] = STATE(106),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(106),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(663),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
  [98] = {
    [sym_return_statement] = STATE(845),
    [sym_variable_declaration] = STATE(85),
    [sym_local_variable_declaration] = STATE(85),
    [sym__variable_declarator] = STATE(25),
    [sym_field_expression] = STATE(103),
    [sym_do_statement] = STATE(85),
    [sym_if_statement] = STATE(85),
    [sym_while_statement] = STATE(85),
    [sym_repeat_statement] = STATE(85),
    [sym_for_statement] = STATE(85),
    [sym_for_in_statement] = STATE(85),
    [sym_goto_statement] = STATE(85),
    [sym_label_statement] = STATE(85),
    [sym__empty_statement] = STATE(85),
    [sym_function_statement] = STATE(85),
    [sym_local_function_statement] = STATE(85),
    [sym_function_call_statement] = STATE(162),
    [sym__expression] = STATE(251),
    [sym_global_variable] = STATE(54),
    [sym__prefix] = STATE(54),
    [sym_function_definition] = STATE(213),
    [sym_table] = STATE(213),
    [sym_binary_operation] = STATE(213),
    [sym_unary_operation] = STATE(213),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_local] = ACTIONS(246),
    [anon_sym_do] = ACTIONS(248),
    [anon_sym_end] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(252),
    [anon_sym_while] = ACTIONS(254),
    [anon_sym_repeat] = ACTIONS(256),
    [anon_sym_for] = ACTIONS(258),
    [anon_sym_goto] = ACTIONS(260),
    [sym_break_statement] = ACTIONS(667),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(669),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [sym_spread] = ACTIONS(272),
    [sym_self] = ACTIONS(274),
    [sym_next] = ACTIONS(276),
    [anon_sym__G] = ACTIONS(278),
    [anon_sym__VERSION] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_TILDE] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(282),
    [sym_number] = ACTIONS(272),
    [sym_nil] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_identifier] = ACTIONS(286),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(272),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(671), 1,
      anon_sym_local,
    ACTIONS(674), 1,
      anon_sym_do,
    ACTIONS(677), 1,
      anon_sym_if,
    ACTIONS(680), 1,
      anon_sym_while,
    ACTIONS(683), 1,
      anon_sym_repeat,
    ACTIONS(686), 1,
      anon_sym_for,
    ACTIONS(689), 1,
      anon_sym_goto,
    ACTIONS(692), 1,
      sym_break_statement,
    ACTIONS(695), 1,
      anon_sym_COLON_COLON,
    ACTIONS(698), 1,
      anon_sym_SEMI,
    ACTIONS(701), 1,
      anon_sym_function,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(710), 1,
      sym_self,
    ACTIONS(719), 1,
      anon_sym_LBRACE,
    ACTIONS(725), 1,
      anon_sym_not,
    ACTIONS(728), 1,
      sym_identifier,
    STATE(47), 1,
      sym__variable_declarator,
    STATE(109), 1,
      sym_field_expression,
    STATE(155), 1,
      sym_function_call_statement,
    STATE(255), 1,
      sym__expression,
    ACTIONS(172), 2,
      anon_sym_return,
      anon_sym_until,
    ACTIONS(716), 2,
      anon_sym__G,
      anon_sym__VERSION,
    STATE(46), 2,
      sym_global_variable,
      sym__prefix,
    ACTIONS(707), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(722), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(713), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
    STATE(99), 14,
      sym_variable_declaration,
      sym_local_variable_declaration,
      sym_do_statement,
      sym_if_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_for_statement,
      sym_for_in_statement,
      sym_goto_statement,
      sym_label_statement,
      sym__empty_statement,
      sym_function_statement,
      sym_local_function_statement,
      aux_sym_program_repeat1,
  [114] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(172), 1,
      anon_sym_return,
    ACTIONS(731), 1,
      ts_builtin_sym_end,
    ACTIONS(733), 1,
      anon_sym_local,
    ACTIONS(736), 1,
      anon_sym_do,
    ACTIONS(739), 1,
      anon_sym_if,
    ACTIONS(742), 1,
      anon_sym_while,
    ACTIONS(745), 1,
      anon_sym_repeat,
    ACTIONS(748), 1,
      anon_sym_for,
    ACTIONS(751), 1,
      anon_sym_goto,
    ACTIONS(754), 1,
      sym_break_statement,
    ACTIONS(757), 1,
      anon_sym_COLON_COLON,
    ACTIONS(760), 1,
      anon_sym_SEMI,
    ACTIONS(763), 1,
      anon_sym_function,
    ACTIONS(766), 1,
      anon_sym_LPAREN,
    ACTIONS(772), 1,
      sym_self,
    ACTIONS(781), 1,
      anon_sym_LBRACE,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(790), 1,
      sym_identifier,
    STATE(26), 1,
      sym__variable_declarator,
    STATE(107), 1,
      sym_field_expression,
    STATE(160), 1,
      sym_function_call_statement,
    STATE(254), 1,
      sym__expression,
    ACTIONS(778), 2,
      anon_sym__G,
      anon_sym__VERSION,
    STATE(30), 2,
      sym_global_variable,
      sym__prefix,
    ACTIONS(769), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(784), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(775), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
    STATE(100), 14,
      sym_variable_declaration,
      sym_local_variable_declaration,
      sym_do_statement,
      sym_if_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_for_statement,
      sym_for_in_statement,
      sym_goto_statement,
      sym_label_statement,
      sym__empty_statement,
      sym_function_statement,
      sym_local_function_statement,
      aux_sym_program_repeat1,
  [230] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(164), 29,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [292] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 2,
      anon_sym_COMMA,
      anon_sym_LBRACK,
    ACTIONS(168), 3,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(241), 22,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(238), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [358] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(168), 30,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [420] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 2,
      anon_sym_COMMA,
      anon_sym_LBRACK,
    ACTIONS(168), 3,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(241), 22,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(238), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [486] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(234), 30,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [548] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(793), 1,
      anon_sym_local,
    ACTIONS(796), 1,
      anon_sym_do,
    ACTIONS(799), 1,
      anon_sym_if,
    ACTIONS(802), 1,
      anon_sym_while,
    ACTIONS(805), 1,
      anon_sym_repeat,
    ACTIONS(808), 1,
      anon_sym_for,
    ACTIONS(811), 1,
      anon_sym_goto,
    ACTIONS(814), 1,
      sym_break_statement,
    ACTIONS(817), 1,
      anon_sym_COLON_COLON,
    ACTIONS(820), 1,
      anon_sym_SEMI,
    ACTIONS(823), 1,
      anon_sym_function,
    ACTIONS(826), 1,
      anon_sym_LPAREN,
    ACTIONS(832), 1,
      sym_self,
    ACTIONS(841), 1,
      anon_sym_LBRACE,
    ACTIONS(847), 1,
      anon_sym_not,
    ACTIONS(850), 1,
      sym_identifier,
    STATE(25), 1,
      sym__variable_declarator,
    STATE(103), 1,
      sym_field_expression,
    STATE(162), 1,
      sym_function_call_statement,
    STATE(251), 1,
      sym__expression,
    ACTIONS(172), 2,
      anon_sym_return,
      anon_sym_end,
    ACTIONS(838), 2,
      anon_sym__G,
      anon_sym__VERSION,
    STATE(54), 2,
      sym_global_variable,
      sym__prefix,
    ACTIONS(829), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(844), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(835), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
    STATE(106), 14,
      sym_variable_declaration,
      sym_local_variable_declaration,
      sym_do_statement,
      sym_if_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_for_statement,
      sym_for_in_statement,
      sym_goto_statement,
      sym_label_statement,
      sym__empty_statement,
      sym_function_statement,
      sym_local_function_statement,
      aux_sym_program_repeat1,
  [662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(168), 29,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [724] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 8,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
    ACTIONS(855), 9,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(141), 14,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
    ACTIONS(853), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [790] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(168), 30,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(234), 30,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [914] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 2,
      anon_sym_COMMA,
      anon_sym_LBRACK,
    ACTIONS(168), 3,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(241), 23,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(238), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(164), 30,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1042] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(234), 29,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1104] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(164), 30,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1166] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(511), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1227] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 1,
      anon_sym_COMMA,
    ACTIONS(863), 1,
      anon_sym_or,
    ACTIONS(865), 1,
      anon_sym_and,
    ACTIONS(871), 1,
      anon_sym_PIPE,
    ACTIONS(873), 1,
      anon_sym_TILDE,
    ACTIONS(875), 1,
      anon_sym_AMP,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    STATE(321), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(867), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(877), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(869), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(861), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(857), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(511), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(633), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(633), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(358), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1562] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(579), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1623] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(241), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(238), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1688] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(575), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(515), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1810] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(241), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(238), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1875] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(358), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1936] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(575), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1997] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(511), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2058] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(579), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(579), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2180] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 1,
      anon_sym_COMMA,
    ACTIONS(863), 1,
      anon_sym_or,
    ACTIONS(865), 1,
      anon_sym_and,
    ACTIONS(871), 1,
      anon_sym_PIPE,
    ACTIONS(873), 1,
      anon_sym_TILDE,
    ACTIONS(875), 1,
      anon_sym_AMP,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    STATE(320), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(867), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(877), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(869), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2271] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(575), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2332] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(515), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2393] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(241), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(238), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2458] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(389), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(515), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(389), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2641] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(290), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2702] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(389), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2763] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(290), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2824] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(503), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(397), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2946] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(503), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3007] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(397), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3068] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(397), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3129] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(290), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3190] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(503), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3251] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 1,
      anon_sym_COMMA,
    ACTIONS(863), 1,
      anon_sym_or,
    ACTIONS(865), 1,
      anon_sym_and,
    ACTIONS(871), 1,
      anon_sym_PIPE,
    ACTIONS(873), 1,
      anon_sym_TILDE,
    ACTIONS(875), 1,
      anon_sym_AMP,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    STATE(317), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(867), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(877), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(869), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(895), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3342] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(358), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3403] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(633), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3524] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3584] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(143), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3644] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(865), 1,
      anon_sym_and,
    ACTIONS(871), 1,
      anon_sym_PIPE,
    ACTIONS(873), 1,
      anon_sym_TILDE,
    ACTIONS(875), 1,
      anon_sym_AMP,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(867), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(877), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(869), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3728] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 8,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
    ACTIONS(855), 9,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(141), 14,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
    ACTIONS(853), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3792] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(871), 1,
      anon_sym_PIPE,
    ACTIONS(873), 1,
      anon_sym_TILDE,
    ACTIONS(875), 1,
      anon_sym_AMP,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(867), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(877), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(869), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3874] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(871), 1,
      anon_sym_PIPE,
    ACTIONS(873), 1,
      anon_sym_TILDE,
    ACTIONS(875), 1,
      anon_sym_AMP,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(877), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 13,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3952] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(907), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4014] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 1,
      anon_sym_TILDE,
    ACTIONS(875), 1,
      anon_sym_AMP,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(877), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4090] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 8,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
    ACTIONS(855), 10,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(141), 14,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
    ACTIONS(853), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4154] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(911), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4216] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 8,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
    ACTIONS(855), 9,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(141), 14,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
    ACTIONS(853), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4280] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 1,
      anon_sym_or,
    ACTIONS(865), 1,
      anon_sym_and,
    ACTIONS(871), 1,
      anon_sym_PIPE,
    ACTIONS(873), 1,
      anon_sym_TILDE,
    ACTIONS(875), 1,
      anon_sym_AMP,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(867), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(877), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(869), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(915), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4366] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(917), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4426] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_AMP,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(877), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4500] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(877), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 15,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4572] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(921), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4632] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4702] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 19,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4768] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(907), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4830] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(883), 1,
      anon_sym_SLASH,
    ACTIONS(885), 1,
      anon_sym_DOT_DOT,
    ACTIONS(887), 1,
      anon_sym_CARET,
    ACTIONS(879), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(881), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4900] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(911), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4961] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(931), 1,
      anon_sym_or,
    ACTIONS(933), 1,
      anon_sym_and,
    ACTIONS(939), 1,
      anon_sym_PIPE,
    ACTIONS(941), 1,
      anon_sym_TILDE,
    ACTIONS(943), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(935), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(945), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(937), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(929), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(927), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5046] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    ACTIONS(957), 1,
      anon_sym_or,
    ACTIONS(959), 1,
      anon_sym_and,
    ACTIONS(965), 1,
      anon_sym_PIPE,
    ACTIONS(967), 1,
      anon_sym_TILDE,
    ACTIONS(969), 1,
      anon_sym_AMP,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    STATE(357), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(961), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(971), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(963), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5135] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    ACTIONS(957), 1,
      anon_sym_or,
    ACTIONS(959), 1,
      anon_sym_and,
    ACTIONS(965), 1,
      anon_sym_PIPE,
    ACTIONS(967), 1,
      anon_sym_TILDE,
    ACTIONS(969), 1,
      anon_sym_AMP,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    STATE(361), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(961), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(971), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(963), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(861), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(857), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5224] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(931), 1,
      anon_sym_or,
    ACTIONS(933), 1,
      anon_sym_and,
    ACTIONS(939), 1,
      anon_sym_PIPE,
    ACTIONS(941), 1,
      anon_sym_TILDE,
    ACTIONS(943), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(935), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(945), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(937), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(985), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(983), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5309] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(931), 1,
      anon_sym_or,
    ACTIONS(933), 1,
      anon_sym_and,
    ACTIONS(939), 1,
      anon_sym_PIPE,
    ACTIONS(941), 1,
      anon_sym_TILDE,
    ACTIONS(943), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(935), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(945), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(937), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(989), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(987), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5394] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    ACTIONS(993), 1,
      anon_sym_or,
    ACTIONS(995), 1,
      anon_sym_and,
    ACTIONS(1001), 1,
      anon_sym_PIPE,
    ACTIONS(1003), 1,
      anon_sym_TILDE,
    ACTIONS(1005), 1,
      anon_sym_AMP,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    STATE(365), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(997), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1007), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(999), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(895), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5483] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    ACTIONS(957), 1,
      anon_sym_or,
    ACTIONS(959), 1,
      anon_sym_and,
    ACTIONS(965), 1,
      anon_sym_PIPE,
    ACTIONS(967), 1,
      anon_sym_TILDE,
    ACTIONS(969), 1,
      anon_sym_AMP,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    STATE(381), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(961), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(971), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(963), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(895), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5572] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 1,
      anon_sym_COMMA,
    ACTIONS(1021), 1,
      anon_sym_or,
    ACTIONS(1023), 1,
      anon_sym_and,
    ACTIONS(1029), 1,
      anon_sym_PIPE,
    ACTIONS(1031), 1,
      anon_sym_TILDE,
    ACTIONS(1033), 1,
      anon_sym_AMP,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    STATE(359), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1025), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1035), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1027), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(861), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(857), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5661] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(907), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5722] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5791] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(907), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5852] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 1,
      anon_sym_COMMA,
    ACTIONS(1021), 1,
      anon_sym_or,
    ACTIONS(1023), 1,
      anon_sym_and,
    ACTIONS(1029), 1,
      anon_sym_PIPE,
    ACTIONS(1031), 1,
      anon_sym_TILDE,
    ACTIONS(1033), 1,
      anon_sym_AMP,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    STATE(378), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1025), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1035), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1027), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5941] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    ACTIONS(993), 1,
      anon_sym_or,
    ACTIONS(995), 1,
      anon_sym_and,
    ACTIONS(1001), 1,
      anon_sym_PIPE,
    ACTIONS(1003), 1,
      anon_sym_TILDE,
    ACTIONS(1005), 1,
      anon_sym_AMP,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    STATE(355), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(997), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1007), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(999), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(861), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(857), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6030] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 1,
      anon_sym_COMMA,
    ACTIONS(1021), 1,
      anon_sym_or,
    ACTIONS(1023), 1,
      anon_sym_and,
    ACTIONS(1029), 1,
      anon_sym_PIPE,
    ACTIONS(1031), 1,
      anon_sym_TILDE,
    ACTIONS(1033), 1,
      anon_sym_AMP,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    STATE(360), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1025), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1035), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1027), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(895), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6119] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 18,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6184] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    ACTIONS(993), 1,
      anon_sym_or,
    ACTIONS(995), 1,
      anon_sym_and,
    ACTIONS(1001), 1,
      anon_sym_PIPE,
    ACTIONS(1003), 1,
      anon_sym_TILDE,
    ACTIONS(1005), 1,
      anon_sym_AMP,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    STATE(379), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(997), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1007), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(999), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6273] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6342] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(945), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6413] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(931), 1,
      anon_sym_or,
    ACTIONS(933), 1,
      anon_sym_and,
    ACTIONS(939), 1,
      anon_sym_PIPE,
    ACTIONS(941), 1,
      anon_sym_TILDE,
    ACTIONS(943), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(935), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(945), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(937), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1049), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1047), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6498] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(933), 1,
      anon_sym_and,
    ACTIONS(939), 1,
      anon_sym_PIPE,
    ACTIONS(941), 1,
      anon_sym_TILDE,
    ACTIONS(943), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(935), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(945), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(937), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6581] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(943), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(945), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6654] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(941), 1,
      anon_sym_TILDE,
    ACTIONS(943), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(945), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6729] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(939), 1,
      anon_sym_PIPE,
    ACTIONS(941), 1,
      anon_sym_TILDE,
    ACTIONS(943), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(945), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 12,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6806] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_CARET,
    ACTIONS(939), 1,
      anon_sym_PIPE,
    ACTIONS(941), 1,
      anon_sym_TILDE,
    ACTIONS(943), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_SLASH,
    ACTIONS(953), 1,
      anon_sym_DOT_DOT,
    ACTIONS(935), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(945), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(947), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(949), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(937), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6887] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 19,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6951] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1029), 1,
      anon_sym_PIPE,
    ACTIONS(1031), 1,
      anon_sym_TILDE,
    ACTIONS(1033), 1,
      anon_sym_AMP,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(1025), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1035), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1027), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 10,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7031] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 19,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7095] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(921), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7153] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(917), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7211] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(907), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7271] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(921), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7397] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(911), 23,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7457] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(907), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7517] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7585] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(907), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7645] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(907), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7705] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7763] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 1,
      anon_sym_AMP,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(971), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7835] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(921), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7893] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(143), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8009] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(917), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8067] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8135] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(971), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 15,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8205] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(1007), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 15,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8275] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1005), 1,
      anon_sym_AMP,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(1007), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8347] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1023), 1,
      anon_sym_and,
    ACTIONS(1029), 1,
      anon_sym_PIPE,
    ACTIONS(1031), 1,
      anon_sym_TILDE,
    ACTIONS(1033), 1,
      anon_sym_AMP,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(1025), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1035), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1027), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 10,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8429] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_TILDE,
    ACTIONS(1005), 1,
      anon_sym_AMP,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(1007), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8503] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_PIPE,
    ACTIONS(1003), 1,
      anon_sym_TILDE,
    ACTIONS(1005), 1,
      anon_sym_AMP,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(1007), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 13,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8579] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(911), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8639] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8707] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1029), 1,
      anon_sym_PIPE,
    ACTIONS(1031), 1,
      anon_sym_TILDE,
    ACTIONS(1033), 1,
      anon_sym_AMP,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(1035), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8783] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_PIPE,
    ACTIONS(1003), 1,
      anon_sym_TILDE,
    ACTIONS(1005), 1,
      anon_sym_AMP,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(997), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1007), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(999), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8863] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(995), 1,
      anon_sym_and,
    ACTIONS(1001), 1,
      anon_sym_PIPE,
    ACTIONS(1003), 1,
      anon_sym_TILDE,
    ACTIONS(1005), 1,
      anon_sym_AMP,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(997), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1007), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(999), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8945] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(917), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9003] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 1,
      anon_sym_or,
    ACTIONS(959), 1,
      anon_sym_and,
    ACTIONS(965), 1,
      anon_sym_PIPE,
    ACTIONS(967), 1,
      anon_sym_TILDE,
    ACTIONS(969), 1,
      anon_sym_AMP,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(961), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(971), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(963), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(915), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9087] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1021), 1,
      anon_sym_or,
    ACTIONS(1023), 1,
      anon_sym_and,
    ACTIONS(1029), 1,
      anon_sym_PIPE,
    ACTIONS(1031), 1,
      anon_sym_TILDE,
    ACTIONS(1033), 1,
      anon_sym_AMP,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(1025), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1035), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1027), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(915), 10,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9171] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1031), 1,
      anon_sym_TILDE,
    ACTIONS(1033), 1,
      anon_sym_AMP,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(1035), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 15,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9245] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(911), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9305] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1033), 1,
      anon_sym_AMP,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(1035), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 15,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9435] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(959), 1,
      anon_sym_and,
    ACTIONS(965), 1,
      anon_sym_PIPE,
    ACTIONS(967), 1,
      anon_sym_TILDE,
    ACTIONS(969), 1,
      anon_sym_AMP,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(961), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(971), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(963), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9517] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 1,
      anon_sym_PIPE,
    ACTIONS(967), 1,
      anon_sym_TILDE,
    ACTIONS(969), 1,
      anon_sym_AMP,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(961), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(971), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(963), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9597] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(1035), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 16,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9667] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 18,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9735] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 20,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9857] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(907), 23,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9917] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(993), 1,
      anon_sym_or,
    ACTIONS(995), 1,
      anon_sym_and,
    ACTIONS(1001), 1,
      anon_sym_PIPE,
    ACTIONS(1003), 1,
      anon_sym_TILDE,
    ACTIONS(1005), 1,
      anon_sym_AMP,
    ACTIONS(1013), 1,
      anon_sym_SLASH,
    ACTIONS(1015), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1017), 1,
      anon_sym_CARET,
    ACTIONS(997), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1007), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1009), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1011), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(999), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(915), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10001] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    ACTIONS(1043), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(1037), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1039), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 18,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10069] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 1,
      anon_sym_PIPE,
    ACTIONS(967), 1,
      anon_sym_TILDE,
    ACTIONS(969), 1,
      anon_sym_AMP,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(971), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 13,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10145] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1045), 1,
      anon_sym_CARET,
    ACTIONS(907), 23,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10263] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(967), 1,
      anon_sym_TILDE,
    ACTIONS(969), 1,
      anon_sym_AMP,
    ACTIONS(977), 1,
      anon_sym_SLASH,
    ACTIONS(979), 1,
      anon_sym_DOT_DOT,
    ACTIONS(981), 1,
      anon_sym_CARET,
    ACTIONS(971), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(973), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(975), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10337] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(143), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(143), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10511] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      anon_sym_or,
    ACTIONS(1053), 1,
      anon_sym_and,
    ACTIONS(1059), 1,
      anon_sym_PIPE,
    ACTIONS(1061), 1,
      anon_sym_TILDE,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1055), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1065), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1057), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1049), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1047), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10594] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1065), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10663] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(911), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10722] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1077), 1,
      anon_sym_or,
    ACTIONS(1079), 1,
      anon_sym_and,
    ACTIONS(1085), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_TILDE,
    ACTIONS(1089), 1,
      anon_sym_AMP,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1081), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1091), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1083), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1049), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1047), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10805] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      anon_sym_or,
    ACTIONS(1105), 1,
      anon_sym_and,
    ACTIONS(1111), 1,
      anon_sym_PIPE,
    ACTIONS(1113), 1,
      anon_sym_TILDE,
    ACTIONS(1115), 1,
      anon_sym_AMP,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1117), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1109), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1049), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1047), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10888] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(907), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10947] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11014] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      anon_sym_or,
    ACTIONS(1053), 1,
      anon_sym_and,
    ACTIONS(1059), 1,
      anon_sym_PIPE,
    ACTIONS(1061), 1,
      anon_sym_TILDE,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1055), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1065), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1057), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(985), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(983), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11097] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1077), 1,
      anon_sym_or,
    ACTIONS(1079), 1,
      anon_sym_and,
    ACTIONS(1085), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_TILDE,
    ACTIONS(1089), 1,
      anon_sym_AMP,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1081), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1091), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1083), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(989), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(987), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11180] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      anon_sym_or,
    ACTIONS(1105), 1,
      anon_sym_and,
    ACTIONS(1111), 1,
      anon_sym_PIPE,
    ACTIONS(1113), 1,
      anon_sym_TILDE,
    ACTIONS(1115), 1,
      anon_sym_AMP,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1117), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1109), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(929), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(927), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11263] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(907), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11322] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 18,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11385] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11452] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_and,
    ACTIONS(1059), 1,
      anon_sym_PIPE,
    ACTIONS(1061), 1,
      anon_sym_TILDE,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1055), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1065), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1057), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11533] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1117), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11602] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(907), 22,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11661] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 1,
      anon_sym_PIPE,
    ACTIONS(1061), 1,
      anon_sym_TILDE,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1055), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1065), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1057), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11740] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 1,
      anon_sym_PIPE,
    ACTIONS(1061), 1,
      anon_sym_TILDE,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1065), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 12,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11815] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      anon_sym_or,
    ACTIONS(1053), 1,
      anon_sym_and,
    ACTIONS(1059), 1,
      anon_sym_PIPE,
    ACTIONS(1061), 1,
      anon_sym_TILDE,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1055), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1065), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1057), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(989), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(987), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11898] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 1,
      anon_sym_AMP,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1117), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11969] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1113), 1,
      anon_sym_TILDE,
    ACTIONS(1115), 1,
      anon_sym_AMP,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1117), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12042] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1061), 1,
      anon_sym_TILDE,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1065), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12115] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1111), 1,
      anon_sym_PIPE,
    ACTIONS(1113), 1,
      anon_sym_TILDE,
    ACTIONS(1115), 1,
      anon_sym_AMP,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1117), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 12,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12190] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      anon_sym_or,
    ACTIONS(1053), 1,
      anon_sym_and,
    ACTIONS(1059), 1,
      anon_sym_PIPE,
    ACTIONS(1061), 1,
      anon_sym_TILDE,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1055), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1065), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1057), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(929), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(927), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12273] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1111), 1,
      anon_sym_PIPE,
    ACTIONS(1113), 1,
      anon_sym_TILDE,
    ACTIONS(1115), 1,
      anon_sym_AMP,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1117), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1109), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12352] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1105), 1,
      anon_sym_and,
    ACTIONS(1111), 1,
      anon_sym_PIPE,
    ACTIONS(1113), 1,
      anon_sym_TILDE,
    ACTIONS(1115), 1,
      anon_sym_AMP,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1117), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1109), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12433] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(911), 22,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12492] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1065), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12563] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1077), 1,
      anon_sym_or,
    ACTIONS(1079), 1,
      anon_sym_and,
    ACTIONS(1085), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_TILDE,
    ACTIONS(1089), 1,
      anon_sym_AMP,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1081), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1091), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1083), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(985), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(983), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12646] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1077), 1,
      anon_sym_or,
    ACTIONS(1079), 1,
      anon_sym_and,
    ACTIONS(1085), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_TILDE,
    ACTIONS(1089), 1,
      anon_sym_AMP,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1081), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1091), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1083), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(929), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(927), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12729] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12796] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(911), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12855] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 18,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12918] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1079), 1,
      anon_sym_and,
    ACTIONS(1085), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_TILDE,
    ACTIONS(1089), 1,
      anon_sym_AMP,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1081), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1091), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1083), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12999] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_TILDE,
    ACTIONS(1089), 1,
      anon_sym_AMP,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1081), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1091), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1083), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13078] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_TILDE,
    ACTIONS(1089), 1,
      anon_sym_AMP,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1091), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 13,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13153] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_TILDE,
    ACTIONS(1089), 1,
      anon_sym_AMP,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1091), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13226] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_AMP,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1091), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 14,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13297] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      anon_sym_or,
    ACTIONS(1105), 1,
      anon_sym_and,
    ACTIONS(1111), 1,
      anon_sym_PIPE,
    ACTIONS(1113), 1,
      anon_sym_TILDE,
    ACTIONS(1115), 1,
      anon_sym_AMP,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1117), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1109), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(985), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(983), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13380] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1091), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 15,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13449] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 17,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13516] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 19,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13579] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      anon_sym_SLASH,
    ACTIONS(1099), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(1093), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1095), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 17,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13646] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(907), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13705] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      anon_sym_or,
    ACTIONS(1105), 1,
      anon_sym_and,
    ACTIONS(1111), 1,
      anon_sym_PIPE,
    ACTIONS(1113), 1,
      anon_sym_TILDE,
    ACTIONS(1115), 1,
      anon_sym_AMP,
    ACTIONS(1123), 1,
      anon_sym_SLASH,
    ACTIONS(1125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1127), 1,
      anon_sym_CARET,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1117), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1119), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1109), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(989), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(987), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13788] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(1067), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13855] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1101), 1,
      anon_sym_CARET,
    ACTIONS(907), 22,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13914] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1075), 1,
      anon_sym_CARET,
    ACTIONS(907), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13973] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1129), 1,
      anon_sym_LBRACK,
    ACTIONS(1131), 1,
      anon_sym_DOT,
    ACTIONS(1133), 1,
      anon_sym_COLON,
    ACTIONS(1135), 1,
      anon_sym_LPAREN,
    ACTIONS(1137), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      sym_string,
    STATE(307), 1,
      sym_arguments,
    STATE(308), 1,
      sym_table,
    ACTIONS(143), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(145), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14038] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(579), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(581), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14085] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(635), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14132] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(360), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(505), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14226] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(236), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14273] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(399), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14320] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(168), 1,
      anon_sym_DOT,
    ACTIONS(170), 5,
      sym_string,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
    ACTIONS(238), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(241), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14371] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(517), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14418] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(577), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14465] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(168), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(170), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14512] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(391), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(513), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14606] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(290), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(292), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(166), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14700] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1143), 1,
      anon_sym_COMMA,
    STATE(316), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1145), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1141), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14747] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1149), 1,
      anon_sym_COMMA,
    STATE(315), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1152), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1147), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14794] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1143), 1,
      anon_sym_COMMA,
    STATE(315), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1156), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1154), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14841] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 1,
      anon_sym_COMMA,
    STATE(318), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(891), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14887] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_COMMA,
    STATE(318), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(915), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1152), 12,
      sym_string,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1147), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14975] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 1,
      anon_sym_COMMA,
    STATE(318), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1163), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1161), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15021] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 1,
      anon_sym_COMMA,
    STATE(318), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1167), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1165), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15067] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_EQ,
    ACTIONS(1173), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1169), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15110] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1175), 1,
      anon_sym_COMMA,
    STATE(350), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1145), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1141), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(903), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [15196] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(905), 4,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
    ACTIONS(907), 21,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15247] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(923), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [15288] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(905), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(907), 27,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [15331] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(905), 4,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
    ACTIONS(907), 21,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15382] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(905), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(907), 27,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [15425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(391), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [15466] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(909), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(911), 27,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [15509] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(899), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [15550] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(905), 4,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
    ACTIONS(907), 19,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
  [15603] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(905), 4,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
    ACTIONS(907), 18,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [15658] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1193), 1,
      anon_sym_SEMI,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(481), 1,
      sym__expression,
    STATE(724), 1,
      sym__empty_statement,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1191), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [15729] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(905), 3,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 18,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [15786] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(905), 3,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(907), 17,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [15845] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1219), 1,
      anon_sym_COMMA,
    STATE(338), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1152), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1147), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15890] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 1,
      anon_sym_else,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
  [15953] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1226), 1,
      anon_sym_COMMA,
    STATE(345), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1145), 12,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1141), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15998] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 1,
      anon_sym_else,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 12,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
  [16063] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(145), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [16104] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1230), 1,
      anon_sym_COMMA,
    STATE(343), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1152), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1147), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16149] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1233), 1,
      anon_sym_COMMA,
    STATE(344), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1152), 12,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1147), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16194] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1226), 1,
      anon_sym_COMMA,
    STATE(344), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1156), 12,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1154), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(399), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [16280] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1236), 1,
      anon_sym_COMMA,
    STATE(343), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1156), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1154), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16325] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1236), 1,
      anon_sym_COMMA,
    STATE(347), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1145), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1141), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16370] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(905), 4,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
    ACTIONS(907), 24,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DOT,
  [16417] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1175), 1,
      anon_sym_COMMA,
    STATE(338), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1156), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1154), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16462] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(919), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [16503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1238), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16543] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1244), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1242), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16583] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1248), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1246), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16623] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(386), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1167), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1165), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1252), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1250), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16707] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(368), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1163), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1161), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16751] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1254), 1,
      anon_sym_LBRACK,
    ACTIONS(1256), 1,
      anon_sym_RBRACE,
    ACTIONS(1258), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(663), 1,
      sym__expression,
    STATE(719), 1,
      sym_field,
    STATE(803), 1,
      sym__field_sequence,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [16823] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 1,
      anon_sym_COMMA,
    STATE(390), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1167), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1165), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16867] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 1,
      anon_sym_COMMA,
    STATE(390), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(891), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16911] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(368), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1167), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1165), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16955] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1254), 1,
      anon_sym_LBRACK,
    ACTIONS(1258), 1,
      sym_identifier,
    ACTIONS(1260), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(663), 1,
      sym__expression,
    STATE(719), 1,
      sym_field,
    STATE(790), 1,
      sym__field_sequence,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [17027] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1264), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1262), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17067] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1266), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17107] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(386), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(891), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17151] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1254), 1,
      anon_sym_LBRACK,
    ACTIONS(1258), 1,
      sym_identifier,
    ACTIONS(1270), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(663), 1,
      sym__expression,
    STATE(719), 1,
      sym_field,
    STATE(859), 1,
      sym__field_sequence,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [17223] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1254), 1,
      anon_sym_LBRACK,
    ACTIONS(1258), 1,
      sym_identifier,
    ACTIONS(1272), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(663), 1,
      sym__expression,
    STATE(719), 1,
      sym_field,
    STATE(804), 1,
      sym__field_sequence,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [17295] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1274), 1,
      anon_sym_COMMA,
    STATE(368), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(915), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1279), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1277), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1281), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17419] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1287), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1285), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1152), 12,
      sym_string,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1147), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17499] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1291), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1289), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1293), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17579] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1297), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17619] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1301), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17659] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1307), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1305), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17699] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 1,
      anon_sym_COMMA,
    STATE(390), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1163), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1161), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17743] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(386), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1163), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1161), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1311), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1309), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17827] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(368), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(891), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17871] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1152), 13,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1147), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17911] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1254), 1,
      anon_sym_LBRACK,
    ACTIONS(1258), 1,
      sym_identifier,
    ACTIONS(1313), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(663), 1,
      sym__expression,
    STATE(719), 1,
      sym_field,
    STATE(873), 1,
      sym__field_sequence,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [17983] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(917), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18063] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      anon_sym_COMMA,
    STATE(386), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(915), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18147] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1152), 12,
      sym_string,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1147), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18187] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1318), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18227] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1322), 1,
      anon_sym_COMMA,
    STATE(390), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(915), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18271] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1254), 1,
      anon_sym_LBRACK,
    ACTIONS(1258), 1,
      sym_identifier,
    ACTIONS(1325), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(663), 1,
      sym__expression,
    STATE(719), 1,
      sym_field,
    STATE(846), 1,
      sym__field_sequence,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [18343] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1327), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18383] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1331), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18423] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1335), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18463] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1339), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1343), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18543] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1254), 1,
      anon_sym_LBRACK,
    ACTIONS(1258), 1,
      sym_identifier,
    ACTIONS(1347), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(663), 1,
      sym__expression,
    STATE(742), 1,
      sym_field,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [18612] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_until,
    ACTIONS(1193), 1,
      anon_sym_SEMI,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(481), 1,
      sym__expression,
    STATE(724), 1,
      sym__empty_statement,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [18681] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1193), 1,
      anon_sym_SEMI,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1349), 1,
      ts_builtin_sym_end,
    STATE(309), 1,
      sym_field_expression,
    STATE(481), 1,
      sym__expression,
    STATE(724), 1,
      sym__empty_statement,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [18750] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1173), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1169), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18791] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1353), 1,
      anon_sym_EQ,
    ACTIONS(1173), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1169), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18832] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(168), 1,
      anon_sym_DOT,
    ACTIONS(1355), 1,
      anon_sym_EQ,
    ACTIONS(238), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(170), 5,
      sym_string,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
    ACTIONS(241), 20,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [18877] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1254), 1,
      anon_sym_LBRACK,
    ACTIONS(1258), 1,
      sym_identifier,
    ACTIONS(1357), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(663), 1,
      sym__expression,
    STATE(742), 1,
      sym_field,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [18946] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_end,
    ACTIONS(1193), 1,
      anon_sym_SEMI,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(481), 1,
      sym__expression,
    STATE(724), 1,
      sym__empty_statement,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [19015] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1359), 1,
      anon_sym_EQ,
    ACTIONS(1173), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1169), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1339), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19094] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1238), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19132] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1281), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1293), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19208] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1248), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1246), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19246] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1252), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1250), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19284] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1291), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1289), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19322] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1293), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1297), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19398] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1301), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19436] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1307), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1305), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19474] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1331), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19512] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1363), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1361), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19550] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1343), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1339), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19626] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(917), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19664] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1335), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19702] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1327), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19740] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1318), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19778] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1264), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1262), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19816] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1287), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1285), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19854] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      anon_sym_else,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(915), 8,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_do,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [19918] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1287), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1285), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19956] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1311), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1309), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19994] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1287), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1285), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1307), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1305), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20070] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1369), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1367), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20108] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1238), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20146] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1371), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1301), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20222] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1318), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20260] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1327), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1335), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20336] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1297), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20374] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1252), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1250), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1331), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1339), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20488] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1244), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1242), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20526] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1318), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20564] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1266), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20602] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1327), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20640] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1248), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1246), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20678] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1264), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1262), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1279), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1277), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20754] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1266), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20792] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1279), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1277), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20830] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1343), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1343), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1377), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1375), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20944] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21020] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1244), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1242), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21058] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1264), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1262), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21096] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1238), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21134] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1252), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1250), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21172] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1266), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21210] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1248), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1246), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21248] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21286] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(917), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(917), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21362] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21400] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1335), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21476] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1281), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1244), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1242), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21552] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1311), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1309), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21590] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1311), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1309), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1279), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1277), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21666] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1281), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21742] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1379), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21780] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1254), 1,
      anon_sym_LBRACK,
    ACTIONS(1258), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(663), 1,
      sym__expression,
    STATE(742), 1,
      sym_field,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21846] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1291), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1289), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21884] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1331), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21922] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1307), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1305), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21960] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1387), 1,
      anon_sym_else,
    ACTIONS(1389), 1,
      anon_sym_SEMI,
    STATE(690), 1,
      aux_sym_return_statement_repeat1,
    STATE(728), 1,
      sym__empty_statement,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1383), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [22032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1301), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [22070] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1297), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [22108] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1293), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [22146] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1291), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1289), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [22184] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1391), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_field_expression,
    STATE(657), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22247] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_field_expression,
    STATE(664), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22310] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_field_expression,
    STATE(662), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22373] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1397), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_field_expression,
    STATE(656), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22436] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1399), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_field_expression,
    STATE(655), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22499] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(242), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22559] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(288), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22619] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(173), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22679] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(256), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22739] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(257), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22799] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(261), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22859] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(262), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22919] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(263), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22979] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(265), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23039] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(270), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23099] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(271), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23159] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(273), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23219] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(275), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23279] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(276), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23339] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(333), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23399] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(148), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23459] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(172), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23519] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(298), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23579] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(296), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23639] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(294), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23699] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(283), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23759] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(281), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23819] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(252), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23879] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(220), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23939] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(198), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23999] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(225), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24059] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(231), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24119] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(233), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24179] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(237), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24239] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(238), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24299] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(239), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24359] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(241), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24419] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(243), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24479] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(245), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24539] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(278), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24599] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(272), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24659] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(268), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24719] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(267), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24779] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(264), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24839] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(253), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24899] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(258), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24959] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(116), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25019] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(177), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25079] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(131), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25139] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(188), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25199] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(269), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25259] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(185), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25319] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(230), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25379] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(329), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25439] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(328), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25499] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(327), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25559] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(277), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25619] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(349), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25679] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(325), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25739] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(176), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25799] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(334), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25859] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(336), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25919] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(337), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25979] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(339), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26039] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(341), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26099] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(178), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26159] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_not,
    ACTIONS(286), 1,
      sym_identifier,
    ACTIONS(1401), 1,
      anon_sym_function,
    STATE(103), 1,
      sym_field_expression,
    STATE(274), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(282), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26219] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(331), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26279] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(672), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26339] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(259), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26399] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(227), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26459] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(226), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26519] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(222), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26579] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(221), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26639] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(219), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26699] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(218), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26759] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(216), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26819] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(197), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26879] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(208), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26939] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(207), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26999] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(206), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27059] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(683), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27119] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(186), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27179] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(284), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27239] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(680), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27299] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(687), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27359] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(285), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27419] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(678), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27479] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(286), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27539] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(677), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27599] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(229), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27659] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(661), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27719] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(180), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27779] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(666), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27839] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(674), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27899] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(290), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27959] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(684), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28019] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(192), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28079] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(196), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28139] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(195), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28199] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(194), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28259] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(193), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28319] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(190), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28379] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(189), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28439] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(187), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28499] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(183), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28559] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(182), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28619] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_not,
    ACTIONS(97), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(15), 1,
      sym_field_expression,
    STATE(181), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(93), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28679] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(163), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28739] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(665), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28799] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(686), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28859] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(291), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28919] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(292), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28979] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(266), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29039] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(668), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29099] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(682), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29159] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(293), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29219] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(297), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29279] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(161), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29339] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(673), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29399] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(658), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29459] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(681), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29519] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(667), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29579] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(235), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29639] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(236), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29699] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(244), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29759] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(247), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29819] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(211), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29879] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(217), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29939] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(224), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29999] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(199), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30059] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(202), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30119] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(203), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30179] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(209), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30239] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(223), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30299] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(280), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30359] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_self,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1401), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_field_expression,
    STATE(232), 1,
      sym__expression,
    ACTIONS(278), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(272), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(276), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(54), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(213), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30419] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(289), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30479] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(174), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30539] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(295), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30599] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(669), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30659] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(660), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30719] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(685), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30779] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(175), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30839] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(279), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30899] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(676), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30959] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1413), 1,
      anon_sym_function,
    ACTIONS(1429), 1,
      anon_sym_not,
    ACTIONS(1431), 1,
      sym_identifier,
    STATE(109), 1,
      sym_field_expression,
    STATE(179), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1427), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31019] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(260), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31079] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(675), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31139] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(154), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31199] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(156), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31259] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(157), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31319] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(159), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31379] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(165), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31439] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(166), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31499] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(168), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31559] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(169), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31619] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(170), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31679] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(171), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31739] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      sym_self,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1417), 1,
      anon_sym_not,
    ACTIONS(1419), 1,
      sym_identifier,
    STATE(15), 1,
      sym_field_expression,
    STATE(158), 1,
      sym__expression,
    ACTIONS(89), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(83), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1415), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(87), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31799] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(671), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31859] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(427), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31919] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      sym_self,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(354), 1,
      anon_sym_not,
    ACTIONS(356), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_function,
    STATE(109), 1,
      sym_field_expression,
    STATE(282), 1,
      sym__expression,
    ACTIONS(348), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(342), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(352), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(346), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(46), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(250), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31979] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(205), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [32039] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(679), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [32099] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(47), 1,
      anon_sym_not,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(107), 1,
      sym_field_expression,
    STATE(287), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(45), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [32159] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      sym_self,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1423), 1,
      anon_sym_not,
    ACTIONS(1425), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(184), 1,
      sym__expression,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(35), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1421), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(39), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(248), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [32219] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(659), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [32279] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_function,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      sym_self,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_not,
    ACTIONS(1213), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(670), 1,
      sym__expression,
    ACTIONS(1205), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1199), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1209), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1203), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(299), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(342), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [32339] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1433), 1,
      anon_sym_RPAREN,
    STATE(762), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32399] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1435), 1,
      anon_sym_RPAREN,
    STATE(737), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32459] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1437), 1,
      anon_sym_RPAREN,
    STATE(763), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32519] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1439), 1,
      anon_sym_do,
    STATE(738), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32579] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1441), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32635] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1443), 1,
      anon_sym_do,
    STATE(755), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32695] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1445), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32751] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1447), 1,
      anon_sym_RPAREN,
    STATE(772), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32811] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1449), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32867] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1451), 1,
      anon_sym_RPAREN,
    STATE(769), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32927] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1453), 1,
      anon_sym_COMMA,
    ACTIONS(1455), 1,
      anon_sym_do,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32984] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1457), 1,
      anon_sym_do,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33038] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1459), 1,
      anon_sym_RBRACK,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33092] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1461), 1,
      anon_sym_then,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33146] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1463), 1,
      anon_sym_RPAREN,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33200] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1465), 1,
      anon_sym_RPAREN,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33254] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1467), 1,
      anon_sym_then,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33308] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1469), 1,
      anon_sym_RBRACK,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33362] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1471), 1,
      anon_sym_RBRACK,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33416] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1473), 1,
      anon_sym_then,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33470] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1475), 1,
      anon_sym_RPAREN,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33524] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1477), 1,
      anon_sym_RBRACK,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33578] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1479), 1,
      anon_sym_then,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33632] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1481), 1,
      anon_sym_COMMA,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33686] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1483), 1,
      anon_sym_RBRACK,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33740] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1485), 1,
      anon_sym_RPAREN,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33794] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1487), 1,
      anon_sym_RPAREN,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33848] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1489), 1,
      anon_sym_RBRACK,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33902] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1491), 1,
      anon_sym_do,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33956] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1493), 1,
      anon_sym_do,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [34010] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1495), 1,
      anon_sym_then,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [34064] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1497), 1,
      anon_sym_do,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [34118] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 1,
      anon_sym_SLASH,
    ACTIONS(1183), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1185), 1,
      anon_sym_CARET,
    ACTIONS(1189), 1,
      anon_sym_AMP,
    ACTIONS(1215), 1,
      anon_sym_TILDE,
    ACTIONS(1217), 1,
      anon_sym_PIPE,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1365), 1,
      anon_sym_or,
    ACTIONS(1499), 1,
      anon_sym_do,
    ACTIONS(1177), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1187), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1222), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1224), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [34172] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      anon_sym_else,
    ACTIONS(1501), 1,
      anon_sym_COMMA,
    STATE(688), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(915), 7,
      ts_builtin_sym_end,
      anon_sym_do,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [34194] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LPAREN,
    ACTIONS(1504), 1,
      sym_self,
    ACTIONS(1506), 1,
      sym_identifier,
    STATE(107), 1,
      sym_field_expression,
    STATE(691), 1,
      sym__variable_declarator,
    ACTIONS(41), 2,
      anon_sym__G,
      anon_sym__VERSION,
    STATE(692), 3,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
  [34222] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1510), 1,
      anon_sym_else,
    ACTIONS(1512), 1,
      anon_sym_SEMI,
    STATE(688), 1,
      aux_sym_return_statement_repeat1,
    STATE(725), 1,
      sym__empty_statement,
    ACTIONS(1508), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [34247] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1514), 2,
      anon_sym_COMMA,
      anon_sym_EQ,
    ACTIONS(141), 6,
      sym_string,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
  [34263] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(362), 1,
      anon_sym_LBRACK,
    ACTIONS(1516), 1,
      anon_sym_DOT,
    ACTIONS(1518), 1,
      anon_sym_COLON,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    ACTIONS(1522), 1,
      sym_string,
    STATE(124), 1,
      sym_arguments,
    STATE(132), 1,
      sym_table,
  [34291] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1524), 1,
      anon_sym_end,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    STATE(781), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34311] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1528), 1,
      anon_sym_end,
    STATE(820), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34331] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1530), 1,
      anon_sym_end,
    STATE(786), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34351] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1532), 1,
      anon_sym_end,
    STATE(832), 1,
      sym_else,
    STATE(708), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34371] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1534), 1,
      anon_sym_end,
    STATE(780), 1,
      sym_else,
    STATE(693), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34391] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1532), 1,
      anon_sym_end,
    STATE(832), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34411] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1536), 1,
      anon_sym_end,
    STATE(908), 1,
      sym_else,
    STATE(711), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34431] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1536), 1,
      anon_sym_end,
    STATE(908), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34451] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    ACTIONS(1540), 1,
      sym_identifier,
    STATE(48), 1,
      sym_parameters,
    STATE(212), 1,
      sym__function_body,
    STATE(740), 1,
      sym_function_name,
    STATE(777), 1,
      sym_function_name_field,
  [34473] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1542), 1,
      anon_sym_end,
    STATE(841), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34493] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1544), 1,
      anon_sym_end,
    STATE(839), 1,
      sym_else,
    STATE(702), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34513] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1544), 1,
      anon_sym_end,
    STATE(839), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34533] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    ACTIONS(1540), 1,
      sym_identifier,
    STATE(80), 1,
      sym_parameters,
    STATE(167), 1,
      sym__function_body,
    STATE(746), 1,
      sym_function_name,
    STATE(777), 1,
      sym_function_name_field,
  [34555] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1530), 1,
      anon_sym_end,
    STATE(786), 1,
      sym_else,
    STATE(707), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34575] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1534), 1,
      anon_sym_end,
    STATE(780), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34595] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1546), 1,
      anon_sym_end,
    STATE(821), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34615] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1546), 1,
      anon_sym_end,
    STATE(821), 1,
      sym_else,
    STATE(694), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34635] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1548), 1,
      anon_sym_end,
    STATE(833), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34655] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1550), 1,
      anon_sym_end,
    STATE(844), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34675] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1548), 1,
      anon_sym_end,
    STATE(833), 1,
      sym_else,
    STATE(704), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34695] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    ACTIONS(1540), 1,
      sym_identifier,
    STATE(68), 1,
      sym_parameters,
    STATE(200), 1,
      sym__function_body,
    STATE(775), 1,
      sym_function_name,
    STATE(777), 1,
      sym_function_name_field,
  [34717] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1552), 1,
      anon_sym_end,
    STATE(902), 1,
      sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34737] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    ACTIONS(1540), 1,
      sym_identifier,
    STATE(53), 1,
      sym_parameters,
    STATE(204), 1,
      sym__function_body,
    STATE(751), 1,
      sym_function_name,
    STATE(777), 1,
      sym_function_name_field,
  [34759] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_else,
    ACTIONS(1526), 1,
      anon_sym_elseif,
    ACTIONS(1552), 1,
      anon_sym_end,
    STATE(902), 1,
      sym_else,
    STATE(700), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34779] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1347), 1,
      anon_sym_RBRACE,
    STATE(403), 1,
      sym__field_sep,
    STATE(722), 1,
      aux_sym__field_sequence_repeat1,
    ACTIONS(1554), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [34796] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      anon_sym_LBRACE,
    ACTIONS(1556), 1,
      anon_sym_LPAREN,
    ACTIONS(1558), 1,
      sym_string,
    STATE(74), 1,
      sym_table,
    STATE(75), 1,
      sym_arguments,
  [34815] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1562), 1,
      anon_sym_RBRACE,
    STATE(397), 1,
      sym__field_sep,
    STATE(717), 1,
      aux_sym__field_sequence_repeat1,
    ACTIONS(1560), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [34832] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(350), 1,
      anon_sym_LBRACE,
    ACTIONS(1564), 1,
      anon_sym_LPAREN,
    ACTIONS(1566), 1,
      sym_string,
    STATE(123), 1,
      sym_table,
    STATE(130), 1,
      sym_arguments,
  [34851] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      anon_sym_LPAREN,
    ACTIONS(1137), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      sym_string,
    STATE(300), 1,
      sym_arguments,
    STATE(308), 1,
      sym_table,
  [34870] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1571), 1,
      anon_sym_RBRACE,
    STATE(477), 1,
      sym__field_sep,
    STATE(722), 1,
      aux_sym__field_sequence_repeat1,
    ACTIONS(1568), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [34887] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(1573), 1,
      anon_sym_LPAREN,
    ACTIONS(1575), 1,
      sym_string,
    STATE(127), 1,
      sym_table,
    STATE(129), 1,
      sym_arguments,
  [34906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1387), 1,
      anon_sym_else,
    ACTIONS(1383), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [34919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1579), 1,
      anon_sym_else,
    ACTIONS(1577), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [34932] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    ACTIONS(1522), 1,
      sym_string,
    STATE(121), 1,
      sym_arguments,
    STATE(132), 1,
      sym_table,
  [34951] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1581), 1,
      anon_sym_end,
    ACTIONS(1583), 1,
      anon_sym_elseif,
    ACTIONS(1586), 1,
      anon_sym_else,
    STATE(727), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [34968] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1510), 1,
      anon_sym_else,
    ACTIONS(1508), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [34981] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1588), 1,
      anon_sym_RPAREN,
    ACTIONS(1590), 1,
      sym_spread,
    ACTIONS(1592), 2,
      sym_self,
      sym_identifier,
  [34995] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1594), 1,
      anon_sym_DOT,
    STATE(730), 1,
      aux_sym_function_name_field_repeat1,
    ACTIONS(1597), 2,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [35009] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1599), 1,
      anon_sym_DOT,
    STATE(730), 1,
      aux_sym_function_name_field_repeat1,
    ACTIONS(1601), 2,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [35023] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1599), 1,
      anon_sym_DOT,
    ACTIONS(1603), 1,
      anon_sym_COLON,
    ACTIONS(1606), 1,
      anon_sym_LPAREN,
    STATE(731), 1,
      aux_sym_function_name_field_repeat1,
  [35039] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1609), 1,
      anon_sym_COMMA,
    ACTIONS(1611), 1,
      anon_sym_EQ,
    ACTIONS(1613), 1,
      anon_sym_in,
    STATE(757), 1,
      aux_sym__local_variable_declarator_repeat1,
  [35055] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1615), 1,
      anon_sym_COMMA,
    STATE(734), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1152), 2,
      anon_sym_in,
      anon_sym_RPAREN,
  [35069] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1618), 1,
      anon_sym_COMMA,
    ACTIONS(1620), 1,
      anon_sym_RPAREN,
    STATE(734), 1,
      aux_sym__local_variable_declarator_repeat1,
  [35082] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 1,
      anon_sym_COMMA,
    ACTIONS(1622), 1,
      anon_sym_EQ,
    STATE(748), 1,
      aux_sym_variable_declaration_repeat1,
  [35095] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1624), 1,
      anon_sym_RPAREN,
    STATE(688), 1,
      aux_sym_return_statement_repeat1,
  [35108] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1443), 1,
      anon_sym_do,
    STATE(688), 1,
      aux_sym_return_statement_repeat1,
  [35121] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 1,
      anon_sym_COMMA,
    ACTIONS(1626), 1,
      anon_sym_EQ,
    STATE(748), 1,
      aux_sym_variable_declaration_repeat1,
  [35134] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(67), 1,
      sym_parameters,
    STATE(448), 1,
      sym__function_body,
  [35147] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1628), 1,
      sym_identifier,
    STATE(880), 1,
      sym__loop_expression,
    STATE(881), 1,
      sym__in_loop_expression,
  [35160] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1571), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [35169] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(68), 1,
      sym_parameters,
    STATE(200), 1,
      sym__function_body,
  [35182] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 1,
      anon_sym_COMMA,
    ACTIONS(1630), 1,
      anon_sym_EQ,
    STATE(748), 1,
      aux_sym_variable_declaration_repeat1,
  [35195] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(92), 1,
      sym_parameters,
    STATE(371), 1,
      sym__function_body,
  [35208] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(92), 1,
      sym_parameters,
    STATE(363), 1,
      sym__function_body,
  [35221] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1632), 1,
      anon_sym_function,
    ACTIONS(1634), 1,
      sym_identifier,
    STATE(401), 1,
      sym__local_variable_declarator,
  [35234] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1636), 1,
      anon_sym_COMMA,
    ACTIONS(1639), 1,
      anon_sym_EQ,
    STATE(748), 1,
      aux_sym_variable_declaration_repeat1,
  [35247] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(67), 1,
      sym_parameters,
    STATE(426), 1,
      sym__function_body,
  [35260] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1641), 1,
      anon_sym_COMMA,
    ACTIONS(1643), 1,
      anon_sym_RPAREN,
    STATE(735), 1,
      aux_sym__local_variable_declarator_repeat1,
  [35273] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(32), 1,
      sym_parameters,
    STATE(425), 1,
      sym__function_body,
  [35286] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1628), 1,
      sym_identifier,
    STATE(888), 1,
      sym__loop_expression,
    STATE(889), 1,
      sym__in_loop_expression,
  [35299] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1645), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [35308] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(48), 1,
      sym_parameters,
    STATE(212), 1,
      sym__function_body,
  [35321] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1647), 1,
      anon_sym_do,
    STATE(688), 1,
      aux_sym_return_statement_repeat1,
  [35334] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1649), 1,
      anon_sym_function,
    ACTIONS(1651), 1,
      sym_identifier,
    STATE(400), 1,
      sym__local_variable_declarator,
  [35347] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1609), 1,
      anon_sym_COMMA,
    ACTIONS(1653), 1,
      anon_sym_in,
    STATE(734), 1,
      aux_sym__local_variable_declarator_repeat1,
  [35360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(162), 1,
      anon_sym_else,
    ACTIONS(1655), 2,
      anon_sym_end,
      anon_sym_elseif,
  [35371] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(53), 1,
      sym_parameters,
    STATE(204), 1,
      sym__function_body,
  [35384] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1628), 1,
      sym_identifier,
    STATE(896), 1,
      sym__loop_expression,
    STATE(897), 1,
      sym__in_loop_expression,
  [35397] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1152), 3,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_RPAREN,
  [35406] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1657), 1,
      anon_sym_RPAREN,
    STATE(688), 1,
      aux_sym_return_statement_repeat1,
  [35419] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1659), 1,
      anon_sym_RPAREN,
    STATE(688), 1,
      aux_sym_return_statement_repeat1,
  [35432] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(80), 1,
      sym_parameters,
    STATE(167), 1,
      sym__function_body,
  [35445] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(98), 1,
      sym_parameters,
    STATE(326), 1,
      sym__function_body,
  [35458] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1663), 1,
      anon_sym_else,
    ACTIONS(1661), 2,
      anon_sym_end,
      anon_sym_elseif,
  [35469] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1665), 1,
      anon_sym_function,
    ACTIONS(1667), 1,
      sym_identifier,
    STATE(322), 1,
      sym__local_variable_declarator,
  [35482] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(32), 1,
      sym_parameters,
    STATE(428), 1,
      sym__function_body,
  [35495] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1669), 1,
      anon_sym_RPAREN,
    STATE(688), 1,
      aux_sym_return_statement_repeat1,
  [35508] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(66), 1,
      sym_parameters,
    STATE(430), 1,
      sym__function_body,
  [35521] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1628), 1,
      sym_identifier,
    STATE(812), 1,
      sym__in_loop_expression,
    STATE(813), 1,
      sym__loop_expression,
  [35534] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 1,
      anon_sym_COMMA,
    ACTIONS(1671), 1,
      anon_sym_RPAREN,
    STATE(688), 1,
      aux_sym_return_statement_repeat1,
  [35547] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 1,
      anon_sym_COMMA,
    ACTIONS(1673), 1,
      anon_sym_EQ,
    STATE(748), 1,
      aux_sym_variable_declaration_repeat1,
  [35560] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1675), 1,
      anon_sym_function,
    ACTIONS(1677), 1,
      sym_identifier,
    STATE(405), 1,
      sym__local_variable_declarator,
  [35573] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_LPAREN,
    STATE(66), 1,
      sym_parameters,
    STATE(458), 1,
      sym__function_body,
  [35586] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1679), 1,
      sym_spread,
    ACTIONS(1681), 1,
      sym_identifier,
  [35596] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1683), 1,
      anon_sym_COLON,
    ACTIONS(1685), 1,
      anon_sym_LPAREN,
  [35606] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1681), 1,
      sym_identifier,
    ACTIONS(1687), 1,
      sym_spread,
  [35616] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1689), 1,
      anon_sym_end,
  [35623] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_end,
  [35630] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1691), 1,
      anon_sym_end,
  [35637] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_end,
  [35644] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1693), 1,
      anon_sym_end,
  [35651] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1695), 1,
      anon_sym_end,
  [35658] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1697), 1,
      anon_sym_end,
  [35665] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1534), 1,
      anon_sym_end,
  [35672] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_end,
  [35679] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1701), 1,
      anon_sym_end,
  [35686] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1703), 1,
      anon_sym_end,
  [35693] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1705), 1,
      anon_sym_RBRACE,
  [35700] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1707), 1,
      sym_identifier,
  [35707] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1709), 1,
      anon_sym_end,
  [35714] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1530), 1,
      anon_sym_end,
  [35721] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1711), 1,
      anon_sym_end,
  [35728] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1713), 1,
      anon_sym_end,
  [35735] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1715), 1,
      anon_sym_until,
  [35742] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1717), 1,
      anon_sym_until,
  [35749] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_end,
  [35756] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1721), 1,
      anon_sym_COLON_COLON,
  [35763] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1723), 1,
      sym_identifier,
  [35770] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1725), 1,
      sym_identifier,
  [35777] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1727), 1,
      sym_identifier,
  [35784] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1729), 1,
      anon_sym_RBRACE,
  [35791] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1731), 1,
      anon_sym_RBRACE,
  [35798] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1733), 1,
      sym_identifier,
  [35805] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1735), 1,
      sym_identifier,
  [35812] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1737), 1,
      anon_sym_COLON_COLON,
  [35819] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1739), 1,
      anon_sym_COLON_COLON,
  [35826] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1741), 1,
      anon_sym_until,
  [35833] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1743), 1,
      sym_identifier,
  [35840] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1745), 1,
      anon_sym_end,
  [35847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1747), 1,
      anon_sym_do,
  [35854] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1749), 1,
      anon_sym_do,
  [35861] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1751), 1,
      anon_sym_until,
  [35868] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1753), 1,
      anon_sym_end,
  [35875] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1755), 1,
      anon_sym_until,
  [35882] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1757), 1,
      anon_sym_end,
  [35889] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1759), 1,
      sym_identifier,
  [35896] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1761), 1,
      sym_identifier,
  [35903] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1763), 1,
      anon_sym_end,
  [35910] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1528), 1,
      anon_sym_end,
  [35917] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1548), 1,
      anon_sym_end,
  [35924] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1765), 1,
      anon_sym_end,
  [35931] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1767), 1,
      anon_sym_end,
  [35938] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1769), 1,
      anon_sym_end,
  [35945] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1771), 1,
      anon_sym_end,
  [35952] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1773), 1,
      anon_sym_end,
  [35959] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1775), 1,
      anon_sym_end,
  [35966] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1777), 1,
      anon_sym_end,
  [35973] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1779), 1,
      sym_identifier,
  [35980] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1781), 1,
      anon_sym_end,
  [35987] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1546), 1,
      anon_sym_end,
  [35994] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1544), 1,
      anon_sym_end,
  [36001] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1783), 1,
      anon_sym_end,
  [36008] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1785), 1,
      sym_identifier,
  [36015] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1787), 1,
      anon_sym_end,
  [36022] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1789), 1,
      anon_sym_end,
  [36029] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1791), 1,
      anon_sym_end,
  [36036] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1542), 1,
      anon_sym_end,
  [36043] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1793), 1,
      anon_sym_end,
  [36050] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1795), 1,
      anon_sym_end,
  [36057] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1797), 1,
      ts_builtin_sym_end,
  [36064] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1799), 1,
      anon_sym_end,
  [36071] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1801), 1,
      anon_sym_end,
  [36078] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1803), 1,
      anon_sym_end,
  [36085] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1805), 1,
      anon_sym_RBRACE,
  [36092] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1807), 1,
      sym_identifier,
  [36099] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1809), 1,
      sym_identifier,
  [36106] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(387), 1,
      ts_builtin_sym_end,
  [36113] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1811), 1,
      sym_identifier,
  [36120] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1813), 1,
      anon_sym_end,
  [36127] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 1,
      ts_builtin_sym_end,
  [36134] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1815), 1,
      sym_identifier,
  [36141] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1817), 1,
      anon_sym_until,
  [36148] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1819), 1,
      anon_sym_end,
  [36155] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1821), 1,
      anon_sym_end,
  [36162] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1823), 1,
      ts_builtin_sym_end,
  [36169] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1825), 1,
      anon_sym_end,
  [36176] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1827), 1,
      anon_sym_RBRACE,
  [36183] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1829), 1,
      anon_sym_end,
  [36190] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1681), 1,
      sym_identifier,
  [36197] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1831), 1,
      anon_sym_end,
  [36204] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1833), 1,
      anon_sym_until,
  [36211] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1835), 1,
      anon_sym_end,
  [36218] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1837), 1,
      sym_identifier,
  [36225] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1839), 1,
      anon_sym_end,
  [36232] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1841), 1,
      sym_identifier,
  [36239] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1843), 1,
      anon_sym_end,
  [36246] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1845), 1,
      sym_identifier,
  [36253] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1847), 1,
      anon_sym_end,
  [36260] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1849), 1,
      sym_identifier,
  [36267] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1851), 1,
      anon_sym_end,
  [36274] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1853), 1,
      anon_sym_RBRACE,
  [36281] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1855), 1,
      anon_sym_end,
  [36288] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1857), 1,
      sym_identifier,
  [36295] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1859), 1,
      anon_sym_COLON_COLON,
  [36302] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1861), 1,
      sym_identifier,
  [36309] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1863), 1,
      anon_sym_until,
  [36316] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1865), 1,
      anon_sym_end,
  [36323] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1867), 1,
      anon_sym_do,
  [36330] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1869), 1,
      anon_sym_do,
  [36337] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1871), 1,
      sym_identifier,
  [36344] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1873), 1,
      sym_identifier,
  [36351] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1875), 1,
      sym_identifier,
  [36358] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1877), 1,
      sym_identifier,
  [36365] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1879), 1,
      sym_identifier,
  [36372] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1881), 1,
      anon_sym_end,
  [36379] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1883), 1,
      anon_sym_do,
  [36386] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1885), 1,
      anon_sym_do,
  [36393] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1552), 1,
      anon_sym_end,
  [36400] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1887), 1,
      sym_identifier,
  [36407] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1889), 1,
      anon_sym_end,
  [36414] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1891), 1,
      sym_identifier,
  [36421] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1893), 1,
      anon_sym_end,
  [36428] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1895), 1,
      anon_sym_end,
  [36435] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1897), 1,
      anon_sym_do,
  [36442] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1899), 1,
      anon_sym_do,
  [36449] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1901), 1,
      anon_sym_LPAREN,
  [36456] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1903), 1,
      anon_sym_end,
  [36463] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1905), 1,
      anon_sym_EQ,
  [36470] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1907), 1,
      anon_sym_end,
  [36477] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1536), 1,
      anon_sym_end,
  [36484] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1909), 1,
      anon_sym_end,
  [36491] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1911), 1,
      anon_sym_end,
  [36498] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1913), 1,
      anon_sym_end,
  [36505] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1915), 1,
      anon_sym_RPAREN,
  [36512] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1917), 1,
      anon_sym_end,
  [36519] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1550), 1,
      anon_sym_end,
  [36526] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1919), 1,
      anon_sym_RPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(99)] = 0,
  [SMALL_STATE(100)] = 114,
  [SMALL_STATE(101)] = 230,
  [SMALL_STATE(102)] = 292,
  [SMALL_STATE(103)] = 358,
  [SMALL_STATE(104)] = 420,
  [SMALL_STATE(105)] = 486,
  [SMALL_STATE(106)] = 548,
  [SMALL_STATE(107)] = 662,
  [SMALL_STATE(108)] = 724,
  [SMALL_STATE(109)] = 790,
  [SMALL_STATE(110)] = 852,
  [SMALL_STATE(111)] = 914,
  [SMALL_STATE(112)] = 980,
  [SMALL_STATE(113)] = 1042,
  [SMALL_STATE(114)] = 1104,
  [SMALL_STATE(115)] = 1166,
  [SMALL_STATE(116)] = 1227,
  [SMALL_STATE(117)] = 1318,
  [SMALL_STATE(118)] = 1379,
  [SMALL_STATE(119)] = 1440,
  [SMALL_STATE(120)] = 1501,
  [SMALL_STATE(121)] = 1562,
  [SMALL_STATE(122)] = 1623,
  [SMALL_STATE(123)] = 1688,
  [SMALL_STATE(124)] = 1749,
  [SMALL_STATE(125)] = 1810,
  [SMALL_STATE(126)] = 1875,
  [SMALL_STATE(127)] = 1936,
  [SMALL_STATE(128)] = 1997,
  [SMALL_STATE(129)] = 2058,
  [SMALL_STATE(130)] = 2119,
  [SMALL_STATE(131)] = 2180,
  [SMALL_STATE(132)] = 2271,
  [SMALL_STATE(133)] = 2332,
  [SMALL_STATE(134)] = 2393,
  [SMALL_STATE(135)] = 2458,
  [SMALL_STATE(136)] = 2519,
  [SMALL_STATE(137)] = 2580,
  [SMALL_STATE(138)] = 2641,
  [SMALL_STATE(139)] = 2702,
  [SMALL_STATE(140)] = 2763,
  [SMALL_STATE(141)] = 2824,
  [SMALL_STATE(142)] = 2885,
  [SMALL_STATE(143)] = 2946,
  [SMALL_STATE(144)] = 3007,
  [SMALL_STATE(145)] = 3068,
  [SMALL_STATE(146)] = 3129,
  [SMALL_STATE(147)] = 3190,
  [SMALL_STATE(148)] = 3251,
  [SMALL_STATE(149)] = 3342,
  [SMALL_STATE(150)] = 3403,
  [SMALL_STATE(151)] = 3464,
  [SMALL_STATE(152)] = 3524,
  [SMALL_STATE(153)] = 3584,
  [SMALL_STATE(154)] = 3644,
  [SMALL_STATE(155)] = 3728,
  [SMALL_STATE(156)] = 3792,
  [SMALL_STATE(157)] = 3874,
  [SMALL_STATE(158)] = 3952,
  [SMALL_STATE(159)] = 4014,
  [SMALL_STATE(160)] = 4090,
  [SMALL_STATE(161)] = 4154,
  [SMALL_STATE(162)] = 4216,
  [SMALL_STATE(163)] = 4280,
  [SMALL_STATE(164)] = 4366,
  [SMALL_STATE(165)] = 4426,
  [SMALL_STATE(166)] = 4500,
  [SMALL_STATE(167)] = 4572,
  [SMALL_STATE(168)] = 4632,
  [SMALL_STATE(169)] = 4702,
  [SMALL_STATE(170)] = 4768,
  [SMALL_STATE(171)] = 4830,
  [SMALL_STATE(172)] = 4900,
  [SMALL_STATE(173)] = 4961,
  [SMALL_STATE(174)] = 5046,
  [SMALL_STATE(175)] = 5135,
  [SMALL_STATE(176)] = 5224,
  [SMALL_STATE(177)] = 5309,
  [SMALL_STATE(178)] = 5394,
  [SMALL_STATE(179)] = 5483,
  [SMALL_STATE(180)] = 5572,
  [SMALL_STATE(181)] = 5661,
  [SMALL_STATE(182)] = 5722,
  [SMALL_STATE(183)] = 5791,
  [SMALL_STATE(184)] = 5852,
  [SMALL_STATE(185)] = 5941,
  [SMALL_STATE(186)] = 6030,
  [SMALL_STATE(187)] = 6119,
  [SMALL_STATE(188)] = 6184,
  [SMALL_STATE(189)] = 6273,
  [SMALL_STATE(190)] = 6342,
  [SMALL_STATE(191)] = 6413,
  [SMALL_STATE(192)] = 6498,
  [SMALL_STATE(193)] = 6581,
  [SMALL_STATE(194)] = 6654,
  [SMALL_STATE(195)] = 6729,
  [SMALL_STATE(196)] = 6806,
  [SMALL_STATE(197)] = 6887,
  [SMALL_STATE(198)] = 6951,
  [SMALL_STATE(199)] = 7031,
  [SMALL_STATE(200)] = 7095,
  [SMALL_STATE(201)] = 7153,
  [SMALL_STATE(202)] = 7211,
  [SMALL_STATE(203)] = 7271,
  [SMALL_STATE(204)] = 7339,
  [SMALL_STATE(205)] = 7397,
  [SMALL_STATE(206)] = 7457,
  [SMALL_STATE(207)] = 7517,
  [SMALL_STATE(208)] = 7585,
  [SMALL_STATE(209)] = 7645,
  [SMALL_STATE(210)] = 7705,
  [SMALL_STATE(211)] = 7763,
  [SMALL_STATE(212)] = 7835,
  [SMALL_STATE(213)] = 7893,
  [SMALL_STATE(214)] = 7951,
  [SMALL_STATE(215)] = 8009,
  [SMALL_STATE(216)] = 8067,
  [SMALL_STATE(217)] = 8135,
  [SMALL_STATE(218)] = 8205,
  [SMALL_STATE(219)] = 8275,
  [SMALL_STATE(220)] = 8347,
  [SMALL_STATE(221)] = 8429,
  [SMALL_STATE(222)] = 8503,
  [SMALL_STATE(223)] = 8579,
  [SMALL_STATE(224)] = 8639,
  [SMALL_STATE(225)] = 8707,
  [SMALL_STATE(226)] = 8783,
  [SMALL_STATE(227)] = 8863,
  [SMALL_STATE(228)] = 8945,
  [SMALL_STATE(229)] = 9003,
  [SMALL_STATE(230)] = 9087,
  [SMALL_STATE(231)] = 9171,
  [SMALL_STATE(232)] = 9245,
  [SMALL_STATE(233)] = 9305,
  [SMALL_STATE(234)] = 9377,
  [SMALL_STATE(235)] = 9435,
  [SMALL_STATE(236)] = 9517,
  [SMALL_STATE(237)] = 9597,
  [SMALL_STATE(238)] = 9667,
  [SMALL_STATE(239)] = 9735,
  [SMALL_STATE(240)] = 9799,
  [SMALL_STATE(241)] = 9857,
  [SMALL_STATE(242)] = 9917,
  [SMALL_STATE(243)] = 10001,
  [SMALL_STATE(244)] = 10069,
  [SMALL_STATE(245)] = 10145,
  [SMALL_STATE(246)] = 10205,
  [SMALL_STATE(247)] = 10263,
  [SMALL_STATE(248)] = 10337,
  [SMALL_STATE(249)] = 10395,
  [SMALL_STATE(250)] = 10453,
  [SMALL_STATE(251)] = 10511,
  [SMALL_STATE(252)] = 10594,
  [SMALL_STATE(253)] = 10663,
  [SMALL_STATE(254)] = 10722,
  [SMALL_STATE(255)] = 10805,
  [SMALL_STATE(256)] = 10888,
  [SMALL_STATE(257)] = 10947,
  [SMALL_STATE(258)] = 11014,
  [SMALL_STATE(259)] = 11097,
  [SMALL_STATE(260)] = 11180,
  [SMALL_STATE(261)] = 11263,
  [SMALL_STATE(262)] = 11322,
  [SMALL_STATE(263)] = 11385,
  [SMALL_STATE(264)] = 11452,
  [SMALL_STATE(265)] = 11533,
  [SMALL_STATE(266)] = 11602,
  [SMALL_STATE(267)] = 11661,
  [SMALL_STATE(268)] = 11740,
  [SMALL_STATE(269)] = 11815,
  [SMALL_STATE(270)] = 11898,
  [SMALL_STATE(271)] = 11969,
  [SMALL_STATE(272)] = 12042,
  [SMALL_STATE(273)] = 12115,
  [SMALL_STATE(274)] = 12190,
  [SMALL_STATE(275)] = 12273,
  [SMALL_STATE(276)] = 12352,
  [SMALL_STATE(277)] = 12433,
  [SMALL_STATE(278)] = 12492,
  [SMALL_STATE(279)] = 12563,
  [SMALL_STATE(280)] = 12646,
  [SMALL_STATE(281)] = 12729,
  [SMALL_STATE(282)] = 12796,
  [SMALL_STATE(283)] = 12855,
  [SMALL_STATE(284)] = 12918,
  [SMALL_STATE(285)] = 12999,
  [SMALL_STATE(286)] = 13078,
  [SMALL_STATE(287)] = 13153,
  [SMALL_STATE(288)] = 13226,
  [SMALL_STATE(289)] = 13297,
  [SMALL_STATE(290)] = 13380,
  [SMALL_STATE(291)] = 13449,
  [SMALL_STATE(292)] = 13516,
  [SMALL_STATE(293)] = 13579,
  [SMALL_STATE(294)] = 13646,
  [SMALL_STATE(295)] = 13705,
  [SMALL_STATE(296)] = 13788,
  [SMALL_STATE(297)] = 13855,
  [SMALL_STATE(298)] = 13914,
  [SMALL_STATE(299)] = 13973,
  [SMALL_STATE(300)] = 14038,
  [SMALL_STATE(301)] = 14085,
  [SMALL_STATE(302)] = 14132,
  [SMALL_STATE(303)] = 14179,
  [SMALL_STATE(304)] = 14226,
  [SMALL_STATE(305)] = 14273,
  [SMALL_STATE(306)] = 14320,
  [SMALL_STATE(307)] = 14371,
  [SMALL_STATE(308)] = 14418,
  [SMALL_STATE(309)] = 14465,
  [SMALL_STATE(310)] = 14512,
  [SMALL_STATE(311)] = 14559,
  [SMALL_STATE(312)] = 14606,
  [SMALL_STATE(313)] = 14653,
  [SMALL_STATE(314)] = 14700,
  [SMALL_STATE(315)] = 14747,
  [SMALL_STATE(316)] = 14794,
  [SMALL_STATE(317)] = 14841,
  [SMALL_STATE(318)] = 14887,
  [SMALL_STATE(319)] = 14933,
  [SMALL_STATE(320)] = 14975,
  [SMALL_STATE(321)] = 15021,
  [SMALL_STATE(322)] = 15067,
  [SMALL_STATE(323)] = 15110,
  [SMALL_STATE(324)] = 15155,
  [SMALL_STATE(325)] = 15196,
  [SMALL_STATE(326)] = 15247,
  [SMALL_STATE(327)] = 15288,
  [SMALL_STATE(328)] = 15331,
  [SMALL_STATE(329)] = 15382,
  [SMALL_STATE(330)] = 15425,
  [SMALL_STATE(331)] = 15466,
  [SMALL_STATE(332)] = 15509,
  [SMALL_STATE(333)] = 15550,
  [SMALL_STATE(334)] = 15603,
  [SMALL_STATE(335)] = 15658,
  [SMALL_STATE(336)] = 15729,
  [SMALL_STATE(337)] = 15786,
  [SMALL_STATE(338)] = 15845,
  [SMALL_STATE(339)] = 15890,
  [SMALL_STATE(340)] = 15953,
  [SMALL_STATE(341)] = 15998,
  [SMALL_STATE(342)] = 16063,
  [SMALL_STATE(343)] = 16104,
  [SMALL_STATE(344)] = 16149,
  [SMALL_STATE(345)] = 16194,
  [SMALL_STATE(346)] = 16239,
  [SMALL_STATE(347)] = 16280,
  [SMALL_STATE(348)] = 16325,
  [SMALL_STATE(349)] = 16370,
  [SMALL_STATE(350)] = 16417,
  [SMALL_STATE(351)] = 16462,
  [SMALL_STATE(352)] = 16503,
  [SMALL_STATE(353)] = 16543,
  [SMALL_STATE(354)] = 16583,
  [SMALL_STATE(355)] = 16623,
  [SMALL_STATE(356)] = 16667,
  [SMALL_STATE(357)] = 16707,
  [SMALL_STATE(358)] = 16751,
  [SMALL_STATE(359)] = 16823,
  [SMALL_STATE(360)] = 16867,
  [SMALL_STATE(361)] = 16911,
  [SMALL_STATE(362)] = 16955,
  [SMALL_STATE(363)] = 17027,
  [SMALL_STATE(364)] = 17067,
  [SMALL_STATE(365)] = 17107,
  [SMALL_STATE(366)] = 17151,
  [SMALL_STATE(367)] = 17223,
  [SMALL_STATE(368)] = 17295,
  [SMALL_STATE(369)] = 17339,
  [SMALL_STATE(370)] = 17379,
  [SMALL_STATE(371)] = 17419,
  [SMALL_STATE(372)] = 17459,
  [SMALL_STATE(373)] = 17499,
  [SMALL_STATE(374)] = 17539,
  [SMALL_STATE(375)] = 17579,
  [SMALL_STATE(376)] = 17619,
  [SMALL_STATE(377)] = 17659,
  [SMALL_STATE(378)] = 17699,
  [SMALL_STATE(379)] = 17743,
  [SMALL_STATE(380)] = 17787,
  [SMALL_STATE(381)] = 17827,
  [SMALL_STATE(382)] = 17871,
  [SMALL_STATE(383)] = 17911,
  [SMALL_STATE(384)] = 17983,
  [SMALL_STATE(385)] = 18023,
  [SMALL_STATE(386)] = 18063,
  [SMALL_STATE(387)] = 18107,
  [SMALL_STATE(388)] = 18147,
  [SMALL_STATE(389)] = 18187,
  [SMALL_STATE(390)] = 18227,
  [SMALL_STATE(391)] = 18271,
  [SMALL_STATE(392)] = 18343,
  [SMALL_STATE(393)] = 18383,
  [SMALL_STATE(394)] = 18423,
  [SMALL_STATE(395)] = 18463,
  [SMALL_STATE(396)] = 18503,
  [SMALL_STATE(397)] = 18543,
  [SMALL_STATE(398)] = 18612,
  [SMALL_STATE(399)] = 18681,
  [SMALL_STATE(400)] = 18750,
  [SMALL_STATE(401)] = 18791,
  [SMALL_STATE(402)] = 18832,
  [SMALL_STATE(403)] = 18877,
  [SMALL_STATE(404)] = 18946,
  [SMALL_STATE(405)] = 19015,
  [SMALL_STATE(406)] = 19056,
  [SMALL_STATE(407)] = 19094,
  [SMALL_STATE(408)] = 19132,
  [SMALL_STATE(409)] = 19170,
  [SMALL_STATE(410)] = 19208,
  [SMALL_STATE(411)] = 19246,
  [SMALL_STATE(412)] = 19284,
  [SMALL_STATE(413)] = 19322,
  [SMALL_STATE(414)] = 19360,
  [SMALL_STATE(415)] = 19398,
  [SMALL_STATE(416)] = 19436,
  [SMALL_STATE(417)] = 19474,
  [SMALL_STATE(418)] = 19512,
  [SMALL_STATE(419)] = 19550,
  [SMALL_STATE(420)] = 19588,
  [SMALL_STATE(421)] = 19626,
  [SMALL_STATE(422)] = 19664,
  [SMALL_STATE(423)] = 19702,
  [SMALL_STATE(424)] = 19740,
  [SMALL_STATE(425)] = 19778,
  [SMALL_STATE(426)] = 19816,
  [SMALL_STATE(427)] = 19854,
  [SMALL_STATE(428)] = 19918,
  [SMALL_STATE(429)] = 19956,
  [SMALL_STATE(430)] = 19994,
  [SMALL_STATE(431)] = 20032,
  [SMALL_STATE(432)] = 20070,
  [SMALL_STATE(433)] = 20108,
  [SMALL_STATE(434)] = 20146,
  [SMALL_STATE(435)] = 20184,
  [SMALL_STATE(436)] = 20222,
  [SMALL_STATE(437)] = 20260,
  [SMALL_STATE(438)] = 20298,
  [SMALL_STATE(439)] = 20336,
  [SMALL_STATE(440)] = 20374,
  [SMALL_STATE(441)] = 20412,
  [SMALL_STATE(442)] = 20450,
  [SMALL_STATE(443)] = 20488,
  [SMALL_STATE(444)] = 20526,
  [SMALL_STATE(445)] = 20564,
  [SMALL_STATE(446)] = 20602,
  [SMALL_STATE(447)] = 20640,
  [SMALL_STATE(448)] = 20678,
  [SMALL_STATE(449)] = 20716,
  [SMALL_STATE(450)] = 20754,
  [SMALL_STATE(451)] = 20792,
  [SMALL_STATE(452)] = 20830,
  [SMALL_STATE(453)] = 20868,
  [SMALL_STATE(454)] = 20906,
  [SMALL_STATE(455)] = 20944,
  [SMALL_STATE(456)] = 20982,
  [SMALL_STATE(457)] = 21020,
  [SMALL_STATE(458)] = 21058,
  [SMALL_STATE(459)] = 21096,
  [SMALL_STATE(460)] = 21134,
  [SMALL_STATE(461)] = 21172,
  [SMALL_STATE(462)] = 21210,
  [SMALL_STATE(463)] = 21248,
  [SMALL_STATE(464)] = 21286,
  [SMALL_STATE(465)] = 21324,
  [SMALL_STATE(466)] = 21362,
  [SMALL_STATE(467)] = 21400,
  [SMALL_STATE(468)] = 21438,
  [SMALL_STATE(469)] = 21476,
  [SMALL_STATE(470)] = 21514,
  [SMALL_STATE(471)] = 21552,
  [SMALL_STATE(472)] = 21590,
  [SMALL_STATE(473)] = 21628,
  [SMALL_STATE(474)] = 21666,
  [SMALL_STATE(475)] = 21704,
  [SMALL_STATE(476)] = 21742,
  [SMALL_STATE(477)] = 21780,
  [SMALL_STATE(478)] = 21846,
  [SMALL_STATE(479)] = 21884,
  [SMALL_STATE(480)] = 21922,
  [SMALL_STATE(481)] = 21960,
  [SMALL_STATE(482)] = 22032,
  [SMALL_STATE(483)] = 22070,
  [SMALL_STATE(484)] = 22108,
  [SMALL_STATE(485)] = 22146,
  [SMALL_STATE(486)] = 22184,
  [SMALL_STATE(487)] = 22247,
  [SMALL_STATE(488)] = 22310,
  [SMALL_STATE(489)] = 22373,
  [SMALL_STATE(490)] = 22436,
  [SMALL_STATE(491)] = 22499,
  [SMALL_STATE(492)] = 22559,
  [SMALL_STATE(493)] = 22619,
  [SMALL_STATE(494)] = 22679,
  [SMALL_STATE(495)] = 22739,
  [SMALL_STATE(496)] = 22799,
  [SMALL_STATE(497)] = 22859,
  [SMALL_STATE(498)] = 22919,
  [SMALL_STATE(499)] = 22979,
  [SMALL_STATE(500)] = 23039,
  [SMALL_STATE(501)] = 23099,
  [SMALL_STATE(502)] = 23159,
  [SMALL_STATE(503)] = 23219,
  [SMALL_STATE(504)] = 23279,
  [SMALL_STATE(505)] = 23339,
  [SMALL_STATE(506)] = 23399,
  [SMALL_STATE(507)] = 23459,
  [SMALL_STATE(508)] = 23519,
  [SMALL_STATE(509)] = 23579,
  [SMALL_STATE(510)] = 23639,
  [SMALL_STATE(511)] = 23699,
  [SMALL_STATE(512)] = 23759,
  [SMALL_STATE(513)] = 23819,
  [SMALL_STATE(514)] = 23879,
  [SMALL_STATE(515)] = 23939,
  [SMALL_STATE(516)] = 23999,
  [SMALL_STATE(517)] = 24059,
  [SMALL_STATE(518)] = 24119,
  [SMALL_STATE(519)] = 24179,
  [SMALL_STATE(520)] = 24239,
  [SMALL_STATE(521)] = 24299,
  [SMALL_STATE(522)] = 24359,
  [SMALL_STATE(523)] = 24419,
  [SMALL_STATE(524)] = 24479,
  [SMALL_STATE(525)] = 24539,
  [SMALL_STATE(526)] = 24599,
  [SMALL_STATE(527)] = 24659,
  [SMALL_STATE(528)] = 24719,
  [SMALL_STATE(529)] = 24779,
  [SMALL_STATE(530)] = 24839,
  [SMALL_STATE(531)] = 24899,
  [SMALL_STATE(532)] = 24959,
  [SMALL_STATE(533)] = 25019,
  [SMALL_STATE(534)] = 25079,
  [SMALL_STATE(535)] = 25139,
  [SMALL_STATE(536)] = 25199,
  [SMALL_STATE(537)] = 25259,
  [SMALL_STATE(538)] = 25319,
  [SMALL_STATE(539)] = 25379,
  [SMALL_STATE(540)] = 25439,
  [SMALL_STATE(541)] = 25499,
  [SMALL_STATE(542)] = 25559,
  [SMALL_STATE(543)] = 25619,
  [SMALL_STATE(544)] = 25679,
  [SMALL_STATE(545)] = 25739,
  [SMALL_STATE(546)] = 25799,
  [SMALL_STATE(547)] = 25859,
  [SMALL_STATE(548)] = 25919,
  [SMALL_STATE(549)] = 25979,
  [SMALL_STATE(550)] = 26039,
  [SMALL_STATE(551)] = 26099,
  [SMALL_STATE(552)] = 26159,
  [SMALL_STATE(553)] = 26219,
  [SMALL_STATE(554)] = 26279,
  [SMALL_STATE(555)] = 26339,
  [SMALL_STATE(556)] = 26399,
  [SMALL_STATE(557)] = 26459,
  [SMALL_STATE(558)] = 26519,
  [SMALL_STATE(559)] = 26579,
  [SMALL_STATE(560)] = 26639,
  [SMALL_STATE(561)] = 26699,
  [SMALL_STATE(562)] = 26759,
  [SMALL_STATE(563)] = 26819,
  [SMALL_STATE(564)] = 26879,
  [SMALL_STATE(565)] = 26939,
  [SMALL_STATE(566)] = 26999,
  [SMALL_STATE(567)] = 27059,
  [SMALL_STATE(568)] = 27119,
  [SMALL_STATE(569)] = 27179,
  [SMALL_STATE(570)] = 27239,
  [SMALL_STATE(571)] = 27299,
  [SMALL_STATE(572)] = 27359,
  [SMALL_STATE(573)] = 27419,
  [SMALL_STATE(574)] = 27479,
  [SMALL_STATE(575)] = 27539,
  [SMALL_STATE(576)] = 27599,
  [SMALL_STATE(577)] = 27659,
  [SMALL_STATE(578)] = 27719,
  [SMALL_STATE(579)] = 27779,
  [SMALL_STATE(580)] = 27839,
  [SMALL_STATE(581)] = 27899,
  [SMALL_STATE(582)] = 27959,
  [SMALL_STATE(583)] = 28019,
  [SMALL_STATE(584)] = 28079,
  [SMALL_STATE(585)] = 28139,
  [SMALL_STATE(586)] = 28199,
  [SMALL_STATE(587)] = 28259,
  [SMALL_STATE(588)] = 28319,
  [SMALL_STATE(589)] = 28379,
  [SMALL_STATE(590)] = 28439,
  [SMALL_STATE(591)] = 28499,
  [SMALL_STATE(592)] = 28559,
  [SMALL_STATE(593)] = 28619,
  [SMALL_STATE(594)] = 28679,
  [SMALL_STATE(595)] = 28739,
  [SMALL_STATE(596)] = 28799,
  [SMALL_STATE(597)] = 28859,
  [SMALL_STATE(598)] = 28919,
  [SMALL_STATE(599)] = 28979,
  [SMALL_STATE(600)] = 29039,
  [SMALL_STATE(601)] = 29099,
  [SMALL_STATE(602)] = 29159,
  [SMALL_STATE(603)] = 29219,
  [SMALL_STATE(604)] = 29279,
  [SMALL_STATE(605)] = 29339,
  [SMALL_STATE(606)] = 29399,
  [SMALL_STATE(607)] = 29459,
  [SMALL_STATE(608)] = 29519,
  [SMALL_STATE(609)] = 29579,
  [SMALL_STATE(610)] = 29639,
  [SMALL_STATE(611)] = 29699,
  [SMALL_STATE(612)] = 29759,
  [SMALL_STATE(613)] = 29819,
  [SMALL_STATE(614)] = 29879,
  [SMALL_STATE(615)] = 29939,
  [SMALL_STATE(616)] = 29999,
  [SMALL_STATE(617)] = 30059,
  [SMALL_STATE(618)] = 30119,
  [SMALL_STATE(619)] = 30179,
  [SMALL_STATE(620)] = 30239,
  [SMALL_STATE(621)] = 30299,
  [SMALL_STATE(622)] = 30359,
  [SMALL_STATE(623)] = 30419,
  [SMALL_STATE(624)] = 30479,
  [SMALL_STATE(625)] = 30539,
  [SMALL_STATE(626)] = 30599,
  [SMALL_STATE(627)] = 30659,
  [SMALL_STATE(628)] = 30719,
  [SMALL_STATE(629)] = 30779,
  [SMALL_STATE(630)] = 30839,
  [SMALL_STATE(631)] = 30899,
  [SMALL_STATE(632)] = 30959,
  [SMALL_STATE(633)] = 31019,
  [SMALL_STATE(634)] = 31079,
  [SMALL_STATE(635)] = 31139,
  [SMALL_STATE(636)] = 31199,
  [SMALL_STATE(637)] = 31259,
  [SMALL_STATE(638)] = 31319,
  [SMALL_STATE(639)] = 31379,
  [SMALL_STATE(640)] = 31439,
  [SMALL_STATE(641)] = 31499,
  [SMALL_STATE(642)] = 31559,
  [SMALL_STATE(643)] = 31619,
  [SMALL_STATE(644)] = 31679,
  [SMALL_STATE(645)] = 31739,
  [SMALL_STATE(646)] = 31799,
  [SMALL_STATE(647)] = 31859,
  [SMALL_STATE(648)] = 31919,
  [SMALL_STATE(649)] = 31979,
  [SMALL_STATE(650)] = 32039,
  [SMALL_STATE(651)] = 32099,
  [SMALL_STATE(652)] = 32159,
  [SMALL_STATE(653)] = 32219,
  [SMALL_STATE(654)] = 32279,
  [SMALL_STATE(655)] = 32339,
  [SMALL_STATE(656)] = 32399,
  [SMALL_STATE(657)] = 32459,
  [SMALL_STATE(658)] = 32519,
  [SMALL_STATE(659)] = 32579,
  [SMALL_STATE(660)] = 32635,
  [SMALL_STATE(661)] = 32695,
  [SMALL_STATE(662)] = 32751,
  [SMALL_STATE(663)] = 32811,
  [SMALL_STATE(664)] = 32867,
  [SMALL_STATE(665)] = 32927,
  [SMALL_STATE(666)] = 32984,
  [SMALL_STATE(667)] = 33038,
  [SMALL_STATE(668)] = 33092,
  [SMALL_STATE(669)] =