#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 4199
#define LARGE_STATE_COUNT 158
#define SYMBOL_COUNT 167
#define ALIAS_COUNT 0
#define TOKEN_COUNT 104
#define EXTERNAL_TOKEN_COUNT 15
#define FIELD_COUNT 19
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 75

enum {
  sym_word = 1,
  anon_sym_LF = 2,
  anon_sym_for = 3,
  anon_sym_select = 4,
  anon_sym_in = 5,
  anon_sym_LPAREN_LPAREN = 6,
  anon_sym_RPAREN_RPAREN = 7,
  anon_sym_SEMI = 8,
  anon_sym_while = 9,
  anon_sym_until = 10,
  anon_sym_do = 11,
  anon_sym_done = 12,
  anon_sym_if = 13,
  anon_sym_then = 14,
  anon_sym_fi = 15,
  anon_sym_elif = 16,
  anon_sym_else = 17,
  anon_sym_case = 18,
  anon_sym_esac = 19,
  anon_sym_PIPE = 20,
  anon_sym_RPAREN = 21,
  anon_sym_SEMI_SEMI = 22,
  anon_sym_SEMI_AMP = 23,
  anon_sym_SEMI_SEMI_AMP = 24,
  anon_sym_function = 25,
  anon_sym_LPAREN = 26,
  anon_sym_LBRACE = 27,
  anon_sym_RBRACE = 28,
  anon_sym_PIPE_AMP = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_BANG = 32,
  anon_sym_LBRACK = 33,
  anon_sym_RBRACK = 34,
  anon_sym_LBRACK_LBRACK = 35,
  anon_sym_RBRACK_RBRACK = 36,
  anon_sym_declare = 37,
  anon_sym_typeset = 38,
  anon_sym_export = 39,
  anon_sym_readonly = 40,
  anon_sym_local = 41,
  anon_sym_unset = 42,
  anon_sym_unsetenv = 43,
  anon_sym_EQ_TILDE = 44,
  anon_sym_EQ_EQ = 45,
  anon_sym_EQ = 46,
  anon_sym_PLUS_EQ = 47,
  anon_sym_LT = 48,
  anon_sym_GT = 49,
  anon_sym_GT_GT = 50,
  anon_sym_AMP_GT = 51,
  anon_sym_AMP_GT_GT = 52,
  anon_sym_LT_AMP = 53,
  anon_sym_GT_AMP = 54,
  anon_sym_GT_PIPE = 55,
  anon_sym_LT_LT = 56,
  anon_sym_LT_LT_DASH = 57,
  anon_sym_LT_LT_LT = 58,
  anon_sym_BANG_EQ = 59,
  anon_sym_PLUS = 60,
  anon_sym_DASH = 61,
  anon_sym_DASH_EQ = 62,
  anon_sym_LT_EQ = 63,
  anon_sym_GT_EQ = 64,
  anon_sym_QMARK = 65,
  anon_sym_COLON = 66,
  anon_sym_PLUS_PLUS = 67,
  anon_sym_DASH_DASH = 68,
  anon_sym_DOLLAR = 69,
  sym__special_character = 70,
  anon_sym_DQUOTE = 71,
  sym__string_content = 72,
  sym_raw_string = 73,
  sym_ansii_c_string = 74,
  anon_sym_POUND = 75,
  aux_sym_expansion_flags_token1 = 76,
  anon_sym_DOLLAR_LBRACE = 77,
  anon_sym_SLASH = 78,
  anon_sym_COLON_QMARK = 79,
  anon_sym_COLON_DASH = 80,
  anon_sym_PERCENT = 81,
  anon_sym_DOLLAR_LPAREN = 82,
  anon_sym_BQUOTE = 83,
  anon_sym_LT_LPAREN = 84,
  anon_sym_GT_LPAREN = 85,
  sym_comment = 86,
  aux_sym__simple_variable_name_token1 = 87,
  anon_sym_STAR = 88,
  anon_sym_AT = 89,
  anon_sym_0 = 90,
  anon_sym__ = 91,
  sym_test_operator = 92,
  anon_sym_AMP = 93,
  sym_heredoc_start = 94,
  sym__simple_heredoc_body = 95,
  sym__heredoc_body_beginning = 96,
  sym__heredoc_body_middle = 97,
  sym__heredoc_body_end = 98,
  sym_file_descriptor = 99,
  sym__empty_value = 100,
  sym__concat = 101,
  sym_variable_name = 102,
  sym_regex = 103,
  sym_program = 104,
  sym__statements = 105,
  aux_sym__statements2 = 106,
  sym__terminated_statement = 107,
  sym_redirected_statement = 108,
  sym_for_statement = 109,
  sym_c_style_for_statement = 110,
  sym_while_statement = 111,
  sym_do_group = 112,
  sym_if_statement = 113,
  sym_elif_clause = 114,
  sym_else_clause = 115,
  sym_case_statement = 116,
  sym_case_item = 117,
  sym_last_case_item = 118,
  sym_function_definition = 119,
  sym_compound_statement = 120,
  sym_subshell = 121,
  sym_pipeline = 122,
  sym_list = 123,
  sym_negated_command = 124,
  sym_test_command = 125,
  sym_declaration_command = 126,
  sym_unset_command = 127,
  sym_command = 128,
  sym_command_name = 129,
  sym_variable_assignment = 130,
  sym_subscript = 131,
  sym_file_redirect = 132,
  sym_heredoc_redirect = 133,
  sym_heredoc_body = 134,
  sym_herestring_redirect = 135,
  sym__expression = 136,
  sym_binary_expression = 137,
  sym_ternary_expression = 138,
  sym_unary_expression = 139,
  sym_postfix_expression = 140,
  sym_parenthesized_expression = 141,
  sym_concatenation = 142,
  sym_string = 143,
  sym_array = 144,
  sym_simple_expansion = 145,
  sym_string_expansion = 146,
  sym_expansion_flags = 147,
  sym_expansion = 148,
  sym_command_substitution = 149,
  sym_process_substitution = 150,
  aux_sym__statements_repeat1 = 151,
  aux_sym_redirected_statement_repeat1 = 152,
  aux_sym_for_statement_repeat1 = 153,
  aux_sym_if_statement_repeat1 = 154,
  aux_sym_case_statement_repeat1 = 155,
  aux_sym_case_item_repeat1 = 156,
  aux_sym_declaration_command_repeat1 = 157,
  aux_sym_unset_command_repeat1 = 158,
  aux_sym_command_repeat1 = 159,
  aux_sym_command_repeat2 = 160,
  aux_sym_heredoc_body_repeat1 = 161,
  aux_sym__literal_repeat1 = 162,
  aux_sym_concatenation_repeat1 = 163,
  aux_sym_string_repeat1 = 164,
  aux_sym_expansion_flags_repeat1 = 165,
  aux_sym_expansion_repeat1 = 166,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_word] = "word",
  [anon_sym_LF] = "\n",
  [anon_sym_for] = "for",
  [anon_sym_select] = "select",
  [anon_sym_in] = "in",
  [anon_sym_LPAREN_LPAREN] = "((",
  [anon_sym_RPAREN_RPAREN] = "))",
  [anon_sym_SEMI] = ";",
  [anon_sym_while] = "while",
  [anon_sym_until] = "until",
  [anon_sym_do] = "do",
  [anon_sym_done] = "done",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_fi] = "fi",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_case] = "case",
  [anon_sym_esac] = "esac",
  [anon_sym_PIPE] = "|",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI_SEMI] = ";;",
  [anon_sym_SEMI_AMP] = ";&",
  [anon_sym_SEMI_SEMI_AMP] = ";;&",
  [anon_sym_function] = "function",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PIPE_AMP] = "|&",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG] = "!",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_declare] = "declare",
  [anon_sym_typeset] = "typeset",
  [anon_sym_export] = "export",
  [anon_sym_readonly] = "readonly",
  [anon_sym_local] = "local",
  [anon_sym_unset] = "unset",
  [anon_sym_unsetenv] = "unsetenv",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_GT] = "&>",
  [anon_sym_AMP_GT_GT] = "&>>",
  [anon_sym_LT_AMP] = "<&",
  [anon_sym_GT_AMP] = ">&",
  [anon_sym_GT_PIPE] = ">|",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_LT_LT_LT] = "<<<",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DOLLAR] = "$",
  [sym__special_character] = "_special_character",
  [anon_sym_DQUOTE] = "\"",
  [sym__string_content] = "_string_content",
  [sym_raw_string] = "raw_string",
  [sym_ansii_c_string] = "ansii_c_string",
  [anon_sym_POUND] = "#",
  [aux_sym_expansion_flags_token1] = "expansion_flags_token1",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON_QMARK] = ":\?",
  [anon_sym_COLON_DASH] = ":-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LT_LPAREN] = "<(",
  [anon_sym_GT_LPAREN] = ">(",
  [sym_comment] = "comment",
  [aux_sym__simple_variable_name_token1] = "variable_name",
  [anon_sym_STAR] = "special_variable_name",
  [anon_sym_AT] = "special_variable_name",
  [anon_sym_0] = "special_variable_name",
  [anon_sym__] = "special_variable_name",
  [sym_test_operator] = "test_operator",
  [anon_sym_AMP] = "&",
  [sym_heredoc_start] = "heredoc_start",
  [sym__simple_heredoc_body] = "_simple_heredoc_body",
  [sym__heredoc_body_beginning] = "_heredoc_body_beginning",
  [sym__heredoc_body_middle] = "_heredoc_body_middle",
  [sym__heredoc_body_end] = "_heredoc_body_end",
  [sym_file_descriptor] = "file_descriptor",
  [sym__empty_value] = "_empty_value",
  [sym__concat] = "_concat",
  [sym_variable_name] = "variable_name",
  [sym_regex] = "regex",
  [sym_program] = "program",
  [sym__statements] = "_statements",
  [aux_sym__statements2] = "_statements2",
  [sym__terminated_statement] = "_terminated_statement",
  [sym_redirected_statement] = "redirected_statement",
  [sym_for_statement] = "for_statement",
  [sym_c_style_for_statement] = "c_style_for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_group] = "do_group",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_case_statement] = "case_statement",
  [sym_case_item] = "case_item",
  [sym_last_case_item] = "case_item",
  [sym_function_definition] = "function_definition",
  [sym_compound_statement] = "compound_statement",
  [sym_subshell] = "subshell",
  [sym_pipeline] = "pipeline",
  [sym_list] = "list",
  [sym_negated_command] = "negated_command",
  [sym_test_command] = "test_command",
  [sym_declaration_command] = "declaration_command",
  [sym_unset_command] = "unset_command",
  [sym_command] = "command",
  [sym_command_name] = "command_name",
  [sym_variable_assignment] = "variable_assignment",
  [sym_subscript] = "subscript",
  [sym_file_redirect] = "file_redirect",
  [sym_heredoc_redirect] = "heredoc_redirect",
  [sym_heredoc_body] = "heredoc_body",
  [sym_herestring_redirect] = "herestring_redirect",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_concatenation] = "concatenation",
  [sym_string] = "string",
  [sym_array] = "array",
  [sym_simple_expansion] = "simple_expansion",
  [sym_string_expansion] = "string_expansion",
  [sym_expansion_flags] = "expansion_flags",
  [sym_expansion] = "expansion",
  [sym_command_substitution] = "command_substitution",
  [sym_process_substitution] = "process_substitution",
  [aux_sym__statements_repeat1] = "_statements_repeat1",
  [aux_sym_redirected_statement_repeat1] = "redirected_statement_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_case_item_repeat1] = "case_item_repeat1",
  [aux_sym_declaration_command_repeat1] = "declaration_command_repeat1",
  [aux_sym_unset_command_repeat1] = "unset_command_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_command_repeat2] = "command_repeat2",
  [aux_sym_heredoc_body_repeat1] = "heredoc_body_repeat1",
  [aux_sym__literal_repeat1] = "_literal_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_expansion_flags_repeat1] = "expansion_flags_repeat1",
  [aux_sym_expansion_repeat1] = "expansion_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_word] = sym_word,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_LPAREN_LPAREN] = anon_sym_LPAREN_LPAREN,
  [anon_sym_RPAREN_RPAREN] = anon_sym_RPAREN_RPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_done] = anon_sym_done,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_fi] = anon_sym_fi,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_esac] = anon_sym_esac,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SEMI_SEMI] = anon_sym_SEMI_SEMI,
  [anon_sym_SEMI_AMP] = anon_sym_SEMI_AMP,
  [anon_sym_SEMI_SEMI_AMP] = anon_sym_SEMI_SEMI_AMP,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_PIPE_AMP] = anon_sym_PIPE_AMP,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_typeset] = anon_sym_typeset,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_unset] = anon_sym_unset,
  [anon_sym_unsetenv] = anon_sym_unsetenv,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_AMP_GT] = anon_sym_AMP_GT,
  [anon_sym_AMP_GT_GT] = anon_sym_AMP_GT_GT,
  [anon_sym_LT_AMP] = anon_sym_LT_AMP,
  [anon_sym_GT_AMP] = anon_sym_GT_AMP,
  [anon_sym_GT_PIPE] = anon_sym_GT_PIPE,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_LT_LT_LT] = anon_sym_LT_LT_LT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym__special_character] = sym__special_character,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym__string_content] = sym__string_content,
  [sym_raw_string] = sym_raw_string,
  [sym_ansii_c_string] = sym_ansii_c_string,
  [anon_sym_POUND] = anon_sym_POUND,
  [aux_sym_expansion_flags_token1] = aux_sym_expansion_flags_token1,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLON_QMARK] = anon_sym_COLON_QMARK,
  [anon_sym_COLON_DASH] = anon_sym_COLON_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOLLAR_LPAREN] = anon_sym_DOLLAR_LPAREN,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_LT_LPAREN] = anon_sym_LT_LPAREN,
  [anon_sym_GT_LPAREN] = anon_sym_GT_LPAREN,
  [sym_comment] = sym_comment,
  [aux_sym__simple_variable_name_token1] = sym_variable_name,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_AT] = anon_sym_STAR,
  [anon_sym_0] = anon_sym_STAR,
  [anon_sym__] = anon_sym_STAR,
  [sym_test_operator] = sym_test_operator,
  [anon_sym_AMP] = anon_sym_AMP,
  [sym_heredoc_start] = sym_heredoc_start,
  [sym__simple_heredoc_body] = sym__simple_heredoc_body,
  [sym__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [sym__heredoc_body_middle] = sym__heredoc_body_middle,
  [sym__heredoc_body_end] = sym__heredoc_body_end,
  [sym_file_descriptor] = sym_file_descriptor,
  [sym__empty_value] = sym__empty_value,
  [sym__concat] = sym__concat,
  [sym_variable_name] = sym_variable_name,
  [sym_regex] = sym_regex,
  [sym_program] = sym_program,
  [sym__statements] = sym__statements,
  [aux_sym__statements2] = aux_sym__statements2,
  [sym__terminated_statement] = sym__terminated_statement,
  [sym_redirected_statement] = sym_redirected_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_c_style_for_statement] = sym_c_style_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_group] = sym_do_group,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_case_statement] = sym_case_statement,
  [sym_case_item] = sym_case_item,
  [sym_last_case_item] = sym_case_item,
  [sym_function_definition] = sym_function_definition,
  [sym_compound_statement] = sym_compound_statement,
  [sym_subshell] = sym_subshell,
  [sym_pipeline] = sym_pipeline,
  [sym_list] = sym_list,
  [sym_negated_command] = sym_negated_command,
  [sym_test_command] = sym_test_command,
  [sym_declaration_command] = sym_declaration_command,
  [sym_unset_command] = sym_unset_command,
  [sym_command] = sym_command,
  [sym_command_name] = sym_command_name,
  [sym_variable_assignment] = sym_variable_assignment,
  [sym_subscript] = sym_subscript,
  [sym_file_redirect] = sym_file_redirect,
  [sym_heredoc_redirect] = sym_heredoc_redirect,
  [sym_heredoc_body] = sym_heredoc_body,
  [sym_herestring_redirect] = sym_herestring_redirect,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_concatenation] = sym_concatenation,
  [sym_string] = sym_string,
  [sym_array] = sym_array,
  [sym_simple_expansion] = sym_simple_expansion,
  [sym_string_expansion] = sym_string_expansion,
  [sym_expansion_flags] = sym_expansion_flags,
  [sym_expansion] = sym_expansion,
  [sym_command_substitution] = sym_command_substitution,
  [sym_process_substitution] = sym_process_substitution,
  [aux_sym__statements_repeat1] = aux_sym__statements_repeat1,
  [aux_sym_redirected_statement_repeat1] = aux_sym_redirected_statement_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_case_item_repeat1] = aux_sym_case_item_repeat1,
  [aux_sym_declaration_command_repeat1] = aux_sym_declaration_command_repeat1,
  [aux_sym_unset_command_repeat1] = aux_sym_unset_command_repeat1,
  [aux_sym_command_repeat1] = aux_sym_command_repeat1,
  [aux_sym_command_repeat2] = aux_sym_command_repeat2,
  [aux_sym_heredoc_body_repeat1] = aux_sym_heredoc_body_repeat1,
  [aux_sym__literal_repeat1] = aux_sym__literal_repeat1,
  [aux_sym_concatenation_repeat1] = aux_sym_concatenation_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_expansion_flags_repeat1] = aux_sym_expansion_flags_repeat1,
  [aux_sym_expansion_repeat1] = aux_sym_expansion_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_done] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_esac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsetenv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__special_character] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [sym_ansii_c_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_expansion_flags_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__simple_variable_name_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = true,
  },
  [sym_test_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_heredoc_start] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_heredoc_body] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_beginning] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_middle] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_end] = {
    .visible = false,
    .named = true,
  },
  [sym_file_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_value] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__statements] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__statements2] = {
    .visible = false,
    .named = false,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_redirected_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_c_style_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_group] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_last_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_subshell] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_command] = {
    .visible = true,
    .named = true,
  },
  [sym_test_command] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_command] = {
    .visible = true,
    .named = true,
  },
  [sym_unset_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_body] = {
    .visible = true,
    .named = true,
  },
  [sym_herestring_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_process_substitution] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_redirected_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unset_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_heredoc_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expansion_flags_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_argument = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_descriptor = 6,
  field_destination = 7,
  field_fallthrough = 8,
  field_index = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_operator = 13,
  field_redirect = 14,
  field_right = 15,
  field_termination = 16,
  field_update = 17,
  field_value = 18,
  field_variable = 19,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_descriptor] = "descriptor",
  [field_destination] = "destination",
  [field_fallthrough] = "fallthrough",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_redirect] = "redirect",
  [field_right] = "right",
  [field_termination] = "termination",
  [field_update] = "update",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 2},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 4, .length = 1},
  [10] = {.index = 7, .length = 1},
  [11] = {.index = 8, .length = 2},
  [12] = {.index = 8, .length = 2},
  [13] = {.index = 10, .length = 2},
  [14] = {.index = 10, .length = 2},
  [15] = {.index = 12, .length = 2},
  [16] = {.index = 14, .length = 2},
  [18] = {.index = 16, .length = 2},
  [19] = {.index = 16, .length = 2},
  [20] = {.index = 18, .length = 2},
  [21] = {.index = 20, .length = 2},
  [22] = {.index = 22, .length = 2},
  [23] = {.index = 22, .length = 2},
  [24] = {.index = 24, .length = 2},
  [25] = {.index = 26, .length = 3},
  [26] = {.index = 29, .length = 1},
  [28] = {.index = 30, .length = 2},
  [29] = {.index = 32, .length = 1},
  [30] = {.index = 32, .length = 1},
  [31] = {.index = 33, .length = 2},
  [34] = {.index = 35, .length = 1},
  [35] = {.index = 36, .length = 3},
  [36] = {.index = 39, .length = 3},
  [37] = {.index = 42, .length = 1},
  [38] = {.index = 42, .length = 1},
  [40] = {.index = 43, .length = 1},
  [41] = {.index = 44, .length = 2},
  [42] = {.index = 46, .length = 2},
  [43] = {.index = 48, .length = 2},
  [44] = {.index = 50, .length = 2},
  [45] = {.index = 52, .length = 2},
  [46] = {.index = 54, .length = 2},
  [47] = {.index = 56, .length = 2},
  [48] = {.index = 50, .length = 2},
  [49] = {.index = 52, .length = 2},
  [50] = {.index = 54, .length = 2},
  [52] = {.index = 58, .length = 2},
  [53] = {.index = 60, .length = 2},
  [54] = {.index = 62, .length = 3},
  [55] = {.index = 65, .length = 2},
  [56] = {.index = 67, .length = 3},
  [57] = {.index = 70, .length = 3},
  [58] = {.index = 73, .length = 2},
  [59] = {.index = 75, .length = 2},
  [60] = {.index = 77, .length = 3},
  [61] = {.index = 80, .length = 3},
  [62] = {.index = 73, .length = 2},
  [63] = {.index = 75, .length = 2},
  [64] = {.index = 77, .length = 3},
  [65] = {.index = 80, .length = 3},
  [66] = {.index = 83, .length = 3},
  [67] = {.index = 86, .length = 3},
  [68] = {.index = 89, .length = 3},
  [69] = {.index = 92, .length = 4},
  [70] = {.index = 96, .length = 3},
  [71] = {.index = 99, .length = 3},
  [72] = {.index = 96, .length = 3},
  [73] = {.index = 99, .length = 3},
  [74] = {.index = 102, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_destination, 1},
  [2] =
    {field_body, 0},
    {field_redirect, 1},
  [4] =
    {field_argument, 0},
  [5] =
    {field_argument, 1, .inherited = true},
    {field_name, 0},
  [7] =
    {field_name, 1},
  [8] =
    {field_descriptor, 0},
    {field_destination, 2},
  [10] =
    {field_name, 0},
    {field_value, 2},
  [12] =
    {field_body, 2},
    {field_condition, 1},
  [14] =
    {field_body, 2},
    {field_name, 1},
  [16] =
    {field_argument, 0},
    {field_argument, 1},
  [18] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [20] =
    {field_argument, 2, .inherited = true},
    {field_name, 1},
  [22] =
    {field_index, 2},
    {field_name, 0},
  [24] =
    {field_body, 3},
    {field_variable, 1},
  [26] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [29] =
    {field_condition, 1},
  [30] =
    {field_body, 3},
    {field_name, 0},
  [32] =
    {field_value, 1},
  [33] =
    {field_body, 4},
    {field_name, 1},
  [35] =
    {field_body, 5},
  [36] =
    {field_body, 5},
    {field_value, 3},
    {field_variable, 1},
  [39] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [42] =
    {field_value, 0},
  [43] =
    {field_body, 6},
  [44] =
    {field_body, 6},
    {field_update, 4},
  [46] =
    {field_body, 6},
    {field_condition, 3},
  [48] =
    {field_body, 6},
    {field_initializer, 2},
  [50] =
    {field_termination, 2},
    {field_value, 0},
  [52] =
    {field_fallthrough, 2},
    {field_value, 0},
  [54] =
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [56] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [58] =
    {field_body, 7},
    {field_update, 4},
  [60] =
    {field_body, 7},
    {field_condition, 3},
  [62] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [65] =
    {field_body, 7},
    {field_initializer, 2},
  [67] =
    {field_body, 7},
    {field_initializer, 2},
    {field_update, 5},
  [70] =
    {field_body, 7},
    {field_condition, 4},
    {field_initializer, 2},
  [73] =
    {field_termination, 3},
    {field_value, 0},
  [75] =
    {field_fallthrough, 3},
    {field_value, 0},
  [77] =
    {field_termination, 3},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [80] =
    {field_fallthrough, 3},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [83] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
  [86] =
    {field_body, 8},
    {field_initializer, 2},
    {field_update, 5},
  [89] =
    {field_body, 8},
    {field_condition, 4},
    {field_initializer, 2},
  [92] =
    {field_body, 8},
    {field_condition, 4},
    {field_initializer, 2},
    {field_update, 6},
  [96] =
    {field_termination, 4},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [99] =
    {field_fallthrough, 4},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [102] =
    {field_body, 9},
    {field_condition, 4},
    {field_initializer, 2},
    {field_update, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = sym_word,
  },
  [4] = {
    [1] = sym_word,
  },
  [5] = {
    [1] = anon_sym_STAR,
  },
  [9] = {
    [0] = sym_word,
  },
  [12] = {
    [2] = sym_word,
  },
  [14] = {
    [2] = sym_word,
  },
  [17] = {
    [1] = sym_word,
  },
  [19] = {
    [1] = sym_word,
  },
  [23] = {
    [2] = sym_word,
  },
  [27] = {
    [2] = anon_sym_STAR,
  },
  [30] = {
    [1] = sym_word,
  },
  [32] = {
    [3] = sym_word,
  },
  [33] = {
    [3] = anon_sym_STAR,
  },
  [38] = {
    [0] = sym_word,
  },
  [39] = {
    [4] = sym_word,
  },
  [48] = {
    [0] = sym_word,
  },
  [49] = {
    [0] = sym_word,
  },
  [50] = {
    [0] = sym_word,
  },
  [51] = {
    [5] = sym_word,
  },
  [62] = {
    [0] = sym_word,
  },
  [63] = {
    [0] = sym_word,
  },
  [64] = {
    [0] = sym_word,
  },
  [65] = {
    [0] = sym_word,
  },
  [72] = {
    [0] = sym_word,
  },
  [73] = {
    [0] = sym_word,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__literal_repeat1, 2,
    aux_sym__literal_repeat1,
    sym_word,
  0,
};

static inline bool sym_word_character_set_1(int32_t c) {
  return (c < '&'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= ' ' || (c < '$'
        ? c == '"'
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool sym_word_character_set_2(int32_t c) {
  return (c < '$'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '$' || (c < '>'
      ? (c < ';'
        ? (c >= '&' && c <= ')')
        : c <= '<')
      : (c <= '>' || (c < '`'
        ? (c >= '[' && c <= ']')
        : c <= '}')))));
}

static inline bool sym_word_character_set_3(int32_t c) {
  return (c < '$'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '$' || (c < '['
      ? (c < ';'
        ? (c >= '&' && c <= ')')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool sym_word_character_set_4(int32_t c) {
  return (c < '$'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '$' || (c < '['
      ? (c < ';'
        ? (c >= '&' && c <= ')')
        : c <= '>')
      : (c <= ']' || (c >= '`' && c <= '}')))));
}

static inline bool sym_word_character_set_5(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c >= '`' && c <= '}')))));
}

static inline bool sym_word_character_set_6(int32_t c) {
  return (c < ';'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '&'
        ? (c >= ' ' && c <= '$')
        : c <= ')')))
    : (c <= '<' || (c < '`'
      ? (c < '['
        ? c == '>'
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_7(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '`'
      ? (c < '['
        ? (c >= ';' && c <= '>')
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_8(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool sym_word_character_set_9(int32_t c) {
  return (c < ';'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '&'
        ? (c >= ' ' && c <= '$')
        : c <= ')')))
    : (c <= '<' || (c < '`'
      ? (c < '['
        ? c == '>'
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_10(int32_t c) {
  return (c < '"'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= ')' || (c < '`'
      ? (c < '['
        ? (c >= ';' && c <= '>')
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_11(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(264);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '/') ADVANCE(344);
      if (lookahead == '0') ADVANCE(369);
      if (lookahead == ':') ADVANCE(316);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(132);
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '_') ADVANCE(372);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'd') ADVANCE(421);
      if (lookahead == 'e') ADVANCE(417);
      if (lookahead == 'f') ADVANCE(415);
      if (lookahead == 'i') ADVANCE(419);
      if (lookahead == 't') ADVANCE(414);
      if (lookahead == '{') ADVANCE(258);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '}') ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(76)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(79)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(81)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(80)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(82)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(83)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(8)
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(138);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(424);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(60)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(61)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(62)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(63)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(64)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(65)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(66)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(67)
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(68)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(69)
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(70)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(95)
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(71)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(72)
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(73)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(25)
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') SKIP(166)
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == 'e') ADVANCE(362);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 26:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') SKIP(167)
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 27:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(427);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') SKIP(176)
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == 'i') ADVANCE(361);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 28:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') SKIP(171)
      if (lookahead == 'e') ADVANCE(130);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      END_STATE();
    case 29:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '&') ADVANCE(427);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '\\') SKIP(182)
      if (lookahead == 'e') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(26)
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(96)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(33)
      END_STATE();
    case 33:
      if (lookahead == '\n') ADVANCE(208);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(287);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') SKIP(168)
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 34:
      if (lookahead == '\n') ADVANCE(208);
      if (lookahead == '!') ADVANCE(114);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(287);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') SKIP(172)
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(89)
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(37)
      END_STATE();
    case 37:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(427);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '-') ADVANCE(423);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(78)
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(88)
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(94)
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(93)
      END_STATE();
    case 42:
      if (lookahead == '\n') SKIP(84)
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(28)
      END_STATE();
    case 44:
      if (lookahead == '\n') SKIP(77)
      END_STATE();
    case 45:
      if (lookahead == '\n') SKIP(34)
      END_STATE();
    case 46:
      if (lookahead == '\n') SKIP(74)
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(75)
      END_STATE();
    case 48:
      if (lookahead == '\n') SKIP(99)
      END_STATE();
    case 49:
      if (lookahead == '\n') SKIP(90)
      END_STATE();
    case 50:
      if (lookahead == '\n') SKIP(91)
      END_STATE();
    case 51:
      if (lookahead == '\n') SKIP(92)
      END_STATE();
    case 52:
      if (lookahead == '\n') SKIP(97)
      END_STATE();
    case 53:
      if (lookahead == '\n') SKIP(98)
      END_STATE();
    case 54:
      if (lookahead == '\n') SKIP(27)
      END_STATE();
    case 55:
      if (lookahead == '\n') SKIP(85)
      END_STATE();
    case 56:
      if (lookahead == '\n') SKIP(101)
      END_STATE();
    case 57:
      if (lookahead == '\n') SKIP(29)
      END_STATE();
    case 58:
      if (lookahead == '\n') SKIP(102)
      END_STATE();
    case 59:
      if (lookahead == '\n') SKIP(103)
      END_STATE();
    case 60:
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(139);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(60)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(424);
      END_STATE();
    case 61:
      if (lookahead == '\n') ADVANCE(211);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(140);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(61)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(424);
      END_STATE();
    case 62:
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(141);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(62)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(424);
      END_STATE();
    case 63:
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(142);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'e') ADVANCE(422);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(63)
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(424);
      END_STATE();
    case 64:
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(143);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(424);
      END_STATE();
    case 65:
      if (lookahead == '\n') ADVANCE(215);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(424);
      END_STATE();
    case 66:
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(145);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(66)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(424);
      END_STATE();
    case 67:
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(146);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(424);
      END_STATE();
    case 68:
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(424);
      END_STATE();
    case 69:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(69)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 70:
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(70)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(424);
      END_STATE();
    case 71:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(151);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'e') ADVANCE(422);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(71)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(424);
      END_STATE();
    case 72:
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(152);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(72)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(424);
      END_STATE();
    case 73:
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(153);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(73)
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(424);
      END_STATE();
    case 74:
      if (lookahead == '\n') ADVANCE(224);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(427);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(161);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(74)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 75:
      if (lookahead == '\n') ADVANCE(225);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(427);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(162);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(75)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 76:
      if (lookahead == '!') ADVANCE(264);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '/') ADVANCE(344);
      if (lookahead == '0') ADVANCE(369);
      if (lookahead == ':') ADVANCE(316);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(132);
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '_') ADVANCE(372);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'd') ADVANCE(421);
      if (lookahead == 'e') ADVANCE(417);
      if (lookahead == 'f') ADVANCE(415);
      if (lookahead == 'i') ADVANCE(419);
      if (lookahead == 't') ADVANCE(414);
      if (lookahead == '{') ADVANCE(258);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '}') ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(76)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 77:
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ':') ADVANCE(316);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '=') ADVANCE(279);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '}') ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(77)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 78:
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(156);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(78)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 79:
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == ';') ADVANCE(106);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '{') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(79)
      if (lookahead != 0 &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 80:
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == ';') ADVANCE(106);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(135);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'e') ADVANCE(422);
      if (lookahead == '{') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(80)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 81:
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'e') ADVANCE(418);
      if (lookahead == 'f') ADVANCE(415);
      if (lookahead == '{') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(81)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 82:
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(136);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'f') ADVANCE(415);
      if (lookahead == '{') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(82)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 83:
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(137);
      if (lookahead == ']') ADVANCE(324);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '{') ADVANCE(258);
      if (lookahead == '}') ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(83)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 84:
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(113);
      if (lookahead == '-') ADVANCE(423);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(159);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(84)
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 85:
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') SKIP(177)
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '}') ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(85)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 86:
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') ADVANCE(178);
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(331);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(334);
      END_STATE();
    case 87:
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(332);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '`') ADVANCE(334);
      END_STATE();
    case 88:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(105);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == '<') ADVANCE(287);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') SKIP(170)
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(88)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 89:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(105);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(113);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '<') ADVANCE(287);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') SKIP(169)
      if (lookahead == ']') ADVANCE(117);
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(89)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 90:
      if (lookahead == '!') ADVANCE(114);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '&') ADVANCE(105);
      if (lookahead == '(') ADVANCE(110);
      if (lookahead == ')') ADVANCE(113);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '<') ADVANCE(287);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') SKIP(173)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(90)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 91:
      if (lookahead == '!') ADVANCE(114);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '&') ADVANCE(105);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '<') ADVANCE(287);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') SKIP(174)
      if (lookahead == '|') ADVANCE(250);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(91)
      END_STATE();
    case 92:
      if (lookahead == '!') ADVANCE(114);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '&') ADVANCE(105);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '<') ADVANCE(287);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') SKIP(175)
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      END_STATE();
    case 93:
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '/') ADVANCE(344);
      if (lookahead == ':') ADVANCE(316);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '=') ADVANCE(279);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '}') ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(93)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 94:
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == ':') ADVANCE(316);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '=') ADVANCE(279);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(157);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '}') ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(94)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 95:
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(150);
      if (lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(95)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 96:
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(154);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(96)
      if (lookahead != 0 &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 97:
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(164);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '}') ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(97)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 98:
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(165);
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(98)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 99:
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(163);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'e') ADVANCE(422);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(99)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 100:
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(328);
      if (lookahead == '$') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(181);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(333);
      if (lookahead != 0) ADVANCE(334);
      END_STATE();
    case 101:
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '+') ADVANCE(115);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '=') ADVANCE(276);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') SKIP(179)
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '{') ADVANCE(258);
      if (lookahead == '}') ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(101)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 102:
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '+') ADVANCE(115);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '=') ADVANCE(276);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') SKIP(183)
      if (lookahead == 'd') ADVANCE(129);
      if (lookahead == '{') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(102)
      END_STATE();
    case 103:
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(324);
      if (lookahead == '\\') SKIP(184)
      if (lookahead == '}') ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(103)
      END_STATE();
    case 104:
      if (lookahead == '#') ADVANCE(341);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '\\') ADVANCE(341);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(342);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(341);
      END_STATE();
    case 105:
      if (lookahead == '&') ADVANCE(261);
      END_STATE();
    case 106:
      if (lookahead == '&') ADVANCE(254);
      if (lookahead == ';') ADVANCE(253);
      END_STATE();
    case 107:
      if (lookahead == '\'') ADVANCE(336);
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 108:
      if (lookahead == '\'') ADVANCE(337);
      if (lookahead == '\\') ADVANCE(109);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 109:
      if (lookahead == '\'') ADVANCE(338);
      if (lookahead == '\\') ADVANCE(109);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 110:
      if (lookahead == '(') ADVANCE(229);
      END_STATE();
    case 111:
      if (lookahead == '(') ADVANCE(350);
      END_STATE();
    case 112:
      if (lookahead == '(') ADVANCE(351);
      END_STATE();
    case 113:
      if (lookahead == ')') ADVANCE(230);
      END_STATE();
    case 114:
      if (lookahead == '=') ADVANCE(301);
      END_STATE();
    case 115:
      if (lookahead == '=') ADVANCE(280);
      END_STATE();
    case 116:
      if (lookahead == '>') ADVANCE(293);
      END_STATE();
    case 117:
      if (lookahead == ']') ADVANCE(271);
      END_STATE();
    case 118:
      if (lookahead == 'a') ADVANCE(119);
      END_STATE();
    case 119:
      if (lookahead == 'c') ADVANCE(244);
      END_STATE();
    case 120:
      if (lookahead == 'e') ADVANCE(242);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 122:
      if (lookahead == 'f') ADVANCE(240);
      END_STATE();
    case 123:
      if (lookahead == 'h') ADVANCE(121);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(238);
      END_STATE();
    case 125:
      if (lookahead == 'i') ADVANCE(122);
      if (lookahead == 's') ADVANCE(120);
      END_STATE();
    case 126:
      if (lookahead == 'l') ADVANCE(125);
      if (lookahead == 's') ADVANCE(118);
      END_STATE();
    case 127:
      if (lookahead == 'n') ADVANCE(226);
      END_STATE();
    case 128:
      if (lookahead == 'n') ADVANCE(236);
      END_STATE();
    case 129:
      if (lookahead == 'o') ADVANCE(234);
      END_STATE();
    case 130:
      if (lookahead == 's') ADVANCE(118);
      END_STATE();
    case 131:
      if (lookahead == '|') ADVANCE(262);
      END_STATE();
    case 132:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(76)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(392);
      if (lookahead == '\r') SKIP(1)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 133:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(79)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(396);
      if (lookahead == '\r') SKIP(2)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 134:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(81)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(397);
      if (lookahead == '\r') SKIP(3)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 135:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(80)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(398);
      if (lookahead == '\r') SKIP(4)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 136:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(82)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(399);
      if (lookahead == '\r') SKIP(5)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 137:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(83)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(400);
      if (lookahead == '\r') SKIP(6)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 138:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(8)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(374);
      if (lookahead == '\r') SKIP(7)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 139:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(60)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(376);
      if (lookahead == '\r') SKIP(9)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 140:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(61)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(377);
      if (lookahead == '\r') SKIP(10)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 141:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(62)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(378);
      if (lookahead == '\r') SKIP(11)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(63)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(379);
      if (lookahead == '\r') SKIP(12)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(64)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(380);
      if (lookahead == '\r') SKIP(13)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(65)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(381);
      if (lookahead == '\r') SKIP(14)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(66)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(382);
      if (lookahead == '\r') SKIP(15)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 146:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(67)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(383);
      if (lookahead == '\r') SKIP(16)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 147:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(68)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(384);
      if (lookahead == '\r') SKIP(17)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 148:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(69)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(385);
      if (lookahead == '\r') SKIP(18)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 149:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(70)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(386);
      if (lookahead == '\r') SKIP(19)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 150:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(95)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(403);
      if (lookahead == '\r') SKIP(20)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 151:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(71)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(387);
      if (lookahead == '\r') SKIP(21)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 152:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(72)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(388);
      if (lookahead == '\r') SKIP(22)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 153:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(73)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(389);
      if (lookahead == '\r') SKIP(23)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 154:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(96)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(404);
      if (lookahead == '\r') SKIP(31)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 155:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(37)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(375);
      if (lookahead == '\r') SKIP(36)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 156:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(78)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(394);
      if (lookahead == '\r') SKIP(38)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 157:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(94)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(402);
      if (lookahead == '\r') SKIP(40)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 158:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(93)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(401);
      if (lookahead == '\r') SKIP(41)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 159:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(84)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(395);
      if (lookahead == '\r') SKIP(42)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 160:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(77)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(393);
      if (lookahead == '\r') SKIP(44)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 161:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(74)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(390);
      if (lookahead == '\r') SKIP(46)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 162:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(75)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(391);
      if (lookahead == '\r') SKIP(47)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 163:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(99)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(405);
      if (lookahead == '\r') SKIP(48)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 164:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(97)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(406);
      if (lookahead == '\r') SKIP(52)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 165:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(98)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(407);
      if (lookahead == '\r') SKIP(53)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 166:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(25)
      if (lookahead == '\r') SKIP(24)
      END_STATE();
    case 167:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(26)
      if (lookahead == '\r') SKIP(30)
      END_STATE();
    case 168:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(33)
      if (lookahead == '\r') SKIP(32)
      END_STATE();
    case 169:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(89)
      if (lookahead == '\r') SKIP(35)
      END_STATE();
    case 170:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(88)
      if (lookahead == '\r') SKIP(39)
      END_STATE();
    case 171:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(28)
      if (lookahead == '\r') SKIP(43)
      END_STATE();
    case 172:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(34)
      if (lookahead == '\r') SKIP(45)
      END_STATE();
    case 173:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(90)
      if (lookahead == '\r') SKIP(49)
      END_STATE();
    case 174:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(91)
      if (lookahead == '\r') SKIP(50)
      END_STATE();
    case 175:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(92)
      if (lookahead == '\r') SKIP(51)
      END_STATE();
    case 176:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(27)
      if (lookahead == '\r') SKIP(54)
      END_STATE();
    case 177:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(85)
      if (lookahead == '\r') SKIP(55)
      END_STATE();
    case 178:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(331);
      if (lookahead == '\r') ADVANCE(327);
      if (lookahead != 0) ADVANCE(334);
      END_STATE();
    case 179:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(101)
      if (lookahead == '\r') SKIP(56)
      END_STATE();
    case 180:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(332);
      if (lookahead == '\r') ADVANCE(329);
      if (lookahead != 0) ADVANCE(334);
      END_STATE();
    case 181:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(333);
      if (lookahead == '\r') ADVANCE(330);
      if (lookahead != 0) ADVANCE(334);
      END_STATE();
    case 182:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(29)
      if (lookahead == '\r') SKIP(57)
      END_STATE();
    case 183:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(102)
      if (lookahead == '\r') SKIP(58)
      END_STATE();
    case 184:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(103)
      if (lookahead == '\r') SKIP(59)
      END_STATE();
    case 185:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(424);
      END_STATE();
    case 186:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(334);
      if (lookahead == '\r') ADVANCE(335);
      END_STATE();
    case 187:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') SKIP(201)
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(187)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 188:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') SKIP(202)
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(188)
      END_STATE();
    case 189:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '&') ADVANCE(427);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') SKIP(204)
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'i') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(189)
      END_STATE();
    case 190:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') SKIP(187)
      END_STATE();
    case 191:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') SKIP(188)
      END_STATE();
    case 192:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') SKIP(200)
      END_STATE();
    case 193:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') SKIP(189)
      END_STATE();
    case 194:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(141);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(194)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(424);
      END_STATE();
    case 195:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(195)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(424);
      END_STATE();
    case 196:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(196)
      if (lookahead != 0) ADVANCE(424);
      END_STATE();
    case 197:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(197)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(424);
      END_STATE();
    case 198:
      if (eof) ADVANCE(205);
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(429);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == ';') ADVANCE(233);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') ADVANCE(153);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(198)
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(424);
      END_STATE();
    case 199:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(257);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == ';') ADVANCE(106);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '{') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(199)
      if (lookahead != 0 &&
          lookahead != '|') ADVANCE(424);
      END_STATE();
    case 200:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(114);
      if (lookahead == '#') ADVANCE(354);
      if (lookahead == '$') ADVANCE(323);
      if (lookahead == '&') ADVANCE(105);
      if (lookahead == ')') ADVANCE(113);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == ';') ADVANCE(106);
      if (lookahead == '<') ADVANCE(287);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(324);
      if (lookahead == '\\') SKIP(203)
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == 'd') ADVANCE(129);
      if (lookahead == 'e') ADVANCE(126);
      if (lookahead == 'f') ADVANCE(124);
      if (lookahead == 'i') ADVANCE(127);
      if (lookahead == 't') ADVANCE(123);
      if (lookahead == '|') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(200)
      END_STATE();
    case 201:
      if (eof) ADVANCE(205);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(187)
      if (lookahead == '\r') SKIP(190)
      END_STATE();
    case 202:
      if (eof) ADVANCE(205);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(188)
      if (lookahead == '\r') SKIP(191)
      END_STATE();
    case 203:
      if (eof) ADVANCE(205);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(200)
      if (lookahead == '\r') SKIP(192)
      END_STATE();
    case 204:
      if (eof) ADVANCE(205);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(189)
      if (lookahead == '\r') SKIP(193)
      END_STATE();
    case 205:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '\\') ADVANCE(138);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(208);
      if (lookahead == '-') ADVANCE(307);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '-') ADVANCE(423);
      if (lookahead == '\\') ADVANCE(155);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(139);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(211);
      if (lookahead == '\\') ADVANCE(140);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(141);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(142);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '\\') ADVANCE(143);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(215);
      if (lookahead == '\\') ADVANCE(144);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '\\') ADVANCE(145);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '\\') ADVANCE(146);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '\\') ADVANCE(147);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '\\') ADVANCE(148);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '\\') ADVANCE(149);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\\') ADVANCE(151);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '\\') ADVANCE(152);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(153);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(224);
      if (lookahead == '\\') ADVANCE(161);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(225);
      if (lookahead == '\\') ADVANCE(162);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_in);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_LPAREN_LPAREN);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_RPAREN_RPAREN);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == '&') ADVANCE(254);
      if (lookahead == ';') ADVANCE(253);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == ';') ADVANCE(252);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_then);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_fi);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_fi);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_elif);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_esac);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(424);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_esac);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '&') ADVANCE(260);
      if (lookahead == '|') ADVANCE(262);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(262);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      if (lookahead == '&') ADVANCE(255);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_SEMI_AMP);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI_AMP);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '(') ADVANCE(229);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_PIPE_AMP);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(302);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(424);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(301);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(270);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(275);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == '~') ADVANCE(273);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(424);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(274);
      if (lookahead == '~') ADVANCE(272);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(295);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '(') ADVANCE(350);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '(') ADVANCE(350);
      if (lookahead == '<') ADVANCE(298);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '(') ADVANCE(350);
      if (lookahead == '<') ADVANCE(298);
      if (lookahead == '=') ADVANCE(311);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '<') ADVANCE(298);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(311);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(296);
      if (lookahead == '(') ADVANCE(351);
      if (lookahead == '=') ADVANCE(312);
      if (lookahead == '>') ADVANCE(292);
      if (lookahead == '|') ADVANCE(297);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(296);
      if (lookahead == '(') ADVANCE(351);
      if (lookahead == '>') ADVANCE(292);
      if (lookahead == '|') ADVANCE(297);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(296);
      if (lookahead == '>') ADVANCE(292);
      if (lookahead == '|') ADVANCE(297);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(312);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_AMP_GT);
      if (lookahead == '>') ADVANCE(294);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_AMP_GT_GT);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_LT_AMP);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_GT_AMP);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_GT_PIPE);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '<') ADVANCE(300);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_LT_LT_LT);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(318);
      if (lookahead == '=') ADVANCE(281);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(424);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(317);
      if (lookahead == '=') ADVANCE(280);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(320);
      if (lookahead == '=') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(185);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(426);
      if (!sym_word_character_set_4(lookahead)) ADVANCE(424);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(319);
      if (lookahead == '=') ADVANCE(309);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(426);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-') ADVANCE(346);
      if (lookahead == '?') ADVANCE(345);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '\'') ADVANCE(108);
      if (lookahead == '(') ADVANCE(348);
      if (lookahead == '{') ADVANCE(343);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(') ADVANCE(348);
      if (lookahead == '{') ADVANCE(343);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__special_character);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym__special_character);
      if (lookahead == ']') ADVANCE(271);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(331);
      if (lookahead == '\\') ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(334);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(334);
      if (lookahead == '\\') ADVANCE(352);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(328);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(332);
      if (lookahead == '\\') ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(334);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(333);
      if (lookahead == '\\') ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(334);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') ADVANCE(178);
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(331);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(334);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '0') ADVANCE(370);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(366);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '_') ADVANCE(373);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(332);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '`') ADVANCE(334);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(328);
      if (lookahead == '$') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(181);
      if (lookahead == '`') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(333);
      if (lookahead != 0) ADVANCE(334);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\\') ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(334);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(334);
      if (lookahead == '\\') ADVANCE(186);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_raw_string);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_ansii_c_string);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_ansii_c_string);
      if (lookahead == '\'') ADVANCE(337);
      if (lookahead == '\\') ADVANCE(109);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '\\') ADVANCE(353);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(425);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(aux_sym_expansion_flags_token1);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(aux_sym_expansion_flags_token1);
      if (lookahead == '#') ADVANCE(341);
      if (lookahead == '\\') ADVANCE(341);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(342);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(341);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_COLON_QMARK);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_COLON_DASH);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_LT_LPAREN);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_GT_LPAREN);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(334);
      if (lookahead == '\r') ADVANCE(328);
      if (lookahead != 0) ADVANCE(328);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(354);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(425);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(354);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'a') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(424);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'c') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(424);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 's') ADVANCE(355);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(424);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(424);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'a') ADVANCE(360);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'c') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'n') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 's') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(424);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(424);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(363);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(138);
      if (lookahead == 'e') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (!sym_word_character_set_5(lookahead)) ADVANCE(424);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '-') ADVANCE(423);
      if (lookahead == '\\') ADVANCE(155);
      if (!sym_word_character_set_6(lookahead)) ADVANCE(424);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (!sym_word_character_set_5(lookahead)) ADVANCE(424);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(211);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '\\') ADVANCE(140);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == 'e') ADVANCE(357);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(424);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (!sym_word_character_set_5(lookahead)) ADVANCE(424);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '\\') ADVANCE(142);
      if (lookahead == 'e') ADVANCE(422);
      if (!sym_word_character_set_7(lookahead)) ADVANCE(424);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '\\') ADVANCE(143);
      if (lookahead == '_') ADVANCE(371);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(424);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(215);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '_') ADVANCE(371);
      if (lookahead == 'e') ADVANCE(357);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(424);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '\\') ADVANCE(145);
      if (lookahead == '_') ADVANCE(371);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(424);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '\\') ADVANCE(146);
      if (!sym_word_character_set_7(lookahead)) ADVANCE(424);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead == '_') ADVANCE(371);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(424);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '=') ADVANCE(408);
      if (lookahead == '\\') ADVANCE(148);
      if (!sym_word_character_set_7(lookahead)) ADVANCE(424);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead == '_') ADVANCE(371);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(424);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(151);
      if (lookahead == 'e') ADVANCE(422);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(424);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(152);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(424);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(153);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(424);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(224);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '\\') ADVANCE(161);
      if (lookahead == '_') ADVANCE(371);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(424);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(225);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(162);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(424);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(264);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '/') ADVANCE(344);
      if (lookahead == '0') ADVANCE(369);
      if (lookahead == ':') ADVANCE(316);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '\\') ADVANCE(132);
      if (lookahead == '_') ADVANCE(372);
      if (lookahead == 'd') ADVANCE(421);
      if (lookahead == 'e') ADVANCE(417);
      if (lookahead == 'f') ADVANCE(415);
      if (lookahead == 'i') ADVANCE(419);
      if (lookahead == 't') ADVANCE(414);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || ')' < lookahead) &&
          (lookahead < ';' || '>' < lookahead) &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(424);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == ':') ADVANCE(316);
      if (lookahead == '=') ADVANCE(279);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == '_') ADVANCE(371);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(424);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '0') ADVANCE(368);
      if (lookahead == '?') ADVANCE(314);
      if (lookahead == '@') ADVANCE(367);
      if (lookahead == '\\') ADVANCE(156);
      if (lookahead == '_') ADVANCE(371);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(424);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '-') ADVANCE(423);
      if (lookahead == '\\') ADVANCE(159);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(424);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(133);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(424);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == 'e') ADVANCE(418);
      if (lookahead == 'f') ADVANCE(415);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(424);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(135);
      if (lookahead == 'e') ADVANCE(422);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(424);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(136);
      if (lookahead == 'f') ADVANCE(415);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(424);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(266);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(137);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(424);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '/') ADVANCE(344);
      if (lookahead == ':') ADVANCE(316);
      if (lookahead == '=') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(158);
      if (!sym_word_character_set_10(lookahead)) ADVANCE(424);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(340);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == ':') ADVANCE(316);
      if (lookahead == '=') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(157);
      if (!sym_word_character_set_10(lookahead)) ADVANCE(424);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(150);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(424);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(154);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(424);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(163);
      if (lookahead == 'e') ADVANCE(422);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(424);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(164);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(424);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '\\') ADVANCE(165);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(424);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=') ADVANCE(275);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == '~') ADVANCE(273);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(424);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'a') ADVANCE(410);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'c') ADVANCE(246);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'e') ADVANCE(243);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'e') ADVANCE(420);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'f') ADVANCE(241);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'h') ADVANCE(412);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'i') ADVANCE(239);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'i') ADVANCE(413);
      if (lookahead == 's') ADVANCE(411);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'l') ADVANCE(416);
      if (lookahead == 's') ADVANCE(409);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'l') ADVANCE(416);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'n') ADVANCE(227);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'n') ADVANCE(237);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 'o') ADVANCE(235);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == 's') ADVANCE(409);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(426);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(424);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(185);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(424);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(353);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(425);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(426);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(261);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(261);
      if (lookahead == '>') ADVANCE(293);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'c') ADVANCE(2);
      if (lookahead == 'd') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'i') ADVANCE(6);
      if (lookahead == 'l') ADVANCE(7);
      if (lookahead == 'r') ADVANCE(8);
      if (lookahead == 's') ADVANCE(9);
      if (lookahead == 't') ADVANCE(10);
      if (lookahead == 'u') ADVANCE(11);
      if (lookahead == 'w') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '\r') SKIP(13)
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(14);
      END_STATE();
    case 3:
      if (lookahead == 'e') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      END_STATE();
    case 4:
      if (lookahead == 'x') ADVANCE(17);
      END_STATE();
    case 5:
      if (lookahead == 'o') ADVANCE(18);
      if (lookahead == 'u') ADVANCE(19);
      END_STATE();
    case 6:
      if (lookahead == 'f') ADVANCE(20);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 10:
      if (lookahead == 'y') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(26);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 14:
      if (lookahead == 's') ADVANCE(27);
      END_STATE();
    case 15:
      if (lookahead == 'c') ADVANCE(28);
      END_STATE();
    case 16:
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 17:
      if (lookahead == 'p') ADVANCE(30);
      END_STATE();
    case 18:
      if (lookahead == 'r') ADVANCE(31);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 21:
      if (lookahead == 'c') ADVANCE(33);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(34);
      END_STATE();
    case 23:
      if (lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 24:
      if (lookahead == 'p') ADVANCE(36);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(37);
      if (lookahead == 't') ADVANCE(38);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(39);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(43);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 32:
      if (lookahead == 'c') ADVANCE(44);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(50);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_done);
      END_STATE();
    case 43:
      if (lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(55);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 47:
      if (lookahead == 'c') ADVANCE(57);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 50:
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 53:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(64);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 56:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_unset);
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 64:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 71:
      if (lookahead == 'y') ADVANCE(75);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_typeset);
      END_STATE();
    case 73:
      if (lookahead == 'v') ADVANCE(76);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_unsetenv);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 199, .external_lex_state = 2},
  [2] = {.lex_state = 81, .external_lex_state = 2},
  [3] = {.lex_state = 81, .external_lex_state = 2},
  [4] = {.lex_state = 81, .external_lex_state = 2},
  [5] = {.lex_state = 81, .external_lex_state = 2},
  [6] = {.lex_state = 81, .external_lex_state = 2},
  [7] = {.lex_state = 81, .external_lex_state = 2},
  [8] = {.lex_state = 80, .external_lex_state = 2},
  [9] = {.lex_state = 80, .external_lex_state = 2},
  [10] = {.lex_state = 80, .external_lex_state = 2},
  [11] = {.lex_state = 80, .external_lex_state = 2},
  [12] = {.lex_state = 80, .external_lex_state = 2},
  [13] = {.lex_state = 199, .external_lex_state = 2},
  [14] = {.lex_state = 199, .external_lex_state = 2},
  [15] = {.lex_state = 199, .external_lex_state = 2},
  [16] = {.lex_state = 199, .external_lex_state = 2},
  [17] = {.lex_state = 199, .external_lex_state = 2},
  [18] = {.lex_state = 81, .external_lex_state = 2},
  [19] = {.lex_state = 81, .external_lex_state = 2},
  [20] = {.lex_state = 81, .external_lex_state = 2},
  [21] = {.lex_state = 199, .external_lex_state = 2},
  [22] = {.lex_state = 199, .external_lex_state = 2},
  [23] = {.lex_state = 199, .external_lex_state = 2},
  [24] = {.lex_state = 199, .external_lex_state = 2},
  [25] = {.lex_state = 199, .external_lex_state = 2},
  [26] = {.lex_state = 199, .external_lex_state = 2},
  [27] = {.lex_state = 199, .external_lex_state = 2},
  [28] = {.lex_state = 199, .external_lex_state = 2},
  [29] = {.lex_state = 199, .external_lex_state = 2},
  [30] = {.lex_state = 199, .external_lex_state = 2},
  [31] = {.lex_state = 199, .external_lex_state = 2},
  [32] = {.lex_state = 199, .external_lex_state = 2},
  [33] = {.lex_state = 199, .external_lex_state = 2},
  [34] = {.lex_state = 199, .external_lex_state = 2},
  [35] = {.lex_state = 199, .external_lex_state = 2},
  [36] = {.lex_state = 199, .external_lex_state = 2},
  [37] = {.lex_state = 199, .external_lex_state = 2},
  [38] = {.lex_state = 199, .external_lex_state = 2},
  [39] = {.lex_state = 199, .external_lex_state = 2},
  [40] = {.lex_state = 199, .external_lex_state = 2},
  [41] = {.lex_state = 199, .external_lex_state = 2},
  [42] = {.lex_state = 82, .external_lex_state = 2},
  [43] = {.lex_state = 199, .external_lex_state = 2},
  [44] = {.lex_state = 199, .external_lex_state = 2},
  [45] = {.lex_state = 199, .external_lex_state = 2},
  [46] = {.lex_state = 199, .external_lex_state = 2},
  [47] = {.lex_state = 199, .external_lex_state = 2},
  [48] = {.lex_state = 199, .external_lex_state = 2},
  [49] = {.lex_state = 199, .external_lex_state = 2},
  [50] = {.lex_state = 199, .external_lex_state = 2},
  [51] = {.lex_state = 199, .external_lex_state = 2},
  [52] = {.lex_state = 199, .external_lex_state = 2},
  [53] = {.lex_state = 199, .external_lex_state = 2},
  [54] = {.lex_state = 199, .external_lex_state = 2},
  [55] = {.lex_state = 199, .external_lex_state = 2},
  [56] = {.lex_state = 199, .external_lex_state = 2},
  [57] = {.lex_state = 199, .external_lex_state = 2},
  [58] = {.lex_state = 199, .external_lex_state = 2},
  [59] = {.lex_state = 199, .external_lex_state = 2},
  [60] = {.lex_state = 199, .external_lex_state = 2},
  [61] = {.lex_state = 199, .external_lex_state = 2},
  [62] = {.lex_state = 83, .external_lex_state = 3},
  [63] = {.lex_state = 83, .external_lex_state = 3},
  [64] = {.lex_state = 199, .external_lex_state = 2},
  [65] = {.lex_state = 199, .external_lex_state = 2},
  [66] = {.lex_state = 199, .external_lex_state = 2},
  [67] = {.lex_state = 199, .external_lex_state = 2},
  [68] = {.lex_state = 199, .external_lex_state = 2},
  [69] = {.lex_state = 199, .external_lex_state = 2},
  [70] = {.lex_state = 199, .external_lex_state = 2},
  [71] = {.lex_state = 83, .external_lex_state = 3},
  [72] = {.lex_state = 199, .external_lex_state = 2},
  [73] = {.lex_state = 199, .external_lex_state = 2},
  [74] = {.lex_state = 83, .external_lex_state = 3},
  [75] = {.lex_state = 199, .external_lex_state = 2},
  [76] = {.lex_state = 199, .external_lex_state = 2},
  [77] = {.lex_state = 199, .external_lex_state = 2},
  [78] = {.lex_state = 199, .external_lex_state = 2},
  [79] = {.lex_state = 199, .external_lex_state = 2},
  [80] = {.lex_state = 199, .external_lex_state = 2},
  [81] = {.lex_state = 199, .external_lex_state = 2},
  [82] = {.lex_state = 199, .external_lex_state = 2},
  [83] = {.lex_state = 199, .external_lex_state = 2},
  [84] = {.lex_state = 199, .external_lex_state = 2},
  [85] = {.lex_state = 199, .external_lex_state = 2},
  [86] = {.lex_state = 199, .external_lex_state = 2},
  [87] = {.lex_state = 82, .external_lex_state = 2},
  [88] = {.lex_state = 199, .external_lex_state = 2},
  [89] = {.lex_state = 199, .external_lex_state = 2},
  [90] = {.lex_state = 199, .external_lex_state = 2},
  [91] = {.lex_state = 199, .external_lex_state = 2},
  [92] = {.lex_state = 199, .external_lex_state = 2},
  [93] = {.lex_state = 199, .external_lex_state = 2},
  [94] = {.lex_state = 199, .external_lex_state = 2},
  [95] = {.lex_state = 199, .external_lex_state = 2},
  [96] = {.lex_state = 199, .external_lex_state = 2},
  [97] = {.lex_state = 199, .external_lex_state = 2},
  [98] = {.lex_state = 199, .external_lex_state = 2},
  [99] = {.lex_state = 199, .external_lex_state = 2},
  [100] = {.lex_state = 199, .external_lex_state = 2},
  [101] = {.lex_state = 199, .external_lex_state = 2},
  [102] = {.lex_state = 199, .external_lex_state = 2},
  [103] = {.lex_state = 199, .external_lex_state = 2},
  [104] = {.lex_state = 199, .external_lex_state = 2},
  [105] = {.lex_state = 199, .external_lex_state = 2},
  [106] = {.lex_state = 83, .external_lex_state = 3},
  [107] = {.lex_state = 199, .external_lex_state = 2},
  [108] = {.lex_state = 199, .external_lex_state = 2},
  [109] = {.lex_state = 199, .external_lex_state = 2},
  [110] = {.lex_state = 199, .external_lex_state = 2},
  [111] = {.lex_state = 199, .external_lex_state = 2},
  [112] = {.lex_state = 199, .external_lex_state = 2},
  [113] = {.lex_state = 199, .external_lex_state = 2},
  [114] = {.lex_state = 199, .external_lex_state = 2},
  [115] = {.lex_state = 199, .external_lex_state = 2},
  [116] = {.lex_state = 199, .external_lex_state = 2},
  [117] = {.lex_state = 199, .external_lex_state = 2},
  [118] = {.lex_state = 199, .external_lex_state = 2},
  [119] = {.lex_state = 199, .external_lex_state = 2},
  [120] = {.lex_state = 199, .external_lex_state = 2},
  [121] = {.lex_state = 199, .external_lex_state = 2},
  [122] = {.lex_state = 199, .external_lex_state = 2},
  [123] = {.lex_state = 199, .external_lex_state = 2},
  [124] = {.lex_state = 199, .external_lex_state = 2},
  [125] = {.lex_state = 199, .external_lex_state = 2},
  [126] = {.lex_state = 199, .external_lex_state = 2},
  [127] = {.lex_state = 83, .external_lex_state = 3},
  [128] = {.lex_state = 199, .external_lex_state = 2},
  [129] = {.lex_state = 82, .external_lex_state = 2},
  [130] = {.lex_state = 199, .external_lex_state = 2},
  [131] = {.lex_state = 199, .external_lex_state = 2},
  [132] = {.lex_state = 199, .external_lex_state = 2},
  [133] = {.lex_state = 83, .external_lex_state = 3},
  [134] = {.lex_state = 199, .external_lex_state = 2},
  [135] = {.lex_state = 199, .external_lex_state = 2},
  [136] = {.lex_state = 199, .external_lex_state = 2},
  [137] = {.lex_state = 199, .external_lex_state = 2},
  [138] = {.lex_state = 199, .external_lex_state = 2},
  [139] = {.lex_state = 199, .external_lex_state = 2},
  [140] = {.lex_state = 199, .external_lex_state = 2},
  [141] = {.lex_state = 199, .external_lex_state = 2},
  [142] = {.lex_state = 199, .external_lex_state = 2},
  [143] = {.lex_state = 199, .external_lex_state = 2},
  [144] = {.lex_state = 199, .external_lex_state = 2},
  [145] = {.lex_state = 199, .external_lex_state = 2},
  [146] = {.lex_state = 199, .external_lex_state = 2},
  [147] = {.lex_state = 199, .external_lex_state = 2},
  [148] = {.lex_state = 199, .external_lex_state = 2},
  [149] = {.lex_state = 199, .external_lex_state = 2},
  [150] = {.lex_state = 199, .external_lex_state = 2},
  [151] = {.lex_state = 199, .external_lex_state = 2},
  [152] = {.lex_state = 199, .external_lex_state = 2},
  [153] = {.lex_state = 199, .external_lex_state = 2},
  [154] = {.lex_state = 199, .external_lex_state = 2},
  [155] = {.lex_state = 199, .external_lex_state = 2},
  [156] = {.lex_state = 199, .external_lex_state = 2},
  [157] = {.lex_state = 199, .external_lex_state = 2},
  [158] = {.lex_state = 80, .external_lex_state = 4},
  [159] = {.lex_state = 80, .external_lex_state = 4},
  [160] = {.lex_state = 199, .external_lex_state = 4},
  [161] = {.lex_state = 81, .external_lex_state = 4},
  [162] = {.lex_state = 199, .external_lex_state = 4},
  [163] = {.lex_state = 8, .external_lex_state = 5},
  [164] = {.lex_state = 8, .external_lex_state = 5},
  [165] = {.lex_state = 8, .external_lex_state = 5},
  [166] = {.lex_state = 60, .external_lex_state = 5},
  [167] = {.lex_state = 60, .external_lex_state = 5},
  [168] = {.lex_state = 60, .external_lex_state = 5},
  [169] = {.lex_state = 61, .external_lex_state = 6},
  [170] = {.lex_state = 194, .external_lex_state = 5},
  [171] = {.lex_state = 199, .external_lex_state = 4},
  [172] = {.lex_state = 63, .external_lex_state = 6},
  [173] = {.lex_state = 199, .external_lex_state = 2},
  [174] = {.lex_state = 194, .external_lex_state = 5},
  [175] = {.lex_state = 63, .external_lex_state = 6},
  [176] = {.lex_state = 199, .external_lex_state = 2},
  [177] = {.lex_state = 199, .external_lex_state = 4},
  [178] = {.lex_state = 83, .external_lex_state = 7},
  [179] = {.lex_state = 63, .external_lex_state = 6},
  [180] = {.lex_state = 80, .external_lex_state = 2},
  [181] = {.lex_state = 194, .external_lex_state = 5},
  [182] = {.lex_state = 80, .external_lex_state = 2},
  [183] = {.lex_state = 64, .external_lex_state = 6},
  [184] = {.lex_state = 65, .external_lex_state = 5},
  [185] = {.lex_state = 194, .external_lex_state = 5},
  [186] = {.lex_state = 199, .external_lex_state = 4},
  [187] = {.lex_state = 63, .external_lex_state = 6},
  [188] = {.lex_state = 65, .external_lex_state = 5},
  [189] = {.lex_state = 63, .external_lex_state = 6},
  [190] = {.lex_state = 199, .external_lex_state = 2},
  [191] = {.lex_state = 194, .external_lex_state = 5},
  [192] = {.lex_state = 199, .external_lex_state = 4},
  [193] = {.lex_state = 194, .external_lex_state = 5},
  [194] = {.lex_state = 199, .external_lex_state = 2},
  [195] = {.lex_state = 80, .external_lex_state = 2},
  [196] = {.lex_state = 199, .external_lex_state = 4},
  [197] = {.lex_state = 80, .external_lex_state = 2},
  [198] = {.lex_state = 82, .external_lex_state = 4},
  [199] = {.lex_state = 194, .external_lex_state = 5},
  [200] = {.lex_state = 66, .external_lex_state = 5},
  [201] = {.lex_state = 194, .external_lex_state = 5},
  [202] = {.lex_state = 8, .external_lex_state = 6},
  [203] = {.lex_state = 199, .external_lex_state = 4},
  [204] = {.lex_state = 8, .external_lex_state = 6},
  [205] = {.lex_state = 199, .external_lex_state = 4},
  [206] = {.lex_state = 67, .external_lex_state = 6},
  [207] = {.lex_state = 67, .external_lex_state = 6},
  [208] = {.lex_state = 67, .external_lex_state = 6},
  [209] = {.lex_state = 81, .external_lex_state = 2},
  [210] = {.lex_state = 8, .external_lex_state = 6},
  [211] = {.lex_state = 195, .external_lex_state = 6},
  [212] = {.lex_state = 66, .external_lex_state = 5},
  [213] = {.lex_state = 199, .external_lex_state = 4},
  [214] = {.lex_state = 67, .external_lex_state = 6},
  [215] = {.lex_state = 67, .external_lex_state = 6},
  [216] = {.lex_state = 195, .external_lex_state = 6},
  [217] = {.lex_state = 81, .external_lex_state = 2},
  [218] = {.lex_state = 65, .external_lex_state = 6},
  [219] = {.lex_state = 196, .external_lex_state = 6},
  [220] = {.lex_state = 196, .external_lex_state = 6},
  [221] = {.lex_state = 196, .external_lex_state = 6},
  [222] = {.lex_state = 66, .external_lex_state = 6},
  [223] = {.lex_state = 60, .external_lex_state = 6},
  [224] = {.lex_state = 196, .external_lex_state = 6},
  [225] = {.lex_state = 196, .external_lex_state = 6},
  [226] = {.lex_state = 197, .external_lex_state = 5},
  [227] = {.lex_state = 60, .external_lex_state = 6},
  [228] = {.lex_state = 196, .external_lex_state = 6},
  [229] = {.lex_state = 197, .external_lex_state = 5},
  [230] = {.lex_state = 196, .external_lex_state = 6},
  [231] = {.lex_state = 196, .external_lex_state = 6},
  [232] = {.lex_state = 196, .external_lex_state = 6},
  [233] = {.lex_state = 60, .external_lex_state = 6},
  [234] = {.lex_state = 197, .external_lex_state = 5},
  [235] = {.lex_state = 196, .external_lex_state = 6},
  [236] = {.lex_state = 197, .external_lex_state = 5},
  [237] = {.lex_state = 199, .external_lex_state = 2},
  [238] = {.lex_state = 196, .external_lex_state = 6},
  [239] = {.lex_state = 82, .external_lex_state = 2},
  [240] = {.lex_state = 194, .external_lex_state = 6},
  [241] = {.lex_state = 83, .external_lex_state = 3},
  [242] = {.lex_state = 199, .external_lex_state = 2},
  [243] = {.lex_state = 197, .external_lex_state = 6},
  [244] = {.lex_state = 199, .external_lex_state = 2},
  [245] = {.lex_state = 83, .external_lex_state = 3},
  [246] = {.lex_state = 194, .external_lex_state = 6},
  [247] = {.lex_state = 196, .external_lex_state = 6},
  [248] = {.lex_state = 82, .external_lex_state = 2},
  [249] = {.lex_state = 194, .external_lex_state = 6},
  [250] = {.lex_state = 196, .external_lex_state = 6},
  [251] = {.lex_state = 199, .external_lex_state = 2},
  [252] = {.lex_state = 199, .external_lex_state = 2},
  [253] = {.lex_state = 197, .external_lex_state = 6},
  [254] = {.lex_state = 194, .external_lex_state = 6},
  [255] = {.lex_state = 194, .external_lex_state = 6},
  [256] = {.lex_state = 194, .external_lex_state = 6},
  [257] = {.lex_state = 196, .external_lex_state = 6},
  [258] = {.lex_state = 199, .external_lex_state = 2},
  [259] = {.lex_state = 199, .external_lex_state = 2},
  [260] = {.lex_state = 194, .external_lex_state = 6},
  [261] = {.lex_state = 95, .external_lex_state = 2},
  [262] = {.lex_state = 95, .external_lex_state = 2},
  [263] = {.lex_state = 199, .external_lex_state = 2},
  [264] = {.lex_state = 199, .external_lex_state = 2},
  [265] = {.lex_state = 199, .external_lex_state = 2},
  [266] = {.lex_state = 95, .external_lex_state = 2},
  [267] = {.lex_state = 199, .external_lex_state = 2},
  [268] = {.lex_state = 194, .external_lex_state = 6},
  [269] = {.lex_state = 199, .external_lex_state = 2},
  [270] = {.lex_state = 95, .external_lex_state = 2},
  [271] = {.lex_state = 95, .external_lex_state = 2},
  [272] = {.lex_state = 71, .external_lex_state = 5},
  [273] = {.lex_state = 63, .external_lex_state = 8},
  [274] = {.lex_state = 71, .external_lex_state = 5},
  [275] = {.lex_state = 71, .external_lex_state = 5},
  [276] = {.lex_state = 71, .external_lex_state = 5},
  [277] = {.lex_state = 63, .external_lex_state = 8},
  [278] = {.lex_state = 63, .external_lex_state = 8},
  [279] = {.lex_state = 72, .external_lex_state = 5},
  [280] = {.lex_state = 72, .external_lex_state = 5},
  [281] = {.lex_state = 72, .external_lex_state = 5},
  [282] = {.lex_state = 8, .external_lex_state = 9},
  [283] = {.lex_state = 72, .external_lex_state = 5},
  [284] = {.lex_state = 63, .external_lex_state = 8},
  [285] = {.lex_state = 63, .external_lex_state = 8},
  [286] = {.lex_state = 63, .external_lex_state = 8},
  [287] = {.lex_state = 8, .external_lex_state = 9},
  [288] = {.lex_state = 67, .external_lex_state = 8},
  [289] = {.lex_state = 8, .external_lex_state = 9},
  [290] = {.lex_state = 8, .external_lex_state = 9},
  [291] = {.lex_state = 8, .external_lex_state = 9},
  [292] = {.lex_state = 63, .external_lex_state = 8},
  [293] = {.lex_state = 63, .external_lex_state = 8},
  [294] = {.lex_state = 67, .external_lex_state = 8},
  [295] = {.lex_state = 60, .external_lex_state = 9},
  [296] = {.lex_state = 63, .external_lex_state = 8},
  [297] = {.lex_state = 67, .external_lex_state = 8},
  [298] = {.lex_state = 63, .external_lex_state = 6},
  [299] = {.lex_state = 8, .external_lex_state = 8},
  [300] = {.lex_state = 8, .external_lex_state = 9},
  [301] = {.lex_state = 63, .external_lex_state = 8},
  [302] = {.lex_state = 63, .external_lex_state = 8},
  [303] = {.lex_state = 63, .external_lex_state = 8},
  [304] = {.lex_state = 8, .external_lex_state = 8},
  [305] = {.lex_state = 198, .external_lex_state = 5},
  [306] = {.lex_state = 198, .external_lex_state = 5},
  [307] = {.lex_state = 63, .external_lex_state = 8},
  [308] = {.lex_state = 63, .external_lex_state = 8},
  [309] = {.lex_state = 63, .external_lex_state = 8},
  [310] = {.lex_state = 60, .external_lex_state = 9},
  [311] = {.lex_state = 63, .external_lex_state = 8},
  [312] = {.lex_state = 63, .external_lex_state = 8},
  [313] = {.lex_state = 198, .external_lex_state = 5},
  [314] = {.lex_state = 63, .external_lex_state = 8},
  [315] = {.lex_state = 198, .external_lex_state = 5},
  [316] = {.lex_state = 8, .external_lex_state = 9},
  [317] = {.lex_state = 63, .external_lex_state = 8},
  [318] = {.lex_state = 63, .external_lex_state = 8},
  [319] = {.lex_state = 63, .external_lex_state = 8},
  [320] = {.lex_state = 8, .external_lex_state = 9},
  [321] = {.lex_state = 63, .external_lex_state = 8},
  [322] = {.lex_state = 63, .external_lex_state = 8},
  [323] = {.lex_state = 63, .external_lex_state = 8},
  [324] = {.lex_state = 63, .external_lex_state = 8},
  [325] = {.lex_state = 198, .external_lex_state = 5},
  [326] = {.lex_state = 71, .external_lex_state = 9},
  [327] = {.lex_state = 8, .external_lex_state = 9},
  [328] = {.lex_state = 63, .external_lex_state = 8},
  [329] = {.lex_state = 63, .external_lex_state = 8},
  [330] = {.lex_state = 63, .external_lex_state = 8},
  [331] = {.lex_state = 63, .external_lex_state = 8},
  [332] = {.lex_state = 63, .external_lex_state = 8},
  [333] = {.lex_state = 8, .external_lex_state = 9},
  [334] = {.lex_state = 8, .external_lex_state = 8},
  [335] = {.lex_state = 67, .external_lex_state = 8},
  [336] = {.lex_state = 67, .external_lex_state = 8},
  [337] = {.lex_state = 63, .external_lex_state = 8},
  [338] = {.lex_state = 8, .external_lex_state = 9},
  [339] = {.lex_state = 8, .external_lex_state = 9},
  [340] = {.lex_state = 8, .external_lex_state = 9},
  [341] = {.lex_state = 8, .external_lex_state = 9},
  [342] = {.lex_state = 63, .external_lex_state = 8},
  [343] = {.lex_state = 8, .external_lex_state = 9},
  [344] = {.lex_state = 60, .external_lex_state = 9},
  [345] = {.lex_state = 8, .external_lex_state = 9},
  [346] = {.lex_state = 60, .external_lex_state = 9},
  [347] = {.lex_state = 196, .external_lex_state = 8},
  [348] = {.lex_state = 67, .external_lex_state = 8},
  [349] = {.lex_state = 71, .external_lex_state = 9},
  [350] = {.lex_state = 198, .external_lex_state = 5},
  [351] = {.lex_state = 60, .external_lex_state = 9},
  [352] = {.lex_state = 8, .external_lex_state = 9},
  [353] = {.lex_state = 63, .external_lex_state = 8},
  [354] = {.lex_state = 8, .external_lex_state = 9},
  [355] = {.lex_state = 196, .external_lex_state = 8},
  [356] = {.lex_state = 198, .external_lex_state = 5},
  [357] = {.lex_state = 8, .external_lex_state = 9},
  [358] = {.lex_state = 8, .external_lex_state = 5},
  [359] = {.lex_state = 8, .external_lex_state = 9},
  [360] = {.lex_state = 8, .external_lex_state = 5},
  [361] = {.lex_state = 71, .external_lex_state = 9},
  [362] = {.lex_state = 8, .external_lex_state = 9},
  [363] = {.lex_state = 8, .external_lex_state = 9},
  [364] = {.lex_state = 8, .external_lex_state = 9},
  [365] = {.lex_state = 8, .external_lex_state = 9},
  [366] = {.lex_state = 8, .external_lex_state = 9},
  [367] = {.lex_state = 63, .external_lex_state = 8},
  [368] = {.lex_state = 8, .external_lex_state = 9},
  [369] = {.lex_state = 8, .external_lex_state = 9},
  [370] = {.lex_state = 198, .external_lex_state = 5},
  [371] = {.lex_state = 8, .external_lex_state = 9},
  [372] = {.lex_state = 63, .external_lex_state = 8},
  [373] = {.lex_state = 63, .external_lex_state = 8},
  [374] = {.lex_state = 63, .external_lex_state = 8},
  [375] = {.lex_state = 67, .external_lex_state = 8},
  [376] = {.lex_state = 8, .external_lex_state = 9},
  [377] = {.lex_state = 63, .external_lex_state = 8},
  [378] = {.lex_state = 8, .external_lex_state = 9},
  [379] = {.lex_state = 63, .external_lex_state = 6},
  [380] = {.lex_state = 8, .external_lex_state = 9},
  [381] = {.lex_state = 8, .external_lex_state = 9},
  [382] = {.lex_state = 8, .external_lex_state = 9},
  [383] = {.lex_state = 8, .external_lex_state = 9},
  [384] = {.lex_state = 8, .external_lex_state = 8},
  [385] = {.lex_state = 8, .external_lex_state = 5},
  [386] = {.lex_state = 8, .external_lex_state = 9},
  [387] = {.lex_state = 63, .external_lex_state = 8},
  [388] = {.lex_state = 63, .external_lex_state = 6},
  [389] = {.lex_state = 8, .external_lex_state = 9},
  [390] = {.lex_state = 71, .external_lex_state = 9},
  [391] = {.lex_state = 63, .external_lex_state = 6},
  [392] = {.lex_state = 8, .external_lex_state = 9},
  [393] = {.lex_state = 194, .external_lex_state = 9},
  [394] = {.lex_state = 198, .external_lex_state = 5},
  [395] = {.lex_state = 60, .external_lex_state = 9},
  [396] = {.lex_state = 194, .external_lex_state = 9},
  [397] = {.lex_state = 63, .external_lex_state = 6},
  [398] = {.lex_state = 198, .external_lex_state = 5},
  [399] = {.lex_state = 198, .external_lex_state = 5},
  [400] = {.lex_state = 198, .external_lex_state = 5},
  [401] = {.lex_state = 196, .external_lex_state = 8},
  [402] = {.lex_state = 60, .external_lex_state = 9},
  [403] = {.lex_state = 60, .external_lex_state = 9},
  [404] = {.lex_state = 198, .external_lex_state = 5},
  [405] = {.lex_state = 63, .external_lex_state = 6},
  [406] = {.lex_state = 198, .external_lex_state = 5},
  [407] = {.lex_state = 194, .external_lex_state = 9},
  [408] = {.lex_state = 196, .external_lex_state = 8},
  [409] = {.lex_state = 8, .external_lex_state = 6},
  [410] = {.lex_state = 198, .external_lex_state = 5},
  [411] = {.lex_state = 63, .external_lex_state = 6},
  [412] = {.lex_state = 198, .external_lex_state = 5},
  [413] = {.lex_state = 196, .external_lex_state = 8},
  [414] = {.lex_state = 196, .external_lex_state = 8},
  [415] = {.lex_state = 194, .external_lex_state = 9},
  [416] = {.lex_state = 67, .external_lex_state = 8},
  [417] = {.lex_state = 71, .external_lex_state = 5},
  [418] = {.lex_state = 67, .external_lex_state = 8},
  [419] = {.lex_state = 196, .external_lex_state = 8},
  [420] = {.lex_state = 67, .external_lex_state = 6},
  [421] = {.lex_state = 194, .external_lex_state = 9},
  [422] = {.lex_state = 60, .external_lex_state = 9},
  [423] = {.lex_state = 198, .external_lex_state = 5},
  [424] = {.lex_state = 60, .external_lex_state = 8},
  [425] = {.lex_state = 8, .external_lex_state = 6},
  [426] = {.lex_state = 60, .external_lex_state = 9},
  [427] = {.lex_state = 71, .external_lex_state = 9},
  [428] = {.lex_state = 71, .external_lex_state = 9},
  [429] = {.lex_state = 71, .external_lex_state = 9},
  [430] = {.lex_state = 71, .external_lex_state = 9},
  [431] = {.lex_state = 67, .external_lex_state = 8},
  [432] = {.lex_state = 60, .external_lex_state = 9},
  [433] = {.lex_state = 60, .external_lex_state = 9},
  [434] = {.lex_state = 60, .external_lex_state = 9},
  [435] = {.lex_state = 67, .external_lex_state = 8},
  [436] = {.lex_state = 71, .external_lex_state = 9},
  [437] = {.lex_state = 71, .external_lex_state = 9},
  [438] = {.lex_state = 71, .external_lex_state = 9},
  [439] = {.lex_state = 71, .external_lex_state = 9},
  [440] = {.lex_state = 71, .external_lex_state = 9},
  [441] = {.lex_state = 71, .external_lex_state = 9},
  [442] = {.lex_state = 71, .external_lex_state = 9},
  [443] = {.lex_state = 71, .external_lex_state = 9},
  [444] = {.lex_state = 71, .external_lex_state = 9},
  [445] = {.lex_state = 71, .external_lex_state = 9},
  [446] = {.lex_state = 60, .external_lex_state = 9},
  [447] = {.lex_state = 71, .external_lex_state = 9},
  [448] = {.lex_state = 60, .external_lex_state = 9},
  [449] = {.lex_state = 71, .external_lex_state = 9},
  [450] = {.lex_state = 71, .external_lex_state = 9},
  [451] = {.lex_state = 60, .external_lex_state = 9},
  [452] = {.lex_state = 71, .external_lex_state = 9},
  [453] = {.lex_state = 71, .external_lex_state = 9},
  [454] = {.lex_state = 71, .external_lex_state = 9},
  [455] = {.lex_state = 8, .external_lex_state = 8},
  [456] = {.lex_state = 60, .external_lex_state = 9},
  [457] = {.lex_state = 60, .external_lex_state = 9},
  [458] = {.lex_state = 71, .external_lex_state = 9},
  [459] = {.lex_state = 71, .external_lex_state = 9},
  [460] = {.lex_state = 8, .external_lex_state = 5},
  [461] = {.lex_state = 71, .external_lex_state = 9},
  [462] = {.lex_state = 71, .external_lex_state = 9},
  [463] = {.lex_state = 60, .external_lex_state = 9},
  [464] = {.lex_state = 71, .external_lex_state = 9},
  [465] = {.lex_state = 71, .external_lex_state = 9},
  [466] = {.lex_state = 71, .external_lex_state = 9},
  [467] = {.lex_state = 8, .external_lex_state = 5},
  [468] = {.lex_state = 71, .external_lex_state = 5},
  [469] = {.lex_state = 60, .external_lex_state = 9},
  [470] = {.lex_state = 196, .external_lex_state = 8},
  [471] = {.lex_state = 60, .external_lex_state = 9},
  [472] = {.lex_state = 8, .external_lex_state = 5},
  [473] = {.lex_state = 71, .external_lex_state = 9},
  [474] = {.lex_state = 60, .external_lex_state = 9},
  [475] = {.lex_state = 60, .external_lex_state = 9},
  [476] = {.lex_state = 60, .external_lex_state = 5},
  [477] = {.lex_state = 60, .external_lex_state = 9},
  [478] = {.lex_state = 72, .external_lex_state = 9},
  [479] = {.lex_state = 8, .external_lex_state = 5},
  [480] = {.lex_state = 194, .external_lex_state = 9},
  [481] = {.lex_state = 194, .external_lex_state = 9},
  [482] = {.lex_state = 60, .external_lex_state = 9},
  [483] = {.lex_state = 60, .external_lex_state = 9},
  [484] = {.lex_state = 194, .external_lex_state = 9},
  [485] = {.lex_state = 60, .external_lex_state = 9},
  [486] = {.lex_state = 72, .external_lex_state = 9},
  [487] = {.lex_state = 194, .external_lex_state = 9},
  [488] = {.lex_state = 71, .external_lex_state = 9},
  [489] = {.lex_state = 196, .external_lex_state = 8},
  [490] = {.lex_state = 196, .external_lex_state = 8},
  [491] = {.lex_state = 25, .external_lex_state = 6},
  [492] = {.lex_state = 67, .external_lex_state = 6},
  [493] = {.lex_state = 71, .external_lex_state = 9},
  [494] = {.lex_state = 60, .external_lex_state = 9},
  [495] = {.lex_state = 60, .external_lex_state = 9},
  [496] = {.lex_state = 60, .external_lex_state = 9},
  [497] = {.lex_state = 67, .external_lex_state = 8},
  [498] = {.lex_state = 67, .external_lex_state = 8},
  [499] = {.lex_state = 71, .external_lex_state = 9},
  [500] = {.lex_state = 8, .external_lex_state = 8},
  [501] = {.lex_state = 67, .external_lex_state = 8},
  [502] = {.lex_state = 8, .external_lex_state = 8},
  [503] = {.lex_state = 67, .external_lex_state = 8},
  [504] = {.lex_state = 60, .external_lex_state = 8},
  [505] = {.lex_state = 196, .external_lex_state = 8},
  [506] = {.lex_state = 198, .external_lex_state = 5},
  [507] = {.lex_state = 72, .external_lex_state = 9},
  [508] = {.lex_state = 60, .external_lex_state = 9},
  [509] = {.lex_state = 60, .external_lex_state = 5},
  [510] = {.lex_state = 71, .external_lex_state = 9},
  [511] = {.lex_state = 196, .external_lex_state = 8},
  [512] = {.lex_state = 194, .external_lex_state = 9},
  [513] = {.lex_state = 8, .external_lex_state = 8},
  [514] = {.lex_state = 8, .external_lex_state = 8},
  [515] = {.lex_state = 8, .external_lex_state = 8},
  [516] = {.lex_state = 67, .external_lex_state = 8},
  [517] = {.lex_state = 8, .external_lex_state = 8},
  [518] = {.lex_state = 8, .external_lex_state = 8},
  [519] = {.lex_state = 8, .external_lex_state = 8},
  [520] = {.lex_state = 196, .external_lex_state = 8},
  [521] = {.lex_state = 67, .external_lex_state = 6},
  [522] = {.lex_state = 8, .external_lex_state = 8},
  [523] = {.lex_state = 60, .external_lex_state = 8},
  [524] = {.lex_state = 8, .external_lex_state = 8},
  [525] = {.lex_state = 67, .external_lex_state = 8},
  [526] = {.lex_state = 67, .external_lex_state = 8},
  [527] = {.lex_state = 67, .external_lex_state = 8},
  [528] = {.lex_state = 67, .external_lex_state = 8},
  [529] = {.lex_state = 60, .external_lex_state = 9},
  [530] = {.lex_state = 8, .external_lex_state = 8},
  [531] = {.lex_state = 8, .external_lex_state = 8},
  [532] = {.lex_state = 8, .external_lex_state = 8},
  [533] = {.lex_state = 8, .external_lex_state = 8},
  [534] = {.lex_state = 8, .external_lex_state = 8},
  [535] = {.lex_state = 8, .external_lex_state = 8},
  [536] = {.lex_state = 60, .external_lex_state = 9},
  [537] = {.lex_state = 8, .external_lex_state = 8},
  [538] = {.lex_state = 67, .external_lex_state = 8},
  [539] = {.lex_state = 67, .external_lex_state = 8},
  [540] = {.lex_state = 67, .external_lex_state = 8},
  [541] = {.lex_state = 67, .external_lex_state = 8},
  [542] = {.lex_state = 67, .external_lex_state = 8},
  [543] = {.lex_state = 8, .external_lex_state = 8},
  [544] = {.lex_state = 67, .external_lex_state = 8},
  [545] = {.lex_state = 67, .external_lex_state = 8},
  [546] = {.lex_state = 60, .external_lex_state = 5},
  [547] = {.lex_state = 8, .external_lex_state = 8},
  [548] = {.lex_state = 8, .external_lex_state = 8},
  [549] = {.lex_state = 72, .external_lex_state = 9},
  [550] = {.lex_state = 60, .external_lex_state = 9},
  [551] = {.lex_state = 67, .external_lex_state = 8},
  [552] = {.lex_state = 67, .external_lex_state = 8},
  [553] = {.lex_state = 67, .external_lex_state = 8},
  [554] = {.lex_state = 67, .external_lex_state = 8},
  [555] = {.lex_state = 196, .external_lex_state = 8},
  [556] = {.lex_state = 8, .external_lex_state = 8},
  [557] = {.lex_state = 60, .external_lex_state = 9},
  [558] = {.lex_state = 8, .external_lex_state = 8},
  [559] = {.lex_state = 8, .external_lex_state = 8},
  [560] = {.lex_state = 60, .external_lex_state = 8},
  [561] = {.lex_state = 67, .external_lex_state = 8},
  [562] = {.lex_state = 8, .external_lex_state = 8},
  [563] = {.lex_state = 67, .external_lex_state = 8},
  [564] = {.lex_state = 60, .external_lex_state = 9},
  [565] = {.lex_state = 67, .external_lex_state = 8},
  [566] = {.lex_state = 67, .external_lex_state = 8},
  [567] = {.lex_state = 8, .external_lex_state = 8},
  [568] = {.lex_state = 60, .external_lex_state = 9},
  [569] = {.lex_state = 8, .external_lex_state = 8},
  [570] = {.lex_state = 8, .external_lex_state = 8},
  [571] = {.lex_state = 67, .external_lex_state = 6},
  [572] = {.lex_state = 8, .external_lex_state = 8},
  [573] = {.lex_state = 63, .external_lex_state = 6},
  [574] = {.lex_state = 67, .external_lex_state = 8},
  [575] = {.lex_state = 8, .external_lex_state = 8},
  [576] = {.lex_state = 8, .external_lex_state = 8},
  [577] = {.lex_state = 67, .external_lex_state = 8},
  [578] = {.lex_state = 67, .external_lex_state = 8},
  [579] = {.lex_state = 67, .external_lex_state = 8},
  [580] = {.lex_state = 8, .external_lex_state = 8},
  [581] = {.lex_state = 194, .external_lex_state = 9},
  [582] = {.lex_state = 196, .external_lex_state = 8},
  [583] = {.lex_state = 196, .external_lex_state = 8},
  [584] = {.lex_state = 67, .external_lex_state = 6},
  [585] = {.lex_state = 196, .external_lex_state = 6},
  [586] = {.lex_state = 196, .external_lex_state = 8},
  [587] = {.lex_state = 72, .external_lex_state = 9},
  [588] = {.lex_state = 196, .external_lex_state = 8},
  [589] = {.lex_state = 196, .external_lex_state = 8},
  [590] = {.lex_state = 72, .external_lex_state = 9},
  [591] = {.lex_state = 196, .external_lex_state = 8},
  [592] = {.lex_state = 60, .external_lex_state = 8},
  [593] = {.lex_state = 60, .external_lex_state = 8},
  [594] = {.lex_state = 60, .external_lex_state = 8},
  [595] = {.lex_state = 196, .external_lex_state = 8},
  [596] = {.lex_state = 60, .external_lex_state = 8},
  [597] = {.lex_state = 196, .external_lex_state = 8},
  [598] = {.lex_state = 194, .external_lex_state = 9},
  [599] = {.lex_state = 67, .external_lex_state = 6},
  [600] = {.lex_state = 198, .external_lex_state = 9},
  [601] = {.lex_state = 60, .external_lex_state = 5},
  [602] = {.lex_state = 60, .external_lex_state = 8},
  [603] = {.lex_state = 72, .external_lex_state = 9},
  [604] = {.lex_state = 194, .external_lex_state = 9},
  [605] = {.lex_state = 196, .external_lex_state = 6},
  [606] = {.lex_state = 196, .external_lex_state = 6},
  [607] = {.lex_state = 194, .external_lex_state = 9},
  [608] = {.lex_state = 60, .external_lex_state = 8},
  [609] = {.lex_state = 194, .external_lex_state = 5},
  [610] = {.lex_state = 198, .external_lex_state = 9},
  [611] = {.lex_state = 194, .external_lex_state = 8},
  [612] = {.lex_state = 194, .external_lex_state = 5},
  [613] = {.lex_state = 194, .external_lex_state = 9},
  [614] = {.lex_state = 194, .external_lex_state = 9},
  [615] = {.lex_state = 194, .external_lex_state = 9},
  [616] = {.lex_state = 194, .external_lex_state = 9},
  [617] = {.lex_state = 194, .external_lex_state = 5},
  [618] = {.lex_state = 196, .external_lex_state = 6},
  [619] = {.lex_state = 198, .external_lex_state = 9},
  [620] = {.lex_state = 72, .external_lex_state = 9},
  [621] = {.lex_state = 196, .external_lex_state = 8},
  [622] = {.lex_state = 196, .external_lex_state = 8},
  [623] = {.lex_state = 71, .external_lex_state = 5},
  [624] = {.lex_state = 196, .external_lex_state = 6},
  [625] = {.lex_state = 194, .external_lex_state = 9},
  [626] = {.lex_state = 196, .external_lex_state = 8},
  [627] = {.lex_state = 194, .external_lex_state = 9},
  [628] = {.lex_state = 196, .external_lex_state = 6},
  [629] = {.lex_state = 67, .external_lex_state = 6},
  [630] = {.lex_state = 194, .external_lex_state = 9},
  [631] = {.lex_state = 194, .external_lex_state = 9},
  [632] = {.lex_state = 194, .external_lex_state = 9},
  [633] = {.lex_state = 194, .external_lex_state = 9},
  [634] = {.lex_state = 194, .external_lex_state = 8},
  [635] = {.lex_state = 194, .external_lex_state = 9},
  [636] = {.lex_state = 71, .external_lex_state = 5},
  [637] = {.lex_state = 194, .external_lex_state = 9},
  [638] = {.lex_state = 194, .external_lex_state = 8},
  [639] = {.lex_state = 196, .external_lex_state = 8},
  [640] = {.lex_state = 194, .external_lex_state = 9},
  [641] = {.lex_state = 194, .external_lex_state = 9},
  [642] = {.lex_state = 194, .external_lex_state = 9},
  [643] = {.lex_state = 194, .external_lex_state = 9},
  [644] = {.lex_state = 194, .external_lex_state = 9},
  [645] = {.lex_state = 196, .external_lex_state = 8},
  [646] = {.lex_state = 194, .external_lex_state = 9},
  [647] = {.lex_state = 194, .external_lex_state = 9},
  [648] = {.lex_state = 194, .external_lex_state = 9},
  [649] = {.lex_state = 194, .external_lex_state = 9},
  [650] = {.lex_state = 72, .external_lex_state = 9},
  [651] = {.lex_state = 194, .external_lex_state = 9},
  [652] = {.lex_state = 196, .external_lex_state = 8},
  [653] = {.lex_state = 196, .external_lex_state = 8},
  [654] = {.lex_state = 196, .external_lex_state = 8},
  [655] = {.lex_state = 72, .external_lex_state = 9},
  [656] = {.lex_state = 194, .external_lex_state = 9},
  [657] = {.lex_state = 194, .external_lex_state = 9},
  [658] = {.lex_state = 194, .external_lex_state = 9},
  [659] = {.lex_state = 71, .external_lex_state = 5},
  [660] = {.lex_state = 194, .external_lex_state = 9},
  [661] = {.lex_state = 194, .external_lex_state = 9},
  [662] = {.lex_state = 194, .external_lex_state = 9},
  [663] = {.lex_state = 194, .external_lex_state = 9},
  [664] = {.lex_state = 194, .external_lex_state = 8},
  [665] = {.lex_state = 194, .external_lex_state = 5},
  [666] = {.lex_state = 196, .external_lex_state = 8},
  [667] = {.lex_state = 196, .external_lex_state = 8},
  [668] = {.lex_state = 196, .external_lex_state = 8},
  [669] = {.lex_state = 194, .external_lex_state = 9},
  [670] = {.lex_state = 196, .external_lex_state = 8},
  [671] = {.lex_state = 196, .external_lex_state = 8},
  [672] = {.lex_state = 196, .external_lex_state = 8},
  [673] = {.lex_state = 194, .external_lex_state = 9},
  [674] = {.lex_state = 194, .external_lex_state = 9},
  [675] = {.lex_state = 194, .external_lex_state = 9},
  [676] = {.lex_state = 196, .external_lex_state = 8},
  [677] = {.lex_state = 194, .external_lex_state = 9},
  [678] = {.lex_state = 196, .external_lex_state = 8},
  [679] = {.lex_state = 194, .external_lex_state = 9},
  [680] = {.lex_state = 196, .external_lex_state = 8},
  [681] = {.lex_state = 26, .external_lex_state = 6},
  [682] = {.lex_state = 194, .external_lex_state = 9},
  [683] = {.lex_state = 194, .external_lex_state = 9},
  [684] = {.lex_state = 196, .external_lex_state = 8},
  [685] = {.lex_state = 196, .external_lex_state = 6},
  [686] = {.lex_state = 72, .external_lex_state = 9},
  [687] = {.lex_state = 72, .external_lex_state = 9},
  [688] = {.lex_state = 72, .external_lex_state = 9},
  [689] = {.lex_state = 72, .external_lex_state = 9},
  [690] = {.lex_state = 72, .external_lex_state = 9},
  [691] = {.lex_state = 72, .external_lex_state = 9},
  [692] = {.lex_state = 72, .external_lex_state = 9},
  [693] = {.lex_state = 72, .external_lex_state = 9},
  [694] = {.lex_state = 72, .external_lex_state = 9},
  [695] = {.lex_state = 196, .external_lex_state = 8},
  [696] = {.lex_state = 72, .external_lex_state = 9},
  [697] = {.lex_state = 72, .external_lex_state = 9},
  [698] = {.lex_state = 72, .external_lex_state = 9},
  [699] = {.lex_state = 72, .external_lex_state = 9},
  [700] = {.lex_state = 72, .external_lex_state = 9},
  [701] = {.lex_state = 198, .external_lex_state = 9},
  [702] = {.lex_state = 194, .external_lex_state = 9},
  [703] = {.lex_state = 194, .external_lex_state = 9},
  [704] = {.lex_state = 194, .external_lex_state = 9},
  [705] = {.lex_state = 194, .external_lex_state = 9},
  [706] = {.lex_state = 196, .external_lex_state = 8},
  [707] = {.lex_state = 72, .external_lex_state = 9},
  [708] = {.lex_state = 194, .external_lex_state = 9},
  [709] = {.lex_state = 196, .external_lex_state = 8},
  [710] = {.lex_state = 196, .external_lex_state = 8},
  [711] = {.lex_state = 196, .external_lex_state = 8},
  [712] = {.lex_state = 196, .external_lex_state = 8},
  [713] = {.lex_state = 196, .external_lex_state = 8},
  [714] = {.lex_state = 196, .external_lex_state = 8},
  [715] = {.lex_state = 72, .external_lex_state = 9},
  [716] = {.lex_state = 72, .external_lex_state = 9},
  [717] = {.lex_state = 72, .external_lex_state = 9},
  [718] = {.lex_state = 194, .external_lex_state = 9},
  [719] = {.lex_state = 72, .external_lex_state = 9},
  [720] = {.lex_state = 194, .external_lex_state = 9},
  [721] = {.lex_state = 60, .external_lex_state = 5},
  [722] = {.lex_state = 72, .external_lex_state = 9},
  [723] = {.lex_state = 72, .external_lex_state = 9},
  [724] = {.lex_state = 72, .external_lex_state = 9},
  [725] = {.lex_state = 72, .external_lex_state = 9},
  [726] = {.lex_state = 194, .external_lex_state = 9},
  [727] = {.lex_state = 194, .external_lex_state = 9},
  [728] = {.lex_state = 194, .external_lex_state = 9},
  [729] = {.lex_state = 194, .external_lex_state = 9},
  [730] = {.lex_state = 194, .external_lex_state = 9},
  [731] = {.lex_state = 194, .external_lex_state = 9},
  [732] = {.lex_state = 194, .external_lex_state = 5},
  [733] = {.lex_state = 72, .external_lex_state = 5},
  [734] = {.lex_state = 194, .external_lex_state = 9},
  [735] = {.lex_state = 72, .external_lex_state = 9},
  [736] = {.lex_state = 72, .external_lex_state = 9},
  [737] = {.lex_state = 72, .external_lex_state = 9},
  [738] = {.lex_state = 194, .external_lex_state = 9},
  [739] = {.lex_state = 60, .external_lex_state = 8},
  [740] = {.lex_state = 194, .external_lex_state = 9},
  [741] = {.lex_state = 196, .external_lex_state = 8},
  [742] = {.lex_state = 196, .external_lex_state = 8},
  [743] = {.lex_state = 196, .external_lex_state = 8},
  [744] = {.lex_state = 196, .external_lex_state = 8},
  [745] = {.lex_state = 60, .external_lex_state = 8},
  [746] = {.lex_state = 60, .external_lex_state = 8},
  [747] = {.lex_state = 60, .external_lex_state = 5},
  [748] = {.lex_state = 60, .external_lex_state = 8},
  [749] = {.lex_state = 60, .external_lex_state = 8},
  [750] = {.lex_state = 60, .external_lex_state = 8},
  [751] = {.lex_state = 60, .external_lex_state = 8},
  [752] = {.lex_state = 60, .external_lex_state = 8},
  [753] = {.lex_state = 60, .external_lex_state = 8},
  [754] = {.lex_state = 60, .external_lex_state = 8},
  [755] = {.lex_state = 60, .external_lex_state = 8},
  [756] = {.lex_state = 194, .external_lex_state = 9},
  [757] = {.lex_state = 196, .external_lex_state = 8},
  [758] = {.lex_state = 196, .external_lex_state = 8},
  [759] = {.lex_state = 196, .external_lex_state = 8},
  [760] = {.lex_state = 196, .external_lex_state = 8},
  [761] = {.lex_state = 196, .external_lex_state = 8},
  [762] = {.lex_state = 60, .external_lex_state = 8},
  [763] = {.lex_state = 196, .external_lex_state = 6},
  [764] = {.lex_state = 60, .external_lex_state = 8},
  [765] = {.lex_state = 60, .external_lex_state = 8},
  [766] = {.lex_state = 60, .external_lex_state = 8},
  [767] = {.lex_state = 60, .external_lex_state = 8},
  [768] = {.lex_state = 60, .external_lex_state = 8},
  [769] = {.lex_state = 60, .external_lex_state = 8},
  [770] = {.lex_state = 196, .external_lex_state = 8},
  [771] = {.lex_state = 196, .external_lex_state = 8},
  [772] = {.lex_state = 196, .external_lex_state = 8},
  [773] = {.lex_state = 196, .external_lex_state = 8},
  [774] = {.lex_state = 196, .external_lex_state = 8},
  [775] = {.lex_state = 60, .external_lex_state = 8},
  [776] = {.lex_state = 194, .external_lex_state = 8},
  [777] = {.lex_state = 60, .external_lex_state = 8},
  [778] = {.lex_state = 60, .external_lex_state = 8},
  [779] = {.lex_state = 60, .external_lex_state = 8},
  [780] = {.lex_state = 60, .external_lex_state = 8},
  [781] = {.lex_state = 60, .external_lex_state = 6},
  [782] = {.lex_state = 196, .external_lex_state = 8},
  [783] = {.lex_state = 196, .external_lex_state = 8},
  [784] = {.lex_state = 196, .external_lex_state = 8},
  [785] = {.lex_state = 196, .external_lex_state = 8},
  [786] = {.lex_state = 60, .external_lex_state = 8},
  [787] = {.lex_state = 60, .external_lex_state = 8},
  [788] = {.lex_state = 60, .external_lex_state = 8},
  [789] = {.lex_state = 194, .external_lex_state = 9},
  [790] = {.lex_state = 194, .external_lex_state = 9},
  [791] = {.lex_state = 194, .external_lex_state = 9},
  [792] = {.lex_state = 194, .external_lex_state = 9},
  [793] = {.lex_state = 196, .external_lex_state = 8},
  [794] = {.lex_state = 196, .external_lex_state = 8},
  [795] = {.lex_state = 194, .external_lex_state = 9},
  [796] = {.lex_state = 194, .external_lex_state = 9},
  [797] = {.lex_state = 194, .external_lex_state = 8},
  [798] = {.lex_state = 194, .external_lex_state = 5},
  [799] = {.lex_state = 196, .external_lex_state = 8},
  [800] = {.lex_state = 194, .external_lex_state = 8},
  [801] = {.lex_state = 196, .external_lex_state = 8},
  [802] = {.lex_state = 198, .external_lex_state = 9},
  [803] = {.lex_state = 196, .external_lex_state = 8},
  [804] = {.lex_state = 196, .external_lex_state = 8},
  [805] = {.lex_state = 196, .external_lex_state = 8},
  [806] = {.lex_state = 196, .external_lex_state = 8},
  [807] = {.lex_state = 187, .external_lex_state = 6},
  [808] = {.lex_state = 67, .external_lex_state = 6},
  [809] = {.lex_state = 194, .external_lex_state = 8},
  [810] = {.lex_state = 71, .external_lex_state = 5},
  [811] = {.lex_state = 60, .external_lex_state = 5},
  [812] = {.lex_state = 198, .external_lex_state = 9},
  [813] = {.lex_state = 72, .external_lex_state = 5},
  [814] = {.lex_state = 8, .external_lex_state = 6},
  [815] = {.lex_state = 198, .external_lex_state = 9},
  [816] = {.lex_state = 196, .external_lex_state = 8},
  [817] = {.lex_state = 196, .external_lex_state = 8},
  [818] = {.lex_state = 198, .external_lex_state = 9},
  [819] = {.lex_state = 60, .external_lex_state = 6},
  [820] = {.lex_state = 196, .external_lex_state = 8},
  [821] = {.lex_state = 196, .external_lex_state = 8},
  [822] = {.lex_state = 194, .external_lex_state = 8},
  [823] = {.lex_state = 198, .external_lex_state = 9},
  [824] = {.lex_state = 60, .external_lex_state = 6},
  [825] = {.lex_state = 96, .external_lex_state = 2},
  [826] = {.lex_state = 72, .external_lex_state = 5},
  [827] = {.lex_state = 198, .external_lex_state = 9},
  [828] = {.lex_state = 196, .external_lex_state = 6},
  [829] = {.lex_state = 198, .external_lex_state = 9},
  [830] = {.lex_state = 198, .external_lex_state = 9},
  [831] = {.lex_state = 196, .external_lex_state = 6},
  [832] = {.lex_state = 194, .external_lex_state = 8},
  [833] = {.lex_state = 198, .external_lex_state = 9},
  [834] = {.lex_state = 198, .external_lex_state = 9},
  [835] = {.lex_state = 198, .external_lex_state = 9},
  [836] = {.lex_state = 198, .external_lex_state = 9},
  [837] = {.lex_state = 198, .external_lex_state = 9},
  [838] = {.lex_state = 198, .external_lex_state = 9},
  [839] = {.lex_state = 198, .external_lex_state = 9},
  [840] = {.lex_state = 198, .external_lex_state = 9},
  [841] = {.lex_state = 198, .external_lex_state = 9},
  [842] = {.lex_state = 198, .external_lex_state = 9},
  [843] = {.lex_state = 198, .external_lex_state = 9},
  [844] = {.lex_state = 198, .external_lex_state = 9},
  [845] = {.lex_state = 198, .external_lex_state = 9},
  [846] = {.lex_state = 198, .external_lex_state = 9},
  [847] = {.lex_state = 194, .external_lex_state = 5},
  [848] = {.lex_state = 96, .external_lex_state = 2},
  [849] = {.lex_state = 198, .external_lex_state = 9},
  [850] = {.lex_state = 198, .external_lex_state = 9},
  [851] = {.lex_state = 198, .external_lex_state = 9},
  [852] = {.lex_state = 198, .external_lex_state = 9},
  [853] = {.lex_state = 198, .external_lex_state = 9},
  [854] = {.lex_state = 198, .external_lex_state = 9},
  [855] = {.lex_state = 198, .external_lex_state = 9},
  [856] = {.lex_state = 198, .external_lex_state = 9},
  [857] = {.lex_state = 198, .external_lex_state = 9},
  [858] = {.lex_state = 198, .external_lex_state = 9},
  [859] = {.lex_state = 198, .external_lex_state = 9},
  [860] = {.lex_state = 198, .external_lex_state = 9},
  [861] = {.lex_state = 198, .external_lex_state = 9},
  [862] = {.lex_state = 198, .external_lex_state = 9},
  [863] = {.lex_state = 198, .external_lex_state = 9},
  [864] = {.lex_state = 194, .external_lex_state = 8},
  [865] = {.lex_state = 194, .external_lex_state = 8},
  [866] = {.lex_state = 198, .external_lex_state = 5},
  [867] = {.lex_state = 194, .external_lex_state = 6},
  [868] = {.lex_state = 194, .external_lex_state = 8},
  [869] = {.lex_state = 72, .external_lex_state = 5},
  [870] = {.lex_state = 196, .external_lex_state = 6},
  [871] = {.lex_state = 194, .external_lex_state = 8},
  [872] = {.lex_state = 194, .external_lex_state = 8},
  [873] = {.lex_state = 194, .external_lex_state = 8},
  [874] = {.lex_state = 194, .external_lex_state = 8},
  [875] = {.lex_state = 194, .external_lex_state = 8},
  [876] = {.lex_state = 194, .external_lex_state = 8},
  [877] = {.lex_state = 194, .external_lex_state = 8},
  [878] = {.lex_state = 194, .external_lex_state = 8},
  [879] = {.lex_state = 194, .external_lex_state = 5},
  [880] = {.lex_state = 194, .external_lex_state = 8},
  [881] = {.lex_state = 194, .external_lex_state = 8},
  [882] = {.lex_state = 194, .external_lex_state = 8},
  [883] = {.lex_state = 194, .external_lex_state = 8},
  [884] = {.lex_state = 194, .external_lex_state = 8},
  [885] = {.lex_state = 194, .external_lex_state = 8},
  [886] = {.lex_state = 194, .external_lex_state = 8},
  [887] = {.lex_state = 194, .external_lex_state = 8},
  [888] = {.lex_state = 194, .external_lex_state = 8},
  [889] = {.lex_state = 194, .external_lex_state = 8},
  [890] = {.lex_state = 194, .external_lex_state = 5},
  [891] = {.lex_state = 194, .external_lex_state = 8},
  [892] = {.lex_state = 194, .external_lex_state = 8},
  [893] = {.lex_state = 194, .external_lex_state = 8},
  [894] = {.lex_state = 96, .external_lex_state = 2},
  [895] = {.lex_state = 194, .external_lex_state = 8},
  [896] = {.lex_state = 194, .external_lex_state = 8},
  [897] = {.lex_state = 194, .external_lex_state = 8},
  [898] = {.lex_state = 194, .external_lex_state = 8},
  [899] = {.lex_state = 194, .external_lex_state = 8},
  [900] = {.lex_state = 194, .external_lex_state = 5},
  [901] = {.lex_state = 194, .external_lex_state = 8},
  [902] = {.lex_state = 194, .external_lex_state = 8},
  [903] = {.lex_state = 194, .external_lex_state = 8},
  [904] = {.lex_state = 194, .external_lex_state = 8},
  [905] = {.lex_state = 194, .external_lex_state = 6},
  [906] = {.lex_state = 194, .external_lex_state = 8},
  [907] = {.lex_state = 194, .external_lex_state = 8},
  [908] = {.lex_state = 194, .external_lex_state = 8},
  [909] = {.lex_state = 194, .external_lex_state = 8},
  [910] = {.lex_state = 194, .external_lex_state = 8},
  [911] = {.lex_state = 194, .external_lex_state = 8},
  [912] = {.lex_state = 198, .external_lex_state = 5},
  [913] = {.lex_state = 194, .external_lex_state = 8},
  [914] = {.lex_state = 194, .external_lex_state = 8},
  [915] = {.lex_state = 196, .external_lex_state = 6},
  [916] = {.lex_state = 196, .external_lex_state = 6},
  [917] = {.lex_state = 194, .external_lex_state = 8},
  [918] = {.lex_state = 198, .external_lex_state = 5},
  [919] = {.lex_state = 194, .external_lex_state = 8},
  [920] = {.lex_state = 196, .external_lex_state = 6},
  [921] = {.lex_state = 194, .external_lex_state = 8},
  [922] = {.lex_state = 194, .external_lex_state = 8},
  [923] = {.lex_state = 194, .external_lex_state = 8},
  [924] = {.lex_state = 196, .external_lex_state = 6},
  [925] = {.lex_state = 198, .external_lex_state = 5},
  [926] = {.lex_state = 194, .external_lex_state = 8},
  [927] = {.lex_state = 194, .external_lex_state = 8},
  [928] = {.lex_state = 194, .external_lex_state = 5},
  [929] = {.lex_state = 198, .external_lex_state = 9},
  [930] = {.lex_state = 198, .external_lex_state = 9},
  [931] = {.lex_state = 198, .external_lex_state = 9},
  [932] = {.lex_state = 194, .external_lex_state = 6},
  [933] = {.lex_state = 198, .external_lex_state = 9},
  [934] = {.lex_state = 194, .external_lex_state = 5},
  [935] = {.lex_state = 198, .external_lex_state = 9},
  [936] = {.lex_state = 198, .external_lex_state = 9},
  [937] = {.lex_state = 198, .external_lex_state = 9},
  [938] = {.lex_state = 198, .external_lex_state = 9},
  [939] = {.lex_state = 96, .external_lex_state = 2},
  [940] = {.lex_state = 196, .external_lex_state = 6},
  [941] = {.lex_state = 198, .external_lex_state = 9},
  [942] = {.lex_state = 198, .external_lex_state = 9},
  [943] = {.lex_state = 198, .external_lex_state = 9},
  [944] = {.lex_state = 198, .external_lex_state = 9},
  [945] = {.lex_state = 198, .external_lex_state = 9},
  [946] = {.lex_state = 198, .external_lex_state = 9},
  [947] = {.lex_state = 198, .external_lex_state = 9},
  [948] = {.lex_state = 198, .external_lex_state = 9},
  [949] = {.lex_state = 198, .external_lex_state = 9},
  [950] = {.lex_state = 198, .external_lex_state = 9},
  [951] = {.lex_state = 194, .external_lex_state = 5},
  [952] = {.lex_state = 194, .external_lex_state = 8},
  [953] = {.lex_state = 198, .external_lex_state = 9},
  [954] = {.lex_state = 194, .external_lex_state = 8},
  [955] = {.lex_state = 198, .external_lex_state = 9},
  [956] = {.lex_state = 198, .external_lex_state = 9},
  [957] = {.lex_state = 194, .external_lex_state = 5},
  [958] = {.lex_state = 198, .external_lex_state = 9},
  [959] = {.lex_state = 198, .external_lex_state = 9},
  [960] = {.lex_state = 198, .external_lex_state = 9},
  [961] = {.lex_state = 194, .external_lex_state = 6},
  [962] = {.lex_state = 198, .external_lex_state = 9},
  [963] = {.lex_state = 198, .external_lex_state = 9},
  [964] = {.lex_state = 198, .external_lex_state = 9},
  [965] = {.lex_state = 194, .external_lex_state = 8},
  [966] = {.lex_state = 96, .external_lex_state = 2},
  [967] = {.lex_state = 198, .external_lex_state = 9},
  [968] = {.lex_state = 198, .external_lex_state = 9},
  [969] = {.lex_state = 198, .external_lex_state = 9},
  [970] = {.lex_state = 198, .external_lex_state = 9},
  [971] = {.lex_state = 72, .external_lex_state = 5},
  [972] = {.lex_state = 194, .external_lex_state = 8},
  [973] = {.lex_state = 72, .external_lex_state = 5},
  [974] = {.lex_state = 194, .external_lex_state = 8},
  [975] = {.lex_state = 187, .external_lex_state = 6},
  [976] = {.lex_state = 194, .external_lex_state = 8},
  [977] = {.lex_state = 194, .external_lex_state = 8},
  [978] = {.lex_state = 194, .external_lex_state = 8},
  [979] = {.lex_state = 194, .external_lex_state = 8},
  [980] = {.lex_state = 194, .external_lex_state = 8},
  [981] = {.lex_state = 194, .external_lex_state = 8},
  [982] = {.lex_state = 194, .external_lex_state = 8},
  [983] = {.lex_state = 194, .external_lex_state = 8},
  [984] = {.lex_state = 194, .external_lex_state = 8},
  [985] = {.lex_state = 198, .external_lex_state = 5},
  [986] = {.lex_state = 198, .external_lex_state = 5},
  [987] = {.lex_state = 198, .external_lex_state = 5},
  [988] = {.lex_state = 194, .external_lex_state = 6},
  [989] = {.lex_state = 198, .external_lex_state = 5},
  [990] = {.lex_state = 194, .external_lex_state = 6},
  [991] = {.lex_state = 198, .external_lex_state = 5},
  [992] = {.lex_state = 33, .external_lex_state = 10},
  [993] = {.lex_state = 198, .external_lex_state = 5},
  [994] = {.lex_state = 198, .external_lex_state = 5},
  [995] = {.lex_state = 198, .external_lex_state = 5},
  [996] = {.lex_state = 89},
  [997] = {.lex_state = 37, .external_lex_state = 10},
  [998] = {.lex_state = 37, .external_lex_state = 10},
  [999] = {.lex_state = 37, .external_lex_state = 10},
  [1000] = {.lex_state = 37, .external_lex_state = 10},
  [1001] = {.lex_state = 78, .external_lex_state = 2},
  [1002] = {.lex_state = 37, .external_lex_state = 10},
  [1003] = {.lex_state = 37, .external_lex_state = 10},
  [1004] = {.lex_state = 37, .external_lex_state = 10},
  [1005] = {.lex_state = 37, .external_lex_state = 10},
  [1006] = {.lex_state = 37, .external_lex_state = 10},
  [1007] = {.lex_state = 88},
  [1008] = {.lex_state = 88, .external_lex_state = 11},
  [1009] = {.lex_state = 94, .external_lex_state = 12},
  [1010] = {.lex_state = 93, .external_lex_state = 13},
  [1011] = {.lex_state = 93, .external_lex_state = 13},
  [1012] = {.lex_state = 93, .external_lex_state = 13},
  [1013] = {.lex_state = 94, .external_lex_state = 12},
  [1014] = {.lex_state = 94, .external_lex_state = 12},
  [1015] = {.lex_state = 93, .external_lex_state = 13},
  [1016] = {.lex_state = 93, .external_lex_state = 13},
  [1017] = {.lex_state = 94, .external_lex_state = 12},
  [1018] = {.lex_state = 94, .external_lex_state = 12},
  [1019] = {.lex_state = 94, .external_lex_state = 12},
  [1020] = {.lex_state = 93, .external_lex_state = 13},
  [1021] = {.lex_state = 93, .external_lex_state = 13},
  [1022] = {.lex_state = 94, .external_lex_state = 12},
  [1023] = {.lex_state = 93, .external_lex_state = 13},
  [1024] = {.lex_state = 93, .external_lex_state = 13},
  [1025] = {.lex_state = 94, .external_lex_state = 12},
  [1026] = {.lex_state = 94, .external_lex_state = 12},
  [1027] = {.lex_state = 94, .external_lex_state = 12},
  [1028] = {.lex_state = 94, .external_lex_state = 12},
  [1029] = {.lex_state = 94, .external_lex_state = 12},
  [1030] = {.lex_state = 93, .external_lex_state = 13},
  [1031] = {.lex_state = 93, .external_lex_state = 13},
  [1032] = {.lex_state = 94, .external_lex_state = 12},
  [1033] = {.lex_state = 93, .external_lex_state = 13},
  [1034] = {.lex_state = 93, .external_lex_state = 13},
  [1035] = {.lex_state = 94, .external_lex_state = 12},
  [1036] = {.lex_state = 94, .external_lex_state = 12},
  [1037] = {.lex_state = 93, .external_lex_state = 13},
  [1038] = {.lex_state = 93, .external_lex_state = 13},
  [1039] = {.lex_state = 93, .external_lex_state = 13},
  [1040] = {.lex_state = 93, .external_lex_state = 13},
  [1041] = {.lex_state = 94, .external_lex_state = 12},
  [1042] = {.lex_state = 93, .external_lex_state = 13},
  [1043] = {.lex_state = 94, .external_lex_state = 12},
  [1044] = {.lex_state = 94, .external_lex_state = 12},
  [1045] = {.lex_state = 94, .external_lex_state = 12},
  [1046] = {.lex_state = 94, .external_lex_state = 12},
  [1047] = {.lex_state = 93, .external_lex_state = 13},
  [1048] = {.lex_state = 93, .external_lex_state = 13},
  [1049] = {.lex_state = 94, .external_lex_state = 12},
  [1050] = {.lex_state = 94, .external_lex_state = 12},
  [1051] = {.lex_state = 94, .external_lex_state = 12},
  [1052] = {.lex_state = 93, .external_lex_state = 13},
  [1053] = {.lex_state = 93, .external_lex_state = 13},
  [1054] = {.lex_state = 94, .external_lex_state = 12},
  [1055] = {.lex_state = 93, .external_lex_state = 13},
  [1056] = {.lex_state = 93, .external_lex_state = 13},
  [1057] = {.lex_state = 94, .external_lex_state = 12},
  [1058] = {.lex_state = 94, .external_lex_state = 12},
  [1059] = {.lex_state = 94, .external_lex_state = 12},
  [1060] = {.lex_state = 94, .external_lex_state = 12},
  [1061] = {.lex_state = 93, .external_lex_state = 13},
  [1062] = {.lex_state = 93, .external_lex_state = 13},
  [1063] = {.lex_state = 93, .external_lex_state = 13},
  [1064] = {.lex_state = 94, .external_lex_state = 12},
  [1065] = {.lex_state = 94, .external_lex_state = 12},
  [1066] = {.lex_state = 93, .external_lex_state = 13},
  [1067] = {.lex_state = 93, .external_lex_state = 13},
  [1068] = {.lex_state = 93, .external_lex_state = 13},
  [1069] = {.lex_state = 94, .external_lex_state = 12},
  [1070] = {.lex_state = 93, .external_lex_state = 13},
  [1071] = {.lex_state = 93, .external_lex_state = 13},
  [1072] = {.lex_state = 94, .external_lex_state = 12},
  [1073] = {.lex_state = 94, .external_lex_state = 12},
  [1074] = {.lex_state = 94, .external_lex_state = 12},
  [1075] = {.lex_state = 84},
  [1076] = {.lex_state = 94, .external_lex_state = 12},
  [1077] = {.lex_state = 94, .external_lex_state = 12},
  [1078] = {.lex_state = 93, .external_lex_state = 13},
  [1079] = {.lex_state = 93, .external_lex_state = 13},
  [1080] = {.lex_state = 94, .external_lex_state = 12},
  [1081] = {.lex_state = 94, .external_lex_state = 12},
  [1082] = {.lex_state = 94, .external_lex_state = 12},
  [1083] = {.lex_state = 93, .external_lex_state = 13},
  [1084] = {.lex_state = 94, .external_lex_state = 12},
  [1085] = {.lex_state = 94, .external_lex_state = 12},
  [1086] = {.lex_state = 93, .external_lex_state = 13},
  [1087] = {.lex_state = 93, .external_lex_state = 13},
  [1088] = {.lex_state = 94, .external_lex_state = 12},
  [1089] = {.lex_state = 93, .external_lex_state = 13},
  [1090] = {.lex_state = 93, .external_lex_state = 13},
  [1091] = {.lex_state = 94, .external_lex_state = 12},
  [1092] = {.lex_state = 93, .external_lex_state = 13},
  [1093] = {.lex_state = 93, .external_lex_state = 13},
  [1094] = {.lex_state = 93, .external_lex_state = 13},
  [1095] = {.lex_state = 94, .external_lex_state = 12},
  [1096] = {.lex_state = 94, .external_lex_state = 12},
  [1097] = {.lex_state = 93, .external_lex_state = 13},
  [1098] = {.lex_state = 94, .external_lex_state = 12},
  [1099] = {.lex_state = 94, .external_lex_state = 12},
  [1100] = {.lex_state = 93, .external_lex_state = 13},
  [1101] = {.lex_state = 93, .external_lex_state = 13},
  [1102] = {.lex_state = 93, .external_lex_state = 13},
  [1103] = {.lex_state = 94, .external_lex_state = 12},
  [1104] = {.lex_state = 94, .external_lex_state = 12},
  [1105] = {.lex_state = 93, .external_lex_state = 13},
  [1106] = {.lex_state = 93, .external_lex_state = 13},
  [1107] = {.lex_state = 93, .external_lex_state = 13},
  [1108] = {.lex_state = 93, .external_lex_state = 13},
  [1109] = {.lex_state = 93, .external_lex_state = 13},
  [1110] = {.lex_state = 94, .external_lex_state = 12},
  [1111] = {.lex_state = 93, .external_lex_state = 13},
  [1112] = {.lex_state = 94, .external_lex_state = 12},
  [1113] = {.lex_state = 94, .external_lex_state = 12},
  [1114] = {.lex_state = 94, .external_lex_state = 12},
  [1115] = {.lex_state = 84},
  [1116] = {.lex_state = 84},
  [1117] = {.lex_state = 93, .external_lex_state = 13},
  [1118] = {.lex_state = 93, .external_lex_state = 13},
  [1119] = {.lex_state = 93, .external_lex_state = 13},
  [1120] = {.lex_state = 94, .external_lex_state = 12},
  [1121] = {.lex_state = 94, .external_lex_state = 12},
  [1122] = {.lex_state = 94, .external_lex_state = 12},
  [1123] = {.lex_state = 94, .external_lex_state = 12},
  [1124] = {.lex_state = 94, .external_lex_state = 12},
  [1125] = {.lex_state = 93, .external_lex_state = 13},
  [1126] = {.lex_state = 94, .external_lex_state = 12},
  [1127] = {.lex_state = 93, .external_lex_state = 13},
  [1128] = {.lex_state = 93, .external_lex_state = 13},
  [1129] = {.lex_state = 93, .external_lex_state = 13},
  [1130] = {.lex_state = 93, .external_lex_state = 13},
  [1131] = {.lex_state = 93, .external_lex_state = 13},
  [1132] = {.lex_state = 93, .external_lex_state = 13},
  [1133] = {.lex_state = 93, .external_lex_state = 13},
  [1134] = {.lex_state = 94, .external_lex_state = 12},
  [1135] = {.lex_state = 94, .external_lex_state = 12},
  [1136] = {.lex_state = 94, .external_lex_state = 12},
  [1137] = {.lex_state = 94, .external_lex_state = 12},
  [1138] = {.lex_state = 94, .external_lex_state = 12},
  [1139] = {.lex_state = 94, .external_lex_state = 12},
  [1140] = {.lex_state = 93, .external_lex_state = 13},
  [1141] = {.lex_state = 94, .external_lex_state = 12},
  [1142] = {.lex_state = 93, .external_lex_state = 13},
  [1143] = {.lex_state = 93, .external_lex_state = 13},
  [1144] = {.lex_state = 94, .external_lex_state = 12},
  [1145] = {.lex_state = 94, .external_lex_state = 12},
  [1146] = {.lex_state = 93, .external_lex_state = 13},
  [1147] = {.lex_state = 93, .external_lex_state = 13},
  [1148] = {.lex_state = 94, .external_lex_state = 12},
  [1149] = {.lex_state = 94, .external_lex_state = 12},
  [1150] = {.lex_state = 93, .external_lex_state = 13},
  [1151] = {.lex_state = 93, .external_lex_state = 13},
  [1152] = {.lex_state = 93, .external_lex_state = 13},
  [1153] = {.lex_state = 94, .external_lex_state = 12},
  [1154] = {.lex_state = 94, .external_lex_state = 12},
  [1155] = {.lex_state = 94, .external_lex_state = 12},
  [1156] = {.lex_state = 94, .external_lex_state = 12},
  [1157] = {.lex_state = 94, .external_lex_state = 12},
  [1158] = {.lex_state = 94, .external_lex_state = 12},
  [1159] = {.lex_state = 93, .external_lex_state = 13},
  [1160] = {.lex_state = 93, .external_lex_state = 13},
  [1161] = {.lex_state = 94, .external_lex_state = 12},
  [1162] = {.lex_state = 94, .external_lex_state = 12},
  [1163] = {.lex_state = 94, .external_lex_state = 12},
  [1164] = {.lex_state = 94, .external_lex_state = 12},
  [1165] = {.lex_state = 93, .external_lex_state = 13},
  [1166] = {.lex_state = 93, .external_lex_state = 13},
  [1167] = {.lex_state = 93, .external_lex_state = 13},
  [1168] = {.lex_state = 94, .external_lex_state = 12},
  [1169] = {.lex_state = 84},
  [1170] = {.lex_state = 93, .external_lex_state = 13},
  [1171] = {.lex_state = 93, .external_lex_state = 13},
  [1172] = {.lex_state = 94, .external_lex_state = 12},
  [1173] = {.lex_state = 94, .external_lex_state = 12},
  [1174] = {.lex_state = 93, .external_lex_state = 13},
  [1175] = {.lex_state = 93, .external_lex_state = 13},
  [1176] = {.lex_state = 93, .external_lex_state = 13},
  [1177] = {.lex_state = 94, .external_lex_state = 12},
  [1178] = {.lex_state = 94, .external_lex_state = 12},
  [1179] = {.lex_state = 93, .external_lex_state = 13},
  [1180] = {.lex_state = 93, .external_lex_state = 13},
  [1181] = {.lex_state = 94, .external_lex_state = 12},
  [1182] = {.lex_state = 94, .external_lex_state = 12},
  [1183] = {.lex_state = 93, .external_lex_state = 13},
  [1184] = {.lex_state = 93, .external_lex_state = 13},
  [1185] = {.lex_state = 94, .external_lex_state = 12},
  [1186] = {.lex_state = 94, .external_lex_state = 12},
  [1187] = {.lex_state = 93, .external_lex_state = 13},
  [1188] = {.lex_state = 93, .external_lex_state = 13},
  [1189] = {.lex_state = 94, .external_lex_state = 12},
  [1190] = {.lex_state = 93, .external_lex_state = 13},
  [1191] = {.lex_state = 93, .external_lex_state = 13},
  [1192] = {.lex_state = 94, .external_lex_state = 12},
  [1193] = {.lex_state = 93, .external_lex_state = 13},
  [1194] = {.lex_state = 94, .external_lex_state = 12},
  [1195] = {.lex_state = 93, .external_lex_state = 13},
  [1196] = {.lex_state = 94, .external_lex_state = 12},
  [1197] = {.lex_state = 94, .external_lex_state = 12},
  [1198] = {.lex_state = 93, .external_lex_state = 13},
  [1199] = {.lex_state = 93, .external_lex_state = 13},
  [1200] = {.lex_state = 93, .external_lex_state = 13},
  [1201] = {.lex_state = 94, .external_lex_state = 12},
  [1202] = {.lex_state = 94, .external_lex_state = 12},
  [1203] = {.lex_state = 93, .external_lex_state = 13},
  [1204] = {.lex_state = 94, .external_lex_state = 12},
  [1205] = {.lex_state = 94, .external_lex_state = 12},
  [1206] = {.lex_state = 94, .external_lex_state = 12},
  [1207] = {.lex_state = 93, .external_lex_state = 13},
  [1208] = {.lex_state = 93, .external_lex_state = 13},
  [1209] = {.lex_state = 93, .external_lex_state = 13},
  [1210] = {.lex_state = 94, .external_lex_state = 12},
  [1211] = {.lex_state = 94, .external_lex_state = 12},
  [1212] = {.lex_state = 93, .external_lex_state = 13},
  [1213] = {.lex_state = 93, .external_lex_state = 13},
  [1214] = {.lex_state = 93, .external_lex_state = 13},
  [1215] = {.lex_state = 94, .external_lex_state = 12},
  [1216] = {.lex_state = 93, .external_lex_state = 13},
  [1217] = {.lex_state = 94, .external_lex_state = 12},
  [1218] = {.lex_state = 94, .external_lex_state = 12},
  [1219] = {.lex_state = 94, .external_lex_state = 12},
  [1220] = {.lex_state = 93, .external_lex_state = 13},
  [1221] = {.lex_state = 93, .external_lex_state = 13},
  [1222] = {.lex_state = 94, .external_lex_state = 12},
  [1223] = {.lex_state = 94, .external_lex_state = 12},
  [1224] = {.lex_state = 93, .external_lex_state = 13},
  [1225] = {.lex_state = 93, .external_lex_state = 13},
  [1226] = {.lex_state = 94, .external_lex_state = 12},
  [1227] = {.lex_state = 94, .external_lex_state = 12},
  [1228] = {.lex_state = 94, .external_lex_state = 12},
  [1229] = {.lex_state = 94, .external_lex_state = 12},
  [1230] = {.lex_state = 93, .external_lex_state = 13},
  [1231] = {.lex_state = 93, .external_lex_state = 13},
  [1232] = {.lex_state = 93, .external_lex_state = 13},
  [1233] = {.lex_state = 93, .external_lex_state = 13},
  [1234] = {.lex_state = 94, .external_lex_state = 12},
  [1235] = {.lex_state = 94, .external_lex_state = 12},
  [1236] = {.lex_state = 94, .external_lex_state = 12},
  [1237] = {.lex_state = 93, .external_lex_state = 13},
  [1238] = {.lex_state = 94, .external_lex_state = 12},
  [1239] = {.lex_state = 94, .external_lex_state = 12},
  [1240] = {.lex_state = 93, .external_lex_state = 13},
  [1241] = {.lex_state = 93, .external_lex_state = 13},
  [1242] = {.lex_state = 84, .external_lex_state = 14},
  [1243] = {.lex_state = 93, .external_lex_state = 13},
  [1244] = {.lex_state = 93, .external_lex_state = 13},
  [1245] = {.lex_state = 94, .external_lex_state = 12},
  [1246] = {.lex_state = 94, .external_lex_state = 12},
  [1247] = {.lex_state = 94, .external_lex_state = 12},
  [1248] = {.lex_state = 93, .external_lex_state = 13},
  [1249] = {.lex_state = 93, .external_lex_state = 13},
  [1250] = {.lex_state = 94, .external_lex_state = 12},
  [1251] = {.lex_state = 94, .external_lex_state = 12},
  [1252] = {.lex_state = 94, .external_lex_state = 12},
  [1253] = {.lex_state = 93, .external_lex_state = 13},
  [1254] = {.lex_state = 93, .external_lex_state = 13},
  [1255] = {.lex_state = 93, .external_lex_state = 13},
  [1256] = {.lex_state = 94, .external_lex_state = 12},
  [1257] = {.lex_state = 94, .external_lex_state = 12},
  [1258] = {.lex_state = 94, .external_lex_state = 12},
  [1259] = {.lex_state = 94, .external_lex_state = 12},
  [1260] = {.lex_state = 94, .external_lex_state = 12},
  [1261] = {.lex_state = 93, .external_lex_state = 13},
  [1262] = {.lex_state = 93, .external_lex_state = 13},
  [1263] = {.lex_state = 93, .external_lex_state = 13},
  [1264] = {.lex_state = 93, .external_lex_state = 13},
  [1265] = {.lex_state = 94, .external_lex_state = 12},
  [1266] = {.lex_state = 93, .external_lex_state = 13},
  [1267] = {.lex_state = 94, .external_lex_state = 12},
  [1268] = {.lex_state = 94, .external_lex_state = 12},
  [1269] = {.lex_state = 93, .external_lex_state = 13},
  [1270] = {.lex_state = 94, .external_lex_state = 12},
  [1271] = {.lex_state = 93, .external_lex_state = 13},
  [1272] = {.lex_state = 84, .external_lex_state = 14},
  [1273] = {.lex_state = 93, .external_lex_state = 13},
  [1274] = {.lex_state = 93, .external_lex_state = 13},
  [1275] = {.lex_state = 93, .external_lex_state = 13},
  [1276] = {.lex_state = 93, .external_lex_state = 13},
  [1277] = {.lex_state = 93, .external_lex_state = 13},
  [1278] = {.lex_state = 93, .external_lex_state = 13},
  [1279] = {.lex_state = 94, .external_lex_state = 12},
  [1280] = {.lex_state = 93, .external_lex_state = 13},
  [1281] = {.lex_state = 94, .external_lex_state = 12},
  [1282] = {.lex_state = 94, .external_lex_state = 12},
  [1283] = {.lex_state = 94, .external_lex_state = 12},
  [1284] = {.lex_state = 84, .external_lex_state = 14},
  [1285] = {.lex_state = 93, .external_lex_state = 13},
  [1286] = {.lex_state = 93, .external_lex_state = 13},
  [1287] = {.lex_state = 94, .external_lex_state = 12},
  [1288] = {.lex_state = 94, .external_lex_state = 12},
  [1289] = {.lex_state = 93, .external_lex_state = 13},
  [1290] = {.lex_state = 93, .external_lex_state = 13},
  [1291] = {.lex_state = 94, .external_lex_state = 12},
  [1292] = {.lex_state = 93, .external_lex_state = 13},
  [1293] = {.lex_state = 94, .external_lex_state = 12},
  [1294] = {.lex_state = 93, .external_lex_state = 13},
  [1295] = {.lex_state = 93, .external_lex_state = 13},
  [1296] = {.lex_state = 93, .external_lex_state = 13},
  [1297] = {.lex_state = 93, .external_lex_state = 13},
  [1298] = {.lex_state = 94, .external_lex_state = 12},
  [1299] = {.lex_state = 94, .external_lex_state = 12},
  [1300] = {.lex_state = 94, .external_lex_state = 12},
  [1301] = {.lex_state = 94, .external_lex_state = 12},
  [1302] = {.lex_state = 93, .external_lex_state = 13},
  [1303] = {.lex_state = 93, .external_lex_state = 13},
  [1304] = {.lex_state = 94, .external_lex_state = 12},
  [1305] = {.lex_state = 94, .external_lex_state = 12},
  [1306] = {.lex_state = 94, .external_lex_state = 12},
  [1307] = {.lex_state = 94, .external_lex_state = 12},
  [1308] = {.lex_state = 94, .external_lex_state = 12},
  [1309] = {.lex_state = 94, .external_lex_state = 12},
  [1310] = {.lex_state = 94, .external_lex_state = 12},
  [1311] = {.lex_state = 93, .external_lex_state = 13},
  [1312] = {.lex_state = 94, .external_lex_state = 12},
  [1313] = {.lex_state = 94, .external_lex_state = 12},
  [1314] = {.lex_state = 93, .external_lex_state = 13},
  [1315] = {.lex_state = 93, .external_lex_state = 13},
  [1316] = {.lex_state = 93, .external_lex_state = 13},
  [1317] = {.lex_state = 94, .external_lex_state = 12},
  [1318] = {.lex_state = 94, .external_lex_state = 12},
  [1319] = {.lex_state = 93, .external_lex_state = 13},
  [1320] = {.lex_state = 93, .external_lex_state = 13},
  [1321] = {.lex_state = 93, .external_lex_state = 13},
  [1322] = {.lex_state = 93, .external_lex_state = 13},
  [1323] = {.lex_state = 94, .external_lex_state = 12},
  [1324] = {.lex_state = 93, .external_lex_state = 13},
  [1325] = {.lex_state = 94, .external_lex_state = 12},
  [1326] = {.lex_state = 94, .external_lex_state = 12},
  [1327] = {.lex_state = 93, .external_lex_state = 13},
  [1328] = {.lex_state = 93, .external_lex_state = 13},
  [1329] = {.lex_state = 94, .external_lex_state = 12},
  [1330] = {.lex_state = 94, .external_lex_state = 12},
  [1331] = {.lex_state = 94, .external_lex_state = 12},
  [1332] = {.lex_state = 94, .external_lex_state = 12},
  [1333] = {.lex_state = 93, .external_lex_state = 13},
  [1334] = {.lex_state = 93, .external_lex_state = 13},
  [1335] = {.lex_state = 93, .external_lex_state = 13},
  [1336] = {.lex_state = 93, .external_lex_state = 13},
  [1337] = {.lex_state = 93, .external_lex_state = 13},
  [1338] = {.lex_state = 94, .external_lex_state = 12},
  [1339] = {.lex_state = 94, .external_lex_state = 12},
  [1340] = {.lex_state = 93, .external_lex_state = 13},
  [1341] = {.lex_state = 93, .external_lex_state = 13},
  [1342] = {.lex_state = 94, .external_lex_state = 12},
  [1343] = {.lex_state = 94, .external_lex_state = 12},
  [1344] = {.lex_state = 84},
  [1345] = {.lex_state = 94, .external_lex_state = 12},
  [1346] = {.lex_state = 93, .external_lex_state = 13},
  [1347] = {.lex_state = 94, .external_lex_state = 12},
  [1348] = {.lex_state = 94, .external_lex_state = 12},
  [1349] = {.lex_state = 94, .external_lex_state = 12},
  [1350] = {.lex_state = 93, .external_lex_state = 13},
  [1351] = {.lex_state = 93, .external_lex_state = 13},
  [1352] = {.lex_state = 93, .external_lex_state = 13},
  [1353] = {.lex_state = 93, .external_lex_state = 13},
  [1354] = {.lex_state = 94, .external_lex_state = 12},
  [1355] = {.lex_state = 94, .external_lex_state = 12},
  [1356] = {.lex_state = 94, .external_lex_state = 12},
  [1357] = {.lex_state = 93, .external_lex_state = 13},
  [1358] = {.lex_state = 93, .external_lex_state = 13},
  [1359] = {.lex_state = 94, .external_lex_state = 12},
  [1360] = {.lex_state = 93, .external_lex_state = 13},
  [1361] = {.lex_state = 93, .external_lex_state = 13},
  [1362] = {.lex_state = 93, .external_lex_state = 13},
  [1363] = {.lex_state = 84},
  [1364] = {.lex_state = 84},
  [1365] = {.lex_state = 94, .external_lex_state = 12},
  [1366] = {.lex_state = 94, .external_lex_state = 12},
  [1367] = {.lex_state = 84},
  [1368] = {.lex_state = 93, .external_lex_state = 13},
  [1369] = {.lex_state = 93, .external_lex_state = 13},
  [1370] = {.lex_state = 94, .external_lex_state = 12},
  [1371] = {.lex_state = 94, .external_lex_state = 12},
  [1372] = {.lex_state = 94, .external_lex_state = 12},
  [1373] = {.lex_state = 94, .external_lex_state = 12},
  [1374] = {.lex_state = 93, .external_lex_state = 13},
  [1375] = {.lex_state = 84, .external_lex_state = 14},
  [1376] = {.lex_state = 93, .external_lex_state = 13},
  [1377] = {.lex_state = 93, .external_lex_state = 13},
  [1378] = {.lex_state = 93, .external_lex_state = 13},
  [1379] = {.lex_state = 84},
  [1380] = {.lex_state = 94, .external_lex_state = 12},
  [1381] = {.lex_state = 94, .external_lex_state = 12},
  [1382] = {.lex_state = 93, .external_lex_state = 13},
  [1383] = {.lex_state = 84},
  [1384] = {.lex_state = 84},
  [1385] = {.lex_state = 93, .external_lex_state = 13},
  [1386] = {.lex_state = 93, .external_lex_state = 13},
  [1387] = {.lex_state = 94, .external_lex_state = 12},
  [1388] = {.lex_state = 94, .external_lex_state = 12},
  [1389] = {.lex_state = 84},
  [1390] = {.lex_state = 94, .external_lex_state = 12},
  [1391] = {.lex_state = 94, .external_lex_state = 12},
  [1392] = {.lex_state = 93, .external_lex_state = 13},
  [1393] = {.lex_state = 93, .external_lex_state = 13},
  [1394] = {.lex_state = 84, .external_lex_state = 14},
  [1395] = {.lex_state = 93, .external_lex_state = 13},
  [1396] = {.lex_state = 94, .external_lex_state = 12},
  [1397] = {.lex_state = 93, .external_lex_state = 13},
  [1398] = {.lex_state = 94, .external_lex_state = 13},
  [1399] = {.lex_state = 94, .external_lex_state = 13},
  [1400] = {.lex_state = 94, .external_lex_state = 13},
  [1401] = {.lex_state = 94, .external_lex_state = 13},
  [1402] = {.lex_state = 84},
  [1403] = {.lex_state = 84},
  [1404] = {.lex_state = 94, .external_lex_state = 13},
  [1405] = {.lex_state = 94, .external_lex_state = 13},
  [1406] = {.lex_state = 94, .external_lex_state = 13},
  [1407] = {.lex_state = 94, .external_lex_state = 13},
  [1408] = {.lex_state = 94, .external_lex_state = 13},
  [1409] = {.lex_state = 84},
  [1410] = {.lex_state = 94, .external_lex_state = 13},
  [1411] = {.lex_state = 94, .external_lex_state = 13},
  [1412] = {.lex_state = 94, .external_lex_state = 13},
  [1413] = {.lex_state = 94, .external_lex_state = 13},
  [1414] = {.lex_state = 94, .external_lex_state = 13},
  [1415] = {.lex_state = 94, .external_lex_state = 13},
  [1416] = {.lex_state = 94, .external_lex_state = 13},
  [1417] = {.lex_state = 94, .external_lex_state = 13},
  [1418] = {.lex_state = 94, .external_lex_state = 13},
  [1419] = {.lex_state = 94, .external_lex_state = 13},
  [1420] = {.lex_state = 94, .external_lex_state = 13},
  [1421] = {.lex_state = 94, .external_lex_state = 13},
  [1422] = {.lex_state = 94, .external_lex_state = 13},
  [1423] = {.lex_state = 94, .external_lex_state = 13},
  [1424] = {.lex_state = 94, .external_lex_state = 13},
  [1425] = {.lex_state = 94, .external_lex_state = 13},
  [1426] = {.lex_state = 94, .external_lex_state = 13},
  [1427] = {.lex_state = 94, .external_lex_state = 13},
  [1428] = {.lex_state = 94, .external_lex_state = 13},
  [1429] = {.lex_state = 94, .external_lex_state = 13},
  [1430] = {.lex_state = 84},
  [1431] = {.lex_state = 84},
  [1432] = {.lex_state = 94, .external_lex_state = 13},
  [1433] = {.lex_state = 94, .external_lex_state = 13},
  [1434] = {.lex_state = 94, .external_lex_state = 13},
  [1435] = {.lex_state = 94, .external_lex_state = 13},
  [1436] = {.lex_state = 94, .external_lex_state = 13},
  [1437] = {.lex_state = 94, .external_lex_state = 13},
  [1438] = {.lex_state = 94, .external_lex_state = 13},
  [1439] = {.lex_state = 94, .external_lex_state = 13},
  [1440] = {.lex_state = 94, .external_lex_state = 13},
  [1441] = {.lex_state = 94, .external_lex_state = 13},
  [1442] = {.lex_state = 94, .external_lex_state = 13},
  [1443] = {.lex_state = 94, .external_lex_state = 13},
  [1444] = {.lex_state = 94, .external_lex_state = 13},
  [1445] = {.lex_state = 94, .external_lex_state = 13},
  [1446] = {.lex_state = 94, .external_lex_state = 13},
  [1447] = {.lex_state = 94, .external_lex_state = 13},
  [1448] = {.lex_state = 94, .external_lex_state = 13},
  [1449] = {.lex_state = 94, .external_lex_state = 13},
  [1450] = {.lex_state = 94, .external_lex_state = 13},
  [1451] = {.lex_state = 94, .external_lex_state = 13},
  [1452] = {.lex_state = 94, .external_lex_state = 13},
  [1453] = {.lex_state = 94, .external_lex_state = 13},
  [1454] = {.lex_state = 94, .external_lex_state = 13},
  [1455] = {.lex_state = 94, .external_lex_state = 13},
  [1456] = {.lex_state = 94, .external_lex_state = 13},
  [1457] = {.lex_state = 94, .external_lex_state = 13},
  [1458] = {.lex_state = 94, .external_lex_state = 13},
  [1459] = {.lex_state = 94, .external_lex_state = 13},
  [1460] = {.lex_state = 94, .external_lex_state = 13},
  [1461] = {.lex_state = 94, .external_lex_state = 13},
  [1462] = {.lex_state = 94, .external_lex_state = 13},
  [1463] = {.lex_state = 94, .external_lex_state = 13},
  [1464] = {.lex_state = 94, .external_lex_state = 13},
  [1465] = {.lex_state = 94, .external_lex_state = 13},
  [1466] = {.lex_state = 94, .external_lex_state = 13},
  [1467] = {.lex_state = 94, .external_lex_state = 13},
  [1468] = {.lex_state = 94, .external_lex_state = 13},
  [1469] = {.lex_state = 94, .external_lex_state = 13},
  [1470] = {.lex_state = 94, .external_lex_state = 13},
  [1471] = {.lex_state = 94, .external_lex_state = 13},
  [1472] = {.lex_state = 94, .external_lex_state = 13},
  [1473] = {.lex_state = 94, .external_lex_state = 13},
  [1474] = {.lex_state = 94, .external_lex_state = 13},
  [1475] = {.lex_state = 94, .external_lex_state = 13},
  [1476] = {.lex_state = 94, .external_lex_state = 13},
  [1477] = {.lex_state = 94, .external_lex_state = 13},
  [1478] = {.lex_state = 94, .external_lex_state = 13},
  [1479] = {.lex_state = 94, .external_lex_state = 13},
  [1480] = {.lex_state = 94, .external_lex_state = 13},
  [1481] = {.lex_state = 94, .external_lex_state = 13},
  [1482] = {.lex_state = 94, .external_lex_state = 13},
  [1483] = {.lex_state = 94, .external_lex_state = 13},
  [1484] = {.lex_state = 94, .external_lex_state = 13},
  [1485] = {.lex_state = 94, .external_lex_state = 13},
  [1486] = {.lex_state = 94, .external_lex_state = 13},
  [1487] = {.lex_state = 94, .external_lex_state = 13},
  [1488] = {.lex_state = 94, .external_lex_state = 13},
  [1489] = {.lex_state = 94, .external_lex_state = 13},
  [1490] = {.lex_state = 94, .external_lex_state = 13},
  [1491] = {.lex_state = 94, .external_lex_state = 13},
  [1492] = {.lex_state = 94, .external_lex_state = 13},
  [1493] = {.lex_state = 94, .external_lex_state = 13},
  [1494] = {.lex_state = 94, .external_lex_state = 13},
  [1495] = {.lex_state = 94, .external_lex_state = 13},
  [1496] = {.lex_state = 94, .external_lex_state = 13},
  [1497] = {.lex_state = 94, .external_lex_state = 13},
  [1498] = {.lex_state = 94, .external_lex_state = 13},
  [1499] = {.lex_state = 94, .external_lex_state = 13},
  [1500] = {.lex_state = 94, .external_lex_state = 13},
  [1501] = {.lex_state = 94, .external_lex_state = 13},
  [1502] = {.lex_state = 94, .external_lex_state = 13},
  [1503] = {.lex_state = 94, .external_lex_state = 13},
  [1504] = {.lex_state = 94, .external_lex_state = 13},
  [1505] = {.lex_state = 94, .external_lex_state = 13},
  [1506] = {.lex_state = 94, .external_lex_state = 13},
  [1507] = {.lex_state = 94, .external_lex_state = 13},
  [1508] = {.lex_state = 94, .external_lex_state = 13},
  [1509] = {.lex_state = 94, .external_lex_state = 13},
  [1510] = {.lex_state = 94, .external_lex_state = 13},
  [1511] = {.lex_state = 94, .external_lex_state = 13},
  [1512] = {.lex_state = 94, .external_lex_state = 13},
  [1513] = {.lex_state = 94, .external_lex_state = 13},
  [1514] = {.lex_state = 94, .external_lex_state = 13},
  [1515] = {.lex_state = 94, .external_lex_state = 13},
  [1516] = {.lex_state = 94, .external_lex_state = 13},
  [1517] = {.lex_state = 94, .external_lex_state = 13},
  [1518] = {.lex_state = 84},
  [1519] = {.lex_state = 94, .external_lex_state = 13},
  [1520] = {.lex_state = 94, .external_lex_state = 13},
  [1521] = {.lex_state = 94, .external_lex_state = 13},
  [1522] = {.lex_state = 94, .external_lex_state = 13},
  [1523] = {.lex_state = 94, .external_lex_state = 13},
  [1524] = {.lex_state = 94, .external_lex_state = 13},
  [1525] = {.lex_state = 94, .external_lex_state = 13},
  [1526] = {.lex_state = 84},
  [1527] = {.lex_state = 94, .external_lex_state = 13},
  [1528] = {.lex_state = 94, .external_lex_state = 13},
  [1529] = {.lex_state = 94, .external_lex_state = 13},
  [1530] = {.lex_state = 94, .external_lex_state = 13},
  [1531] = {.lex_state = 94, .external_lex_state = 13},
  [1532] = {.lex_state = 94, .external_lex_state = 13},
  [1533] = {.lex_state = 94, .external_lex_state = 13},
  [1534] = {.lex_state = 94, .external_lex_state = 13},
  [1535] = {.lex_state = 94, .external_lex_state = 13},
  [1536] = {.lex_state = 94, .external_lex_state = 13},
  [1537] = {.lex_state = 94, .external_lex_state = 13},
  [1538] = {.lex_state = 94, .external_lex_state = 13},
  [1539] = {.lex_state = 94, .external_lex_state = 13},
  [1540] = {.lex_state = 94, .external_lex_state = 13},
  [1541] = {.lex_state = 94, .external_lex_state = 13},
  [1542] = {.lex_state = 94, .external_lex_state = 13},
  [1543] = {.lex_state = 94, .external_lex_state = 13},
  [1544] = {.lex_state = 94, .external_lex_state = 13},
  [1545] = {.lex_state = 94, .external_lex_state = 13},
  [1546] = {.lex_state = 94, .external_lex_state = 13},
  [1547] = {.lex_state = 94, .external_lex_state = 13},
  [1548] = {.lex_state = 94, .external_lex_state = 13},
  [1549] = {.lex_state = 94, .external_lex_state = 13},
  [1550] = {.lex_state = 94, .external_lex_state = 13},
  [1551] = {.lex_state = 94, .external_lex_state = 13},
  [1552] = {.lex_state = 94, .external_lex_state = 13},
  [1553] = {.lex_state = 94, .external_lex_state = 13},
  [1554] = {.lex_state = 94, .external_lex_state = 13},
  [1555] = {.lex_state = 94, .external_lex_state = 13},
  [1556] = {.lex_state = 94, .external_lex_state = 13},
  [1557] = {.lex_state = 94, .external_lex_state = 13},
  [1558] = {.lex_state = 94, .external_lex_state = 13},
  [1559] = {.lex_state = 84},
  [1560] = {.lex_state = 94, .external_lex_state = 13},
  [1561] = {.lex_state = 94, .external_lex_state = 13},
  [1562] = {.lex_state = 94, .external_lex_state = 13},
  [1563] = {.lex_state = 94, .external_lex_state = 13},
  [1564] = {.lex_state = 94, .external_lex_state = 13},
  [1565] = {.lex_state = 94, .external_lex_state = 13},
  [1566] = {.lex_state = 94, .external_lex_state = 13},
  [1567] = {.lex_state = 94, .external_lex_state = 13},
  [1568] = {.lex_state = 94, .external_lex_state = 13},
  [1569] = {.lex_state = 94, .external_lex_state = 13},
  [1570] = {.lex_state = 94, .external_lex_state = 13},
  [1571] = {.lex_state = 94, .external_lex_state = 13},
  [1572] = {.lex_state = 94, .external_lex_state = 13},
  [1573] = {.lex_state = 94, .external_lex_state = 13},
  [1574] = {.lex_state = 94, .external_lex_state = 13},
  [1575] = {.lex_state = 94, .external_lex_state = 13},
  [1576] = {.lex_state = 94, .external_lex_state = 13},
  [1577] = {.lex_state = 94, .external_lex_state = 13},
  [1578] = {.lex_state = 94, .external_lex_state = 13},
  [1579] = {.lex_state = 94, .external_lex_state = 13},
  [1580] = {.lex_state = 94, .external_lex_state = 13},
  [1581] = {.lex_state = 94, .external_lex_state = 13},
  [1582] = {.lex_state = 94, .external_lex_state = 13},
  [1583] = {.lex_state = 94, .external_lex_state = 13},
  [1584] = {.lex_state = 94, .external_lex_state = 13},
  [1585] = {.lex_state = 94, .external_lex_state = 13},
  [1586] = {.lex_state = 94, .external_lex_state = 13},
  [1587] = {.lex_state = 94, .external_lex_state = 13},
  [1588] = {.lex_state = 94, .external_lex_state = 13},
  [1589] = {.lex_state = 94, .external_lex_state = 13},
  [1590] = {.lex_state = 94, .external_lex_state = 13},
  [1591] = {.lex_state = 94, .external_lex_state = 13},
  [1592] = {.lex_state = 94, .external_lex_state = 13},
  [1593] = {.lex_state = 94, .external_lex_state = 13},
  [1594] = {.lex_state = 94, .external_lex_state = 13},
  [1595] = {.lex_state = 94, .external_lex_state = 13},
  [1596] = {.lex_state = 94, .external_lex_state = 13},
  [1597] = {.lex_state = 94, .external_lex_state = 13},
  [1598] = {.lex_state = 94, .external_lex_state = 13},
  [1599] = {.lex_state = 94, .external_lex_state = 13},
  [1600] = {.lex_state = 94, .external_lex_state = 13},
  [1601] = {.lex_state = 94, .external_lex_state = 13},
  [1602] = {.lex_state = 94, .external_lex_state = 13},
  [1603] = {.lex_state = 94, .external_lex_state = 13},
  [1604] = {.lex_state = 94, .external_lex_state = 13},
  [1605] = {.lex_state = 94, .external_lex_state = 13},
  [1606] = {.lex_state = 94, .external_lex_state = 13},
  [1607] = {.lex_state = 94, .external_lex_state = 13},
  [1608] = {.lex_state = 94, .external_lex_state = 13},
  [1609] = {.lex_state = 94, .external_lex_state = 13},
  [1610] = {.lex_state = 94, .external_lex_state = 13},
  [1611] = {.lex_state = 94, .external_lex_state = 13},
  [1612] = {.lex_state = 94, .external_lex_state = 13},
  [1613] = {.lex_state = 94, .external_lex_state = 13},
  [1614] = {.lex_state = 94, .external_lex_state = 13},
  [1615] = {.lex_state = 94, .external_lex_state = 13},
  [1616] = {.lex_state = 94, .external_lex_state = 13},
  [1617] = {.lex_state = 94, .external_lex_state = 13},
  [1618] = {.lex_state = 94, .external_lex_state = 13},
  [1619] = {.lex_state = 94, .external_lex_state = 13},
  [1620] = {.lex_state = 94, .external_lex_state = 13},
  [1621] = {.lex_state = 94, .external_lex_state = 13},
  [1622] = {.lex_state = 94, .external_lex_state = 13},
  [1623] = {.lex_state = 94, .external_lex_state = 13},
  [1624] = {.lex_state = 94, .external_lex_state = 13},
  [1625] = {.lex_state = 94, .external_lex_state = 13},
  [1626] = {.lex_state = 94, .external_lex_state = 13},
  [1627] = {.lex_state = 94, .external_lex_state = 13},
  [1628] = {.lex_state = 94, .external_lex_state = 13},
  [1629] = {.lex_state = 94, .external_lex_state = 13},
  [1630] = {.lex_state = 94, .external_lex_state = 13},
  [1631] = {.lex_state = 94, .external_lex_state = 13},
  [1632] = {.lex_state = 94, .external_lex_state = 13},
  [1633] = {.lex_state = 94, .external_lex_state = 13},
  [1634] = {.lex_state = 94, .external_lex_state = 13},
  [1635] = {.lex_state = 94, .external_lex_state = 13},
  [1636] = {.lex_state = 94, .external_lex_state = 13},
  [1637] = {.lex_state = 94, .external_lex_state = 13},
  [1638] = {.lex_state = 94, .external_lex_state = 13},
  [1639] = {.lex_state = 94, .external_lex_state = 13},
  [1640] = {.lex_state = 94, .external_lex_state = 13},
  [1641] = {.lex_state = 94, .external_lex_state = 13},
  [1642] = {.lex_state = 94, .external_lex_state = 13},
  [1643] = {.lex_state = 94, .external_lex_state = 13},
  [1644] = {.lex_state = 94, .external_lex_state = 13},
  [1645] = {.lex_state = 94, .external_lex_state = 13},
  [1646] = {.lex_state = 94, .external_lex_state = 13},
  [1647] = {.lex_state = 94, .external_lex_state = 13},
  [1648] = {.lex_state = 94, .external_lex_state = 13},
  [1649] = {.lex_state = 94, .external_lex_state = 13},
  [1650] = {.lex_state = 94, .external_lex_state = 13},
  [1651] = {.lex_state = 94, .external_lex_state = 13},
  [1652] = {.lex_state = 94, .external_lex_state = 13},
  [1653] = {.lex_state = 94, .external_lex_state = 13},
  [1654] = {.lex_state = 94, .external_lex_state = 13},
  [1655] = {.lex_state = 94, .external_lex_state = 13},
  [1656] = {.lex_state = 94, .external_lex_state = 13},
  [1657] = {.lex_state = 94, .external_lex_state = 13},
  [1658] = {.lex_state = 94, .external_lex_state = 13},
  [1659] = {.lex_state = 94, .external_lex_state = 13},
  [1660] = {.lex_state = 94, .external_lex_state = 13},
  [1661] = {.lex_state = 94, .external_lex_state = 13},
  [1662] = {.lex_state = 94, .external_lex_state = 13},
  [1663] = {.lex_state = 94, .external_lex_state = 13},
  [1664] = {.lex_state = 94, .external_lex_state = 13},
  [1665] = {.lex_state = 94, .external_lex_state = 13},
  [1666] = {.lex_state = 94, .external_lex_state = 13},
  [1667] = {.lex_state = 94, .external_lex_state = 13},
  [1668] = {.lex_state = 84},
  [1669] = {.lex_state = 94, .external_lex_state = 13},
  [1670] = {.lex_state = 94, .external_lex_state = 13},
  [1671] = {.lex_state = 94, .external_lex_state = 13},
  [1672] = {.lex_state = 94, .external_lex_state = 13},
  [1673] = {.lex_state = 94, .external_lex_state = 13},
  [1674] = {.lex_state = 94, .external_lex_state = 13},
  [1675] = {.lex_state = 94, .external_lex_state = 13},
  [1676] = {.lex_state = 94, .external_lex_state = 13},
  [1677] = {.lex_state = 94, .external_lex_state = 13},
  [1678] = {.lex_state = 94, .external_lex_state = 13},
  [1679] = {.lex_state = 94, .external_lex_state = 13},
  [1680] = {.lex_state = 94, .external_lex_state = 13},
  [1681] = {.lex_state = 94, .external_lex_state = 13},
  [1682] = {.lex_state = 94, .external_lex_state = 13},
  [1683] = {.lex_state = 94, .external_lex_state = 13},
  [1684] = {.lex_state = 94, .external_lex_state = 13},
  [1685] = {.lex_state = 94, .external_lex_state = 13},
  [1686] = {.lex_state = 94, .external_lex_state = 13},
  [1687] = {.lex_state = 94, .external_lex_state = 13},
  [1688] = {.lex_state = 94, .external_lex_state = 13},
  [1689] = {.lex_state = 94, .external_lex_state = 13},
  [1690] = {.lex_state = 94, .external_lex_state = 13},
  [1691] = {.lex_state = 94, .external_lex_state = 13},
  [1692] = {.lex_state = 94, .external_lex_state = 13},
  [1693] = {.lex_state = 94, .external_lex_state = 13},
  [1694] = {.lex_state = 94, .external_lex_state = 13},
  [1695] = {.lex_state = 94, .external_lex_state = 13},
  [1696] = {.lex_state = 94, .external_lex_state = 13},
  [1697] = {.lex_state = 94, .external_lex_state = 13},
  [1698] = {.lex_state = 94, .external_lex_state = 13},
  [1699] = {.lex_state = 94, .external_lex_state = 13},
  [1700] = {.lex_state = 94, .external_lex_state = 13},
  [1701] = {.lex_state = 94, .external_lex_state = 13},
  [1702] = {.lex_state = 94, .external_lex_state = 13},
  [1703] = {.lex_state = 94, .external_lex_state = 13},
  [1704] = {.lex_state = 94, .external_lex_state = 13},
  [1705] = {.lex_state = 94, .external_lex_state = 13},
  [1706] = {.lex_state = 94, .external_lex_state = 13},
  [1707] = {.lex_state = 94, .external_lex_state = 13},
  [1708] = {.lex_state = 94, .external_lex_state = 13},
  [1709] = {.lex_state = 94, .external_lex_state = 13},
  [1710] = {.lex_state = 94, .external_lex_state = 13},
  [1711] = {.lex_state = 94, .external_lex_state = 13},
  [1712] = {.lex_state = 94, .external_lex_state = 13},
  [1713] = {.lex_state = 94, .external_lex_state = 13},
  [1714] = {.lex_state = 94, .external_lex_state = 13},
  [1715] = {.lex_state = 94, .external_lex_state = 13},
  [1716] = {.lex_state = 94, .external_lex_state = 13},
  [1717] = {.lex_state = 94, .external_lex_state = 13},
  [1718] = {.lex_state = 94, .external_lex_state = 13},
  [1719] = {.lex_state = 94, .external_lex_state = 13},
  [1720] = {.lex_state = 94, .external_lex_state = 13},
  [1721] = {.lex_state = 94, .external_lex_state = 13},
  [1722] = {.lex_state = 94, .external_lex_state = 13},
  [1723] = {.lex_state = 94, .external_lex_state = 13},
  [1724] = {.lex_state = 94, .external_lex_state = 13},
  [1725] = {.lex_state = 94, .external_lex_state = 13},
  [1726] = {.lex_state = 94, .external_lex_state = 13},
  [1727] = {.lex_state = 94, .external_lex_state = 13},
  [1728] = {.lex_state = 94, .external_lex_state = 13},
  [1729] = {.lex_state = 94, .external_lex_state = 13},
  [1730] = {.lex_state = 94, .external_lex_state = 13},
  [1731] = {.lex_state = 94, .external_lex_state = 13},
  [1732] = {.lex_state = 94, .external_lex_state = 13},
  [1733] = {.lex_state = 94, .external_lex_state = 13},
  [1734] = {.lex_state = 94, .external_lex_state = 13},
  [1735] = {.lex_state = 94, .external_lex_state = 13},
  [1736] = {.lex_state = 94, .external_lex_state = 13},
  [1737] = {.lex_state = 94, .external_lex_state = 13},
  [1738] = {.lex_state = 94, .external_lex_state = 13},
  [1739] = {.lex_state = 94, .external_lex_state = 13},
  [1740] = {.lex_state = 94, .external_lex_state = 13},
  [1741] = {.lex_state = 94, .external_lex_state = 13},
  [1742] = {.lex_state = 94, .external_lex_state = 13},
  [1743] = {.lex_state = 94, .external_lex_state = 13},
  [1744] = {.lex_state = 94, .external_lex_state = 13},
  [1745] = {.lex_state = 94, .external_lex_state = 13},
  [1746] = {.lex_state = 94, .external_lex_state = 13},
  [1747] = {.lex_state = 94, .external_lex_state = 13},
  [1748] = {.lex_state = 94, .external_lex_state = 13},
  [1749] = {.lex_state = 94, .external_lex_state = 13},
  [1750] = {.lex_state = 94, .external_lex_state = 13},
  [1751] = {.lex_state = 94, .external_lex_state = 13},
  [1752] = {.lex_state = 94, .external_lex_state = 13},
  [1753] = {.lex_state = 94, .external_lex_state = 13},
  [1754] = {.lex_state = 94, .external_lex_state = 13},
  [1755] = {.lex_state = 94, .external_lex_state = 13},
  [1756] = {.lex_state = 94, .external_lex_state = 13},
  [1757] = {.lex_state = 94, .external_lex_state = 13},
  [1758] = {.lex_state = 94, .external_lex_state = 13},
  [1759] = {.lex_state = 94, .external_lex_state = 13},
  [1760] = {.lex_state = 94, .external_lex_state = 13},
  [1761] = {.lex_state = 94, .external_lex_state = 13},
  [1762] = {.lex_state = 94, .external_lex_state = 13},
  [1763] = {.lex_state = 94, .external_lex_state = 13},
  [1764] = {.lex_state = 94, .external_lex_state = 13},
  [1765] = {.lex_state = 94, .external_lex_state = 13},
  [1766] = {.lex_state = 94, .external_lex_state = 13},
  [1767] = {.lex_state = 94, .external_lex_state = 13},
  [1768] = {.lex_state = 94, .external_lex_state = 13},
  [1769] = {.lex_state = 94, .external_lex_state = 13},
  [1770] = {.lex_state = 94, .external_lex_state = 13},
  [1771] = {.lex_state = 94, .external_lex_state = 13},
  [1772] = {.lex_state = 94, .external_lex_state = 13},
  [1773] = {.lex_state = 94, .external_lex_state = 13},
  [1774] = {.lex_state = 94, .external_lex_state = 13},
  [1775] = {.lex_state = 94, .external_lex_state = 13},
  [1776] = {.lex_state = 94, .external_lex_state = 13},
  [1777] = {.lex_state = 94, .external_lex_state = 13},
  [1778] = {.lex_state = 94, .external_lex_state = 13},
  [1779] = {.lex_state = 94, .external_lex_state = 13},
  [1780] = {.lex_state = 94, .external_lex_state = 13},
  [1781] = {.lex_state = 94, .external_lex_state = 13},
  [1782] = {.lex_state = 94, .external_lex_state = 13},
  [1783] = {.lex_state = 94, .external_lex_state = 13},
  [1784] = {.lex_state = 94, .external_lex_state = 13},
  [1785] = {.lex_state = 94, .external_lex_state = 13},
  [1786] = {.lex_state = 94, .external_lex_state = 13},
  [1787] = {.lex_state = 94, .external_lex_state = 13},
  [1788] = {.lex_state = 94, .external_lex_state = 13},
  [1789] = {.lex_state = 94, .external_lex_state = 13},
  [1790] = {.lex_state = 94, .external_lex_state = 13},
  [1791] = {.lex_state = 94, .external_lex_state = 13},
  [1792] = {.lex_state = 94, .external_lex_state = 13},
  [1793] = {.lex_state = 94, .external_lex_state = 13},
  [1794] = {.lex_state = 94, .external_lex_state = 13},
  [1795] = {.lex_state = 94, .external_lex_state = 13},
  [1796] = {.lex_state = 94, .external_lex_state = 13},
  [1797] = {.lex_state = 94, .external_lex_state = 13},
  [1798] = {.lex_state = 94, .external_lex_state = 13},
  [1799] = {.lex_state = 94, .external_lex_state = 13},
  [1800] = {.lex_state = 94, .external_lex_state = 13},
  [1801] = {.lex_state = 94, .external_lex_state = 13},
  [1802] = {.lex_state = 94, .external_lex_state = 13},
  [1803] = {.lex_state = 94, .external_lex_state = 13},
  [1804] = {.lex_state = 94, .external_lex_state = 13},
  [1805] = {.lex_state = 94, .external_lex_state = 13},
  [1806] = {.lex_state = 94, .external_lex_state = 13},
  [1807] = {.lex_state = 94, .external_lex_state = 13},
  [1808] = {.lex_state = 94, .external_lex_state = 13},
  [1809] = {.lex_state = 94, .external_lex_state = 13},
  [1810] = {.lex_state = 94, .external_lex_state = 13},
  [1811] = {.lex_state = 94, .external_lex_state = 13},
  [1812] = {.lex_state = 94, .external_lex_state = 13},
  [1813] = {.lex_state = 94, .external_lex_state = 13},
  [1814] = {.lex_state = 94, .external_lex_state = 13},
  [1815] = {.lex_state = 94, .external_lex_state = 13},
  [1816] = {.lex_state = 94, .external_lex_state = 13},
  [1817] = {.lex_state = 94, .external_lex_state = 13},
  [1818] = {.lex_state = 94, .external_lex_state = 13},
  [1819] = {.lex_state = 94, .external_lex_state = 13},
  [1820] = {.lex_state = 94, .external_lex_state = 13},
  [1821] = {.lex_state = 94, .external_lex_state = 13},
  [1822] = {.lex_state = 94, .external_lex_state = 13},
  [1823] = {.lex_state = 94, .external_lex_state = 13},
  [1824] = {.lex_state = 94, .external_lex_state = 13},
  [1825] = {.lex_state = 94, .external_lex_state = 13},
  [1826] = {.lex_state = 94, .external_lex_state = 13},
  [1827] = {.lex_state = 94, .external_lex_state = 13},
  [1828] = {.lex_state = 94, .external_lex_state = 13},
  [1829] = {.lex_state = 94, .external_lex_state = 13},
  [1830] = {.lex_state = 94, .external_lex_state = 13},
  [1831] = {.lex_state = 94, .external_lex_state = 13},
  [1832] = {.lex_state = 94, .external_lex_state = 13},
  [1833] = {.lex_state = 94, .external_lex_state = 13},
  [1834] = {.lex_state = 94, .external_lex_state = 13},
  [1835] = {.lex_state = 94, .external_lex_state = 13},
  [1836] = {.lex_state = 94, .external_lex_state = 13},
  [1837] = {.lex_state = 94, .external_lex_state = 13},
  [1838] = {.lex_state = 94, .external_lex_state = 13},
  [1839] = {.lex_state = 94, .external_lex_state = 13},
  [1840] = {.lex_state = 94, .external_lex_state = 13},
  [1841] = {.lex_state = 94, .external_lex_state = 13},
  [1842] = {.lex_state = 94, .external_lex_state = 13},
  [1843] = {.lex_state = 94, .external_lex_state = 13},
  [1844] = {.lex_state = 94, .external_lex_state = 13},
  [1845] = {.lex_state = 94, .external_lex_state = 13},
  [1846] = {.lex_state = 94, .external_lex_state = 13},
  [1847] = {.lex_state = 94, .external_lex_state = 13},
  [1848] = {.lex_state = 94, .external_lex_state = 13},
  [1849] = {.lex_state = 94, .external_lex_state = 13},
  [1850] = {.lex_state = 94, .external_lex_state = 13},
  [1851] = {.lex_state = 94, .external_lex_state = 13},
  [1852] = {.lex_state = 94, .external_lex_state = 13},
  [1853] = {.lex_state = 94, .external_lex_state = 13},
  [1854] = {.lex_state = 94, .external_lex_state = 13},
  [1855] = {.lex_state = 94, .external_lex_state = 13},
  [1856] = {.lex_state = 94, .external_lex_state = 13},
  [1857] = {.lex_state = 94, .external_lex_state = 13},
  [1858] = {.lex_state = 94, .external_lex_state = 13},
  [1859] = {.lex_state = 94, .external_lex_state = 13},
  [1860] = {.lex_state = 94, .external_lex_state = 13},
  [1861] = {.lex_state = 94, .external_lex_state = 13},
  [1862] = {.lex_state = 94, .external_lex_state = 13},
  [1863] = {.lex_state = 94, .external_lex_state = 13},
  [1864] = {.lex_state = 94, .external_lex_state = 13},
  [1865] = {.lex_state = 94, .external_lex_state = 13},
  [1866] = {.lex_state = 94, .external_lex_state = 13},
  [1867] = {.lex_state = 94, .external_lex_state = 13},
  [1868] = {.lex_state = 94, .external_lex_state = 13},
  [1869] = {.lex_state = 94, .external_lex_state = 13},
  [1870] = {.lex_state = 94, .external_lex_state = 13},
  [1871] = {.lex_state = 94, .external_lex_state = 13},
  [1872] = {.lex_state = 94, .external_lex_state = 13},
  [1873] = {.lex_state = 94, .external_lex_state = 13},
  [1874] = {.lex_state = 94, .external_lex_state = 13},
  [1875] = {.lex_state = 94, .external_lex_state = 13},
  [1876] = {.lex_state = 94, .external_lex_state = 13},
  [1877] = {.lex_state = 94, .external_lex_state = 13},
  [1878] = {.lex_state = 84},
  [1879] = {.lex_state = 94, .external_lex_state = 13},
  [1880] = {.lex_state = 94, .external_lex_state = 13},
  [1881] = {.lex_state = 94, .external_lex_state = 13},
  [1882] = {.lex_state = 94, .external_lex_state = 13},
  [1883] = {.lex_state = 94, .external_lex_state = 13},
  [1884] = {.lex_state = 94, .external_lex_state = 13},
  [1885] = {.lex_state = 94, .external_lex_state = 13},
  [1886] = {.lex_state = 94, .external_lex_state = 13},
  [1887] = {.lex_state = 94, .external_lex_state = 13},
  [1888] = {.lex_state = 94, .external_lex_state = 13},
  [1889] = {.lex_state = 94, .external_lex_state = 13},
  [1890] = {.lex_state = 94, .external_lex_state = 13},
  [1891] = {.lex_state = 94, .external_lex_state = 13},
  [1892] = {.lex_state = 94, .external_lex_state = 13},
  [1893] = {.lex_state = 94, .external_lex_state = 13},
  [1894] = {.lex_state = 94, .external_lex_state = 13},
  [1895] = {.lex_state = 94, .external_lex_state = 13},
  [1896] = {.lex_state = 94, .external_lex_state = 13},
  [1897] = {.lex_state = 94, .external_lex_state = 13},
  [1898] = {.lex_state = 94, .external_lex_state = 13},
  [1899] = {.lex_state = 94, .external_lex_state = 13},
  [1900] = {.lex_state = 84},
  [1901] = {.lex_state = 94, .external_lex_state = 13},
  [1902] = {.lex_state = 94, .external_lex_state = 13},
  [1903] = {.lex_state = 94, .external_lex_state = 13},
  [1904] = {.lex_state = 94, .external_lex_state = 13},
  [1905] = {.lex_state = 94, .external_lex_state = 13},
  [1906] = {.lex_state = 94, .external_lex_state = 13},
  [1907] = {.lex_state = 94, .external_lex_state = 13},
  [1908] = {.lex_state = 94, .external_lex_state = 13},
  [1909] = {.lex_state = 94, .external_lex_state = 13},
  [1910] = {.lex_state = 94, .external_lex_state = 13},
  [1911] = {.lex_state = 94, .external_lex_state = 13},
  [1912] = {.lex_state = 94, .external_lex_state = 13},
  [1913] = {.lex_state = 94, .external_lex_state = 13},
  [1914] = {.lex_state = 94, .external_lex_state = 13},
  [1915] = {.lex_state = 94, .external_lex_state = 13},
  [1916] = {.lex_state = 94, .external_lex_state = 13},
  [1917] = {.lex_state = 94, .external_lex_state = 13},
  [1918] = {.lex_state = 94, .external_lex_state = 13},
  [1919] = {.lex_state = 94, .external_lex_state = 13},
  [1920] = {.lex_state = 94, .external_lex_state = 13},
  [1921] = {.lex_state = 94, .external_lex_state = 13},
  [1922] = {.lex_state = 94, .external_lex_state = 13},
  [1923] = {.lex_state = 94, .external_lex_state = 13},
  [1924] = {.lex_state = 94, .external_lex_state = 13},
  [1925] = {.lex_state = 94, .external_lex_state = 13},
  [1926] = {.lex_state = 94, .external_lex_state = 13},
  [1927] = {.lex_state = 84},
  [1928] = {.lex_state = 94, .external_lex_state = 13},
  [1929] = {.lex_state = 94, .external_lex_state = 13},
  [1930] = {.lex_state = 94, .external_lex_state = 13},
  [1931] = {.lex_state = 94, .external_lex_state = 13},
  [1932] = {.lex_state = 94, .external_lex_state = 13},
  [1933] = {.lex_state = 94, .external_lex_state = 13},
  [1934] = {.lex_state = 94, .external_lex_state = 13},
  [1935] = {.lex_state = 94, .external_lex_state = 13},
  [1936] = {.lex_state = 94, .external_lex_state = 13},
  [1937] = {.lex_state = 94, .external_lex_state = 13},
  [1938] = {.lex_state = 94, .external_lex_state = 13},
  [1939] = {.lex_state = 94, .external_lex_state = 13},
  [1940] = {.lex_state = 94, .external_lex_state = 13},
  [1941] = {.lex_state = 94, .external_lex_state = 13},
  [1942] = {.lex_state = 94, .external_lex_state = 13},
  [1943] = {.lex_state = 94, .external_lex_state = 13},
  [1944] = {.lex_state = 94, .external_lex_state = 13},
  [1945] = {.lex_state = 94, .external_lex_state = 13},
  [1946] = {.lex_state = 94, .external_lex_state = 13},
  [1947] = {.lex_state = 94, .external_lex_state = 13},
  [1948] = {.lex_state = 94, .external_lex_state = 13},
  [1949] = {.lex_state = 94, .external_lex_state = 13},
  [1950] = {.lex_state = 94, .external_lex_state = 13},
  [1951] = {.lex_state = 94, .external_lex_state = 13},
  [1952] = {.lex_state = 94, .external_lex_state = 13},
  [1953] = {.lex_state = 94, .external_lex_state = 13},
  [1954] = {.lex_state = 94, .external_lex_state = 13},
  [1955] = {.lex_state = 84},
  [1956] = {.lex_state = 94, .external_lex_state = 13},
  [1957] = {.lex_state = 94, .external_lex_state = 13},
  [1958] = {.lex_state = 94, .external_lex_state = 13},
  [1959] = {.lex_state = 94, .external_lex_state = 13},
  [1960] = {.lex_state = 94, .external_lex_state = 13},
  [1961] = {.lex_state = 94, .external_lex_state = 13},
  [1962] = {.lex_state = 94, .external_lex_state = 13},
  [1963] = {.lex_state = 94, .external_lex_state = 13},
  [1964] = {.lex_state = 94, .external_lex_state = 13},
  [1965] = {.lex_state = 84},
  [1966] = {.lex_state = 94, .external_lex_state = 13},
  [1967] = {.lex_state = 94, .external_lex_state = 13},
  [1968] = {.lex_state = 94, .external_lex_state = 13},
  [1969] = {.lex_state = 94, .external_lex_state = 13},
  [1970] = {.lex_state = 94, .external_lex_state = 13},
  [1971] = {.lex_state = 84},
  [1972] = {.lex_state = 94, .external_lex_state = 13},
  [1973] = {.lex_state = 94, .external_lex_state = 13},
  [1974] = {.lex_state = 84},
  [1975] = {.lex_state = 84},
  [1976] = {.lex_state = 94, .external_lex_state = 13},
  [1977] = {.lex_state = 94, .external_lex_state = 13},
  [1978] = {.lex_state = 94, .external_lex_state = 13},
  [1979] = {.lex_state = 94, .external_lex_state = 13},
  [1980] = {.lex_state = 94, .external_lex_state = 13},
  [1981] = {.lex_state = 94, .external_lex_state = 13},
  [1982] = {.lex_state = 84},
  [1983] = {.lex_state = 94, .external_lex_state = 13},
  [1984] = {.lex_state = 94, .external_lex_state = 13},
  [1985] = {.lex_state = 94, .external_lex_state = 13},
  [1986] = {.lex_state = 94, .external_lex_state = 13},
  [1987] = {.lex_state = 94, .external_lex_state = 13},
  [1988] = {.lex_state = 94, .external_lex_state = 13},
  [1989] = {.lex_state = 94, .external_lex_state = 13},
  [1990] = {.lex_state = 84},
  [1991] = {.lex_state = 84},
  [1992] = {.lex_state = 94, .external_lex_state = 13},
  [1993] = {.lex_state = 94, .external_lex_state = 13},
  [1994] = {.lex_state = 94, .external_lex_state = 13},
  [1995] = {.lex_state = 94, .external_lex_state = 13},
  [1996] = {.lex_state = 94, .external_lex_state = 13},
  [1997] = {.lex_state = 94, .external_lex_state = 13},
  [1998] = {.lex_state = 94, .external_lex_state = 13},
  [1999] = {.lex_state = 84},
  [2000] = {.lex_state = 84},
  [2001] = {.lex_state = 84},
  [2002] = {.lex_state = 94, .external_lex_state = 13},
  [2003] = {.lex_state = 94, .external_lex_state = 13},
  [2004] = {.lex_state = 94, .external_lex_state = 13},
  [2005] = {.lex_state = 94, .external_lex_state = 13},
  [2006] = {.lex_state = 94, .external_lex_state = 13},
  [2007] = {.lex_state = 94, .external_lex_state = 13},
  [2008] = {.lex_state = 94, .external_lex_state = 13},
  [2009] = {.lex_state = 94, .external_lex_state = 13},
  [2010] = {.lex_state = 94, .external_lex_state = 13},
  [2011] = {.lex_state = 94, .external_lex_state = 13},
  [2012] = {.lex_state = 94, .external_lex_state = 13},
  [2013] = {.lex_state = 94, .external_lex_state = 13},
  [2014] = {.lex_state = 94, .external_lex_state = 13},
  [2015] = {.lex_state = 94, .external_lex_state = 13},
  [2016] = {.lex_state = 84},
  [2017] = {.lex_state = 94, .external_lex_state = 13},
  [2018] = {.lex_state = 84},
  [2019] = {.lex_state = 94, .external_lex_state = 13},
  [2020] = {.lex_state = 94, .external_lex_state = 13},
  [2021] = {.lex_state = 94, .external_lex_state = 13},
  [2022] = {.lex_state = 94, .external_lex_state = 13},
  [2023] = {.lex_state = 94, .external_lex_state = 13},
  [2024] = {.lex_state = 84},
  [2025] = {.lex_state = 84},
  [2026] = {.lex_state = 84},
  [2027] = {.lex_state = 84},
  [2028] = {.lex_state = 84},
  [2029] = {.lex_state = 94, .external_lex_state = 13},
  [2030] = {.lex_state = 94, .external_lex_state = 13},
  [2031] = {.lex_state = 94, .external_lex_state = 13},
  [2032] = {.lex_state = 94, .external_lex_state = 13},
  [2033] = {.lex_state = 94, .external_lex_state = 13},
  [2034] = {.lex_state = 84},
  [2035] = {.lex_state = 84},
  [2036] = {.lex_state = 94, .external_lex_state = 13},
  [2037] = {.lex_state = 94, .external_lex_state = 13},
  [2038] = {.lex_state = 94, .external_lex_state = 13},
  [2039] = {.lex_state = 94, .external_lex_state = 13},
  [2040] = {.lex_state = 94, .external_lex_state = 13},
  [2041] = {.lex_state = 94, .external_lex_state = 13},
  [2042] = {.lex_state = 94, .external_lex_state = 13},
  [2043] = {.lex_state = 94, .external_lex_state = 13},
  [2044] = {.lex_state = 94, .external_lex_state = 13},
  [2045] = {.lex_state = 94, .external_lex_state = 13},
  [2046] = {.lex_state = 84},
  [2047] = {.lex_state = 94, .external_lex_state = 13},
  [2048] = {.lex_state = 94, .external_lex_state = 13},
  [2049] = {.lex_state = 94, .external_lex_state = 13},
  [2050] = {.lex_state = 94, .external_lex_state = 13},
  [2051] = {.lex_state = 94, .external_lex_state = 13},
  [2052] = {.lex_state = 28, .external_lex_state = 6},
  [2053] = {.lex_state = 28, .external_lex_state = 6},
  [2054] = {.lex_state = 28, .external_lex_state = 6},
  [2055] = {.lex_state = 28, .external_lex_state = 6},
  [2056] = {.lex_state = 28, .external_lex_state = 6},
  [2057] = {.lex_state = 28, .external_lex_state = 6},
  [2058] = {.lex_state = 77, .external_lex_state = 13},
  [2059] = {.lex_state = 28, .external_lex_state = 6},
  [2060] = {.lex_state = 28, .external_lex_state = 8},
  [2061] = {.lex_state = 188, .external_lex_state = 6},
  [2062] = {.lex_state = 188, .external_lex_state = 6},
  [2063] = {.lex_state = 28, .external_lex_state = 6},
  [2064] = {.lex_state = 188, .external_lex_state = 6},
  [2065] = {.lex_state = 28, .external_lex_state = 6},
  [2066] = {.lex_state = 28, .external_lex_state = 6},
  [2067] = {.lex_state = 28, .external_lex_state = 6},
  [2068] = {.lex_state = 28, .external_lex_state = 6},
  [2069] = {.lex_state = 188, .external_lex_state = 8},
  [2070] = {.lex_state = 188, .external_lex_state = 6},
  [2071] = {.lex_state = 188, .external_lex_state = 6},
  [2072] = {.lex_state = 28, .external_lex_state = 6},
  [2073] = {.lex_state = 188, .external_lex_state = 6},
  [2074] = {.lex_state = 188, .external_lex_state = 6},
  [2075] = {.lex_state = 28, .external_lex_state = 8},
  [2076] = {.lex_state = 188, .external_lex_state = 6},
  [2077] = {.lex_state = 96, .external_lex_state = 2},
  [2078] = {.lex_state = 188, .external_lex_state = 6},
  [2079] = {.lex_state = 28, .external_lex_state = 8},
  [2080] = {.lex_state = 28, .external_lex_state = 6},
  [2081] = {.lex_state = 34, .external_lex_state = 15},
  [2082] = {.lex_state = 28, .external_lex_state = 8},
  [2083] = {.lex_state = 188, .external_lex_state = 6},
  [2084] = {.lex_state = 188, .external_lex_state = 6},
  [2085] = {.lex_state = 28, .external_lex_state = 8},
  [2086] = {.lex_state = 28, .external_lex_state = 8},
  [2087] = {.lex_state = 28, .external_lex_state = 6},
  [2088] = {.lex_state = 74, .external_lex_state = 10},
  [2089] = {.lex_state = 28, .external_lex_state = 8},
  [2090] = {.lex_state = 188, .external_lex_state = 6},
  [2091] = {.lex_state = 188, .external_lex_state = 6},
  [2092] = {.lex_state = 188, .external_lex_state = 6},
  [2093] = {.lex_state = 28, .external_lex_state = 6},
  [2094] = {.lex_state = 188, .external_lex_state = 6},
  [2095] = {.lex_state = 34, .external_lex_state = 10},
  [2096] = {.lex_state = 28, .external_lex_state = 8},
  [2097] = {.lex_state = 96, .external_lex_state = 16},
  [2098] = {.lex_state = 96, .external_lex_state = 16},
  [2099] = {.lex_state = 28, .external_lex_state = 8},
  [2100] = {.lex_state = 28, .external_lex_state = 8},
  [2101] = {.lex_state = 28, .external_lex_state = 8},
  [2102] = {.lex_state = 28, .external_lex_state = 6},
  [2103] = {.lex_state = 28, .external_lex_state = 8},
  [2104] = {.lex_state = 28, .external_lex_state = 8},
  [2105] = {.lex_state = 28, .external_lex_state = 8},
  [2106] = {.lex_state = 28, .external_lex_state = 8},
  [2107] = {.lex_state = 28, .external_lex_state = 8},
  [2108] = {.lex_state = 28, .external_lex_state = 8},
  [2109] = {.lex_state = 28, .external_lex_state = 8},
  [2110] = {.lex_state = 28, .external_lex_state = 8},
  [2111] = {.lex_state = 28, .external_lex_state = 8},
  [2112] = {.lex_state = 28, .external_lex_state = 8},
  [2113] = {.lex_state = 28, .external_lex_state = 8},
  [2114] = {.lex_state = 28, .external_lex_state = 8},
  [2115] = {.lex_state = 28, .external_lex_state = 8},
  [2116] = {.lex_state = 28, .external_lex_state = 8},
  [2117] = {.lex_state = 28, .external_lex_state = 8},
  [2118] = {.lex_state = 28, .external_lex_state = 8},
  [2119] = {.lex_state = 28, .external_lex_state = 8},
  [2120] = {.lex_state = 28, .external_lex_state = 8},
  [2121] = {.lex_state = 28, .external_lex_state = 8},
  [2122] = {.lex_state = 188, .external_lex_state = 8},
  [2123] = {.lex_state = 28, .external_lex_state = 8},
  [2124] = {.lex_state = 28, .external_lex_state = 8},
  [2125] = {.lex_state = 28, .external_lex_state = 8},
  [2126] = {.lex_state = 28, .external_lex_state = 8},
  [2127] = {.lex_state = 28, .external_lex_state = 8},
  [2128] = {.lex_state = 28, .external_lex_state = 8},
  [2129] = {.lex_state = 28, .external_lex_state = 8},
  [2130] = {.lex_state = 96, .external_lex_state = 16},
  [2131] = {.lex_state = 28, .external_lex_state = 8},
  [2132] = {.lex_state = 28, .external_lex_state = 8},
  [2133] = {.lex_state = 34, .external_lex_state = 15},
  [2134] = {.lex_state = 75, .external_lex_state = 10},
  [2135] = {.lex_state = 34, .external_lex_state = 15},
  [2136] = {.lex_state = 34, .external_lex_state = 10},
  [2137] = {.lex_state = 34, .external_lex_state = 15},
  [2138] = {.lex_state = 75, .external_lex_state = 10},
  [2139] = {.lex_state = 188, .external_lex_state = 6},
  [2140] = {.lex_state = 188, .external_lex_state = 6},
  [2141] = {.lex_state = 188, .external_lex_state = 8},
  [2142] = {.lex_state = 28, .external_lex_state = 8},
  [2143] = {.lex_state = 188, .external_lex_state = 8},
  [2144] = {.lex_state = 188, .external_lex_state = 8},
  [2145] = {.lex_state = 188, .external_lex_state = 6},
  [2146] = {.lex_state = 96, .external_lex_state = 16},
  [2147] = {.lex_state = 188, .external_lex_state = 6},
  [2148] = {.lex_state = 28, .external_lex_state = 8},
  [2149] = {.lex_state = 28, .external_lex_state = 8},
  [2150] = {.lex_state = 188, .external_lex_state = 6},
  [2151] = {.lex_state = 188, .external_lex_state = 8},
  [2152] = {.lex_state = 96, .external_lex_state = 16},
  [2153] = {.lex_state = 188, .external_lex_state = 6},
  [2154] = {.lex_state = 75, .external_lex_state = 10},
  [2155] = {.lex_state = 75, .external_lex_state = 10},
  [2156] = {.lex_state = 188, .external_lex_state = 6},
  [2157] = {.lex_state = 188, .external_lex_state = 6},
  [2158] = {.lex_state = 188, .external_lex_state = 6},
  [2159] = {.lex_state = 188, .external_lex_state = 8},
  [2160] = {.lex_state = 28, .external_lex_state = 8},
  [2161] = {.lex_state = 188, .external_lex_state = 6},
  [2162] = {.lex_state = 188, .external_lex_state = 8},
  [2163] = {.lex_state = 188, .external_lex_state = 8},
  [2164] = {.lex_state = 99},
  [2165] = {.lex_state = 96, .external_lex_state = 16},
  [2166] = {.lex_state = 96, .external_lex_state = 16},
  [2167] = {.lex_state = 96, .external_lex_state = 16},
  [2168] = {.lex_state = 96, .external_lex_state = 16},
  [2169] = {.lex_state = 96, .external_lex_state = 16},
  [2170] = {.lex_state = 96, .external_lex_state = 16},
  [2171] = {.lex_state = 96, .external_lex_state = 16},
  [2172] = {.lex_state = 96, .external_lex_state = 16},
  [2173] = {.lex_state = 96, .external_lex_state = 16},
  [2174] = {.lex_state = 96, .external_lex_state = 16},
  [2175] = {.lex_state = 96, .external_lex_state = 16},
  [2176] = {.lex_state = 96, .external_lex_state = 16},
  [2177] = {.lex_state = 96, .external_lex_state = 16},
  [2178] = {.lex_state = 96, .external_lex_state = 16},
  [2179] = {.lex_state = 96, .external_lex_state = 16},
  [2180] = {.lex_state = 96, .external_lex_state = 16},
  [2181] = {.lex_state = 96, .external_lex_state = 16},
  [2182] = {.lex_state = 96, .external_lex_state = 16},
  [2183] = {.lex_state = 96, .external_lex_state = 16},
  [2184] = {.lex_state = 96, .external_lex_state = 16},
  [2185] = {.lex_state = 96, .external_lex_state = 16},
  [2186] = {.lex_state = 96, .external_lex_state = 16},
  [2187] = {.lex_state = 96, .external_lex_state = 16},
  [2188] = {.lex_state = 96, .external_lex_state = 16},
  [2189] = {.lex_state = 96, .external_lex_state = 16},
  [2190] = {.lex_state = 96, .external_lex_state = 16},
  [2191] = {.lex_state = 96, .external_lex_state = 16},
  [2192] = {.lex_state = 96, .external_lex_state = 16},
  [2193] = {.lex_state = 96, .external_lex_state = 16},
  [2194] = {.lex_state = 96, .external_lex_state = 16},
  [2195] = {.lex_state = 96, .external_lex_state = 16},
  [2196] = {.lex_state = 96, .external_lex_state = 16},
  [2197] = {.lex_state = 96, .external_lex_state = 2},
  [2198] = {.lex_state = 34, .external_lex_state = 15},
  [2199] = {.lex_state = 34, .external_lex_state = 15},
  [2200] = {.lex_state = 34, .external_lex_state = 15},
  [2201] = {.lex_state = 34, .external_lex_state = 15},
  [2202] = {.lex_state = 99},
  [2203] = {.lex_state = 34, .external_lex_state = 15},
  [2204] = {.lex_state = 34, .external_lex_state = 15},
  [2205] = {.lex_state = 99},
  [2206] = {.lex_state = 34, .external_lex_state = 15},
  [2207] = {.lex_state = 99},
  [2208] = {.lex_state = 188, .external_lex_state = 6},
  [2209] = {.lex_state = 34, .external_lex_state = 15},
  [2210] = {.lex_state = 34, .external_lex_state = 15},
  [2211] = {.lex_state = 99},
  [2212] = {.lex_state = 28, .external_lex_state = 6},
  [2213] = {.lex_state = 28, .external_lex_state = 6},
  [2214] = {.lex_state = 200, .external_lex_state = 17},
  [2215] = {.lex_state = 90, .external_lex_state = 17},
  [2216] = {.lex_state = 34, .external_lex_state = 15},
  [2217] = {.lex_state = 34, .external_lex_state = 15},
  [2218] = {.lex_state = 34, .external_lex_state = 15},
  [2219] = {.lex_state = 34, .external_lex_state = 15},
  [2220] = {.lex_state = 188, .external_lex_state = 8},
  [2221] = {.lex_state = 188, .external_lex_state = 6},
  [2222] = {.lex_state = 34, .external_lex_state = 15},
  [2223] = {.lex_state = 34, .external_lex_state = 15},
  [2224] = {.lex_state = 34, .external_lex_state = 15},
  [2225] = {.lex_state = 34, .external_lex_state = 15},
  [2226] = {.lex_state = 34, .external_lex_state = 15},
  [2227] = {.lex_state = 99},
  [2228] = {.lex_state = 34, .external_lex_state = 15},
  [2229] = {.lex_state = 34, .external_lex_state = 15},
  [2230] = {.lex_state = 96, .external_lex_state = 2},
  [2231] = {.lex_state = 99},
  [2232] = {.lex_state = 34, .external_lex_state = 15},
  [2233] = {.lex_state = 34, .external_lex_state = 15},
  [2234] = {.lex_state = 34, .external_lex_state = 15},
  [2235] = {.lex_state = 34, .external_lex_state = 15},
  [2236] = {.lex_state = 34, .external_lex_state = 15},
  [2237] = {.lex_state = 34, .external_lex_state = 15},
  [2238] = {.lex_state = 34, .external_lex_state = 15},
  [2239] = {.lex_state = 34, .external_lex_state = 15},
  [2240] = {.lex_state = 34, .external_lex_state = 15},
  [2241] = {.lex_state = 34, .external_lex_state = 15},
  [2242] = {.lex_state = 28, .external_lex_state = 6},
  [2243] = {.lex_state = 90, .external_lex_state = 17},
  [2244] = {.lex_state = 34, .external_lex_state = 15},
  [2245] = {.lex_state = 34, .external_lex_state = 15},
  [2246] = {.lex_state = 28, .external_lex_state = 6},
  [2247] = {.lex_state = 188, .external_lex_state = 8},
  [2248] = {.lex_state = 96, .external_lex_state = 2},
  [2249] = {.lex_state = 34, .external_lex_state = 10},
  [2250] = {.lex_state = 99},
  [2251] = {.lex_state = 188, .external_lex_state = 8},
  [2252] = {.lex_state = 28, .external_lex_state = 6},
  [2253] = {.lex_state = 188, .external_lex_state = 6},
  [2254] = {.lex_state = 99},
  [2255] = {.lex_state = 99},
  [2256] = {.lex_state = 188, .external_lex_state = 8},
  [2257] = {.lex_state = 188, .external_lex_state = 8},
  [2258] = {.lex_state = 28, .external_lex_state = 6},
  [2259] = {.lex_state = 28, .external_lex_state = 6},
  [2260] = {.lex_state = 28, .external_lex_state = 6},
  [2261] = {.lex_state = 28, .external_lex_state = 6},
  [2262] = {.lex_state = 28, .external_lex_state = 6},
  [2263] = {.lex_state = 28, .external_lex_state = 6},
  [2264] = {.lex_state = 188, .external_lex_state = 8},
  [2265] = {.lex_state = 188, .external_lex_state = 8},
  [2266] = {.lex_state = 28, .external_lex_state = 6},
  [2267] = {.lex_state = 28, .external_lex_state = 6},
  [2268] = {.lex_state = 28, .external_lex_state = 6},
  [2269] = {.lex_state = 28, .external_lex_state = 6},
  [2270] = {.lex_state = 28, .external_lex_state = 6},
  [2271] = {.lex_state = 28, .external_lex_state = 6},
  [2272] = {.lex_state = 28, .external_lex_state = 6},
  [2273] = {.lex_state = 188, .external_lex_state = 8},
  [2274] = {.lex_state = 28, .external_lex_state = 6},
  [2275] = {.lex_state = 28, .external_lex_state = 6},
  [2276] = {.lex_state = 28, .external_lex_state = 6},
  [2277] = {.lex_state = 28, .external_lex_state = 6},
  [2278] = {.lex_state = 28, .external_lex_state = 6},
  [2279] = {.lex_state = 188, .external_lex_state = 8},
  [2280] = {.lex_state = 28, .external_lex_state = 6},
  [2281] = {.lex_state = 90, .external_lex_state = 17},
  [2282] = {.lex_state = 28, .external_lex_state = 6},
  [2283] = {.lex_state = 188, .external_lex_state = 8},
  [2284] = {.lex_state = 188, .external_lex_state = 8},
  [2285] = {.lex_state = 99},
  [2286] = {.lex_state = 28, .external_lex_state = 6},
  [2287] = {.lex_state = 188, .external_lex_state = 8},
  [2288] = {.lex_state = 188, .external_lex_state = 8},
  [2289] = {.lex_state = 28, .external_lex_state = 6},
  [2290] = {.lex_state = 188, .external_lex_state = 8},
  [2291] = {.lex_state = 28, .external_lex_state = 6},
  [2292] = {.lex_state = 188, .external_lex_state = 8},
  [2293] = {.lex_state = 28, .external_lex_state = 6},
  [2294] = {.lex_state = 188, .external_lex_state = 8},
  [2295] = {.lex_state = 28, .external_lex_state = 6},
  [2296] = {.lex_state = 28, .external_lex_state = 6},
  [2297] = {.lex_state = 28, .external_lex_state = 6},
  [2298] = {.lex_state = 188, .external_lex_state = 8},
  [2299] = {.lex_state = 28, .external_lex_state = 6},
  [2300] = {.lex_state = 28, .external_lex_state = 6},
  [2301] = {.lex_state = 28, .external_lex_state = 6},
  [2302] = {.lex_state = 28, .external_lex_state = 6},
  [2303] = {.lex_state = 28, .external_lex_state = 6},
  [2304] = {.lex_state = 188, .external_lex_state = 8},
  [2305] = {.lex_state = 28, .external_lex_state = 6},
  [2306] = {.lex_state = 188, .external_lex_state = 8},
  [2307] = {.lex_state = 188, .external_lex_state = 8},
  [2308] = {.lex_state = 96, .external_lex_state = 16},
  [2309] = {.lex_state = 188, .external_lex_state = 8},
  [2310] = {.lex_state = 188, .external_lex_state = 8},
  [2311] = {.lex_state = 28, .external_lex_state = 6},
  [2312] = {.lex_state = 188, .external_lex_state = 6},
  [2313] = {.lex_state = 188, .external_lex_state = 8},
  [2314] = {.lex_state = 28, .external_lex_state = 6},
  [2315] = {.lex_state = 28, .external_lex_state = 6},
  [2316] = {.lex_state = 188, .external_lex_state = 8},
  [2317] = {.lex_state = 188, .external_lex_state = 8},
  [2318] = {.lex_state = 188, .external_lex_state = 8},
  [2319] = {.lex_state = 28, .external_lex_state = 6},
  [2320] = {.lex_state = 28, .external_lex_state = 6},
  [2321] = {.lex_state = 28, .external_lex_state = 6},
  [2322] = {.lex_state = 28, .external_lex_state = 6},
  [2323] = {.lex_state = 188, .external_lex_state = 8},
  [2324] = {.lex_state = 99},
  [2325] = {.lex_state = 188, .external_lex_state = 8},
  [2326] = {.lex_state = 188, .external_lex_state = 8},
  [2327] = {.lex_state = 188, .external_lex_state = 8},
  [2328] = {.lex_state = 188, .external_lex_state = 6},
  [2329] = {.lex_state = 188, .external_lex_state = 8},
  [2330] = {.lex_state = 188, .external_lex_state = 8},
  [2331] = {.lex_state = 188, .external_lex_state = 8},
  [2332] = {.lex_state = 188, .external_lex_state = 8},
  [2333] = {.lex_state = 188, .external_lex_state = 8},
  [2334] = {.lex_state = 90, .external_lex_state = 17},
  [2335] = {.lex_state = 188, .external_lex_state = 8},
  [2336] = {.lex_state = 188, .external_lex_state = 6},
  [2337] = {.lex_state = 96, .external_lex_state = 2},
  [2338] = {.lex_state = 188, .external_lex_state = 6},
  [2339] = {.lex_state = 34, .external_lex_state = 10},
  [2340] = {.lex_state = 188, .external_lex_state = 6},
  [2341] = {.lex_state = 34, .external_lex_state = 10},
  [2342] = {.lex_state = 188, .external_lex_state = 6},
  [2343] = {.lex_state = 96, .external_lex_state = 2},
  [2344] = {.lex_state = 96, .external_lex_state = 18},
  [2345] = {.lex_state = 188, .external_lex_state = 6},
  [2346] = {.lex_state = 96, .external_lex_state = 2},
  [2347] = {.lex_state = 188, .external_lex_state = 6},
  [2348] = {.lex_state = 96, .external_lex_state = 2},
  [2349] = {.lex_state = 96},
  [2350] = {.lex_state = 188, .external_lex_state = 8},
  [2351] = {.lex_state = 90, .external_lex_state = 17},
  [2352] = {.lex_state = 96, .external_lex_state = 2},
  [2353] = {.lex_state = 188, .external_lex_state = 6},
  [2354] = {.lex_state = 90, .external_lex_state = 17},
  [2355] = {.lex_state = 188, .external_lex_state = 6},
  [2356] = {.lex_state = 188, .external_lex_state = 6},
  [2357] = {.lex_state = 90, .external_lex_state = 17},
  [2358] = {.lex_state = 188, .external_lex_state = 6},
  [2359] = {.lex_state = 188, .external_lex_state = 6},
  [2360] = {.lex_state = 90, .external_lex_state = 17},
  [2361] = {.lex_state = 90, .external_lex_state = 17},
  [2362] = {.lex_state = 188, .external_lex_state = 6},
  [2363] = {.lex_state = 188, .external_lex_state = 6},
  [2364] = {.lex_state = 96, .external_lex_state = 2},
  [2365] = {.lex_state = 96, .external_lex_state = 2},
  [2366] = {.lex_state = 96, .external_lex_state = 2},
  [2367] = {.lex_state = 34, .external_lex_state = 10},
  [2368] = {.lex_state = 34, .external_lex_state = 10},
  [2369] = {.lex_state = 34, .external_lex_state = 10},
  [2370] = {.lex_state = 90, .external_lex_state = 17},
  [2371] = {.lex_state = 90, .external_lex_state = 17},
  [2372] = {.lex_state = 90, .external_lex_state = 17},
  [2373] = {.lex_state = 96, .external_lex_state = 2},
  [2374] = {.lex_state = 188, .external_lex_state = 8},
  [2375] = {.lex_state = 188, .external_lex_state = 6},
  [2376] = {.lex_state = 90, .external_lex_state = 17},
  [2377] = {.lex_state = 34, .external_lex_state = 10},
  [2378] = {.lex_state = 34, .external_lex_state = 10},
  [2379] = {.lex_state = 90, .external_lex_state = 17},
  [2380] = {.lex_state = 188, .external_lex_state = 6},
  [2381] = {.lex_state = 90, .external_lex_state = 17},
  [2382] = {.lex_state = 188, .external_lex_state = 8},
  [2383] = {.lex_state = 188, .external_lex_state = 8},
  [2384] = {.lex_state = 188, .external_lex_state = 6},
  [2385] = {.lex_state = 90, .external_lex_state = 17},
  [2386] = {.lex_state = 188, .external_lex_state = 6},
  [2387] = {.lex_state = 91},
  [2388] = {.lex_state = 188, .external_lex_state = 6},
  [2389] = {.lex_state = 91, .external_lex_state = 17},
  [2390] = {.lex_state = 96, .external_lex_state = 18},
  [2391] = {.lex_state = 188, .external_lex_state = 6},
  [2392] = {.lex_state = 188, .external_lex_state = 8},
  [2393] = {.lex_state = 96, .external_lex_state = 2},
  [2394] = {.lex_state = 34, .external_lex_state = 10},
  [2395] = {.lex_state = 90, .external_lex_state = 17},
  [2396] = {.lex_state = 90, .external_lex_state = 17},
  [2397] = {.lex_state = 90, .external_lex_state = 17},
  [2398] = {.lex_state = 34, .external_lex_state = 10},
  [2399] = {.lex_state = 96, .external_lex_state = 2},
  [2400] = {.lex_state = 34, .external_lex_state = 10},
  [2401] = {.lex_state = 188, .external_lex_state = 6},
  [2402] = {.lex_state = 188, .external_lex_state = 6},
  [2403] = {.lex_state = 188, .external_lex_state = 8},
  [2404] = {.lex_state = 96},
  [2405] = {.lex_state = 188, .external_lex_state = 8},
  [2406] = {.lex_state = 90, .external_lex_state = 17},
  [2407] = {.lex_state = 90, .external_lex_state = 17},
  [2408] = {.lex_state = 188, .external_lex_state = 8},
  [2409] = {.lex_state = 96, .external_lex_state = 18},
  [2410] = {.lex_state = 188, .external_lex_state = 8},
  [2411] = {.lex_state = 188, .external_lex_state = 8},
  [2412] = {.lex_state = 92, .external_lex_state = 19},
  [2413] = {.lex_state = 188, .external_lex_state = 8},
  [2414] = {.lex_state = 188, .external_lex_state = 8},
  [2415] = {.lex_state = 90, .external_lex_state = 17},
  [2416] = {.lex_state = 188, .external_lex_state = 8},
  [2417] = {.lex_state = 188, .external_lex_state = 6},
  [2418] = {.lex_state = 188, .external_lex_state = 8},
  [2419] = {.lex_state = 188, .external_lex_state = 6},
  [2420] = {.lex_state = 96},
  [2421] = {.lex_state = 188, .external_lex_state = 8},
  [2422] = {.lex_state = 96, .external_lex_state = 2},
  [2423] = {.lex_state = 188, .external_lex_state = 8},
  [2424] = {.lex_state = 188, .external_lex_state = 6},
  [2425] = {.lex_state = 90, .external_lex_state = 17},
  [2426] = {.lex_state = 188, .external_lex_state = 8},
  [2427] = {.lex_state = 188, .external_lex_state = 8},
  [2428] = {.lex_state = 96, .external_lex_state = 2},
  [2429] = {.lex_state = 188, .external_lex_state = 8},
  [2430] = {.lex_state = 34, .external_lex_state = 10},
  [2431] = {.lex_state = 96, .external_lex_state = 2},
  [2432] = {.lex_state = 96},
  [2433] = {.lex_state = 188, .external_lex_state = 8},
  [2434] = {.lex_state = 188, .external_lex_state = 8},
  [2435] = {.lex_state = 188, .external_lex_state = 8},
  [2436] = {.lex_state = 90, .external_lex_state = 17},
  [2437] = {.lex_state = 96, .external_lex_state = 2},
  [2438] = {.lex_state = 96, .external_lex_state = 2},
  [2439] = {.lex_state = 188, .external_lex_state = 8},
  [2440] = {.lex_state = 96, .external_lex_state = 18},
  [2441] = {.lex_state = 188, .external_lex_state = 8},
  [2442] = {.lex_state = 90, .external_lex_state = 17},
  [2443] = {.lex_state = 96, .external_lex_state = 18},
  [2444] = {.lex_state = 188, .external_lex_state = 8},
  [2445] = {.lex_state = 90, .external_lex_state = 17},
  [2446] = {.lex_state = 188, .external_lex_state = 8},
  [2447] = {.lex_state = 34, .external_lex_state = 10},
  [2448] = {.lex_state = 96, .external_lex_state = 2},
  [2449] = {.lex_state = 96, .external_lex_state = 2},
  [2450] = {.lex_state = 90, .external_lex_state = 17},
  [2451] = {.lex_state = 96, .external_lex_state = 18},
  [2452] = {.lex_state = 96, .external_lex_state = 18},
  [2453] = {.lex_state = 90, .external_lex_state = 17},
  [2454] = {.lex_state = 90, .external_lex_state = 17},
  [2455] = {.lex_state = 96, .external_lex_state = 2},
  [2456] = {.lex_state = 188, .external_lex_state = 6},
  [2457] = {.lex_state = 188, .external_lex_state = 6},
  [2458] = {.lex_state = 96, .external_lex_state = 2},
  [2459] = {.lex_state = 188, .external_lex_state = 6},
  [2460] = {.lex_state = 96, .external_lex_state = 2},
  [2461] = {.lex_state = 90, .external_lex_state = 17},
  [2462] = {.lex_state = 34, .external_lex_state = 10},
  [2463] = {.lex_state = 96, .external_lex_state = 2},
  [2464] = {.lex_state = 96},
  [2465] = {.lex_state = 90, .external_lex_state = 17},
  [2466] = {.lex_state = 188, .external_lex_state = 8},
  [2467] = {.lex_state = 200},
  [2468] = {.lex_state = 188, .external_lex_state = 8},
  [2469] = {.lex_state = 96, .external_lex_state = 2},
  [2470] = {.lex_state = 34, .external_lex_state = 10},
  [2471] = {.lex_state = 188, .external_lex_state = 6},
  [2472] = {.lex_state = 96, .external_lex_state = 18},
  [2473] = {.lex_state = 188, .external_lex_state = 6},
  [2474] = {.lex_state = 96, .external_lex_state = 2},
  [2475] = {.lex_state = 96},
  [2476] = {.lex_state = 96, .external_lex_state = 2},
  [2477] = {.lex_state = 188, .external_lex_state = 8},
  [2478] = {.lex_state = 96, .external_lex_state = 2},
  [2479] = {.lex_state = 96},
  [2480] = {.lex_state = 188, .external_lex_state = 6},
  [2481] = {.lex_state = 96},
  [2482] = {.lex_state = 188, .external_lex_state = 6},
  [2483] = {.lex_state = 96, .external_lex_state = 2},
  [2484] = {.lex_state = 188, .external_lex_state = 8},
  [2485] = {.lex_state = 90, .external_lex_state = 17},
  [2486] = {.lex_state = 90, .external_lex_state = 17},
  [2487] = {.lex_state = 188, .external_lex_state = 6},
  [2488] = {.lex_state = 188, .external_lex_state = 6},
  [2489] = {.lex_state = 90, .external_lex_state = 17},
  [2490] = {.lex_state = 188, .external_lex_state = 6},
  [2491] = {.lex_state = 188, .external_lex_state = 6},
  [2492] = {.lex_state = 188, .external_lex_state = 6},
  [2493] = {.lex_state = 34, .external_lex_state = 10},
  [2494] = {.lex_state = 188, .external_lex_state = 6},
  [2495] = {.lex_state = 96, .external_lex_state = 2},
  [2496] = {.lex_state = 90, .external_lex_state = 17},
  [2497] = {.lex_state = 96, .external_lex_state = 2},
  [2498] = {.lex_state = 90, .external_lex_state = 17},
  [2499] = {.lex_state = 188, .external_lex_state = 6},
  [2500] = {.lex_state = 188, .external_lex_state = 6},
  [2501] = {.lex_state = 96},
  [2502] = {.lex_state = 96, .external_lex_state = 2},
  [2503] = {.lex_state = 188, .external_lex_state = 6},
  [2504] = {.lex_state = 188, .external_lex_state = 6},
  [2505] = {.lex_state = 96},
  [2506] = {.lex_state = 96, .external_lex_state = 2},
  [2507] = {.lex_state = 96},
  [2508] = {.lex_state = 96, .external_lex_state = 2},
  [2509] = {.lex_state = 188, .external_lex_state = 8},
  [2510] = {.lex_state = 96, .external_lex_state = 2},
  [2511] = {.lex_state = 91, .external_lex_state = 17},
  [2512] = {.lex_state = 96, .external_lex_state = 18},
  [2513] = {.lex_state = 96, .external_lex_state = 2},
  [2514] = {.lex_state = 78},
  [2515] = {.lex_state = 188, .external_lex_state = 6},
  [2516] = {.lex_state = 34, .external_lex_state = 10},
  [2517] = {.lex_state = 188, .external_lex_state = 6},
  [2518] = {.lex_state = 188, .external_lex_state = 6},
  [2519] = {.lex_state = 96},
  [2520] = {.lex_state = 200},
  [2521] = {.lex_state = 96, .external_lex_state = 2},
  [2522] = {.lex_state = 188, .external_lex_state = 6},
  [2523] = {.lex_state = 188, .external_lex_state = 6},
  [2524] = {.lex_state = 91, .external_lex_state = 17},
  [2525] = {.lex_state = 91, .external_lex_state = 17},
  [2526] = {.lex_state = 91, .external_lex_state = 17},
  [2527] = {.lex_state = 188, .external_lex_state = 6},
  [2528] = {.lex_state = 92, .external_lex_state = 11},
  [2529] = {.lex_state = 90},
  [2530] = {.lex_state = 188, .external_lex_state = 6},
  [2531] = {.lex_state = 92, .external_lex_state = 19},
  [2532] = {.lex_state = 90},
  [2533] = {.lex_state = 96},
  [2534] = {.lex_state = 96},
  [2535] = {.lex_state = 91, .external_lex_state = 17},
  [2536] = {.lex_state = 188, .external_lex_state = 6},
  [2537] = {.lex_state = 188, .external_lex_state = 6},
  [2538] = {.lex_state = 188, .external_lex_state = 6},
  [2539] = {.lex_state = 188, .external_lex_state = 6},
  [2540] = {.lex_state = 188, .external_lex_state = 6},
  [2541] = {.lex_state = 91, .external_lex_state = 17},
  [2542] = {.lex_state = 91, .external_lex_state = 17},
  [2543] = {.lex_state = 91, .external_lex_state = 17},
  [2544] = {.lex_state = 91, .external_lex_state = 17},
  [2545] = {.lex_state = 188, .external_lex_state = 6},
  [2546] = {.lex_state = 188, .external_lex_state = 6},
  [2547] = {.lex_state = 91, .external_lex_state = 17},
  [2548] = {.lex_state = 96},
  [2549] = {.lex_state = 188, .external_lex_state = 6},
  [2550] = {.lex_state = 96},
  [2551] = {.lex_state = 96},
  [2552] = {.lex_state = 91, .external_lex_state = 17},
  [2553] = {.lex_state = 96},
  [2554] = {.lex_state = 91, .external_lex_state = 17},
  [2555] = {.lex_state = 200},
  [2556] = {.lex_state = 91, .external_lex_state = 17},
  [2557] = {.lex_state = 91, .external_lex_state = 17},
  [2558] = {.lex_state = 188, .external_lex_state = 6},
  [2559] = {.lex_state = 188, .external_lex_state = 6},
  [2560] = {.lex_state = 90},
  [2561] = {.lex_state = 188, .external_lex_state = 6},
  [2562] = {.lex_state = 188, .external_lex_state = 6},
  [2563] = {.lex_state = 91, .external_lex_state = 17},
  [2564] = {.lex_state = 96},
  [2565] = {.lex_state = 96},
  [2566] = {.lex_state = 91, .external_lex_state = 17},
  [2567] = {.lex_state = 188, .external_lex_state = 6},
  [2568] = {.lex_state = 91, .external_lex_state = 17},
  [2569] = {.lex_state = 91, .external_lex_state = 17},
  [2570] = {.lex_state = 91, .external_lex_state = 17},
  [2571] = {.lex_state = 91, .external_lex_state = 17},
  [2572] = {.lex_state = 91, .external_lex_state = 17},
  [2573] = {.lex_state = 91, .external_lex_state = 17},
  [2574] = {.lex_state = 91, .external_lex_state = 17},
  [2575] = {.lex_state = 91, .external_lex_state = 17},
  [2576] = {.lex_state = 188, .external_lex_state = 6},
  [2577] = {.lex_state = 96},
  [2578] = {.lex_state = 188, .external_lex_state = 6},
  [2579] = {.lex_state = 91, .external_lex_state = 17},
  [2580] = {.lex_state = 188, .external_lex_state = 6},
  [2581] = {.lex_state = 94, .external_lex_state = 20},
  [2582] = {.lex_state = 96},
  [2583] = {.lex_state = 188, .external_lex_state = 6},
  [2584] = {.lex_state = 90},
  [2585] = {.lex_state = 96},
  [2586] = {.lex_state = 91, .external_lex_state = 17},
  [2587] = {.lex_state = 91, .external_lex_state = 17},
  [2588] = {.lex_state = 94, .external_lex_state = 20},
  [2589] = {.lex_state = 188, .external_lex_state = 6},
  [2590] = {.lex_state = 188, .external_lex_state = 6},
  [2591] = {.lex_state = 93, .external_lex_state = 20},
  [2592] = {.lex_state = 188, .external_lex_state = 6},
  [2593] = {.lex_state = 188, .external_lex_state = 6},
  [2594] = {.lex_state = 188, .external_lex_state = 6},
  [2595] = {.lex_state = 96},
  [2596] = {.lex_state = 188, .external_lex_state = 6},
  [2597] = {.lex_state = 96},
  [2598] = {.lex_state = 93, .external_lex_state = 20},
  [2599] = {.lex_state = 91, .external_lex_state = 17},
  [2600] = {.lex_state = 91, .external_lex_state = 17},
  [2601] = {.lex_state = 96},
  [2602] = {.lex_state = 91, .external_lex_state = 17},
  [2603] = {.lex_state = 91},
  [2604] = {.lex_state = 91, .external_lex_state = 17},
  [2605] = {.lex_state = 188, .external_lex_state = 6},
  [2606] = {.lex_state = 96},
  [2607] = {.lex_state = 188, .external_lex_state = 6},
  [2608] = {.lex_state = 90},
  [2609] = {.lex_state = 92, .external_lex_state = 19},
  [2610] = {.lex_state = 96},
  [2611] = {.lex_state = 90},
  [2612] = {.lex_state = 90},
  [2613] = {.lex_state = 91, .external_lex_state = 17},
  [2614] = {.lex_state = 91, .external_lex_state = 17},
  [2615] = {.lex_state = 91, .external_lex_state = 17},
  [2616] = {.lex_state = 91},
  [2617] = {.lex_state = 188, .external_lex_state = 6},
  [2618] = {.lex_state = 96, .external_lex_state = 2},
  [2619] = {.lex_state = 91, .external_lex_state = 17},
  [2620] = {.lex_state = 188, .external_lex_state = 6},
  [2621] = {.lex_state = 96},
  [2622] = {.lex_state = 90},
  [2623] = {.lex_state = 188, .external_lex_state = 6},
  [2624] = {.lex_state = 188, .external_lex_state = 6},
  [2625] = {.lex_state = 94, .external_lex_state = 20},
  [2626] = {.lex_state = 94, .external_lex_state = 20},
  [2627] = {.lex_state = 188, .external_lex_state = 6},
  [2628] = {.lex_state = 96, .external_lex_state = 2},
  [2629] = {.lex_state = 188, .external_lex_state = 6},
  [2630] = {.lex_state = 96},
  [2631] = {.lex_state = 188, .external_lex_state = 6},
  [2632] = {.lex_state = 188, .external_lex_state = 6},
  [2633] = {.lex_state = 188, .external_lex_state = 6},
  [2634] = {.lex_state = 188, .external_lex_state = 6},
  [2635] = {.lex_state = 188, .external_lex_state = 6},
  [2636] = {.lex_state = 188, .external_lex_state = 6},
  [2637] = {.lex_state = 188, .external_lex_state = 6},
  [2638] = {.lex_state = 188, .external_lex_state = 6},
  [2639] = {.lex_state = 188, .external_lex_state = 6},
  [2640] = {.lex_state = 93, .external_lex_state = 20},
  [2641] = {.lex_state = 93, .external_lex_state = 20},
  [2642] = {.lex_state = 96},
  [2643] = {.lex_state = 188, .external_lex_state = 6},
  [2644] = {.lex_state = 92, .external_lex_state = 19},
  [2645] = {.lex_state = 92, .external_lex_state = 11},
  [2646] = {.lex_state = 96},
  [2647] = {.lex_state = 188, .external_lex_state = 6},
  [2648] = {.lex_state = 188, .external_lex_state = 6},
  [2649] = {.lex_state = 96, .external_lex_state = 2},
  [2650] = {.lex_state = 97, .external_lex_state = 13},
  [2651] = {.lex_state = 97, .external_lex_state = 13},
  [2652] = {.lex_state = 97, .external_lex_state = 13},
  [2653] = {.lex_state = 97, .external_lex_state = 13},
  [2654] = {.lex_state = 96, .external_lex_state = 14},
  [2655] = {.lex_state = 97, .external_lex_state = 13},
  [2656] = {.lex_state = 96, .external_lex_state = 14},
  [2657] = {.lex_state = 97, .external_lex_state = 13},
  [2658] = {.lex_state = 97, .external_lex_state = 13},
  [2659] = {.lex_state = 96},
  [2660] = {.lex_state = 200},
  [2661] = {.lex_state = 97, .external_lex_state = 13},
  [2662] = {.lex_state = 97, .external_lex_state = 13},
  [2663] = {.lex_state = 94, .external_lex_state = 20},
  [2664] = {.lex_state = 94, .external_lex_state = 20},
  [2665] = {.lex_state = 94, .external_lex_state = 20},
  [2666] = {.lex_state = 92, .external_lex_state = 11},
  [2667] = {.lex_state = 94, .external_lex_state = 20},
  [2668] = {.lex_state = 94, .external_lex_state = 20},
  [2669] = {.lex_state = 94, .external_lex_state = 20},
  [2670] = {.lex_state = 94, .external_lex_state = 20},
  [2671] = {.lex_state = 92, .external_lex_state = 19},
  [2672] = {.lex_state = 93, .external_lex_state = 13},
  [2673] = {.lex_state = 94, .external_lex_state = 20},
  [2674] = {.lex_state = 97, .external_lex_state = 13},
  [2675] = {.lex_state = 97, .external_lex_state = 13},
  [2676] = {.lex_state = 94, .external_lex_state = 20},
  [2677] = {.lex_state = 97, .external_lex_state = 13},
  [2678] = {.lex_state = 94, .external_lex_state = 20},
  [2679] = {.lex_state = 92, .external_lex_state = 19},
  [2680] = {.lex_state = 92, .external_lex_state = 19},
  [2681] = {.lex_state = 97, .external_lex_state = 13},
  [2682] = {.lex_state = 94, .external_lex_state = 20},
  [2683] = {.lex_state = 97, .external_lex_state = 13},
  [2684] = {.lex_state = 92, .external_lex_state = 19},
  [2685] = {.lex_state = 94, .external_lex_state = 20},
  [2686] = {.lex_state = 93, .external_lex_state = 13},
  [2687] = {.lex_state = 92, .external_lex_state = 19},
  [2688] = {.lex_state = 92, .external_lex_state = 19},
  [2689] = {.lex_state = 97, .external_lex_state = 13},
  [2690] = {.lex_state = 97, .external_lex_state = 13},
  [2691] = {.lex_state = 94, .external_lex_state = 20},
  [2692] = {.lex_state = 94, .external_lex_state = 20},
  [2693] = {.lex_state = 94, .external_lex_state = 20},
  [2694] = {.lex_state = 94, .external_lex_state = 20},
  [2695] = {.lex_state = 97, .external_lex_state = 13},
  [2696] = {.lex_state = 94, .external_lex_state = 20},
  [2697] = {.lex_state = 94, .external_lex_state = 20},
  [2698] = {.lex_state = 94, .external_lex_state = 20},
  [2699] = {.lex_state = 97, .external_lex_state = 13},
  [2700] = {.lex_state = 93, .external_lex_state = 13},
  [2701] = {.lex_state = 97, .external_lex_state = 13},
  [2702] = {.lex_state = 97, .external_lex_state = 13},
  [2703] = {.lex_state = 94, .external_lex_state = 20},
  [2704] = {.lex_state = 97, .external_lex_state = 13},
  [2705] = {.lex_state = 94, .external_lex_state = 20},
  [2706] = {.lex_state = 94, .external_lex_state = 20},
  [2707] = {.lex_state = 97, .external_lex_state = 13},
  [2708] = {.lex_state = 92, .external_lex_state = 19},
  [2709] = {.lex_state = 94, .external_lex_state = 20},
  [2710] = {.lex_state = 97, .external_lex_state = 13},
  [2711] = {.lex_state = 94, .external_lex_state = 20},
  [2712] = {.lex_state = 92, .external_lex_state = 19},
  [2713] = {.lex_state = 97, .external_lex_state = 13},
  [2714] = {.lex_state = 92, .external_lex_state = 19},
  [2715] = {.lex_state = 97, .external_lex_state = 13},
  [2716] = {.lex_state = 97, .external_lex_state = 13},
  [2717] = {.lex_state = 92, .external_lex_state = 19},
  [2718] = {.lex_state = 94, .external_lex_state = 13},
  [2719] = {.lex_state = 92, .external_lex_state = 19},
  [2720] = {.lex_state = 92, .external_lex_state = 19},
  [2721] = {.lex_state = 92, .external_lex_state = 19},
  [2722] = {.lex_state = 92, .external_lex_state = 19},
  [2723] = {.lex_state = 97, .external_lex_state = 13},
  [2724] = {.lex_state = 97, .external_lex_state = 13},
  [2725] = {.lex_state = 94, .external_lex_state = 20},
  [2726] = {.lex_state = 97, .external_lex_state = 13},
  [2727] = {.lex_state = 94, .external_lex_state = 20},
  [2728] = {.lex_state = 92, .external_lex_state = 19},
  [2729] = {.lex_state = 92, .external_lex_state = 19},
  [2730] = {.lex_state = 92, .external_lex_state = 19},
  [2731] = {.lex_state = 92, .external_lex_state = 19},
  [2732] = {.lex_state = 92, .external_lex_state = 19},
  [2733] = {.lex_state = 97, .external_lex_state = 13},
  [2734] = {.lex_state = 94, .external_lex_state = 20},
  [2735] = {.lex_state = 92, .external_lex_state = 19},
  [2736] = {.lex_state = 92, .external_lex_state = 19},
  [2737] = {.lex_state = 92, .external_lex_state = 19},
  [2738] = {.lex_state = 92, .external_lex_state = 19},
  [2739] = {.lex_state = 97, .external_lex_state = 13},
  [2740] = {.lex_state = 94, .external_lex_state = 20},
  [2741] = {.lex_state = 97, .external_lex_state = 13},
  [2742] = {.lex_state = 92, .external_lex_state = 19},
  [2743] = {.lex_state = 92, .external_lex_state = 19},
  [2744] = {.lex_state = 92, .external_lex_state = 19},
  [2745] = {.lex_state = 92, .external_lex_state = 19},
  [2746] = {.lex_state = 97, .external_lex_state = 13},
  [2747] = {.lex_state = 94, .external_lex_state = 20},
  [2748] = {.lex_state = 96},
  [2749] = {.lex_state = 97, .external_lex_state = 13},
  [2750] = {.lex_state = 97, .external_lex_state = 13},
  [2751] = {.lex_state = 97, .external_lex_state = 13},
  [2752] = {.lex_state = 97, .external_lex_state = 13},
  [2753] = {.lex_state = 94, .external_lex_state = 20},
  [2754] = {.lex_state = 90},
  [2755] = {.lex_state = 94, .external_lex_state = 20},
  [2756] = {.lex_state = 97, .external_lex_state = 13},
  [2757] = {.lex_state = 97, .external_lex_state = 13},
  [2758] = {.lex_state = 97, .external_lex_state = 13},
  [2759] = {.lex_state = 97, .external_lex_state = 13},
  [2760] = {.lex_state = 97, .external_lex_state = 13},
  [2761] = {.lex_state = 97, .external_lex_state = 13},
  [2762] = {.lex_state = 97, .external_lex_state = 13},
  [2763] = {.lex_state = 97, .external_lex_state = 13},
  [2764] = {.lex_state = 93, .external_lex_state = 13},
  [2765] = {.lex_state = 97, .external_lex_state = 13},
  [2766] = {.lex_state = 97, .external_lex_state = 13},
  [2767] = {.lex_state = 97, .external_lex_state = 13},
  [2768] = {.lex_state = 97, .external_lex_state = 13},
  [2769] = {.lex_state = 97, .external_lex_state = 13},
  [2770] = {.lex_state = 94, .external_lex_state = 13},
  [2771] = {.lex_state = 97, .external_lex_state = 13},
  [2772] = {.lex_state = 97, .external_lex_state = 13},
  [2773] = {.lex_state = 97, .external_lex_state = 13},
  [2774] = {.lex_state = 97, .external_lex_state = 13},
  [2775] = {.lex_state = 97, .external_lex_state = 13},
  [2776] = {.lex_state = 97, .external_lex_state = 13},
  [2777] = {.lex_state = 97, .external_lex_state = 13},
  [2778] = {.lex_state = 97, .external_lex_state = 13},
  [2779] = {.lex_state = 96, .external_lex_state = 14},
  [2780] = {.lex_state = 97, .external_lex_state = 13},
  [2781] = {.lex_state = 94, .external_lex_state = 20},
  [2782] = {.lex_state = 97, .external_lex_state = 13},
  [2783] = {.lex_state = 96, .external_lex_state = 14},
  [2784] = {.lex_state = 97, .external_lex_state = 13},
  [2785] = {.lex_state = 97, .external_lex_state = 13},
  [2786] = {.lex_state = 97, .external_lex_state = 13},
  [2787] = {.lex_state = 97, .external_lex_state = 13},
  [2788] = {.lex_state = 92, .external_lex_state = 19},
  [2789] = {.lex_state = 92, .external_lex_state = 19},
  [2790] = {.lex_state = 97, .external_lex_state = 13},
  [2791] = {.lex_state = 97, .external_lex_state = 13},
  [2792] = {.lex_state = 97, .external_lex_state = 13},
  [2793] = {.lex_state = 96},
  [2794] = {.lex_state = 92, .external_lex_state = 19},
  [2795] = {.lex_state = 92, .external_lex_state = 19},
  [2796] = {.lex_state = 92, .external_lex_state = 19},
  [2797] = {.lex_state = 97, .external_lex_state = 13},
  [2798] = {.lex_state = 97, .external_lex_state = 13},
  [2799] = {.lex_state = 97, .external_lex_state = 13},
  [2800] = {.lex_state = 97, .external_lex_state = 13},
  [2801] = {.lex_state = 97, .external_lex_state = 13},
  [2802] = {.lex_state = 97, .external_lex_state = 13},
  [2803] = {.lex_state = 97, .external_lex_state = 13},
  [2804] = {.lex_state = 97, .external_lex_state = 13},
  [2805] = {.lex_state = 97, .external_lex_state = 13},
  [2806] = {.lex_state = 97, .external_lex_state = 13},
  [2807] = {.lex_state = 97, .external_lex_state = 13},
  [2808] = {.lex_state = 97, .external_lex_state = 13},
  [2809] = {.lex_state = 97, .external_lex_state = 13},
  [2810] = {.lex_state = 97, .external_lex_state = 13},
  [2811] = {.lex_state = 97, .external_lex_state = 13},
  [2812] = {.lex_state = 97, .external_lex_state = 13},
  [2813] = {.lex_state = 97, .external_lex_state = 13},
  [2814] = {.lex_state = 97, .external_lex_state = 13},
  [2815] = {.lex_state = 97, .external_lex_state = 13},
  [2816] = {.lex_state = 97, .external_lex_state = 13},
  [2817] = {.lex_state = 97, .external_lex_state = 13},
  [2818] = {.lex_state = 97, .external_lex_state = 13},
  [2819] = {.lex_state = 97, .external_lex_state = 13},
  [2820] = {.lex_state = 97, .external_lex_state = 13},
  [2821] = {.lex_state = 97, .external_lex_state = 13},
  [2822] = {.lex_state = 97, .external_lex_state = 13},
  [2823] = {.lex_state = 96},
  [2824] = {.lex_state = 200},
  [2825] = {.lex_state = 96},
  [2826] = {.lex_state = 90},
  [2827] = {.lex_state = 96},
  [2828] = {.lex_state = 96},
  [2829] = {.lex_state = 96},
  [2830] = {.lex_state = 200},
  [2831] = {.lex_state = 92, .external_lex_state = 11},
  [2832] = {.lex_state = 200},
  [2833] = {.lex_state = 91},
  [2834] = {.lex_state = 91},
  [2835] = {.lex_state = 200},
  [2836] = {.lex_state = 200},
  [2837] = {.lex_state = 96},
  [2838] = {.lex_state = 91},
  [2839] = {.lex_state = 92, .external_lex_state = 11},
  [2840] = {.lex_state = 200},
  [2841] = {.lex_state = 200},
  [2842] = {.lex_state = 200},
  [2843] = {.lex_state = 96},
  [2844] = {.lex_state = 92, .external_lex_state = 11},
  [2845] = {.lex_state = 91},
  [2846] = {.lex_state = 96},
  [2847] = {.lex_state = 94, .external_lex_state = 13},
  [2848] = {.lex_state = 91},
  [2849] = {.lex_state = 91},
  [2850] = {.lex_state = 92, .external_lex_state = 11},
  [2851] = {.lex_state = 200},
  [2852] = {.lex_state = 96},
  [2853] = {.lex_state = 91},
  [2854] = {.lex_state = 92, .external_lex_state = 11},
  [2855] = {.lex_state = 92, .external_lex_state = 11},
  [2856] = {.lex_state = 200},
  [2857] = {.lex_state = 91},
  [2858] = {.lex_state = 92, .external_lex_state = 11},
  [2859] = {.lex_state = 90},
  [2860] = {.lex_state = 96},
  [2861] = {.lex_state = 96},
  [2862] = {.lex_state = 200},
  [2863] = {.lex_state = 96},
  [2864] = {.lex_state = 96},
  [2865] = {.lex_state = 96},
  [2866] = {.lex_state = 200},
  [2867] = {.lex_state = 200},
  [2868] = {.lex_state = 200},
  [2869] = {.lex_state = 91},
  [2870] = {.lex_state = 96},
  [2871] = {.lex_state = 91},
  [2872] = {.lex_state = 96},
  [2873] = {.lex_state = 96},
  [2874] = {.lex_state = 200},
  [2875] = {.lex_state = 200},
  [2876] = {.lex_state = 200},
  [2877] = {.lex_state = 92, .external_lex_state = 11},
  [2878] = {.lex_state = 90},
  [2879] = {.lex_state = 90},
  [2880] = {.lex_state = 92, .external_lex_state = 11},
  [2881] = {.lex_state = 200},
  [2882] = {.lex_state = 200},
  [2883] = {.lex_state = 91},
  [2884] = {.lex_state = 96},
  [2885] = {.lex_state = 96},
  [2886] = {.lex_state = 96},
  [2887] = {.lex_state = 200},
  [2888] = {.lex_state = 92, .external_lex_state = 11},
  [2889] = {.lex_state = 98, .external_lex_state = 11},
  [2890] = {.lex_state = 27, .external_lex_state = 10},
  [2891] = {.lex_state = 98, .external_lex_state = 11},
  [2892] = {.lex_state = 96},
  [2893] = {.lex_state = 96},
  [2894] = {.lex_state = 75, .external_lex_state = 15},
  [2895] = {.lex_state = 96},
  [2896] = {.lex_state = 96},
  [2897] = {.lex_state = 96},
  [2898] = {.lex_state = 96},
  [2899] = {.lex_state = 96},
  [2900] = {.lex_state = 96},
  [2901] = {.lex_state = 96},
  [2902] = {.lex_state = 96},
  [2903] = {.lex_state = 96},
  [2904] = {.lex_state = 96},
  [2905] = {.lex_state = 75, .external_lex_state = 15},
  [2906] = {.lex_state = 96},
  [2907] = {.lex_state = 96},
  [2908] = {.lex_state = 96},
  [2909] = {.lex_state = 96},
  [2910] = {.lex_state = 96},
  [2911] = {.lex_state = 96},
  [2912] = {.lex_state = 96},
  [2913] = {.lex_state = 96},
  [2914] = {.lex_state = 96},
  [2915] = {.lex_state = 96},
  [2916] = {.lex_state = 96},
  [2917] = {.lex_state = 96},
  [2918] = {.lex_state = 96},
  [2919] = {.lex_state = 96},
  [2920] = {.lex_state = 96},
  [2921] = {.lex_state = 96},
  [2922] = {.lex_state = 96},
  [2923] = {.lex_state = 96},
  [2924] = {.lex_state = 96},
  [2925] = {.lex_state = 96},
  [2926] = {.lex_state = 96},
  [2927] = {.lex_state = 96},
  [2928] = {.lex_state = 75, .external_lex_state = 15},
  [2929] = {.lex_state = 96},
  [2930] = {.lex_state = 96},
  [2931] = {.lex_state = 96},
  [2932] = {.lex_state = 96},
  [2933] = {.lex_state = 96},
  [2934] = {.lex_state = 96},
  [2935] = {.lex_state = 96},
  [2936] = {.lex_state = 96},
  [2937] = {.lex_state = 96},
  [2938] = {.lex_state = 96},
  [2939] = {.lex_state = 96},
  [2940] = {.lex_state = 96},
  [2941] = {.lex_state = 96},
  [2942] = {.lex_state = 96},
  [2943] = {.lex_state = 96},
  [2944] = {.lex_state = 96},
  [2945] = {.lex_state = 75, .external_lex_state = 15},
  [2946] = {.lex_state = 96},
  [2947] = {.lex_state = 96},
  [2948] = {.lex_state = 96},
  [2949] = {.lex_state = 96},
  [2950] = {.lex_state = 96},
  [2951] = {.lex_state = 96},
  [2952] = {.lex_state = 96},
  [2953] = {.lex_state = 96},
  [2954] = {.lex_state = 96},
  [2955] = {.lex_state = 96},
  [2956] = {.lex_state = 96},
  [2957] = {.lex_state = 75, .external_lex_state = 15},
  [2958] = {.lex_state = 75, .external_lex_state = 15},
  [2959] = {.lex_state = 75, .external_lex_state = 15},
  [2960] = {.lex_state = 75, .external_lex_state = 15},
  [2961] = {.lex_state = 75, .external_lex_state = 15},
  [2962] = {.lex_state = 75, .external_lex_state = 15},
  [2963] = {.lex_state = 75, .external_lex_state = 15},
  [2964] = {.lex_state = 75, .external_lex_state = 15},
  [2965] = {.lex_state = 75, .external_lex_state = 15},
  [2966] = {.lex_state = 75, .external_lex_state = 15},
  [2967] = {.lex_state = 75, .external_lex_state = 15},
  [2968] = {.lex_state = 75, .external_lex_state = 15},
  [2969] = {.lex_state = 75, .external_lex_state = 10},
  [2970] = {.lex_state = 75, .external_lex_state = 15},
  [2971] = {.lex_state = 75, .external_lex_state = 15},
  [2972] = {.lex_state = 75, .external_lex_state = 15},
  [2973] = {.lex_state = 75, .external_lex_state = 15},
  [2974] = {.lex_state = 75, .external_lex_state = 15},
  [2975] = {.lex_state = 75, .external_lex_state = 15},
  [2976] = {.lex_state = 75, .external_lex_state = 15},
  [2977] = {.lex_state = 75, .external_lex_state = 15},
  [2978] = {.lex_state = 75, .external_lex_state = 15},
  [2979] = {.lex_state = 75, .external_lex_state = 15},
  [2980] = {.lex_state = 75, .external_lex_state = 15},
  [2981] = {.lex_state = 75, .external_lex_state = 15},
  [2982] = {.lex_state = 75, .external_lex_state = 15},
  [2983] = {.lex_state = 75, .external_lex_state = 15},
  [2984] = {.lex_state = 75, .external_lex_state = 15},
  [2985] = {.lex_state = 75, .external_lex_state = 10},
  [2986] = {.lex_state = 75, .external_lex_state = 15},
  [2987] = {.lex_state = 75, .external_lex_state = 15},
  [2988] = {.lex_state = 75, .external_lex_state = 15},
  [2989] = {.lex_state = 75, .external_lex_state = 15},
  [2990] = {.lex_state = 75, .external_lex_state = 15},
  [2991] = {.lex_state = 85, .external_lex_state = 21},
  [2992] = {.lex_state = 85, .external_lex_state = 21},
  [2993] = {.lex_state = 85, .external_lex_state = 21},
  [2994] = {.lex_state = 85, .external_lex_state = 19},
  [2995] = {.lex_state = 85, .external_lex_state = 21},
  [2996] = {.lex_state = 85, .external_lex_state = 21},
  [2997] = {.lex_state = 85, .external_lex_state = 21},
  [2998] = {.lex_state = 85, .external_lex_state = 21},
  [2999] = {.lex_state = 85, .external_lex_state = 21},
  [3000] = {.lex_state = 85, .external_lex_state = 21},
  [3001] = {.lex_state = 85, .external_lex_state = 21},
  [3002] = {.lex_state = 85, .external_lex_state = 21},
  [3003] = {.lex_state = 85, .external_lex_state = 21},
  [3004] = {.lex_state = 85, .external_lex_state = 21},
  [3005] = {.lex_state = 85},
  [3006] = {.lex_state = 85, .external_lex_state = 21},
  [3007] = {.lex_state = 85, .external_lex_state = 21},
  [3008] = {.lex_state = 85, .external_lex_state = 21},
  [3009] = {.lex_state = 85, .external_lex_state = 21},
  [3010] = {.lex_state = 85, .external_lex_state = 21},
  [3011] = {.lex_state = 85, .external_lex_state = 21},
  [3012] = {.lex_state = 85, .external_lex_state = 21},
  [3013] = {.lex_state = 85, .external_lex_state = 21},
  [3014] = {.lex_state = 85, .external_lex_state = 21},
  [3015] = {.lex_state = 85, .external_lex_state = 21},
  [3016] = {.lex_state = 85, .external_lex_state = 21},
  [3017] = {.lex_state = 75, .external_lex_state = 10},
  [3018] = {.lex_state = 85, .external_lex_state = 21},
  [3019] = {.lex_state = 85, .external_lex_state = 21},
  [3020] = {.lex_state = 85, .external_lex_state = 21},
  [3021] = {.lex_state = 85, .external_lex_state = 21},
  [3022] = {.lex_state = 85, .external_lex_state = 21},
  [3023] = {.lex_state = 85, .external_lex_state = 21},
  [3024] = {.lex_state = 85, .external_lex_state = 21},
  [3025] = {.lex_state = 96, .external_lex_state = 17},
  [3026] = {.lex_state = 96, .external_lex_state = 17},
  [3027] = {.lex_state = 96, .external_lex_state = 17},
  [3028] = {.lex_state = 96, .external_lex_state = 17},
  [3029] = {.lex_state = 85, .external_lex_state = 13},
  [3030] = {.lex_state = 85},
  [3031] = {.lex_state = 96},
  [3032] = {.lex_state = 85},
  [3033] = {.lex_state = 85, .external_lex_state = 21},
  [3034] = {.lex_state = 85, .external_lex_state = 21},
  [3035] = {.lex_state = 96, .external_lex_state = 17},
  [3036] = {.lex_state = 85},
  [3037] = {.lex_state = 96, .external_lex_state = 17},
  [3038] = {.lex_state = 96, .external_lex_state = 17},
  [3039] = {.lex_state = 96, .external_lex_state = 17},
  [3040] = {.lex_state = 96, .external_lex_state = 17},
  [3041] = {.lex_state = 85, .external_lex_state = 21},
  [3042] = {.lex_state = 85},
  [3043] = {.lex_state = 85, .external_lex_state = 21},
  [3044] = {.lex_state = 85},
  [3045] = {.lex_state = 85},
  [3046] = {.lex_state = 85, .external_lex_state = 21},
  [3047] = {.lex_state = 96, .external_lex_state = 17},
  [3048] = {.lex_state = 96, .external_lex_state = 17},
  [3049] = {.lex_state = 85},
  [3050] = {.lex_state = 96, .external_lex_state = 17},
  [3051] = {.lex_state = 85, .external_lex_state = 21},
  [3052] = {.lex_state = 85, .external_lex_state = 21},
  [3053] = {.lex_state = 85},
  [3054] = {.lex_state = 85},
  [3055] = {.lex_state = 85},
  [3056] = {.lex_state = 96, .external_lex_state = 17},
  [3057] = {.lex_state = 85, .external_lex_state = 21},
  [3058] = {.lex_state = 85, .external_lex_state = 21},
  [3059] = {.lex_state = 85},
  [3060] = {.lex_state = 85},
  [3061] = {.lex_state = 85, .external_lex_state = 21},
  [3062] = {.lex_state = 85, .external_lex_state = 21},
  [3063] = {.lex_state = 85},
  [3064] = {.lex_state = 96, .external_lex_state = 17},
  [3065] = {.lex_state = 85},
  [3066] = {.lex_state = 96},
  [3067] = {.lex_state = 85, .external_lex_state = 21},
  [3068] = {.lex_state = 96, .external_lex_state = 17},
  [3069] = {.lex_state = 85, .external_lex_state = 21},
  [3070] = {.lex_state = 96, .external_lex_state = 17},
  [3071] = {.lex_state = 96, .external_lex_state = 17},
  [3072] = {.lex_state = 96, .external_lex_state = 17},
  [3073] = {.lex_state = 96, .external_lex_state = 17},
  [3074] = {.lex_state = 85},
  [3075] = {.lex_state = 96, .external_lex_state = 17},
  [3076] = {.lex_state = 85},
  [3077] = {.lex_state = 96, .external_lex_state = 17},
  [3078] = {.lex_state = 85},
  [3079] = {.lex_state = 96, .external_lex_state = 17},
  [3080] = {.lex_state = 96, .external_lex_state = 17},
  [3081] = {.lex_state = 96, .external_lex_state = 17},
  [3082] = {.lex_state = 85, .external_lex_state = 21},
  [3083] = {.lex_state = 96, .external_lex_state = 17},
  [3084] = {.lex_state = 85, .external_lex_state = 21},
  [3085] = {.lex_state = 96, .external_lex_state = 17},
  [3086] = {.lex_state = 85},
  [3087] = {.lex_state = 85, .external_lex_state = 21},
  [3088] = {.lex_state = 96, .external_lex_state = 17},
  [3089] = {.lex_state = 96, .external_lex_state = 17},
  [3090] = {.lex_state = 85},
  [3091] = {.lex_state = 85, .external_lex_state = 21},
  [3092] = {.lex_state = 96, .external_lex_state = 17},
  [3093] = {.lex_state = 85},
  [3094] = {.lex_state = 85},
  [3095] = {.lex_state = 85},
  [3096] = {.lex_state = 85, .external_lex_state = 21},
  [3097] = {.lex_state = 96, .external_lex_state = 17},
  [3098] = {.lex_state = 85, .external_lex_state = 21},
  [3099] = {.lex_state = 96, .external_lex_state = 17},
  [3100] = {.lex_state = 85},
  [3101] = {.lex_state = 85, .external_lex_state = 21},
  [3102] = {.lex_state = 85},
  [3103] = {.lex_state = 85},
  [3104] = {.lex_state = 85, .external_lex_state = 21},
  [3105] = {.lex_state = 96, .external_lex_state = 17},
  [3106] = {.lex_state = 85, .external_lex_state = 21},
  [3107] = {.lex_state = 85},
  [3108] = {.lex_state = 85, .external_lex_state = 21},
  [3109] = {.lex_state = 85, .external_lex_state = 21},
  [3110] = {.lex_state = 96, .external_lex_state = 17},
  [3111] = {.lex_state = 85, .external_lex_state = 21},
  [3112] = {.lex_state = 85, .external_lex_state = 21},
  [3113] = {.lex_state = 85, .external_lex_state = 21},
  [3114] = {.lex_state = 85, .external_lex_state = 21},
  [3115] = {.lex_state = 85},
  [3116] = {.lex_state = 85, .external_lex_state = 21},
  [3117] = {.lex_state = 85, .external_lex_state = 21},
  [3118] = {.lex_state = 85},
  [3119] = {.lex_state = 85},
  [3120] = {.lex_state = 85, .external_lex_state = 21},
  [3121] = {.lex_state = 96, .external_lex_state = 17},
  [3122] = {.lex_state = 96, .external_lex_state = 17},
  [3123] = {.lex_state = 96, .external_lex_state = 17},
  [3124] = {.lex_state = 99},
  [3125] = {.lex_state = 86},
  [3126] = {.lex_state = 86},
  [3127] = {.lex_state = 86},
  [3128] = {.lex_state = 99},
  [3129] = {.lex_state = 86},
  [3130] = {.lex_state = 99},
  [3131] = {.lex_state = 86},
  [3132] = {.lex_state = 86},
  [3133] = {.lex_state = 99},
  [3134] = {.lex_state = 86},
  [3135] = {.lex_state = 86},
  [3136] = {.lex_state = 86},
  [3137] = {.lex_state = 86},
  [3138] = {.lex_state = 86},
  [3139] = {.lex_state = 86},
  [3140] = {.lex_state = 86},
  [3141] = {.lex_state = 86},
  [3142] = {.lex_state = 99},
  [3143] = {.lex_state = 86},
  [3144] = {.lex_state = 86},
  [3145] = {.lex_state = 86},
  [3146] = {.lex_state = 99},
  [3147] = {.lex_state = 86},
  [3148] = {.lex_state = 86},
  [3149] = {.lex_state = 99},
  [3150] = {.lex_state = 86},
  [3151] = {.lex_state = 96},
  [3152] = {.lex_state = 86},
  [3153] = {.lex_state = 86},
  [3154] = {.lex_state = 86},
  [3155] = {.lex_state = 86},
  [3156] = {.lex_state = 86},
  [3157] = {.lex_state = 86},
  [3158] = {.lex_state = 86},
  [3159] = {.lex_state = 86},
  [3160] = {.lex_state = 86},
  [3161] = {.lex_state = 86},
  [3162] = {.lex_state = 86},
  [3163] = {.lex_state = 86},
  [3164] = {.lex_state = 99},
  [3165] = {.lex_state = 86},
  [3166] = {.lex_state = 86},
  [3167] = {.lex_state = 86},
  [3168] = {.lex_state = 86},
  [3169] = {.lex_state = 99},
  [3170] = {.lex_state = 86},
  [3171] = {.lex_state = 99},
  [3172] = {.lex_state = 86},
  [3173] = {.lex_state = 85, .external_lex_state = 21},
  [3174] = {.lex_state = 86},
  [3175] = {.lex_state = 86},
  [3176] = {.lex_state = 86},
  [3177] = {.lex_state = 86},
  [3178] = {.lex_state = 86},
  [3179] = {.lex_state = 86},
  [3180] = {.lex_state = 86},
  [3181] = {.lex_state = 86},
  [3182] = {.lex_state = 85, .external_lex_state = 21},
  [3183] = {.lex_state = 86},
  [3184] = {.lex_state = 86},
  [3185] = {.lex_state = 86},
  [3186] = {.lex_state = 86},
  [3187] = {.lex_state = 86},
  [3188] = {.lex_state = 86},
  [3189] = {.lex_state = 86},
  [3190] = {.lex_state = 86},
  [3191] = {.lex_state = 86},
  [3192] = {.lex_state = 86},
  [3193] = {.lex_state = 86},
  [3194] = {.lex_state = 86},
  [3195] = {.lex_state = 101, .external_lex_state = 21},
  [3196] = {.lex_state = 101, .external_lex_state = 21},
  [3197] = {.lex_state = 101, .external_lex_state = 21},
  [3198] = {.lex_state = 101, .external_lex_state = 21},
  [3199] = {.lex_state = 101, .external_lex_state = 21},
  [3200] = {.lex_state = 101, .external_lex_state = 21},
  [3201] = {.lex_state = 96},
  [3202] = {.lex_state = 101, .external_lex_state = 21},
  [3203] = {.lex_state = 101, .external_lex_state = 21},
  [3204] = {.lex_state = 101, .external_lex_state = 21},
  [3205] = {.lex_state = 96},
  [3206] = {.lex_state = 96},
  [3207] = {.lex_state = 101, .external_lex_state = 21},
  [3208] = {.lex_state = 101, .external_lex_state = 21},
  [3209] = {.lex_state = 96},
  [3210] = {.lex_state = 101, .external_lex_state = 21},
  [3211] = {.lex_state = 101, .external_lex_state = 21},
  [3212] = {.lex_state = 96},
  [3213] = {.lex_state = 96},
  [3214] = {.lex_state = 96},
  [3215] = {.lex_state = 101, .external_lex_state = 21},
  [3216] = {.lex_state = 101, .external_lex_state = 21},
  [3217] = {.lex_state = 101, .external_lex_state = 21},
  [3218] = {.lex_state = 101, .external_lex_state = 21},
  [3219] = {.lex_state = 101, .external_lex_state = 21},
  [3220] = {.lex_state = 101, .external_lex_state = 21},
  [3221] = {.lex_state = 101, .external_lex_state = 21},
  [3222] = {.lex_state = 101, .external_lex_state = 21},
  [3223] = {.lex_state = 101, .external_lex_state = 21},
  [3224] = {.lex_state = 96},
  [3225] = {.lex_state = 96},
  [3226] = {.lex_state = 101, .external_lex_state = 21},
  [3227] = {.lex_state = 101, .external_lex_state = 21},
  [3228] = {.lex_state = 101, .external_lex_state = 21},
  [3229] = {.lex_state = 96},
  [3230] = {.lex_state = 101, .external_lex_state = 21},
  [3231] = {.lex_state = 101, .external_lex_state = 21},
  [3232] = {.lex_state = 101, .external_lex_state = 21},
  [3233] = {.lex_state = 101, .external_lex_state = 21},
  [3234] = {.lex_state = 101, .external_lex_state = 21},
  [3235] = {.lex_state = 101, .external_lex_state = 21},
  [3236] = {.lex_state = 96},
  [3237] = {.lex_state = 101, .external_lex_state = 21},
  [3238] = {.lex_state = 96},
  [3239] = {.lex_state = 96},
  [3240] = {.lex_state = 101, .external_lex_state = 21},
  [3241] = {.lex_state = 101, .external_lex_state = 21},
  [3242] = {.lex_state = 101, .external_lex_state = 21},
  [3243] = {.lex_state = 87},
  [3244] = {.lex_state = 101, .external_lex_state = 21},
  [3245] = {.lex_state = 101, .external_lex_state = 21},
  [3246] = {.lex_state = 101, .external_lex_state = 21},
  [3247] = {.lex_state = 96},
  [3248] = {.lex_state = 96},
  [3249] = {.lex_state = 101, .external_lex_state = 21},
  [3250] = {.lex_state = 101, .external_lex_state = 21},
  [3251] = {.lex_state = 101, .external_lex_state = 21},
  [3252] = {.lex_state = 101, .external_lex_state = 21},
  [3253] = {.lex_state = 101, .external_lex_state = 21},
  [3254] = {.lex_state = 101, .external_lex_state = 21},
  [3255] = {.lex_state = 101, .external_lex_state = 21},
  [3256] = {.lex_state = 96},
  [3257] = {.lex_state = 101, .external_lex_state = 21},
  [3258] = {.lex_state = 96},
  [3259] = {.lex_state = 101, .external_lex_state = 21},
  [3260] = {.lex_state = 101, .external_lex_state = 21},
  [3261] = {.lex_state = 96},
  [3262] = {.lex_state = 101, .external_lex_state = 21},
  [3263] = {.lex_state = 101, .external_lex_state = 21},
  [3264] = {.lex_state = 101, .external_lex_state = 21},
  [3265] = {.lex_state = 101, .external_lex_state = 21},
  [3266] = {.lex_state = 96},
  [3267] = {.lex_state = 101, .external_lex_state = 21},
  [3268] = {.lex_state = 96},
  [3269] = {.lex_state = 101, .external_lex_state = 21},
  [3270] = {.lex_state = 96},
  [3271] = {.lex_state = 101, .external_lex_state = 21},
  [3272] = {.lex_state = 101, .external_lex_state = 21},
  [3273] = {.lex_state = 96},
  [3274] = {.lex_state = 101, .external_lex_state = 21},
  [3275] = {.lex_state = 101, .external_lex_state = 21},
  [3276] = {.lex_state = 101, .external_lex_state = 21},
  [3277] = {.lex_state = 96},
  [3278] = {.lex_state = 101, .external_lex_state = 21},
  [3279] = {.lex_state = 101, .external_lex_state = 21},
  [3280] = {.lex_state = 96},
  [3281] = {.lex_state = 101, .external_lex_state = 21},
  [3282] = {.lex_state = 96},
  [3283] = {.lex_state = 96},
  [3284] = {.lex_state = 100},
  [3285] = {.lex_state = 100},
  [3286] = {.lex_state = 100},
  [3287] = {.lex_state = 100},
  [3288] = {.lex_state = 100},
  [3289] = {.lex_state = 100},
  [3290] = {.lex_state = 100},
  [3291] = {.lex_state = 100},
  [3292] = {.lex_state = 100},
  [3293] = {.lex_state = 100},
  [3294] = {.lex_state = 100},
  [3295] = {.lex_state = 100},
  [3296] = {.lex_state = 100},
  [3297] = {.lex_state = 200, .external_lex_state = 22},
  [3298] = {.lex_state = 200, .external_lex_state = 22},
  [3299] = {.lex_state = 100},
  [3300] = {.lex_state = 100},
  [3301] = {.lex_state = 100},
  [3302] = {.lex_state = 100},
  [3303] = {.lex_state = 100},
  [3304] = {.lex_state = 100},
  [3305] = {.lex_state = 100},
  [3306] = {.lex_state = 100},
  [3307] = {.lex_state = 100},
  [3308] = {.lex_state = 100},
  [3309] = {.lex_state = 85},
  [3310] = {.lex_state = 100},
  [3311] = {.lex_state = 100},
  [3312] = {.lex_state = 100},
  [3313] = {.lex_state = 100},
  [3314] = {.lex_state = 100},
  [3315] = {.lex_state = 100},
  [3316] = {.lex_state = 100},
  [3317] = {.lex_state = 100},
  [3318] = {.lex_state = 100},
  [3319] = {.lex_state = 200, .external_lex_state = 22},
  [3320] = {.lex_state = 100},
  [3321] = {.lex_state = 100},
  [3322] = {.lex_state = 200, .external_lex_state = 22},
  [3323] = {.lex_state = 200, .external_lex_state = 22},
  [3324] = {.lex_state = 100},
  [3325] = {.lex_state = 100},
  [3326] = {.lex_state = 100},
  [3327] = {.lex_state = 100},
  [3328] = {.lex_state = 100},
  [3329] = {.lex_state = 100},
  [3330] = {.lex_state = 100},
  [3331] = {.lex_state = 100},
  [3332] = {.lex_state = 100},
  [3333] = {.lex_state = 100},
  [3334] = {.lex_state = 100},
  [3335] = {.lex_state = 100},
  [3336] = {.lex_state = 100},
  [3337] = {.lex_state = 100},
  [3338] = {.lex_state = 100},
  [3339] = {.lex_state = 100},
  [3340] = {.lex_state = 100},
  [3341] = {.lex_state = 100},
  [3342] = {.lex_state = 100},
  [3343] = {.lex_state = 100},
  [3344] = {.lex_state = 100},
  [3345] = {.lex_state = 100},
  [3346] = {.lex_state = 100},
  [3347] = {.lex_state = 200, .external_lex_state = 22},
  [3348] = {.lex_state = 100},
  [3349] = {.lex_state = 200, .external_lex_state = 22},
  [3350] = {.lex_state = 100},
  [3351] = {.lex_state = 101},
  [3352] = {.lex_state = 101},
  [3353] = {.lex_state = 101},
  [3354] = {.lex_state = 101},
  [3355] = {.lex_state = 101},
  [3356] = {.lex_state = 101},
  [3357] = {.lex_state = 101},
  [3358] = {.lex_state = 189, .external_lex_state = 15},
  [3359] = {.lex_state = 101},
  [3360] = {.lex_state = 101},
  [3361] = {.lex_state = 101},
  [3362] = {.lex_state = 101},
  [3363] = {.lex_state = 101},
  [3364] = {.lex_state = 101},
  [3365] = {.lex_state = 101},
  [3366] = {.lex_state = 100, .external_lex_state = 17},
  [3367] = {.lex_state = 189, .external_lex_state = 15},
  [3368] = {.lex_state = 100, .external_lex_state = 17},
  [3369] = {.lex_state = 100, .external_lex_state = 17},
  [3370] = {.lex_state = 100, .external_lex_state = 17},
  [3371] = {.lex_state = 100, .external_lex_state = 17},
  [3372] = {.lex_state = 100, .external_lex_state = 17},
  [3373] = {.lex_state = 100, .external_lex_state = 17},
  [3374] = {.lex_state = 100, .external_lex_state = 17},
  [3375] = {.lex_state = 100, .external_lex_state = 17},
  [3376] = {.lex_state = 100, .external_lex_state = 17},
  [3377] = {.lex_state = 100, .external_lex_state = 17},
  [3378] = {.lex_state = 100, .external_lex_state = 17},
  [3379] = {.lex_state = 100, .external_lex_state = 17},
  [3380] = {.lex_state = 100, .external_lex_state = 17},
  [3381] = {.lex_state = 100, .external_lex_state = 17},
  [3382] = {.lex_state = 100, .external_lex_state = 17},
  [3383] = {.lex_state = 100, .external_lex_state = 17},
  [3384] = {.lex_state = 100, .external_lex_state = 17},
  [3385] = {.lex_state = 100, .external_lex_state = 17},
  [3386] = {.lex_state = 100, .external_lex_state = 17},
  [3387] = {.lex_state = 100, .external_lex_state = 17},
  [3388] = {.lex_state = 100, .external_lex_state = 17},
  [3389] = {.lex_state = 29, .external_lex_state = 10},
  [3390] = {.lex_state = 100, .external_lex_state = 17},
  [3391] = {.lex_state = 29, .external_lex_state = 10},
  [3392] = {.lex_state = 100, .external_lex_state = 17},
  [3393] = {.lex_state = 189, .external_lex_state = 15},
  [3394] = {.lex_state = 100, .external_lex_state = 17},
  [3395] = {.lex_state = 100, .external_lex_state = 17},
  [3396] = {.lex_state = 189, .external_lex_state = 15},
  [3397] = {.lex_state = 189, .external_lex_state = 10},
  [3398] = {.lex_state = 189, .external_lex_state = 15},
  [3399] = {.lex_state = 100, .external_lex_state = 17},
  [3400] = {.lex_state = 189, .external_lex_state = 10},
  [3401] = {.lex_state = 100, .external_lex_state = 17},
  [3402] = {.lex_state = 189, .external_lex_state = 10},
  [3403] = {.lex_state = 189, .external_lex_state = 15},
  [3404] = {.lex_state = 29, .external_lex_state = 10},
  [3405] = {.lex_state = 189, .external_lex_state = 10},
  [3406] = {.lex_state = 29, .external_lex_state = 10},
  [3407] = {.lex_state = 29, .external_lex_state = 10},
  [3408] = {.lex_state = 200, .external_lex_state = 22},
  [3409] = {.lex_state = 200},
  [3410] = {.lex_state = 189, .external_lex_state = 15},
  [3411] = {.lex_state = 189, .external_lex_state = 10},
  [3412] = {.lex_state = 200},
  [3413] = {.lex_state = 189, .external_lex_state = 10},
  [3414] = {.lex_state = 200},
  [3415] = {.lex_state = 189, .external_lex_state = 15},
  [3416] = {.lex_state = 200, .external_lex_state = 22},
  [3417] = {.lex_state = 200, .external_lex_state = 22},
  [3418] = {.lex_state = 189, .external_lex_state = 15},
  [3419] = {.lex_state = 100},
  [3420] = {.lex_state = 200, .external_lex_state = 22},
  [3421] = {.lex_state = 200, .external_lex_state = 22},
  [3422] = {.lex_state = 189, .external_lex_state = 15},
  [3423] = {.lex_state = 200, .external_lex_state = 22},
  [3424] = {.lex_state = 200, .external_lex_state = 22},
  [3425] = {.lex_state = 189, .external_lex_state = 15},
  [3426] = {.lex_state = 189, .external_lex_state = 15},
  [3427] = {.lex_state = 200, .external_lex_state = 22},
  [3428] = {.lex_state = 200, .external_lex_state = 22},
  [3429] = {.lex_state = 200, .external_lex_state = 22},
  [3430] = {.lex_state = 200, .external_lex_state = 22},
  [3431] = {.lex_state = 200, .external_lex_state = 22},
  [3432] = {.lex_state = 200, .external_lex_state = 22},
  [3433] = {.lex_state = 200, .external_lex_state = 22},
  [3434] = {.lex_state = 200, .external_lex_state = 22},
  [3435] = {.lex_state = 200, .external_lex_state = 22},
  [3436] = {.lex_state = 189, .external_lex_state = 15},
  [3437] = {.lex_state = 200, .external_lex_state = 22},
  [3438] = {.lex_state = 200, .external_lex_state = 22},
  [3439] = {.lex_state = 200, .external_lex_state = 22},
  [3440] = {.lex_state = 200, .external_lex_state = 22},
  [3441] = {.lex_state = 200, .external_lex_state = 22},
  [3442] = {.lex_state = 189, .external_lex_state = 15},
  [3443] = {.lex_state = 200, .external_lex_state = 22},
  [3444] = {.lex_state = 200, .external_lex_state = 22},
  [3445] = {.lex_state = 189, .external_lex_state = 15},
  [3446] = {.lex_state = 189, .external_lex_state = 15},
  [3447] = {.lex_state = 200, .external_lex_state = 22},
  [3448] = {.lex_state = 200},
  [3449] = {.lex_state = 189, .external_lex_state = 15},
  [3450] = {.lex_state = 189, .external_lex_state = 10},
  [3451] = {.lex_state = 189, .external_lex_state = 15},
  [3452] = {.lex_state = 189, .external_lex_state = 15},
  [3453] = {.lex_state = 200, .external_lex_state = 22},
  [3454] = {.lex_state = 189, .external_lex_state = 15},
  [3455] = {.lex_state = 189, .external_lex_state = 15},
  [3456] = {.lex_state = 189, .external_lex_state = 15},
  [3457] = {.lex_state = 189, .external_lex_state = 15},
  [3458] = {.lex_state = 189, .external_lex_state = 15},
  [3459] = {.lex_state = 189, .external_lex_state = 15},
  [3460] = {.lex_state = 189, .external_lex_state = 15},
  [3461] = {.lex_state = 189, .external_lex_state = 15},
  [3462] = {.lex_state = 200},
  [3463] = {.lex_state = 200, .external_lex_state = 22},
  [3464] = {.lex_state = 189, .external_lex_state = 15},
  [3465] = {.lex_state = 29, .external_lex_state = 10},
  [3466] = {.lex_state = 189, .external_lex_state = 15},
  [3467] = {.lex_state = 189, .external_lex_state = 15},
  [3468] = {.lex_state = 189, .external_lex_state = 15},
  [3469] = {.lex_state = 189, .external_lex_state = 15},
  [3470] = {.lex_state = 189, .external_lex_state = 15},
  [3471] = {.lex_state = 189, .external_lex_state = 15},
  [3472] = {.lex_state = 189, .external_lex_state = 15},
  [3473] = {.lex_state = 29, .external_lex_state = 10},
  [3474] = {.lex_state = 189, .external_lex_state = 15},
  [3475] = {.lex_state = 189, .external_lex_state = 15},
  [3476] = {.lex_state = 189, .external_lex_state = 10},
  [3477] = {.lex_state = 100},
  [3478] = {.lex_state = 200},
  [3479] = {.lex_state = 189, .external_lex_state = 15},
  [3480] = {.lex_state = 102},
  [3481] = {.lex_state = 102},
  [3482] = {.lex_state = 189, .external_lex_state = 10},
  [3483] = {.lex_state = 102},
  [3484] = {.lex_state = 102},
  [3485] = {.lex_state = 91},
  [3486] = {.lex_state = 189, .external_lex_state = 10},
  [3487] = {.lex_state = 102},
  [3488] = {.lex_state = 102},
  [3489] = {.lex_state = 102},
  [3490] = {.lex_state = 102},
  [3491] = {.lex_state = 102},
  [3492] = {.lex_state = 102},
  [3493] = {.lex_state = 189, .external_lex_state = 10},
  [3494] = {.lex_state = 189, .external_lex_state = 10},
  [3495] = {.lex_state = 189, .external_lex_state = 10},
  [3496] = {.lex_state = 91, .external_lex_state = 17},
  [3497] = {.lex_state = 102},
  [3498] = {.lex_state = 102},
  [3499] = {.lex_state = 102},
  [3500] = {.lex_state = 189, .external_lex_state = 10},
  [3501] = {.lex_state = 189, .external_lex_state = 10},
  [3502] = {.lex_state = 189, .external_lex_state = 10},
  [3503] = {.lex_state = 189, .external_lex_state = 10},
  [3504] = {.lex_state = 102},
  [3505] = {.lex_state = 189, .external_lex_state = 10},
  [3506] = {.lex_state = 102},
  [3507] = {.lex_state = 189, .external_lex_state = 10},
  [3508] = {.lex_state = 189, .external_lex_state = 10},
  [3509] = {.lex_state = 102},
  [3510] = {.lex_state = 91},
  [3511] = {.lex_state = 102},
  [3512] = {.lex_state = 91, .external_lex_state = 17},
  [3513] = {.lex_state = 102},
  [3514] = {.lex_state = 102},
  [3515] = {.lex_state = 200},
  [3516] = {.lex_state = 102},
  [3517] = {.lex_state = 189, .external_lex_state = 10},
  [3518] = {.lex_state = 102},
  [3519] = {.lex_state = 189, .external_lex_state = 10},
  [3520] = {.lex_state = 102},
  [3521] = {.lex_state = 91, .external_lex_state = 17},
  [3522] = {.lex_state = 102},
  [3523] = {.lex_state = 102},
  [3524] = {.lex_state = 189, .external_lex_state = 10},
  [3525] = {.lex_state = 189, .external_lex_state = 10},
  [3526] = {.lex_state = 189, .external_lex_state = 10},
  [3527] = {.lex_state = 92, .external_lex_state = 19},
  [3528] = {.lex_state = 189, .external_lex_state = 10},
  [3529] = {.lex_state = 189, .external_lex_state = 10},
  [3530] = {.lex_state = 102},
  [3531] = {.lex_state = 102},
  [3532] = {.lex_state = 102},
  [3533] = {.lex_state = 102},
  [3534] = {.lex_state = 91, .external_lex_state = 17},
  [3535] = {.lex_state = 102},
  [3536] = {.lex_state = 102},
  [3537] = {.lex_state = 189, .external_lex_state = 10},
  [3538] = {.lex_state = 189, .external_lex_state = 10},
  [3539] = {.lex_state = 102},
  [3540] = {.lex_state = 102},
  [3541] = {.lex_state = 92, .external_lex_state = 19},
  [3542] = {.lex_state = 189, .external_lex_state = 10},
  [3543] = {.lex_state = 92, .external_lex_state = 19},
  [3544] = {.lex_state = 189, .external_lex_state = 10},
  [3545] = {.lex_state = 103, .external_lex_state = 20},
  [3546] = {.lex_state = 102},
  [3547] = {.lex_state = 189, .external_lex_state = 10},
  [3548] = {.lex_state = 189, .external_lex_state = 10},
  [3549] = {.lex_state = 189, .external_lex_state = 10},
  [3550] = {.lex_state = 200},
  [3551] = {.lex_state = 91},
  [3552] = {.lex_state = 102},
  [3553] = {.lex_state = 102},
  [3554] = {.lex_state = 189, .external_lex_state = 10},
  [3555] = {.lex_state = 200},
  [3556] = {.lex_state = 102},
  [3557] = {.lex_state = 189, .external_lex_state = 10},
  [3558] = {.lex_state = 189, .external_lex_state = 10},
  [3559] = {.lex_state = 200},
  [3560] = {.lex_state = 102},
  [3561] = {.lex_state = 102},
  [3562] = {.lex_state = 102},
  [3563] = {.lex_state = 102},
  [3564] = {.lex_state = 102},
  [3565] = {.lex_state = 102},
  [3566] = {.lex_state = 91, .external_lex_state = 17},
  [3567] = {.lex_state = 102},
  [3568] = {.lex_state = 189, .external_lex_state = 10},
  [3569] = {.lex_state = 189, .external_lex_state = 10},
  [3570] = {.lex_state = 102},
  [3571] = {.lex_state = 92, .external_lex_state = 19},
  [3572] = {.lex_state = 102},
  [3573] = {.lex_state = 189, .external_lex_state = 10},
  [3574] = {.lex_state = 200},
  [3575] = {.lex_state = 102},
  [3576] = {.lex_state = 102},
  [3577] = {.lex_state = 200},
  [3578] = {.lex_state = 102},
  [3579] = {.lex_state = 103, .external_lex_state = 13},
  [3580] = {.lex_state = 101, .external_lex_state = 20},
  [3581] = {.lex_state = 101, .external_lex_state = 20},
  [3582] = {.lex_state = 101, .external_lex_state = 20},
  [3583] = {.lex_state = 103, .external_lex_state = 13},
  [3584] = {.lex_state = 103, .external_lex_state = 13},
  [3585] = {.lex_state = 101, .external_lex_state = 20},
  [3586] = {.lex_state = 101, .external_lex_state = 20},
  [3587] = {.lex_state = 103, .external_lex_state = 13},
  [3588] = {.lex_state = 103, .external_lex_state = 13},
  [3589] = {.lex_state = 101, .external_lex_state = 20},
  [3590] = {.lex_state = 103, .external_lex_state = 13},
  [3591] = {.lex_state = 104},
  [3592] = {.lex_state = 101, .external_lex_state = 20},
  [3593] = {.lex_state = 103, .external_lex_state = 13},
  [3594] = {.lex_state = 101, .external_lex_state = 20},
  [3595] = {.lex_state = 101, .external_lex_state = 20},
  [3596] = {.lex_state = 92, .external_lex_state = 19},
  [3597] = {.lex_state = 103, .external_lex_state = 13},
  [3598] = {.lex_state = 101, .external_lex_state = 20},
  [3599] = {.lex_state = 103, .external_lex_state = 13},
  [3600] = {.lex_state = 102},
  [3601] = {.lex_state = 102},
  [3602] = {.lex_state = 103, .external_lex_state = 13},
  [3603] = {.lex_state = 104},
  [3604] = {.lex_state = 101, .external_lex_state = 20},
  [3605] = {.lex_state = 103, .external_lex_state = 13},
  [3606] = {.lex_state = 101, .external_lex_state = 20},
  [3607] = {.lex_state = 101, .external_lex_state = 20},
  [3608] = {.lex_state = 103, .external_lex_state = 13},
  [3609] = {.lex_state = 101, .external_lex_state = 20},
  [3610] = {.lex_state = 101, .external_lex_state = 17},
  [3611] = {.lex_state = 103, .external_lex_state = 13},
  [3612] = {.lex_state = 101, .external_lex_state = 17},
  [3613] = {.lex_state = 101, .external_lex_state = 20},
  [3614] = {.lex_state = 103, .external_lex_state = 13},
  [3615] = {.lex_state = 92, .external_lex_state = 19},
  [3616] = {.lex_state = 92, .external_lex_state = 19},
  [3617] = {.lex_state = 103, .external_lex_state = 13},
  [3618] = {.lex_state = 101, .external_lex_state = 20},
  [3619] = {.lex_state = 101, .external_lex_state = 20},
  [3620] = {.lex_state = 103, .external_lex_state = 13},
  [3621] = {.lex_state = 103, .external_lex_state = 13},
  [3622] = {.lex_state = 101, .external_lex_state = 20},
  [3623] = {.lex_state = 103, .external_lex_state = 13},
  [3624] = {.lex_state = 104},
  [3625] = {.lex_state = 101, .external_lex_state = 20},
  [3626] = {.lex_state = 103, .external_lex_state = 13},
  [3627] = {.lex_state = 102},
  [3628] = {.lex_state = 101, .external_lex_state = 20},
  [3629] = {.lex_state = 101, .external_lex_state = 20},
  [3630] = {.lex_state = 103, .external_lex_state = 13},
  [3631] = {.lex_state = 103, .external_lex_state = 13},
  [3632] = {.lex_state = 103, .external_lex_state = 13},
  [3633] = {.lex_state = 102},
  [3634] = {.lex_state = 101, .external_lex_state = 20},
  [3635] = {.lex_state = 103, .external_lex_state = 13},
  [3636] = {.lex_state = 101, .external_lex_state = 20},
  [3637] = {.lex_state = 101, .external_lex_state = 20},
  [3638] = {.lex_state = 103, .external_lex_state = 13},
  [3639] = {.lex_state = 103, .external_lex_state = 13},
  [3640] = {.lex_state = 101, .external_lex_state = 20},
  [3641] = {.lex_state = 101, .external_lex_state = 17},
  [3642] = {.lex_state = 103, .external_lex_state = 13},
  [3643] = {.lex_state = 101, .external_lex_state = 20},
  [3644] = {.lex_state = 101, .external_lex_state = 20},
  [3645] = {.lex_state = 103, .external_lex_state = 13},
  [3646] = {.lex_state = 101, .external_lex_state = 20},
  [3647] = {.lex_state = 103, .external_lex_state = 13},
  [3648] = {.lex_state = 103, .external_lex_state = 13},
  [3649] = {.lex_state = 101, .external_lex_state = 20},
  [3650] = {.lex_state = 103, .external_lex_state = 13},
  [3651] = {.lex_state = 102},
  [3652] = {.lex_state = 101, .external_lex_state = 20},
  [3653] = {.lex_state = 101, .external_lex_state = 20},
  [3654] = {.lex_state = 101, .external_lex_state = 20},
  [3655] = {.lex_state = 103, .external_lex_state = 13},
  [3656] = {.lex_state = 103, .external_lex_state = 13},
  [3657] = {.lex_state = 103, .external_lex_state = 13},
  [3658] = {.lex_state = 101, .external_lex_state = 20},
  [3659] = {.lex_state = 101, .external_lex_state = 20},
  [3660] = {.lex_state = 102},
  [3661] = {.lex_state = 91},
  [3662] = {.lex_state = 103, .external_lex_state = 13},
  [3663] = {.lex_state = 103, .external_lex_state = 13},
  [3664] = {.lex_state = 101, .external_lex_state = 20},
  [3665] = {.lex_state = 103, .external_lex_state = 13},
  [3666] = {.lex_state = 101, .external_lex_state = 20},
  [3667] = {.lex_state = 101, .external_lex_state = 20},
  [3668] = {.lex_state = 103, .external_lex_state = 13},
  [3669] = {.lex_state = 103, .external_lex_state = 13},
  [3670] = {.lex_state = 101, .external_lex_state = 20},
  [3671] = {.lex_state = 103, .external_lex_state = 13},
  [3672] = {.lex_state = 101, .external_lex_state = 20},
  [3673] = {.lex_state = 101, .external_lex_state = 20},
  [3674] = {.lex_state = 103, .external_lex_state = 13},
  [3675] = {.lex_state = 103, .external_lex_state = 13},
  [3676] = {.lex_state = 102},
  [3677] = {.lex_state = 103, .external_lex_state = 13},
  [3678] = {.lex_state = 101, .external_lex_state = 20},
  [3679] = {.lex_state = 101, .external_lex_state = 20},
  [3680] = {.lex_state = 103, .external_lex_state = 13},
  [3681] = {.lex_state = 103, .external_lex_state = 13},
  [3682] = {.lex_state = 101, .external_lex_state = 20},
  [3683] = {.lex_state = 103, .external_lex_state = 13},
  [3684] = {.lex_state = 101, .external_lex_state = 20},
  [3685] = {.lex_state = 103, .external_lex_state = 13},
  [3686] = {.lex_state = 101, .external_lex_state = 20},
  [3687] = {.lex_state = 101, .external_lex_state = 20},
  [3688] = {.lex_state = 91},
  [3689] = {.lex_state = 103, .external_lex_state = 13},
  [3690] = {.lex_state = 91},
  [3691] = {.lex_state = 103, .external_lex_state = 13},
  [3692] = {.lex_state = 103, .external_lex_state = 13},
  [3693] = {.lex_state = 101, .external_lex_state = 20},
  [3694] = {.lex_state = 103, .external_lex_state = 13},
  [3695] = {.lex_state = 101, .external_lex_state = 20},
  [3696] = {.lex_state = 101, .external_lex_state = 20},
  [3697] = {.lex_state = 103, .external_lex_state = 13},
  [3698] = {.lex_state = 101, .external_lex_state = 20},
  [3699] = {.lex_state = 91},
  [3700] = {.lex_state = 103, .external_lex_state = 13},
  [3701] = {.lex_state = 101, .external_lex_state = 20},
  [3702] = {.lex_state = 101, .external_lex_state = 20},
  [3703] = {.lex_state = 102},
  [3704] = {.lex_state = 101, .external_lex_state = 20},
  [3705] = {.lex_state = 103, .external_lex_state = 13},
  [3706] = {.lex_state = 103, .external_lex_state = 13},
  [3707] = {.lex_state = 103, .external_lex_state = 13},
  [3708] = {.lex_state = 101, .external_lex_state = 20},
  [3709] = {.lex_state = 101, .external_lex_state = 20},
  [3710] = {.lex_state = 101, .external_lex_state = 20},
  [3711] = {.lex_state = 101, .external_lex_state = 20},
  [3712] = {.lex_state = 103, .external_lex_state = 13},
  [3713] = {.lex_state = 103, .external_lex_state = 13},
  [3714] = {.lex_state = 101, .external_lex_state = 20},
  [3715] = {.lex_state = 103, .external_lex_state = 13},
  [3716] = {.lex_state = 101, .external_lex_state = 20},
  [3717] = {.lex_state = 101, .external_lex_state = 20},
  [3718] = {.lex_state = 103, .external_lex_state = 13},
  [3719] = {.lex_state = 91},
  [3720] = {.lex_state = 91},
  [3721] = {.lex_state = 103, .external_lex_state = 13},
  [3722] = {.lex_state = 101, .external_lex_state = 20},
  [3723] = {.lex_state = 101, .external_lex_state = 20},
  [3724] = {.lex_state = 103, .external_lex_state = 13},
  [3725] = {.lex_state = 101, .external_lex_state = 20},
  [3726] = {.lex_state = 103, .external_lex_state = 13},
  [3727] = {.lex_state = 103, .external_lex_state = 13},
  [3728] = {.lex_state = 101, .external_lex_state = 20},
  [3729] = {.lex_state = 101, .external_lex_state = 20},
  [3730] = {.lex_state = 103, .external_lex_state = 13},
  [3731] = {.lex_state = 101, .external_lex_state = 17},
  [3732] = {.lex_state = 101, .external_lex_state = 20},
  [3733] = {.lex_state = 91},
  [3734] = {.lex_state = 91},
  [3735] = {.lex_state = 103, .external_lex_state = 13},
  [3736] = {.lex_state = 103, .external_lex_state = 13},
  [3737] = {.lex_state = 101, .external_lex_state = 20},
  [3738] = {.lex_state = 101, .external_lex_state = 20},
  [3739] = {.lex_state = 103, .external_lex_state = 13},
  [3740] = {.lex_state = 103, .external_lex_state = 13},
  [3741] = {.lex_state = 101, .external_lex_state = 20},
  [3742] = {.lex_state = 103, .external_lex_state = 13},
  [3743] = {.lex_state = 91},
  [3744] = {.lex_state = 200},
  [3745] = {.lex_state = 200},
  [3746] = {.lex_state = 101, .external_lex_state = 20},
  [3747] = {.lex_state = 101, .external_lex_state = 20},
  [3748] = {.lex_state = 101, .external_lex_state = 20},
  [3749] = {.lex_state = 103, .external_lex_state = 13},
  [3750] = {.lex_state = 200},
  [3751] = {.lex_state = 103, .external_lex_state = 13},
  [3752] = {.lex_state = 200},
  [3753] = {.lex_state = 101, .external_lex_state = 20},
  [3754] = {.lex_state = 103, .external_lex_state = 13},
  [3755] = {.lex_state = 200},
  [3756] = {.lex_state = 101, .external_lex_state = 20},
  [3757] = {.lex_state = 101, .external_lex_state = 20},
  [3758] = {.lex_state = 103, .external_lex_state = 13},
  [3759] = {.lex_state = 101, .external_lex_state = 20},
  [3760] = {.lex_state = 103, .external_lex_state = 13},
  [3761] = {.lex_state = 103, .external_lex_state = 13},
  [3762] = {.lex_state = 101, .external_lex_state = 20},
  [3763] = {.lex_state = 103, .external_lex_state = 13},
  [3764] = {.lex_state = 92, .external_lex_state = 19},
  [3765] = {.lex_state = 101, .external_lex_state = 20},
  [3766] = {.lex_state = 103, .external_lex_state = 13},
  [3767] = {.lex_state = 101, .external_lex_state = 20},
  [3768] = {.lex_state = 101, .external_lex_state = 20},
  [3769] = {.lex_state = 102},
  [3770] = {.lex_state = 103, .external_lex_state = 13},
  [3771] = {.lex_state = 103, .external_lex_state = 13},
  [3772] = {.lex_state = 103, .external_lex_state = 13},
  [3773] = {.lex_state = 101, .external_lex_state = 20},
  [3774] = {.lex_state = 101, .external_lex_state = 20},
  [3775] = {.lex_state = 103, .external_lex_state = 13},
  [3776] = {.lex_state = 103, .external_lex_state = 13},
  [3777] = {.lex_state = 101, .external_lex_state = 20},
  [3778] = {.lex_state = 101, .external_lex_state = 20},
  [3779] = {.lex_state = 103, .external_lex_state = 13},
  [3780] = {.lex_state = 101, .external_lex_state = 20},
  [3781] = {.lex_state = 103, .external_lex_state = 13},
  [3782] = {.lex_state = 103, .external_lex_state = 13},
  [3783] = {.lex_state = 101, .external_lex_state = 20},
  [3784] = {.lex_state = 101, .external_lex_state = 20},
  [3785] = {.lex_state = 103, .external_lex_state = 13},
  [3786] = {.lex_state = 101, .external_lex_state = 20},
  [3787] = {.lex_state = 103, .external_lex_state = 13},
  [3788] = {.lex_state = 103, .external_lex_state = 13},
  [3789] = {.lex_state = 101, .external_lex_state = 20},
  [3790] = {.lex_state = 103, .external_lex_state = 13},
  [3791] = {.lex_state = 103, .external_lex_state = 13},
  [3792] = {.lex_state = 101, .external_lex_state = 20},
  [3793] = {.lex_state = 101, .external_lex_state = 20},
  [3794] = {.lex_state = 103, .external_lex_state = 13},
  [3795] = {.lex_state = 101, .external_lex_state = 20},
  [3796] = {.lex_state = 101, .external_lex_state = 20},
  [3797] = {.lex_state = 103, .external_lex_state = 13},
  [3798] = {.lex_state = 103, .external_lex_state = 13},
  [3799] = {.lex_state = 101, .external_lex_state = 20},
  [3800] = {.lex_state = 101, .external_lex_state = 20},
  [3801] = {.lex_state = 103, .external_lex_state = 13},
  [3802] = {.lex_state = 102},
  [3803] = {.lex_state = 102},
  [3804] = {.lex_state = 101, .external_lex_state = 20},
  [3805] = {.lex_state = 102},
  [3806] = {.lex_state = 101, .external_lex_state = 20},
  [3807] = {.lex_state = 102},
  [3808] = {.lex_state = 102},
  [3809] = {.lex_state = 102},
  [3810] = {.lex_state = 101, .external_lex_state = 20},
  [3811] = {.lex_state = 101, .external_lex_state = 20},
  [3812] = {.lex_state = 102},
  [3813] = {.lex_state = 101, .external_lex_state = 20},
  [3814] = {.lex_state = 101, .external_lex_state = 20},
  [3815] = {.lex_state = 102},
  [3816] = {.lex_state = 101, .external_lex_state = 20},
  [3817] = {.lex_state = 102},
  [3818] = {.lex_state = 101, .external_lex_state = 20},
  [3819] = {.lex_state = 102},
  [3820] = {.lex_state = 102},
  [3821] = {.lex_state = 102},
  [3822] = {.lex_state = 102},
  [3823] = {.lex_state = 101, .external_lex_state = 20},
  [3824] = {.lex_state = 101, .external_lex_state = 20},
  [3825] = {.lex_state = 101, .external_lex_state = 20},
  [3826] = {.lex_state = 101, .external_lex_state = 20},
  [3827] = {.lex_state = 102},
  [3828] = {.lex_state = 101, .external_lex_state = 20},
  [3829] = {.lex_state = 102},
  [3830] = {.lex_state = 102},
  [3831] = {.lex_state = 102},
  [3832] = {.lex_state = 102},
  [3833] = {.lex_state = 102},
  [3834] = {.lex_state = 101, .external_lex_state = 20},
  [3835] = {.lex_state = 101, .external_lex_state = 20},
  [3836] = {.lex_state = 102},
  [3837] = {.lex_state = 102},
  [3838] = {.lex_state = 101, .external_lex_state = 20},
  [3839] = {.lex_state = 102},
  [3840] = {.lex_state = 101, .external_lex_state = 20},
  [3841] = {.lex_state = 102},
  [3842] = {.lex_state = 102},
  [3843] = {.lex_state = 102},
  [3844] = {.lex_state = 102},
  [3845] = {.lex_state = 102},
  [3846] = {.lex_state = 102},
  [3847] = {.lex_state = 102},
  [3848] = {.lex_state = 101, .external_lex_state = 20},
  [3849] = {.lex_state = 101, .external_lex_state = 20},
  [3850] = {.lex_state = 102},
  [3851] = {.lex_state = 102},
  [3852] = {.lex_state = 101, .external_lex_state = 20},
  [3853] = {.lex_state = 102},
  [3854] = {.lex_state = 102},
  [3855] = {.lex_state = 101, .external_lex_state = 20},
  [3856] = {.lex_state = 102},
  [3857] = {.lex_state = 102},
  [3858] = {.lex_state = 102},
  [3859] = {.lex_state = 101},
  [3860] = {.lex_state = 91},
  [3861] = {.lex_state = 101, .external_lex_state = 20},
  [3862] = {.lex_state = 102},
  [3863] = {.lex_state = 102},
  [3864] = {.lex_state = 101, .external_lex_state = 20},
  [3865] = {.lex_state = 102},
  [3866] = {.lex_state = 102},
  [3867] = {.lex_state = 101, .external_lex_state = 20},
  [3868] = {.lex_state = 102},
  [3869] = {.lex_state = 102},
  [3870] = {.lex_state = 102},
  [3871] = {.lex_state = 102},
  [3872] = {.lex_state = 102},
  [3873] = {.lex_state = 102},
  [3874] = {.lex_state = 102},
  [3875] = {.lex_state = 102},
  [3876] = {.lex_state = 101},
  [3877] = {.lex_state = 102},
  [3878] = {.lex_state = 102},
  [3879] = {.lex_state = 101, .external_lex_state = 20},
  [3880] = {.lex_state = 200},
  [3881] = {.lex_state = 101},
  [3882] = {.lex_state = 101, .external_lex_state = 20},
  [3883] = {.lex_state = 101},
  [3884] = {.lex_state = 101, .external_lex_state = 20},
  [3885] = {.lex_state = 102},
  [3886] = {.lex_state = 102},
  [3887] = {.lex_state = 102},
  [3888] = {.lex_state = 102},
  [3889] = {.lex_state = 102},
  [3890] = {.lex_state = 102},
  [3891] = {.lex_state = 102},
  [3892] = {.lex_state = 102},
  [3893] = {.lex_state = 102},
  [3894] = {.lex_state = 102},
  [3895] = {.lex_state = 101},
  [3896] = {.lex_state = 102},
  [3897] = {.lex_state = 101, .external_lex_state = 20},
  [3898] = {.lex_state = 102},
  [3899] = {.lex_state = 101, .external_lex_state = 20},
  [3900] = {.lex_state = 200},
  [3901] = {.lex_state = 101, .external_lex_state = 20},
  [3902] = {.lex_state = 102},
  [3903] = {.lex_state = 102},
  [3904] = {.lex_state = 101},
  [3905] = {.lex_state = 102},
  [3906] = {.lex_state = 102},
  [3907] = {.lex_state = 102},
  [3908] = {.lex_state = 101},
  [3909] = {.lex_state = 102},
  [3910] = {.lex_state = 101, .external_lex_state = 20},
  [3911] = {.lex_state = 102},
  [3912] = {.lex_state = 101, .external_lex_state = 20},
  [3913] = {.lex_state = 101},
  [3914] = {.lex_state = 101},
  [3915] = {.lex_state = 102},
  [3916] = {.lex_state = 103, .external_lex_state = 13},
  [3917] = {.lex_state = 102},
  [3918] = {.lex_state = 102},
  [3919] = {.lex_state = 102},
  [3920] = {.lex_state = 102},
  [3921] = {.lex_state = 102},
  [3922] = {.lex_state = 102},
  [3923] = {.lex_state = 101},
  [3924] = {.lex_state = 102},
  [3925] = {.lex_state = 200},
  [3926] = {.lex_state = 102},
  [3927] = {.lex_state = 102},
  [3928] = {.lex_state = 102},
  [3929] = {.lex_state = 102},
  [3930] = {.lex_state = 102},
  [3931] = {.lex_state = 102},
  [3932] = {.lex_state = 102},
  [3933] = {.lex_state = 102},
  [3934] = {.lex_state = 102},
  [3935] = {.lex_state = 101},
  [3936] = {.lex_state = 102},
  [3937] = {.lex_state = 200},
  [3938] = {.lex_state = 90},
  [3939] = {.lex_state = 92, .external_lex_state = 19},
  [3940] = {.lex_state = 102},
  [3941] = {.lex_state = 102},
  [3942] = {.lex_state = 200},
  [3943] = {.lex_state = 200},
  [3944] = {.lex_state = 101},
  [3945] = {.lex_state = 92, .external_lex_state = 19},
  [3946] = {.lex_state = 102},
  [3947] = {.lex_state = 90},
  [3948] = {.lex_state = 102},
  [3949] = {.lex_state = 102},
  [3950] = {.lex_state = 102},
  [3951] = {.lex_state = 200},
  [3952] = {.lex_state = 200},
  [3953] = {.lex_state = 101},
  [3954] = {.lex_state = 90},
  [3955] = {.lex_state = 200},
  [3956] = {.lex_state = 200},
  [3957] = {.lex_state = 200},
  [3958] = {.lex_state = 101, .external_lex_state = 13},
  [3959] = {.lex_state = 200},
  [3960] = {.lex_state = 200},
  [3961] = {.lex_state = 91},
  [3962] = {.lex_state = 200},
  [3963] = {.lex_state = 200},
  [3964] = {.lex_state = 91},
  [3965] = {.lex_state = 101, .external_lex_state = 13},
  [3966] = {.lex_state = 200},
  [3967] = {.lex_state = 200},
  [3968] = {.lex_state = 200},
  [3969] = {.lex_state = 200},
  [3970] = {.lex_state = 200},
  [3971] = {.lex_state = 200, .external_lex_state = 23},
  [3972] = {.lex_state = 200},
  [3973] = {.lex_state = 101, .external_lex_state = 13},
  [3974] = {.lex_state = 95},
  [3975] = {.lex_state = 200},
  [3976] = {.lex_state = 92, .external_lex_state = 11},
  [3977] = {.lex_state = 92, .external_lex_state = 11},
  [3978] = {.lex_state = 91},
  [3979] = {.lex_state = 91},
  [3980] = {.lex_state = 101, .external_lex_state = 13},
  [3981] = {.lex_state = 101, .external_lex_state = 13},
  [3982] = {.lex_state = 200, .external_lex_state = 23},
  [3983] = {.lex_state = 200},
  [3984] = {.lex_state = 91},
  [3985] = {.lex_state = 200},
  [3986] = {.lex_state = 200},
  [3987] = {.lex_state = 200},
  [3988] = {.lex_state = 101, .external_lex_state = 13},
  [3989] = {.lex_state = 91},
  [3990] = {.lex_state = 200},
  [3991] = {.lex_state = 91},
  [3992] = {.lex_state = 200},
  [3993] = {.lex_state = 200},
  [3994] = {.lex_state = 101, .external_lex_state = 13},
  [3995] = {.lex_state = 200},
  [3996] = {.lex_state = 200},
  [3997] = {.lex_state = 91},
  [3998] = {.lex_state = 200},
  [3999] = {.lex_state = 91},
  [4000] = {.lex_state = 101, .external_lex_state = 13},
  [4001] = {.lex_state = 101, .external_lex_state = 13},
  [4002] = {.lex_state = 91},
  [4003] = {.lex_state = 200},
  [4004] = {.lex_state = 200},
  [4005] = {.lex_state = 101, .external_lex_state = 13},
  [4006] = {.lex_state = 91},
  [4007] = {.lex_state = 200},
  [4008] = {.lex_state = 91},
  [4009] = {.lex_state = 101, .external_lex_state = 13},
  [4010] = {.lex_state = 95},
  [4011] = {.lex_state = 101, .external_lex_state = 13},
  [4012] = {.lex_state = 101, .external_lex_state = 13},
  [4013] = {.lex_state = 91},
  [4014] = {.lex_state = 200},
  [4015] = {.lex_state = 101, .external_lex_state = 13},
  [4016] = {.lex_state = 91},
  [4017] = {.lex_state = 101, .external_lex_state = 13},
  [4018] = {.lex_state = 101, .external_lex_state = 13},
  [4019] = {.lex_state = 101, .external_lex_state = 13},
  [4020] = {.lex_state = 91},
  [4021] = {.lex_state = 101, .external_lex_state = 13},
  [4022] = {.lex_state = 200},
  [4023] = {.lex_state = 91},
  [4024] = {.lex_state = 101, .external_lex_state = 13},
  [4025] = {.lex_state = 101, .external_lex_state = 13},
  [4026] = {.lex_state = 101, .external_lex_state = 13},
  [4027] = {.lex_state = 101, .external_lex_state = 13},
  [4028] = {.lex_state = 91},
  [4029] = {.lex_state = 200},
  [4030] = {.lex_state = 91},
  [4031] = {.lex_state = 101, .external_lex_state = 13},
  [4032] = {.lex_state = 200},
  [4033] = {.lex_state = 101, .external_lex_state = 13},
  [4034] = {.lex_state = 91},
  [4035] = {.lex_state = 91},
  [4036] = {.lex_state = 200},
  [4037] = {.lex_state = 91},
  [4038] = {.lex_state = 101, .external_lex_state = 13},
  [4039] = {.lex_state = 101, .external_lex_state = 13},
  [4040] = {.lex_state = 101, .external_lex_state = 13},
  [4041] = {.lex_state = 101, .external_lex_state = 13},
  [4042] = {.lex_state = 91},
  [4043] = {.lex_state = 200},
  [4044] = {.lex_state = 91},
  [4045] = {.lex_state = 101, .external_lex_state = 13},
  [4046] = {.lex_state = 101, .external_lex_state = 13},
  [4047] = {.lex_state = 101, .external_lex_state = 13},
  [4048] = {.lex_state = 101, .external_lex_state = 13},
  [4049] = {.lex_state = 101, .external_lex_state = 13},
  [4050] = {.lex_state = 200},
  [4051] = {.lex_state = 91},
  [4052] = {.lex_state = 101, .external_lex_state = 13},
  [4053] = {.lex_state = 101, .external_lex_state = 13},
  [4054] = {.lex_state = 101, .external_lex_state = 13},
  [4055] = {.lex_state = 101, .external_lex_state = 13},
  [4056] = {.lex_state = 200},
  [4057] = {.lex_state = 91},
  [4058] = {.lex_state = 91},
  [4059] = {.lex_state = 200},
  [4060] = {.lex_state = 91},
  [4061] = {.lex_state = 101, .external_lex_state = 13},
  [4062] = {.lex_state = 101, .external_lex_state = 13},
  [4063] = {.lex_state = 101, .external_lex_state = 13},
  [4064] = {.lex_state = 101, .external_lex_state = 13},
  [4065] = {.lex_state = 91},
  [4066] = {.lex_state = 200},
  [4067] = {.lex_state = 91},
  [4068] = {.lex_state = 91},
  [4069] = {.lex_state = 101, .external_lex_state = 13},
  [4070] = {.lex_state = 101, .external_lex_state = 13},
  [4071] = {.lex_state = 101, .external_lex_state = 13},
  [4072] = {.lex_state = 101, .external_lex_state = 13},
  [4073] = {.lex_state = 91},
  [4074] = {.lex_state = 200},
  [4075] = {.lex_state = 200},
  [4076] = {.lex_state = 91},
  [4077] = {.lex_state = 101, .external_lex_state = 13},
  [4078] = {.lex_state = 101, .external_lex_state = 13},
  [4079] = {.lex_state = 101, .external_lex_state = 13},
  [4080] = {.lex_state = 101, .external_lex_state = 13},
  [4081] = {.lex_state = 91},
  [4082] = {.lex_state = 200},
  [4083] = {.lex_state = 91},
  [4084] = {.lex_state = 91},
  [4085] = {.lex_state = 200},
  [4086] = {.lex_state = 101, .external_lex_state = 13},
  [4087] = {.lex_state = 91},
  [4088] = {.lex_state = 101, .external_lex_state = 13},
  [4089] = {.lex_state = 101, .external_lex_state = 13},
  [4090] = {.lex_state = 91},
  [4091] = {.lex_state = 200},
  [4092] = {.lex_state = 91},
  [4093] = {.lex_state = 101, .external_lex_state = 13},
  [4094] = {.lex_state = 101, .external_lex_state = 13},
  [4095] = {.lex_state = 101, .external_lex_state = 13},
  [4096] = {.lex_state = 101, .external_lex_state = 13},
  [4097] = {.lex_state = 91},
  [4098] = {.lex_state = 200},
  [4099] = {.lex_state = 91},
  [4100] = {.lex_state = 101, .external_lex_state = 13},
  [4101] = {.lex_state = 101, .external_lex_state = 13},
  [4102] = {.lex_state = 200},
  [4103] = {.lex_state = 91},
  [4104] = {.lex_state = 101, .external_lex_state = 13},
  [4105] = {.lex_state = 101, .external_lex_state = 13},
  [4106] = {.lex_state = 91},
  [4107] = {.lex_state = 200},
  [4108] = {.lex_state = 91},
  [4109] = {.lex_state = 200},
  [4110] = {.lex_state = 101, .external_lex_state = 13},
  [4111] = {.lex_state = 101, .external_lex_state = 13},
  [4112] = {.lex_state = 101, .external_lex_state = 13},
  [4113] = {.lex_state = 101, .external_lex_state = 13},
  [4114] = {.lex_state = 91},
  [4115] = {.lex_state = 200},
  [4116] = {.lex_state = 200},
  [4117] = {.lex_state = 91},
  [4118] = {.lex_state = 200},
  [4119] = {.lex_state = 91},
  [4120] = {.lex_state = 200},
  [4121] = {.lex_state = 101, .external_lex_state = 13},
  [4122] = {.lex_state = 101, .external_lex_state = 13},
  [4123] = {.lex_state = 91},
  [4124] = {.lex_state = 101, .external_lex_state = 13},
  [4125] = {.lex_state = 91},
  [4126] = {.lex_state = 200},
  [4127] = {.lex_state = 101, .external_lex_state = 13},
  [4128] = {.lex_state = 91},
  [4129] = {.lex_state = 101, .external_lex_state = 13},
  [4130] = {.lex_state = 101, .external_lex_state = 13},
  [4131] = {.lex_state = 101, .external_lex_state = 13},
  [4132] = {.lex_state = 200},
  [4133] = {.lex_state = 101, .external_lex_state = 13},
  [4134] = {.lex_state = 200},
  [4135] = {.lex_state = 91},
  [4136] = {.lex_state = 200},
  [4137] = {.lex_state = 91},
  [4138] = {.lex_state = 200},
  [4139] = {.lex_state = 200},
  [4140] = {.lex_state = 101, .external_lex_state = 13},
  [4141] = {.lex_state = 101, .external_lex_state = 13},
  [4142] = {.lex_state = 101, .external_lex_state = 13},
  [4143] = {.lex_state = 101, .external_lex_state = 13},
  [4144] = {.lex_state = 200},
  [4145] = {.lex_state = 91},
  [4146] = {.lex_state = 101, .external_lex_state = 13},
  [4147] = {.lex_state = 101, .external_lex_state = 13},
  [4148] = {.lex_state = 101, .external_lex_state = 13},
  [4149] = {.lex_state = 101, .external_lex_state = 13},
  [4150] = {.lex_state = 91},
  [4151] = {.lex_state = 91},
  [4152] = {.lex_state = 200},
  [4153] = {.lex_state = 200},
  [4154] = {.lex_state = 91},
  [4155] = {.lex_state = 91},
  [4156] = {.lex_state = 101, .external_lex_state = 13},
  [4157] = {.lex_state = 101, .external_lex_state = 13},
  [4158] = {.lex_state = 101, .external_lex_state = 13},
  [4159] = {.lex_state = 91},
  [4160] = {.lex_state = 200},
  [4161] = {.lex_state = 90},
  [4162] = {.lex_state = 101, .external_lex_state = 13},
  [4163] = {.lex_state = 91},
  [4164] = {.lex_state = 200},
  [4165] = {.lex_state = 91},
  [4166] = {.lex_state = 92, .external_lex_state = 11},
  [4167] = {.lex_state = 92, .external_lex_state = 11},
  [4168] = {.lex_state = 101, .external_lex_state = 13},
  [4169] = {.lex_state = 200},
  [4170] = {.lex_state = 200},
  [4171] = {.lex_state = 101, .external_lex_state = 13},
  [4172] = {.lex_state = 101, .external_lex_state = 13},
  [4173] = {.lex_state = 200},
  [4174] = {.lex_state = 200},
  [4175] = {.lex_state = 101, .external_lex_state = 13},
  [4176] = {.lex_state = 91},
  [4177] = {.lex_state = 200},
  [4178] = {.lex_state = 91},
  [4179] = {.lex_state = 200, .external_lex_state = 23},
  [4180] = {.lex_state = 101, .external_lex_state = 13},
  [4181] = {.lex_state = 90},
  [4182] = {.lex_state = 91},
  [4183] = {.lex_state = 91},
  [4184] = {.lex_state = 200},
  [4185] = {.lex_state = 91},
  [4186] = {.lex_state = 101, .external_lex_state = 13},
  [4187] = {.lex_state = 101, .external_lex_state = 13},
  [4188] = {.lex_state = 200},
  [4189] = {.lex_state = 200},
  [4190] = {.lex_state = 91},
  [4191] = {.lex_state = 200},
  [4192] = {.lex_state = 101, .external_lex_state = 13},
  [4193] = {.lex_state = 91},
  [4194] = {.lex_state = 200},
  [4195] = {.lex_state = 200},
  [4196] = {.lex_state = 95},
  [4197] = {.lex_state = 90},
  [4198] = {.lex_state = 101, .external_lex_state = 13},
};

enum {
  ts_external_token_heredoc_start = 0,
  ts_external_token__simple_heredoc_body = 1,
  ts_external_token__heredoc_body_beginning = 2,
  ts_external_token__heredoc_body_middle = 3,
  ts_external_token__heredoc_body_end = 4,
  ts_external_token_file_descriptor = 5,
  ts_external_token__empty_value = 6,
  ts_external_token__concat = 7,
  ts_external_token_variable_name = 8,
  ts_external_token_regex = 9,
  ts_external_token_RBRACE = 10,
  ts_external_token_RBRACK = 11,
  ts_external_token_LT_LT = 12,
  ts_external_token_LT_LT_DASH = 13,
  ts_external_token_LF = 14,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_heredoc_start] = sym_heredoc_start,
  [ts_external_token__simple_heredoc_body] = sym__simple_heredoc_body,
  [ts_external_token__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [ts_external_token__heredoc_body_middle] = sym__heredoc_body_middle,
  [ts_external_token__heredoc_body_end] = sym__heredoc_body_end,
  [ts_external_token_file_descriptor] = sym_file_descriptor,
  [ts_external_token__empty_value] = sym__empty_value,
  [ts_external_token__concat] = sym__concat,
  [ts_external_token_variable_name] = sym_variable_name,
  [ts_external_token_regex] = sym_regex,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_LT_LT] = anon_sym_LT_LT,
  [ts_external_token_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [ts_external_token_LF] = anon_sym_LF,
};

static const bool ts_external_scanner_states[24][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_heredoc_start] = true,
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__empty_value] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
  },
  [2] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
  },
  [3] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [4] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
  },
  [5] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [6] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [7] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [8] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [9] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [10] = {
    [ts_external_token_LF] = true,
  },
  [11] = {
    [ts_external_token_RBRACK] = true,
  },
  [12] = {
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
  },
  [13] = {
    [ts_external_token_RBRACE] = true,
  },
  [14] = {
    [ts_external_token_regex] = true,
  },
  [15] = {
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [16] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
  },
  [17] = {
    [ts_external_token__concat] = true,
  },
  [18] = {
    [ts_external_token__empty_value] = true,
  },
  [19] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACK] = true,
  },
  [20] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACE] = true,
  },
  [21] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [22] = {
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
  },
  [23] = {
    [ts_external_token_heredoc_start] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_word] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_done] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_fi] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_esac] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI_SEMI] = ACTIONS(1),
    [anon_sym_SEMI_AMP] = ACTIONS(1),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PIPE_AMP] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_typeset] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_unset] = ACTIONS(1),
    [anon_sym_unsetenv] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_GT] = ACTIONS(1),
    [anon_sym_AMP_GT_GT] = ACTIONS(1),
    [anon_sym_LT_AMP] = ACTIONS(1),
    [anon_sym_GT_AMP] = ACTIONS(1),
    [anon_sym_GT_PIPE] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_LT] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym__special_character] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_raw_string] = ACTIONS(1),
    [sym_ansii_c_string] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON_QMARK] = ACTIONS(1),
    [anon_sym_COLON_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LT_LPAREN] = ACTIONS(1),
    [anon_sym_GT_LPAREN] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [sym_test_operator] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [sym_heredoc_start] = ACTIONS(1),
    [sym__simple_heredoc_body] = ACTIONS(1),
    [sym__heredoc_body_beginning] = ACTIONS(1),
    [sym__heredoc_body_middle] = ACTIONS(1),
    [sym__heredoc_body_end] = ACTIONS(1),
    [sym_file_descriptor] = ACTIONS(1),
    [sym__empty_value] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym_variable_name] = ACTIONS(1),
    [sym_regex] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(4195),
    [sym__statements] = STATE(4194),
    [sym_redirected_statement] = STATE(2094),
    [sym_for_statement] = STATE(2094),
    [sym_c_style_for_statement] = STATE(2094),
    [sym_while_statement] = STATE(2094),
    [sym_if_statement] = STATE(2094),
    [sym_case_statement] = STATE(2094),
    [sym_function_definition] = STATE(2094),
    [sym_compound_statement] = STATE(2094),
    [sym_subshell] = STATE(2094),
    [sym_pipeline] = STATE(2094),
    [sym_list] = STATE(2094),
    [sym_negated_command] = STATE(2094),
    [sym_test_command] = STATE(2094),
    [sym_declaration_command] = STATE(2094),
    [sym_unset_command] = STATE(2094),
    [sym_command] = STATE(2094),
    [sym_command_name] = STATE(221),
    [sym_variable_assignment] = STATE(356),
    [sym_subscript] = STATE(3953),
    [sym_file_redirect] = STATE(894),
    [sym_concatenation] = STATE(870),
    [sym_string] = STATE(489),
    [sym_simple_expansion] = STATE(489),
    [sym_string_expansion] = STATE(489),
    [sym_expansion] = STATE(489),
    [sym_command_substitution] = STATE(489),
    [sym_process_substitution] = STATE(489),
    [aux_sym__statements_repeat1] = STATE(140),
    [aux_sym_command_repeat1] = STATE(894),
    [aux_sym__literal_repeat1] = STATE(763),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansii_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [2] = {
    [aux_sym__statements2] = STATE(20),
    [sym_redirected_statement] = STATE(2145),
    [sym_for_statement] = STATE(2145),
    [sym_c_style_for_statement] = STATE(2145),
    [sym_while_statement] = STATE(2145),
    [sym_if_statement] = STATE(2145),
    [sym_elif_clause] = STATE(3462),
    [sym_else_clause] = STATE(4138),
    [sym_case_statement] = STATE(2145),
    [sym_function_definition] = STATE(2145),
    [sym_compound_statement] = STATE(2145),
    [sym_subshell] = STATE(2145),
    [sym_pipeline] = STATE(2145),
    [sym_list] = STATE(2145),
    [sym_negated_command] = STATE(2145),
    [sym_test_command] = STATE(2145),
    [sym_declaration_command] = STATE(2145),
    [sym_unset_command] = STATE(2145),
    [sym_command] = STATE(2145),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(394),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_if_statement_repeat1] = STATE(3462),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(71),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [3] = {
    [aux_sym__statements2] = STATE(20),
    [sym_redirected_statement] = STATE(2145),
    [sym_for_statement] = STATE(2145),
    [sym_c_style_for_statement] = STATE(2145),
    [sym_while_statement] = STATE(2145),
    [sym_if_statement] = STATE(2145),
    [sym_elif_clause] = STATE(3478),
    [sym_else_clause] = STATE(3970),
    [sym_case_statement] = STATE(2145),
    [sym_function_definition] = STATE(2145),
    [sym_compound_statement] = STATE(2145),
    [sym_subshell] = STATE(2145),
    [sym_pipeline] = STATE(2145),
    [sym_list] = STATE(2145),
    [sym_negated_command] = STATE(2145),
    [sym_test_command] = STATE(2145),
    [sym_declaration_command] = STATE(2145),
    [sym_unset_command] = STATE(2145),
    [sym_command] = STATE(2145),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(394),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_if_statement_repeat1] = STATE(3478),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(113),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [4] = {
    [aux_sym__statements2] = STATE(2),
    [sym_redirected_statement] = STATE(2145),
    [sym_for_statement] = STATE(2145),
    [sym_c_style_for_statement] = STATE(2145),
    [sym_while_statement] = STATE(2145),
    [sym_if_statement] = STATE(2145),
    [sym_elif_clause] = STATE(3412),
    [sym_else_clause] = STATE(4164),
    [sym_case_statement] = STATE(2145),
    [sym_function_definition] = STATE(2145),
    [sym_compound_statement] = STATE(2145),
    [sym_subshell] = STATE(2145),
    [sym_pipeline] = STATE(2145),
    [sym_list] = STATE(2145),
    [sym_negated_command] = STATE(2145),
    [sym_test_command] = STATE(2145),
    [sym_declaration_command] = STATE(2145),
    [sym_unset_command] = STATE(2145),
    [sym_command] = STATE(2145),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(394),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_if_statement_repeat1] = STATE(3412),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(115),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [5] = {
    [aux_sym__statements2] = STATE(6),
    [sym_redirected_statement] = STATE(2145),
    [sym_for_statement] = STATE(2145),
    [sym_c_style_for_statement] = STATE(2145),
    [sym_while_statement] = STATE(2145),
    [sym_if_statement] = STATE(2145),
    [sym_elif_clause] = STATE(3414),
    [sym_else_clause] = STATE(4004),
    [sym_case_statement] = STATE(2145),
    [sym_function_definition] = STATE(2145),
    [sym_compound_statement] = STATE(2145),
    [sym_subshell] = STATE(2145),
    [sym_pipeline] = STATE(2145),
    [sym_list] = STATE(2145),
    [sym_negated_command] = STATE(2145),
    [sym_test_command] = STATE(2145),
    [sym_declaration_command] = STATE(2145),
    [sym_unset_command] = STATE(2145),
    [sym_command] = STATE(2145),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(394),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_if_statement_repeat1] = STATE(3414),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(117),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [6] = {
    [aux_sym__statements2] = STATE(20),
    [sym_redirected_statement] = STATE(2145),
    [sym_for_statement] = STATE(2145),
    [sym_c_style_for_statement] = STATE(2145),
    [sym_while_statement] = STATE(2145),
    [sym_if_statement] = STATE(2145),
    [sym_elif_clause] = STATE(3448),
    [sym_else_clause] = STATE(3983),
    [sym_case_statement] = STATE(2145),
    [sym_function_definition] = STATE(2145),
    [sym_compound_statement] = STATE(2145),
    [sym_subshell] = STATE(2145),
    [sym_pipeline] = STATE(2145),
    [sym_list] = STATE(2145),
    [sym_negated_command] = STATE(2145),
    [sym_test_command] = STATE(2145),
    [sym_declaration_command] = STATE(2145),
    [sym_unset_command] = STATE(2145),
    [sym_command] = STATE(2145),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(394),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_if_statement_repeat1] = STATE(3448),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(119),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [7] = {
    [aux_sym__statements2] = STATE(3),
    [sym_redirected_statement] = STATE(2145),
    [sym_for_statement] = STATE(2145),
    [sym_c_style_for_statement] = STATE(2145),
    [sym_while_statement] = STATE(2145),
    [sym_if_statement] = STATE(2145),
    [sym_elif_clause] = STATE(3409),
    [sym_else_clause] = STATE(3966),
    [sym_case_statement] = STATE(2145),
    [sym_function_definition] = STATE(2145),
    [sym_compound_statement] = STATE(2145),
    [sym_subshell] = STATE(2145),
    [sym_pipeline] = STATE(2145),
    [sym_list] = STATE(2145),
    [sym_negated_command] = STATE(2145),
    [sym_test_command] = STATE(2145),
    [sym_declaration_command] = STATE(2145),
    [sym_unset_command] = STATE(2145),
    [sym_command] = STATE(2145),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(394),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_if_statement_repeat1] = STATE(3409),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(121),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [8] = {
    [sym__statements] = STATE(3555),
    [sym_redirected_statement] = STATE(2057),
    [sym_for_statement] = STATE(2057),
    [sym_c_style_for_statement] = STATE(2057),
    [sym_while_statement] = STATE(2057),
    [sym_if_statement] = STATE(2057),
    [sym_case_statement] = STATE(2057),
    [sym_function_definition] = STATE(2057),
    [sym_compound_statement] = STATE(2057),
    [sym_subshell] = STATE(2057),
    [sym_pipeline] = STATE(2057),
    [sym_list] = STATE(2057),
    [sym_negated_command] = STATE(2057),
    [sym_test_command] = STATE(2057),
    [sym_declaration_command] = STATE(2057),
    [sym_unset_command] = STATE(2057),
    [sym_command] = STATE(2057),
    [sym_command_name] = STATE(175),
    [sym_variable_assignment] = STATE(275),
    [sym_subscript] = STATE(3908),
    [sym_file_redirect] = STATE(825),
    [sym_concatenation] = STATE(411),
    [sym_string] = STATE(285),
    [sym_simple_expansion] = STATE(285),
    [sym_string_expansion] = STATE(285),
    [sym_expansion] = STATE(285),
    [sym_command_substitution] = STATE(285),
    [sym_process_substitution] = STATE(285),
    [aux_sym__statements_repeat1] = STATE(142),
    [aux_sym_command_repeat1] = STATE(825),
    [aux_sym__literal_repeat1] = STATE(388),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(137),
    [anon_sym_SEMI_SEMI] = ACTIONS(139),
    [anon_sym_SEMI_AMP] = ACTIONS(141),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(141),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [9] = {
    [sym__statements] = STATE(3559),
    [sym_redirected_statement] = STATE(2057),
    [sym_for_statement] = STATE(2057),
    [sym_c_style_for_statement] = STATE(2057),
    [sym_while_statement] = STATE(2057),
    [sym_if_statement] = STATE(2057),
    [sym_case_statement] = STATE(2057),
    [sym_function_definition] = STATE(2057),
    [sym_compound_statement] = STATE(2057),
    [sym_subshell] = STATE(2057),
    [sym_pipeline] = STATE(2057),
    [sym_list] = STATE(2057),
    [sym_negated_command] = STATE(2057),
    [sym_test_command] = STATE(2057),
    [sym_declaration_command] = STATE(2057),
    [sym_unset_command] = STATE(2057),
    [sym_command] = STATE(2057),
    [sym_command_name] = STATE(175),
    [sym_variable_assignment] = STATE(275),
    [sym_subscript] = STATE(3908),
    [sym_file_redirect] = STATE(825),
    [sym_concatenation] = STATE(411),
    [sym_string] = STATE(285),
    [sym_simple_expansion] = STATE(285),
    [sym_string_expansion] = STATE(285),
    [sym_expansion] = STATE(285),
    [sym_command_substitution] = STATE(285),
    [sym_process_substitution] = STATE(285),
    [aux_sym__statements_repeat1] = STATE(142),
    [aux_sym_command_repeat1] = STATE(825),
    [aux_sym__literal_repeat1] = STATE(388),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(177),
    [anon_sym_SEMI_SEMI] = ACTIONS(179),
    [anon_sym_SEMI_AMP] = ACTIONS(181),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(181),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [10] = {
    [sym__statements] = STATE(3577),
    [sym_redirected_statement] = STATE(2057),
    [sym_for_statement] = STATE(2057),
    [sym_c_style_for_statement] = STATE(2057),
    [sym_while_statement] = STATE(2057),
    [sym_if_statement] = STATE(2057),
    [sym_case_statement] = STATE(2057),
    [sym_function_definition] = STATE(2057),
    [sym_compound_statement] = STATE(2057),
    [sym_subshell] = STATE(2057),
    [sym_pipeline] = STATE(2057),
    [sym_list] = STATE(2057),
    [sym_negated_command] = STATE(2057),
    [sym_test_command] = STATE(2057),
    [sym_declaration_command] = STATE(2057),
    [sym_unset_command] = STATE(2057),
    [sym_command] = STATE(2057),
    [sym_command_name] = STATE(175),
    [sym_variable_assignment] = STATE(275),
    [sym_subscript] = STATE(3908),
    [sym_file_redirect] = STATE(825),
    [sym_concatenation] = STATE(411),
    [sym_string] = STATE(285),
    [sym_simple_expansion] = STATE(285),
    [sym_string_expansion] = STATE(285),
    [sym_expansion] = STATE(285),
    [sym_command_substitution] = STATE(285),
    [sym_process_substitution] = STATE(285),
    [aux_sym__statements_repeat1] = STATE(142),
    [aux_sym_command_repeat1] = STATE(825),
    [aux_sym__literal_repeat1] = STATE(388),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(183),
    [anon_sym_SEMI_SEMI] = ACTIONS(185),
    [anon_sym_SEMI_AMP] = ACTIONS(187),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(189),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [11] = {
    [sym__statements] = STATE(3574),
    [sym_redirected_statement] = STATE(2057),
    [sym_for_statement] = STATE(2057),
    [sym_c_style_for_statement] = STATE(2057),
    [sym_while_statement] = STATE(2057),
    [sym_if_statement] = STATE(2057),
    [sym_case_statement] = STATE(2057),
    [sym_function_definition] = STATE(2057),
    [sym_compound_statement] = STATE(2057),
    [sym_subshell] = STATE(2057),
    [sym_pipeline] = STATE(2057),
    [sym_list] = STATE(2057),
    [sym_negated_command] = STATE(2057),
    [sym_test_command] = STATE(2057),
    [sym_declaration_command] = STATE(2057),
    [sym_unset_command] = STATE(2057),
    [sym_command] = STATE(2057),
    [sym_command_name] = STATE(175),
    [sym_variable_assignment] = STATE(275),
    [sym_subscript] = STATE(3908),
    [sym_file_redirect] = STATE(825),
    [sym_concatenation] = STATE(411),
    [sym_string] = STATE(285),
    [sym_simple_expansion] = STATE(285),
    [sym_string_expansion] = STATE(285),
    [sym_expansion] = STATE(285),
    [sym_command_substitution] = STATE(285),
    [sym_process_substitution] = STATE(285),
    [aux_sym__statements_repeat1] = STATE(142),
    [aux_sym_command_repeat1] = STATE(825),
    [aux_sym__literal_repeat1] = STATE(388),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(183),
    [anon_sym_SEMI_SEMI] = ACTIONS(191),
    [anon_sym_SEMI_AMP] = ACTIONS(193),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(195),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [12] = {
    [sym__statements] = STATE(3550),
    [sym_redirected_statement] = STATE(2057),
    [sym_for_statement] = STATE(2057),
    [sym_c_style_for_statement] = STATE(2057),
    [sym_while_statement] = STATE(2057),
    [sym_if_statement] = STATE(2057),
    [sym_case_statement] = STATE(2057),
    [sym_function_definition] = STATE(2057),
    [sym_compound_statement] = STATE(2057),
    [sym_subshell] = STATE(2057),
    [sym_pipeline] = STATE(2057),
    [sym_list] = STATE(2057),
    [sym_negated_command] = STATE(2057),
    [sym_test_command] = STATE(2057),
    [sym_declaration_command] = STATE(2057),
    [sym_unset_command] = STATE(2057),
    [sym_command] = STATE(2057),
    [sym_command_name] = STATE(175),
    [sym_variable_assignment] = STATE(275),
    [sym_subscript] = STATE(3908),
    [sym_file_redirect] = STATE(825),
    [sym_concatenation] = STATE(411),
    [sym_string] = STATE(285),
    [sym_simple_expansion] = STATE(285),
    [sym_string_expansion] = STATE(285),
    [sym_expansion] = STATE(285),
    [sym_command_substitution] = STATE(285),
    [sym_process_substitution] = STATE(285),
    [aux_sym__statements_repeat1] = STATE(142),
    [aux_sym_command_repeat1] = STATE(825),
    [aux_sym__literal_repeat1] = STATE(388),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(197),
    [anon_sym_SEMI_SEMI] = ACTIONS(199),
    [anon_sym_SEMI_AMP] = ACTIONS(201),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [13] = {
    [sym__statements] = STATE(3752),
    [sym_redirected_statement] = STATE(2063),
    [sym_for_statement] = STATE(2063),
    [sym_c_style_for_statement] = STATE(2063),
    [sym_while_statement] = STATE(2063),
    [sym_if_statement] = STATE(2063),
    [sym_case_statement] = STATE(2063),
    [sym_function_definition] = STATE(2063),
    [sym_compound_statement] = STATE(2063),
    [sym_subshell] = STATE(2063),
    [sym_pipeline] = STATE(2063),
    [sym_list] = STATE(2063),
    [sym_negated_command] = STATE(2063),
    [sym_test_command] = STATE(2063),
    [sym_declaration_command] = STATE(2063),
    [sym_unset_command] = STATE(2063),
    [sym_command] = STATE(2063),
    [sym_command_name] = STATE(207),
    [sym_variable_assignment] = STATE(281),
    [sym_subscript] = STATE(3876),
    [sym_file_redirect] = STATE(966),
    [sym_concatenation] = STATE(808),
    [sym_string] = STATE(348),
    [sym_simple_expansion] = STATE(348),
    [sym_string_expansion] = STATE(348),
    [sym_expansion] = STATE(348),
    [sym_command_substitution] = STATE(348),
    [sym_process_substitution] = STATE(348),
    [aux_sym__statements_repeat1] = STATE(144),
    [aux_sym_command_repeat1] = STATE(966),
    [aux_sym__literal_repeat1] = STATE(492),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(207),
    [anon_sym_SEMI_AMP] = ACTIONS(193),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(195),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [14] = {
    [sym__statements] = STATE(3755),
    [sym_redirected_statement] = STATE(2063),
    [sym_for_statement] = STATE(2063),
    [sym_c_style_for_statement] = STATE(2063),
    [sym_while_statement] = STATE(2063),
    [sym_if_statement] = STATE(2063),
    [sym_case_statement] = STATE(2063),
    [sym_function_definition] = STATE(2063),
    [sym_compound_statement] = STATE(2063),
    [sym_subshell] = STATE(2063),
    [sym_pipeline] = STATE(2063),
    [sym_list] = STATE(2063),
    [sym_negated_command] = STATE(2063),
    [sym_test_command] = STATE(2063),
    [sym_declaration_command] = STATE(2063),
    [sym_unset_command] = STATE(2063),
    [sym_command] = STATE(2063),
    [sym_command_name] = STATE(207),
    [sym_variable_assignment] = STATE(281),
    [sym_subscript] = STATE(3876),
    [sym_file_redirect] = STATE(966),
    [sym_concatenation] = STATE(808),
    [sym_string] = STATE(348),
    [sym_simple_expansion] = STATE(348),
    [sym_string_expansion] = STATE(348),
    [sym_expansion] = STATE(348),
    [sym_command_substitution] = STATE(348),
    [sym_process_substitution] = STATE(348),
    [aux_sym__statements_repeat1] = STATE(144),
    [aux_sym_command_repeat1] = STATE(966),
    [aux_sym__literal_repeat1] = STATE(492),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(233),
    [anon_sym_SEMI_AMP] = ACTIONS(201),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [15] = {
    [sym__statements] = STATE(3750),
    [sym_redirected_statement] = STATE(2063),
    [sym_for_statement] = STATE(2063),
    [sym_c_style_for_statement] = STATE(2063),
    [sym_while_statement] = STATE(2063),
    [sym_if_statement] = STATE(2063),
    [sym_case_statement] = STATE(2063),
    [sym_function_definition] = STATE(2063),
    [sym_compound_statement] = STATE(2063),
    [sym_subshell] = STATE(2063),
    [sym_pipeline] = STATE(2063),
    [sym_list] = STATE(2063),
    [sym_negated_command] = STATE(2063),
    [sym_test_command] = STATE(2063),
    [sym_declaration_command] = STATE(2063),
    [sym_unset_command] = STATE(2063),
    [sym_command] = STATE(2063),
    [sym_command_name] = STATE(207),
    [sym_variable_assignment] = STATE(281),
    [sym_subscript] = STATE(3876),
    [sym_file_redirect] = STATE(966),
    [sym_concatenation] = STATE(808),
    [sym_string] = STATE(348),
    [sym_simple_expansion] = STATE(348),
    [sym_string_expansion] = STATE(348),
    [sym_expansion] = STATE(348),
    [sym_command_substitution] = STATE(348),
    [sym_process_substitution] = STATE(348),
    [aux_sym__statements_repeat1] = STATE(144),
    [aux_sym_command_repeat1] = STATE(966),
    [aux_sym__literal_repeat1] = STATE(492),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(235),
    [anon_sym_SEMI_AMP] = ACTIONS(187),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(189),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [16] = {
    [sym__statements] = STATE(3745),
    [sym_redirected_statement] = STATE(2063),
    [sym_for_statement] = STATE(2063),
    [sym_c_style_for_statement] = STATE(2063),
    [sym_while_statement] = STATE(2063),
    [sym_if_statement] = STATE(2063),
    [sym_case_statement] = STATE(2063),
    [sym_function_definition] = STATE(2063),
    [sym_compound_statement] = STATE(2063),
    [sym_subshell] = STATE(2063),
    [sym_pipeline] = STATE(2063),
    [sym_list] = STATE(2063),
    [sym_negated_command] = STATE(2063),
    [sym_test_command] = STATE(2063),
    [sym_declaration_command] = STATE(2063),
    [sym_unset_command] = STATE(2063),
    [sym_command] = STATE(2063),
    [sym_command_name] = STATE(207),
    [sym_variable_assignment] = STATE(281),
    [sym_subscript] = STATE(3876),
    [sym_file_redirect] = STATE(966),
    [sym_concatenation] = STATE(808),
    [sym_string] = STATE(348),
    [sym_simple_expansion] = STATE(348),
    [sym_string_expansion] = STATE(348),
    [sym_expansion] = STATE(348),
    [sym_command_substitution] = STATE(348),
    [sym_process_substitution] = STATE(348),
    [aux_sym__statements_repeat1] = STATE(144),
    [aux_sym_command_repeat1] = STATE(966),
    [aux_sym__literal_repeat1] = STATE(492),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(237),
    [anon_sym_SEMI_AMP] = ACTIONS(181),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(181),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [17] = {
    [sym__statements] = STATE(3744),
    [sym_redirected_statement] = STATE(2063),
    [sym_for_statement] = STATE(2063),
    [sym_c_style_for_statement] = STATE(2063),
    [sym_while_statement] = STATE(2063),
    [sym_if_statement] = STATE(2063),
    [sym_case_statement] = STATE(2063),
    [sym_function_definition] = STATE(2063),
    [sym_compound_statement] = STATE(2063),
    [sym_subshell] = STATE(2063),
    [sym_pipeline] = STATE(2063),
    [sym_list] = STATE(2063),
    [sym_negated_command] = STATE(2063),
    [sym_test_command] = STATE(2063),
    [sym_declaration_command] = STATE(2063),
    [sym_unset_command] = STATE(2063),
    [sym_command] = STATE(2063),
    [sym_command_name] = STATE(207),
    [sym_variable_assignment] = STATE(281),
    [sym_subscript] = STATE(3876),
    [sym_file_redirect] = STATE(966),
    [sym_concatenation] = STATE(808),
    [sym_string] = STATE(348),
    [sym_simple_expansion] = STATE(348),
    [sym_string_expansion] = STATE(348),
    [sym_expansion] = STATE(348),
    [sym_command_substitution] = STATE(348),
    [sym_process_substitution] = STATE(348),
    [aux_sym__statements_repeat1] = STATE(144),
    [aux_sym_command_repeat1] = STATE(966),
    [aux_sym__literal_repeat1] = STATE(492),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(239),
    [anon_sym_SEMI_AMP] = ACTIONS(141),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(141),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [18] = {
    [aux_sym__statements2] = STATE(19),
    [sym_redirected_statement] = STATE(2145),
    [sym_for_statement] = STATE(2145),
    [sym_c_style_for_statement] = STATE(2145),
    [sym_while_statement] = STATE(2145),
    [sym_if_statement] = STATE(2145),
    [sym_case_statement] = STATE(2145),
    [sym_function_definition] = STATE(2145),
    [sym_compound_statement] = STATE(2145),
    [sym_subshell] = STATE(2145),
    [sym_pipeline] = STATE(2145),
    [sym_list] = STATE(2145),
    [sym_negated_command] = STATE(2145),
    [sym_test_command] = STATE(2145),
    [sym_declaration_command] = STATE(2145),
    [sym_unset_command] = STATE(2145),
    [sym_command] = STATE(2145),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(394),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(241),
    [anon_sym_elif] = ACTIONS(241),
    [anon_sym_else] = ACTIONS(241),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [19] = {
    [aux_sym__statements2] = STATE(20),
    [sym_redirected_statement] = STATE(2145),
    [sym_for_statement] = STATE(2145),
    [sym_c_style_for_statement] = STATE(2145),
    [sym_while_statement] = STATE(2145),
    [sym_if_statement] = STATE(2145),
    [sym_case_statement] = STATE(2145),
    [sym_function_definition] = STATE(2145),
    [sym_compound_statement] = STATE(2145),
    [sym_subshell] = STATE(2145),
    [sym_pipeline] = STATE(2145),
    [sym_list] = STATE(2145),
    [sym_negated_command] = STATE(2145),
    [sym_test_command] = STATE(2145),
    [sym_declaration_command] = STATE(2145),
    [sym_unset_command] = STATE(2145),
    [sym_command] = STATE(2145),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(394),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(243),
    [anon_sym_elif] = ACTIONS(243),
    [anon_sym_else] = ACTIONS(243),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [20] = {
    [aux_sym__statements2] = STATE(20),
    [sym_redirected_statement] = STATE(2145),
    [sym_for_statement] = STATE(2145),
    [sym_c_style_for_statement] = STATE(2145),
    [sym_while_statement] = STATE(2145),
    [sym_if_statement] = STATE(2145),
    [sym_case_statement] = STATE(2145),
    [sym_function_definition] = STATE(2145),
    [sym_compound_statement] = STATE(2145),
    [sym_subshell] = STATE(2145),
    [sym_pipeline] = STATE(2145),
    [sym_list] = STATE(2145),
    [sym_negated_command] = STATE(2145),
    [sym_test_command] = STATE(2145),
    [sym_declaration_command] = STATE(2145),
    [sym_unset_command] = STATE(2145),
    [sym_command] = STATE(2145),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(394),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(248),
    [anon_sym_select] = ACTIONS(251),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(254),
    [anon_sym_while] = ACTIONS(257),
    [anon_sym_until] = ACTIONS(257),
    [anon_sym_if] = ACTIONS(260),
    [anon_sym_fi] = ACTIONS(263),
    [anon_sym_elif] = ACTIONS(263),
    [anon_sym_else] = ACTIONS(263),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_LBRACE] = ACTIONS(274),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(280),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(283),
    [anon_sym_declare] = ACTIONS(286),
    [anon_sym_typeset] = ACTIONS(286),
    [anon_sym_export] = ACTIONS(286),
    [anon_sym_readonly] = ACTIONS(286),
    [anon_sym_local] = ACTIONS(286),
    [anon_sym_unset] = ACTIONS(289),
    [anon_sym_unsetenv] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(292),
    [anon_sym_GT] = ACTIONS(292),
    [anon_sym_GT_GT] = ACTIONS(292),
    [anon_sym_AMP_GT] = ACTIONS(292),
    [anon_sym_AMP_GT_GT] = ACTIONS(292),
    [anon_sym_LT_AMP] = ACTIONS(292),
    [anon_sym_GT_AMP] = ACTIONS(292),
    [anon_sym_GT_PIPE] = ACTIONS(292),
    [anon_sym_DOLLAR] = ACTIONS(295),
    [sym__special_character] = ACTIONS(298),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [sym_raw_string] = ACTIONS(304),
    [sym_ansii_c_string] = ACTIONS(304),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(307),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(310),
    [anon_sym_BQUOTE] = ACTIONS(313),
    [anon_sym_LT_LPAREN] = ACTIONS(316),
    [anon_sym_GT_LPAREN] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(319),
    [sym_variable_name] = ACTIONS(322),
  },
  [21] = {
    [sym__statements] = STATE(4190),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_RPAREN] = ACTIONS(325),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [22] = {
    [sym__statements] = STATE(3964),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_RPAREN] = ACTIONS(327),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [23] = {
    [sym__statements] = STATE(3991),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [24] = {
    [aux_sym__statements2] = STATE(72),
    [sym_redirected_statement] = STATE(2158),
    [sym_for_statement] = STATE(2158),
    [sym_c_style_for_statement] = STATE(2158),
    [sym_while_statement] = STATE(2158),
    [sym_if_statement] = STATE(2158),
    [sym_case_statement] = STATE(2158),
    [sym_function_definition] = STATE(2158),
    [sym_compound_statement] = STATE(2158),
    [sym_subshell] = STATE(2158),
    [sym_pipeline] = STATE(2158),
    [sym_list] = STATE(2158),
    [sym_negated_command] = STATE(2158),
    [sym_test_command] = STATE(2158),
    [sym_declaration_command] = STATE(2158),
    [sym_unset_command] = STATE(2158),
    [sym_command] = STATE(2158),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(410),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [25] = {
    [sym__statements] = STATE(4014),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [26] = {
    [sym__statements] = STATE(4178),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [27] = {
    [sym__statements] = STATE(4076),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [28] = {
    [sym__statements] = STATE(4185),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2502),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [29] = {
    [sym__statements] = STATE(4184),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [30] = {
    [sym__statements] = STATE(4183),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [31] = {
    [sym__statements] = STATE(4193),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2393),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [32] = {
    [sym__statements] = STATE(4075),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [33] = {
    [sym__statements] = STATE(4091),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [34] = {
    [sym__statements] = STATE(4073),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2463),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [35] = {
    [sym__statements] = STATE(4154),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2495),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [36] = {
    [sym__statements] = STATE(4152),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [37] = {
    [sym__statements] = STATE(4177),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [38] = {
    [sym__statements] = STATE(4176),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2506),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [39] = {
    [sym__statements] = STATE(3984),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [40] = {
    [sym__statements] = STATE(4151),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [41] = {
    [sym__statements] = STATE(4163),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [42] = {
    [aux_sym__statements2] = STATE(87),
    [sym_redirected_statement] = STATE(2156),
    [sym_for_statement] = STATE(2156),
    [sym_c_style_for_statement] = STATE(2156),
    [sym_while_statement] = STATE(2156),
    [sym_if_statement] = STATE(2156),
    [sym_case_statement] = STATE(2156),
    [sym_function_definition] = STATE(2156),
    [sym_compound_statement] = STATE(2156),
    [sym_subshell] = STATE(2156),
    [sym_pipeline] = STATE(2156),
    [sym_list] = STATE(2156),
    [sym_negated_command] = STATE(2156),
    [sym_test_command] = STATE(2156),
    [sym_declaration_command] = STATE(2156),
    [sym_unset_command] = STATE(2156),
    [sym_command] = STATE(2156),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(423),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(339),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [43] = {
    [sym__statements] = STATE(4067),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [44] = {
    [sym__statements] = STATE(4119),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2364),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [45] = {
    [sym__statements] = STATE(4160),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [46] = {
    [sym__statements] = STATE(4118),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [47] = {
    [sym__statements] = STATE(4159),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2513),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [48] = {
    [sym__statements] = STATE(4066),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [49] = {
    [sym__statements] = STATE(4065),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2431),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [50] = {
    [sym__statements] = STATE(4060),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [51] = {
    [sym__statements] = STATE(4155),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [52] = {
    [sym__statements] = STATE(3986),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [53] = {
    [sym__statements] = STATE(4153),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [54] = {
    [sym__statements] = STATE(4150),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2497),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [55] = {
    [sym__statements] = STATE(4145),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [56] = {
    [sym__statements] = STATE(4117),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [57] = {
    [sym__statements] = STATE(4087),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2474),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [58] = {
    [sym__statements] = STATE(4085),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [59] = {
    [sym__statements] = STATE(4084),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [60] = {
    [sym__statements] = STATE(4144),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [61] = {
    [sym__statements] = STATE(4165),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2449),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [62] = {
    [aux_sym__statements2] = STATE(74),
    [sym_redirected_statement] = STATE(2153),
    [sym_for_statement] = STATE(2153),
    [sym_c_style_for_statement] = STATE(2153),
    [sym_while_statement] = STATE(2153),
    [sym_if_statement] = STATE(2153),
    [sym_case_statement] = STATE(2153),
    [sym_function_definition] = STATE(2153),
    [sym_compound_statement] = STATE(2153),
    [sym_subshell] = STATE(2153),
    [sym_pipeline] = STATE(2153),
    [sym_list] = STATE(2153),
    [sym_negated_command] = STATE(2153),
    [sym_test_command] = STATE(2153),
    [sym_declaration_command] = STATE(2153),
    [sym_unset_command] = STATE(2153),
    [sym_command] = STATE(2153),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(406),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(341),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [63] = {
    [aux_sym__statements2] = STATE(71),
    [sym_redirected_statement] = STATE(2153),
    [sym_for_statement] = STATE(2153),
    [sym_c_style_for_statement] = STATE(2153),
    [sym_while_statement] = STATE(2153),
    [sym_if_statement] = STATE(2153),
    [sym_case_statement] = STATE(2153),
    [sym_function_definition] = STATE(2153),
    [sym_compound_statement] = STATE(2153),
    [sym_subshell] = STATE(2153),
    [sym_pipeline] = STATE(2153),
    [sym_list] = STATE(2153),
    [sym_negated_command] = STATE(2153),
    [sym_test_command] = STATE(2153),
    [sym_declaration_command] = STATE(2153),
    [sym_unset_command] = STATE(2153),
    [sym_command] = STATE(2153),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(406),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(343),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [64] = {
    [sym__statements] = STATE(3989),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2455),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [65] = {
    [sym__statements] = STATE(3991),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [66] = {
    [sym__statements] = STATE(4097),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2476),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [67] = {
    [sym__statements] = STATE(4137),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [68] = {
    [sym__statements] = STATE(4136),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [69] = {
    [sym__statements] = STATE(4057),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2366),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [70] = {
    [sym__statements] = STATE(4006),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2346),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [71] = {
    [aux_sym__statements2] = STATE(74),
    [sym_redirected_statement] = STATE(2153),
    [sym_for_statement] = STATE(2153),
    [sym_c_style_for_statement] = STATE(2153),
    [sym_while_statement] = STATE(2153),
    [sym_if_statement] = STATE(2153),
    [sym_case_statement] = STATE(2153),
    [sym_function_definition] = STATE(2153),
    [sym_compound_statement] = STATE(2153),
    [sym_subshell] = STATE(2153),
    [sym_pipeline] = STATE(2153),
    [sym_list] = STATE(2153),
    [sym_negated_command] = STATE(2153),
    [sym_test_command] = STATE(2153),
    [sym_declaration_command] = STATE(2153),
    [sym_unset_command] = STATE(2153),
    [sym_command] = STATE(2153),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(406),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [72] = {
    [aux_sym__statements2] = STATE(72),
    [sym_redirected_statement] = STATE(2158),
    [sym_for_statement] = STATE(2158),
    [sym_c_style_for_statement] = STATE(2158),
    [sym_while_statement] = STATE(2158),
    [sym_if_statement] = STATE(2158),
    [sym_case_statement] = STATE(2158),
    [sym_function_definition] = STATE(2158),
    [sym_compound_statement] = STATE(2158),
    [sym_subshell] = STATE(2158),
    [sym_pipeline] = STATE(2158),
    [sym_list] = STATE(2158),
    [sym_negated_command] = STATE(2158),
    [sym_test_command] = STATE(2158),
    [sym_declaration_command] = STATE(2158),
    [sym_unset_command] = STATE(2158),
    [sym_command] = STATE(2158),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(410),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(248),
    [anon_sym_select] = ACTIONS(251),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(254),
    [anon_sym_while] = ACTIONS(257),
    [anon_sym_until] = ACTIONS(257),
    [anon_sym_done] = ACTIONS(263),
    [anon_sym_if] = ACTIONS(260),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_LBRACE] = ACTIONS(274),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(280),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(283),
    [anon_sym_declare] = ACTIONS(286),
    [anon_sym_typeset] = ACTIONS(286),
    [anon_sym_export] = ACTIONS(286),
    [anon_sym_readonly] = ACTIONS(286),
    [anon_sym_local] = ACTIONS(286),
    [anon_sym_unset] = ACTIONS(289),
    [anon_sym_unsetenv] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(292),
    [anon_sym_GT] = ACTIONS(292),
    [anon_sym_GT_GT] = ACTIONS(292),
    [anon_sym_AMP_GT] = ACTIONS(292),
    [anon_sym_AMP_GT_GT] = ACTIONS(292),
    [anon_sym_LT_AMP] = ACTIONS(292),
    [anon_sym_GT_AMP] = ACTIONS(292),
    [anon_sym_GT_PIPE] = ACTIONS(292),
    [anon_sym_DOLLAR] = ACTIONS(295),
    [sym__special_character] = ACTIONS(298),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [sym_raw_string] = ACTIONS(304),
    [sym_ansii_c_string] = ACTIONS(304),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(307),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(310),
    [anon_sym_BQUOTE] = ACTIONS(313),
    [anon_sym_LT_LPAREN] = ACTIONS(316),
    [anon_sym_GT_LPAREN] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(319),
    [sym_variable_name] = ACTIONS(322),
  },
  [73] = {
    [sym__statements] = STATE(4135),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2422),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [74] = {
    [aux_sym__statements2] = STATE(74),
    [sym_redirected_statement] = STATE(2153),
    [sym_for_statement] = STATE(2153),
    [sym_c_style_for_statement] = STATE(2153),
    [sym_while_statement] = STATE(2153),
    [sym_if_statement] = STATE(2153),
    [sym_case_statement] = STATE(2153),
    [sym_function_definition] = STATE(2153),
    [sym_compound_statement] = STATE(2153),
    [sym_subshell] = STATE(2153),
    [sym_pipeline] = STATE(2153),
    [sym_list] = STATE(2153),
    [sym_negated_command] = STATE(2153),
    [sym_test_command] = STATE(2153),
    [sym_declaration_command] = STATE(2153),
    [sym_unset_command] = STATE(2153),
    [sym_command] = STATE(2153),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(406),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(248),
    [anon_sym_select] = ACTIONS(251),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(254),
    [anon_sym_while] = ACTIONS(257),
    [anon_sym_until] = ACTIONS(257),
    [anon_sym_if] = ACTIONS(260),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_LBRACE] = ACTIONS(274),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(280),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(283),
    [anon_sym_declare] = ACTIONS(286),
    [anon_sym_typeset] = ACTIONS(286),
    [anon_sym_export] = ACTIONS(286),
    [anon_sym_readonly] = ACTIONS(286),
    [anon_sym_local] = ACTIONS(286),
    [anon_sym_unset] = ACTIONS(289),
    [anon_sym_unsetenv] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(292),
    [anon_sym_GT] = ACTIONS(292),
    [anon_sym_GT_GT] = ACTIONS(292),
    [anon_sym_AMP_GT] = ACTIONS(292),
    [anon_sym_AMP_GT_GT] = ACTIONS(292),
    [anon_sym_LT_AMP] = ACTIONS(292),
    [anon_sym_GT_AMP] = ACTIONS(292),
    [anon_sym_GT_PIPE] = ACTIONS(292),
    [anon_sym_DOLLAR] = ACTIONS(295),
    [sym__special_character] = ACTIONS(298),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [sym_raw_string] = ACTIONS(304),
    [sym_ansii_c_string] = ACTIONS(304),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(307),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(310),
    [anon_sym_BQUOTE] = ACTIONS(313),
    [anon_sym_LT_LPAREN] = ACTIONS(316),
    [anon_sym_GT_LPAREN] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(319),
    [sym_variable_name] = ACTIONS(322),
  },
  [75] = {
    [sym__statements] = STATE(4128),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [76] = {
    [sym__statements] = STATE(4092),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [77] = {
    [sym__statements] = STATE(3999),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [78] = {
    [sym__statements] = STATE(3998),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [79] = {
    [aux_sym__statements2] = STATE(72),
    [sym_redirected_statement] = STATE(2158),
    [sym_for_statement] = STATE(2158),
    [sym_c_style_for_statement] = STATE(2158),
    [sym_while_statement] = STATE(2158),
    [sym_if_statement] = STATE(2158),
    [sym_case_statement] = STATE(2158),
    [sym_function_definition] = STATE(2158),
    [sym_compound_statement] = STATE(2158),
    [sym_subshell] = STATE(2158),
    [sym_pipeline] = STATE(2158),
    [sym_list] = STATE(2158),
    [sym_negated_command] = STATE(2158),
    [sym_test_command] = STATE(2158),
    [sym_declaration_command] = STATE(2158),
    [sym_unset_command] = STATE(2158),
    [sym_command] = STATE(2158),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(410),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(347),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [80] = {
    [sym__statements] = STATE(4126),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [81] = {
    [sym__statements] = STATE(3997),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2428),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [82] = {
    [sym__statements] = STATE(3957),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [83] = {
    [sym__statements] = STATE(4125),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2343),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [84] = {
    [sym__statements] = STATE(4123),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [85] = {
    [sym__statements] = STATE(4190),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [86] = {
    [sym__statements] = STATE(4056),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [87] = {
    [aux_sym__statements2] = STATE(87),
    [sym_redirected_statement] = STATE(2156),
    [sym_for_statement] = STATE(2156),
    [sym_c_style_for_statement] = STATE(2156),
    [sym_while_statement] = STATE(2156),
    [sym_if_statement] = STATE(2156),
    [sym_case_statement] = STATE(2156),
    [sym_function_definition] = STATE(2156),
    [sym_compound_statement] = STATE(2156),
    [sym_subshell] = STATE(2156),
    [sym_pipeline] = STATE(2156),
    [sym_list] = STATE(2156),
    [sym_negated_command] = STATE(2156),
    [sym_test_command] = STATE(2156),
    [sym_declaration_command] = STATE(2156),
    [sym_unset_command] = STATE(2156),
    [sym_command] = STATE(2156),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(423),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(248),
    [anon_sym_select] = ACTIONS(251),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(254),
    [anon_sym_while] = ACTIONS(257),
    [anon_sym_until] = ACTIONS(257),
    [anon_sym_if] = ACTIONS(260),
    [anon_sym_fi] = ACTIONS(263),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_function] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_LBRACE] = ACTIONS(274),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(280),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(283),
    [anon_sym_declare] = ACTIONS(286),
    [anon_sym_typeset] = ACTIONS(286),
    [anon_sym_export] = ACTIONS(286),
    [anon_sym_readonly] = ACTIONS(286),
    [anon_sym_local] = ACTIONS(286),
    [anon_sym_unset] = ACTIONS(289),
    [anon_sym_unsetenv] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(292),
    [anon_sym_GT] = ACTIONS(292),
    [anon_sym_GT_GT] = ACTIONS(292),
    [anon_sym_AMP_GT] = ACTIONS(292),
    [anon_sym_AMP_GT_GT] = ACTIONS(292),
    [anon_sym_LT_AMP] = ACTIONS(292),
    [anon_sym_GT_AMP] = ACTIONS(292),
    [anon_sym_GT_PIPE] = ACTIONS(292),
    [anon_sym_DOLLAR] = ACTIONS(295),
    [sym__special_character] = ACTIONS(298),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [sym_raw_string] = ACTIONS(304),
    [sym_ansii_c_string] = ACTIONS(304),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(307),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(310),
    [anon_sym_BQUOTE] = ACTIONS(313),
    [anon_sym_LT_LPAREN] = ACTIONS(316),
    [anon_sym_GT_LPAREN] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(319),
    [sym_variable_name] = ACTIONS(322),
  },
  [88] = {
    [aux_sym__statements2] = STATE(93),
    [sym_redirected_statement] = STATE(2158),
    [sym_for_statement] = STATE(2158),
    [sym_c_style_for_statement] = STATE(2158),
    [sym_while_statement] = STATE(2158),
    [sym_if_statement] = STATE(2158),
    [sym_case_statement] = STATE(2158),
    [sym_function_definition] = STATE(2158),
    [sym_compound_statement] = STATE(2158),
    [sym_subshell] = STATE(2158),
    [sym_pipeline] = STATE(2158),
    [sym_list] = STATE(2158),
    [sym_negated_command] = STATE(2158),
    [sym_test_command] = STATE(2158),
    [sym_declaration_command] = STATE(2158),
    [sym_unset_command] = STATE(2158),
    [sym_command] = STATE(2158),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(410),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(349),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [89] = {
    [sym__statements] = STATE(4059),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [90] = {
    [sym__statements] = STATE(4115),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [91] = {
    [sym__statements] = STATE(4082),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [92] = {
    [sym__statements] = STATE(4098),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [93] = {
    [aux_sym__statements2] = STATE(72),
    [sym_redirected_statement] = STATE(2158),
    [sym_for_statement] = STATE(2158),
    [sym_c_style_for_statement] = STATE(2158),
    [sym_while_statement] = STATE(2158),
    [sym_if_statement] = STATE(2158),
    [sym_case_statement] = STATE(2158),
    [sym_function_definition] = STATE(2158),
    [sym_compound_statement] = STATE(2158),
    [sym_subshell] = STATE(2158),
    [sym_pipeline] = STATE(2158),
    [sym_list] = STATE(2158),
    [sym_negated_command] = STATE(2158),
    [sym_test_command] = STATE(2158),
    [sym_declaration_command] = STATE(2158),
    [sym_unset_command] = STATE(2158),
    [sym_command] = STATE(2158),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(410),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [94] = {
    [sym__statements] = STATE(4081),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2469),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [95] = {
    [sym__statements] = STATE(4034),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2478),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [96] = {
    [sym__statements] = STATE(4032),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [97] = {
    [sym__statements] = STATE(4099),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [98] = {
    [sym__statements] = STATE(4103),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [99] = {
    [sym__statements] = STATE(4058),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2373),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [100] = {
    [sym__statements] = STATE(4051),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [101] = {
    [sym__statements] = STATE(4050),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [102] = {
    [sym__statements] = STATE(4068),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2352),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [103] = {
    [aux_sym__statements2] = STATE(79),
    [sym_redirected_statement] = STATE(2158),
    [sym_for_statement] = STATE(2158),
    [sym_c_style_for_statement] = STATE(2158),
    [sym_while_statement] = STATE(2158),
    [sym_if_statement] = STATE(2158),
    [sym_case_statement] = STATE(2158),
    [sym_function_definition] = STATE(2158),
    [sym_compound_statement] = STATE(2158),
    [sym_subshell] = STATE(2158),
    [sym_pipeline] = STATE(2158),
    [sym_list] = STATE(2158),
    [sym_negated_command] = STATE(2158),
    [sym_test_command] = STATE(2158),
    [sym_declaration_command] = STATE(2158),
    [sym_unset_command] = STATE(2158),
    [sym_command] = STATE(2158),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(410),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [104] = {
    [sym__statements] = STATE(4044),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [105] = {
    [sym__statements] = STATE(4114),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2365),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [106] = {
    [aux_sym__statements2] = STATE(62),
    [sym_redirected_statement] = STATE(2153),
    [sym_for_statement] = STATE(2153),
    [sym_c_style_for_statement] = STATE(2153),
    [sym_while_statement] = STATE(2153),
    [sym_if_statement] = STATE(2153),
    [sym_case_statement] = STATE(2153),
    [sym_function_definition] = STATE(2153),
    [sym_compound_statement] = STATE(2153),
    [sym_subshell] = STATE(2153),
    [sym_pipeline] = STATE(2153),
    [sym_list] = STATE(2153),
    [sym_negated_command] = STATE(2153),
    [sym_test_command] = STATE(2153),
    [sym_declaration_command] = STATE(2153),
    [sym_unset_command] = STATE(2153),
    [sym_command] = STATE(2153),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(406),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [107] = {
    [sym__statements] = STATE(4043),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [108] = {
    [sym__statements] = STATE(4108),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [109] = {
    [aux_sym__statements2] = STATE(24),
    [sym_redirected_statement] = STATE(2158),
    [sym_for_statement] = STATE(2158),
    [sym_c_style_for_statement] = STATE(2158),
    [sym_while_statement] = STATE(2158),
    [sym_if_statement] = STATE(2158),
    [sym_case_statement] = STATE(2158),
    [sym_function_definition] = STATE(2158),
    [sym_compound_statement] = STATE(2158),
    [sym_subshell] = STATE(2158),
    [sym_pipeline] = STATE(2158),
    [sym_list] = STATE(2158),
    [sym_negated_command] = STATE(2158),
    [sym_test_command] = STATE(2158),
    [sym_declaration_command] = STATE(2158),
    [sym_unset_command] = STATE(2158),
    [sym_command] = STATE(2158),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(410),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(357),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [110] = {
    [sym__statements] = STATE(4090),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2510),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [111] = {
    [sym__statements] = STATE(4042),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2348),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [112] = {
    [sym__statements] = STATE(4037),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [113] = {
    [sym__statements] = STATE(3978),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [114] = {
    [sym__statements] = STATE(4036),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [115] = {
    [sym__statements] = STATE(4035),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2437),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [116] = {
    [sym__statements] = STATE(4030),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [117] = {
    [sym__statements] = STATE(4029),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [118] = {
    [sym__statements] = STATE(4028),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2521),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [119] = {
    [sym__statements] = STATE(4023),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [120] = {
    [sym__statements] = STATE(4022),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [121] = {
    [sym__statements] = STATE(4020),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2460),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [122] = {
    [sym__statements] = STATE(3959),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [123] = {
    [sym__statements] = STATE(4016),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [124] = {
    [sym__statements] = STATE(4083),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [125] = {
    [sym__statements] = STATE(4013),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2399),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [126] = {
    [sym__statements] = STATE(4107),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [127] = {
    [aux_sym__statements2] = STATE(133),
    [sym_redirected_statement] = STATE(2153),
    [sym_for_statement] = STATE(2153),
    [sym_c_style_for_statement] = STATE(2153),
    [sym_while_statement] = STATE(2153),
    [sym_if_statement] = STATE(2153),
    [sym_case_statement] = STATE(2153),
    [sym_function_definition] = STATE(2153),
    [sym_compound_statement] = STATE(2153),
    [sym_subshell] = STATE(2153),
    [sym_pipeline] = STATE(2153),
    [sym_list] = STATE(2153),
    [sym_negated_command] = STATE(2153),
    [sym_test_command] = STATE(2153),
    [sym_declaration_command] = STATE(2153),
    [sym_unset_command] = STATE(2153),
    [sym_command] = STATE(2153),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(406),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [128] = {
    [sym__statements] = STATE(4106),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2448),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [129] = {
    [aux_sym__statements2] = STATE(42),
    [sym_redirected_statement] = STATE(2156),
    [sym_for_statement] = STATE(2156),
    [sym_c_style_for_statement] = STATE(2156),
    [sym_while_statement] = STATE(2156),
    [sym_if_statement] = STATE(2156),
    [sym_case_statement] = STATE(2156),
    [sym_function_definition] = STATE(2156),
    [sym_compound_statement] = STATE(2156),
    [sym_subshell] = STATE(2156),
    [sym_pipeline] = STATE(2156),
    [sym_list] = STATE(2156),
    [sym_negated_command] = STATE(2156),
    [sym_test_command] = STATE(2156),
    [sym_declaration_command] = STATE(2156),
    [sym_unset_command] = STATE(2156),
    [sym_command] = STATE(2156),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(423),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(361),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [130] = {
    [sym__statements] = STATE(3961),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(2438),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [131] = {
    [sym__statements] = STATE(4008),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [132] = {
    [sym__statements] = STATE(4007),
    [sym_redirected_statement] = STATE(2091),
    [sym_for_statement] = STATE(2091),
    [sym_c_style_for_statement] = STATE(2091),
    [sym_while_statement] = STATE(2091),
    [sym_if_statement] = STATE(2091),
    [sym_case_statement] = STATE(2091),
    [sym_function_definition] = STATE(2091),
    [sym_compound_statement] = STATE(2091),
    [sym_subshell] = STATE(2091),
    [sym_pipeline] = STATE(2091),
    [sym_list] = STATE(2091),
    [sym_negated_command] = STATE(2091),
    [sym_test_command] = STATE(2091),
    [sym_declaration_command] = STATE(2091),
    [sym_unset_command] = STATE(2091),
    [sym_command] = STATE(2091),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(412),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [133] = {
    [aux_sym__statements2] = STATE(74),
    [sym_redirected_statement] = STATE(2153),
    [sym_for_statement] = STATE(2153),
    [sym_c_style_for_statement] = STATE(2153),
    [sym_while_statement] = STATE(2153),
    [sym_if_statement] = STATE(2153),
    [sym_case_statement] = STATE(2153),
    [sym_function_definition] = STATE(2153),
    [sym_compound_statement] = STATE(2153),
    [sym_subshell] = STATE(2153),
    [sym_pipeline] = STATE(2153),
    [sym_list] = STATE(2153),
    [sym_negated_command] = STATE(2153),
    [sym_test_command] = STATE(2153),
    [sym_declaration_command] = STATE(2153),
    [sym_unset_command] = STATE(2153),
    [sym_command] = STATE(2153),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(406),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [134] = {
    [sym__statements] = STATE(3964),
    [sym_redirected_statement] = STATE(2090),
    [sym_for_statement] = STATE(2090),
    [sym_c_style_for_statement] = STATE(2090),
    [sym_while_statement] = STATE(2090),
    [sym_if_statement] = STATE(2090),
    [sym_case_statement] = STATE(2090),
    [sym_function_definition] = STATE(2090),
    [sym_compound_statement] = STATE(2090),
    [sym_subshell] = STATE(2090),
    [sym_pipeline] = STATE(2090),
    [sym_list] = STATE(2090),
    [sym_negated_command] = STATE(2090),
    [sym_test_command] = STATE(2090),
    [sym_declaration_command] = STATE(2090),
    [sym_unset_command] = STATE(2090),
    [sym_command] = STATE(2090),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(146),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [135] = {
    [sym__terminated_statement] = STATE(4191),
    [sym_redirected_statement] = STATE(2161),
    [sym_for_statement] = STATE(2161),
    [sym_c_style_for_statement] = STATE(2161),
    [sym_while_statement] = STATE(2161),
    [sym_if_statement] = STATE(2161),
    [sym_case_statement] = STATE(2161),
    [sym_function_definition] = STATE(2161),
    [sym_compound_statement] = STATE(2161),
    [sym_subshell] = STATE(2161),
    [sym_pipeline] = STATE(2161),
    [sym_list] = STATE(2161),
    [sym_negated_command] = STATE(2161),
    [sym_test_command] = STATE(2161),
    [sym_declaration_command] = STATE(2161),
    [sym_unset_command] = STATE(2161),
    [sym_command] = STATE(2161),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(398),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [136] = {
    [sym__terminated_statement] = STATE(3955),
    [sym_redirected_statement] = STATE(2161),
    [sym_for_statement] = STATE(2161),
    [sym_c_style_for_statement] = STATE(2161),
    [sym_while_statement] = STATE(2161),
    [sym_if_statement] = STATE(2161),
    [sym_case_statement] = STATE(2161),
    [sym_function_definition] = STATE(2161),
    [sym_compound_statement] = STATE(2161),
    [sym_subshell] = STATE(2161),
    [sym_pipeline] = STATE(2161),
    [sym_list] = STATE(2161),
    [sym_negated_command] = STATE(2161),
    [sym_test_command] = STATE(2161),
    [sym_declaration_command] = STATE(2161),
    [sym_unset_command] = STATE(2161),
    [sym_command] = STATE(2161),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(398),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [137] = {
    [sym__terminated_statement] = STATE(4003),
    [sym_redirected_statement] = STATE(2161),
    [sym_for_statement] = STATE(2161),
    [sym_c_style_for_statement] = STATE(2161),
    [sym_while_statement] = STATE(2161),
    [sym_if_statement] = STATE(2161),
    [sym_case_statement] = STATE(2161),
    [sym_function_definition] = STATE(2161),
    [sym_compound_statement] = STATE(2161),
    [sym_subshell] = STATE(2161),
    [sym_pipeline] = STATE(2161),
    [sym_list] = STATE(2161),
    [sym_negated_command] = STATE(2161),
    [sym_test_command] = STATE(2161),
    [sym_declaration_command] = STATE(2161),
    [sym_unset_command] = STATE(2161),
    [sym_command] = STATE(2161),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(398),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [138] = {
    [sym__terminated_statement] = STATE(4139),
    [sym_redirected_statement] = STATE(2161),
    [sym_for_statement] = STATE(2161),
    [sym_c_style_for_statement] = STATE(2161),
    [sym_while_statement] = STATE(2161),
    [sym_if_statement] = STATE(2161),
    [sym_case_statement] = STATE(2161),
    [sym_function_definition] = STATE(2161),
    [sym_compound_statement] = STATE(2161),
    [sym_subshell] = STATE(2161),
    [sym_pipeline] = STATE(2161),
    [sym_list] = STATE(2161),
    [sym_negated_command] = STATE(2161),
    [sym_test_command] = STATE(2161),
    [sym_declaration_command] = STATE(2161),
    [sym_unset_command] = STATE(2161),
    [sym_command] = STATE(2161),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(398),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [139] = {
    [sym_redirected_statement] = STATE(2139),
    [sym_for_statement] = STATE(2139),
    [sym_c_style_for_statement] = STATE(2139),
    [sym_while_statement] = STATE(2139),
    [sym_if_statement] = STATE(2139),
    [sym_case_statement] = STATE(2139),
    [sym_function_definition] = STATE(2139),
    [sym_compound_statement] = STATE(2139),
    [sym_subshell] = STATE(2139),
    [sym_pipeline] = STATE(2139),
    [sym_list] = STATE(2139),
    [sym_negated_command] = STATE(2139),
    [sym_test_command] = STATE(2139),
    [sym_declaration_command] = STATE(2139),
    [sym_unset_command] = STATE(2139),
    [sym_command] = STATE(2139),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(506),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(365),
    [anon_sym_for] = ACTIONS(368),
    [anon_sym_select] = ACTIONS(371),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(374),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_until] = ACTIONS(377),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_case] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(386),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(392),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(398),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_declare] = ACTIONS(404),
    [anon_sym_typeset] = ACTIONS(404),
    [anon_sym_export] = ACTIONS(404),
    [anon_sym_readonly] = ACTIONS(404),
    [anon_sym_local] = ACTIONS(404),
    [anon_sym_unset] = ACTIONS(407),
    [anon_sym_unsetenv] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(410),
    [anon_sym_GT] = ACTIONS(410),
    [anon_sym_GT_GT] = ACTIONS(410),
    [anon_sym_AMP_GT] = ACTIONS(410),
    [anon_sym_AMP_GT_GT] = ACTIONS(410),
    [anon_sym_LT_AMP] = ACTIONS(410),
    [anon_sym_GT_AMP] = ACTIONS(410),
    [anon_sym_GT_PIPE] = ACTIONS(410),
    [anon_sym_DOLLAR] = ACTIONS(413),
    [sym__special_character] = ACTIONS(416),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [sym_raw_string] = ACTIONS(422),
    [sym_ansii_c_string] = ACTIONS(422),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(425),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(431),
    [anon_sym_LT_LPAREN] = ACTIONS(434),
    [anon_sym_GT_LPAREN] = ACTIONS(434),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(437),
    [sym_variable_name] = ACTIONS(440),
  },
  [140] = {
    [sym_redirected_statement] = STATE(2078),
    [sym_for_statement] = STATE(2078),
    [sym_c_style_for_statement] = STATE(2078),
    [sym_while_statement] = STATE(2078),
    [sym_if_statement] = STATE(2078),
    [sym_case_statement] = STATE(2078),
    [sym_function_definition] = STATE(2078),
    [sym_compound_statement] = STATE(2078),
    [sym_subshell] = STATE(2078),
    [sym_pipeline] = STATE(2078),
    [sym_list] = STATE(2078),
    [sym_negated_command] = STATE(2078),
    [sym_test_command] = STATE(2078),
    [sym_declaration_command] = STATE(2078),
    [sym_unset_command] = STATE(2078),
    [sym_command] = STATE(2078),
    [sym_command_name] = STATE(221),
    [sym_variable_assignment] = STATE(370),
    [sym_subscript] = STATE(3953),
    [sym_file_redirect] = STATE(894),
    [sym_concatenation] = STATE(870),
    [sym_string] = STATE(489),
    [sym_simple_expansion] = STATE(489),
    [sym_string_expansion] = STATE(489),
    [sym_expansion] = STATE(489),
    [sym_command_substitution] = STATE(489),
    [sym_process_substitution] = STATE(489),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(894),
    [aux_sym__literal_repeat1] = STATE(763),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansii_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [141] = {
    [sym__terminated_statement] = STATE(3975),
    [sym_redirected_statement] = STATE(2161),
    [sym_for_statement] = STATE(2161),
    [sym_c_style_for_statement] = STATE(2161),
    [sym_while_statement] = STATE(2161),
    [sym_if_statement] = STATE(2161),
    [sym_case_statement] = STATE(2161),
    [sym_function_definition] = STATE(2161),
    [sym_compound_statement] = STATE(2161),
    [sym_subshell] = STATE(2161),
    [sym_pipeline] = STATE(2161),
    [sym_list] = STATE(2161),
    [sym_negated_command] = STATE(2161),
    [sym_test_command] = STATE(2161),
    [sym_declaration_command] = STATE(2161),
    [sym_unset_command] = STATE(2161),
    [sym_command] = STATE(2161),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(398),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [142] = {
    [sym_redirected_statement] = STATE(2055),
    [sym_for_statement] = STATE(2055),
    [sym_c_style_for_statement] = STATE(2055),
    [sym_while_statement] = STATE(2055),
    [sym_if_statement] = STATE(2055),
    [sym_case_statement] = STATE(2055),
    [sym_function_definition] = STATE(2055),
    [sym_compound_statement] = STATE(2055),
    [sym_subshell] = STATE(2055),
    [sym_pipeline] = STATE(2055),
    [sym_list] = STATE(2055),
    [sym_negated_command] = STATE(2055),
    [sym_test_command] = STATE(2055),
    [sym_declaration_command] = STATE(2055),
    [sym_unset_command] = STATE(2055),
    [sym_command] = STATE(2055),
    [sym_command_name] = STATE(175),
    [sym_variable_assignment] = STATE(274),
    [sym_subscript] = STATE(3908),
    [sym_file_redirect] = STATE(825),
    [sym_concatenation] = STATE(411),
    [sym_string] = STATE(285),
    [sym_simple_expansion] = STATE(285),
    [sym_string_expansion] = STATE(285),
    [sym_expansion] = STATE(285),
    [sym_command_substitution] = STATE(285),
    [sym_process_substitution] = STATE(285),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(825),
    [aux_sym__literal_repeat1] = STATE(388),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [143] = {
    [sym__terminated_statement] = STATE(3951),
    [sym_redirected_statement] = STATE(2161),
    [sym_for_statement] = STATE(2161),
    [sym_c_style_for_statement] = STATE(2161),
    [sym_while_statement] = STATE(2161),
    [sym_if_statement] = STATE(2161),
    [sym_case_statement] = STATE(2161),
    [sym_function_definition] = STATE(2161),
    [sym_compound_statement] = STATE(2161),
    [sym_subshell] = STATE(2161),
    [sym_pipeline] = STATE(2161),
    [sym_list] = STATE(2161),
    [sym_negated_command] = STATE(2161),
    [sym_test_command] = STATE(2161),
    [sym_declaration_command] = STATE(2161),
    [sym_unset_command] = STATE(2161),
    [sym_command] = STATE(2161),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(398),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [144] = {
    [sym_redirected_statement] = STATE(2059),
    [sym_for_statement] = STATE(2059),
    [sym_c_style_for_statement] = STATE(2059),
    [sym_while_statement] = STATE(2059),
    [sym_if_statement] = STATE(2059),
    [sym_case_statement] = STATE(2059),
    [sym_function_definition] = STATE(2059),
    [sym_compound_statement] = STATE(2059),
    [sym_subshell] = STATE(2059),
    [sym_pipeline] = STATE(2059),
    [sym_list] = STATE(2059),
    [sym_negated_command] = STATE(2059),
    [sym_test_command] = STATE(2059),
    [sym_declaration_command] = STATE(2059),
    [sym_unset_command] = STATE(2059),
    [sym_command] = STATE(2059),
    [sym_command_name] = STATE(207),
    [sym_variable_assignment] = STATE(283),
    [sym_subscript] = STATE(3876),
    [sym_file_redirect] = STATE(966),
    [sym_concatenation] = STATE(808),
    [sym_string] = STATE(348),
    [sym_simple_expansion] = STATE(348),
    [sym_string_expansion] = STATE(348),
    [sym_expansion] = STATE(348),
    [sym_command_substitution] = STATE(348),
    [sym_process_substitution] = STATE(348),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(966),
    [aux_sym__literal_repeat1] = STATE(492),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [145] = {
    [sym_redirected_statement] = STATE(2092),
    [sym_for_statement] = STATE(2092),
    [sym_c_style_for_statement] = STATE(2092),
    [sym_while_statement] = STATE(2092),
    [sym_if_statement] = STATE(2092),
    [sym_case_statement] = STATE(2092),
    [sym_function_definition] = STATE(2092),
    [sym_compound_statement] = STATE(2092),
    [sym_subshell] = STATE(2092),
    [sym_pipeline] = STATE(2092),
    [sym_list] = STATE(2092),
    [sym_negated_command] = STATE(2092),
    [sym_test_command] = STATE(2092),
    [sym_declaration_command] = STATE(2092),
    [sym_unset_command] = STATE(2092),
    [sym_command] = STATE(2092),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(404),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [146] = {
    [sym_redirected_statement] = STATE(2070),
    [sym_for_statement] = STATE(2070),
    [sym_c_style_for_statement] = STATE(2070),
    [sym_while_statement] = STATE(2070),
    [sym_if_statement] = STATE(2070),
    [sym_case_statement] = STATE(2070),
    [sym_function_definition] = STATE(2070),
    [sym_compound_statement] = STATE(2070),
    [sym_subshell] = STATE(2070),
    [sym_pipeline] = STATE(2070),
    [sym_list] = STATE(2070),
    [sym_negated_command] = STATE(2070),
    [sym_test_command] = STATE(2070),
    [sym_declaration_command] = STATE(2070),
    [sym_unset_command] = STATE(2070),
    [sym_command] = STATE(2070),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(325),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [147] = {
    [sym__terminated_statement] = STATE(3943),
    [sym_redirected_statement] = STATE(2161),
    [sym_for_statement] = STATE(2161),
    [sym_c_style_for_statement] = STATE(2161),
    [sym_while_statement] = STATE(2161),
    [sym_if_statement] = STATE(2161),
    [sym_case_statement] = STATE(2161),
    [sym_function_definition] = STATE(2161),
    [sym_compound_statement] = STATE(2161),
    [sym_subshell] = STATE(2161),
    [sym_pipeline] = STATE(2161),
    [sym_list] = STATE(2161),
    [sym_negated_command] = STATE(2161),
    [sym_test_command] = STATE(2161),
    [sym_declaration_command] = STATE(2161),
    [sym_unset_command] = STATE(2161),
    [sym_command] = STATE(2161),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(398),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [148] = {
    [sym_redirected_statement] = STATE(2074),
    [sym_for_statement] = STATE(2074),
    [sym_c_style_for_statement] = STATE(2074),
    [sym_while_statement] = STATE(2074),
    [sym_if_statement] = STATE(2074),
    [sym_case_statement] = STATE(2074),
    [sym_function_definition] = STATE(2074),
    [sym_compound_statement] = STATE(2074),
    [sym_subshell] = STATE(2074),
    [sym_pipeline] = STATE(2074),
    [sym_list] = STATE(2074),
    [sym_negated_command] = STATE(2074),
    [sym_test_command] = STATE(2074),
    [sym_declaration_command] = STATE(2074),
    [sym_unset_command] = STATE(2074),
    [sym_command] = STATE(2074),
    [sym_command_name] = STATE(221),
    [sym_variable_assignment] = STATE(315),
    [sym_subscript] = STATE(3953),
    [sym_file_redirect] = STATE(894),
    [sym_concatenation] = STATE(870),
    [sym_string] = STATE(489),
    [sym_simple_expansion] = STATE(489),
    [sym_string_expansion] = STATE(489),
    [sym_expansion] = STATE(489),
    [sym_command_substitution] = STATE(489),
    [sym_process_substitution] = STATE(489),
    [aux_sym_command_repeat1] = STATE(894),
    [aux_sym__literal_repeat1] = STATE(763),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansii_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [149] = {
    [sym_redirected_statement] = STATE(2064),
    [sym_for_statement] = STATE(2064),
    [sym_c_style_for_statement] = STATE(2064),
    [sym_while_statement] = STATE(2064),
    [sym_if_statement] = STATE(2064),
    [sym_case_statement] = STATE(2064),
    [sym_function_definition] = STATE(2064),
    [sym_compound_statement] = STATE(2064),
    [sym_subshell] = STATE(2064),
    [sym_pipeline] = STATE(2064),
    [sym_list] = STATE(2064),
    [sym_negated_command] = STATE(2064),
    [sym_test_command] = STATE(2064),
    [sym_declaration_command] = STATE(2064),
    [sym_unset_command] = STATE(2064),
    [sym_command] = STATE(2064),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(306),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [150] = {
    [sym_redirected_statement] = STATE(2071),
    [sym_for_statement] = STATE(2071),
    [sym_c_style_for_statement] = STATE(2071),
    [sym_while_statement] = STATE(2071),
    [sym_if_statement] = STATE(2071),
    [sym_case_statement] = STATE(2071),
    [sym_function_definition] = STATE(2071),
    [sym_compound_statement] = STATE(2071),
    [sym_subshell] = STATE(2071),
    [sym_pipeline] = STATE(2071),
    [sym_list] = STATE(2071),
    [sym_negated_command] = STATE(2071),
    [sym_test_command] = STATE(2071),
    [sym_declaration_command] = STATE(2071),
    [sym_unset_command] = STATE(2071),
    [sym_command] = STATE(2071),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(305),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(939),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(939),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [151] = {
    [sym_redirected_statement] = STATE(2068),
    [sym_for_statement] = STATE(2068),
    [sym_c_style_for_statement] = STATE(2068),
    [sym_while_statement] = STATE(2068),
    [sym_if_statement] = STATE(2068),
    [sym_case_statement] = STATE(2068),
    [sym_function_definition] = STATE(2068),
    [sym_compound_statement] = STATE(2068),
    [sym_subshell] = STATE(2068),
    [sym_pipeline] = STATE(2068),
    [sym_list] = STATE(2068),
    [sym_negated_command] = STATE(2068),
    [sym_test_command] = STATE(2068),
    [sym_declaration_command] = STATE(2068),
    [sym_unset_command] = STATE(2068),
    [sym_command] = STATE(2068),
    [sym_command_name] = STATE(207),
    [sym_variable_assignment] = STATE(280),
    [sym_subscript] = STATE(3876),
    [sym_file_redirect] = STATE(966),
    [sym_concatenation] = STATE(808),
    [sym_string] = STATE(348),
    [sym_simple_expansion] = STATE(348),
    [sym_string_expansion] = STATE(348),
    [sym_expansion] = STATE(348),
    [sym_command_substitution] = STATE(348),
    [sym_process_substitution] = STATE(348),
    [aux_sym_command_repeat1] = STATE(966),
    [aux_sym__literal_repeat1] = STATE(492),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [152] = {
    [sym_redirected_statement] = STATE(2056),
    [sym_for_statement] = STATE(2056),
    [sym_c_style_for_statement] = STATE(2056),
    [sym_while_statement] = STATE(2056),
    [sym_if_statement] = STATE(2056),
    [sym_case_statement] = STATE(2056),
    [sym_function_definition] = STATE(2056),
    [sym_compound_statement] = STATE(2056),
    [sym_subshell] = STATE(2056),
    [sym_pipeline] = STATE(2056),
    [sym_list] = STATE(2056),
    [sym_negated_command] = STATE(2056),
    [sym_test_command] = STATE(2056),
    [sym_declaration_command] = STATE(2056),
    [sym_unset_command] = STATE(2056),
    [sym_command] = STATE(2056),
    [sym_command_name] = STATE(175),
    [sym_variable_assignment] = STATE(272),
    [sym_subscript] = STATE(3908),
    [sym_file_redirect] = STATE(825),
    [sym_concatenation] = STATE(411),
    [sym_string] = STATE(285),
    [sym_simple_expansion] = STATE(285),
    [sym_string_expansion] = STATE(285),
    [sym_expansion] = STATE(285),
    [sym_command_substitution] = STATE(285),
    [sym_process_substitution] = STATE(285),
    [aux_sym_command_repeat1] = STATE(825),
    [aux_sym__literal_repeat1] = STATE(388),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [153] = {
    [sym_redirected_statement] = STATE(2067),
    [sym_for_statement] = STATE(2067),
    [sym_c_style_for_statement] = STATE(2067),
    [sym_while_statement] = STATE(2067),
    [sym_if_statement] = STATE(2067),
    [sym_case_statement] = STATE(2067),
    [sym_function_definition] = STATE(2067),
    [sym_compound_statement] = STATE(2067),
    [sym_subshell] = STATE(2067),
    [sym_pipeline] = STATE(2067),
    [sym_list] = STATE(2067),
    [sym_negated_command] = STATE(2067),
    [sym_test_command] = STATE(2067),
    [sym_declaration_command] = STATE(2067),
    [sym_unset_command] = STATE(2067),
    [sym_command] = STATE(2067),
    [sym_command_name] = STATE(207),
    [sym_variable_assignment] = STATE(279),
    [sym_subscript] = STATE(3876),
    [sym_file_redirect] = STATE(966),
    [sym_concatenation] = STATE(808),
    [sym_string] = STATE(348),
    [sym_simple_expansion] = STATE(348),
    [sym_string_expansion] = STATE(348),
    [sym_expansion] = STATE(348),
    [sym_command_substitution] = STATE(348),
    [sym_process_substitution] = STATE(348),
    [aux_sym_command_repeat1] = STATE(966),
    [aux_sym__literal_repeat1] = STATE(492),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [154] = {
    [sym_redirected_statement] = STATE(2064),
    [sym_for_statement] = STATE(2064),
    [sym_c_style_for_statement] = STATE(2064),
    [sym_while_statement] = STATE(2064),
    [sym_if_statement] = STATE(2064),
    [sym_case_statement] = STATE(2064),
    [sym_function_definition] = STATE(2064),
    [sym_compound_statement] = STATE(2064),
    [sym_subshell] = STATE(2064),
    [sym_pipeline] = STATE(2064),
    [sym_list] = STATE(2064),
    [sym_negated_command] = STATE(2064),
    [sym_test_command] = STATE(2064),
    [sym_declaration_command] = STATE(2064),
    [sym_unset_command] = STATE(2064),
    [sym_command] = STATE(2064),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(400),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [155] = {
    [sym_redirected_statement] = STATE(2084),
    [sym_for_statement] = STATE(2084),
    [sym_c_style_for_statement] = STATE(2084),
    [sym_while_statement] = STATE(2084),
    [sym_if_statement] = STATE(2084),
    [sym_case_statement] = STATE(2084),
    [sym_function_definition] = STATE(2084),
    [sym_compound_statement] = STATE(2084),
    [sym_subshell] = STATE(2084),
    [sym_pipeline] = STATE(2084),
    [sym_list] = STATE(2084),
    [sym_negated_command] = STATE(2084),
    [sym_test_command] = STATE(2084),
    [sym_declaration_command] = STATE(2084),
    [sym_unset_command] = STATE(2084),
    [sym_command] = STATE(2084),
    [sym_command_name] = STATE(250),
    [sym_variable_assignment] = STATE(399),
    [sym_subscript] = STATE(3904),
    [sym_file_redirect] = STATE(848),
    [sym_concatenation] = STATE(940),
    [sym_string] = STATE(470),
    [sym_simple_expansion] = STATE(470),
    [sym_string_expansion] = STATE(470),
    [sym_expansion] = STATE(470),
    [sym_command_substitution] = STATE(470),
    [sym_process_substitution] = STATE(470),
    [aux_sym_command_repeat1] = STATE(848),
    [aux_sym__literal_repeat1] = STATE(618),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(335),
    [anon_sym_typeset] = ACTIONS(335),
    [anon_sym_export] = ACTIONS(335),
    [anon_sym_readonly] = ACTIONS(335),
    [anon_sym_local] = ACTIONS(335),
    [anon_sym_unset] = ACTIONS(337),
    [anon_sym_unsetenv] = ACTIONS(337),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansii_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [156] = {
    [sym_redirected_statement] = STATE(2054),
    [sym_for_statement] = STATE(2054),
    [sym_c_style_for_statement] = STATE(2054),
    [sym_while_statement] = STATE(2054),
    [sym_if_statement] = STATE(2054),
    [sym_case_statement] = STATE(2054),
    [sym_function_definition] = STATE(2054),
    [sym_compound_statement] = STATE(2054),
    [sym_subshell] = STATE(2054),
    [sym_pipeline] = STATE(2054),
    [sym_list] = STATE(2054),
    [sym_negated_command] = STATE(2054),
    [sym_test_command] = STATE(2054),
    [sym_declaration_command] = STATE(2054),
    [sym_unset_command] = STATE(2054),
    [sym_command] = STATE(2054),
    [sym_command_name] = STATE(175),
    [sym_variable_assignment] = STATE(276),
    [sym_subscript] = STATE(3908),
    [sym_file_redirect] = STATE(825),
    [sym_concatenation] = STATE(411),
    [sym_string] = STATE(285),
    [sym_simple_expansion] = STATE(285),
    [sym_string_expansion] = STATE(285),
    [sym_expansion] = STATE(285),
    [sym_command_substitution] = STATE(285),
    [sym_process_substitution] = STATE(285),
    [aux_sym_command_repeat1] = STATE(825),
    [aux_sym__literal_repeat1] = STATE(388),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansii_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [157] = {
    [sym_redirected_statement] = STATE(2073),
    [sym_for_statement] = STATE(2073),
    [sym_c_style_for_statement] = STATE(2073),
    [sym_while_statement] = STATE(2073),
    [sym_if_statement] = STATE(2073),
    [sym_case_statement] = STATE(2073),
    [sym_function_definition] = STATE(2073),
    [sym_compound_statement] = STATE(2073),
    [sym_subshell] = STATE(2073),
    [sym_pipeline] = STATE(2073),
    [sym_list] = STATE(2073),
    [sym_negated_command] = STATE(2073),
    [sym_test_command] = STATE(2073),
    [sym_declaration_command] = STATE(2073),
    [sym_unset_command] = STATE(2073),
    [sym_command] = STATE(2073),
    [sym_command_name] = STATE(221),
    [sym_variable_assignment] = STATE(313),
    [sym_subscript] = STATE(3953),
    [sym_file_redirect] = STATE(894),
    [sym_concatenation] = STATE(870),
    [sym_string] = STATE(489),
    [sym_simple_expansion] = STATE(489),
    [sym_string_expansion] = STATE(489),
    [sym_expansion] = STATE(489),
    [sym_command_substitution] = STATE(489),
    [sym_process_substitution] = STATE(489),
    [aux_sym_command_repeat1] = STATE(894),
    [aux_sym__literal_repeat1] = STATE(763),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansii_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(3391), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [64] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(3406), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [128] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(3473), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 3,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [191] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      sym__simple_heredoc_body,
    ACTIONS(457), 1,
      sym__heredoc_body_beginning,
    STATE(3544), 1,
      sym_heredoc_body,
    ACTIONS(459), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(263), 42,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [252] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(3465), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 3,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [315] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(466), 1,
      anon_sym_DOLLAR,
    ACTIONS(469), 1,
      sym__special_character,
    ACTIONS(472), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(478), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(481), 1,
      anon_sym_BQUOTE,
    ACTIONS(487), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(490), 1,
      sym_file_descriptor,
    ACTIONS(492), 1,
      sym_variable_name,
    STATE(385), 1,
      aux_sym__literal_repeat1,
    STATE(3895), 1,
      sym_subscript,
    ACTIONS(484), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(461), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(163), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(287), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(464), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [398] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      anon_sym_DOLLAR,
    ACTIONS(501), 1,
      sym__special_character,
    ACTIONS(503), 1,
      anon_sym_DQUOTE,
    ACTIONS(505), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(507), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(509), 1,
      anon_sym_BQUOTE,
    ACTIONS(513), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(515), 1,
      sym_file_descriptor,
    ACTIONS(517), 1,
      sym_variable_name,
    STATE(385), 1,
      aux_sym__literal_repeat1,
    STATE(3895), 1,
      sym_subscript,
    ACTIONS(511), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(495), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(165), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(287), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(497), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [481] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      anon_sym_DOLLAR,
    ACTIONS(501), 1,
      sym__special_character,
    ACTIONS(503), 1,
      anon_sym_DQUOTE,
    ACTIONS(505), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(507), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(509), 1,
      anon_sym_BQUOTE,
    ACTIONS(517), 1,
      sym_variable_name,
    ACTIONS(521), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(523), 1,
      sym_file_descriptor,
    STATE(385), 1,
      aux_sym__literal_repeat1,
    STATE(3895), 1,
      sym_subscript,
    ACTIONS(511), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(495), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(163), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(287), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(519), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [564] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 1,
      sym_file_descriptor,
    ACTIONS(527), 1,
      anon_sym_DOLLAR,
    ACTIONS(529), 1,
      sym__special_character,
    ACTIONS(531), 1,
      anon_sym_DQUOTE,
    ACTIONS(533), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(537), 1,
      anon_sym_BQUOTE,
    ACTIONS(541), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(543), 1,
      sym_variable_name,
    STATE(546), 1,
      aux_sym__literal_repeat1,
    STATE(3859), 1,
      sym_subscript,
    ACTIONS(539), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(525), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(167), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(310), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(519), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [646] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(490), 1,
      sym_file_descriptor,
    ACTIONS(548), 1,
      anon_sym_DOLLAR,
    ACTIONS(551), 1,
      sym__special_character,
    ACTIONS(554), 1,
      anon_sym_DQUOTE,
    ACTIONS(557), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(560), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(563), 1,
      anon_sym_BQUOTE,
    ACTIONS(569), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(572), 1,
      sym_variable_name,
    STATE(546), 1,
      aux_sym__literal_repeat1,
    STATE(3859), 1,
      sym_subscript,
    ACTIONS(566), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(545), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(167), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(310), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(464), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [728] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_file_descriptor,
    ACTIONS(527), 1,
      anon_sym_DOLLAR,
    ACTIONS(529), 1,
      sym__special_character,
    ACTIONS(531), 1,
      anon_sym_DQUOTE,
    ACTIONS(533), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(535), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(537), 1,
      anon_sym_BQUOTE,
    ACTIONS(543), 1,
      sym_variable_name,
    ACTIONS(575), 1,
      aux_sym__simple_variable_name_token1,
    STATE(546), 1,
      aux_sym__literal_repeat1,
    STATE(3859), 1,
      sym_subscript,
    ACTIONS(539), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(525), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(166), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(310), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(497), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [810] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      sym_raw_string,
    ACTIONS(583), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(585), 1,
      sym_file_descriptor,
    STATE(353), 1,
      sym_string,
    ACTIONS(579), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 32,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [874] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(590), 1,
      anon_sym_DOLLAR,
    ACTIONS(593), 1,
      sym__special_character,
    ACTIONS(596), 1,
      anon_sym_DQUOTE,
    ACTIONS(599), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(602), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(605), 1,
      anon_sym_BQUOTE,
    ACTIONS(611), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(614), 1,
      sym_variable_name,
    STATE(665), 1,
      aux_sym__literal_repeat1,
    STATE(3935), 1,
      sym_subscript,
    ACTIONS(490), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(608), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(587), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(170), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(407), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(464), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [955] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 1,
      ts_builtin_sym_end,
    ACTIONS(619), 1,
      sym__simple_heredoc_body,
    ACTIONS(621), 1,
      sym__heredoc_body_beginning,
    STATE(3524), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1016] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(629), 1,
      sym_file_descriptor,
    STATE(179), 1,
      aux_sym_command_repeat2,
    STATE(391), 1,
      aux_sym__literal_repeat1,
    STATE(405), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(627), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(623), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(278), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(625), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1095] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(633), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(631), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1150] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_file_descriptor,
    ACTIONS(639), 1,
      anon_sym_DOLLAR,
    ACTIONS(641), 1,
      sym__special_character,
    ACTIONS(643), 1,
      anon_sym_DQUOTE,
    ACTIONS(645), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(647), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(649), 1,
      anon_sym_BQUOTE,
    ACTIONS(653), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(655), 1,
      sym_variable_name,
    STATE(612), 1,
      aux_sym__literal_repeat1,
    STATE(3923), 1,
      sym_subscript,
    ACTIONS(651), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(637), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(181), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(484), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(497), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1231] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(659), 1,
      sym_file_descriptor,
    STATE(189), 1,
      aux_sym_command_repeat2,
    STATE(391), 1,
      aux_sym__literal_repeat1,
    STATE(405), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(627), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(623), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(278), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(657), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1310] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1365] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      anon_sym_RPAREN,
    ACTIONS(455), 1,
      sym__simple_heredoc_body,
    ACTIONS(457), 1,
      sym__heredoc_body_beginning,
    STATE(3503), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1426] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      sym__simple_heredoc_body,
    ACTIONS(457), 1,
      sym__heredoc_body_beginning,
    STATE(3537), 1,
      sym_heredoc_body,
    ACTIONS(459), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(263), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1485] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(669), 1,
      anon_sym_DOLLAR,
    ACTIONS(672), 1,
      sym__special_character,
    ACTIONS(675), 1,
      anon_sym_DQUOTE,
    ACTIONS(678), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(681), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(684), 1,
      anon_sym_BQUOTE,
    ACTIONS(690), 1,
      sym_file_descriptor,
    STATE(179), 1,
      aux_sym_command_repeat2,
    STATE(391), 1,
      aux_sym__literal_repeat1,
    STATE(405), 1,
      sym_concatenation,
    ACTIONS(666), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(687), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(661), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(278), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(664), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1564] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(692), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(631), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1619] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 1,
      sym_file_descriptor,
    ACTIONS(639), 1,
      anon_sym_DOLLAR,
    ACTIONS(641), 1,
      sym__special_character,
    ACTIONS(643), 1,
      anon_sym_DQUOTE,
    ACTIONS(645), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(647), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(649), 1,
      anon_sym_BQUOTE,
    ACTIONS(655), 1,
      sym_variable_name,
    ACTIONS(694), 1,
      aux_sym__simple_variable_name_token1,
    STATE(612), 1,
      aux_sym__literal_repeat1,
    STATE(3923), 1,
      sym_subscript,
    ACTIONS(651), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(637), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(185), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(484), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(519), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1700] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(633), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(631), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1755] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      sym_file_descriptor,
    ACTIONS(698), 1,
      sym_raw_string,
    ACTIONS(700), 1,
      aux_sym__simple_variable_name_token1,
    STATE(501), 1,
      sym_string,
    ACTIONS(696), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 31,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [1818] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      sym_raw_string,
    ACTIONS(706), 1,
      aux_sym__simple_variable_name_token1,
    STATE(366), 1,
      sym_string,
    ACTIONS(585), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(702), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [1881] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(490), 1,
      sym_file_descriptor,
    ACTIONS(711), 1,
      anon_sym_DOLLAR,
    ACTIONS(714), 1,
      sym__special_character,
    ACTIONS(717), 1,
      anon_sym_DQUOTE,
    ACTIONS(720), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(723), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(726), 1,
      anon_sym_BQUOTE,
    ACTIONS(732), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(735), 1,
      sym_variable_name,
    STATE(612), 1,
      aux_sym__literal_repeat1,
    STATE(3923), 1,
      sym_subscript,
    ACTIONS(729), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(708), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(185), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(484), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(464), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1962] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      sym__simple_heredoc_body,
    ACTIONS(457), 1,
      sym__heredoc_body_beginning,
    STATE(3529), 1,
      sym_heredoc_body,
    ACTIONS(459), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(263), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_done,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2021] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(740), 1,
      sym_file_descriptor,
    STATE(172), 1,
      aux_sym_command_repeat2,
    STATE(391), 1,
      aux_sym__literal_repeat1,
    STATE(405), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(627), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(623), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(278), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(738), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2100] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_DQUOTE,
    ACTIONS(746), 1,
      sym_raw_string,
    ACTIONS(748), 1,
      aux_sym__simple_variable_name_token1,
    STATE(488), 1,
      sym_string,
    ACTIONS(585), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(742), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [2163] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(752), 1,
      sym_file_descriptor,
    STATE(179), 1,
      aux_sym_command_repeat2,
    STATE(391), 1,
      aux_sym__literal_repeat1,
    STATE(405), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(627), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(623), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(278), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(750), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2242] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(692), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(631), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2297] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      anon_sym_DOLLAR,
    ACTIONS(758), 1,
      sym__special_character,
    ACTIONS(760), 1,
      anon_sym_DQUOTE,
    ACTIONS(762), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(764), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(766), 1,
      anon_sym_BQUOTE,
    ACTIONS(770), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(772), 1,
      sym_variable_name,
    STATE(665), 1,
      aux_sym__literal_repeat1,
    STATE(3935), 1,
      sym_subscript,
    ACTIONS(515), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(768), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(754), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(193), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(407), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(497), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2378] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_RPAREN,
    ACTIONS(455), 1,
      sym__simple_heredoc_body,
    ACTIONS(457), 1,
      sym__heredoc_body_beginning,
    STATE(3507), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2439] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      anon_sym_DOLLAR,
    ACTIONS(758), 1,
      sym__special_character,
    ACTIONS(760), 1,
      anon_sym_DQUOTE,
    ACTIONS(762), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(764), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(766), 1,
      anon_sym_BQUOTE,
    ACTIONS(772), 1,
      sym_variable_name,
    ACTIONS(774), 1,
      aux_sym__simple_variable_name_token1,
    STATE(665), 1,
      aux_sym__literal_repeat1,
    STATE(3935), 1,
      sym_subscript,
    ACTIONS(523), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(768), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(754), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(170), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(407), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(519), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2520] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2575] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2630] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(619), 1,
      sym__simple_heredoc_body,
    ACTIONS(621), 1,
      sym__heredoc_body_beginning,
    ACTIONS(776), 1,
      ts_builtin_sym_end,
    STATE(3508), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2691] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2746] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      sym__simple_heredoc_body,
    ACTIONS(457), 1,
      sym__heredoc_body_beginning,
    STATE(3554), 1,
      sym_heredoc_body,
    ACTIONS(459), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(263), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2805] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_file_descriptor,
    ACTIONS(639), 1,
      anon_sym_DOLLAR,
    ACTIONS(641), 1,
      sym__special_character,
    ACTIONS(643), 1,
      anon_sym_DQUOTE,
    ACTIONS(645), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(647), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(655), 1,
      sym_variable_name,
    ACTIONS(778), 1,
      aux_sym__simple_variable_name_token1,
    STATE(612), 1,
      aux_sym__literal_repeat1,
    STATE(3923), 1,
      sym_subscript,
    ACTIONS(651), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(637), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(201), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(484), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(497), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [2883] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      anon_sym_DQUOTE,
    ACTIONS(782), 1,
      sym_raw_string,
    ACTIONS(784), 1,
      aux_sym__simple_variable_name_token1,
    STATE(469), 1,
      sym_string,
    ACTIONS(585), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(780), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [2945] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 1,
      sym_file_descriptor,
    ACTIONS(639), 1,
      anon_sym_DOLLAR,
    ACTIONS(641), 1,
      sym__special_character,
    ACTIONS(643), 1,
      anon_sym_DQUOTE,
    ACTIONS(645), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(647), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(655), 1,
      sym_variable_name,
    ACTIONS(694), 1,
      aux_sym__simple_variable_name_token1,
    STATE(612), 1,
      aux_sym__literal_repeat1,
    STATE(3923), 1,
      sym_subscript,
    ACTIONS(651), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(637), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(185), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(484), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(519), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [3023] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      sym__special_character,
    ACTIONS(794), 1,
      anon_sym_DQUOTE,
    ACTIONS(796), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(798), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(800), 1,
      anon_sym_BQUOTE,
    ACTIONS(804), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(806), 1,
      sym_file_descriptor,
    STATE(409), 1,
      aux_sym__literal_repeat1,
    ACTIONS(802), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(204), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(786), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(384), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(788), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3099] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_BQUOTE,
    ACTIONS(455), 1,
      sym__simple_heredoc_body,
    ACTIONS(457), 1,
      sym__heredoc_body_beginning,
    STATE(3500), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3159] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      sym__special_character,
    ACTIONS(794), 1,
      anon_sym_DQUOTE,
    ACTIONS(796), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(798), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(800), 1,
      anon_sym_BQUOTE,
    ACTIONS(810), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(812), 1,
      sym_file_descriptor,
    STATE(409), 1,
      aux_sym__literal_repeat1,
    ACTIONS(802), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(210), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(786), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(384), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(808), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3235] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      sym__simple_heredoc_body,
    ACTIONS(457), 1,
      sym__heredoc_body_beginning,
    STATE(3573), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3293] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(752), 1,
      sym_file_descriptor,
    STATE(214), 1,
      aux_sym_command_repeat2,
    STATE(420), 1,
      aux_sym__literal_repeat1,
    STATE(629), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(816), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(814), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(294), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(750), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3371] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(659), 1,
      sym_file_descriptor,
    STATE(206), 1,
      aux_sym_command_repeat2,
    STATE(420), 1,
      aux_sym__literal_repeat1,
    STATE(629), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(816), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(814), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(294), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(657), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3449] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(740), 1,
      sym_file_descriptor,
    STATE(215), 1,
      aux_sym_command_repeat2,
    STATE(420), 1,
      aux_sym__literal_repeat1,
    STATE(629), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(816), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(814), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(294), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(738), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(263), 42,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3579] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 1,
      anon_sym_DOLLAR,
    ACTIONS(826), 1,
      sym__special_character,
    ACTIONS(829), 1,
      anon_sym_DQUOTE,
    ACTIONS(832), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(835), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(838), 1,
      anon_sym_BQUOTE,
    ACTIONS(844), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(847), 1,
      sym_file_descriptor,
    STATE(409), 1,
      aux_sym__literal_repeat1,
    ACTIONS(841), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(210), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(818), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(384), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(821), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3655] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(851), 1,
      sym_raw_string,
    ACTIONS(853), 1,
      aux_sym__simple_variable_name_token1,
    STATE(653), 1,
      sym_string,
    ACTIONS(585), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(849), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [3717] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(857), 1,
      anon_sym_DQUOTE,
    ACTIONS(859), 1,
      sym_raw_string,
    ACTIONS(861), 1,
      aux_sym__simple_variable_name_token1,
    STATE(587), 1,
      sym_string,
    ACTIONS(585), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(855), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [3779] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      anon_sym_BQUOTE,
    ACTIONS(455), 1,
      sym__simple_heredoc_body,
    ACTIONS(457), 1,
      sym__heredoc_body_beginning,
    STATE(3505), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3839] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 1,
      sym_file_descriptor,
    ACTIONS(869), 1,
      anon_sym_DOLLAR,
    ACTIONS(872), 1,
      sym__special_character,
    ACTIONS(875), 1,
      anon_sym_DQUOTE,
    ACTIONS(878), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(881), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(884), 1,
      anon_sym_BQUOTE,
    STATE(214), 1,
      aux_sym_command_repeat2,
    STATE(420), 1,
      aux_sym__literal_repeat1,
    STATE(629), 1,
      sym_concatenation,
    ACTIONS(866), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(887), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(863), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(294), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(664), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3917] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(629), 1,
      sym_file_descriptor,
    STATE(214), 1,
      aux_sym_command_repeat2,
    STATE(420), 1,
      aux_sym__literal_repeat1,
    STATE(629), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(816), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(814), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(294), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(625), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3995] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      sym_file_descriptor,
    ACTIONS(892), 1,
      sym_raw_string,
    ACTIONS(894), 1,
      aux_sym__simple_variable_name_token1,
    STATE(667), 1,
      sym_string,
    ACTIONS(890), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(896), 42,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [4109] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      sym_file_descriptor,
    ACTIONS(794), 1,
      anon_sym_DQUOTE,
    ACTIONS(902), 1,
      sym_raw_string,
    ACTIONS(904), 1,
      aux_sym__simple_variable_name_token1,
    STATE(524), 1,
      sym_string,
    ACTIONS(900), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4171] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(752), 1,
      sym_file_descriptor,
    STATE(225), 1,
      aux_sym_command_repeat2,
    STATE(606), 1,
      aux_sym__literal_repeat1,
    STATE(920), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(505), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(750), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4248] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(231), 1,
      aux_sym_command_repeat2,
    STATE(628), 1,
      aux_sym__literal_repeat1,
    STATE(915), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(752), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(912), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(910), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(419), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(750), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4325] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(220), 1,
      aux_sym_command_repeat2,
    STATE(628), 1,
      aux_sym__literal_repeat1,
    STATE(915), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(659), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(912), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(910), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(419), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(657), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4402] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      sym_file_descriptor,
    ACTIONS(916), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym_raw_string,
    ACTIONS(920), 1,
      aux_sym__simple_variable_name_token1,
    STATE(608), 1,
      sym_string,
    ACTIONS(914), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4463] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 1,
      sym_file_descriptor,
    ACTIONS(925), 1,
      anon_sym_DOLLAR,
    ACTIONS(928), 1,
      sym__special_character,
    ACTIONS(931), 1,
      anon_sym_DQUOTE,
    ACTIONS(934), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(937), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(940), 1,
      anon_sym_BQUOTE,
    ACTIONS(946), 1,
      aux_sym__simple_variable_name_token1,
    STATE(819), 1,
      aux_sym__literal_repeat1,
    ACTIONS(943), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(223), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(922), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(560), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(821), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4538] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(629), 1,
      sym_file_descriptor,
    STATE(225), 1,
      aux_sym_command_repeat2,
    STATE(606), 1,
      aux_sym__literal_repeat1,
    STATE(920), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(505), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(625), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4615] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 1,
      sym_file_descriptor,
    ACTIONS(955), 1,
      anon_sym_DOLLAR,
    ACTIONS(958), 1,
      sym__special_character,
    ACTIONS(961), 1,
      anon_sym_DQUOTE,
    ACTIONS(964), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(967), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(970), 1,
      anon_sym_BQUOTE,
    STATE(225), 1,
      aux_sym_command_repeat2,
    STATE(606), 1,
      aux_sym__literal_repeat1,
    STATE(920), 1,
      sym_concatenation,
    ACTIONS(952), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(973), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(949), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(505), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(664), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4692] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 1,
      anon_sym_DQUOTE,
    ACTIONS(980), 1,
      sym_raw_string,
    ACTIONS(982), 1,
      aux_sym__simple_variable_name_token1,
    STATE(827), 1,
      sym_string,
    ACTIONS(585), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(976), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 28,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4753] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 1,
      sym_file_descriptor,
    ACTIONS(916), 1,
      anon_sym_DQUOTE,
    ACTIONS(986), 1,
      anon_sym_DOLLAR,
    ACTIONS(988), 1,
      sym__special_character,
    ACTIONS(990), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(992), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(994), 1,
      anon_sym_BQUOTE,
    ACTIONS(998), 1,
      aux_sym__simple_variable_name_token1,
    STATE(819), 1,
      aux_sym__literal_repeat1,
    ACTIONS(996), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(233), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(984), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(560), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(788), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4828] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(740), 1,
      sym_file_descriptor,
    STATE(224), 1,
      aux_sym_command_repeat2,
    STATE(606), 1,
      aux_sym__literal_repeat1,
    STATE(920), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(505), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(738), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4905] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(643), 1,
      anon_sym_DQUOTE,
    ACTIONS(1002), 1,
      sym_raw_string,
    ACTIONS(1004), 1,
      aux_sym__simple_variable_name_token1,
    STATE(598), 1,
      sym_string,
    ACTIONS(585), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1000), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 28,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4966] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(235), 1,
      aux_sym_command_repeat2,
    STATE(628), 1,
      aux_sym__literal_repeat1,
    STATE(915), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(740), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(912), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(910), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(419), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(738), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5043] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      anon_sym_DOLLAR,
    ACTIONS(1015), 1,
      sym__special_character,
    ACTIONS(1018), 1,
      anon_sym_DQUOTE,
    ACTIONS(1021), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1024), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1027), 1,
      anon_sym_BQUOTE,
    STATE(231), 1,
      aux_sym_command_repeat2,
    STATE(628), 1,
      aux_sym__literal_repeat1,
    STATE(915), 1,
      sym_concatenation,
    ACTIONS(690), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1009), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(1030), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(1006), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(419), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(664), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5120] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(659), 1,
      sym_file_descriptor,
    STATE(219), 1,
      aux_sym_command_repeat2,
    STATE(606), 1,
      aux_sym__literal_repeat1,
    STATE(920), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(505), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(657), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5197] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 1,
      sym_file_descriptor,
    ACTIONS(916), 1,
      anon_sym_DQUOTE,
    ACTIONS(986), 1,
      anon_sym_DOLLAR,
    ACTIONS(988), 1,
      sym__special_character,
    ACTIONS(990), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(992), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(994), 1,
      anon_sym_BQUOTE,
    ACTIONS(1033), 1,
      aux_sym__simple_variable_name_token1,
    STATE(819), 1,
      aux_sym__literal_repeat1,
    ACTIONS(996), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(223), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(984), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(560), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(808), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5272] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 1,
      sym_raw_string,
    ACTIONS(1039), 1,
      aux_sym__simple_variable_name_token1,
    STATE(581), 1,
      sym_string,
    ACTIONS(585), 3,
      sym_file_descriptor,
      sym_variable_name,
      ts_builtin_sym_end,
    ACTIONS(1035), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 27,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [5333] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(231), 1,
      aux_sym_command_repeat2,
    STATE(628), 1,
      aux_sym__literal_repeat1,
    STATE(915), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(629), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(912), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(910), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(419), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(625), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5410] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1043), 1,
      anon_sym_DQUOTE,
    ACTIONS(1045), 1,
      sym_raw_string,
    ACTIONS(1047), 1,
      aux_sym__simple_variable_name_token1,
    STATE(970), 1,
      sym_string,
    ACTIONS(585), 3,
      sym_file_descriptor,
      sym_variable_name,
      ts_builtin_sym_end,
    ACTIONS(1041), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 27,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [5471] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(896), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_done,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5521] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(740), 1,
      sym_file_descriptor,
    STATE(247), 1,
      aux_sym_command_repeat2,
    STATE(606), 1,
      aux_sym__literal_repeat1,
    STATE(920), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(505), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(738), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [5595] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(263), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5645] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 1,
      sym_file_descriptor,
    ACTIONS(1051), 1,
      anon_sym_DOLLAR,
    ACTIONS(1053), 1,
      sym__special_character,
    ACTIONS(1055), 1,
      anon_sym_DQUOTE,
    ACTIONS(1057), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1059), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1061), 1,
      anon_sym_BQUOTE,
    ACTIONS(1065), 1,
      aux_sym__simple_variable_name_token1,
    STATE(932), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1063), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(249), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1049), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(611), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(808), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(896), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5769] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1067), 1,
      ts_builtin_sym_end,
    ACTIONS(635), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(631), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5821] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      sym_file_descriptor,
    ACTIONS(1055), 1,
      anon_sym_DQUOTE,
    ACTIONS(1071), 1,
      sym_raw_string,
    ACTIONS(1073), 1,
      aux_sym__simple_variable_name_token1,
    STATE(914), 1,
      sym_string,
    ACTIONS(1069), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 28,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [5881] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 1,
      ts_builtin_sym_end,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(263), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5983] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1078), 1,
      anon_sym_DOLLAR,
    ACTIONS(1081), 1,
      sym__special_character,
    ACTIONS(1084), 1,
      anon_sym_DQUOTE,
    ACTIONS(1087), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1090), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1093), 1,
      anon_sym_BQUOTE,
    ACTIONS(1099), 1,
      aux_sym__simple_variable_name_token1,
    STATE(905), 1,
      aux_sym__literal_repeat1,
    ACTIONS(847), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1096), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(246), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1075), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(664), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(821), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6057] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(629), 1,
      sym_file_descriptor,
    STATE(225), 1,
      aux_sym_command_repeat2,
    STATE(606), 1,
      aux_sym__literal_repeat1,
    STATE(920), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(505), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(625), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [6131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(896), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6181] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 1,
      sym_file_descriptor,
    ACTIONS(1105), 1,
      anon_sym_DOLLAR,
    ACTIONS(1108), 1,
      sym__special_character,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1114), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1117), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1120), 1,
      anon_sym_BQUOTE,
    ACTIONS(1126), 1,
      aux_sym__simple_variable_name_token1,
    STATE(932), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1123), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(249), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1102), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(611), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(821), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6255] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(659), 1,
      sym_file_descriptor,
    STATE(257), 1,
      aux_sym_command_repeat2,
    STATE(606), 1,
      aux_sym__literal_repeat1,
    STATE(920), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(505), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(657), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [6329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(263), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_done,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6379] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 1,
      ts_builtin_sym_end,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6431] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 1,
      anon_sym_DQUOTE,
    ACTIONS(1133), 1,
      sym_raw_string,
    ACTIONS(1135), 1,
      aux_sym__simple_variable_name_token1,
    STATE(984), 1,
      sym_string,
    ACTIONS(585), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1129), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(577), 27,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [6491] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      anon_sym_DOLLAR,
    ACTIONS(1141), 1,
      sym__special_character,
    ACTIONS(1143), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1145), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1147), 1,
      anon_sym_BQUOTE,
    ACTIONS(1151), 1,
      aux_sym__simple_variable_name_token1,
    STATE(905), 1,
      aux_sym__literal_repeat1,
    ACTIONS(812), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1149), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(246), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1137), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(664), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(808), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6565] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      anon_sym_DOLLAR,
    ACTIONS(1141), 1,
      sym__special_character,
    ACTIONS(1143), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1145), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1147), 1,
      anon_sym_BQUOTE,
    ACTIONS(1153), 1,
      aux_sym__simple_variable_name_token1,
    STATE(905), 1,
      aux_sym__literal_repeat1,
    ACTIONS(806), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1149), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(254), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1137), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(664), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(788), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6639] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 1,
      sym_file_descriptor,
    ACTIONS(1051), 1,
      anon_sym_DOLLAR,
    ACTIONS(1053), 1,
      sym__special_character,
    ACTIONS(1055), 1,
      anon_sym_DQUOTE,
    ACTIONS(1057), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1059), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1061), 1,
      anon_sym_BQUOTE,
    ACTIONS(1155), 1,
      aux_sym__simple_variable_name_token1,
    STATE(932), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1063), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(240), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1049), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(611), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(788), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6713] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(752), 1,
      sym_file_descriptor,
    STATE(225), 1,
      aux_sym_command_repeat2,
    STATE(606), 1,
      aux_sym__literal_repeat1,
    STATE(920), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(908), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(906), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(505), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(750), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [6787] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1157), 1,
      ts_builtin_sym_end,
    ACTIONS(635), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(631), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6839] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      anon_sym_BQUOTE,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6890] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 1,
      sym_file_descriptor,
    ACTIONS(1051), 1,
      anon_sym_DOLLAR,
    ACTIONS(1053), 1,
      sym__special_character,
    ACTIONS(1055), 1,
      anon_sym_DQUOTE,
    ACTIONS(1057), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1059), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1065), 1,
      aux_sym__simple_variable_name_token1,
    STATE(932), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1063), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(249), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1049), 3,
      sym_raw_string,
      sym_ansii_c_string,
      sym_word,
    STATE(611), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(808), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [6961] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    ACTIONS(55), 1,
      sym_file_descriptor,
    ACTIONS(1159), 1,
      sym_word,
    ACTIONS(1161), 1,
      sym_variable_name,
    STATE(221), 1,
      sym_command_name,
    STATE(763), 1,
      aux_sym__literal_repeat1,
    STATE(870), 1,
      sym_concatenation,
    STATE(3944), 1,
      sym_subscript,
    ACTIONS(45), 2,
      sym_raw_string,
      sym_ansii_c_string,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(894), 3,
      sym_variable_assignment,
      sym_file_redirect,
      aux_sym_command_repeat1,
    STATE(2536), 3,
      sym_subshell,
      sym_test_command,
      sym_command,
    STATE(489), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(37), 8,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
  [7052] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      sym_file_descriptor,
    ACTIONS(129), 1,
      anon_sym_LPAREN_LPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(151), 1,
      anon_sym_LBRACK,
    ACTIONS(153), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(1161), 1,
      sym_variable_name,
    ACTIONS(1163), 1,
      sym_word,
    STATE(207), 1,
      sym_command_name,
    STATE(492), 1,
      aux_sym__literal_repeat1,
    STATE(808), 1,
      sym_concatenation,
    STATE(3944), 1,
      sym_subscript,
    ACTIONS(221), 2,
      sym_raw_string,
      sym_ansii_c_string,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(966), 3,
      sym_variable_assignment,
      sym_file_redirect,
      aux_sym_command_repeat1,
    STATE(2213), 3,
      sym_subshell,
      sym_test_command,
      sym_command,
    STATE(348), 6,
      sym_string,
      sym_simple_expansion,
      sym_string_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(37), 8,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
  [7143] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7192] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(631), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7241] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_BQUOTE,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansii_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [7292] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      sym_file_descriptor,
    ACTIONS(65), 1,
      anon_sym_LPAREN_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      anon_sym_LBRACK,
    ACTIONS(89), 1,
      anon_sym_LBRACK_LBRACK,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(1161), 1,
      sym_variable_name,
    ACTIONS(1165), 1,
      sym_word,
    STATE(232), 1,
      sym_command_name,
    STATE(618), 1,
      aux_sym__literal_repeat1,
    STATE(940), 1,
      sym_concatenation,
    STATE(3944), 1,
      sym_subscript,
    ACTIONS(101), 2,
      sym_raw_string,
      sym_ansii_c_string,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(939), 3,
      sym_variable_assignment,
      sym_file_redirect,
      aux_sym_command_repeat1,
   