#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1248
#define LARGE_STATE_COUNT 22
#define SYMBOL_COUNT 207
#define ALIAS_COUNT 4
#define TOKEN_COUNT 92
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 35
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 104

enum {
  sym_identifier = 1,
  anon_sym_LF = 2,
  anon_sym_SEMI = 3,
  anon_sym_package = 4,
  anon_sym_import = 5,
  anon_sym_DOT = 6,
  sym_blank_identifier = 7,
  anon_sym_LPAREN = 8,
  anon_sym_RPAREN = 9,
  anon_sym_const = 10,
  anon_sym_COMMA = 11,
  anon_sym_EQ = 12,
  anon_sym_var = 13,
  anon_sym_func = 14,
  anon_sym_LBRACK = 15,
  anon_sym_RBRACK = 16,
  anon_sym_DOT_DOT_DOT = 17,
  anon_sym_type = 18,
  anon_sym_STAR = 19,
  anon_sym_struct = 20,
  anon_sym_LBRACE = 21,
  anon_sym_RBRACE = 22,
  anon_sym_interface = 23,
  anon_sym_PIPE = 24,
  anon_sym_TILDE = 25,
  anon_sym_map = 26,
  anon_sym_chan = 27,
  anon_sym_LT_DASH = 28,
  anon_sym_COLON_EQ = 29,
  anon_sym_PLUS_PLUS = 30,
  anon_sym_DASH_DASH = 31,
  anon_sym_STAR_EQ = 32,
  anon_sym_SLASH_EQ = 33,
  anon_sym_PERCENT_EQ = 34,
  anon_sym_LT_LT_EQ = 35,
  anon_sym_GT_GT_EQ = 36,
  anon_sym_AMP_EQ = 37,
  anon_sym_AMP_CARET_EQ = 38,
  anon_sym_PLUS_EQ = 39,
  anon_sym_DASH_EQ = 40,
  anon_sym_PIPE_EQ = 41,
  anon_sym_CARET_EQ = 42,
  anon_sym_COLON = 43,
  anon_sym_fallthrough = 44,
  anon_sym_break = 45,
  anon_sym_continue = 46,
  anon_sym_goto = 47,
  anon_sym_return = 48,
  anon_sym_go = 49,
  anon_sym_defer = 50,
  anon_sym_if = 51,
  anon_sym_else = 52,
  anon_sym_for = 53,
  anon_sym_range = 54,
  anon_sym_switch = 55,
  anon_sym_case = 56,
  anon_sym_default = 57,
  anon_sym_select = 58,
  anon_sym_new = 59,
  anon_sym_make = 60,
  anon_sym_PLUS = 61,
  anon_sym_DASH = 62,
  anon_sym_BANG = 63,
  anon_sym_CARET = 64,
  anon_sym_AMP = 65,
  anon_sym_SLASH = 66,
  anon_sym_PERCENT = 67,
  anon_sym_LT_LT = 68,
  anon_sym_GT_GT = 69,
  anon_sym_AMP_CARET = 70,
  anon_sym_EQ_EQ = 71,
  anon_sym_BANG_EQ = 72,
  anon_sym_LT = 73,
  anon_sym_LT_EQ = 74,
  anon_sym_GT = 75,
  anon_sym_GT_EQ = 76,
  anon_sym_AMP_AMP = 77,
  anon_sym_PIPE_PIPE = 78,
  sym_raw_string_literal = 79,
  anon_sym_DQUOTE = 80,
  sym__interpreted_string_literal_basic_content = 81,
  sym_escape_sequence = 82,
  sym_int_literal = 83,
  sym_float_literal = 84,
  sym_imaginary_literal = 85,
  sym_rune_literal = 86,
  sym_nil = 87,
  sym_true = 88,
  sym_false = 89,
  sym_iota = 90,
  sym_comment = 91,
  sym_source_file = 92,
  sym_package_clause = 93,
  sym_import_declaration = 94,
  sym_import_spec = 95,
  sym_dot = 96,
  sym_import_spec_list = 97,
  sym__declaration = 98,
  sym_const_declaration = 99,
  sym_const_spec = 100,
  sym_var_declaration = 101,
  sym_var_spec = 102,
  sym_function_declaration = 103,
  sym_method_declaration = 104,
  sym_type_parameter_list = 105,
  sym_parameter_list = 106,
  sym_parameter_declaration = 107,
  sym_variadic_parameter_declaration = 108,
  sym_type_alias = 109,
  sym_type_declaration = 110,
  sym_type_spec = 111,
  sym_expression_list = 112,
  sym_parenthesized_type = 113,
  sym__simple_type = 114,
  sym_generic_type = 115,
  sym_type_arguments = 116,
  sym_pointer_type = 117,
  sym_array_type = 118,
  sym_implicit_length_array_type = 119,
  sym_slice_type = 120,
  sym_struct_type = 121,
  sym_field_declaration_list = 122,
  sym_field_declaration = 123,
  sym_interface_type = 124,
  sym__interface_body = 125,
  sym_interface_type_name = 126,
  sym_constraint_elem = 127,
  sym_constraint_term = 128,
  sym_method_spec = 129,
  sym_map_type = 130,
  sym_channel_type = 131,
  sym_function_type = 132,
  sym_block = 133,
  sym__statement_list = 134,
  sym__statement = 135,
  sym_empty_statement = 136,
  sym__simple_statement = 137,
  sym_send_statement = 138,
  sym_receive_statement = 139,
  sym_inc_statement = 140,
  sym_dec_statement = 141,
  sym_assignment_statement = 142,
  sym_short_var_declaration = 143,
  sym_labeled_statement = 144,
  sym_empty_labeled_statement = 145,
  sym_fallthrough_statement = 146,
  sym_break_statement = 147,
  sym_continue_statement = 148,
  sym_goto_statement = 149,
  sym_return_statement = 150,
  sym_go_statement = 151,
  sym_defer_statement = 152,
  sym_if_statement = 153,
  sym_for_statement = 154,
  sym_for_clause = 155,
  sym_range_clause = 156,
  sym_expression_switch_statement = 157,
  sym_expression_case = 158,
  sym_default_case = 159,
  sym_type_switch_statement = 160,
  sym__type_switch_header = 161,
  sym_type_case = 162,
  sym_select_statement = 163,
  sym_communication_case = 164,
  sym__expression = 165,
  sym_parenthesized_expression = 166,
  sym_call_expression = 167,
  sym_variadic_argument = 168,
  sym_special_argument_list = 169,
  sym_argument_list = 170,
  sym_selector_expression = 171,
  sym_index_expression = 172,
  sym_slice_expression = 173,
  sym_type_assertion_expression = 174,
  sym_type_conversion_expression = 175,
  sym_composite_literal = 176,
  sym_literal_value = 177,
  sym_literal_element = 178,
  sym_keyed_element = 179,
  sym_func_literal = 180,
  sym_unary_expression = 181,
  sym_binary_expression = 182,
  sym_qualified_type = 183,
  sym_interpreted_string_literal = 184,
  aux_sym_source_file_repeat1 = 185,
  aux_sym_import_spec_list_repeat1 = 186,
  aux_sym_const_declaration_repeat1 = 187,
  aux_sym_const_spec_repeat1 = 188,
  aux_sym_var_declaration_repeat1 = 189,
  aux_sym_type_parameter_list_repeat1 = 190,
  aux_sym_parameter_list_repeat1 = 191,
  aux_sym_parameter_declaration_repeat1 = 192,
  aux_sym_type_declaration_repeat1 = 193,
  aux_sym_expression_list_repeat1 = 194,
  aux_sym_type_arguments_repeat1 = 195,
  aux_sym_field_declaration_list_repeat1 = 196,
  aux_sym_field_declaration_repeat1 = 197,
  aux_sym_interface_type_repeat1 = 198,
  aux_sym_constraint_elem_repeat1 = 199,
  aux_sym__statement_list_repeat1 = 200,
  aux_sym_expression_switch_statement_repeat1 = 201,
  aux_sym_type_switch_statement_repeat1 = 202,
  aux_sym_select_statement_repeat1 = 203,
  aux_sym_argument_list_repeat1 = 204,
  aux_sym_literal_value_repeat1 = 205,
  aux_sym_interpreted_string_literal_repeat1 = 206,
  alias_sym_field_identifier = 207,
  alias_sym_label_name = 208,
  alias_sym_package_identifier = 209,
  alias_sym_type_identifier = 210,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [sym_blank_identifier] = "blank_identifier",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_const] = "const",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_var] = "var",
  [anon_sym_func] = "func",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_type] = "type",
  [anon_sym_STAR] = "*",
  [anon_sym_struct] = "struct",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_interface] = "interface",
  [anon_sym_PIPE] = "|",
  [anon_sym_TILDE] = "~",
  [anon_sym_map] = "map",
  [anon_sym_chan] = "chan",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_AMP_CARET_EQ] = "&^=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_COLON] = ":",
  [anon_sym_fallthrough] = "fallthrough",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym_return] = "return",
  [anon_sym_go] = "go",
  [anon_sym_defer] = "defer",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_range] = "range",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_select] = "select",
  [anon_sym_new] = "identifier",
  [anon_sym_make] = "identifier",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_CARET] = "&^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [sym_raw_string_literal] = "raw_string_literal",
  [anon_sym_DQUOTE] = "\"",
  [sym__interpreted_string_literal_basic_content] = "_interpreted_string_literal_basic_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_int_literal] = "int_literal",
  [sym_float_literal] = "float_literal",
  [sym_imaginary_literal] = "imaginary_literal",
  [sym_rune_literal] = "rune_literal",
  [sym_nil] = "nil",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_iota] = "iota",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym_package_clause] = "package_clause",
  [sym_import_declaration] = "import_declaration",
  [sym_import_spec] = "import_spec",
  [sym_dot] = "dot",
  [sym_import_spec_list] = "import_spec_list",
  [sym__declaration] = "_declaration",
  [sym_const_declaration] = "const_declaration",
  [sym_const_spec] = "const_spec",
  [sym_var_declaration] = "var_declaration",
  [sym_var_spec] = "var_spec",
  [sym_function_declaration] = "function_declaration",
  [sym_method_declaration] = "method_declaration",
  [sym_type_parameter_list] = "type_parameter_list",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_variadic_parameter_declaration] = "variadic_parameter_declaration",
  [sym_type_alias] = "type_alias",
  [sym_type_declaration] = "type_declaration",
  [sym_type_spec] = "type_spec",
  [sym_expression_list] = "expression_list",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym__simple_type] = "_simple_type",
  [sym_generic_type] = "generic_type",
  [sym_type_arguments] = "type_arguments",
  [sym_pointer_type] = "pointer_type",
  [sym_array_type] = "array_type",
  [sym_implicit_length_array_type] = "implicit_length_array_type",
  [sym_slice_type] = "slice_type",
  [sym_struct_type] = "struct_type",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym_field_declaration] = "field_declaration",
  [sym_interface_type] = "interface_type",
  [sym__interface_body] = "_interface_body",
  [sym_interface_type_name] = "interface_type_name",
  [sym_constraint_elem] = "constraint_elem",
  [sym_constraint_term] = "constraint_term",
  [sym_method_spec] = "method_spec",
  [sym_map_type] = "map_type",
  [sym_channel_type] = "channel_type",
  [sym_function_type] = "function_type",
  [sym_block] = "block",
  [sym__statement_list] = "_statement_list",
  [sym__statement] = "_statement",
  [sym_empty_statement] = "empty_statement",
  [sym__simple_statement] = "_simple_statement",
  [sym_send_statement] = "send_statement",
  [sym_receive_statement] = "receive_statement",
  [sym_inc_statement] = "inc_statement",
  [sym_dec_statement] = "dec_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_short_var_declaration] = "short_var_declaration",
  [sym_labeled_statement] = "labeled_statement",
  [sym_empty_labeled_statement] = "labeled_statement",
  [sym_fallthrough_statement] = "fallthrough_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_return_statement] = "return_statement",
  [sym_go_statement] = "go_statement",
  [sym_defer_statement] = "defer_statement",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_clause] = "for_clause",
  [sym_range_clause] = "range_clause",
  [sym_expression_switch_statement] = "expression_switch_statement",
  [sym_expression_case] = "expression_case",
  [sym_default_case] = "default_case",
  [sym_type_switch_statement] = "type_switch_statement",
  [sym__type_switch_header] = "_type_switch_header",
  [sym_type_case] = "type_case",
  [sym_select_statement] = "select_statement",
  [sym_communication_case] = "communication_case",
  [sym__expression] = "_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_call_expression] = "call_expression",
  [sym_variadic_argument] = "variadic_argument",
  [sym_special_argument_list] = "argument_list",
  [sym_argument_list] = "argument_list",
  [sym_selector_expression] = "selector_expression",
  [sym_index_expression] = "index_expression",
  [sym_slice_expression] = "slice_expression",
  [sym_type_assertion_expression] = "type_assertion_expression",
  [sym_type_conversion_expression] = "type_conversion_expression",
  [sym_composite_literal] = "composite_literal",
  [sym_literal_value] = "literal_value",
  [sym_literal_element] = "literal_element",
  [sym_keyed_element] = "keyed_element",
  [sym_func_literal] = "func_literal",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_qualified_type] = "qualified_type",
  [sym_interpreted_string_literal] = "interpreted_string_literal",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_import_spec_list_repeat1] = "import_spec_list_repeat1",
  [aux_sym_const_declaration_repeat1] = "const_declaration_repeat1",
  [aux_sym_const_spec_repeat1] = "const_spec_repeat1",
  [aux_sym_var_declaration_repeat1] = "var_declaration_repeat1",
  [aux_sym_type_parameter_list_repeat1] = "type_parameter_list_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_parameter_declaration_repeat1] = "parameter_declaration_repeat1",
  [aux_sym_type_declaration_repeat1] = "type_declaration_repeat1",
  [aux_sym_expression_list_repeat1] = "expression_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_field_declaration_list_repeat1] = "field_declaration_list_repeat1",
  [aux_sym_field_declaration_repeat1] = "field_declaration_repeat1",
  [aux_sym_interface_type_repeat1] = "interface_type_repeat1",
  [aux_sym_constraint_elem_repeat1] = "constraint_elem_repeat1",
  [aux_sym__statement_list_repeat1] = "_statement_list_repeat1",
  [aux_sym_expression_switch_statement_repeat1] = "expression_switch_statement_repeat1",
  [aux_sym_type_switch_statement_repeat1] = "type_switch_statement_repeat1",
  [aux_sym_select_statement_repeat1] = "select_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_literal_value_repeat1] = "literal_value_repeat1",
  [aux_sym_interpreted_string_literal_repeat1] = "interpreted_string_literal_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_label_name] = "label_name",
  [alias_sym_package_identifier] = "package_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_blank_identifier] = sym_blank_identifier,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_map] = anon_sym_map,
  [anon_sym_chan] = anon_sym_chan,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_AMP_CARET_EQ] = anon_sym_AMP_CARET_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_fallthrough] = anon_sym_fallthrough,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_go] = anon_sym_go,
  [anon_sym_defer] = anon_sym_defer,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_range] = anon_sym_range,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_new] = sym_identifier,
  [anon_sym_make] = sym_identifier,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_AMP_CARET] = anon_sym_AMP_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym__interpreted_string_literal_basic_content] = sym__interpreted_string_literal_basic_content,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_int_literal] = sym_int_literal,
  [sym_float_literal] = sym_float_literal,
  [sym_imaginary_literal] = sym_imaginary_literal,
  [sym_rune_literal] = sym_rune_literal,
  [sym_nil] = sym_nil,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_iota] = sym_iota,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym_package_clause] = sym_package_clause,
  [sym_import_declaration] = sym_import_declaration,
  [sym_import_spec] = sym_import_spec,
  [sym_dot] = sym_dot,
  [sym_import_spec_list] = sym_import_spec_list,
  [sym__declaration] = sym__declaration,
  [sym_const_declaration] = sym_const_declaration,
  [sym_const_spec] = sym_const_spec,
  [sym_var_declaration] = sym_var_declaration,
  [sym_var_spec] = sym_var_spec,
  [sym_function_declaration] = sym_function_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [sym_type_parameter_list] = sym_type_parameter_list,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_variadic_parameter_declaration] = sym_variadic_parameter_declaration,
  [sym_type_alias] = sym_type_alias,
  [sym_type_declaration] = sym_type_declaration,
  [sym_type_spec] = sym_type_spec,
  [sym_expression_list] = sym_expression_list,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym__simple_type] = sym__simple_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_pointer_type] = sym_pointer_type,
  [sym_array_type] = sym_array_type,
  [sym_implicit_length_array_type] = sym_implicit_length_array_type,
  [sym_slice_type] = sym_slice_type,
  [sym_struct_type] = sym_struct_type,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym_field_declaration] = sym_field_declaration,
  [sym_interface_type] = sym_interface_type,
  [sym__interface_body] = sym__interface_body,
  [sym_interface_type_name] = sym_interface_type_name,
  [sym_constraint_elem] = sym_constraint_elem,
  [sym_constraint_term] = sym_constraint_term,
  [sym_method_spec] = sym_method_spec,
  [sym_map_type] = sym_map_type,
  [sym_channel_type] = sym_channel_type,
  [sym_function_type] = sym_function_type,
  [sym_block] = sym_block,
  [sym__statement_list] = sym__statement_list,
  [sym__statement] = sym__statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym__simple_statement] = sym__simple_statement,
  [sym_send_statement] = sym_send_statement,
  [sym_receive_statement] = sym_receive_statement,
  [sym_inc_statement] = sym_inc_statement,
  [sym_dec_statement] = sym_dec_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_short_var_declaration] = sym_short_var_declaration,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_empty_labeled_statement] = sym_labeled_statement,
  [sym_fallthrough_statement] = sym_fallthrough_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_go_statement] = sym_go_statement,
  [sym_defer_statement] = sym_defer_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_clause] = sym_for_clause,
  [sym_range_clause] = sym_range_clause,
  [sym_expression_switch_statement] = sym_expression_switch_statement,
  [sym_expression_case] = sym_expression_case,
  [sym_default_case] = sym_default_case,
  [sym_type_switch_statement] = sym_type_switch_statement,
  [sym__type_switch_header] = sym__type_switch_header,
  [sym_type_case] = sym_type_case,
  [sym_select_statement] = sym_select_statement,
  [sym_communication_case] = sym_communication_case,
  [sym__expression] = sym__expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_variadic_argument] = sym_variadic_argument,
  [sym_special_argument_list] = sym_argument_list,
  [sym_argument_list] = sym_argument_list,
  [sym_selector_expression] = sym_selector_expression,
  [sym_index_expression] = sym_index_expression,
  [sym_slice_expression] = sym_slice_expression,
  [sym_type_assertion_expression] = sym_type_assertion_expression,
  [sym_type_conversion_expression] = sym_type_conversion_expression,
  [sym_composite_literal] = sym_composite_literal,
  [sym_literal_value] = sym_literal_value,
  [sym_literal_element] = sym_literal_element,
  [sym_keyed_element] = sym_keyed_element,
  [sym_func_literal] = sym_func_literal,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_qualified_type] = sym_qualified_type,
  [sym_interpreted_string_literal] = sym_interpreted_string_literal,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_import_spec_list_repeat1] = aux_sym_import_spec_list_repeat1,
  [aux_sym_const_declaration_repeat1] = aux_sym_const_declaration_repeat1,
  [aux_sym_const_spec_repeat1] = aux_sym_const_spec_repeat1,
  [aux_sym_var_declaration_repeat1] = aux_sym_var_declaration_repeat1,
  [aux_sym_type_parameter_list_repeat1] = aux_sym_type_parameter_list_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_parameter_declaration_repeat1] = aux_sym_parameter_declaration_repeat1,
  [aux_sym_type_declaration_repeat1] = aux_sym_type_declaration_repeat1,
  [aux_sym_expression_list_repeat1] = aux_sym_expression_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_field_declaration_list_repeat1] = aux_sym_field_declaration_list_repeat1,
  [aux_sym_field_declaration_repeat1] = aux_sym_field_declaration_repeat1,
  [aux_sym_interface_type_repeat1] = aux_sym_interface_type_repeat1,
  [aux_sym_constraint_elem_repeat1] = aux_sym_constraint_elem_repeat1,
  [aux_sym__statement_list_repeat1] = aux_sym__statement_list_repeat1,
  [aux_sym_expression_switch_statement_repeat1] = aux_sym_expression_switch_statement_repeat1,
  [aux_sym_type_switch_statement_repeat1] = aux_sym_type_switch_statement_repeat1,
  [aux_sym_select_statement_repeat1] = aux_sym_select_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_literal_value_repeat1] = aux_sym_literal_value_repeat1,
  [aux_sym_interpreted_string_literal_repeat1] = aux_sym_interpreted_string_literal_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_label_name] = alias_sym_label_name,
  [alias_sym_package_identifier] = alias_sym_package_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_blank_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chan] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallthrough] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_go] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_range] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_make] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__interpreted_string_literal_basic_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_imaginary_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_rune_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_iota] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_package_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_const_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_const_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_var_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_implicit_length_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_type] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_type] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type] = {
    .visible = true,
    .named = true,
  },
  [sym__interface_body] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_elem] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_term] = {
    .visible = true,
    .named = true,
  },
  [sym_method_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_map_type] = {
    .visible = true,
    .named = true,
  },
  [sym_channel_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__statement_list] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_send_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_receive_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_inc_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_dec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_short_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_fallthrough_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_go_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_defer_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_range_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_case] = {
    .visible = true,
    .named = true,
  },
  [sym_default_case] = {
    .visible = true,
    .named = true,
  },
  [sym_type_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__type_switch_header] = {
    .visible = false,
    .named = true,
  },
  [sym_type_case] = {
    .visible = true,
    .named = true,
  },
  [sym_select_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_communication_case] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_special_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_conversion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_composite_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_value] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_element] = {
    .visible = true,
    .named = true,
  },
  [sym_keyed_element] = {
    .visible = true,
    .named = true,
  },
  [sym_func_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_type] = {
    .visible = true,
    .named = true,
  },
  [sym_interpreted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_spec_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_spec_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_var_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constraint_elem_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__statement_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_select_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_literal_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_label_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_package_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_arguments = 3,
  field_body = 4,
  field_capacity = 5,
  field_channel = 6,
  field_communication = 7,
  field_condition = 8,
  field_consequence = 9,
  field_element = 10,
  field_end = 11,
  field_field = 12,
  field_function = 13,
  field_index = 14,
  field_initializer = 15,
  field_key = 16,
  field_label = 17,
  field_left = 18,
  field_length = 19,
  field_name = 20,
  field_operand = 21,
  field_operator = 22,
  field_package = 23,
  field_parameters = 24,
  field_path = 25,
  field_receiver = 26,
  field_result = 27,
  field_right = 28,
  field_start = 29,
  field_tag = 30,
  field_type = 31,
  field_type_arguments = 32,
  field_type_parameters = 33,
  field_update = 34,
  field_value = 35,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_capacity] = "capacity",
  [field_channel] = "channel",
  [field_communication] = "communication",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_element] = "element",
  [field_end] = "end",
  [field_field] = "field",
  [field_function] = "function",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_length] = "length",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_package] = "package",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_receiver] = "receiver",
  [field_result] = "result",
  [field_right] = "right",
  [field_start] = "start",
  [field_tag] = "tag",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 5, .length = 1},
  [9] = {.index = 6, .length = 1},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 2},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 2},
  [15] = {.index = 13, .length = 2},
  [16] = {.index = 15, .length = 2},
  [17] = {.index = 17, .length = 2},
  [18] = {.index = 19, .length = 1},
  [19] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 2},
  [21] = {.index = 24, .length = 2},
  [22] = {.index = 26, .length = 1},
  [23] = {.index = 17, .length = 2},
  [24] = {.index = 19, .length = 1},
  [25] = {.index = 27, .length = 1},
  [26] = {.index = 28, .length = 1},
  [27] = {.index = 29, .length = 2},
  [28] = {.index = 31, .length = 1},
  [29] = {.index = 32, .length = 1},
  [30] = {.index = 33, .length = 2},
  [31] = {.index = 35, .length = 3},
  [32] = {.index = 38, .length = 2},
  [33] = {.index = 40, .length = 2},
  [34] = {.index = 42, .length = 2},
  [35] = {.index = 44, .length = 3},
  [36] = {.index = 47, .length = 2},
  [37] = {.index = 49, .length = 3},
  [38] = {.index = 52, .length = 1},
  [39] = {.index = 53, .length = 3},
  [40] = {.index = 56, .length = 3},
  [41] = {.index = 59, .length = 3},
  [42] = {.index = 62, .length = 3},
  [43] = {.index = 65, .length = 1},
  [44] = {.index = 66, .length = 2},
  [45] = {.index = 68, .length = 2},
  [46] = {.index = 70, .length = 3},
  [47] = {.index = 52, .length = 1},
  [48] = {.index = 73, .length = 2},
  [49] = {.index = 17, .length = 2},
  [50] = {.index = 73, .length = 2},
  [52] = {.index = 75, .length = 2},
  [53] = {.index = 77, .length = 1},
  [54] = {.index = 78, .length = 1},
  [55] = {.index = 79, .length = 1},
  [56] = {.index = 80, .length = 3},
  [57] = {.index = 83, .length = 1},
  [58] = {.index = 84, .length = 2},
  [59] = {.index = 86, .length = 1},
  [60] = {.index = 87, .length = 2},
  [61] = {.index = 89, .length = 3},
  [62] = {.index = 92, .length = 3},
  [63] = {.index = 95, .length = 1},
  [64] = {.index = 68, .length = 2},
  [65] = {.index = 96, .length = 3},
  [66] = {.index = 99, .length = 2},
  [67] = {.index = 101, .length = 4},
  [68] = {.index = 105, .length = 4},
  [69] = {.index = 109, .length = 4},
  [70] = {.index = 113, .length = 4},
  [71] = {.index = 117, .length = 2},
  [72] = {.index = 117, .length = 2},
  [73] = {.index = 95, .length = 1},
  [74] = {.index = 119, .length = 3},
  [75] = {.index = 96, .length = 3},
  [76] = {.index = 122, .length = 3},
  [77] = {.index = 125, .length = 2},
  [78] = {.index = 127, .length = 3},
  [79] = {.index = 130, .length = 3},
  [80] = {.index = 133, .length = 2},
  [81] = {.index = 135, .length = 2},
  [82] = {.index = 137, .length = 2},
  [83] = {.index = 139, .length = 2},
  [84] = {.index = 141, .length = 1},
  [85] = {.index = 142, .length = 1},
  [86] = {.index = 143, .length = 2},
  [87] = {.index = 145, .length = 2},
  [88] = {.index = 147, .length = 2},
  [89] = {.index = 149, .length = 4},
  [90] = {.index = 153, .length = 5},
  [91] = {.index = 158, .length = 5},
  [92] = {.index = 163, .length = 4},
  [93] = {.index = 167, .length = 3},
  [94] = {.index = 170, .length = 2},
  [95] = {.index = 172, .length = 1},
  [96] = {.index = 173, .length = 3},
  [97] = {.index = 176, .length = 4},
  [98] = {.index = 180, .length = 2},
  [99] = {.index = 182, .length = 3},
  [100] = {.index = 185, .length = 2},
  [101] = {.index = 187, .length = 2},
  [102] = {.index = 189, .length = 4},
  [103] = {.index = 193, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_path, 0},
  [1] =
    {field_name, 0},
  [2] =
    {field_parameters, 1},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_value, 1},
  [6] =
    {field_body, 1},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_type, 0},
    {field_type_arguments, 1},
  [11] =
    {field_body, 1},
    {field_type, 0},
  [13] =
    {field_name, 0},
    {field_path, 1},
  [15] =
    {field_name, 0},
    {field_name, 1},
  [17] =
    {field_name, 0},
    {field_type, 1},
  [19] =
    {field_type, 0},
  [20] =
    {field_name, 1},
    {field_parameters, 2},
  [22] =
    {field_parameters, 1},
    {field_result, 2},
  [24] =
    {field_body, 2},
    {field_parameters, 1},
  [26] =
    {field_element, 2},
  [27] =
    {field_label, 0},
  [28] =
    {field_value, 2},
  [29] =
    {field_condition, 1},
    {field_consequence, 2},
  [31] =
    {field_right, 1},
  [32] =
    {field_body, 2},
  [33] =
    {field_name, 2},
    {field_package, 0},
  [35] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [38] =
    {field_left, 0},
    {field_right, 2},
  [40] =
    {field_field, 2},
    {field_operand, 0},
  [42] =
    {field_channel, 0},
    {field_value, 2},
  [44] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [47] =
    {field_name, 0},
    {field_value, 2},
  [49] =
    {field_name, 0},
    {field_name, 1},
    {field_type, 2},
  [52] =
    {field_type, 1},
  [53] =
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [56] =
    {field_name, 1},
    {field_parameters, 2},
    {field_result, 3},
  [59] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [62] =
    {field_body, 3},
    {field_parameters, 1},
    {field_result, 2},
  [65] =
    {field_element, 3},
  [66] =
    {field_element, 3},
    {field_length, 1},
  [68] =
    {field_name, 0},
    {field_type, 2},
  [70] =
    {field_name, 0},
    {field_type, 2},
    {field_type_parameters, 1},
  [73] =
    {field_tag, 1},
    {field_type, 0},
  [75] =
    {field_name, 0},
    {field_parameters, 1},
  [77] =
    {field_update, 2},
  [78] =
    {field_condition, 1},
  [79] =
    {field_initializer, 0},
  [80] =
    {field_alias, 1, .inherited = true},
    {field_initializer, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [83] =
    {field_right, 0},
  [84] =
    {field_operand, 2},
    {field_type, 0},
  [86] =
    {field_operand, 0},
  [87] =
    {field_index, 2},
    {field_operand, 0},
  [89] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 3},
  [92] =
    {field_name, 0},
    {field_name, 1},
    {field_value, 3},
  [95] =
    {field_name, 1},
  [96] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_type, 2},
  [99] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [101] =
    {field_name, 1},
    {field_parameters, 3},
    {field_result, 4},
    {field_type_parameters, 2},
  [105] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [109] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
    {field_result, 3},
  [113] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
  [117] =
    {field_tag, 2},
    {field_type, 1},
  [119] =
    {field_name, 0},
    {field_tag, 2},
    {field_type, 1},
  [122] =
    {field_name, 0},
    {field_parameters, 1},
    {field_result, 2},
  [125] =
    {field_key, 2},
    {field_value, 4},
  [127] =
    {field_condition, 3},
    {field_consequence, 4},
    {field_initializer, 1},
  [130] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [133] =
    {field_condition, 1},
    {field_update, 3},
  [135] =
    {field_left, 0},
    {field_right, 3},
  [137] =
    {field_initializer, 0},
    {field_update, 3},
  [139] =
    {field_condition, 2},
    {field_initializer, 0},
  [141] =
    {field_initializer, 1},
  [142] =
    {field_communication, 1},
  [143] =
    {field_operand, 0},
    {field_type, 3},
  [145] =
    {field_end, 3},
    {field_operand, 0},
  [147] =
    {field_operand, 0},
    {field_start, 2},
  [149] =
    {field_name, 0},
    {field_name, 1},
    {field_type, 2},
    {field_value, 4},
  [153] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_result, 4},
    {field_type_parameters, 2},
  [158] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
    {field_result, 4},
  [163] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_tag, 3},
    {field_type, 2},
  [167] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [170] =
    {field_initializer, 1},
    {field_value, 3},
  [172] =
    {field_value, 0},
  [173] =
    {field_end, 4},
    {field_operand, 0},
    {field_start, 2},
  [176] =
    {field_alternative, 6},
    {field_condition, 3},
    {field_consequence, 4},
    {field_initializer, 1},
  [180] =
    {field_type, 1},
    {field_type, 2},
  [182] =
    {field_capacity, 5},
    {field_end, 3},
    {field_operand, 0},
  [185] =
    {field_alias, 0},
    {field_value, 2},
  [187] =
    {field_initializer, 0},
    {field_value, 2},
  [189] =
    {field_capacity, 6},
    {field_end, 4},
    {field_operand, 0},
    {field_start, 2},
  [193] =
    {field_alias, 2},
    {field_initializer, 0},
    {field_value, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [2] = {
    [1] = alias_sym_package_identifier,
  },
  [8] = {
    [1] = alias_sym_label_name,
  },
  [11] = {
    [0] = alias_sym_type_identifier,
  },
  [12] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [0] = alias_sym_package_identifier,
  },
  [23] = {
    [0] = alias_sym_type_identifier,
  },
  [24] = {
    [0] = alias_sym_type_identifier,
  },
  [25] = {
    [0] = alias_sym_label_name,
  },
  [30] = {
    [0] = alias_sym_package_identifier,
    [2] = alias_sym_type_identifier,
  },
  [33] = {
    [2] = alias_sym_field_identifier,
  },
  [45] = {
    [0] = alias_sym_type_identifier,
  },
  [46] = {
    [0] = alias_sym_type_identifier,
  },
  [47] = {
    [1] = alias_sym_type_identifier,
  },
  [48] = {
    [0] = alias_sym_type_identifier,
  },
  [49] = {
    [0] = alias_sym_field_identifier,
  },
  [51] = {
    [1] = alias_sym_type_identifier,
  },
  [52] = {
    [0] = alias_sym_field_identifier,
  },
  [70] = {
    [2] = alias_sym_field_identifier,
  },
  [71] = {
    [1] = alias_sym_type_identifier,
  },
  [73] = {
    [1] = alias_sym_field_identifier,
  },
  [74] = {
    [0] = alias_sym_field_identifier,
  },
  [75] = {
    [0] = alias_sym_field_identifier,
  },
  [76] = {
    [0] = alias_sym_field_identifier,
  },
  [91] = {
    [2] = alias_sym_field_identifier,
  },
  [92] = {
    [0] = alias_sym_field_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 6688
    ? (c < 2984
      ? (c < 2365
        ? (c < 1488
          ? (c < 886
            ? (c < 216
              ? (c < 181
                ? (c < 'a'
                  ? (c >= 'A' && c <= '_')
                  : (c <= 'z' || c == 170))
                : (c <= 181 || (c < 192
                  ? c == 186
                  : c <= 214)))
              : (c <= 246 || (c < 748
                ? (c < 710
                  ? (c >= 248 && c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))
                : (c <= 748 || (c < 880
                  ? c == 750
                  : c <= 884)))))
            : (c <= 887 || (c < 931
              ? (c < 904
                ? (c < 895
                  ? (c >= 890 && c <= 893)
                  : (c <= 895 || c == 902))
                : (c <= 906 || (c < 910
                  ? c == 908
                  : c <= 929)))
              : (c <= 1013 || (c < 1329
                ? (c < 1162
                  ? (c >= 1015 && c <= 1153)
                  : c <= 1327)
                : (c <= 1366 || (c < 1376
                  ? c == 1369
                  : c <= 1416)))))))
          : (c <= 1514 || (c < 1994
            ? (c < 1774
              ? (c < 1649
                ? (c < 1568
                  ? (c >= 1519 && c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))
                : (c <= 1747 || (c < 1765
                  ? c == 1749
                  : c <= 1766)))
              : (c <= 1775 || (c < 1810
                ? (c < 1791
                  ? (c >= 1786 && c <= 1788)
                  : (c <= 1791 || c == 1808))
                : (c <= 1839 || (c < 1969
                  ? (c >= 1869 && c <= 1957)
                  : c <= 1969)))))
            : (c <= 2026 || (c < 2112
              ? (c < 2074
                ? (c < 2042
                  ? (c >= 2036 && c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2088
                  ? c == 2084
                  : c <= 2088)))
              : (c <= 2136 || (c < 2185
                ? (c < 2160
                  ? (c >= 2144 && c <= 2154)
                  : c <= 2183)
                : (c <= 2190 || (c < 2308
                  ? (c >= 2208 && c <= 2249)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2544
            ? (c < 2474
              ? (c < 2437
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : c <= 2472)))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2654
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : c <= 2652)
                : (c <= 2654 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2869
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2958
              ? (c < 2929
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2949
                  ? c == 2947
                  : c <= 2954)))
              : (c <= 2960 || (c < 2972
                ? (c < 2969
                  ? (c >= 2962 && c <= 2965)
                  : c <= 2970)
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 4176
        ? (c < 3423
          ? (c < 3218
            ? (c < 3133
              ? (c < 3086
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3114
                  ? (c >= 3090 && c <= 3112)
                  : c <= 3129)))
              : (c <= 3133 || (c < 3200
                ? (c < 3165
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3332
              ? (c < 3293
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3313
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3314)))
              : (c <= 3340 || (c < 3389
                ? (c < 3346
                  ? (c >= 3342 && c <= 3344)
                  : c <= 3386)
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3749
            ? (c < 3585
              ? (c < 3507
                ? (c < 3461
                  ? (c >= 3450 && c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3520
                  ? c == 3517
                  : c <= 3526)))
              : (c <= 3632 || (c < 3716
                ? (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : c <= 3747)))))
            : (c <= 3749 || (c < 3840
              ? (c < 3776
                ? (c < 3762
                  ? (c >= 3751 && c <= 3760)
                  : (c <= 3763 || c == 3773))
                : (c <= 3780 || (c < 3804
                  ? c == 3782
                  : c <= 3807)))
              : (c <= 3840 || (c < 3976
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : c <= 3948)
                : (c <= 3980 || (c < 4159
                  ? (c >= 4096 && c <= 4138)
                  : c <= 4159)))))))))
        : (c <= 4181 || (c < 4992
          ? (c < 4696
            ? (c < 4256
              ? (c < 4206
                ? (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))
                : (c <= 4208 || (c < 4238
                  ? (c >= 4213 && c <= 4225)
                  : c <= 4238)))
              : (c <= 4293 || (c < 4348
                ? (c < 4301
                  ? c == 4295
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))
                : (c <= 4680 || (c < 4688
                  ? (c >= 4682 && c <= 4685)
                  : c <= 4694)))))
            : (c <= 4696 || (c < 4800
              ? (c < 4752
                ? (c < 4704
                  ? (c >= 4698 && c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4792
                  ? (c >= 4786 && c <= 4789)
                  : c <= 4798)))
              : (c <= 4800 || (c < 4824
                ? (c < 4808
                  ? (c >= 4802 && c <= 4805)
                  : c <= 4822)
                : (c <= 4880 || (c < 4888
                  ? (c >= 4882 && c <= 4885)
                  : c <= 4954)))))))
          : (c <= 5007 || (c < 6103
            ? (c < 5873
              ? (c < 5743
                ? (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))
                : (c <= 5759 || (c < 5792
                  ? (c >= 5761 && c <= 5786)
                  : c <= 5866)))
              : (c <= 5880 || (c < 5984
                ? (c < 5919
                  ? (c >= 5888 && c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6016
                  ? (c >= 5998 && c <= 6000)
                  : c <= 6067)))))
            : (c <= 6103 || (c < 6400
              ? (c < 6279
                ? (c < 6176
                  ? c == 6108
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))
              : (c <= 6430 || (c < 6528
                ? (c < 6512
                  ? (c >= 6480 && c <= 6509)
                  : c <= 6516)
                : (c <= 6571 || (c < 6656
                  ? (c >= 6576 && c <= 6601)
                  : c <= 6678)))))))))))))
    : (c <= 6740 || (c < 43261
      ? (c < 11264
        ? (c < 8064
          ? (c < 7406
            ? (c < 7168
              ? (c < 7043
                ? (c < 6917
                  ? c == 6823
                  : (c <= 6963 || (c >= 6981 && c <= 6988)))
                : (c <= 7072 || (c < 7098
                  ? (c >= 7086 && c <= 7087)
                  : c <= 7141)))
              : (c <= 7203 || (c < 7312
                ? (c < 7258
                  ? (c >= 7245 && c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))
                : (c <= 7354 || (c < 7401
                  ? (c >= 7357 && c <= 7359)
                  : c <= 7404)))))
            : (c <= 7411 || (c < 8008
              ? (c < 7680
                ? (c < 7418
                  ? (c >= 7413 && c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 7968
                  ? (c >= 7960 && c <= 7965)
                  : c <= 8005)))
              : (c <= 8013 || (c < 8027
                ? (c < 8025
                  ? (c >= 8016 && c <= 8023)
                  : c <= 8025)
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))))))
          : (c <= 8116 || (c < 8455
            ? (c < 8160
              ? (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))
              : (c <= 8172 || (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))))
            : (c <= 8455 || (c < 8490
              ? (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))
              : (c <= 8493 || (c < 8517
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : c <= 8511)
                : (c <= 8521 || (c < 8579
                  ? c == 8526
                  : c <= 8580)))))))))
        : (c <= 11492 || (c < 12704
          ? (c < 11720
            ? (c < 11631
              ? (c < 11559
                ? (c < 11506
                  ? (c >= 11499 && c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : c <= 11623)))
              : (c <= 11631 || (c < 11696
                ? (c < 11680
                  ? (c >= 11648 && c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : c <= 11718)))))
            : (c <= 11726 || (c < 12353
              ? (c < 12293
                ? (c < 11736
                  ? (c >= 11728 && c <= 11734)
                  : (c <= 11742 || c == 11823))
                : (c <= 12294 || (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))
              : (c <= 12438 || (c < 12540
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)
                : (c <= 12543 || (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : c <= 12686)))))))
          : (c <= 12735 || (c < 42786
            ? (c < 42240
              ? (c < 19968
                ? (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : (c <= 13312 || c == 19903))
                : (c <= 19968 || (c < 42192
                  ? (c >= 40959 && c <= 42124)
                  : c <= 42237)))
              : (c <= 42508 || (c < 42623
                ? (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : c <= 42783)))))
            : (c <= 42888 || (c < 43015
              ? (c < 42965
                ? (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : c <= 43013)))
              : (c <= 43018 || (c < 43138
                ? (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)
                : (c <= 43187 || (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : c <= 43259)))))))))))
      : (c <= 43262 || (c < 65345
        ? (c < 43816
          ? (c < 43646
            ? (c < 43494
              ? (c < 43396
                ? (c < 43312
                  ? (c >= 43274 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43488
                  ? c == 43471
                  : c <= 43492)))
              : (c <= 43503 || (c < 43588
                ? (c < 43520
                  ? (c >= 43514 && c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : c <= 43642)))))
            : (c <= 43695 || (c < 43744
              ? (c < 43712
                ? (c < 43701
                  ? c == 43697
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43739
                  ? c == 43714
                  : c <= 43741)))
              : (c <= 43754 || (c < 43785
                ? (c < 43777
                  ? (c >= 43762 && c <= 43764)
                  : c <= 43782)
                : (c <= 43790 || (c < 43808
                  ? (c >= 43793 && c <= 43798)
                  : c <= 43814)))))))
          : (c <= 43822 || (c < 64298
            ? (c < 55243
              ? (c < 44032
                ? (c < 43868
                  ? (c >= 43824 && c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 44032 || (c < 55216
                  ? c == 55203
                  : c <= 55238)))
              : (c <= 55291 || (c < 64275
                ? (c < 64112
                  ? (c >= 63744 && c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))
                : (c <= 64279 || (c < 64287
                  ? c == 64285
                  : c <= 64296)))))
            : (c <= 64310 || (c < 64848
              ? (c < 64323
                ? (c < 64318
                  ? (c >= 64312 && c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : c <= 64829)))
              : (c <= 64911 || (c < 65136
                ? (c < 65008
                  ? (c >= 64914 && c <= 64967)
                  : c <= 65019)
                : (c <= 65140 || (c < 65313
                  ? (c >= 65142 && c <= 65276)
                  : c <= 65338)))))))))
        : (c <= 65370 || (c < 66928
          ? (c < 66208
            ? (c < 65549
              ? (c < 65490
                ? (c < 65474
                  ? (c >= 65382 && c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : c <= 65547)))
              : (c <= 65574 || (c < 65616
                ? (c < 65596
                  ? (c >= 65576 && c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 66176
                  ? (c >= 65664 && c <= 65786)
                  : c <= 66204)))))
            : (c <= 66256 || (c < 66504
              ? (c < 66384
                ? (c < 66349
                  ? (c >= 66304 && c <= 66335)
                  : (c <= 66368 || (c >= 66370 && c <= 66377)))
                : (c <= 66421 || (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : c <= 66499)))
              : (c <= 66511 || (c < 66776
                ? (c < 66736
                  ? (c >= 66560 && c <= 66717)
                  : c <= 66771)
                : (c <= 66811 || (c < 66864
                  ? (c >= 66816 && c <= 66855)
                  : c <= 66915)))))))
          : (c <= 66938 || (c < 67506
            ? (c < 67003
              ? (c < 66967
                ? (c < 66956
                  ? (c >= 66940 && c <= 66954)
                  : (c <= 66962 || (c >= 66964 && c <= 66965)))
                : (c <= 66977 || (c < 66995
                  ? (c >= 66979 && c <= 66993)
                  : c <= 67001)))
              : (c <= 67004 || (c < 67424
                ? (c < 67392
                  ? (c >= 67072 && c <= 67382)
                  : c <= 67413)
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= 'A' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < 'a'
                ? (c < 'A'
                  ? (c >= '0' && c <= '9')
                  : (c <= 'Z' || c == '_'))
                : (c <= 'z' || (c < 181
                  ? c == 170
                  : c <= 181)))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_rune_literal_character_set_1(int32_t c) {
  return (c < 'f'
    ? (c < '\\'
      ? (c < '\''
        ? c == '"'
        : c <= '\'')
      : (c <= '\\' || (c >= 'a' && c <= 'b')))
    : (c <= 'f' || (c < 't'
      ? (c < 'r'
        ? c == 'n'
        : c <= 'r')
      : (c <= 't' || c == 'v'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(60);
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '%') ADVANCE(116);
      if (lookahead == '&') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '+') ADVANCE(101);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(104);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '/') ADVANCE(114);
      if (lookahead == '0') ADVANCE(146);
      if (lookahead == ':') ADVANCE(99);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(130);
      if (lookahead == '[') ADVANCE(72);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(109);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(135);
      if (lookahead == '`') ADVANCE(25);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '~') ADVANCE(82);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(58)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(61);
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(116);
      if (lookahead == '&') ADVANCE(111);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '+') ADVANCE(101);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(104);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(114);
      if (lookahead == ':') ADVANCE(99);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(130);
      if (lookahead == '[') ADVANCE(72);
      if (lookahead == '^') ADVANCE(109);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(135);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(61);
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(115);
      if (lookahead == '&') ADVANCE(112);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(113);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(20);
      if (lookahead == '>') ADVANCE(131);
      if (lookahead == '[') ADVANCE(72);
      if (lookahead == '^') ADVANCE(108);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(135);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(81);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(8)
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(141);
      if (lookahead != 0) ADVANCE(142);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(116);
      if (lookahead == '&') ADVANCE(111);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '+') ADVANCE(101);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(104);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(114);
      if (lookahead == ':') ADVANCE(19);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(130);
      if (lookahead == '[') ADVANCE(72);
      if (lookahead == '^') ADVANCE(109);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(116);
      if (lookahead == '&') ADVANCE(111);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '+') ADVANCE(102);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(105);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(114);
      if (lookahead == ':') ADVANCE(19);
      if (lookahead == '<') ADVANCE(127);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(130);
      if (lookahead == '[') ADVANCE(72);
      if (lookahead == '^') ADVANCE(109);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(115);
      if (lookahead == '&') ADVANCE(112);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(64);
      if (lookahead == '/') ADVANCE(113);
      if (lookahead == ':') ADVANCE(99);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(131);
      if (lookahead == '[') ADVANCE(72);
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(108);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(81);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(115);
      if (lookahead == '&') ADVANCE(112);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(113);
      if (lookahead == ':') ADVANCE(99);
      if (lookahead == '<') ADVANCE(126);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(131);
      if (lookahead == '[') ADVANCE(72);
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(108);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(135);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(81);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      END_STATE();
    case 9:
      if (lookahead == '\'') ADVANCE(156);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(158);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(157);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '-') ADVANCE(83);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(154);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(74);
      END_STATE();
    case 17:
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '_') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(149);
      END_STATE();
    case 18:
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 21:
      if (lookahead == 'U') ADVANCE(55);
      if (lookahead == 'u') ADVANCE(47);
      if (lookahead == 'x') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(145);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 22:
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(9);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(150);
      END_STATE();
    case 24:
      if (lookahead == '_') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(151);
      END_STATE();
    case 25:
      if (lookahead == '`') ADVANCE(136);
      if (lookahead != 0) ADVANCE(25);
      END_STATE();
    case 26:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(152);
      END_STATE();
    case 27:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(26);
      if (lookahead == '_') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(27);
      END_STATE();
    case 28:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(27);
      END_STATE();
    case 29:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(150);
      END_STATE();
    case 30:
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(147);
      END_STATE();
    case 31:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(9);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(151);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(31);
      END_STATE();
    case 34:
      if (sym_rune_literal_character_set_1(lookahead)) ADVANCE(9);
      if (lookahead == 'U') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(48);
      if (lookahead == 'x') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(33);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(15);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(152);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(9);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(143);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(149);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(27);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 57:
      if (eof) ADVANCE(60);
      if (lookahead == '\n') ADVANCE(61);
      if (lookahead == '!') ADVANCE(106);
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '&') ADVANCE(110);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '0') ADVANCE(146);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(13);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '[') ADVANCE(72);
      if (lookahead == '^') ADVANCE(108);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(135);
      if (lookahead == '`') ADVANCE(25);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(79);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(57)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 58:
      if (eof) ADVANCE(60);
      if (lookahead == '!') ADVANCE(107);
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '%') ADVANCE(116);
      if (lookahead == '&') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '+') ADVANCE(101);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(104);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '/') ADVANCE(114);
      if (lookahead == '0') ADVANCE(146);
      if (lookahead == ':') ADVANCE(99);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(130);
      if (lookahead == '[') ADVANCE(72);
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(109);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(135);
      if (lookahead == '`') ADVANCE(25);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '~') ADVANCE(82);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(58)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 59:
      if (eof) ADVANCE(60);
      if (lookahead == '!') ADVANCE(106);
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '&') ADVANCE(110);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '0') ADVANCE(146);
      if (lookahead == ':') ADVANCE(98);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(13);
      if (lookahead == '[') ADVANCE(72);
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(108);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(135);
      if (lookahead == '`') ADVANCE(25);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(59)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(16);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(96);
      if (lookahead == '|') ADVANCE(134);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(134);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_AMP_CARET_EQ);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(85);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '^') ADVANCE(122);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '^') ADVANCE(121);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(158);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead == '=') ADVANCE(88);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(89);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(90);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(91);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_AMP_CARET);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_AMP_CARET);
      if (lookahead == '=') ADVANCE(93);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '<') ADVANCE(118);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '<') ADVANCE(117);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(118);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(117);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(132);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(132);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(135);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_raw_string_literal);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '*') ADVANCE(140);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(142);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '*') ADVANCE(139);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(140);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '*') ADVANCE(139);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(141);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(142);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(154);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(23);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(24);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(17);
      if (lookahead == '_') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(147);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(154);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == '_') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(147);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(154);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == '_') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(28);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(26);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'i') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(149);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'i') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(152);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == '_') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == 'i') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_imaginary_literal);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_rune_literal);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(158);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '_') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'p') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'v') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      ACCEPT_TOKEN(sym_blank_identifier);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(17);
      if (lookahead == 'h') ADVANCE(18);
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(20);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'u') ADVANCE(24);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(26);
      if (lookahead == 'm') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(30);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(32);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(36);
      if (lookahead == 't') ADVANCE(37);
      if (lookahead == 'w') ADVANCE(38);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(39);
      if (lookahead == 'y') ADVANCE(40);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(41);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(45);
      END_STATE();
    case 20:
      if (lookahead == 'f') ADVANCE(46);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(48);
      END_STATE();
    case 23:
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_go);
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 27:
      if (lookahead == 'p') ADVANCE(52);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 30:
      if (lookahead == 'k') ADVANCE(55);
      if (lookahead == 'p') ADVANCE(56);
      END_STATE();
    case 31:
      if (lookahead == 'w') ADVANCE(57);
      END_STATE();
    case 32:
      if (lookahead == 'l') ADVANCE(58);
      END_STATE();
    case 33:
      if (lookahead == 'c') ADVANCE(59);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(62);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(63);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(64);
      END_STATE();
    case 39:
      if (lookahead == 'u') ADVANCE(65);
      END_STATE();
    case 40:
      if (lookahead == 'p') ADVANCE(66);
      END_STATE();
    case 41:
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(68);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 44:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(71);
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(73);
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(76);
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 50:
      if (lookahead == 'c') ADVANCE(78);
      END_STATE();
    case 51:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 52:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(82);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_map);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 59:
      if (lookahead == 'k') ADVANCE(84);
      END_STATE();
    case 60:
      if (lookahead == 'g') ADVANCE(85);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(86);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 63:
      if (lookahead == 'u') ADVANCE(88);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 68:
      if (lookahead == 'k') ADVANCE(92);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_chan);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(93);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 73:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 76:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 81:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_iota);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_make);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 86:
      if (lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(104);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(106);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 94:
      if (lookahead == 'n') ADVANCE(107);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_defer);
      END_STATE();
    case 97:
      if (lookahead == 'h') ADVANCE(109);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 100:
      if (lookahead == 'f') ADVANCE(111);
      END_STATE();
    case 101:
      if (lookahead == 'g') ADVANCE(112);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_range);
      END_STATE();
    case 103:
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(114);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 106:
      if (lookahead == 'h') ADVANCE(116);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(117);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 109:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 119:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 120:
      if (lookahead == 'c') ADVANCE(124);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 123:
      if (lookahead == 'u') ADVANCE(125);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 125:
      if (lookahead == 'g') ADVANCE(127);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 127:
      if (lookahead == 'h') ADVANCE(128);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 59},
  [2] = {.lex_state = 59},
  [3] = {.lex_state = 59},
  [4] = {.lex_state = 59},
  [5] = {.lex_state = 59},
  [6] = {.lex_state = 59},
  [7] = {.lex_state = 59},
  [8] = {.lex_state = 59},
  [9] = {.lex_state = 59},
  [10] = {.lex_state = 59},
  [11] = {.lex_state = 59},
  [12] = {.lex_state = 59},
  [13] = {.lex_state = 59},
  [14] = {.lex_state = 59},
  [15] = {.lex_state = 59},
  [16] = {.lex_state = 59},
  [17] = {.lex_state = 59},
  [18] = {.lex_state = 59},
  [19] = {.lex_state = 59},
  [20] = {.lex_state = 59},
  [21] = {.lex_state = 59},
  [22] = {.lex_state = 59},
  [23] = {.lex_state = 59},
  [24] = {.lex_state = 59},
  [25] = {.lex_state = 59},
  [26] = {.lex_state = 59},
  [27] = {.lex_state = 57},
  [28] = {.lex_state = 57},
  [29] = {.lex_state = 59},
  [30] = {.lex_state = 57},
  [31] = {.lex_state = 57},
  [32] = {.lex_state = 59},
  [33] = {.lex_state = 59},
  [34] = {.lex_state = 59},
  [35] = {.lex_state = 59},
  [36] = {.lex_state = 59},
  [37] = {.lex_state = 59},
  [38] = {.lex_state = 59},
  [39] = {.lex_state = 59},
  [40] = {.lex_state = 59},
  [41] = {.lex_state = 59},
  [42] = {.lex_state = 59},
  [43] = {.lex_state = 59},
  [44] = {.lex_state = 59},
  [45] = {.lex_state = 59},
  [46] = {.lex_state = 59},
  [47] = {.lex_state = 59},
  [48] = {.lex_state = 59},
  [49] = {.lex_state = 59},
  [50] = {.lex_state = 59},
  [51] = {.lex_state = 59},
  [52] = {.lex_state = 59},
  [53] = {.lex_state = 59},
  [54] = {.lex_state = 59},
  [55] = {.lex_state = 59},
  [56] = {.lex_state = 59},
  [57] = {.lex_state = 59},
  [58] = {.lex_state = 59},
  [59] = {.lex_state = 59},
  [60] = {.lex_state = 59},
  [61] = {.lex_state = 59},
  [62] = {.lex_state = 59},
  [63] = {.lex_state = 59},
  [64] = {.lex_state = 59},
  [65] = {.lex_state = 59},
  [66] = {.lex_state = 59},
  [67] = {.lex_state = 59},
  [68] = {.lex_state = 59},
  [69] = {.lex_state = 59},
  [70] = {.lex_state = 59},
  [71] = {.lex_state = 59},
  [72] = {.lex_state = 59},
  [73] = {.lex_state = 59},
  [74] = {.lex_state = 59},
  [75] = {.lex_state = 59},
  [76] = {.lex_state = 59},
  [77] = {.lex_state = 59},
  [78] = {.lex_state = 59},
  [79] = {.lex_state = 59},
  [80] = {.lex_state = 59},
  [81] = {.lex_state = 59},
  [82] = {.lex_state = 59},
  [83] = {.lex_state = 59},
  [84] = {.lex_state = 59},
  [85] = {.lex_state = 59},
  [86] = {.lex_state = 59},
  [87] = {.lex_state = 59},
  [88] = {.lex_state = 59},
  [89] = {.lex_state = 59},
  [90] = {.lex_state = 59},
  [91] = {.lex_state = 59},
  [92] = {.lex_state = 59},
  [93] = {.lex_state = 59},
  [94] = {.lex_state = 59},
  [95] = {.lex_state = 59},
  [96] = {.lex_state = 59},
  [97] = {.lex_state = 59},
  [98] = {.lex_state = 59},
  [99] = {.lex_state = 59},
  [100] = {.lex_state = 59},
  [101] = {.lex_state = 59},
  [102] = {.lex_state = 59},
  [103] = {.lex_state = 59},
  [104] = {.lex_state = 59},
  [105] = {.lex_state = 59},
  [106] = {.lex_state = 59},
  [107] = {.lex_state = 59},
  [108] = {.lex_state = 59},
  [109] = {.lex_state = 59},
  [110] = {.lex_state = 59},
  [111] = {.lex_state = 59},
  [112] = {.lex_state = 59},
  [113] = {.lex_state = 59},
  [114] = {.lex_state = 59},
  [115] = {.lex_state = 59},
  [116] = {.lex_state = 59},
  [117] = {.lex_state = 59},
  [118] = {.lex_state = 59},
  [119] = {.lex_state = 59},
  [120] = {.lex_state = 59},
  [121] = {.lex_state = 59},
  [122] = {.lex_state = 59},
  [123] = {.lex_state = 59},
  [124] = {.lex_state = 59},
  [125] = {.lex_state = 59},
  [126] = {.lex_state = 59},
  [127] = {.lex_state = 59},
  [128] = {.lex_state = 59},
  [129] = {.lex_state = 59},
  [130] = {.lex_state = 59},
  [131] = {.lex_state = 59},
  [132] = {.lex_state = 59},
  [133] = {.lex_state = 59},
  [134] = {.lex_state = 59},
  [135] = {.lex_state = 59},
  [136] = {.lex_state = 59},
  [137] = {.lex_state = 59},
  [138] = {.lex_state = 59},
  [139] = {.lex_state = 59},
  [140] = {.lex_state = 59},
  [141] = {.lex_state = 59},
  [142] = {.lex_state = 59},
  [143] = {.lex_state = 59},
  [144] = {.lex_state = 59},
  [145] = {.lex_state = 59},
  [146] = {.lex_state = 59},
  [147] = {.lex_state = 59},
  [148] = {.lex_state = 59},
  [149] = {.lex_state = 59},
  [150] = {.lex_state = 59},
  [151] = {.lex_state = 59},
  [152] = {.lex_state = 59},
  [153] = {.lex_state = 59},
  [154] = {.lex_state = 59},
  [155] = {.lex_state = 59},
  [156] = {.lex_state = 59},
  [157] = {.lex_state = 59},
  [158] = {.lex_state = 59},
  [159] = {.lex_state = 59},
  [160] = {.lex_state = 59},
  [161] = {.lex_state = 59},
  [162] = {.lex_state = 59},
  [163] = {.lex_state = 59},
  [164] = {.lex_state = 59},
  [165] = {.lex_state = 59},
  [166] = {.lex_state = 59},
  [167] = {.lex_state = 59},
  [168] = {.lex_state = 59},
  [169] = {.lex_state = 59},
  [170] = {.lex_state = 59},
  [171] = {.lex_state = 59},
  [172] = {.lex_state = 59},
  [173] = {.lex_state = 59},
  [174] = {.lex_state = 59},
  [175] = {.lex_state = 59},
  [176] = {.lex_state = 59},
  [177] = {.lex_state = 59},
  [178] = {.lex_state = 59},
  [179] = {.lex_state = 59},
  [180] = {.lex_state = 59},
  [181] = {.lex_state = 59},
  [182] = {.lex_state = 59},
  [183] = {.lex_state = 59},
  [184] = {.lex_state = 59},
  [185] = {.lex_state = 59},
  [186] = {.lex_state = 59},
  [187] = {.lex_state = 59},
  [188] = {.lex_state = 59},
  [189] = {.lex_state = 59},
  [190] = {.lex_state = 59},
  [191] = {.lex_state = 59},
  [192] = {.lex_state = 59},
  [193] = {.lex_state = 59},
  [194] = {.lex_state = 59},
  [195] = {.lex_state = 59},
  [196] = {.lex_state = 59},
  [197] = {.lex_state = 59},
  [198] = {.lex_state = 59},
  [199] = {.lex_state = 59},
  [200] = {.lex_state = 59},
  [201] = {.lex_state = 59},
  [202] = {.lex_state = 59},
  [203] = {.lex_state = 59},
  [204] = {.lex_state = 59},
  [205] = {.lex_state = 59},
  [206] = {.lex_state = 59},
  [207] = {.lex_state = 59},
  [208] = {.lex_state = 59},
  [209] = {.lex_state = 59},
  [210] = {.lex_state = 59},
  [211] = {.lex_state = 59},
  [212] = {.lex_state = 59},
  [213] = {.lex_state = 59},
  [214] = {.lex_state = 59},
  [215] = {.lex_state = 59},
  [216] = {.lex_state = 59},
  [217] = {.lex_state = 59},
  [218] = {.lex_state = 59},
  [219] = {.lex_state = 59},
  [220] = {.lex_state = 59},
  [221] = {.lex_state = 59},
  [222] = {.lex_state = 59},
  [223] = {.lex_state = 59},
  [224] = {.lex_state = 59},
  [225] = {.lex_state = 59},
  [226] = {.lex_state = 59},
  [227] = {.lex_state = 59},
  [228] = {.lex_state = 59},
  [229] = {.lex_state = 59},
  [230] = {.lex_state = 59},
  [231] = {.lex_state = 59},
  [232] = {.lex_state = 59},
  [233] = {.lex_state = 59},
  [234] = {.lex_state = 59},
  [235] = {.lex_state = 57},
  [236] = {.lex_state = 57},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 57},
  [240] = {.lex_state = 57},
  [241] = {.lex_state = 57},
  [242] = {.lex_state = 57},
  [243] = {.lex_state = 57},
  [244] = {.lex_state = 57},
  [245] = {.lex_state = 57},
  [246] = {.lex_state = 57},
  [247] = {.lex_state = 57},
  [248] = {.lex_state = 57},
  [249] = {.lex_state = 57},
  [250] = {.lex_state = 57},
  [251] = {.lex_state = 57},
  [252] = {.lex_state = 57},
  [253] = {.lex_state = 57},
  [254] = {.lex_state = 57},
  [255] = {.lex_state = 57},
  [256] = {.lex_state = 7},
  [257] = {.lex_state = 57},
  [258] = {.lex_state = 57},
  [259] = {.lex_state = 57},
  [260] = {.lex_state = 57},
  [261] = {.lex_state = 57},
  [262] = {.lex_state = 57},
  [263] = {.lex_state = 57},
  [264] = {.lex_state = 57},
  [265] = {.lex_state = 57},
  [266] = {.lex_state = 57},
  [267] = {.lex_state = 57},
  [268] = {.lex_state = 57},
  [269] = {.lex_state = 57},
  [270] = {.lex_state = 57},
  [271] = {.lex_state = 57},
  [272] = {.lex_state = 57},
  [273] = {.lex_state = 57},
  [274] = {.lex_state = 57},
  [275] = {.lex_state = 57},
  [276] = {.lex_state = 57},
  [277] = {.lex_state = 57},
  [278] = {.lex_state = 57},
  [279] = {.lex_state = 57},
  [280] = {.lex_state = 57},
  [281] = {.lex_state = 57},
  [282] = {.lex_state = 57},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 57},
  [285] = {.lex_state = 57},
  [286] = {.lex_state = 57},
  [287] = {.lex_state = 57},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 57},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 59},
  [293] = {.lex_state = 1},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 1},
  [296] = {.lex_state = 1},
  [297] = {.lex_state = 4},
  [298] = {.lex_state = 4},
  [299] = {.lex_state = 1},
  [300] = {.lex_state = 1},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 1},
  [303] = {.lex_state = 1},
  [304] = {.lex_state = 1},
  [305] = {.lex_state = 1},
  [306] = {.lex_state = 1},
  [307] = {.lex_state = 1},
  [308] = {.lex_state = 1},
  [309] = {.lex_state = 1},
  [310] = {.lex_state = 4},
  [311] = {.lex_state = 1},
  [312] = {.lex_state = 1},
  [313] = {.lex_state = 1},
  [314] = {.lex_state = 1},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 1},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 1},
  [319] = {.lex_state = 1},
  [320] = {.lex_state = 1},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 1},
  [323] = {.lex_state = 1},
  [324] = {.lex_state = 1},
  [325] = {.lex_state = 1},
  [326] = {.lex_state = 1},
  [327] = {.lex_state = 1},
  [328] = {.lex_state = 1},
  [329] = {.lex_state = 1},
  [330] = {.lex_state = 1},
  [331] = {.lex_state = 1},
  [332] = {.lex_state = 1},
  [333] = {.lex_state = 1},
  [334] = {.lex_state = 1},
  [335] = {.lex_state = 4},
  [336] = {.lex_state = 4},
  [337] = {.lex_state = 4},
  [338] = {.lex_state = 4},
  [339] = {.lex_state = 4},
  [340] = {.lex_state = 4},
  [341] = {.lex_state = 4},
  [342] = {.lex_state = 4},
  [343] = {.lex_state = 4},
  [344] = {.lex_state = 4},
  [345] = {.lex_state = 4},
  [346] = {.lex_state = 4},
  [347] = {.lex_state = 4},
  [348] = {.lex_state = 4},
  [349] = {.lex_state = 4},
  [350] = {.lex_state = 4},
  [351] = {.lex_state = 4},
  [352] = {.lex_state = 4},
  [353] = {.lex_state = 4},
  [354] = {.lex_state = 4},
  [355] = {.lex_state = 4},
  [356] = {.lex_state = 4},
  [357] = {.lex_state = 4},
  [358] = {.lex_state = 4},
  [359] = {.lex_state = 4},
  [360] = {.lex_state = 4},
  [361] = {.lex_state = 4},
  [362] = {.lex_state = 4},
  [363] = {.lex_state = 4},
  [364] = {.lex_state = 4},
  [365] = {.lex_state = 4},
  [366] = {.lex_state = 4},
  [367] = {.lex_state = 4},
  [368] = {.lex_state = 4},
  [369] = {.lex_state = 4},
  [370] = {.lex_state = 4},
  [371] = {.lex_state = 4},
  [372] = {.lex_state = 4},
  [373] = {.lex_state = 4},
  [374] = {.lex_state = 4},
  [375] = {.lex_state = 4},
  [376] = {.lex_state = 4},
  [377] = {.lex_state = 4},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 5},
  [384] = {.lex_state = 5},
  [385] = {.lex_state = 5},
  [386] = {.lex_state = 5},
  [387] = {.lex_state = 5},
  [388] = {.lex_state = 5},
  [389] = {.lex_state = 5},
  [390] = {.lex_state = 5},
  [391] = {.lex_state = 5},
  [392] = {.lex_state = 5},
  [393] = {.lex_state = 5},
  [394] = {.lex_state = 5},
  [395] = {.lex_state = 5},
  [396] = {.lex_state = 5},
  [397] = {.lex_state = 5},
  [398] = {.lex_state = 5},
  [399] = {.lex_state = 5},
  [400] = {.lex_state = 5},
  [401] = {.lex_state = 5},
  [402] = {.lex_state = 5},
  [403] = {.lex_state = 5},
  [404] = {.lex_state = 5},
  [405] = {.lex_state = 5},
  [406] = {.lex_state = 5},
  [407] = {.lex_state = 5},
  [408] = {.lex_state = 5},
  [409] = {.lex_state = 5},
  [410] = {.lex_state = 5},
  [411] = {.lex_state = 5},
  [412] = {.lex_state = 5},
  [413] = {.lex_state = 5},
  [414] = {.lex_state = 5},
  [415] = {.lex_state = 5},
  [416] = {.lex_state = 5},
  [417] = {.lex_state = 5},
  [418] = {.lex_state = 5},
  [419] = {.lex_state = 5},
  [420] = {.lex_state = 5},
  [421] = {.lex_state = 6},
  [422] = {.lex_state = 6},
  [423] = {.lex_state = 6},
  [424] = {.lex_state = 6},
  [425] = {.lex_state = 6},
  [426] = {.lex_state = 6},
  [427] = {.lex_state = 6},
  [428] = {.lex_state = 6},
  [429] = {.lex_state = 6},
  [430] = {.lex_state = 6},
  [431] = {.lex_state = 6},
  [432] = {.lex_state = 6},
  [433] = {.lex_state = 6},
  [434] = {.lex_state = 6},
  [435] = {.lex_state = 6},
  [436] = {.lex_state = 6},
  [437] = {.lex_state = 6},
  [438] = {.lex_state = 6},
  [439] = {.lex_state = 6},
  [440] = {.lex_state = 6},
  [441] = {.lex_state = 6},
  [442] = {.lex_state = 6},
  [443] = {.lex_state = 6},
  [444] = {.lex_state = 6},
  [445] = {.lex_state = 6},
  [446] = {.lex_state = 6},
  [447] = {.lex_state = 6},
  [448] = {.lex_state = 6},
  [449] = {.lex_state = 6},
  [450] = {.lex_state = 6},
  [451] = {.lex_state = 6},
  [452] = {.lex_state = 6},
  [453] = {.lex_state = 6},
  [454] = {.lex_state = 6},
  [455] = {.lex_state = 6},
  [456] = {.lex_state = 6},
  [457] = {.lex_state = 6},
  [458] = {.lex_state = 6},
  [459] = {.lex_state = 6},
  [460] = {.lex_state = 6},
  [461] = {.lex_state = 2},
  [462] = {.lex_state = 6},
  [463] = {.lex_state = 57},
  [464] = {.lex_state = 2},
  [465] = {.lex_state = 6},
  [466] = {.lex_state = 7},
  [467] = {.lex_state = 57},
  [468] = {.lex_state = 2},
  [469] = {.lex_state = 57},
  [470] = {.lex_state = 2},
  [471] = {.lex_state = 2},
  [472] = {.lex_state = 57},
  [473] = {.lex_state = 2},
  [474] = {.lex_state = 2},
  [475] = {.lex_state = 2},
  [476] = {.lex_state = 7},
  [477] = {.lex_state = 2},
  [478] = {.lex_state = 2},
  [479] = {.lex_state = 6},
  [480] = {.lex_state = 7},
  [481] = {.lex_state = 7},
  [482] = {.lex_state = 7},
  [483] = {.lex_state = 7},
  [484] = {.lex_state = 7},
  [485] = {.lex_state = 2},
  [486] = {.lex_state = 2},
  [487] = {.lex_state = 2},
  [488] = {.lex_state = 7},
  [489] = {.lex_state = 2},
  [490] = {.lex_state = 2},
  [491] = {.lex_state = 6},
  [492] = {.lex_state = 2},
  [493] = {.lex_state = 6},
  [494] = {.lex_state = 2},
  [495] = {.lex_state = 2},
  [496] = {.lex_state = 2},
  [497] = {.lex_state = 2},
  [498] = {.lex_state = 2},
  [499] = {.lex_state = 2},
  [500] = {.lex_state = 6},
  [501] = {.lex_state = 2},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 2},
  [504] = {.lex_state = 6},
  [505] = {.lex_state = 2},
  [506] = {.lex_state = 6},
  [507] = {.lex_state = 2},
  [508] = {.lex_state = 2},
  [509] = {.lex_state = 2},
  [510] = {.lex_state = 2},
  [511] = {.lex_state = 6},
  [512] = {.lex_state = 2},
  [513] = {.lex_state = 2},
  [514] = {.lex_state = 2},
  [515] = {.lex_state = 2},
  [516] = {.lex_state = 2},
  [517] = {.lex_state = 2},
  [518] = {.lex_state = 2},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 6},
  [521] = {.lex_state = 6},
  [522] = {.lex_state = 7},
  [523] = {.lex_state = 6},
  [524] = {.lex_state = 2},
  [525] = {.lex_state = 2},
  [526] = {.lex_state = 6},
  [527] = {.lex_state = 2},
  [528] = {.lex_state = 2},
  [529] = {.lex_state = 2},
  [530] = {.lex_state = 2},
  [531] = {.lex_state = 2},
  [532] = {.lex_state = 2},
  [533] = {.lex_state = 2},
  [534] = {.lex_state = 2},
  [535] = {.lex_state = 2},
  [536] = {.lex_state = 7},
  [537] = {.lex_state = 7},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 6},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 6},
  [542] = {.lex_state = 6},
  [543] = {.lex_state = 6},
  [544] = {.lex_state = 6},
  [545] = {.lex_state = 6},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 6},
  [549] = {.lex_state = 7},
  [550] = {.lex_state = 7},
  [551] = {.lex_state = 7},
  [552] = {.lex_state = 7},
  [553] = {.lex_state = 6},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 7},
  [556] = {.lex_state = 7},
  [557] = {.lex_state = 7},
  [558] = {.lex_state = 7},
  [559] = {.lex_state = 7},
  [560] = {.lex_state = 7},
  [561] = {.lex_state = 7},
  [562] = {.lex_state = 7},
  [563] = {.lex_state = 7},
  [564] = {.lex_state = 7},
  [565] = {.lex_state = 7},
  [566] = {.lex_state = 7},
  [567] = {.lex_state = 7},
  [568] = {.lex_state = 7},
  [569] = {.lex_state = 7},
  [570] = {.lex_state = 7},
  [571] = {.lex_state = 7},
  [572] = {.lex_state = 7},
  [573] = {.lex_state = 7},
  [574] = {.lex_state = 7},
  [575] = {.lex_state = 7},
  [576] = {.lex_state = 7},
  [577] = {.lex_state = 6},
  [578] = {.lex_state = 7},
  [579] = {.lex_state = 7},
  [580] = {.lex_state = 7},
  [581] = {.lex_state = 7},
  [582] = {.lex_state = 6},
  [583] = {.lex_state = 7},
  [584] = {.lex_state = 6},
  [585] = {.lex_state = 6},
  [586] = {.lex_state = 6},
  [587] = {.lex_state = 7},
  [588] = {.lex_state = 6},
  [589] = {.lex_state = 6},
  [590] = {.lex_state = 6},
  [591] = {.lex_state = 6},
  [592] = {.lex_state = 6},
  [593] = {.lex_state = 6},
  [594] = {.lex_state = 6},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 6},
  [597] = {.lex_state = 6},
  [598] = {.lex_state = 6},
  [599] = {.lex_state = 6},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 6},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 6},
  [604] = {.lex_state = 6},
  [605] = {.lex_state = 6},
  [606] = {.lex_state = 6},
  [607] = {.lex_state = 6},
  [608] = {.lex_state = 6},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 6},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 6},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 6},
  [615] = {.lex_state = 6},
  [616] = {.lex_state = 6},
  [617] = {.lex_state = 6},
  [618] = {.lex_state = 6},
  [619] = {.lex_state = 6},
  [620] = {.lex_state = 6},
  [621] = {.lex_state = 6},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 6},
  [624] = {.lex_state = 6},
  [625] = {.lex_state = 6},
  [626] = {.lex_state = 6},
  [627] = {.lex_state = 6},
  [628] = {.lex_state = 6},
  [629] = {.lex_state = 6},
  [630] = {.lex_state = 6},
  [631] = {.lex_state = 6},
  [632] = {.lex_state = 6},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 6},
  [635] = {.lex_state = 6},
  [636] = {.lex_state = 6},
  [637] = {.lex_state = 6},
  [638] = {.lex_state = 6},
  [639] = {.lex_state = 6},
  [640] = {.lex_state = 6},
  [641] = {.lex_state = 6},
  [642] = {.lex_state = 6},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 6},
  [645] = {.lex_state = 6},
  [646] = {.lex_state = 6},
  [647] = {.lex_state = 6},
  [648] = {.lex_state = 57},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 6},
  [651] = {.lex_state = 6},
  [652] = {.lex_state = 6},
  [653] = {.lex_state = 6},
  [654] = {.lex_state = 6},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 6},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 57},
  [742] = {.lex_state = 57},
  [743] = {.lex_state = 57},
  [744] = {.lex_state = 57},
  [745] = {.lex_state = 57},
  [746] = {.lex_state = 57},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 57},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 57},
  [783] = {.lex_state = 57},
  [784] = {.lex_state = 57},
  [785] = {.lex_state = 57},
  [786] = {.lex_state = 57},
  [787] = {.lex_state = 57},
  [788] = {.lex_state = 57},
  [789] = {.lex_state = 57},
  [790] = {.lex_state = 57},
  [791] = {.lex_state = 57},
  [792] = {.lex_state = 57},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 57},
  [795] = {.lex_state = 57},
  [796] = {.lex_state = 57},
  [797] = {.lex_state = 57},
  [798] = {.lex_state = 57},
  [799] = {.lex_state = 57},
  [800] = {.lex_state = 57},
  [801] = {.lex_state = 57},
  [802] = {.lex_state = 57},
  [803] = {.lex_state = 57},
  [804] = {.lex_state = 57},
  [805] = {.lex_state = 57},
  [806] = {.lex_state = 57},
  [807] = {.lex_state = 57},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 57},
  [815] = {.lex_state = 57},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 57},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 57},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 57},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 57},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 57},
  [845] = {.lex_state = 57},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 57},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 57},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 57},
  [856] = {.lex_state = 57},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 57},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 57},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 57},
  [867] = {.lex_state = 57},
  [868] = {.lex_state = 57},
  [869] = {.lex_state = 57},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 57},
  [873] = {.lex_state = 57},
  [874] = {.lex_state = 57},
  [875] = {.lex_state = 57},
  [876] = {.lex_state = 57},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 57},
  [879] = {.lex_state = 57},
  [880] = {.lex_state = 57},
  [881] = {.lex_state = 57},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 57},
  [884] = {.lex_state = 57},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 57},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 57},
  [889] = {.lex_state = 57},
  [890] = {.lex_state = 57},
  [891] = {.lex_state = 57},
  [892] = {.lex_state = 57},
  [893] = {.lex_state = 57},
  [894] = {.lex_state = 57},
  [895] = {.lex_state = 57},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 57},
  [898] = {.lex_state = 57},
  [899] = {.lex_state = 57},
  [900] = {.lex_state = 57},
  [901] = {.lex_state = 57},
  [902] = {.lex_state = 57},
  [903] = {.lex_state = 57},
  [904] = {.lex_state = 57},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 57},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 57},
  [909] = {.lex_state = 57},
  [910] = {.lex_state = 57},
  [911] = {.lex_state = 57},
  [912] = {.lex_state = 57},
  [913] = {.lex_state = 57},
  [914] = {.lex_state = 57},
  [915] = {.lex_state = 57},
  [916] = {.lex_state = 57},
  [917] = {.lex_state = 57},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 57},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 57},
  [922] = {.lex_state = 57},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 57},
  [925] = {.lex_state = 57},
  [926] = {.lex_state = 57},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 57},
  [929] = {.lex_state = 57},
  [930] = {.lex_state = 57},
  [931] = {.lex_state = 57},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 57},
  [934] = {.lex_state = 57},
  [935] = {.lex_state = 57},
  [936] = {.lex_state = 57},
  [937] = {.lex_state = 57},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 57},
  [941] = {.lex_state = 57},
  [942] = {.lex_state = 3},
  [943] = {.lex_state = 57},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 57},
  [946] = {.lex_state = 57},
  [947] = {.lex_state = 57},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 57},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 3},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 57},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 3},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 3},
  [960] = {.lex_state = 57},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 3},
  [963] = {.lex_state = 3},
  [964] = {.lex_state = 3},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 3},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 3},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 3},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 3},
  [977] = {.lex_state = 57},
  [978] = {.lex_state = 3},
  [979] = {.lex_state = 57},
  [980] = {.lex_state = 57},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 57},
  [983] = {.lex_state = 3},
  [984] = {.lex_state = 3},
  [985] = {.lex_state = 3},
  [986] = {.lex_state = 57},
  [987] = {.lex_state = 57},
  [988] = {.lex_state = 57},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 57},
  [1007] = {.lex_state = 57},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 57},
  [1012] = {.lex_state = 57},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 57},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 57},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 57},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 57},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 57},
  [1058] = {.lex_state = 57},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 57},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 57},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 57},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 57},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 57},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 57},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 57},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 57},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 57},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 57},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 57},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 0},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 0},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_blank_identifier] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_map] = ACTIONS(1),
    [anon_sym_chan] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_AMP_CARET_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_fallthrough] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_go] = ACTIONS(1),
    [anon_sym_defer] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_range] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_make] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [sym_raw_string_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_float_literal] = ACTIONS(1),
    [sym_imaginary_literal] = ACTIONS(1),
    [sym_rune_literal] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_iota] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(1213),
    [sym_package_clause] = STATE(263),
    [sym_import_declaration] = STATE(263),
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_function_declaration] = STATE(263),
    [sym_method_declaration] = STATE(263),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement] = STATE(1130),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_package] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_package_clause] = STATE(263),
    [sym_import_declaration] = STATE(263),
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_function_declaration] = STATE(263),
    [sym_method_declaration] = STATE(263),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement] = STATE(1130),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(73),
    [sym_identifier] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(78),
    [anon_sym_package] = ACTIONS(81),
    [anon_sym_import] = ACTIONS(84),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_const] = ACTIONS(90),
    [anon_sym_var] = ACTIONS(93),
    [anon_sym_func] = ACTIONS(96),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_type] = ACTIONS(102),
    [anon_sym_STAR] = ACTIONS(105),
    [anon_sym_struct] = ACTIONS(108),
    [anon_sym_LBRACE] = ACTIONS(111),
    [anon_sym_interface] = ACTIONS(114),
    [anon_sym_map] = ACTIONS(117),
    [anon_sym_chan] = ACTIONS(120),
    [anon_sym_LT_DASH] = ACTIONS(123),
    [anon_sym_fallthrough] = ACTIONS(126),
    [anon_sym_break] = ACTIONS(129),
    [anon_sym_continue] = ACTIONS(132),
    [anon_sym_goto] = ACTIONS(135),
    [anon_sym_return] = ACTIONS(138),
    [anon_sym_go] = ACTIONS(141),
    [anon_sym_defer] = ACTIONS(144),
    [anon_sym_if] = ACTIONS(147),
    [anon_sym_for] = ACTIONS(150),
    [anon_sym_switch] = ACTIONS(153),
    [anon_sym_select] = ACTIONS(156),
    [anon_sym_new] = ACTIONS(159),
    [anon_sym_make] = ACTIONS(159),
    [anon_sym_PLUS] = ACTIONS(162),
    [anon_sym_DASH] = ACTIONS(162),
    [anon_sym_BANG] = ACTIONS(162),
    [anon_sym_CARET] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(162),
    [sym_raw_string_literal] = ACTIONS(165),
    [anon_sym_DQUOTE] = ACTIONS(168),
    [sym_int_literal] = ACTIONS(171),
    [sym_float_literal] = ACTIONS(171),
    [sym_imaginary_literal] = ACTIONS(165),
    [sym_rune_literal] = ACTIONS(165),
    [sym_nil] = ACTIONS(171),
    [sym_true] = ACTIONS(171),
    [sym_false] = ACTIONS(171),
    [sym_iota] = ACTIONS(171),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_package_clause] = STATE(263),
    [sym_import_declaration] = STATE(263),
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_function_declaration] = STATE(263),
    [sym_method_declaration] = STATE(263),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement] = STATE(1130),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(174),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_package] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(1036),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1036),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(180),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(182),
    [anon_sym_default] = ACTIONS(182),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(1005),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1005),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(184),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(186),
    [anon_sym_default] = ACTIONS(186),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(996),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(996),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(188),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(190),
    [anon_sym_default] = ACTIONS(190),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(998),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(998),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(192),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(194),
    [anon_sym_default] = ACTIONS(194),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(995),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(995),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(196),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(198),
    [anon_sym_default] = ACTIONS(198),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement] = STATE(879),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1048),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(200),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(202),
    [anon_sym_default] = ACTIONS(202),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement] = STATE(879),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1088),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(204),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(206),
    [anon_sym_default] = ACTIONS(206),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(1231),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1231),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(208),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(1221),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1221),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(210),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(1163),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1163),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(212),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(1187),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1187),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(214),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement] = STATE(901),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(216),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(218),
    [anon_sym_default] = ACTIONS(218),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(1236),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1236),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(220),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(1179),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1179),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement_list] = STATE(1181),
    [sym__statement] = STATE(838),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_empty_labeled_statement] = STATE(1181),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement] = STATE(901),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__declaration] = STATE(910),
    [sym_const_declaration] = STATE(910),
    [sym_var_declaration] = STATE(910),
    [sym_type_declaration] = STATE(910),
    [sym_expression_list] = STATE(756),
    [sym_parenthesized_type] = STATE(1204),
    [sym__simple_type] = STATE(1204),
    [sym_generic_type] = STATE(1001),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1001),
    [sym_implicit_length_array_type] = STATE(1129),
    [sym_slice_type] = STATE(1001),
    [sym_struct_type] = STATE(1001),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1001),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(910),
    [sym__statement] = STATE(879),
    [sym_empty_statement] = STATE(910),
    [sym__simple_statement] = STATE(910),
    [sym_send_statement] = STATE(914),
    [sym_inc_statement] = STATE(914),
    [sym_dec_statement] = STATE(914),
    [sym_assignment_statement] = STATE(914),
    [sym_short_var_declaration] = STATE(914),
    [sym_labeled_statement] = STATE(910),
    [sym_fallthrough_statement] = STATE(910),
    [sym_break_statement] = STATE(910),
    [sym_continue_statement] = STATE(910),
    [sym_goto_statement] = STATE(910),
    [sym_return_statement] = STATE(910),
    [sym_go_statement] = STATE(910),
    [sym_defer_statement] = STATE(910),
    [sym_if_statement] = STATE(910),
    [sym_for_statement] = STATE(910),
    [sym_expression_switch_statement] = STATE(910),
    [sym_type_switch_statement] = STATE(910),
    [sym_select_statement] = STATE(910),
    [sym__expression] = STATE(283),
    [sym_parenthesized_expression] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_selector_expression] = STATE(316),
    [sym_index_expression] = STATE(316),
    [sym_slice_expression] = STATE(316),
    [sym_type_assertion_expression] = STATE(316),
    [sym_type_conversion_expression] = STATE(316),
    [sym_composite_literal] = STATE(316),
    [sym_func_literal] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_qualified_type] = STATE(1001),
    [sym_interpreted_string_literal] = STATE(316),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_iota] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_expression_list] = STATE(754),
    [sym_parenthesized_type] = STATE(1244),
    [sym__simple_type] = STATE(1244),
    [sym_generic_type] = STATE(1055),
    [sym_pointer_type] = STATE(836),
    [sym_array_type] = STATE(1055),
    [sym_implicit_length_array_type] = STATE(1150),
    [sym_slice_type] = STATE(1055),
    [sym_struct_type] = STATE(1055),
    [sym_interface_type] = STATE(836),
    [sym_map_type] = STATE(1055),
    [sym_channel_type] = STATE(836),
    [sym_function_type] = STATE(836),
    [sym_block] = STATE(929),
    [sym__simple_statement] = STATE(1202),
    [sym_send_statement] = STATE(1121),
    [sym_inc_statement] = STATE(1121),
    [sym_dec_statement] = STATE(1121),
    [sym_assignment_statement] = STATE(1121),
    [sym_short_var_declaration] = STATE(1121),
    [sym_for_clause] = STATE(1128),
    [sym_range_clause] = STATE(1128),
    [sym__expression] = STATE(297),
    [sym_parenthesized_expression] = STATE(369),
    [sym_call_expression] = STATE(369),
    [sym_selector_expression] = STATE(369),
    [sym_index_expression] = STATE(369),
    [sym_slice_expression] = STATE(369),
    [sym_type_assertion_expression] = STATE(369),
    [sym_type_conversion_expression] = STATE(369),
    [sym_composite_literal] = STATE(369),
    [sym_func_literal] = STATE(369),
    [sym_unary_expression] = STATE(369),
    [sym_binary_expression] = STATE(369),
    [sym_qualified_type] = STATE(1055),
    [sym_interpreted_string_literal] = STATE(369),
    [sym_identifier] = ACTIONS(226),
    [anon_sym_SEMI] = ACTIONS(228),
    [anon_sym_LPAREN] = ACTIONS(230),
    [anon_sym_func] = ACTIONS(232),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(234),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(236),
    [anon_sym_range] = ACTIONS(238),
    [anon_sym_new] = ACTIONS(240),
    [anon_sym_make] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(242),
    [anon_sym_DASH] = ACTIONS(242),
    [anon_sym_BANG] = ACTIONS(242),
    [anon_sym_CARET] = ACTIONS(242),
    [anon_sym_AMP] = ACTIONS(242),
    [sym_raw_string_literal] = ACTIONS(244),
    [anon_sym_DQUOTE] = ACTIONS(246),
    [sym_int_literal] = ACTIONS(248),
    [sym_float_literal] = ACTIONS(248),
    [sym_imaginary_literal] = ACTIONS(244),
    [sym_rune_literal] = ACTIONS(244),
    [sym_nil] = ACTIONS(248),
    [sym_true] = ACTIONS(248),
    [sym_false] = ACTIONS(248),
    [sym_iota] = ACTIONS(248),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(250), 1,
      anon_sym_LBRACE,
    STATE(310), 1,
      sym__expression,
    STATE(755), 1,
      sym_expression_list,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    STATE(1222), 1,
      sym__simple_statement,
    STATE(1224), 1,
      sym__type_switch_header,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1121), 5,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [118] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(252), 1,
      anon_sym_LBRACE,
    STATE(342), 1,
      sym__expression,
    STATE(758), 1,
      sym_expression_list,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    STATE(1235), 1,
      sym__simple_statement,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1121), 5,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [233] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(254), 1,
      anon_sym_LBRACE,
    STATE(342), 1,
      sym__expression,
    STATE(758), 1,
      sym_expression_list,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    STATE(1168), 1,
      sym__simple_statement,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1121), 5,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [348] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_LBRACE,
    STATE(342), 1,
      sym__expression,
    STATE(758), 1,
      sym_expression_list,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    STATE(1195), 1,
      sym__simple_statement,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1121), 5,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [463] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    STATE(342), 1,
      sym__expression,
    STATE(758), 1,
      sym_expression_list,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    STATE(1167), 1,
      sym__simple_statement,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1121), 5,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [578] = 17,
    ACTIONS(262), 1,
      sym_identifier,
    ACTIONS(266), 1,
      anon_sym_LPAREN,
    ACTIONS(268), 1,
      anon_sym_func,
    ACTIONS(270), 1,
      anon_sym_LBRACK,
    ACTIONS(272), 1,
      anon_sym_STAR,
    ACTIONS(274), 1,
      anon_sym_struct,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(278), 1,
      anon_sym_interface,
    ACTIONS(280), 1,
      anon_sym_map,
    ACTIONS(282), 1,
      anon_sym_chan,
    ACTIONS(284), 1,
      anon_sym_LT_DASH,
    ACTIONS(286), 1,
      sym_comment,
    STATE(242), 1,
      sym_block,
    ACTIONS(260), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(236), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(260), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
    ACTIONS(264), 34,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_const,
      anon_sym_var,
      anon_sym_type,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [674] = 17,
    ACTIONS(262), 1,
      sym_identifier,
    ACTIONS(266), 1,
      anon_sym_LPAREN,
    ACTIONS(268), 1,
      anon_sym_func,
    ACTIONS(270), 1,
      anon_sym_LBRACK,
    ACTIONS(272), 1,
      anon_sym_STAR,
    ACTIONS(274), 1,
      anon_sym_struct,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(278), 1,
      anon_sym_interface,
    ACTIONS(280), 1,
      anon_sym_map,
    ACTIONS(282), 1,
      anon_sym_chan,
    ACTIONS(284), 1,
      anon_sym_LT_DASH,
    ACTIONS(286), 1,
      sym_comment,
    STATE(289), 1,
      sym_block,
    ACTIONS(288), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(239), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(260), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
    ACTIONS(290), 34,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_const,
      anon_sym_var,
      anon_sym_type,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [770] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(298), 1,
      sym__expression,
    STATE(753), 1,
      sym_expression_list,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    STATE(1191), 1,
      sym__simple_statement,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1121), 5,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [882] = 24,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(294), 1,
      anon_sym_LF,
    ACTIONS(298), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    ACTIONS(304), 1,
      anon_sym_STAR,
    ACTIONS(306), 1,
      anon_sym_LT_DASH,
    ACTIONS(314), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(909), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(296), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(310), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    ACTIONS(312), 9,
      sym_raw_string_literal,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [991] = 15,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(318), 1,
      sym_identifier,
    ACTIONS(323), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(329), 1,
      anon_sym_LBRACK,
    ACTIONS(332), 1,
      anon_sym_STAR,
    ACTIONS(335), 1,
      anon_sym_struct,
    ACTIONS(338), 1,
      anon_sym_interface,
    ACTIONS(341), 1,
      anon_sym_map,
    ACTIONS(344), 1,
      anon_sym_chan,
    ACTIONS(347), 1,
      anon_sym_LT_DASH,
    ACTIONS(316), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(284), 2,
      sym_parameter_list,
      sym__simple_type,
    STATE(260), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
    ACTIONS(321), 35,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_const,
      anon_sym_var,
      anon_sym_type,
      anon_sym_LBRACE,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [1082] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(354), 1,
      anon_sym_COMMA,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(362), 1,
      anon_sym_RBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(545), 1,
      sym__expression,
    STATE(939), 1,
      sym_literal_element,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1084), 1,
      sym_keyed_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1199] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(376), 1,
      anon_sym_COMMA,
    ACTIONS(378), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(973), 1,
      sym_literal_element,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1073), 1,
      sym_keyed_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1316] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(380), 1,
      anon_sym_COMMA,
    ACTIONS(382), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(954), 1,
      sym_literal_element,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1017), 1,
      sym_keyed_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1433] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(384), 1,
      anon_sym_COMMA,
    ACTIONS(386), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(958), 1,
      sym_literal_element,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1052), 1,
      sym_keyed_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1550] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      anon_sym_COMMA,
    ACTIONS(390), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(944), 1,
      sym_literal_element,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1040), 1,
      sym_keyed_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1667] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(392), 1,
      anon_sym_COMMA,
    ACTIONS(394), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(969), 1,
      sym_literal_element,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1003), 1,
      sym_keyed_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1784] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(396), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1898] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(398), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2012] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(400), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2126] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2240] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(404), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2354] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2468] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(408), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2582] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(410), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2696] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(412), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2810] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2924] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3038] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(418), 1,
      anon_sym_RBRACE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3152] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1029), 1,
      sym_literal_element,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_keyed_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3263] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(545), 1,
      sym__expression,
    STATE(1002), 1,
      sym_literal_value,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1151), 1,
      sym_literal_element,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3371] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(466), 1,
      sym__expression,
    STATE(1140), 1,
      sym_implicit_length_array_type,
    STATE(1143), 1,
      sym_expression_list,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1225), 2,
      sym_send_statement,
      sym_receive_statement,
    STATE(1246), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(434), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(438), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1060), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(550), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3477] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(444), 1,
      anon_sym_LBRACE,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(520), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1232), 1,
      sym_expression_list,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3582] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(450), 1,
      anon_sym_range,
    STATE(526), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1104), 1,
      sym_expression_list,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3687] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(454), 1,
      anon_sym_RPAREN,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(504), 1,
      sym__expression,
    STATE(1010), 1,
      sym_variadic_argument,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3792] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(462), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3897] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      anon_sym_RBRACK,
    ACTIONS(466), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(637), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4002] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(468), 1,
      anon_sym_RPAREN,
    STATE(523), 1,
      sym__expression,
    STATE(1079), 1,
      sym_variadic_argument,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4107] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(470), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4212] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(472), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4317] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(474), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4422] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(476), 1,
      anon_sym_RPAREN,
    STATE(521), 1,
      sym__expression,
    STATE(1076), 1,
      sym_variadic_argument,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4527] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(478), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4632] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(480), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4737] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(482), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4842] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(484), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4947] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(486), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5052] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(488), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5157] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(490), 1,
      sym_identifier,
    ACTIONS(492), 1,
      anon_sym_RBRACK,
    ACTIONS(494), 1,
      anon_sym_STAR,
    STATE(636), 1,
      sym__expression,
    STATE(1077), 1,
      sym_parameter_declaration,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1085), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5262] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(496), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5367] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(498), 1,
      anon_sym_RPAREN,
    STATE(506), 1,
      sym__expression,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5472] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(500), 1,
      anon_sym_RPAREN,
    STATE(491), 1,
      sym__expression,
    STATE(1020), 1,
      sym_variadic_argument,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5577] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(450), 1,
      anon_sym_range,
    STATE(526), 1,
      sym__expression,
    STATE(1097), 1,
      sym_expression_list,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5682] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(502), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5787] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(504), 1,
      anon_sym_RPAREN,
    STATE(493), 1,
      sym__expression,
    STATE(1039), 1,
      sym_variadic_argument,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5892] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(494), 1,
      anon_sym_STAR,
    ACTIONS(506), 1,
      sym_identifier,
    ACTIONS(508), 1,
      anon_sym_COLON,
    STATE(606), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(961), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5994] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(510), 1,
      anon_sym_RBRACK,
    STATE(615), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6096] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(512), 1,
      anon_sym_SEMI,
    STATE(650), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6198] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(548), 1,
      sym__expression,
    STATE(1097), 1,
      sym_expression_list,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6300] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(514), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6402] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(516), 1,
      anon_sym_RBRACK,
    STATE(631), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6504] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(518), 1,
      anon_sym_RBRACK,
    STATE(619), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6606] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(548), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1104), 1,
      sym_expression_list,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6708] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(520), 1,
      anon_sym_RBRACK,
    STATE(601), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6810] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      anon_sym_RBRACK,
    STATE(637), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6912] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(494), 1,
      anon_sym_STAR,
    ACTIONS(506), 1,
      sym_identifier,
    ACTIONS(522), 1,
      anon_sym_RBRACK,
    STATE(645), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(961), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7014] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(524), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7116] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      anon_sym_RBRACK,
    STATE(645), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7218] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(494), 1,
      anon_sym_STAR,
    ACTIONS(506), 1,
      sym_identifier,
    ACTIONS(526), 1,
      anon_sym_COLON,
    STATE(608), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(961), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7320] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7422] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(899), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7524] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(540), 1,
      anon_sym_RBRACK,
    STATE(610), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7626] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(542), 1,
      anon_sym_RBRACK,
    STATE(597), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7728] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(544), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7830] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(526), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1188), 1,
      sym_expression_list,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7932] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(546), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8034] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(548), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8136] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(898), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8238] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(550), 1,
      anon_sym_SEMI,
    STATE(630), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8340] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(526), 1,
      sym__expression,
    STATE(1097), 1,
      sym_expression_list,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8442] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(552), 1,
      anon_sym_RBRACK,
    STATE(598), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8544] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(554), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8646] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(556), 1,
      anon_sym_RBRACK,
    STATE(621), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8748] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(908), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8850] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(912), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8952] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(577), 1,
      sym__expression,
    STATE(1097), 1,
      sym_expression_list,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9054] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(494), 1,
      anon_sym_STAR,
    ACTIONS(506), 1,
      sym_identifier,
    ACTIONS(558), 1,
      anon_sym_COLON,
    STATE(592), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(961), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9156] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(560), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9258] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(494), 1,
      anon_sym_STAR,
    ACTIONS(506), 1,
      sym_identifier,
    ACTIONS(562), 1,
      anon_sym_COLON,
    STATE(612), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(961), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9360] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(916), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9462] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      anon_sym_RBRACK,
    STATE(588), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9564] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(566), 1,
      anon_sym_RBRACK,
    STATE(593), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9666] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(568), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9768] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(570), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9870] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(572), 1,
      anon_sym_RBRACK,
    STATE(594), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9972] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(494), 1,
      anon_sym_STAR,
    ACTIONS(506), 1,
      sym_identifier,
    ACTIONS(574), 1,
      anon_sym_COLON,
    STATE(603), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(961), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10074] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(576), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10176] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(578), 1,
      anon_sym_RBRACK,
    STATE(614), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10278] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(872), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10380] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(580), 1,
      anon_sym_RBRACK,
    STATE(596), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10482] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(582), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10584] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(584), 1,
      anon_sym_RPAREN,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10686] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(902), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10788] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(904), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10890] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(539), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1148), 1,
      sym_variadic_argument,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10992] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(906), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11094] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(494), 1,
      anon_sym_STAR,
    ACTIONS(506), 1,
      sym_identifier,
    ACTIONS(586), 1,
      anon_sym_COLON,
    STATE(618), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(961), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11196] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      sym__expression,
    STATE(873), 1,
      sym_expression_list,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11298] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(526), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    STATE(1104), 1,
      sym_expression_list,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11400] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(486), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11499] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(624), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11598] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(588), 1,
      sym_identifier,
    STATE(294), 1,
      sym__expression,
    STATE(1129), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1204), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(67), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(71), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1001), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(316), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11697] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(582), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11796] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      anon_sym_chan,
    STATE(341), 1,
      sym__expression,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11895] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(422), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11994] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(588), 1,
      sym_identifier,
    STATE(293), 1,
      sym__expression,
    STATE(1129), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1204), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(67), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(71), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1001), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(316), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12093] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(588), 1,
      sym_identifier,
    STATE(291), 1,
      sym__expression,
    STATE(1129), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1204), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(67), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(71), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1001), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(316), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12192] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(588), 1,
      sym_identifier,
    STATE(290), 1,
      sym__expression,
    STATE(1129), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1204), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(67), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(71), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1001), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(316), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12291] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(341), 1,
      sym__expression,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(950), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12390] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(592), 1,
      anon_sym_STAR,
    STATE(627), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1094), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12489] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_LPAREN,
    ACTIONS(598), 1,
      anon_sym_func,
    ACTIONS(600), 1,
      anon_sym_STAR,
    ACTIONS(602), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    STATE(379), 1,
      sym__expression,
    STATE(1105), 1,
      sym_implicit_length_array_type,
    ACTIONS(604), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1245), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(608), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(606), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(612), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1091), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(390), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12588] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1140), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1246), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(434), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(438), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1060), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(550), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12687] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(484), 1,
      sym__expression,
    STATE(1140), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1246), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(434), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(438), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1060), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(550), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12786] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(479), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12885] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(634), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12984] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(488), 1,
      sym__expression,
    STATE(1140), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1246), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(434), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(438), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1060), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(550), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13083] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(480), 1,
      sym__expression,
    STATE(1140), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1246), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(434), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(438), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1060), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(550), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13182] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(482), 1,
      sym__expression,
    STATE(1140), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1246), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(434), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(438), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1060), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(550), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13281] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(592), 1,
      anon_sym_STAR,
    STATE(628), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1094), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13380] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      anon_sym_chan,
    STATE(483), 1,
      sym__expression,
    STATE(1140), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1246), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(434), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(438), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1060), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(550), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13479] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(589), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13578] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(592), 1,
      anon_sym_STAR,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(950), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13677] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(460), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13776] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(626), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13875] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(475), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13974] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(590), 1,
      anon_sym_chan,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14073] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(471), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14172] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(485), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14271] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(462), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14370] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(468), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14469] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(470), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14568] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(625), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14667] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(459), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14766] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(465), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14865] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(422), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14964] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(620), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15063] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(477), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15162] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15261] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(616), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15360] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(592), 1,
      anon_sym_STAR,
    STATE(646), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1094), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15459] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(641), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15558] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(607), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15657] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      anon_sym_chan,
    STATE(474), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15756] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(483), 1,
      sym__expression,
    STATE(1140), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1246), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(434), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(438), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1060), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(550), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15855] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(647), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15954] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(474), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(950), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16053] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(651), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16152] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(592), 1,
      anon_sym_STAR,
    STATE(639), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1094), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16251] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(588), 1,
      sym_identifier,
    STATE(296), 1,
      sym__expression,
    STATE(1129), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(950), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(67), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(71), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1001), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(316), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16350] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(629), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16449] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(483), 1,
      sym__expression,
    STATE(1140), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(950), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(434), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(438), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1060), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(550), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16548] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(473), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16647] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(494), 1,
      anon_sym_STAR,
    ACTIONS(506), 1,
      sym_identifier,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(950), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16746] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(592), 1,
      anon_sym_STAR,
    STATE(640), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1094), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16845] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_LPAREN,
    ACTIONS(598), 1,
      anon_sym_func,
    ACTIONS(600), 1,
      anon_sym_STAR,
    ACTIONS(602), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    STATE(385), 1,
      sym__expression,
    STATE(1105), 1,
      sym_implicit_length_array_type,
    ACTIONS(604), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1245), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(608), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(606), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(612), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1091), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(390), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16944] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(341), 1,
      sym__expression,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17043] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_LPAREN,
    ACTIONS(598), 1,
      anon_sym_func,
    ACTIONS(600), 1,
      anon_sym_STAR,
    ACTIONS(602), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    STATE(384), 1,
      sym__expression,
    STATE(1105), 1,
      sym_implicit_length_array_type,
    ACTIONS(604), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1245), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(608), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(606), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(612), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1091), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(390), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17142] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(635), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17241] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_LPAREN,
    ACTIONS(598), 1,
      anon_sym_func,
    ACTIONS(600), 1,
      anon_sym_STAR,
    ACTIONS(602), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    STATE(382), 1,
      sym__expression,
    STATE(1105), 1,
      sym_implicit_length_array_type,
    ACTIONS(604), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(950), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(608), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(606), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(612), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1091), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(390), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17340] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(604), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17439] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(590), 1,
      anon_sym_chan,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_LPAREN,
    ACTIONS(598), 1,
      anon_sym_func,
    ACTIONS(600), 1,
      anon_sym_STAR,
    ACTIONS(602), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    STATE(382), 1,
      sym__expression,
    STATE(1105), 1,
      sym_implicit_length_array_type,
    ACTIONS(604), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1245), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(608), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(606), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(612), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1091), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(390), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17538] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(652), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17637] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(950), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17736] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(623), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17835] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(590), 1,
      anon_sym_chan,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17934] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(950), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18033] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(599), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18132] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    ACTIONS(592), 1,
      anon_sym_STAR,
    STATE(653), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1094), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18231] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(336), 1,
      sym__expression,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18330] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(337), 1,
      sym__expression,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18429] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_LPAREN,
    ACTIONS(598), 1,
      anon_sym_func,
    ACTIONS(600), 1,
      anon_sym_STAR,
    ACTIONS(602), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    STATE(383), 1,
      sym__expression,
    STATE(1105), 1,
      sym_implicit_length_array_type,
    ACTIONS(604), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1245), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(608), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(606), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(612), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1091), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(390), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18528] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(617), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18627] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(338), 1,
      sym__expression,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18726] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(638), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18825] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(588), 1,
      sym_identifier,
    ACTIONS(590), 1,
      anon_sym_chan,
    STATE(296), 1,
      sym__expression,
    STATE(1129), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1204), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(67), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(71), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1001), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(316), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18924] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(642), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19023] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(605), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19122] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19221] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(339), 1,
      sym__expression,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19320] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(340), 1,
      sym__expression,
    STATE(1150), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1244), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(244), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(248), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1055), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(369), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19419] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(661), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19518] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(487), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19617] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(588), 1,
      sym_identifier,
    STATE(296), 1,
      sym__expression,
    STATE(1129), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1204), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(67), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(71), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1001), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(316), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19716] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(528), 1,
      anon_sym_LPAREN,
    ACTIONS(530), 1,
      anon_sym_STAR,
    ACTIONS(532), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    STATE(474), 1,
      sym__expression,
    STATE(1106), 1,
      sym_implicit_length_array_type,
    ACTIONS(308), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1243), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(536), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(534), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(312), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(993), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(492), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19815] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(654), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19914] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(590), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20013] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(591), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20112] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      anon_sym_chan,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20211] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(632), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20310] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(644), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20409] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_LPAREN,
    ACTIONS(598), 1,
      anon_sym_func,
    ACTIONS(600), 1,
      anon_sym_STAR,
    ACTIONS(602), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    STATE(382), 1,
      sym__expression,
    STATE(1105), 1,
      sym_implicit_length_array_type,
    ACTIONS(604), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1245), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(608), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(606), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(612), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1091), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(390), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20508] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(350), 1,
      sym_identifier,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_LT_DASH,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(950), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(368), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20607] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_LPAREN,
    ACTIONS(598), 1,
      anon_sym_func,
    ACTIONS(600), 1,
      anon_sym_STAR,
    ACTIONS(602), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    STATE(381), 1,
      sym__expression,
    STATE(1105), 1,
      sym_implicit_length_array_type,
    ACTIONS(604), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1245), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(608), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(606), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(612), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1091), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(390), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20706] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(584), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20805] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(585), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20904] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(452), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_STAR,
    ACTIONS(458), 1,
      anon_sym_LT_DASH,
    STATE(586), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(460), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21003] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(541), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21102] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(542), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21201] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(543), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21300] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(588), 1,
      sym_identifier,
    STATE(295), 1,
      sym__expression,
    STATE(1129), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1204), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(67), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(71), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1001), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(316), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21399] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(594), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_LPAREN,
    ACTIONS(598), 1,
      anon_sym_func,
    ACTIONS(600), 1,
      anon_sym_STAR,
    ACTIONS(602), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    STATE(380), 1,
      sym__expression,
    STATE(1105), 1,
      sym_implicit_length_array_type,
    ACTIONS(604), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1245), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(608), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(606), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(612), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(1091), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(390), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21498] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(544), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21597] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(422), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21696] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(352), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      anon_sym_func,
    ACTIONS(372), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(421), 1,
      sym__expression,
    STATE(1099), 1,
      sym_implicit_length_array_type,
    ACTIONS(366), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1240), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(370), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    STATE(836), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(374), 6,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(860), 6,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(429), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21795] = 6,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(618), 1,
      anon_sym_DOT,
    ACTIONS(620), 1,
      anon_sym_LBRACK,
    STATE(285), 1,
      sym_type_arguments,
    ACTIONS(614), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(616), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [21858] = 5,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(286), 1,
      sym_comment,
    STATE(278), 1,
      sym_block,
    ACTIONS(623), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(625), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [21918] = 10,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_LF,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(634), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_LBRACK,
    ACTIONS(640), 1,
      anon_sym_LBRACE,
    ACTIONS(642), 1,
      anon_sym_COLON,
    STATE(306), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(629), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [21988] = 10,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_LF,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(634), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_LBRACK,
    ACTIONS(640), 1,
      anon_sym_LBRACE,
    ACTIONS(644), 1,
      anon_sym_COLON,
    STATE(306), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(629), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [22058] = 5,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(286), 1,
      sym_comment,
    STATE(286), 1,
      sym_block,
    ACTIONS(646), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(648), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22118] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(650), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(652), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22173] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(654), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(656), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22228] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(658), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(660), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22283] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(662), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(664), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22338] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(666), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(668), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22393] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(670), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(672), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22448] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(674), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(676), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22503] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(678), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(680), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22558] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(682), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(684), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22613] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(686), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(688), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22668] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(690), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(692), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22723] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(694), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(696), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22778] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(698), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(700), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22833] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(702), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(704), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22888] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(706), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(708), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22943] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(710), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(712), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [22998] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(714), 1,
      sym_identifier,
    ACTIONS(716), 1,
      anon_sym_DOT,
    ACTIONS(719), 1,
      anon_sym_LPAREN,
    ACTIONS(723), 1,
      anon_sym_COMMA,
    ACTIONS(726), 1,
      anon_sym_func,
    ACTIONS(728), 1,
      anon_sym_LBRACK,
    ACTIONS(731), 1,
      anon_sym_RBRACK,
    ACTIONS(734), 1,
      anon_sym_STAR,
    ACTIONS(737), 1,
      anon_sym_map,
    ACTIONS(739), 1,
      anon_sym_chan,
    ACTIONS(741), 1,
      anon_sym_LT_DASH,
    STATE(426), 1,
      sym_literal_value,
    STATE(665), 1,
      aux_sym_parameter_declaration_repeat1,
    STATE(823), 1,
      sym_type_arguments,
    STATE(1061), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(629), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    STATE(836), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
    ACTIONS(627), 13,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23091] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(743), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(745), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23146] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(747), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(749), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23201] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(751), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(753), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23256] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(755), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(757), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23311] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(759), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(761), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23366] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(763), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(765), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23421] = 5,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(767), 1,
      ts_builtin_sym_end,
    ACTIONS(771), 1,
      anon_sym_LF,
    ACTIONS(773), 1,
      anon_sym_SEMI,
    ACTIONS(769), 44,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23480] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(776), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(778), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23535] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(780), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(782), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23590] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(784), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(786), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23645] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(788), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(790), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23700] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(792), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(794), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23755] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(796), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(798), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23810] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(800), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(802), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23865] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(796), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(798), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23920] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(804), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(806), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [23975] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(808), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(810), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24030] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(812), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(814), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24085] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(816), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(818), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24140] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(796), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(798), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24195] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(820), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(822), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24250] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(824), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(826), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24305] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(828), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(830), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24360] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(832), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(834), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24415] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(836), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(838), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24470] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(840), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(842), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24525] = 19,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(844), 1,
      anon_sym_LF,
    ACTIONS(848), 1,
      anon_sym_DOT,
    ACTIONS(850), 1,
      anon_sym_LPAREN,
    ACTIONS(852), 1,
      anon_sym_COMMA,
    ACTIONS(856), 1,
      anon_sym_LBRACK,
    ACTIONS(862), 1,
      anon_sym_LT_DASH,
    ACTIONS(864), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(866), 1,
      anon_sym_DASH_DASH,
    ACTIONS(870), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_PIPE,
    STATE(308), 1,
      sym_argument_list,
    STATE(751), 1,
      aux_sym_expression_list_repeat1,
    STATE(1103), 1,
      sym_type_arguments,
    ACTIONS(846), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(860), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(868), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(858), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(854), 13,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [24612] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(874), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(876), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24667] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(878), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(880), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24722] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(882), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(884), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24777] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(886), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(888), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24832] = 9,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_LF,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(634), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_LBRACK,
    ACTIONS(640), 1,
      anon_sym_LBRACE,
    STATE(306), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(629), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24899] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(890), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(892), 45,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_LBRACK,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [24954] = 12,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_DOT,
    ACTIONS(850), 1,
      anon_sym_LPAREN,
    ACTIONS(856), 1,
      anon_sym_LBRACK,
    ACTIONS(870), 1,
      anon_sym_AMP_AMP,
    ACTIONS(894), 1,
      anon_sym_LF,
    STATE(308), 1,
      sym_argument_list,
    STATE(1103), 1,
      sym_type_arguments,
    ACTIONS(860), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(868), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(858), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(896), 22,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PIPE_PIPE,
  [25026] = 11,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_DOT,
    ACTIONS(850), 1,
      anon_sym_LPAREN,
    ACTIONS(856), 1,
      anon_sym_LBRACK,
    ACTIONS(894), 1,
      anon_sym_LF,
    STATE(308), 1,
      sym_argument_list,
    STATE(1103), 1,
      sym_type_arguments,
    ACTIONS(860), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(868), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(858), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(896), 23,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25096] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(898), 30,
      anon_sym_package,
      anon_sym_import,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_struct,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      sym_identifier,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
  [25150] = 10,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_DOT,
    ACTIONS(850), 1,
      anon_sym_LPAREN,
    ACTIONS(856), 1,
      anon_sym_LBRACK,
    ACTIONS(894), 1,
      anon_sym_LF,
    STATE(308), 1,
      sym_argument_list,
    STATE(1103), 1,
      sym_type_arguments,
    ACTIONS(860), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(858), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(896), 29,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25218] = 9,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_DOT,
    ACTIONS(850), 1,
      anon_sym_LPAREN,
    ACTIONS(856), 1,
      anon_sym_LBRACK,
    ACTIONS(894), 1,
      anon_sym_LF,
    STATE(308), 1,
      sym_argument_list,
    STATE(1103), 1,
      sym_type_arguments,
    ACTIONS(858), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(896), 33,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25284] = 8,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_DOT,
    ACTIONS(850), 1,
      anon_sym_LPAREN,
    ACTIONS(856), 1,
      anon_sym_LBRACK,
    ACTIONS(894), 1,
      anon_sym_LF,
    STATE(308), 1,
      sym_argument_list,
    STATE(1103), 1,
      sym_type_arguments,
    ACTIONS(896), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25348] = 8,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_DOT,
    ACTIONS(850), 1,
      anon_sym_LPAREN,
    ACTIONS(856), 1,
      anon_sym_LBRACK,
    ACTIONS(900), 1,
      anon_sym_LF,
    STATE(308), 1,
      sym_argument_list,
    STATE(1103), 1,
      sym_type_arguments,
    ACTIONS(902), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25412] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(844), 1,
      anon_sym_SEMI,
    ACTIONS(854), 1,
      anon_sym_EQ,
    ACTIONS(904), 1,
      anon_sym_DOT,
    ACTIONS(906), 1,
      anon_sym_LPAREN,
    ACTIONS(908), 1,
      anon_sym_COMMA,
    ACTIONS(910), 1,
      anon_sym_LBRACK,
    ACTIONS(916), 1,
      anon_sym_LT_DASH,
    ACTIONS(920), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(922), 1,
      anon_sym_DASH_DASH,
    ACTIONS(928), 1,
      anon_sym_AMP_AMP,
    ACTIONS(930), 1,
      anon_sym_PIPE_PIPE,
    STATE(365), 1,
      sym_argument_list,
    STATE(751), 1,
      aux_sym_expression_list_repeat1,
    STATE(911), 1,
      sym_block,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(926), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(914), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(924), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(912), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(918), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [25503] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(844), 1,
      anon_sym_SEMI,
    ACTIONS(854), 1,
      anon_sym_EQ,
    ACTIONS(904), 1,
      anon_sym_DOT,
    ACTIONS(906), 1,
      anon_sym_LPAREN,
    ACTIONS(908), 1,
      anon_sym_COMMA,
    ACTIONS(910), 1,
      anon_sym_LBRACK,
    ACTIONS(916), 1,
      anon_sym_LT_DASH,
    ACTIONS(920), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(922), 1,
      anon_sym_DASH_DASH,
    ACTIONS(928), 1,
      anon_sym_AMP_AMP,
    ACTIONS(930), 1,
      anon_sym_PIPE_PIPE,
    STATE(365), 1,
      sym_argument_list,
    STATE(751), 1,
      aux_sym_expression_list_repeat1,
    STATE(855), 1,
      sym_block,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(926), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(914), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(924), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(912), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(918), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [25594] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(784), 1,
      anon_sym_LF,
    ACTIONS(786), 44,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_else,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25647] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_LF,
    ACTIONS(782), 44,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_else,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25700] = 5,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_LF,
    ACTIONS(932), 1,
      anon_sym_LPAREN,
    STATE(308), 1,
      sym_special_argument_list,
    ACTIONS(629), 42,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25757] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(934), 1,
      anon_sym_LF,
    ACTIONS(936), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25809] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(938), 1,
      anon_sym_LF,
    ACTIONS(940), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25861] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(942), 1,
      anon_sym_LF,
    ACTIONS(944), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25913] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(743), 1,
      anon_sym_LF,
    ACTIONS(745), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25965] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(946), 1,
      anon_sym_LF,
    ACTIONS(948), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26017] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(950), 1,
      anon_sym_LF,
    ACTIONS(952), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26069] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(954), 1,
      anon_sym_LF,
    ACTIONS(956), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26121] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(958), 1,
      anon_sym_LF,
    ACTIONS(960), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26173] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 1,
      anon_sym_SEMI,
    ACTIONS(854), 1,
      anon_sym_EQ,
    ACTIONS(906), 1,
      anon_sym_LPAREN,
    ACTIONS(908), 1,
      anon_sym_COMMA,
    ACTIONS(910), 1,
      anon_sym_LBRACK,
    ACTIONS(916), 1,
      anon_sym_LT_DASH,
    ACTIONS(920), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(922), 1,
      anon_sym_DASH_DASH,
    ACTIONS(928), 1,
      anon_sym_AMP_AMP,
    ACTIONS(930), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(962), 1,
      anon_sym_DOT,
    ACTIONS(964), 1,
      anon_sym_LBRACE,
    STATE(365), 1,
      sym_argument_list,
    STATE(751), 1,
      aux_sym_expression_list_repeat1,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(926), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(914), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(924), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(912), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(918), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [26261] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(966), 1,
      anon_sym_LF,
    ACTIONS(968), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26313] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(970), 1,
      anon_sym_LF,
    ACTIONS(972), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26365] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(747), 1,
      anon_sym_LF,
    ACTIONS(749), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26417] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(976), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26469] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(978), 1,
      anon_sym_LF,
    ACTIONS(980), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26521] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_LF,
    ACTIONS(629), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26573] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(982), 1,
      anon_sym_LF,
    ACTIONS(984), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26625] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(986), 1,
      anon_sym_LF,
    ACTIONS(988), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26677] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(990), 1,
      anon_sym_LF,
    ACTIONS(992), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26729] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(994), 1,
      anon_sym_LF,
    ACTIONS(996), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26781] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(998), 1,
      anon_sym_LF,
    ACTIONS(1000), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26833] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1002), 1,
      anon_sym_LF,
    ACTIONS(1004), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26885] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1006), 1,
      anon_sym_LF,
    ACTIONS(1008), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26937] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_LF,
    ACTIONS(1012), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26989] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LF,
    ACTIONS(1016), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27041] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1018), 1,
      anon_sym_LF,
    ACTIONS(1020), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27093] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1022), 1,
      anon_sym_LF,
    ACTIONS(1024), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27145] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1026), 1,
      anon_sym_LF,
    ACTIONS(1028), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27197] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1030), 1,
      anon_sym_LF,
    ACTIONS(1032), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27249] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1034), 1,
      anon_sym_LF,
    ACTIONS(1036), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27301] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1038), 1,
      anon_sym_LF,
    ACTIONS(1040), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27353] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1042), 1,
      anon_sym_LF,
    ACTIONS(1044), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27405] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1046), 1,
      anon_sym_LF,
    ACTIONS(1048), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27457] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1050), 1,
      anon_sym_LF,
    ACTIONS(1052), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27509] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 1,
      anon_sym_DOT,
    ACTIONS(731), 1,
      anon_sym_LPAREN,
    ACTIONS(1054), 1,
      anon_sym_LBRACK,
    STATE(357), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(629), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27570] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_DOT,
    ACTIONS(906), 1,
      anon_sym_LPAREN,
    ACTIONS(910), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_argument_list,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(896), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(894), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27631] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_DOT,
    ACTIONS(906), 1,
      anon_sym_LPAREN,
    ACTIONS(910), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_argument_list,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(896), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(912), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27694] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_DOT,
    ACTIONS(906), 1,
      anon_sym_LPAREN,
    ACTIONS(910), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_argument_list,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(896), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(914), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(912), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27759] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 1,
      anon_sym_EQ,
    ACTIONS(904), 1,
      anon_sym_DOT,
    ACTIONS(906), 1,
      anon_sym_LPAREN,
    ACTIONS(910), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_argument_list,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(926), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(914), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(924), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(912), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27828] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 1,
      anon_sym_EQ,
    ACTIONS(904), 1,
      anon_sym_DOT,
    ACTIONS(906), 1,
      anon_sym_LPAREN,
    ACTIONS(910), 1,
      anon_sym_LBRACK,
    ACTIONS(928), 1,
      anon_sym_AMP_AMP,
    STATE(365), 1,
      sym_argument_list,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(926), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(914), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(924), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(912), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_PIPE,
  [27899] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_DOT,
    ACTIONS(906), 1,
      anon_sym_LPAREN,
    ACTIONS(910), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_argument_list,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(902), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(900), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27960] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 1,
      anon_sym_LBRACE,
    ACTIONS(854), 1,
      anon_sym_EQ,
    ACTIONS(904), 1,
      anon_sym_DOT,
    ACTIONS(906), 1,
      anon_sym_LPAREN,
    ACTIONS(908), 1,
      anon_sym_COMMA,
    ACTIONS(910), 1,
      anon_sym_LBRACK,
    ACTIONS(920), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(922), 1,
      anon_sym_DASH_DASH,
    ACTIONS(928), 1,
      anon_sym_AMP_AMP,
    ACTIONS(930), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1057), 1,
      anon_sym_LT_DASH,
    STATE(365), 1,
      sym_argument_list,
    STATE(751), 1,
      aux_sym_expression_list_repeat1,
    STATE(1134), 1,
      sym_type_arguments,
    ACTIONS(926), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(914), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(924), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(912), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(918), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [28045] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 1,
      anon_sym_LPAREN,
    STATE(365), 1,
      sym_special_argument_list,
    ACTIONS(629), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 26,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1010), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28148] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(998), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28197] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(938), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28246] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(990), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28295] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(978), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(780), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28393] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(950), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28442] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1014), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28491] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(942), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28540] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1002), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28589] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1022), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28638] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(966), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(784), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28736] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(946), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(934), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28834] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(970), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28883] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(982), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28932] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28981] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1018), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29030] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1042), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1038), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29128] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(954), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(743), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29226] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29275] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1034), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(629), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29373] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1046), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29422] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1050), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29471] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(747), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29520] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(986), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(974), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29618] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(958), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1006), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1026), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29765] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 1,
      anon_sym_DOT,
    ACTIONS(731), 1,
      anon_sym_LPAREN,
    ACTIONS(1054), 1,
      anon_sym_LBRACK,
    ACTIONS(1061), 1,
      anon_sym_LBRACE,
    STATE(395), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(629), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29824] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_DOT,
    ACTIONS(1065), 1,
      anon_sym_LPAREN,
    ACTIONS(1069), 1,
      anon_sym_EQ,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1081), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE_PIPE,
    STATE(393), 1,
      sym_argument_list,
    STATE(1109), 1,
      sym_type_arguments,
    ACTIONS(1079), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1075), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1077), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1073), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1067), 13,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [29892] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_DOT,
    ACTIONS(1065), 1,
      anon_sym_LPAREN,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    STATE(393), 1,
      sym_argument_list,
    STATE(1109), 1,
      sym_type_arguments,
    ACTIONS(896), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(894), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29948] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_DOT,
    ACTIONS(1065), 1,
      anon_sym_LPAREN,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    STATE(393), 1,
      sym_argument_list,
    STATE(1109), 1,
      sym_type_arguments,
    ACTIONS(896), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1073), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30006] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_DOT,
    ACTIONS(1065), 1,
      anon_sym_LPAREN,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    STATE(393), 1,
      sym_argument_list,
    STATE(1109), 1,
      sym_type_arguments,
    ACTIONS(902), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(900), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30062] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_DOT,
    ACTIONS(1065), 1,
      anon_sym_LPAREN,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    STATE(393), 1,
      sym_argument_list,
    STATE(1109), 1,
      sym_type_arguments,
    ACTIONS(896), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1075), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1073), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30122] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 1,
      anon_sym_EQ,
    ACTIONS(1063), 1,
      anon_sym_DOT,
    ACTIONS(1065), 1,
      anon_sym_LPAREN,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    STATE(393), 1,
      sym_argument_list,
    STATE(1109), 1,
      sym_type_arguments,
    ACTIONS(1079), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1075), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1077), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1073), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 15,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30186] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 1,
      anon_sym_EQ,
    ACTIONS(1063), 1,
      anon_sym_DOT,
    ACTIONS(1065), 1,
      anon_sym_LPAREN,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
    ACTIONS(1081), 1,
      anon_sym_AMP_AMP,
    STATE(393), 1,
      sym_argument_list,
    STATE(1109), 1,
      sym_type_arguments,
    ACTIONS(1079), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1075), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1077), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1073), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 14,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_PIPE,
  [30252] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_LPAREN,
    STATE(393), 1,
      sym_special_argument_list,
    ACTIONS(629), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 21,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30301] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(974), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30345] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1034), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30389] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(743), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30433] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(629), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30477] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(780), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(747), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30565] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(954), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(946), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30697] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(950), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30741] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(934), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(784), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30829] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(942), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1006), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30917] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(978), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(990), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31005] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(938), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1010), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31093] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1014), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1022), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31181] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(966), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(970), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(982), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31313] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(998), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31357] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1018), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31401] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1042), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1038), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31489] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31533] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1026), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31577] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1046), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31621] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1050), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(986), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1002), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31753] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(958), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31797] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DOT,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(902), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(900), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31849] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DOT,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(896), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(894), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31901] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      anon_sym_LPAREN,
    STATE(452), 1,
      sym_special_argument_list,
    ACTIONS(629), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 23,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31946] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(716), 1,
      anon_sym_DOT,
    ACTIONS(1054), 1,
      anon_sym_LBRACK,
    STATE(426), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(731), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(629), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1046), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(946), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(938), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(982), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(629), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32199] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(950), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1034), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(990), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(942), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(934), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(970), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32439] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1050), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(978), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(974), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(986), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32639] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(743), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32679] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(958), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1006), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(747), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1010), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(966), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1002), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1014), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(998), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(780), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(954), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1022), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1018), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33199] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1038), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1042), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1026), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(784), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33359] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    ACTIONS(1099), 1,
      anon_sym_PIPE,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1103), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1101), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(896), 4,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1097), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 11,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33416] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    ACTIONS(1099), 1,
      anon_sym_PIPE,
    ACTIONS(1109), 1,
      anon_sym_AMP_AMP,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(896), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1103), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1101), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1105), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1097), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PIPE_PIPE,
  [33479] = 9,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_LF,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(634), 1,
      anon_sym_LPAREN,
    ACTIONS(637), 1,
      anon_sym_LBRACK,
    ACTIONS(1111), 1,
      anon_sym_LBRACE,
    STATE(498), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(629), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33530] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    ACTIONS(1099), 1,
      anon_sym_PIPE,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(896), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1103), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1101), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1105), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1097), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33591] = 21,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1113), 1,
      sym_identifier,
    ACTIONS(1115), 1,
      anon_sym_LF,
    ACTIONS(1119), 1,
      anon_sym_DOT,
    ACTIONS(1121), 1,
      anon_sym_LPAREN,
    ACTIONS(1123), 1,
      anon_sym_COMMA,
    ACTIONS(1125), 1,
      anon_sym_func,
    ACTIONS(1127), 1,
      anon_sym_LBRACK,
    ACTIONS(1129), 1,
      anon_sym_STAR,
    ACTIONS(1131), 1,
      anon_sym_struct,
    ACTIONS(1133), 1,
      anon_sym_interface,
    ACTIONS(1135), 1,
      anon_sym_map,
    ACTIONS(1137), 1,
      anon_sym_chan,
    ACTIONS(1139), 1,
      anon_sym_LT_DASH,
    ACTIONS(1141), 1,
      sym_raw_string_literal,
    ACTIONS(1143), 1,
      anon_sym_DQUOTE,
    STATE(656), 1,
      aux_sym_field_declaration_repeat1,
    STATE(1090), 1,
      sym_interpreted_string_literal,
    ACTIONS(1117), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(859), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(804), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [33666] = 15,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_LF,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1149), 1,
      anon_sym_COMMA,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    ACTIONS(1159), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1161), 1,
      anon_sym_PIPE_PIPE,
    STATE(496), 1,
      sym_argument_list,
    STATE(820), 1,
      aux_sym_expression_list_repeat1,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(854), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1155), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1157), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1153), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [33729] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1103), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(896), 5,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1097), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33782] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 1,
      anon_sym_EQ,
    ACTIONS(916), 1,
      anon_sym_LT_DASH,
    ACTIONS(918), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1163), 1,
      anon_sym_DOT,
    ACTIONS(1165), 1,
      anon_sym_LPAREN,
    ACTIONS(1167), 1,
      anon_sym_COMMA,
    ACTIONS(1169), 1,
      anon_sym_LBRACK,
    ACTIONS(1173), 1,
      anon_sym_PIPE,
    ACTIONS(1175), 1,
      anon_sym_COLON,
    ACTIONS(1185), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1187), 1,
      anon_sym_PIPE_PIPE,
    STATE(557), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1147), 1,
      sym_type_arguments,
    ACTIONS(1179), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1183), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1177), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1181), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1171), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [33854] = 15,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(316), 1,
      anon_sym_LF,
    ACTIONS(1113), 1,
      sym_identifier,
    ACTIONS(1125), 1,
      anon_sym_func,
    ACTIONS(1127), 1,
      anon_sym_LBRACK,
    ACTIONS(1129), 1,
      anon_sym_STAR,
    ACTIONS(1131), 1,
      anon_sym_struct,
    ACTIONS(1133), 1,
      anon_sym_interface,
    ACTIONS(1135), 1,
      anon_sym_map,
    ACTIONS(1137), 1,
      anon_sym_chan,
    ACTIONS(1139), 1,
      anon_sym_LT_DASH,
    ACTIONS(1189), 1,
      anon_sym_LPAREN,
    STATE(806), 2,
      sym_parameter_list,
      sym__simple_type,
    ACTIONS(321), 7,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
    STATE(804), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [33916] = 10,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(894), 1,
      anon_sym_LF,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    STATE(496), 1,
      sym_argument_list,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(1155), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1153), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(896), 13,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33968] = 18,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(714), 1,
      sym_identifier,
    ACTIONS(726), 1,
      anon_sym_func,
    ACTIONS(737), 1,
      anon_sym_map,
    ACTIONS(739), 1,
      anon_sym_chan,
    ACTIONS(1191), 1,
      anon_sym_LF,
    ACTIONS(1195), 1,
      anon_sym_LPAREN,
    ACTIONS(1197), 1,
      anon_sym_COMMA,
    ACTIONS(1199), 1,
      anon_sym_EQ,
    ACTIONS(1201), 1,
      anon_sym_LBRACK,
    ACTIONS(1203), 1,
      anon_sym_STAR,
    ACTIONS(1205), 1,
      anon_sym_LT_DASH,
    STATE(472), 1,
      aux_sym_const_spec_repeat1,
    STATE(1171), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(1193), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    STATE(836), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [34036] = 11,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(894), 1,
      anon_sym_LF,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    STATE(496), 1,
      sym_argument_list,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(1155), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1157), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(896), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1153), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34090] = 9,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(894), 1,
      anon_sym_LF,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    STATE(496), 1,
      sym_argument_list,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(1153), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(896), 17,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34140] = 18,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(714), 1,
      sym_identifier,
    ACTIONS(726), 1,
      anon_sym_func,
    ACTIONS(737), 1,
      anon_sym_map,
    ACTIONS(739), 1,
      anon_sym_chan,
    ACTIONS(1195), 1,
      anon_sym_LPAREN,
    ACTIONS(1197), 1,
      anon_sym_COMMA,
    ACTIONS(1201), 1,
      anon_sym_LBRACK,
    ACTIONS(1203), 1,
      anon_sym_STAR,
    ACTIONS(1205), 1,
      anon_sym_LT_DASH,
    ACTIONS(1207), 1,
      anon_sym_LF,
    ACTIONS(1211), 1,
      anon_sym_EQ,
    STATE(741), 1,
      aux_sym_const_spec_repeat1,
    STATE(1175), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(1209), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    STATE(836), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [34208] = 13,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1067), 1,
      anon_sym_LF,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    ACTIONS(1159), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1161), 1,
      anon_sym_PIPE_PIPE,
    STATE(496), 1,
      sym_argument_list,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(1155), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1069), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1157), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1153), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34266] = 8,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(900), 1,
      anon_sym_LF,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    STATE(496), 1,
      sym_argument_list,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(902), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34314] = 8,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(894), 1,
      anon_sym_LF,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    STATE(496), 1,
      sym_argument_list,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(896), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34362] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 1,
      anon_sym_DOT,
    ACTIONS(731), 1,
      anon_sym_LPAREN,
    ACTIONS(1054), 1,
      anon_sym_LBRACK,
    ACTIONS(1213), 1,
      anon_sym_LBRACE,
    STATE(558), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(629), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34412] = 12,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(894), 1,
      anon_sym_LF,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    ACTIONS(1159), 1,
      anon_sym_AMP_AMP,
    STATE(496), 1,
      sym_argument_list,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(1155), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(896), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PIPE_PIPE,
    ACTIONS(1157), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1153), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34468] = 5,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_LF,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    STATE(496), 1,
      sym_special_argument_list,
    ACTIONS(629), 26,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34509] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    ACTIONS(1099), 1,
      anon_sym_PIPE,
    ACTIONS(1109), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1217), 1,
      anon_sym_PIPE_PIPE,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1069), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1103), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1067), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
    ACTIONS(1101), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1105), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1097), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34572] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1163), 1,
      anon_sym_DOT,
    ACTIONS(1165), 1,
      anon_sym_LPAREN,
    ACTIONS(1169), 1,
      anon_sym_LBRACK,
    ACTIONS(1173), 1,
      anon_sym_PIPE,
    STATE(557), 1,
      sym_argument_list,
    STATE(1147), 1,
      sym_type_arguments,
    ACTIONS(896), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1179), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1183), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1177), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1181), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(894), 5,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1171), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34631] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1163), 1,
      anon_sym_DOT,
    ACTIONS(1165), 1,
      anon_sym_LPAREN,
    ACTIONS(1169), 1,
      anon_sym_LBRACK,
    STATE(557), 1,
      sym_argument_list,
    STATE(1147), 1,
      sym_type_arguments,
    ACTIONS(896), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(894), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34678] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1163), 1,
      anon_sym_DOT,
    ACTIONS(1165), 1,
      anon_sym_LPAREN,
    ACTIONS(1169), 1,
      anon_sym_LBRACK,
    ACTIONS(1173), 1,
      anon_sym_PIPE,
    ACTIONS(1185), 1,
      anon_sym_AMP_AMP,
    STATE(557), 1,
      sym_argument_list,
    STATE(1147), 1,
      sym_type_arguments,
    ACTIONS(896), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1179), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1183), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1177), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(894), 4,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PIPE_PIPE,
    ACTIONS(1181), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1171), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34739] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1163), 1,
      anon_sym_DOT,
    ACTIONS(1165), 1,
      anon_sym_LPAREN,
    ACTIONS(1169), 1,
      anon_sym_LBRACK,
    STATE(557), 1,
      sym_argument_list,
    STATE(1147), 1,
      sym_type_arguments,
    ACTIONS(902), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(900), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34786] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1163), 1,
      anon_sym_DOT,
    ACTIONS(1165), 1,
      anon_sym_LPAREN,
    ACTIONS(1169), 1,
      anon_sym_LBRACK,
    STATE(557), 1,
      sym_argument_list,
    STATE(1147), 1,
      sym_type_arguments,
    ACTIONS(1179), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(896), 5,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1171), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 12,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34837] = 13,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    ACTIONS(1159), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1161), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1219), 1,
      anon_sym_LF,
    STATE(496), 1,
      sym_argument_list,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(1155), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1221), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1157), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1153), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34894] = 13,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    ACTIONS(1159), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1161), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1223), 1,
      anon_sym_LF,
    STATE(496), 1,
      sym_argument_list,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(1155), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1225), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1157), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1153), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34951] = 13,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1145), 1,
      anon_sym_DOT,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      anon_sym_LBRACK,
    ACTIONS(1159), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1161), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1227), 1,
      anon_sym_LF,
    STATE(496), 1,
      sym_argument_list,
    STATE(1127), 1,
      sym_type_arguments,
    ACTIONS(1155), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1229), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1157), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1153), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [35008] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1163), 1,
      anon_sym_DOT,
    ACTIONS(1165), 1,
      anon_sym_LPAREN,
    ACTIONS(1169), 1,
      anon_sym_LBRACK,
    ACTIONS(1173), 1,
      anon_sym_PIPE,
    STATE(557), 1,
      sym_argument_list,
    STATE(1147), 1,
      sym_type_arguments,
    ACTIONS(1179), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1177), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(896), 4,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1171), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 9,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35063] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(934), 1,
      anon_sym_LF,
    ACTIONS(936), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35099] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1026), 1,
      anon_sym_LF,
    ACTIONS(1028), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35135] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DOT,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1231), 1,
      anon_sym_RPAREN,
    ACTIONS(1233), 1,
      anon_sym_COMMA,
    ACTIONS(1235), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1239), 1,
      anon_sym_PIPE,
    ACTIONS(1249), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1251), 1,
      anon_sym_PIPE_PIPE,
    STATE(452), 1,
      sym_argument_list,
    STATE(1038), 1,
      aux_sym_argument_list_repeat1,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1243), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1247), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1241), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1237), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [35201] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_LF,
    ACTIONS(629), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35237] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DOT,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1235), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1239), 1,
      anon_sym_PIPE,
    ACTIONS(1249), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1251), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1253), 1,
      anon_sym_RPAREN,
    ACTIONS(1255), 1,
      anon_sym_COMMA,
    STATE(452), 1,
      sym_argument_list,
    STATE(1021), 1,
      aux_sym_argument_list_repeat1,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1243), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1247), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1241), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1237), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [35303] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(966), 1,
      anon_sym_LF,
    ACTIONS(968), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35339] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(970), 1,
      anon_sym_LF,
    ACTIONS(972), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35375] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(954), 1,
      anon_sym_LF,
    ACTIONS(956), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35411] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(982), 1,
      anon_sym_LF,
    ACTIONS(984), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35447] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(946), 1,
      anon_sym_LF,
    ACTIONS(948), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35483] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(994), 1,
      anon_sym_LF,
    ACTIONS(996), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35519] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(731), 1,
      anon_sym_LPAREN,
    ACTIONS(1054), 1,
      anon_sym_LBRACK,
    STATE(426), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(629), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 17,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35567] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(998), 1,
      anon_sym_LF,
    ACTIONS(1000), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35603] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(714), 1,
      sym_identifier,
    ACTIONS(726), 1,
      anon_sym_func,
    ACTIONS(737), 1,
      anon_sym_map,
    ACTIONS(739), 1,
      anon_sym_chan,
    ACTIONS(741), 1,
      anon_sym_LT_DASH,
    ACTIONS(1257), 1,
      anon_sym_LPAREN,
    ACTIONS(1259), 1,
      anon_sym_LBRACK,
    ACTIONS(1261), 1,
      anon_sym_STAR,
    STATE(818), 2,
      sym_parameter_list,
      sym__simple_type,
    ACTIONS(316), 6,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
    STATE(836), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [35661] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1018), 1,
      anon_sym_LF,
    ACTIONS(1020), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35697] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DOT,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1235), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1239), 1,
      anon_sym_PIPE,
    ACTIONS(1249), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1251), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1263), 1,
      anon_sym_RPAREN,
    ACTIONS(1265), 1,
      anon_sym_COMMA,
    STATE(452), 1,
      sym_argument_list,
    STATE(1064), 1,
      aux_sym_argument_list_repeat1,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1243), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1247), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1241), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1237), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [35763] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1042), 1,
      anon_sym_LF,
    ACTIONS(1044), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35799] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DOT,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1235), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1239), 1,
      anon_sym_PIPE,
    ACTIONS(1249), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1251), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1267), 1,
      anon_sym_RPAREN,
    ACTIONS(1269), 1,
      anon_sym_COMMA,
    STATE(452), 1,
      sym_argument_list,
    STATE(1037), 1,
      aux_sym_argument_list_repeat1,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1243), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1247), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1241), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1237), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [35865] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(747), 1,
      anon_sym_LF,
    ACTIONS(749), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35901] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1046), 1,
      anon_sym_LF,
    ACTIONS(1048), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35937] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_LF,
    ACTIONS(782), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35973] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(950), 1,
      anon_sym_LF,
    ACTIONS(952), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36009] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 1,
      anon_sym_LBRACE,
    ACTIONS(614), 1,
      anon_sym_COMMA,
    ACTIONS(716), 1,
      anon_sym_DOT,
    ACTIONS(1054), 1,
      anon_sym_LBRACK,
    STATE(426), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(731), 2,
      anon_sym_LPAREN,
      anon_sym_RBRACK,
    ACTIONS(629), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 15,
      anon_sym_STAR,
      anon_sym_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36059] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1030), 1,
      anon_sym_LF,
    ACTIONS(1032), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36095] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1034), 1,
      anon_sym_LF,
    ACTIONS(1036), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36131] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1022), 1,
      anon_sym_LF,
    ACTIONS(1024), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36167] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(958), 1,
      anon_sym_LF,
    ACTIONS(960), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36203] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(974), 1,
      anon_sym_LF,
    ACTIONS(976), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36239] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1006), 1,
      anon_sym_LF,
    ACTIONS(1008), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36275] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(990), 1,
      anon_sym_LF,
    ACTIONS(992), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36311] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(614), 1,
      anon_sym_RPAREN,
    ACTIONS(714), 1,
      sym_identifier,
    ACTIONS(723), 1,
      anon_sym_COMMA,
    ACTIONS(726), 1,
      anon_sym_func,
    ACTIONS(737), 1,
      anon_sym_map,
    ACTIONS(739), 1,
      anon_sym_chan,
    ACTIONS(741), 1,
      anon_sym_LT_DASH,
    ACTIONS(1261), 1,
      anon_sym_STAR,
    ACTIONS(1271), 1,
      anon_sym_DOT,
    ACTIONS(1273), 1,
      anon_sym_LPAREN,
    ACTIONS(1275), 1,
      anon_sym_LBRACK,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(665), 1,
      aux_sym_parameter_declaration_repeat1,
    STATE(823), 1,
      sym_type_arguments,
    STATE(1061), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(836), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [36379] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1167), 1,
      anon_sym_COMMA,
    ACTIONS(1279), 1,
      anon_sym_DOT,
    ACTIONS(1283), 1,
      anon_sym_LBRACE,
    ACTIONS(1285), 1,
      anon_sym_PIPE,
    ACTIONS(1295), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1297), 1,
      anon_sym_PIPE_PIPE,
    STATE(452), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1289), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1293), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1287), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1291), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1281), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36445] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DOT,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1235), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1239), 1,
      anon_sym_PIPE,
    ACTIONS(1249), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1251), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1299), 1,
      anon_sym_RPAREN,
    ACTIONS(1301), 1,
      anon_sym_COMMA,
    STATE(452), 1,
      sym_argument_list,
    STATE(1086), 1,
      aux_sym_argument_list_repeat1,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1243), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1247), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1241), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1237), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36511] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      anon_sym_LPAREN,
    STATE(557), 1,
      sym_special_argument_list,
    ACTIONS(629), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 19,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36551] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DOT,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1235), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1239), 1,
      anon_sym_PIPE,
    ACTIONS(1249), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1251), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1305), 1,
      anon_sym_RPAREN,
    ACTIONS(1307), 1,
      anon_sym_COMMA,
    STATE(452), 1,
      sym_argument_list,
    STATE(1071), 1,
      aux_sym_argument_list_repeat1,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1243), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1247), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1241), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1237), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36617] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1038), 1,
      anon_sym_LF,
    ACTIONS(1040), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36653] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(978), 1,
      anon_sym_LF,
    ACTIONS(980), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36689] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    ACTIONS(1099), 1,
      anon_sym_PIPE,
    ACTIONS(1109), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1167), 1,
      anon_sym_COMMA,
    ACTIONS(1217), 1,
      anon_sym_PIPE_PIPE,
    STATE(452), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(918), 2,
      anon_sym_SEMI,
      anon_sym_COLON,
    ACTIONS(1103), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1101), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1105), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1097), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36753] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(986), 1,
      anon_sym_LF,
    ACTIONS(988), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36789] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(784), 1,
      anon_sym_LF,
    ACTIONS(786), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36825] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(743), 1,
      anon_sym_LF,
    ACTIONS(745), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36861] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LF,
    ACTIONS(1016), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36897] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_LF,
    ACTIONS(1012), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36933] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(938), 1,
      anon_sym_LF,
    ACTIONS(940), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36969] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1050), 1,
      anon_sym_LF,
    ACTIONS(1052), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37005] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(942), 1,
      anon_sym_LF,
    ACTIONS(944), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37041] = 3,
    ACTIONS(286), 1,
      sym_comment,
    ACTIONS(1002), 1,
      anon_sym_LF,
    ACTIONS(1004), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1038), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37112] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1018), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37147] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(726), 1,
      anon_sym_func,
    ACTIONS(737), 1,
      anon_sym_map,
    ACTIONS(739), 1,
      anon_sym_chan,
    ACTIONS(741), 1,
      anon_sym_LT_DASH,
    ACTIONS(1259), 1,
      anon_sym_LBRACK,
    ACTIONS(1261), 1,
      anon_sym_STAR,
    ACTIONS(1273), 1,
      anon_sym_LPAREN,
    ACTIONS(1309), 1,
      sym_identifier,
    ACTIONS(1311), 1,
      anon_sym_RPAREN,
    ACTIONS(1313), 1,
      anon_sym_COMMA,
    ACTIONS(1315), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(1065), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1066), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(836), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [37210] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DOT,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1235), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1239), 1,
      anon_sym_PIPE,
    ACTIONS(1249), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1251), 1,
      anon_sym_PIPE_PIPE,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1243), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1247), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1317), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(1241), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1237), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37271] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(726), 1,
      anon_sym_func,
    ACTIONS(737), 1,
      anon_sym_map,
    ACTIONS(739), 1,
      anon_sym_chan,
    ACTIONS(741), 1,
      anon_sym_LT_DASH,
    ACTIONS(1259), 1,
      anon_sym_LBRACK,
    ACTIONS(1261), 1,
      anon_sym_STAR,
    ACTIONS(1273), 1,
      anon_sym_LPAREN,
    ACTIONS(1309), 1,
      sym_identifier,
    ACTIONS(1315), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1319), 1,
      anon_sym_RPAREN,
    ACTIONS(1321), 1,
      anon_sym_COMMA,
    STATE(1008), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1065), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(836), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [37334] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    ACTIONS(1285), 1,
      anon_sym_PIPE,
    ACTIONS(1295), 1,
      anon_sym_AMP_AMP,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1289), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1293), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1287), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(894), 4,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PIPE_PIPE,
    ACTIONS(1291), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1281), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37391] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    ACTIONS(1285), 1,
      anon_sym_PIPE,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1289), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1293), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1287), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1291), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(894), 5,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1281), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37446] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    ACTIONS(1285), 1,
      anon_sym_PIPE,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(896), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1289), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1287), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1281), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 9,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37499] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1289), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(896), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1281), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(894), 12,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37548] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    ACTIONS(1099), 1,
      anon_sym_PIPE,
    ACTIONS(1109), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1217), 1,
      anon_sym_PIPE_PIPE,
    STATE(452), 1,
      sym_argument_list,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1103), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1107), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1101), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1323), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(1105), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1097), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37607] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(614), 1,
      anon_sym_RBRACK,
    ACTIONS(714), 1,
      sym_identifier,
    ACTIONS(723), 1,
      anon_sym_COMMA,
    ACTIONS(726), 1,
      anon_sym_func,
    ACTIONS(737), 1,
      anon_sym_map,
    ACTIONS(739), 1,
      anon_sym_chan,
    ACTIONS(741), 1,
      anon_sym_LT_DASH,
    ACTIONS(1261), 1,
      anon_sym_STAR,
    ACTIONS(1273), 1,
      anon_sym_LPAREN,
    ACTIONS(1275), 1,
      anon_sym_LBRACK,
    ACTIONS(1325), 1,
      anon_sym_DOT,
    STATE(665), 1,
      aux_sym_parameter_declaration_repeat1,
    STATE(823), 1,
      sym_type_arguments,
    STATE(1061), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(836), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [37672] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(726), 1,
      anon_sym_func,
    ACTIONS(737), 1,
      anon_sym_map,
    ACTIONS(739), 1,
      anon_sym_chan,
    ACTIONS(741), 1,
      anon_sym_LT_DASH,
    ACTIONS(1259), 1,
      anon_sym_LBRACK,
    ACTIONS(1261), 1,
      anon_sym_STAR,
    ACTIONS(1273), 1,
      anon_sym_LPAREN,
    ACTIONS(1309), 1,
      sym_identifier,
    ACTIONS(1315), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1327), 1,
      anon_sym_RPAREN,
    ACTIONS(1329), 1,
      anon_sym_COMMA,
    STATE(1046), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1065), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(836), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [37735] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_LBRACE,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1091), 1,
      anon_sym_LBRACK,
    ACTIONS(1095), 1,
      anon_sym_DOT,
    ACTIONS(1285), 1,
      anon_sym_PIPE,
    ACTIONS(1295), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1297), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1331), 1,
      anon_sym_COMMA,
    STATE(452), 1,
      sym_argument_list,
    STATE(1051), 1,
      aux_sym_expression_list_repeat1,
    STATE(1155), 1,
      sym_type_arguments,
    ACTIONS(1289), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1293), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1287), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1291), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1281), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(743), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(629), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(978), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37903] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(747), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37938] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 1,
      anon_sym_DOT,
    ACTIONS(731), 1,
      anon_sym_LPAREN,
    ACTIONS(1054), 1,
      anon_sym_LBRACK,
    STATE(426), 1,
      sym_literal_value,
    STATE(823), 1,
      sym_type_arguments,
    ACTIONS(629), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [37983] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(714), 1,
      sym_identifier,
    ACTIONS(1333), 1,
      anon_sym_LPAREN,
    ACTIONS(1336), 1,
      anon_sym_func,
    ACTIONS(1338), 1,
      anon_sym_LBRACK,
    ACTIONS(1340), 1,
      anon_sym_STAR,
    ACTIONS(1342), 1,
      anon_sym_LBRACE,
    ACTIONS(1344), 1,
      anon_sym_LT_DASH,
    STATE(447), 1,
      sym_block,
    STATE(850), 2,
      sym_parameter_list,
      sym__simple_type,
    ACTIONS(316), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    STATE(836), 10,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [38044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(990), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(780), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38114] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(954), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38149] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(946), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(950), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(942), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38254] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1002), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38289] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(938), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(784), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(934), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38394] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(994), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38429] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1026), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1010), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38499] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1006), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38534] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(958), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(974), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [38604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(986), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon