import { z } from 'zod';
export declare const ConfigSchema: z.ZodObject<{
    backgroundAnalysisMaxFiles: z.ZodDefault<z.ZodNumber>;
    globPattern: z.ZodDefault<z.ZodString>;
    explainshellEndpoint: z.ZodDefault<z.ZodString>;
    logLevel: z.ZodDefault<z.ZodEnum<["debug", "info", "warning", "error"]>>;
    includeAllWorkspaceSymbols: z.ZodDefault<z.ZodBoolean>;
    shellcheckArguments: z.ZodDefault<z.ZodEffects<z.ZodArray<z.ZodString, "many">, string[], unknown>>;
    shellcheckPath: z.ZodDefault<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    globPattern: string;
    includeAllWorkspaceSymbols: boolean;
    backgroundAnalysisMaxFiles: number;
    explainshellEndpoint: string;
    logLevel: "error" | "warning" | "debug" | "info";
    shellcheckArguments: string[];
    shellcheckPath: string;
}, {
    backgroundAnalysisMaxFiles?: number | undefined;
    globPattern?: string | undefined;
    explainshellEndpoint?: string | undefined;
    logLevel?: "error" | "warning" | "debug" | "info" | undefined;
    includeAllWorkspaceSymbols?: boolean | undefined;
    shellcheckArguments?: unknown;
    shellcheckPath?: string | undefined;
}>;
export type Config = z.infer<typeof ConfigSchema>;
export declare function getConfigFromEnvironmentVariables(): {
    config: Config;
    environmentVariablesUsed: string[];
};
export declare function getDefaultConfiguration(): Config;
