/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.proxy;

import com.xqj2.proxy.XQCastAs;
import com.xqj2.proxy.XQFunctionName;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQSequenceType;
import net.xqj.core.Constants;
import net.xqj.core.GenericXQConnection;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.util.ClassTester;
import net.xqj.core.util.StringWriter;
import net.xqj.core.xqitem.ObjectToXQItemConverter;
import net.xqj.core.xqitem.XQItemBase;
import net.xqj.core.xqitem.XQItemProxy;
import net.xqj.core.xqitem.XQItemToObjectConverter;
import net.xqj.core.xqitem.xstream.XStreamHelper;
import net.xqj.core.xqitem.xstream.XmlFriendlyNameCoder2;
import net.xqj.core.xqitemtype.XQItemTypeFactory;
import net.xqj.core.xqsequence.IteratorToXQItemBaseAdapter;
import net.xqj.core.xqsequence.ScrollableXQSequence;
import net.xqj.core.xqsequence.XQSequenceFactory;

public class XQueryModuleProxy
implements InvocationHandler {
    private GenericXQConnection parentConnection;
    private String namespaceUri;
    private String moduleUri;
    private static boolean isXStreamAvailable;
    private static XmlFriendlyNameCoder2 nameCoder;

    private static final void setXStreamFlag() {
        try {
            Class.forName("com.thoughtworks.xstream.XStream");
            isXStreamAvailable = true;
        }
        catch (Exception e) {
            isXStreamAvailable = false;
        }
    }

    public static final boolean isXStreamAvailable() {
        return isXStreamAvailable;
    }

    private XQueryModuleProxy(GenericXQConnection parentConnection, String namespaceUri, String moduleUri) {
        this.parentConnection = parentConnection;
        this.namespaceUri = namespaceUri;
        this.moduleUri = moduleUri;
    }

    public static Object createProxy(GenericXQConnection parent, String namespaceUri, String moduleUri, Class[] interfaces) {
        return Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), interfaces, (InvocationHandler)new XQueryModuleProxy(parent, namespaceUri, moduleUri));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws XQException {
        XQExpression expr = this.parentConnection.createExpression();
        StringWriter strWriter = new StringWriter();
        String functionName = null;
        try {
            strWriter.write("import module namespace xqj-proxy = ");
            strWriter.write(XQToolkit.getInQuotes(this.namespaceUri));
            if (this.moduleUri != null) {
                strWriter.write(" at ");
                strWriter.write(XQToolkit.getInQuotes(this.moduleUri));
            }
            strWriter.write(59);
            strWriter.write("xqj-proxy:");
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            functionName = XQueryModuleProxy.getXQueryFunctionNameFromMethod(method);
            strWriter.write(functionName);
            strWriter.write(40);
            for (int i = 0; i < args.length; ++i) {
                XQSequenceType sequenceType = null;
                for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                    Annotation annotation = parameterAnnotations[i][j];
                    if (!ClassTester.isXQCastAs(annotation)) continue;
                    XQCastAs castAs = (XQCastAs)annotation;
                    sequenceType = XQItemTypeFactory.createSequenceType(castAs.value());
                }
                this.serializeToXQuery(args[i], sequenceType, strWriter);
                if (i + 1 == args.length) continue;
                strWriter.write(", ");
            }
            strWriter.write(41);
        }
        catch (IOException e) {
            throw new XQExceptionImpl("Issue occurred creating XQuery code from Proxy invocation. " + e.getMessage(), "XQJPX005", e);
        }
        XQResultSequence rs = expr.executeQuery(strWriter.toString());
        Class<?> returnType = method.getReturnType();
        if (XQueryModuleProxy.isXStreamAvailable()) {
            XStreamHelper.processAnnotations(returnType);
        }
        if (returnType.isArray()) {
            XQSequence scrollableSequence = this.parentConnection.createSequence((XQSequence)rs);
            Object array = Array.newInstance(returnType.getComponentType(), scrollableSequence.count());
            int index = 0;
            while (rs.next()) {
                XQItemProxy itemProxy = (XQItemProxy)rs.getItem();
                XQItemBase itemBase = itemProxy.getItemBase();
                Object javaObject = XQItemToObjectConverter.createObject(itemBase);
                Array.set(array, index, javaObject);
                ++index;
            }
            return array;
        }
        if (!returnType.equals(Void.TYPE)) {
            if (!rs.next()) {
                throw new XQExceptionImpl("XQJPX001", "The Java method " + method.getName() + " defines a return type of '" + returnType.getName() + "', but the mapped XQuery function '" + functionName + "' has returned an empty-sequence().");
            }
            XQItemProxy itemProxy = (XQItemProxy)rs.getItem();
            XQItemBase itemBase = itemProxy.getItemBase();
            Object javaObject = XQItemToObjectConverter.createObject(itemBase, ClassTester.notObjectOrNull(returnType));
            if (javaObject == null) {
                throw new XQExceptionImpl("XQJPX004", "The XQuery function '" + functionName + "' returned an item with a XDM type of '" + itemBase.getItemTypeAsString() + "', however there is currently no XDM to Java serializer for that XDM type. Please raise a support ticket if this is an issue.");
            }
            if (rs.next()) {
                throw new XQExceptionImpl("XQJPX002", "The Java method " + method.getName() + " defines a return type of '" + returnType.getName() + "', but the mapped XQuery function '" + functionName + "' has returned more than one sequence items.");
            }
            if (!returnType.isInstance(javaObject)) {
                throw new XQExceptionImpl("XQJPX003", "The Java method " + method.getName() + " defines a return type of '" + returnType.getName() + "', but the mapped XQuery function '" + functionName + "' has returned a " + itemBase.getItemTypeAsString() + " which is incompatible with the Java type.");
            }
            return javaObject;
        }
        return null;
    }

    private void serializeToXQuery(Object value, XQSequenceType sequenceType, Writer out) throws XQException {
        if (!value.getClass().isArray() || ClassTester.isByteArray(value.getClass())) {
            XQItemBase itemBase = ObjectToXQItemConverter.createXQItem(value, sequenceType != null ? sequenceType.getItemType() : null);
            itemBase.writeItem(out, Constants.WRITE_XQUERY_PROPERTIES);
        } else {
            Object[] array = (Object[])value;
            ArrayList<XQItemBase> list = new ArrayList<XQItemBase>(array.length);
            for (int i = 0; i < array.length; ++i) {
                XQItemBase itemBase = ObjectToXQItemConverter.createXQItem(array[i], sequenceType != null ? sequenceType.getItemType() : null);
                list.add(itemBase);
            }
            ScrollableXQSequence sequence = XQSequenceFactory.newScrollableXQSequence(new IteratorToXQItemBaseAdapter(list.iterator()));
            sequence.writeSequence(out, Constants.WRITE_XQUERY_PROPERTIES);
        }
    }

    private static final String getXQueryFunctionNameFromMethod(Method method) {
        XQFunctionName overrideAnnotation = ClassTester.getXQFunctionNameAnnotation(method);
        if (overrideAnnotation != null) {
            return overrideAnnotation.value();
        }
        return XQueryModuleProxy.javaNameToXmlName(method.getName());
    }

    public static String javaNameToXmlName(String javaName) {
        return nameCoder.encodeNode(javaName);
    }

    public static String xmlNameToJavaName(String xmlName) {
        return nameCoder.decodeNode(xmlName);
    }

    static {
        XQueryModuleProxy.setXStreamFlag();
        nameCoder = new XmlFriendlyNameCoder2();
    }
}

