/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.func.Records;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ChoiceItemType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.RecordField;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenObjectMap;

public final class RecordType
extends MapType {
    private boolean extensible;
    private TokenObjectMap<RecordField> fields;
    private final QNm name;
    private final AnnList anns;
    private InputInfo info;

    public RecordType(TokenObjectMap<RecordField> fields) {
        this(fields, false);
    }

    public RecordType(TokenObjectMap<RecordField> fields, boolean extensible) {
        this(fields, extensible, null, AnnList.EMPTY);
    }

    public RecordType(TokenObjectMap<RecordField> fields, boolean extensible, QNm name, AnnList anns) {
        super(extensible ? AtomType.ANY_ATOMIC_TYPE : AtomType.STRING, extensible ? Types.ITEM_ZM : RecordType.unionType(fields));
        this.extensible = extensible;
        this.fields = fields;
        this.name = name;
        this.anns = anns;
        this.info = null;
    }

    public RecordType(QNm name, InputInfo info) {
        super(AtomType.ANY_ATOMIC_TYPE, Types.ITEM_ZM, false);
        this.name = name;
        this.info = info;
        this.extensible = true;
        this.fields = new TokenObjectMap(0L);
        this.anns = AnnList.EMPTY;
    }

    public RecordType add(String fieldName, boolean optional, SeqType seqType) {
        this.fields.put(Token.token(fieldName), new RecordField(seqType, optional));
        return this;
    }

    private static SeqType unionType(TokenObjectMap<RecordField> rfs) {
        if (rfs.isEmpty()) {
            return Types.ITEM_ZM;
        }
        SeqType ust = null;
        int fs = rfs.size();
        for (int f = 1; f <= fs; ++f) {
            SeqType st = rfs.value(f).seqType();
            ust = ust == null ? st : ust.union(st);
        }
        return ust;
    }

    public TokenObjectMap<RecordField> fields() {
        return this.fields;
    }

    public boolean isExtensible() {
        return this.extensible;
    }

    public boolean hasOptional() {
        int fs = this.fields.size();
        for (int f = 1; f <= fs; ++f) {
            if (!this.fields.value(f).isOptional()) continue;
            return true;
        }
        return false;
    }

    public QNm name() {
        return this.name;
    }

    public AnnList anns() {
        return this.anns;
    }

    public int minFields() {
        int min = 0;
        for (RecordField rf : this.fields.values()) {
            if (rf.optional || rf.expr() != null) {
                return min;
            }
            ++min;
        }
        return min;
    }

    @Override
    public boolean eq(Type type) {
        return this.eq(type, Collections.emptySet(), false);
    }

    public boolean equals(Object obj) {
        RecordType rt;
        return this == obj || obj instanceof RecordType && this.eq(rt = (RecordType)obj, Collections.emptySet(), true);
    }

    private boolean eq(Type type, Set<Pair> pairs, boolean strict) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof RecordType)) {
            return false;
        }
        RecordType rt = (RecordType)type;
        if (this.extensible != rt.extensible || this.fields.size() != rt.fields.size()) {
            return false;
        }
        Predicate<byte[]> compareFields = key -> {
            RecordField rf1 = this.fields.get((byte[])key);
            RecordField rf2 = rt.fields.get((byte[])key);
            if (rf1 == null || rf2 == null || rf1.optional != rf2.optional) {
                return false;
            }
            SeqType st1 = rf1.seqType();
            SeqType st2 = rf2.seqType();
            if (st1.occ != st2.occ) {
                return false;
            }
            Type tp1 = st1.type;
            Type tp2 = st2.type;
            if (tp1 instanceof RecordType) {
                RecordType rt1 = (RecordType)tp1;
                if (tp2 instanceof RecordType) {
                    RecordType rt2 = (RecordType)tp2;
                    Pair pair = new Pair(rt1, rt2);
                    return pairs.contains(pair) || rt1.eq(rt2, pair.addTo(pairs), strict);
                }
            }
            return tp1.eq(tp2);
        };
        if (strict) {
            byte[] key2;
            Iterator<byte[]> iter = this.fields.iterator();
            Iterator<byte[]> iter2 = rt.fields.iterator();
            while ((key2 = iter.next()) != null) {
                if (Token.eq(key2, iter2.next()) && compareFields.test(key2)) continue;
                return false;
            }
        } else {
            for (byte[] key3 : this.fields) {
                if (compareFields.test(key3)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean instanceOf(Type type) {
        return this.instanceOf(type, Collections.emptySet());
    }

    private boolean instanceOf(Type type, Set<Pair> pairs) {
        if (this == type || type.oneOf(Types.RECORD, Types.MAP, Types.FUNCTION, AtomType.ITEM)) {
            return true;
        }
        if (type instanceof ChoiceItemType) {
            ChoiceItemType cit = (ChoiceItemType)type;
            for (SeqType st : cit.types) {
                if (!this.instanceOf(st.type, pairs)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof RecordType) {
            RecordType rt = (RecordType)type;
            if (!rt.extensible) {
                if (this.extensible) {
                    return false;
                }
                for (byte[] key : this.fields) {
                    if (rt.fields.contains(key)) continue;
                    return false;
                }
            }
            for (byte[] key : rt.fields) {
                RecordField rtf = rt.fields.get(key);
                if (this.fields.contains(key)) {
                    SeqType rtfst;
                    RecordField f = this.fields.get(key);
                    if (!rtf.optional && f.optional) {
                        return false;
                    }
                    SeqType fst = f.seqType();
                    if (fst == (rtfst = rtf.seqType())) continue;
                    if (fst.zero()) {
                        if (!rtfst.oneOrMore()) continue;
                        return false;
                    }
                    if (!fst.occ.instanceOf(rtfst.occ)) {
                        return false;
                    }
                    Type ft = fst.type;
                    Type rtft = rtfst.type;
                    if (ft instanceof RecordType) {
                        RecordType rt1 = (RecordType)ft;
                        if (rtft instanceof RecordType) {
                            RecordType rt2 = (RecordType)rtft;
                            Pair pair = new Pair(rt1, rt2);
                            if (pairs.contains(pair) || rt1.instanceOf(rt2, pair.addTo(pairs))) continue;
                            return false;
                        }
                    }
                    if (ft.instanceOf(rtft)) continue;
                    return false;
                }
                if (rtf.optional && (!this.extensible || rtf.seqType() == Types.ITEM_ZM)) continue;
                return false;
            }
            return true;
        }
        if (!this.extensible && type instanceof MapType) {
            MapType mt = (MapType)type;
            if (!mt.keyType().oneOf(AtomType.STRING, AtomType.ANY_ATOMIC_TYPE)) {
                return false;
            }
            int fs = this.fields.size();
            for (int f = 1; f <= fs; ++f) {
                if (this.fields.value(f).seqType().instanceOf(mt.valueType())) continue;
                return false;
            }
            return true;
        }
        if (type instanceof FuncType) {
            FuncType ft = (FuncType)type;
            return this.funcType().declType.instanceOf(ft.declType) && ft.argTypes.length == 1 && ft.argTypes[0].instanceOf(Types.ANY_ATOMIC_TYPE_O);
        }
        return false;
    }

    @Override
    public Type union(Type type) {
        return type == this ? this : this.union(type, Collections.emptySet());
    }

    @Override
    public MapType union(Type kt, SeqType vt) {
        return RecordType.get(this.keyType().union(kt), this.valueType().union(vt));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Type union(Type type, Set<Pair> pairs) {
        block11: {
            if (type instanceof ChoiceItemType) {
                return type.union(this);
            }
            if (type == Types.MAP) {
                return Types.MAP;
            }
            if (this.instanceOf(type)) {
                return type;
            }
            if (type.instanceOf(this)) {
                return this;
            }
            if (!(type instanceof RecordType)) break block11;
            rt = (RecordType)type;
            map = new TokenObjectMap<RecordField>();
            for (byte[] key : this.fields) {
                block12: {
                    f = this.fields.get(key);
                    if (!rt.fields.contains(key)) break block12;
                    rtf = rt.fields.get(key);
                    fst = f.seqType();
                    rtfst = rtf.seqType();
                    ft = fst.type;
                    rtft = rtfst.type;
                    if (!(ft instanceof RecordType)) ** GOTO lbl-1000
                    rt1 = (RecordType)ft;
                    if (!(rtft instanceof RecordType)) ** GOTO lbl-1000
                    rt2 = (RecordType)rtft;
                    if (!fst.zero() && !rtfst.zero()) {
                        pair = new Pair(rt1, rt2);
                        if (pairs.contains(pair)) {
                            return Types.RECORD;
                        }
                        union = SeqType.get(rt1.union((Type)rt2, pair.addTo(pairs)), fst.occ.union(rtfst.occ));
                    } else lbl-1000:
                    // 3 sources

                    {
                        union = fst.union(rtfst);
                    }
                    map.put(key, new RecordField(union, f.optional != false || rtf.optional != false));
                    continue;
                }
                map.put(key, new RecordField(f.seqType, true));
            }
            for (byte[] key : rt.fields) {
                if (this.fields.contains(key)) continue;
                map.put(key, new RecordField(rt.fields.get((byte[])key).seqType, true));
            }
            return new RecordType(map, this.extensible != false || rt.extensible != false);
        }
        if (type instanceof MapType) {
            mt = (MapType)type;
            v0 /* !! */  = mt.union(this.keyType(), this.valueType());
        } else {
            v0 /* !! */  = type instanceof ArrayType != false ? Types.FUNCTION : (type instanceof FuncType != false ? type.union(this) : AtomType.ITEM);
        }
        return v0 /* !! */ ;
    }

    @Override
    public Type intersect(Type type) {
        return type == this ? this : this.intersect(type, Collections.emptySet());
    }

    /*
     * Unable to fully structure code
     */
    private Type intersect(Type type, Set<Pair> pairs) {
        if (type instanceof ChoiceItemType) {
            return type.intersect(this);
        }
        if (this.instanceOf(type)) {
            return this;
        }
        if (type.instanceOf(this)) {
            return type;
        }
        if (!(type instanceof RecordType)) {
            return null;
        }
        rt = (RecordType)type;
        map = new TokenObjectMap<RecordField>();
        for (byte[] key : this.fields) {
            block12: {
                f = this.fields.get(key);
                if (!rt.fields.contains(key)) break block12;
                rtf = rt.fields.get(key);
                fst = f.seqType();
                rtfst = rtf.seqType();
                ft = fst.type;
                rtft = rtfst.type;
                if (!(ft instanceof RecordType)) ** GOTO lbl-1000
                rt1 = (RecordType)ft;
                if (rtft instanceof RecordType) {
                    rt2 = (RecordType)rtft;
                    pair = new Pair(rt1, rt2);
                    if (pairs.contains(pair)) {
                        return null;
                    }
                    it = rt1.intersect(rt2, pair.addTo(pairs));
                    is = it == null ? null : SeqType.get(it, fst.occ.intersect(rtfst.occ));
                } else lbl-1000:
                // 2 sources

                {
                    is = fst.intersect(rtfst);
                }
                if (is == null) {
                    return null;
                }
                map.put(key, new RecordField(is, f.optional != false && rtf.optional != false));
                continue;
            }
            if (!rt.extensible) {
                return null;
            }
            map.put(key, new RecordField(f.seqType));
        }
        for (byte[] key : rt.fields) {
            if (this.fields.contains(key)) continue;
            if (!this.extensible) {
                return null;
            }
            map.put(key, new RecordField(rt.fields.get((byte[])key).seqType));
        }
        return new RecordType(map, this.extensible != false && rt.extensible != false);
    }

    @Override
    public String toString() {
        if (this.name != null) {
            return Token.string(this.name.prefixString());
        }
        QueryString qs = new QueryString().token("record").token('(');
        if (this == Types.RECORD) {
            qs.token('*');
        } else {
            int i = 0;
            for (byte[] key : this.fields) {
                if (i++ != 0) {
                    qs.token(',').token(' ');
                    if (i > 3) {
                        qs.token("...");
                        break;
                    }
                }
                if (XMLToken.isNCName(key)) {
                    qs.token(key);
                } else {
                    qs.quoted(key);
                }
                RecordField f = this.fields.get(key);
                if (f.optional) {
                    qs.token('?');
                }
                if (f.seqType == null) continue;
                Type type = f.seqType.type;
                if (f.seqType.instanceOf(Types.ARRAY_ZM)) {
                    type = Types.ARRAY;
                } else if (f.seqType.instanceOf(Types.MAP_ZM)) {
                    type = Types.MAP;
                }
                qs.token("as").token(type.seqType(f.seqType.occ));
            }
            if (this.extensible) {
                qs.token(',').token(' ').token('*');
            }
        }
        return qs.token(')').toString();
    }

    public static void resolveRefs(QNmMap<RecordType> recordTypeRefs, QNmMap<RecordType> declaredRecordTypes) throws QueryException {
        for (QNm name : recordTypeRefs) {
            RecordType ref = recordTypeRefs.get(name);
            RecordType dec = ref.getDeclaration(declaredRecordTypes);
            ref.extensible = dec.extensible;
            ref.fields = dec.fields;
            ref.info = null;
            ref.finalizeTypes(dec.keyType(), dec.valueType());
        }
    }

    public RecordType getDeclaration(QNmMap<RecordType> declaredRecordTypes) throws QueryException {
        if (this.info == null) {
            return this;
        }
        RecordType rt = declaredRecordTypes.get(this.name);
        if (rt == null) {
            rt = Records.BUILT_IN.get(this.name);
        }
        if (rt == null) {
            throw QueryError.TYPEUNKNOWN_X.get(this.info, AtomType.similar(this.name));
        }
        return rt;
    }

    private record Pair(Object o1, Object o2) {
        public Set<Pair> addTo(Set<Pair> pairs) {
            if (pairs.isEmpty()) {
                HashSet<Pair> set = new HashSet<Pair>();
                set.add(this);
                return set;
            }
            pairs.add(this);
            return pairs;
        }

        @Override
        public String toString() {
            return new QueryString().token('[').token(this.o1).token(',').token(this.o2).token(']').toString();
        }
    }
}

