/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.fn.FnRound;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class Flt
extends ANum {
    public static final Flt NAN = new Flt(Float.NaN);
    public static final Flt ZERO = new Flt(0.0f);
    public static final Flt NEGATIVE_ZERO = new Flt(-0.0f);
    public static final Flt ONE = new Flt(1.0f);
    private final float value;

    private Flt(float value) {
        super(AtomType.FLOAT);
        this.value = value;
    }

    public static Flt get(float value) {
        return value == 0.0f && Float.floatToRawIntBits(value) == 0 ? ZERO : (value == 1.0f ? ONE : (Float.isNaN(value) ? NAN : new Flt(value)));
    }

    @Override
    public byte[] string() {
        return Token.token(this.value);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return !Float.isNaN(this.value) && this.value != 0.0f;
    }

    @Override
    public long itr() {
        return (long)this.value;
    }

    @Override
    public float flt() {
        return this.value;
    }

    @Override
    public double dbl() {
        return this.value;
    }

    @Override
    public BigDecimal dec(InputInfo ii) throws QueryException {
        if (!Double.isFinite(this.value)) {
            throw QueryError.valueError(AtomType.DECIMAL, this.string(), ii);
        }
        return new BigDecimal(this.value);
    }

    @Override
    public Flt abs() {
        return (double)this.value > 0.0 || 1.0f / this.value > 0.0f ? this : Flt.get(-this.value);
    }

    @Override
    public Flt ceiling() {
        float v = (float)Math.ceil(this.value);
        return v == this.value ? this : Flt.get(v);
    }

    @Override
    public Flt floor() {
        float f = (float)Math.floor(this.value);
        return f == this.value ? this : Flt.get(f);
    }

    @Override
    public Flt round(int prec, FnRound.RoundMode mode) {
        if (this.value == 0.0f || Float.isNaN(this.value) || Float.isInfinite(this.value)) {
            return this;
        }
        float f = Dec.round(BigDecimal.valueOf(this.value), prec, mode).floatValue();
        return f == 0.0f && Float.floatToRawIntBits(this.value) < 0 ? NEGATIVE_ZERO : (f == this.value ? this : Flt.get(f));
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        float f = item.flt(ii);
        return item.type.instanceOf(AtomType.DECIMAL) || item instanceof Dbl ? -item.compare(this, coll, transitive, ii) : Dbl.compare(this.value, Float.isInfinite(f) ? item.dbl(ii) : (double)f, transitive);
    }

    @Override
    public Float toJava() {
        return Float.valueOf(this.value);
    }

    @Override
    public int hashCode() {
        float v = this.value;
        int i = (int)v;
        return v == (float)i || Float.isNaN(this.value) || Float.isInfinite(this.value) ? i : super.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Flt)) return false;
        Flt flt = (Flt)obj;
        if (Float.compare(this.value, flt.value) != 0) return false;
        return true;
    }

    public static float parse(byte[] value, InputInfo info) throws QueryException {
        byte[] v = Token.trim(value);
        if (Token.eq(v, Token.NAN)) {
            return Float.NaN;
        }
        if (Token.eq(v, Token.POSITIVE_INF)) {
            return Float.POSITIVE_INFINITY;
        }
        if (Token.eq(v, Token.NEGATIVE_INF)) {
            return Float.NEGATIVE_INFINITY;
        }
        if (!Token.eq(v, Token.POSITIVE_INFINITY, Token.NEGATIVE_INFINITY)) {
            try {
                return Float.parseFloat(Token.string(v));
            }
            catch (NumberFormatException ex) {
                Util.debug(ex);
            }
        }
        throw AtomType.FLOAT.castError(value, info);
    }
}

