/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.util.ArrayIterator;

public final class AnnList
implements Iterable<Ann> {
    public static final AnnList EMPTY = new AnnList(new Ann[0]);
    private final Ann[] anns;

    private AnnList(Ann ... anns) {
        this.anns = anns;
    }

    public boolean contains(Annotation def) {
        return this.get(def) != null;
    }

    public boolean contains(Ann ann) {
        for (Ann a : this.anns) {
            if (!a.equals(ann)) continue;
            return true;
        }
        return false;
    }

    public Ann get(Annotation def) {
        for (Ann ann : this.anns) {
            if (ann.definition != def) continue;
            return ann;
        }
        return null;
    }

    public AnnList attach(Ann ann) {
        int al = this.anns.length;
        Ann[] tmp = Arrays.copyOf(this.anns, al + 1);
        tmp[al] = ann;
        return new AnnList(tmp);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public int size() {
        return this.anns.length;
    }

    public AnnList intersect(AnnList list) {
        Annotation def;
        ArrayList<Ann> tmp = new ArrayList<Ann>();
        boolean pub = false;
        boolean priv = false;
        boolean up = false;
        for (Ann ann : this.anns) {
            def = ann.definition;
            if (def == Annotation.PUBLIC) {
                pub = true;
            } else if (def == Annotation.PRIVATE) {
                priv = true;
            } else if (def == Annotation.UPDATING) {
                up = true;
            }
            tmp.add(ann);
        }
        for (Ann ann : list.anns) {
            def = ann.definition;
            if (def == Annotation.PUBLIC) {
                if (pub) continue;
                if (priv) {
                    return null;
                }
            } else if (def == Annotation.PRIVATE) {
                if (pub) {
                    return null;
                }
                if (priv) {
                    continue;
                }
            } else if (def == Annotation.UPDATING && up) continue;
            tmp.add(ann);
        }
        return new AnnList((Ann[])tmp.toArray(Ann[]::new));
    }

    public AnnList union(AnnList list) {
        ArrayList<Ann> tmp = new ArrayList<Ann>();
        for (Ann ann : this.anns) {
            for (Ann ann2 : list.anns) {
                if (!ann.equals(ann2)) continue;
                tmp.add(ann);
            }
        }
        return new AnnList((Ann[])tmp.toArray(Ann[]::new));
    }

    public AnnList check(boolean variable, boolean visible) throws QueryException {
        boolean up = false;
        boolean vis = false;
        for (Ann ann : this.anns) {
            Annotation def = ann.definition;
            if (def == Annotation.UPDATING) {
                if (up) {
                    throw QueryError.DUPLUPD.get(ann.info, new Object[0]);
                }
                up = true;
                continue;
            }
            if (!visible || def != Annotation.PUBLIC && def != Annotation.PRIVATE) continue;
            if (vis) {
                throw (variable ? QueryError.DUPLVARVIS : QueryError.DUPLFUNVIS).get(ann.info, new Object[0]);
            }
            vis = true;
        }
        return this;
    }

    public void toString(QueryString qs) {
        for (Ann ann : this.anns) {
            ann.toString(qs);
        }
    }

    @Override
    public Iterator<Ann> iterator() {
        return new ArrayIterator<Ann>(this.anns, this.anns.length);
    }
}

