/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.expr.path.Test;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.TokenBuilder;

public final class UnionTest
extends Test {
    public final Test[] tests;

    public UnionTest(Test[] tests) {
        super(UnionTest.unionType(tests));
        this.tests = tests;
    }

    private static NodeType unionType(Test[] tests) {
        Type unionType = tests[0].type;
        for (int i = 1; i < tests.length; ++i) {
            unionType = unionType.union(tests[i].type);
        }
        return unionType;
    }

    @Override
    public Test optimize(Data data) {
        ArrayList<Test> list = new ArrayList<Test>();
        for (Test test : this.tests) {
            Test t = test.optimize(data);
            if (t == null) continue;
            list.add(t);
        }
        return this.tests.length != list.size() ? UnionTest.get(list) : this;
    }

    @Override
    public boolean matches(ANode node) {
        for (Test test : this.tests) {
            if (!test.matches(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean matches(SeqType seqType) {
        Type tp = seqType.type;
        if (tp.intersect(this.type) == null) {
            return Boolean.FALSE;
        }
        for (Test test : this.tests) {
            Boolean matches = test.matches(seqType);
            if (matches == Boolean.FALSE) continue;
            return matches;
        }
        return Boolean.FALSE;
    }

    @Override
    public Test copy() {
        return this;
    }

    @Override
    public boolean instanceOf(Test test) {
        for (Test t : this.tests) {
            if (t.instanceOf(test)) continue;
            return false;
        }
        return true;
    }

    boolean instance(Test test) {
        for (Test t : this.tests) {
            if (!test.instanceOf(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Test intersect(Test test) {
        ArrayList<Test> list = new ArrayList<Test>(this.tests.length);
        for (Test t : this.tests) {
            Test t2 = t.intersect(test);
            if (t2 == null) continue;
            list.add(t2);
        }
        return UnionTest.get(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof UnionTest)) return false;
        UnionTest ut = (UnionTest)obj;
        if (!Arrays.equals(this.tests, ut.tests)) return false;
        return true;
    }

    @Override
    public String toString(boolean full) {
        TokenBuilder tb = new TokenBuilder();
        int ch = 40;
        for (Test test : this.tests) {
            tb.add(ch).add(test.toString(full || test.type == NodeType.ATTRIBUTE));
            ch = 124;
        }
        return tb.add(41).toString();
    }
}

