/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;

public final class JsonW3XmlConverter
extends JsonXmlConverter {
    private final boolean escape;

    JsonW3XmlConverter(JsonParserOptions opts) throws QueryException {
        super(opts);
        this.escape = this.jopts.get(JsonParserOptions.ESCAPE);
    }

    @Override
    protected void openObject() {
        this.openOuter(JsonConstants.MAP);
    }

    @Override
    protected void closeObject() {
        this.closeOuter();
    }

    @Override
    protected void openPair(byte[] key, boolean add) {
        this.addValues.add(add);
        if (add) {
            this.name = this.shared.token(key);
        }
    }

    @Override
    protected void closePair(boolean add) {
        this.addValues.pop();
    }

    @Override
    protected void openArray() {
        this.openOuter(JsonConstants.ARRAY);
    }

    @Override
    protected void closeArray() {
        this.closeOuter();
    }

    @Override
    protected void openItem() {
    }

    @Override
    protected void closeItem() {
    }

    @Override
    void addValue(byte[] type, byte[] value) {
        if (this.addValues.peek()) {
            byte[] val = value != null ? this.shared.token(value) : null;
            FBuilder elem = this.element(type).add(val);
            if (this.escape && value != null && Token.contains(val, 92)) {
                elem.add(Q_ESCAPED, Token.TRUE);
            }
            if (this.curr != null) {
                this.curr.add(elem);
            } else {
                this.curr = elem;
            }
        }
    }

    private void openOuter(byte[] type) {
        this.curr = this.element(type);
        if (this.stack.isEmpty()) {
            this.curr.declareNS();
        }
        this.stack.push(this.curr);
    }

    private void closeOuter() {
        this.curr = (FBuilder)this.stack.pop();
        if (!this.stack.isEmpty()) {
            this.curr = ((FBuilder)this.stack.peek()).add(this.curr);
        }
    }

    private FBuilder element(byte[] type) {
        FBuilder elem = FElem.build(this.shared.qName(type, QueryText.FN_URI));
        if (this.name != null) {
            elem.add(Q_KEY, this.name);
            if (this.escape && Token.contains(this.name, 92)) {
                elem.add(Q_ESCAPED_KEY, Token.TRUE);
            }
            this.name = null;
        }
        return elem;
    }
}

