/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.DataOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjectMap;

public abstract class Value
extends Expr
implements Iterable<Item> {
    public Type type;

    protected Value(Type type) {
        this.type = type;
    }

    public void write(DataOutput out) throws IOException, QueryException {
        throw Util.notExpected();
    }

    @Override
    public final void checkUp() {
    }

    @Override
    public final Value compile(CompileContext cc) {
        return this;
    }

    public boolean isEmpty() {
        return false;
    }

    public abstract Item itemAt(long var1);

    @Override
    public final BasicIter<Item> iter(QueryContext qc) {
        return this.iter();
    }

    @Override
    public Iterator<Item> iterator() {
        return this.iter().iterator();
    }

    public abstract BasicIter<Item> iter();

    @Override
    public final Value value(QueryContext qc) {
        return this;
    }

    public final Value subsequence(long pos, long length, QueryContext qc) {
        return length == 0L ? Empty.VALUE : (length == 1L ? this.itemAt(pos) : (length == this.size() ? this : this.subSeq(pos, length, qc)));
    }

    protected abstract Value subSeq(long var1, long var3, QueryContext var5);

    public final Value append(Value value, QueryContext qc) {
        return this.insert(this.size(), value, qc);
    }

    public final Value insert(long pos, Value value, QueryContext qc) {
        long size = this.size();
        long vsize = value.size();
        return size == 0L ? value : (vsize == 0L ? this : (pos == size && size < vsize ? value.insertValue(0L, this, qc) : this.insertValue(pos, value, qc)));
    }

    public abstract Value insertValue(long var1, Value var3, QueryContext var4);

    public abstract Value removeItem(long var1, QueryContext var3);

    public abstract void cache(boolean var1, InputInfo var2) throws QueryException;

    public abstract Object toJava() throws QueryException;

    @Override
    public final boolean has(Flag ... flags) {
        return false;
    }

    @Override
    public final boolean inlineable(InlineContext ic) {
        return true;
    }

    @Override
    public final VarUsage count(Var var) {
        return VarUsage.NEVER;
    }

    @Override
    public final Expr inline(InlineContext ic) {
        return null;
    }

    @Override
    public Value copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this;
    }

    public abstract Value materialize(Predicate<Data> var1, InputInfo var2, QueryContext var3) throws QueryException;

    public abstract boolean materialized(Predicate<Data> var1, InputInfo var2) throws QueryException;

    public final ArrayOutput serialize() throws QueryIOException {
        return this.serialize((SerializerOptions)null);
    }

    public final ArrayOutput serialize(SerializerOptions options) throws QueryIOException {
        ArrayOutput ao = new ArrayOutput();
        try {
            this.serialize(Serializer.get(ao, options));
        }
        catch (QueryIOException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw QueryError.SERPARAM_X.getIO(ex);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Util.debug(ex);
            throw QueryError.BASEX_ERROR_X.getIO(ex.getLocalizedMessage());
        }
        return ao;
    }

    public final void serialize(Serializer ser) throws IOException {
        for (Item item : this) {
            if (ser.finished()) break;
            ser.serialize(item);
        }
    }

    public abstract Value reverse(QueryContext var1);

    public abstract boolean refineType() throws QueryException;

    public abstract Value shrink(QueryContext var1) throws QueryException;

    protected abstract Value rebuild(QueryContext var1) throws QueryException;

    @Override
    public boolean accept(ASTVisitor visitor) {
        Data data = this.data();
        return data == null || visitor.lock(data.meta.name);
    }

    @Override
    public final int exprSize() {
        return 1;
    }
}

