/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.core.users.Perm;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.up.expr.Update;
import org.basex.query.up.primitives.node.ReplaceNode;
import org.basex.query.up.primitives.node.ReplaceValue;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FComm;
import org.basex.query.value.node.FPI;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjectMap;

public final class Replace
extends Update {
    private final boolean value;

    public Replace(InputInfo info, Expr trg, Expr src, boolean value) {
        super(info, trg, src);
        this.value = value;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Iter iter = this.arg(0).iter(qc);
        FBuilder builder = null;
        while ((item = iter.next()) != null) {
            ANodeList list;
            Type type = item.type;
            if (!(type instanceof NodeType) || type == NodeType.DOCUMENT_NODE) {
                throw QueryError.UPTRGNODE_X.get(this.info, item);
            }
            ANode targ = (ANode)item;
            Updates updates = qc.updates();
            DBNode dbnode = updates.determineDataRef(targ, qc);
            this.checkPerm(qc, Perm.WRITE, dbnode.data().meta.name);
            if (builder == null) {
                builder = this.builder(this.arg(1), qc);
            }
            if (this.value) {
                byte[] text = Token.EMPTY;
                if (builder.children != null) {
                    text = ((ANode)builder.children.get(0)).string();
                } else if (builder.attributes != null) {
                    text = ((ANode)builder.attributes.get(0)).string();
                }
                if (type == NodeType.COMMENT) {
                    FComm.parse(text, this.info);
                }
                if (type == NodeType.PROCESSING_INSTRUCTION) {
                    FPI.parse(text, this.info);
                }
                updates.add(new ReplaceValue(dbnode.pre(), dbnode.data(), this.info, text), qc);
                continue;
            }
            ANode parent = targ.parent();
            if (parent == null) {
                throw QueryError.UPNOPAR_X.get(this.info, targ);
            }
            if (type == NodeType.ATTRIBUTE) {
                if (builder.children != null) {
                    throw QueryError.UPWRATTR_X.get(this.info, builder.children.get(0));
                }
                list = builder.attributes != null ? this.checkNS(builder.attributes, parent) : new ANodeList();
            } else {
                if (builder.attributes != null) {
                    throw QueryError.UPWRELM_X.get(this.info, targ);
                }
                list = builder.children != null ? builder.children : new ANodeList();
            }
            updates.add(new ReplaceNode(dbnode.pre(), dbnode.data(), this.info, list), qc);
        }
        return Empty.VALUE;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Replace(this.info, this.arg(0).copy(cc, vm), this.arg(1).copy(cc, vm), this.value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Replace)) return false;
        Replace rplc = (Replace)obj;
        if (this.value != rplc.value) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("replace");
        if (this.value) {
            qs.token("value").token("of");
        }
        qs.token("node").token(this.arg(0)).token("with").token(this.arg(1));
    }
}

