/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.user;

import java.util.ArrayList;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.user.UserFn;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.UserPermUpdate;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class UserCreate
extends UserFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        String name = this.toInactiveName(this.arg(0), qc);
        String password = this.toString(this.arg(1), qc);
        ArrayList<Perm> perms = this.toPermissions(this.arg(2), qc);
        StringList patterns = this.toPatterns(this.arg(3), qc);
        User user = new User(name, password);
        if (name.equals("admin")) {
            throw QueryError.USER_ADMIN.get(this.info, new Object[0]);
        }
        if (this.defined(4)) {
            ANode node = this.toElem(this.arg(4), Q_INFO, qc, QueryError.ELM_X_X_X);
            user.info((ANode)node.materialize(n -> false, this.info, qc));
        }
        qc.updates().add(new Create(user, perms, patterns, qc, this.info), qc);
        return Empty.VALUE;
    }

    private static final class Create
    extends UserPermUpdate {
        private Create(User user, ArrayList<Perm> perms, StringList patterns, QueryContext qc, InputInfo info) throws QueryException {
            super(UpdateType.USERCREATE, user, perms, patterns, qc, info);
        }

        @Override
        public void apply() {
            User old = this.users.get(this.user.name());
            if (old != null) {
                this.users.drop(old);
            }
            this.users.add(this.user);
            this.grant();
        }

        @Override
        public String operation() {
            return "created";
        }
    }
}

