/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.DeepLookup;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.XQStruct;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Enums;
import org.basex.util.InputInfo;
import org.basex.util.XMLToken;

public abstract class ALookup
extends Arr {
    public static final Str WILDCARD = Str.get(42);
    protected final Modifier modifier;

    public ALookup(InputInfo info, Modifier modifier, Expr ... expr) {
        super(info, SeqType.ITEM_ZM, expr);
        this.modifier = modifier;
    }

    final Value valueFor(Item item, boolean deep, QueryContext qc) throws QueryException {
        Item key2;
        if (!(item instanceof XQStruct)) {
            throw QueryError.LOOKUP_X.get(this.info, item);
        }
        XQStruct struct = (XQStruct)item;
        Expr keys = this.exprs[1];
        if (keys == WILDCARD) {
            if (this.modifier == Modifier.ITEMS) {
                return struct.items(qc);
            }
            ValueBuilder vb = new ValueBuilder(qc);
            if (struct instanceof XQArray) {
                XQArray array = (XQArray)struct;
                long k = 0L;
                for (Value val : array.iterable()) {
                    vb.add(this.modify(Itr.get(++k), val));
                }
            } else {
                ((XQMap)struct).forEach((key, value) -> vb.add(this.modify((Item)key, (Value)value)));
            }
            return vb.value();
        }
        ValueBuilder vb = new ValueBuilder(qc);
        Iter ir = keys.atomIter(qc, this.info);
        while ((key2 = ir.next()) != null) {
            Value value2 = null;
            if (struct instanceof XQMap) {
                XQMap map = (XQMap)struct;
                value2 = map.getOrNull(key2);
                if (value2 instanceof FuncItem) {
                    FuncItem fi = (FuncItem)value2;
                    value2 = fi.toMethod(struct);
                }
            } else {
                Item index = null;
                if (!deep) {
                    index = key2;
                } else if (key2.type.isNumber()) {
                    Item cast = AtomType.INTEGER.cast(key2, qc, this.info);
                    Item item2 = index = key2.equal(cast, null, this.info) ? cast : null;
                }
                if (index != null) {
                    value2 = ((XQArray)struct).getOrNull(index, qc, this.info);
                }
            }
            if (value2 == null) continue;
            vb.add(this.modify(key2, value2));
        }
        return vb.value(this);
    }

    @Override
    public final void toString(QueryString qs) {
        Itr itr;
        long l;
        qs.token(this.exprs[0]).token('?');
        if (this instanceof DeepLookup) {
            qs.token('?');
        }
        if (this.modifier != Modifier.ITEMS) {
            qs.concat(new Object[]{this.modifier, "::"});
        }
        Expr keys = this.exprs[1];
        Object key = null;
        if (keys == WILDCARD) {
            key = WILDCARD.string();
        } else if (keys instanceof Str) {
            Str str = (Str)keys;
            if (XMLToken.isNCName(str.string())) {
                key = str.toJava();
            }
        } else if (keys instanceof Itr && (l = (itr = (Itr)keys).itr()) >= 0L) {
            key = l;
        }
        if (key != null) {
            qs.token(key);
        } else {
            qs.paren(keys);
        }
    }

    private Value modify(Item key, Value value) throws QueryException {
        return switch (this.modifier) {
            case Modifier.ITEMS -> value;
            case Modifier.KEYS -> key;
            case Modifier.PAIRS -> XQMap.pair(key, value);
            default -> {
                ArrayBuilder ab = new ArrayBuilder();
                value.forEach(ab::add);
                yield ab.array();
            }
        };
    }

    public static enum Modifier {
        ITEMS,
        KEYS,
        PAIRS,
        VALUES;


        public String toString() {
            return Enums.string(this);
        }
    }
}

