/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import org.basex.gui.GUIConstants;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.list.StringList;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Comment;
import org.basex.util.options.NumberOption;
import org.basex.util.options.NumbersOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;
import org.basex.util.options.StringsOption;

public final class GUIOptions
extends Options {
    public static final Comment C_VERSION = new Comment("Version");
    public static final StringOption UPDATEVERSION = new StringOption("UPDATEVERSION", Prop.VERSION.replaceAll(" .*", ""));
    public static final BooleanOption CHECKUPDATES = new BooleanOption("CHECKUPDATES", false);
    public static final Comment C_PATHS = new Comment("Paths");
    public static final StringOption INPUTPATH = new StringOption("INPUTPATH", Prop.HOMEDIR);
    public static final StringOption DATAPATH = new StringOption("DATAPATH", Prop.HOMEDIR);
    public static final StringOption WORKPATH = new StringOption("WORKPATH", Prop.HOMEDIR);
    public static final StringOption PROJECTPATH = new StringOption("PROJECTPATH", "");
    public static final Comment C_LAYOUT = new Comment("Layout");
    public static final StringOption FONT = new StringOption("FONT", "SansSerif");
    public static final StringOption MONOFONT = new StringOption("MONOFONT", GUIConstants.MONOFONT);
    public static final NumberOption FONTSIZE = new NumberOption("FONTSIZE", 15);
    public static final BooleanOption LISTMONO = new BooleanOption("LISTMONO", true);
    public static final StringOption ANTIALIAS = new StringOption("ANTIALIAS", "System");
    public static final NumberOption COLORRED = new NumberOption("COLORRED", 21);
    public static final NumberOption COLORGREEN = new NumberOption("COLORGREEN", 14);
    public static final NumberOption COLORBLUE = new NumberOption("COLORBLUE", 7);
    public static final Comment C_WINDOWS = new Comment("Windows");
    public static final StringOption VIEWS = new StringOption("VIEWS", "V H editor folder map plot  - H text info table tree explore - -");
    public static final NumbersOption GUISIZE = new NumbersOption("GUISIZE", 1004, 748);
    public static final NumbersOption GUILOC = new NumbersOption("GUILOC", 10, 10);
    public static final BooleanOption MAXSTATE = new BooleanOption("MAXSTATE", false);
    public static final BooleanOption SHOWBUTTONS = new BooleanOption("SHOWBUTTONS", true);
    public static final BooleanOption SHOWINPUT = new BooleanOption("SHOWINPUT", true);
    public static final BooleanOption SHOWSTATUS = new BooleanOption("SHOWSTATUS", true);
    public static final BooleanOption SHOWINFO = new BooleanOption("SHOWINFO", true);
    public static final BooleanOption SHOWMAP = new BooleanOption("SHOWMAP", true);
    public static final BooleanOption SHOWTABLE = new BooleanOption("SHOWTABLE", false);
    public static final BooleanOption SHOWTEXT = new BooleanOption("SHOWTEXT", true);
    public static final BooleanOption SHOWFOLDER = new BooleanOption("SHOWFOLDER", false);
    public static final BooleanOption SHOWEXPLORE = new BooleanOption("SHOWEXPLORE", false);
    public static final BooleanOption SHOWPLOT = new BooleanOption("SHOWPLOT", false);
    public static final BooleanOption SHOWEDITOR = new BooleanOption("SHOWEDITOR", true);
    public static final BooleanOption SHOWTREE = new BooleanOption("SHOWTREE", false);
    public static final BooleanOption SHOWPROJECT = new BooleanOption("SHOWPROJECT", true);
    public static final BooleanOption INDENTRESULT = new BooleanOption("INDENTRESULT", false);
    public static final NumberOption PREFTAB = new NumberOption("PREFTAB", 0);
    public static final StringOption LOOKANDFEEL = new StringOption("LOOKANDFEEL", "");
    public static final StringOption LABELS = new StringOption("LABELS", "name,label,id");
    public static final BooleanOption SCROLLTABS = new BooleanOption("SCROLLTABS", true);
    public static final BooleanOption MOUSEFOCUS = new BooleanOption("MOUSEFOCUS", false);
    public static final StringOption XMLSUFFIXES = new StringOption("XMLSUFFIXES", "xml,xsd,svg,rdf,rss,rng,sch,xhtml");
    public static final BooleanOption ASCSORT = new BooleanOption("ASCSORT", true);
    public static final BooleanOption CASESORT = new BooleanOption("CASESORT", true);
    public static final BooleanOption MERGEDUPL = new BooleanOption("MERGEDUPL", false);
    public static final NumberOption COLUMN = new NumberOption("COLUMN", 1);
    public static final BooleanOption UNICODE = new BooleanOption("UNICODE", true);
    public static final BooleanOption SHOWMARGIN = new BooleanOption("SHOWMARGIN", true);
    public static final NumberOption MARGIN = new NumberOption("MARGIN", 80);
    public static final BooleanOption TABSPACES = new BooleanOption("TABSPACES", true);
    public static final NumberOption INDENT = new NumberOption("INDENT", 2);
    public static final BooleanOption SHOWINVISIBLE = new BooleanOption("SHOWINVISIBLE", true);
    public static final BooleanOption SHOWNL = new BooleanOption("SHOWNL", false);
    public static final BooleanOption SHOWLINES = new BooleanOption("SHOWLINES", true);
    public static final BooleanOption MARKLINE = new BooleanOption("MARKLINE", true);
    public static final BooleanOption SAVERUN = new BooleanOption("SAVERUN", false);
    public static final BooleanOption PARSEPROJ = new BooleanOption("PARSEPROJ", true);
    public static final BooleanOption AUTO = new BooleanOption("AUTO", true);
    public static final StringOption FILES = new StringOption("FILES", "*.xml, *.xq*");
    public static final BooleanOption SHOWHIDDEN = new BooleanOption("SHOWHIDDEN", false);
    public static final NumberOption SEARCHMODE = new NumberOption("SEARCHMODE", 0);
    public static final BooleanOption FILTERRT = new BooleanOption("FILTERRT", false);
    public static final BooleanOption EXECRT = new BooleanOption("EXECRT", false);
    public static final StringOption DBNAME = new StringOption("DBNAME", "");
    public static final NumberOption LASTINSERT = new NumberOption("LASTINSERT", 1);
    public static final Comment C_VISUALIZATIONS = new Comment("Visualizations");
    public static final BooleanOption MAPATTS = new BooleanOption("MAPATTS", false);
    public static final NumberOption MAPOFFSETS = new NumberOption("MAPOFFSETS", 3);
    public static final NumberOption MAPALGO = new NumberOption("MAPALGO", 0);
    public static final NumberOption MAPWEIGHT = new NumberOption("MAPWEIGHT", 0);
    public static final BooleanOption TREESLIMS = new BooleanOption("TREESLIM", true);
    public static final BooleanOption TREEATTS = new BooleanOption("TREEATTS", false);
    public static final NumberOption PLOTDOTS = new NumberOption("PLOTDOTS", 0);
    public static final BooleanOption PLOTXLOG = new BooleanOption("PLOTXLOG", false);
    public static final BooleanOption PLOTYLOG = new BooleanOption("PLOTYLOG", false);
    public static final NumberOption MAXTEXT = new NumberOption("MAXTEXT", 0x800000);
    public static final NumberOption MAXRESULTS = new NumberOption("MAXRESULTS", 500000);
    public static final Comment C_SEARCH = new Comment("Search");
    public static final StringsOption SEARCHED = new StringsOption("SEARCHED", new String[0]);
    public static final StringsOption REPLACED = new StringsOption("REPLACED", new String[0]);
    public static final Comment C_HISTORY = new Comment("History");
    public static final StringsOption COMMANDS = new StringsOption("COMMANDS", new String[0]);
    public static final StringsOption SEARCH = new StringsOption("SEARCH", new String[0]);
    public static final StringsOption XQUERY = new StringsOption("XQUERY", new String[0]);
    public static final Comment C_FILES = new Comment("Files");
    public static final StringsOption EDITOR = new StringsOption("EDITOR", new String[0]);
    public static final StringsOption INPUTS = new StringsOption("INPUTS", new String[0]);
    public static final StringsOption OPEN = new StringsOption("OPEN", new String[0]);
    public static final StringsOption PROJECTS = new StringsOption("PROJECTS", new String[0]);
    public static final StringsOption PROJFILES = new StringsOption("PROJFILES", new String[0]);
    public static final StringsOption PROJCONTS = new StringsOption("PROJCONTS", new String[0]);

    public GUIOptions() {
        super(new IOFile(Prop.HOMEDIR + ".basexgui"));
        this.set(FILTERRT, false);
        this.set(EXECRT, false);
        for (StringOption stringOption : new StringOption[]{WORKPATH, PROJECTPATH}) {
            this.setFile(stringOption, new IOFile(this.get(stringOption)));
        }
        for (Option option : new StringsOption[]{EDITOR, OPEN, PROJECTS}) {
            this.setFiles((StringsOption)option, this.get((StringsOption)option));
        }
    }

    public synchronized void setFiles(StringsOption option, String[] paths) {
        StringList list = new StringList();
        for (String path : paths) {
            IOFile file = new IOFile(path);
            if (!file.exists()) continue;
            list.addUnique(file.path());
        }
        this.set(option, (String[])list.finish());
    }

    public synchronized void setFile(StringOption option, IOFile file) {
        this.set(option, file.normalize().path());
    }

    public synchronized String[] xmlSuffixes() {
        StringList list = new StringList();
        for (String suffix : this.get(XMLSUFFIXES).split("\\W+")) {
            list.add("." + suffix);
        }
        return (String[])list.finish();
    }
}

