#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 non installata"},
    {TR_NO_PATCH_MESSAGE,
        "La tua installazione di Caesar 3 non comprende la patch 1.0.1.0."
        "Puoi scaricare la patch da:\n"
        URL_PATCHES "\n"
        "Prosegui a tuo rischio e pericolo."},
    {TR_MISSING_FONTS_TITLE, "Font mancanti"},
    {TR_MISSING_FONTS_MESSAGE,
        "La tua installazione di Caesar 3 richiede i font aggiuntivi."
        "Puoi scaricare la patch da:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Editor non installato"},
    {TR_NO_EDITOR_MESSAGE,
        "La tua installazione di Caesar 3 non comprende l'editor delle mappe. "
        "Puoi scaricarlo da:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Cartella della lingua non valida"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "La cartella selezionata non contiene un pacchetto di lingua corretto."
        "Per favore controlla il log degli errori."},
    {TR_BUILD_ALL_TEMPLES, "Tutti"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Cancella"},
    {TR_BUTTON_RESET_DEFAULTS, "Ripristina default"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Tasti rapidi"},
    {TR_CONFIG_TITLE, "Opzioni di configurazione di Augustus"},
    {TR_CONFIG_LANGUAGE_LABEL, "Lingua:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(default)"},
    {TR_CONFIG_DISPLAY_SCALE, "Ridimensionamento display:"},
    {TR_CONFIG_CURSOR_SCALE, "Ridimensionamento cursore:"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Modifiche all'interfaccia utente"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Modifiche al gioco"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Riproduci video introduttivo"},
    {TR_CONFIG_SIDEBAR_INFO, "Informazioni extra nel pannello di controllo"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Abilita lo scorrimento fluido"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Disabilita lo spostamento della mappa col tasto destro"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Migliora l'aspetto liberando il terreno"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Consente la costruzione di ogni tempio in successione"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Mostra la copertura di cisterne, fontane e pozzi"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Mostra le dimensioni della costruzione durante il trascinamento"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Evidenzia la legione al passaggio del cursore"},
    {TR_CONFIG_ROTATE_MANUALLY, "Ruota i Bastioni e l'Arco di Trionfo tramite scorciatoie da tastiera"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Abilita il pannello militare"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Correggi il bug dell'immigrazione al livello molto difficile"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Corregge il bug dei centenari"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Elimina le complicazioni al cambio di Imperatore"},
    {TR_CONFIG_DRAW_WALKER_WAYPOINTS, "Visualizza il percorso del camminatore cliccando con il tasto destro del mouse su un edificio"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Fissa colonne di valutazione non completate su obiettivi bassi"},
    {TR_CONFIG_GRANDFESTIVAL, "Le grandi feste permettono una benedizione extra da parte di una divinità"},
    {TR_CONFIG_JEALOUS_GODS, "Disabilita gelosia delle divinità"},
    {TR_CONFIG_GLOBAL_LABOUR, "Abilita mercato del lavoro globale"},
    {TR_CONFIG_SCHOOL_WALKERS, "Aumenta la distanza massima percorribile dagli scolari"},
    {TR_CONFIG_RETIRE_AT_60, "Cambia l'età della pensione da 50 a 60 anni"},
    {TR_CONFIG_FIXED_WORKERS, "Mercato del lavoro fisso - 38% della popolazione plebea"},
    {TR_CONFIG_EXTRA_FORTS, "Consenti l'edificazione di 4 forti supplementari"},
    {TR_CONFIG_WOLVES_BLOCK, "Impedisci la costruzione vicino ai lupi"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Bloccare le strade del granaio non collegate"},
    {TR_CONFIG_MORE_STOCKPILE, "Le case accumulano più merci dal mercato"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Le signore del mercato non distribuiscono merci"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Rimuovi edifici immediatamente"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "I carrelli da e verso i granai possono uscire dalle strade"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Raddoppia la capacità dei carrelli da e verso i granai"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Le sentinelle della torre non hanno bisogno di un accesso stradale dalle caserme"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Le fattorie e i moli consegnano solo ai granai vicini"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Il cibo non viene consegnato da/verso i granai."},
    {TR_CONFIG_ALL_HOUSES_MERGE, "Tutte le case si uniscono"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Le vie commerciali aperte contano come fornitura di diversi tipi di vino"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "I crolli improvvisi delle miniere costano soldi"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Permetti la costruzione di caserme multiple" },
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "I magazzini non accettano nulla quando costruiti"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Le case non si espandono nei giardini"},
    {TR_HOTKEY_TITLE, "Configurazione scorciatoie da tastiera Augustus"},
    {TR_HOTKEY_LABEL, "Tasto"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternativa"},
    {TR_HOTKEY_HEADER_ARROWS, "Pulsanti frecce"},
    {TR_HOTKEY_HEADER_GLOBAL, "Scorciatoie globali"},
    {TR_HOTKEY_HEADER_CITY, "Scorciatoie città"},
    {TR_HOTKEY_HEADER_ADVISORS, "Consiglieri"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Sovrapposizioni mappa"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Segnalibri mappa città"},
    {TR_HOTKEY_HEADER_EDITOR, "Editor"},
    {TR_HOTKEY_HEADER_BUILD, "Scorciatoie costruzione"},
    {TR_HOTKEY_ARROW_UP, "Su"},
    {TR_HOTKEY_ARROW_DOWN, "Giù"},
    {TR_HOTKEY_ARROW_LEFT, "Sinistra"},
    {TR_HOTKEY_ARROW_RIGHT, "Destra"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Tutto schermo"},
    {TR_HOTKEY_CENTER_WINDOW, "Centra la finestra"},
    {TR_HOTKEY_RESIZE_TO_640, "Finestra a 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Finestra a 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Finestra a 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Salva Schermata"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Salva Schermata dell'intera città"},
    {TR_HOTKEY_BUILD_CLONE, "Clona l'edificio sotto il cursore"},
    {TR_HOTKEY_LOAD_FILE, "Carica file"},
    {TR_HOTKEY_SAVE_FILE, "Salva file"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Aumenta velocità gioco"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Diminuisci velocità gioco"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Pausa"},
    {TR_HOTKEY_CYCLE_LEGION, "Scorri le legioni"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Ruota la mappa a sinistra"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Ruota la mappa a destra"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Consigliere del lavoro"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Consigliere militare"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Consigliere imperiale"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Consigliere del livelli"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Consigliere del commercio"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Consigliere della popolazione"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Consigliere della salute"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Consigliere dell'educazione"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Consigliere degli intrattenimenti"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Consigliere religioso"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Consigliere finanziario"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Consigliere capo"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Consigliere delle abitazioni"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Disabilita sovrapposizione attuale"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Mostra sovrapposizione acque"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Mostra sovrapposizione fuoco"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Mostra sovrapposizione danni"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Mostra sovrapposizione crimine"},
    {TR_HOTKEY_ROTATE_BUILDING, "Ruota edificio"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Mostra sovrapposizione problemi"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Vai a segnaposto 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Vai a segnaposto 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Vai a segnaposto 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Vai a segnaposto 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Imposta segnaposto 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Imposta segnaposto 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Imposta segnaposto 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Imposta segnaposto 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Mostra informazioni della Battaglia"},
    {TR_HOTKEY_EDIT_TITLE, "Premi nuova pulsante scorciatoia"},
    {TR_BUILDING_ROADBLOCK, "Blocco stradale"},
    {TR_BUILDING_ROADBLOCK_DESC, "Il Blocco stradale blocca i vagabondi."},
    {TR_BUILDING_ARCHITECT_GUILD, "Gilda degli Ingienieri" },
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Gli ingenieri di questa gilda lavorano senza sosta alla costruzione dei monumenti per la gloria di Roma" },
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Concedi un epiteto sul tempio" },
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Tempio Grande di Cerere" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Tempio Grande di Nettuno" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Tempio Grande di Mercurio" },
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Tempio Grande di Marte" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Tempio Grande di Venere" },
    {TR_BUILDING_PANTHEON, "Pantheon" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Tempio Grande di Cerere" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Tempio Grande di Nettuno" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Tempio Grande di Mercurio" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Tempio Grande di Marte" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Tempio Grande di Venere" },
    {TR_BUILDING_PANTHEON_DESC, "Pantheon" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "I braccianti si muovono il 50% più velocemente." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Garantisce +1 al raggio di azione di fontane e pozzi e + 2 alle riserve. Il costo del lavoro degli impianti idrici è ridotto del 50%. Le navi da commercio viaggiano il 25% più velocemente." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "I commercianti via terra e via mare hanno il 50% in più di capicità di carico. I commercianti via terra si muovono il 25% più velocemente." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Addestra i soldati come una caserma. Possono essere costruiti quattro forti supplementari." },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Giardini, statue e templi risplendono con maggiore bellezza aumentando la loro desiderabilità. Le case accumulano più beni e si impoveriscono più lentamente." },
    {TR_BUILDING_PANTHEON_BONUS_DESC, "Fornisce accesso a tutte le divinità. Vi si tengono festival annuali e riduce il personale dei templi del 25%" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "I sacerdoti riducono il consumo di cibo del 20%." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "I templi producono aurighi per l'ippodromo." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "I sacerdoti riducono il consumo di vettovaglie e mobili del 20%." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "I templi generano cibo, in un ammontare pari al numero di case che coprono e lo consegnano al mercato." },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "Il Tempio Grande produce vino in quantità in scala alla popolazione con accesso al tempio di Venere. I templi lo raccolgono e lo distribuiscono alle case." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "I sacerdoti accumulano e distribuiscono olio e un altro genere alimentare dai magazzini." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "I sacerdoti espandono la capacità abitativa delle case del 5%. Il tempio grande fornisce acqua come una riserva" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "I sacerdoti riducono il consumo di olio e vino del 20%." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "I sacerdoti riducono il consumo di ogni bene del 10%" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "I sacerdoti offrono intrattenimento e abbelliscono le case, aumentando l'attrattività delle abitiazioni senza bisogno di ulteriori decorazioni." },
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "Tutti i templi mandano dei sacerdoti al Patheon, diffondendo la fede nelle proprie divinità ed elargendo benedizioni." },
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Le case con accesso al Patheon possono migliorare di un livello aggiuntivo." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Tempio di Cerere Promitor" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Tempio di Cerere Reparator" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Tempio di Nettuno Equester" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Tempio di Nettuno Adiutor" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Tempio di Mercurio Fortunus" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Tempio dell'Abbondanza di Mercurio" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Tempio di Marte Ultor" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Tempio di Marte Quirinus" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Tempio di Venere Verticordia" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Tempio di Venere Genetrix" },
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheon Ara Maxima" },
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheon Roma Aeterna" },
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Tempio Grande" },
    {TR_BUILDING_WORK_CAMP, "Campo di Lavoro" },
    {TR_BUILDING_WORK_CAMP_DESC, "Gli operai si radunano qui per il trasporto dei materiali da costruzione del cantiere." },
    {TR_HEADER_HOUSING, "Alloggi"},
    {TR_ADVISOR_HOUSING_ROOM, "Gli alloggi della città hanno posti disponibili"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "La città non ha alloggi disponibili."},
    {TR_ADVISOR_RESIDENCES_DEMANDING_POTTERY, "I residenti richiedono vettovaglie"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_FURNITURE, "I residenti richiedono mobili"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_OIL, "I residenti richiedono olio"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_WINE, "I residenti richiedono vino"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Totale residenti:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Capacità rimanente:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Capacità complessiva:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Popolazione - alloggi"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Grafici"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, " Il rating di prosperità di questa abitazione è:"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "La percentuale di popolazione in ville e palazzi è:"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "La percentuale di popolazione in tende e baracche è:"},
    {TR_ADVISOR_AVERAGE_TAX, "Introito medio per residente:"},
    {TR_ADVISOR_AVERAGE_AGE, "Età media della popolazione:"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Percentuale della popolazione come forza lavoro:"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Nascite nell'ultimo anno:"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Morti nell'ultimo anno:"},
    {TR_ADVISOR_TOTAL_POPULATION, "residenti totali"},
    {TR_REQUIRED_RESOURCES, "Risorse consegnate per la fase attuale:"},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "La costruzione di grandi templi richiede materiale conservato in un magazzino, operai da un campo di lavoro e ingegneri da una gilda di ingegneri."},
    {TR_CONSTRUCTION_PHASE, "Fase della costruzione:"},
    {TR_ADD_MODULE, "Riconsacrare il tempio?"},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Epiteto conferito."},

    {TR_BUILDING_CERES_TEMPLE_QUOTE, "Per prima Cerere smosse col vomere dell'aratro le zolle,\nper prima diede in coltura alla terra messi e frutti,\nper prima diede leggi: a Cerere dobbiamo tutto.\n-Ovid, the Metamorphoses, Book V" },

    { TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "Cessò la furia del mare e, deposto il suo tridente,\nil dio degli oceani rabbonì le acque, chiamò l'azzurro Tritone\nche sporge fuori dai gorghi con le spalle incrostate di conchiglie\ne gli ordinò di soffiare nel suo corno sonoro\nperché a quel segnale rientrassero flutti e fiumi\n-Ovidio, Metamorfosi, Libro I"},

    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Poiché predare bovi si possono, e floride greggi,\ntripodi puoi conquistare, cavalli di bionda cervice;\nma che ritorni d’un uomo lo spirito, quando la cerchia\nlasciò dei denti, cosa non è che si predi o s’acquisti.\n-Omero, L'Iliade, Libro IX"},

    {TR_BUILDING_MARS_TEMPLE_QUOTE, "Fe' Turno inalberar di guerra il segno,\ne che guerra sonâr le roche trombe,\nspinti i carri e i destrieri, e l'armi scosse di Marte al tempio.\n-Virgilio, Eneide, Libro VIII" },

    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "O Venere, o Cupido, che voli intorno alla tua tenera madre,\nche godimento ho provato, che voluttà autentica m'ha pervaso,\nabbandonata al languore, sfibrata sino all'anima.\n-Ovidio, Metamorfosi, Libro IX" },

    {TR_BUILDING_PANTHEON_QUOTE, "Si apre intanto la casa dell´onnipotente Olimpo\ned il padre e re degli dei e degli uomini convoca il concilio.\nnella sede siderea, da cui alto contempla tutte le terre\ngli accampamenti dei Dardanidi ed i popoli latini.\n-Virgilio, Eneide, Libro X" },

    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "I lavoratori stanno costruendo il podio che innalzerà il tempio e fornirà una solida base per resistere al passare del tempo." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Gli artigiani stanno realizzando il portico, che ospita l'altare sacrificale del tempio." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Gli ingegneri stanno realizzando la cella, l'interno del tempio che ospita le immagini sacre." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Sono iniziati i lavori per il praecinctum del tempio, dove i fedeli si riuniranno all'aperto per le cerimonie pubbliche." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Con il tempio quasi completo, i sacerdoti si riuniscono per eseguire i riti di consacrazione." },
    {TR_BUILDING_MENU_TREES, "Alberi" },
    {TR_BUILDING_MENU_PATHS, "Sentieri" },
    {TR_BUILDING_MENU_PARKS, "Parchi"},
    {TR_BUILDING_SMALL_POND, "Piccolo stagno"},
    {TR_BUILDING_LARGE_POND, "Grande stagno"},
    {TR_BUILDING_PINE_TREE, "Pino"},
    {TR_BUILDING_FIR_TREE, "Abete" },
    {TR_BUILDING_OAK_TREE, "Quercia" },
    {TR_BUILDING_ELM_TREE, "Olmo" },
    {TR_BUILDING_FIG_TREE, "Fico" },
    {TR_BUILDING_PLUM_TREE, "Prugno" },
    {TR_BUILDING_PALM_TREE, "Palma" },
    {TR_BUILDING_DATE_TREE, "Palma da dattero" },
    {TR_BUILDING_PINE_PATH, "Sentiero con pini" },
    {TR_BUILDING_FIR_PATH, "Sentiero con abeti" },
    {TR_BUILDING_OAK_PATH, "Sentiero con querce" },
    {TR_BUILDING_ELM_PATH, "Sentiero con olmi" },
    {TR_BUILDING_FIG_PATH, "Sentiero con fichi" },
    {TR_BUILDING_PLUM_PATH, "Sentiero con prugni" },
    {TR_BUILDING_PALM_PATH, "Sentiero con palme" },
    {TR_BUILDING_DATE_PATH, "Sentiero con datteri" },
    {TR_BUILDING_BLUE_PAVILION, "Padiglione blu" },
    {TR_BUILDING_RED_PAVILION, "Padiglione rosso"},
    {TR_BUILDING_ORANGE_PAVILION, "Padiglione arancione"},
    {TR_BUILDING_YELLOW_PAVILION, "Padiglione giallo"},
    {TR_BUILDING_GREEN_PAVILION, "Padiglione verde" },
    {TR_BUILDING_SMALL_STATUE_ALT, "Statua divinità" },
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Statua senatore"},
    {TR_BUILDING_OBELISK, "Obelisco" },
    {TR_BUILDING_POND_DESC, "Gli stagni attingono dalle riserve d'acqua della città fornendo acqua per le piante e un fresco, rilassante ristoro per le persone. Tutti i cittadini vorrebbero vivere vicino a uno stagno." },
    {TR_BUILDING_WINDOW_POND, "Stagno"},
    {TR_BUILDING_OBELISK_DESC, "Un monumento prestigioso, opera di un antico Re del nilo. Gli egizioni non lo utilizzavano."},
    {TR_ADVISOR_FINANCE_LEVIES, "Tasse edilizie"},
    {TR_CONFIRM_DELETE_MONUMENT, "Demolire questo monumento"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Seleziona l'epiteto da conferire"},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Il conferimento di un epiteto consacrerà permanentemente il tuo tempio a un aspetto della sua divinità, donando ai sacerdoti il potere divino." },
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/mese"},
    {TR_BUILDING_MESS_HALL, "Stazione di rifornimento"},
    {TR_BUILDING_MESS_HALL_DESC, "La stazione di rifornimento raccoglie cibo dai granai della città per sfamare i soldati di stanza nei forti della città. Un posto di rifornimento mal rifornito rallenta il reclutamento e danneggia il morale."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "Le scorte di cibo dell'ultimo mese:"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "I soldati sono: " },
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Pasciuti" },
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Sazi"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Affamati"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Molto Affamati"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "Morenti di fame"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "Una dieta variegata per i tuoi soldati aumenta considerevolmente il loro morale."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "Una dieta diversa e nutriente dieta per i tuoi soldati aumenta di molto il morale."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "Non hai soldati da sfamare." },
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Mesi di cibo in magazzino:" },
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "La carenza di cibo alla tua stazione di rifornimento sta rallentando il reclutamento dei soldati."},
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Carenze di cibo critiche alla tua stazione di rifornimento stanno paralizzando il reclutamento dei soldati." },
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "La recente carenza di cibo ha ridotto il morale"},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "La recente carenza di cibo ha ridotto di molto il morale"},
    {TR_BUILDING_LEGION_STARVING, "Carenza di cibo" },
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "I tuoi soldati hanno tutto il cibo di cui hanno bisogno."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "I tuoi soldati necessitano di più cibo." },
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "I tuoi soldati muoiono di fame!"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Scorte di cibo nella stazione di rifornimento:" },
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Soldati affamati" },
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "La scorta di cibo alla tua stazione di rifornimento è molto bassa e il morale delle tue truppe si sta abbassando. Assicurati che il tuo posto di rifornimento possa accedere a un granaio ben fornito"},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "La tua città ha perso la propria stazione di rifornimento, e le tue truppe muoiono di fame. Costruisci immediatamente una stazione di rifornimento."},
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Beni da ritirare"},
    {TR_WARNING_NO_MESS_HALL, "Devi prima costruire una stazione di rifornimento per sfamare i tuoi soldati." },
    {TR_WARNING_MAX_GRAND_TEMPLES, "Solo due Templi Grandi possono essere costruiti." },
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Tempio Grande completato"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "I sacerdoti e i fedeli accorrono al nuovo grande tempio per i riti di consacrazione. Il tuo popolo è in visibilio per la maestosità delle tue opere, e la divinità da te scelta ti offre il suo favore."},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Una benedizione da Mercurio" },
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Deliziato dalla tua devozione, Mercurio ha benedetto la tua industria, fornendo materiali grezzi per i tuoi artigiani."},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Capomastro"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Trasportatore"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Architetto"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Borgomastro"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Operaio"},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "Il grande tempio organizza i sacerdoti di Cerere per aiutare a distribuire cibo e olio ai cittadini affamati."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "Il grande tempio permette ai sacerdoti di Venere di fornire vino sacro ai tuoi cittadini." },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "Il grande tempio organizza i sacerdoti di Marte per fornire cibo alla tua stazione di rifornimento."},
    {TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Tempio di Cerere"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Tempio di Nettuno"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Tempio di Mercurio"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Tempio di Marte"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Tempio di Venere"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Sacerdote" },
    // Transcription of mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Farò il possibile per calmare questi barbari. Sono sicuro che smetteranno di attaccare la città quando avrò parlato con loro.\"" },
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Una festività annuale"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "I fedeli accorrono nei templi per la celebrazione di Cerealia, in onore di Cerere. I contadini offrono sacrifici per i ricchi raccolti dei prossimi anni."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Oggi è la festività di Neptunalia, in onore di Nettuno. I fedeli costruiscono capanne di rami e fogliame e si divertono sotto il calore rovente del sole di mezza estate."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Commercianti e mercanti si riuniscono in massa per festeggiare Mercuralia. L'acqua sacra viene spruzzata sulle navi e sui magazzini nella speranza di una protezione divina dal dio Mercurio."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "I cittadini si riuniscono fuori città per la celebrazione di Equirria, per chiedere il favore di Marte. L'aria si riempie del tuonare degli zoccoli e dello scricchiolio dei carri mentre i fedeli corrono in onore del loro dio."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "I fedeli si riuniscono per la celebrazione della Veneralia, giorno sacro a Venere. I tuoi cittadini la implorano per la buona sorte nelle questioni di cuore."},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Cancella messaggi già letti"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Disattiva questo edificio"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Attiva questo edificio"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Consenti alle donne del mercato di commerciare"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Consenti alle carovane di commerciare"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Consenti alle navi commerciali di commerciare"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Gestione della città"},
    {TR_BUILDING_LIGHTHOUSE, "Faro"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Fondamenta)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Piedistallo)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Torre)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Corona)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Gli ingegneri stanno gettando una solida base per sostenere il peso di una grande torre di pietra." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "I muratori stanno costruendo il piedistallo che innalzerà la fiamma del faro molto al di sopra dell'orizzonte." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "La torre del faro si erge ancora più in alto ogni giorno, mentre i muratori praticano con cura il loro mestiere." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Gli ingegneri stanno eseguendo gli ultimi ritocchi al faro. Presto risplenderà per miglia e miglia, guidando le navi verso casa." },
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "La costruzione del faro richiede materiale immagazzinato in un magazzino, operai di un campo di lavoro e ingegneri di una gilda di ingegneri." },
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "Le navi da pesca si muovono il 10% più velocemente. Le tempeste marine durano la metà del tempo." },
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monumenti"},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "Il faro completato, una possente torre di pietra, si staglia all'orizzonte. Che il suo faro guidi le navi fino alla fine dei tempi." },
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "Il Pantheon è completato. Non ha rivali come monumento al grande potere degli dei e del popolo di Roma." },
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monumento completato" },
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Una benedizione da Nettuno"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Premiando la devozione della vostra città, Nettuno concede ai commercianti un passaggio senza intoppi per dodici mesi, durante i quali le vostre esportazioni otterranno la metà del prezzo extra."},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Una benedizione da Venere" },
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Deliziata dalla gioiosa riverenza che le viene mostrata, Venere concede giovinezza, salute e felicità al vostro popolo, aumentando la dimensione della vostra popolazione attiva." },
    {TR_BUILDING_MENU_STATUES, "Statue" },
    {TR_BUILDING_MENU_GOV_RES, "Residenze del governatore" },
    {TR_OVERLAY_ROADS, "Strade" },
    {TR_NO_EXTRA_ASSETS_TITLE, "La cartella assets non è stata trovata" },
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "La tua installazione di Caesar 3 non ha la cartella assets installata correttamente. "
        "I nuovi assett non saranno mostrati correttamente.\n"
        "Assicurati che la cartella '/assets' esiste nella cartella principale della tua installazione di Caesar 3. " },
    {TR_WARNING_WATER_NEEDED_FOR_LIGHTHOUSE, "Il faro deve essere posizionato vicino all'acqua"},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Questa casa ha accesso a tutti i cinque dei del Pantheon"},
    {TR_BUILDING_LEGION_FOOD_BONUS, "L'abbondanza di cibo aumenta il morale" },
    {TR_BUILDING_LEGION_FOOD_STATUS, "Stato del cibo"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Permetti al capomastro di prelevare cibo da qui"},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "Non puoi ottenere i materiali necessari"},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "I grandi templi completati concedono 8 punti alla valutazione della cultura."},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Torna al menu principale" },
    {TR_LABEL_PAUSE_MENU, "Pausa" },
    {TR_OVERLAY_LEVY, "Arruolamenti" },
    {TR_TOOLTIP_OVERLAY_LEVY, " denari pagati mensilmente in arruolamenti." },
    {TR_MAP_EDITOR_OPTIONS, "Impostazioni scenario" },
    {TR_BUTTON_GO_TO_SITE, "Vai alla posizione" },
    {TR_RETURN_ALL_TO_FORT, "Ritorna tutti" },
    {TR_OPTION_MENU_COST, "Questo costerà"},
    {TR_CONFIG_ARE_YOU_SURE, "Sei sicuro?"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Perderai tutte le impostazioni personalizzate"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Perderai tutte le tue scorciatoie da tastiera"},
    {TR_CONFIG_HEADER_GENERAL, "Impostazioni generali"},
    {TR_CONFIG_GAME_SPEED, "Velocità di gioco:"},
    {TR_CONFIG_VIDEO, "Opzioni video"},
    {TR_CONFIG_FULLSCREEN, "Schermo intero"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Risoluzione finestra"},
    {TR_CONFIG_USE_COLOR_CURSORS, "Usa cursori colorati"},
    {TR_CONFIG_AUDIO, "Opzioni audio"},
    {TR_CONFIG_VOLUME, "Volume"},
    {TR_CONFIG_ENABLE_AUDIO, "Abilita audio"},
    {TR_CONFIG_MUSIC, "Abilita musica"},
    {TR_CONFIG_SPEECH, "Abilita parlato"},
    {TR_CONFIG_EFFECTS, "Abilita effetti sonori"},
    {TR_CONFIG_CITY_SOUNDS, "Abilita suoni cittadini"},
    {TR_CONFIG_VIDEO_SOUND, "Abilita l'audio nei video"},
    {TR_CONFIG_SCROLL_SPEED, "Velocità di scorrimento:"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Disabilia lo scorrimento col mouse a bordo finestra"},
    {TR_CONFIG_DIFFICULTY, "Difficoltà:"},
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Numero massimo di grandi templi per città:"},
    {TR_CONFIG_INFINITE, "Infinito"},
    {TR_CONFIG_GODS_EFFECTS, "Abilita benedizioni e maledizioni degli dei"},
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Permetti ai commercianti di esportare cibo dai granai"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "I camminatori ambulanti non prendono scorciatoie"},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Mostra la massima prosperità raggiungibile"},
    {TR_HOTKEY_COPY_SETTINGS, "Copia le impostazioni degli edifici"},
    {TR_HOTKEY_PASTE_SETTINGS, "Incolla le impostazioni degli edifici"},
    //{TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Show relative overlay"}, TODO ???
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Ruota l'edificio come prima"},
    {TR_ADVISOR_IN_STORAGE, "in magazzino"},
    {TR_ADVISOR_FROM_GRANARIES, "dai granai"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Distribuzione di cibo dai granai"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "Sei sicuro?"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Continua ad accumulare"},
    //{TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_REACHED, "TODO"}, -- no English translation
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "La massima prosperità per il tipo di abitazione corrente è"},
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Istruzioni per il posto di rifornimento"},
    {TR_ADVISOR_TRADE_MAX, "Massimo"},
    {TR_ADVISOR_TRADE_NO_LIMIT, "massimo"},
    {TR_ADVISOR_TRADE_IMPORTABLE, "Importabile"},
    {TR_ADVISOR_TRADE_EXPORTABLE, "Esportabile"},
    //{TR_ADVISOR_TRADE_IMPORTABLE_EXPORTABLE, "TODO"}, XXX not in english, spanish, ...
    {TR_ADVISOR_TRADE_NO_BUYERS, "Nessun compratore per questa risorsa"},
    {TR_ADVISOR_TRADE_NO_SELLERS, "Nessun venditore per questa risorsa"},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "Nessuna importazione"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "Nessuna esportazione"},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Apri una rotta commerciale per importare"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Apri una rotta commerciale per esportare"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Istruzioni per il porto"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Istruzioni per il tempio"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Istruzioni per la taverna"},
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Città con rotta commerciale marittima aperta:"},
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "Non ci sono rotte commerciali marittime."},
    {TR_BUILDING_CARAVANSERAI, "Caravanserraglio"},
    {TR_BUILDING_CARAVANSERAI_DESC, "Le carovane di mercanti sostano qui per riposare e nutrire i loro animali. Le interruzioni del commercio via terra durano la metà."},
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Istruzioni per il caravanserraglio"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Fondamenta)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Gli ingegneri posano le fondamenta di un rifugio per i mercanti."},
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Fornitore del caravanserraglio"},
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Raccoglitore del caravanserraglio"}, // XXX never seen it in game!
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Politica per il commercio via terra"},
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "Nessuna politica per il commercio via terra."},
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Seleziona una politica per il commercio via terra della tua città. Puoi cambiare politica in qualunque momento." },
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" }, // English&Spanish agree
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Landed seller's policy: Land exports earn 20% more, but land imports are 10% more expensive." },
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium emptor terrae" }, // English&Spanish agree
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Politica acquisti via terra: le importazioni via terra costano il 20% di meno, ma le esportazioni rendono il 10% di meno." },
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" }, // English&Spanish agree
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Politica quantitativa via terra: le carovane commerciali trasportano 4 unità in più, ma il caravanserraglio consuma il 20% di cibo in più." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Politica per il commercio marittimo"},
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Nessuna politica per il commercio marittimo"},
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Seleziona una politica per il commercio marittimo della tua città. Puoi cambiare politica in qualunque momento."},
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Politica di vendita via mare: le esportazioni marittime rendono il 20% in più, ma le importazioni costano il 10$ di più." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Politica acquisti marittimi: le importazioni costano il 20% di meno, ma le esportazioni rendono il 10% di meno." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Politica quantità marittime: Le navi commerciali trasportano 4 unità in più, ma il faro consuma il 20% di legna in più." },
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Disabilita la ricomparsa infinita dei lupi."},
    {TR_BUILDING_TAVERN, "Taverna"},
    {TR_BUILDING_GRAND_GARDEN, "Grande giardino"},
    {TR_BUILDING_TAVERN_DESC_1, "Questa taverna non ha lavoratori, dunque non può aprire."},
    {TR_BUILDING_TAVERN_DESC_2, "Questa taverna non ha vino, dunque non può aprire."},
    {TR_BUILDING_TAVERN_DESC_3, "Questa taverna fornisce intrattenimento fintanto che il vino continua a scorrere. Una fornitura di carne la renderebbe di maggior richiamo." },
    {TR_BUILDING_TAVERN_DESC_4, "Vino in abbondanza e l'odore della carne arrostita spingono la gente a venire in questa taverna a scommettere, sentire musica e divertirsi."},
    {TR_FIGURE_TYPE_BARKEEP, "Barista"},
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Fornitore della taverna"},
    {TR_OVERLAY_TAVERN, "Taverna"},
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Questa casa non ha accesso a una taverna, o la sua taverna è a corto di vino."},
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Nessun barista è passato da un bel po'. Questa casa sta per perdere il suo accesso alla taverna." },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Questa taverna è stata visitata da un barista da una taverna col vino."},
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Questa taverna è stata visitata da un barista da una taverna con vino e pesce."},
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Quuesta casa è stata appena visitata dal barista di una taverna col vino." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Questa casa è stata appena visitata dal barista di una taverna con vino e carne. Ora di divertirsi!" },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Gli abitanti schifano il tuo stesso nome."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Gli abitanti sono molto arrabbiati con te." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Gli abitanti sono arrabbiati con te." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Gli abitanti sono molto scontenti di te." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Gli abitanti sono scontenti di te." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Gli abitanti sono stanchi di te." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Gli abitanti ti sono indifferenti." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Gli abitanti sono soddisfatti di te." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Gli abitanti sono molto soddisfatti di te." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Gli abitanti sono estremamente soddisfatti di te." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Gli abitanti ti vogliono bene." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Gli abitanti ti adorano come un dio." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Gli abitanti sono scontenti per le tasse troppo alte."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Gli abitanti sono scontenti per gli stipendi troppo bassi."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Gli abitanti sono scontenti per la mancanza di lavoro."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Gli abitanti sono avviliti dalle condizioni delle loro abitazioni."},
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Gli abitanti apprezzerebbero più intrattenimenti."},
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Gli abitanti apprezzerebbero una dieta più variata."},
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Gli abitanti apprezzerebbero una maggiore desiderabilità."},
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Gli abitanti hanno il morale alle stelle per via dei recenti eventi."},
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Gli abitanti sono demoralizzati dai recenti eventi."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Taverne"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Giochi"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Sponsorizza i Grandi Giochi al tuo Colosseo, pagandoli di tasca tua e con risorse della tua città." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Hold games"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "I preparativi per i Grandi Giochi sono in corso."},
    {TR_SELECT_GAMES_HEADER, "Giochi"},
    {TR_SELECT_GAMES_TEXT, "I Giochi si terranno al Colosseo; verranno pagati di tasca tua e le risorse saranno prese dalla tua città." },
    {TR_BUILDING_ARENA, "Arena"},
    {TR_BUILDING_HORSE_STATUE, "Statua equestre"},
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Statua di delfino"},
    {TR_BUILDING_HEDGE_DARK, "Siepe verdeggiante"},
    {TR_BUILDING_HEDGE_LIGHT, "Siepe soleggiata"},
    //{TR_BUILDING_GARDEN_WALL, "Looped garden wall" }, // FIXME "Looped garden wall" in italiano?
    {TR_BUILDING_LEGION_STATUE, "Statua di un legionario"},
    {TR_BUILDING_DECORATIVE_COLUMN, "Colonna di marmo"},
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Ipogeo)" },
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Fondamenta)" },
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Arcate)" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Galleria)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "I lavoratori stanno scavando i sotterranei dell'ipogeo - tunnel e macchinari da cui sorgeranno grandi spettacoli." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Le mura del colosseo prendono forma man mano che vengono create le file di posti per le persone comuni e per gli imperatori." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Archi aggraziati si innalzano al cielo, per far tendere verso il firmamento il possente Colosseo." }, // XXX probably borked
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "Man mano che il Colosseo si innalza verso il cielo, le sue mura vengono ricoperte di marmo lucante e sculture." },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Pista)" }, // XXX "Track" - pista o guida per lavori successivi?
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Fondamenta)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Gradinate)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Facciata)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "Questo sito imponente viene esaminato e ripulito per un progetto di scala mai vista prima." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Le vie d'accesso e le strutture di supporto vengono costruite attorno alla pista." }, // XXX "Track"
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Gli scalpellini stanno intagliando i seggi di pietra per decine di migliaia di persone." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Più che una semplica pista, gli artigiani stanno creando un monumento degno degli dei e del popolo di Roma." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "La costruzione del monumento richiede materiali in magazzino, lavoratori da un campo di lavoro, e architetti dalla gilda degli architetti." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Costruzione interrotta." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Questo monumento ha tutti i materiali necessari per questa fase. I lavoratori attendono un architetto dalla gilda degli architetti per sovrintendere le fasi successive." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arene"},
    {TR_BUILDING_INFO_TOURISM, "(Viandanti)"},
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "Il Colosseo è completo! Che i giochi comincino!"},
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "L'Ippodromo è completo. I tuoi cittadini aspettano con ansia il tuo ordine di dare inizio alle corse!"},
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Giochi inaugurali"},
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Iniziano le corse"},
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "I giochi inaugurali del tuo Colosseo sono iniziati. Al tuo comando, questo monumento verrà consacrato col sangue dei valorosi!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "La tua città si svuota tanta è la folla che si reca all'Ippodromo per le corse inaugurali dei carri. Quando si aprono i cancelli l'entusiasmo del pubblico è assordante!" },
    {TR_WINDOW_GAMES_OPTION_1, "Tieni dei Giochi Navali"},
    {TR_WINDOW_GAMES_OPTION_2, "Tieni dei Giochi Animali"},
    {TR_WINDOW_GAMES_OPTION_3, "Tieni le Calende di gennaio"},
    {TR_WINDOW_GAMES_OPTION_4, "Tieni i Giochi Olimpici"},
    {TR_WINDOW_GAMES_OPTION_5, "Tieni i Giochi Romani"},
    {TR_WINDOW_GAMES_OPTION_1_DESC, "Il Colosseo verrà allagato per ricostruire una grande battaglia navale. La velocità di spostamento delle tue truppe e la loro forza nelle battaglie lontane sarà aumentata per l'anno prossimo." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "Il Colosseo ospiterà delle truculente cacce agli animali ed esecuzioni da parte di belve feroci, deliziando le masse dei plebei. Il Crimine, le proteste e le rivolte non saranno un problema per il prossimo anno. I gladiatori aiuteranno a difendere la città dalla prossima invasione." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "Il Colosseo ospiterà dei giochi in onore degli dei il primo giorno dell'anno prossimo, implorando che portino fortuna e prosperità. I commerci saranno raddoppiati per l'anno prossimo." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "L'Ippodromo ospiterà i Giochi Olimpici. La tua città ospiterà frotte di visitatori, e se i tuoi atleti onoreranno la tua città otterrai un aumento permanente di turismo e popolarità." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "Il colosseo ospiterà i Giochi Romani, con gente che si recherà alla tua città da tutto l'impero per gareggiare. Uno spettacolo del genere ti farà sicuramente guadagnare il favore sia dell'Imperatore che della gente comune per il prossimo anno." },
    {TR_WINDOW_GAMES_COST, "Costo:"},
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(fondi personali)"},
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Non hai abbastanza fondi personali."},
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Non ci sono abbastanza risorse."},
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "L'edificio non ha accesso a una cisterna." },
    {TR_WINDOW_GAMES_NO_VENUE, "L'edificio non è ancora completo, o non ha lavoratori." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Costruzione)"},
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Tagliapietre e ingegneri stanno costruendo questo sacro edificio con marmo lucente." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "Costruire questo tempio richiederà materiali nel magazzino, lavoratori dai campi di lavoro, e architetti da una gilda degli architetti." },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "L'acqua delle tue cisterne cittadine sta lentamente riempiendo il Colosseo. I carpentieri iniziano ad assemblare le navi da guerra in miniatura mentre i gladiatori si allenano al combattimento in acqua. Presto inizieranno i Giochi Navali!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "Il Colosseo è diventato un lago artificiale, e i gladiatori ricostruiscono le grandi vittorie romane sul mare. Il sangue e l'acqua si mescolano ed il pubblico grida entusiasta. La Naumachia - i Giochi Navali - è incominciata!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Per il Colosseo incomincia un lungo processo di pulizia, deve essere drenato e riadattato al normale utilizzo. I tuoi cittadini parleranno di questo spettacolo acquatico per anni a venire." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Nella tua città incominciano ad apparire degli strani cargo quando i mercanti da ogni angolo remoto della terra portano terrificanti belve nelle gabbie sotto il Colosseo. Presto uno spettacolo truculento delizierà i tuoi cittadini." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Criminali condannati e gladiatori in cerca della gloria eterna affrontano la more sotto forma di denti e artigli. Con uno squillo di trombe, i Giochi Animali sono cominciati!" },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "L'ultima delle bestie selvagge giace massacrata nella sabbia del Colosseo, ed il loro sangue si mescola a quello dei condannati. I Giochi Animali sono terminati." },
    // FIXME "fortune" vs "prosperity"
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Festeggeremo l'anno nuovo con dei gloriosi giochi in onore degli dei. In cambio, chiediamo fortuna, prosperità, e benedizioni per quel che riguarda il commercio." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "I giochi iniziano all'alba delle calende di gennaio. I sacerdoti sacrificano gli animali mentre i gladiatori preparano le loro armi per morire cercando il favore degli dei."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Gli auguri suggeriscono che gli dei sono compiaciuti dai nostri grandi giochi e dai sacrifici e dal rispetto che abbiamo dimostrato. Possiamo aspettarci un anno molto propizio!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Tutti gli occhi saranno puntati sulla tua città visto che i Giochi Olimpici portano viaggiatori, concorrenti e dignitari romani da tutto il mondo. Servirà non meno di un anno intero per vedere conclusi tutti i possibili preparativi."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Finalmente, il giorno è giunto. La fiamma dei sacrifici è accesa, e le strade della tua città sono deserte perchè i cittadini affollano il grande ippodromo. Che i giochi abbiano inizio!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "La sacra fiamma è spenta, e viaggiatori e cittadini tornano a casa stanchi e felici. Eterna gloria a te per aver ospitato questa antica e sacra celebrazione della forza e dell'onore dei mortali." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Con l'annuncio dei Giochi Romani, gente da ogni dove si precipita nella tua città, molti sperando di vincere le imminenti competizioni. Servirà non meno di un anno intero per vedere conclusi tutti i possibili preparativi."},
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "Comincia la solenne processione, e con essa i Giochi Romani. Possa Giove in persona selezionare i campioni delle corse, incontri di lotta, e altre gare di vigore e agilità. Il Colosseo è pieno fino all'orlo di cittadini che aspettano i giochi e le tradizionali elargizioni di grano e olio d'oliva. Che i giochi abbiano inizio!" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "L'ultima giornata dei Giochi Romani è finalmente conclusa. Pieni d'entusiasmo, e con le pance altrettanto piene, tutti i cittadini hanno avuto un assaggio della grandezza dello stile di vita romano. Gloria agli dei, gloria ai vittoriosi, e gloria al governatore!" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "I Grandi Giochi"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Mesi prima di poter tenere i giochi:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Mesi prima dei Giochi Navali:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "I Giochi Navali sono in corso. The Naval Games are underway. I tonfi d'acqua, lo scricchiolio del legno ed i gridi di battaglia dei gladiatori si aggiungono al rumoreggiare del pubblico." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Mesi prima dei Giochi Animali:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "I Giochi Animali sono in corso. Spalla a spalla, il pubblico grida a squarciagola mentre le bestie feroci inseguono le loro prede umane." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Mesi prima dei Giochi delle Calende:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "I Giochi delle Calende sono in corso. L'odore dei sacrifici animali e dell'incenso sovrasta persino il sangue pungente ed il sudore dell'arena." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Mesi prima dei Giochi Olimpici"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "I Giochi Olimpici sono in corso. La sacra fiamma brucia giorno e notte mentre gli atleti competono per la gloria immortale." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Mesi prime dei Giochi Romani:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "I Giochi Romani sono in corso. Ogni partecipante versa il proprio sangue, sudore e lacrime per dimostrare di essere il migliore dei romani." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "I Grandi Giochi continueranno ancora per" }, // ...XX Days,
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "I Grandi Giochi si sono tenuti recentemente"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "I Grandi Giochi sono in corso! La tua città pullula di turisti e bagordi." },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "L'arena è chiusa. Gli uccelli nidificano nei posti vuoti." },
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Quest'arena non ospita nè leoni nè gladiatori, e fornisce ben poco intrattenimento." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "Quest'arena ospita gladiatori e caccie alle belve, per il diletto degli abitanti del posto." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Il pubblico si diverte con i normali spettacoli di gladiatori, ma dei leoni produrrebbero uno spettacolo migliore." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Le bestie affamate si aggirano per l'arena in cerca di preda, ma la mancanza di gladiatori allenati fa sì che gli spettacoli siano molto brevi." },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Questo tempio raccoglierà cibo per le postazioni di rifornimento, non appena sarà stato costruito." },
    {TR_OVERLAY_ARENA_COL, "Arena"},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "Questa casa non ha nessun accesso a una arena o al Colosseo." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "Questa casa a accesso a un'arena con uno spettacolo." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "Questa casa ha accesso a un'arena con due spettacoli." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "Questa casa ha accesso al Colosseo, con uno spettacolo." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "Questa casa ha accesso al Colosseo, con due spettacoli." },
    //{TR_TOOLTIP_OVERLAY_ARENA_COL_6, "TODO"}, -- not in english.c or anywhere
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Lavoratori in sciopero"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Nessun accesso all'acqua"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "In attesa del carrettiere"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "Nessuna risorsa disponibile"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Edificio inattivo"},
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Troppi edifici di questo tipo -- i turisti evitano questo posto." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Incassi dai viaggiatori quest'anno:"},
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Il tuo consigliere del commercio ha ordinato di interrompere la produzione di pesce."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Tributi/interessi"},
    {TR_WINDOW_ADVISOR_TOURISM, "Varie"}, // XXX wtf is this???
    {TR_WINDOW_FIGURE_TOURIST, "Questo viaggiatore ha speso: "},
    {TR_FIGURE_TYPE_TOURIST, "Viaggiatore"},
    // Intentionally untranslated, to help finding a solution - feel free to disagree.
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Incompatible savegame version" },
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "La partita che stai cercando di caricare è per una versione di Augustus più recente.\nAggiorna Augustus alla versione più recente." },
    {TR_BUILDING_COLONNADE, "Colonnato"},
    {TR_BUILDING_LARARIUM, "Lararium"}, // Preferisco in latino
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Questo piccolo santuario è dedicato ai Lari - gli spiriti ancestrali dei Romani. Qui si può pregare o compiere piccoli sacrifici."},
    {TR_BUILDING_WATCHTOWER, "Torre di guardia"},
    {TR_BUILDING_WATCHTOWER_DESC, "Gli arcieri sui merli di questa torre montano la guardia, mentre le sentinelle pattugliano le strade di sotto." },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "A questa torre serve una sentinelle dalle baracche prima che possa proteggere la nostra città."},
    {TR_BUILDING_NYMPHAEUM, "Ninfeo"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Questo grande tempio è dedicato alle ninfe dell'acquua - divinità minori di sorgenti, fiumi e mari. Promette bellezza e abbondanza alle terre intorno e il favore degli dei alla città." },
    {TR_BUILDING_SMALL_MAUSOLEUM, "Piccolo mausoleo"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "In questo mausoleo riposano le generazioni passate delle famiglie più ricche della tua città, ed è l'invidia di molti fra i vivi." },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Grande mausoleo"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "I muri e le statue di marmo levigato di questa magnifica struttura riflettono le grandi imprese dei patrizi che si sono guadagnati il privilegio di riposare qui." },
    {TR_FIGURE_TYPE_WATCHMAN, "Sentinella"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Permetti/vieta l'accesso a prefetti e ingegneri" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Permetti/vieta l'accesso alle acquirenti del mercato" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Permetti/vieta l'accesso agli intrattenitori" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Permetti/vieta l'accesso al personale scolastico" }, // XXX need better translation!
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Permetti/vieta l'accesso al personale sanitario" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Permetti/vieta l'accesso agli esattori delle tasse" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Permetti/vieta l'accesso a chi cerca lavoratori" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Permetti/vieta l'accesso ai missionari" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Permetti/vieta l'accesso alle sentinelle" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Permetti/vieta l'accesso ai sacerdoti" },
    {TR_HOTKEY_DUPLICATE_TITLE, "Scorciatoia già utilizzata"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Questa scorciatoia è già stata assegnata all'azione seguente:"},
    {TR_BUILDING_GARDEN_PATH, "Viale dei giardini"},
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Interrompi la costruzione"},
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Riprendi la costruzione"},
    {TR_RESOURCE_FISH, "Pesce"},
    {TR_WARNING_VARIANT_TOGGLE, "Premi il tasto rotazione per vedere le altre varianti di questo edificio"},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "Questa scuola è in funzione. Lo sviluppo locale ha permesso ai tuoi cittadini di espandere l'edificio, facendo spazio per più bambini."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Questo teatro è in funzione. Lo sviluppo locale ha permesso ai tuoi cittadini di espandere l'edificio, fornendo più posti a sedere." },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Questa biblioteca è in funzione. Lo sviluppo locale ha permesso ai tuoi cittadini di espandere l'edificio, fornendo altre pergamene e angoli di lettura." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Il cantiere di questo monumento non ha accesso alla strada e non può ricevere materiali. Collega una strada a una delle caselle centrali."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Per via del basso morale cittadino, i plebei di questo negozio hanno dichiarato la secessione e si rifiutano di lavorare!" },
    {TR_CITY_WARNING_SECESSION, "I plebei si rifiutano di lavorare!!" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Hanno saccheggiato un magazzino!" },
    //{TR_CITY_WARNING_MARKET_BREAKIN, "TODO"}, not in english etc
    {TR_CITY_WARNING_THEFT, "Hanno rubato soldi pubblici da un foro o dal senato!" },
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Saccheggi nella citta!"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Un magazzino o granaio è stato saccheggiato da cittadini furiosi e le merci sono state rubate! Il basso morale rende questi incidenti più probabili."},
    {TR_SIDEBAR_EXTRA_INVASIONS, "Invasioni"},
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasione in corso" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "Nessuna invasione" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasione imminente" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Nemici in avvicinamento" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Nemici lontani" },
    {TR_SIDEBAR_EXTRA_GODS, "Dei"},
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Vedi tutto"}, // XXX context?
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Piccola armata"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Discreta armata"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Grande armata"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Invia richiesta"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Accumula"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Smetti di accumulare"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Vai al grafico della popolazione"},
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Visita il consigliere della popolazione"},
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Informazioni sui giochi"},
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Questa statua apparirebbe persino più grandiose con una fontana funzionante. Forniscile accesso alla cisterna." },
    {TR_OPTION_MENU_APPLY, "Applica"},
    {TR_FIGURE_TYPE_LOOTER, "Saccheggiatore"},
    {TR_FIGURE_TYPE_ROBBER, "Brigante"}, // ladro? bandito?
    {TR_OVERLAY_SENTIMENT, "Umore"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Nessuno"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Tutti"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Seleziona una politica di commercio terrestre"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Per impostare una politica di commercio via terra devi prima costruire un caravanserraglio"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Seleziona una politica di commercio marittimo"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Per impostare una politica di commercio marittimo devi prima costruire un faro"},
    {TR_TOOLTIP_HOLD_GAME, "Celebra i Giochi"},
    {TR_TOOLTIP_NO_GAME, "Non celebrare i Giochi"},
    {TR_WARNING_NEARBY_WOLF, "Non si può costruire vicino ai lupi"},
    {TR_MARKET_TRADING, "Acquista"}, // should the market buy eg furniture?
    {TR_MARKET_NOT_TRADING, "Non acquistare"},
    {TR_TEMPLE_DISTRIBUTING, "Distribuisci"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "Non distribuire"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Gli alloggi squallidi e i quartieri malfamati bloccano l'immigrazione"},
    {TR_CITY_MESSAGE_SQUALOR, "Gli alloggi squallidi e i quartieri malfamati sono un problema"},
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Guardiano del faro"},
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Lararium nella città"},
    {TR_WINDOW_RACE_BET_BUTTON, "Scommetti su un cavallo"},
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "La corsa si sta svolgendo..."},
    {TR_WINDOW_RACE_BET_TITLE, "Scommetti su un cavallo"},
    {TR_WINDOW_RACE_BET_AMOUNT, "Quantità"},
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Scommetti un po' dei tuoi fondi personali su una squadra di carri, e raddoppia la tua puntata se il tuo cavallo vince. Il tuo salario sarà quadruplicato durante i giochi del Colosseo!"},
    {TR_WARNING_BET_VICTORY, "Il tuo cavallo ha vinto la corsa all'ippodromo della tua città"},
    {TR_WARNING_BET_DEFEAT, "Il tuo cavallo ha perso la corsa all'ippodromo della tua città"},
    {TR_PERSONAL_SAVINGS, "Risparmi :"},
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Scommetti sul cavallo blu"}, // XXX non biga/squadra?
    {TR_WINDOW_RACE_BET_RED_HORSE, "Scommetti sul cavallo rosso"},
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Scommetti sul cavallo bianco"},
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Scommetti sul cavallo verde"},
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "A corto di sacerdoti e attendenti, il tempio non può compiere tutti i riti e le celebrazioni. Finchè la situazione non cambierà non possiamo aspettarci il favore degli dei. "},
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "Al Colosseo servono più lavoratori per assicurare a tutti i nostri cittadini un intrattenimento degno di questo posto."},
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "L'Ippodromo ha bisogno di più lavoratori per fornire le sue spettacolari attrazioni a tutti i nostri cittadini."},
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "Il Faro non ha tutti i lavoratori di cui ha bisogno per tenere acceso il fuoco. Le navi non possono usare la sua luce per arrivare ai nostri porti."},
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "Senza tutti i lavoratori necessari, il caravanserraglio non può servire tutte le carovane in arrivo."},
    //{TR_BUILDING_ROOFED_GARDEN_WALL, "TODO"}, ???
    {TR_BUILDING_GARDEN_WALL_GATE, "Cancello del giardino"},
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "I cancelli impediscono agli ospiti indesiderati di disturbare la pace dei giardini."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "Il magazziniere sta andando a prendere i beni da un altro magazzino."},
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Non consegnare risorse a officine e granai" },
    {TR_CITY_WARNING_GRANARY_BREAKIN, "Un granaio è stato saccheggiato!" },
    {TR_BUILDING_GARDEN_WALL, "Muro di cinta a volte " },
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Muro di cinta coperto" },
    {TR_BUILDING_GARDEN_WALL_GATE, "Cancello" },
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "Questo piccolo cancello controlla l'accesso e l'uscita delle persone ad uno dei posti più esclusivi della tua città." },
    {TR_BUILDING_PALISADE, "Palizzata" },
    {TR_BUILDING_PALISADE_DESC, "Questo terrapieno, sormontato da un alto muro di pali di legno appunti, terrà la tua città al sicuro da invasori ed animali ostili." },
    {TR_OVERLAY_MOTHBALL, "Attività sospesa" },
    {TR_OVERLAY_ENEMY, "Nemici" },
    {TR_BUILDING_TAVERN_DESC_5, "I cittadini amano visitare questo stabilimento nel loro tempo libero, per socializzare fra cibi delicati e vini ricercati." },
    {TR_OVERLAY_WAREHOUSES, "Magazzini" },
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "I Blu - i preferiti di Nettuno. Sono i più promettenti fra i giovani aurighi di Roma, desiderosi di provare il loro valore." },
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "I Rossi - conosciuti come la squadra del più vincente auriga della storia di Roma - l'ex rematore e salvatore di un console Romano." },
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "I Bianchi - squadra fondata da ex gladiatori. Hanno il combattimento nel sangue e anche da liberti vivono per la lotta." },
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "I Verdi - discendenti dei \"Celeres\", cavalieri dei tempi dei sette re. Vantano di essere ancora il meglio del meglio." },
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Riprendi a consegnare risorse a officine e granai" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, "Attiva accumulo in un magazzino" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Disattiva accumulo" },
    {TR_CONFIG_DIGIT_SEPARATOR, "Raggruppa cifre"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_LABOR, "Nessuna manodopera" },
    {TR_WINDOW_BUILDING_DISTRIBUTION_GRANARY_CART_PUSHER_GETTING, "Il magazziniere sta andando a prendere il cibo da un altro granaio." },
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_RETURNING_WITH, "Il magazziniere sta tornando con i beni recuperati." },
    {TR_BUTTON_YEARLY_AUTOSAVE_OFF, "Salvataggio automatico annuale OFF" },
    {TR_BUTTON_YEARLY_AUTOSAVE_ON, "Salvataggio automatico annuale ON" },
    {TR_BUILDING_DOCK_PLAGUE_DESC, "La peste è stata portata qui da una nave commerciale. Questo scalo sarà in quarantena fino a quando un dottore non avrà sanificato l'area." },
    {TR_BUILDING_GRANARY_PLAGUE_DESC, "La peste è stata portata qui da un lavoratore infetto. Questo granaio sarà in quarantena fino a quando un dottore non avrà sanificato l'area." },
    {TR_BUILDING_WAREHOUSE_PLAGUE_DESC, "La peste è stata portata qui da un lavoratore infetto. Questo magazzino sarà in quarantena fino a quando un dottore non avrà sanificato l'area." },
    {TR_BUILDING_FUMIGATION_DESC, "La sanificazione di questo edificio è in corso, la fumigazione dovrebbe durare qualche giorno." },
    {TR_OVERLAY_SICKNESS, "Malattie" },
    {TR_ADVISOR_SICKNESS_LEVEL_LOW, "In città sono diffuse pochissime malattie e il commercio procede senza restrizioni. Il livello d'igiene cittadina permette di arginare efficaciemente le epidemie provenienti da altre città." },
    {TR_ADVISOR_SICKNESS_LEVEL_MEDIUM, "Sono riportati in città alcuni casi di malattie infettive, ma la situazione è sotto controllo. Assicurati che sia mantenuto un corretto livello di igiene per evitare restizioni al commercio. Gli ospedali sono efficaci nella prevenzione delle epidemie." },
    {TR_ADVISOR_SICKNESS_LEVEL_HIGH, "Molte malattie infettive si stanno diffondendo in alcune aree della città. Se non prendi subito provvedimenti efficaci, scali, magazzini e granai potrebbero essere messi in quarantena, impedendo il commercio. Costruisci ospedali vicino a questi edifici per arginare le epidemie provenienti da altre città." },
    {TR_ADVISOR_SICKNESS_LEVEL_PLAGUE, "La peste dilaga in città e il commercio ne è gravemente limitato. I dottori sono costretti a concentrarsi sulla decontaminazione dei luoghi più colpiti dall'epidemia. Occorrono provvedimenti urgenti!" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_LOW, "Pochissime malattie" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_MEDIUM, "Qualche caso di malattie infettive" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_HIGH, "Focolaio di malattie infettive" },
    {TR_TOOLTIP_OVERLAY_SICKNESS_PLAGUE, "Focolaio di peste" },
    {TR_CITY_MESSAGE_TITLE_SICKNESS, "La peste è in città" },
    {TR_CITY_MESSAGE_TEXT_SICKNESS, "La peste è arrivata in città, un edificio è stato messo in quarantena e i dottori sono stati assegnati alla sanificazione." },
    {TR_FIGURES_CARTPUSHER_GOING_TO_ROME, "Porta a Roma le merci richieste dall'imperatore" },
    {TR_WARNING_SCREENSHOT_SAVED, "Schermata salvata: "} // TODO: Google translate
};

void translation_italian(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
