/*
 * This file is part of AtomVM.
 *
 * Copyright 2019 Davide Bettio <davide@uninstall.it>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0 OR LGPL-2.1-or-later
 */

#ifndef _PLATFORM_DEFAULTATOMS_H_
#define _PLATFORM_DEFAULTATOMS_H_

#include "defaultatoms.h"

#define READ_ATOM_INDEX (PLATFORM_ATOMS_BASE_INDEX + 0)
#define GPIO_INTERRUPT_ATOM_INDEX (PLATFORM_ATOMS_BASE_INDEX + 1)
#define RISING_ATOM_INDEX (PLATFORM_ATOMS_BASE_INDEX + 2)
#define FALLING_ATOM_INDEX (PLATFORM_ATOMS_BASE_INDEX + 3)
#define BOTH_ATOM_INDEX (PLATFORM_ATOMS_BASE_INDEX + 4)
#define LOW_ATOM_INDEX (PLATFORM_ATOMS_BASE_INDEX + 5)
#define HIGH_ATOM_INDEX (PLATFORM_ATOMS_BASE_INDEX + 6)

#define ESP32_ATOM_INDEX (PLATFORM_ATOMS_BASE_INDEX + 7)

#define SOCKET_ATOMS_BASE_INDEX (PLATFORM_ATOMS_BASE_INDEX + 8)
#define PROTO_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 0)
#define UDP_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 1)
#define TCP_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 2)
#define SOCKET_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 3)
#define FCNTL_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 4)
#define BIND_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 5)
#define GETSOCKNAME_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 6)
#define RECVFROM_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 7)
#define SENDTO_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 8)
#define ADDRESS_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 9)
#define CONTROLLING_PROCESS_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 10)
#define ACTIVE_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 11)
#define BUFFER_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 12)
#define CONNECT_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 13)
#define SEND_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 14)
#define TCP_CLOSED_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 15)
#define RECV_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 16)
#define LISTEN_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 17)
#define BACKLOG_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 18)
#define ACCEPT_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 19)
#define FD_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 20)

#define INIT_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 21)
#define GET_PORT_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 22)
#define SOCKNAME_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 23)
#define PEERNAME_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 24)
#define NOT_OWNER_ATOM_INDEX (SOCKET_ATOMS_BASE_INDEX + 25)

#define UART_ATOMS_BASE_INDEX (NOT_OWNER_ATOM_INDEX + 1)
#define NAME_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 0)
#define SPEED_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 1)
#define WRITE_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 2)
#define DATA_BITS_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 3)
#define STOP_BITS_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 4)
#define FLOW_CONTROL_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 5)
#define PARITY_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 6)
#define TX_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 7)
#define RX_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 8)
#define RTS_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 9)
#define CTS_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 10)
#define DEFAULT_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 11)
#define EVENT_QUEUE_LEN_ATOM_INDEX (UART_ATOMS_BASE_INDEX + 12)

#define READ_ATOM TERM_FROM_ATOM_INDEX(READ_ATOM_INDEX)
#define GPIO_INTERRUPT_ATOM TERM_FROM_ATOM_INDEX(GPIO_INTERRUPT_ATOM_INDEX)
#define RISING_ATOM TERM_FROM_ATOM_INDEX(RISING_ATOM_INDEX)
#define FALLING_ATOM TERM_FROM_ATOM_INDEX(FALLING_ATOM_INDEX)
#define BOTH_ATOM TERM_FROM_ATOM_INDEX(BOTH_ATOM_INDEX)
#define LOW_ATOM TERM_FROM_ATOM_INDEX(LOW_ATOM_INDEX)
#define HIGH_ATOM TERM_FROM_ATOM_INDEX(HIGH_ATOM_INDEX)

#define ESP32_ATOM TERM_FROM_ATOM_INDEX(ESP32_ATOM_INDEX)

// socket
#define PROTO_ATOM TERM_FROM_ATOM_INDEX(PROTO_ATOM_INDEX)
#define UDP_ATOM TERM_FROM_ATOM_INDEX(UDP_ATOM_INDEX)
#define TCP_ATOM TERM_FROM_ATOM_INDEX(TCP_ATOM_INDEX)
#define SOCKET_ATOM TERM_FROM_ATOM_INDEX(SOCKET_ATOM_INDEX)
#define FCNTL_ATOM TERM_FROM_ATOM_INDEX(FCNTL_ATOM_INDEX)
#define BIND_ATOM TERM_FROM_ATOM_INDEX(BIND_ATOM_INDEX)
#define GETSOCKNAME_ATOM TERM_FROM_ATOM_INDEX(GETSOCKNAME_ATOM_INDEX)
#define RECVFROM_ATOM TERM_FROM_ATOM_INDEX(RECVFROM_ATOM_INDEX)
#define SENDTO_ATOM TERM_FROM_ATOM_INDEX(SENDTO_ATOM_INDEX)
#define ADDRESS_ATOM term_from_atom_index(ADDRESS_ATOM_INDEX)
#define CONTROLLING_PROCESS_ATOM TERM_FROM_ATOM_INDEX(CONTROLLING_PROCESS_ATOM_INDEX)
#define ACTIVE_ATOM term_from_atom_index(ACTIVE_ATOM_INDEX)
#define BUFFER_ATOM term_from_atom_index(BUFFER_ATOM_INDEX)
#define CONNECT_ATOM term_from_atom_index(CONNECT_ATOM_INDEX)
#define SEND_ATOM TERM_FROM_ATOM_INDEX(SEND_ATOM_INDEX)
#define TCP_CLOSED_ATOM TERM_FROM_ATOM_INDEX(TCP_CLOSED_ATOM_INDEX)
#define RECV_ATOM TERM_FROM_ATOM_INDEX(RECV_ATOM_INDEX)
#define LISTEN_ATOM TERM_FROM_ATOM_INDEX(LISTEN_ATOM_INDEX)
#define BACKLOG_ATOM TERM_FROM_ATOM_INDEX(BACKLOG_ATOM_INDEX)
#define ACCEPT_ATOM TERM_FROM_ATOM_INDEX(ACCEPT_ATOM_INDEX)
#define FD_ATOM TERM_FROM_ATOM_INDEX(FD_ATOM_INDEX)

#define INIT_ATOM TERM_FROM_ATOM_INDEX(INIT_ATOM_INDEX)
#define GET_PORT_ATOM TERM_FROM_ATOM_INDEX(GET_PORT_ATOM_INDEX)
#define SOCKNAME_ATOM TERM_FROM_ATOM_INDEX(SOCKNAME_ATOM_INDEX)
#define PEERNAME_ATOM TERM_FROM_ATOM_INDEX(PEERNAME_ATOM_INDEX)
#define NOT_OWNER_ATOM TERM_FROM_ATOM_INDEX(NOT_OWNER_ATOM_INDEX)

// uart_driver
#define NAME_ATOM TERM_FROM_ATOM_INDEX(NAME_ATOM_INDEX)
#define SPEED_ATOM TERM_FROM_ATOM_INDEX(SPEED_ATOM_INDEX)
#define WRITE_ATOM TERM_FROM_ATOM_INDEX(WRITE_ATOM_INDEX)
#define DATA_BITS_ATOM TERM_FROM_ATOM_INDEX(DATA_BITS_ATOM_INDEX)
#define STOP_BITS_ATOM TERM_FROM_ATOM_INDEX(STOP_BITS_ATOM_INDEX)
#define FLOW_CONTROL_ATOM TERM_FROM_ATOM_INDEX(FLOW_CONTROL_ATOM_INDEX)
#define PARITY_ATOM TERM_FROM_ATOM_INDEX(PARITY_ATOM_INDEX)
#define TX_ATOM TERM_FROM_ATOM_INDEX(TX_ATOM_INDEX)
#define RX_ATOM TERM_FROM_ATOM_INDEX(RX_ATOM_INDEX)
#define RTS_ATOM TERM_FROM_ATOM_INDEX(RTS_ATOM_INDEX)
#define CTS_ATOM TERM_FROM_ATOM_INDEX(CTS_ATOM_INDEX)
#define DEFAULT_ATOM TERM_FROM_ATOM_INDEX(DEFAULT_ATOM_INDEX)
#define EVENT_QUEUE_LEN_ATOM TERM_FROM_ATOM_INDEX(EVENT_QUEUE_LEN_ATOM_INDEX)

#endif
