#pragma once

#ifndef LOGOS_H
#define LOGOS_H

static char *logos[][32] = {      // please leave logos[0] to Linux and logos[1] to macOS
    {   // Linux - default logo
        "linux",                                                // this first line contains the distro ID, taken from /etc/os-release
        "\033[90m",                                               // default color for the printed text
        "                     ",                                // numbers of spaces to use when ran out of lines
        "\033[90m        #####        ",                          // just the logo
        "\033[90m       #######       ",
        "\033[90m       ##\033[37mO\033[90m#\033[37mO\033[90m##       ",
        "\033[90m       #\033[33m#####\033[90m#       ",
        "\033[90m     ##\033[37m##\033[33m###\033[37m##\033[90m##     ",
        "\033[90m    #\033[37m##########\033[90m##    ",
        "\033[90m   #\033[37m############\033[90m##   ",
        "\033[90m   #\033[37m############\033[90m###  ",
        "\033[33m  ##\033[90m#\033[37m###########\033[90m##\033[33m#  ",
        "\033[33m######\033[90m#\033[37m#######\033[90m#\033[33m######",
        "\033[33m#######\033[90m#\033[37m#####\033[90m#\033[33m#######",
        "\033[33m  #####\033[90m#######\033[33m#####  ",
        NULL                                                 // the logo is terminated by NULL
    },
    {   // MacOS X
        "apple",
        "\033[35m",
        "                              ",
        "\033[32m                    'c.       ",
        "\033[32m                 ,xNMM.       ",
        "\033[32m               .OMMMMo        ",
        "\033[32m               OMMM0,         ",
        "\033[32m     .;loddo:' loolloddol;.   ",
        "\033[32m   cKMMMMMMMMMMNWMMMMMMMMMM0: ",
        "\033[33m .KMMMMMMMMMMMMMMMMMMMMMMMWd. ",
        "\033[33m XMMMMMMMMMMMMMMMMMMMMMMMX.   ",
        "\033[31m;MMMMMMMMMMMMMMMMMMMMMMMM:    ",
        "\033[31m:MMMMMMMMMMMMMMMMMMMMMMMM:    ",
        "\033[31m.MMMMMMMMMMMMMMMMMMMMMMMMX.   ",
        "\033[31m kMMMMMMMMMMMMMMMMMMMMMMMMWd. ",
        "\033[35m .XMMMMMMMMMMMMMMMMMMMMMMMMMMk",
        "\033[35m  .XMMMMMMMMMMMMMMMMMMMMMMMMK.",
        "\033[34m    kMMMMMMMMMMMMMMMMMMMMMMd  ",
        "\033[34m     ;KMMMMMMMWXXWMMMMMMMk.   ",
        "\033[34m       .cooc,.    .,coo:.     ",
        NULL
    },
    {   // Android
        "android",
        "\033[32m",
        "                                ",
        "\033[32m         -o          o-         ",
        "\033[32m          +hydNNNNdyh+          ",
        "\033[32m        +mMMMMMMMMMMMMm+        ",
        "\033[32m      `dMM\033[37mm:\033[32mNMMMMMMN\033[37m:m\033[32mMMd`      ",
        "\033[32m      hMMMMMMMMMMMMMMMMMMh      ",
        "\033[32m  ..  yyyyyyyyyyyyyyyyyyyy  ..  ",
        "\033[32m.mMMm`MMMMMMMMMMMMMMMMMMMM`mMMm.",
        "\033[32m:MMMM-MMMMMMMMMMMMMMMMMMMM-MMMM:",
        "\033[32m:MMMM-MMMMMMMMMMMMMMMMMMMM-MMMM:",
        "\033[32m:MMMM-MMMMMMMMMMMMMMMMMMMM-MMMM:",
        "\033[32m:MMMM-MMMMMMMMMMMMMMMMMMMM-MMMM:",
        "\033[32m-MMMM-MMMMMMMMMMMMMMMMMMMM-MMMM-",
        "\033[32m +yy+ MMMMMMMMMMMMMMMMMMMM +yy+ ",
        "\033[32m      mMMMMMMMMMMMMMMMMMMm      ",
        "\033[32m      `/++MMMMh++hMMMM++/`      ",
        "\033[32m          MMMMo  oMMMM          ",
        "\033[32m          MMMMo  oMMMM          ",
        "\033[32m          oNMm-  -mMNs          ",
        NULL
    },
    {   // Arch Linux
        "arch",
        "\033[36m",
        "                                    ",
        "\033[36m                  -`                 ",
        "\033[36m                 .o+`                ",
        "\033[36m                `ooo/                ",
        "\033[36m               `+oooo:               ",
        "\033[36m              `+oooooo:              ",
        "\033[36m              -+oooooo+:             ",
        "\033[36m            `/:-:++oooo+:            ",
        "\033[36m           `/++++/+++++++:           ",
        "\033[36m          `/++++++++++++++:          ",
        "\033[36m         `/+++ooooooooooooo/`        ",
        "\033[36m        ./ooosssso++osssssso+`       ",
        "\033[36m       .oossssso-````/ossssss+`      ",
        "\033[36m      -osssssso.      :ssssssso.     ",
        "\033[36m     :osssssss/        osssso+++.    ",
        "\033[36m    /ossssssss/        +ssssooo/-    ",
        "\033[36m  `/ossssso+/:-        -:/+osssso+-  ",
        "\033[36m `+sso+:-`                 `.-/+oso: ",
        "\033[36m`++:.                           `-/+/",
        "\033[36m.`                                 `/",
        NULL
    },
    {   // Arch Linux (small version)
        "arch_small",
        "\033[36m",
        "\033[36m              ",
        "\033[36m      /\\      ",
        "\033[36m     /  \\     ",
        "\033[36m    /\\   \\    ",
        "\033[36m   /      \\   ",
        "\033[36m  /   ,,   \\  ",
        "\033[36m /   |  |  -\\ ",
        "\033[36m/_-''    ''-_\\",
        NULL
    },
    {   // Debian
        "debian",
        "\033[31m",
        "                            ",
        "\033[31m       _,met$$$$$gg.        ",
        "\033[31m    ,g$$$$$$$$$$$$$$$P.     ",
        "\033[31m  ,g$$P\"     \"\"\"Y$$.\".      ",
        "\033[31m ,$$P'              `$$$.   ",
        "\033[31m',$$P       ,ggs.     `$$b: ",
        "\033[31m`d$$'     ,$P\"'   \033[37m.\033[31m    $$$  ",
        "\033[31m $$P      d$'     \033[37m,\033[31m    $$P  ",
        "\033[31m $$:      $$.   \033[37m-\033[31m    ,d$$'  ",
        "\033[31m $$;      Y$b._   _,d$P'    ",
        "\033[31m Y$$.    \033[37m`.\033[31m`\"Y$$$$P\"'       ",
        "\033[31m `$$b      \033[37m\"-.__\033[31m            ",
        "\033[31m  `Y$$                      ",
        "\033[31m   `Y$$.                    ",
        "\033[31m     `$$b.                  ",
        "\033[31m       `Y$$b.               ",
        "\033[31m          `\"Y$b._           ", 
        "\033[31m              `\"\"\"          ",
        NULL
    },
    {   // Linux Mint
        "linuxmint",
        "\033[32m",
        "                                        ",
        "\033[37m             ...-:::::-...              ",
        "\033[37m          .-MMMMMMMMMMMMMMM-.           ",
        "\033[37m      .-MMMM\033[32m`..-:::::::-..`\033[37mMMMM-.       ",
        "\033[37m    .:MMMM\033[32m.:MMMMMMMMMMMMMMM:.\033[37mMMMM:.     ",
        "\033[37m   -MMM\033[32m-M---MMMMMMMMMMMMMMMMMMM.\033[37mMMM-    ",
        "\033[37m `:MMM\033[32m:MM`  :MMMM:....::-...-MMMM:\033[37mMMM:` ",
        "\033[37m :MMM\033[32m:MMM`  :MM:`  ``    ``  `:MMM:\033[37mMMM: ",
        "\033[37m.MMM\033[32m.MMMM`  :MM.  -MM.  .MM-  `MMMM.\033[37mMMM.",
        "\033[37m:MMM\033[32m:MMMM`  :MM.  -MM-  .MM:  `MMMM-\033[37mMMM:",
        "\033[37m:MMM\033[32m:MMMM`  :MM.  -MM-  .MM:  `MMMM:\033[37mMMM:",
        "\033[37m:MMM\033[32m:MMMM`  :MM.  -MM-  .MM:  `MMMM-\033[37mMMM:",
        "\033[37m.MMM\033[32m.MMMM`  :MM:--:MM:--:MM:  `MMMM.\033[37mMMM.",
        "\033[37m :MMM\033[32m:MMM-  `-MMMMMMMMMMMM-`  -MMM-\033[37mMMM: ",
        "\033[37m  :MMM\033[32m:MMM:`                `:MMM:\033[37mMMM:  ",
        "\033[37m   .MMM\033[32m.MMMM:--------------:MMMM.\033[37mMMM.   ",
        "\033[37m     '-MMMM\033[32m.-MMMMMMMMMMMMMMM-.\033[37mMMMM-'    ",
        "\033[37m       '.-MMMM\033[32m``--:::::--``\033[37mMMMM-.'      ",
        "\033[37m            '-MMMMMMMMMMMMM-'           ",
        "\033[37m               ``-:::::-``              ",
        NULL
    },
    {   // Endeavour OS
        "endeavouros",
        "\033[35m",
        "                                        ",
        "\033[31m                     ./\033[35mo\033[34m.               ",
        "\033[31m                   ./\033[35msssso\033[34m-             ",
        "\033[31m                 `:\033[35mosssssss+\033[34m-           ",
        "\033[31m               `:+\033[35msssssssssso\033[34m/.         ",
        "\033[31m             `-/o\033[35mssssssssssssso\033[34m/.       ",
        "\033[31m           `-/+\033[35msssssssssssssssso\033[34m+:`     ",
        "\033[31m         `-:/+\033[35msssssssssssssssssso«\033[34m+/.   ",
        "\033[31m       `.://\033[35mosssssssssssssssssssso\033[34m++-   ",
        "\033[31m      .://+\033[35mssssssssssssssssssssssso\033[34m++:  ",
        "\033[31m    .:///\033[35mossssssssssssssssssssssssso\033[34m++: ",
        "\033[31m  `:////\033[35mssssssssssssssssssssssssssso\033[34m+++.",
        "\033[31m`-////+\033[35mssssssssssssssssssssssssssso\033[34m++++-",
        "\033[31m `..-+\033[35moosssssssssssssssssssssssso\033[34m+++++/`",
        "\033[34m   ./++++++++++++++++++++++++++++++/:.  ",
        "\033[34m  `:::::::::::::::::::::::::------``    ",
        NULL
    },
    {   // Ubuntu
        "ubuntu",
        "\033[31m",
        "                                        ",
        "\033[31m            .-/+oossssoo+/-.            ",
        "\033[31m        `:+ssssssssssssssssss+:`        ",
        "\033[31m      -+ssssssssssssssssssyyssss+-      ",
        "\033[31m    .ossssssssssssssssss\033[37mdMMMNy\033[31msssso.    ",
        "\033[31m   /sssssssssss\033[37mhdmmNNmmyNMMMMh\033[31mssssss/   ",
        "\033[31m  +sssssssss\033[37mhm\033[31myd\033[37mMMMMMMMNddddy\033[31mssssssss+  ",
        "\033[31m /ssssssss\033[37mhNMMM\033[31myh\033[37mhyyyyhmNMMMNh\033[31mssssssss/ ",
        "\033[31m.ssssssss\033[37mdMMMNh\033[31mssssssssss\033[37mhNMMMd\033[31mssssssss.",
        "\033[31m+ssss\033[37mhhhyNMMNy\033[31mssssssssssss\033[37myNMMMy\033[31msssssss+",
        "\033[31moss\033[37myNMMMNyMMh\033[31mssssssssssssss\033[37mhmmmh\033[31mssssssso",
        "\033[31moss\033[37myNMMMNyMMh\033[31msssssssssssssshmmmhssssssso",
        "\033[31m+ssss\033[37mhhhyNMMNy\033[31mssssssssssss\033[37myNMMMy\033[31msssssss+",
        "\033[31m.ssssssss\033[37mdMMMNh\033[31mssssssssss\033[37mhNMMMd\033[31mssssssss.",
        "\033[31m /ssssssss\033[37mhNMMM\033[31myh\033[37mhyyyyhdNMMMNh\033[31mssssssss/ ",
        "\033[31m  +sssssssss\033[37mdm\033[31myd\033[37mMMMMMMMMddddy\033[31mssssssss+  ",
        "\033[31m   /sssssssssss\033[37mhdmNNNNmyNMMMMh\033[31mssssss/   ",
        "\033[31m    .ossssssssssssssssss\033[37mdMMMNy\033[31msssso.    ",
        "\033[31m      -+sssssssssssssssss\033[37myyy\033[31mssss+-      ",
        "\033[31m        `:+ssssssssssssssssss+:`        ",
        "\033[31m            .-/+oossssoo+/-.            ",
        NULL
    },
    {   // Parrot OS
        "parrot",
        "\033[36m",
        "                                       ",
        "\033[36m  `:oho/-`                             ",
        "\033[36m`mMMMMMMMMMMMNmmdhy-                   ",
        "\033[36m dMMMMMMMMMMMMMMMMMMs`                 ",
        "\033[36m +MMsohNMMMMMMMMMMMMMm/                ",
        "\033[36m .My   .+dMMMMMMMMMMMMMh.              ",
        "\033[36m  +       :NMMMMMMMMMMMMNo             ",
        "\033[36m           `yMMMMMMMMMMMMMm:           ",
        "\033[36m             /NMMMMMMMMMMMMMy`         ",
        "\033[36m              .hMMMMMMMMMMMMMN+        ",
        "\033[36m                  ``-NMMMMMMMMMd-      ",
        "\033[36m                     /MMMMMMMMMMMs`    ",
        "\033[36m                      mMMMMMMMsyNMN/   ",
        "\033[36m                      +MMMMMMMo  :sNh. ",
        "\033[36m                      `NMMMMMMm     -o/",
        "\033[36m                       oMMMMMMM.       ",
        "\033[36m                       `NMMMMMM+       ",
        "\033[36m                        +MMd/NMh       ",
        "\033[36m                         mMm -mN`      ",
        "\033[36m                         /MM  `h:      ",
        "\033[36m                          dM`   .      ",
        "\033[36m                          :M-          ",
        "\033[36m                           d:          ",
        "\033[36m                           -+          ",
        "\033[36m                            -          ",
        NULL
    },
    {   // Manjaro Linux
        "manjaro",
        "\033[32m",
        "                            ",
        "\033[32m██████████████████  ████████",
        "\033[32m██████████████████  ████████",
        "\033[32m██████████████████  ████████",
        "\033[32m██████████████████  ████████",
        "\033[32m████████            ████████",
        "\033[32m████████  ████████  ████████",
        "\033[32m████████  ████████  ████████",
        "\033[32m████████  ████████  ████████",
        "\033[32m████████  ████████  ████████",
        "\033[32m████████  ████████  ████████",
        "\033[32m████████  ████████  ████████",
        "\033[32m████████  ████████  ████████",
        "\033[32m████████  ████████  ████████",
        "\033[32m████████  ████████  ████████",
        NULL
    },
    {   // Fedora
        "fedora",
        "\033[34m",
        "                                  ",
        "\033[34m          /:-------------:\\       ",
        "\033[34m       :-------------------::     ",
        "\033[34m     :-----------\033[39m/shhOHbmp\033[34m---:\\   ",
        "\033[34m   /-----------\033[39momMMMNNNMMD\033[34m]  ---: ",
        "\033[34m  :-----------\033[39msMMMMNMNMP\033[34m.    ---: ",
        "\033[34m :-----------\033[39m:MMMdP\033[34m-------    ---\\",
        "\033[34m,------------\033[39m:MMMd\033[34m--------    ---:",
        "\033[34m:------------\033[39m:MMMd\033[34m-------    .---:",
        "\033[34m:----    \033[39moNMMMMMMMMMNho\033[34m     .----:",
        "\033[34m:--     .\033[39m+shhhMMMmhhy++\033[34m   .------/",
        "\033[34m:-    -------\033[39m:MMMd\033[34m--------------: ",
        "\033[34m:-   --------\033[39m/MMMd\033[34m-------------;  ",
        "\033[34m:-    ------\033[39m/hMMMy\033[34m------------:   ",
        "\033[34m:-- \033[39m:dMNdhhdNMMNo\033[34m------------;    ",
        "\033[34m:---\033[39m:sdNMMMMNds:\033[34m------------:     ",
        "\033[34m:------\033[39m:://:\033[34m-------------::       ",
        "\033[34m:---------------------://         ",
        NULL
    },
    {   // KDE Neon
        "neon",
        "\033[32m",
        "                                        ",
        "\033[32m             `..---+/---..`             ",
        "\033[32m         `---.``   ``   `.---.`         ",
        "\033[32m      .--.`        ``        `-:-.      ",
        "\033[32m    `:/:     `.----//----.`     :/-     ",
        "\033[32m   .:.    `---`          `--.`    .:`   ",
        "\033[32m  .:`   `--`                .:-    `:.  ",
        "\033[32m `/    `:.      `.-::-.`      -:`   `/` ",
        "\033[32m /.    /.     `:++++++++:`     .:    .: ",
        "\033[32m`/    .:     `+++++++++++/      /`   `+`",
        "\033[32m/+`   --     .++++++++++++`     :.   .+:",
        "\033[32m`/    .:     `+++++++++++/      /`   `+`",
        "\033[32m /`    /.     `:++++++++:`     .:    .: ",
        "\033[32m ./    `:.      `.:::-.`      -:`   `/` ",
        "\033[32m  .:`   `--`                .:-    `:.  ",
        "\033[32m   .:.    `---`          `--.`    .:`   ",
        "\033[32m    `:/:     `.----//----.`     :/-     ",
        "\033[32m      .-:.`        ``        `-:-.      ",
        "\033[32m         `---.``   ``   `.---.`         ",
        "\033[32m             `..---+/---..`             ",
        NULL
    },
    {   // Pop!_OS
        "pop",
        "\033[36m",
        "                                       ",
        "\033[36m             /////////////             ",
        "\033[36m         /////////////////////         ",
        "\033[36m      ///////\033[39m*767\033[36m////////////////      ",
        "\033[36m    //////\033[39m7676767676*\033[36m//////////////    ",
        "\033[36m   /////\033[39m76767\033[36m//\033[39m7676767\033[36m//////////////   ",
        "\033[36m  /////\033[39m767676\033[36m///\033[39m*76767\033[36m///////////////  ",
        "\033[36m ///////\033[39m767676\033[36m///\033[39m76767\033[36m].///\033[39m7676*\033[36m///////",
        "\033[36m/////////\033[39m767676\033[36m//\033[39m76767\033[36m///\033[39m767676\033[36m////////",
        "\033[36m//////////\033[39m76767676767\033[36m////\033[39m76767\033[36m/////////",
        "\033[36m///////////\033[39m76767676\033[36m//////\033[39m7676\033[36m//////////",
        "\033[36m////////////,\033[39m7676\033[36m,///////\033[39m767\033[36m///////////",
        "\033[36m/////////////*\033[39m7676\033[36m///////\033[39m76\033[36m////////////",
        "\033[36m///////////////\033[39m7676\033[36m////////////////////",
        "\033[36m ///////////////\033[39m7676\033[36m///\033[39m767\033[36m//////////// ",
        "\033[36m  //////////////////////\033[39m'\033[36m////////////  ",
        "\033[36m   //////\033[39m.7676767676767676767,\033[36m//////   ",
        "\033[36m    /////\033[39m767676767676767676767\033[36m/////    ",
        "\033[36m      ///////////////////////////      ",
        "\033[36m         /////////////////////         ",
        "\033[36m             /////////////             ",
        NULL
    },
    {   // Gentoo
        "gentoo",
        "\033[35m",
        "                                ",
        "\033[35m         -/oyddmdhs+:.             ",
        "\033[35m    -o\033[97mdNMMMMMMMMNNmhy+\033[35m-`           ",
        "\033[35m   -y\033[97mNMMMMMMMMMMMNNNmmdhy\033[35m+-        ",
        "\033[35m `o\033[97mmMMMMMMMMMMMMNmdmmmmddhhy\033[35m/`     ",
        "\033[35m om\033[97mMMMMMMMMMMMN\033[35mhhyyyo\033[97mhmdddhhhd\033[35mo`   ",
        "\033[35m.y\033[97mdMMMMMMMMMMd\033[35mhs++so/s\033[97mmdddhhhhdm\033[35m+` ",
        "\033[35m oy\033[97mhdmNMMMMMMMN\033[35mdyooy\033[97mdmddddhhhhyhN\033[35md.",
        "\033[35m  :o\033[97myhhdNNMMMMMMMNNNmmdddhhhhhyym\033[35mMh",
        "\033[35m    .:\033[97m+sydNMMMMMNNNmmmdddhhhhhhmM\033[35mmy",
        "\033[35m       /m\033[97mMMMMMMNNNmmmdddhhhhhmMNh\033[35ms:",
        "\033[35m    `o\033[97mNMMMMMMMNNNmmmddddhhdmMNhs\033[35m+` ",
        "\033[35m  `s\033[97mNMMMMMMMMNNNmmmdddddmNMmhs\033[35m/.   ",
        "\033[35m /N\033[97mMMMMMMMMNNNNmmmdddmNMNdso\033[35m:`     ",
        "\033[35m+M\033[97mMMMMMMNNNNNmmmmdmNMNdso\033[35m/-        ",
        "\033[35myM\033[97mMNNNNNNNmmmmmNNMmhs+/\033[35m-`          ",
        "\033[35m/h\033[97mMMNNNNNNNNMNdhs++/\033[35m-`             ",
        "\033[35m `/\033[97mohdmmddhys+++/:\033[35m.`               ",
        "\033[35m  `-//////:--.                     ",
        NULL
    },
    {   // Windows
        "windows",
        "\033[34m",
        "                                     ",
        "\033[31m        ,.=:!!t3Z3z.,                ",
        "\033[31m       :tt:::tt333EE3                ",
        "\033[31m       Et:::ztt33EEEL \033[32m@Ee.,      .., ",
        "\033[31m      ;tt:::tt333EE7 \033[32m;EEEEEEttttt33# ",
        "\033[31m     :Et:::zt333EEQ. \033[32m$EEEEEttttt33QL ",
        "\033[31m     it::::tt333EEF \033[32m@EEEEEEttttt33F  ",
        "\033[31m    ;3=*^```\"*4EEV \033[32m:EEEEEEttttt33@.  ",
        "\033[34m    ,.=::::!t=., \033[31m` \033[32m@EEEEEEtttz33QF   ",
        "\033[34m   ;::::::::zt33)   \033[32m\"4EEEtttji3P*    ",
        "\033[34m  :t::::::::tt33.\033[33m:Z3z..  \033[32m`` \033[33m,..g.    ",
        "\033[34m  i::::::::zt33F \033[33mAEEEtttt::::ztF     ",
        "\033[34m ;:::::::::t33V \033[33m;EEEttttt::::t3      ",
        "\033[34m E::::::::zt33L \033[33m@EEEtttt::::z3F      ",
        "\033[34m{3=*^```\"*4E3) \033[33m;EEEtttt:::::tZ`      ",
        "\033[34m             `\033[33m \033[33m:EEEEtttt::::z7       ",
        "\033[33m                 \"VEzjt:;;z>*`       ",
        NULL
    },
    {   // ElementaryOS
        "elementary",
        "\033[34m",
        "                                    ",
        "\033[0m         eeeeeeeeeeeeeeeee          ",
        "\033[37m      eeeeeeeeeeeeeeeeeeeeeee       ",
        "\033[37m    eeeee  eeeeeeeeeeee   eeeee     ",
        "\033[37m  eeee   eeeee       eee     eeee   ",
        "\033[37m eeee   eeee          eee     eeee  ",
        "\033[37meee    eee            eee       eee ",
        "\033[37meee   eee            eee        eee ",
        "\033[37mee    eee           eeee       eeee ",
        "\033[37mee    eee         eeeee      eeeeee ",
        "\033[37mee    eee       eeeee      eeeee ee ",
        "\033[37meee   eeee   eeeeee      eeeee  eee ",
        "\033[37meee    eeeeeeeeee     eeeeee    eee ",
        "\033[37m eeeeeeeeeeeeeeeeeeeeeeee    eeeee  ",
        "\033[37m  eeeeeeee eeeeeeeeeeee      eeee   ",
        "\033[37m    eeeee                 eeeee     ",
        "\033[37m      eeeeeee         eeeeeee       ",
        "\033[37m         eeeeeeeeeeeeeeeee          ",
        NULL
    },
    {   // Garuda Linux
        "garuda",
        "\033[35m",
        "\033[0m                                                    ",
        "\033[0m                 __,,,,,,,_                      ",
        "\033[0m           _╓╗╣╫╠╠╠╠╠╠╠╠╠╠╠╠╠╕╗╗┐_               ",
        "\033[0m        ╥╢╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╥,            ",
        "\033[0m      ╗╠╠╠╠╠╠╠╝╜╜╜╜╝╢╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠┐          ",
        "\033[0m     ╣╠╠╠╠╠╠╠╠╢╣╢╗╕ , `\"╘╠╠╠╠╠╠╠╠╠╠╠╠╠╠╔╥_       ",
        "\033[0m   ╒╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╕╙╥╥╜   `\"╜╠╬╠╠╠╠╠╠╠╠╠╠╠╥,    ",
        "\033[0m   ╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╗╥╥╥╥╗╗╬╠╠╠╠╠╠╠╝╙╠╠╣╠╠╠╠╢┐  ",
        "\033[0m  ╣╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╥╬╣╠╠╠╠╠╠╠╠╗ ",
        "\033[0m ╒╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╗",
        "\033[0m ╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠",
        "\033[0m ╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╬     ```\"╜╝╢╠╠╡",
        "\033[0m╒╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╣,         ╘╠╪ ",
        "\033[0m╞╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╢┐        ╜  ",
        "\033[0m`╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╗          ",
        "\033[0m,╬╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠\"╕         ",
        "\033[0m╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╗           ",
        "\033[0m╝^╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╝╣╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╠╡           ",
        "\033[0m ╔╜`╞┘╢╛╜ ╡╢╠\"╚╠╠╜╝┌╞╞\"╢╠╠╠╠╠╠╠╠╠╠╣╩╢╪           ",
        "\033[0m    ╜╒\"   `╜    `      ╜╙╕  └╣╠╠╠╠╕ ╞╙╖            ",
        "\033[0m                               ╠╠╠                   ",
        "\033[0m                                ╜                    ",
        NULL
    },
    {   // Alpine Linux
        "alpine",
        "\033[34m",
        "\033[34m                                        ",
        "\033[34m       .hddddddddddddddddddddddh.       ",
        "\033[34m      :dddddddddddddddddddddddddd:      ",
        "\033[34m     /dddddddddddddddddddddddddddd/     ",
        "\033[34m    +dddddddddddddddddddddddddddddd+    ",
        "\033[34m  `sdddddddddddddddddddddddddddddddds`  ",
        "\033[34m `ydddddddddddd++hdddddddddddddddddddy` ",
        "\033[34m `ydddddddddddd++hdddddddddddddddddddy` ",
        "\033[34mhdddddddddd+`      `+y:    .sddddddddddh",
        "\033[34mddddddddh+`   `//`   `.`     -sddddddddd",
        "\033[34mddddddh+`   `/hddh/`   `:s-    -sddddddd",
        "\033[34mddddh+`   `/+/dddddh/`   `+s-    -sddddd",
        "\033[34mddd+`   `/o` :dddddddh/`   `oy-    .yddd",
        "\033[34mhdddyo+ohddyosdddddddddho+oydddy++ohdddh",
        "\033[34m.hddddddddddddddddddddddddddddddddddddh.",
        "\033[34m `yddddddddddddddddddddddddddddddddddy` ",
        "\033[34m  `sdddddddddddddddddddddddddddddddds`  ",
        "\033[34m    +dddddddddddddddddddddddddddddd+    ",
        "\033[34m     /dddddddddddddddddddddddddddd/     ",
        "\033[34m      :dddddddddddddddddddddddddd:      ",
        "\033[34m       .hddddddddddddddddddddddh.       ",
        NULL
    }
};

#endif // LOGOS_H
