% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatXi.R
\name{matXi}
\alias{matXi}
\title{Estimation of Fisher information matrix I}
\usage{
matXi(data, p = 0, q = 0)
}
\arguments{
\item{data}{Matrix of dimension (p+q,n).}

\item{p}{Dimension of AR estimate coefficients.}

\item{q}{Dimension of MA estimate coefficients.}
}
\value{
Estimate Fisher information matrix \eqn{I = 
\sum_{h=-\infty}^{+\infty} cov(2e_t \nabla e_t, 2e_{t-h} \nabla e_{t-h})} where \eqn{\nabla e_t} 
denotes the gradient of the residuals.
}
\description{
Uses a consistent estimator of the matrix I based on an autoregressive spectral estimator.
}
\references{
Berk, Kenneth N. 1974, Consistent autoregressive spectral estimates,
 \emph{The Annals of Statistics}, vol. 2, pp. 489-502.

Boubacar Maïnassara, Y. and Francq, C. 2011, Estimating structural VARMA models with uncorrelated but 
non-independent error terms, \emph{Journal of Multivariate Analysis}, vol. 102, no. 3, pp. 496-505.

Boubacar Mainassara, Y. and Carbon, M. and Francq, C. 2012, Computing and estimating information matrices 
of weak ARMA models \emph{Computational Statistics & Data Analysis}, vol. 56, no. 2, pp. 345-361.
}
