% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{dec_to_bin}
\alias{dec_to_bin}
\title{Convert decimal number to its binary representation}
\usage{
dec_to_bin(decimal_num, bits = 32)
}
\arguments{
\item{decimal_num}{decimal number between 0 and (2^31) - 1}

\item{bits}{number of bits to keep in the result counting from the right.
\strong{Default value is 32}.}
}
\value{
a binary string representation of the given decimal number.
}
\description{
Get the binary representation of any decimal number from 0 to (2^31) - 1.
Doesn't work for larger numbers.
}
\examples{

# representing 0
dec_to_bin(0,1)
dec_to_bin(0,10)
dec_to_bin(0,32)
dec_to_bin(0)

# representing 24
dec_to_bin(24,6)
dec_to_bin(24,21)
dec_to_bin(24)
dec_to_bin(24,3) # note that this will cut the returned result so be careful!

}
