% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-module.R
\name{tsibble-wrap}
\alias{tsibble-wrap}
\alias{tsibbleWrapUI}
\alias{tsibbleWrapServer}
\title{A shiny module to easily slice and dice tsibble index for visualising periodicity}
\usage{
tsibbleWrapUI(id)

tsibbleWrapServer(id, plot, period)
}
\arguments{
\item{id}{A unique shiny id.}

\item{plot}{A \code{ggplot} or \code{plotly} object.}

\item{period}{A string passed to \code{\link[lubridate:period]{lubridate::period()}} to specify the minimum
seasonal period, for example \code{"1 day"}.}
}
\description{
A pair of UI and server functions: \code{tsibbleWrapUI()} and \code{tsibbleWrapServer()}.
}
\examples{
if (interactive()) {
  library(tsibble)
  library(dplyr)
  library(shiny)
  library(ggplot2)
  p <- tourism \%>\%
    filter(Region \%in\% c("Melbourne", "Sydney")) \%>\%
    ggplot(aes(x = Quarter, y = Trips, colour = Region)) +
    geom_line() +
    facet_wrap(~ Purpose, scales = "free_y") +
    theme(legend.position = "none")

  ui <- fluidPage(tsibbleWrapUI("dice"))
  server <- function(input, output, session) {
    tsibbleWrapServer("dice", p, period = "1 year")
  }
  shinyApp(ui, server)
}
}
