% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-spt.R
\name{find.hclust}
\alias{find.hclust}
\title{find the hierarchical cluster analysis among the nodes of graph
based on the length of all the shortest paths in the graph.}
\usage{
find.hclust(
  x,
  graph.mst = FALSE,
  weights = NULL,
  hclust.method = "average",
  ...
)
}
\arguments{
\item{x}{a igraph object}

\item{graph.mst}{logical whether obtain the minimum spanning tree first
then find.hclust, default is FALSE.}

\item{weights}{a numeric vector giving edge weights or a character.
If this is \code{NULL} and the graph has a \code{weight} edge attribute,
then the attribute is used. If this is \code{NA} then no weights
are used even if the graph has a \code{weight} attribute. If this is a
character, the graph has the edge attribute which is numeric, then it
will be used, default is \code{NULL}.}

\item{hclust.method}{the agglomeration method to be used, This should be (an
unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"},
\code{"single"}, \code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"}
(= WPGMA), \code{"median"} (= WPGMC) or \code{"centroid"} (= UPGMC).}

\item{...}{additional parameters}
}
\value{
hclust object
}
\description{
find the hierarchical cluster analysis among the nodes of graph
based on the length of all the shortest paths in the graph.
}
\examples{
library(igraph)
set.seed(123)
g <- igraph::sample_gnp(100, .1) \%>\%
     set_edge_attr(name='weight', value=abs(rnorm(E(.),3)))
tr1 <- find.hclust(g, weights = NA)
tr2 <- find.hclust(g)
tr3 <- find.hclust(g, graph.mst = TRUE)
}
