% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{copy_tinytex}
\alias{copy_tinytex}
\alias{use_tinytex}
\title{Copy TinyTeX to another location and use it in another system}
\usage{
copy_tinytex(
  from = tinytex_root(),
  to = select_dir("Select Destination Directory"),
  move = FALSE
)

use_tinytex(from = select_dir("Select TinyTeX Directory"))
}
\arguments{
\item{from}{The root directory of the TinyTeX installation. For
\code{copy_tinytex()}, the default value \code{tinytex_root()} should be a
reasonable guess if you installed TinyTeX via \code{install_tinytex()}. For
\code{use_tinytex()}, if \code{from} is not provided, a dialog for choosing
the directory interactively will pop up.}

\item{to}{The destination directory where you want to make a copy of TinyTeX.
Like \code{from} in \code{use_tinytex()}, a dialog will pop up if \code{to}
is not provided in \code{copy_tinytex()}.}

\item{move}{Whether to use the new copy and delete the original copy of
TinyTeX after copying it.}
}
\description{
The function \code{copy_tinytex()} copies the existing TinyTeX installation
to another directory (e.g., a portable device like a USB stick). The function
\code{use_tinytex()} runs \command{tlmgr path add} to add the copy of TinyTeX
in an existing folder to the \code{PATH} variable of the current system, so
that you can use utilities such as \command{tlmgr} and \command{pdflatex},
etc.
}
\note{
You can only copy TinyTeX and use it in the same system, e.g., the
  Windows version of TinyTeX only works on Windows.
}
