% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{data.vesta.fraud}
\alias{data.vesta.fraud}
\title{Load 'Vesta' Dataset}
\usage{
data.vesta.fraud(
  dirPath,
  training = TRUE,
  tranDumCols = NULL,
  idenDumCols = NULL,
  catMinSkip = 6
)
}
\arguments{
\item{dirPath}{A character string representing the path to the downloaded data directory.}

\item{training}{A logical value indicating whether to load training data or not. If \code{FALSE}, it loads test data.}

\item{tranDumCols}{A list with \code{name} and \code{values} of (categorical) columns in the 'transaction' file to be converted to dummy variables. If \code{training} is \code{FALSE} and this is \code{NULL}, a warning is raised.}

\item{idenDumCols}{Similar to \code{tranDumCols} but for the 'identity' file.}

\item{catMinSkip}{An integer value representing the minimum number of unique values for a categorical variable to be omitted if \code{tranDumCols} or \code{idenDumCols} is \code{NULL}.}
}
\value{
A list with the following items:
\item{data}{A \code{data.frame} with the data.}
\item{tranDumCols}{A list with \code{name} and \code{values} in 'transaction' data, used for creating dummy variables.}
\item{idenDumCols}{A list with \code{name} and \code{values} in 'identity' data, used for creating dummy variables.}
}
\description{
Use this function to create a fraud-series table from the 'Vesta' dataset (aka IEEE-CIS Fraud Detection).
}
