% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_f.R
\name{get.character.info}
\alias{get.character.info}
\title{Return Value and Class as String}
\usage{
get.character.info(frequency)
}
\arguments{
\item{frequency}{value of the frequency. It must be an \code{ldtf}
object returned from \code{f.?} functions.}
}
\value{
A list with the following items:
\itemize{
\item \strong{value:} String representation of the frequency. If you just want this, use \code{as.character()} function.
\item \strong{day:} Class Id of this frequency. If you just want this, use \code{\link{get.class.id}} function.
\item \strong{classType:} Type of the class.
}
}
\description{
Similar to \code{as.character()} method. However, it returns the class id too.
}
\examples{

freq <- f.x.times.a.day(f.daily(2023,5,16),13, 12)
freq_class_id <- get.character.info(freq) # this will be 'da13|d'.

#or,
freq1 <- f.monthly(2020,3)
freq1_class_id <- get.character.info(freq1)
}
\seealso{
\code{\link{get.class.id}}
}
