% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.weekly}
\alias{f.weekly}
\title{Creates a Weekly Frequency}
\usage{
f.weekly(year, month, day)
}
\arguments{
\item{year}{Year of the observation. It should be a valid year as an integer.}

\item{month}{Month of the observation. It should be a valid month of year as an integer.}

\item{day}{Day of the observation which will determine the start of the week. It should be a valid day of month as an integer.}
}
\value{
An object of class 'ldtf'. It is also a list with the following members:
\tabular{ll}{
\code{class} \tab Determines the class of this frequency.\cr
\code{year} \tab Determines the \code{year}.\cr
\code{month} \tab Determines the \code{month}.\cr
\code{day} \tab Determines the \code{day}.
}
}
\description{
Use it to create a frequency for time-series data that occurs weekly. We use first day of the week as the reference.
}
\details{
In order to use \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} First day of the week in \code{"YYYYMMDD"} format.
\item \strong{Class Id} \code{"w"}
}
}
\examples{

w0 <- f.weekly(2023, 1, 2) # This is 2/1/2023 which is Monday. Next observation belongs to 9/1/2023.

w0_value_str <-  as.character(w0) # this will be '20230102'.
w0_class_str <- get.class.id(w0) # this will be 'w'.

w_new <- as.frequency("20230109", "w") # This is 9/1/2023.

# Don't use invalid or unsupported dates:
\donttest{
w_invalid <- try(as.frequency("1399109", "w")) # this is a too old date and unsupported
w_invalid <- try(as.frequency("20230132", "w")) # invalid day in month
w_invalid <- try(as.frequency("20231331", "w")) # invalid month
}

}
