\name{SYSargs-class}
\Rdversion{1.1}
\docType{class}
\alias{SYSargs-class}
\alias{[,SYSargs,ANY,ANY,ANY-method}
\alias{coerce,list,SYSargs-method}
\alias{cores,SYSargs-method}
\alias{infile1,SYSargs-method}
\alias{infile2,SYSargs-method}
\alias{modules,SYSargs-method}
\alias{names,SYSargs-method}
\alias{length,SYSargs-method}
\alias{other,SYSargs-method}
\alias{results,SYSargs-method}
\alias{outfile1,SYSargs-method}
\alias{outpaths,SYSargs-method}
\alias{reference,SYSargs-method}
\alias{show,SYSargs-method}
\alias{software,SYSargs-method}
\alias{sysargs,SYSargs-method}
\alias{SampleName,SYSargs-method}
\alias{targetsheader,SYSargs-method}
\alias{targetsin,SYSargs-method}
\alias{targetsout,SYSargs-method}

\title{Class \code{"SYSargs"}}
\description{
S4 class container for storing parameters of command-line- or R-based software.
\code{SYSargs} instances are constructed by the \code{systemArgs} function
from two simple tabular files: a \code{targets} file and a \code{param} file.
The latter is optional for workflow steps lacking command-line software.
Typically, a \code{SYSargs} instance stores all sample-level inputs as well as
the paths to the corresponding outputs generated by command-line- or R-based
software generating sample-level output files. Each sample level input/outfile
operation uses its own \code{SYSargs} instance. The outpaths of \code{SYSargs}
usually define the sample inputs for the next \code{SYSargs} instance. This
connectivity is achieved by writing the outpaths with the
\code{writeTargetsout} function to a new targets file that serves as input to
the next \code{systemArgs} call. By chaining several \code{SYSargs} steps
together one can construct complex workflows involving many sample-level
input/output file operations with any combination of command-line or R-based
software.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("SYSargs", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{targetsin}:}{Object of class \code{"data.frame"} storing tabular data from targets input file }
    \item{\code{targetsout}:}{Object of class \code{"data.frame"} storing tabular data from targets output file }
    \item{\code{targetsheader}:}{Object of class \code{"character"} storing header/comment lines of targets file }
    \item{\code{modules}:}{Object of class \code{"character"} storing software versions from module system }
    \item{\code{software}:}{Object of class \code{"character"} name of executable of command-line software  }
    \item{\code{cores}:}{Object of class \code{"numeric"} number of CPU cores to use }
    \item{\code{other}:}{Object of class \code{"character"} additional arguments }
    \item{\code{reference}:}{Object of class \code{"character"} path to reference genome file }
    \item{\code{results}:}{Object of class \code{"character"} path to results directory }
    \item{\code{infile1}:}{Object of class \code{"character"} paths to first FASTQ file }
    \item{\code{infile2}:}{Object of class \code{"character"} paths to second FASTQ file if data is PE }
    \item{\code{outfile1}:}{Object of class \code{"character"} paths to output files generated by command-line software }
    \item{\code{sysargs}:}{Object of class \code{"character"} full commands used to execute external software}
    \item{\code{outpaths}:}{Object of class \code{"character"} paths to final outputs including postprocessing by \code{Rsamtools} }
  }
}
\section{Methods}{
  \describe{
    \item{SampleName}{\code{signature(x = "SYSargs")}: extracts sample names }
    \item{[}{\code{signature(x = "SYSargs")}: subsetting of class with bracket operator }
    \item{coerce}{\code{signature(from = "list", to = "SYSargs")}: \code{as(list, "SYSargs")} }
    \item{cores}{\code{signature(x = "SYSargs")}: extracts data from \code{cores} slot }
    \item{infile1}{\code{signature(x = "SYSargs")}: extracts data from \code{infile1} slot }
    \item{infile2}{\code{signature(x = "SYSargs")}: extracts data from \code{infile2} slot }
    \item{modules}{\code{signature(x = "SYSargs")}: extracts data from \code{modules} slot }
    \item{names}{\code{signature(x = "SYSargs")}: extracts slot names }
    \item{length}{\code{signature(x = "SYSargs")}: extracts number of samples }
    \item{other}{\code{signature(x = "SYSargs")}: extracts data from \code{other} slot}
    \item{outfile1}{\code{signature(x = "SYSargs")}: extracts data from \code{outfile1} slot }
    \item{outpaths}{\code{signature(x = "SYSargs")}: extracts data from \code{outpath} slot }
    \item{reference}{\code{signature(x = "SYSargs")}: extracts data from \code{reference} slot }
    \item{results}{\code{signature(x = "SYSargs")}: extracts data from \code{results} slot }
    \item{show}{\code{signature(object = "SYSargs")}: summary view of \code{SYSargs} objects }
    \item{software}{\code{signature(x = "SYSargs")}: extracts data from \code{software} slot }
    \item{targetsheader}{\code{signature(x = "SYSargs")}: extracts data from \code{targetsheader} slot }
    \item{targetsin}{\code{signature(x = "SYSargs")}: extracts data from \code{targetsin} slot }
    \item{targetsout}{\code{signature(x = "SYSargs")}: extracts data from \code{targetsout} slot }
	 }
}
\author{
Thomas Girke
}
\seealso{
\code{systemArgs} and \code{runCommandline}
}
\examples{
showClass("SYSargs")
## Construct SYSargs object from param and targets files 
param <- system.file("extdata", "tophat.param", package="systemPipeR")
targets <- system.file("extdata", "targets.txt", package="systemPipeR")
args <- systemArgs(sysma=param, mytargets=targets)
args
names(args); targetsin(args); targetsout(args); targetsheader(args); 
software(args); modules(args); cores(args); outpaths(args) 
sysargs(args); other(args); reference(args); results(args); infile1(args)
infile2(args); outfile1(args); SampleName(args)

## Return sample comparisons
readComp(args, format = "vector", delim = "-")

## The subsetting operator '[' allows to select specific samples
args[1:4]

\dontrun{
## Execute SYSargs on single machine
runCommandline(args=args)

## Execute SYSargs on multiple machines  
qsubargs <- getQsubargs(queue="batch", Nnodes="nodes=1", cores=cores(args), 
                        memory="mem=10gb", time="walltime=20:00:00")
qsubRun(appfct="runCommandline(args=args)", appargs=args, qsubargs=qsubargs, 
        Nqsubs=1, submitdir="results", package="systemPipeR")

## Write outpaths to new targets file for next SYSargs step
writeTargetsout(x=args, file="default")
}
}
\keyword{classes}
