% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.msel}
\alias{summary.msel}
\title{Summary for an Object of Class msel}
\usage{
\method{summary}{msel}(object, ..., vcov = NULL, show_ind = FALSE)
}
\arguments{
\item{object}{object of class 'msel'}

\item{...}{further arguments (currently ignored)}

\item{vcov}{positively defined numeric matrix representing
asymptotic variance-covariance matrix of the estimator to be
used for calculation of standard errors and p-values. It may also be a 
character. Then \code{\link[switchSelection]{vcov.msel}} function
will be used which input argument \code{type} will be set to \code{vcov}.
If \code{estimator = "2step"} then \code{vcov} should be an estimate of the 
asymptotic covariance matrix of the first step estimator.}

\item{show_ind}{logical; if \code{TRUE} then indexes of parameters will be
shown. Particularly, these indexes may be used in \code{ind} element of
\code{regularization} parameter of \code{\link[switchSelection]{msel}}.}
}
\value{
Returns an object of class 'summary.msel'.
}
\description{
Provides summary for an object of class 'msel'.
}
\details{
If \code{vcov} is \code{NULL} then this function just changes the 
class of the 'msel' object to 'summary.msel'. Otherwise it 
additionally changes \code{object$cov} to \code{vcov} and use it to
recalculate \code{object$se}, \code{object$p_value} and \code{object$tbl} 
values. It also adds the value of \code{ind} argument to the object.
}
