% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svSuiteData.R
\name{svSuiteData}
\alias{svSuiteData}
\alias{is.svSuiteData}
\alias{stats.svSuiteData}
\alias{metadata}
\alias{metadata.svSuiteData}
\alias{print.svSuiteData}
\alias{summary.svSuiteData}
\alias{protocol}
\alias{protocol.default}
\alias{protocol.svSuiteData}
\alias{protocol_text}
\alias{protocol_text.svSuiteData}
\alias{protocol_junit}
\alias{protocol_junit.svSuiteData}
\title{Objects of class 'svSuiteData' contain results from running test suites}
\usage{
is.svSuiteData(x)

\method{stats}{svSuiteData}(object, ...)

metadata(object, ...)

\method{metadata}{svSuiteData}(
  object,
  fields = c("R.version", "sessionInfo", "time", "description"),
  ...
)

\method{print}{svSuiteData}(x, all = FALSE, file = "", append = FALSE, ...)

\method{summary}{svSuiteData}(object, ...)

protocol(object, type = "text", file = "", append = FALSE, ...)

\method{protocol}{default}(object, type = "text", file = "", append = FALSE, ...)

\method{protocol}{svSuiteData}(object, type = "text", file = "", append = FALSE, ...)

protocol_text(object, file = "", append = FALSE, ...)

\method{protocol_text}{svSuiteData}(object, file = "", append = FALSE, ...)

protocol_junit(object, ...)

\method{protocol_junit}{svSuiteData}(object, file = "", append = FALSE, ...)
}
\arguments{
\item{x}{Any kind of object, or a 'svSuiteData' object in the case of
\code{\link[=print]{print()}}.}

\item{object}{A 'svSuiteData' object.}

\item{...}{Further arguments to pass to methods. Not used yet.}

\item{fields}{Character vector. The name of all metadata items you want to
extract for the object. The default value is an exhaustive list of all
available metadata (i.e., defined by default) in the object, but you can add
more: just add a corresponding attribute to your object.}

\item{all}{Do we print concise report for all test, or only for the tests
that fail or produce an error?}

\item{file}{Character. The path to the file where to write the report.
If \code{file = ""}, the protocol report is output to the console.}

\item{append}{Do we append to this file?}

\item{type}{Character. The type of protocol report to create. For the moment,
only \code{type = "text"} and \code{type = "junit"} are supported, but further types
(HTML, LaTeX, Wiki, etc.) could be provided later.}
}
\value{
\code{\link[=is.svSuiteData]{is.svSuiteData()}} returns \code{TRUE} if the object is an 'svSuiteData'. The
various methods serve to extract or print content in the object.
}
\description{
The 'svSuiteData' object contains results of all test run in one or more test
suites. The \code{checkxxx()} functions and the \code{\link[=runTest]{runTest()}} method generate data
(objects 'svTestData') contained in the default 'svSuiteData' named \code{.Log}
and located in \code{.GlobalEnv}. It is then possible to display and report
information it contains in various ways to analyze the results.
}
\details{
A 'svSuiteData' is, indeed, an environment. The results for the various tests
runs are in non hidden (i.e., names not starting with a dot) objects that are
of class 'svTestData' in this environment. Various other objects that control
the execution of the test, their context, etc. are contained as hidden objects
with name starting with a dot. Note that using an environment instead of a
list for this object allows for a call by reference instead of a usual call by
value in R, when passing this object to a function. This property is largely
exploited in all svUnit functions to make sure results of test runs are
centralized in the same log ('svSuiteData' object).
}
\examples{
clearLog()    # Clear any existing log

# Run some tests
checkTrue(1 < 2)
checkException(log("a"))
foo <- function(x, y = 2)
  return(x * y)
test(foo) <- function() {
  checkEqualsNumeric(4, foo(2))
  checkEqualsNumeric(6, foo(2, nonexisting))
  checkTrue(is.test(foo))
  warning("This is a warning")
  cat("Youhou from test!\n")  # Don't use, except for debugging!
  checkTrue(is.test(test(foo)))
  checkIdentical(attr(foo, "test"), test(foo))
  checkException(foo(2, nonexisting))
  #DEACTIVATED("My deactivation message")
  checkException(foo(2))  # This test fails
}
runTest(foo)

# Now inspect the log, which is a 'svSuiteData' object
is.svSuiteData(Log())
stats(Log())
metadata(Log())
Log()    # Print method
summary(Log())

\dontrun{
# To get a print of the test protocol on file, use:
protocol(Log(), type = "text", file = "RprofProtocol.out")
file.show("RprofProtocol.out")
unlink("RprofProtocol.out")
}

rm(foo)

\dontrun{
# Profiling of very simple test runs
library(utils)
createLog(description = "test profiling", deleteExisting = TRUE)
imax <- 3
jmax <- 100
l <- 50
Rprof()
for (i in 1:imax) {
  # Change the context for these tests
  .Log$..Test <- paste("Test", i, sep = "")
  .Log$..Tag <- paste("#", i, sep = "")
  res <- system.time({
    for (j in 1:jmax) checkTrue(i <= j, "My test")
  }, gcFirst = TRUE)[3]
  print(res)
  flush.console()
}
Rprof(NULL)
# Look at profile
summaryRprof()
unlink("Rprof.out")

# Look at the log
summary(Log())
}
}
\seealso{
\code{\link[=svSuite]{svSuite()}}, \code{\link[=is.svTestData]{is.svTestData()}}, \code{\link[=Log]{Log()}}, \code{\link[=checkEquals]{checkEquals()}}
}
\author{
Philippe Grosjean; Mario Frasca for the junit protocol.
}
\concept{unit testing}
\keyword{utilities}
