# [**stringx**](https://stringx.gagolewski.com/)

### Replacements for base [R](https://www.r-project.org/) string functions powered by *[stringi](https://stringi.gagolewski.com/)*

> English is the native language for only 5% of the World population.
> Also, only 17% of us can understand this text. Moreover, the Latin alphabet
> is the main one for merely 36% of the total. The early computer era,
> now a very long time ago, was dominated by the US. Due to the proliferation
> of the internet, smartphones, social media, and other technologies and media,
> this is no longer the case. This package replaces base R string functions
> with ones that fully support the Unicode standards related to natural
> language and date-time processing. Thanks to
> [ICU (International Components for Unicode)](https://icu.unicode.org/)
> and [*stringi*](https://stringi.gagolewski.com/),
> they are fast, reliable, and portable across different platforms.


[*stringx*](https://stringx.gagolewski.com/) replaces base
[R](https://www.r-project.org/) functions like
`paste`, `gregexpr`, `tolower`, and `strptime` with ones that:

* work in the same way on every platform,
* support a wide range of languages and scripts,
* fix some long-standing inconsistencies in base R
  (which are pointed out in the package
  [manual](https://stringx.gagolewski.com)).


[**stringx**](https://stringx.gagolewski.com/) is a set of wrappers around
[*stringi*](https://stringi.gagolewski.com/) — a mature
[R](https://www.r-project.org/) package for
fast, consistent, convenient, and portable string/text/natural language
processing in any locale that relies on
[ICU – International Components for Unicode](https://icu.unicode.org/).

To learn more about R, check out Marek's recent open-access (free!) textbook
[*Deep R Programming*](https://deepr.gagolewski.com/).


--------------------------------------------------------------------------------


**Package Maintainer and Author**:
[Marek Gagolewski](https://www.gagolewski.com/)

**Homepage**: https://stringx.gagolewski.com

**CRAN Entry**: https://cran.r-project.org/package=stringx

**License**:
*stringx* is distributed under the terms of the GNU General Public License,
either Version 2 or Version 3, see
[LICENSE](https://raw.githubusercontent.com/gagolews/stringx/master/LICENSE).

**Changelog**: see
[NEWS](https://raw.githubusercontent.com/gagolews/stringx/master/NEWS).
