% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql_helpers.R
\name{update_values}
\alias{update_values}
\title{Generate a UPDATE statement, optionally execute the statement if con is not NULL.}
\usage{
update_values(
  x,
  schema = NULL,
  table,
  where = NULL,
  returning = NULL,
  quote_text = TRUE,
  cast = TRUE,
  types = NULL,
  con = NULL,
  dialect = "T-SQL"
)
}
\arguments{
\item{x}{A list, data.frame or data.table, names must match the column names of the destination SQL table.}

\item{schema}{A string, the schema name of the destination SQL table.}

\item{table}{A string, the table name of the destination SQL table.}

\item{where}{A string, conditions to add to a WHERE statement.}

\item{returning}{A vector of character strings specifying the SQL column names to be returned by the UPDATE statement.}

\item{quote_text}{TRUE/FALSE, if TRUE, calls quoteText() to add single quotes around character strings.}

\item{cast}{TRUE/FALSE, if TRUE, will add SQL to cast the data to be inserted to the specified type.}

\item{types}{A vector of types to use for casting columns. If blank, will look at meta data about table to decide types.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}

\item{dialect}{A string, "T-SQL" or "Postgresql".}
}
\value{
A string, the UPDATE statement; or the results retrieved by DBI::dbGetQuery after executing the statement.
}
\description{
Generate a UPDATE statement, optionally execute the statement if con is not NULL.
}
\examples{
update_values(
x = list(col1 = c("a"), col2 = c(1)),
schema = "test",
table = "table1",
where = "1=1",
types = c("VARCHAR(12)", "INT")
)
}
