% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitfngr.R
\name{make_share}
\alias{make_share}
\title{Convert a function from multiple function arguments to a
single function}
\usage{
make_share(func, arg_fn, arg_gr)
}
\arguments{
\item{func}{The function that takes in two function arguments}

\item{arg_fn}{The function (first) argument name of func}

\item{arg_gr}{The gradient (second) argument name of func}
}
\value{
A new function that evaluates the two arguments together
}
\description{
Convert a function from multiple function arguments to a
single function
}
\examples{
quad_share <- function(x){list(sum(x^4), 4*x^3)}
lbfgs_share <- make_share(lbfgs::lbfgs, 'call_eval', 'call_grad')
make_share(lbfgs::lbfgs, 'call_eval', 'call_grad')(quad_share, vars=c(5,-4))
}
