% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impacts.R
\name{impacts.error_sphet}
\alias{impacts.error_sphet}
\title{Generate impacts for objects of class error_sphet created in sphet}
\usage{
\method{impacts}{error_sphet}(
  obj,
  ...,
  tr = NULL,
  R = NULL,
  listw = NULL,
  evalues = NULL,
  tol = 1e-06,
  empirical = FALSE,
  Q = NULL
)
}
\arguments{
\item{obj}{A spreg spatial regression object created by \code{spreg} with model ="lag"}

\item{...}{Arguments passed through to methods in the \pkg{coda} package}

\item{tr}{A vector of traces of powers of the spatial weights matrix created using \code{trW}, for approximate impact measures; if not given, \code{listw} must be given for exact measures (for small to moderate spatial weights matrices); the traces must be for the same spatial weights as were used in fitting the spatial regression}

\item{R}{If given, simulations are used to compute distributions for the impact measures, returned as \code{mcmc} objects}

\item{listw}{a listw object}

\item{evalues}{vector of eigenvalues of spatial weights matrix for impacts calculations}

\item{tol}{Argument passed to \code{mvrnorm}: tolerance (relative to largest variance) for numerical lack of positive-definiteness in the coefficient covariance matrix}

\item{empirical}{Argument passed to \code{mvrnorm} (default FALSE): if true, the coefficients and their covariance matrix specify the empirical not population mean and covariance matrix}

\item{Q}{default NULL, else an integer number of cumulative power series impacts to calculate if \code{tr} is given}
}
\value{
Estimate of the Average Total, Average Direct, and Average Indirect Effects
}
\description{
Generate impacts for objects of class error_sphet created in sphet
}
\examples{
library(sphet)
require("sf", quietly=TRUE)
columbus <- st_read(system.file("shapes/columbus.shp", package="spData")[1], quiet=TRUE)
col.gal.nb <- spdep::read.gal(system.file("weights/columbus.gal", package="spData")[1])
listw <- spdep::nb2listw(col.gal.nb)
error1 <- spreg(CRIME ~ INC + HOVAL, columbus, listw, Durbin=TRUE,
                model = "error")
summary(error1)
impacts(error1)
summary(impacts(error1))
error2 <- spreg(CRIME ~ INC + HOVAL, columbus, listw, Durbin= ~ INC,
                model = "error")
impacts(error2)
error3 <- spreg(CRIME ~ HOVAL, columbus, listw, Durbin= ~ INC,
                model = "error")
summary(impacts(error3))

}
