% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mongon.R
\name{ndvi.tif}
\alias{ndvi.tif}
\title{Normalized difference vegetation index for the Mongón study area.}
\format{
A geotiff file
}
\description{
NDVI raster geotiff (EPSG:32717) computed from a Landsat scene
  (path 9, row 67, acquisition date: 09/22/2000; USGS 2013) with 117 rows and
  117 columns: \describe{ \item{ndvi}{Normalized difference vegetation
  index.}. For more details, please refer to Muenchow et al. (2013).}.
  The data is used in the "Ecology" chapter in Geocomputation with R.
  See \url{https://geocompr.robinlovelace.net/eco.html} for details.
}
\examples{
system.file("raster/ndvi.tif", package = "spDataLarge")
}
\references{
Muenchow, J., Bräuning, A., Rodríguez, E.F. & von Wehrden, H.
(2013): Predictive mapping of species richness and plant species'
distributions of a Peruvian fog oasis along an altitudinal gradient.
Biotropica 45, 5, 557-566, doi: 10.1111/btp.12049.

USGS (2013): U.S. Geological Survey. Earth Explorer. Available at:
http://earthexplorer.usgs.gov/ (last accessed 1 March 2013).
}
