% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mongon.R
\name{comm}
\alias{comm}
\title{Community matrix of the Mt. Mongón}
\format{
A dataframe with 100 sites (rows) and 69 species (columns). Species
  presence is given in percentage points (between 0-100% per species and
  site). Due to overlapping cover between individual plants, the total cover
  per site can be >100\%.
}
\description{
A community matrix with species as columns and sites as rows.
  The rownames correspond to the id which can be also found in
  [random_points]. Please note that in fact 100 sites have been visited but
  in 16 of them no species could be found (see again [random_points]). The
  data is used in the "Ecology" chapter in Geocomputation with R. See
  \url{https://geocompr.robinlovelace.net/eco.html} for details.
}
\examples{
data("comm", package = "spDataLarge")
}
\references{
Muenchow, J., Bräuning, A., Rodríguez, E.F. & von Wehrden, H.
  (2013): Predictive mapping of species richness and plant species'
  distributions of a Peruvian fog oasis along an altitudinal gradient.
  Biotropica 45, 5, 557-566, doi: 10.1111/btp.12049.
}
