% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex_tree.R
\name{serialize}
\alias{serialize}
\title{Serializes the simplex tree.}
\usage{
serialize(st)
}
\arguments{
\item{st}{a simplex tree.}
}
\description{
Provides a compressed serialization interface for the simplex tree.
}
\details{
The serialize/deserialize commands can be used to compress/uncompress the complex into 
smaller form amenable for e.g. storing on disk (see \code{saveRDS}) or saving for later use. 
The serialization.
}
\examples{
st <- simplex_tree(list(1:5, 7:9))
st2 <- deserialize(serialize(st))
all.equal(as.list(preorder(st)), as.list(preorder(st2)))
# TRUE 

set.seed(1234)
R <- rips(dist(replicate(2, rnorm(100))), eps = pnorm(0.10), dim = 2)
print(R$n_simplices)
# 100 384 851

## Approx. size of the full complex 
print(utils::object.size(as.list(preorder(R))), units = "Kb")
# 106.4 Kb

## Approx. size of serialized version 
print(utils::object.size(serialize(R)), units = "Kb")
# 5.4 Kb
## You can save these to disk via e.g. saveRDS(serialize(R), ...)
}
\seealso{
Other serialization: 
\code{\link{deserialize}()}
}
\concept{serialization}
