% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{carousel}
\alias{carousel}
\alias{carouselItem}
\title{AdminLTE2 carousel container}
\usage{
carousel(..., id, indicators = TRUE, width = 6, .list = NULL)

carouselItem(..., caption = NULL, active = FALSE)
}
\arguments{
\item{...}{Element such as images, iframe, ...}

\item{id}{Carousel id. Must be unique.}

\item{indicators}{Whether to display left and right indicators.}

\item{width}{Carousel width. 6 by default.}

\item{.list}{Should you need to pass \link{carouselItem} via \link{lapply} or similar,
put these item here instead of passing them in ...}

\item{caption}{Item caption.}

\item{active}{Whether the item is active or not at start.}
}
\description{
\link{carousel} creates a carousel container to display media content.

\link{carouselItem} creates a carousel item to insert in a \link{carousel}.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      body = dashboardBody(
        carousel(
          id = "mycarousel",
          carouselItem(
            caption = "Item 1",
            tags$img(src = "https://placehold.it/900x500/3c8dbc/ffffff&text=I+Love+Bootstrap")
          ),
          carouselItem(
            caption = "Item 2",
            tags$img(src = "https://placehold.it/900x500/39CCCC/ffffff&text=I+Love+Bootstrap")
          )
        )
      ),
      title = "Carousel"
    ),
    server = function(input, output) { }
  )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
