% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxes.R, R/useful-items.R
\name{box}
\alias{box}
\alias{updateBox}
\alias{boxDropdown}
\alias{boxDropdownItem}
\alias{dropdownDivider}
\alias{boxPad}
\alias{descriptionBlock}
\title{Create a box for the main body of a dashboard}
\usage{
box(
  ...,
  title = NULL,
  footer = NULL,
  status = NULL,
  solidHeader = FALSE,
  background = NULL,
  width = 6,
  height = NULL,
  collapsible = FALSE,
  collapsed = FALSE,
  closable = FALSE,
  icon = NULL,
  gradient = FALSE,
  boxToolSize = "sm",
  headerBorder = TRUE,
  label = NULL,
  dropdownMenu = NULL,
  sidebar = NULL,
  id = NULL
)

updateBox(
  id,
  action = c("remove", "toggle", "restore", "update"),
  options = NULL,
  session = shiny::getDefaultReactiveDomain()
)

boxDropdown(..., icon = shiny::icon("wrench"))

boxDropdownItem(..., id = NULL, href = NULL, icon = NULL)

dropdownDivider()

boxPad(..., color = NULL, style = NULL)

descriptionBlock(
  number = NULL,
  numberColor = NULL,
  numberIcon = NULL,
  header = NULL,
  text = NULL,
  rightBorder = TRUE,
  marginBottom = FALSE
)
}
\arguments{
\item{...}{any element such as \link{descriptionBlock}.}

\item{title}{Optional title.}

\item{footer}{Optional footer text.}

\item{status}{The status of the item This determines the item's background
  color.  Valid statuses are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#3c8dbc")}
  \item \code{success}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#00a65a")}
  \item \code{info}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#00c0ef")}
  \item \code{warning}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#f39c12")}
  \item \code{danger}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#f56954")}
  \item \code{navy}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#001F3F")}
  \item \code{teal}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#39CCCC")}
  \item \code{purple}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#605ca8")}
  \item \code{orange}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#ff851b")}
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#D81B60")}
  \item \code{black}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#111111")}
}
Only primary, success, info, warning and danger are compatible with solidHeader!}

\item{solidHeader}{Should the header be shown with a solid color background?}

\item{background}{If NULL (the default), the background of the box will be
  white. Otherwise, a color string. Valid colors are listed in
  \link{validColors}. See below:
\itemize{
 \item \code{light-blue (primary status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#3c8dbc")}.
 \item \code{red (danger status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#dd4b39")}.
 \item \code{green (success status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#00a65a")}.
 \item \code{aqua (info status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#00c0ef")}.
 \item \code{yellow (warning status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#f39c12")}.
 \item \code{blue}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#0073b7")}.
 \item \code{navy}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#001F3F")}.
 \item \code{teal}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#39CCCC")}.
 \item \code{olive}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#3D9970")}.
 \item \code{lime}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#01FF70")}.
 \item \code{orange}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#FF851B")}.
 \item \code{fuchsia}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#F012BE")}.
 \item \code{purple}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#605ca8")}.
 \item \code{maroon}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#D81B60")}.
 \item \code{black}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#111")}.
 \item \code{gray}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#d2d6de")}.
}}

\item{width}{The width of the box, using the Bootstrap grid system. This is
used for row-based layouts. The overall width of a region is 12, so the
default valueBox width of 4 occupies 1/3 of that width. For column-based
layouts, use \code{NULL} for the width; the width is set by the column that
contains the box.}

\item{height}{The height of a box, in pixels or other CSS unit. By default
the height scales automatically with the content.}

\item{collapsible}{If TRUE, display a button in the upper right that allows
the user to collapse the box.}

\item{collapsed}{If TRUE, start collapsed. This must be used with
\code{collapsible=TRUE}.}

\item{closable}{If TRUE, display a button in the upper right that allows the user to close the box.}

\item{icon}{Optional icon. Expect \link[shiny]{icon}.}

\item{gradient}{Whether to allow gradient effect for the background color. Default to FALSE.}

\item{boxToolSize}{Size of the toolbox: choose among "xs", "sm", "md", "lg".}

\item{headerBorder}{Whether to display a border between the header and body.
TRUE by default.}

\item{label}{Slot for \link{boxLabel}.}

\item{dropdownMenu}{List of items in the boxtool dropdown menu. Use \link{boxDropdown}.}

\item{sidebar}{Slot for \link{boxSidebar}.}

\item{id}{If passed, the item will behave like an action button.}

\item{action}{Action to trigger: either collapse, remove, restore or update.}

\item{options}{If action is update, a list of new options to configure the box, such as
\code{list(title = "new title", status = NULL, solidHeader = FALSE, 
background = "red", width = 6, height = "200px", collapsible = FALSE, closable = FALSE)}.
If the box had a background/status (any item that may be NULL), you must explicitly pass background = NULL, 
if you want to remove the background value.}

\item{session}{Shiny session object.}

\item{href}{Target url or page.}

\item{color}{background color: see here for a list of valid colors \url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.
See below:
\itemize{
 \item \code{light-blue (primary status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#3c8dbc")}.
 \item \code{red (danger status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#dd4b39")}.
 \item \code{green (success status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#00a65a")}.
 \item \code{aqua (info status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#00c0ef")}.
 \item \code{yellow (warning status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#f39c12")}.
 \item \code{blue}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#0073b7")}.
 \item \code{navy}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#001F3F")}.
 \item \code{teal}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#39CCCC")}.
 \item \code{olive}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#3D9970")}.
 \item \code{lime}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#01FF70")}.
 \item \code{orange}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#FF851B")}.
 \item \code{fuchsia}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#F012BE")}.
 \item \code{purple}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#605ca8")}.
 \item \code{maroon}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#D81B60")}.
 \item \code{black}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#111")}.
 \item \code{gray}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#d2d6de")}.
}}

\item{style}{custom CSS, if any.}

\item{number}{any number.}

\item{numberColor}{number color: see here for a list of valid colors \url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.
See below:
\itemize{
 \item \code{light-blue (primary status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#3c8dbc")}.
 \item \code{red (danger status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#dd4b39")}.
 \item \code{green (success status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#00a65a")}.
 \item \code{aqua (info status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#00c0ef")}.
 \item \code{yellow (warning status)}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#f39c12")}.
 \item \code{blue}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#0073b7")}.
 \item \code{navy}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#001F3F")}.
 \item \code{teal}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#39CCCC")}.
 \item \code{olive}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#3D9970")}.
 \item \code{lime}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#01FF70")}.
 \item \code{orange}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#FF851B")}.
 \item \code{fuchsia}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#F012BE")}.
 \item \code{purple}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#605ca8")}.
 \item \code{maroon}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#D81B60")}.
 \item \code{black}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#111")}.
 \item \code{gray}: \Sexpr[results=rd, stage=install]{shinydashboardPlus:::rd_color_tag("#d2d6de")}.
}}

\item{numberIcon}{number icon, if any. Expect \code{\link[shiny]{icon}}.}

\item{header}{bold text.}

\item{text}{additional text.}

\item{rightBorder}{TRUE by default. Whether to display a right border to
separate two blocks. The last block on the right should not have a right border.}

\item{marginBottom}{FALSE by default. Set it to TRUE when the
descriptionBlock is used in a boxPad context.}
}
\description{
\link{box} can be used to hold content in the main body of a dashboard.

\link{updateBox} is used to toggle, close or restore a \link{box} on the client.

\link{boxDropdown} is used in the dropdown parameter of \link{box}.

\link{boxDropdownItem} goes in \link{boxDropdown}.

\link{dropdownDivider} goes in \link{boxDropdown} but also in any
dropdown menu container.

\link{boxPad} creates a vertical container for \link{descriptionBlock}.
It has to be included in a \link{box}.

\link{descriptionBlock} creates a description block, perfect for writing statistics
to insert in a \link{box}
}
\examples{

# A box with label, sidebar, dropdown menu
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)

 shinyApp(
   ui = dashboardPage(
     dashboardHeader(),
     dashboardSidebar(),
     dashboardBody(
      box(
        title = "Closable Box with dropdown", 
        closable = TRUE, 
        width = 12,
        status = "warning", 
        solidHeader = FALSE, 
        collapsible = TRUE,
        label = boxLabel(
         text = 1,
         status = "danger",
         style = "circle"
        ),
        dropdownMenu = boxDropdown(
         boxDropdownItem("Link to google", href = "https://www.google.com"),
         boxDropdownItem("item 2", href = "#"),
         dropdownDivider(),
         boxDropdownItem("item 3", href = "#", icon = icon("table-cells"))
        ),
        sidebar = boxSidebar(
         startOpen = TRUE,
         id = "mycardsidebar",
         sliderInput(
          "obs", 
          "Number of observations:",
          min = 0, 
          max = 1000, 
          value = 500
         )
        ),
        plotOutput("distPlot")
       )
     )
   ),
   server = function(input, output) {
    output$distPlot <- renderPlot({
     hist(rnorm(input$obs))
    })
   }
 )
}

# Toggle a box on the client
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 ui <- dashboardPage(
   dashboardHeader(),
   dashboardSidebar(),
   dashboardBody(
     tags$style("body { background-color: ghostwhite}"),
     fluidRow(
       actionButton("toggle_box", "Toggle Box"),
       actionButton("remove_box", "Remove Box", class = "bg-danger"),
       actionButton("restore_box", "Restore Box", class = "bg-success")
     ),
     actionButton("update_box", "Update Box", class = "bg-info"), 
     actionButton("update_box2", "Update Box 2", class = "bg-info"),
     br(),
     br(),
     box(
       title = textOutput("box_state"),
       id = "mybox",
       status = "danger", 
       background = "maroon", 
       gradient = TRUE,
       collapsible = TRUE,
       closable = TRUE,
       plotOutput("plot")
     )
   )
 )
 
 server <- function(input, output, session) {
   output$plot <- renderPlot({
     req(!input$mybox$collapsed)
     plot(rnorm(200))
   })
   
   output$box_state <- renderText({
     state <- if (input$mybox$collapsed) "collapsed" else "uncollapsed"
     paste("My box is", state)
   })
   
   observeEvent(input$toggle_box, {
     updateBox("mybox", action = "toggle")
   })
   
   observeEvent(input$remove_box, {
     updateBox("mybox", action = "remove")
   })
   
   observeEvent(input$restore_box, {
     updateBox("mybox", action = "restore")
   })
   
   observeEvent(input$mybox$visible, {
     collapsed <- if (input$mybox$collapsed) "collapsed" else "uncollapsed"
     visible <- if (input$mybox$visible) "visible" else "hidden"
     message <- paste("My box is", collapsed, "and", visible)
     showNotification(message, type = "warning", duration = 1)
   })
   
   observeEvent(input$update_box, {
     updateBox(
       "mybox", 
       action = "update", 
       options = list(
         title = h2("hello", dashboardLabel(1, status = "primary")),
         status = "warning", 
         solidHeader = TRUE, 
         width = 12, 
         background = NULL, 
         height = "900px", 
         closable = FALSE
       )
     )
   })
    
    observeEvent(input$update_box2, {
      updateBox(
        "mybox", 
        action = "update", 
        options = list(
          status = NULL, 
          solidHeader = FALSE,
          width = 4, 
          background = "green", 
          height = "500px", 
          closable = TRUE
        )
      )
    })
   
 }
 
 shinyApp(ui, server)
}

# Box with dropdown items and input
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
   ui = dashboardPage(
     dashboardHeader(),
     dashboardSidebar(),
     dashboardBody(
       box(
         title = "Closable Box with dropdown", 
         closable = TRUE, 
         width = 12,
         status = "warning", 
         solidHeader = FALSE, 
         collapsible = TRUE,
         dropdownMenu = boxDropdown(
           boxDropdownItem("Click me", id = "dropdownItem", icon = icon("heart")),
           boxDropdownItem("item 2", href = "https://www.google.com/"),
           dropdownDivider(),
           boxDropdownItem("item 3", icon = icon("table-cells"))
         ),
         "My box"
       )
     )
   ),
   server = function(input, output) {
     observeEvent(input$dropdownItem, {
       showNotification("Hello", duration = 1, type = "message")
     })
   }
 )
}

# Box with boxPad container + descriptionBlock
if (interactive()) {
  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)

  shinyApp(
    ui = dashboardPage(
      dashboardHeader(),
      dashboardSidebar(),
      dashboardBody(
        box(
          title = "Box with right pad",
          status = "warning",
          fluidRow(
            column(width = 6),
            column(
              width = 6,
              boxPad(
                color = "green",
                descriptionBlock(
                  header = "8390",
                  text = "VISITS",
                  rightBorder = FALSE,
                  marginBottom = TRUE
                ),
                descriptionBlock(
                  header = "30\%",
                  text = "REFERRALS",
                  rightBorder = FALSE,
                  marginBottom = TRUE
                ),
                descriptionBlock(
                  header = "70\%",
                  text = "ORGANIC",
                  rightBorder = FALSE,
                  marginBottom = FALSE
                )
              )
            )
          )
        )
      ),
      title = "boxPad"
    ),
    server = function(input, output) { }
  )
}


# Box with descriptionBlock
if (interactive()) {
  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)

  shinyApp(
    ui = dashboardPage(
      dashboardHeader(),
      dashboardSidebar(),
      dashboardBody(
        box(
          solidHeader = FALSE,
          title = "Status summary",
          background = NULL,
          width = 4,
          status = "danger",
          footer = fluidRow(
            column(
              width = 6,
              descriptionBlock(
                number = "17\%",
                numberColor = "green",
                numberIcon = icon("caret-up"),
                header = "$35,210.43",
                text = "TOTAL REVENUE",
                rightBorder = TRUE,
                marginBottom = FALSE
              )
            ),
            column(
              width = 6,
              descriptionBlock(
                number = "18\%",
                numberColor = "red",
                numberIcon = icon("caret-down"),
                header = "1200",
                text = "GOAL COMPLETION",
                rightBorder = FALSE,
                marginBottom = FALSE
              )
            )
          )
        )
      ),
      title = "Description Blocks"
    ),
    server = function(input, output) { }
  )
}

}
