% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_score.R
\name{ConsensusScore}
\alias{ConsensusScore}
\title{Consensus score}
\usage{
ConsensusScore(prop, K, theta)
}
\arguments{
\item{prop}{consensus matrix.}

\item{K}{matrix of co-sampling counts.}

\item{theta}{consensus co-membership matrix.}
}
\value{
A consensus score.
}
\description{
Computes the consensus score from the consensus matrix, matrix of co-sampling
counts and consensus clusters. The score is a z statistic for the comparison
of the co-membership proportions observed within and between the consensus
clusters.
}
\details{
To calculate the consensus score, the features are classified as being stably
selected or not (in selection) or as being in the same consensus cluster or
not (in clustering). In selection, the quantities \eqn{X_w} and \eqn{X_b} are
defined as the sum of the selection counts for features that are stably
selected or not, respectively. In clustering, the quantities \eqn{X_w} and
\eqn{X_b} are defined as the sum of the co-membership counts for pairs of
items in the same consensus cluster or in different consensus clusters,
respectively.

Conditionally on this classification, and under the assumption that the
selection (or co-membership) probabilities are the same for all features (or
item pairs) in each of these two categories, the quantities \eqn{X_w} and
\eqn{X_b} follow binomial distributions with probabilities \eqn{p_w} and
\eqn{p_b}, respectively.

In the most unstable situation, we suppose that all features (or item pairs)
would have the same probability of being selected (or co-members). The
consensus score is the z statistic from a z test where the null hypothesis is
\eqn{p_w \leq p_b}.

The consensus score increases with stability.
}
\examples{
\donttest{
# Data simulation
set.seed(2)
simul <- SimulateClustering(
  n = c(30, 30, 30),
  nu_xc = 1
)
plot(simul)

# Consensus clustering
stab <- Clustering(
  xdata = simul$data
)
stab$Sc[3]

# Calculating the consensus score
theta <- CoMembership(Clusters(stab, argmax_id = 3))
ConsensusScore(
  prop = (stab$coprop[, , 3])[upper.tri(stab$coprop[, , 3])],
  K = stab$sampled_pairs[upper.tri(stab$sampled_pairs)],
  theta = theta[upper.tri(theta)]
)
}
}
\seealso{
Other stability metric functions: 
\code{\link{FDP}()},
\code{\link{PFER}()},
\code{\link{StabilityMetrics}()},
\code{\link{StabilityScore}()}
}
\concept{stability metric functions}
