% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sftime}
\alias{plot.sftime}
\alias{plot}
\title{Plots an  \code{sftime} object}
\usage{
\method{plot}{sftime}(x, y, ..., number = 6, tcuts)
}
\arguments{
\item{x}{The \code{\link[=st_sftime]{sftime}} object to be plotted.}

\item{y}{A character value; The variable name to be plotted; if missing, the 
first variable is plotted.}

\item{...}{Additional arguments; Passed on to \code{\link[sf:plot]{plot.sf}}.}

\item{number}{A numeric value; The number of panels to be plotted, cannot be 
larger than the number of timestamps; ignored when \code{tcuts} is provided.}

\item{tcuts}{predefined temporal ranges assigned to each map; if missing, 
will be determined as equal spans according to \code{number}.}
}
\value{
Returns \code{NULL} and creates as side effect a plot for \code{x}.
}
\description{
\code{plot.sftime}
}
\examples{
set.seed(123)
coords <- matrix(runif(100), ncol = 2)
g <- st_sfc(lapply(1:50, function(i) st_point(coords[i, ]) ))
sft <- st_sftime(a = 1:50, g, time = as.POSIXct("2020-09-01 00:00:00") + 0:49 * 3600 * 6)

plot(sft)

}
