% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdEff-fun.R
\name{getFamily}
\alias{getFamily}
\title{Get Model Error Distribution Family}
\usage{
getFamily(mod)
}
\arguments{
\item{mod}{A fitted model object, or a list or nested list of such objects.}
}
\value{
A model \code{"family"} object, or a list or nested list of such objects.
}
\description{
Extract the error distribution family (and link function) from a
fitted model.
}
\details{
\code{getFamily()} returns an appropriate family object for a range of
different model classes, similarly to \code{\link[=family]{family()}}. However, it can be also
be used for some classes without an existing family method. Mostly for
internal use.
}
\examples{
# SEM model error distributions
getFamily(shipley.sem)
}
\seealso{
\code{\link[=family]{family()}}
}
