% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gillespie.R
\name{gmRNA}
\alias{gmRNA}
\alias{gmRNA_basic}
\alias{gmRNA_switch}
\alias{gmRNA_burst}
\alias{gmRNA_basic_burst}
\alias{gmRNA_IGbasic_burst}
\title{Gillespie algorithm for mRNA generating processes}
\usage{
gmRNA_basic(n, r.on, r.degr)

gmRNA_switch(n, r.act, r.deact, r.on, r.degr)

gmRNA_burst(n, r.burst, s.burst, r.degr)

gmRNA_basic_burst(n, r.on, r.burst, s.burst, r.degr)

gmRNA_IGbasic_burst(n, r.mu, r.burst, r.degr)
}
\arguments{
\item{n}{Number of observations}

\item{r.on}{Transcription rate during gene activation (Switching model)}

\item{r.degr}{mRNA degradation rate (all models)}

\item{r.act}{DNA activation rate (Switching Model)}

\item{r.deact}{DNA deactivation rate (Switching Model)}

\item{r.burst}{Bursty transcription rate (Bursting model, Basic Burst model and IG Basic Burst model)}

\item{s.burst}{Mean burst size (Bursting Model and  Basic Burst model)}

\item{r.mu}{Mean parameter for the inverse Gaussian distribution (IG Basic Burst model)}
}
\description{
Gillespie algorithms allow synthetic data simulation via three different
underlying mRNA generating processes: the basic process consists of a
simple death-birth model of mRNA transcription and degradation; the
switching process considers additionally gene activation and deactivation,
with mRNA transcription only happening in active gene states; the
bursting process, transcribes mRNA in bursts with geometrically distributed burst sizes.
The basic_burst model combines both the basic and the burst model.
The IGbasic burst model describes the basic model with non-constant transcription rates, but
transcription rates follow an inverse Gaussian distribution governed by one parameter, the mean parameter
of the inverse Gaussian distribution. Additionally a burst transcription occures (with NB distributed
burst sizes), the whole burst (rate and burst sizes) are determined by the rate parameter.
}
\examples{
x <- gmRNA_basic(100, 0.75, 0.001)
plot(density(x))
x <- gmRNA_switch(100, 0.23, 0.15, 0.75, 0.001)
plot(density(x))
x <- gmRNA_burst(10, 0.15, 0.75, 0.001)
plot(density(x))
x <- gmRNA_basic_burst(10, 0.75, 0.15, 0.5, 0.001)
plot(density(x))
x <- gmRNA_IGbasic_burst(10, 2, 0.5, 0.1)
plot(density(x))
}
