% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_export.R
\name{tt_to_flextable}
\alias{tt_to_flextable}
\title{Create a FlexTable object representing an rtables TableTree}
\usage{
tt_to_flextable(
  tt,
  paginate = FALSE,
  lpp = NULL,
  cpp = NULL,
  ...,
  colwidths = propose_column_widths(matrix_form(tt, indent_rownames = TRUE)),
  tf_wrap = !is.null(cpp),
  max_width = cpp,
  total_width = 10
)
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a
populated table.}

\item{paginate}{logical(1). Should \code{tt} be paginated and exported as
multiple flextables. Defaults to \code{FALSE}}

\item{lpp}{numeric. Maximum lines per page including (re)printed header and context rows}

\item{cpp}{numeric(1) or NULL. Width (in characters) of the pages for
horizontal pagination. \code{NULL} (the default) indicates no horizontal
pagination should be done.}

\item{...}{Passed on to methods or tabulation functions.}

\item{colwidths}{numeric vector. Column widths for use with vertical pagination.}

\item{tf_wrap}{logical(1). Should  the texts for  title, subtitle,
and footnotes be wrapped?}

\item{max_width}{integer(1), character(1) or NULL. Width that title
and   footer   (including   footnotes)  materials   should   be
word-wrapped to. If NULL, it is  set to the current print width
of the  session (`getOption("width")`). If set to `"auto"`,
the width of the table (plus any table inset) is used. Ignored
completely if `tf_wrap` is `FALSE`.}

\item{total_width}{numeric(1). Total width in inches for the resulting
flextable(s). Defaults to 5.}
}
\value{
a flextable object
}
\description{
Create a FlexTable object representing an rtables TableTree
}
\examples{
analysisfun <- function(x, ...) {
    in_rows(row1 = 5,
            row2 = c(1, 2),
            .row_footnotes = list(row1 = "row 1 - row footnote"),
            .cell_footnotes = list(row2 = "row 2 - cell footnote"))
}

lyt <- basic_table(title = "Title says Whaaaat", subtitles = "Oh, ok.",
               main_footer = "ha HA! Footer!") \%>\%
split_cols_by("ARM") \%>\%
analyze("AGE", afun = analysisfun)

tbl <-  build_table(lyt, ex_adsl)
ft <- tt_to_flextable(tbl)
ft
}
