% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{rtable}
\alias{rtable}
\alias{rtablel}
\title{Create a Table}
\usage{
rtable(header, ..., format = NULL, hsep = default_hsep(), inset = 0L)

rtablel(header, ..., format = NULL, hsep = default_hsep(), inset = 0L)
}
\arguments{
\item{header}{Information defining the header (column strucure) of the table.
This can be as row objects (legacy), character vectors or a
\code{InstantiatedColumnInfo} object.}

\item{\dots}{Rows to place in the table.}

\item{format}{if \code{FUN} does not return a formatted \code{\link{rcell}}
then the \code{format} is applied}

\item{hsep}{character(1). Set of character(s) to be repeated as the separator
between the header and body of the table when rendered as text. Defaults to
a connected horrizontal line (unicode 2014) in locals that use a UTF
charset, and to \code{-} elsewhere (with a once per session warning).}

\item{inset}{integer(1). The table inset for the row or table being
constructed. See \code{\link[formatters]{table_inset}}.}
}
\value{
a formal table object of the appropriate type (\code{ElementaryTable}
or \code{TableTree})
}
\description{
Create a Table
}
\examples{

rtable(
  header = LETTERS[1:3],
  rrow("one to three", 1, 2, 3),
  rrow("more stuff", rcell(pi, format = "xx.xx"), "test", "and more")
)


# Table with multirow header
sel <- iris$Species == "setosa"
mtbl <- rtable(
  header = rheader(
    rrow(row.name = NULL, rcell("Sepal.Length", colspan = 2),
         rcell("Petal.Length", colspan=2)),
    rrow(NULL, "mean", "median", "mean", "median")
  ),
  rrow(
    row.name = "All Species",
    mean(iris$Sepal.Length), median(iris$Sepal.Length),
    mean(iris$Petal.Length), median(iris$Petal.Length),
    format = "xx.xx"
  ),
  rrow(
    row.name = "Setosa",
    mean(iris$Sepal.Length[sel]), median(iris$Sepal.Length[sel]),
    mean(iris$Petal.Length[sel]), median(iris$Petal.Length[sel])
  )
)

mtbl

names(mtbl) # always first row of header

# Single row header

tbl <- rtable(
  header = c("Treatement\nN=100", "Comparison\nN=300"),
  format = "xx (xx.xx\%)",
  rrow("A", c(104, .2), c(100, .4)),
  rrow("B", c(23, .4), c(43, .5)),
  rrow(""),
  rrow("this is a very long section header"),
  rrow("estimate", rcell(55.23, "xx.xx", colspan = 2)),
  rrow("95\% CI", indent = 1, rcell(c(44.8, 67.4), format = "(xx.x, xx.x)", colspan = 2))
)
tbl

row.names(tbl)
names(tbl)


# Subsetting
tbl[1, ]
tbl[, 1]

tbl[1,2]
tbl[2, 1]

tbl[3,2]
tbl[5,1]
tbl[5,2]

# # Data Structure methods
dim(tbl)
nrow(tbl)
ncol(tbl)
names(tbl)


# Colspans

tbl2 <- rtable(
  c("A", "B", "C", "D", "E"),
  format = "xx",
  rrow("r1", 1, 2, 3, 4, 5),

  rrow("r2", rcell("sp2", colspan = 2), "sp1", rcell("sp2-2", colspan = 2))
)

tbl2

}
\seealso{
Other compatability: 
\code{\link{rheader}()},
\code{\link{rrowl}()},
\code{\link{rrow}()}
}
\concept{compatability}
