% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_conventions.R
\name{constr_args}
\alias{constr_args}
\title{Constructor Arg Conventions}
\usage{
constr_args(
  kids,
  cont,
  lev,
  iscontent,
  cinfo,
  labelrow,
  vals,
  cspan,
  label_pos,
  cindent_mod,
  cvar,
  label,
  cextra_args,
  child_names,
  title,
  subtitles,
  main_footer,
  prov_footer,
  footnotes,
  page_title,
  page_prefix,
  section_div,
  trailing_sep,
  split_na_str,
  cna_str,
  inset,
  table_inset
)
}
\arguments{
\item{kids}{list. List of direct children.}

\item{cont}{ElementaryTable. Content table.}

\item{lev}{integer. Nesting level (roughly, indentation level in practical
terms).}

\item{iscontent}{logical. Is the TableTree/ElementaryTable being constructed
the content table for another TableTree.}

\item{cinfo}{InstantiatedColumnInfo (or NULL). Column structure for the
object being created.}

\item{labelrow}{LabelRow. The LabelRow object to assign to this Table.
Consructed from \code{label} by default if not specified.}

\item{vals}{list. cell values for the row}

\item{cspan}{integer. Column span. \code{1} indicates no spanning.}

\item{label_pos}{character(1). Location the variable label should be
displayed, Accepts  hidden (default for non-analyze row splits), visible,
topleft, and - for analyze splits only - default.  For analyze calls,
\code{default} indicates that the variable should be visible if and only if
multiple variables are analyzed at the same level of nesting.}

\item{cindent_mod}{numeric(1). The indent modifier for the content tables
generated by this split.}

\item{cvar}{character(1). The variable, if any, which the content function
should accept. Defaults to NA.}

\item{label}{character(1). A label (not to be confused with the name) for the
object/structure.}

\item{cextra_args}{list. Extra arguments to be passed to the content function
when tabulating row group summaries.}

\item{child_names}{character. Names to be given to the sub splits contained
by a compound split (typically a AnalyzeMultiVars split object).}

\item{title}{character(1). Main title. Ignored for subtables.}

\item{subtitles}{character. Subtitles. Ignored for subtables.}

\item{main_footer}{character. Main global (non-referential) footer materials.}

\item{prov_footer}{character. Provenance-related global footer materials.
Generally should not be modified by hand.}

\item{footnotes}{list or NULL. Referential footnotes to be applied at current
level}

\item{page_title}{character. Page specific title(s).}

\item{page_prefix}{character(1). Prefix, to be appended with the split value,
when forcing pagination between the children of this split/table}

\item{section_div}{character(1). String which should be repeated as a section
divider after each group defined by this split instruciton, or
\code{NA_character_} (the default) for no section divider.}

\item{trailing_sep}{character(1). String which will be used as a section
divider after the printing of the last row contained in this (sub)-table,
unless that row is also the last table row to be printed overall, or
\code{NA_character_} for none (the default). When generated via layouting, this
would correspond to the \code{section_div} of the split under which this table
represents a single facet.}

\item{split_na_str}{character. NA string vector for use with \code{split_format}.}

\item{cna_str}{character. NA string for use with \code{cformat} for content
table.}

\item{inset}{numeric(1). Number of spaces to inset the table header, table
body, referential footnotes, and main_footer, as compared to alignment
of title, subtitle, and provenance footer. Defaults to 0 (no inset).}

\item{table_inset}{numeric(1). Number of spaces to inset the table header, table
body, referential footnotes, and main_footer, as compared to alignment
of title, subtitle, and provenance footer. Defaults to 0 (no inset).}
}
\value{
NULL (this is an argument template dummy function)
}
\description{
Constructor Arg Conventions
}
\seealso{
Other conventions: 
\code{\link{compat_args}()},
\code{\link{gen_args}()},
\code{\link{lyt_args}()},
\code{\link{sf_args}()}
}
\concept{conventions}
