% Generated by roxygen2 (4.0.2): do not edit by hand
\name{peek_front.rdeque}
\alias{peek_front.rdeque}
\title{Return the data element at the front of an rdeque}
\usage{
\method{peek_front}{rdeque}(x, ...)
}
\arguments{
\item{x}{rdeque to peek at.}

\item{...}{additional arguments to be passed to or from methods (ignored).}
}
\value{
data element existing at the front of the rdeque.
}
\description{
Simply returns the data element sitting at the front of the rdeque,
leaving the rdeque alone.
}
\details{
Runs in \code{O(1)} worst-case time.
}
\examples{
d <- rdeque()
d <- insert_front(d, "a")
d <- insert_front(d, "b")
e <- peek_front(d)
print(e)
print(d)

## Assigning to the front data element with peek_front:
d <- rdeque()
d <- insert_front(d, data.frame(a = 1, b = 1))
d <- insert_front(d, data.frame(a = 1, b = 1))

peek_front(d)$a <- 100
print(d)

peek_front(d) <- data.frame(a = 100, b = 100)
print(d)
}
\seealso{
\code{\link{without_front}} for removing the front element.
}

